#!/bin/sh -e
set -o errexit

###
# Copyright (c) 2015-2020, Antoine "vv221/vv222" Le Gonidec
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Valhalla Hills
# build native Linux packages from the original installers
# send your bug reports to vv221@dotslashplay.it
###

script_version=20200918.1

# Set game-specific variables

GAME_ID='valhalla-hills'
GAME_NAME='Valhalla Hills'

ARCHIVE_GOG='gog_valhalla_hills_2.3.0.5.sh'
ARCHIVE_GOG_URL='https://www.gog.com/game/valhalla_hills'
ARCHIVE_GOG_MD5='59286a003e654ae9f571abccc0375053'
ARCHIVE_GOG_SIZE='1300000'
ARCHIVE_GOG_VERSION='1.05.17-gog2.3.0.5'

ARCHIVE_DOC1_DATA_PATH='data/noarch/docs'
ARCHIVE_DOC1_DATA_FILES='./*'

ARCHIVE_GAME1_BIN_PATH='data/noarch/game/'
ARCHIVE_GAME1_BIN_FILES='./ValhallaHills/Binaries'

ARCHIVE_GAME2_BIN_PATH='data/noarch/game/'
ARCHIVE_GAME2_BIN_FILES='./Engine'

ARCHIVE_GAME_DATA_PATH='data/noarch/game/'
ARCHIVE_GAME_DATA_FILES='./ValhallaHills/Content ./ValhallaHills/Saved'

CONFIG_DIRS='./Saved'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='ValhallaHills/Binaries/Linux/ValhallaHills-Linux-Shipping'
APP_MAIN_ICON='data/noarch/support/icon.png'
APP_MAIN_ICON_RES='256'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID glibc libstdc++ openal"

# Load common functions

target_version='2.7'

if [ -z "$PLAYIT_LIB2" ]; then
	: "${XDG_DATA_HOME:="$HOME/.local/share"}"
	for path in\
		"$PWD"\
		"$XDG_DATA_HOME/play.it"\
		'/usr/local/share/games/play.it'\
		'/usr/local/share/play.it'\
		'/usr/share/games/play.it'\
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
#shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Extract game icon

PKG='PKG_DATA'
get_icon_from_temp_dir 'APP_MAIN'

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
write_launcher 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
