#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2020-2021, HS-157
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Volgarr the Viking
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210612.3

# Set game-specific variables

GAME_ID='volgarr-the-viking'
GAME_NAME='Volgarr the Viking'

ARCHIVE_BASE_GOG_0='gog_volgarr_the_viking_2.1.0.3.sh'
ARCHIVE_BASE_GOG_0_MD5='8593287f13c3104aa45b9c91264b4260'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_VERSION='1.36c-gog2.1.0.3'
ARCHIVE_BASE_GOG_0_SIZE='200000'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/volgarr_the_viking'

ARCHIVE_BASE_HUMBLE_0='VolgarrTheViking_v1.36c_Linux32.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='c3652629edb019838d8e1c7873f0716b'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.36c-humble'
ARCHIVE_BASE_HUMBLE_0_SIZE='180000'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/volgarr-the-viking'

###
# TODO
# Check that the documentation files are provided by the Humble archive
###
ARCHIVE_GAME_DOC_PATH_GOG='data/noarch/game'
ARCHIVE_GAME_DOC_PATH_HUMBLE='Volgarr'
ARCHIVE_GAME_DOC_FILES='Readme.txt'

ARCHIVE_GAME_BIN_PATH_GOG='data/noarch/game'
ARCHIVE_GAME_BIN_PATH_HUMBLE='Volgarr'
ARCHIVE_GAME_BIN_FILES='Volgarr'

ARCHIVE_GAME_DATA_PATH_GOG='data/noarch/game'
ARCHIVE_GAME_DATA_PATH_HUMBLE='Volgarr'
ARCHIVE_GAME_DATA_FILES='Data.pk icon.png'

APP_MAIN_TYPE='native'
APP_MAIN_ICON='icon.png'
APP_MAIN_EXE='Volgarr'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="${PKG_DATA_ID} glibc libstdc++ glx sdl2"

# Load common functions

target_version='2.13'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Extract icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
