# Print the path to the init .reg file
# USAGE: wine_registry_script_path $package
wine_registry_script_path() {
	local package
	package="$1"

	local package_path path_game_data
	package_path=$(package_path "$package")
	path_game_data=$(path_game_data)

	printf '%s%s/registry-scripts/init.reg' \
		"$package_path" \
		"$path_game_data"
}

# Print the content of the init .reg file
# USAGE: wine_registry_script_content
wine_registry_script_content() {
	## TODO: Some game scrips expect contextual values support
	##       for WINE_REGISTRY_INIT.
	local script_content
	script_content="${WINE_REGISTRY_INIT:-}"

	# Return early if there is not init .reg file
	if [ -z "$script_content" ]; then
		return 0
	fi

	cat <<- EOF
	Windows Registry Editor Version 5.00

	$script_content
	EOF
}

# Write the .reg script setting the initial keys for the given package.
# USAGE: wine_registry_script_write $package
wine_registry_script_write() {
	## Identifier of the package that should include that .reg script
	local package="$1"

	local script_content
	script_content=$(wine_registry_script_content)
	## Return early if there is no script to write.
	if [ -z "$script_content" ]; then
		return 0
	fi

	local script_path script_directory
	script_path=$(wine_registry_script_path "$package")
	script_directory=$(dirname "$script_path")
	mkdir --parents "$script_directory"
	printf '%s' "$script_content" |
		iconv --from-code=UTF-8 --to-code=UTF-16 --output="$script_path"
	## Ensure correct permissions on the output file.
	## TODO: Check if this is required, as we already explictly set umask to 0022.
	chmod 644 "$script_path"
}

