//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _hrr_e0_77.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifdef COMPILE_J_ORB
#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_e0_77(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 596];
    auto current_out = &data_out[c * 1296];
   {
     //current index a: xxxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[147];
      const auto axyz_0 = current_data[148];
      const auto ayyz_0 = current_data[149];
      const auto axzz_0 = current_data[157];
      const auto ayzz_0 = current_data[158];
      const auto azzz_0 = current_data[166];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[214];
      const auto axxyz_0 = current_data[215];
      const auto axyyz_0 = current_data[216];
      const auto ayyyz_0 = current_data[217];
      const auto axxzz_0 = current_data[225];
      const auto axyzz_0 = current_data[226];
      const auto ayyzz_0 = current_data[227];
      const auto axzzz_0 = current_data[235];
      const auto ayzzz_0 = current_data[236];
      const auto azzzz_0 = current_data[244];
      const auto axxxxx_0 = current_data[280];
      const auto axxxxy_0 = current_data[281];
      const auto axxxyy_0 = current_data[282];
      const auto axxyyy_0 = current_data[283];
      const auto axyyyy_0 = current_data[284];
      const auto ayyyyy_0 = current_data[285];
      const auto axxxxz_0 = current_data[293];
      const auto axxxyz_0 = current_data[294];
      const auto axxyyz_0 = current_data[295];
      const auto axyyyz_0 = current_data[296];
      const auto ayyyyz_0 = current_data[297];
      const auto axxxzz_0 = current_data[305];
      const auto axxyzz_0 = current_data[306];
      const auto axyyzz_0 = current_data[307];
      const auto ayyyzz_0 = current_data[308];
      const auto axxzzz_0 = current_data[316];
      const auto axyzzz_0 = current_data[317];
      const auto ayyzzz_0 = current_data[318];
      const auto axzzzz_0 = current_data[326];
      const auto ayzzzz_0 = current_data[327];
      const auto azzzzz_0 = current_data[335];
      const auto axxxxxx_0 = current_data[371];
      const auto axxxxxy_0 = current_data[372];
      const auto axxxxyy_0 = current_data[373];
      const auto axxxyyy_0 = current_data[374];
      const auto axxyyyy_0 = current_data[375];
      const auto axyyyyy_0 = current_data[376];
      const auto ayyyyyy_0 = current_data[377];
      const auto axxxxxz_0 = current_data[385];
      const auto axxxxyz_0 = current_data[386];
      const auto axxxyyz_0 = current_data[387];
      const auto axxyyyz_0 = current_data[388];
      const auto axyyyyz_0 = current_data[389];
      const auto ayyyyyz_0 = current_data[390];
      const auto axxxxzz_0 = current_data[398];
      const auto axxxyzz_0 = current_data[399];
      const auto axxyyzz_0 = current_data[400];
      const auto axyyyzz_0 = current_data[401];
      const auto ayyyyzz_0 = current_data[402];
      const auto axxxzzz_0 = current_data[410];
      const auto axxyzzz_0 = current_data[411];
      const auto axyyzzz_0 = current_data[412];
      const auto ayyyzzz_0 = current_data[413];
      const auto axxzzzz_0 = current_data[421];
      const auto axyzzzz_0 = current_data[422];
      const auto ayyzzzz_0 = current_data[423];
      const auto axzzzzz_0 = current_data[431];
      const auto ayzzzzz_0 = current_data[432];
      const auto azzzzzz_0 = current_data[440];
      const auto axxxxxxx_0 = current_data[476];
      const auto axxxxxxy_0 = current_data[477];
      const auto axxxxxyy_0 = current_data[478];
      const auto axxxxyyy_0 = current_data[479];
      const auto axxxyyyy_0 = current_data[480];
      const auto axxyyyyy_0 = current_data[481];
      const auto axyyyyyy_0 = current_data[482];
      const auto ayyyyyyy_0 = current_data[483];
      const auto axxxxxxz_0 = current_data[491];
      const auto axxxxxyz_0 = current_data[492];
      const auto axxxxyyz_0 = current_data[493];
      const auto axxxyyyz_0 = current_data[494];
      const auto axxyyyyz_0 = current_data[495];
      const auto axyyyyyz_0 = current_data[496];
      const auto ayyyyyyz_0 = current_data[497];
      const auto axxxxxzz_0 = current_data[505];
      const auto axxxxyzz_0 = current_data[506];
      const auto axxxyyzz_0 = current_data[507];
      const auto axxyyyzz_0 = current_data[508];
      const auto axyyyyzz_0 = current_data[509];
      const auto ayyyyyzz_0 = current_data[510];
      const auto axxxxzzz_0 = current_data[518];
      const auto axxxyzzz_0 = current_data[519];
      const auto axxyyzzz_0 = current_data[520];
      const auto axyyyzzz_0 = current_data[521];
      const auto ayyyyzzz_0 = current_data[522];
      const auto axxxzzzz_0 = current_data[530];
      const auto axxyzzzz_0 = current_data[531];
      const auto axyyzzzz_0 = current_data[532];
      const auto ayyyzzzz_0 = current_data[533];
      const auto axxzzzzz_0 = current_data[541];
      const auto axyzzzzz_0 = current_data[542];
      const auto ayyzzzzz_0 = current_data[543];
      const auto axzzzzzz_0 = current_data[551];
      const auto ayzzzzzz_0 = current_data[552];
      const auto azzzzzzz_0 = current_data[560];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[0] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[1] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[2] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[3] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[4] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[5] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[6] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[7] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[8] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[9] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[10] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[11] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[12] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[13] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[14] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[15] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[16] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[17] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[18] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[19] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[20] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[21] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[22] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[23] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[24] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[25] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[26] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[27] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[28] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[29] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[30] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[31] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[32] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[33] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[34] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[35] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[148];
      const auto axyz_0 = current_data[149];
      const auto ayyz_0 = current_data[150];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[167];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[226];
      const auto axyzz_0 = current_data[227];
      const auto ayyzz_0 = current_data[228];
      const auto axzzz_0 = current_data[236];
      const auto ayzzz_0 = current_data[237];
      const auto azzzz_0 = current_data[245];
      const auto axxxxx_0 = current_data[281];
      const auto axxxxy_0 = current_data[282];
      const auto axxxyy_0 = current_data[283];
      const auto axxyyy_0 = current_data[284];
      const auto axyyyy_0 = current_data[285];
      const auto ayyyyy_0 = current_data[286];
      const auto axxxxz_0 = current_data[294];
      const auto axxxyz_0 = current_data[295];
      const auto axxyyz_0 = current_data[296];
      const auto axyyyz_0 = current_data[297];
      const auto ayyyyz_0 = current_data[298];
      const auto axxxzz_0 = current_data[306];
      const auto axxyzz_0 = current_data[307];
      const auto axyyzz_0 = current_data[308];
      const auto ayyyzz_0 = current_data[309];
      const auto axxzzz_0 = current_data[317];
      const auto axyzzz_0 = current_data[318];
      const auto ayyzzz_0 = current_data[319];
      const auto axzzzz_0 = current_data[327];
      const auto ayzzzz_0 = current_data[328];
      const auto azzzzz_0 = current_data[336];
      const auto axxxxxx_0 = current_data[372];
      const auto axxxxxy_0 = current_data[373];
      const auto axxxxyy_0 = current_data[374];
      const auto axxxyyy_0 = current_data[375];
      const auto axxyyyy_0 = current_data[376];
      const auto axyyyyy_0 = current_data[377];
      const auto ayyyyyy_0 = current_data[378];
      const auto axxxxxz_0 = current_data[386];
      const auto axxxxyz_0 = current_data[387];
      const auto axxxyyz_0 = current_data[388];
      const auto axxyyyz_0 = current_data[389];
      const auto axyyyyz_0 = current_data[390];
      const auto ayyyyyz_0 = current_data[391];
      const auto axxxxzz_0 = current_data[399];
      const auto axxxyzz_0 = current_data[400];
      const auto axxyyzz_0 = current_data[401];
      const auto axyyyzz_0 = current_data[402];
      const auto ayyyyzz_0 = current_data[403];
      const auto axxxzzz_0 = current_data[411];
      const auto axxyzzz_0 = current_data[412];
      const auto axyyzzz_0 = current_data[413];
      const auto ayyyzzz_0 = current_data[414];
      const auto axxzzzz_0 = current_data[422];
      const auto axyzzzz_0 = current_data[423];
      const auto ayyzzzz_0 = current_data[424];
      const auto axzzzzz_0 = current_data[432];
      const auto ayzzzzz_0 = current_data[433];
      const auto azzzzzz_0 = current_data[441];
      const auto axxxxxxx_0 = current_data[477];
      const auto axxxxxxy_0 = current_data[478];
      const auto axxxxxyy_0 = current_data[479];
      const auto axxxxyyy_0 = current_data[480];
      const auto axxxyyyy_0 = current_data[481];
      const auto axxyyyyy_0 = current_data[482];
      const auto axyyyyyy_0 = current_data[483];
      const auto ayyyyyyy_0 = current_data[484];
      const auto axxxxxxz_0 = current_data[492];
      const auto axxxxxyz_0 = current_data[493];
      const auto axxxxyyz_0 = current_data[494];
      const auto axxxyyyz_0 = current_data[495];
      const auto axxyyyyz_0 = current_data[496];
      const auto axyyyyyz_0 = current_data[497];
      const auto ayyyyyyz_0 = current_data[498];
      const auto axxxxxzz_0 = current_data[506];
      const auto axxxxyzz_0 = current_data[507];
      const auto axxxyyzz_0 = current_data[508];
      const auto axxyyyzz_0 = current_data[509];
      const auto axyyyyzz_0 = current_data[510];
      const auto ayyyyyzz_0 = current_data[511];
      const auto axxxxzzz_0 = current_data[519];
      const auto axxxyzzz_0 = current_data[520];
      const auto axxyyzzz_0 = current_data[521];
      const auto axyyyzzz_0 = current_data[522];
      const auto ayyyyzzz_0 = current_data[523];
      const auto axxxzzzz_0 = current_data[531];
      const auto axxyzzzz_0 = current_data[532];
      const auto axyyzzzz_0 = current_data[533];
      const auto ayyyzzzz_0 = current_data[534];
      const auto axxzzzzz_0 = current_data[542];
      const auto axyzzzzz_0 = current_data[543];
      const auto ayyzzzzz_0 = current_data[544];
      const auto axzzzzzz_0 = current_data[552];
      const auto ayzzzzzz_0 = current_data[553];
      const auto azzzzzzz_0 = current_data[561];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[36] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[37] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[38] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[39] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[40] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[41] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[42] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[43] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[44] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[45] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[46] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[47] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[48] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[49] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[50] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[51] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[52] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[53] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[54] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[55] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[56] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[57] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[58] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[59] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[60] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[61] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[62] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[63] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[64] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[65] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[66] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[67] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[68] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[69] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[70] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[71] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[93];
      const auto ayz_0 = current_data[94];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[168];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[227];
      const auto axyzz_0 = current_data[228];
      const auto ayyzz_0 = current_data[229];
      const auto axzzz_0 = current_data[237];
      const auto ayzzz_0 = current_data[238];
      const auto azzzz_0 = current_data[246];
      const auto axxxxx_0 = current_data[282];
      const auto axxxxy_0 = current_data[283];
      const auto axxxyy_0 = current_data[284];
      const auto axxyyy_0 = current_data[285];
      const auto axyyyy_0 = current_data[286];
      const auto ayyyyy_0 = current_data[287];
      const auto axxxxz_0 = current_data[295];
      const auto axxxyz_0 = current_data[296];
      const auto axxyyz_0 = current_data[297];
      const auto axyyyz_0 = current_data[298];
      const auto ayyyyz_0 = current_data[299];
      const auto axxxzz_0 = current_data[307];
      const auto axxyzz_0 = current_data[308];
      const auto axyyzz_0 = current_data[309];
      const auto ayyyzz_0 = current_data[310];
      const auto axxzzz_0 = current_data[318];
      const auto axyzzz_0 = current_data[319];
      const auto ayyzzz_0 = current_data[320];
      const auto axzzzz_0 = current_data[328];
      const auto ayzzzz_0 = current_data[329];
      const auto azzzzz_0 = current_data[337];
      const auto axxxxxx_0 = current_data[373];
      const auto axxxxxy_0 = current_data[374];
      const auto axxxxyy_0 = current_data[375];
      const auto axxxyyy_0 = current_data[376];
      const auto axxyyyy_0 = current_data[377];
      const auto axyyyyy_0 = current_data[378];
      const auto ayyyyyy_0 = current_data[379];
      const auto axxxxxz_0 = current_data[387];
      const auto axxxxyz_0 = current_data[388];
      const auto axxxyyz_0 = current_data[389];
      const auto axxyyyz_0 = current_data[390];
      const auto axyyyyz_0 = current_data[391];
      const auto ayyyyyz_0 = current_data[392];
      const auto axxxxzz_0 = current_data[400];
      const auto axxxyzz_0 = current_data[401];
      const auto axxyyzz_0 = current_data[402];
      const auto axyyyzz_0 = current_data[403];
      const auto ayyyyzz_0 = current_data[404];
      const auto axxxzzz_0 = current_data[412];
      const auto axxyzzz_0 = current_data[413];
      const auto axyyzzz_0 = current_data[414];
      const auto ayyyzzz_0 = current_data[415];
      const auto axxzzzz_0 = current_data[423];
      const auto axyzzzz_0 = current_data[424];
      const auto ayyzzzz_0 = current_data[425];
      const auto axzzzzz_0 = current_data[433];
      const auto ayzzzzz_0 = current_data[434];
      const auto azzzzzz_0 = current_data[442];
      const auto axxxxxxx_0 = current_data[478];
      const auto axxxxxxy_0 = current_data[479];
      const auto axxxxxyy_0 = current_data[480];
      const auto axxxxyyy_0 = current_data[481];
      const auto axxxyyyy_0 = current_data[482];
      const auto axxyyyyy_0 = current_data[483];
      const auto axyyyyyy_0 = current_data[484];
      const auto ayyyyyyy_0 = current_data[485];
      const auto axxxxxxz_0 = current_data[493];
      const auto axxxxxyz_0 = current_data[494];
      const auto axxxxyyz_0 = current_data[495];
      const auto axxxyyyz_0 = current_data[496];
      const auto axxyyyyz_0 = current_data[497];
      const auto axyyyyyz_0 = current_data[498];
      const auto ayyyyyyz_0 = current_data[499];
      const auto axxxxxzz_0 = current_data[507];
      const auto axxxxyzz_0 = current_data[508];
      const auto axxxyyzz_0 = current_data[509];
      const auto axxyyyzz_0 = current_data[510];
      const auto axyyyyzz_0 = current_data[511];
      const auto ayyyyyzz_0 = current_data[512];
      const auto axxxxzzz_0 = current_data[520];
      const auto axxxyzzz_0 = current_data[521];
      const auto axxyyzzz_0 = current_data[522];
      const auto axyyyzzz_0 = current_data[523];
      const auto ayyyyzzz_0 = current_data[524];
      const auto axxxzzzz_0 = current_data[532];
      const auto axxyzzzz_0 = current_data[533];
      const auto axyyzzzz_0 = current_data[534];
      const auto ayyyzzzz_0 = current_data[535];
      const auto axxzzzzz_0 = current_data[543];
      const auto axyzzzzz_0 = current_data[544];
      const auto ayyzzzzz_0 = current_data[545];
      const auto axzzzzzz_0 = current_data[553];
      const auto ayzzzzzz_0 = current_data[554];
      const auto azzzzzzz_0 = current_data[562];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[72] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[73] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[74] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[75] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[76] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[77] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[78] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[79] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[80] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[81] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[82] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[83] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[84] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[85] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[86] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[87] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[88] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[89] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[90] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[91] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[92] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[93] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[94] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[95] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[96] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[97] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[98] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[99] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[100] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[101] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[102] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[103] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[104] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[105] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[106] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[107] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[160];
      const auto ayzz_0 = current_data[161];
      const auto azzz_0 = current_data[169];
      const auto axxxx_0 = current_data[205];
      const auto axxxy_0 = current_data[206];
      const auto axxyy_0 = current_data[207];
      const auto axyyy_0 = current_data[208];
      const auto ayyyy_0 = current_data[209];
      const auto axxxz_0 = current_data[217];
      const auto axxyz_0 = current_data[218];
      const auto axyyz_0 = current_data[219];
      const auto ayyyz_0 = current_data[220];
      const auto axxzz_0 = current_data[228];
      const auto axyzz_0 = current_data[229];
      const auto ayyzz_0 = current_data[230];
      const auto axzzz_0 = current_data[238];
      const auto ayzzz_0 = current_data[239];
      const auto azzzz_0 = current_data[247];
      const auto axxxxx_0 = current_data[283];
      const auto axxxxy_0 = current_data[284];
      const auto axxxyy_0 = current_data[285];
      const auto axxyyy_0 = current_data[286];
      const auto axyyyy_0 = current_data[287];
      const auto ayyyyy_0 = current_data[288];
      const auto axxxxz_0 = current_data[296];
      const auto axxxyz_0 = current_data[297];
      const auto axxyyz_0 = current_data[298];
      const auto axyyyz_0 = current_data[299];
      const auto ayyyyz_0 = current_data[300];
      const auto axxxzz_0 = current_data[308];
      const auto axxyzz_0 = current_data[309];
      const auto axyyzz_0 = current_data[310];
      const auto ayyyzz_0 = current_data[311];
      const auto axxzzz_0 = current_data[319];
      const auto axyzzz_0 = current_data[320];
      const auto ayyzzz_0 = current_data[321];
      const auto axzzzz_0 = current_data[329];
      const auto ayzzzz_0 = current_data[330];
      const auto azzzzz_0 = current_data[338];
      const auto axxxxxx_0 = current_data[374];
      const auto axxxxxy_0 = current_data[375];
      const auto axxxxyy_0 = current_data[376];
      const auto axxxyyy_0 = current_data[377];
      const auto axxyyyy_0 = current_data[378];
      const auto axyyyyy_0 = current_data[379];
      const auto ayyyyyy_0 = current_data[380];
      const auto axxxxxz_0 = current_data[388];
      const auto axxxxyz_0 = current_data[389];
      const auto axxxyyz_0 = current_data[390];
      const auto axxyyyz_0 = current_data[391];
      const auto axyyyyz_0 = current_data[392];
      const auto ayyyyyz_0 = current_data[393];
      const auto axxxxzz_0 = current_data[401];
      const auto axxxyzz_0 = current_data[402];
      const auto axxyyzz_0 = current_data[403];
      const auto axyyyzz_0 = current_data[404];
      const auto ayyyyzz_0 = current_data[405];
      const auto axxxzzz_0 = current_data[413];
      const auto axxyzzz_0 = current_data[414];
      const auto axyyzzz_0 = current_data[415];
      const auto ayyyzzz_0 = current_data[416];
      const auto axxzzzz_0 = current_data[424];
      const auto axyzzzz_0 = current_data[425];
      const auto ayyzzzz_0 = current_data[426];
      const auto axzzzzz_0 = current_data[434];
      const auto ayzzzzz_0 = current_data[435];
      const auto azzzzzz_0 = current_data[443];
      const auto axxxxxxx_0 = current_data[479];
      const auto axxxxxxy_0 = current_data[480];
      const auto axxxxxyy_0 = current_data[481];
      const auto axxxxyyy_0 = current_data[482];
      const auto axxxyyyy_0 = current_data[483];
      const auto axxyyyyy_0 = current_data[484];
      const auto axyyyyyy_0 = current_data[485];
      const auto ayyyyyyy_0 = current_data[486];
      const auto axxxxxxz_0 = current_data[494];
      const auto axxxxxyz_0 = current_data[495];
      const auto axxxxyyz_0 = current_data[496];
      const auto axxxyyyz_0 = current_data[497];
      const auto axxyyyyz_0 = current_data[498];
      const auto axyyyyyz_0 = current_data[499];
      const auto ayyyyyyz_0 = current_data[500];
      const auto axxxxxzz_0 = current_data[508];
      const auto axxxxyzz_0 = current_data[509];
      const auto axxxyyzz_0 = current_data[510];
      const auto axxyyyzz_0 = current_data[511];
      const auto axyyyyzz_0 = current_data[512];
      const auto ayyyyyzz_0 = current_data[513];
      const auto axxxxzzz_0 = current_data[521];
      const auto axxxyzzz_0 = current_data[522];
      const auto axxyyzzz_0 = current_data[523];
      const auto axyyyzzz_0 = current_data[524];
      const auto ayyyyzzz_0 = current_data[525];
      const auto axxxzzzz_0 = current_data[533];
      const auto axxyzzzz_0 = current_data[534];
      const auto axyyzzzz_0 = current_data[535];
      const auto ayyyzzzz_0 = current_data[536];
      const auto axxzzzzz_0 = current_data[544];
      const auto axyzzzzz_0 = current_data[545];
      const auto ayyzzzzz_0 = current_data[546];
      const auto axzzzzzz_0 = current_data[554];
      const auto ayzzzzzz_0 = current_data[555];
      const auto azzzzzzz_0 = current_data[563];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[108] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[109] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[110] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[111] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[112] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[113] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[114] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[115] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[116] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[117] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[118] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[119] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[120] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[121] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[122] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[123] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[124] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[125] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[126] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[127] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[128] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[129] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[130] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[131] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[132] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[133] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[134] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[135] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[136] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[137] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[138] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[139] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[140] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[141] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[142] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[143] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[140];
      const auto axxy_0 = current_data[141];
      const auto axyy_0 = current_data[142];
      const auto ayyy_0 = current_data[143];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[170];
      const auto axxxx_0 = current_data[206];
      const auto axxxy_0 = current_data[207];
      const auto axxyy_0 = current_data[208];
      const auto axyyy_0 = current_data[209];
      const auto ayyyy_0 = current_data[210];
      const auto axxxz_0 = current_data[218];
      const auto axxyz_0 = current_data[219];
      const auto axyyz_0 = current_data[220];
      const auto ayyyz_0 = current_data[221];
      const auto axxzz_0 = current_data[229];
      const auto axyzz_0 = current_data[230];
      const auto ayyzz_0 = current_data[231];
      const auto axzzz_0 = current_data[239];
      const auto ayzzz_0 = current_data[240];
      const auto azzzz_0 = current_data[248];
      const auto axxxxx_0 = current_data[284];
      const auto axxxxy_0 = current_data[285];
      const auto axxxyy_0 = current_data[286];
      const auto axxyyy_0 = current_data[287];
      const auto axyyyy_0 = current_data[288];
      const auto ayyyyy_0 = current_data[289];
      const auto axxxxz_0 = current_data[297];
      const auto axxxyz_0 = current_data[298];
      const auto axxyyz_0 = current_data[299];
      const auto axyyyz_0 = current_data[300];
      const auto ayyyyz_0 = current_data[301];
      const auto axxxzz_0 = current_data[309];
      const auto axxyzz_0 = current_data[310];
      const auto axyyzz_0 = current_data[311];
      const auto ayyyzz_0 = current_data[312];
      const auto axxzzz_0 = current_data[320];
      const auto axyzzz_0 = current_data[321];
      const auto ayyzzz_0 = current_data[322];
      const auto axzzzz_0 = current_data[330];
      const auto ayzzzz_0 = current_data[331];
      const auto azzzzz_0 = current_data[339];
      const auto axxxxxx_0 = current_data[375];
      const auto axxxxxy_0 = current_data[376];
      const auto axxxxyy_0 = current_data[377];
      const auto axxxyyy_0 = current_data[378];
      const auto axxyyyy_0 = current_data[379];
      const auto axyyyyy_0 = current_data[380];
      const auto ayyyyyy_0 = current_data[381];
      const auto axxxxxz_0 = current_data[389];
      const auto axxxxyz_0 = current_data[390];
      const auto axxxyyz_0 = current_data[391];
      const auto axxyyyz_0 = current_data[392];
      const auto axyyyyz_0 = current_data[393];
      const auto ayyyyyz_0 = current_data[394];
      const auto axxxxzz_0 = current_data[402];
      const auto axxxyzz_0 = current_data[403];
      const auto axxyyzz_0 = current_data[404];
      const auto axyyyzz_0 = current_data[405];
      const auto ayyyyzz_0 = current_data[406];
      const auto axxxzzz_0 = current_data[414];
      const auto axxyzzz_0 = current_data[415];
      const auto axyyzzz_0 = current_data[416];
      const auto ayyyzzz_0 = current_data[417];
      const auto axxzzzz_0 = current_data[425];
      const auto axyzzzz_0 = current_data[426];
      const auto ayyzzzz_0 = current_data[427];
      const auto axzzzzz_0 = current_data[435];
      const auto ayzzzzz_0 = current_data[436];
      const auto azzzzzz_0 = current_data[444];
      const auto axxxxxxx_0 = current_data[480];
      const auto axxxxxxy_0 = current_data[481];
      const auto axxxxxyy_0 = current_data[482];
      const auto axxxxyyy_0 = current_data[483];
      const auto axxxyyyy_0 = current_data[484];
      const auto axxyyyyy_0 = current_data[485];
      const auto axyyyyyy_0 = current_data[486];
      const auto ayyyyyyy_0 = current_data[487];
      const auto axxxxxxz_0 = current_data[495];
      const auto axxxxxyz_0 = current_data[496];
      const auto axxxxyyz_0 = current_data[497];
      const auto axxxyyyz_0 = current_data[498];
      const auto axxyyyyz_0 = current_data[499];
      const auto axyyyyyz_0 = current_data[500];
      const auto ayyyyyyz_0 = current_data[501];
      const auto axxxxxzz_0 = current_data[509];
      const auto axxxxyzz_0 = current_data[510];
      const auto axxxyyzz_0 = current_data[511];
      const auto axxyyyzz_0 = current_data[512];
      const auto axyyyyzz_0 = current_data[513];
      const auto ayyyyyzz_0 = current_data[514];
      const auto axxxxzzz_0 = current_data[522];
      const auto axxxyzzz_0 = current_data[523];
      const auto axxyyzzz_0 = current_data[524];
      const auto axyyyzzz_0 = current_data[525];
      const auto ayyyyzzz_0 = current_data[526];
      const auto axxxzzzz_0 = current_data[534];
      const auto axxyzzzz_0 = current_data[535];
      const auto axyyzzzz_0 = current_data[536];
      const auto ayyyzzzz_0 = current_data[537];
      const auto axxzzzzz_0 = current_data[545];
      const auto axyzzzzz_0 = current_data[546];
      const auto ayyzzzzz_0 = current_data[547];
      const auto axzzzzzz_0 = current_data[555];
      const auto ayzzzzzz_0 = current_data[556];
      const auto azzzzzzz_0 = current_data[564];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[144] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[145] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[146] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[147] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[148] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[149] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[150] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[151] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[152] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[153] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[154] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[155] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[156] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[157] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[158] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[159] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[160] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[161] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[162] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[163] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[164] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[165] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[166] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[167] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[168] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[169] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[170] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[171] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[172] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[173] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[174] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[175] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[176] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[177] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[178] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[179] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[50];
      const auto axx_0 = current_data[86];
      const auto axy_0 = current_data[87];
      const auto ayy_0 = current_data[88];
      const auto axz_0 = current_data[96];
      const auto ayz_0 = current_data[97];
      const auto azz_0 = current_data[105];
      const auto axxx_0 = current_data[141];
      const auto axxy_0 = current_data[142];
      const auto axyy_0 = current_data[143];
      const auto ayyy_0 = current_data[144];
      const auto axxz_0 = current_data[152];
      const auto axyz_0 = current_data[153];
      const auto ayyz_0 = current_data[154];
      const auto axzz_0 = current_data[162];
      const auto ayzz_0 = current_data[163];
      const auto azzz_0 = current_data[171];
      const auto axxxx_0 = current_data[207];
      const auto axxxy_0 = current_data[208];
      const auto axxyy_0 = current_data[209];
      const auto axyyy_0 = current_data[210];
      const auto ayyyy_0 = current_data[211];
      const auto axxxz_0 = current_data[219];
      const auto axxyz_0 = current_data[220];
      const auto axyyz_0 = current_data[221];
      const auto ayyyz_0 = current_data[222];
      const auto axxzz_0 = current_data[230];
      const auto axyzz_0 = current_data[231];
      const auto ayyzz_0 = current_data[232];
      const auto axzzz_0 = current_data[240];
      const auto ayzzz_0 = current_data[241];
      const auto azzzz_0 = current_data[249];
      const auto axxxxx_0 = current_data[285];
      const auto axxxxy_0 = current_data[286];
      const auto axxxyy_0 = current_data[287];
      const auto axxyyy_0 = current_data[288];
      const auto axyyyy_0 = current_data[289];
      const auto ayyyyy_0 = current_data[290];
      const auto axxxxz_0 = current_data[298];
      const auto axxxyz_0 = current_data[299];
      const auto axxyyz_0 = current_data[300];
      const auto axyyyz_0 = current_data[301];
      const auto ayyyyz_0 = current_data[302];
      const auto axxxzz_0 = current_data[310];
      const auto axxyzz_0 = current_data[311];
      const auto axyyzz_0 = current_data[312];
      const auto ayyyzz_0 = current_data[313];
      const auto axxzzz_0 = current_data[321];
      const auto axyzzz_0 = current_data[322];
      const auto ayyzzz_0 = current_data[323];
      const auto axzzzz_0 = current_data[331];
      const auto ayzzzz_0 = current_data[332];
      const auto azzzzz_0 = current_data[340];
      const auto axxxxxx_0 = current_data[376];
      const auto axxxxxy_0 = current_data[377];
      const auto axxxxyy_0 = current_data[378];
      const auto axxxyyy_0 = current_data[379];
      const auto axxyyyy_0 = current_data[380];
      const auto axyyyyy_0 = current_data[381];
      const auto ayyyyyy_0 = current_data[382];
      const auto axxxxxz_0 = current_data[390];
      const auto axxxxyz_0 = current_data[391];
      const auto axxxyyz_0 = current_data[392];
      const auto axxyyyz_0 = current_data[393];
      const auto axyyyyz_0 = current_data[394];
      const auto ayyyyyz_0 = current_data[395];
      const auto axxxxzz_0 = current_data[403];
      const auto axxxyzz_0 = current_data[404];
      const auto axxyyzz_0 = current_data[405];
      const auto axyyyzz_0 = current_data[406];
      const auto ayyyyzz_0 = current_data[407];
      const auto axxxzzz_0 = current_data[415];
      const auto axxyzzz_0 = current_data[416];
      const auto axyyzzz_0 = current_data[417];
      const auto ayyyzzz_0 = current_data[418];
      const auto axxzzzz_0 = current_data[426];
      const auto axyzzzz_0 = current_data[427];
      const auto ayyzzzz_0 = current_data[428];
      const auto axzzzzz_0 = current_data[436];
      const auto ayzzzzz_0 = current_data[437];
      const auto azzzzzz_0 = current_data[445];
      const auto axxxxxxx_0 = current_data[481];
      const auto axxxxxxy_0 = current_data[482];
      const auto axxxxxyy_0 = current_data[483];
      const auto axxxxyyy_0 = current_data[484];
      const auto axxxyyyy_0 = current_data[485];
      const auto axxyyyyy_0 = current_data[486];
      const auto axyyyyyy_0 = current_data[487];
      const auto ayyyyyyy_0 = current_data[488];
      const auto axxxxxxz_0 = current_data[496];
      const auto axxxxxyz_0 = current_data[497];
      const auto axxxxyyz_0 = current_data[498];
      const auto axxxyyyz_0 = current_data[499];
      const auto axxyyyyz_0 = current_data[500];
      const auto axyyyyyz_0 = current_data[501];
      const auto ayyyyyyz_0 = current_data[502];
      const auto axxxxxzz_0 = current_data[510];
      const auto axxxxyzz_0 = current_data[511];
      const auto axxxyyzz_0 = current_data[512];
      const auto axxyyyzz_0 = current_data[513];
      const auto axyyyyzz_0 = current_data[514];
      const auto ayyyyyzz_0 = current_data[515];
      const auto axxxxzzz_0 = current_data[523];
      const auto axxxyzzz_0 = current_data[524];
      const auto axxyyzzz_0 = current_data[525];
      const auto axyyyzzz_0 = current_data[526];
      const auto ayyyyzzz_0 = current_data[527];
      const auto axxxzzzz_0 = current_data[535];
      const auto axxyzzzz_0 = current_data[536];
      const auto axyyzzzz_0 = current_data[537];
      const auto ayyyzzzz_0 = current_data[538];
      const auto axxzzzzz_0 = current_data[546];
      const auto axyzzzzz_0 = current_data[547];
      const auto ayyzzzzz_0 = current_data[548];
      const auto axzzzzzz_0 = current_data[556];
      const auto ayzzzzzz_0 = current_data[557];
      const auto azzzzzzz_0 = current_data[565];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[180] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[181] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[182] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[183] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[184] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[185] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[186] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[187] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[188] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[189] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[190] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[191] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[192] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[193] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[194] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[195] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[196] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[197] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[198] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[199] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[200] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[201] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[202] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[203] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[204] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[205] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[206] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[207] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[208] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[209] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[210] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[211] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[212] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[213] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[214] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[215] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xyyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[42];
      const auto ay_0 = current_data[43];
      const auto az_0 = current_data[51];
      const auto axx_0 = current_data[87];
      const auto axy_0 = current_data[88];
      const auto ayy_0 = current_data[89];
      const auto axz_0 = current_data[97];
      const auto ayz_0 = current_data[98];
      const auto azz_0 = current_data[106];
      const auto axxx_0 = current_data[142];
      const auto axxy_0 = current_data[143];
      const auto axyy_0 = current_data[144];
      const auto ayyy_0 = current_data[145];
      const auto axxz_0 = current_data[153];
      const auto axyz_0 = current_data[154];
      const auto ayyz_0 = current_data[155];
      const auto axzz_0 = current_data[163];
      const auto ayzz_0 = current_data[164];
      const auto azzz_0 = current_data[172];
      const auto axxxx_0 = current_data[208];
      const auto axxxy_0 = current_data[209];
      const auto axxyy_0 = current_data[210];
      const auto axyyy_0 = current_data[211];
      const auto ayyyy_0 = current_data[212];
      const auto axxxz_0 = current_data[220];
      const auto axxyz_0 = current_data[221];
      const auto axyyz_0 = current_data[222];
      const auto ayyyz_0 = current_data[223];
      const auto axxzz_0 = current_data[231];
      const auto axyzz_0 = current_data[232];
      const auto ayyzz_0 = current_data[233];
      const auto axzzz_0 = current_data[241];
      const auto ayzzz_0 = current_data[242];
      const auto azzzz_0 = current_data[250];
      const auto axxxxx_0 = current_data[286];
      const auto axxxxy_0 = current_data[287];
      const auto axxxyy_0 = current_data[288];
      const auto axxyyy_0 = current_data[289];
      const auto axyyyy_0 = current_data[290];
      const auto ayyyyy_0 = current_data[291];
      const auto axxxxz_0 = current_data[299];
      const auto axxxyz_0 = current_data[300];
      const auto axxyyz_0 = current_data[301];
      const auto axyyyz_0 = current_data[302];
      const auto ayyyyz_0 = current_data[303];
      const auto axxxzz_0 = current_data[311];
      const auto axxyzz_0 = current_data[312];
      const auto axyyzz_0 = current_data[313];
      const auto ayyyzz_0 = current_data[314];
      const auto axxzzz_0 = current_data[322];
      const auto axyzzz_0 = current_data[323];
      const auto ayyzzz_0 = current_data[324];
      const auto axzzzz_0 = current_data[332];
      const auto ayzzzz_0 = current_data[333];
      const auto azzzzz_0 = current_data[341];
      const auto axxxxxx_0 = current_data[377];
      const auto axxxxxy_0 = current_data[378];
      const auto axxxxyy_0 = current_data[379];
      const auto axxxyyy_0 = current_data[380];
      const auto axxyyyy_0 = current_data[381];
      const auto axyyyyy_0 = current_data[382];
      const auto ayyyyyy_0 = current_data[383];
      const auto axxxxxz_0 = current_data[391];
      const auto axxxxyz_0 = current_data[392];
      const auto axxxyyz_0 = current_data[393];
      const auto axxyyyz_0 = current_data[394];
      const auto axyyyyz_0 = current_data[395];
      const auto ayyyyyz_0 = current_data[396];
      const auto axxxxzz_0 = current_data[404];
      const auto axxxyzz_0 = current_data[405];
      const auto axxyyzz_0 = current_data[406];
      const auto axyyyzz_0 = current_data[407];
      const auto ayyyyzz_0 = current_data[408];
      const auto axxxzzz_0 = current_data[416];
      const auto axxyzzz_0 = current_data[417];
      const auto axyyzzz_0 = current_data[418];
      const auto ayyyzzz_0 = current_data[419];
      const auto axxzzzz_0 = current_data[427];
      const auto axyzzzz_0 = current_data[428];
      const auto ayyzzzz_0 = current_data[429];
      const auto axzzzzz_0 = current_data[437];
      const auto ayzzzzz_0 = current_data[438];
      const auto azzzzzz_0 = current_data[446];
      const auto axxxxxxx_0 = current_data[482];
      const auto axxxxxxy_0 = current_data[483];
      const auto axxxxxyy_0 = current_data[484];
      const auto axxxxyyy_0 = current_data[485];
      const auto axxxyyyy_0 = current_data[486];
      const auto axxyyyyy_0 = current_data[487];
      const auto axyyyyyy_0 = current_data[488];
      const auto ayyyyyyy_0 = current_data[489];
      const auto axxxxxxz_0 = current_data[497];
      const auto axxxxxyz_0 = current_data[498];
      const auto axxxxyyz_0 = current_data[499];
      const auto axxxyyyz_0 = current_data[500];
      const auto axxyyyyz_0 = current_data[501];
      const auto axyyyyyz_0 = current_data[502];
      const auto ayyyyyyz_0 = current_data[503];
      const auto axxxxxzz_0 = current_data[511];
      const auto axxxxyzz_0 = current_data[512];
      const auto axxxyyzz_0 = current_data[513];
      const auto axxyyyzz_0 = current_data[514];
      const auto axyyyyzz_0 = current_data[515];
      const auto ayyyyyzz_0 = current_data[516];
      const auto axxxxzzz_0 = current_data[524];
      const auto axxxyzzz_0 = current_data[525];
      const auto axxyyzzz_0 = current_data[526];
      const auto axyyyzzz_0 = current_data[527];
      const auto ayyyyzzz_0 = current_data[528];
      const auto axxxzzzz_0 = current_data[536];
      const auto axxyzzzz_0 = current_data[537];
      const auto axyyzzzz_0 = current_data[538];
      const auto ayyyzzzz_0 = current_data[539];
      const auto axxzzzzz_0 = current_data[547];
      const auto axyzzzzz_0 = current_data[548];
      const auto ayyzzzzz_0 = current_data[549];
      const auto axzzzzzz_0 = current_data[557];
      const auto ayzzzzzz_0 = current_data[558];
      const auto azzzzzzz_0 = current_data[566];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[216] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[217] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[218] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[219] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[220] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[221] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[222] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[223] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[224] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[225] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[226] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[227] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[228] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[229] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[230] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[231] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[232] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[233] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[234] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[235] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[236] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[237] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[238] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[239] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[240] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[241] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[242] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[243] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[244] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[245] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[246] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[247] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[248] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[249] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[250] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[251] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: yyyyyyy
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[52];
      const auto axx_0 = current_data[88];
      const auto axy_0 = current_data[89];
      const auto ayy_0 = current_data[90];
      const auto axz_0 = current_data[98];
      const auto ayz_0 = current_data[99];
      const auto azz_0 = current_data[107];
      const auto axxx_0 = current_data[143];
      const auto axxy_0 = current_data[144];
      const auto axyy_0 = current_data[145];
      const auto ayyy_0 = current_data[146];
      const auto axxz_0 = current_data[154];
      const auto axyz_0 = current_data[155];
      const auto ayyz_0 = current_data[156];
      const auto axzz_0 = current_data[164];
      const auto ayzz_0 = current_data[165];
      const auto azzz_0 = current_data[173];
      const auto axxxx_0 = current_data[209];
      const auto axxxy_0 = current_data[210];
      const auto axxyy_0 = current_data[211];
      const auto axyyy_0 = current_data[212];
      const auto ayyyy_0 = current_data[213];
      const auto axxxz_0 = current_data[221];
      const auto axxyz_0 = current_data[222];
      const auto axyyz_0 = current_data[223];
      const auto ayyyz_0 = current_data[224];
      const auto axxzz_0 = current_data[232];
      const auto axyzz_0 = current_data[233];
      const auto ayyzz_0 = current_data[234];
      const auto axzzz_0 = current_data[242];
      const auto ayzzz_0 = current_data[243];
      const auto azzzz_0 = current_data[251];
      const auto axxxxx_0 = current_data[287];
      const auto axxxxy_0 = current_data[288];
      const auto axxxyy_0 = current_data[289];
      const auto axxyyy_0 = current_data[290];
      const auto axyyyy_0 = current_data[291];
      const auto ayyyyy_0 = current_data[292];
      const auto axxxxz_0 = current_data[300];
      const auto axxxyz_0 = current_data[301];
      const auto axxyyz_0 = current_data[302];
      const auto axyyyz_0 = current_data[303];
      const auto ayyyyz_0 = current_data[304];
      const auto axxxzz_0 = current_data[312];
      const auto axxyzz_0 = current_data[313];
      const auto axyyzz_0 = current_data[314];
      const auto ayyyzz_0 = current_data[315];
      const auto axxzzz_0 = current_data[323];
      const auto axyzzz_0 = current_data[324];
      const auto ayyzzz_0 = current_data[325];
      const auto axzzzz_0 = current_data[333];
      const auto ayzzzz_0 = current_data[334];
      const auto azzzzz_0 = current_data[342];
      const auto axxxxxx_0 = current_data[378];
      const auto axxxxxy_0 = current_data[379];
      const auto axxxxyy_0 = current_data[380];
      const auto axxxyyy_0 = current_data[381];
      const auto axxyyyy_0 = current_data[382];
      const auto axyyyyy_0 = current_data[383];
      const auto ayyyyyy_0 = current_data[384];
      const auto axxxxxz_0 = current_data[392];
      const auto axxxxyz_0 = current_data[393];
      const auto axxxyyz_0 = current_data[394];
      const auto axxyyyz_0 = current_data[395];
      const auto axyyyyz_0 = current_data[396];
      const auto ayyyyyz_0 = current_data[397];
      const auto axxxxzz_0 = current_data[405];
      const auto axxxyzz_0 = current_data[406];
      const auto axxyyzz_0 = current_data[407];
      const auto axyyyzz_0 = current_data[408];
      const auto ayyyyzz_0 = current_data[409];
      const auto axxxzzz_0 = current_data[417];
      const auto axxyzzz_0 = current_data[418];
      const auto axyyzzz_0 = current_data[419];
      const auto ayyyzzz_0 = current_data[420];
      const auto axxzzzz_0 = current_data[428];
      const auto axyzzzz_0 = current_data[429];
      const auto ayyzzzz_0 = current_data[430];
      const auto axzzzzz_0 = current_data[438];
      const auto ayzzzzz_0 = current_data[439];
      const auto azzzzzz_0 = current_data[447];
      const auto axxxxxxx_0 = current_data[483];
      const auto axxxxxxy_0 = current_data[484];
      const auto axxxxxyy_0 = current_data[485];
      const auto axxxxyyy_0 = current_data[486];
      const auto axxxyyyy_0 = current_data[487];
      const auto axxyyyyy_0 = current_data[488];
      const auto axyyyyyy_0 = current_data[489];
      const auto ayyyyyyy_0 = current_data[490];
      const auto axxxxxxz_0 = current_data[498];
      const auto axxxxxyz_0 = current_data[499];
      const auto axxxxyyz_0 = current_data[500];
      const auto axxxyyyz_0 = current_data[501];
      const auto axxyyyyz_0 = current_data[502];
      const auto axyyyyyz_0 = current_data[503];
      const auto ayyyyyyz_0 = current_data[504];
      const auto axxxxxzz_0 = current_data[512];
      const auto axxxxyzz_0 = current_data[513];
      const auto axxxyyzz_0 = current_data[514];
      const auto axxyyyzz_0 = current_data[515];
      const auto axyyyyzz_0 = current_data[516];
      const auto ayyyyyzz_0 = current_data[517];
      const auto axxxxzzz_0 = current_data[525];
      const auto axxxyzzz_0 = current_data[526];
      const auto axxyyzzz_0 = current_data[527];
      const auto axyyyzzz_0 = current_data[528];
      const auto ayyyyzzz_0 = current_data[529];
      const auto axxxzzzz_0 = current_data[537];
      const auto axxyzzzz_0 = current_data[538];
      const auto axyyzzzz_0 = current_data[539];
      const auto ayyyzzzz_0 = current_data[540];
      const auto axxzzzzz_0 = current_data[548];
      const auto axyzzzzz_0 = current_data[549];
      const auto ayyzzzzz_0 = current_data[550];
      const auto axzzzzzz_0 = current_data[558];
      const auto ayzzzzzz_0 = current_data[559];
      const auto azzzzzzz_0 = current_data[567];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[252] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[253] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[254] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[255] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[256] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[257] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[258] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[259] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[260] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[261] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[262] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[263] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[264] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[265] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[266] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[267] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[268] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[269] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[270] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[271] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[272] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[273] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[274] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[275] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[276] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[277] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[278] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[279] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[280] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[281] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[282] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[283] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[284] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[285] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[286] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[287] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxxxz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[45];
      const auto ay_0 = current_data[46];
      const auto az_0 = current_data[53];
      const auto axx_0 = current_data[91];
      const auto axy_0 = current_data[92];
      const auto ayy_0 = current_data[93];
      const auto axz_0 = current_data[100];
      const auto ayz_0 = current_data[101];
      const auto azz_0 = current_data[108];
      const auto axxx_0 = current_data[147];
      const auto axxy_0 = current_data[148];
      const auto axyy_0 = current_data[149];
      const auto ayyy_0 = current_data[150];
      const auto axxz_0 = current_data[157];
      const auto axyz_0 = current_data[158];
      const auto ayyz_0 = current_data[159];
      const auto axzz_0 = current_data[166];
      const auto ayzz_0 = current_data[167];
      const auto azzz_0 = current_data[174];
      const auto axxxx_0 = current_data[214];
      const auto axxxy_0 = current_data[215];
      const auto axxyy_0 = current_data[216];
      const auto axyyy_0 = current_data[217];
      const auto ayyyy_0 = current_data[218];
      const auto axxxz_0 = current_data[225];
      const auto axxyz_0 = current_data[226];
      const auto axyyz_0 = current_data[227];
      const auto ayyyz_0 = current_data[228];
      const auto axxzz_0 = current_data[235];
      const auto axyzz_0 = current_data[236];
      const auto ayyzz_0 = current_data[237];
      const auto axzzz_0 = current_data[244];
      const auto ayzzz_0 = current_data[245];
      const auto azzzz_0 = current_data[252];
      const auto axxxxx_0 = current_data[293];
      const auto axxxxy_0 = current_data[294];
      const auto axxxyy_0 = current_data[295];
      const auto axxyyy_0 = current_data[296];
      const auto axyyyy_0 = current_data[297];
      const auto ayyyyy_0 = current_data[298];
      const auto axxxxz_0 = current_data[305];
      const auto axxxyz_0 = current_data[306];
      const auto axxyyz_0 = current_data[307];
      const auto axyyyz_0 = current_data[308];
      const auto ayyyyz_0 = current_data[309];
      const auto axxxzz_0 = current_data[316];
      const auto axxyzz_0 = current_data[317];
      const auto axyyzz_0 = current_data[318];
      const auto ayyyzz_0 = current_data[319];
      const auto axxzzz_0 = current_data[326];
      const auto axyzzz_0 = current_data[327];
      const auto ayyzzz_0 = current_data[328];
      const auto axzzzz_0 = current_data[335];
      const auto ayzzzz_0 = current_data[336];
      const auto azzzzz_0 = current_data[343];
      const auto axxxxxx_0 = current_data[385];
      const auto axxxxxy_0 = current_data[386];
      const auto axxxxyy_0 = current_data[387];
      const auto axxxyyy_0 = current_data[388];
      const auto axxyyyy_0 = current_data[389];
      const auto axyyyyy_0 = current_data[390];
      const auto ayyyyyy_0 = current_data[391];
      const auto axxxxxz_0 = current_data[398];
      const auto axxxxyz_0 = current_data[399];
      const auto axxxyyz_0 = current_data[400];
      const auto axxyyyz_0 = current_data[401];
      const auto axyyyyz_0 = current_data[402];
      const auto ayyyyyz_0 = current_data[403];
      const auto axxxxzz_0 = current_data[410];
      const auto axxxyzz_0 = current_data[411];
      const auto axxyyzz_0 = current_data[412];
      const auto axyyyzz_0 = current_data[413];
      const auto ayyyyzz_0 = current_data[414];
      const auto axxxzzz_0 = current_data[421];
      const auto axxyzzz_0 = current_data[422];
      const auto axyyzzz_0 = current_data[423];
      const auto ayyyzzz_0 = current_data[424];
      const auto axxzzzz_0 = current_data[431];
      const auto axyzzzz_0 = current_data[432];
      const auto ayyzzzz_0 = current_data[433];
      const auto axzzzzz_0 = current_data[440];
      const auto ayzzzzz_0 = current_data[441];
      const auto azzzzzz_0 = current_data[448];
      const auto axxxxxxx_0 = current_data[491];
      const auto axxxxxxy_0 = current_data[492];
      const auto axxxxxyy_0 = current_data[493];
      const auto axxxxyyy_0 = current_data[494];
      const auto axxxyyyy_0 = current_data[495];
      const auto axxyyyyy_0 = current_data[496];
      const auto axyyyyyy_0 = current_data[497];
      const auto ayyyyyyy_0 = current_data[498];
      const auto axxxxxxz_0 = current_data[505];
      const auto axxxxxyz_0 = current_data[506];
      const auto axxxxyyz_0 = current_data[507];
      const auto axxxyyyz_0 = current_data[508];
      const auto axxyyyyz_0 = current_data[509];
      const auto axyyyyyz_0 = current_data[510];
      const auto ayyyyyyz_0 = current_data[511];
      const auto axxxxxzz_0 = current_data[518];
      const auto axxxxyzz_0 = current_data[519];
      const auto axxxyyzz_0 = current_data[520];
      const auto axxyyyzz_0 = current_data[521];
      const auto axyyyyzz_0 = current_data[522];
      const auto ayyyyyzz_0 = current_data[523];
      const auto axxxxzzz_0 = current_data[530];
      const auto axxxyzzz_0 = current_data[531];
      const auto axxyyzzz_0 = current_data[532];
      const auto axyyyzzz_0 = current_data[533];
      const auto ayyyyzzz_0 = current_data[534];
      const auto axxxzzzz_0 = current_data[541];
      const auto axxyzzzz_0 = current_data[542];
      const auto axyyzzzz_0 = current_data[543];
      const auto ayyyzzzz_0 = current_data[544];
      const auto axxzzzzz_0 = current_data[551];
      const auto axyzzzzz_0 = current_data[552];
      const auto ayyzzzzz_0 = current_data[553];
      const auto axzzzzzz_0 = current_data[560];
      const auto ayzzzzzz_0 = current_data[561];
      const auto azzzzzzz_0 = current_data[568];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[288] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[289] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[290] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[291] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[292] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[293] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[294] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[295] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[296] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[297] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[298] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[299] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[300] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[301] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[302] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[303] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[304] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[305] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[306] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[307] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[308] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[309] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[310] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[311] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[312] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[313] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[314] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[315] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[316] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[317] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[318] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[319] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[320] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[321] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[322] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[323] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxxyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[54];
      const auto axx_0 = current_data[92];
      const auto axy_0 = current_data[93];
      const auto ayy_0 = current_data[94];
      const auto axz_0 = current_data[101];
      const auto ayz_0 = current_data[102];
      const auto azz_0 = current_data[109];
      const auto axxx_0 = current_data[148];
      const auto axxy_0 = current_data[149];
      const auto axyy_0 = current_data[150];
      const auto ayyy_0 = current_data[151];
      const auto axxz_0 = current_data[158];
      const auto axyz_0 = current_data[159];
      const auto ayyz_0 = current_data[160];
      const auto axzz_0 = current_data[167];
      const auto ayzz_0 = current_data[168];
      const auto azzz_0 = current_data[175];
      const auto axxxx_0 = current_data[215];
      const auto axxxy_0 = current_data[216];
      const auto axxyy_0 = current_data[217];
      const auto axyyy_0 = current_data[218];
      const auto ayyyy_0 = current_data[219];
      const auto axxxz_0 = current_data[226];
      const auto axxyz_0 = current_data[227];
      const auto axyyz_0 = current_data[228];
      const auto ayyyz_0 = current_data[229];
      const auto axxzz_0 = current_data[236];
      const auto axyzz_0 = current_data[237];
      const auto ayyzz_0 = current_data[238];
      const auto axzzz_0 = current_data[245];
      const auto ayzzz_0 = current_data[246];
      const auto azzzz_0 = current_data[253];
      const auto axxxxx_0 = current_data[294];
      const auto axxxxy_0 = current_data[295];
      const auto axxxyy_0 = current_data[296];
      const auto axxyyy_0 = current_data[297];
      const auto axyyyy_0 = current_data[298];
      const auto ayyyyy_0 = current_data[299];
      const auto axxxxz_0 = current_data[306];
      const auto axxxyz_0 = current_data[307];
      const auto axxyyz_0 = current_data[308];
      const auto axyyyz_0 = current_data[309];
      const auto ayyyyz_0 = current_data[310];
      const auto axxxzz_0 = current_data[317];
      const auto axxyzz_0 = current_data[318];
      const auto axyyzz_0 = current_data[319];
      const auto ayyyzz_0 = current_data[320];
      const auto axxzzz_0 = current_data[327];
      const auto axyzzz_0 = current_data[328];
      const auto ayyzzz_0 = current_data[329];
      const auto axzzzz_0 = current_data[336];
      const auto ayzzzz_0 = current_data[337];
      const auto azzzzz_0 = current_data[344];
      const auto axxxxxx_0 = current_data[386];
      const auto axxxxxy_0 = current_data[387];
      const auto axxxxyy_0 = current_data[388];
      const auto axxxyyy_0 = current_data[389];
      const auto axxyyyy_0 = current_data[390];
      const auto axyyyyy_0 = current_data[391];
      const auto ayyyyyy_0 = current_data[392];
      const auto axxxxxz_0 = current_data[399];
      const auto axxxxyz_0 = current_data[400];
      const auto axxxyyz_0 = current_data[401];
      const auto axxyyyz_0 = current_data[402];
      const auto axyyyyz_0 = current_data[403];
      const auto ayyyyyz_0 = current_data[404];
      const auto axxxxzz_0 = current_data[411];
      const auto axxxyzz_0 = current_data[412];
      const auto axxyyzz_0 = current_data[413];
      const auto axyyyzz_0 = current_data[414];
      const auto ayyyyzz_0 = current_data[415];
      const auto axxxzzz_0 = current_data[422];
      const auto axxyzzz_0 = current_data[423];
      const auto axyyzzz_0 = current_data[424];
      const auto ayyyzzz_0 = current_data[425];
      const auto axxzzzz_0 = current_data[432];
      const auto axyzzzz_0 = current_data[433];
      const auto ayyzzzz_0 = current_data[434];
      const auto axzzzzz_0 = current_data[441];
      const auto ayzzzzz_0 = current_data[442];
      const auto azzzzzz_0 = current_data[449];
      const auto axxxxxxx_0 = current_data[492];
      const auto axxxxxxy_0 = current_data[493];
      const auto axxxxxyy_0 = current_data[494];
      const auto axxxxyyy_0 = current_data[495];
      const auto axxxyyyy_0 = current_data[496];
      const auto axxyyyyy_0 = current_data[497];
      const auto axyyyyyy_0 = current_data[498];
      const auto ayyyyyyy_0 = current_data[499];
      const auto axxxxxxz_0 = current_data[506];
      const auto axxxxxyz_0 = current_data[507];
      const auto axxxxyyz_0 = current_data[508];
      const auto axxxyyyz_0 = current_data[509];
      const auto axxyyyyz_0 = current_data[510];
      const auto axyyyyyz_0 = current_data[511];
      const auto ayyyyyyz_0 = current_data[512];
      const auto axxxxxzz_0 = current_data[519];
      const auto axxxxyzz_0 = current_data[520];
      const auto axxxyyzz_0 = current_data[521];
      const auto axxyyyzz_0 = current_data[522];
      const auto axyyyyzz_0 = current_data[523];
      const auto ayyyyyzz_0 = current_data[524];
      const auto axxxxzzz_0 = current_data[531];
      const auto axxxyzzz_0 = current_data[532];
      const auto axxyyzzz_0 = current_data[533];
      const auto axyyyzzz_0 = current_data[534];
      const auto ayyyyzzz_0 = current_data[535];
      const auto axxxzzzz_0 = current_data[542];
      const auto axxyzzzz_0 = current_data[543];
      const auto axyyzzzz_0 = current_data[544];
      const auto ayyyzzzz_0 = current_data[545];
      const auto axxzzzzz_0 = current_data[552];
      const auto axyzzzzz_0 = current_data[553];
      const auto ayyzzzzz_0 = current_data[554];
      const auto axzzzzzz_0 = current_data[561];
      const auto ayzzzzzz_0 = current_data[562];
      const auto azzzzzzz_0 = current_data[569];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[324] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[325] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[326] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[327] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[328] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[329] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[330] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[331] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[332] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[333] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[334] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[335] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[336] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[337] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[338] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[339] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[340] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[341] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[342] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[343] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[344] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[345] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[346] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[347] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[348] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[349] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[350] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[351] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[352] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[353] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[354] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[355] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[356] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[357] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[358] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[359] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[47];
      const auto ay_0 = current_data[48];
      const auto az_0 = current_data[55];
      const auto axx_0 = current_data[93];
      const auto axy_0 = current_data[94];
      const auto ayy_0 = current_data[95];
      const auto axz_0 = current_data[102];
      const auto ayz_0 = current_data[103];
      const auto azz_0 = current_data[110];
      const auto axxx_0 = current_data[149];
      const auto axxy_0 = current_data[150];
      const auto axyy_0 = current_data[151];
      const auto ayyy_0 = current_data[152];
      const auto axxz_0 = current_data[159];
      const auto axyz_0 = current_data[160];
      const auto ayyz_0 = current_data[161];
      const auto axzz_0 = current_data[168];
      const auto ayzz_0 = current_data[169];
      const auto azzz_0 = current_data[176];
      const auto axxxx_0 = current_data[216];
      const auto axxxy_0 = current_data[217];
      const auto axxyy_0 = current_data[218];
      const auto axyyy_0 = current_data[219];
      const auto ayyyy_0 = current_data[220];
      const auto axxxz_0 = current_data[227];
      const auto axxyz_0 = current_data[228];
      const auto axyyz_0 = current_data[229];
      const auto ayyyz_0 = current_data[230];
      const auto axxzz_0 = current_data[237];
      const auto axyzz_0 = current_data[238];
      const auto ayyzz_0 = current_data[239];
      const auto axzzz_0 = current_data[246];
      const auto ayzzz_0 = current_data[247];
      const auto azzzz_0 = current_data[254];
      const auto axxxxx_0 = current_data[295];
      const auto axxxxy_0 = current_data[296];
      const auto axxxyy_0 = current_data[297];
      const auto axxyyy_0 = current_data[298];
      const auto axyyyy_0 = current_data[299];
      const auto ayyyyy_0 = current_data[300];
      const auto axxxxz_0 = current_data[307];
      const auto axxxyz_0 = current_data[308];
      const auto axxyyz_0 = current_data[309];
      const auto axyyyz_0 = current_data[310];
      const auto ayyyyz_0 = current_data[311];
      const auto axxxzz_0 = current_data[318];
      const auto axxyzz_0 = current_data[319];
      const auto axyyzz_0 = current_data[320];
      const auto ayyyzz_0 = current_data[321];
      const auto axxzzz_0 = current_data[328];
      const auto axyzzz_0 = current_data[329];
      const auto ayyzzz_0 = current_data[330];
      const auto axzzzz_0 = current_data[337];
      const auto ayzzzz_0 = current_data[338];
      const auto azzzzz_0 = current_data[345];
      const auto axxxxxx_0 = current_data[387];
      const auto axxxxxy_0 = current_data[388];
      const auto axxxxyy_0 = current_data[389];
      const auto axxxyyy_0 = current_data[390];
      const auto axxyyyy_0 = current_data[391];
      const auto axyyyyy_0 = current_data[392];
      const auto ayyyyyy_0 = current_data[393];
      const auto axxxxxz_0 = current_data[400];
      const auto axxxxyz_0 = current_data[401];
      const auto axxxyyz_0 = current_data[402];
      const auto axxyyyz_0 = current_data[403];
      const auto axyyyyz_0 = current_data[404];
      const auto ayyyyyz_0 = current_data[405];
      const auto axxxxzz_0 = current_data[412];
      const auto axxxyzz_0 = current_data[413];
      const auto axxyyzz_0 = current_data[414];
      const auto axyyyzz_0 = current_data[415];
      const auto ayyyyzz_0 = current_data[416];
      const auto axxxzzz_0 = current_data[423];
      const auto axxyzzz_0 = current_data[424];
      const auto axyyzzz_0 = current_data[425];
      const auto ayyyzzz_0 = current_data[426];
      const auto axxzzzz_0 = current_data[433];
      const auto axyzzzz_0 = current_data[434];
      const auto ayyzzzz_0 = current_data[435];
      const auto axzzzzz_0 = current_data[442];
      const auto ayzzzzz_0 = current_data[443];
      const auto azzzzzz_0 = current_data[450];
      const auto axxxxxxx_0 = current_data[493];
      const auto axxxxxxy_0 = current_data[494];
      const auto axxxxxyy_0 = current_data[495];
      const auto axxxxyyy_0 = current_data[496];
      const auto axxxyyyy_0 = current_data[497];
      const auto axxyyyyy_0 = current_data[498];
      const auto axyyyyyy_0 = current_data[499];
      const auto ayyyyyyy_0 = current_data[500];
      const auto axxxxxxz_0 = current_data[507];
      const auto axxxxxyz_0 = current_data[508];
      const auto axxxxyyz_0 = current_data[509];
      const auto axxxyyyz_0 = current_data[510];
      const auto axxyyyyz_0 = current_data[511];
      const auto axyyyyyz_0 = current_data[512];
      const auto ayyyyyyz_0 = current_data[513];
      const auto axxxxxzz_0 = current_data[520];
      const auto axxxxyzz_0 = current_data[521];
      const auto axxxyyzz_0 = current_data[522];
      const auto axxyyyzz_0 = current_data[523];
      const auto axyyyyzz_0 = current_data[524];
      const auto ayyyyyzz_0 = current_data[525];
      const auto axxxxzzz_0 = current_data[532];
      const auto axxxyzzz_0 = current_data[533];
      const auto axxyyzzz_0 = current_data[534];
      const auto axyyyzzz_0 = current_data[535];
      const auto ayyyyzzz_0 = current_data[536];
      const auto axxxzzzz_0 = current_data[543];
      const auto axxyzzzz_0 = current_data[544];
      const auto axyyzzzz_0 = current_data[545];
      const auto ayyyzzzz_0 = current_data[546];
      const auto axxzzzzz_0 = current_data[553];
      const auto axyzzzzz_0 = current_data[554];
      const auto ayyzzzzz_0 = current_data[555];
      const auto axzzzzzz_0 = current_data[562];
      const auto ayzzzzzz_0 = current_data[563];
      const auto azzzzzzz_0 = current_data[570];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[360] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[361] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[362] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[363] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[364] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[365] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[366] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[367] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[368] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[369] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[370] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[371] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[372] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[373] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[374] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[375] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[376] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[377] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[378] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[379] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[380] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[381] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[382] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[383] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[384] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[385] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[386] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[387] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[388] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[389] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[390] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[391] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[392] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[393] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[394] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[395] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[48];
      const auto ay_0 = current_data[49];
      const auto az_0 = current_data[56];
      const auto axx_0 = current_data[94];
      const auto axy_0 = current_data[95];
      const auto ayy_0 = current_data[96];
      const auto axz_0 = current_data[103];
      const auto ayz_0 = current_data[104];
      const auto azz_0 = current_data[111];
      const auto axxx_0 = current_data[150];
      const auto axxy_0 = current_data[151];
      const auto axyy_0 = current_data[152];
      const auto ayyy_0 = current_data[153];
      const auto axxz_0 = current_data[160];
      const auto axyz_0 = current_data[161];
      const auto ayyz_0 = current_data[162];
      const auto axzz_0 = current_data[169];
      const auto ayzz_0 = current_data[170];
      const auto azzz_0 = current_data[177];
      const auto axxxx_0 = current_data[217];
      const auto axxxy_0 = current_data[218];
      const auto axxyy_0 = current_data[219];
      const auto axyyy_0 = current_data[220];
      const auto ayyyy_0 = current_data[221];
      const auto axxxz_0 = current_data[228];
      const auto axxyz_0 = current_data[229];
      const auto axyyz_0 = current_data[230];
      const auto ayyyz_0 = current_data[231];
      const auto axxzz_0 = current_data[238];
      const auto axyzz_0 = current_data[239];
      const auto ayyzz_0 = current_data[240];
      const auto axzzz_0 = current_data[247];
      const auto ayzzz_0 = current_data[248];
      const auto azzzz_0 = current_data[255];
      const auto axxxxx_0 = current_data[296];
      const auto axxxxy_0 = current_data[297];
      const auto axxxyy_0 = current_data[298];
      const auto axxyyy_0 = current_data[299];
      const auto axyyyy_0 = current_data[300];
      const auto ayyyyy_0 = current_data[301];
      const auto axxxxz_0 = current_data[308];
      const auto axxxyz_0 = current_data[309];
      const auto axxyyz_0 = current_data[310];
      const auto axyyyz_0 = current_data[311];
      const auto ayyyyz_0 = current_data[312];
      const auto axxxzz_0 = current_data[319];
      const auto axxyzz_0 = current_data[320];
      const auto axyyzz_0 = current_data[321];
      const auto ayyyzz_0 = current_data[322];
      const auto axxzzz_0 = current_data[329];
      const auto axyzzz_0 = current_data[330];
      const auto ayyzzz_0 = current_data[331];
      const auto axzzzz_0 = current_data[338];
      const auto ayzzzz_0 = current_data[339];
      const auto azzzzz_0 = current_data[346];
      const auto axxxxxx_0 = current_data[388];
      const auto axxxxxy_0 = current_data[389];
      const auto axxxxyy_0 = current_data[390];
      const auto axxxyyy_0 = current_data[391];
      const auto axxyyyy_0 = current_data[392];
      const auto axyyyyy_0 = current_data[393];
      const auto ayyyyyy_0 = current_data[394];
      const auto axxxxxz_0 = current_data[401];
      const auto axxxxyz_0 = current_data[402];
      const auto axxxyyz_0 = current_data[403];
      const auto axxyyyz_0 = current_data[404];
      const auto axyyyyz_0 = current_data[405];
      const auto ayyyyyz_0 = current_data[406];
      const auto axxxxzz_0 = current_data[413];
      const auto axxxyzz_0 = current_data[414];
      const auto axxyyzz_0 = current_data[415];
      const auto axyyyzz_0 = current_data[416];
      const auto ayyyyzz_0 = current_data[417];
      const auto axxxzzz_0 = current_data[424];
      const auto axxyzzz_0 = current_data[425];
      const auto axyyzzz_0 = current_data[426];
      const auto ayyyzzz_0 = current_data[427];
      const auto axxzzzz_0 = current_data[434];
      const auto axyzzzz_0 = current_data[435];
      const auto ayyzzzz_0 = current_data[436];
      const auto axzzzzz_0 = current_data[443];
      const auto ayzzzzz_0 = current_data[444];
      const auto azzzzzz_0 = current_data[451];
      const auto axxxxxxx_0 = current_data[494];
      const auto axxxxxxy_0 = current_data[495];
      const auto axxxxxyy_0 = current_data[496];
      const auto axxxxyyy_0 = current_data[497];
      const auto axxxyyyy_0 = current_data[498];
      const auto axxyyyyy_0 = current_data[499];
      const auto axyyyyyy_0 = current_data[500];
      const auto ayyyyyyy_0 = current_data[501];
      const auto axxxxxxz_0 = current_data[508];
      const auto axxxxxyz_0 = current_data[509];
      const auto axxxxyyz_0 = current_data[510];
      const auto axxxyyyz_0 = current_data[511];
      const auto axxyyyyz_0 = current_data[512];
      const auto axyyyyyz_0 = current_data[513];
      const auto ayyyyyyz_0 = current_data[514];
      const auto axxxxxzz_0 = current_data[521];
      const auto axxxxyzz_0 = current_data[522];
      const auto axxxyyzz_0 = current_data[523];
      const auto axxyyyzz_0 = current_data[524];
      const auto axyyyyzz_0 = current_data[525];
      const auto ayyyyyzz_0 = current_data[526];
      const auto axxxxzzz_0 = current_data[533];
      const auto axxxyzzz_0 = current_data[534];
      const auto axxyyzzz_0 = current_data[535];
      const auto axyyyzzz_0 = current_data[536];
      const auto ayyyyzzz_0 = current_data[537];
      const auto axxxzzzz_0 = current_data[544];
      const auto axxyzzzz_0 = current_data[545];
      const auto axyyzzzz_0 = current_data[546];
      const auto ayyyzzzz_0 = current_data[547];
      const auto axxzzzzz_0 = current_data[554];
      const auto axyzzzzz_0 = current_data[555];
      const auto ayyzzzzz_0 = current_data[556];
      const auto axzzzzzz_0 = current_data[563];
      const auto ayzzzzzz_0 = current_data[564];
      const auto azzzzzzz_0 = current_data[571];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[396] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[397] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[398] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[399] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[400] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[401] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[402] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[403] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[404] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[405] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[406] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[407] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[408] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[409] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[410] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[411] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[412] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[413] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[414] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[415] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[416] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[417] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[418] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[419] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[420] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[421] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[422] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[423] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[424] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[425] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[426] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[427] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[428] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[429] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[430] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[431] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[49];
      const auto ay_0 = current_data[50];
      const auto az_0 = current_data[57];
      const auto axx_0 = current_data[95];
      const auto axy_0 = current_data[96];
      const auto ayy_0 = current_data[97];
      const auto axz_0 = current_data[104];
      const auto ayz_0 = current_data[105];
      const auto azz_0 = current_data[112];
      const auto axxx_0 = current_data[151];
      const auto axxy_0 = current_data[152];
      const auto axyy_0 = current_data[153];
      const auto ayyy_0 = current_data[154];
      const auto axxz_0 = current_data[161];
      const auto axyz_0 = current_data[162];
      const auto ayyz_0 = current_data[163];
      const auto axzz_0 = current_data[170];
      const auto ayzz_0 = current_data[171];
      const auto azzz_0 = current_data[178];
      const auto axxxx_0 = current_data[218];
      const auto axxxy_0 = current_data[219];
      const auto axxyy_0 = current_data[220];
      const auto axyyy_0 = current_data[221];
      const auto ayyyy_0 = current_data[222];
      const auto axxxz_0 = current_data[229];
      const auto axxyz_0 = current_data[230];
      const auto axyyz_0 = current_data[231];
      const auto ayyyz_0 = current_data[232];
      const auto axxzz_0 = current_data[239];
      const auto axyzz_0 = current_data[240];
      const auto ayyzz_0 = current_data[241];
      const auto axzzz_0 = current_data[248];
      const auto ayzzz_0 = current_data[249];
      const auto azzzz_0 = current_data[256];
      const auto axxxxx_0 = current_data[297];
      const auto axxxxy_0 = current_data[298];
      const auto axxxyy_0 = current_data[299];
      const auto axxyyy_0 = current_data[300];
      const auto axyyyy_0 = current_data[301];
      const auto ayyyyy_0 = current_data[302];
      const auto axxxxz_0 = current_data[309];
      const auto axxxyz_0 = current_data[310];
      const auto axxyyz_0 = current_data[311];
      const auto axyyyz_0 = current_data[312];
      const auto ayyyyz_0 = current_data[313];
      const auto axxxzz_0 = current_data[320];
      const auto axxyzz_0 = current_data[321];
      const auto axyyzz_0 = current_data[322];
      const auto ayyyzz_0 = current_data[323];
      const auto axxzzz_0 = current_data[330];
      const auto axyzzz_0 = current_data[331];
      const auto ayyzzz_0 = current_data[332];
      const auto axzzzz_0 = current_data[339];
      const auto ayzzzz_0 = current_data[340];
      const auto azzzzz_0 = current_data[347];
      const auto axxxxxx_0 = current_data[389];
      const auto axxxxxy_0 = current_data[390];
      const auto axxxxyy_0 = current_data[391];
      const auto axxxyyy_0 = current_data[392];
      const auto axxyyyy_0 = current_data[393];
      const auto axyyyyy_0 = current_data[394];
      const auto ayyyyyy_0 = current_data[395];
      const auto axxxxxz_0 = current_data[402];
      const auto axxxxyz_0 = current_data[403];
      const auto axxxyyz_0 = current_data[404];
      const auto axxyyyz_0 = current_data[405];
      const auto axyyyyz_0 = current_data[406];
      const auto ayyyyyz_0 = current_data[407];
      const auto axxxxzz_0 = current_data[414];
      const auto axxxyzz_0 = current_data[415];
      const auto axxyyzz_0 = current_data[416];
      const auto axyyyzz_0 = current_data[417];
      const auto ayyyyzz_0 = current_data[418];
      const auto axxxzzz_0 = current_data[425];
      const auto axxyzzz_0 = current_data[426];
      const auto axyyzzz_0 = current_data[427];
      const auto ayyyzzz_0 = current_data[428];
      const auto axxzzzz_0 = current_data[435];
      const auto axyzzzz_0 = current_data[436];
      const auto ayyzzzz_0 = current_data[437];
      const auto axzzzzz_0 = current_data[444];
      const auto ayzzzzz_0 = current_data[445];
      const auto azzzzzz_0 = current_data[452];
      const auto axxxxxxx_0 = current_data[495];
      const auto axxxxxxy_0 = current_data[496];
      const auto axxxxxyy_0 = current_data[497];
      const auto axxxxyyy_0 = current_data[498];
      const auto axxxyyyy_0 = current_data[499];
      const auto axxyyyyy_0 = current_data[500];
      const auto axyyyyyy_0 = current_data[501];
      const auto ayyyyyyy_0 = current_data[502];
      const auto axxxxxxz_0 = current_data[509];
      const auto axxxxxyz_0 = current_data[510];
      const auto axxxxyyz_0 = current_data[511];
      const auto axxxyyyz_0 = current_data[512];
      const auto axxyyyyz_0 = current_data[513];
      const auto axyyyyyz_0 = current_data[514];
      const auto ayyyyyyz_0 = current_data[515];
      const auto axxxxxzz_0 = current_data[522];
      const auto axxxxyzz_0 = current_data[523];
      const auto axxxyyzz_0 = current_data[524];
      const auto axxyyyzz_0 = current_data[525];
      const auto axyyyyzz_0 = current_data[526];
      const auto ayyyyyzz_0 = current_data[527];
      const auto axxxxzzz_0 = current_data[534];
      const auto axxxyzzz_0 = current_data[535];
      const auto axxyyzzz_0 = current_data[536];
      const auto axyyyzzz_0 = current_data[537];
      const auto ayyyyzzz_0 = current_data[538];
      const auto axxxzzzz_0 = current_data[545];
      const auto axxyzzzz_0 = current_data[546];
      const auto axyyzzzz_0 = current_data[547];
      const auto ayyyzzzz_0 = current_data[548];
      const auto axxzzzzz_0 = current_data[555];
      const auto axyzzzzz_0 = current_data[556];
      const auto ayyzzzzz_0 = current_data[557];
      const auto axzzzzzz_0 = current_data[564];
      const auto ayzzzzzz_0 = current_data[565];
      const auto azzzzzzz_0 = current_data[572];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[432] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[433] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[434] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[435] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[436] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[437] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[438] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[439] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[440] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[441] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[442] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[443] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[444] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[445] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[446] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[447] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[448] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[449] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[450] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[451] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[452] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[453] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[454] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[455] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[456] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[457] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[458] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[459] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[460] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[461] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[462] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[463] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[464] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[465] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[466] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[467] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xyyyyyz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[50];
      const auto ay_0 = current_data[51];
      const auto az_0 = current_data[58];
      const auto axx_0 = current_data[96];
      const auto axy_0 = current_data[97];
      const auto ayy_0 = current_data[98];
      const auto axz_0 = current_data[105];
      const auto ayz_0 = current_data[106];
      const auto azz_0 = current_data[113];
      const auto axxx_0 = current_data[152];
      const auto axxy_0 = current_data[153];
      const auto axyy_0 = current_data[154];
      const auto ayyy_0 = current_data[155];
      const auto axxz_0 = current_data[162];
      const auto axyz_0 = current_data[163];
      const auto ayyz_0 = current_data[164];
      const auto axzz_0 = current_data[171];
      const auto ayzz_0 = current_data[172];
      const auto azzz_0 = current_data[179];
      const auto axxxx_0 = current_data[219];
      const auto axxxy_0 = current_data[220];
      const auto axxyy_0 = current_data[221];
      const auto axyyy_0 = current_data[222];
      const auto ayyyy_0 = current_data[223];
      const auto axxxz_0 = current_data[230];
      const auto axxyz_0 = current_data[231];
      const auto axyyz_0 = current_data[232];
      const auto ayyyz_0 = current_data[233];
      const auto axxzz_0 = current_data[240];
      const auto axyzz_0 = current_data[241];
      const auto ayyzz_0 = current_data[242];
      const auto axzzz_0 = current_data[249];
      const auto ayzzz_0 = current_data[250];
      const auto azzzz_0 = current_data[257];
      const auto axxxxx_0 = current_data[298];
      const auto axxxxy_0 = current_data[299];
      const auto axxxyy_0 = current_data[300];
      const auto axxyyy_0 = current_data[301];
      const auto axyyyy_0 = current_data[302];
      const auto ayyyyy_0 = current_data[303];
      const auto axxxxz_0 = current_data[310];
      const auto axxxyz_0 = current_data[311];
      const auto axxyyz_0 = current_data[312];
      const auto axyyyz_0 = current_data[313];
      const auto ayyyyz_0 = current_data[314];
      const auto axxxzz_0 = current_data[321];
      const auto axxyzz_0 = current_data[322];
      const auto axyyzz_0 = current_data[323];
      const auto ayyyzz_0 = current_data[324];
      const auto axxzzz_0 = current_data[331];
      const auto axyzzz_0 = current_data[332];
      const auto ayyzzz_0 = current_data[333];
      const auto axzzzz_0 = current_data[340];
      const auto ayzzzz_0 = current_data[341];
      const auto azzzzz_0 = current_data[348];
      const auto axxxxxx_0 = current_data[390];
      const auto axxxxxy_0 = current_data[391];
      const auto axxxxyy_0 = current_data[392];
      const auto axxxyyy_0 = current_data[393];
      const auto axxyyyy_0 = current_data[394];
      const auto axyyyyy_0 = current_data[395];
      const auto ayyyyyy_0 = current_data[396];
      const auto axxxxxz_0 = current_data[403];
      const auto axxxxyz_0 = current_data[404];
      const auto axxxyyz_0 = current_data[405];
      const auto axxyyyz_0 = current_data[406];
      const auto axyyyyz_0 = current_data[407];
      const auto ayyyyyz_0 = current_data[408];
      const auto axxxxzz_0 = current_data[415];
      const auto axxxyzz_0 = current_data[416];
      const auto axxyyzz_0 = current_data[417];
      const auto axyyyzz_0 = current_data[418];
      const auto ayyyyzz_0 = current_data[419];
      const auto axxxzzz_0 = current_data[426];
      const auto axxyzzz_0 = current_data[427];
      const auto axyyzzz_0 = current_data[428];
      const auto ayyyzzz_0 = current_data[429];
      const auto axxzzzz_0 = current_data[436];
      const auto axyzzzz_0 = current_data[437];
      const auto ayyzzzz_0 = current_data[438];
      const auto axzzzzz_0 = current_data[445];
      const auto ayzzzzz_0 = current_data[446];
      const auto azzzzzz_0 = current_data[453];
      const auto axxxxxxx_0 = current_data[496];
      const auto axxxxxxy_0 = current_data[497];
      const auto axxxxxyy_0 = current_data[498];
      const auto axxxxyyy_0 = current_data[499];
      const auto axxxyyyy_0 = current_data[500];
      const auto axxyyyyy_0 = current_data[501];
      const auto axyyyyyy_0 = current_data[502];
      const auto ayyyyyyy_0 = current_data[503];
      const auto axxxxxxz_0 = current_data[510];
      const auto axxxxxyz_0 = current_data[511];
      const auto axxxxyyz_0 = current_data[512];
      const auto axxxyyyz_0 = current_data[513];
      const auto axxyyyyz_0 = current_data[514];
      const auto axyyyyyz_0 = current_data[515];
      const auto ayyyyyyz_0 = current_data[516];
      const auto axxxxxzz_0 = current_data[523];
      const auto axxxxyzz_0 = current_data[524];
      const auto axxxyyzz_0 = current_data[525];
      const auto axxyyyzz_0 = current_data[526];
      const auto axyyyyzz_0 = current_data[527];
      const auto ayyyyyzz_0 = current_data[528];
      const auto axxxxzzz_0 = current_data[535];
      const auto axxxyzzz_0 = current_data[536];
      const auto axxyyzzz_0 = current_data[537];
      const auto axyyyzzz_0 = current_data[538];
      const auto ayyyyzzz_0 = current_data[539];
      const auto axxxzzzz_0 = current_data[546];
      const auto axxyzzzz_0 = current_data[547];
      const auto axyyzzzz_0 = current_data[548];
      const auto ayyyzzzz_0 = current_data[549];
      const auto axxzzzzz_0 = current_data[556];
      const auto axyzzzzz_0 = current_data[557];
      const auto ayyzzzzz_0 = current_data[558];
      const auto axzzzzzz_0 = current_data[565];
      const auto ayzzzzzz_0 = current_data[566];
      const auto azzzzzzz_0 = current_data[573];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[468] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[469] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[470] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[471] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[472] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[473] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[474] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[475] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[476] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[477] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[478] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[479] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[480] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[481] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[482] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[483] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[484] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[485] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[486] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[487] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[488] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[489] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[490] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[491] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[492] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[493] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[494] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[495] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[496] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[497] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[498] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[499] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[500] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[501] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[502] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[503] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: yyyyyyz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[51];
      const auto ay_0 = current_data[52];
      const auto az_0 = current_data[59];
      const auto axx_0 = current_data[97];
      const auto axy_0 = current_data[98];
      const auto ayy_0 = current_data[99];
      const auto axz_0 = current_data[106];
      const auto ayz_0 = current_data[107];
      const auto azz_0 = current_data[114];
      const auto axxx_0 = current_data[153];
      const auto axxy_0 = current_data[154];
      const auto axyy_0 = current_data[155];
      const auto ayyy_0 = current_data[156];
      const auto axxz_0 = current_data[163];
      const auto axyz_0 = current_data[164];
      const auto ayyz_0 = current_data[165];
      const auto axzz_0 = current_data[172];
      const auto ayzz_0 = current_data[173];
      const auto azzz_0 = current_data[180];
      const auto axxxx_0 = current_data[220];
      const auto axxxy_0 = current_data[221];
      const auto axxyy_0 = current_data[222];
      const auto axyyy_0 = current_data[223];
      const auto ayyyy_0 = current_data[224];
      const auto axxxz_0 = current_data[231];
      const auto axxyz_0 = current_data[232];
      const auto axyyz_0 = current_data[233];
      const auto ayyyz_0 = current_data[234];
      const auto axxzz_0 = current_data[241];
      const auto axyzz_0 = current_data[242];
      const auto ayyzz_0 = current_data[243];
      const auto axzzz_0 = current_data[250];
      const auto ayzzz_0 = current_data[251];
      const auto azzzz_0 = current_data[258];
      const auto axxxxx_0 = current_data[299];
      const auto axxxxy_0 = current_data[300];
      const auto axxxyy_0 = current_data[301];
      const auto axxyyy_0 = current_data[302];
      const auto axyyyy_0 = current_data[303];
      const auto ayyyyy_0 = current_data[304];
      const auto axxxxz_0 = current_data[311];
      const auto axxxyz_0 = current_data[312];
      const auto axxyyz_0 = current_data[313];
      const auto axyyyz_0 = current_data[314];
      const auto ayyyyz_0 = current_data[315];
      const auto axxxzz_0 = current_data[322];
      const auto axxyzz_0 = current_data[323];
      const auto axyyzz_0 = current_data[324];
      const auto ayyyzz_0 = current_data[325];
      const auto axxzzz_0 = current_data[332];
      const auto axyzzz_0 = current_data[333];
      const auto ayyzzz_0 = current_data[334];
      const auto axzzzz_0 = current_data[341];
      const auto ayzzzz_0 = current_data[342];
      const auto azzzzz_0 = current_data[349];
      const auto axxxxxx_0 = current_data[391];
      const auto axxxxxy_0 = current_data[392];
      const auto axxxxyy_0 = current_data[393];
      const auto axxxyyy_0 = current_data[394];
      const auto axxyyyy_0 = current_data[395];
      const auto axyyyyy_0 = current_data[396];
      const auto ayyyyyy_0 = current_data[397];
      const auto axxxxxz_0 = current_data[404];
      const auto axxxxyz_0 = current_data[405];
      const auto axxxyyz_0 = current_data[406];
      const auto axxyyyz_0 = current_data[407];
      const auto axyyyyz_0 = current_data[408];
      const auto ayyyyyz_0 = current_data[409];
      const auto axxxxzz_0 = current_data[416];
      const auto axxxyzz_0 = current_data[417];
      const auto axxyyzz_0 = current_data[418];
      const auto axyyyzz_0 = current_data[419];
      const auto ayyyyzz_0 = current_data[420];
      const auto axxxzzz_0 = current_data[427];
      const auto axxyzzz_0 = current_data[428];
      const auto axyyzzz_0 = current_data[429];
      const auto ayyyzzz_0 = current_data[430];
      const auto axxzzzz_0 = current_data[437];
      const auto axyzzzz_0 = current_data[438];
      const auto ayyzzzz_0 = current_data[439];
      const auto axzzzzz_0 = current_data[446];
      const auto ayzzzzz_0 = current_data[447];
      const auto azzzzzz_0 = current_data[454];
      const auto axxxxxxx_0 = current_data[497];
      const auto axxxxxxy_0 = current_data[498];
      const auto axxxxxyy_0 = current_data[499];
      const auto axxxxyyy_0 = current_data[500];
      const auto axxxyyyy_0 = current_data[501];
      const auto axxyyyyy_0 = current_data[502];
      const auto axyyyyyy_0 = current_data[503];
      const auto ayyyyyyy_0 = current_data[504];
      const auto axxxxxxz_0 = current_data[511];
      const auto axxxxxyz_0 = current_data[512];
      const auto axxxxyyz_0 = current_data[513];
      const auto axxxyyyz_0 = current_data[514];
      const auto axxyyyyz_0 = current_data[515];
      const auto axyyyyyz_0 = current_data[516];
      const auto ayyyyyyz_0 = current_data[517];
      const auto axxxxxzz_0 = current_data[524];
      const auto axxxxyzz_0 = current_data[525];
      const auto axxxyyzz_0 = current_data[526];
      const auto axxyyyzz_0 = current_data[527];
      const auto axyyyyzz_0 = current_data[528];
      const auto ayyyyyzz_0 = current_data[529];
      const auto axxxxzzz_0 = current_data[536];
      const auto axxxyzzz_0 = current_data[537];
      const auto axxyyzzz_0 = current_data[538];
      const auto axyyyzzz_0 = current_data[539];
      const auto ayyyyzzz_0 = current_data[540];
      const auto axxxzzzz_0 = current_data[547];
      const auto axxyzzzz_0 = current_data[548];
      const auto axyyzzzz_0 = current_data[549];
      const auto ayyyzzzz_0 = current_data[550];
      const auto axxzzzzz_0 = current_data[557];
      const auto axyzzzzz_0 = current_data[558];
      const auto ayyzzzzz_0 = current_data[559];
      const auto axzzzzzz_0 = current_data[566];
      const auto ayzzzzzz_0 = current_data[567];
      const auto azzzzzzz_0 = current_data[574];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[504] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[505] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[506] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[507] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[508] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[509] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[510] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[511] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[512] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[513] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[514] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[515] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[516] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[517] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[518] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[519] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[520] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[521] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[522] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[523] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[524] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[525] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[526] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[527] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[528] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[529] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[530] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[531] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[532] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[533] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[534] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[535] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[536] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[537] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[538] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[539] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxxzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[53];
      const auto ay_0 = current_data[54];
      const auto az_0 = current_data[60];
      const auto axx_0 = current_data[100];
      const auto axy_0 = current_data[101];
      const auto ayy_0 = current_data[102];
      const auto axz_0 = current_data[108];
      const auto ayz_0 = current_data[109];
      const auto azz_0 = current_data[115];
      const auto axxx_0 = current_data[157];
      const auto axxy_0 = current_data[158];
      const auto axyy_0 = current_data[159];
      const auto ayyy_0 = current_data[160];
      const auto axxz_0 = current_data[166];
      const auto axyz_0 = current_data[167];
      const auto ayyz_0 = current_data[168];
      const auto axzz_0 = current_data[174];
      const auto ayzz_0 = current_data[175];
      const auto azzz_0 = current_data[181];
      const auto axxxx_0 = current_data[225];
      const auto axxxy_0 = current_data[226];
      const auto axxyy_0 = current_data[227];
      const auto axyyy_0 = current_data[228];
      const auto ayyyy_0 = current_data[229];
      const auto axxxz_0 = current_data[235];
      const auto axxyz_0 = current_data[236];
      const auto axyyz_0 = current_data[237];
      const auto ayyyz_0 = current_data[238];
      const auto axxzz_0 = current_data[244];
      const auto axyzz_0 = current_data[245];
      const auto ayyzz_0 = current_data[246];
      const auto axzzz_0 = current_data[252];
      const auto ayzzz_0 = current_data[253];
      const auto azzzz_0 = current_data[259];
      const auto axxxxx_0 = current_data[305];
      const auto axxxxy_0 = current_data[306];
      const auto axxxyy_0 = current_data[307];
      const auto axxyyy_0 = current_data[308];
      const auto axyyyy_0 = current_data[309];
      const auto ayyyyy_0 = current_data[310];
      const auto axxxxz_0 = current_data[316];
      const auto axxxyz_0 = current_data[317];
      const auto axxyyz_0 = current_data[318];
      const auto axyyyz_0 = current_data[319];
      const auto ayyyyz_0 = current_data[320];
      const auto axxxzz_0 = current_data[326];
      const auto axxyzz_0 = current_data[327];
      const auto axyyzz_0 = current_data[328];
      const auto ayyyzz_0 = current_data[329];
      const auto axxzzz_0 = current_data[335];
      const auto axyzzz_0 = current_data[336];
      const auto ayyzzz_0 = current_data[337];
      const auto axzzzz_0 = current_data[343];
      const auto ayzzzz_0 = current_data[344];
      const auto azzzzz_0 = current_data[350];
      const auto axxxxxx_0 = current_data[398];
      const auto axxxxxy_0 = current_data[399];
      const auto axxxxyy_0 = current_data[400];
      const auto axxxyyy_0 = current_data[401];
      const auto axxyyyy_0 = current_data[402];
      const auto axyyyyy_0 = current_data[403];
      const auto ayyyyyy_0 = current_data[404];
      const auto axxxxxz_0 = current_data[410];
      const auto axxxxyz_0 = current_data[411];
      const auto axxxyyz_0 = current_data[412];
      const auto axxyyyz_0 = current_data[413];
      const auto axyyyyz_0 = current_data[414];
      const auto ayyyyyz_0 = current_data[415];
      const auto axxxxzz_0 = current_data[421];
      const auto axxxyzz_0 = current_data[422];
      const auto axxyyzz_0 = current_data[423];
      const auto axyyyzz_0 = current_data[424];
      const auto ayyyyzz_0 = current_data[425];
      const auto axxxzzz_0 = current_data[431];
      const auto axxyzzz_0 = current_data[432];
      const auto axyyzzz_0 = current_data[433];
      const auto ayyyzzz_0 = current_data[434];
      const auto axxzzzz_0 = current_data[440];
      const auto axyzzzz_0 = current_data[441];
      const auto ayyzzzz_0 = current_data[442];
      const auto axzzzzz_0 = current_data[448];
      const auto ayzzzzz_0 = current_data[449];
      const auto azzzzzz_0 = current_data[455];
      const auto axxxxxxx_0 = current_data[505];
      const auto axxxxxxy_0 = current_data[506];
      const auto axxxxxyy_0 = current_data[507];
      const auto axxxxyyy_0 = current_data[508];
      const auto axxxyyyy_0 = current_data[509];
      const auto axxyyyyy_0 = current_data[510];
      const auto axyyyyyy_0 = current_data[511];
      const auto ayyyyyyy_0 = current_data[512];
      const auto axxxxxxz_0 = current_data[518];
      const auto axxxxxyz_0 = current_data[519];
      const auto axxxxyyz_0 = current_data[520];
      const auto axxxyyyz_0 = current_data[521];
      const auto axxyyyyz_0 = current_data[522];
      const auto axyyyyyz_0 = current_data[523];
      const auto ayyyyyyz_0 = current_data[524];
      const auto axxxxxzz_0 = current_data[530];
      const auto axxxxyzz_0 = current_data[531];
      const auto axxxyyzz_0 = current_data[532];
      const auto axxyyyzz_0 = current_data[533];
      const auto axyyyyzz_0 = current_data[534];
      const auto ayyyyyzz_0 = current_data[535];
      const auto axxxxzzz_0 = current_data[541];
      const auto axxxyzzz_0 = current_data[542];
      const auto axxyyzzz_0 = current_data[543];
      const auto axyyyzzz_0 = current_data[544];
      const auto ayyyyzzz_0 = current_data[545];
      const auto axxxzzzz_0 = current_data[551];
      const auto axxyzzzz_0 = current_data[552];
      const auto axyyzzzz_0 = current_data[553];
      const auto ayyyzzzz_0 = current_data[554];
      const auto axxzzzzz_0 = current_data[560];
      const auto axyzzzzz_0 = current_data[561];
      const auto ayyzzzzz_0 = current_data[562];
      const auto axzzzzzz_0 = current_data[568];
      const auto ayzzzzzz_0 = current_data[569];
      const auto azzzzzzz_0 = current_data[575];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[540] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[541] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[542] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[543] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[544] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[545] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[546] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[547] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[548] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[549] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[550] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[551] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[552] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[553] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[554] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[555] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[556] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[557] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[558] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[559] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[560] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[561] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[562] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[563] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[564] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[565] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[566] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[567] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[568] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[569] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[570] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[571] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[572] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[573] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[574] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[575] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxyzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[54];
      const auto ay_0 = current_data[55];
      const auto az_0 = current_data[61];
      const auto axx_0 = current_data[101];
      const auto axy_0 = current_data[102];
      const auto ayy_0 = current_data[103];
      const auto axz_0 = current_data[109];
      const auto ayz_0 = current_data[110];
      const auto azz_0 = current_data[116];
      const auto axxx_0 = current_data[158];
      const auto axxy_0 = current_data[159];
      const auto axyy_0 = current_data[160];
      const auto ayyy_0 = current_data[161];
      const auto axxz_0 = current_data[167];
      const auto axyz_0 = current_data[168];
      const auto ayyz_0 = current_data[169];
      const auto axzz_0 = current_data[175];
      const auto ayzz_0 = current_data[176];
      const auto azzz_0 = current_data[182];
      const auto axxxx_0 = current_data[226];
      const auto axxxy_0 = current_data[227];
      const auto axxyy_0 = current_data[228];
      const auto axyyy_0 = current_data[229];
      const auto ayyyy_0 = current_data[230];
      const auto axxxz_0 = current_data[236];
      const auto axxyz_0 = current_data[237];
      const auto axyyz_0 = current_data[238];
      const auto ayyyz_0 = current_data[239];
      const auto axxzz_0 = current_data[245];
      const auto axyzz_0 = current_data[246];
      const auto ayyzz_0 = current_data[247];
      const auto axzzz_0 = current_data[253];
      const auto ayzzz_0 = current_data[254];
      const auto azzzz_0 = current_data[260];
      const auto axxxxx_0 = current_data[306];
      const auto axxxxy_0 = current_data[307];
      const auto axxxyy_0 = current_data[308];
      const auto axxyyy_0 = current_data[309];
      const auto axyyyy_0 = current_data[310];
      const auto ayyyyy_0 = current_data[311];
      const auto axxxxz_0 = current_data[317];
      const auto axxxyz_0 = current_data[318];
      const auto axxyyz_0 = current_data[319];
      const auto axyyyz_0 = current_data[320];
      const auto ayyyyz_0 = current_data[321];
      const auto axxxzz_0 = current_data[327];
      const auto axxyzz_0 = current_data[328];
      const auto axyyzz_0 = current_data[329];
      const auto ayyyzz_0 = current_data[330];
      const auto axxzzz_0 = current_data[336];
      const auto axyzzz_0 = current_data[337];
      const auto ayyzzz_0 = current_data[338];
      const auto axzzzz_0 = current_data[344];
      const auto ayzzzz_0 = current_data[345];
      const auto azzzzz_0 = current_data[351];
      const auto axxxxxx_0 = current_data[399];
      const auto axxxxxy_0 = current_data[400];
      const auto axxxxyy_0 = current_data[401];
      const auto axxxyyy_0 = current_data[402];
      const auto axxyyyy_0 = current_data[403];
      const auto axyyyyy_0 = current_data[404];
      const auto ayyyyyy_0 = current_data[405];
      const auto axxxxxz_0 = current_data[411];
      const auto axxxxyz_0 = current_data[412];
      const auto axxxyyz_0 = current_data[413];
      const auto axxyyyz_0 = current_data[414];
      const auto axyyyyz_0 = current_data[415];
      const auto ayyyyyz_0 = current_data[416];
      const auto axxxxzz_0 = current_data[422];
      const auto axxxyzz_0 = current_data[423];
      const auto axxyyzz_0 = current_data[424];
      const auto axyyyzz_0 = current_data[425];
      const auto ayyyyzz_0 = current_data[426];
      const auto axxxzzz_0 = current_data[432];
      const auto axxyzzz_0 = current_data[433];
      const auto axyyzzz_0 = current_data[434];
      const auto ayyyzzz_0 = current_data[435];
      const auto axxzzzz_0 = current_data[441];
      const auto axyzzzz_0 = current_data[442];
      const auto ayyzzzz_0 = current_data[443];
      const auto axzzzzz_0 = current_data[449];
      const auto ayzzzzz_0 = current_data[450];
      const auto azzzzzz_0 = current_data[456];
      const auto axxxxxxx_0 = current_data[506];
      const auto axxxxxxy_0 = current_data[507];
      const auto axxxxxyy_0 = current_data[508];
      const auto axxxxyyy_0 = current_data[509];
      const auto axxxyyyy_0 = current_data[510];
      const auto axxyyyyy_0 = current_data[511];
      const auto axyyyyyy_0 = current_data[512];
      const auto ayyyyyyy_0 = current_data[513];
      const auto axxxxxxz_0 = current_data[519];
      const auto axxxxxyz_0 = current_data[520];
      const auto axxxxyyz_0 = current_data[521];
      const auto axxxyyyz_0 = current_data[522];
      const auto axxyyyyz_0 = current_data[523];
      const auto axyyyyyz_0 = current_data[524];
      const auto ayyyyyyz_0 = current_data[525];
      const auto axxxxxzz_0 = current_data[531];
      const auto axxxxyzz_0 = current_data[532];
      const auto axxxyyzz_0 = current_data[533];
      const auto axxyyyzz_0 = current_data[534];
      const auto axyyyyzz_0 = current_data[535];
      const auto ayyyyyzz_0 = current_data[536];
      const auto axxxxzzz_0 = current_data[542];
      const auto axxxyzzz_0 = current_data[543];
      const auto axxyyzzz_0 = current_data[544];
      const auto axyyyzzz_0 = current_data[545];
      const auto ayyyyzzz_0 = current_data[546];
      const auto axxxzzzz_0 = current_data[552];
      const auto axxyzzzz_0 = current_data[553];
      const auto axyyzzzz_0 = current_data[554];
      const auto ayyyzzzz_0 = current_data[555];
      const auto axxzzzzz_0 = current_data[561];
      const auto axyzzzzz_0 = current_data[562];
      const auto ayyzzzzz_0 = current_data[563];
      const auto axzzzzzz_0 = current_data[569];
      const auto ayzzzzzz_0 = current_data[570];
      const auto azzzzzzz_0 = current_data[576];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[576] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[577] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[578] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[579] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[580] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[581] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[582] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[583] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[584] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[585] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[586] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[587] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[588] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[589] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[590] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[591] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[592] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[593] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[594] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[595] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[596] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[597] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[598] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[599] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[600] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[601] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[602] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[603] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[604] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[605] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[606] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[607] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[608] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[609] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[610] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[611] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxyyzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[55];
      const auto ay_0 = current_data[56];
      const auto az_0 = current_data[62];
      const auto axx_0 = current_data[102];
      const auto axy_0 = current_data[103];
      const auto ayy_0 = current_data[104];
      const auto axz_0 = current_data[110];
      const auto ayz_0 = current_data[111];
      const auto azz_0 = current_data[117];
      const auto axxx_0 = current_data[159];
      const auto axxy_0 = current_data[160];
      const auto axyy_0 = current_data[161];
      const auto ayyy_0 = current_data[162];
      const auto axxz_0 = current_data[168];
      const auto axyz_0 = current_data[169];
      const auto ayyz_0 = current_data[170];
      const auto axzz_0 = current_data[176];
      const auto ayzz_0 = current_data[177];
      const auto azzz_0 = current_data[183];
      const auto axxxx_0 = current_data[227];
      const auto axxxy_0 = current_data[228];
      const auto axxyy_0 = current_data[229];
      const auto axyyy_0 = current_data[230];
      const auto ayyyy_0 = current_data[231];
      const auto axxxz_0 = current_data[237];
      const auto axxyz_0 = current_data[238];
      const auto axyyz_0 = current_data[239];
      const auto ayyyz_0 = current_data[240];
      const auto axxzz_0 = current_data[246];
      const auto axyzz_0 = current_data[247];
      const auto ayyzz_0 = current_data[248];
      const auto axzzz_0 = current_data[254];
      const auto ayzzz_0 = current_data[255];
      const auto azzzz_0 = current_data[261];
      const auto axxxxx_0 = current_data[307];
      const auto axxxxy_0 = current_data[308];
      const auto axxxyy_0 = current_data[309];
      const auto axxyyy_0 = current_data[310];
      const auto axyyyy_0 = current_data[311];
      const auto ayyyyy_0 = current_data[312];
      const auto axxxxz_0 = current_data[318];
      const auto axxxyz_0 = current_data[319];
      const auto axxyyz_0 = current_data[320];
      const auto axyyyz_0 = current_data[321];
      const auto ayyyyz_0 = current_data[322];
      const auto axxxzz_0 = current_data[328];
      const auto axxyzz_0 = current_data[329];
      const auto axyyzz_0 = current_data[330];
      const auto ayyyzz_0 = current_data[331];
      const auto axxzzz_0 = current_data[337];
      const auto axyzzz_0 = current_data[338];
      const auto ayyzzz_0 = current_data[339];
      const auto axzzzz_0 = current_data[345];
      const auto ayzzzz_0 = current_data[346];
      const auto azzzzz_0 = current_data[352];
      const auto axxxxxx_0 = current_data[400];
      const auto axxxxxy_0 = current_data[401];
      const auto axxxxyy_0 = current_data[402];
      const auto axxxyyy_0 = current_data[403];
      const auto axxyyyy_0 = current_data[404];
      const auto axyyyyy_0 = current_data[405];
      const auto ayyyyyy_0 = current_data[406];
      const auto axxxxxz_0 = current_data[412];
      const auto axxxxyz_0 = current_data[413];
      const auto axxxyyz_0 = current_data[414];
      const auto axxyyyz_0 = current_data[415];
      const auto axyyyyz_0 = current_data[416];
      const auto ayyyyyz_0 = current_data[417];
      const auto axxxxzz_0 = current_data[423];
      const auto axxxyzz_0 = current_data[424];
      const auto axxyyzz_0 = current_data[425];
      const auto axyyyzz_0 = current_data[426];
      const auto ayyyyzz_0 = current_data[427];
      const auto axxxzzz_0 = current_data[433];
      const auto axxyzzz_0 = current_data[434];
      const auto axyyzzz_0 = current_data[435];
      const auto ayyyzzz_0 = current_data[436];
      const auto axxzzzz_0 = current_data[442];
      const auto axyzzzz_0 = current_data[443];
      const auto ayyzzzz_0 = current_data[444];
      const auto axzzzzz_0 = current_data[450];
      const auto ayzzzzz_0 = current_data[451];
      const auto azzzzzz_0 = current_data[457];
      const auto axxxxxxx_0 = current_data[507];
      const auto axxxxxxy_0 = current_data[508];
      const auto axxxxxyy_0 = current_data[509];
      const auto axxxxyyy_0 = current_data[510];
      const auto axxxyyyy_0 = current_data[511];
      const auto axxyyyyy_0 = current_data[512];
      const auto axyyyyyy_0 = current_data[513];
      const auto ayyyyyyy_0 = current_data[514];
      const auto axxxxxxz_0 = current_data[520];
      const auto axxxxxyz_0 = current_data[521];
      const auto axxxxyyz_0 = current_data[522];
      const auto axxxyyyz_0 = current_data[523];
      const auto axxyyyyz_0 = current_data[524];
      const auto axyyyyyz_0 = current_data[525];
      const auto ayyyyyyz_0 = current_data[526];
      const auto axxxxxzz_0 = current_data[532];
      const auto axxxxyzz_0 = current_data[533];
      const auto axxxyyzz_0 = current_data[534];
      const auto axxyyyzz_0 = current_data[535];
      const auto axyyyyzz_0 = current_data[536];
      const auto ayyyyyzz_0 = current_data[537];
      const auto axxxxzzz_0 = current_data[543];
      const auto axxxyzzz_0 = current_data[544];
      const auto axxyyzzz_0 = current_data[545];
      const auto axyyyzzz_0 = current_data[546];
      const auto ayyyyzzz_0 = current_data[547];
      const auto axxxzzzz_0 = current_data[553];
      const auto axxyzzzz_0 = current_data[554];
      const auto axyyzzzz_0 = current_data[555];
      const auto ayyyzzzz_0 = current_data[556];
      const auto axxzzzzz_0 = current_data[562];
      const auto axyzzzzz_0 = current_data[563];
      const auto ayyzzzzz_0 = current_data[564];
      const auto axzzzzzz_0 = current_data[570];
      const auto ayzzzzzz_0 = current_data[571];
      const auto azzzzzzz_0 = current_data[577];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[612] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[613] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[614] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[615] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[616] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[617] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[618] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[619] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[620] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[621] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[622] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[623] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[624] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[625] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[626] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[627] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[628] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[629] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[630] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[631] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[632] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[633] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[634] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[635] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[636] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[637] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[638] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[639] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[640] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[641] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[642] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[643] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[644] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[645] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[646] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[647] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxyyyzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[56];
      const auto ay_0 = current_data[57];
      const auto az_0 = current_data[63];
      const auto axx_0 = current_data[103];
      const auto axy_0 = current_data[104];
      const auto ayy_0 = current_data[105];
      const auto axz_0 = current_data[111];
      const auto ayz_0 = current_data[112];
      const auto azz_0 = current_data[118];
      const auto axxx_0 = current_data[160];
      const auto axxy_0 = current_data[161];
      const auto axyy_0 = current_data[162];
      const auto ayyy_0 = current_data[163];
      const auto axxz_0 = current_data[169];
      const auto axyz_0 = current_data[170];
      const auto ayyz_0 = current_data[171];
      const auto axzz_0 = current_data[177];
      const auto ayzz_0 = current_data[178];
      const auto azzz_0 = current_data[184];
      const auto axxxx_0 = current_data[228];
      const auto axxxy_0 = current_data[229];
      const auto axxyy_0 = current_data[230];
      const auto axyyy_0 = current_data[231];
      const auto ayyyy_0 = current_data[232];
      const auto axxxz_0 = current_data[238];
      const auto axxyz_0 = current_data[239];
      const auto axyyz_0 = current_data[240];
      const auto ayyyz_0 = current_data[241];
      const auto axxzz_0 = current_data[247];
      const auto axyzz_0 = current_data[248];
      const auto ayyzz_0 = current_data[249];
      const auto axzzz_0 = current_data[255];
      const auto ayzzz_0 = current_data[256];
      const auto azzzz_0 = current_data[262];
      const auto axxxxx_0 = current_data[308];
      const auto axxxxy_0 = current_data[309];
      const auto axxxyy_0 = current_data[310];
      const auto axxyyy_0 = current_data[311];
      const auto axyyyy_0 = current_data[312];
      const auto ayyyyy_0 = current_data[313];
      const auto axxxxz_0 = current_data[319];
      const auto axxxyz_0 = current_data[320];
      const auto axxyyz_0 = current_data[321];
      const auto axyyyz_0 = current_data[322];
      const auto ayyyyz_0 = current_data[323];
      const auto axxxzz_0 = current_data[329];
      const auto axxyzz_0 = current_data[330];
      const auto axyyzz_0 = current_data[331];
      const auto ayyyzz_0 = current_data[332];
      const auto axxzzz_0 = current_data[338];
      const auto axyzzz_0 = current_data[339];
      const auto ayyzzz_0 = current_data[340];
      const auto axzzzz_0 = current_data[346];
      const auto ayzzzz_0 = current_data[347];
      const auto azzzzz_0 = current_data[353];
      const auto axxxxxx_0 = current_data[401];
      const auto axxxxxy_0 = current_data[402];
      const auto axxxxyy_0 = current_data[403];
      const auto axxxyyy_0 = current_data[404];
      const auto axxyyyy_0 = current_data[405];
      const auto axyyyyy_0 = current_data[406];
      const auto ayyyyyy_0 = current_data[407];
      const auto axxxxxz_0 = current_data[413];
      const auto axxxxyz_0 = current_data[414];
      const auto axxxyyz_0 = current_data[415];
      const auto axxyyyz_0 = current_data[416];
      const auto axyyyyz_0 = current_data[417];
      const auto ayyyyyz_0 = current_data[418];
      const auto axxxxzz_0 = current_data[424];
      const auto axxxyzz_0 = current_data[425];
      const auto axxyyzz_0 = current_data[426];
      const auto axyyyzz_0 = current_data[427];
      const auto ayyyyzz_0 = current_data[428];
      const auto axxxzzz_0 = current_data[434];
      const auto axxyzzz_0 = current_data[435];
      const auto axyyzzz_0 = current_data[436];
      const auto ayyyzzz_0 = current_data[437];
      const auto axxzzzz_0 = current_data[443];
      const auto axyzzzz_0 = current_data[444];
      const auto ayyzzzz_0 = current_data[445];
      const auto axzzzzz_0 = current_data[451];
      const auto ayzzzzz_0 = current_data[452];
      const auto azzzzzz_0 = current_data[458];
      const auto axxxxxxx_0 = current_data[508];
      const auto axxxxxxy_0 = current_data[509];
      const auto axxxxxyy_0 = current_data[510];
      const auto axxxxyyy_0 = current_data[511];
      const auto axxxyyyy_0 = current_data[512];
      const auto axxyyyyy_0 = current_data[513];
      const auto axyyyyyy_0 = current_data[514];
      const auto ayyyyyyy_0 = current_data[515];
      const auto axxxxxxz_0 = current_data[521];
      const auto axxxxxyz_0 = current_data[522];
      const auto axxxxyyz_0 = current_data[523];
      const auto axxxyyyz_0 = current_data[524];
      const auto axxyyyyz_0 = current_data[525];
      const auto axyyyyyz_0 = current_data[526];
      const auto ayyyyyyz_0 = current_data[527];
      const auto axxxxxzz_0 = current_data[533];
      const auto axxxxyzz_0 = current_data[534];
      const auto axxxyyzz_0 = current_data[535];
      const auto axxyyyzz_0 = current_data[536];
      const auto axyyyyzz_0 = current_data[537];
      const auto ayyyyyzz_0 = current_data[538];
      const auto axxxxzzz_0 = current_data[544];
      const auto axxxyzzz_0 = current_data[545];
      const auto axxyyzzz_0 = current_data[546];
      const auto axyyyzzz_0 = current_data[547];
      const auto ayyyyzzz_0 = current_data[548];
      const auto axxxzzzz_0 = current_data[554];
      const auto axxyzzzz_0 = current_data[555];
      const auto axyyzzzz_0 = current_data[556];
      const auto ayyyzzzz_0 = current_data[557];
      const auto axxzzzzz_0 = current_data[563];
      const auto axyzzzzz_0 = current_data[564];
      const auto ayyzzzzz_0 = current_data[565];
      const auto axzzzzzz_0 = current_data[571];
      const auto ayzzzzzz_0 = current_data[572];
      const auto azzzzzzz_0 = current_data[578];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[648] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[649] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[650] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[651] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[652] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[653] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[654] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[655] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[656] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[657] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[658] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[659] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[660] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[661] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[662] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[663] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[664] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[665] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[666] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[667] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[668] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[669] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[670] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[671] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[672] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[673] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[674] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[675] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[676] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[677] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[678] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[679] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[680] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[681] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[682] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[683] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xyyyyzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[57];
      const auto ay_0 = current_data[58];
      const auto az_0 = current_data[64];
      const auto axx_0 = current_data[104];
      const auto axy_0 = current_data[105];
      const auto ayy_0 = current_data[106];
      const auto axz_0 = current_data[112];
      const auto ayz_0 = current_data[113];
      const auto azz_0 = current_data[119];
      const auto axxx_0 = current_data[161];
      const auto axxy_0 = current_data[162];
      const auto axyy_0 = current_data[163];
      const auto ayyy_0 = current_data[164];
      const auto axxz_0 = current_data[170];
      const auto axyz_0 = current_data[171];
      const auto ayyz_0 = current_data[172];
      const auto axzz_0 = current_data[178];
      const auto ayzz_0 = current_data[179];
      const auto azzz_0 = current_data[185];
      const auto axxxx_0 = current_data[229];
      const auto axxxy_0 = current_data[230];
      const auto axxyy_0 = current_data[231];
      const auto axyyy_0 = current_data[232];
      const auto ayyyy_0 = current_data[233];
      const auto axxxz_0 = current_data[239];
      const auto axxyz_0 = current_data[240];
      const auto axyyz_0 = current_data[241];
      const auto ayyyz_0 = current_data[242];
      const auto axxzz_0 = current_data[248];
      const auto axyzz_0 = current_data[249];
      const auto ayyzz_0 = current_data[250];
      const auto axzzz_0 = current_data[256];
      const auto ayzzz_0 = current_data[257];
      const auto azzzz_0 = current_data[263];
      const auto axxxxx_0 = current_data[309];
      const auto axxxxy_0 = current_data[310];
      const auto axxxyy_0 = current_data[311];
      const auto axxyyy_0 = current_data[312];
      const auto axyyyy_0 = current_data[313];
      const auto ayyyyy_0 = current_data[314];
      const auto axxxxz_0 = current_data[320];
      const auto axxxyz_0 = current_data[321];
      const auto axxyyz_0 = current_data[322];
      const auto axyyyz_0 = current_data[323];
      const auto ayyyyz_0 = current_data[324];
      const auto axxxzz_0 = current_data[330];
      const auto axxyzz_0 = current_data[331];
      const auto axyyzz_0 = current_data[332];
      const auto ayyyzz_0 = current_data[333];
      const auto axxzzz_0 = current_data[339];
      const auto axyzzz_0 = current_data[340];
      const auto ayyzzz_0 = current_data[341];
      const auto axzzzz_0 = current_data[347];
      const auto ayzzzz_0 = current_data[348];
      const auto azzzzz_0 = current_data[354];
      const auto axxxxxx_0 = current_data[402];
      const auto axxxxxy_0 = current_data[403];
      const auto axxxxyy_0 = current_data[404];
      const auto axxxyyy_0 = current_data[405];
      const auto axxyyyy_0 = current_data[406];
      const auto axyyyyy_0 = current_data[407];
      const auto ayyyyyy_0 = current_data[408];
      const auto axxxxxz_0 = current_data[414];
      const auto axxxxyz_0 = current_data[415];
      const auto axxxyyz_0 = current_data[416];
      const auto axxyyyz_0 = current_data[417];
      const auto axyyyyz_0 = current_data[418];
      const auto ayyyyyz_0 = current_data[419];
      const auto axxxxzz_0 = current_data[425];
      const auto axxxyzz_0 = current_data[426];
      const auto axxyyzz_0 = current_data[427];
      const auto axyyyzz_0 = current_data[428];
      const auto ayyyyzz_0 = current_data[429];
      const auto axxxzzz_0 = current_data[435];
      const auto axxyzzz_0 = current_data[436];
      const auto axyyzzz_0 = current_data[437];
      const auto ayyyzzz_0 = current_data[438];
      const auto axxzzzz_0 = current_data[444];
      const auto axyzzzz_0 = current_data[445];
      const auto ayyzzzz_0 = current_data[446];
      const auto axzzzzz_0 = current_data[452];
      const auto ayzzzzz_0 = current_data[453];
      const auto azzzzzz_0 = current_data[459];
      const auto axxxxxxx_0 = current_data[509];
      const auto axxxxxxy_0 = current_data[510];
      const auto axxxxxyy_0 = current_data[511];
      const auto axxxxyyy_0 = current_data[512];
      const auto axxxyyyy_0 = current_data[513];
      const auto axxyyyyy_0 = current_data[514];
      const auto axyyyyyy_0 = current_data[515];
      const auto ayyyyyyy_0 = current_data[516];
      const auto axxxxxxz_0 = current_data[522];
      const auto axxxxxyz_0 = current_data[523];
      const auto axxxxyyz_0 = current_data[524];
      const auto axxxyyyz_0 = current_data[525];
      const auto axxyyyyz_0 = current_data[526];
      const auto axyyyyyz_0 = current_data[527];
      const auto ayyyyyyz_0 = current_data[528];
      const auto axxxxxzz_0 = current_data[534];
      const auto axxxxyzz_0 = current_data[535];
      const auto axxxyyzz_0 = current_data[536];
      const auto axxyyyzz_0 = current_data[537];
      const auto axyyyyzz_0 = current_data[538];
      const auto ayyyyyzz_0 = current_data[539];
      const auto axxxxzzz_0 = current_data[545];
      const auto axxxyzzz_0 = current_data[546];
      const auto axxyyzzz_0 = current_data[547];
      const auto axyyyzzz_0 = current_data[548];
      const auto ayyyyzzz_0 = current_data[549];
      const auto axxxzzzz_0 = current_data[555];
      const auto axxyzzzz_0 = current_data[556];
      const auto axyyzzzz_0 = current_data[557];
      const auto ayyyzzzz_0 = current_data[558];
      const auto axxzzzzz_0 = current_data[564];
      const auto axyzzzzz_0 = current_data[565];
      const auto ayyzzzzz_0 = current_data[566];
      const auto axzzzzzz_0 = current_data[572];
      const auto ayzzzzzz_0 = current_data[573];
      const auto azzzzzzz_0 = current_data[579];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[684] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[685] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[686] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[687] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[688] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[689] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[690] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[691] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[692] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[693] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[694] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[695] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[696] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[697] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[698] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[699] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[700] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[701] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[702] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[703] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[704] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[705] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[706] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[707] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[708] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[709] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[710] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[711] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[712] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[713] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[714] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[715] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[716] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[717] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[718] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[719] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: yyyyyzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[58];
      const auto ay_0 = current_data[59];
      const auto az_0 = current_data[65];
      const auto axx_0 = current_data[105];
      const auto axy_0 = current_data[106];
      const auto ayy_0 = current_data[107];
      const auto axz_0 = current_data[113];
      const auto ayz_0 = current_data[114];
      const auto azz_0 = current_data[120];
      const auto axxx_0 = current_data[162];
      const auto axxy_0 = current_data[163];
      const auto axyy_0 = current_data[164];
      const auto ayyy_0 = current_data[165];
      const auto axxz_0 = current_data[171];
      const auto axyz_0 = current_data[172];
      const auto ayyz_0 = current_data[173];
      const auto axzz_0 = current_data[179];
      const auto ayzz_0 = current_data[180];
      const auto azzz_0 = current_data[186];
      const auto axxxx_0 = current_data[230];
      const auto axxxy_0 = current_data[231];
      const auto axxyy_0 = current_data[232];
      const auto axyyy_0 = current_data[233];
      const auto ayyyy_0 = current_data[234];
      const auto axxxz_0 = current_data[240];
      const auto axxyz_0 = current_data[241];
      const auto axyyz_0 = current_data[242];
      const auto ayyyz_0 = current_data[243];
      const auto axxzz_0 = current_data[249];
      const auto axyzz_0 = current_data[250];
      const auto ayyzz_0 = current_data[251];
      const auto axzzz_0 = current_data[257];
      const auto ayzzz_0 = current_data[258];
      const auto azzzz_0 = current_data[264];
      const auto axxxxx_0 = current_data[310];
      const auto axxxxy_0 = current_data[311];
      const auto axxxyy_0 = current_data[312];
      const auto axxyyy_0 = current_data[313];
      const auto axyyyy_0 = current_data[314];
      const auto ayyyyy_0 = current_data[315];
      const auto axxxxz_0 = current_data[321];
      const auto axxxyz_0 = current_data[322];
      const auto axxyyz_0 = current_data[323];
      const auto axyyyz_0 = current_data[324];
      const auto ayyyyz_0 = current_data[325];
      const auto axxxzz_0 = current_data[331];
      const auto axxyzz_0 = current_data[332];
      const auto axyyzz_0 = current_data[333];
      const auto ayyyzz_0 = current_data[334];
      const auto axxzzz_0 = current_data[340];
      const auto axyzzz_0 = current_data[341];
      const auto ayyzzz_0 = current_data[342];
      const auto axzzzz_0 = current_data[348];
      const auto ayzzzz_0 = current_data[349];
      const auto azzzzz_0 = current_data[355];
      const auto axxxxxx_0 = current_data[403];
      const auto axxxxxy_0 = current_data[404];
      const auto axxxxyy_0 = current_data[405];
      const auto axxxyyy_0 = current_data[406];
      const auto axxyyyy_0 = current_data[407];
      const auto axyyyyy_0 = current_data[408];
      const auto ayyyyyy_0 = current_data[409];
      const auto axxxxxz_0 = current_data[415];
      const auto axxxxyz_0 = current_data[416];
      const auto axxxyyz_0 = current_data[417];
      const auto axxyyyz_0 = current_data[418];
      const auto axyyyyz_0 = current_data[419];
      const auto ayyyyyz_0 = current_data[420];
      const auto axxxxzz_0 = current_data[426];
      const auto axxxyzz_0 = current_data[427];
      const auto axxyyzz_0 = current_data[428];
      const auto axyyyzz_0 = current_data[429];
      const auto ayyyyzz_0 = current_data[430];
      const auto axxxzzz_0 = current_data[436];
      const auto axxyzzz_0 = current_data[437];
      const auto axyyzzz_0 = current_data[438];
      const auto ayyyzzz_0 = current_data[439];
      const auto axxzzzz_0 = current_data[445];
      const auto axyzzzz_0 = current_data[446];
      const auto ayyzzzz_0 = current_data[447];
      const auto axzzzzz_0 = current_data[453];
      const auto ayzzzzz_0 = current_data[454];
      const auto azzzzzz_0 = current_data[460];
      const auto axxxxxxx_0 = current_data[510];
      const auto axxxxxxy_0 = current_data[511];
      const auto axxxxxyy_0 = current_data[512];
      const auto axxxxyyy_0 = current_data[513];
      const auto axxxyyyy_0 = current_data[514];
      const auto axxyyyyy_0 = current_data[515];
      const auto axyyyyyy_0 = current_data[516];
      const auto ayyyyyyy_0 = current_data[517];
      const auto axxxxxxz_0 = current_data[523];
      const auto axxxxxyz_0 = current_data[524];
      const auto axxxxyyz_0 = current_data[525];
      const auto axxxyyyz_0 = current_data[526];
      const auto axxyyyyz_0 = current_data[527];
      const auto axyyyyyz_0 = current_data[528];
      const auto ayyyyyyz_0 = current_data[529];
      const auto axxxxxzz_0 = current_data[535];
      const auto axxxxyzz_0 = current_data[536];
      const auto axxxyyzz_0 = current_data[537];
      const auto axxyyyzz_0 = current_data[538];
      const auto axyyyyzz_0 = current_data[539];
      const auto ayyyyyzz_0 = current_data[540];
      const auto axxxxzzz_0 = current_data[546];
      const auto axxxyzzz_0 = current_data[547];
      const auto axxyyzzz_0 = current_data[548];
      const auto axyyyzzz_0 = current_data[549];
      const auto ayyyyzzz_0 = current_data[550];
      const auto axxxzzzz_0 = current_data[556];
      const auto axxyzzzz_0 = current_data[557];
      const auto axyyzzzz_0 = current_data[558];
      const auto ayyyzzzz_0 = current_data[559];
      const auto axxzzzzz_0 = current_data[565];
      const auto axyzzzzz_0 = current_data[566];
      const auto ayyzzzzz_0 = current_data[567];
      const auto axzzzzzz_0 = current_data[573];
      const auto ayzzzzzz_0 = current_data[574];
      const auto azzzzzzz_0 = current_data[580];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[720] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[721] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[722] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[723] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[724] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[725] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[726] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[727] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[728] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[729] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[730] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[731] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[732] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[733] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[734] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[735] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[736] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[737] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[738] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[739] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[740] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[741] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[742] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[743] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[744] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[745] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[746] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[747] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[748] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[749] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[750] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[751] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[752] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[753] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[754] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[755] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxxzzz
      const auto a0_0 = current_data[21];
      const auto ax_0 = current_data[60];
      const auto ay_0 = current_data[61];
      const auto az_0 = current_data[66];
      const auto axx_0 = current_data[108];
      const auto axy_0 = current_data[109];
      const auto ayy_0 = current_data[110];
      const auto axz_0 = current_data[115];
      const auto ayz_0 = current_data[116];
      const auto azz_0 = current_data[121];
      const auto axxx_0 = current_data[166];
      const auto axxy_0 = current_data[167];
      const auto axyy_0 = current_data[168];
      const auto ayyy_0 = current_data[169];
      const auto axxz_0 = current_data[174];
      const auto axyz_0 = current_data[175];
      const auto ayyz_0 = current_data[176];
      const auto axzz_0 = current_data[181];
      const auto ayzz_0 = current_data[182];
      const auto azzz_0 = current_data[187];
      const auto axxxx_0 = current_data[235];
      const auto axxxy_0 = current_data[236];
      const auto axxyy_0 = current_data[237];
      const auto axyyy_0 = current_data[238];
      const auto ayyyy_0 = current_data[239];
      const auto axxxz_0 = current_data[244];
      const auto axxyz_0 = current_data[245];
      const auto axyyz_0 = current_data[246];
      const auto ayyyz_0 = current_data[247];
      const auto axxzz_0 = current_data[252];
      const auto axyzz_0 = current_data[253];
      const auto ayyzz_0 = current_data[254];
      const auto axzzz_0 = current_data[259];
      const auto ayzzz_0 = current_data[260];
      const auto azzzz_0 = current_data[265];
      const auto axxxxx_0 = current_data[316];
      const auto axxxxy_0 = current_data[317];
      const auto axxxyy_0 = current_data[318];
      const auto axxyyy_0 = current_data[319];
      const auto axyyyy_0 = current_data[320];
      const auto ayyyyy_0 = current_data[321];
      const auto axxxxz_0 = current_data[326];
      const auto axxxyz_0 = current_data[327];
      const auto axxyyz_0 = current_data[328];
      const auto axyyyz_0 = current_data[329];
      const auto ayyyyz_0 = current_data[330];
      const auto axxxzz_0 = current_data[335];
      const auto axxyzz_0 = current_data[336];
      const auto axyyzz_0 = current_data[337];
      const auto ayyyzz_0 = current_data[338];
      const auto axxzzz_0 = current_data[343];
      const auto axyzzz_0 = current_data[344];
      const auto ayyzzz_0 = current_data[345];
      const auto axzzzz_0 = current_data[350];
      const auto ayzzzz_0 = current_data[351];
      const auto azzzzz_0 = current_data[356];
      const auto axxxxxx_0 = current_data[410];
      const auto axxxxxy_0 = current_data[411];
      const auto axxxxyy_0 = current_data[412];
      const auto axxxyyy_0 = current_data[413];
      const auto axxyyyy_0 = current_data[414];
      const auto axyyyyy_0 = current_data[415];
      const auto ayyyyyy_0 = current_data[416];
      const auto axxxxxz_0 = current_data[421];
      const auto axxxxyz_0 = current_data[422];
      const auto axxxyyz_0 = current_data[423];
      const auto axxyyyz_0 = current_data[424];
      const auto axyyyyz_0 = current_data[425];
      const auto ayyyyyz_0 = current_data[426];
      const auto axxxxzz_0 = current_data[431];
      const auto axxxyzz_0 = current_data[432];
      const auto axxyyzz_0 = current_data[433];
      const auto axyyyzz_0 = current_data[434];
      const auto ayyyyzz_0 = current_data[435];
      const auto axxxzzz_0 = current_data[440];
      const auto axxyzzz_0 = current_data[441];
      const auto axyyzzz_0 = current_data[442];
      const auto ayyyzzz_0 = current_data[443];
      const auto axxzzzz_0 = current_data[448];
      const auto axyzzzz_0 = current_data[449];
      const auto ayyzzzz_0 = current_data[450];
      const auto axzzzzz_0 = current_data[455];
      const auto ayzzzzz_0 = current_data[456];
      const auto azzzzzz_0 = current_data[461];
      const auto axxxxxxx_0 = current_data[518];
      const auto axxxxxxy_0 = current_data[519];
      const auto axxxxxyy_0 = current_data[520];
      const auto axxxxyyy_0 = current_data[521];
      const auto axxxyyyy_0 = current_data[522];
      const auto axxyyyyy_0 = current_data[523];
      const auto axyyyyyy_0 = current_data[524];
      const auto ayyyyyyy_0 = current_data[525];
      const auto axxxxxxz_0 = current_data[530];
      const auto axxxxxyz_0 = current_data[531];
      const auto axxxxyyz_0 = current_data[532];
      const auto axxxyyyz_0 = current_data[533];
      const auto axxyyyyz_0 = current_data[534];
      const auto axyyyyyz_0 = current_data[535];
      const auto ayyyyyyz_0 = current_data[536];
      const auto axxxxxzz_0 = current_data[541];
      const auto axxxxyzz_0 = current_data[542];
      const auto axxxyyzz_0 = current_data[543];
      const auto axxyyyzz_0 = current_data[544];
      const auto axyyyyzz_0 = current_data[545];
      const auto ayyyyyzz_0 = current_data[546];
      const auto axxxxzzz_0 = current_data[551];
      const auto axxxyzzz_0 = current_data[552];
      const auto axxyyzzz_0 = current_data[553];
      const auto axyyyzzz_0 = current_data[554];
      const auto ayyyyzzz_0 = current_data[555];
      const auto axxxzzzz_0 = current_data[560];
      const auto axxyzzzz_0 = current_data[561];
      const auto axyyzzzz_0 = current_data[562];
      const auto ayyyzzzz_0 = current_data[563];
      const auto axxzzzzz_0 = current_data[568];
      const auto axyzzzzz_0 = current_data[569];
      const auto ayyzzzzz_0 = current_data[570];
      const auto axzzzzzz_0 = current_data[575];
      const auto ayzzzzzz_0 = current_data[576];
      const auto azzzzzzz_0 = current_data[581];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[756] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[757] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[758] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[759] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[760] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[761] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[762] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[763] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[764] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[765] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[766] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[767] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[768] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[769] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[770] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[771] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[772] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[773] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[774] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[775] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[776] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[777] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[778] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[779] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[780] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[781] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[782] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[783] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[784] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[785] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[786] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[787] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[788] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[789] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[790] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[791] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxxyzzz
      const auto a0_0 = current_data[22];
      const auto ax_0 = current_data[61];
      const auto ay_0 = current_data[62];
      const auto az_0 = current_data[67];
      const auto axx_0 = current_data[109];
      const auto axy_0 = current_data[110];
      const auto ayy_0 = current_data[111];
      const auto axz_0 = current_data[116];
      const auto ayz_0 = current_data[117];
      const auto azz_0 = current_data[122];
      const auto axxx_0 = current_data[167];
      const auto axxy_0 = current_data[168];
      const auto axyy_0 = current_data[169];
      const auto ayyy_0 = current_data[170];
      const auto axxz_0 = current_data[175];
      const auto axyz_0 = current_data[176];
      const auto ayyz_0 = current_data[177];
      const auto axzz_0 = current_data[182];
      const auto ayzz_0 = current_data[183];
      const auto azzz_0 = current_data[188];
      const auto axxxx_0 = current_data[236];
      const auto axxxy_0 = current_data[237];
      const auto axxyy_0 = current_data[238];
      const auto axyyy_0 = current_data[239];
      const auto ayyyy_0 = current_data[240];
      const auto axxxz_0 = current_data[245];
      const auto axxyz_0 = current_data[246];
      const auto axyyz_0 = current_data[247];
      const auto ayyyz_0 = current_data[248];
      const auto axxzz_0 = current_data[253];
      const auto axyzz_0 = current_data[254];
      const auto ayyzz_0 = current_data[255];
      const auto axzzz_0 = current_data[260];
      const auto ayzzz_0 = current_data[261];
      const auto azzzz_0 = current_data[266];
      const auto axxxxx_0 = current_data[317];
      const auto axxxxy_0 = current_data[318];
      const auto axxxyy_0 = current_data[319];
      const auto axxyyy_0 = current_data[320];
      const auto axyyyy_0 = current_data[321];
      const auto ayyyyy_0 = current_data[322];
      const auto axxxxz_0 = current_data[327];
      const auto axxxyz_0 = current_data[328];
      const auto axxyyz_0 = current_data[329];
      const auto axyyyz_0 = current_data[330];
      const auto ayyyyz_0 = current_data[331];
      const auto axxxzz_0 = current_data[336];
      const auto axxyzz_0 = current_data[337];
      const auto axyyzz_0 = current_data[338];
      const auto ayyyzz_0 = current_data[339];
      const auto axxzzz_0 = current_data[344];
      const auto axyzzz_0 = current_data[345];
      const auto ayyzzz_0 = current_data[346];
      const auto axzzzz_0 = current_data[351];
      const auto ayzzzz_0 = current_data[352];
      const auto azzzzz_0 = current_data[357];
      const auto axxxxxx_0 = current_data[411];
      const auto axxxxxy_0 = current_data[412];
      const auto axxxxyy_0 = current_data[413];
      const auto axxxyyy_0 = current_data[414];
      const auto axxyyyy_0 = current_data[415];
      const auto axyyyyy_0 = current_data[416];
      const auto ayyyyyy_0 = current_data[417];
      const auto axxxxxz_0 = current_data[422];
      const auto axxxxyz_0 = current_data[423];
      const auto axxxyyz_0 = current_data[424];
      const auto axxyyyz_0 = current_data[425];
      const auto axyyyyz_0 = current_data[426];
      const auto ayyyyyz_0 = current_data[427];
      const auto axxxxzz_0 = current_data[432];
      const auto axxxyzz_0 = current_data[433];
      const auto axxyyzz_0 = current_data[434];
      const auto axyyyzz_0 = current_data[435];
      const auto ayyyyzz_0 = current_data[436];
      const auto axxxzzz_0 = current_data[441];
      const auto axxyzzz_0 = current_data[442];
      const auto axyyzzz_0 = current_data[443];
      const auto ayyyzzz_0 = current_data[444];
      const auto axxzzzz_0 = current_data[449];
      const auto axyzzzz_0 = current_data[450];
      const auto ayyzzzz_0 = current_data[451];
      const auto axzzzzz_0 = current_data[456];
      const auto ayzzzzz_0 = current_data[457];
      const auto azzzzzz_0 = current_data[462];
      const auto axxxxxxx_0 = current_data[519];
      const auto axxxxxxy_0 = current_data[520];
      const auto axxxxxyy_0 = current_data[521];
      const auto axxxxyyy_0 = current_data[522];
      const auto axxxyyyy_0 = current_data[523];
      const auto axxyyyyy_0 = current_data[524];
      const auto axyyyyyy_0 = current_data[525];
      const auto ayyyyyyy_0 = current_data[526];
      const auto axxxxxxz_0 = current_data[531];
      const auto axxxxxyz_0 = current_data[532];
      const auto axxxxyyz_0 = current_data[533];
      const auto axxxyyyz_0 = current_data[534];
      const auto axxyyyyz_0 = current_data[535];
      const auto axyyyyyz_0 = current_data[536];
      const auto ayyyyyyz_0 = current_data[537];
      const auto axxxxxzz_0 = current_data[542];
      const auto axxxxyzz_0 = current_data[543];
      const auto axxxyyzz_0 = current_data[544];
      const auto axxyyyzz_0 = current_data[545];
      const auto axyyyyzz_0 = current_data[546];
      const auto ayyyyyzz_0 = current_data[547];
      const auto axxxxzzz_0 = current_data[552];
      const auto axxxyzzz_0 = current_data[553];
      const auto axxyyzzz_0 = current_data[554];
      const auto axyyyzzz_0 = current_data[555];
      const auto ayyyyzzz_0 = current_data[556];
      const auto axxxzzzz_0 = current_data[561];
      const auto axxyzzzz_0 = current_data[562];
      const auto axyyzzzz_0 = current_data[563];
      const auto ayyyzzzz_0 = current_data[564];
      const auto axxzzzzz_0 = current_data[569];
      const auto axyzzzzz_0 = current_data[570];
      const auto ayyzzzzz_0 = current_data[571];
      const auto axzzzzzz_0 = current_data[576];
      const auto ayzzzzzz_0 = current_data[577];
      const auto azzzzzzz_0 = current_data[582];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[792] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[793] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[794] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[795] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[796] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[797] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[798] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[799] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[800] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[801] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[802] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[803] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[804] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[805] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[806] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[807] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[808] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[809] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[810] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[811] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[812] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[813] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[814] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[815] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[816] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[817] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[818] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[819] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[820] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[821] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[822] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[823] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[824] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[825] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[826] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[827] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xxyyzzz
      const auto a0_0 = current_data[23];
      const auto ax_0 = current_data[62];
      const auto ay_0 = current_data[63];
      const auto az_0 = current_data[68];
      const auto axx_0 = current_data[110];
      const auto axy_0 = current_data[111];
      const auto ayy_0 = current_data[112];
      const auto axz_0 = current_data[117];
      const auto ayz_0 = current_data[118];
      const auto azz_0 = current_data[123];
      const auto axxx_0 = current_data[168];
      const auto axxy_0 = current_data[169];
      const auto axyy_0 = current_data[170];
      const auto ayyy_0 = current_data[171];
      const auto axxz_0 = current_data[176];
      const auto axyz_0 = current_data[177];
      const auto ayyz_0 = current_data[178];
      const auto axzz_0 = current_data[183];
      const auto ayzz_0 = current_data[184];
      const auto azzz_0 = current_data[189];
      const auto axxxx_0 = current_data[237];
      const auto axxxy_0 = current_data[238];
      const auto axxyy_0 = current_data[239];
      const auto axyyy_0 = current_data[240];
      const auto ayyyy_0 = current_data[241];
      const auto axxxz_0 = current_data[246];
      const auto axxyz_0 = current_data[247];
      const auto axyyz_0 = current_data[248];
      const auto ayyyz_0 = current_data[249];
      const auto axxzz_0 = current_data[254];
      const auto axyzz_0 = current_data[255];
      const auto ayyzz_0 = current_data[256];
      const auto axzzz_0 = current_data[261];
      const auto ayzzz_0 = current_data[262];
      const auto azzzz_0 = current_data[267];
      const auto axxxxx_0 = current_data[318];
      const auto axxxxy_0 = current_data[319];
      const auto axxxyy_0 = current_data[320];
      const auto axxyyy_0 = current_data[321];
      const auto axyyyy_0 = current_data[322];
      const auto ayyyyy_0 = current_data[323];
      const auto axxxxz_0 = current_data[328];
      const auto axxxyz_0 = current_data[329];
      const auto axxyyz_0 = current_data[330];
      const auto axyyyz_0 = current_data[331];
      const auto ayyyyz_0 = current_data[332];
      const auto axxxzz_0 = current_data[337];
      const auto axxyzz_0 = current_data[338];
      const auto axyyzz_0 = current_data[339];
      const auto ayyyzz_0 = current_data[340];
      const auto axxzzz_0 = current_data[345];
      const auto axyzzz_0 = current_data[346];
      const auto ayyzzz_0 = current_data[347];
      const auto axzzzz_0 = current_data[352];
      const auto ayzzzz_0 = current_data[353];
      const auto azzzzz_0 = current_data[358];
      const auto axxxxxx_0 = current_data[412];
      const auto axxxxxy_0 = current_data[413];
      const auto axxxxyy_0 = current_data[414];
      const auto axxxyyy_0 = current_data[415];
      const auto axxyyyy_0 = current_data[416];
      const auto axyyyyy_0 = current_data[417];
      const auto ayyyyyy_0 = current_data[418];
      const auto axxxxxz_0 = current_data[423];
      const auto axxxxyz_0 = current_data[424];
      const auto axxxyyz_0 = current_data[425];
      const auto axxyyyz_0 = current_data[426];
      const auto axyyyyz_0 = current_data[427];
      const auto ayyyyyz_0 = current_data[428];
      const auto axxxxzz_0 = current_data[433];
      const auto axxxyzz_0 = current_data[434];
      const auto axxyyzz_0 = current_data[435];
      const auto axyyyzz_0 = current_data[436];
      const auto ayyyyzz_0 = current_data[437];
      const auto axxxzzz_0 = current_data[442];
      const auto axxyzzz_0 = current_data[443];
      const auto axyyzzz_0 = current_data[444];
      const auto ayyyzzz_0 = current_data[445];
      const auto axxzzzz_0 = current_data[450];
      const auto axyzzzz_0 = current_data[451];
      const auto ayyzzzz_0 = current_data[452];
      const auto axzzzzz_0 = current_data[457];
      const auto ayzzzzz_0 = current_data[458];
      const auto azzzzzz_0 = current_data[463];
      const auto axxxxxxx_0 = current_data[520];
      const auto axxxxxxy_0 = current_data[521];
      const auto axxxxxyy_0 = current_data[522];
      const auto axxxxyyy_0 = current_data[523];
      const auto axxxyyyy_0 = current_data[524];
      const auto axxyyyyy_0 = current_data[525];
      const auto axyyyyyy_0 = current_data[526];
      const auto ayyyyyyy_0 = current_data[527];
      const auto axxxxxxz_0 = current_data[532];
      const auto axxxxxyz_0 = current_data[533];
      const auto axxxxyyz_0 = current_data[534];
      const auto axxxyyyz_0 = current_data[535];
      const auto axxyyyyz_0 = current_data[536];
      const auto axyyyyyz_0 = current_data[537];
      const auto ayyyyyyz_0 = current_data[538];
      const auto axxxxxzz_0 = current_data[543];
      const auto axxxxyzz_0 = current_data[544];
      const auto axxxyyzz_0 = current_data[545];
      const auto axxyyyzz_0 = current_data[546];
      const auto axyyyyzz_0 = current_data[547];
      const auto ayyyyyzz_0 = current_data[548];
      const auto axxxxzzz_0 = current_data[553];
      const auto axxxyzzz_0 = current_data[554];
      const auto axxyyzzz_0 = current_data[555];
      const auto axyyyzzz_0 = current_data[556];
      const auto ayyyyzzz_0 = current_data[557];
      const auto axxxzzzz_0 = current_data[562];
      const auto axxyzzzz_0 = current_data[563];
      const auto axyyzzzz_0 = current_data[564];
      const auto ayyyzzzz_0 = current_data[565];
      const auto axxzzzzz_0 = current_data[570];
      const auto axyzzzzz_0 = current_data[571];
      const auto ayyzzzzz_0 = current_data[572];
      const auto axzzzzzz_0 = current_data[577];
      const auto ayzzzzzz_0 = current_data[578];
      const auto azzzzzzz_0 = current_data[583];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto axxxxxx_x = axxxxxxx_0 + AB[0] * axxxxxx_0;
      const auto axxxxxx_y = axxxxxxy_0 + AB[1] * axxxxxx_0;
      const auto axxxxxy_y = axxxxxyy_0 + AB[1] * axxxxxy_0;
      const auto axxxxyy_y = axxxxyyy_0 + AB[1] * axxxxyy_0;
      const auto axxxyyy_y = axxxyyyy_0 + AB[1] * axxxyyy_0;
      const auto axxyyyy_y = axxyyyyy_0 + AB[1] * axxyyyy_0;
      const auto axyyyyy_y = axyyyyyy_0 + AB[1] * axyyyyy_0;
      const auto ayyyyyy_y = ayyyyyyy_0 + AB[1] * ayyyyyy_0;
      const auto axxxxxx_z = axxxxxxz_0 + AB[2] * axxxxxx_0;
      const auto axxxxxy_z = axxxxxyz_0 + AB[2] * axxxxxy_0;
      const auto axxxxyy_z = axxxxyyz_0 + AB[2] * axxxxyy_0;
      const auto axxxyyy_z = axxxyyyz_0 + AB[2] * axxxyyy_0;
      const auto axxyyyy_z = axxyyyyz_0 + AB[2] * axxyyyy_0;
      const auto axyyyyy_z = axyyyyyz_0 + AB[2] * axyyyyy_0;
      const auto ayyyyyy_z = ayyyyyyz_0 + AB[2] * ayyyyyy_0;
      const auto axxxxxz_z = axxxxxzz_0 + AB[2] * axxxxxz_0;
      const auto axxxxyz_z = axxxxyzz_0 + AB[2] * axxxxyz_0;
      const auto axxxyyz_z = axxxyyzz_0 + AB[2] * axxxyyz_0;
      const auto axxyyyz_z = axxyyyzz_0 + AB[2] * axxyyyz_0;
      const auto axyyyyz_z = axyyyyzz_0 + AB[2] * axyyyyz_0;
      const auto ayyyyyz_z = ayyyyyzz_0 + AB[2] * ayyyyyz_0;
      const auto axxxxzz_z = axxxxzzz_0 + AB[2] * axxxxzz_0;
      const auto axxxyzz_z = axxxyzzz_0 + AB[2] * axxxyzz_0;
      const auto axxyyzz_z = axxyyzzz_0 + AB[2] * axxyyzz_0;
      const auto axyyyzz_z = axyyyzzz_0 + AB[2] * axyyyzz_0;
      const auto ayyyyzz_z = ayyyyzzz_0 + AB[2] * ayyyyzz_0;
      const auto axxxzzz_z = axxxzzzz_0 + AB[2] * axxxzzz_0;
      const auto axxyzzz_z = axxyzzzz_0 + AB[2] * axxyzzz_0;
      const auto axyyzzz_z = axyyzzzz_0 + AB[2] * axyyzzz_0;
      const auto ayyyzzz_z = ayyyzzzz_0 + AB[2] * ayyyzzz_0;
      const auto axxzzzz_z = axxzzzzz_0 + AB[2] * axxzzzz_0;
      const auto axyzzzz_z = axyzzzzz_0 + AB[2] * axyzzzz_0;
      const auto ayyzzzz_z = ayyzzzzz_0 + AB[2] * ayyzzzz_0;
      const auto axzzzzz_z = axzzzzzz_0 + AB[2] * axzzzzz_0;
      const auto ayzzzzz_z = ayzzzzzz_0 + AB[2] * ayzzzzz_0;
      const auto azzzzzz_z = azzzzzzz_0 + AB[2] * azzzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto axxxxx_xx = axxxxxx_x + AB[0] * axxxxx_x;
      const auto axxxxx_xy = axxxxxx_y + AB[0] * axxxxx_y;
      const auto axxxxx_yy = axxxxxy_y + AB[1] * axxxxx_y;
      const auto axxxxy_yy = axxxxyy_y + AB[1] * axxxxy_y;
      const auto axxxyy_yy = axxxyyy_y + AB[1] * axxxyy_y;
      const auto axxyyy_yy = axxyyyy_y + AB[1] * axxyyy_y;
      const auto axyyyy_yy = axyyyyy_y + AB[1] * axyyyy_y;
      const auto ayyyyy_yy = ayyyyyy_y + AB[1] * ayyyyy_y;
      const auto axxxxx_xz = axxxxxx_z + AB[0] * axxxxx_z;
      const auto axxxxx_yz = axxxxxy_z + AB[1] * axxxxx_z;
      const auto axxxxy_yz = axxxxyy_z + AB[1] * axxxxy_z;
      const auto axxxyy_yz = axxxyyy_z + AB[1] * axxxyy_z;
      const auto axxyyy_yz = axxyyyy_z + AB[1] * axxyyy_z;
      const auto axyyyy_yz = axyyyyy_z + AB[1] * axyyyy_z;
      const auto ayyyyy_yz = ayyyyyy_z + AB[1] * ayyyyy_z;
      const auto axxxxx_zz = axxxxxz_z + AB[2] * axxxxx_z;
      const auto axxxxy_zz = axxxxyz_z + AB[2] * axxxxy_z;
      const auto axxxyy_zz = axxxyyz_z + AB[2] * axxxyy_z;
      const auto axxyyy_zz = axxyyyz_z + AB[2] * axxyyy_z;
      const auto axyyyy_zz = axyyyyz_z + AB[2] * axyyyy_z;
      const auto ayyyyy_zz = ayyyyyz_z + AB[2] * ayyyyy_z;
      const auto axxxxz_zz = axxxxzz_z + AB[2] * axxxxz_z;
      const auto axxxyz_zz = axxxyzz_z + AB[2] * axxxyz_z;
      const auto axxyyz_zz = axxyyzz_z + AB[2] * axxyyz_z;
      const auto axyyyz_zz = axyyyzz_z + AB[2] * axyyyz_z;
      const auto ayyyyz_zz = ayyyyzz_z + AB[2] * ayyyyz_z;
      const auto axxxzz_zz = axxxzzz_z + AB[2] * axxxzz_z;
      const auto axxyzz_zz = axxyzzz_z + AB[2] * axxyzz_z;
      const auto axyyzz_zz = axyyzzz_z + AB[2] * axyyzz_z;
      const auto ayyyzz_zz = ayyyzzz_z + AB[2] * ayyyzz_z;
      const auto axxzzz_zz = axxzzzz_z + AB[2] * axxzzz_z;
      const auto axyzzz_zz = axyzzzz_z + AB[2] * axyzzz_z;
      const auto ayyzzz_zz = ayyzzzz_z + AB[2] * ayyzzz_z;
      const auto axzzzz_zz = axzzzzz_z + AB[2] * axzzzz_z;
      const auto ayzzzz_zz = ayzzzzz_z + AB[2] * ayzzzz_z;
      const auto azzzzz_zz = azzzzzz_z + AB[2] * azzzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto axxxx_xxx = axxxxx_xx + AB[0] * axxxx_xx;
      const auto axxxx_xxy = axxxxx_xy + AB[0] * axxxx_xy;
      const auto axxxx_xyy = axxxxx_yy + AB[0] * axxxx_yy;
      const auto axxxx_yyy = axxxxy_yy + AB[1] * axxxx_yy;
      const auto axxxy_yyy = axxxyy_yy + AB[1] * axxxy_yy;
      const auto axxyy_yyy = axxyyy_yy + AB[1] * axxyy_yy;
      const auto axyyy_yyy = axyyyy_yy + AB[1] * axyyy_yy;
      const auto ayyyy_yyy = ayyyyy_yy + AB[1] * ayyyy_yy;
      const auto axxxx_xxz = axxxxx_xz + AB[0] * axxxx_xz;
      const auto axxxx_xyz = axxxxx_yz + AB[0] * axxxx_yz;
      const auto axxxx_yyz = axxxxy_yz + AB[1] * axxxx_yz;
      const auto axxxy_yyz = axxxyy_yz + AB[1] * axxxy_yz;
      const auto axxyy_yyz = axxyyy_yz + AB[1] * axxyy_yz;
      const auto axyyy_yyz = axyyyy_yz + AB[1] * axyyy_yz;
      const auto ayyyy_yyz = ayyyyy_yz + AB[1] * ayyyy_yz;
      const auto axxxx_xzz = axxxxx_zz + AB[0] * axxxx_zz;
      const auto axxxx_yzz = axxxxy_zz + AB[1] * axxxx_zz;
      const auto axxxy_yzz = axxxyy_zz + AB[1] * axxxy_zz;
      const auto axxyy_yzz = axxyyy_zz + AB[1] * axxyy_zz;
      const auto axyyy_yzz = axyyyy_zz + AB[1] * axyyy_zz;
      const auto ayyyy_yzz = ayyyyy_zz + AB[1] * ayyyy_zz;
      const auto axxxx_zzz = axxxxz_zz + AB[2] * axxxx_zz;
      const auto axxxy_zzz = axxxyz_zz + AB[2] * axxxy_zz;
      const auto axxyy_zzz = axxyyz_zz + AB[2] * axxyy_zz;
      const auto axyyy_zzz = axyyyz_zz + AB[2] * axyyy_zz;
      const auto ayyyy_zzz = ayyyyz_zz + AB[2] * ayyyy_zz;
      const auto axxxz_zzz = axxxzz_zz + AB[2] * axxxz_zz;
      const auto axxyz_zzz = axxyzz_zz + AB[2] * axxyz_zz;
      const auto axyyz_zzz = axyyzz_zz + AB[2] * axyyz_zz;
      const auto ayyyz_zzz = ayyyzz_zz + AB[2] * ayyyz_zz;
      const auto axxzz_zzz = axxzzz_zz + AB[2] * axxzz_zz;
      const auto axyzz_zzz = axyzzz_zz + AB[2] * axyzz_zz;
      const auto ayyzz_zzz = ayyzzz_zz + AB[2] * ayyzz_zz;
      const auto axzzz_zzz = axzzzz_zz + AB[2] * axzzz_zz;
      const auto ayzzz_zzz = ayzzzz_zz + AB[2] * ayzzz_zz;
      const auto azzzz_zzz = azzzzz_zz + AB[2] * azzzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto axxx_xxxx = axxxx_xxx + AB[0] * axxx_xxx;
      const auto axxx_xxxy = axxxx_xxy + AB[0] * axxx_xxy;
      const auto axxx_xxyy = axxxx_xyy + AB[0] * axxx_xyy;
      const auto axxx_xyyy = axxxx_yyy + AB[0] * axxx_yyy;
      const auto axxx_yyyy = axxxy_yyy + AB[1] * axxx_yyy;
      const auto axxy_yyyy = axxyy_yyy + AB[1] * axxy_yyy;
      const auto axyy_yyyy = axyyy_yyy + AB[1] * axyy_yyy;
      const auto ayyy_yyyy = ayyyy_yyy + AB[1] * ayyy_yyy;
      const auto axxx_xxxz = axxxx_xxz + AB[0] * axxx_xxz;
      const auto axxx_xxyz = axxxx_xyz + AB[0] * axxx_xyz;
      const auto axxx_xyyz = axxxx_yyz + AB[0] * axxx_yyz;
      const auto axxx_yyyz = axxxy_yyz + AB[1] * axxx_yyz;
      const auto axxy_yyyz = axxyy_yyz + AB[1] * axxy_yyz;
      const auto axyy_yyyz = axyyy_yyz + AB[1] * axyy_yyz;
      const auto ayyy_yyyz = ayyyy_yyz + AB[1] * ayyy_yyz;
      const auto axxx_xxzz = axxxx_xzz + AB[0] * axxx_xzz;
      const auto axxx_xyzz = axxxx_yzz + AB[0] * axxx_yzz;
      const auto axxx_yyzz = axxxy_yzz + AB[1] * axxx_yzz;
      const auto axxy_yyzz = axxyy_yzz + AB[1] * axxy_yzz;
      const auto axyy_yyzz = axyyy_yzz + AB[1] * axyy_yzz;
      const auto ayyy_yyzz = ayyyy_yzz + AB[1] * ayyy_yzz;
      const auto axxx_xzzz = axxxx_zzz + AB[0] * axxx_zzz;
      const auto axxx_yzzz = axxxy_zzz + AB[1] * axxx_zzz;
      const auto axxy_yzzz = axxyy_zzz + AB[1] * axxy_zzz;
      const auto axyy_yzzz = axyyy_zzz + AB[1] * axyy_zzz;
      const auto ayyy_yzzz = ayyyy_zzz + AB[1] * ayyy_zzz;
      const auto axxx_zzzz = axxxz_zzz + AB[2] * axxx_zzz;
      const auto axxy_zzzz = axxyz_zzz + AB[2] * axxy_zzz;
      const auto axyy_zzzz = axyyz_zzz + AB[2] * axyy_zzz;
      const auto ayyy_zzzz = ayyyz_zzz + AB[2] * ayyy_zzz;
      const auto axxz_zzzz = axxzz_zzz + AB[2] * axxz_zzz;
      const auto axyz_zzzz = axyzz_zzz + AB[2] * axyz_zzz;
      const auto ayyz_zzzz = ayyzz_zzz + AB[2] * ayyz_zzz;
      const auto axzz_zzzz = axzzz_zzz + AB[2] * axzz_zzz;
      const auto ayzz_zzzz = ayzzz_zzz + AB[2] * ayzz_zzz;
      const auto azzz_zzzz = azzzz_zzz + AB[2] * azzz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      const auto axx_xxxxx = axxx_xxxx + AB[0] * axx_xxxx;
      const auto axx_xxxxy = axxx_xxxy + AB[0] * axx_xxxy;
      const auto axx_xxxyy = axxx_xxyy + AB[0] * axx_xxyy;
      const auto axx_xxyyy = axxx_xyyy + AB[0] * axx_xyyy;
      const auto axx_xyyyy = axxx_yyyy + AB[0] * axx_yyyy;
      const auto axx_yyyyy = axxy_yyyy + AB[1] * axx_yyyy;
      const auto axy_yyyyy = axyy_yyyy + AB[1] * axy_yyyy;
      const auto ayy_yyyyy = ayyy_yyyy + AB[1] * ayy_yyyy;
      const auto axx_xxxxz = axxx_xxxz + AB[0] * axx_xxxz;
      const auto axx_xxxyz = axxx_xxyz + AB[0] * axx_xxyz;
      const auto axx_xxyyz = axxx_xyyz + AB[0] * axx_xyyz;
      const auto axx_xyyyz = axxx_yyyz + AB[0] * axx_yyyz;
      const auto axx_yyyyz = axxy_yyyz + AB[1] * axx_yyyz;
      const auto axy_yyyyz = axyy_yyyz + AB[1] * axy_yyyz;
      const auto ayy_yyyyz = ayyy_yyyz + AB[1] * ayy_yyyz;
      const auto axx_xxxzz = axxx_xxzz + AB[0] * axx_xxzz;
      const auto axx_xxyzz = axxx_xyzz + AB[0] * axx_xyzz;
      const auto axx_xyyzz = axxx_yyzz + AB[0] * axx_yyzz;
      const auto axx_yyyzz = axxy_yyzz + AB[1] * axx_yyzz;
      const auto axy_yyyzz = axyy_yyzz + AB[1] * axy_yyzz;
      const auto ayy_yyyzz = ayyy_yyzz + AB[1] * ayy_yyzz;
      const auto axx_xxzzz = axxx_xzzz + AB[0] * axx_xzzz;
      const auto axx_xyzzz = axxx_yzzz + AB[0] * axx_yzzz;
      const auto axx_yyzzz = axxy_yzzz + AB[1] * axx_yzzz;
      const auto axy_yyzzz = axyy_yzzz + AB[1] * axy_yzzz;
      const auto ayy_yyzzz = ayyy_yzzz + AB[1] * ayy_yzzz;
      const auto axx_xzzzz = axxx_zzzz + AB[0] * axx_zzzz;
      const auto axx_yzzzz = axxy_zzzz + AB[1] * axx_zzzz;
      const auto axy_yzzzz = axyy_zzzz + AB[1] * axy_zzzz;
      const auto ayy_yzzzz = ayyy_zzzz + AB[1] * ayy_zzzz;
      const auto axx_zzzzz = axxz_zzzz + AB[2] * axx_zzzz;
      const auto axy_zzzzz = axyz_zzzz + AB[2] * axy_zzzz;
      const auto ayy_zzzzz = ayyz_zzzz + AB[2] * ayy_zzzz;
      const auto axz_zzzzz = axzz_zzzz + AB[2] * axz_zzzz;
      const auto ayz_zzzzz = ayzz_zzzz + AB[2] * ayz_zzzz;
      const auto azz_zzzzz = azzz_zzzz + AB[2] * azz_zzzz;

      const auto a0_xxxxxx = ax_xxxxx + AB[0] * a0_xxxxx;
      const auto a0_xxxxxy = ax_xxxxy + AB[0] * a0_xxxxy;
      const auto a0_xxxxyy = ax_xxxyy + AB[0] * a0_xxxyy;
      const auto a0_xxxyyy = ax_xxyyy + AB[0] * a0_xxyyy;
      const auto a0_xxyyyy = ax_xyyyy + AB[0] * a0_xyyyy;
      const auto a0_xyyyyy = ax_yyyyy + AB[0] * a0_yyyyy;
      const auto a0_yyyyyy = ay_yyyyy + AB[1] * a0_yyyyy;
      const auto a0_xxxxxz = ax_xxxxz + AB[0] * a0_xxxxz;
      const auto a0_xxxxyz = ax_xxxyz + AB[0] * a0_xxxyz;
      const auto a0_xxxyyz = ax_xxyyz + AB[0] * a0_xxyyz;
      const auto a0_xxyyyz = ax_xyyyz + AB[0] * a0_xyyyz;
      const auto a0_xyyyyz = ax_yyyyz + AB[0] * a0_yyyyz;
      const auto a0_yyyyyz = ay_yyyyz + AB[1] * a0_yyyyz;
      const auto a0_xxxxzz = ax_xxxzz + AB[0] * a0_xxxzz;
      const auto a0_xxxyzz = ax_xxyzz + AB[0] * a0_xxyzz;
      const auto a0_xxyyzz = ax_xyyzz + AB[0] * a0_xyyzz;
      const auto a0_xyyyzz = ax_yyyzz + AB[0] * a0_yyyzz;
      const auto a0_yyyyzz = ay_yyyzz + AB[1] * a0_yyyzz;
      const auto a0_xxxzzz = ax_xxzzz + AB[0] * a0_xxzzz;
      const auto a0_xxyzzz = ax_xyzzz + AB[0] * a0_xyzzz;
      const auto a0_xyyzzz = ax_yyzzz + AB[0] * a0_yyzzz;
      const auto a0_yyyzzz = ay_yyzzz + AB[1] * a0_yyzzz;
      const auto a0_xxzzzz = ax_xzzzz + AB[0] * a0_xzzzz;
      const auto a0_xyzzzz = ax_yzzzz + AB[0] * a0_yzzzz;
      const auto a0_yyzzzz = ay_yzzzz + AB[1] * a0_yzzzz;
      const auto a0_xzzzzz = ax_zzzzz + AB[0] * a0_zzzzz;
      const auto a0_yzzzzz = ay_zzzzz + AB[1] * a0_zzzzz;
      const auto a0_zzzzzz = az_zzzzz + AB[2] * a0_zzzzz;

      const auto ax_xxxxxx = axx_xxxxx + AB[0] * ax_xxxxx;
      const auto ax_xxxxxy = axx_xxxxy + AB[0] * ax_xxxxy;
      const auto ax_xxxxyy = axx_xxxyy + AB[0] * ax_xxxyy;
      const auto ax_xxxyyy = axx_xxyyy + AB[0] * ax_xxyyy;
      const auto ax_xxyyyy = axx_xyyyy + AB[0] * ax_xyyyy;
      const auto ax_xyyyyy = axx_yyyyy + AB[0] * ax_yyyyy;
      const auto ax_yyyyyy = axy_yyyyy + AB[1] * ax_yyyyy;
      const auto ay_yyyyyy = ayy_yyyyy + AB[1] * ay_yyyyy;
      const auto ax_xxxxxz = axx_xxxxz + AB[0] * ax_xxxxz;
      const auto ax_xxxxyz = axx_xxxyz + AB[0] * ax_xxxyz;
      const auto ax_xxxyyz = axx_xxyyz + AB[0] * ax_xxyyz;
      const auto ax_xxyyyz = axx_xyyyz + AB[0] * ax_xyyyz;
      const auto ax_xyyyyz = axx_yyyyz + AB[0] * ax_yyyyz;
      const auto ax_yyyyyz = axy_yyyyz + AB[1] * ax_yyyyz;
      const auto ay_yyyyyz = ayy_yyyyz + AB[1] * ay_yyyyz;
      const auto ax_xxxxzz = axx_xxxzz + AB[0] * ax_xxxzz;
      const auto ax_xxxyzz = axx_xxyzz + AB[0] * ax_xxyzz;
      const auto ax_xxyyzz = axx_xyyzz + AB[0] * ax_xyyzz;
      const auto ax_xyyyzz = axx_yyyzz + AB[0] * ax_yyyzz;
      const auto ax_yyyyzz = axy_yyyzz + AB[1] * ax_yyyzz;
      const auto ay_yyyyzz = ayy_yyyzz + AB[1] * ay_yyyzz;
      const auto ax_xxxzzz = axx_xxzzz + AB[0] * ax_xxzzz;
      const auto ax_xxyzzz = axx_xyzzz + AB[0] * ax_xyzzz;
      const auto ax_xyyzzz = axx_yyzzz + AB[0] * ax_yyzzz;
      const auto ax_yyyzzz = axy_yyzzz + AB[1] * ax_yyzzz;
      const auto ay_yyyzzz = ayy_yyzzz + AB[1] * ay_yyzzz;
      const auto ax_xxzzzz = axx_xzzzz + AB[0] * ax_xzzzz;
      const auto ax_xyzzzz = axx_yzzzz + AB[0] * ax_yzzzz;
      const auto ax_yyzzzz = axy_yzzzz + AB[1] * ax_yzzzz;
      const auto ay_yyzzzz = ayy_yzzzz + AB[1] * ay_yzzzz;
      const auto ax_xzzzzz = axx_zzzzz + AB[0] * ax_zzzzz;
      const auto ax_yzzzzz = axy_zzzzz + AB[1] * ax_zzzzz;
      const auto ay_yzzzzz = ayy_zzzzz + AB[1] * ay_zzzzz;
      const auto ax_zzzzzz = axz_zzzzz + AB[2] * ax_zzzzz;
      const auto ay_zzzzzz = ayz_zzzzz + AB[2] * ay_zzzzz;
      const auto az_zzzzzz = azz_zzzzz + AB[2] * az_zzzzz;

      current_out[828] = ax_xxxxxx + AB[0] * a0_xxxxxx; // a0_xxxxxxx
      current_out[829] = ax_xxxxxy + AB[0] * a0_xxxxxy; // a0_xxxxxxy
      current_out[830] = ax_xxxxyy + AB[0] * a0_xxxxyy; // a0_xxxxxyy
      current_out[831] = ax_xxxyyy + AB[0] * a0_xxxyyy; // a0_xxxxyyy
      current_out[832] = ax_xxyyyy + AB[0] * a0_xxyyyy; // a0_xxxyyyy
      current_out[833] = ax_xyyyyy + AB[0] * a0_xyyyyy; // a0_xxyyyyy
      current_out[834] = ax_yyyyyy + AB[0] * a0_yyyyyy; // a0_xyyyyyy
      current_out[835] = ay_yyyyyy + AB[1] * a0_yyyyyy; // a0_yyyyyyy
      current_out[836] = ax_xxxxxz + AB[0] * a0_xxxxxz; // a0_xxxxxxz
      current_out[837] = ax_xxxxyz + AB[0] * a0_xxxxyz; // a0_xxxxxyz
      current_out[838] = ax_xxxyyz + AB[0] * a0_xxxyyz; // a0_xxxxyyz
      current_out[839] = ax_xxyyyz + AB[0] * a0_xxyyyz; // a0_xxxyyyz
      current_out[840] = ax_xyyyyz + AB[0] * a0_xyyyyz; // a0_xxyyyyz
      current_out[841] = ax_yyyyyz + AB[0] * a0_yyyyyz; // a0_xyyyyyz
      current_out[842] = ay_yyyyyz + AB[1] * a0_yyyyyz; // a0_yyyyyyz
      current_out[843] = ax_xxxxzz + AB[0] * a0_xxxxzz; // a0_xxxxxzz
      current_out[844] = ax_xxxyzz + AB[0] * a0_xxxyzz; // a0_xxxxyzz
      current_out[845] = ax_xxyyzz + AB[0] * a0_xxyyzz; // a0_xxxyyzz
      current_out[846] = ax_xyyyzz + AB[0] * a0_xyyyzz; // a0_xxyyyzz
      current_out[847] = ax_yyyyzz + AB[0] * a0_yyyyzz; // a0_xyyyyzz
      current_out[848] = ay_yyyyzz + AB[1] * a0_yyyyzz; // a0_yyyyyzz
      current_out[849] = ax_xxxzzz + AB[0] * a0_xxxzzz; // a0_xxxxzzz
      current_out[850] = ax_xxyzzz + AB[0] * a0_xxyzzz; // a0_xxxyzzz
      current_out[851] = ax_xyyzzz + AB[0] * a0_xyyzzz; // a0_xxyyzzz
      current_out[852] = ax_yyyzzz + AB[0] * a0_yyyzzz; // a0_xyyyzzz
      current_out[853] = ay_yyyzzz + AB[1] * a0_yyyzzz; // a0_yyyyzzz
      current_out[854] = ax_xxzzzz + AB[0] * a0_xxzzzz; // a0_xxxzzzz
      current_out[855] = ax_xyzzzz + AB[0] * a0_xyzzzz; // a0_xxyzzzz
      current_out[856] = ax_yyzzzz + AB[0] * a0_yyzzzz; // a0_xyyzzzz
      current_out[857] = ay_yyzzzz + AB[1] * a0_yyzzzz; // a0_yyyzzzz
      current_out[858] = ax_xzzzzz + AB[0] * a0_xzzzzz; // a0_xxzzzzz
      current_out[859] = ax_yzzzzz + AB[0] * a0_yzzzzz; // a0_xyzzzzz
      current_out[860] = ay_yzzzzz + AB[1] * a0_yzzzzz; // a0_yyzzzzz
      current_out[861] = ax_zzzzzz + AB[0] * a0_zzzzzz; // a0_xzzzzzz
      current_out[862] = ay_zzzzzz + AB[1] * a0_zzzzzz; // a0_yzzzzzz
      current_out[863] = az_zzzzzz + AB[2] * a0_zzzzzz; // a0_zzzzzzz

    }
   {
     //current index a: xyyyzzz
      const auto a0_0 = current_data[24];
      const auto ax_0 = current_data[63];
      const auto ay_0 = current_data[64];
      const auto az_0 = current_data[69];
      const auto axx_0 = current_data[111];
      const auto axy_0 = current_data[112];
      const auto ayy_0 = current_data[113];
      const auto axz_0 = current_data[118];
      const auto ayz_0 = current_data[119];
      const auto azz_0 = current_data[124];
      const auto axxx_0 = current_data[169];
      const auto axxy_0 = current_data[170];
      const auto axyy_0 = current_data[171];
      const auto ayyy_0 = current_data[172];
      const auto axxz_0 = current_data[177];
      const auto axyz_0 = current_data[178];
      const auto ayyz_0 = current_data[179];
      const auto axzz_0 = current_data[184];
      const auto ayzz_0 = current_data[185];
      const auto azzz_0 = current_data[190];
      const auto axxxx_0 = current_data[238];
      const auto axxxy_0 = current_data[239];
      const auto axxyy_0 = current_data[240];
      const auto axyyy_0 = current_data[241];
      const auto ayyyy_0 = current_data[242];
      const auto axxxz_0 = current_data[247];
      const auto axxyz_0 = current_data[248];
      const auto axyyz_0 = current_data[249];
      const auto ayyyz_0 = current_data[250];
      const auto axxzz_0 = current_data[255];
      const auto axyzz_0 = current_data[256];
      const auto ayyzz_0 = current_data[257];
      const auto axzzz_0 = current_data[262];
      const auto ayzzz_0 = current_data[263];
      const auto azzzz_0 = current_data[268];
      const auto axxxxx_0 = current_data[319];
      const auto axxxxy_0 = current_data[320];
      const auto axxxyy_0 = current_data[321];
      const auto axxyyy_0 = current_data[322];
      const auto axyyyy_0 = current_data[323];
      const auto ayyyyy_0 = current_data[324];
      const auto axxxxz_0 = current_data[329];
      const auto axxxyz_0 = current_data[330];
      const auto axxyyz_0 = current_data[331];
      const auto axyyyz_0 = current_data[332];
      const auto ayyyyz_0 = current_data[333];
      const auto axxxzz_0 = current_data[338];
      const auto axxyzz_0 = current_data[339];
      const auto axyyzz_0 = current_data[340];
      const auto ayyyzz_0 = current_data[341];
      const auto axxzzz_0 = current_data[346];
      const auto axyzzz_0 = current_data[347];
      const auto ayyzzz_0 = current_data[348];
      const auto axzzzz_0 = current_data[353];
      const auto ayzzzz_0 = current_data[354];
      const auto azzzzz_0 = current_data[359];
      const auto axxxxxx_0 = current_data[413];
      const auto axxxxxy_0 = current_data[414];
      const auto axxxxyy_0 = current_data[415];
      const auto axxxyyy_0 = current_data[416];
      const auto axxyyyy_0 = current_data[417];
      const auto axyyyyy_0 = current_data[418];
      const auto ayyyyyy_0 = current_data[419];
      const auto axxxxxz_0 = current_data[424];
      const auto axxxxyz_0 = current_data[425];
      const auto axxxyyz_0 = current_data[426];
      const auto axxyyyz_0 = current_data[427];
      const auto axyyyyz_0 = current_data[428];
      const auto ayyyyyz_0 = current_data[429];
      const auto axxxxzz_0 = current_data[434];
      const auto axxxyzz_0 = current_data[435];
      const auto axxyyzz_0 = current_data[436];
      const auto axyyyzz_0 = current_data[437];
      const auto ayyyyzz_0 = current_data[438];
      const auto axxxzzz_0 = current_data[443];
      const auto axxyzzz_0 = current_data[444];
      const auto axyyzzz_0 = current_data[445];
      const auto ayyyzzz_0 = current_data[446];
      const auto axxzzzz_0 = current_data[451];
      const auto axyzzzz_0 = current_data[452];
      const auto ayyzzzz_0 = current_data[453];
      const auto axzzzzz_0 = current_data[458];
      const auto ayzzzzz_0 = current_data[459];
      const auto azzzzzz_0 = current_data[464];
      const auto axxxxxxx_0 = current_data[521];
      const auto axxxxxxy_0 = current_data[522];
      const auto axxxxxyy_0 = current_data[523];
      const auto axxxxyyy_0 = current_data[524];
      const auto axxxyyyy_0 = current_data[525];
      const auto axxyyyyy_0 = current_data[526];
      const auto axyyyyyy_0 = current_data[527];
      