//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_22.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot22(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[22] = {2.772473659127682e-02,2.497302810882349e-01,6.948552179522746e-01,1.365358277686830e+00,2.264707258937521e+00,
    3.397680865752056e+00,4.770515676273487e+00,6.391109747809455e+00,8.269300130906052e+00,1.041724021458193e+01,1.284991631425293e+01,1.558586475749591e+01,
    1.864818751747483e+01,2.206602920267685e+01,2.587679811930160e+01,3.012964996496447e+01,3.489125211513239e+01,4.025600692910713e+01,4.636595735293852e+01,
    5.345504450454067e+01,6.197009133480717e+01,7.305697947972854e+01};
  constexpr double aw[22] = {3.239426288419958e-01,2.597733961158877e-01,1.668671658256460e-01,8.567018730024628e-02,3.503375710968701e-02,
    1.135786693907002e-02,2.901293775296623e-03,5.794204327156650e-04,8.959797364061745e-05,1.060017177251762e-05,9.454538542285627e-07,6.242724506281515e-08,
    2.983121019039563e-09,1.002600077890922e-10,2.284807897122037e-12,3.365035612792274e-14,3.001521402980671e-16,1.479409975817158e-18,3.512144955836503e-21,
    3.207221691904951e-24,7.362126104297159e-28,1.456115308176244e-32};
  constexpr double x[8448] = {  2.436135707445798e-03, -2.703596612057743e-05,  2.247559280844219e-07, -1.658217083177863e-09,  1.144610141110474e-11,
 -7.566412118772039e-14,  4.848749855169289e-16, -3.033656875417933e-18,  1.861191931354629e-20, -1.122856675051252e-22,  6.673127873844494e-25, -3.910844243808119e-27,
  2.185708864482767e-02, -2.402605287034787e-04,  1.959153369763240e-06, -1.398989786996265e-08,  9.183903208438493e-11, -5.643607849223201e-13,  3.262596102213224e-15,
 -1.767692957770119e-17,  8.849782076212354e-20, -3.956950302041247e-22,  1.439116124958308e-24, -2.689887814776742e-27,  6.033675532481639e-02, -6.506157023237718e-04,
  5.100255376455887e-06, -3.399180055554679e-08,  1.992845346880462e-10, -1.018288808599922e-12,  4.265425107529695e-15, -1.129099233059991e-17, -2.492608658064168e-20,
  6.565666008043540e-22, -6.140102898705499e-24,  4.227187751400957e-26,  1.171561080845142e-01, -1.227063920925311e-03,  9.047262964965370e-06, -5.378108281908939e-08,
  2.541328969386994e-10, -7.928051041726740e-13, -5.870449118074423e-16,  3.306644072465391e-17, -3.082790404759953e-19,  1.867257785548481e-21, -7.055697410552917e-24,
 -2.252095867209928e-27,  1.912502364738459e-01, -1.925853271598792e-03,  1.302691190642819e-05, -6.471833588727611e-08,  1.919684605028151e-10,  3.488245569979888e-13,
 -9.666123343889779e-15,  7.481720723153022e-17, -3.147744028661134e-19, -9.598620285906667e-23,  1.428007320676584e-23, -1.341997808568907e-25,  2.812247112867592e-01,
 -2.693685650409513e-03,  1.622430041230831e-05, -6.017951025175882e-08,  1.320054259937107e-13,  1.952612473633433e-12, -1.551343012353105e-14,  4.987715252841106e-17,
  2.301834615268136e-19, -4.129968273262590e-21,  2.523303203277756e-23, -2.859451057981705e-26,  3.853773993852114e-01, -3.471620801365359e-03,  1.792296648129559e-05,
 -3.781285937836307e-08, -2.686178587057026e-10,  3.062207961413988e-12, -1.075604324654508e-14, -5.063480429340231e-17,  8.368285699889886e-19, -3.834885535076180e-21,
 -1.106581459291371e-23,  2.705728555526402e-25,  5.017256956622648e-01, -4.199459077903295e-03,  1.763128096091557e-05, -5.865435682920287e-10, -5.132409978814162e-10,
  2.796514837092490e-12,  4.665891345631572e-15, -1.472581478418755e-16,  6.589637417508062e-19,  3.042434764505473e-21, -5.110592428527149e-23,  1.618690326251007e-25,
  6.280390924099847e-01, -4.820303809100800e-03,  1.517373435992455e-05,  4.373471638198646e-08, -6.262983041855835e-10,  9.623680283987813e-13,  2.154958128292094e-14,
 -1.368505387620612e-16, -4.002150529266828e-19,  8.540438801810747e-21, -1.910389083506905e-23, -3.575295610298513e-25,  7.618769359021862e-01, -5.284977966239619e-03,
  1.073068788520661e-05,  8.459299814908474e-08, -5.426021932246699e-10, -1.707896576926545e-12,  2.740900270615122e-14, -7.108695369538251e-19, -1.313380495535533e-18,
  3.931549665824970e-21,  5.641675401494998e-23, -3.822283749361308e-25,  9.006311216663676e-01, -5.555962950412371e-03,  4.818088173521316e-06,  1.115817424033607e-07,
 -2.723764961608985e-10, -3.891111126611689e-12,  1.625262967860754e-14,  1.582111551339515e-16, -9.928889714187082e-19, -6.750197480140088e-21,  6.122508747647144e-23,
  2.837368064717373e-25,  1.041573351688837e+00, -5.610542903042222e-03, -1.791541398019190e-06,  1.174819345301847e-07,  9.749249230740211e-11, -4.415766080981768e-12,
 -5.818102473897483e-15,  2.013430916579849e-16,  3.633446668827837e-19, -1.014381343831734e-20, -2.332742453126261e-23,  5.429674653627188e-25,  1.181906418898220e+00,
 -5.442878209631365e-03, -8.195297280654665e-06,  1.004695311879968e-07,  4.366051143049862e-10, -2.966683395644127e-12, -2.436017721402961e-14,  8.706237901221773e-17,
  1.366178326305180e-18, -1.562936399372031e-21, -7.539560156022547e-23, -7.778840537823153e-26,  1.318818799996541e+00, -5.064797507991865e-03, -1.351283590847168e-05,
  6.478243318204034e-08,  6.250856479575769e-10, -2.997350880759294e-13, -2.726489807279945e-14, -8.508038477927131e-17,  9.971652992549257e-19,  8.033930670964691e-21,
 -2.128679950283049e-23, -5.131025468474703e-25,  1.449541634186828e+00, -4.505186995806451e-03, -1.703972768552247e-05,  1.957982161688262e-08,  6.044310875860601e-10,
  2.191858056367910e-12, -1.387141584484080e-14, -1.687645683662325e-16, -2.332985149865401e-19,  7.065013973222588e-21,  5.022900170290482e-23, -9.513723965376687e-26,
  1.571406954126185e+00, -3.807964835413339e-03, -1.837340612511530e-05, -2.371598682837127e-08,  4.014875854738112e-10,  3.301282137578487e-12,  5.007288434494846e-15,
 -1.096063571396170e-16, -9.623556160567058e-19, -1.318809433809522e-21,  3.849719800821810e-23,  3.362909247088116e-25,  1.681905832717335e+00, -3.028749538563520e-03,
 -1.748750824195177e-05, -5.480688713746653e-08,  1.138001496676565e-10,  2.699556133297750e-12,  1.610876756497795e-14,  1.383689392827425e-17, -5.963157371751551e-19,
 -5.472199059533420e-21, -1.672622015694891e-23,  1.279409634632209e-25,  1.778744936202507e+00, -2.230453939998539e-03, -1.473890088048924e-05, -6.757755123228708e-08,
 -1.371170082353869e-10,  1.051322650895861e-12,  1.403692607902588e-14,  8.303540019086022e-17,  1.676870601392960e-19, -2.065705296713202e-21, -2.685773066013294e-23,
 -1.583661770420775e-25,  1.859899859072115e+00, -1.478147954009569e-03, -1.080381621372699e-05, -6.183345104198168e-08, -2.621945046466420e-10, -5.042480289695236e-13,
  4.172093124084099e-15,  5.898290284565455e-17,  4.215729867801718e-19,  1.847731998961335e-21,  1.126695050758226e-24, -6.838624442141538e-26,  1.923663620185946e+00,
 -8.336196776343939e-04, -6.553105585029669e-06, -4.312933676999708e-08, -2.433398936731427e-10, -1.135090725188612e-12, -3.694376410283617e-15,  5.795189060422359e-19,
  1.385187465076287e-19,  1.454238056243344e-21,  1.034739437071824e-23,  5.519290930513125e-26,  1.968689162384598e+00, -3.501092432732455e-04, -2.888914509051328e-06,
 -2.072015195167289e-08, -1.352240706230943e-10, -8.140180406159737e-13, -4.507519535550795e-15, -2.251062119381820e-17, -9.596375049041885e-20, -2.884260999480523e-22,
  1.535469616625348e-25,  1.203567198585768e-26,  1.994030955632417e+00, -6.762307077915634e-05, -5.728659291250058e-07, -4.296529313578961e-09, -3.005758022698577e-11,
 -2.006202642742474e-13, -1.292239258967468e-15, -8.082380290974664e-18, -4.924718273913422e-20, -2.927317960626483e-22, -1.697359655942552e-24, -9.586231358878459e-27,
  2.331466161991986e-03, -2.531451081654002e-05,  2.059081825161378e-07, -1.486581158694728e-09,  1.004264126475742e-11, -6.498268842688528e-14,  4.076979121521392e-16,
 -2.497918750622396e-18,  1.501137096711122e-20, -8.873775697899422e-23,  5.169199713081864e-25, -2.970722319501871e-27,  2.092636392072805e-02, -2.252346676267562e-04,
  1.799731999178754e-06, -1.260667934865169e-08,  8.129634759409484e-11, -4.916906898740727e-13,  2.805225395323379e-15, -1.506205497201644e-17,  7.525839536822009e-20,
 -3.407130040939186e-22,  1.305760082796897e-24, -3.274878195117806e-27,  5.781338775417611e-02, -6.113925725469840e-04,  4.710830734634579e-06, -3.096072094366282e-08,
  1.799164735388401e-10, -9.197822802705382e-13,  3.941345966766126e-15, -1.175439611500588e-17, -5.290706822829014e-21,  4.450744769478101e-22, -4.506956848105936e-24,
  3.232033110104212e-26,  1.123886172397560e-01, -1.157199393586037e-03,  8.425761811738629e-06, -4.984227527786334e-08,  2.382053941255032e-10, -7.968384301584752e-13,
  2.104237613706276e-16,  2.422263196197732e-17, -2.461252547768979e-19,  1.586953986866928e-21, -6.875428466876966e-24,  9.331330568906227e-27,  1.837504097004151e-01,
 -1.824691789273809e-03,  1.226891213932546e-05, -6.160294143749319e-08,  1.967888848766649e-10,  1.408384271473339e-13, -7.712058088340636e-15,  6.478839611385013e-17,
 -3.092854841804587e-19,  3.665121265147411e-22,  9.072546917930236e-24, -1.029764812168426e-25,  2.707049876500450e-01, -2.566776988744168e-03,  1.550338348706220e-05,
 -5.988472156830019e-08,  3.557789687742901e-11,  1.597750727921285e-12, -1.403472809824901e-14,  5.505577156644761e-17,  9.926030793125810e-20, -3.157448689538745e-21,
  2.314459011543941e-23, -6.278987828890136e-26,  3.717747127360949e-01, -3.330120589569672e-03,  1.744539928837143e-05, -4.163524698607487e-08, -2.100549015924638e-10,
  2.789945536306458e-12, -1.182015348543745e-14, -2.612861422832530e-17,  6.934782831770002e-19, -4.060976955616779e-21, -7.733373396890560e-25,  1.973447099991153e-25,
  4.852097238299077e-01, -4.058572302408496e-03,  1.757683298609155e-05, -8.346230705685278e-09, -4.565121747148620e-10,  2.861487771016324e-12,  8.516186498505214e-16,
 -1.247982253711199e-16,  7.335974809557975e-19,  1.160418294439696e-21, -4.258608191335943e-23,  2.181170993318432e-25,  6.090037424138014e-01, -4.696983382167731e-03,
  1.563914889302821e-05,  3.389469778074069e-08, -6.021957163491824e-10,  1.432407117916347e-12,  1.758347245815008e-14, -1.449140471689792e-16, -1.099496221675304e-19,
  7.500835742223016e-21, -3.189471815122025e-23, -2.231270683019333e-25,  7.409149326214457e-01, -5.195221951211446e-03,  1.169270239610683e-05,  7.567375055503405e-08,
 -5.702075118514671e-10, -1.054923038786669e-12,  2.682488904950983e-14, -4.007323854088189e-17, -1.135486144091063e-18,  5.829940712477923e-21,  3.808263830151777e-23,
 -4.399683780085613e-25,  8.784927272797981e-01, -5.512142177386554e-03,  6.128425410456134e-06,  1.066237729851582e-07, -3.459587092937747e-10, -3.451686448116158e-12,
  2.020469093914950e-14,  1.230444049229379e-16, -1.189303659715044e-18, -4.106467937970155e-21,  6.957630771806394e-23,  9.408655793131765e-26,  1.019111472578854e+00,
 -5.619216335069330e-03, -3.753326009752469e-07,  1.183296410773334e-07,  8.242810889934948e-12, -4.486778092204211e-12, -7.362378845772135e-17,  2.069949780372717e-16,
 -1.271736604844387e-20, -1.058337421952546e-20,  1.595453673395012e-24,  5.766504729829577e-25,  1.160011578444176e+00, -5.503504005053721e-03, -6.949807247101154e-06,
  1.069496948434248e-07,  3.716476957237671e-10, -3.517207489582897e-12, -2.132301277694312e-14,  1.292945732243651e-16,  1.255335534110286e-18, -4.588397624382011e-21,
 -7.438489541593305e-23,  1.266211054852502e-25,  1.298348567191633e+00, -5.169621305502276e-03, -1.267575352978157e-05,  7.469955077054224e-08,  6.123741524583653e-10,
 -9.788136395329816e-13, -2.915836914471579e-14, -4.875254618864739e-17,  1.265548871387072e-18,  6.724174615659153e-21, -4.424059726759730e-23, -5.182820470225475e-25,
  1.431249974963276e+00, -4.640397374518845e-03, -1.674536082785593e-05,  2.958170930871514e-08,  6.445530379426667e-10,  1.801644193440220e-12, -1.866040226809580e-14,
 -1.717839131807616e-16,  5.576673551236182e-20,  8.942716802130885e-21,  4.243032270709773e-23, -2.631125973563472e-25,  1.555879478705350e+00, -3.955976192224507e-03,
 -1.861725816465103e-05, -1.675855732597233e-08,  4.684482605901380e-10,  3.381116923340363e-12,  1.502325235461200e-15, -1.408350438367588e-16, -9.785240159558170e-19,
  5.191051589824297e-22,  5.336877510487299e-23,  3.319199872852420e-25,  1.669506918389468e+00, -3.171245141154030e-03, -1.813241606138815e-05, -5.253305936935453e-08,
  1.716768263974408e-10,  3.088473133284780e-12,  1.619858703190198e-14, -8.513621353041320e-18, -8.037420283379009e-19, -5.999882472384433e-21, -8.905116253842825e-24,
  2.312193930348286e-25,  1.769582111743086e+00, -2.351644444430973e-03, -1.556223937903644e-05, -6.958410713770871e-08, -1.125305546155957e-10,  1.416638660525283e-12,
  1.642430349629419e-14,  8.699041116485857e-17,  7.228219075164278e-20, -3.281624027278384e-21, -3.396284752645160e-23, -1.615841458801038e-25,  1.853809605209235e+00,
 -1.567618534483796e-03, -1.157130187744797e-05, -6.610321265949237e-08, -2.711362498513931e-10, -3.827135150132894e-13,  6.022503607303695e-15,  7.353965915834989e-17,
  4.880720373139001e-19,  1.820863184272245e-21, -2.784956230352916e-24, -1.116450870193756e-25,  1.920220918199866e+00, -8.881826755010972e-04, -7.094782982808856e-06,
 -4.720919187464489e-08, -2.669242394651704e-10, -1.223008806643900e-12, -3.607625343205842e-15,  5.934548241394638e-18,  1.989304036911799e-19,  1.919291050669737e-21,
  1.296714382197902e-23,  6.365929286022208e-26,  1.967240874441045e+00, -3.742531841713962e-04, -3.151094735762414e-06, -2.302007843998282e-08, -1.526391240532352e-10,
 -9.301186071353689e-13, -5.182354623406123e-15, -2.574525492551345e-17, -1.060906433755596e-19, -2.696452502196716e-22,  8.415556684870180e-25,  1.975095615370608e-26,
  1.993750958999780e+00, -7.242072356714853e-05, -6.274478946159256e-07, -4.811315197044169e-09, -3.439941719980049e-11, -2.345379912767796e-13, -1.542291338714081e-15,
 -9.840878986155239e-18, -6.111644409930951e-20, -3.698598394635186e-22, -2.180185509202116e-24, -1.249278350987451e-26,  2.233393399838534e-03, -2.373596508749644e-05,
  1.889920730101107e-07, -1.335787330586235e-09,  8.835438221995213e-12, -5.598577329442562e-14,  3.440280700754721e-16, -2.064919317166365e-18,  1.215953752624219e-20,
 -7.045360695968986e-23,  4.023963310384389e-25, -2.268296655645016e-27,  2.005329311611917e-02, -2.114205439319965e-04,  1.655943249462887e-06, -1.138108892002495e-08,
  7.210298677584047e-11, -4.291649766390733e-13,  2.415429893220185e-15, -1.284024268647218e-17,  6.389752606537671e-20, -2.914275107625752e-22,  1.157599474768648e-24,
 -3.403621080703143e-27,  5.544090502701648e-02, -5.751444692287184e-04,  4.355983350516958e-06, -2.822419508487133e-08,  1.624400516305935e-10, -8.291449582822907e-13,
  3.612028687226623e-15, -1.169949831276243e-17,  7.806975379376643e-21,  2.907708952618181e-22, -3.265817466833848e-24,  2.440760715482574e-26,  1.078909337190525e-01,
 -1.092122144767847e-03,  7.849997794678420e-06, -4.615799348297838e-08,  2.223696817338859e-10, -7.844885313178005e-13,  7.866088241391915e-16,  1.720856634506639e-17,
 -1.938265586463733e-19,  1.322245348173625e-21, -6.316517944655668e-24,  1.533276269764883e-26,  1.766433390845058e-01, -1.729443755052614e-03,  1.154863058987862e-05,
 -5.844124481117278e-08,  1.978959798093469e-10, -2.358595643499291e-14, -6.034108800516520e-15,  5.516405784377933e-17, -2.905737445339299e-19,  6.471928385192499e-22,
  5.161311858649344e-24, -7.555590811500094e-26,  2.606813993092471e-01, -2.445612397992211e-03,  1.478917898397646e-05, -5.907760708227352e-08,  6.429087527931144e-11,
  1.279676136002564e-12, -1.246454524932799e-14,  5.658631529437571e-17,  1.535850453375953e-21, -2.292682655015294e-21,  1.997998704394600e-23, -7.849592008376427e-26,
  3.587301172901884e-01, -3.192608882532110e-03,  1.692740191488434e-05, -4.456535296426795e-08, -1.571397003991237e-10,  2.499855355319003e-12, -1.226300477625856e-14,
 -6.266669090872430e-18,  5.486292170565628e-19, -3.938975855008438e-21,  6.375035063394909e-24,  1.290140859120939e-25,  4.692558600703928e-01, -3.918478077932088e-03,
  1.743474209750558e-05, -1.519261691854189e-08, -3.993472412057312e-10,  2.842674423831213e-12, -2.310032513604831e-15, -1.009642021762793e-16,  7.470957536529621e-19,
 -3.436600216014991e-22, -3.249855243648457e-23,  2.346653370824956e-25,  5.904683830711169e-01, -4.570404723406317e-03,  1.598909035898237e-05,  2.451029667694291e-08,
 -5.696572350761767e-10,  1.805562031811305e-12,  1.351536107746243e-14, -1.443750368508047e-16,  1.351063412341011e-19,  6.067631168103799e-21, -3.882605650632264e-23,
 -9.439014032696747e-26,  7.203266584698488e-01, -5.098204466866849e-03,  1.254546332615818e-05,  6.641616954639318e-08, -5.849792471494628e-10, -4.284927319857094e-13,
  2.522756771507608e-14, -7.279484918349811e-17, -9.028844210638467e-19,  6.963619083527868e-21,  1.864877208422820e-23, -4.336642641398024e-25,  8.565501772405770e-01,
 -5.458096003661975e-03,  7.372508892686175e-06,  1.005636031734981e-07, -4.098869826768052e-10, -2.929848723132812e-12,  2.309876188653498e-14,  8.316323125023375e-17,
 -1.286553447622213e-18, -1.296362774438319e-21,  6.958100383303853e-23, -9.053654685534657e-26,  9.966375891545400e-01, -5.616543741822877e-03,  1.042458189819914e-06,
  1.177455108217575e-07, -8.104268207571981e-11, -4.419391118547986e-12,  5.659634582286305e-15,  2.005535737943124e-16, -3.865184143794862e-19, -1.002016713716659e-20,
  2.622238668598898e-23,  5.297743402922552e-25,  1.137894629129324e+00, -5.553873309873493e-03, -5.633140600401409e-06,  1.123068099658226e-07,  2.965020012848522e-10,
 -3.981150347525257e-12, -1.716921968097311e-14,  1.662627313876368e-16,  1.038499587744464e-18, -7.390941785664181e-21, -6.424752983847653e-23,  3.312766798441009e-25,
  1.277473179955559e+00, -5.267276926320798e-03, -1.172134124781545e-05,  8.430252545744736e-08,  5.857138520446028e-10, -1.690208757940874e-12, -2.992277279337368e-14,
 -4.767182370849913e-18,  1.470401341039598e-18,  4.514037775717865e-21, -6.573330205844638e-23, -4.450655693303522e-25,  1.412422958811714e+00, -4.772762448351187e-03,
 -1.632739741205301e-05,  4.015685998704397e-08,  6.757201645142577e-10,  1.296585359519525e-12, -2.339478162400503e-14, -1.645466058971510e-16,  4.049847698680639e-19,
  1.035569845057007e-20,  2.691526003787666e-23, -4.415895308267054e-25,  1.539756610822962e+00, -4.105586105254808e-03, -1.877115575241575e-05, -8.721851453880076e-09,
  5.360935857422760e-10,  3.366346504303403e-12, -2.873525798367988e-15, -1.714089317192655e-16, -9.180021540884112e-19,  2.932875457799778e-21,  6.688456684718605e-23,
  2.719443427801635e-25,  1.656527898940677e+00, -3.318774529308194e-03, -1.874422533633435e-05, -4.927108740202284e-08,  2.372987665531291e-10,  3.471270806678522e-12,
  1.556729305021923e-14, -3.773608754325424e-17, -1.023383124513081e-18, -6.117860057972252e-21,  3.891846066704670e-24,  3.526006960422065e-25,  1.759921209550676e+00,
 -2.479510708353802e-03, -1.640704496928537e-05, -7.113568517572244e-08, -8.005780196413401e-11,  1.840193220035111e-12,  1.887270834453798e-14,  8.713732426724298e-17,
 -7.199052957194698e-20, -4.778374884159779e-21, -4.072509576791558e-23, -1.408359258535102e-25,  1.847348861582487e+00, -1.663436179865481e-03, -1.239079467018883e-05,
 -7.049404085909973e-08, -2.771689568381867e-10, -2.116396888501188e-13,  8.309911371569568e-15,  9.017474371759685e-17,  5.502914409712144e-19,  1.595343011076873e-21,
 -8.910790745656867e-24, -1.692874960206655e-25,  1.916550978083644e+00, -9.472814731678683e-04, -7.687740249334181e-06, -5.168029516623548e-08, -2.922327841156804e-10,
 -1.306810913992281e-12, -3.341203903162033e-15,  1.351154308845589e-17,  2.780550326290039e-19,  2.496009079701919e-21,  1.591198785248082e-23,  6.954168436956758e-26,
  1.965691634128421e+00, -4.006098825947951e-04, -3.442625488043589e-06, -2.561813330129860e-08, -1.725456712368418e-10, -1.063537839409749e-12, -5.952152661822386e-15,
 -2.928709734025783e-17, -1.149552131735566e-19, -2.155442626587549e-22,  1.946923546012229e-24,  3.123127088994638e-26,  1.993450857582806e+00, -7.768097654088544e-05,
 -6.886475966529566e-07, -5.401340923596840e-09, -3.948384269276941e-11, -2.750934483208605e-13, -1.847344324306116e-15, -1.202761225554876e-17, -7.614305696529178e-20,
 -4.691133288457998e-22, -2.810393459151996e-24, -1.632887030694092e-26,  2.141375176988548e-03, -2.228582533434148e-05,  1.737752778048104e-07, -1.202948326098930e-09,
  7.793823937871389e-12, -4.838118076377334e-14,  2.912975745631741e-16, -1.713473943497715e-18,  9.890413828951708e-21, -5.618761618182369e-23,  3.147408007023808e-25,
 -1.740679787648282e-27,  1.923326792218208e-02, -1.987003106497140e-04,  1.526018698786108e-06, -1.029307601055454e-08,  6.407142286754868e-11, -3.752873090624643e-13,
  2.083014006945632e-15, -1.095473920011091e-17,  5.420370919657041e-20, -2.480945413132200e-22,  1.009999152007698e-24, -3.275097375261953e-27,  5.320793859813304e-02,
 -5.416084103443404e-04,  4.032354973140256e-06, -2.575321812261600e-08,  1.466976887068727e-10, -7.463502505724154e-13,  3.289345744700696e-15, -1.130542053023122e-17,
  1.616434785172094e-20,  1.796839844962415e-22, -2.333468018200633e-24,  1.823234710403373e-26,  1.036446209243618e-01, -1.031478446538551e-03,  7.316935341003826e-06,
 -4.272441923994286e-08,  2.069042844251278e-10, -7.604864445286061e-13,  1.188430651183690e-15,  1.172034449325847e-17, -1.506023726721543e-19,  1.083985022086082e-21,
 -5.579378088320848e-24,  1.770539131443278e-26,  1.699059765026106e-01, -1.639806146818142e-03,  1.086629400144832e-05, -5.528604481839632e-08,  1.960958524573184e-10,
 -1.508973591605350e-13, -4.615941088904167e-15,  4.627225044796071e-17, -2.642953588963482e-19,  7.941689569064351e-22,  2.352098976390492e-24, -5.295559048582169e-26,
  2.511311138052867e-01, -2.330115361962504e-03,  1.408721302916561e-05, -5.785992078529301e-08,  8.702096951713281e-11,  9.994746869622791e-13, -1.089078835800717e-14,
  5.546225549514723e-17, -6.746355482826512e-20, -1.564167178406711e-21,  1.642514893245980e-23, -8.140627773666153e-26,  3.462270777608718e-01, -3.059367850422865e-03,
  1.637913029296495e-05, -4.669562789778271e-08, -1.100902232366749e-10,  2.205292471379786e-12, -1.221359351256275e-14,  9.079851261056320e-18,  4.126204007344367e-19,
 -3.588255565685575e-21,  1.074247788553572e-23,  7.158841518642205e-26,  4.538596013104806e-01, -3.779833712494552e-03,  1.721595725710032e-05, -2.113126995906979e-08,
 -3.432632651869368e-10,  2.755991267285970e-12, -4.805863274614876e-15, -7.748586282910552e-17,  7.137984836127528e-19, -1.439097544358561e-21, -2.236727136660861e-23,
  2.219441463697468e-25,  5.724442374117193e-01, -4.441467600884864e-03,  1.622977185546602e-05,  1.570093168904557e-08, -5.306264085801357e-10,  2.082100184053524e-12,
  9.564051752931022e-15, -1.368624966008029e-16,  3.248940282588885e-19,  4.465063405892201e-21, -4.051896825004854e-23,  1.303965719021288e-26,  7.001393904185171e-01,
 -4.994812339724274e-03,  1.328612108065528e-05,  5.702009076797174e-08, -5.876754585957697e-10,  1.494808681414480e-13,  2.282332072640916e-14, -9.756870117640890e-17,
 -6.432462523886984e-19,  7.341691898104672e-21,  6.741404514355539e-25, -3.764024932136470e-25,  8.348432331849316e-01, -5.394404622915452e-03,  8.538088810373279e-06,
  9.356746409081686e-08, -4.627757970159828e-10, -2.352211934038814e-12,  2.484771068313596e-14,  4.177326872729365e-17, -1.284525205113961e-18,  1.359353454507448e-21,
  6.209638615623817e-23, -2.424273431008292e-25,  9.741970022720770e-01, -5.602580995558232e-03,  2.444736477471886e-06,  1.157509854289643e-07, -1.676259443978493e-10,
 -4.217896513566609e-12,  1.104944429921909e-14,  1.826596824207902e-16, -7.230133723170170e-19, -8.535300131156942e-21,  4.715732024425858e-23,  4.115613232177103e-25,
  1.115597646662989e+00, -5.593473247938976e-03, -4.259690290449372e-06,  1.163931163335058e-07,  2.131537675609313e-10, -4.333854945832410e-12, -1.209197004705112e-14,
  1.947733286487284e-16,  7.301744013197908e-19, -9.615722364264700e-21, -4.575352705935873e-23,  5.007438190568318e-25,  1.256223158990045e+00, -5.356844643367335e-03,
 -1.065472423400619e-05,  9.336454640562990e-08,  5.447454464771569e-10, -2.404509002515181e-12, -2.937691295089476e-14,  4.434224741303880e-17,  1.581210638412371e-18,
  1.532755495308383e-21, -8.220799821567152e-23, -2.911340787286571e-25,  1.393073984396970e+00, -4.901268537528918e-03, -1.577989323663776e-05,  5.114379382119359e-08,
  6.956729863983491e-10,  6.816382700432024e-13, -2.776336184126672e-14, -1.454554231199178e-16,  7.920334861509221e-19,  1.099443044062945e-20,  3.863249273595097e-24,
 -6.000039646751038e-25,  1.523033477614462e+00, -4.256023098525541e-03, -1.882214793406602e-05,  3.888241814877802e-10,  6.023254415511050e-10,  3.236585554245027e-12,
 -8.064560233106833e-15, -1.985577667760086e-16, -7.616664132744835e-19,  5.814871768187487e-21,  7.627492664609972e-23,  1.427647580349679e-25,  1.642949246858201e+00,
 -3.471023392774900e-03, -1.931034205610710e-05, -4.489903247216603e-08,  3.103547654689679e-10,  3.828304323508206e-12,  1.401949807599050e-14, -7.394560435631101e-17,
 -1.236744375486331e-18, -5.614512556022882e-21,  2.219523666799069e-23,  4.785061959326803e-25,  1.749735220837630e+00, -2.614200395643357e-03, -1.726706224386505e-05,
 -7.209674636458388e-08, -3.852892182880501e-11,  2.321985568789769e-12,  2.125213309490397e-14,  8.175553394144312e-17, -2.747070864042578e-19, -6.517499072072408e-21,
 -4.581280320788910e-23, -8.317237384582468e-26,  1.840491399838247e+00, -1.766021888025548e-03, -1.326343352824924e-05, -7.495087547851198e-08, -2.791923567115590e-10,
  2.013697719986196e-14,  1.108938807395939e-14,  1.086184310255611e-16,  5.993297825721709e-19,  1.069617840807377e-21, -1.790477110161909e-23, -2.419264604459188e-25,
  1.912634805773525e+00, -1.011345550591160e-03, -8.336834349634939e-06, -5.656931856157776e-08, -3.191346820586378e-10, -1.381366914030720e-12, -2.823892953444690e-15,
  2.397587445156151e-17,  3.801114289486804e-19,  3.194241188069120e-21,  1.899942837417834e-23,  6.942983830918540e-26,  1.964032097157989e+00, -4.294291577392365e-04,
 -3.767335328972334e-06, -2.855707808014498e-08, -1.953135443237712e-10, -1.216652207238068e-12, -6.824733847987833e-15, -3.307183816288336e-17, -1.209415932849953e-19,
 -1.056781571754002e-22,  3.668911553778806e-24,  4.808935420832399e-26,  1.993128689079670e+00, -8.346059566570737e-05, -7.574438267318478e-07, -6.079625959586221e-09,
 -4.545784504265445e-11, -3.237627396763324e-13, -2.220931619333520e-15, -1.475758227872386e-17, -9.524025916019138e-20, -5.972890440088756e-22, -3.635273229435236e-24,
 -2.139894553097094e-26,  2.054923754908780e-03, -2.095131586141936e-05,  1.600573607787731e-07, -1.085623971930622e-09,  6.892402787266185e-12, -4.193178820321684e-14,
  2.474636157035698e-16, -1.427057112667234e-18,  8.076971272963681e-21, -4.500441785739535e-23,  2.473167177332546e-25, -1.342317824259825e-27,  1.846212457795286e-02,
 -1.869693545741289e-04,  1.408413475590747e-06, -9.325363829705574e-09,  5.704173363132528e-11, -3.287877454088444e-13,  1.799275861024869e-15, -9.355603562741673e-18,
  4.596540426322138e-20, -2.105062431229294e-22,  8.713292341003747e-25, -3.013555109295370e-27,  5.110412026243293e-02, -5.105469303726402e-04,  3.736920345425492e-06,
 -2.352128834204346e-08,  1.325348111978070e-10, -6.711407536083167e-13,  2.980888251498990e-15, -1.070119975220012e-17,  2.113246210873074e-20,  1.008985271412868e-22,
 -1.640363862131776e-24,  1.348282711759191e-26,  9.963260898834460e-02, -9.749386033239682e-04,  6.823608502568907e-06, -3.953397657964525e-08,  1.920036936999227e-10,
 -7.285360956213631e-13,  1.454698762703846e-15,  7.483907444339205e-18, -1.154065701872298e-19,  8.765564606883719e-22, -4.791130285395136e-24,  1.784675952237551e-26,
  1.635164858316876e-01, -1.555476453237837e-03,  1.022156873846386e-05, -5.217825028206183e-08,  1.920701998460737e-10, -2.470612012500930e-13, -3.434319614612949e-15,
  3.828618048144350e-17, -2.345220485053872e-19,  8.472140707699026e-22,  4.292893925363983e-25, -3.521757092763418e-26,  2.420316857178691e-01, -2.220169834687039e-03,
  1.340186307417099e-05, -5.632134792255574e-08,  1.045209968496906e-10,  7.564394664561152e-13, -9.375670435563969e-15,  5.252231144005134e-17, -1.128019259592886e-19,
 -9.777430008088599e-22,  1.293348631558686e-23, -7.632610633333750e-26,  3.342480855912113e-01, -2.930602893655013e-03,  1.580961829710254e-05, -4.812003941485688e-08,
 -6.888782736001318e-11,  1.916592834334451e-12, -1.179330065912285e-14,  2.030510568563438e-17,  2.918077663945853e-19, -3.109550996769974e-21,  1.287071751810690e-23,
  2.736792323979365e-26,  4.390139894544799e-01, -3.643209578088459e-03,  1.693122549317451e-05, -2.618948234351894e-08, -2.894594696194867e-10,  2.617142814934054e-12,
 -6.664596838466646e-15, -5.562727285851278e-17,  6.481676711562348e-19, -2.146632172990200e-21, -1.323648447588924e-23,  1.909282368995119e-25,  5.549390371349534e-01,
 -4.311016872260818e-03,  1.636865397993104e-05,  7.555236702769061e-09, -4.869927752857874e-10,  2.266963843216350e-12,  5.899403324293331e-15, -1.242041416955571e-16,
  4.568347135113821e-19,  2.881019072787699e-21, -3.811431666735240e-23,  9.113532608801666e-26,  6.803768273937506e-01, -4.885945838647404e-03,  1.391413775704844e-05,
  4.766999440171068e-08, -5.794405165651435e-10,  6.623751278334445e-13,  1.984281252603305e-14, -1.139495144524575e-16, -3.822296715707259e-19,  7.062129388381877e-21,
 -1.399722991905074e-23, -2.867811693033905e-25,  8.134091530889491e-01, -5.321737912387743e-03,  9.615025286837508e-06,  8.581941370228801e-08, -5.037855960458348e-10,
 -1.746414101861827e-12,  2.545253826353327e-14,  1.907871227447300e-18, -1.193764405141890e-18,  3.596103012392533e-21,  4.900590273333251e-23, -3.432629897868622e-25,
  9.518345184555533e-01, -5.577518959856588e-03,  3.814923703560202e-06,  1.124102037339818e-07, -2.489324022774280e-10, -3.894220688815119e-12,  1.579659970302433e-14,
  1.550036623760170e-16, -9.923860999505528e-19, -6.333454456316197e-21,  6.171348611108257e-23,  2.443414401191909e-25,  1.093164517551820e+00, -5.621912603372371e-03,
 -2.845416381885633e-06,  1.190962894269823e-07,  1.240285874959765e-10, -4.556309453907120e-12, -6.365496414086071e-15,  2.122923944187629e-16,  3.567136942820533e-19,
 -1.096915694097544e-20, -2.116360555973371e-23,  6.040373595032967e-25,  1.234632604587518e+00, -5.437456669470204e-03, -9.483763776271130e-06,  1.016579700455081e-07,
  4.897350571122799e-10, -3.088910520431620e-12, -2.742330485286720e-14,  9.516771287542221e-17,  1.574659407338849e-18, -1.950914411104141e-21, -9.036828333639361e-23,
 -7.096535871840826e-26,  1.373220587083423e+00, -5.024862764036582e-03, -1.509905414459611e-05,  6.234609177752004e-08,  7.023290051513989e-10, -3.032597845404122e-14,
 -3.142187828128487e-14, -1.138015869250174e-16,  1.183921073339577e-18,  1.058558049138087e-20, -2.505293507725864e-23, -7.020261923265889e-25,  1.505708498085403e+00,
 -4.406412944206803e-03, -1.875756199807646e-05,  1.053143161338869e-08,  6.646579934324185e-10,  2.973781238497973e-12, -1.392968020383195e-14, -2.189837514068169e-16,
 -4.963852086070640e-19,  8.937103022964806e-21,  7.836168643399868e-23, -5.956720818524349e-26,  1.628752902480844e+00, -3.627570932320301e-03, -1.981675261131447e-05,
 -3.930333285050631e-08,  3.900939437537979e-10,  4.135274909698716e-12,  1.136604429080048e-14, -1.165407866274693e-16, -1.417499884578002e-18, -4.271720086400242e-21,
  4.572859181071853e-23,  5.856482618297143e-25,  1.738996656996000e+00, -2.755804304038904e-03, -1.813429761995859e-05, -7.231322110175817e-08,  1.319062279152836e-11,
  2.858283690285739e-12,  2.338039127198388e-14,  6.885158251884923e-17, -5.429580857989867e-19, -8.395381154305824e-21, -4.729116383437318e-23,  2.551542111637227e-26,
  1.833209294038442e+00, -1.875802808744513e-03, -1.418958344812459e-05, -7.939919726715678e-08, -2.758704859061076e-10,  3.249753561762781e-13,  1.440387952021747e-14,
  1.282525963412350e-16,  6.221589449484467e-19,  1.161848090038624e-22, -3.038850349698173e-23, -3.271570847433297e-25,  1.908451609608749e+00, -1.080844479675924e-03,
 -9.047226045873874e-06, -6.189992014492771e-08, -3.473778033871650e-10, -1.439598325061786e-12, -1.963911548204333e-15,  3.813185308120280e-17,  5.095004080074161e-19,
  4.012977834519061e-21,  2.185392562832778e-23,  5.783662761581811e-26,  1.962251855310484e+00, -4.609936141286050e-04, -4.129603063603348e-06, -3.188598134151588e-08,
 -2.213618025563566e-10, -1.391997675234667e-12, -7.805271316955233e-15, -3.696999642525812e-17, -1.215358625243015e-19,  8.995066796116076e-23,  6.290174360552528e-24,
  7.252627741996742e-26,  1.992782247414990e+00, -8.982484451815362e-05, -8.349867553598281e-07, -6.861796566252460e-09, -5.250146158912288e-11, -3.823889541173243e-13,
 -2.680255365364837e-15, -1.817932263383736e-17, -1.196034894166874e-19, -7.633699341635140e-22, -4.717544870187696e-24, -2.810380551039382e-26,  1.973599467026220e-03,
 -1.972115389746896e-05,  1.476648781930608e-07, -9.817449995439182e-10,  6.110066554938171e-12, -3.644437780583706e-14,  2.108939076774579e-16, -1.192717008489243e-18,
  6.621522629164201e-21, -3.619796994942144e-23,  1.952045299498142e-25, -1.040033687746829e-27,  1.773609431142663e-02, -1.761346338259316e-04,  1.301775479941707e-06,
 -8.463042037532347e-09,  5.087741656363023e-11, -2.885891647476076e-13,  1.556818684947401e-15, -7.999489495448038e-18,  3.898340920875600e-20, -1.782134958494065e-22,
  7.456343844341215e-25, -2.694855255497860e-27,  4.911998522815876e-02, -4.817455353609303e-04,  3.466957590605708e-06, -2.150432726704735e-08,  1.198035465907347e-10,
 -6.031156927343859e-13,  2.691184156097235e-15, -9.978416114734800e-18,  2.371623775335539e-20,  4.601256007008235e-23, -1.130198991155867e-24,  9.872796674262525e-27,
  9.583910001422283e-02, -9.221962359007259e-04,  6.367158626419929e-06, -3.657652222892052e-08,  1.777970353115995e-10, -6.914981694121651e-13,  1.617035074470678e-15,
  4.260327688938888e-18, -8.711319140807524e-20,  7.003510420283675e-22, -4.027434974368974e-24,  1.671789702588476e-26,  1.574542327968593e-01, -1.476156619129041e-03,
  9.613691867266494e-06, -4.914878564061633e-08,  1.863873092160469e-10, -3.174405170911654e-13, -2.462779963613113e-15,  3.127001218843463e-17, -2.040476795275339e-19,
  8.376208312709548e-22, -8.117628564949408e-25, -2.186214532777127e-26,  2.333611973207657e-01, -2.115628852274236e-03,  1.273650190971783e-05, -5.453971524135541e-08,
  1.175165123044817e-10,  5.486338670282240e-13, -7.960197988833771e-15,  4.844289562536769e-17, -1.394751008368737e-19, -5.250179314455426e-22,  9.771449927782769e-24,
 -6.693692654116685e-26,  3.227749480496742e-01, -2.806451632318576e-03,  1.522678030012239e-05, -4.893075726413811e-08, -3.333528338852400e-11,  1.641331473918426e-12,
 -1.111013774300279e-14,  2.795294845580407e-17,  1.893275340473565e-19, -2.580731627649911e-21,  1.334292825456092e-23, -3.871516175832342e-27,  4.247099543675463e-01,
 -3.509091683137860e-03,  1.659086141143909e-05, -3.041126999295094e-08, -2.388304812997185e-10,  2.440770837050929e-12, -7.944035580791579e-15, -3.620879143056581e-17,
  5.632807699563671e-19, -2.519410502416792e-21, -5.692391330864510e-24,  1.512335682663345e-25,  5.379572599012974e-01, -4.179833961075453e-03,  1.641408347237202e-05,
  1.326077571541027e-10, -4.405104302480814e-10,  2.368554373228325e-12,  2.639894003218765e-15, -1.082113564514832e-16,  5.342260694124804e-19,  1.452755160197122e-21,
 -3.295420336779526e-23,  1.385165580300411e-25,  6.610590721901775e-01, -4.772501015238116e-03,  1.443106936646854e-05,  3.852969448485612e-08, -5.616953386908072e-10,
  1.099163922035746e-12,  1.651830283648150e-14, -1.222440393423053e-16, -1.408409189707930e-19,  6.279743008913351e-21, -2.437302699122524e-23, -1.842019263336994e-25,
  7.922823674373169e-01, -5.240837847052520e-03,  1.059544957853352e-05,  7.751255017934817e-08, -5.326226964627051e-10, -1.139096396410846e-12,  2.499313502605195e-14,
 -3.387354135604189e-17, -1.032821354883492e-18,  5.237413856704103e-21,  3.274664188950451e-23, -3.863080583438517e-25,  9.295939213539985e-01, -5.541677368393922e-03,
  5.137449047927927e-06,  1.078262173004496e-07, -3.226934599976928e-10, -3.466802715333548e-12,  1.966133917157037e-14,  1.200934434593087e-16, -1.173861129439550e-18,
 -3.704416358090372e-21,  6.837804043471452e-23,  5.806037409265874e-26,  1.070640430234745e+00, -5.638932546166366e-03, -1.407382648738931e-06,  1.203454762170326e-07,
  3.186125925419467e-11, -4.636830662355775e-12, -3.217262095372152e-16,  2.172784324511721e-16, -4.688949020966382e-20, -1.127233595532003e-20,  6.136125191771530e-24,
  6.220465976973914e-25,  1.212738945276339e+00, -5.508318911746456e-03, -8.219005367427908e-06,  1.089647526475441e-07,  4.216201546732476e-10, -3.709489424942016e-12,
 -2.406870752004920e-14,  1.437337312080273e-16,  1.439279376476009e-18, -5.554133344343278e-21, -8.792720560712043e-23,  1.844704423479121e-25,  1.352884558756001e+00,
 -5.142471868650736e-03, -1.428363296504458e-05,  7.353652763377775e-08,  6.939467220809861e-10, -8.180636396739220e-13, -3.402236984119697e-14, -7.007343720271357e-17,
  1.539407584218956e-18,  8.954816217172360e-21, -5.656884783777653e-23, -7.131162894702642e-25,  1.487783786732119e+00, -4.555782752831852e-03, -1.856547955990678e-05,
  2.162148720334949e-08,  7.202859030129739e-10,  2.564414149871230e-12, -2.023097616008171e-14, -2.291248321135121e-16, -1.195272819286377e-19,  1.194517731330800e-20,
  7.011712415107343e-23, -3.233555664341225e-25,  1.613922721853780e+00, -3.787879031612588e-03, -2.024816955246176e-05, -3.238656781407249e-08,  4.752359349200590e-10,
  4.363648389725490e-12,  7.447559432099683e-15, -1.639564988081167e-16, -1.531944270446984e-18, -1.905848472914861e-21,  7.297352599498926e-23,  6.411036765683185e-25,
  1.727677806259619e+00, -2.904341585994257e-03, -1.899880304951003e-05, -7.161374127587986e-08,  7.611236680980052e-11,  3.440291661780715e-12,  2.501697723486905e-14,
  4.628093472198156e-17, -8.785633925176071e-19, -1.021888046653033e-20, -4.263281046227412e-23,  1.973664144332221e-25,  1.825472910007590e+00, -1.993205052352267e-03,
 -1.516857862278267e-05, -8.374108492445373e-08, -2.656115603806129e-10,  7.160058146012486e-13,  1.827246475034029e-14,  1.479642606660171e-16,  6.007508793030639e-19,
 -1.413827404678896e-21, -4.676991892483480e-23, -4.172236293812535e-25,  1.903978635382755e+00, -1.156290173857094e-03, -9.824330711665350e-06, -6.769046374081439e-08,
 -3.765445152743114e-10, -1.471937910691528e-12, -6.450155679882109e-16,  5.692061698918709e-17,  6.702508109346784e-19,  4.930572211297165e-21,  2.379814866730029e-23,
  2.638975238183541e-26,  1.960339295992408e+00, -4.956233598941184e-04, -4.534438241255218e-06, -3.566102768860090e-08, -2.511611208444180e-10, -1.592180686544751e-12,
 -8.894007439609714e-15, -4.075198351021127e-17, -1.129154940391072e-19,  4.147869394425262e-22,  1.020569410726078e-23,  1.074675037056425e-25,  1.992409045795734e+00,
 -9.684899002409879e-05, -9.226326449236314e-07, -7.766678423880676e-09, -6.083608050971595e-11, -4.532825788148609e-13, -3.247264478045238e-15, -2.248531579664229e-17,
 -1.508012854417775e-19, -9.792342352627498e-22, -6.140134691717493e-24, -3.696535751415078e-26,  1.897005152282438e-03, -1.858535035723575e-05,  1.364473120937327e-07,
 -8.895509682627578e-10,  5.429207277263087e-12, -3.176088585575398e-14,  1.802786176462803e-16, -1.000256423135016e-18,  5.448581757831351e-21, -2.923264581144517e-23,
  1.547384201065491e-25, -8.095358304917564e-28,  1.705175996736772e-02, -1.661132431811021e-04,  1.204919112495520e-06, -7.693221240287259e-09,  4.546183100826102e-11,
 -2.537781086992956e-13,  1.349372780051172e-15, -6.849141167353715e-18,  3.307689239229817e-20, -1.506619980293681e-22,  6.343541691992992e-25, -2.363848851704514e-27,
  4.724688490336328e-02, -4.550103901816652e-04,  3.220019859271014e-06, -1.968055316323246e-08,  1.083649345186102e-10, -5.417930242080015e-13,  2.422604855327051e-15,
 -9.200921153026606e-18,  2.465572952188169e-20,  8.635668967497351e-24, -7.584094686776869e-25,  7.155988034279306e-27,  9.224947669872878e-02, -8.729673163610993e-04,
  5.944859414433780e-06, -3.384026557850507e-08,  1.643632897167391e-10, -6.515506388454944e-13,  1.700874363488939e-15,  1.846426142414090e-18, -6.462742633694235e-20,
  5.534760802268528e-22, -3.329205050146620e-24,  1.495410806375496e-26,  1.516997609945432e-01, -1.401556030502545e-03,  9.041580489953689e-06, -4.622030587069529e-08,
  1.795146561070501e-10, -3.667507530105013e-13, -1.674154417312676e-15,  2.521499738155671e-17, -1.746810561867459e-19,  7.890008138470848e-22, -1.548860791301325e-24,
 -1.218739045664725e-26,  2.250983670674646e-01, -2.016322010099998e-03,  1.209363662429564e-05, -5.258159781954852e-08,  1.266859393678072e-10,  3.733466799295574e-13,
 -6.668617763740047e-15,  4.374714760576819e-17, -1.520209863493664e-19, -1.898527568940348e-22,  7.067874213002649e-24, -5.583296209173070e-26,  3.117890416392279e-01,
 -2.686992731397121e-03,  1.463744812973414e-05, -4.921571901653508e-08, -3.108502451008915e-12,  1.384682788469443e-12, -1.025587294374083e-14,  3.262719167492143e-17,
  1.059254684806788e-19, -2.057035128420929e-21,  1.269697595523558e-23, -2.380667758805483e-26,  4.109366432547656e-01, -3.377885853593430e-03,  1.620457494244751e-05,
 -3.385270253134601e-08, -1.919935883989063e-10,  2.239899584438521e-12, -8.719408516682957e-15, -1.966664671349069e-17,  4.699761440948975e-19, -2.626201814368890e-21,
  5.326547532756432e-26,  1.101803935429573e-25,  5.215003950834279e-01, -4.048631129364794e-03,  1.637495743099788e-05, -6.534142890843177e-09, -3.927410350439902e-10,
  2.397524108487951e-12, -1.445706502545319e-16, -9.052132369189118e-17,  5.643404663191308e-19,  2.641815644924590e-22, -2.632925166555862e-23,  1.585547572084269e-25,
  6.422026801767887e-01, -4.655354011236863e-03,  1.484029497310294e-05,  2.973880484066159e-08, -5.360266883295777e-10,  1.454221715116129e-12,  1.306493451620658e-14,
 -1.233360306981066e-16,  6.600098263089018e-20,  5.172587382027633e-21, -3.026246177402319e-23, -8.521707191562032e-26,  7.714942276507718e-01, -5.152500042939650e-03,
  1.147382113137528e-05,  6.884053530658683e-08, -5.495016289923409e-10, -5.541949176607784e-13,  2.361192602220534e-14, -6.368761460663550e-17, -8.248037890442957e-19,
  6.206892123418326e-21,  1.580624249664799e-23, -3.756631996258607e-25,  9.075174752123150e-01, -5.495494987809438e-03,  6.398182980043787e-06,  1.021351374229786e-07,
 -3.870608120323110e-10, -2.958928146727426e-12,  2.248179413501799e-14,  8.092580416767653e-17, -1.257859604731360e-18, -9.714214899085644e-22,  6.699630284662997e-23,
 -1.166474582411164e-25,  1.048071331135461e+00, -5.644413398703165e-03,  3.676571362192528e-08,  1.201150045934159e-07, -6.046223782460928e-11, -4.572088046991720e-12,
  5.680701829103257e-15,  2.093852644733564e-16, -4.418000009330008e-19, -1.049394925311098e-20,  3.227282361171244e-23,  5.522074227282653e-25,  1.190582601084862e+00,
 -5.568731801045963e-03, -6.873498771482928e-06,  1.150872305979460e-07,  3.420058908521267e-10, -4.233847981875413e-12, -1.943415012180077e-14,  1.859330974143739e-16,
  1.178666323027702e-18, -8.833735852270348e-21, -7.423945923841864e-23,  4.327239467533677e-25,  1.332091986399573e+00, -5.253023960122962e-03, -1.333526095428522e-05,
  8.446385653257365e-08,  6.692911247415218e-10, -1.652297933619738e-12, -3.524977171600099e-14, -1.615137762415138e-17,  1.813670998596171e-18,  6.086135769196359e-21,
 -8.611578588853563e-23, -6.101756741523445e-25,  1.469265532780608e+00, -4.703069124489733e-03, -1.823527317631835e-05,  3.352780295081927e-08,  7.661986170081440e-10,
  2.001868481852584e-12, -2.663169940431317e-14, -2.255609193185175e-16,  3.567755075845755e-19,  1.437952329965904e-20,  4.945456530945394e-23, -6.171248988205023e-25,
  1.598444964940235e+00, -3.951282991427985e-03, -2.058827875615349e-05, -2.407655862684092e-08,  5.638956434013155e-10,  4.481719034493157e-12,  2.164488192746607e-15,
 -2.134579551866429e-16, -1.541224579416593e-18,  1.574799806065413e-21,  1.008054534496430e-22,  6.056876690989430e-25,  1.715751052813360e+00, -3.059743324280839e-03,
 -1.984848383685512e-05, -6.981249562901907e-08,  1.510093373967606e-10,  4.052721427108184e-12,  2.586171304817630e-14,  1.197253249685480e-17, -1.274455897789764e-18,
 -1.168476009306983e-20, -2.891313764865353e-23,  4.372281727116256e-25,  1.817250927861515e+00, -2.118644249472553e-03, -1.619841666359905e-05, -8.785103470022222e-08,
 -2.465594923024522e-10,  1.206372419811548e-12,  2.267415917632350e-14,  1.659754447837846e-16,  5.115265884929590e-19, -3.676552188169168e-21, -6.694312026138669e-23,
 -4.959796520729031e-25,  1.899190993374454e+00, -1.238238621853435e-03, -1.067373716328779e-05, -7.395093949785244e-08, -4.059957355817409e-10, -1.465698710964766e-12,
  1.277036987021861e-15,  8.139374792599553e-17,  8.650263761732973e-19,  5.889877061647140e-21,  2.370722011013608e-23, -3.701214500531989e-26,  1.958281441568967e+00,
 -5.336814083979896e-04, -4.987571525939059e-06, -3.994634741611079e-08, -2.852337624369686e-10, -1.819720976525730e-12, -1.008278522359112e-14, -4.403755067571273e-17,
 -8.937639676711000e-20,  9.308855992900068e-22,  1.595695367667491e-23,  1.566538505147838e-25,  1.992006273140325e+00, -1.046201167661712e-04, -1.021986542136223e-06,
 -8.817039662699921e-09, -7.073503509199287e-11, -5.393516400225067e-13, -3.950069208600275e-15, -2.792576685883002e-17, -1.908954154241838e-19, -1.260577791304699e-21,
 -8.012060806786150e-24, -4.865149038938376e-26,  1.824781325008140e-03, -1.753504035768764e-05,  1.262736784936779e-07, -8.075394902713187e-10,  4.835085693717378e-12,
 -2.775151446654512e-14,  1.545623253345582e-16, -8.416115189124207e-19,  4.499544426365491e-21, -2.370011443393376e-23,  1.231727933169255e-25, -6.329462085932360e-28,
  1.640601797841671e-02, -1.568311739086725e-04,  1.116802826471317e-06, -7.004739973917638e-09,  4.069518194517220e-11, -2.235797088328474e-13,  1.171633657101187e-15,
 -5.872762429631610e-18,  2.808559784984506e-20, -1.272728893723621e-22,  5.374194325886328e-25, -2.045763855065928e-27,  4.547690849005775e-02, -4.301662260265826e-04,
  2.993908669243968e-06, -1.803032800510325e-08,  9.809009278044145e-11, -4.866527696220320e-13,  2.176033196398911e-15, -8.412241932572168e-18,  2.449052718717603e-20,
 -1.604404937549786e-23, -4.903205997865402e-25,  5.129030956124533e-27,  8.885021515176587e-02, -8.269890428547720e-04,  5.554132302781094e-06, -3.131246950449987e-08,
  1.517435416049809e-10, -6.103254245397268e-13,  1.726440666176475e-15,  7.270169238109806e-20, -4.694601323363415e-20,  4.328867531898501e-22, -2.714831652687924e-24,
  1.295733802881960e-26,  1.462347575993185e-01, -1.331393703776068e-03,  8.503921728627142e-06, -4.340870557637190e-08,  1.718318769000956e-10, -3.990640722495597e-13,
 -1.042212193435734e-15,  2.006679569870318e-17, -1.475013219951015e-19,  7.184931388578506e-22, -1.927534516937571e-24, -5.450306665606960e-27,  2.172226303385121e-01,
 -1.922061862207766e-03,  1.147503865521120e-05, -5.050317667811403e-08,  1.326487621988521e-10,  2.274447075357255e-13, -5.512468352198842e-15,  3.882307874891825e-17,
 -1.543286084779183e-19,  4.704687847468244e-23,  4.858366145540070e-24, -4.469129882049059e-26,  3.012715309627687e-01, -2.572254326987487e-03,  1.404743251857698e-05,
 -4.905696280828565e-08,  2.219944404127572e-11,  1.149822624737142e-12, -9.305303852886762e-15,  3.492768794337316e-17,  4.072602732587844e-20, -1.573895087600636e-21,
  1.138066751795706e-23, -3.474088972353012e-26,  3.976817309032559e-01, -3.249923076064088e-03,  1.578135219012450e-05, -3.657774388947497e-08, -1.493244457262021e-10,
  2.025638099197371e-12, -9.073683864420267e-15, -6.130899110668798e-18,  3.765349184717237e-19, -2.538540362198067e-21,  4.055836441545640e-24,  7.260530676061016e-26,
  5.055672272755041e-01, -3.918048295454369e-03,  1.626042406603498e-05, -1.243540911970069e-08, -3.450199938792636e-10,  2.365681763540671e-12, -2.426283117449750e-15,
 -7.249979337070450e-17,  5.565862382162027e-19, -6.485231897741310e-22, -1.931617661875632e-23,  1.572666041635529e-25,  6.238207662129416e-01, -4.535347672780294e-03,
  1.514671384848715e-05,  2.141092223143794e-08, -5.040844632117985e-10,  1.726741452861668e-12,  9.667387832275349e-15, -1.184839653642258e-16,  2.297609647099224e-19,
  3.913137282020764e-21, -3.209927492067294e-23, -1.455892392616023e-27,  7.510728286266342e-01, -5.057555238191816e-03,  1.224688758683294e-05,  5.998997072359797e-08,
 -5.550776330569276e-10, -1.168018112055092e-14,  2.149343860250984e-14, -8.641575259369617e-17, -5.938460208600975e-19,  6.521452908263102e-21,  3.048941551169067e-25,
 -3.233243827168455e-25,  8.856454741423511e-01, -5.439516621527048e-03,  7.584790769196082e-06,  9.549874053429456e-08, -4.406837822557094e-10, -2.396736558257380e-12,
  2.418255423360146e-14,  4.061923748582569e-17, -1.246236449985704e-18,  1.561799307427011e-21,  5.865656633934310e-23, -2.548272830331000e-25,  1.025503362224986e+00,
 -5.638377090184912e-03,  1.469353178862814e-06,  1.184254425679645e-07, -1.500754460692674e-10, -4.367334328518105e-12,  1.129081064851294e-14,  1.894976610442495e-16,
 -7.908243214171295e-19, -8.754728359902929e-21,  5.364168511158641e-23,  4.089699934096166e-25,  1.168206567179159e+00, -5.618109169556167e-03, -5.462490855827645e-06,
  1.198584098485673e-07,  2.531071399874281e-10, -4.633845348584450e-12, -1.375164041395084e-14,  2.180301601861695e-16,  8.123696450183668e-19, -1.135958577267315e-20,
 -5.062034462860466e-23,  6.288296003077808e-25,  1.310873198956960e+00, -5.355472545862571e-03, -1.225868227051681e-05,  9.486214773522200e-08,  6.277832519267817e-10,
 -2.496983644831978e-12, -3.486157583317610e-14,  4.467760852974659e-17,  1.964798805961102e-18,  2.161129916805326e-21, -1.085332824988440e-22, -3.907028896597935e-25,
  1.450164337959791e+00, -4.847130762663451e-03, -1.775818153057449e-05,  4.607043416309925e-08,  7.993415490001787e-10,  1.288699888581703e-12, -3.270735839343927e-14,
 -2.055378965000823e-16,  9.027326628529119e-19,  1.573076351063576e-20,  1.611325463321074e-23, -8.898894200807833e-25,  1.582308816223578e+00, -4.116984696618728e-03,
 -2.082010219235028e-05, -1.433646222591916e-08,  6.535369038853431e-10,  4.456453271485270e-12, -4.488440013235440e-15, -2.610417809073619e-16, -1.405855591981031e-18,
  6.102192411976349e-21,  1.243735984025083e-22,  4.418206370725965e-25,  1.703189264410684e+00, -3.221834740777490e-03, -2.066895275116230e-05, -6.671416110908242e-08,
  2.382722385715034e-10,  4.672421239391084e-12,  2.556140068849545e-14, -3.572108813835114e-17, -1.710527926658638e-18, -1.237228183559460e-20, -3.289288885758315e-24,
  7.351537824729965e-25,  1.808510407508793e+00, -2.252513462873511e-03, -1.727540241615517e-05, -9.157178827833648e-08, -2.166048437064598e-10,  1.808027819805992e-12,
  2.752680120182499e-14,  1.796661037637086e-16,  3.255625952465701e-19, -6.806461726476595e-21, -8.984545030927305e-23, -5.355512307336043e-25,  1.894061480000005e+00,
 -1.327290808054225e-03, -1.160108373653471e-05, -8.067888408853840e-08, -4.348015994091464e-10, -1.404371232954050e-12,  3.976748171316749e-15,  1.126453509225205e-16,
  1.093484012867241e-18,  6.776854439948805e-21,  1.982995590588079e-23, -1.487860822736750e-25,  1.956063765581903e+00, -5.755798423655866e-04, -5.495554900199505e-06,
 -4.481481553265868e-08, -3.241494492796216e-10, -2.076791901261727e-12, -1.134987769924655e-14, -4.622365812701003e-17, -4.254880144082266e-20,  1.725488783200945e-21,
  2.426740258556369e-23,  2.245860122602163e-25,  1.991570742506631e+00, -1.132393215883528e-04, -1.134954996150387e-06, -1.004052620858470e-08, -8.253717393423363e-11,
 -6.442708879592830e-13, -4.824800515960807e-15, -3.482680021411689e-17, -2.425987022950641e-19, -1.628092207946181e-21, -1.047528347943526e-23, -6.399314420906413e-26,
  1.756601972093263e-03, -1.656233859343565e-05,  1.170296885000190e-07, -7.344245414063900e-10,  4.315322449224105e-12, -2.430928544051789e-14,  1.328912104591548e-16,
 -7.103783429042202e-19,  3.728705409348971e-21, -1.928761410299796e-23,  9.844093944859165e-26, -4.970408950340229e-28,  1.579604495883753e-02, -1.482222399115714e-04,
  1.036509922144462e-06, -6.387916140276798e-09,  3.649196784580580e-11, -1.973362812513490e-13,  1.019118442008350e-15, -5.043354355898240e-18,  2.386982877040343e-20,
 -1.074882481094879e-22,  4.539410448033987e-25, -1.753616961686037e-27,  4.380281253381993e-02, -4.070544535796489e-04,  2.786649167824657e-06, -1.653599191583552e-08,
  8.886066134544780e-11, -4.371665870861913e-13,  1.951350773604217e-15, -7.641159386246487e-18,  2.360991201730777e-20, -3.161836964719238e-23, -2.993088129046541e-25,
  3.628588449870749e-27,  8.562880241435149e-02, -7.840186218020118e-04,  5.192554521353362e-06, -2.897997581285000e-08,  1.399507248970714e-10, -5.690225003810300e-13,
  1.709644142714581e-15, -1.200106808926022e-18, -3.318476570753999e-20,  3.351042504786430e-22, -2.188796275944902e-24,  1.096815321150016e-26,  1.410420116439536e-01,
 -1.265399824040700e-03,  7.999245836835990e-06, -4.072442310140737e-08,  1.636433189662128e-10, -4.178447282983884e-13, -5.426423816402571e-16,  1.574534617005795e-17,
 -1.230676130362432e-19,  6.380577398022818e-22, -2.061634191135149e-24, -9.648406491803016e-28,  2.097141966030206e-01, -1.832649324174720e-03,  1.088186263085132e-05,
 -4.835123400027472e-08,  1.359598418224534e-10,  1.076347834337349e-13, -4.494060699153086e-15,  3.394550933056090e-17, -1.495824860775363e-19,  2.051466325793361e-22,
  3.121010064878013e-24, -3.448500747733970e-26,  2.912035549774905e-01, -2.462221892249689e-03,  1.346160060234926e-05, -4.852959967907044e-08,  4.304238972608859e-11,
  9.383290117375585e-13, -8.316992719176262e-15,  3.540911779379366e-17, -8.124482913626032e-21, -1.150912287855580e-21,  9.737346018777629e-24, -3.904857762923137e-26,
  3.849317069472239e-01, -3.125465604595366e-03,  1.532938260772164e-05, -3.865469994856080e-08, -1.109965898513425e-10,  1.807088075745486e-12, -9.090143478615175e-15,
  4.492985635756498e-18,  2.887478941650502e-19, -2.322168774652111e-21,  6.533504391796479e-24,  4.114494032403253e-26,  4.901541280109010e-01, -3.788652076002040e-03,
  1.607962653912786e-05, -1.758103812752863e-08, -2.984428044950456e-10,  2.285077081472750e-12, -4.211422289786282e-15, -5.519838056130863e-17,  5.209661890518483e-19,
 -1.286596224347629e-21, -1.270311548638266e-23,  1.414916992694742e-25,  6.059231601618629e-01, -4.413280647683954e-03,  1.535643024864139e-05,  1.363334428636200e-08,
 -4.674933687816336e-10,  1.919900290920822e-12,  6.472186225966411e-15, -1.091243499418381e-16,  3.476920985221440e-19,  2.647894405757978e-21, -3.070861033328854e-23,
  6.089382404293617e-26,  7.310429041640356e-01, -4.956851439911694e-03,  1.291356052731478e-05,  5.113402867209226e-08, -5.503589814398371e-10,  4.731956531943155e-13,
  1.884291042682381e-14, -1.016866718370609e-16, -3.620878910946396e-19,  6.270804237141409e-21, -1.226672091122644e-23, -2.452415141646332e-25,  8.640158484472267e-01,
 -5.374377658388246e-03,  8.686991176672930e-06,  8.809616265932347e-08, -4.827455880730412e-10, -1.807146020184135e-12,  2.477312368772423e-14,  2.068322202696898e-18,
 -1.150756875072607e-18,  3.654306499548892e-21,  4.533771319242312e-23, -3.414156820205783e-25,  1.002982297598786e+00, -5.620985197989546e-03,  2.873221296113316e-06,
  1.153419341476139e-07, -2.342985155353403e-10, -4.035818877505767e-12,  1.619821616637666e-14,  1.595947219936816e-16, -1.063517826309207e-18, -6.302596984764315e-21,
  6.758421982819595e-23,  2.199585886740982e-25,  1.145655927659348e+00, -5.655994197034393e-03, -4.003002289258275e-06,  1.231509002247161e-07,  1.576378633805826e-10,
 -4.888079506194911e-12, -7.346792786261777e-15,  2.371486654968695e-16,  3.740132047166517e-19, -1.279210637231727e-20, -2.022330987771270e-23,  7.359290130229026e-25,
  1.289262615076375e+00, -5.448821952020231e-03, -1.106186309874966e-05,  1.044622566613266e-07,  5.696150413516494e-10, -3.311503884121533e-12, -3.272482056662375e-14,
  1.079295473914577e-16,  1.961090476619368e-18, -2.437437135671590e-21, -1.191129781046007e-22, -7.815376331293065e-26,  1.430495494526768e+00, -4.986765740892437e-03,
 -1.712789233626161e-05,  5.902154927077492e-08,  8.168187214376603e-10,  4.384525799847157e-13, -3.797243675493253e-14, -1.675456884261248e-16,  1.470611016400463e-18,
  1.552844085008570e-20, -2.760652777873564e-23, -1.077940499934640e-24,  1.565506926056426e+00, -4.284049179222859e-03, -2.092648490032027e-05, -3.175265799720230e-09,
  7.409714174940879e-10,  4.256175267578727e-12, -1.238736501424834e-14, -3.015207763788081e-16, -1.092665818073316e-18,  1.138430149615421e-20,  1.374311500114835e-22,
  1.260009698443634e-25,  1.689966253057556e+00, -3.390316515993256e-03, -2.144345798874897e-05, -6.212134243839956e-08,  3.377406733738085e-10,  5.267296512931604e-12,
  2.372814815771819e-14, -9.754087286582042e-17, -2.149639843169533e-18, -1.176201917801225e-20,  3.615956476913674e-23,  1.057776707038768e-24,  1.799216908513968e+00,
 -2.395168054581344e-03, -1.839374365129771e-05, -9.471055792864889e-08, -1.734253429435939e-10,  2.529963745927030e-12,  3.266125605589836e-14,  1.854240293288335e-16,
  1.019198961881547e-20, -1.086691418719707e-20, -1.128796063007151e-22, -4.937936563909222e-25,  1.888560398103925e+00, -1.424092425747870e-03, -1.261187827858716e-05,
 -8.785407693746883e-08, -4.616577144603251e-10, -1.266895868846331e-12,  7.658379158305229e-15,  1.516778580623273e-16,  1.349728797648187e-18,  7.391716111007139e-21,
  9.600439385907140e-24, -3.293808580204028e-25,  1.953669982648978e+00, -6.217868164359979e-04, -6.065870865549367e-06, -5.034873567834711e-08, -3.685146187850370e-10,
 -2.364809371628678e-12, -1.265240885991667e-14, -4.638319972059011e-17,  3.964784581107568e-20,  2.918889403959161e-21,  3.606880120988536e-23,  3.161203324898227e-25,
  1.991098829821377e+00, -1.228243788069928e-04, -1.263811423575187e-06, -1.147084393019082e-08, -9.666430548590485e-11, -7.727023325143218e-13, -5.918056411584388e-15,
 -4.361443927741299e-17, -3.094803252880096e-19, -2.108926291025762e-21, -1.371183462280621e-23, -8.397576296801687e-26,  1.692170886216803e-03, -1.566021555259422e-05,
  1.086153642505249e-07, -6.691021059359264e-10,  3.859486547976111e-12, -2.134571594846511e-14,  1.145718726574651e-16, -6.014502415915717e-19,  3.100261147081290e-21,
 -1.575449158990424e-23,  7.897945258573553e-26, -3.919917014700404e-28,  1.521926830436535e-02, -1.402271462432886e-04,  9.632320926379798e-07, -5.834336033742559e-09,
  3.277882367045115e-11, -1.744891462519866e-13,  8.880406112579561e-16, -4.338074785953964e-18,  2.030921828110921e-20, -9.079470862343292e-23,  3.826341815601648e-25,
 -1.493003997272059e-27,  4.221795763760487e-02, -3.855314660654571e-04,  2.596467405786727e-06, -1.518169464892617e-08,  8.056876012169194e-11, -3.928173516641496e-13,
  1.747789661560210e-15, -6.905874186917143e-18,  2.229139599787481e-20, -4.074721610333850e-23, -1.651521935514413e-25,  2.526046832854370e-27,  8.257365894024689e-02,
 -7.438320083681367e-04,  4.857861711761629e-06, -2.682959188547637e-08,  1.289772926598432e-10, -5.285037074228866e-13,  1.662872791845947e-15, -2.084986399017379e-18,
 -2.258573579193772e-20,  2.566471211415740e-22, -1.747533709054666e-24,  9.119198882599983e-27,  1.361053672217768e-01, -1.203316757680776e-03,  7.525984839474242e-06,
 -3.817355060451549e-08,  1.551896887760958e-10, -4.260020672767302e-13, -1.535674768055383e-16,  1.215876288857199e-17, -1.015834548718485e-19,  5.556764083331499e-22,
 -2.036955717289955e-24,  1.854103975500783e-27,  2.025540867928596e-01, -1.747878174186553e-03,  1.031475288347916e-05, -4.616420169561949e-08,  1.371081878080252e-10,
  1.064974249285256e-14, -3.609333740354433e-15,  2.929832421626471e-17, -1.402909809727945e-19,  3.023402266781985e-22,  1.802761120683228e-24, -2.568733705689691e-26,
  2.815663830905198e-01, -2.356845443217144e-03,  1.288396256055623e-05, -4.770129805839022e-08,  5.989289481764786e-11,  7.505535919787277e-13, -7.334889542010042e-15,
  3.455800282821857e-17, -4.296286894581936e-20, -7.959863453749990e-22,  8.010562711991557e-24, -3.885487918819230e-26,  3.726721377954196e-01, -3.004713490356116e-03,
  1.485602497704691e-05, -4.015330425405601e-08, -7.702119752296971e-11,  1.591403025397978e-12, -8.847170614982462e-15,  1.244885795565920e-17,  2.102192135230740e-19,
 -2.032320736399434e-21,  7.781193110449041e-24,  1.674209545949038e-26,  4.752553475019149e-01, -3.660936694797215e-03,  1.584149257869803e-05, -2.199649453785651e-08,
 -2.538676517552617e-10,  2.167294095312669e-12, -5.531177698948130e-15, -3.935482130590582e-17,  4.669432054999846e-19, -1.676846167764529e-21, -6.984018718125060e-24,
  1.175965520523833e-25,  5.885166009821938e-01, -4.289898995346698e-03,  1.547644270758604e-05,  6.468058964808572e-09, -4.277826912633746e-10,  2.039903982397985e-12,
  3.585145141884146e-15, -9.670402013960425e-17,  4.216754552377806e-19,  1.486395753443814e-21, -2.707859284894332e-23,  1.004349409611679e-25,  7.114257913645686e-01,
 -4.851237345957956e-03,  1.347472361472222e-05,  4.242757844982415e-08, -5.366092907144365e-10,  8.901541837220753e-13,  1.586661592068355e-14, -1.097757795236979e-16,
 -1.475387822942642e-19,  5.589945656397994e-21, -2.113583793077736e-23, -1.575357430536607e-25,  8.426638362491791e-01, -5.300786957151747e-03,  9.696713354648633e-06,
  8.011534054071533e-08, -5.129592141733761e-10, -1.215923905963717e-12,  2.433759560336350e-14, -3.233125457963194e-17, -9.903054182379545e-19,  5.154269031635057e-21,
  2.943434493516881e-23, -3.725555598147768e-25,  9.805529964578702e-01, -5.592532733937868e-03,  4.232240608538062e-06,  1.109699970075784e-07, -3.107860557918960e-10,
 -3.597474136072821e-12,  2.016011474734657e-14,  1.224689800841404e-16, -1.239959368557025e-18, -3.465094907891940e-21,  7.282407802883627e-23,  1.909386310564550e-26,
  1.122977312975584e+00, -5.682071575473367e-03, -2.513309201699146e-06,  1.248837095953973e-07,  5.865606479955066e-11, -4.983797667202111e-12, -6.090461399206119e-16,
  2.416566619555117e-16, -9.317551279280961e-20, -1.294576584957936e-20,  1.252895649499506e-23,  7.344067897244536e-25,  1.267298488343734e+00, -5.532153038315073e-03,
 -9.755953685382365e-06,  1.130047372437826e-07,  4.958119758091435e-10, -4.053657954335254e-12, -2.884398069376466e-14,  1.683603887283053e-16,  1.787696380462353e-18,
 -7.166731117113996e-21, -1.147405741091773e-22,  2.793115712437313e-25,  1.410279185046202e+00, -5.120733333287462e-03, -1.634109427826242e-05,  7.210979232803994e-08,
  8.161240340568744e-10, -5.233569359606414e-13, -4.192290781417837e-14, -1.118493469978359e-16,  1.998083015912633e-18,  1.345107903943033e-20, -7.656284826890765e-23,
 -1.118585913741210e-24,  1.548035957173431e+00, -4.451405577039384e-03, -2.089070608533134e-05,  9.342175460124741e-09,  8.224194319658224e-10,  3.854033200366671e-12,
 -2.125025814847511e-14, -3.288642837032751e-16, -5.836774770102047e-19,  1.686603630561214e-20,  1.332849014703590e-22, -3.360359915348721e-25,  1.676057310938729e+00,
 -3.564745936756784e-03, -2.215291723455589e-05, -5.584485604733154e-08,  4.485183476456480e-10,  5.795846321248914e-12,  1.997285328680314e-14, -1.727286581710721e-16,
 -2.535000961544131e-18, -9.295668098547079e-21,  8.923387118319344e-23,  1.341263354457339e-24,  1.789334677228765e+00, -2.546907151265003e-03, -1.954510662803581e-05,
 -9.703621798196391e-08, -1.145682850798491e-10,  3.375779573416922e-12,  3.779243470268268e-14,  1.785791146545794e-16, -4.671768668946158e-19, -1.577600778805819e-20,
 -1.312778439947551e-22, -3.146476552538157e-25,  1.882655381714116e+00, -1.529331871831291e-03, -1.371124598096894e-05, -9.543178223144236e-08, -4.847873411733968e-10,
 -1.027002640055027e-12,  1.255038536179660e-14,  1.991683658675598e-16,  1.618601593739130e-18,  7.413259306493298e-21, -1.049939743426303e-23, -6.010067582363163e-25,
  1.951081808559100e+00, -6.728344625278583e-04, -6.707048512442346e-06, -5.664027546149441e-08, -4.189513899538451e-10, -2.683800814518693e-12, -1.391542692871168e-14,
 -4.312559631227756e-17,  1.743461929316907e-19,  4.672814233437351e-21,  5.249558641258867e-23,  4.353371258382096e-25,  1.990586400805873e+00, -1.335129901870605e-04,
 -1.411277490478187e-06, -1.314925861676976e-08, -1.136436988610105e-10, -9.305833413314329e-13, -7.290120004980294e-15, -5.484605111950398e-17, -3.962286463256767e-19,
 -2.738410258536038e-21, -1.794937134123410e-23, -1.096676043722300e-25,  1.631218458529402e-03, -1.482239126179970e-05,  1.009430302933385e-07, -6.106217646176496e-10,
  3.458761179919566e-12, -1.878737080635400e-14,  9.903907889596998e-17, -5.107389311138702e-19,  2.586042871881193e-21, -1.291477039218392e-23,  6.359978307083257e-26,
 -3.104621749601081e-28,  1.467334026996129e-02, -1.327926796915882e-04,  8.962553058086666e-07, -5.336675128360413e-09,  2.949269883555322e-11, -1.545632442653261e-13,
  7.752020027423423e-16, -3.737647910442064e-18,  1.730090987209624e-20, -7.673376442149366e-23,  3.220722437957122e-25, -1.265173985912629e-27,  4.071625161250161e-02,
 -3.654671160552300e-04,  2.421769617999430e-06, -1.395323045702503e-08,  7.311663076489833e-11, -3.531115637338346e-13,  1.564183297476692e-15, -6.217093155080740e-18,
  2.073001160655883e-20, -4.538591640623880e-23, -7.263328521342494e-26,  1.721567343441714e-27,  7.967406613095752e-02, -7.062226426028667e-04,  4.547946583216591e-06,
 -2.484836862364765e-08,  1.188011916816767e-10, -4.893689122205239e-13,  1.595671949673690e-15, -2.672637571323256e-18, -1.451254657332159e-20,  1.942704046650401e-22,
 -1.383291019770542e-24,  7.473407258920191e-27,  1.314096734968025e-01, -1.144899646074180e-03,  7.082518933179635e-06, -3.575876679280846e-08,  1.466585453228966e-10,
 -4.259517417581869e-13,  1.442647985596835e-16,  9.212630679752311e-18, -8.302089772514118e-20,  4.763809362504991e-22, -1.916025160506061e-24,  3.479035686938797e-27,
  1.957241542969324e-01, -1.667538752415543e-03,  9.773937372593093e-06, -4.397320337654797e-08,  1.365188137219980e-10, -6.662682010464059e-14, -2.850107662987163e-15,
  2.499500391554595e-17, -1.283604895306667e-19,  3.540909571027631e-22,  8.375324636677778e-25, -1.844280154113290e-26,  2.723415438466475e-01, -2.256046033850947e-03,
  1.231776197605231e-05, -4.663216198339421e-08,  7.322106325671776e-11,  5.859480293868026e-13, -6.390398980796238e-15,  3.278324042798177e-17, -6.625651139320967e-20,
 -5.090348439425316e-22,  6.358749204821362e-24, -3.589116385836817e-26,  3.608879021018994e-01, -2.887811254289308e-03,  1.436780460147939e-05, -4.114242429613664e-08,
 -4.728457433271867e-11,  1.383948473337447e-12, -8.414988398830148e-15,  1.806642093459453e-17,  1.427834570990888e-19, -1.711979174441405e-21,  8.108176978784829e-24,
 -8.066184863775268e-28,  4.608632996673266e-01, -3.535326392219062e-03,  1.555456944791948e-05, -2.571916757818466e-08, -2.119300259317590e-10,  2.022953612955219e-12,
 -6.433325303480913e-15, -2.542276476995964e-17,  4.027240894899529e-19, -1.860556865640403e-21, -2.397543280088765e-24,  9.074059633774607e-26,  5.716049595088465e-01,
 -4.165890217177541e-03,  1.551435130889383e-05, -4.629705713044885e-11, -3.863354379196804e-10,  2.095021885460578e-12,  1.072949421963007e-15, -8.255420279906759e-17,
  4.568196795031040e-19,  4.985575122842224e-22, -2.217667693666310e-23,  1.192637740461362e-25,  6.922394579434012e-01, -4.741547508764664e-03,  1.393299171304178e-05,
  3.400389219281585e-08, -5.152491810822487e-10,  1.233714606521312e-12,  1.275581517979165e-14, -1.114524115017985e-16,  3.704265697137418e-20,  4.631217591219669e-21,
 -2.618875796571979e-23, -7.368334499561446e-26,  8.216217254446433e-01, -5.219508882672994e-03,  1.060815265765311e-05,  7.174481156399185e-08, -5.315277488738313e-10,
 -6.460870749625792e-13,  2.301799314285722e-14, -6.085693407183356e-17, -7.874957463990552e-19,  6.005965239899190e-21,  1.328552687941944e-23, -3.542193316526473e-25,
  9.582588887622556e-01, -5.553438074928348e-03,  5.531758923320044e-06,  1.054491970017754e-07, -3.776429396551765e-10, -3.077060682577786e-12,  2.301899246008210e-14,
  8.135486516620601e-17, -1.312576514802053e-18, -5.908555341514302e-22,  6.957194960695228e-23, -1.611891229844342e-25,  1.100218317432166e+00, -5.696175245731037e-03,
 -1.012359323967758e-06,  1.250262938503733e-07, -4.062153337586261e-11, -4.917980686908302e-12,  6.046584627427238e-15,  2.313768870369892e-16, -5.426249996315839e-19,
 -1.182287648086671e-20,  4.282800816296105e-23,  6.266656797312336e-25,  1.245022551262234e+00, -5.604647977061118e-03, -8.355091487925714e-06,  1.202532467660214e-07,
  4.082303864779302e-10, -4.683149442887617e-12, -2.337393353906322e-14,  2.205831163560716e-16,  1.450988530240292e-18, -1.140727664521522e-20, -9.481451495760714e-23,
  6.176767441938259e-25,  1.389540586438442e+00, -5.247779987157249e-03, -1.539795394545497e-05,  8.502844297687071e-08,  7.953808774497713e-10, -1.559439089765159e-12,
 -4.409151575988932e-14, -4.084871582194815e-17,  2.415578201550603e-18,  9.433740412071683e-21, -1.232119565986892e-22, -9.685200806729055e-25,  1.529897116859900e+00,
 -4.617853440787777e-03, -2.069720244294916e-05,  2.308666012658626e-08,  8.936457739637449e-10,  3.232014956870957e-12, -3.062154462134100e-14, -3.368365795413234e-16,
  1.144511193677516e-19,  2.174137328024909e-20,  1.063922440618005e-22, -8.960139588374741e-25,  1.661439820355195e+00, -3.744518860683135e-03, -2.277609301997531e-05,
 -4.771699546179300e-08,  5.687884231363841e-10,  6.207709753633808e-12,  1.395606064395552e-14, -2.583950004453616e-16, -2.790628896403383e-18, -4.488569641232403e-21,
  1.522212395408516e-22,  1.490435447685756e-24,  1.778826915349367e+00, -2.707951445671046e-03, -2.071814759278192e-05, -9.827824187712386e-08, -3.758858317095450e-11,
  4.340549696758045e-12,  4.249061861652034e-14,  1.535073160611314e-16, -1.132131984473803e-18, -2.120886185354322e-20, -1.376040931382925e-22,  6.531558826735195e-26,
  1.876311233405130e+00, -1.643735872248073e-03, -1.490358632034590e-05, -1.033343299088061e-07, -5.018323077818182e-10, -6.527776514681420e-13,  1.889144667491253e-14,
  2.550948228706535e-16,  1.870616342648395e-18,  6.360660837527967e-21, -4.490198874824655e-23, -9.815847630919030e-25,  1.948278686865257e+00, -7.293277378811968e-04,
 -7.428782328549927e-06, -6.379144862068546e-08, -4.760609438945493e-10, -3.031459927126356e-12, -1.501642893351412e-14, -3.440979928591136e-17,  3.853549420413002e-19,
  7.197235929726725e-21,  7.480182688609750e-23,  5.830115948368255e-25,  1.990028723476462e+00, -1.454667645603026e-04, -1.580624858798001e-06, -1.512650657822103e-08,
 -1.341371954205670e-10, -1.125503545464309e-12, -9.019185337518206e-15, -6.925122951601258e-17, -5.089790529290991e-19, -3.561905460997625e-21, -2.346089262688376e-23,
 -1.420089111599162e-25,  1.573498866255491e-03, -1.404324382233313e-05,  9.393561597552122e-08, -5.581631174405339e-10,  3.105671353668508e-12, -1.657310274460090e-14,
  8.583039304915515e-17, -4.349589855543642e-19,  2.163793636589351e-21, -1.062414189214484e-23,  5.139370337813774e-26, -2.469561998833206e-28,  1.415611507229260e-02,
 -1.258710041780126e-04,  8.349476714847450e-07, -4.888545691379301e-09,  2.657931824867420e-11, -1.371541520134028e-13,  6.779004998485261e-16, -3.225836298263421e-18,
  1.475752051270101e-20, -6.490425638047652e-23,  2.708317437409359e-25, -1.068992238175371e-27,  3.929209840214570e-02, -3.467433502158547e-04,  2.261123444031663e-06,
 -1.283788037758293e-08,  6.641608404849004e-11, -3.175866744808714e-13,  1.399142909870530e-15, -5.580299016479909e-18,  1.906036356659464e-20, -4.696176966975455e-23,
 -1.040007720922187e-26,  1.138393289682105e-27,  7.692009888569519e-02, -6.710002081590231e-04,  4.260854759150362e-06, -2.302379413497794e-08,  1.093904680345360e-10,
 -4.520171731726644e-13,  1.515315327289960e-15, -3.035201476453300e-18, -8.439523723414722e-21,  1.450803050872514e-22, -1.086577533485354e-24,  6.050373583972983e-27,
  1.269407330144797e-01, -1.089916670100727e-03,  6.667212660311621e-06, -3.348011172398227e-08,  1.381935421341586e-10, -4.196788209980091e-13,  3.674996351594950e-16,
  6.815883097467110e-18, -6.721115012918289e-20,  4.030856738577348e-22, -1.742966733189401e-24,  4.275734740970803e-27,  1.892070925824638e-01, -1.591420958350441e-03,
  9.259309356036766e-06, -4.180304943397356e-08,  1.345565920521266e-10, -1.270832618465540e-13, -2.205799267094453e-15,  2.109641261994487e-17, -1.151892253000780e-19,
  3.731578069299138e-22,  1.576300130682238e-25, -1.269832653039339e-26,  2.635109290833472e-01, -2.159721527655723e-03,  1.176556582892006e-05, -4.537489878100581e-08,
  8.347937657258412e-11,  4.433387864524147e-13, -5.504573614934869e-15,  3.041590083531985e-17, -8.037297373197099e-20, -2.850366624468231e-22,  4.873491943418922e-24,
 -3.146656792352995e-26,  3.495633996615540e-01, -2.774854482048858e-03,  1.387043454262862e-05, -4.168833830072507e-08, -2.158179262600322e-11,  1.188520658696010e-12,
 -7.853982150201859e-15,  2.171168195043212e-17,  8.694621646919516e-20, -1.392162004415166e-21,  7.798607114411206e-24, -1.236893940630616e-26,  4.469688351557520e-01,
 -3.412178982358096e-03,  1.522690152954307e-05, -2.879498109393768e-08, -1.730653489094285e-10,  1.861405640357445e-12, -6.974900707703939e-15, -1.361844571311723e-17,
  3.349084308112684e-19, -1.884445099495566e-21,  1.012566830799470e-24,  6.461186992594410e-26,  5.551894805949553e-01, -4.041879522461533e-03,  1.547809271323850e-05,
 -5.891817478952932e-09, -3.443561393264951e-10,  2.094697039086578e-12, -1.032375368992825e-15, -6.780962073845039e-17,  4.600826329341625e-19, -2.818563106181692e-22,
 -1.682825577424654e-23,  1.215063817010300e-25,  6.734985848179632e-01, -4.628589557950123e-03,  1.429243974103671e-05,  2.597287649928116e-08, -4.877649481588527e-10,
  1.502686799183927e-12,  9.675335359680279e-15, -1.078066464981459e-16,  1.843314098920961e-19,  3.540808154875205e-21, -2.781636582377992e-23, -3.002538583432613e-27,
  8.009186678026424e-01, -5.131345276123737e-03,  1.141773284236922e-05,  6.316638111239363e-08, -5.390770535235811e-10, -1.167480451640769e-13,  2.099426370513149e-14,
 -8.252448521310739e-17, -5.653474503574696e-19,  6.239753442039592e-21, -1.192375047480924e-24, -2.990380411460622e-25,  9.361415078129031e-01, -5.504229639582585e-03,
  6.758963847776272e-06,  9.894528606535112e-08, -4.334996264344134e-10, -2.502016750997371e-12,  2.470943229417236e-14,  3.953262097423385e-17, -1.285869090745086e-18,
  2.006499621761295e-21,  5.930929312041188e-23, -2.964333689187174e-25,  1.077426895321761e+00, -5.698291320603717e-03,  4.808421314108050e-07,  1.235995196494988e-07,
 -1.370169662726599e-10, -4.697462327529722e-12,  1.222071125116688e-14,  2.075845101252571e-16, -9.312245118819794e-19, -9.609529675131060e-21,  6.644652523511835e-23,
  4.360527381897427e-25,  1.222479564276074e+00, -5.665612820074373e-03, -6.876046065817688e-06,  1.260073386708894e-07,  3.094833511590014e-10, -5.165165355666123e-12,
 -1.661418500751048e-14,  2.597704570167510e-16,  9.793783716803427e-19, -1.457339547349710e-20, -6.163458982520865e-23,  8.718044461623255e-25,  1.368309863217369e+00,
 -5.366668655029591e-03, -1.430247221405026e-05,  9.744730336236685e-08,  7.535638306991343e-10, -2.622348082576853e-12, -4.410928535501500e-14,  4.085410372294214e-17,
  2.656991907633801e-18,  3.741540372639577e-21, -1.588664124156312e-22, -6.215890663880695e-25,  1.511096651734637e+00, -4.782075191614741e-03, -2.033237746576780e-05,
  3.785899470415701e-08,  9.501782650621005e-10,  2.385085122719265e-12, -3.987867139443608e-14, -3.199170723966027e-16,  9.626936172280570e-19,  2.503908710861533e-20,
  5.438211730969591e-23, -1.458341537451216e-24,  1.646093931920657e+00, -3.928853769174881e-03, -2.328994439975659e-05, -3.760759136995243e-08,  6.956534112965697e-10,
  6.445639459956002e-12,  5.455628247048280e-15, -3.489771656652982e-16, -2.826844185126629e-18,  2.904392385978994e-21,  2.167074010460560e-22,  1.389859763036676e-24,
  1.767656144785174e+00, -2.878417241578273e-03, -2.189804696085381e-05, -9.812838515763434e-08,  5.974402541891578e-11,  5.407066054830534e-12,  4.615935162061393e-14,
  1.040157316468480e-16, -1.992546662186864e-18, -2.648846239507080e-20, -1.217548612967805e-22,  7.000897176887957e-25,  1.869489785331075e+00, -1.768061928647815e-03,
 -1.619211828246301e-05, -1.114409040431401e-07, -5.097395549299905e-10, -1.067099735309936e-13,  2.690356165408124e-14,  3.181791111433062e-16,  2.055627950206226e-18,
  3.563753124713768e-21, -9.852220879970218e-23, -1.472427598795001e-24,  1.945237478201828e+00, -7.919542111716217e-04, -8.242046583158163e-06, -7.191333796738801e-08,
 -5.403638300117819e-10, -3.401761120355785e-12, -1.576389098862991e-14, -1.730229892261447e-17,  7.049357699853234e-19,  1.075099753711812e-20,  1.041166541776047e-22,
  7.515709373550840e-25,  1.989420362941378e+00, -1.588761116525732e-04, -1.775802922393562e-06, -1.746523725717424e-08, -1.589789717769402e-10, -1.367198148157841e-12,
 -1.120688468601925e-14, -8.778421010222367e-17, -6.557053320736918e-19, -4.636386630088262e-21, -3.054955838982935e-23, -1.813118828238107e-25,  1.518787600681722e-03,
 -1.331773046552048e-05,  8.752521633106616e-08, -5.110161538208923e-10,  2.793861093460042e-12, -1.465183497782513e-14,  7.456613342302972e-17, -3.714606445141046e-19,
  1.815851969112267e-21, -8.770222554531791e-24,  4.166321456067741e-26, -1.973489853918375e-28,  1.366562862750623e-02, -1.194190463045558e-04,  7.787489977932468e-07,
 -4.484367058300143e-09,  2.399188202363243e-11, -1.219171442629842e-13,  5.938515798550236e-16, -2.788978573597920e-18,  1.260509984260740e-20, -5.496056195876871e-23,
  2.275674602177387e-25, -9.022027893935361e-28,  3.794035217942666e-02, -3.292529868838513e-04,  2.113240984130401e-06, -1.182426432284088e-08,  6.038783830712376e-11,
 -2.858148655732323e-13,  1.251179377566847e-15, -4.997407893887200e-18,  1.737308536588679e-20, -4.650989666387706e-23,  2.993535731885019e-26,  7.177674832838135e-28,
  7.430256303694267e-02, -6.379894323708251e-04,  3.994778703675360e-06, -2.134392280814672e-08,  1.007067781219136e-10, -4.166954118081193e-13,  1.427277053912098e-15,
 -3.229590095512744e-18, -3.938208914245934e-21,  1.065712762077607e-22, -8.476587003014685e-25,  4.843878871856913e-27,  1.226852494777289e-01, -1.038149060030906e-03,
  6.278442631099615e-06, -3.133562375988815e-08,  1.299024231832061e-10, -4.087987921387694e-13,  5.303214994689453e-16,  4.884222803096729e-18, -5.390865613501631e-20,
  3.372333930149570e-22, -1.547912732918324e-24,  4.516975228467187e-27,  1.829864320596980e-01, -1.519316641368810e-03,  8.770497534484897e-06, -3.967316014199290e-08,
  1.315312817480224e-10, -1.733381431066252e-13, -1.664682191463659e-15,  1.762550511338701e-17, -1.017639151519641e-19,  3.696749062091370e-22, -2.997428464124134e-25,
 -8.297110652200778e-27,  2.550568764211935e-01, -2.067751661119257e-03,  1.122935119433110e-05, -4.397518829211447e-08,  9.109250033979250e-11,  3.211499318953870e-13,
 -4.690225127876554e-15,  2.771478589716379e-17, -8.744592438882073e-20, -1.163420169043223e-22,  3.597437876845552e-24, -2.650623196709584e-26,  3.386827343841753e-01,
 -2.665896175134236e-03,  1.336885445647063e-05, -4.185351349064373e-08,  3.543430117369342e-13,  1.007590424288171e-12, -7.214215174472699e-15,  2.375107294005177e-17,
  4.229078569297853e-20, -1.093394288997414e-21,  7.090836575202539e-24, -1.910816459565451e-26,  4.335614984302732e-01, -3.291790233301900e-03,  1.486594624512443e-05,
 -3.127540570334608e-08, -1.375361047007560e-10,  1.690580979530911e-12, -7.216291000496168e-15, -3.973866980810073e-18,  2.684177144744249e-19, -1.794159624811081e-21,
  3.333155566575426e-24,  4.148682669643770e-26,  5.392690361606267e-01, -3.918428080755237e-03,  1.537570916124652e-05, -1.106832617949040e-08, -3.028552187017379e-10,
  2.048785893050680e-12, -2.727319326349304e-15, -5.336889441571147e-17,  4.390900395095134e-19, -8.501661752614421e-22, -1.165683498075700e-23,  1.120255655732431e-25,
  6.552146953673837e-01, -4.513133653004045e-03,  1.455831869365005e-05,  1.842067095959364e-08, -4.556297204964256e-10,  1.699448473842692e-12,  6.756965204649403e-15,
 -1.000824997129981e-16,  2.918970448025631e-19,  2.442393350748470e-21, -2.672090062789294e-23,  4.963382905455521e-26,  7.805805640481664e-01, -5.037118059684174e-03,
  1.212398741526021e-05,  5.454902532632559e-08, -5.365702442889682e-10,  3.575483762967855e-13,  1.846386350044342e-14, -9.705518228447023e-17, -3.445520249214507e-19,
  5.950415994113801e-21, -1.271529681090734e-23, -2.225018060979421e-25,  9.142400813055570e-01, -5.445530059162617e-03,  7.903145187134210e-06,  9.164148416926724e-08,
 -4.775437273235357e-10, -1.900274667846863e-12,  2.525424361206638e-14, -2.879994603953355e-20, -1.174330816050526e-18,  4.090851971712745e-21,  4.434444944938368e-23,
 -3.738463298415741e-25,  1.054650755190786e+00, -5.688556102281386e-03,  1.947839278884312e-06,  1.206735017402723e-07, -2.275811300482197e-10, -4.338084625748552e-12,
  1.756773716639551e-14,  1.727967333309723e-16, -1.225313234571526e-18, -6.635485032268963e-21,  8.053433933171396e-23,  2.004058821623257e-25,  1.199716781145024e+00,
 -5.714496636165394e-03, -5.337719890837738e-06,  1.301135113042871e-07,  2.027979887376924e-10, -5.473581356762778e-12, -8.983664837600899e-15,  2.823184729678911e-16,
  4.200437833452284e-19, -1.622535410730147e-20, -2.008622017296953e-23,  9.918805559935204e-25,  1.346622038682667e+00, -5.476210349844439e-03, -1.306267803191586e-05,
  1.090277933904542e-07,  6.906733161463011e-10, -3.657556835447399e-12, -4.176380300581103e-14,  1.267611588663894e-16,  2.671960735396815e-18, -3.021106533220400e-21,
 -1.755960239036576e-22, -1.191090067860494e-25,  1.491646279416813e+00, -4.942655258458444e-03, -1.978545485458863e-05,  5.338848658405410e-08,  9.876050838737617e-10,
  1.324830612450443e-12, -4.826732806237335e-14, -2.744027629366951e-16,  1.886479519280657e-18,  2.578946011578060e-20, -2.002825825272645e-23, -1.890554048706887e-24,
  1.630003299641819e+00, -4.116779444673569e-03, -2.367018511846612e-05, -2.544222465486333e-08,  8.250318800528315e-10,  6.449255625535037e-12, -5.553847437536990e-15,
 -4.359764541029644e-16, -2.552433578510016e-18,  1.268977649968984e-20,  2.692317928140766e-22,  9.316670562902767e-25,  1.755784683585615e+00, -3.058286915225799e-03,
 -2.306608614726598e-05, -9.624630938545092e-08,  1.791584060494400e-10,  6.541721768616272e-12,  4.802949370653768e-14,  2.413162870752661e-17, -3.024152237828982e-18,
 -3.049516299446788e-20, -7.199021073825547e-23,  1.603881375324616e-24,  1.862149798567524e+00, -1.903086606146767e-03, -1.757829231506403e-05, -1.195755642521813e-07,
 -5.046564604213738e-10,  6.534048739028965e-13,  3.674658094691500e-14,  3.851149173677070e-16,  2.095893779903684e-18, -1.836122933289235e-21, -1.755950059827488e-22,
 -2.036952867118602e-24,  1.941932108712297e+00, -8.614947078643671e-04, -9.159193644542448e-06, -8.112411112314316e-08, -6.122068264818084e-10, -3.782971013073204e-12,
 -1.586823965198390e-14,  1.231970322459728e-17,  1.175363408337932e-18,  1.562711716742755e-20,  1.408920477342586e-22,  9.158125262778397e-25,  1.988755054377315e+00,
 -1.739662861157151e-04, -2.001599830043994e-06, -2.024314671122645e-08, -1.892246219224695e-10, -1.668192962846899e-12, -1.398546626548878e-14, -1.116895525741553e-16,
 -8.466505175551110e-19, -6.030834053621915e-21, -3.950017019357166e-23, -2.261804106304507e-25,  1.466879289308549e-03, -1.264131923619239e-05,  8.165186852046053e-08,
 -4.685648574837268e-10,  2.517910530420541e-12, -1.298077307159939e-14,  6.493347103481491e-17, -3.180996352494489e-19,  1.528140380850380e-21, -7.265244740481843e-24,
  3.386797387539531e-26, -1.585536192163243e-28,  1.320008058909774e-02, -1.133979585606137e-04,  7.271617862590417e-07, -4.119255060394065e-09,  2.168996614292429e-11,
 -1.085579903779027e-13,  5.211219064399925e-16, -2.415590875587636e-18,  1.078119657117134e-20, -4.660875069835866e-23,  1.910419213024339e-25, -7.622847751667881e-28,
  3.665627607277570e-02, -3.128986222765646e-04,  1.976963564589342e-06, -1.090220421533069e-08,  5.496080806293588e-11, -2.574044059110765e-13,  1.118785363364327e-15,
 -4.467971907252594e-18,  1.572700202135585e-20, -4.477731515299154e-23,  5.448885377553361e-26,  4.144786145639883e-28,  7.181293747997468e-02, -6.070289402312319e-04,
  3.748050405993527e-06, -1.979745541352708e-08,  9.270803229444631e-11, -3.835368243515986e-13,  1.335616643746094e-15, -3.300373633042974e-18, -6.634470631949949e-22,
  7.661670047254893e-23, -6.574302558825721e-25,  3.832848543922139e-27,  1.186307758815195e-01, -9.893909121276678e-04,  5.914618330392830e-06, -2.932185812620104e-08,
  1.218638405502126e-10, -3.946141108731960e-13,  6.446708201552174e-16,  3.341830688151149e-18, -4.283494227716330e-20,  2.792777263750145e-22, -1.350751244320564e-24,
  4.398141600798038e-27,  1.770465284384651e-01, -1.451021473041568e-03,  8.306925623916156e-06, -3.759840315150679e-08,  1.277031198685147e-10, -2.077241266636845e-13,
 -1.214777921761095e-15,  1.457902789264663e-17, -8.874985929906572e-20,  3.514180774471683e-22, -5.894151114797726e-25, -5.042223173348857e-27,  2.469622328561355e-01,
 -1.980002433743566e-03,  1.071058666943542e-05, -4.247218223551181e-08,  9.645105490850491e-11,  2.175775604813345e-13, -3.953831318540328e-15,  2.487508193654703e-17,
 -8.931184099907439e-20,  5.688722503604330e-24,  2.539721759885681e-24, -2.162110278740019e-26,  3.282298725675856e-01, -2.560952740197925e-03,  1.286728147180477e-05,
 -4.169580845657683e-08,  1.882925027254887e-11,  8.425480884452661e-13, -6.535775919691397e-15,  2.452760681174773e-17,  7.820553298489755e-21, -8.277186738089251e-22,
  6.170303042070889e-24, -2.223461773223155e-26,  4.206297662030543e-01, -3.174398784207997e-03,  1.447852314948589e-05, -3.321492158895256e-08, -1.054606411309510e-10,
  1.516966695433609e-12, -7.216815771600986e-15,  3.611006482562874e-18,  2.066133691289904e-19, -1.630238163290272e-21,  4.724379906114816e-24,  2.246881262532960e-26,
  5.238403817687141e-01, -3.796032975100419e-03,  1.521515450427255e-05, -1.559024025856295e-08, -2.626470233851314e-10,  1.966954766936760e-12, -4.030124156881640e-15,
 -3.988831992665454e-17,  4.012387691253141e-19, -1.222360561002772e-21, -7.073914878861859e-24,  9.546986996074674e-26,  6.373963223357795e-01, -4.395904206775846e-03,
  1.473677391390501e-05,  1.141038544332675e-08, -4.202402932300265e-10,  1.829117406048511e-12,  4.097200813236395e-15, -8.953629071209008e-17,  3.612151784385866e-19,
  1.428467244185008e-21, -2.373120419363956e-23,  8.319195443488759e-26,  7.606300161989069e-01, -4.937653059023053e-03,  1.272737637590893e-05,  4.604424215224459e-08,
 -5.252136839583706e-10,  7.670186367872738e-13,  1.562335914055389e-14, -1.047692607832493e-16, -1.416294615005546e-19,  5.270408504106232e-21, -2.067958594440486e-23,
 -1.395616167582887e-25,  8.925911892289058e-01, -5.378038673088033e-03,  8.955851111361518e-06,  8.372959730393153e-08, -5.095095940071892e-10, -1.298281370079295e-12,
  2.475172774164375e-14, -3.494154527999610e-17, -9.991911817052701e-19,  5.526041452970667e-21,  2.727861547790084e-23, -3.927270875295267e-25,  1.031936771508625e+00,
 -5.667249399254753e-03,  3.371288878723398e-06,  1.163625811539431e-07, -3.097584158459823e-10, -3.863028110760974e-12,  2.182570557020072e-14,  1.303993609401961e-16,
 -1.404731465205713e-18, -3.309036789725023e-21,  8.405025013767470e-23, -3.758370877685102e-26,  1.176783346534838e+00, -5.750906168219482e-03, -3.760532264675628e-06,
  1.324734994566624e-07,  9.181612645095704e-11, -5.593354571168428e-12, -9.789890847201474e-16,  2.863446416052545e-16, -1.679849373467195e-19, -1.615507858900920e-20,
  2.333955076518459e-23,  9.563156205623980e-25,  1.324516737998320e+00, -5.575296483493062e-03, -1.169062655870462e-05,  1.194402761856947e-07,  6.078356913850582e-10,
 -4.607783578944888e-12, -3.704347776416658e-14,  2.091678363879665e-16,  2.437024702265792e-18, -9.982784551962874e-21, -1.683073496404955e-22,  4.530333046320124e-25,
  1.471563529995314e+00, -5.098106028967569e-03, -1.904931923903913e-05,  6.933672154023820e-08,  1.001934053408412e-09,  8.188513364647428e-14, -5.496795855699350e-14,
 -1.995027361697512e-16,  2.779740175202164e-18,  2.325309854263002e-20, -1.079791404059789e-22, -2.052085440196212e-24,  1.613155854943533e+00, -4.307128009176340e-03,
 -2.389206743163209e-05, -1.122138628835121e-08,  9.516496422893460e-10,  6.160743772385759e-12, -1.882078136527035e-14, -5.081993359520144e-16, -1.893883625922567e-18,
  2.405242334184493e-20,  2.925464861648702e-22,  5.993961528029787e-26,  1.743175246246238e+00, -3.247376345549190e-03, -2.419932211454616e-05, -9.227044910869972e-08,
  3.215137701542978e-10,  7.690572009277383e-12,  4.718224772279204e-14, -9.060554674152051e-17, -4.153954248328203e-18, -3.164818247295212e-20,  2.240327937197566e-23,
  2.707979520854355e-24,  1.854246919659362e+00, -2.049588515064597e-03, -1.906104929840766e-05, -1.274938039467078e-07, -4.818570250315068e-10,  1.672186112918905e-12,
  4.844809275122481e-14,  4.495850495847759e-16,  1.880256090652478e-18, -1.081699857937645e-20, -2.773488323285494e-22, -2.569086805569929e-24,  1.938333174513349e+00,
 -9.388346182458963e-04, -1.019401810181505e-05, -9.154518709072797e-08, -6.916223640774683e-10, -4.154858526465716e-12, -1.490392823901034e-14,  6.010141654883530e-17,
  1.849445013110213e-18,  2.210607972163417e-20,  1.838062526350286e-22,  1.017005471129453e-24,  1.988025548995141e+00, -1.910048845454116e-04, -2.263846279939435e-06,
 -2.355700962838082e-08, -2.262150197839724e-10, -2.044645340249639e-12, -1.752700288954206e-14, -1.425813524457063e-16, -1.094722991583790e-18, -7.823453003749500e-21,
 -5.046083013645554e-23, -2.712932520263985e-25,  1.417585772870219e-03, -1.200992972482372e-05,  7.626250856866765e-08, -4.302734713418762e-10,  2.273185217405668e-12,
 -1.152395813898396e-14,  5.667375654453305e-17, -2.731355316306138e-19,  1.289382383880291e-21, -6.040590276800593e-24,  2.758493870033647e-26, -1.282965353613718e-28,
  1.275781839687314e-02, -1.077726495472393e-04,  6.797434540410776e-07, -3.788927651995601e-09,  1.963859211962221e-11, -9.682521759927103e-14,  4.580732370883185e-16,
 -2.096027820746885e-18,  9.233076037270902e-21, -3.960225037367895e-23,  1.601215066330466e-25, -6.471561883785891e-28,  3.543550503398143e-02, -2.975916522058246e-04,
  1.851248076621659e-06, -1.006259862603340e-08,  5.007138271464677e-11, -2.319994005420088e-13,  1.000488696469926e-15, -3.990047545154905e-18,  1.415799844150701e-20,
 -4.230311678372942e-23,  6.760981668436715e-26,  1.927767713149233e-28,  6.944332076427424e-02, -5.779701700750336e-04,  3.519133333586634e-06, -1.837378257640697e-08,
  8.535035633553265e-11, -3.525909744700750e-13,  1.243289255190177e-15, -3.282233972278535e-18,  1.659663144006080e-21,  5.343266537778332e-23, -5.079263843150731e-25,
  2.987186050538504e-27,  1.147656636770451e-01, -9.434488619147177e-04,  5.574197319819408e-06, -2.743430514144400e-08,  1.141330961960695e-10, -3.781651208718255e-13,
  7.204912988945816e-16,  2.121922175419907e-18, -3.370763208942323e-20,  2.290291064657599e-22, -1.164217669549458e-24,  4.050901638877986e-27,  1.713725444872096e-01,
 -1.386336381519050e-03,  7.867862422113988e-06, -3.558983999762459e-08,  1.232885462920731e-10, -2.322896459102925e-13, -8.444579322177992e-16,  1.193651055785912e-17,
 -7.656979452890285e-20,  3.241452361172331e-22, -7.574682009193189e-25, -2.738608362470241e-27,  2.392104020544630e-01, -1.896329872075293e-03,  1.021030731716911e-05,
 -4.089907773387873e-08,  9.990843743971565e-11,  1.307215303969259e-13, -3.297180532156066e-15,  2.203820694987827e-17, -8.749538431530253e-20,  8.959775735730886e-23,
  1.688042833539107e-24, -1.718797599847386e-26,  3.181887780794633e-01, -2.460009539211163e-03,  1.236926849147327e-05, -4.126802173453973e-08,  3.416728979442999e-11,
  6.939331433709128e-13, -5.849650520870712e-15,  2.434679685153255e-17, -1.777377056370093e-20, -6.008045103146235e-22,  5.170935876849574e-24, -2.286356517583347e-26,
  4.081612655689408e-01, -3.060191355671364e-03,  1.407079070785672e-05, -3.466894076665862e-08, -7.684151728422915e-11,  1.345670647363679e-12, -7.031697819012110e-15,
  9.321739967680379e-18,  1.515218987498250e-19, -1.426120214937749e-21,  5.374634602127341e-24,  7.787638981360657e-27,  5.088984105222573e-01, -3.675128556742106e-03,
  1.500413769791665e-05, -1.948348932405552e-08, -2.243583052203796e-10,  1.858237775240709e-12, -4.974200977422794e-15, -2.779949110753488e-17,  3.531013303686324e-19,
 -1.427000145900332e-21, -3.302405676259395e-24,  7.569647095459908e-26,  6.200492034125523e-01, -4.277573811487622e-03,  1.483457772389128e-05,  4.983713945875028e-09,
 -3.828707564576260e-10,  1.898713336961358e-12,  1.758477129686360e-15, -7.733027503490239e-17,  3.964918058807874e-19,  5.583575346546917e-22, -1.965669917882516e-23,
  9.938969545281208e-26,  7.410863413629427e-01, -4.833765489266694e-03,  1.323005625078949e-05,  3.778291462088155e-08, -5.063632462025690e-10,  1.106433988420252e-12,
  1.265369250457181e-14, -1.064358875379861e-16,  3.195106769776263e-20,  4.343898017923877e-21, -2.508213810274452e-23, -6.228045680705218e-26,  8.712284936121231e-01,
 -5.302513195734265e-03,  9.910939983471165e-06,  7.540159980809733e-08, -5.296319222887495e-10, -7.194028235870475e-13,  2.335694073981614e-14, -6.355558421351274e-17,
 -7.847299800802688e-19,  6.277448886278153e-21,  1.051597035433035e-23, -3.621903721805143e-25,  1.009330431641085e+00, -5.634783619726209e-03,  4.735448807213902e-06,
  1.108179715554528e-07, -3.815116976655222e-10, -3.300563525744145e-12,  2.483424785686247e-14,  8.418373143164309e-17, -1.464321161863834e-18, -4.336149692740879e-23,
  7.775493656778804e-23, -2.401812211334609e-25,  1.153729645385968e+00, -5.774615221103790e-03, -2.165724265095881e-06,  1.330490524163365e-07, -1.964188249144954e-11,
 -5.521774888766771e-12,  6.877722053215955e-15,  2.719238723528453e-16, -7.230007592012033e-19, -1.442338236942861e-20,  6.193307165437777e-23,  7.768212369408214e-25,
  1.302037803292780e+00, -5.662930338547239e-03, -1.020218281456893e-05,  1.283822423012239e-07,  5.073079462446432e-10, -5.418111744115967e-12, -3.015800731803548e-14,
  2.801520610857559e-16,  1.962760733941775e-18, -1.615355015238911e-20, -1.363637193332448e-22,  9.821826213630385e-25,  1.450871970672028e+00, -5.246900244067953e-03,
 -1.812127578507091e-05,  8.530738094962248e-08,  9.899820813523719e-10, -1.293587913429114e-12, -5.918982545672031e-14, -9.816601692186697e-17,  3.517601687306142e-18,
  1.716181969390900e-20, -1.950235159117663e-22, -1.837250665392211e-24,  1.595544594551464e+00, -4.498535146069562e-03, -2.393139260144268e-05,  4.961234464461845e-09,
  1.069163229780268e-09,  5.532322346765097e-12, -3.375261702896173e-14, -5.527058150416706e-16, -8.198003555264996e-19,  3.546488320999837e-20,  2.690400168532863e-22,
 -1.177762164213501e-24,  1.729791678526218e+00, -3.445300368306332e-03, -2.527043014315896e-05, -8.583535779137338e-08,  4.863614021852447e-10,  8.776441374941294e-12,
  4.261572324401503e-14, -2.413352304183721e-16, -5.245377436058416e-18, -2.803360796530070e-20,  1.664257264028681e-22,  3.814482922068528e-24,  1.845733718142709e+00,
 -2.208324703249423e-03, -2.063591295518053e-05, -1.348683932884861e-07, -4.357327871071231e-10,  2.992357943705549e-12,  6.180370554779051e-14,  5.011532448080755e-16,
  1.262846787211997e-18, -2.428375505042068e-20, -3.981109920771130e-22, -2.854820137272108e-24,  1.934407500252223e+00, -1.024975491611233e-03, -1.136175938008984e-05,
 -1.032946545871720e-07, -7.781222927809143e-10, -4.484882895787866e-12, -1.226227482805370e-14,  1.335233170353353e-16,  2.788377096983037e-18,  3.034873292389473e-20,
  2.277731775989673e-22,  9.377557619974426e-25,  1.987223426424089e+00, -2.103111851223894e-04, -2.569674425190807e-06, -2.752788047810402e-08, -2.716593969239568e-10,
 -2.517434020330376e-12, -2.205497319746212e-14, -1.825323912763752e-16, -1.415678986799683e-18, -1.009166519404908e-20, -6.318406755373806e-23, -3.030019105366211e-25,
  1.370734403722789e-03, -1.141988152537348e-05,  7.131007936266906e-08, -3.956749574559424e-10,  2.055711554995289e-12, -1.025109269943673e-14,  4.957236982562823e-17,
 -2.351523139179134e-19,  1.090489349034452e-21, -5.042770971797292e-24,  2.247561322336333e-26, -1.049981077039877e-28,  1.233732308739953e-02, -1.025113721353686e-04,
  6.360996042064871e-07, -3.489624255361599e-09,  1.780743866767624e-11, -8.650361293502334e-14,  4.033150479048792e-16, -1.822198098475048e-18,  7.916083390682108e-21,
 -3.373830728681432e-23,  1.337395325019369e-25, -5.560322162638861e-28,  3.427401240982433e-02, -2.832513972586579e-04,  1.735154750698946e-06, -9.297308851450518e-09,
  4.566272124557250e-11, -2.092785206388437e-13,  8.948850054397615e-16, -3.560822878208360e-18,  1.268532214422587e-20, -3.948202765844244e-23,  7.220447895979186e-26,
  2.201875679582375e-29,  6.718638189086006e-02, -5.506763552328374e-04,  3.306614033418063e-06, -1.706300129922652e-08,  7.858952022807537e-11, -3.238472183066207e-13,
  1.152392877944670e-15, -3.202024916065869e-18,  3.247198003364130e-21,  3.552515461670188e-23, -3.926756973471417e-25,  2.268792162781084e-27,  1.110790134563798e-01,
 -9.001416544160541e-04,  5.255695939855618e-06, -2.566772439869818e-08,  1.067469254675792e-10, -3.602749450684765e-13,  7.659815076505010e-16,  1.166551554614474e-18,
 -2.625909896166523e-20,  1.858877949750380e-22, -9.964864620556015e-25,  3.551675922996200e-27,  1.659504268009931e-01, -1.325068619667533e-03,  7.452463463228130e-06,
 -3.365538198319380e-08,  1.184657695162906e-10, -2.488122770701456e-13, -5.428275335302847e-16,  9.666932325580279e-18, -6.547034675466317e-20,  2.919352891540041e-22,
 -8.420036643506312e-25, -1.223123931040563e-27,  2.317853777461899e-01, -1.816583222392529e-03,  9.729182502923630e-06, -3.928372265930189e-08,  1.017799064894579e-10,
  5.868106282586118e-14, -2.718739076852206e-15,  1.930158586749359e-17, -8.322607392809822e-20,  1.431545858927415e-22,  1.017180118909478e-24, -1.343081381059082e-26,
  3.085435262986807e-01, -2.363025956454489e-03,  1.187776620742423e-05, -4.061771335626875e-08,  4.669684315001097e-11,  5.616391781501730e-13, -5.178881157536452e-15,
  2.346993399425193e-17, -3.592058353456048e-20, -4.139026146027414e-22,  4.180834251771278e-24, -2.196014371796927e-26,  3.961429710732042e-01, -2.949308053732619e-03,
  1.364824533864357e-05, -3.569216906606866e-08, -5.159193432686437e-11,  1.180543965176417e-12, -6.710226788775738e-15,  1.339094798014749e-17,  1.041022710290633e-19,
 -1.207700769791040e-21,  5.468419421062735e-24, -2.922785139386253e-27,  4.944363992690080e-01, -3.556088906948114e-03,  1.475000218546929e-05, -2.278263281702944e-08,
 -1.884440126871320e-10,  1.730744912643984e-12, -5.602266051745401e-15, -1.734153908849611e-17,  3.000997433068305e-19, -1.498467816992152e-21, -4.182223631377213e-25,
  5.550653808104765e-26,  6.031764969695305e-01, -4.158759214880263e-03,  1.485888532822513e-05, -8.368411731155940e-10, -3.446423708867981e-10,  1.916380891792301e-12,
 -2.271522145368800e-16, -6.446401052129441e-17,  4.035092226531347e-19, -1.389333253348174e-22, -1.519301495480678e-23,  1.014860261650202e-25,  7.219656397101308e-01,
 -4.726247406195721e-03,  1.363562129052724e-05,  2.987362312540462e-08, -4.814378921314505e-10,  1.374613147774613e-12,  9.709905328275025e-15, -1.031091500341050e-16,
  1.697949534166496e-19,  3.305693148049996e-21, -2.636490103491245e-23,  1.252699965030638e-27,  8.501825418155324e-01, -5.219751357772730e-03,  1.076453660026216e-05,
  6.684218864656337e-08, -5.385722278464082e-10, -1.828175441371280e-13,  2.126020195817927e-14, -8.500013377151919e-17, -5.548583207893914e-19,  6.396530346911268e-21,
 -4.087772805727508e-24, -2.973717233412612e-25,  9.868753336635353e-01, -5.591689340683891e-03,  6.026567831678799e-06,  1.042187844419471e-07, -4.413991149943799e-10,
 -2.681531376046772e-12,  2.653928737887167e-14,  3.787718786494728e-17, -1.412879190076822e-18,  2.808794927442461e-21,  6.381949851359595e-23, -3.819088735269012e-25,
  1.130606626121993e+00, -5.785568325490010e-03, -5.746296297384478e-07,  1.318628025795955e-07, -1.278254836674068e-10, -5.268418621483918e-12,  1.409340076165574e-14,
  2.410204381506283e-16, -1.190108457634748e-18, -1.134001311284322e-20,  9.016921824487782e-23,  4.940804939061361e-25,  1.279232787707214e+00, -5.738255942965729e-03,
 -8.616590106319898e-06,  1.355957330241460e-07,  3.923774444769999e-10, -6.041248215571251e-12, -2.152883331940579e-14,  3.326954988349122e-16,  1.294627655838608e-18,
 -2.061887392905725e-20, -8.415969019305997e-23,  1.357472202495716e-24,  1.429601289568719e+00, -5.387508892333220e-03, -1.700365470748920e-05,  1.008622377057784e-07,
  9.497500756781419e-10, -2.733894575858519e-12, -6.028131674416779e-14,  2.262739414940949e-17,  3.976877389682738e-18,  7.897878551757718e-21, -2.636665748403733e-22,
 -1.219738976666138e-24,  1.577168349992583e+00, -4.689449238335527e-03, -2.376572382708666e-05,  2.290370502572643e-08,  1.170445458528040e-09,  4.534836984729630e-12,
 -4.938961423761104e-14, -5.565606191766102e-16,  6.344057398153893e-19,  4.477701280419824e-20,  1.862247589356241e-22, -2.592351772941421e-24,  1.715599831473468e+00,
 -3.651437927925260e-03, -2.624779840603032e-05, -7.659642401283168e-08,  6.714688666168052e-10,  9.698284672620717e-12,  3.336783284413398e-14, -4.237051539168314e-16,
 -6.091854269405910e-18, -1.775692697025867e-20,  3.529666239513518e-22,  4.569792031232245e-24,  1.836559834088634e+00, -2.379999113120958e-03, -2.229391479818447e-05,
 -1.412759069163717e-07, -3.598963708173454e-10,  4.647677090998851e-12,  7.624699661284360e-14,  5.242587868098827e-16,  7.193175593371503e-20, -4.268658283314871e-20,
 -5.198020175612033e-22, -2.541005864923724e-24,  1.930117651833045e+00, -1.121046273149293e-03, -1.267900285442251e-05, -1.164767164377170e-07, -8.704034375474343e-10,
 -4.723156593176580e-12, -7.097203049799682e-15,  2.420660169398177e-16,  4.054018726515920e-18,  4.018433534789796e-20,  2.606136613414338e-22,  4.663896043789223e-25,
  1.986338865165381e+00, -2.322678325090208e-04, -2.927847939169671e-06, -3.230781423937375e-08, -3.277432006726391e-10, -3.113557133304357e-12, -2.785834995584886e-14,
 -2.341609261135674e-16, -1.827702613624727e-18, -1.288683920670718e-20, -7.649275424936531e-23, -2.907978340893941e-25,  1.326166536960198e-03, -1.086784930740423e-05,
  6.675276590441454e-08, -3.643612748338755e-10,  1.862073433454336e-12, -9.136585548354160e-15,  4.345053917432240e-17, -2.029964785196728e-19,  9.240694290871580e-22,
 -4.230649886818118e-24,  1.825580772994914e-26, -8.778505075836857e-29,  1.193719664998676e-02, -9.758536179534465e-05,  5.958781922825225e-07, -3.218036738282429e-09,
  1.617017257927658e-11, -7.740877230717829e-14,  3.556644051183932e-16, -1.587330772589148e-18,  6.792097284504219e-21, -2.885682226912855e-23,  1.108098021381562e-25,
 -4.909158504157372e-28,  3.316807982576790e-02, -2.698043205046476e-04,  1.627836231217943e-06, -8.599056035177607e-09,  4.168407885057450e-11, -1.889531402745130e-13,
  8.006552843091500e-16, -3.177077593384207e-18,  1.131578153794830e-20, -3.661920207730150e-23,  6.984002095845024e-26, -1.292028344650802e-28,  6.503531504786549e-02,
 -5.250215733134862e-04,  3.109193657561089e-06, -1.585591206811449e-08,  7.238195327859737e-11, -2.972528497926515e-13,  1.064362648104319e-15, -3.080499881437149e-18,
  4.265676278113295e-21,  2.162226189086968e-23, -3.071381190411081e-25,  1.626516696441974e-27,  1.075606275037612e-01, -8.592996435846760e-04,  4.957696432357706e-06,
 -2.401640926873639e-08,  9.972744239827445e-11, -3.415884647512988e-13,  7.878337729280047e-16,  4.259342342813631e-19, -2.024852755539620e-20,  1.489782800898878e-22,
 -8.535796490250421e-25,  2.920651396313000e-27,  1.607668789156835e-01, -1.267032529961064e-03,  7.059805325766836e-06, -3.180035959034679e-08,  1.133799868141729e-10,
 -2.588193131102682e-13, -2.999510518235602e-16,  7.733448835687291e-18, -5.557714304077314e-20,  2.574709788165285e-22, -8.751732518007814e-25, -3.939336998744072e-28,
  2.246717653868974e-01, -1.740607629869663e-03,  9.267576436759819e-06, -3.764922202091220e-08,  1.023432721758850e-10, -3.792725708428408e-16, -2.214755630219156e-15,
  1.672756194864627e-17, -7.747400922254762e-20,  1.729492503326130e-22,  4.938782331459754e-25, -1.050564725525459e-26,  2.992783987891507e-01, -2.269939964579577e-03,
  1.139518595486681e-05, -3.978723392683282e-08,  5.673919938999510e-11,  4.450893789284039e-13, -4.539836173862282e-15,  2.211247964430283e-17, -4.803972291669105e-20,
 -2.655466241884792e-22,  3.248727789238665e-24, -2.035742140340821e-26,  3.845613806625412e-01, -2.841847609908320e-03,  1.321573766271000e-05, -3.633736936203080e-08,
 -2.955935832490722e-11,  1.024335641948076e-12, -6.294879713545566e-15,  1.606840144196785e-17,  6.450900943910678e-20, -9.939444873635036e-22,  5.164882341830730e-24,
 -1.042428835793786e-26,  4.804462432413059e-01, -3.439231130083715e-03,  1.445963818863371e-05, -2.552826939568072e-08, -1.552075922088926e-10,  1.591499082403207e-12,
 -5.961491209154225e-15, -8.600259557862101e-18,  2.463902944288554e-19, -1.472047117293893e-21,  1.601355705852664e-24,  3.658182684372283e-26,  5.867790101670761e-01,
 -4.040019135321669e-03,  1.481701980458614e-05, -6.045381916441939e-09, -3.065079673692112e-10,  1.890719820200363e-12, -1.852910372061108e-15, -5.174039234388726e-17,
  3.886294950675921e-19, -6.591577509501799e-22, -1.087911010828276e-23,  9.317641660960785e-26,  7.032809084016690e-01, -4.615857286217653e-03,  1.394883233715051e-05,
  2.240224745548240e-08, -4.518454901464724e-10,  1.573722883170227e-12,  6.915361693680176e-15, -9.597414969013054e-17,  2.699676123278611e-19,  2.266997043361317e-21,
 -2.523755495280370e-23,  4.686840211576091e-26,  8.294806420201081e-01, -5.130573233482438e-03,  1.151490678165817e-05,  5.822266290816764e-08, -5.373283829228216e-10,
  2.970719279150760e-13,  1.866587327910270e-14, -9.912696173325010e-17, -3.304676904540689e-19,  5.994781776986907e-21, -1.540102668107687e-23, -2.154387646986272e-25,
  9.646127474276465e-01, -5.538598206601793e-03,  7.233161988125389e-06,  9.676223084999508e-08, -4.886003540533330e-10, -2.036860513844768e-12,  2.698539393219654e-14,
 -5.258920364398643e-18, -1.270108536062585e-18,  4.999462771781262e-21,  4.519769431942520e-23, -4.528697065348957e-25,  1.107465120839958e+00, -5.783878594071552e-03,
  9.920412020272585e-07,  1.289952381680945e-07, -2.292885532919985e-10, -4.853848946482860e-12,  2.025261365050309e-14,  1.971380731143250e-16, -1.529053573150087e-18,
 -7.393879890318652e-21,  1.047387327599227e-22,  1.657003254221061e-25,  1.256152342125425e+00, -5.800582691020367e-03, -6.955842399735496e-06,  1.408823413188277e-07,
  2.671613220311511e-10, -6.442179279940896e-12, -1.174889101000849e-14,  3.617182009183605e-16,  5.067311850364112e-19, -2.273018381380796e-20, -2.036482836694208e-23,
  1.499977540267199e-24,  1.407787219638679e+00, -5.518443074656047e-03, -1.570418962919720e-05,  1.155426857112114e-07,  8.807311491751882e-10, -4.158475368326154e-12,
 -5.783841204558659e-14,  1.523112291694423e-16,  4.060741955083308e-18, -3.464008209274425e-21, -2.975650057846996e-22, -2.804772339728735e-25,  1.558032500119578e+00,
 -4.878150841492799e-03, -2.337574656742231e-05,  4.228676457045015e-08,  1.248044755728543e-09,  3.166310776096323e-12, -6.443792591634086e-14, -5.092776266607048e-16,
  2.349326777768215e-18,  4.954850537841218e-20,  4.309705326613334e-23, -3.856165328633705e-24,  1.700568571268195e+00, -3.864899301568171e-03, -2.709596465926175e-05,
 -6.426212146017165e-08,  8.723659120653618e-10,  1.033423617599750e-11,  1.870056750168175e-14, -6.257495694817030e-16, -6.427874582088425e-18,  4.386420055373697e-22,
  5.563146345016356e-22,  4.493386127669708e-24,  1.826672269988056e+00, -2.565221831687614e-03, -2.402037259290716e-05, -1.461862184420669e-07, -2.474597511743863e-10,
  6.652447557256507e-12,  9.069765341548319e-14,  4.977586460378913e-16, -1.863286476274732e-18, -6.540022325235093e-20, -6.057624950484803e-22, -1.143247948723527e-24,
  1.925421406703757e+00, -1.228313154860363e-03, -1.416342247330765e-05, -1.311655452086868e-07, -9.659391943066548e-10, -4.796086621311671e-12,  1.728823033579735e-15,
  3.969768727005174e-16,  5.690736821544705e-18,  5.073166147895339e-20,  2.579910705152580e-22, -7.447550118422722e-25,  1.985360360470082e+00, -2.573355174492692e-04,
 -3.349184068320051e-06, -3.808855569668923e-08, -3.972674782943573e-10, -3.867894954378308e-12, -3.530775937814773e-14, -3.006845176020707e-16, -2.349584170783008e-18,
 -1.617822327003996e-20, -8.721880935317947e-23, -1.711180992576782e-25,  1.283736189706935e-03, -1.035082356624048e-05,  6.255333790517133e-08, -3.359751682477147e-10,
  1.689326145464505e-12, -8.158773862194796e-15,  3.815868679689369e-17, -1.757294991156831e-19,  7.840141609483053e-22, -3.573933406577587e-24,  1.466099862357869e-26,
 -7.668626522627284e-29,  1.155615074101515e-02, -9.296851845499634e-05,  5.587644602752794e-07, -2.971250275722076e-09,  1.470387948962879e-11, -6.938253984042846e-14,
  3.141116881040927e-16, -1.385791208642645e-18,  5.827944517250140e-21, -2.484428454483921e-23,  9.004891062256667e-26, -4.593522125417499e-28,  3.211427003157931e-02,
 -2.571833278479920e-04,  1.528527822357138e-06, -7.961328746553850e-09,  3.809017407080928e-11, -1.707651928076890e-13,  7.165721646215744e-16, -2.835539993605212e-18,
  1.004597694341762e-20, -3.398685583428922e-23,  6.052456860710976e-26, -3.021950518360078e-28,  6.298379801397343e-02, -5.008898628924666e-04,  2.925679609801971e-06,
 -1.474400238317675e-08,  6.668543921546508e-11, -2.727271317807778e-13,  9.801205455473051e-16, -2.933786023581983e-18,  4.838497234379422e-21,  1.058213449022053e-23,
 -2.495445952294757e-25,  9.824797666516334e-28,  1.042009644444566e-01, -8.207642464313252e-04,  4.678851243068472e-06, -2.247439421067914e-08,  9.308536101363083e-11,
 -3.226058329696511e-13,  7.914492727386705e-16, -1.425584695622849e-19, -1.547091730179798e-20,  1.171824553686853e-22, -7.421281210835219e-25,  2.105904954060565e-27,
  1.558093318701912e-01, -1.212050060854191e-03,  6.688913594370160e-06, -3.002801191347761e-08,  1.081481485973734e-10, -2.636123442431723e-13, -1.069679435141750e-16,
  6.096499948558467e-18, -4.694153711559836e-20,  2.222120062667113e-22, -8.867223502821265e-25, -2.518083871603609e-28,  2.178547940258938e-01, -1.668246362232060e-03,
  8.825601544337536e-06, -3.601452410996826e-08,  1.018406604887766e-10, -4.818722523615002e-14, -1.780134105414912e-15,  1.435096104789139e-17, -7.099764434578154e-20,
  1.841030109309329e-22,  7.772983288476090e-26, -8.599549495383408e-27,  2.903779607089531e-01, -2.180672192000468e-03,  1.092346126104501e-05, -3.881390510146070e-08,
  6.460064526826967e-11,  3.433814129708142e-13, -3.943476871655388e-15,  2.044561099646958e-17, -5.547177172081157e-20, -1.530321655230480e-22,  2.388125668521328e-24,
 -1.884300104300946e-26,  3.734026710211805e-01, -2.737872438046455e-03,  1.277750143109592e-05, -3.665447715739776e-08, -1.054590312506991e-11,  8.788591151154752e-13,
 -5.821165098409695e-15,  1.759904980616456e-17,  3.231956504718192e-20, -7.982135607041378e-22,  4.582759777186443e-24, -1.578809254392854e-26,  4.669186763091221e-01,
 -3.324819229741412e-03,  1.413942404860704e-05, -2.776479126985258e-08, -1.248234752421590e-10,  1.446376101473524e-12, -6.099777503884789e-15, -1.548469807499040e-18,
  1.948902760689990e-19, -1.380959690983096e-21,  2.828647389392022e-24,  1.949771751012569e-26,  5.708554325609453e-01, -3.921853669531658e-03,  1.471628921943133e-05,
 -1.064987801283350e-08, -2.692484573089147e-10,  1.830245748988345e-12, -3.131656205125292e-15, -3.976012928233443e-17,  3.580181169627416e-19, -1.016454682394149e-21,
 -7.098822123806441e-24,  7.768313336568301e-26,  6.850421928584304e-01, -4.503311775431820e-03,  1.417534755492367e-05,  1.543263769341904e-08, -4.189236749082506e-10,
  1.708489006784759e-12,  4.359937138868017e-15, -8.621961915626682e-17,  3.339916262945018e-19,  1.307932830721117e-21, -2.252234146914721e-23,  7.342106801290223e-26,
  8.091468069716949e-01, -5.035804839806842e-03,  1.216226749915490e-05,  4.969631790963151e-08, -5.271373011873656e-10,  7.107459843951082e-13,  1.577376485899744e-14,
 -1.063848789566972e-16, -1.278021117761504e-19,  5.213993340787473e-21, -2.303258627641978e-23, -1.324733127584038e-25,  9.425812477054842e-01, -5.476224090896410e-03,
  8.346172451877435e-06,  8.865378600805035e-08, -5.228959848048598e-10, -1.395392966031772e-12,  2.629845229681860e-14, -4.271319078299187e-17, -1.062449226228347e-18,
  6.402968850138891e-21,  2.494129052526685e-23, -4.581291883571840e-25,  1.084355185214091e+00, -5.769820056876566e-03,  2.514859247860006e-06,  1.245781893086492e-07,
 -3.210873083294430e-10, -4.307293678896432e-12,  2.505326707122729e-14,  1.447665668949185e-16, -1.718938168984357e-18, -3.154037557361261e-21,  1.049526784634874e-22,
 -1.494424987787684e-25,  1.232849514516289e+00, -5.849404284408079e-03, -5.243898815458697e-06,  1.441143200428817e-07,  1.363246305676430e-10, -6.601541537647574e-12,
 -1.517157137841867e-15,  3.648123063181440e-16, -3.104228168331284e-19, -2.224057535416710e-20,  4.399486790973127e-23,  1.383742024595288e-24,  1.385471290810072e+00,
 -5.638297786528324e-03, -1.423611152052572e-05,  1.288953186438496e-07,  7.841009629328009e-10, -5.480934650906233e-12, -5.178965817753107e-14,  2.779571234118695e-16,
  3.721676812140835e-18, -1.529843681979073e-20, -2.862793646332518e-22,  7.970348595684834e-25,  1.538149583480902e+00, -5.062783337661182e-03, -2.274668834994626e-05,
  6.267338900288734e-08,  1.294801741580277e-09,  1.458829980094935e-12, -7.737667801837275e-14, -4.055751037920191e-16,  4.120726808034446e-18,  4.761575922672025e-20,
 -1.449668282348010e-22, -4.568806066044875e-24,  1.684670910565960e+00, -4.084498481942421e-03, -2.777648068221598e-05, -4.863277707820187e-08,  1.082000098819761e-09,
  1.054973218177502e-11, -1.664950832440851e-15, -8.265234170413056e-16, -5.966442200071033e-18,  2.634423747791121e-20,  7.288361787280710e-22,  3.097830332261298e-24,
  1.816015865850083e+00, -2.764458156925774e-03, -2.579357703629953e-05, -1.489583251835863e-07, -9.155911388483707e-11,  8.987356159960851e-12,  1.034124917681346e-13,
  3.957305681860662e-16, -4.659356072265383e-18, -8.988585321715436e-20, -5.967275438362138e-22,  1.854134974252082e-24,  1.920271190254505e+00, -1.348186471339210e-03,
 -1.583328602716458e-05, -1.473815200612410e-07, -1.060431903674232e-09, -4.598876400670280e-12,  1.568184592095603e-14,  6.101947763128192e-16,  7.689534432738977e-18,
  5.978249865411529e-20,  1.766870860345794e-22, -3.207952231771354e-24,  1.984274376028086e+00, -2.860714906080901e-04, -3.847094570133865e-06, -4.511276236212955e-08,
 -4.838274734212334e-10, -4.825369785108331e-12, -4.487196062218320e-14, -3.858734823201091e-16, -2.995913151265328e-18, -1.973666410113184e-20, -8.815330210783888e-23,
  1.827126875339375e-25,  1.243308847484069e-03, -9.866076260523007e-06,  5.867858313616955e-08, -3.102032182347045e-10,  1.534924359939534e-12, -7.299290493576479e-15,
  3.357092632252825e-17, -1.525929357547072e-19,  6.651118023455049e-22, -3.053278896414747e-24,  1.139891994146137e-26, -7.299715806522850e-29,  1.119299659405986e-02,
 -8.863712619510813e-05,  5.244765285719766e-07, -2.746692632558143e-09,  1.338857801657806e-11, -6.228921386868218e-14,  2.777907236270249e-16, -1.212951633945816e-18,
  4.993511910330120e-21, -2.164766925304299e-23,  6.964630483526259e-26, -4.784280093646014e-28,  3.110940239626066e-02, -2.453271421453304e-04,  1.436538783666797e-06,
 -7.378300337277085e-09,  3.484059952978925e-11, -1.544849905895334e-13,  6.414968674614473e-16, -2.533207779605963e-18,  8.862227049984643e-21, -3.189887196896261e-23,
  4.200393010723417e-26, -5.605365618738437e-28,  6.102595396293507e-02, -4.781744060680061e-04,  2.754977447943352e-06, -1.371942123064566e-08,  6.145956335488746e-11,
 -2.501722097922383e-13,  9.001861480192025e-16, -2.774713194719762e-18,  5.048289703106771e-21,  1.252558207365302e-24, -2.225352537111781e-25,  2.104510657725203e-28,
  1.009910961313704e-01, -7.843873718570604e-04,  4.417885124403448e-06, -2.103561563357503e-08,  8.682259554512045e-11, -3.037111956193005e-13,  7.811209722871317e-16,
 -5.756965255094845e-19, -1.176709268820255e-20,  8.904353237026935e-23, -6.731813496780756e-25,  9.532262020243399e-28,  1.510659131151843e-01, -1.159951081695591e-03,
  6.338785389126451e-06, -2.833990392009153e-08,  1.028632094976704e-10, -2.642937452382243e-13,  4.385789494224001e-17,  4.715490830017199e-18, -3.958413786979275e-20,
  1.863850598280812e-22, -9.097126683766998e-25, -9.559658515928853e-28,  2.113203200898965e-01, -1.599342634041066e-03,  8.403164997919437e-06, -3.439497271223690e-08,
  1.004809309818399e-10, -8.633912084340604e-14, -1.409117689268931e-15,  1.218495838626811e-17, -6.440244413956936e-20,  1.799217265618607e-22, -2.826862265115065e-25,
 -8.044334166955445e-27,  2.818271229182002e-01, -2.095129508499377e-03,  1.046410655927359e-05, -3.773030507052485e-08,  7.056715373852929e-11,  2.554026362840661e-13,
 -3.396557189099521e-15,  1.859920001418128e-17, -5.945871511979286e-20, -7.382449919925951e-23,  1.576348431993387e-24, -1.829855156083447e-26,  3.626528332021347e-01,
 -2.637413422598751e-03,  1.233719121905216e-05, -3.669001563063025e-08,  5.674610007764205e-12,  7.451559789798546e-13, -5.317988507875485e-15,  1.820744321959312e-17,
  6.703629148665986e-21, -6.301577672941529e-22,  3.786494539679259e-24, -2.042077355171459e-26,  4.538434749519937e-01, -3.213068352528128e-03,  1.379519233148709e-05,
 -2.953850345033645e-08, -9.735996160243304e-11,  1.300120759571471e-12, -6.063133550954542e-15,  3.915818992618033e-18,  1.473762230889649e-19, -1.255351965232545e-21,
  3.337088134624590e-24,  3.731186956340559e-27,  5.554025693604038e-01, -3.804705031845251e-03,  1.456383658630080e-05, -1.466945336580860e-08, -2.334787752480071e-10,
  1.742985578837611e-12, -4.090402404116930e-15, -2.893748146146985e-17,  3.170867148445446e-19, -1.237783112051162e-21, -4.117871030576827e-24,  5.705898092964890e-26,
  6.672567667968350e-01, -4.389279545767126e-03,  1.432146636422870e-05,  9.008103908806986e-09, -3.838966518187838e-10,  1.785402871736349e-12,  2.101292791133872e-15,
 -7.494582620984606e-17,  3.656754521035979e-19,  4.753208638697087e-22, -1.905003456583285e-23,  8.143041919235449e-26,  7.892017599784020e-01, -4.936263448985052e-03,
  1.270855107130821e-05,  4.139539049584812e-08, -5.093796352070712e-10,  1.053275713040013e-12,  1.276462392101598e-14, -1.076591548318694e-16,  4.211662414737604e-20,
  4.198198635668622e-21, -2.724099677717334e-23, -6.176463285486757e-26,  9.208164244783125e-01, -5.405343457747546e-03,  9.359008723368829e-06,  8.009800759770503e-08,
 -5.446080183716196e-10, -7.822046538169801e-13,  2.466230556345899e-14, -7.286979377752845e-17, -8.187563037354010e-19,  7.007539597184377e-21,  5.609138793283423e-24,
 -4.143144080576839e-25,  1.061325479022761e+00, -5.743815094005593e-03,  3.976239643240452e-06,  1.187855601351348e-07, -4.009245317604170e-10, -3.663665741651175e-12,
  2.832525471192353e-14,  8.873625757437256e-17, -1.759247227945205e-18,  8.317537488248114e-22,  9.246828637046964e-23, -4.056254125688889e-25,  1.209378986809798e+00,
 -5.884410937338701e-03, -3.505793815806456e-06,  1.452407325988462e-07,  4.748189309738723e-12, -6.517223669690721e-12,  8.441239569081284e-15,  3.425220342821878e-16,
 -1.065497256544089e-18, -1.934985400398703e-20,  9.802879265673718e-23,  1.040028880345859e-24,  1.362700407499284e+00, -5.745795183622627e-03, -1.261792238343766e-05,
  1.404993317844236e-07,  6.627502686367638e-10, -6.617621133539866e-12, -4.243761162954048e-14,  3.861157569504562e-16,  2.976040923269144e-18, -2.574594015333341e-20,
 -2.289910643530124e-22,  1.768619022136420e-24,  1.517539765573826e+00, -5.241394791839777e-03, -2.186968058717308e-05,  8.351915729376937e-08,  1.304571646248046e-09,
 -5.180488948689937e-13, -8.663926947734387e-14, -2.478000526376094e-16,  5.681767417538956e-18,  3.777727662001368e-20, -3.456335997956091e-22, -4.384649496236633e-24,
  1.667885233418696e+00, -4.308734415781651e-03, -2.824926861253179e-05, -2.964323285485056e-08,  1.290613568554000e-09,  1.021157013754897e-11, -2.729654855364663e-14,
 -9.964254610719641e-16, -4.467176747821768e-18,  5.746069930684012e-20,  8.051972476694409e-22,  1.090484821573191e-25,  1.804533999133845e+00, -2.977967122677208e-03,
 -2.758348866670847e-05, -1.488470197630202e-07,  1.138041791531845e-10,  1.158222385481022e-11,  1.118875405621185e-13,  1.904850154432457e-16, -8.293620065589136e-18,
 -1.108211246895142e-19, -4.143862750329312e-22,  6.744004517591815e-24,  1.914613494580232e+00, -1.482222336470977e-03, -1.770661761590051e-05, -1.650574664281084e-07,
 -1.147109574017081e-09, -3.987651922916913e-12,  3.654356783448046e-14,  8.917182912309190e-16,  9.924954612143116e-18,  6.290448681834479e-20, -5.225162833777831e-23,
 -7.565341017885038e-24,  1.983064912020714e+00, -3.191529946120976e-04, -4.438279964495804e-06, -5.368845119913479e-08, -5.920381610909386e-10, -6.043463816365166e-12,
 -5.713010957546557e-14, -4.937647766931894e-16, -3.766235550363320e-18, -2.290367815950849e-20, -6.418835716557087e-23,  1.014740965181458e-24,  1.204760399460425e-03,
 -9.411130668032520e-06,  5.509881765991007e-08, -2.867699491529998e-10,  1.396661501182848e-12, -6.542553018341759e-15,  2.958036066265132e-17, -1.329863763190967e-19,
  5.626188804812932e-22, -2.662600506965822e-24,  8.088859912651129e-27, -7.937837206380913e-29,  1.084663598437909e-02, -8.456960590187770e-05,  4.927615521886992e-07,
 -2.542090650891313e-09,  1.220680286828491e-11, -5.601243361721442e-14,  2.459516031776788e-16, -1.065133008052632e-18,  4.259079247661063e-21, -1.930482056882127e-23,
  4.678755471793942e-26, -5.761803492589210e-28,  3.015053077329748e-02, -2.341797431489723e-04,  1.351244562227960e-06, -6.844755384461955e-09,  3.189927480356613e-11,
 -1.399092285722585e-13,  5.743666920771298e-16, -2.267720632151779e-18,  7.737176341014418e-21, -3.082371501073933e-23,  8.600116495472603e-27, -9.950083519379567e-28,
  5.915631641039230e-02, -4.567767744674898e-04,  2.596083128600213e-06, -1.277494801471318e-08,  5.666596508115128e-11, -2.294818108712899e-13,  8.247503659137140e-16,
 -2.614163101609161e-18,  4.932802747878879e-21, -7.752958840966859e-24, -2.356040710159861e-25, -8.721546568994270e-28,  9.792266683868328e-02, -7.500308397198093e-04,
  4.173595539300046e-06, -1.969403552443398e-08,  8.093432698042022e-11, -2.851974984373586e-13,  7.601750088690919e-16, -9.060960538736972e-19, -9.040230067867781e-21,
  6.249241113349511e-23, -6.671294825524268e-25, -8.025105176215837e-28,  1.465254144924855e-01, -1.110573536320006e-03,  6.008407278209445e-06, -2.673627998346910e-08,
  9.759784085957737e-11, -2.617939407505597e-13,  1.591159905196049e-16,  3.549025500590549e-18, -3.354338701415422e-20,  1.486994016861719e-22, -9.882688560150864e-25,
 -2.842761607714144e-27,  2.050548245730708e-01, -1.533741084549023e-03,  8.000008865848642e-06, -3.280281767854711e-08,  9.844241730943321e-11, -1.162907890363977e-13,
 -1.095837032671978e-15,  1.022482934618037e-17, -5.821595523247121e-20,  1.613017712246322e-22, -6.579088116400845e-25, -9.370845588227297e-27,  2.736111906603845e-01,
 -2.013208156103117e-03,  1.001827203829865e-05, -3.656462213072737e-08,  7.490109559760947e-11,  1.799175324396958e-13, -2.902739043780105e-15,  1.666458105633465e-17,
 -6.117744445778442e-20, -2.712479742162497e-23,  7.479727684640078e-25, -1.977862186426484e-26,  3.522977897466961e-01, -2.540474381658168e-03,  1.189792560790405e-05,
 -3.648675805845492e-08,  1.934274681483020e-11,  6.236462344278199e-13, -4.808389490991226e-15,  1.808637371631695e-17, -1.348598592904800e-20, -4.981926165894425e-22,
  2.770911674126421e-24, -2.605663990392291e-26,  4.412096448477036e-01, -3.104149218912529e-03,  1.343221632658420e-05, -3.089610349999777e-08, -7.280123705407897e-11,
  1.156413347865126e-12, -5.894075854364405e-15,  7.934583585794087e-18,  1.045838865642724e-19, -1.123202142753043e-21,  3.154452409786500e-24, -1.221888488855373e-26,
  5.404155695318184e-01, -3.688959365744863e-03,  1.436652157187456e-05, -1.813182535586910e-08, -1.996606432299568e-10,  1.636197316693124e-12, -4.765496165342462e-15,
 -1.953096594883922e-17,  2.701028840774725e-19, -1.359360578488658e-21, -2.144354659016581e-24,  3.187841471249345e-26,  6.499293328713459e-01, -4.274377117585521e-03,
  1.439389488243307e-05,  3.153472482334049e-09, -3.478473790038357e-10,  1.811985109098273e-12,  1.681964597693351e-16, -6.311055531182855e-17,  3.699223216034172e-19,
 -2.165997155210580e-22, -1.561593536985843e-23,  7.184638455492654e-26,  7.696629956883051e-01, -4.832744908881872e-03,  1.315714160193876e-05,  3.342946505469707e-08,
 -4.854934302437372e-10,  1.323737522137182e-12,  9.790231318777677e-15, -1.041078751807771e-16,  1.731335953522296e-19,  3.070358208332878e-21, -2.879696277738709e-23,
 -1.324727682048492e-26,  8.993506717972081e-01, -5.326775800638973e-03,  1.026748834610452e-05,  7.129054221370866e-08, -5.545127357122733e-10, -2.175204089216070e-13,
  2.229318108684419e-14, -9.502486763156124e-17, -5.666647248905303e-19,  6.886768065533816e-21, -1.113800602710882e-23, -3.447220439167038e-25,  1.038422705193445e+00,
 -5.706417846515015e-03,  5.360881270260026e-06,  1.118222481576343e-07, -4.672312010663471e-10, -2.960353425624953e-12,  3.003109823859287e-14,  3.359482528861003e-17,
 -1.667562025807524e-18,  4.116127291145882e-21,  7.048531975558135e-23, -5.793213051206404e-25,  1.185796277527313e+00, -5.905494259979069e-03, -1.766706184876821e-06,
  1.442881387490135e-07, -1.228160847250267e-10, -6.204013882965579e-12,  1.745566674865019e-14,  2.981188051456101e-16, -1.681724343586878e-18, -1.465154787222863e-20,
  1.332628652291718e-22,  5.440694634777806e-25,  1.339526258760510e+00, -5.839824726011196e-03, -1.087284277806890e-05,  1.499930359302897e-07,  5.211402944774906e-10,
 -7.496543146818592e-12, -3.044409584692659e-14,  4.649173588421830e-16,  1.905095379649867e-18, -3.313240098473937e-20, -1.357323157094197e-22,  2.397559743814189e-24,
  1.496231117953322e+00, -5.411990005099397e-03, -2.074292522102331e-05,  1.041944638639907e-07,  1.272966369775752e-09, -2.658954750898432e-12, -9.084892296290698e-14,
 -4.725380729298455e-17,  6.748862752890193e-18,  2.037874985816429e-20, -5.153881761261435e-22, -3.164850827921164e-24,  1.650196570281641e+00, -4.535785150821674e-03,
 -2.847449072934090e-05, -7.404909168807764e-09,  1.485959341425944e-09,  9.207633264772381e-12, -5.684275132056907e-14, -1.100122798557231e-15, -1.828530180918989e-18,
  8.855720059449976e-20,  7.176653136562595e-22, -4.265373585399656e-24,  1.792169550564787e+00, -3.205730174686738e-03, -2.935060727095935e-05, -1.450258700652075e-07,
  3.725626871951852e-10,  1.429775366011733e-11,  1.128868908900796e-13, -1.412557809199872e-16, -1.249369037953369e-17, -1.196501707409965e-19,  1.985127531593218e-23,
  1.316188331823689e-23,  1.908388306948323e+00, -1.632115756363778e-03, -1.979988241474643e-05, -1.839924297562331e-07, -1.215875492213505e-09, -2.773040312091411e-12,
  6.629133981686947e-14,  1.244390214967888e-15,  1.205546309121061e-17,  5.233979743123857e-20, -5.256591229889502e-22, -1.438701983346650e-23,  1.981712967147416e+00,
 -3.574070088035471e-04, -5.143620501290849e-06, -6.420746921791654e-08, -7.278121949336224e-10, -7.594887107003659e-12, -7.276966176840865e-14, -6.278608463884944e-16,
 -4.622451944725195e-18, -2.414803130616496e-20,  1.473946948469721e-23,  2.780556850227052e-24,  1.167976186869648e-03, -8.983734892600723e-06,  5.178746126307418e-08,
 -2.654328313689927e-10,  1.272618260225798e-12, -5.875359864933879e-15,  2.609478978770672e-17, -1.164608737784109e-19,  4.717071927899801e-22, -2.413504383193743e-24,
  4.229855463467757e-27, -9.799742755201069e-29,  1.051605312444524e-02, -8.074629668967314e-05,  4.633923610897985e-07, -2.355432944581687e-09,  1.114324377064546e-11,
 -5.045270952343742e-14,  2.179337425779313e-16, -9.396533589036437e-19,  3.591229660758224e-21, -1.799161898460531e-23,  1.741890941686856e-26, -7.752001591530449e-28,
  2.923492348723278e-02, -2.236898662080318e-04,  1.272079856224719e-06, -6.356024588486331e-09,  2.923393529048131e-11, -1.268594297241232e-13,  5.141698772749235e-16,
 -2.037915272929391e-18,  6.621531755661839e-21, -3.153824078047695e-23, -4.931565094127518e-26, -1.678586531405976e-27,  5.736979705503249e-02, -4.366062357482256e-04,
  2.448075643586192e-06, -1.190395875856019e-08,  5.226843087536126e-11, -2.105486491040575e-13,  7.537082140030397e-16, -2.462697499000493e-18,  4.471051613346601e-21,
 -1.836459035335406e-23, -3.062291959401349e-25, -2.414238856187995e-27,  9.498785477703639e-02, -7.175658020787654e-04,  3.944851764096501e-06, -1.844373581364576e-08,
  7.541060318705517e-11, -2.672885438064731e-13,  7.310551881753789e-16, -1.164647751291979e-18, -7.285603851444187e-21,  3.440159014377121e-23, -7.562419975031505e-25,
 -3.383010716063188e-27,  1.421772598612062e-01, -1.063763469340493e-03,  5.696769286432212e-06, -2.521636240784624e-08,  9.240759218754215e-11, -2.568993107055270e-13,
  2.442099708404598e-16,  2.553363227419116e-18, -2.893973841594708e-20,  1.057856173839509e-22, -1.181889963837400e-24, -6.194304078532037e-27,  1.990454049203027e-01,
 -1.471288958111109e-03,  7.615744402028623e-06, -3.124768087948685e-08,  9.587572465447646e-11, -1.393606809778581e-13, -8.347907210707622e-16,  8.448892323586199e-18,
 -5.299006982262504e-20,  1.258363107121661e-22, -1.141887139875755e-24, -1.300089107629911e-26,  2.657159005698414e-01, -1.934796458906920e-03,  9.586793986185416e-06,
 -3.534104831070577e-08,  7.783943764583700e-11,  1.156291379431226e-13, -2.463654045707351e-15,  1.469529169473556e-17, -6.183441406165371e-20, -1.567324733682193e-23,
 -2.070086188474659e-25, -2.410626941056663e-26,  3.423234946633014e-01, -2.447036171898452e-03,  1.146233317867619e-05, -3.608358975204866e-08,  3.070235817188492e-11,
  5.142572779653152e-13, -4.310570063262024e-15,  1.738688520834445e-17, -2.972170818542694e-20, -4.124714693885926e-22,  1.456092835548260e-24, -3.415333085627448e-26,
  4.290055896287768e-01, -2.998192594989640e-03,  1.305521272380583e-05, -3.188350116125269e-08, -5.106775367837220e-11,  1.017963199684807e-12, -5.630966643087827e-15,
  1.065730426732448e-17,  6.624442644795481e-20, -1.012839010134350e-21,  2.234663759784306e-24, -2.992156573304523e-26,  5.258881449526139e-01, -3.574949382689042e-03,
  1.413083153961344e-05, -2.107098723128047e-08, -1.681198583690583e-10,  1.516193945329960e-12, -5.198818560702884e-15, -1.168497574867194e-17,  2.198836327741655e-19,
 -1.425532469087225e-21, -1.381100597158659e-24,  2.144595885328921e-27,  6.330622364391298e-01, -4.159166453577229e-03,  1.439953824048704e-05, -2.122525516325403e-09,
 -3.117035770998611e-10,  1.796142948093118e-12, -1.435171585548347e-15, -5.151254038035339e-17,  3.515861143880445e-19, -7.844871988465951e-22, -1.296535187850920e-23,
  4.627044978151037e-26,  7.505448872795869e-01, -4.726013125803391e-03,  1.351260015575021e-05,  2.588515602216960e-08, -4.569015010331663e-10,  1.524443044902675e-12,
  6.967802511800883e-15, -9.702199660082683e-17,  2.628704207356752e-19,  1.915007887324563e-21, -2.881916393237629e-23,  7.584346758479339e-27,  8.782130533528670e-01,
 -5.241364921702078e-03,  1.106968967876756e-05,  6.241166688126211e-08, -5.537379280437463e-10,  2.837638187682809e-13,  1.941511172660534e-14, -1.093057105006652e-16,
 -3.302179265987561e-19,  6.159562390492729e-21, -2.469666746458552e-23, -2.727846477316037e-25,  1.015691121371151e+00, -5.658294659487932e-03,  6.656067687855601e-06,
  1.039122662168253e-07, -5.191851285599845e-10, -2.234194010775968e-12,  3.025054257356351e-14, -1.690402707842832e-17, -1.475079407788179e-18,  6.393466620230248e-21,
  4.272744722029555e-23, -6.693200726547324e-25,  1.162156939695677e+00, -5.912744753364497e-03, -5.105230203127685e-08,  1.413559241739096e-07, -2.420642279594593e-10,
 -5.691440683549462e-12,  2.497784523173637e-14,  2.369302988908378e-16, -2.108931652960888e-18, -9.004020573636123e-21,  1.450830621572998e-22, -7.706714272570288e-27,
  1.316004578639981e+00, -5.919477682591804e-03, -9.027960832657361e-06,  1.570966701475928e-07,  3.649880870270586e-10, -8.065234754619159e-12, -1.675848787873896e-14,
  5.059599991490108e-16,  6.407966303188219e-19, -3.637468340636797e-20, -2.543474646985230e-23,  2.527237164518845e-24,  1.474259672429072e+00, -5.572590637457273e-03,
 -1.937252569534989e-05,  1.240180224576956e-07,  1.198004822864904e-09, -4.830272817275940e-12, -8.906803490892601e-14,  1.762294125946742e-16,  7.082885685008043e-18,
 -2.459147356992617e-21, -6.112968486961719e-22, -1.084397270347275e-24,  1.631597863443633e+00, -4.763518869667348e-03, -2.841488942507213e-05,  1.775898613026388e-08,
  1.653953684189472e-09,  7.470287175900255e-12, -8.794914916548429e-14, -1.102539813315035e-15,  1.817879624147322e-18,  1.120659993840583e-19,  4.220364366923723e-22,
 -9.147758395263473e-24,  1.778866171092805e+00, -3.447372258757105e-03, -3.104524408376866e-05, -1.366322302035835e-07,  6.850399914055782e-10,  1.691045559908322e-11,
  1.026952476533643e-13, -6.085675004834966e-16, -1.662920730119609e-17, -1.053045590913384e-19,  7.444467434461907e-22,  1.956913666513805e-23,  1.901528590709256e+00,
 -1.799680761772369e-03, -2.212603150870711e-05, -2.037910286882544e-07, -1.252372054491854e-09, -7.187779600842846e-13,  1.067815355954287e-13,  1.654865666986641e-15,
  1.338553014120332e-17,  1.608086490313585e-20, -1.354786367979392e-21, -2.362989190860229e-23,  1.980195865902209e+00, -4.018480879183971e-04, -5.989317185261246e-06,
 -7.716882606077917e-08, -8.986884008564315e-10, -9.569827401966518e-12, -9.254887771900628e-14, -7.892862864043255e-16, -5.444029005824673e-18, -2.024107136269790e-20,
  2.060899327420804e-22,  6.301125574730963e-24,  1.132850150967377e-03, -8.581838541090309e-06,  4.872066816877809e-08, -2.459780482164209e-10,  1.161118157353290e-12,
 -5.286589402694671e-15,  2.303233005501838e-17, -1.027326435002177e-19,  3.867599567246522e-22, -2.337968732579113e-24, -6.356788367532472e-28, -1.225720027928751e-28,
  1.020030738273131e-02, -7.714926250526229e-05,  4.361645150241382e-07, -2.184938011674589e-09,  1.018442712980178e-11, -4.552563274291919e-14,  1.931354992816540e-16,
 -8.350338715210262e-19,  2.947175078090185e-21, -1.805153690242931e-23, -2.223803356424755e-26, -1.021067776436839e-27,  2.836004521920819e-02, -2.138105534729860e-04,
  1.198532411577798e-06, -5.907927638856577e-09,  2.681564470421380e-11, -1.151812152833311e-13,  4.599003894082523e-16, -1.844731809823888e-18,  5.430664456715407e-21,
 -3.522770289558083e-23, -1.409899289444438e-25, -2.467010993823989e-27,  5.566165627851231e-02, -4.175791173705249e-04,  2.310110066024275e-06, -1.110039197560920e-08,
  4.823284310337304e-11, -1.932716521297125e-13,  6.866381135994612e-16, -2.332805092795062e-18,  3.559067182744325e-21, -3.326190414008873e-23, -4.513522449081413e-25,
 -4.135709127916206e-27,  9.217933590278289e-02, -6.868721757429951e-04,  3.730592998368838e-06, -1.727899058257316e-08,  7.023751205137091e-11, -2.501599582583967e-13,
  6.953237119250469e-16, -1.384154086648867e-18, -6.635578939088004e-21,  2.897683202032488e-25, -9.709048929134599e-25, -6.301581328680811e-27,  1.380114728213178e-01,
 -1.019374953884360e-03,  5.402875606363474e-06, -2.377860390569364e-08,  8.733348026622791e-11, -2.502818093490966e-13,  3.032431551476493e-16,  1.678494238414126e-18,
 -2.605916223745844e-20,  5.184297000236544e-23, -1.545087503867388e-24, -1.022918690575072e-26,  1.932797627031049e-01, -1.411837031895069e-03,  7.249881008420389e-06,
 -2.973697852465702e-08,  9.290634959211330e-11, -1.567446011874719e-13, -6.213500119096575e-16,  6.815671677410789e-18, -4.943308923209671e-20,  6.727569630623802e-23,
 -1.821923441916134e-24, -1.782375243807311e-26,  2.581274476149212e-01, -1.859777149446905e-03,  9.170240273780966e-06, -3.408019338235731e-08,  7.959291420223373e-11,
  6.121483383620688e-14, -2.079996441031842e-15,  1.270378545518722e-17, -6.281926162253788e-20, -4.692378751950490e-23, -1.398950351164625e-24, -2.994910591925141e-26,
  3.327160177290118e-01, -2.357060421770485e-03,  1.103259917722798e-05, -3.551552842297920e-08,  3.999178792973746e-11,  4.165247217480617e-13, -3.839222603673198e-15,
  1.620634083998189e-17, -4.390999002794728e-20, -3.870830299637575e-22, -2.544650562398812e-25, -4.330736128932963e-26,  4.172192618768313e-01, -2.895293691565692e-03,
  1.266835656268813e-05, -3.254494854748503e-08, -3.203465388216437e-11,  8.866072502279281e-13, -5.308259633462866e-15,  1.220808009141433e-17,  3.102425808365042e-20,
 -9.552095094351999e-22,  5.169904494594649e-25, -4.754958537614760e-26,  5.118127777558005e-01, -3.462957606286609e-03,  1.386281864378199e-05, -2.352519074060667e-08,
 -1.390662908826624e-10,  1.388243441420872e-12, -5.435282678692008e-15, -5.480840168223402e-18,  1.675082573934984e-19, -1.488150967093146e-21, -1.974150442957853e-24,
 -2.839149104039568e-26,  6.166556858118507e-01, -4.044154096615639e-03,  1.434532249738861e-05, -6.824739237189606e-09, -2.762355428005888e-10,  1.745632365866605e-12,
 -2.724951233980095e-15, -4.081035301164446e-17,  3.144094067404305e-19, -1.272424322679333e-21, -1.168675521522069e-23,  1.159185667325967e-26,  7.318588313243853e-01,
 -4.616791742605550e-03,  1.378039256737898e-05,  1.882682309702567e-08, -4.249552594963691e-10,  1.660077217691094e-12,  4.377734458920977e-15, -8.772887513234760e-17,
  3.111479761283175e-19,  7.693764020749757e-22, -2.848230300766348e-23,  5.292966888821036e-27,  8.574292401217058e-01, -5.149961670416808e-03,  1.176573724441093e-05,
  5.362152002882128e-08, -5.436562584944615e-10,  7.120032286868706e-13,  1.623846013553196e-14, -1.165377632632282e-16, -1.289741313351802e-19,  4.950582685224337e-21,
 -3.530043568721807e-23, -2.104405811936362e-25,  9.931721336254303e-01, -5.600202688432861e-03,  7.851825655799784e-06,  9.528702576455875e-08, -5.566738423842432e-10,
 -1.518971603530893e-12,  2.915301030343599e-14, -6.015235558159597e-17, -1.221344949880434e-18,  7.504000164300881e-21,  1.269698308122493e-23, -6.831732074825392e-25,
  1.138515782816853e+00, -5.906442357639024e-03,  1.618335602914066e-06,  1.366069520612984e-07, -3.494015382692270e-10, -5.020249371553109e-12,  3.062629748146570e-14,
  1.653681120263646e-16, -2.330127434134169e-18, -3.363289152537345e-21,  1.332562796827126e-22, -5.135285154285258e-25,  1.292194283726367e+00, -5.984073829431987e-03,
 -7.113142549813739e-06,  1.616290318156525e-07,  2.008157044125305e-10, -8.296330454393721e-12, -2.501549968151885e-15,  5.055307639389169e-16, -6.608653181672380e-19,
 -3.524751463936183e-20,  7.895332385798904e-23,  2.139885163664246e-24,  1.451669224253647e+00, -5.721300207037344e-03, -1.777285947863998e-05,  1.422992470262751e-07,
  1.080554124659437e-09, -6.883332906651851e-12, -8.100776425852762e-14,  3.966954704524998e-16,  6.549241110868319e-18, -2.714685142667689e-20, -6.050441695235052e-22,
  1.383132434075532e-24,  1.612091148504417e+00, -4.989525120061390e-03, -2.803847143388218e-05,  4.529247613935067e-08,  1.779801220071816e-09,  4.999450958378534e-12,
 -1.173810726718504e-13, -9.774254209785682e-16,  6.047286414245908e-18,  1.196201493750474e-19, -7.290188011633793e-23, -1.304202158904822e-23,  1.764569872102342e+00,
 -3.702079686978665e-03, -3.260749084912480e-05, -1.228389207355200e-07,  1.046190988233803e-09,  1.910727761792993e-11,  7.768672638079407e-14, -1.193839645413555e-15,
 -1.966382439682877e-17, -5.695616580187788e-20,  1.698301917645478e-21,  2.298178478271703e-23,  1.893959881927708e+00, -1.986811734543484e-03, -2.469172976905142e-05,
 -2.237881150228711e-07, -1.237115924812507e-09,  2.448523154679619e-12,  1.591142945230314e-13,  2.079793409672747e-15,  1.271117784372455e-17, -6.189276221987341e-20,
 -2.616738420917190e-21, -3.355322311332037e-23,  1.978486414335600e+00, -4.537265412793824e-04, -7.008345597980478e-06, -9.320757271413295e-08, -1.114191120635311e-09,
 -1.207648754492898e-11, -1.171824188471215e-13, -9.729257240777614e-16, -5.942742749113264e-18, -4.777905336592243e-21,  6.155187227463636e-22,  1.298913194462159e-23,
  1.099284068677097e-03, -8.203572163158502e-06,  4.587700445895045e-08, -2.282169316983199e-10,  1.060688027133419e-12, -4.767011337440832e-15,  2.031633404358430e-17,
 -9.171869592752132e-20,  3.008021941113176e-22, -2.474240520495097e-24, -6.153340562296288e-27, -1.176548189122484e-28,  9.898526731262323e-03, -7.376212084688337e-05,
  4.108937114989554e-07, -2.029027195704416e-09,  9.318425637157013e-12, -4.116090398788079e-14,  1.709754441120013e-16, -7.513840747647409e-19,  2.270124999580224e-21,
 -1.987237818047161e-23, -6.871901444029504e-26, -9.954759353636710e-28,  2.752354059258874e-02, -2.044987521166483e-04,  1.130137457652000e-06, -5.496723831908132e-09,
  2.461830899674029e-11, -1.047450147023284e-13,  4.104811494401065e-16, -1.692551170767996e-18,  4.033567718620272e-21, -4.315506411061934e-23, -2.557307791439773e-25,
 -2.476581463229272e-27,  5.402747608158623e-02, -3.996182243889195e-04,  2.181410996166798e-06, -1.035871656642682e-08,  4.452697373957056e-11, -1.775645305324049e-13,
  6.227070144115922e-16, -2.241933955523815e-18,  1.989995625455518e-21, -5.522876292310436e-23, -6.486948118999251e-25, -4.292841537162647e-27,  8.949024996172324e-02,
 -6.578380931202658e-04,  3.529825706960750e-06, -1.619432289240187e-08,  6.539792632959127e-11, -2.339615316380893e-13,  6.535394722634618e-16, -1.604397520230118e-18,
 -7.395882193069842e-21, -4.456618665396352e-23, -1.275195929026845e-24, -6.626198218367239e-27,  1.340186448794018e-01, -9.772699451010571e-04,  5.125752508124955e-06,
 -2.242090358017607e-08,  8.240394795965291e-11, -2.425329541635168e-13,  3.387566842810518e-16,  8.616076946207201e-19, -2.542033462446787e-20, -1.959686035661812e-23,
 -2.030017079512711e-24, -1.046025522909252e-26,  1.877461880169598e-01, -1.355240331476513e-03,  6.901850369265747e-06, -2.827630461509929e-08,  8.963687524275688e-11,
 -1.695439898847525e-13, -4.524025677236740e-16,  5.256911985179479e-18, -4.851925407919410e-20, -2.196456732700792e-23, -2.639290263289302e-24, -1.743353617258309e-26,
  2.508325034316851e-01, -1.788029351257779e-03,  8.768950809402079e-06, -3.279950786809373e-08,  8.034564171316210e-11,  1.533422470002376e-14, -1.752779662371858e-15,
  1.065310509569961e-17, -6.584132329501823e-20, -1.299456239889257e-22, -2.745769128224694e-24, -2.869234863058030e-26,  3.234616146001148e-01, -2.270492894605167e-03,
  1.061051115155357e-05, -3.481387094547383e-08,  4.743674913306454e-11,  3.296568909014561e-13, -3.407247711753965e-15,  1.457247541146335e-17, -5.850051225089403e-20,
 -4.365797666450268e-22, -2.217696677542556e-24, -4.243848593056368e-26,  4.058382968189976e-01, -2.795516406765090e-03,  1.227530491357051e-05, -3.292244998723766e-08,
 -1.554835813501923e-11,  7.633913808580890e-13, -4.957700423539563e-15,  1.265034632833450e-17, -3.525222019191543e-21, -9.793494113645162e-22, -1.753384846951651e-24,
 -5.094069875484394e-26,  4.981809138367713e-01, -3.353220028457714e-03,  1.356805915527746e-05, -2.553526197273049e-08, -1.126154023121862e-10,  1.256510689609665e-12,
 -5.521881244560109e-15, -9.958441176068739e-19,  1.121523093261868e-19, -1.598294937282801e-21, -3.629520616858832e-24, -4.080722492679805e-26,  6.007079732976272e-01,
 -3.929791611759915e-03,  1.423804660803443e-05, -1.096912871380478e-08, -2.420637572846378e-10,  1.667612625213618e-12, -3.734312150200808e-15, -3.157191680173751e-17,
  2.602331647264061e-19, -1.737762826853243e-21, -1.171743661077793e-23, -6.178071878290855e-27,  7.136134216593341e-01, -4.505757946046209e-03,  1.396663064943010e-05,
  1.229804517944985e-08, -3.908961332252996e-10,  1.736808794386798e-12,  2.063318622704846e-15, -7.754849387644310e-17,  3.183829941382612e-19, -3.661527393838695e-22,
 -2.826172244676593e-23,  1.110516259652076e-26,  8.370215133008713e-01, -5.053408599720398e-03,  1.235753995015221e-05,  4.505699954134102e-08, -5.257850194690244e-10,
  1.062257717930596e-12,  1.294237252525309e-14, -1.181029116257705e-16,  2.177149394468677e-20,  3.372754343646835e-21, -4.304614330450899e-23, -1.341172108227438e-25,
  9.709039773966588e-01, -5.532967786241992e-03,  8.940948148231536e-06,  8.617457546869212e-08, -5.802147346760898e-10, -8.436752568549261e-13,  2.696255522114905e-14,
 -9.487312181064047e-17, -9.491814969435006e-19,  7.425630185502057e-21, -1.603920415910476e-23, -6.025141751909291e-25,  1.114926144989167e+00, -5.887040940451845e-03,
  3.220896415093701e-06,  1.302546458758598e-07, -4.421250495747227e-10, -4.238156615390752e-12,  3.420154757038139e-14,  8.984401470101649e-17, -2.361801259113736e-18,
  1.397864109109913e-21,  1.023041047270813e-22, -8.534589774804783e-25,  1.268156522423812e+00, -6.033178762379812e-03, -5.159788990951765e-06,  1.635161630852519e-07,
  3.541803489401679e-11, -8.190045340211742e-12,  1.117183944657297e-14,  4.648624786066087e-16, -1.852043139625681e-18, -3.040821655920474e-20,  1.575880212515147e-22,
  1.401453175309803e-24,  1.428510872715550e+00, -5.856369936816359e-03, -1.596640917885952e-05,  1.583853350639690e-07,  9.244632723106630e-10, -8.671613789954334e-12,
 -6.714555284051393e-14,  5.861251213113500e-16,  5.157412420697643e-18, -4.943156735406023e-20, -4.926233778801815e-22,  3.651534000956385e-24,  1.591688566865072e+00,
 -5.211168186456206e-03, -2.732132135045254e-05,  7.440728175241147e-08,  1.849531712605068e-09,  1.879687609417749e-12, -1.414031334928254e-13, -7.167365979115408e-16,
  1.015696519626208e-17,  1.046304221827615e-19, -6.852203166455350e-22, -1.420417871831543e-23,  1.749230938525201e+00, -3.968521678484667e-03, -3.396821878772014e-05,
 -1.029540608906173e-07,  1.443900073968873e-09,  2.049814754121832e-11,  3.524646194109037e-14, -1.840812056767980e-15, -2.025027942242944e-17,  3.080805343029524e-20,
  2.665057215293011e-21,  1.951841232798028e-23,  1.885600091092597e+00, -2.195418726434107e-03, -2.749360613674479e-05, -2.429621285452451e-07, -1.145015118204526e-09,
  7.009185199977946e-12,  2.225466965007512e-13,  2.427670433926253e-15,  8.222203833693069e-18, -1.982962815202610e-19, -4.244545024487777e-21, -3.903518803668704e-23,
  1.976551837506209e+00, -5.145897261247095e-04, -8.242290517496309e-06, -1.131293235169495e-07, -1.386162262951436e-09, -1.523721579735670e-11, -1.470713425194053e-13,
 -1.159800521666522e-15, -5.506643900153164e-18,  3.434982831336446e-20,  1.428806476558015e-21,  2.511549704388751e-23,  1.067186865571730e-03, -7.847229111061521e-06,
  4.323716457687154e-08, -2.119830072441332e-10,  9.700209677574654e-13, -4.309233332451311e-15,  1.786918789697227e-17, -8.357456013142496e-20,  2.062572568596388e-22,
 -2.798750601162536e-24, -9.100732893436861e-27,  1.905774114923687e-29,  9.609901838762919e-03, -7.056989099952596e-05,  3.874134908069497e-07, -1.886302192327456e-09,
  8.534577068514116e-12, -3.730243154264610e-14,  1.508419298371623e-16, -6.907916755786565e-19,  1.496500716303999e-21, -2.327461217591596e-23, -9.272942925930955e-26,
  2.240951861502515e-28,  2.672321928023931e-02, -1.957149548331399e-04,  1.066472688058915e-06, -5.119070692688855e-09,  2.261815448757140e-11, -9.544908980034462e-14,
  3.646480281422433e-16, -1.590491979901894e-18,  2.274485453706961e-21, -5.496178147443072e-23, -3.108596855205979e-25,  8.678233779413448e-28,  5.246313524654563e-02,
 -3.826523082059534e-04,  2.061266366512395e-06, -9.673904540633986e-09,  4.112007682047551e-11, -1.633676805464542e-13,  5.604879024801815e-16, -2.215386603771194e-18,
 -5.014792547958093e-22, -8.379912641047166e-23, -7.336834083528427e-25,  2.208837879995007e-27,  8.691416868283823e-02, -6.303593768900564e-04,  3.341620336178973e-06,
 -1.518455347827234e-08,  6.087176056866509e-11, -2.188442523514499e-13,  6.049887385216621e-16, -1.877057074198663e-18, -9.973218494893252e-21, -9.949191036866494e-23,
 -1.394352573507383e-24,  4.189480446946783e-27,  1.301899043111923e-01, -9.373180802802445e-04,  4.864453821726938e-06, -2.114079741202197e-08,  7.763606467993995e-11,
 -2.342064455097441e-13,  3.512710610946469e-16,  2.044270155581233e-20, -2.767438419007601e-20, -1.070428072712019e-22, -2.224527820638648e-24,  6.132927643326574e-27,
  1.824335413740648e-01, -1.301358671217877e-03,  6.571026173035011e-06, -2.686978470999156e-08,  8.614842891463415e-11, -1.788122672815246e-13, -3.272174717744197e-16,
  3.669986419663341e-18, -5.135938147037671e-20, -1.384869505851099e-22, -3.014982691610957e-24,  6.769574788905519e-27,  2.438182273423500e-01, -1.719430258201317e-03,
  8.383072880097032e-06, -3.151371267847213e-08,  8.025456860309949e-11, -2.339626238890518e-14, -1.484856883518912e-15,  8.447976652165919e-18, -7.274996933548102e-20,
 -2.588352619849283e-22, -3.459390332563628e-24,  4.998585733244312e-27,  3.145467841867297e-01, -2.187266495517455e-03,  1.019750217893660e-05, -3.400644617632646e-08,
  5.324404048963305e-11,  2.525525415306143e-13, -3.027930748847733e-15,  1.242861648797941e-17, -7.619849302685890e-20, -5.545809954189128e-22, -3.368475898693509e-24,
  1.759101083831429e-27,  3.948501294714398e-01, -2.698897355260557e-03,  1.187922609591457e-05, -3.305542615862007e-08, -1.441893845517988e-12,  6.486111777724850e-13,
 -4.610490076769569e-15,  1.195596529547883e-17, -4.050950437975596e-20, -1.084981350141080e-21, -3.147172540132558e-24,  2.799924800617624e-27,  4.849831412042935e-01,
 -3.245930016084577e-03,  1.325163089576453e-05, -2.714327010814117e-08, -8.881083220875819e-11,  1.124002231450073e-12, -5.508388746672046e-15,  1.641317634139373e-18,
  5.164225569748277e-20, -1.769783653611485e-21, -4.514801316176276e-24,  2.006916325583881e-26,  5.852156922903534e-01, -3.816477096707912e-03,  1.408426301119366e-05,
 -1.458048476038731e-08, -2.096747386628279e-10,  1.568260927692743e-12, -4.511792077886053e-15, -2.433593484260759e-17,  1.892517241910111e-19, -2.201363442534227e-21,
 -1.096508235385792e-23,  6.445712264306857e-26,  6.958146440110734e-01, -4.393538264582494e-03,  1.407783420423149e-05,  6.323569241214414e-09, -3.558347708839797e-10,
  1.761403479309348e-12,  3.106906026467866e-17, -6.778744487477124e-17,  2.851222646335451e-19, -1.468207993657660e-21, -2.610427572972250e-23,  1.152146148421339e-25,
  8.170088242318014e-01, -4.952526838958614e-03,  1.284850127566773e-05,  3.683015571327295e-08, -5.017007142313321e-10,  1.333370871087213e-12,  9.661072891963731e-15,
 -1.158050750547488e-16,  1.111384662419747e-19,  1.575137530478289e-21, -4.546441803260313e-23,  5.761618579944515e-26,  9.489214864786062e-01, -5.457462698525144e-03,
  9.918896893798915e-06,  7.679034901277722e-08, -5.908491090221794e-10, -2.316421867351054e-13,  2.391989482476085e-14, -1.211421092305820e-16, -6.992683103190241e-19,
  6.315431994123267e-21, -3.745904812169179e-23, -3.222035775897548e-25,  1.091439237023240e+00, -5.855147952759860e-03,  4.738857413792334e-06,  1.225478413658723e-07,
 -5.185198874347685e-10, -3.395599290285267e-12,  3.567185121223867e-14,  1.578550816371222e-17, -2.247193950565252e-18,  4.709654281999713e-21,  6.340217675667670e-23,
 -8.318474596865965e-25,  1.243953675311889e+00, -6.066610997556681e-03, -3.199541368062588e-06,  1.627913049671222e-07, -1.246860583479861e-10, -7.773389662866986e-12,
  2.320300819350508e-14,  3.894053292598742e-16, -2.820502217321911e-18, -2.309753333398198e-20,  2.028280695127897e-22,  7.095305213971097e-25,  1.404842304641602e+00,
 -5.976260980875954e-03, -1.398302756641426e-05,  1.717076245185075e-07,  7.363343314801496e-10, -1.006929166623669e-11, -4.871618026768698e-14,  7.192344622061664e-16,
  3.066955123896713e-18, -6.537743888833994e-20, -2.922381128462283e-22,  5.361988157651910e-24,  1.570413120371133e+00, -5.425662506995627e-03, -2.625025257803933e-05,
  1.041100294032288e-07,  1.851766951645946e-09, -1.714822040351405e-12, -1.563998516274274e-13, -3.379325911904450e-16,  1.328406728227814e-17,  6.526789217437654e-20,
 -1.261156321933756e-21, -1.120728955813830e-23,  1.732806131601729e+00, -4.244785119382880e-03, -3.505142646362803e-05, -7.654481599160010e-08,  1.857775929460127e-09,
  2.065412364786126e-11, -2.504608901037890e-14, -2.448995363012911e-15, -1.704268417877017e-17,  1.514419752502922e-19,  3.270429162060885e-21,  6.324580361482034e-24,
  1.876359630244625e+00, -2.427328545850070e-03, -3.051344280374210e-05, -2.598471502179993e-07, -9.457931176893737e-10,  1.318788443574010e-11,  2.928789425884777e-13,
  2.540479046988687e-15, -2.378210596311167e-18, -4.012526648759633e-19, -5.838088947466678e-21, -2.983394723573864e-23,  1.974352439665114e+00, -5.863597566932321e-04,
 -9.743622759218381e-06, -1.379490358580615e-07, -1.728930563382248e-09, -1.917493695581667e-11, -1.817341773368487e-13, -1.302728092996278e-15, -2.927375622601170e-18,
  1.189729732066331e-19,  2.953515659366691e-21,  4.593210866527685e-23,  1.036473997090455e-03, -7.511249535637729e-06,  4.078371974400701e-08, -1.971296310996749e-10,
  8.879388098519333e-13, -3.907803515942863e-15,  1.560589285712165e-17, -7.864924902319448e-20,  1.000655451264796e-22, -3.039529044869833e-24,  5.115317679569486e-28,
  4.978394875375337e-28,  9.333680735745037e-03, -6.755885962739194e-05,  3.655731836924543e-07, -1.755527139538487e-09,  7.823188377513351e-12, -3.390971829067053e-14,
  1.320394893595921e-16, -6.569544745711275e-19,  6.024430924829016e-22, -2.582874415235575e-23, -3.911346309423384e-27,  4.535807446574055e-27,  2.595704247243488e-02,
 -1.874228786518714e-04,  1.007153685383043e-06, -4.771991591966741e-09,  2.079311543068988e-11, -8.722562754847320e-14,  3.208197816808104e-16, -1.551547340266279e-18,
  1.040720668751428e-22, -6.397042412777501e-23, -5.308192228086047e-26,  1.287270755123607e-26,  5.096478652741514e-02, -3.666155837063009e-04,  1.949021526444328e-06,
 -9.041412424890538e-09,  3.798219390094928e-11, -1.506651344276577e-13,  4.977409695090049e-16, -2.284892475726967e-18, -3.978166296304152e-21, -1.059630105680498e-22,
 -2.039893487002105e-25,  2.587854540166534e-26,  8.444506601712964e-02, -6.043390432580169e-04,  3.165107451232390e-06, -1.424485004867305e-08,  5.663561388118217e-11,
 -2.049949540391593e-13,  5.473522973610481e-16, -2.263437292396083e-18, -1.443939583657765e-20, -1.428228160516425e-22, -4.870038491947744e-25,  4.377752798354953e-26,
  1.265168858972558e-01, -8.993964439969644e-04,  4.618064218593260e-06, -1.993563700817325e-08,  7.303575274237854e-11, -2.258732907381568e-13,  3.387500892480732e-16,
 -9.427175290611892e-19, -3.295021340876671e-20, -1.772871003562630e-22, -8.535009475701902e-25,  6.640437571633204e-26,  1.773312337236838e-01, -1.250057053534186e-03,
  6.256739694703496e-06, -2.552041497160333e-08,  8.250099262095717e-11, -1.856234927618116e-13, -2.483739518485016e-16,  1.925062807120041e-18, -5.827962435057858e-20,
 -2.339702307217059e-22, -1.136692954497363e-24,  9.317853788976462e-26,  2.370722711889481e-01, -1.653856551888823e-03,  8.012591261069046e-06, -3.023524366365550e-08,
  7.944803825601418e-11, -5.646690021633425e-14, -1.282487421497259e-15,  5.946040465165299e-18, -8.427983060183290e-20, -3.664717403490042e-22, -1.067904997465840e-24,
  1.236150358455665e-25,  3.059583146698175e-01, -2.107303946329735e-03,  9.794690458231918e-06, -3.311796842541804e-08,  5.759507048449338e-11,  1.837633446515067e-13,
 -2.717243300789859e-15,  9.646860397998816e-18, -9.827136899133233e-20, -6.529455258048024e-22, -4.188317076692102e-25,  1.587465116114034e-25,  3.842420961531449e-01,
 -2.605449651762311e-03,  1.148283147249831e-05, -3.298062003577143e-08,  1.045001500423254e-11,  5.417932265362558e-13, -4.299903609481673e-15,  1.001305059063399e-17,
 -8.142590839598640e-20, -1.164125018537981e-21,  6.360412703296491e-25,  2.035662285724742e-25,  4.722093524362223e-01, -3.141242340525126e-03,  1.291810443772621e-05,
 -2.839156778588289e-08, -6.764836734868930e-11,  9.924791006045645e-13, -5.449098713874780e-15,  2.244274123507219e-18, -1.464332325108801e-20, -1.878330214268771e-21,
  8.819828466551513e-25,  2.693038247582488e-25,  5.701739465730576e-01, -3.704557542986625e-03,  1.389018380806813e-05, -1.769046253957350e-08, -1.794443285082866e-10,
  1.452409324977851e-12, -5.120881709583661e-15, -1.962341550101954e-17,  1.033558573055829e-19, -2.517005794676381e-21, -2.614284024616926e-24,  3.705258362163682e-25,
  6.784660837770859e-01, -4.280706172217192e-03,  1.412071783451553e-05,  9.114504965290668e-10, -3.207478907467454e-10,  1.740347840280783e-12, -1.748547953412191e-15,
 -5.969623227533459e-17,  2.154222556505808e-19, -2.325769928326389e-21, -1.397459952529175e-23,  5.041652575835088e-25,  7.974069021036795e-01, -4.848105340743059e-03,
  1.324321771511016e-05,  2.902778697945899e-08, -4.729750308943864e-10,  1.526768080002548e-12,  6.474403881842535e-15, -1.116807128158186e-16,  1.367716613379708e-19,
 -7.096933406658650e-23, -3.299053139790725e-23,  5.920550204640432e-25,  9.272559469991452e-01, -5.374586452927965e-03,  1.078360446627732e-05,  6.732969588144475e-08,
 -5.900281441468981e-10,  2.994022060136500e-13,  2.024664599929518e-14, -1.401884214596315e-16, -5.008081805230660e-19,  4.705550522100158e-21, -3.768895193793328e-23,
  4.187689778917572e-25,  1.068103575031249e+00, -5.811500693412553e-03,  6.157563246741300e-06,  1.137547496239626e-07, -5.778760997817734e-10, -2.542124262080750e-12,
  3.513570264629589e-14, -5.298633769805381e-17, -2.039571736841137e-18,  6.662853904235662e-21,  3.957217969490908e-23, -9.344781519541773e-26,  1.219648347610770e+00,
 -6.084438861819905e-03, -1.263038330574525e-06,  1.595863567795739e-07, -2.737577198456324e-10, -7.096587149681973e-12,  3.272925623798513e-14,  2.874662885580217e-16,
 -3.499238694437952e-18, -1.443213335381222e-20,  2.305607637467157e-22,  7.408076397377657e-25,  1.380726844152419e+00, -6.079698635833739e-03, -1.185868035918139e-05,
  1.818213793433369e-07,  5.249356698811371e-10, -1.098797059466772e-11, -2.757073250568503e-14,  7.779496910396515e-16,  5.635557430753189e-19, -7.193898638423408e-20,
 -2.578060528497357e-23,  6.759657211177466e-24,  1.548299084621846e+00, -5.630167509523204e-03, -2.482496166982659e-05,  1.332576549968521e-07,  1.779424241959134e-09,
 -5.532127576198099e-12, -1.596319426906290e-13,  1.141609022843166e-16,  1.462393438166618e-17,  6.906210358548891e-21, -1.599974155373493e-21, -3.391293162477627e-24,
  1.715261105258097e+00, -4.528334305129997e-03, -3.577815805285048e-05, -4.357275115943303e-08,  2.258999215492219e-09,  1.917447615750074e-11, -1.002520008507855e-13,
 -2.881683333572602e-15, -9.222039833380753e-18,  2.819012691476489e-19,  3.094377369622875e-21, -1.525801392767445e-23,  1.866142019107419e+00, -2.684143361562825e-03,
 -3.371239831660988e-05, -2.724640210096701e-07, -6.060898086900147e-10,  2.104696658684618e-11,  3.604414140877238e-13,  2.186093098710079e-15, -2.126776105162854e-17,
 -6.522518030650556e-19, -6.428547740053422e-21,  9.325084799201977e-24,  1.971839914196334e+00, -6.714313093001350e-04, -1.157844584383130e-05, -1.689294290451782e-07,
 -2.159034694623687e-09, -2.397997947826193e-11, -2.186902305295224e-13, -1.300616241769960e-15,  4.047213679800278e-18,  2.862870275430988e-19,  5.653229998736485e-21,
  7.905770033181344e-23,  1.007066889911149e-03, -7.194206291965705e-06,  3.850089103257048e-08, -1.835282521345471e-10,  8.133512230235753e-13, -3.559426028300433e-15,
  1.343244366565640e-17, -7.713578527387639e-20, -1.314286315868358e-24, -2.307107983765541e-24,  4.428312078657027e-26,  1.624350382137498e-27,  9.069163985632617e-03,
 -6.471646200837385e-05,  3.452360444047521e-07, -1.635615726865576e-09,  7.175201163326701e-12, -3.096017692034952e-14,  1.137775868164654e-16, -6.520551238759944e-19,
 -2.605007609382075e-22, -1.952339801622497e-23,  3.929271719275270e-25,  1.470011019897475e-26,  2.522311055852300e-02, -1.795891789761922e-04,  9.518296711875421e-07,
 -4.452854287581002e-09,  1.912207368800673e-11, -8.004900459122231e-14,  2.770822310864437e-16, -1.583979757890482e-18, -2.040262093710834e-21, -4.786968202469915e-23,
  1.064090598167309e-24,  4.126077212735996e-26,  4.952883567807707e-02, -3.514472930377443e-04,  1.844073471272988e-06, -8.457176745906227e-09,  3.508307761968283e-11,
 -1.395049723339753e-13,  4.314136448604243e-16, -2.471812888577839e-18, -7.546070966394695e-21, -7.771771152596694e-23,  2.023604545764268e-24,  8.202238736382803e-26,
  8.207729029768555e-02, -5.796868386296873e-04,  2.999473223655710e-06, -1.337078822039047e-08,  5.266165574926255e-11, -1.926759958071628e-13,  4.767354308743274e-16,
 -2.806477891145011e-18, -1.926779194024756e-20, -1.009487605123182e-22,  3.263132402288621e-24,  1.378355711997802e-25,  1.229917016369819e-01, -8.633893156109046e-04,
  4.385700331417741e-06, -1.880277415546520e-08,  6.859680776531128e-11, -2.181851462094063e-13,  2.966283322913432e-16, -2.098171192261708e-18, -3.893914221641448e-20,
 -1.182547588213200e-22,  4.843463338697115e-24,  2.095205630743394e-25,  1.724292050989577e-01, -1.201205959801899e-03,  5.958291290426572e-06, -2.423040829383707e-08,
  7.873215654455973e-11, -1.911562338061766e-13, -2.218504041230114e-16, -7.262604962171388e-20, -6.609833286632265e-20, -1.477507025554201e-22,  6.932652793454770e-24,
  2.978582577502674e-25,  2.305827789445673e-01, -1.591185600066421e-03,  7.657352804524456e-06, -2.897473115227236e-08,  7.802276211119709e-11, -8.556563803880298e-14,
 -1.155717762029713e-15,  3.044204504882372e-18, -9.633546635136581e-20, -2.323281054336102e-22,  9.809193172330353e-24,  4.039864591589423e-25,  2.976833194225242e-01,
 -2.030520162560307e-03,  9.402914005006028e-06, -3.217050327883543e-08,  6.063815033191805e-11,  1.214140947598144e-13, -2.494610066892281e-15,  6.141561055100192e-18,
 -1.196063993627914e-19, -4.397579078462979e-22,  1.377558327761420e-23,  5.305477043602629e-25,  3.740015213757532e-01, -2.515166439793004e-03,  1.108840690088272e-05,
 -3.273225041676172e-08,  2.027492862986214e-11,  4.416274912048232e-13, -4.062149345703250e-15,  6.765827627034150e-18, -1.197002890495793e-19, -8.431493699870939e-22,
  1.889715122349127e-23,  6.838718539664242e-25,  4.598488909398974e-01, -3.039277238130043e-03,  1.257154345459723e-05, -2.932223101150731e-08, -4.910201464770520e-11,
  8.623403405000713e-13, -5.402762424877360e-15,  7.319581869039047e-19, -7.749023719223867e-20, -1.459289566453691e-21,  2.447650131761254e-23,  8.767537214777259e-25,
  5.555765488151406e-01, -3.594331860207169e-03,  1.366160806500828e-05, -2.033604509633745e-08, -1.516680828601481e-10,  1.323204955639745e-12, -5.637565988442927e-15,
 -1.774392093702480e-17,  1.638502656373369e-20, -2.112862414336027e-21,  2.832080895291319e-23,  1.128725274968198e-24,  6.615691401422371e-01, -4.167781295596594e-03,
  1.410200316536877e-05, -3.944895519765566e-09, -2.864922889166328e-10,  1.679023803644250e-12, -3.336576535679526e-15, -5.419406911298148e-17,  1.289785871977978e-19,
 -2.212112056732709e-21,  2.654450982815176e-23,  1.453788666195528e-24,  7.782283998358923e-01, -4.740892544159621e-03,  1.354717768686946e-05,  2.171185759036172e-08,
 -4.411365864840277e-10,  1.645113713790179e-12,  3.406793346546554e-15, -1.075319586935481e-16,  1.193447060201664e-19, -5.721597288103755e-22,  1.679703864403455e-23,
  1.814520067214252e-24,  9.059350301528192e-01, -5.285245659581218e-03,  1.153519752148015e-05,  5.796218629221941e-08, -5.795075810660507e-10,  7.365548940452721e-13,
  1.612071686348321e-14, -1.537364651081098e-16, -3.506209432542456e-19,  3.963622614023806e-21,  1.232322007915569e-23,  2.035763755404924e-24,  1.044964512002964e+00,
 -5.756940711148071e-03,  7.465613056564299e-06,  1.041471749325564e-07, -6.204433239252773e-10, -1.723813073097037e-12,  3.277667481978775e-14, -1.140910247529903e-16,
 -1.768081770787917e-18,  8.636960105120874e-21,  7.348616838280844e-23,  1.885060509844496e-24,  1.195302393133521e+00, -6.086967982326275e-03,  6.211786279695175e-07,
  1.541159617919496e-07, -4.072496610489241e-10, -6.227564127647383e-12,  3.914568874817835e-14,  1.690389675112519e-16, -3.842108607677627e-18, -4.219669738095136e-21,
  2.920317647912057e-22,  2.397356016109736e-24,  1.356232308454222e+00, -6.165714768479534e-03, -9.633778244634944e-06,  1.884337346766170e-07,  3.003240712276325e-10,
 -1.138862441877254e-11, -5.922908642511713e-15,  7.549587902719853e-16, -1.968563406083952e-18, -6.650411393829358e-20,  3.125311886388425e-22,  8.842522651261008e-24,
  1.525392013298921e+00, -5.821896584027374e-03, -2.305936531477998e-05,  1.606371791616342e-07,  1.631001586714382e-09, -9.272271565308729e-12, -1.499353459784437e-13,
  5.736551602091623e-16,  1.371450334911113e-17, -5.673279273340259e-20, -1.491487707209936e-21,  9.014653160186493e-24,  1.696572910622654e+00, -4.816008456147322e-03,
 -3.607201157642924e-05, -4.519481543303407e-09,  2.611763034617860e-09,  1.577702671147700e-11, -1.833842831061287e-13, -2.992250746199545e-15,  2.930054775129756e-18,
  3.854401713483277e-19,  1.922845036922943e-21, -3.694850752524122e-23,  1.854845153426878e+00, -2.967050535797605e-03, -3.702468479493219e-05, -2.783047946608833e-07,
 -9.418233536959779e-11,  3.033175413432794e-11,  4.082506879748192e-13,  1.082197985992787e-15, -4.909251106999784e-17, -8.800758859422446e-19, -4.352770997658651e-21,
  9.308288298614384e-23,  1.968955215656835e+00, -7.727931083224640e-04, -1.382964975508346e-05, -2.076079328046048e-07, -2.693947426587535e-09, -2.963965180254080e-11,
 -2.513907268747037e-13, -9.550075794700258e-16,  1.937732151008389e-17,  5.948126179809323e-19,  1.011279745759999e-20,  1.255775900549937e-22,  9.788924361853273e-04,
 -6.894792588451892e-06,  3.637433923332326e-08, -1.710673600741538e-10,  7.452112519953116e-13, -3.263030271642399e-15,  1.126296001498954e-17, -7.799499352452541e-20,
 -3.061087118993844e-23,  1.417042180876157e-24,  1.564537402285139e-25,  3.614791096537675e-27,  8.815700301923954e-03, -6.203117767976659e-05,  3.262775048562752e-07,
 -1.525624002069957e-09,  6.581818270782248e-12, -2.845005206199572e-14,  9.532795214728590e-17, -6.670665497897932e-19, -4.825714812165036e-22,  1.385470400044834e-23,
  1.407154250060840e-24,  3.267055308135830e-26,  2.451965188575449e-02, -1.721831968109631e-04,  9.001794353037255e-07, -4.159362863018622e-09,  1.758395737273207e-11,
 -7.393982280275286e-14,  2.316405126069181e-16, -1.664316283298065e-18, -2.442542513569578e-21,  4.421102850208612e-23,  3.906691029600073e-24,  9.150310556456945e-26,
  4.815192213282673e-02, -3.370913156657884e-04,  1.745865009246281e-06, -7.917629784807956e-09,  3.239076206085354e-11, -1.300106852625185e-13,  3.585612008359537e-16,
 -2.733868891764763e-18, -7.784851025814978e-21,  1.015513332093231e-22,  7.665997326503119e-24,  1.815016190655146e-25,  7.980553817571345e-02, -5.563188156711192e-04,
  2.843954055445525e-06, -1.255843622741887e-08,  4.891581727708362e-11, -1.822491123612097e-13,  3.892362911460604e-16, -3.441621359831146e-18, -1.870146677530535e-20,
  1.947027583972168e-22,  1.273702716337456e-23,  3.046404043878205e-25,  1.196069124759686e-01, -8.291879170252804e-04,  4.166509525107458e-06, -1.773977059234032e-08,
  6.429879910957380e-11, -2.119139366113029e-13,  2.201844551473728e-16, -3.353082277867711e-18, -3.689461636333579e-20,  3.265692920779200e-22,  1.925105819227443e-23,
  4.634221613940560e-25,  1.677179022570449e-01, -1.154681566388045e-03,  5.674957565388950e-06, -2.300157310942663e-08,  7.485437625495257e-11, -1.967463247913836e-13,
 -2.537389380947210e-16, -2.188242035745474e-18, -6.241991926179614e-20,  4.870585679940586e-22,  2.745817677752881e-23,  6.609601154231429e-25,  2.243383818866845e-01,
 -1.531296482267065e-03,  7.317084924738037e-06, -2.774154186758953e-08,  7.603916125889128e-11, -1.126323846235907e-13, -1.114117939306510e-15, -5.434982275441301e-20,
 -9.219206304298546e-20,  6.462017417348662e-22,  3.774797047595260e-23,  9.014009080498280e-25,  2.897092639401707e-01, -1.956824377427502e-03,  9.022758964870031e-06,
 -3.118406904320578e-08,  6.247937560454202e-11,  6.316500592919178e-14, -2.377538920107496e-15,  2.222826021838667e-18, -1.183527761475031e-19,  7.515683830767268e-22,
  5.061136277917758e-23,  1.191005355456170e-24,  3.641157911035575e-01, -2.428024180679005e-03,  1.069784076124617e-05, -3.234243187427089e-08,  2.814557590028820e-11,
  3.459552488952687e-13, -3.929451341621191e-15,  2.667411116036273e-18, -1.272001549370142e-19,  7.392451506487836e-22,  6.647319006423148e-23,  1.540265702614593e-24,
  4.478906810084077e-01, -2.940124448332478e-03,  1.221550921812199e-05, -2.997693260512953e-08, -3.315183338105731e-11,  7.326001546358442e-13, -5.423016997157482e-15,
 -2.307463296196989e-18, -1.005673231485156e-19,  5.770453878782113e-22,  8.529843455015225e-23,  1.967128504738147e-24,  5.414162059138988e-01, -3.486054416897345e-03,
  1.340386442933182e-05, -2.255854167325676e-08, -1.265971975417651e-10,  1.181940974928540e-12, -6.136268712818603e-15, -1.810024848796658e-17, -2.413363105318926e-20,
  3.719859942413201e-22,  1.059277253473680e-22,  2.499743558414748e-24,  6.451232405114680e-01, -4.055230029842801e-03,  1.402825383005019e-05, -8.264987609173194e-09,
 -2.538333672489646e-10,  1.581140453162520e-12, -4.805889169378997e-15, -5.098511880003438e-17,  8.785803948998720e-20,  5.782586169173764e-22,  1.255119603798911e-22,
  3.171829309003791e-24,  7.594830685339765e-01, -4.631590418268123e-03,  1.376646825219146e-05,  1.492031675550405e-08, -4.076583836796482e-10,  1.691167629549758e-12,
  4.482564608541629e-16, -1.037239126188486e-16,  1.351466145335212e-19,  2.266849897001426e-21,  1.410395725095314e-22,  3.991586958052954e-24,  8.849827949092187e-01,
 -5.190338271744012e-03,  1.217566119926611e-05,  4.882745057320643e-08, -5.612621497568260e-10,  1.070669158472246e-12,  1.168236895390403e-14, -1.623603270211085e-16,
 -1.708812534979429e-19,  6.989513026403519e-21,  1.595558299078707e-22,  4.856960372405758e-24,  1.022063872790492e+00, -5.692387851240848e-03,  8.654814092576317e-06,
  9.398581518788900e-08, -6.473436749810526e-10, -9.815882657956082e-13,  2.884201616586751e-14, -1.649110215215109e-16, -1.375866333729457e-18,  1.418036448061690e-20,
  2.301028089149295e-22,  5.505741281370057e-24,  1.170976004437743e+00, -6.074720886328920e-03,  2.427533154176416e-06,  1.466559612724844e-07, -5.220946819562920e-10,
 -5.245217210874459e-12,  4.215221878903447e-14,  4.617805075644521e-17, -3.749564369128472e-18,  1.056917425550820e-20,  4.765141962740247e-22,  6.386776773502699e-24,
  1.331429722373432e+00, -6.233675812845967e-03, -7.351264558289801e-06,  1.914160482494432e-07,  7.279653319399584e-11, -1.128633245436455e-11,  1.399598788862181e-14,
  6.568894740035413e-16, -4.035015203207066e-18, -4.521098501743531e-20,  7.812489424011154e-22,  1.284310963961567e-23,  1.501748291703517e+00, -5.998232622978260e-03,
 -2.098187902948694e-05,  1.850604507896997e-07,  1.411119587426064e-09, -1.263065487255915e-11, -1.281122500702832e-13,  9.693662479859382e-16,  1.073416872871308e-17,
 -1.039919060130562e-19, -7.563226419028007e-22,  2.477641151193981e-23,  1.676732413538501e+00, -5.104068796945150e-03, -3.586595488914595e-05,  3.952579132073750e-08,
  2.876615745033283e-09,  1.039427112417192e-11, -2.636824988588058e-13, -2.665064007983807e-15,  1.776162676003304e-17,  4.260588851431733e-19,  5.104085366596279e-23,
 -4.456377966865404e-23,  1.842363434183618e+00, -3.276582662086574e-03, -4.035162080316580e-05, -2.744195485964554e-07,  6.118420399741403e-10,  4.028562988400943e-11,
  4.116125733983007e-13, -1.019241891296538e-15, -8.260910804898311e-17, -9.373550330450635e-19,  2.416624732783053e-21,  2.198310900881132e-22,  1.965625894020243e+00,
 -8.941754619373386e-04, -1.660020914080623e-05, -2.557887974606832e-07, -3.348783032767806e-09, -3.590098183172343e-11, -2.656070683274829e-13,  9.747243577275476e-17,
  4.954248900858373e-17,  1.125062004436723e-18,  1.676686213438416e-20,  1.753923902278681e-22,  9.518825338775934e-04, -6.611811278485400e-06,  3.439096313608719e-08,
 -1.596521213956478e-10,  6.824766766925349e-13, -3.018937418386286e-15,  9.083681405993256e-18, -7.659599315261061e-20,  1.780061147320475e-22,  1.158674002113560e-23,
  3.702940474517912e-25,  6.095252403148263e-27,  8.572682555241528e-03, -5.949243980652869e-05,  3.085834796107364e-07, -1.424748981970868e-09,  6.034177628214507e-12,
 -2.638713447809183e-14,  7.660453480543595e-17, -6.604615716900737e-19,  1.435618527473792e-21,  1.054880290848081e-22,  3.339445803378927e-24,  5.507182356910799e-26,
  2.384501246433764e-02, -1.651767384148301e-04,  8.519072754126756e-07, -3.889563829569107e-09,  1.615694517858091e-11, -6.894572895565686e-14,  1.844506773334195e-16,
 -1.677881020567425e-18,  3.099515297943772e-21,  2.994535059570863e-22,  9.316812773479178e-24,  1.541677380987570e-25,  4.683090115162591e-02, -3.234958262437667e-04,
  1.653878600306712e-06, -7.419738203190072e-09,  2.987028054842213e-11, -1.223460258510759e-13,  2.795979089653271e-16, -2.847516624869760e-18,  3.646662474155131e-21,
  6.044669709667759e-22,  1.839395531818062e-23,  3.056649718212793e-25,  7.762483015915962e-02, -5.341569569524093e-04,  2.697830006703986e-06, -1.180446930267171e-08,
  4.535613922233802e-11, -1.741207424176988e-13,  2.864171248572131e-16, -3.799727909711575e-18,  1.265040458978958e-21,  1.033594528949590e-21,  3.074159401952971e-23,
  5.129961856471135e-25,  1.163555010059133e-01, -7.966901809508376e-04,  3.959665937001419e-06, -1.674464303768903e-08,  6.010513929575737e-11, -2.078722903420484e-13,
  1.128545294777723e-16, -4.151556108999154e-18, -5.516311778856397e-21,  1.597819445190753e-21,  4.664824813796409e-23,  7.808175010066784e-25,  1.631882555399310e-01,
 -1.110365922306870e-03,  5.405993717758504e-06, -2.183573797572333e-08,  7.085252429159713e-11, -2.037716845448786e-13, -3.384582079347311e-16, -3.628334598395294e-18,
 -1.689540144298938e-20,  2.300661426614013e-21,  6.656644701947315e-23,  1.115236447284563e-24,  2.183281899206323e-01, -1.474070894892587e-03,  6.991407123386429e-06,
 -2.654439539972026e-08,  7.351741503947928e-11, -1.396888084790661e-13, -1.150864245178927e-15, -2.252412352789983e-18, -3.053095301787277e-20,  3.132531119936573e-21,
  9.115476856999715e-23,  1.524369959407408e-24,  2.820239846780339e-01, -1.886122070688770e-03,  8.654579842891022e-06, -3.017737900240470e-08,  6.317506188701769e-11,
  6.464750676912948e-15, -2.360804156950510e-15, -6.238789236469819e-19, -4.001927686217176e-20,  4.067591971259240e-21,  1.212891445001465e-22,  2.019530706876269e-24,
  3.545724132675750e-01, -2.343985743066501e-03,  1.031264533707143e-05, -3.184185618262999e-08,  3.412546787342580e-11,  2.521312756840548e-13, -3.903230210786963e-15,
 -3.126748409931703e-19, -3.352621006205016e-20,  5.069934705004565e-21,  1.579910829067161e-22,  2.617478821566713e-24,  4.363233417954793e-01, -2.843847217176762e-03,
  1.185306398543382e-05, -3.039724552511015e-08, -1.980828511574031e-11,  6.013561577197642e-13, -5.523764295211772e-15, -4.341461984436478e-18,  6.141783526264419e-21,
  6.124021518638078e-21,  2.021869263477747e-22,  3.344156322251645e-24,  5.276846893167623e-01, -3.379939002197233e-03,  1.312176228614160e-05, -2.440316136534238e-08,
 -1.044724071441474e-10,  1.028549068014904e-12, -6.644649853665492e-15, -1.759511808601180e-17,  9.665214416446784e-20,  7.318639120099089e-21,  2.542111694567045e-22,
  4.239491191748549e-24,  6.291260499567151e-01, -3.943467401050021e-03,  1.390572791697550e-05, -1.208008491013767e-08, -2.234777323527198e-10,  1.449047141617613e-12,
 -6.182307281443947e-15, -4.656068125302202e-17,  2.384781148511064e-19,  9.030186692566716e-21,  3.131852032372552e-22,  5.359276082478214e-24,  7.411779511441474e-01,
 -4.520850810616229e-03,  1.390749223861058e-05,  8.667976725340558e-09, -3.739596780330067e-10,  1.667686960117100e-12, -2.373211496348903e-15, -9.661314869520531e-17,
  3.679622347454448e-19,  1.223062198341721e-20,  3.775192174891328e-22,  6.759531773030170e-24,  8.644197500239079e-01, -5.090740209143980e-03,  1.270846118520030e-05,
  4.003224376384745e-08, -5.374152410412850e-10,  1.296163061757492e-12,  7.109058635591585e-15, -1.620908629645858e-16,  2.565839649271767e-19,  1.869015366115953e-20,
  4.517638160858116e-22,  8.430112209198284e-24,  9.994396910837828e-01, -5.618815352650116e-03,  9.719968371951929e-06,  8.350721956058138e-08, -6.604508117670437e-10,
 -3.492166976650444e-13,  2.370066727543593e-14, -1.984400850118874e-16, -6.290078907908712e-19,  2.958955693122380e-20,  5.747533800602216e-22,  1.018238533111848e-23,
  1.146726896731532e+00, -6.048410759112709e-03,  4.134000434220146e-06,  1.375183796972767e-07, -6.168458138773427e-10, -4.231108103999102e-12,  4.185247861447095e-14,
 -6.339609521813317e-17, -2.943593658720897e-18,  3.687653662152161e-20,  8.807265562421870e-22,  1.207725017133362e-23,  1.306391952030723e+00, -6.283295165069341e-03,
 -5.054656954712342e-06,  1.907992045275153e-07, -1.481621630615813e-10, -1.074556364158768e-11,  3.038639521938153e-14,  5.089599605890622e-16, -4.949217937631760e-18,
 -1.027284117731745e-21,  1.470018663707649e-21,  1.855471276354247e-23,  1.477434230991319e+00, -6.156841164517517e-03, -1.863453672172720e-05,  2.054602818278143e-07,
  1.130143419245228e-09, -1.534443680341904e-11, -9.675173392397156e-14,  1.249545506337309e-15,  6.752896677766230e-18, -1.076033482186786e-19,  6.917570330272343e-22,
  4.058036703530020e-23,  1.655746409521916e+00, -5.388303313857627e-03, -3.510981000474889e-05,  8.684684963699362e-08,  3.015564825462969e-09,  3.248749884749915e-12,
 -3.280599128957425e-13, -1.854561334593607e-15,  3.269097451430055e-17,  3.922583037319617e-19, -1.606279823781783e-21, -2.610551594574242e-23,  1.828590941702912e+00,
 -3.612336695827974e-03, -4.355763168369726e-05, -2.576630985340416e-07,  1.512357971841545e-09,  4.949315207374002e-11,  3.412464926868422e-13, -4.162649275667013e-15,
 -1.119155785660390e-16, -6.072378447365371e-19,  1.502526294890476e-20,  3.466786988422872e-22,  1.961762788188129e+00, -1.040222666531401e-03, -2.001596301612630e-05,
 -3.154551559685788e-07, -4.129224546235421e-09, -4.202121777665222e-11, -2.335806442499923e-13,  2.476003023703320e-15,  1.040632856419569e-16,  1.958726799275206e-18,
  2.500917701751505e-20,  1.864145587457568e-22,  9.259736667263033e-04, -6.344165756948228e-06,  3.253869935953862e-08, -1.492043910015594e-10,  6.241096703282275e-13,
 -2.825520354811396e-15,  7.105045390598946e-18, -6.080704087777700e-20,  9.316083781237073e-22,  3.230543903306059e-23,  6.746092562871566e-25,  7.262143970030841e-27,
  8.339544115791079e-03, -5.709055811456341e-05,  2.920486641112672e-07, -1.332330328362604e-09,  5.523367572202737e-12, -2.476079537531452e-14,  5.953853472814672e-17,
 -5.229193926191427e-19,  8.268848797707965e-21,  2.924352967034337e-22,  6.088953340395040e-24,  6.561581134903450e-26,  2.319764648820694e-02, -1.585438878990574e-04,
  8.067388083083995e-07, -3.641859115913609e-09,  1.481860399542274e-11, -6.505859464331795e-14,  1.410733874576923e-16, -1.320118703551339e-18,  2.235506125370999e-20,
  8.215256855956042e-22,  1.701372994306102e-23,  1.836969240466593e-25,  4.556282723198076e-02, -3.106130038885215e-04,  1.567629648619831e-06, -6.961051041260998e-09,
  2.748417952298353e-11, -1.165533860198770e-13,  2.059462297662830e-16, -2.212560813856613e-18,  4.215476700831485e-20,  1.636442285188023e-21,  3.365525209976616e-23,
  3.642835909007978e-25,  7.553048754244993e-02, -5.131288569698848e-04,  2.560416757078951e-06, -1.110629246441821e-08,  4.193405083160526e-11, -1.684748488488623e-13,
  1.881480379910523e-16, -2.879428121289058e-18,  6.648894807682809e-20,  2.760447425332620e-21,  5.635889616179941e-23,  6.116356443974543e-25,  1.132308450089952e-01,
 -7.658005629274096e-04,  3.764363487819900e-06, -1.581611227393644e-08,  5.596553780739764e-11, -2.065108752297349e-13,  5.766678986229701e-18, -2.975845117171398e-18,
  9.454405007396868e-20,  4.220677847872231e-21,  8.565329216543661e-23,  9.316589792787023e-25,  1.588316550292906e-01, -1.068147128873347e-03,  5.150630690936490e-06,
 -2.073517686684158e-08,  6.668771551523711e-11, -2.130774921568486e-13, -4.309169884604984e-16, -2.227388609819869e-18,  1.266462321555412e-19,  6.044852513042634e-21,
  1.223093270488078e-22,  1.332238185721179e-24,  2.125417794193217e-01, -1.419393994333956e-03,  6.679834934659911e-06, -2.539198951623926e-08,  7.044229719167717e-11,
 -1.680439808090920e-13, -1.204834295751290e-15, -5.811653643112935e-19,  1.653610208546038e-19,  8.257839610721336e-21,  1.674094785328550e-22,  1.823891711535452e-24,
  2.746157004389053e-01, -1.818316772728167e-03,  8.298510377518621e-06, -2.916862858643613e-08,  6.273631168750078e-11, -5.037556854395601e-14, -2.366445049285446e-15,
  1.560587243449627e-18,  2.169245287509990e-19,  1.088004990476064e-20,  2.224136347502330e-22,  2.421025854877754e-24,  3.453590662074096e-01, -2.263003357182750e-03,
  9.933969019474338e-06, -3.126060002835717e-08,  3.823087576332718e-11,  1.584455903790217e-13, -3.889487405415052e-15,  2.995367598147646e-18,  2.928063873120186e-19,
  1.393276164047963e-20,  2.891888762427164e-22,  3.144241208005975e-24,  4.251352852994304e-01, -2.750486293860680e-03,  1.148676890138763e-05, -3.062520180575453e-08,
 -9.115505286129372e-12,  4.676163158090075e-13, -5.596534608749188e-15,  1.251270572225307e-18,  4.106020181248096e-19,  1.746233685577609e-20,  3.699406882924756e-22,
  4.024306203525052e-24,  5.143729887362158e-01, -3.276163165840191e-03,  1.281954533984366e-05, -2.591897398843283e-08, -8.553292210642341e-11,  8.638381372233042e-13,
 -7.038171907949877e-15, -7.933877217710324e-18,  5.918670877872142e-19,  2.160898896092452e-20,  4.669593837562033e-22,  5.108173696545807e-24,  6.135736709326077e-01,
 -3.832860059679353e-03,  1.374024212929353e-05, -1.543236576691078e-08, -1.960800581412187e-10,  1.286288569961411e-12, -7.310226538661823e-15, -3.081680634954905e-17,
  8.506346966327370e-19,  2.676840915196104e-20,  5.821914553531135e-22,  6.465373056200532e-24,  7.233175862545060e-01, -4.409274016526143e-03,  1.397669603735737e-05,
  2.947467656257125e-09, -3.413855971297839e-10,  1.580124638891307e-12, -4.822987534493730e-15, -7.425641378374658e-17,  1.157798490596354e-18,  3.391014510311858e-20,
  7.173533602054967e-22,  8.185199099808107e-24,  8.442629633135241e-01, -4.987295126072902e-03,  1.313813758751517e-05,  3.164873913221439e-08, -5.101454795783200e-10,
  1.414011124010688e-12,  2.815948989990101e-15, -1.388482312226293e-16,  1.351970807504540e-18,  4.500303149961189e-20,  8.783932671120444e-22,  1.033430509190642e-23,
  9.771260416442354e-01, -5.537227241269901e-03,  1.065851612801076e-05,  7.291312184411917e-08, -6.622039742286865e-10,  1.518149095002881e-13,  1.805975397798519e-14,
 -1.961400959053886e-16,  9.685689375504725e-19,  6.264820581958077e-20,  1.098299613891005e-21,  1.283239688156210e-23,  1.122609604193096e+00, -6.008911735896575e-03,
  5.722385975434184e-06,  1.270256682929012e-07, -6.916159947263100e-10, -3.257096542973621e-12,  3.901318030197265e-14, -1.284211738626237e-16, -8.404221362255436e-19,
  8.414727065847581e-20,  1.509061530646422e-21,  1.553567856954260e-23,  1.281192319522405e+00, -6.314630412061884e-03, -2.786241316229039e-06,  1.867534707881849e-07,
 -3.547174058783916e-10, -9.862763203235670e-12,  4.250506342404464e-14,  3.630264685921598e-16, -3.718088325456237e-18,  7.544760247994427e-20,  2.376152814409663e-21,
  2.144821951053221e-23,  1.452524730993362e+00, -6.295772048286996e-03, -1.607102211333403e-05,  2.209735941238980e-07,  8.029802313736657e-10, -1.722551051442118e-11,
 -5.926214468951285e-14,  1.412703935338789e-15,  3.838913354750181e-18, -4.094953093139828e-20,  2.698366222542796e-21,  4.820290979376400e-23,  1.633639200557378e+00,
 -5.664190831154130e-03, -3.377743790199213e-05,  1.351725304032188e-07,  2.998263836698716e-09, -5.117049551346304e-12, -3.633175314831319e-13, -5.965266505810742e-16,
  4.547617893581736e-17,  3.159367040860016e-19, -1.915480202845511e-21,  1.375987113620143e-23,  1.813425773712738e+00, -3.972676323099077e-03, -4.647042187193044e-05,
 -2.251486023595744e-07,  2.572519651450313e-09,  5.586444422715434e-11,  1.722744473138962e-13, -7.946536009043720e-15, -1.190883306154324e-16,  3.179979600292215e-19,
  3.142662068889575e-20,  3.703546429338090e-22,  1.957255995375408e+00, -1.216681070731386e-03, -2.422646842608771e-05, -3.885194860107282e-07, -5.017845097185914e-09,
 -4.634648797720663e-11, -1.055676296208262e-13,  7.142181998239693e-15,  1.943635626984998e-16,  3.098518426363311e-18,  3.096894201354166e-20,  4.371338316720148e-23,
  9.011065174229938e-04, -6.090852452180716e-06,  3.080632496228439e-08, -1.396619571202526e-10,  5.691892604362242e-13, -2.670785922611323e-15,  6.035263035225508e-18,
 -6.584282788142176e-21,  2.652247587985192e-21,  6.502086120940178e-23,  9.312313086076804e-25,  3.049905387433310e-27,  8.115755476814590e-03, -5.481665545549734e-05,
  2.765748408236881e-07, -1.247844834312979e-09,  5.041457298458503e-12, -2.346612753534025e-14,  5.055053660050085e-17, -3.748711775918045e-20,  2.383047266252314e-20,
  5.877805560697801e-22,  8.408064851233131e-24,  2.758291186196896e-26,  2.257610753765543e-02, -1.522608537588785e-04,  7.644167121471383e-07, -3.414997581527948e-09,
  1.354884775158746e-11, -6.200315452786875e-14,  1.195958714463522e-16,  1.485039688720449e-20,  6.599958661300936e-20,  1.647086678495282e-21,  2.350877861573148e-23,
  7.736389950229217e-26,  4.434493857336418e-02, -2.983987969598000e-04,  1.486659412806500e-06, -6.539701683598555e-09,  2.519857585822280e-11, -1.121371886257076e-13,
  1.737636172438613e-16,  3.686754027374902e-19,  1.289078400551247e-19,  3.270309090819480e-21,  4.654278714256321e-23,  1.538322814599596e-25,  7.351811047137650e-02,
 -4.931674734914406e-04,  2.431056456129597e-06, -1.046208002977468e-08,  3.860487178290590e-11, -1.645777163336825e-13,  1.556464190294454e-16,  1.323496850855061e-18,
  2.125053480783479e-19,  5.497982225659999e-21,  7.801368682032179e-23,  2.591807583488953e-25,  1.102266916254045e-01, -7.364299197440561e-04,  3.579806501163185e-06,
 -1.495371802320798e-08,  5.183241003355304e-11, -2.068645236567034e-13, -7.196980215139275e-18,  3.218360483692935e-18,  3.173958237639994e-19,  8.383188459714963e-21,
  1.186697116916432e-22,  3.964287871045567e-25,  1.546399259078102e-01, -1.027919560367144e-03,  4.908068106111136e-06, -1.970283777020947e-08,  6.232104576924898e-11,
 -2.234723600757806e-13, -3.964594664889726e-16,  6.360701893319030e-18,  4.455382065167344e-19,  1.199090126979712e-20,  1.695753664951184e-22,  5.695941015789715e-25,
  2.069691777099957e-01, -1.367155235652901e-03,  6.381777542177572e-06, -2.429336167539565e-08,  6.679537565943908e-11, -1.962326616333514e-13, -1.092242709501357e-15,
  1.090907044025330e-17,  6.012793097469391e-19,  1.639786325147403e-20,  2.322056731162610e-22,  7.840686980870953e-25,  2.674730166629759e-01, -1.753311816073629e-03,
  7.954466362637712e-06, -2.817595928813740e-08,  6.117022236640246e-11, -1.054331809569085e-13, -2.153277543143736e-15,  1.668501471682521e-17,  7.927872946471271e-19,
  2.169463987465780e-20,  3.085600317314798e-22,  1.047401327473480e-24,  3.364636354343524e-01, -2.185021506902431e-03,  9.562600266506813e-06, -3.062857227760689e-08,
  4.048085449854984e-11,  6.771291184628907e-14, -3.581605809084140e-15,  2.288145218887236e-17,  1.033851174161109e-18,  2.799403645891988e-20,  4.012816595724695e-22,
  1.370845558407399e-24,  4.143147982883306e-01, -2.660063968193987e-03,  1.111867649345295e-05, -3.070348202878544e-08, -1.092972319338452e-12,  3.358959590253440e-13,
 -5.260744039447642e-15,  2.763583426159215e-17,  1.345636135700394e-18,  3.545588618706238e-20,  5.137471742675239e-22,  1.772234664565391e-24,  5.014714477674186e-01,
 -3.174872925603612e-03,  1.250084680451153e-05, -2.715849088709833e-08, -6.994869996741414e-11,  6.952546938825863e-13, -6.850053539805298e-15,  2.747815278336920e-17,
  1.756874350638848e-18,  4.435086913306894e-20,  6.500642510458702e-22,  2.280787298939524e-24,  5.984608289116696e-01, -3.723730317938238e-03,  1.353704748645107e-05,
 -1.837359801055439e-08, -1.721583298482949e-10,  1.104629106833744e-12, -7.611980268733536e-15,  1.684957295884157e-17,  2.297964574595264e-18,  5.521105183195792e-20,
  8.149456415193371e-22,  2.943387173686090e-24,  7.059042133517212e-01, -4.297409468880289e-03,  1.398031342733935e-05, -2.268786205497159e-09, -3.110818352874673e-10,
  1.444952365037902e-12, -6.156515407626873e-15, -1.146074736871565e-17,  2.976890404800660e-18,  6.915254303737332e-20,  1.013843595986299e-21,  3.826353490545966e-24,
  8.245262052751829e-01, -4.880807478442137e-03,  1.346989027994997e-05,  2.371511307793647e-08, -4.814717665521577e-10,  1.441590552233371e-12, -1.692126740771781e-16,
 -6.202646781710211e-17,  3.708209441164250e-18,  8.844765206488439e-20,  1.255932818024221e-21,  4.987598158468302e-24,  9.551529565342296e-01, -5.448639027029353e-03,
  1.147007360519975e-05,  6.236392419638920e-08, -6.552500464475268e-10,  5.252621320516309e-13,  1.340748533660495e-14, -1.195149011891893e-16,  4.144043537098072e-18,
  1.169621079329633e-19,  1.571537213551748e-21,  6.354990636097013e-24,  1.098674897676988e+00, -5.957228161986591e-03,  7.178310582276922e-06,  1.154883130681034e-07,
 -7.476882275971821e-10, -2.363720638389327e-12,  3.558689850403819e-14, -9.390245529958144e-17,  3.432267881074177e-18,  1.570966998000182e-19,  2.082038313364780e-21,
  7.560646069666145e-24,  1.255903255773937e+00, -6.328067274117325e-03, -5.855734754888772e-07,  1.795586298463080e-07, -5.410044122346048e-10, -8.730899443329067e-12,
  5.155353386696694e-14,  3.076142180856262e-16,  9.223749649713446e-19,  1.875589814845947e-19,  3.146802796431848e-21,  9.795958304422427e-24,  1.427101573714170e+00,
 -6.413541699149244e-03, -1.335383471520394e-05,  2.310016076648368e-07,  4.475201192245956e-10, -1.815976819696844e-11, -1.803613562534560e-14,  1.536836943850387e-15,
  4.800114703875026e-18,  1.069099524904324e-19,  4.572454779693541e-21,  3.101994707966973e-23,  1.610453408520510e+00, -5.927117396814199e-03, -3.187245422585868e-05,
  1.818496670829444e-07,  2.808266377634162e-09, -1.386263856707151e-11, -3.580322716500140e-13,  1.027769246860142e-15,  5.571815287724641e-17,  2.621526459230601e-19,
 -5.687841284062045e-22,  4.087932659041316e-23,  1.796775531520506e+00, -4.354461138480374e-03, -4.888786986979112e-05, -1.749085027640062e-07,  3.710985053550292e-09,
  5.691837609361607e-11, -9.995487146281006e-14, -1.130186541912900e-14, -8.143825774188357e-17,  1.858131409279671e-18,  4.397905089143107e-20,  1.488910831119543e-22,
  1.951970099737574e+00, -1.430577554596672e-03, -2.940123071580120e-05, -4.762760638462745e-07, -5.949811871888324e-09, -4.566592206750522e-11,  1.999532276539579e-13,
  1.538299580276650e-14,  3.276555025399236e-16,  4.256991525187531e-18,  2.305835205428278e-20, -4.977201599607931e-22,  8.772256077863315e-04, -5.850954814915539e-06,
  2.918328672977847e-08, -1.309742446041415e-10,  5.172667623690226e-13, -2.516138462084326e-15,  7.442844916075026e-18,  1.229963154084300e-19,  5.665035578846049e-21,
  1.013754714932639e-22,  7.721707695946568e-25, -1.274938224210637e-26,  7.900821105677759e-03, -5.266261723935362e-05,  2.620694119437689e-07, -1.170868713162930e-09,
  4.584718720219396e-12, -2.215743900978067e-14,  6.382611859395401e-17,  1.129173411984144e-18,  5.105881049527665e-20,  9.160594631267878e-22,  6.973394455097029e-24,
 -1.150987176326139e-25,  2.197904033000229e-02, -1.463058478698280e-04,  7.246970260276080e-07, -3.207975368060423e-09,  1.233901115969542e-11, -5.882785411824169e-14,
  1.598024464980516e-16,  3.258781858220689e-18,  1.422637295034888e-19,  2.565134471932576e-21,  1.950577707582182e-23, -3.217137190670921e-25,  4.317464237225441e-02,
 -2.868127422452096e-04,  1.410528812394582e-06, -6.154226415517942e-09,  2.300128950943146e-11, -1.072550706658850e-13,  2.621278735373990e-16,  6.740224677110556e-18,
  2.802409991247543e-19,  5.088401893332783e-21,  3.864240117753917e-23, -6.365579135964147e-25,  7.158355685889796e-02, -4.742109498707011e-04,  2.309109672871053e-06,
 -9.870502572446857e-09,  3.535850103047673e-11, -1.594244068580655e-13,  3.220066383710723e-16,  1.189873593724448e-17,  4.667695339018980e-19,  8.546572100491752e-21,
  6.482717669278518e-23, -1.065912645288922e-24,  1.073371318571901e-01, -7.084954620299977e-04,  3.405201377135398e-06, -1.415745198736646e-08,  4.770792710527622e-11,
 -2.044961603545256e-13,  2.770905007972659e-16,  1.912914603087941e-17,  7.049116695144187e-19,  1.302262164549890e-20,  9.871945789946605e-23, -1.618804284448943e-24,
  1.506053028201098e-01, -9.895841430060334e-04,  4.677467954175738e-06, -1.874187848664656e-08,  5.778106574225102e-11, -2.287928678497538e-13,  5.558365943638193e-17,
  2.884736707202674e-17,  9.997430797224579e-19,  1.862398177926147e-20,  1.412590601834782e-22, -2.307610017505705e-24,  2.016008441579375e-01, -1.317249235160135e-03,
  6.096535825408284e-06, -2.325730658161015e-08,  6.264711365149995e-11, -2.159964480741358e-13, -4.157308602985817e-16,  4.140683703524344e-17,  1.359450629391226e-18,
  2.548625476819393e-20,  1.937553914643816e-22, -3.148862834658646e-24,  2.605849227439264e-01, -1.691012070386085e-03,  7.622149091228235e-06, -2.721669240784278e-08,
  5.860080578909423e-11, -1.478310429670627e-13, -1.196318930094549e-15,  5.695838384127980e-17,  1.796926604680265e-18,  3.378010820296637e-20,  2.580026540734638e-22,
 -4.164262254947382e-24,  3.278742388833314e-01, -2.109979791467553e-03,  9.198973908375411e-06, -2.997441683757486e-08,  4.105110317858266e-11, -5.775647958936499e-15,
 -2.303883897513762e-15,  7.522204893460762e-17,  2.331968320329625e-18,  4.372521331334412e-20,  3.364166641701603e-22, -5.381865756860972e-24,  4.038501079741891e-01,
 -2.572588152960831e-03,  1.075033021912366e-05, -3.067371909366329e-08,  4.455721642116855e-12,  2.251126746868274e-13, -3.663554990953178e-15,  9.513158833847548e-17,
  2.994012694034647e-18,  5.562020309154426e-20,  4.321734434565329e-22, -6.837408208377302e-24,  4.889698800306735e-01, -3.076187784188934e-03,  1.216866080687734e-05,
 -2.817496523987531e-08, -5.758554328690730e-11,  5.480961438934309e-13, -5.017280438647018e-15,  1.143256656852928e-16,  3.824661954968071e-18,  6.990923704006458e-20,
  5.493030442405547e-22, -8.575831326414161e-24,  5.837810400316908e-01, -3.616361081777141e-03,  1.330073486688209e-05, -2.096098099012927e-08, -1.518028394772104e-10,
  9.379772780263288e-13, -5.766378546369402e-15,  1.285638541370223e-16,  4.877162940636449e-18,  8.733116176377066e-20,  6.926806347025173e-22, -1.065413281724225e-23,
  6.889379714382480e-01, -4.185758332933217e-03,  1.392415203812903e-05, -7.022814482400252e-09, -2.836199163897220e-10,  1.306694224758049e-12, -4.712801872834138e-15,
  1.315797874533433e-16,  6.204040892675058e-18,  1.092471105269734e-19,  8.680541075270400e-22, -1.315141870349410e-23,  8.052201139542271e-01, -4.772038803121491e-03,
  1.370920013881400e-05,  1.624169053407579e-08, -4.527381750520283e-10,  1.433392274104835e-12,  3.043766588554596e-16,  1.174481689838257e-16,  7.808531505018153e-18,
  1.383061871000068e-19,  1.083641192947361e-21, -1.621022919782085e-23,  9.335464108363593e-01, -5.354062290219653e-03,  1.215593765496302e-05,  5.198063472316514e-08,
 -6.417025063112693e-10,  8.262018803464229e-13,  1.263872142383090e-14,  9.282130885497499e-17,  9.502531180488425e-18,  1.794679193886468e-19,  1.361751934864980e-21,
 -2.018805181323441e-23,  1.074969323636719e+00, -5.894464904143346e-03,  8.490980785210878e-06,  1.031929134247482e-07, -7.865463138845961e-10, -1.522965932017503e-12,
  3.546191586130001e-14,  1.227356314096812e-16,  1.060266514410539e-17,  2.395286324627677e-19,  1.796448599717386e-21, -2.605373890456574e-23,  1.230595039283862e+00,
 -6.324293020007392e-03,  1.511657365483228e-06,  1.695759181712026e-07, -7.025049688664108e-10, -7.379802233993511e-12,  6.177048464334260e-14,  4.697522176445570e-16,
  9.957365883325833e-18,  3.119587759176902e-19,  2.748694526508465e-21, -3.506971528942514e-23,  1.401251437037684e+00, -6.509190255777437e-03, -1.055087427026515e-05,
  2.352478488674087e-07,  8.359119178633332e-11, -1.805403119857804e-11,  2.798752700932478e-14,  1.789164646313603e-15,  1.213963564276831e-17,  3.019580456718012e-19,
  4.696331876168499e-21, -3.578022164466459e-23,  1.586249847090173e+00, -6.172628438922551e-03, -2.943129061624764e-05,  2.241105528443223e-07,  2.448494807723905e-09,
 -2.189995853228670e-11, -3.028861076972897e-13,  2.960649740687761e-15,  6.513716172317678e-17,  2.693436322312977e-19,  5.975615223620468e-22, -5.549000339363357e-24,
  1.778563725345157e+00, -4.752865201090586e-03, -5.059367818584848e-05, -1.066681223588699e-07,  4.798515967274519e-09,  5.050167566914163e-11, -4.403783222773456e-13,
 -1.249311692324883e-14,  1.747647528776392e-17,  3.609331405249453e-18,  3.954010928725955e-20, -4.043842480118321e-22,  1.945738799735557e+00, -1.690333898312157e-03,
 -3.571656480763066e-05, -5.783492347642324e-07, -6.773509935169516e-09, -3.436696579748690e-11,  8.014407531947521e-13,  2.843735910824321e-14,  4.894450771665374e-16,
  4.422139362335367e-18, -2.441858243449597e-20, -1.823987525900553e-21,  8.542789607483318e-04, -5.623638342267709e-06,  2.765962837544185e-08, -1.230892686139449e-10,
  4.691300734094721e-13, -2.272149100498476e-15,  1.400716480200965e-17,  3.670582880982435e-19,  9.661464170925781e-21,  1.126688665390261e-22, -4.480523732300669e-25,
 -4.575860118830113e-26,  7.694276478181643e-03, -5.062104966884795e-05,  2.484448043282207e-07, -1.100960696521995e-09,  4.160538664161921e-12, -2.002950728069459e-14,
  1.235806870723603e-16,  3.330341464588066e-18,  8.717026186049634e-20,  1.018079882507910e-21, -4.044914138436751e-24, -4.132219759290500e-25,  2.140517290704324e-02,
 -1.406589861371764e-04,  6.873478248297594e-07, -3.019713846307543e-09,  1.121123506399703e-11, -5.329341041581687e-14,  3.295200746745055e-16,  9.399626990048835e-18,
  2.433754248994184e-19,  2.850702803247883e-21, -1.130477209457044e-23, -1.155678328150560e-24,  4.204950076390340e-02, -2.758178186697765e-04,  1.338816762214118e-06,
 -5.802940122813722e-09,  2.094037425275361e-11, -9.750779325832659e-14,  6.056349381650921e-16,  1.885860403224224e-17,  4.807999222575466e-19,  5.654859994913462e-21,
 -2.235877933124398e-23, -2.288638235102544e-24,  6.972292191844769e-02, -4.562024779971430e-04,  2.193954589015668e-06, -9.329707128474509e-09,  3.228426597910779e-11,
 -1.457112371456945e-13,  9.133816336179131e-16,  3.212702790534467e-17,  8.036208859657890e-19,  9.498908940646034e-21, -3.740078953305144e-23, -3.836543969322312e-24,
  1.045565751790914e-01, -6.819207395284054e-04,  3.239758737818144e-06, -1.342624946447350e-08,  4.374298709314277e-11, -1.884137448542229e-13,  1.203318168210176e-15,
  4.974946166960704e-17,  1.218209298862564e-18,  1.447772631623098e-20, -5.668383251324412e-23, -5.834322899982371e-24,  1.467204030846191e-01, -9.530486387281453e-04,
  4.457962551080467e-06, -1.785356787891162e-08,  5.330540801798607e-11, -2.134990546676707e-13,  1.418192714409865e-15,  7.237180480507593e-17,  1.733975281636312e-18,
  2.071653158730971e-20, -8.051594284861236e-23, -8.329718633082435e-24,  1.964276478572606e-01, -1.269576588739129e-03,  5.823319270240597e-06, -2.228956035939184e-08,
  5.835048991732998e-11, -2.062531091537222e-13,  1.499146711853356e-15,  1.006955914011659e-16,  2.364649668132112e-18,  2.837681217532411e-20, -1.092576386478335e-22,
 -1.138667602601172e-23,  2.539407825768155e-01, -1.631325571092269e-03,  7.301073633614935e-06, -2.630361833671365e-08,  5.552482180642905e-11, -1.497238246544406e-13,
  1.397720435914417e-15,  1.353935881478620e-16,  3.130190111008175e-18,  3.766596579026800e-20, -1.433278071822839e-22, -1.509020834167961e-23,  3.195792409769242e-01,
 -2.037815630367497e-03,  8.843210632853295e-06, -2.932064030892641e-08,  4.060330420369278e-11, -2.582966358632090e-14,  1.098542870879152e-15,  1.769609042460018e-16,
  4.059555395085791e-18,  4.885419307991573e-20, -1.832352781595181e-22, -1.955342046812659e-23,  3.937294315727493e-01, -2.488056321261486e-03,  1.038280943603566e-05,
 -3.057006164477695e-08,  8.358657562265536e-12,  1.819281007386711e-13,  6.615829077653592e-16,  2.254650830327321e-16,  5.194584384387009e-18,  6.230657745446289e-20,
 -2.296766740276143e-22, -2.492780068310530e-23,  4.768576651093774e-01, -2.980205762211833e-03,  1.182537720277275e-05, -2.901381279930344e-08, -4.748665750978956e-11,
  4.823777043619162e-13,  3.000048334055884e-16,  2.801568523371329e-16,  6.594938375846460e-18,  7.854853143489302e-20, -2.837884927406484e-22, -3.141880110676912e-23,
  5.695267579628734e-01, -3.511001235929697e-03,  1.303522892278938e-05, -2.324568934667737e-08, -1.340315684846439e-10,  8.634835264203150e-13,  5.218358747302527e-16,
  3.389547552462141e-16,  8.342865034878369e-18,  9.840656463483103e-20, -3.477202109550526e-22, -3.931098011751743e-23,  6.724170844732261e-01, -4.074777402065789e-03,
  1.381349776372107e-05, -1.135610270394791e-08, -2.581865638858802e-10,  1.264067896280685e-12,  2.380817360837450e-15,  3.980901483324358e-16,  1.054246397102605e-17,
  1.233195345333002e-19, -4.257381811129279e-22, -4.901358705935494e-23,  7.863523693462213e-01, -4.661706556486913e-03,  1.386158929680133e-05,  9.229307007775114e-09,
 -4.235645136808383e-10,  1.513249116277451e-12,  7.888102888059483e-15,  4.533115094371310e-16,  1.329567955525471e-17,  1.560184876526092e-19, -5.255307935278525e-22,
 -6.115899019047347e-23,  9.123283625916838e-01, -5.254492891519085e-03,  1.271870458635765e-05,  4.186364937813074e-08, -6.217305525151221e-10,  1.201368364467366e-12,
  2.052709204180350e-14,  5.082396706627049e-16,  1.660361160018538e-17,  2.018564987303954e-19, -6.552110693181310e-22, -7.685717740209525e-23,  1.051534857677606e+00,
 -5.821799744118999e-03,  9.652937018317131e-06,  9.041270474735782e-08, -8.079828816102440e-10, -5.839121402481658e-13,  4.502572229675758e-14,  6.105819322082478e-16,
  2.008210868858675e-17,  2.702103405173034e-19, -7.894357459098168e-22, -9.839802838694343e-23,  1.205334657630408e+00, -6.304261867026649e-03,  3.474532237827691e-06,
  1.572408784408611e-07, -8.339781299452354e-10, -5.692431685787987e-12,  8.119995785392436e-14,  9.849110706488512e-16,  2.258256502011878e-17,  3.669299857829016e-19,
 -6.957674021272640e-22, -1.305550989074966e-22,  1.375063737187673e+00, -6.582309733152324e-03, -7.731624024959591e-06,  2.337511218028827e-07, -2.664407406003602e-10,
 -1.672604600925178e-11,  8.538785509030044e-14,  2.382737439644434e-15,  2.570146227932318e-17,  4.231242618346226e-19,  3.528607255483015e-22, -1.742608926993127e-22,
  1.561106358380291e+00, -6.396691163170588e-03, -2.652255437767322e-05,  2.594200518697990e-07,  1.945773473711740e-09, -2.792983875111629e-11, -1.893296169621845e-13,
  5.202031956956273e-15,  7.484534781065981e-17,  2.468168994966097e-19, -3.014054580371985e-21, -1.827360923652622e-22,  1.758736597340425e+00, -5.161357048652728e-03,
 -5.138188585132298e-05, -2.250201332144678e-08,  5.675396647320720e-09,  3.592797663055439e-11, -7.609116866829489e-13, -9.597528949244121e-15,  1.695895132479420e-16,
  4.612901547494190e-18,  4.911478527653424e-21, -1.184838993931390e-21,  1.938359385017260e+00, -2.005713543091594e-03, -4.332548921492769e-05, -6.908746819403996e-07,
 -7.194275534463136e-09, -3.671782161337188e-12,  1.838462640786066e-12,  4.626525127207013e-14,  6.061506602137537e-16,  1.213692407113386e-18, -1.533582589211082e-19,
 -4.196332201399684e-21,  };
  constexpr double w[8448] = {  1.393777385277624e-01, -8.545903814310904e-04,  5.658593453286651e-06, -3.926980550408135e-08,  2.787749128169556e-10,
 -1.993718629401039e-12,  1.424389166535677e-14, -1.012508548146776e-16,  7.148447150891370e-19, -5.010224244195455e-21,  3.486182223199134e-23, -2.408875418155837e-25,
  1.374125921751643e-01, -1.473380789861621e-03,  1.780116908408771e-05, -2.051658048205381e-07,  2.237651741534877e-09, -2.333673646901052e-11,  2.347534318219663e-13,
 -2.291551202976727e-15,  2.180011064775002e-17, -2.027650410919335e-19,  1.848483888559706e-21, -1.654856605866380e-23,  1.335971596456867e-01, -2.648302891983577e-03,
  4.880973540637881e-05, -7.876597554537846e-07,  1.159032651460403e-08, -1.591629114178079e-10,  2.068428620603001e-12, -2.567830094283557e-14,  3.065822839487975e-16,
 -3.538184154780064e-18,  3.962506067401413e-20, -4.319388434901364e-22,  1.281468301868341e-01, -4.263232410965790e-03,  1.100109600477389e-04, -2.365962524346627e-06,
  4.504653543720719e-08, -7.830184553587780e-10,  1.266209028717984e-11, -1.929043349940421e-13,  2.793760542781565e-15, -3.872210507533695e-17,  5.162933220956699e-19,
 -6.648357698893893e-21,  1.213516737382211e-01, -6.164994054997227e-03,  2.137303298177324e-04, -5.932626562874070e-06,  1.419254166854792e-07, -3.039633473193709e-09,
  5.964700078183577e-11, -1.089113602921602e-12,  1.870855231699971e-14, -3.048113084304514e-16,  4.739918365456567e-18, -7.068511960056031e-20,  1.135439318929025e-01,
 -8.183625030015068e-03,  3.692519076281727e-04, -1.288355998252466e-05,  3.784215482603808e-07, -9.780089558254478e-09,  2.284558450058121e-10, -4.910503110271840e-12,
  9.836225673469544e-14, -1.853558098744308e-15,  3.309865156899960e-17, -5.631468090201967e-19,  1.050644796276585e-01, -1.015264565205161e-02,  5.794504082534635e-04,
 -2.483781023847186e-05,  8.783735967546550e-07, -2.691974563771835e-08,  7.366911948474005e-10, -1.836516724521395e-11,  4.230191867537632e-13, -9.098343954311204e-15,
  1.842166949216877e-16, -3.532747409647662e-18,  9.623332680768071e-02, -1.192599065038602e-02,  8.389219239575189e-04, -4.328260612996138e-05,  1.811189525110431e-06,
 -6.481843714034415e-08,  2.049230164620938e-09, -5.848724127917877e-11,  1.530450900124814e-12, -3.714198230707527e-14,  8.434393650342862e-16, -1.804144496501825e-17,
  8.732766312282576e-02, -1.338944629480171e-02,  1.133949913958590e-03, -6.911936776432773e-05,  3.368740093032812e-06, -1.388264744596330e-07,  5.006512495322660e-09,
 -1.616914251415092e-10,  4.754391042482824e-12, -1.288587887042322e-13,  3.250000369853459e-15, -7.682179162602264e-17,  7.856894862140010e-02, -1.446589201000667e-02,
  1.444132171752718e-03, -1.022384329901088e-04,  5.719420937107819e-06, -2.679176043593884e-07,  1.089266610489682e-08, -3.937928549200039e-10,  1.288086833174256e-11,
 -3.862057065856180e-13,  1.072182054777665e-14, -2.776752022260970e-16,  7.011868829058381e-02, -1.511493656309043e-02,  1.745122488139550e-03, -1.412528496316227e-04,
  8.947166731242844e-06, -4.706563130259932e-07,  2.133596733148535e-08, -8.546889523610430e-10,  3.080608937691909e-11, -1.012734569636376e-12,  3.068793768697913e-14,
 -8.638213390286139e-16,  6.208120429104630e-02, -1.532838889404939e-02,  2.011787916405304e-03, -1.834774146504196e-04,  1.299169920496029e-05, -7.586933659975678e-07,
  3.794885303556455e-08, -1.668212353613685e-09,  6.566125829637386e-11, -2.346762990908815e-12,  7.699833918585893e-14, -2.337848515010645e-15,  5.451108547778472e-02,
 -1.512332819486027e-02,  2.221139945490984e-03, -2.251696064133531e-04,  1.760957153878779e-05, -1.129244175525429e-06,  6.170097307459991e-08, -2.948949832141593e-09,
  1.256565355254171e-10, -4.842852532004826e-12,  1.707271375633233e-13, -5.550522197346407e-15,  4.742298133787095e-02, -1.453441781749773e-02,  2.354594265952900e-03,
 -2.619815676442201e-04,  2.237185655486229e-05, -1.559002077896981e-06,  9.215912039911732e-08, -4.746156723478166e-09,  2.171057040052175e-10, -8.951734465288658e-12,
  3.365477555335316e-13, -1.163286652735698e-14,  4.080181593379456e-02, -1.360671299540119e-02,  2.399357672431546e-03, -2.895279298001307e-04,  2.670493114577590e-05,
 -2.002122746788546e-06,  1.268611374227847e-07, -6.978837247990831e-09,  3.399176942098586e-10, -1.487918264299709e-11,  5.922199480566658e-13, -2.161308480514906e-14,
  3.461209564112752e-02, -1.238972337215746e-02,  2.348955947677252e-03, -3.039613362985741e-04,  2.996923429018103e-05, -2.394066190313680e-06,  1.611393982366853e-07,
 -9.389174743896487e-09,  4.830707611327275e-10, -2.227942018317210e-11,  9.320925757433896e-13, -3.567197952704986e-14,  2.880558343657699e-02, -1.093304490041111e-02,
  2.203060803014529e-03, -3.024621167943761e-04,  3.156102938198901e-05, -2.661431427856622e-06,  1.886230048993206e-07, -1.154502221293594e-08,  6.225421962313908e-10,
 -3.002783082462825e-11,  1.311187571779951e-12, -5.226988282048832e-14,  2.332709790205185e-02, -9.283545944258904e-03,  1.966838434744352e-03, -2.835796041174933e-04,
  3.101681852855630e-05, -2.736039903106953e-06,  2.024371223486343e-07, -1.291032269576996e-08,  7.240274802470711e-10, -3.625696632412327e-11,  1.640930585660319e-12,
 -6.768824587868575e-14,  1.811852686086394e-02, -7.483898112423519e-03,  1.650041727500649e-03, -2.473977859570402e-04,  2.809998329391631e-05, -2.570072203259189e-06,
  1.968562488599429e-07, -1.297693909834604e-08,  7.511596133165420e-10, -3.877082813714666e-11,  1.806189940426526e-12, -7.658904473049910e-14,  1.312134938156586e-02,
 -5.572171824494719e-03,  1.266028654331613e-03, -1.955283220188604e-04,  2.285364938099500e-05, -2.148516694713959e-06,  1.689605505000440e-07, -1.142244796663098e-08,
  6.773212645109350e-10, -3.577562848917942e-11,  1.703843055587960e-12, -7.378644538052668e-14,  8.278246849949331e-03, -3.582311908834074e-03,  8.308527737321825e-04,
 -1.309577270426998e-04,  1.561125505418690e-05, -1.495730382507809e-06,  1.197826599289691e-07, -8.240012371207182e-09,  4.968202897724294e-10, -2.666342538235021e-11,
  1.289387349338796e-12, -5.665682776518245e-14,  3.538971471089441e-03, -1.547364639764398e-03,  3.629860950083811e-04, -5.786124904661263e-05,  6.973257133622245e-06,
 -6.751713449987925e-07,  5.461758972058533e-08, -3.793682583069606e-09,  2.308599542044897e-10, -1.249998076634297e-11,  6.096151810344576e-13, -2.700446196753166e-14,
  1.360470331926190e-01, -8.111336720745538e-04,  5.212859964509498e-06, -3.511074729197308e-08,  2.421021225459689e-10, -1.683458164842130e-12,  1.170380806482651e-14,
 -8.101199502056398e-17,  5.572209623010597e-19, -3.806318029446508e-21,  2.581983994343112e-23, -1.739719973331432e-25,  1.317891099910965e-01, -1.340244340388311e-03,
  1.553952697319194e-05, -1.728116152893912e-07,  1.822441127378595e-09, -1.840005381294153e-11,  1.793531412153049e-13, -1.697780062021046e-15,  1.567314087425584e-17,
 -1.415436146677657e-19,  1.253538931348906e-21, -1.090714404034254e-23,  1.237291941108499e-01, -2.292705649661466e-03,  4.037355619081434e-05, -6.252092852709783e-07,
  8.850519803568604e-09, -1.171475431539976e-10,  1.469619686563895e-12, -1.763338238094892e-14,  2.036887881492189e-16, -2.276328059932236e-18,  2.470561407640933e-20,
 -2.611697089602445e-22,  1.126901162815956e-01, -3.485549621518162e-03,  8.547595596947951e-05, -1.755659443698669e-06,  3.203478173253833e-08, -5.350004344456676e-10,
  8.328226628973931e-12, -1.223311758099243e-13,  1.710430824288298e-15, -2.291342142760488e-17,  2.955803270954008e-19, -3.685802108684520e-21,  9.970949029682118e-02,
 -4.705475639189281e-03,  1.543837822430887e-04, -4.079650922732876e-06,  9.328883878403228e-08, -1.915364712337397e-09,  3.611305932058559e-11, -6.347409256488682e-13,
  1.051203277728208e-14, -1.653422293641543e-16,  2.485092089466112e-18, -3.585763188313707e-20,  8.586620941703006e-02, -5.758228838864931e-03,  2.453739084744069e-04,
 -8.136780621142798e-06,  2.281184741865191e-07, -5.644993064101053e-09,  1.265714965622493e-10, -2.616722550652349e-12,  5.050190768821777e-14, -9.182958085658849e-16,
  1.584370049847329e-17, -2.607696729360645e-19,  7.212770073470284e-02, -6.505784753181104e-03,  3.506462822614023e-04, -1.428109346272071e-05,  4.819170172568400e-07,
 -1.413865177831818e-08,  3.713522950898557e-10, -8.904079977294289e-12,  1.976248144461115e-13, -4.102253956338646e-15,  8.027499900308533e-17, -1.489747785331345e-18,
  5.924716056942925e-02, -6.883108444052984e-03,  4.579685011364286e-04, -2.247336883461223e-05,  8.980839095837909e-07, -3.079064741922283e-08,  9.349621957052755e-10,
 -2.568539106990446e-11,  6.481487064920671e-13, -1.519356322525833e-14,  3.337480253852329e-16, -6.914877542528653e-18,  4.772080346851430e-02, -6.894433312570918e-03,
  5.538730440681422e-04, -3.218049808102520e-05,  1.500526075058824e-06, -5.933646494532539e-08,  2.058404785723013e-09, -6.408311958055873e-11,  1.819737797386413e-12,
 -4.770771931857426e-14,  1.165596341941604e-15, -2.672513578738021e-17,  3.779774958954521e-02, -6.595251887940795e-03,  6.269861030481473e-04, -4.244095494752779e-05,
  2.277526494669668e-06, -1.026195633388408e-07,  4.022347365371387e-09, -1.404734238405337e-10,  4.446440754724750e-12, -1.292123652616042e-13,  3.481620479526227e-15,
 -8.762818942241736e-17,  2.952483299636598e-02, -6.068639128010927e-03,  6.703009241873745e-04, -5.207442135043384e-05,  3.174793439883776e-06, -1.611310111079439e-07,
  7.062135006934004e-09, -2.740143235608835e-10,  9.581822206169896e-12, -3.060458696508769e-13,  9.022178975507187e-15, -2.473760609231683e-16,  2.280643205052693e-02,
 -5.403396244121342e-03,  6.818851180331889e-04, -5.995025349081215e-05,  4.101773464592448e-06, -2.319354736528742e-07,  1.125352049772516e-08, -4.806589354797720e-10,
  1.840882466979824e-11, -6.410508036882375e-13,  2.051801850907572e-14, -6.084103783125140e-16,  1.746323502986623e-02, -4.678416881159117e-03,  6.641985232573185e-04,
 -6.521613544092629e-05,  4.949298081852580e-06, -3.085205441359318e-07,  1.641222834599935e-08, -7.647767469060073e-10,  3.181267201127126e-11, -1.198316761500953e-12,
  4.133272392771355e-14, -1.316103394402779e-15,  1.328025579771876e-02, -3.954418901923789e-03,  6.226008557707864e-04, -6.742146489390311e-05,  5.611956952074012e-06,
 -3.817290529399794e-07,  2.205489215679327e-08, -1.111427865177466e-09,  4.980292348488205e-11, -2.013581569520318e-12,  7.429984686175809e-14, -2.522853840792547e-15,
  1.004052886819494e-02, -3.271897723360211e-03,  5.636853583726022e-04, -6.652217254786987e-05,  6.007558928575180e-06, -4.414780200646083e-07,  2.744791110375734e-08,
 -1.483009269339855e-09,  7.100704403505818e-11, -3.057961583421645e-12,  1.198378858601881e-13, -4.309316725447727e-15,  7.545198834264765e-03, -2.653153534866714e-03,
  4.938965860551276e-04, -6.279610028015888e-05,  6.088460842960598e-06, -4.786854584895355e-07,  3.173551347095989e-08, -1.822749728628392e-09,  9.250618397330355e-11,
 -4.211225128791740e-12,  1.740097251819945e-13, -6.581283862452462e-15,  5.622893375982907e-03, -2.106255079627406e-03,  4.186379760589901e-04, -5.671644542262144e-05,
  5.843463523933142e-06, -4.868323337466234e-07,  3.410824361909768e-08, -2.064916773055181e-09,  1.101914667315984e-10, -5.262460617951374e-12,  2.276232255087068e-13,
 -8.992655724642542e-15,  4.131797210966338e-03, -1.629348989101582e-03,  3.418670798790263e-04, -4.882680976409960e-05,  5.292291231198533e-06, -4.628194436243879e-07,
  3.396242679285605e-08, -2.148989935015458e-09,  1.196193988213836e-10, -5.947560614399156e-12,  2.673506995640049e-13, -1.095694810680470e-14,  2.957415529495844e-03,
 -1.214392962728851e-03,  2.660611321847181e-04, -3.964539520939190e-05,  4.476261219647235e-06, -4.070795475057774e-07,  3.101128535094140e-08, -2.033703933794115e-09,
  1.171374963872582e-10, -6.017485761084322e-12,  2.790695622954707e-13, -1.178276782487812e-14,  2.008217410445900e-03, -8.499446652908590e-04,  1.924057189292444e-04,
 -2.960850111544437e-05,  3.448646497841965e-06, -3.231317520008974e-07,  2.533005838472379e-08, -1.707185369665996e-09,  1.009357564872376e-10, -5.316452495768284e-12,
  2.525232108516196e-13, -1.090782998589826e-14,  1.210573980138542e-03, -5.230078093121846e-04,  1.210852403631500e-04, -1.905141832164158e-05,  2.267177744574883e-06,
 -2.168599684004914e-07,  1.733907587981822e-08, -1.190948486693909e-09,  7.170077787989882e-11, -3.842599693082812e-12,  1.855672590245468e-13, -8.143357260834031e-15,
  5.044105452976692e-04, -2.204008025855702e-04,  5.166433113964452e-05, -8.229389926109700e-06,  9.910604289765324e-07, -9.588943858879262e-08,  7.751575300454646e-09,
 -5.380560949028162e-10,  3.272145729539899e-11, -1.770593912561660e-12,  8.629762495508428e-14, -3.820501482641106e-15,  1.328833255609270e-01, -7.710527198400572e-04,
  4.813709131845067e-06, -3.149194140986829e-08,  2.110680388511305e-10, -1.427891730875694e-12,  9.665846401953917e-15, -6.518807827908817e-17,  4.370788290204353e-19,
 -2.911504642863502e-21,  1.926482558650053e-23, -1.266473717749154e-25,  1.266642961429484e-01, -1.223753903054293e-03,  1.362931365691390e-05, -1.463778896753298e-07,
  1.493908348953902e-09, -1.461374263580525e-11,  1.381347540212277e-13, -1.268956731717350e-15,  1.137547244047759e-17, -9.981466508330043e-20,  8.593050543420020e-22,
 -7.271438833950128e-24,  1.151600110694315e-01, -1.997486300870162e-03,  3.364915619446191e-05, -5.005837167856744e-07,  6.823793528668746e-09, -8.713436664581594e-11,
  1.056058046994249e-12, -1.225616875392361e-14,  1.370722824800101e-16, -1.484390363402650e-18,  1.562291857746970e-20, -1.602628481840818e-22,  9.999341451850766e-02,
 -2.878048171906006e-03,  6.716252582634345e-05, -1.318905335062657e-06,  2.308510418511616e-08, -3.707291749859213e-10,  5.559820056621637e-12, -7.879681960698817e-14,
  1.064368091945041e-15, -1.379004055582748e-17,  1.722093975811686e-19, -2.080626130938547e-21,  8.308001116963054e-02, -3.643486914471447e-03,  1.132570947447443e-04,
 -2.851819549140480e-06,  6.238446883046583e-08, -1.228796082995166e-09,  2.227564827334452e-11, -3.771186547451487e-13,  6.024731800992555e-15, -9.153098783256014e-17,
  1.330318659213757e-18, -1.858106658631171e-20,  6.621838060029510e-02, -4.131374463689281e-03,  1.663799252085986e-04, -5.247012714365563e-06,  1.404895077308035e-07,
 -3.330552049607950e-09,  7.171559329877026e-11, -1.426675867875540e-12,  2.653974506161566e-14, -4.658281357298585e-16,  7.768039222737296e-18, -1.237166528287105e-19,
  5.078976709123347e-02, -4.273744301536064e-03,  2.175701949514338e-04, -8.421824957531370e-06,  2.712597757691750e-07, -7.620465100562401e-09,  1.921447309321973e-10,
 -4.432187471286637e-12,  9.480663558273083e-14, -1.899624006846632e-15,  3.593140951104752e-17, -6.453598533815219e-19,  3.762608462047909e-02, -4.093746849404446e-03,
  2.575524617489107e-04, -1.201937035341885e-05,  4.586688668952084e-07, -1.506428880487453e-08,  4.393278077110963e-10, -1.161667809848987e-11,  2.826673508334089e-13,
 -6.399846267204228e-15,  1.359761220947391e-16, -2.728563036222670e-18,  2.703538661077807e-02, -3.675332460805104e-03,  2.798695226319513e-04, -1.549100498036217e-05,
  6.907577619824515e-07, -2.620082904877054e-08,  8.740218605327073e-10, -2.622142992051031e-11,  7.188580400090250e-13, -1.822426491280174e-14,  4.311879625411442e-16,
 -9.586833202229303e-18,  1.892796264215797e-02, -3.124576560304839e-03,  2.825374743897578e-04, -1.826946073053352e-05,  9.397410422334982e-07, -4.070000637320597e-08,
  1.537049498132426e-09, -5.182372695469335e-11,  1.586521852334952e-12, -4.466045924262133e-14,  1.167354608456944e-15, -2.853901543476134e-17,  1.297578363063383e-02,
 -2.538156352939664e-03,  2.678028917559443e-04, -1.994445816408712e-05,  1.169105520494726e-06, -5.719360830319074e-08,  2.421429344073106e-09, -9.092752637358975e-11,
  3.082347633462834e-12, -9.558300055440016e-14,  2.739384906564001e-15, -7.311303789468388e-17,  8.754317557953369e-03, -1.986104125350252e-03,  2.405893387343792e-04,
 -2.036149290593641e-05,  1.344410585381353e-06, -7.352221826714324e-08,  3.456721524370402e-09, -1.433099139504482e-10,  5.335677390672519e-12, -1.808743589033727e-13,
  5.642660120163524e-15, -1.632751560410007e-16,  5.841916627361691e-03, -1.508124944151895e-03,  2.066040604840049e-04, -1.961743903879586e-05,  1.442681657399199e-06,
 -8.730812852971472e-08,  4.516496717762344e-09, -2.049648924094751e-10,  8.314590255634803e-12, -3.058023772670051e-13,  1.031049121696332e-14, -3.212582911769324e-16,
  3.874262195007875e-03, -1.118604230208393e-03,  1.708651202564449e-04, -1.798013533914186e-05,  1.456704740275816e-06, -9.659073701985160e-08,  5.447676523587576e-09,
 -2.683263249812848e-10,  1.176561256013358e-11, -4.659798852144926e-13,  1.685964033630648e-14, -5.618508556188159e-16,  2.563850486407556e-03, -8.149629255624986e-04,
  1.369507594287932e-04, -1.578273755744020e-05,  1.393637358773937e-06, -1.002585972010702e-07,  6.109011346005354e-09, -3.238212691632965e-10,  1.522574908947162e-11,
 -6.444797831655760e-13,  2.484434450136177e-14, -8.795118561377326e-16,  1.697923606296164e-03, -5.856242227178818e-04,  1.068896819231043e-04, -1.333559229169304e-05,
  1.269908246288065e-06, -9.815253160645150e-08,  6.402701810453664e-09, -3.621315864937155e-10,  1.811183080377851e-11, -8.131298897022208e-13,  3.315671660983897e-14,
 -1.238323433534335e-15,  1.126239893007812e-03, -4.158672025630776e-04,  8.143668776471421e-05, -1.087531458838045e-05,  1.105199008515096e-06, -9.088229679838714e-08,
  6.288842193752763e-09, -3.762631030793864e-10,  1.985476375846778e-11, -9.381394070579104e-13,  4.016761619365956e-14, -1.571604868023586e-15,  7.461924735805091e-04,
 -2.913205128650248e-04,  6.048144401225855e-05, -8.549805546282945e-06,  9.176230521796927e-07, -7.949779909021982e-08,  5.781775222316222e-09, -3.627463619705380e-10,
  2.002873586909884e-11, -9.881907952885219e-13,  4.409508017988610e-14, -1.794569376788535e-15,  4.892009544858624e-04, -1.995842415938928e-04,  4.342552568975098e-05,
 -6.427155120820382e-06,  7.209733271633688e-07, -6.516081114225902e-08,  4.934637839463547e-09, -3.217895592217097e-10,  1.843501368433691e-11, -9.421811435485300e-13,
  4.348165958624183e-14, -1.827330962263838e-15,  3.098318171259413e-04, -1.306461269802206e-04,  2.945647939227671e-05, -4.515078018038869e-06,  5.238956738968904e-07,
 -4.890936911141098e-08,  3.820625495558117e-09, -2.566447886685017e-10,  1.512568654511125e-11, -7.942768701580958e-13,  3.761747673999203e-14, -1.620405469821985e-15,
  1.777387615315832e-04, -7.665241552143689e-05,  1.771175260058504e-05, -2.781370259185780e-06,  3.303724298556234e-07, -3.154382879482129e-08,  2.517726806182474e-09,
 -1.726448360951875e-10,  1.037747527442979e-11, -5.553006930816920e-13,  2.677727339154917e-14, -1.173430900591100e-15,  7.201167545007288e-05, -3.144311151275613e-05,
  7.364815056377015e-06, -1.172185584906932e-06,  1.410564425179384e-07, -1.363754421574760e-08,  1.101633623905662e-09, -7.641275997489968e-11,  4.643775718909240e-12,
 -2.511115703436739e-13,  1.223106699004578e-14, -5.411437844615522e-16,  1.298738189282908e-01, -7.339993409425019e-04,  4.455165156821557e-06, -2.833130454754051e-08,
  1.846899364929421e-10, -1.216325923074077e-12,  8.021634937128801e-15, -5.274009710321609e-17,  3.448918623720140e-19, -2.241602348490743e-21,  1.447562853576894e-23,
 -9.289840264708096e-26,  1.219767706089503e-01, -1.121360289154916e-03,  1.200710127843829e-05, -1.246448079292258e-07,  1.232107155189656e-09, -1.168684195527540e-11,
  1.072038879924370e-13, -9.563791766507359e-16,  8.330897047077260e-18, -7.107016462445356e-20,  5.951358143826186e-22, -4.900613764856496e-24,  1.076728643266507e-01,
 -1.750589040326660e-03,  2.824388923870411e-05, -4.040757732139252e-07,  5.309129884969707e-09, -6.545677565427414e-11,  7.670463723261840e-13, -8.616801796926508e-15,
  9.337014931901539e-17, -9.804502103928250e-19,  1.001307450558211e-20, -9.973413130304384e-23,  8.946376228318989e-02, -2.398296140688537e-03,  5.332874031638603e-05,
 -1.002296673615560e-06,  1.684427052794093e-08, -2.603357325717415e-10,  3.764248495562347e-12, -5.151103035613187e-14,  6.726483010931891e-16, -8.433788014828964e-18,
  1.020176184060546e-19, -1.194905838680365e-21,  7.012314961132117e-02, -2.859044327628404e-03,  8.429831162511499e-05, -2.024461877506178e-06,  4.240028783469515e-08,
 -8.018204936654414e-10,  1.398494079478734e-11, -2.281890306739285e-13,  3.518632291044971e-15, -5.166172113335873e-17,  7.264398029855015e-19, -9.826281254126967e-21,
  5.200415286594383e-02, -3.018494439227012e-03,  1.149741791048264e-04, -3.450586472249234e-06,  8.829176595235799e-08, -2.006361410511750e-09,  4.151032335596312e-11,
 -7.949907390510676e-13,  1.426069167891509e-14, -2.417088987511642e-16,  3.897117840991475e-18, -6.007800769956150e-20,  3.662656863311446e-02, -2.873789911720827e-03,
  1.382293153918076e-04, -5.087134647486242e-06,  1.564487521862599e-07, -4.209878356747901e-09,  1.019326783481670e-10, -2.262581309513300e-12,  4.665455979399350e-14,
 -9.025249635594899e-16,  1.650406744971454e-17, -2.869316261882138e-19,  2.460850250419535e-02, -2.505157557731618e-03,  1.490023288970389e-04, -6.612671902203540e-06,
  2.409743094529881e-07, -7.581951118360009e-09,  2.123723954494640e-10, -5.405054724265080e-12,  1.268237238781033e-13, -2.773307067968853e-15,  5.699183983293250e-17,
 -1.107565795235925e-18,  1.585541189845485e-02, -2.025552142899377e-03,  1.461051782432353e-04, -7.700889340965248e-06,  3.282734800032805e-07, -1.194019536241997e-08,
  3.829158453445454e-10, -1.106752752579028e-11,  2.928553158371305e-13, -7.177634926294864e-15,  1.644176185676532e-16, -3.543926424240534e-18,  9.854922999249987e-03,
 -1.536531241406041e-03,  1.320140606737286e-04, -8.147725719873740e-06,  4.014449859949981e-07, -1.670207303493971e-08,  6.073919941908545e-10, -1.976117411336734e-11,
  5.848124174247364e-13, -1.593948167051000e-14,  4.039768575206340e-16, -9.588936126790526e-18,  5.947974294423081e-03, -1.105095350547792e-03,  1.112254517271455e-04,
 -7.931672721040246e-06,  4.465871369974408e-07, -2.103997452252423e-08,  8.597741183353369e-10, -3.122235741963097e-11,  1.025305233233109e-12, -3.084730623324536e-14,
  8.589211953529882e-16, -2.230058333478241e-17,  3.510814793729099e-03, -7.611209157316475e-04,  8.835739235653272e-05, -7.188230656121285e-06,  4.574568085572337e-07,
 -2.416816278246926e-08,  1.099939174699688e-09, -4.422104465816033e-11,  1.599103486872959e-12, -5.272486235030473e-14,  1.601894444168426e-15, -4.519676734637182e-17,
  2.041738263469269e-03, -5.068352100000269e-04,  6.688043470687780e-05, -6.131605212176033e-06,  4.363523920800340e-07, -2.560436464015196e-08,  1.286517720497470e-09,
 -5.679760580352523e-11,  2.244616004636936e-12, -8.052856644982837e-14,  2.651583308272193e-15, -8.077531271773696e-17,  1.178707307334258e-03, -3.293168002491707e-04,
  4.871490865030142e-05, -4.973434157524749e-06,  3.916205473422923e-07, -2.527971718014763e-08,  1.390069521587273e-09, -6.684400094242641e-11,  2.864973083352231e-12,
 -1.110369123410523e-13,  3.935415112450845e-15, -1.285975369804890e-16,  6.803662668653085e-04, -2.105608234126075e-04,  3.445522906126551e-05, -3.871587125995519e-06,
  3.337917741009289e-07, -2.347677331032755e-08,  1.400254437403899e-09, -7.273543920477190e-11,  3.354827946913566e-12, -1.394321613714198e-13,  5.282303975833409e-15,
 -1.839269814091369e-16,  3.951147221330705e-04, -1.334551850290577e-04,  2.384723142021487e-05, -2.915323627636382e-06,  2.723137617513654e-07, -2.066629515530293e-08,
  1.324961979448098e-09, -7.371770836962770e-11,  3.629872915108125e-12, -1.605629155005342e-13,  6.455387093067985e-15, -2.378757738042149e-16,  2.318685851606470e-04,
 -8.429032286629985e-05,  1.624184250967474e-05, -2.135488612152300e-06,  2.138240312536109e-07, -1.733724043776449e-08,  1.183767571444730e-09, -6.993179123330322e-11,
  3.645931179039988e-12, -1.703049627542421e-13,  7.212584067392802e-15, -2.792842445456284e-16,  1.376119990169200e-04, -5.313807170331931e-05,  1.090555833242400e-05,
 -1.524473784053379e-06,  1.618750201722830e-07, -1.388180219029543e-08,  9.998728361356314e-10, -6.215649186865501e-11,  3.401982556433910e-12, -1.664554258831471e-13,
  7.368823955947995e-15, -2.976383061786743e-16,  8.210138028219589e-05, -3.325855027773268e-05,  7.181787382705281e-06, -1.055102584996077e-06,  1.175206624570826e-07,
 -1.054973669239082e-08,  7.937979120519471e-10, -5.144700517960800e-11,  2.930166503294146e-12, -1.489237998856131e-13,  6.836439830308754e-15, -2.858562230274727e-16,
  4.822186736007712e-05, -2.025091505017436e-05,  4.545871256294577e-06, -6.937846007050196e-07,  8.016725272196494e-08, -7.454434450778121e-09,  5.801035202332918e-10,
 -3.882642783166508e-11,  2.280374904614765e-12, -1.193514812690898e-13,  5.634757294591020e-15, -2.419935464532625e-16,  2.620994038584542e-05, -1.128142008344121e-05,
  2.601202745273790e-06, -4.076213219658469e-07,  4.831882951568089e-08, -4.604424648207871e-09,  3.668195642541493e-10, -2.510812457267529e-11,  1.506613320139281e-12,
 -8.048572905873044e-14,  3.874960129478116e-15, -1.695503227912155e-16,  1.029869544225865e-05, -4.493414591648834e-06,  1.051592912550159e-06, -1.672308557920837e-07,
  2.010732999304505e-08, -1.942444477924322e-09,  1.567872632177742e-10, -1.086703058624916e-11,  6.599297470524468e-13, -3.566025233852261e-14,  1.735731940490494e-15,
 -7.674347856408130e-17,  1.270070195939751e-01, -6.996694699043793e-04,  4.132149524560841e-06, -2.556089806503293e-08,  1.621751387386177e-10, -1.040350986625600e-12,
  6.688044995828995e-15, -4.289049005086219e-17,  2.737029018337884e-19, -1.736607874897483e-21,  1.095046650658016e-23, -6.863880325568927e-26,  1.176744208675666e-01,
 -1.030968195431813e-03,  1.062236174809929e-05, -1.066697857860408e-07,  1.022076403355460e-09, -9.407377195321500e-12,  8.380334988691379e-14, -7.265228788185568e-16,
  6.153609956565972e-18, -5.106999238869812e-20,  4.162275009771579e-22, -3.337174859527615e-24,  1.010936158819951e-01, -1.542682860051415e-03,  2.386448458352028e-05,
 -3.286789004818115e-07,  4.166158521646417e-09, -4.963533001559214e-11,  5.628047072102017e-13, -6.124223424498360e-15,  6.433904781007868e-17, -6.555279762530744e-19,
  6.500222646725600e-21, -6.290218616386909e-23,  8.065364690675872e-02, -2.015560905086465e-03,  4.276106692420431e-05, -7.699834427495845e-07,  1.243562339067272e-08,
 -1.851239122658560e-10,  2.582713740404482e-12, -3.414896980973802e-14,  4.313755535167805e-16, -5.237440980528973e-18,  6.140240999045083e-20, -6.975953920306917e-22,
  5.989669816690574e-02, -2.271409339485924e-03,  6.359963863506769e-05, -1.458075832763318e-06,  2.926186300869042e-08, -5.316671303579253e-10,  8.927971397601634e-12,
 -1.404902471532080e-13,  2.092169489455099e-15, -2.970231571501452e-17,  4.042796149907449e-19, -5.298444413965233e-21,  4.153780197679465e-02, -2.243045925089657e-03,
  8.087564091101015e-05, -2.311540486776112e-06,  5.655990336229583e-08, -1.232743882377853e-09,  2.451911108997584e-11, -4.522925482858272e-13,  7.827099941872399e-15,
 -1.281607222946142e-16,  1.998640100478460e-18, -2.983395560356491e-20,  2.700906621211025e-02, -1.975215055226161e-03,  8.980251877821287e-05, -3.143463701028893e-06,
  9.234279300543840e-08, -2.381029561401891e-09,  5.538009772287860e-11, -1.183256526298007e-12,  2.352649203454492e-14, -4.395053489396915e-16,  7.771666447008095e-18,
 -1.308103547734489e-19,  1.654867689928013e-02, -1.574953146264494e-03,  8.855373973257335e-05, -3.737510787987064e-06,  1.300751279029653e-07, -3.921115345680328e-09,
  1.054979871784185e-10, -2.584573312616947e-12,  5.848198742832058e-14, -1.235210988516193e-15,  2.455202394151882e-17, -4.620946873023193e-19,  9.611277194145037e-03,
 -1.152423177572831e-03,  7.869776765384412e-05, -3.948598818894820e-06,  1.608717910433915e-07, -5.609877957148284e-09,  1.729218128451713e-10, -4.814299636889966e-12,
  1.229346589060257e-13, -2.912362151118601e-15,  6.457755768246269e-17, -1.349152384609759e-18,  5.327982767714096e-03, -7.833579901292672e-04,  6.388700409962817e-05,
 -3.760817106727984e-06,  1.773870758935513e-07, -7.085978351499699e-09,  2.480272211197864e-10, -7.783131297253057e-12,  2.225673954423332e-13, -5.871136865621487e-15,
  1.442226619881414e-16, -3.322412473885828e-18,  2.841370750534658e-03, -5.004813115259119e-04,  4.798685640121802e-05, -3.273204374211753e-06,  1.768594653851342e-07,
 -8.017888777496304e-09,  3.160034423668390e-10, -1.108997608417387e-11,  3.525620455739174e-13, -1.028474800071213e-14,  2.780561798921131e-16, -7.018811628014210e-18,
  1.470589279898916e-03, -3.040196450939527e-04,  3.376827865437564e-05, -2.637236369331284e-06,  1.615736999554746e-07, -8.237774591922485e-09,  3.625692300672512e-10,
 -1.412231293962265e-11,  4.955837665048929e-13, -1.588019816216561e-14,  4.695159878575603e-16, -1.290740484638908e-17,  7.457752434748472e-04, -1.776320261458847e-04,
  2.253789657650979e-05, -1.992013864801134e-06,  1.369920416410952e-07, -7.784373963550403e-09,  3.794739667003784e-10, -1.628054051157724e-11,  6.261753805848616e-13,
 -2.189274776612515e-14,  7.033661359780760e-16, -2.093052693590467e-17,  3.743426559605861e-04, -1.009892135440229e-04,  1.444104348529905e-05, -1.428046311276392e-06,
  1.091300214815417e-07, -6.848728223390858e-09,  3.667100131179663e-10, -1.719567841966419e-11,  7.196347555055145e-13, -2.726515457553630e-14,  9.456960571408570e-16,
 -3.027348954060222e-17,  1.879024151942618e-04, -5.650668590874840e-05,  8.987909387318917e-06, -9.831331236642787e-07,  8.263838416326647e-08, -5.674781183351251e-09,
  3.308968658843790e-10, -1.682396532224032e-11,  7.603733329048922e-13, -3.099794057998121e-14,  1.152952225690904e-15, -3.944932349696905e-17,  9.524482559182673e-05,
 -3.144968784580491e-05,  5.492964608972268e-06, -6.570315259845789e-07,  6.011735181111671e-08, -4.474124123873490e-09,  2.815897633605302e-10, -1.539475581231017e-11,
  7.455345632672658e-13, -3.246055625733527e-14,  1.285583520038048e-15, -4.670005294527026e-17,  4.915579306624375e-05, -1.756758334325389e-05,  3.326387566590721e-06,
 -4.300567779469638e-07,  4.237745035402007e-08, -3.384286023444427e-09,  2.277739891506908e-10, -1.327343702975578e-11,  6.831045443087229e-13, -3.151769954563862e-14,
  1.319247615529437e-15, -5.051764824263718e-17,  2.595735582461561e-05, -9.903314741732061e-06,  2.007045667874520e-06, -2.771636560552331e-07,  2.909004089753755e-08,
 -2.467220350803220e-09,  1.758514755096588e-10, -1.082320528708942e-11,  5.867930586539763e-13, -2.845353379836106e-14,  1.248851999844995e-15, -5.003360806327483e-17,
  1.399749709138045e-05, -5.626097124030728e-06,  1.204840943880993e-06, -1.755810819819173e-07,  1.940579119270522e-08, -1.729223635295051e-09,  1.292015484893028e-10,
 -8.317930316012308e-12,  4.707455162017840e-13, -2.378098981732777e-14,  1.085408218689897e-15, -4.513692668205038e-17,  7.577376031545138e-06, -3.167885830622733e-06,
  7.076876372188551e-07, -1.074956086380187e-07,  1.236471193885886e-08, -1.144748831440492e-09,  8.871498846827580e-11, -5.914247290922643e-12,  3.460504815570782e-13,
 -1.804673204134179e-14,  8.490938830248584e-16, -3.634677978165179e-17,  3.883436390355496e-06, -1.667961993961127e-06,  3.836931251291173e-07, -5.998842076055747e-08,
  7.095138144181767e-09, -6.746708006676970e-10,  5.363891103844861e-11, -3.664296252370794e-12,  2.194640475735840e-13, -1.170308818318696e-14,  5.624732059979378e-16,
 -2.457081095762223e-17,  1.475625122721117e-06, -6.433061469708171e-07,  1.504171287403807e-07, -2.389870501402466e-08,  2.870971466059280e-09, -2.771087424955546e-10,
  2.234862658673044e-11, -1.547749687818017e-12,  9.391790657726564e-14, -5.071152849156809e-15,  2.466532583063369e-16, -1.089778872744502e-17,  1.242725737378738e-01,
 -6.677966118070001e-04,  3.840328105390123e-06, -2.312422201508769e-08,  1.428808545557328e-10, -8.933142856749887e-13,  5.600901845282506e-15, -3.505331068618329e-17,
  2.183930929035749e-19, -1.353409417343746e-21,  8.337212660323993e-24, -5.106755386310831e-26,  1.137127734493755e-01, -9.508450683991417e-04,  9.434570789875849e-06,
 -9.171900096558197e-08,  8.525020959803089e-10, -7.619547663656467e-12,  6.596248454156826e-14, -5.560767961552393e-16,  4.582515242934394e-18, -3.702028722960717e-20,
  2.938272044939294e-22, -2.295078558995030e-24,  9.528124260683737e-02, -1.366481326483330e-03,  2.028975716199742e-05, -2.692824992101717e-07,  3.295751276435599e-09,
 -3.797324281659677e-11,  4.169313481124698e-13, -4.397725690887599e-15,  4.482281264031964e-17, -4.433909429897515e-19,  4.271483937678631e-21, -4.018150427910947e-23,
  7.322149162850813e-02, -1.707310100290222e-03,  3.460298777691044e-05, -5.975645461620582e-07,  9.282926089023422e-09, -1.332116279904695e-10,  1.794515136660006e-12,
 -2.294179786806398e-14,  2.805278709373194e-16, -3.300141030096106e-18,  3.751990022586745e-20, -4.136901084048936e-22,  5.172810015141680e-02, -1.825379268080687e-03,
  4.859532659297823e-05, -1.064523690436610e-06,  2.048788028730436e-08, -3.579220168392931e-10,  5.790651833552756e-12, -8.793330199887026e-14,  1.265402817370018e-15,
 -1.738025388545738e-17,  2.291015149835037e-19, -2.910558543700801e-21,  3.370343789813633e-02, -1.693295975718413e-03,  5.784621520694055e-05, -1.575694402056461e-06,
  3.689381710394576e-08, -7.717217159883710e-10,  1.476458988327029e-11, -2.624627682334027e-13,  4.383854963375890e-15, -6.937444112496716e-17,  1.046838848716774e-18,
 -1.513623584272559e-20,  2.033736063164920e-02, -1.385764208588371e-03,  5.958084415487431e-05, -1.984630337530093e-06,  5.571442454889953e-08, -1.377133456382671e-09,
  3.078051398278191e-11, -6.332649498524395e-13,  1.214470743185706e-14, -2.191577815375108e-16,  3.748289075731516e-18, -6.109377998594542e-20,  1.142475765720134e-02,
 -1.015717977072456e-03,  5.398941126936737e-05, -2.167385052274394e-06,  7.205092478459058e-08, -2.081290622701017e-09,  5.379615126520181e-11, -1.268810034687026e-12,
  2.768927817590300e-14, -5.649263369153088e-16,  1.086175171532280e-17, -1.979937635904123e-19,  6.012789977658662e-03, -6.758775659831276e-04,  4.367780591331705e-05,
 -2.085661066853833e-06,  8.119967108008101e-08, -2.714388324781365e-09,  8.041267934826749e-11, -2.156236387411077e-12,  5.312842407833400e-14, -1.216432923889453e-15,
  2.610580608575172e-17, -5.285646908854249e-19,  2.987096571791551e-03, -4.135179805377710e-04,  3.198491646872032e-05, -1.794728761403197e-06,  8.099754416802015e-08,
 -3.105243202340633e-09,  1.045744612457755e-10, -3.163967724654040e-12,  8.739548059659895e-14, -2.230503139317446e-15,  5.308788120414417e-17, -1.186517851068739e-18,
  1.413146543710864e-03, -2.355487117520491e-04,  2.148840793550749e-05, -1.400618154547194e-06,  7.256527886195922e-08, -3.163260423118611e-09,  1.201625006695733e-10,
 -4.072813963316676e-12,  1.252739586202344e-13, -3.541340294372312e-15,  9.291216263093855e-17, -2.278983605488729e-18,  6.430967316966460e-04, -1.265191130901799e-04,
  1.342478657934528e-05, -1.005195286225542e-06,  5.922165028679055e-08, -2.910922027469533e-09,  1.237853717486586e-10, -4.667327166764376e-12,  1.588160646642894e-13,
 -4.941992738341051e-15,  1.420875384581464e-16, -3.803250595253667e-18,  2.847417941889600e-04, -6.493247351646510e-05,  7.907669298372373e-06, -6.727832599172712e-07,
  4.465155846940460e-08, -2.454089231588922e-09,  1.159367634594012e-10, -4.828700834891406e-12,  1.805717987616658e-13, -6.146826921502234e-15,  1.925210096593148e-16,
 -5.591639889024223e-18,  1.242014016232107e-04, -3.228333119174645e-05,  4.454198066070852e-06, -4.259429338845861e-07,  3.154328157874093e-08, -1.921975912937324e-09,
  1.000853723351834e-10, -4.571262547068475e-12,  1.865921367189938e-13, -6.903902812958058e-15,  2.341200444803081e-16, -7.335316678450586e-18,  5.408148834362608e-05,
 -1.577060114773299e-05,  2.433828093246577e-06, -2.587293838186630e-07,  2.117118487646428e-08, -1.417479658260817e-09,  8.070107944616194e-11, -4.011374719552387e-12,
  1.774516861571640e-13, -7.088296064921536e-15,  2.585866117071605e-16, -8.686221852302261e-18,  2.382446033364550e-05, -7.676440636608336e-06,  1.308278290615731e-06,
 -1.528745136014677e-07,  1.368229659305669e-08, -9.972603662366727e-10,  6.153923486474036e-11, -3.302155579895081e-12,  1.571089786384885e-13, -6.726425940380619e-15,
  2.621692188774982e-16, -9.379863397035561e-18,  1.075070605234766e-05, -3.771482230398600e-06,  7.007159468225617e-07, -8.896050048578975e-08,  8.616089210756919e-09,
 -6.769301627165266e-10,  4.485992132556864e-11, -2.576122103182140e-12,  1.307450674643671e-13, -5.953208443494399e-15,  2.460727748497610e-16, -9.310973789493265e-18,
  5.016652670242186e-06, -1.888857362009487e-06,  3.775818308671104e-07, -5.145498558454328e-08,  5.332674396654066e-09, -4.468859884779889e-10,  3.149133663704786e-11,
 -1.917390247490626e-12,  1.028931729421529e-13, -4.940908811799304e-15,  2.148613361107917e-16, -8.532748193864677e-18,  2.427643306179751e-06, -9.673867697239699e-07,
  2.052884266571302e-07, -2.965268830309521e-08,  3.249657991565122e-09, -2.872469556067838e-10,  2.129826553663331e-11, -1.361226317184997e-12,  7.650624143877965e-14,
 -3.839582148970438e-15,  1.741523256848248e-16, -7.199246502934013e-18,  1.203214068368049e-06, -5.005428992159604e-07,  1.112249018650563e-07, -1.680699947729871e-08,
  1.923592270010840e-09, -1.772424393205669e-10,  1.367355261485258e-11, -9.076229527649674e-13,  5.288800742654414e-14, -2.747345640161020e-15,  1.287798210075141e-16,
 -5.493071440046712e-18,  5.783973818126617e-07, -2.478427957467272e-07,  5.686742237361691e-08, -8.868552700481984e-09,  1.046381185928368e-09, -9.926768954655235e-11,
  7.874565322490015e-12, -5.367974147155760e-13,  3.208464309987783e-14, -1.707603763654001e-15,  8.191775748590751e-17, -3.572088890050788e-18,  2.118576659762852e-07,
 -9.227970879725007e-08,  2.155584020458541e-08, -3.421540139267906e-09,  4.106436414539204e-10, -3.959928163377048e-11,  3.190812939229428e-12, -2.207888869613810e-13,
  1.338637911104306e-14, -7.222232709149823e-16,  3.510047991829959e-17, -1.549664988366293e-18,  1.216611282333243e-01, -6.381463980160299e-04,  3.575987195208412e-06,
 -2.097407510642594e-08,  1.262831827082858e-10, -7.699236672010446e-13,  4.710359257047445e-15, -2.878407809164808e-17,  1.751691874830191e-19, -1.060794618464017e-21,
  6.386741882718057e-24, -3.824804668494014e-26,  1.100536884288603e-01, -8.795501815587310e-04,  8.411018923687481e-06, -7.921709071866554e-08,  7.147616495959663e-10,
 -6.207874436505590e-12,  5.226004472162206e-14, -4.286751977579957e-16,  3.439104509074372e-18, -2.706024046150140e-20,  2.092729353695053e-22, -1.593349688496117e-24,
  9.012068162509015e-02, -1.216246768522546e-03,  1.735135030765902e-05, -2.221216474675165e-07,  2.627154996918121e-09, -2.929609720013053e-11,  3.116925239983698e-13,
 -3.188982169262806e-15,  3.155348847125300e-17, -3.032286233916671e-19,  2.839681608164376e-21, -2.598178738361618e-23,  6.690379972558412e-02, -1.456832633728203e-03,
  2.824247878043679e-05, -4.682130081153988e-07,  7.002156898097772e-09, -9.693755727147456e-11,  1.261836816192643e-12, -1.560831262518018e-14,  1.848631605988491e-16,
 -2.108429253220258e-18,  2.325928324691958e-20, -2.490218124372499e-22,  4.513041167464260e-02, -1.482639917788236e-03,  3.757400585635100e-05, -7.871957504012212e-07,
  1.454117000010602e-08, -2.444368568374672e-10,  3.812652505663212e-12, -5.590599659258149e-14,  7.778782981409276e-16, -1.034210033455445e-17,  1.320934940951695e-19,
 -1.627488717561517e-21,  2.774880506947113e-02, -1.297183739900358e-03,  4.202651826447220e-05, -1.091856179482121e-06,  2.448070881822540e-08, -4.917550228689785e-10,
  9.055008053218653e-12, -1.552015996963088e-13,  2.503239572415172e-15, -3.830266256696405e-17,  5.594854666325901e-19, -7.838867625622112e-21,  1.561569542954022e-02,
 -9.910848760678978e-04,  4.032021809875601e-05, -1.278725849194020e-06,  3.432224649990261e-08, -8.136351479604766e-10,  1.748323154949549e-11, -3.464815862914003e-13,
  6.411416407254655e-15, -1.117946809759156e-16,  1.849884698133236e-18, -2.920471005334063e-20,  8.085000530011981e-03, -6.710005260506357e-04,  3.372212307001483e-05,
 -1.287918537915559e-06,  4.090594172917275e-08, -1.132546494807752e-09,  2.812863315757129e-11, -6.388146891455925e-13,  1.344749537870885e-14, -2.650587608304125e-16,
  4.930166158767641e-18, -8.704836432649293e-20,  3.876104135004044e-03, -4.080146342185798e-04,  2.494443736712124e-05, -1.133436815626829e-06,  4.216478502029817e-08,
 -1.351111452025112e-09,  3.846643306118915e-11, -9.933967580388438e-13,  2.361671501729076e-14, -5.225682762672336e-16,  1.085354378788392e-17, -2.129487851951594e-19,
  1.734221832880100e-03, -2.257176725741403e-04,  1.654576614228609e-05, -8.845013076566344e-07,  3.817929302351643e-08, -1.404256862315579e-09,  4.548522713828352e-11,
 -1.326476104613372e-12,  3.538193352595805e-14, -8.734257612401902e-16,  2.013620576406767e-17, -4.365080557886904e-19,  7.309268458367128e-04, -1.150874650947032e-04,
  9.977899770992943e-06, -6.209173513423928e-07,  3.082300414422059e-08, -1.291137306126871e-09,  4.724448609094107e-11, -1.545693767537555e-12,  4.597515680900490e-14,
 -1.258809796533459e-15,  3.203458050659229e-17, -7.631641702200536e-19,  2.934242841925185e-04, -5.482272209380226e-05,  5.548924232797760e-06, -3.978571673190885e-07,
  2.251702749685455e-08, -1.066022193116081e-09,  4.376146751716548e-11, -1.595989356020334e-12,  5.261945505651492e-14, -1.588963835476923e-15,  4.439473506383362e-17,
 -1.156259828562243e-18,  1.136380185709141e-04, -2.475573028875164e-05,  2.888696478263357e-06, -2.362307365952559e-07,  1.511099631193851e-08, -8.023506212151036e-10,
  3.669452878839487e-11, -1.482174463873416e-12,  5.383993643370734e-14, -1.782861034585272e-15,  5.439065784392138e-17, -1.540626097626844e-18,  4.307787148972358e-05,
 -1.076403871366008e-05,  1.430270024210092e-06, -1.320463118192796e-07,  9.462340837809764e-09, -5.590308930317531e-10,  2.827708636784445e-11, -1.256529809180066e-12,
  4.997226199149238e-14, -1.803835878135915e-15,  5.974827749537427e-17, -1.830540285562511e-18,  1.624169391312954e-05, -4.582690769548860e-06,  6.848898445130782e-07,
 -7.063880150731327e-08,  5.618318233719347e-09, -3.662450122951318e-10,  2.033239463061744e-11, -9.868580812059341e-13,  4.268127149017499e-14, -1.668749433013635e-15,
  5.964895517399776e-17, -1.965210494758803e-18,  6.194480400863787e-06, -1.943791367540795e-06,  3.226723992348481e-07, -3.677436429998223e-08,  3.214635974058157e-09,
 -2.291529889568699e-10,  1.384680722024133e-11, -7.283964362882155e-13,  3.400914746859733e-14, -1.430273964789085e-15,  5.480755160247123e-17, -1.929512029206910e-18,
  2.430284741339507e-06, -8.355065717247762e-07,  1.520785147591427e-07, -1.893198741519296e-08,  1.799830965851910e-09, -1.389401392229236e-10,  9.055619952807046e-12,
 -5.119012363472710e-13,  2.559535215120596e-14, -1.149033996274129e-15,  4.685949538829396e-17, -1.750563203222152e-18,  9.952061607290543e-07, -3.693228057986096e-07,
  7.272903841462786e-08, -9.769012043263287e-09,  9.986239495592792e-10, -8.260349247052317e-11,  5.749569215675345e-12, -3.460009603387747e-13,  1.836274663214675e-14,
 -8.725420298631781e-16,  3.756591854470644e-17, -1.477756969988412e-18,  4.289477139435910e-07, -1.693138757821803e-07,  3.557207675637747e-08, -5.088517065478850e-09,
  5.525081057918843e-10, -4.840950366355967e-11,  3.559497884390495e-12, -2.256990013978010e-13,  1.258999852339119e-14, -6.273447085681085e-16,  2.826172696049857e-17,
 -1.160792394808822e-18,  1.932641738455125e-07, -7.995943515701823e-08,  1.766374298872907e-08, -2.653894429009413e-09,  3.020804984154414e-10, -2.768889154768753e-11,
  2.125485747206774e-12, -1.404195797382913e-13,  8.145649011770525e-15, -4.213308874195941e-16,  1.966930281046908e-17, -8.357497854293535e-19,  8.663899550092601e-08,
 -3.702876888157676e-08,  8.472381290361488e-09, -1.317631185380005e-09,  1.550506856960414e-10, -1.467179715669984e-11,  1.161028671664974e-12, -7.896153858867393e-14,
  4.709090127353709e-15, -2.500949647603459e-16,  1.197333327449666e-17, -5.210982355713544e-19,  3.048267426870016e-08, -1.326494125186153e-08,  3.095356125991500e-09,
 -4.908118430598617e-10,  5.884599339754423e-11, -5.669057507923824e-12,  4.563632677505253e-13, -3.154904945042420e-14,  1.911109176727983e-15, -1.030196907995563e-16,
  5.002657151557693e-18, -2.206873342063450e-19,  1.191642114051541e-01, -6.105120387272709e-04,  3.335932504157426e-06, -1.907085272520597e-08,  1.119530432884226e-10,
 -6.659466850658604e-13,  3.977473210270811e-15, -2.374348520047790e-17,  1.412009951575664e-19, -8.360010465253676e-22,  4.921421138478328e-24, -2.883027223166537e-26,
  1.066643060684546e-01, -8.158790479676890e-04,  7.525143866555309e-06, -6.870988537645030e-08,  6.022349864608141e-10, -5.086078016723604e-12,  4.166217905007146e-14,
 -3.327226204039890e-16,  2.600141436840483e-18, -1.993770359009355e-20,  1.503207524636480e-22, -1.116186031558094e-24,  8.551738818088413e-02, -1.087425251202604e-03,
  1.492000030537526e-05, -1.843965242803643e-07,  2.109356202241831e-09, -2.278223199027754e-11,  2.350401614964736e-13, -2.334061745754493e-15,  2.243367017143391e-17,
 -2.095628763985638e-19,  1.908827139274361e-21, -1.699625860276914e-23,  6.149527184945322e-02, -1.251599787808854e-03,  2.323710206329106e-05, -3.701804754945154e-07,
  5.334025821962531e-09, -7.129360949535475e-11,  8.973779732044317e-13, -1.074700884274462e-14,  1.233665600145038e-16, -1.364937201004264e-18,  1.461837299378079e-20,
 -1.520534820838544e-22,  3.974634087270409e-02, -1.216219763039397e-03,  2.937704414408658e-05, -5.891609214578419e-07,  1.045387423121660e-08, -1.692155528709148e-10,
  2.546335624515447e-12, -3.607640382359460e-14,  4.856311363676666e-16, -6.253294521279160e-18,  7.742889075342137e-20, -9.256242628325670e-22,  2.315801686437064e-02,
 -1.007399417639574e-03,  3.098440433686240e-05, -7.683675030996666e-07,  1.650869996038524e-08, -3.186657252436910e-10,  5.650805217781621e-12, -9.343577125404685e-14,
  1.455971993225389e-15, -2.155073611187889e-17,  3.048497498033020e-19, -4.140447506085024e-21,  1.221101392071975e-02, -7.216697619336994e-04,  2.779919026798307e-05,
 -8.398778614286966e-07,  2.156541225953685e-08, -4.905358690432977e-10,  1.013793336775316e-11, -1.936126483638495e-13,  3.458125025833891e-15, -5.828427052004544e-17,
  9.333722539833428e-19, -1.427667976809469e-20,  5.856376031924140e-03, -4.534273750075652e-04,  2.155067282135266e-05, -7.832587345293720e-07,  2.377536263579787e-08,
 -6.310960363704328e-10,  1.506516218351899e-11, -3.295194778408961e-13,  6.692489344586170e-15, -1.274636793321415e-16,  2.293950059376818e-18, -3.923617458514913e-20,
  2.570858929118631e-03, -2.531644869717010e-04,  1.463918930992463e-05, -6.329350159941997e-07,  2.249867097656480e-08, -6.910862611493426e-10,  1.890913447999404e-11,
 -4.703144353134480e-13,  1.078829419827090e-14, -2.306928189689694e-16,  4.636936801416166e-18, -8.815752371452488e-20,  1.041126780529680e-03, -1.272264479547107e-04,
  8.832605081259785e-06, -4.496512850415462e-07,  1.855769516431292e-08, -6.546699111434178e-10,  2.039088880521750e-11, -5.730460800019956e-13,  1.475708876579418e-14,
 -3.522732338592455e-16,  7.864900961916393e-18, -1.653271554704914e-19,  3.927099231814554e-04, -5.830925311410237e-05,  4.799286834496024e-06, -2.849092550451843e-07,
  1.354244042344417e-08, -5.448023699645397e-10,  1.919279977038815e-11, -6.058265957559340e-13,  1.741737922781071e-14, -4.616980198764662e-16,  1.139158745647571e-17,
 -2.634692262825907e-19,  1.395784836569593e-04, -2.471700787118163e-05,  2.383005588413276e-06, -1.634274954283334e-07,  8.876493897896820e-09, -4.044153667748404e-10,
  1.601396723636137e-11, -5.644936023015988e-13,  1.802048602682661e-14, -5.277269627341599e-16,  1.431913467780262e-17, -3.626612411941540e-19,  4.739589921273725e-05,
 -9.841817520621494e-06,  1.098504283924606e-06, -8.622338802788204e-08,  5.309285904615746e-09, -2.720436736518387e-10,  1.203197665018187e-11, -4.708801927699731e-13,
  1.660018810556724e-14, -5.342817331873737e-16,  1.586377709858647e-17, -4.378806335374381e-19,  1.562619951800514e-05, -3.744940672393511e-06,  4.783218088855858e-07,
 -4.256445045296606e-08,  2.947181194500508e-09, -1.686046655840253e-10,  8.274083924539119e-12, -3.573082190098148e-13,  1.383060877808542e-14, -4.865695712658799e-16,
  1.572711242357595e-17, -4.707465666456237e-19,  5.095229932043569e-06, -1.387906848460708e-06,  2.004806723941615e-07, -2.002683671527401e-08,  1.545835171431119e-09,
 -9.797264572426088e-11,  5.296708713818868e-12, -2.507231371291236e-13,  1.058952516544231e-14, -4.048137341204962e-16,  1.416357830277522e-17, -4.572376190771997e-19,
  1.676873088974858e-06, -5.113820743168449e-07,  8.253029444513044e-08, -9.158151999334113e-09,  7.807010004610559e-10, -5.435057839825587e-11,  3.211708479937485e-12,
 -1.654220979736981e-13,  7.570884488930183e-15, -3.124216005813678e-16,  1.175827614129068e-17, -4.069349653225800e-19,  5.689549705136960e-07, -1.913413211215742e-07,
  3.406321020964956e-08, -4.151613957424841e-09,  3.868636632487708e-10, -2.930525541426657e-11,  1.876210382614525e-12, -1.042833629244556e-13,  5.131486127320532e-15,
 -2.268957733648369e-16,  9.120830703209353e-18, -3.361072347569772e-19,  2.030474329649663e-07, -7.416268358484095e-08,  1.436752714406388e-08, -1.899750029075988e-09,
  1.913226497661435e-10, -1.560374193785707e-11,  1.071672565101068e-12, -6.368102988017598e-14,  3.339371219185882e-15, -1.568830203523604e-16,  6.681836430126262e-18,
 -2.601715346586828e-19,  7.734194597257300e-08, -3.020966993906095e-08,  6.277451895243467e-09, -8.884647028810894e-10,  9.549492185084707e-11, -8.286872474023915e-12,
  6.037897795489181e-13, -3.795514687749629e-14,  2.099931652402546e-15, -1.038260087693899e-16,  4.642899584529627e-18, -1.893662087821016e-19,  3.143596691522134e-08,
 -1.292731484985684e-08,  2.837321322308375e-09, -4.236128103051086e-10,  4.792766530523034e-11, -4.367915918810643e-12,  3.334701867006037e-13, -2.191675338250163e-14,
  1.265135807254358e-15, -6.513346567403657e-17,  3.027187894667924e-18, -1.280840178340457e-19,  1.305933620875134e-08, -5.565508955629712e-09,  1.269478862707845e-09,
 -1.968307515884537e-10,  2.309414287187397e-11, -2.179195670302878e-12,  1.719873149542373e-13, -1.166711878660172e-14,  6.941143852689081e-16, -3.677848007560236e-17,
  1.756890671052415e-18, -7.630201925221453e-20,  4.396192518375373e-09, -1.911109028991678e-09,  4.454519989607830e-10, -7.055333160862795e-11,  8.449749159844001e-12,
 -8.131623180316298e-13,  6.539314386002226e-14, -4.516255626226053e-15,  2.733150356421010e-16, -1.471968636851916e-17,  7.141562017027335e-19, -3.147736217803367e-20,
  1.167741304820381e-01, -5.847105080249567e-04,  3.117406443391801e-06, -1.738118607241316e-08,  9.953737844720153e-11, -5.779810655566996e-13,  3.371646403555924e-15,
 -1.967094297612600e-17,  1.143629957167138e-19, -6.623127929302002e-22,  3.813639802405645e-24, -2.186574020875930e-26,  1.035161917191235e-01, -7.588195565607055e-04,
  6.755250704965325e-06, -5.983657706297764e-08,  5.098036551059714e-10, -4.189202383881138e-12,  3.341065556976834e-14, -2.599313139304770e-16,  1.979754596824673e-18,
 -1.480179880572569e-20,  1.088542439796625e-22, -7.886826410049683e-25,  8.139315976285209e-02, -9.763752794551712e-04,  1.289563936072401e-05, -1.540063349889941e-07,
  1.705219016972693e-09, -1.785087079640700e-11,  1.786997288991588e-13, -1.723502844607236e-15,  1.610099450117889e-17, -1.462871901208524e-19,  1.296729928794584e-21,
 -1.124222864915187e-23,  5.683444700265978e-02, -1.082122020059254e-03,  1.926347815392553e-05, -2.951676890422850e-07,  4.101276650976748e-09, -5.296310968832634e-11,
  6.450776374402059e-13, -7.484520486808020e-15,  8.332071451289683e-17, -8.947958433869877e-19,  9.308845328034804e-21, -9.411830928929994e-23,  3.531041871459409e-02,
 -1.006876900865930e-03,  2.320889068590817e-05, -4.459673233879267e-07,  7.607127154756780e-09, -1.186575836708919e-10,  1.723757394194013e-12, -2.361179703221890e-14,
  3.076754295280636e-16, -3.839147321336945e-18,  4.610737500306621e-20, -5.350619106163464e-22,  1.957152981168898e-02, -7.923560159838459e-04,  2.316015819246817e-05,
 -5.486493778406519e-07,  1.130411385041479e-08, -2.098167949180819e-10,  3.585166063722043e-12, -5.721971302031192e-14,  8.618642167606913e-16, -1.234621571394322e-17,
  1.692038326255659e-19, -2.228659041480571e-21,  9.712687313358795e-03, -5.343926272931288e-04,  1.950546027961382e-05, -5.617378808221603e-07,  1.380593258657196e-08,
 -3.014833429584067e-10,  5.995623147770520e-12, -1.103905960812889e-13,  1.903896789987285e-15, -3.102800739806117e-17,  4.810387348720799e-19, -7.130930100148832e-21,
  4.335958345498305e-03, -3.129971243992563e-04,  1.407348421461480e-05, -4.869336509704645e-07,  1.413087053948367e-08, -3.597320720857592e-10,  8.256085861464402e-12,
 -1.739724972593844e-13,  3.409831260842415e-15, -6.276584038012514e-17,  1.093154200787629e-18, -1.811587126627139e-20,  1.751757229629528e-03, -1.612221528477697e-04,
  8.816860831216343e-06, -3.627351704978048e-07,  1.232163368164181e-08, -3.628418853803331e-10,  9.542066741627889e-12, -2.285948163297387e-13,  5.059681092324077e-15,
 -1.045633247726281e-16,  2.034017999859174e-18, -3.747222508700269e-20,  6.453720544625603e-04, -7.394717095922391e-05,  4.859493140561601e-06, -2.355122336198600e-07,
  9.291400411892173e-09, -3.143247880540767e-10,  9.412614984555813e-12, -2.548702016622666e-13,  6.335639046793905e-15, -1.462290201930538e-16,  3.161085848357691e-18,
 -6.442391362173536e-20,  2.188915967930818e-04, -3.059718862513260e-05,  2.388545402152058e-06, -1.351752767887267e-07,  6.148846520964702e-09, -2.374488199521035e-10,
  8.050069974234982e-12, -2.450583564052481e-13,  6.807206448442288e-15, -1.746295953969360e-16,  4.175900348119222e-18, -9.373090653975705e-20,  6.915942049790401e-05,
 -1.158471365095738e-05,  1.062463959108409e-06, -6.962082647928776e-08,  3.625787324221170e-09, -1.588469976580967e-10,  6.062979274004413e-12, -2.064334667922391e-13,
  6.376858822146447e-15, -1.809943893412393e-16,  4.766643635591465e-18, -1.173315554662836e-19,  2.065100632118319e-05, -4.078498117945961e-06,  4.347183779636446e-07,
 -3.270593439811384e-08,  1.936320525668189e-09, -9.564247841364535e-11,  4.086858715661513e-12, -1.548274112756190e-13,  5.292743893070925e-15, -1.654378223643959e-16,
  4.777147617813544e-18, -1.284030306061565e-19,  5.929867115818243e-06, -1.359849684363519e-06,  1.666408400149359e-07, -1.427014301812833e-08,  9.533629387443437e-10,
 -5.274591672985649e-11,  2.508296513149661e-12, -1.051505857345848e-13,  3.957371351205046e-15, -1.355582370704493e-16,  4.271760142175533e-18, -1.248098854657413e-19,
  1.671339008901999e-06, -4.384792177555205e-07,  6.109542324813865e-08, -5.900743223472793e-09,  4.413310118743794e-10, -2.715577690878695e-11,  1.427830669036629e-12,
 -6.583492771883006e-14,  2.712321298116814e-15, -1.012692031229573e-16,  3.464648805954024e-18, -1.094892706372729e-19,  4.733571541210115e-07, -1.399826351337743e-07,
  2.192023686179353e-08, -2.364209389880497e-09,  1.962268934494574e-10, -1.332191674518485e-11,  7.688077152029503e-13, -3.872279225483941e-14,  1.735132715121377e-15,
 -7.018057540906838e-17,  2.591476782536782e-18, -8.807937153169895e-20,  1.382128126424228e-07, -4.538119204030809e-08,  7.887389982531823e-09, -9.396297203965886e-10,
  8.569408679875448e-11, -6.361040850081678e-12,  3.995321641996998e-13, -2.180876096804596e-14,  1.054936586519490e-15, -4.589497916988196e-17,  1.816717897832758e-18,
 -6.597663293657136e-20,  4.269223295459833e-08, -1.532349437205554e-08,  2.916094905549443e-09, -3.790414017149561e-10,  3.755941843280416e-11, -3.016694331846098e-12,
  2.042120745785476e-13, -1.196983056619012e-14,  6.196102831993592e-16, -2.875413549471828e-17,  1.210498220115286e-18, -4.661620747436452e-20,  1.425548723522445e-08,
 -5.503961547172421e-09,  1.129940150565673e-09, -1.580655376916917e-10,  1.680159692505674e-11, -1.442742088050392e-12,  1.040774417740874e-13, -6.481051853770431e-15,
  3.553860405392413e-16, -1.742303546465653e-17,  7.728905620311625e-19, -3.128428752419064e-20,  5.184472770216260e-09, -2.117674429502788e-09,  4.614756820660171e-10,
 -6.842041340837803e-11,  7.689801860696016e-12, -6.964014245864141e-13,  5.284941237719547e-14, -3.453757495640531e-15,  1.982952505218427e-16, -1.015683122780536e-17,
  4.697688321597546e-19, -1.978520413999745e-20,  1.982090521860203e-09, -8.420370310451113e-10,  1.914102341434985e-10, -2.957850605006105e-11,  3.459284618465480e-12,
 -3.254208081642900e-13,  2.560786945352036e-14, -1.732325974410237e-15,  1.027883857481093e-16, -5.432611223883172e-18,  2.588887163689602e-19, -1.121784182799533e-20,
  6.356204244919024e-10, -2.760102428415111e-10,  6.425545852250378e-11, -1.016480692010528e-11,  1.215939441089325e-12, -1.168823364750907e-13,  9.389121830679490e-15,
 -6.477535055384470e-16,  3.916066857172068e-17, -2.106961357968982e-18,  1.021264071999558e-19, -4.497237098043628e-21,  1.144838830818538e-01, -5.605793301094518e-04,
  2.918020078818934e-06, -1.587684846038268e-08,  8.874438598930257e-11, -5.032784754239462e-13,  2.868709683951112e-15, -1.636515966765481e-17,  9.304879541718685e-20,
 -5.273727192436224e-22,  2.971056017080432e-24, -1.668310465485359e-26,  1.005846376359223e-01, -7.075171363417074e-04,  6.083522719657462e-06, -5.230877524238556e-08,
  4.334836530868081e-10, -3.467988698390451e-12,  2.694502188069019e-14, -2.043280463327571e-16,  1.517575688391807e-18, -1.106888216855973e-20,  7.943976164993390e-23,
 -5.618844953058845e-25,  7.768290523688338e-02, -8.801643458674231e-04,  1.120019517994912e-05, -1.293613648640540e-07,  1.387462108005781e-09, -1.408748380208296e-11,
  1.369293287595556e-13, -1.283414166391019e-15,  1.166036375546319e-17, -1.030970088918588e-19,  8.898391740847185e-22, -7.515412736629264e-24,  5.279321705836227e-02,
 -9.411420684664408e-04,  1.608277517697231e-05, -2.372463685168124e-07,  3.181297740170909e-09, -3.972213976931958e-11,  4.684651308007783e-13, -5.269175039527245e-15,
  5.692047421658934e-17, -5.936617473267734e-19,  6.002443465119853e-21, -5.902117379232015e-23,  3.162306031829761e-02, -8.407098641868577e-04,  1.851596481933090e-05,
 -3.411970098185885e-07,  5.599376548945338e-09, -8.422444815241832e-11,  1.181982244621240e-12, -1.566300465767904e-14,  1.976821492663876e-16, -2.391561441403936e-18,
  2.787259061748060e-20, -3.141368903503586e-22,  1.673492644752501e-02, -6.306262432919532e-04,  1.753686120120515e-05, -3.971726849915290e-07,  7.852963247924725e-09,
 -1.402504579881579e-10,  2.310620748959556e-12, -3.561550423239420e-14,  5.188095524198090e-16, -7.196067512703698e-18,  9.559080686156680e-20, -1.221518932598366e-21,
  7.849267568058975e-03, -4.019693661289325e-04,  1.391372200260679e-05, -3.822010854299892e-07,  8.996488458929651e-09, -1.887082357959837e-10,  3.613010547393783e-12,
 -6.416186275765532e-14,  1.068987307195052e-15, -1.685185485008447e-17,  2.530158253393026e-19, -3.636184268409645e-21,  3.276923045367523e-03, -2.204227226283435e-04,
  9.380250242734430e-06, -3.090893608672671e-07,  8.578969552948364e-09, -2.095315109540913e-10,  4.624971789854980e-12, -9.391796630072408e-14,  1.776918182453041e-15,
 -3.161970699211386e-17,  5.330562475852703e-19, -8.560736500675979e-21,  1.224464977767124e-03, -1.052273562111929e-04,  5.442504666660242e-06, -2.130875415764335e-07,
  6.918048750323098e-09, -1.953318247967862e-10,  4.937933119781300e-12, -1.139542585992968e-13,  2.434027706258173e-15, -4.861766572068014e-17,  9.153281416334034e-19,
 -1.634099025639675e-20,  4.124618518953280e-04, -4.425714723614266e-05,  2.751867317515463e-06, -1.269366360072318e-07,  4.786431610404844e-09, -1.552605559350824e-10,
  4.469603763640872e-12, -1.165983317622047e-13,  2.797572561508936e-15, -6.242276524478692e-17,  1.306427362381981e-18, -2.581081088732691e-20,  1.264052190689694e-04,
 -1.660748601311832e-05,  1.228568043451068e-06, -6.624283457038258e-08,  2.882291414409738e-09, -1.068008486822336e-10,  3.483195081833362e-12, -1.022258443774180e-13,
  2.742736689992549e-15, -6.807209952024424e-17,  1.577144604919389e-18, -3.434435906521130e-20,  3.565731906170193e-05, -5.638974523142675e-06,  4.913440433257237e-07,
 -3.073393825120321e-08,  1.533487309119057e-09, -6.455680471137623e-11,  2.373600852982954e-12, -7.801496913606115e-14,  2.330666668680185e-15, -6.407973265135004e-17,
  1.637129091086987e-18, -3.914561651262605e-20,  9.394846633479923e-06, -1.760839237075797e-06,  1.789430459970792e-07, -1.288737880162444e-08,  7.327741748890789e-10,
 -3.485645122361783e-11,  1.437701679164095e-12, -5.268009126931159e-14,  1.744884466764279e-15, -5.292872260181873e-17,  1.485290386027869e-18, -3.884862135528700e-20,
  2.354333294358717e-06, -5.153930644842711e-07,  6.048317619082708e-08, -4.976422539112802e-09,  3.203440775081639e-10, -1.711885187135407e-11,  7.879694800345533e-13,
 -3.203264116749287e-14,  1.170993295639795e-15, -3.901959012805508e-17,  1.197718046485863e-18, -3.412966739627841e-20,  5.736930014394596e-07, -1.446101529297257e-07,
  1.939670999239045e-08, -1.808092356636416e-09,  1.308289790006969e-10, -7.804399502736076e-12,  3.985645931463974e-13, -1.787894951450926e-14,  7.176882500528109e-16,
 -2.614357706094042e-17,  8.737183699139667e-19, -2.700286661797240e-20,  1.395426694038755e-07, -3.992263725256634e-08,  6.053511611187464e-09, -6.334396516259731e-10,
  5.110463670740632e-11, -3.378353873273768e-12,  1.901400668373193e-13, -9.353090559918496e-15,  4.098375194905727e-16, -1.622912743200866e-17,  5.873417094655037e-19,
 -1.958510834963475e-20,  3.490717714647990e-08, -1.116692078978148e-08,  1.891229077133366e-09, -2.198408352025001e-10,  1.959156298887150e-11, -1.422998878434902e-12,
  8.756511423361382e-14, -4.688267751080704e-15,  2.226727647600521e-16, -9.521060335731393e-18,  3.707439850391597e-19, -1.325604793869722e-20,  9.270139781102299e-09,
 -3.264200191466001e-09,  6.092064919804741e-10, -7.772676624914966e-11,  7.567736940153819e-12, -5.978255028406698e-13,  3.984070545625028e-14, -2.300982616831545e-15,
  1.174553165678965e-16, -5.379054998280344e-18,  2.236251230785872e-19, -8.510065933291339e-21,  2.691109115613223e-09, -1.025772397411877e-09,  2.077994574570517e-10,
 -2.869823938167435e-11,  3.013567281796076e-12, -2.558105283351216e-13,  1.825410394613388e-14, -1.125075789244000e-15,  6.109560195751073e-17, -2.967775625885099e-18,
  1.305064055623667e-19, -5.239017314455351e-21,  8.681169491540308e-10, -3.519474658335400e-10,  7.608905009577891e-11, -1.119483932290093e-11,  1.249000041706262e-12,
 -1.123275347866260e-13,  8.468488631425014e-15, -5.499822275561908e-16,  3.139085011856802e-17, -1.598883427396812e-18,  7.355899435965594e-20, -3.082533607892338e-21,
  3.031304042104635e-10, -1.283241778277145e-10,  2.906001847088297e-11, -4.474013399019400e-12,  5.213917344392226e-13, -4.888240135573472e-14,  3.834263971237801e-15,
 -2.585881905195663e-16,  1.529886490377510e-17, -8.063465197557346e-19,  3.832501049868360e-20, -1.656502526927342e-21,  9.215296518149928e-11, -3.996800974006061e-11,
  9.292249948019390e-12, -1.468040167131678e-12,  1.753859705082612e-13, -1.683817976406052e-14,  1.350997083169805e-15, -9.309832832387335e-17,  5.622166308086059e-18,
 -3.021688022460661e-19,  1.463146092430483e-20, -6.436792192279465e-22,  1.122870805411684e-01, -5.379738611612378e-04,  2.735696900392326e-06, -1.453387200301362e-08,
  7.933185795295773e-11, -4.396084288599974e-13,  2.449472513288329e-15, -1.366978931632542e-17,  7.603691786666111e-20, -4.219884123269608e-22,  2.326373556211122e-24,
 -1.280390725030674e-26,  9.784808977126598e-02, -6.612469205791730e-04,  5.495251703486445e-06, -4.589462966098054e-08,  3.701541425424208e-10, -2.884822251464544e-12,
  2.184791342870521e-14, -1.615732630625055e-16,  1.170803998336844e-18, -8.335009416188834e-21,  5.840515417516255e-23, -4.034779548034920e-25,  7.433212545753994e-02,
 -7.964150508819547e-04,  9.772304164849112e-06, -1.092489138546445e-07,  1.135868889208641e-09, -1.119344211002669e-11,  1.057050874333319e-13, -9.633946529380653e-16,
  8.517223592541892e-18, -7.332393581896103e-20,  6.165352415839081e-22, -5.075204136484021e-24,  4.926908919121513e-02, -8.230590234042218e-04,  1.351685685382380e-05,
 -1.921369656103650e-07,  2.488321670769622e-09, -3.006180334829342e-11,  3.435188466740639e-13, -3.747968908032020e-15,  3.931066429315435e-17, -3.983995456100890e-19,
  3.916983903139282e-21, -3.747564287484816e-23,  2.853253847046320e-02, -7.075552704767115e-04,  1.490816685950875e-05, -2.636787915342666e-07,  4.166422337544547e-09,
 -6.047730465297078e-11,  8.204272606882354e-13, -1.052392726339077e-14,  1.287194098363210e-16, -1.510638053405039e-18,  1.709358929473820e-20, -1.871920944384386e-22,
  1.446558336349420e-02, -5.074547978379488e-04,  1.344101682825669e-05, -2.912604304388809e-07,  5.530495185773014e-09, -9.510172666172636e-11,  1.511577785599814e-12,
 -2.251421102876031e-14,  3.173403380945761e-16, -4.263959599922731e-18,  5.492534413254122e-20, -6.812221610391568e-22,  6.438074023054608e-03, -3.068171975398940e-04,
  1.008016983294957e-05, -2.642870488207117e-07,  5.961757130160876e-09, -1.201866693635568e-10,  2.216484541795997e-12, -3.798273927563446e-14,  6.115799477168006e-16,
 -9.329644950141625e-18,  1.357054481777358e-19, -1.891355239766933e-21,  2.524744244501912e-03, -1.581668476118226e-04,  6.373812625624003e-06, -2.001105840042473e-07,
  5.314552855749386e-09, -1.245843450358770e-10,  2.645763311272042e-12, -5.179310357197956e-14,  9.462182556525617e-16, -1.628181631215990e-17,  2.657567228014969e-19,
 -4.136948671356464e-21,  8.767528799509831e-04, -7.029368969290675e-05,  3.438902013555000e-06, -1.281577657432108e-07,  3.977511688504245e-09, -1.077041350531122e-10,
  2.617795598299985e-12, -5.820462760229495e-14,  1.199930641349659e-15, -2.316824116067455e-17,  4.222113007974518e-19, -7.304925183949879e-21,  2.713845663918865e-04,
 -2.723624175768709e-05,  1.601886292162331e-06, -7.031851579295622e-08,  2.534105758156015e-09, -7.881523933015407e-11,  2.181129766818232e-12, -5.481572915072717e-14,
  1.269387478242013e-15, -2.738117569104260e-17,  5.547617556378108e-19, -1.062417618025700e-20,  7.552271889463080e-05, -9.311638139305578e-06,  6.522932543555829e-07,
 -3.349221952768755e-08,  1.393418533204379e-09, -4.952687619618065e-11,  1.553436876090215e-12, -4.394133226391208e-14,  1.138434507585818e-15, -2.732864430883192e-17,
  6.133092666259974e-19, -1.295395325266345e-20,  1.910810460889995e-05, -2.847514230466383e-06,  2.354541127028283e-07, -1.404657529328641e-08,  6.709997259104628e-10,
 -2.712690620812448e-11,  9.602423963624035e-13, -3.045094321100385e-14,  8.793539255233833e-16, -2.340884950028319e-17,  5.799048169292456e-19, -1.346352705054497e-20,
  4.459447334879994e-06, -7.914725163084406e-07,  7.656919227910443e-08, -5.272352982673300e-09,  2.876161625501062e-10, -1.316332775602912e-11,  5.236415096377617e-13,
 -1.854358180394442e-14,  5.946798919841403e-16, -1.749350538181925e-17,  4.767531543500808e-19, -1.212651938977233e-20,  9.778634798599243e-07, -2.038611119373202e-07,
  2.286856137294480e-08, -1.805063647455085e-09,  1.118104167795109e-10, -5.764325513280766e-12,  2.565391408022052e-13, -1.010293960696646e-14,  3.583965749617387e-16,
 -1.160678377235614e-17,  3.467402876380798e-19, -9.628590757512570e-21,  2.061937466762405e-07, -4.981340120142751e-08,  6.418879064802747e-09, -5.764786822630477e-10,
  4.029170164616793e-11, -2.326896013417823e-12,  1.152708641523043e-13, -5.024650210932924e-15,  1.963007079445919e-16, -6.969243037204426e-18,  2.272913444562844e-19,
 -6.863331647644120e-21,  4.301654617650328e-08, -1.187711770198062e-08,  1.740204059297615e-09, -1.763380309641966e-10,  1.380561320079180e-11, -8.873068891914550e-13,
  4.863502312273799e-14, -2.333438767095074e-15,  9.986519296425511e-17, -3.867228115075965e-18,  1.370225490129660e-19, -4.478082439062394e-21,  9.183541811364654e-09,
 -2.855936792819649e-09,  4.703668597280342e-10, -5.325393290760562e-11,  4.629777002615438e-12, -3.285444580160807e-13,  1.977946402036362e-14, -1.037365927334647e-15,
  4.831899241984647e-17, -2.028245782737398e-18,  7.760872121852078e-20, -2.729288236067529e-21,  2.083344052433523e-09, -7.183287194654005e-10,  1.312481063117108e-10,
 -1.641045390416536e-11,  1.567603701737748e-12, -1.216319029561910e-13,  7.969904565574012e-15, -4.530105479831318e-16,  2.277822102235564e-17, -1.028392245531981e-18,
  4.217992949369592e-20, -1.584765360063847e-21,  5.213765511666903e-10, -1.959292991669231e-10,  3.911296595122572e-11, -5.326166209835932e-12,  5.518825293043050e-13,
 -4.626094769374022e-14,  3.262084881939675e-15, -1.988124148891303e-16,  1.068235092308189e-17, -5.137267518518564e-19,  2.237734424822643e-20, -8.902794703677340e-22,
  1.478105779913162e-10, -5.942627532586701e-11,  1.273505569657169e-11, -1.857801968829641e-12,  2.056017979196041e-13, -1.834935028814478e-14,  1.373382906512078e-15,
 -8.858438515460422e-17,  5.023370762209961e-18, -2.542979650275535e-19,  1.163150939358121e-20, -4.847516292118178e-22,  4.675069322609189e-11, -1.971350967530275e-11,
  4.445523115210514e-12, -6.816175329977458e-13,  7.912270295714478e-14, -7.390370133074892e-15,  5.776362363622711e-16, -3.882562425994004e-17,  2.289710663908973e-18,
 -1.203163420983625e-19,  5.702066143495616e-21, -2.457840997253168e-22,  1.340033367608664e-11, -5.804252391207061e-12,  1.347492762061282e-12, -2.125794610128521e-13,
  2.536148437952698e-14, -2.431606589219026e-15,  1.948468264190208e-16, -1.341045463154130e-17,  8.088893121509662e-19, -4.342491157524257e-20,  2.100390458876967e-21,
 -9.230479802185829e-23,  1.101778812804919e-01, -5.167649816283656e-04,  2.568626155677928e-06, -1.333183087563542e-08,  7.109792336213180e-11, -3.851526094178245e-13,
  2.098621089493378e-15, -1.146275938982523e-17,  6.239303295959189e-20, -3.392815841037438e-22,  1.830198212370973e-24, -9.885100193309378e-27,  9.528767470656177e-02,
 -6.193913744216541e-04,  4.978235221210601e-06, -4.040671067005216e-08,  3.173555080824904e-10, -2.410789272617301e-12,  1.780629752939282e-14, -1.284901456545828e-16,
  9.088468920108713e-19, -6.318198918217303e-21,  4.324615965780963e-23, -2.919304932351276e-25,  7.129493402031487e-02, -7.231877709759204e-04,  8.563395647545214e-06,
 -9.273676999846224e-08,  9.353336953484802e-10, -8.951701423257018e-12,  8.218048858895595e-14, -7.287229057858184e-16,  6.272506823784202e-18, -5.260520761987418e-20,
  4.311272614017529e-22, -3.460707280710867e-24,  4.617941913129090e-02, -7.235128703940472e-04,  1.143161069438179e-05, -1.567190418096506e-07,  1.961711829795421e-09,
 -2.294676719872473e-11,  2.542290216381896e-13, -2.692218892296285e-15,  2.743208545965735e-17, -2.702949044215789e-19,  2.585452605771199e-21, -2.408035727499246e-23,
  2.592229536694629e-02, -5.998986910567114e-04,  1.210729346267862e-05, -2.057149797266426e-07,  3.132118774731284e-09, -4.390354245857332e-11,  5.761031793663754e-13,
 -7.157643978096901e-15,  8.488911638664143e-17, -9.669366664142704e-19,  1.062826856107642e-20, -1.131441826078702e-22,  1.263063270196488e-02, -4.125356038690474e-04,
  1.041989733998609e-05, -2.162130550206576e-07,  3.945556542012178e-09, -6.536914262750720e-11,  1.002986364684996e-12, -1.444372421927124e-14,  1.970934199941397e-16,
 -2.566668681004167e-18,  3.207480295839984e-20, -3.862735151939945e-22,  5.354072237958805e-03, -2.374055713500777e-04,  7.410192944106324e-06, -1.855639509275462e-07,
  4.014071939144107e-09, -7.781832150210542e-11,  1.383085559613126e-12, -2.288201218832926e-14,  3.562259093756442e-16, -5.260802980673238e-18,  7.416188486430481e-20,
 -1.002734336787039e-21,  1.980666095461217e-03, -1.155052695711568e-04,  4.410419865844037e-06, -1.319989512278675e-07,  3.356008339971375e-09, -7.554317339034973e-11,
  1.544140070481219e-12, -2.915073035297956e-14,  5.144170759704643e-16, -8.562104979971255e-18,  1.353469114822924e-19, -2.042727323272267e-21,  6.421970123590549e-04,
 -4.799616051958607e-05,  2.221477242600289e-06, -7.882151778594918e-08,  2.339225020971369e-09, -6.076285799355418e-11,  1.420290379485162e-12, -3.043191655859190e-14,
  6.056405229745314e-16, -1.130558778057029e-17,  1.994559793203588e-19, -3.344803112864949e-21,  1.835611983261922e-04, -1.721077583088355e-05,  9.572834896245456e-07,
 -3.998865562509367e-08,  1.377299927381378e-09, -4.107375140274793e-11,  1.092731449540336e-12, -2.645747680334915e-14,  5.913480821629728e-16, -1.233096681468603e-17,
  2.418562224817033e-19, -4.489574368415399e-21,  4.661763250662895e-05, -5.385840884232716e-06,  3.570416400484875e-07, -1.745057580265308e-08,  6.940023993666858e-10,
 -2.365593126062238e-11,  7.134286208188034e-13, -1.944644105135815e-14,  4.864087499243464e-16, -1.129148734690477e-17,  2.454058714135188e-19, -5.026403111514721e-21,
  1.062980911245757e-05, -1.489940025868108e-06,  1.167901391031061e-07, -6.640015373477182e-09,  3.034883690286065e-10, -1.177616492664062e-11,  4.011343078097676e-13,
 -1.226772846952076e-14,  3.422963548364707e-16, -8.818918816008600e-18,  2.117540118197023e-19, -4.771593707267321e-21,  2.206711193459901e-06, -3.700740438277082e-07,
  3.403295284601787e-08, -2.237984485081671e-09,  1.170182239659475e-10, -5.148481987467644e-12,  1.973776321664216e-13, -6.750423787111265e-15,  2.094593753979038e-16,
 -5.971530887474467e-18,  1.579550413846099e-19, -3.904784992134189e-21,  4.247657187527494e-07, -8.412912067325948e-08,  9.004932415615599e-09, -6.808711540198958e-10,
  4.053140435760397e-11, -2.013596801650815e-12,  8.655613136870437e-14, -3.299025241495201e-15,  1.134658465214589e-16, -3.568314095853648e-18,  1.036629756427624e-19,
 -2.803014305238278e-21,  7.763087465061184e-08, -1.792863307754757e-08,  2.214907381218191e-09, -1.913174370340765e-10,  1.289642453370749e-11, -7.200387925497456e-13,
  3.455667401334652e-14, -1.462014733063389e-15,  5.552820001457132e-17, -1.919390148533111e-18,  6.102761706430169e-20, -1.798820008229850e-21,  1.388322129794311e-08,
 -3.689920527558620e-09,  5.212730660709269e-10, -5.105454822151268e-11,  3.872229844025351e-12, -2.415919851619937e-13,  1.287801386704328e-14, -6.018540970319340e-16,
  2.512680744339443e-17, -9.504404459177604e-19,  3.293380383910647e-20, -1.053804915631859e-21,  2.521405745179391e-09, -7.604357949147075e-10,  1.215360493135294e-10,
 -1.337655357826422e-11,  1.132534639288991e-12, -7.839697451688571e-14,  4.610862699154769e-15, -2.365648319044937e-16,  1.079247674749684e-17, -4.442186412316872e-19,
  1.668426033361028e-20, -5.764897835707681e-22,  4.856787344626985e-10, -1.636432942836084e-10,  2.921645807983999e-11, -3.573762318533774e-12,  3.344060873702270e-13,
 -2.544812375744194e-14,  1.637305725206631e-15, -9.147682079042003e-17,  4.525524106359557e-18, -2.012058767752808e-19,  8.133487247946299e-21, -3.014161587084011e-22,
  1.038949523729920e-10, -3.843292318423012e-11,  7.549290837300064e-12, -1.012239093399120e-12,  1.033634555818592e-13, -8.545800336131872e-15,  5.948358229548604e-16,
 -3.581219991654215e-17,  1.902122190621352e-18, -9.048241155700392e-20,  3.900830125348729e-21, -1.536875438757037e-22,  2.563389937514646e-11, -1.021032513142557e-11,
  2.166784721635912e-12, -3.131251310651023e-13,  3.434446416101499e-14, -3.039313425470109e-15,  2.256717271945137e-16, -1.444665597615090e-17,  8.134133503717215e-19,
 -4.090098515778501e-20,  1.858913040537369e-21, -7.700650386183348e-23,  7.277696345867900e-12, -3.055391852962025e-12,  6.857881023387570e-13, -1.046710848632264e-13,
  1.209749507730107e-14, -1.125290164885089e-15,  8.760937970525846e-17, -5.866809255136201e-18,  3.447750637111496e-19, -1.805638135307896e-20,  8.530280021158037e-22,
 -3.665916175364682e-23,  1.954946253198010e-12, -8.455474075597760e-13,  1.959888135233469e-13, -3.087075777000197e-14,  3.677421494026799e-15, -3.520706318418920e-16,
  2.817234378253709e-17, -1.936382166588057e-18,  1.166482828155402e-19, -6.254498070260602e-21,  3.021615710963963e-22, -1.326388599009017e-23,  1.081509327048344e-01,
 -4.968371298080443e-04,  2.415223960962557e-06, -1.225325712361183e-08,  6.387366258048759e-11, -3.384223782049323e-13,  1.803875729834041e-15, -9.648287706504827e-18,
  5.139821941530517e-20, -2.740784719599193e-22,  1.445999924355104e-24, -7.679665281910491e-27,  9.288680727859637e-02, -5.814222134525025e-04,  4.522301709227246e-06,
 -3.569269609171641e-08,  2.731379526174617e-10, -2.023523255879136e-12,  1.458378519615776e-14, -1.027360399407050e-16,  7.096670508202093e-19, -4.819983882177247e-21,
  3.224007839672086e-23, -2.127627287207652e-25,  6.853249133810162e-02, -6.588905032028842e-04,  7.534767429890987e-06, -7.910309041864204e-08,  7.744804464502222e-10,
 -7.203177045471756e-12,  6.432374176963700e-14, -5.552512925482002e-16,  4.655670744572735e-18, -3.805648767491566e-20,  3.041457592099150e-22, -2.381814677470709e-24,
  4.345707265183351e-02, -6.390817588626129e-04,  9.725169553563753e-06, -1.286955744673204e-07,  1.558162438608166e-09, -1.765898739317999e-11,  1.898047802986882e-13,
 -1.952023528617999e-15,  1.933334647815768e-17, -1.853034955165936e-19,  1.725301472644509e-21, -1.565046038061634e-23,  2.370190347137710e-02, -5.121248959312510e-04,
  9.912680495570566e-06, -1.619374107138163e-07,  2.377539027590727e-09, -3.220453025705723e-11,  4.090194919155746e-13, -4.924928979248429e-15,  5.666773171319899e-17,
 -6.268095514693669e-19,  6.695818777747028e-21, -6.932493273641289e-23,  1.113217047501602e-02, -3.385729583488625e-04,  8.164860021907011e-06, -1.623610136662604e-07,
  2.849482811581783e-09, -4.551515436792172e-11,  6.745591250461131e-13, -9.397314200293343e-15,  1.242068987540657e-16, -1.568422013920031e-18,  1.902339163803096e-20,
 -2.225450403584589e-22,  4.510309180299670e-03, -1.860468308102846e-04,  5.522714566081280e-06, -1.321829057115924e-07,  2.743732406940533e-09, -5.118098729221875e-11,
  8.771382887300332e-13, -1.401687376459648e-14,  2.110786900651692e-16, -3.019035693280650e-18,  4.126318642162947e-20, -5.414444704970681e-22,  1.580332080696321e-03,
 -8.574802320248267e-05,  3.104588217765335e-06, -8.862352828400605e-08,  2.158152723657404e-09, -4.666971156933570e-11,  9.185821449403441e-13, -1.672990972938414e-14,
  2.852739859205840e-16, -4.594342835312228e-18,  7.035702623910478e-20, -1.029801898476314e-21,  4.805556406579450e-04, -3.345312660422695e-05,  1.465374186781032e-06,
 -4.951855448068138e-08,  1.405720064403400e-09, -3.503840911439407e-11,  7.878468333487548e-13, -1.627179196548643e-14,  3.126852860892315e-16, -5.644367841170661e-18,
  9.641934780293908e-20, -1.567446830407131e-21,  1.274523680063904e-04, -1.115162295987630e-05,  5.865415632522989e-07, -2.331680562897888e-08,  7.676009459796411e-10,
 -2.195148098253222e-11,  5.614749003389143e-13, -1.309817917423001e-14,  2.825784814254529e-16, -5.696518844469775e-18,  1.081654520863112e-19, -1.946261469662139e-21,
  2.968641043678602e-05, -3.209085083176285e-06,  2.012206033243763e-07, -9.358882790302646e-09,  3.557143853078529e-10, -1.162602797043955e-11,  3.370845405102144e-13,
 -8.852792439217368e-15,  2.137516714318703e-16, -4.797761707187715e-18,  1.009675011822869e-19, -2.005101973833357e-21,  6.130658269227904e-06, -8.067930501991847e-07,
  5.989428210016512e-08, -3.243083345333091e-09,  1.417502529469320e-10, -5.276846661600161e-12,  1.728980696247354e-13, -5.097476997286411e-15,  1.373764190114040e-16,
 -3.424286452029214e-18,  7.966669717731673e-20, -1.741766930125661e-21,  1.137247136791437e-06, -1.798296260408426e-07,  1.569902670458943e-08, -9.848805442100600e-10,
  4.931628404567807e-11, -2.084294462191943e-12,  7.695361988175987e-14, -2.540143607473772e-15,  7.621570237147094e-17, -2.104615020109560e-18,  5.400209749497515e-20,
 -1.296764427178068e-21,  1.928747326008762e-07, -3.620477903084374e-08,  3.691259407649174e-09, -2.669801885970090e-10,  1.525525585296333e-11, -7.295421467247756e-13,
  3.026029355942762e-14, -1.115226656991497e-15,  3.715684865882694e-17, -1.133806243271326e-18,  3.200631644606528e-20, -8.420960750385752e-22,  3.062317996793803e-08,
 -6.743314335241383e-09,  7.970626695487679e-10, -6.610313373078627e-11,  4.291093938832846e-12, -2.313105320058683e-13,  1.074165020880172e-14, -4.405853857189112e-16,
  1.625083159863004e-17, -5.463559265101607e-19,  1.691966362955039e-20, -4.863720662259360e-22,  4.695822298241210e-09, -1.198207561856823e-09,  1.628459969537359e-10,
 -1.538633064409816e-11,  1.128590724176376e-12, -6.824789320127875e-14,  3.532894423937610e-15, -1.606192446957751e-16,  6.533406438265746e-18, -2.411178560782525e-19,
  8.162052633016451e-21, -2.554401359080432e-22,  7.237400184957106e-10, -2.111438927622795e-10,  3.267441180388197e-11, -3.489081415237724e-12,  2.871719470657650e-13,
 -1.935961667414225e-14,  1.110687709715869e-15, -5.566831768935118e-17,  2.484292486248548e-18, -1.001441760429940e-19,  3.687754170861967e-21, -1.250623667214480e-22,
  1.177178075186622e-10, -3.867354814485124e-11,  6.733145494641075e-12, -8.042368271064309e-13,  7.359248885624905e-14, -5.484210923642724e-15,  3.459690553298937e-16,
 -1.897450766335888e-17,  9.224444475503521e-19, -4.034089053870873e-20,  1.605472106943091e-21, -5.862515435946487e-23,  2.134392228286530e-11, -7.758915120628443e-12,
  1.497173537736477e-12, -1.973666547417113e-13,  1.983370370124382e-14, -1.615283343560056e-15,  1.108511119779038e-16, -6.585371930077074e-18,  3.454028892083076e-19,
 -1.623664752795154e-20,  6.921769141373881e-22, -2.698355495511104e-23,  4.536394280221419e-12, -1.788170883939893e-12,  3.753714166116922e-13, -5.368080337346976e-14,
  5.829799209220562e-15, -5.111076533808253e-16,  3.761732903503258e-17, -2.388204540927004e-18,  1.334176656583510e-19, -6.659224582291703e-21,  3.005476333565392e-22,
 -1.236850084253901e-23,  1.144707634039264e-12, -4.782280123109813e-13,  1.067787979874771e-13, -1.621494889901216e-14,  1.865015027930143e-15, -1.726870136288960e-16,
  1.338633330598094e-17, -8.927525191927686e-19,  5.226116696202530e-20, -2.726954935714673e-21,  1.283803089856261e-22, -5.499049593041649e-24,  2.862206017905696e-13,
 -1.235986410036202e-13,  2.859917433509920e-14, -4.497036093869321e-15,  5.348161175402850e-16, -5.112125540538166e-17,  4.084456256150731e-18, -2.803302650238989e-19,
  1.686365613615175e-20, -9.029958853403350e-22,  4.356889156860938e-23, -1.910188497650648e-24,  1.062013203894349e-01, -4.780866203884651e-04,  2.274100764719381e-06,
 -1.128316246978627e-08,  5.751718611967912e-11, -2.981940630020221e-13,  1.555342682187186e-15, -8.150879578192832e-18,  4.249592619946645e-20, -2.224710983938470e-22,
  1.146517010436115e-24, -6.009716581857114e-27,  9.063086358699697e-02, -5.468857125445788e-04,  4.118934110596003e-06, -3.162816916328623e-08,  2.359472035040483e-10,
 -1.705617430673672e-12,  1.200069508044854e-14, -8.257131547019961e-17,  5.572711348798886e-19, -3.699574757261413e-21,  2.419191808763382e-23, -1.561532013515077e-25,
  6.601175739048672e-02, -6.022090823679669e-04,  6.655384326489696e-06, -6.778503198273412e-08,  6.446772170753998e-10, -5.830323540740276e-12,  5.067210903995325e-14,
 -4.260328611938880e-16,  3.481543790544885e-18, -2.775166178726708e-20,  2.163835972999031e-22, -1.653916848327290e-24,  4.104713233022488e-02, -5.670592908727894e-04,
  8.319505146178311e-06, -1.063603080275143e-07,  1.246445426320468e-09, -1.369536224280350e-11,  1.428942963607832e-13, -1.428010204296480e-15,  1.375499279466858e-17,
 -1.283085495983334e-19,  1.163407132950396e-21, -1.028327215044908e-23,  2.180055206750888e-02, -4.399954614126152e-04,  8.178028241164699e-06, -1.285595984230378e-07,
  1.821420174707864e-09, -2.385706772048406e-11,  2.934530011020257e-13, -3.426336965668092e-15,  3.826962055911957e-17, -4.112711540963736e-19,  4.271780820117408e-21,
 -4.303370425433993e-23,  9.897186647816020e-03, -2.803362291845918e-04,  6.462661191740276e-06, -1.232540904198132e-07,  2.081878293216985e-09, -3.208145996407534e-11,
  4.595364584736871e-13, -6.196460634690447e-15,  7.937040564114057e-17, -9.723096225908563e-19,  1.145135355949144e-20, -1.301877987702997e-22,  3.845399030389108e-03,
 -1.475345733981851e-04,  4.169509441557827e-06, -9.544924831985872e-08,  1.902392112774635e-09, -3.416616920677498e-11,  5.649172064090719e-13, -8.724159040020001e-15,
  1.271393180054854e-16, -1.761924949598267e-18,  2.335720228239769e-20, -2.975492220182635e-22,  1.281022137124877e-03, -6.464210661901522e-05,  2.220972201924401e-06,
 -6.050489993954377e-08,  1.412021709561449e-09, -2.934883483852835e-11,  5.564962077146816e-13, -9.782069432819449e-15,  1.612377577589595e-16, -2.513477283872414e-18,
  3.730040937853433e-20, -5.296272582739700e-22,  3.669028502007015e-04, -2.377194568474560e-05,  9.859241151478194e-07, -3.174255942590469e-08,  8.622645917913514e-10,
 -2.063087576203756e-11,  4.463883783484454e-13, -8.889436889518054e-15,  1.649858357140428e-16, -2.880622442205278e-18,  4.765641521254460e-20, -7.511655368938970e-22,
  9.071454911280709e-05, -7.398871128660880e-06,  3.680120621738873e-07, -1.392373876059808e-08,  4.381920947488773e-10, -1.201858407329639e-11,  2.955972621335498e-13,
 -6.644809638539133e-15,  1.383859487035761e-16, -2.697233715198335e-18,  4.958472801530617e-20, -8.648649936111842e-22,  1.947476740020407e-05, -1.966976388832787e-06,
  1.166124877893745e-07, -5.160232198403348e-09,  1.874226022957770e-10, -5.873086847339510e-12,  1.636966042334008e-13, -4.141923585762078e-15,  9.653088202037585e-17,
 -2.094779338639228e-18,  4.268247870312226e-20, -8.217529309901243e-22,  3.660766902227343e-06, -4.515158491688120e-07,  3.171902999347832e-08, -1.634775456589092e-09,
  6.830128138985030e-11, -2.438428497205196e-12,  7.682694832456419e-14, -2.182915376938467e-15,  5.680481080425928e-17, -1.369502747398058e-18,  3.086285499579501e-20,
 -6.544949140174844e-22,  6.097183086224471e-07, -9.071646595027909e-08,  7.508405005248451e-09, -4.489529200366621e-10,  2.151200515184692e-11, -8.727697334956528e-13,
  3.101388753481832e-14, -9.874973739894284e-16,  2.863567120340393e-17, -7.655179930592939e-19,  1.904443948829110e-20, -4.440124640999375e-22,  9.148994606087121e-08,
 -1.623720156894622e-08,  1.574230561883507e-09, -1.087717078959617e-10,  5.959102653960507e-12, -2.740498372178866e-13,  1.095865564716772e-14, -3.901990555723247e-16,
  1.258395345753337e-17, -3.723021483420294e-19,  1.020514488037294e-20, -2.610786030690437e-22,  1.265686954390849e-08, -2.650392555947432e-09,  2.991335108501166e-10,
 -2.377930511483020e-11,  1.484382916600169e-12, -7.715264495055564e-14,  3.462680369331631e-15, -1.375421077865095e-16,  4.921761040527181e-18, -1.607873775159669e-19,
  4.845327165135048e-21, -1.357174722776357e-22,  1.665927349314806e-09, -4.069775080379255e-10,  5.309272429099019e-11, -4.829958865378992e-12,  3.420412882158418e-13,
 -2.001678816263842e-14,  1.004845635341439e-15, -4.438387115694985e-17,  1.756853455543737e-18, -6.318757240711924e-20,  2.087308658137283e-21, -6.382693255894401e-23,
  2.175449197672283e-10, -6.122787940252572e-11,  9.152843144420984e-12, -9.463121949802854e-13,  7.557734608198788e-14, -4.953688937354133e-15,  2.768032038724697e-16,
 -1.353380394062284e-17,  5.900176252650019e-19, -2.326476361045274e-20,  8.389893499836111e-22, -2.789493500286948e-23,  2.973281540957184e-11, -9.501305417924516e-12,
  1.609584523792224e-12, -1.873671840475100e-13,  1.673666406484789e-14, -1.219381652022554e-15,  7.531113423212341e-17, -4.048929923237515e-18,  1.931790276177802e-19,
 -8.299923961837414e-21,  3.248337175121225e-22, -1.167542347938961e-23,  4.531734418425549e-12, -1.615779001865479e-12,  3.057292784599699e-13, -3.955880198450944e-14,
  3.906240426461777e-15, -3.129362317503764e-16,  2.114627222851547e-17, -1.238116601211158e-18,  6.405653015926923e-20, -2.972551448093401e-21,  1.251868182349133e-22,
 -4.824464868791704e-24,  8.208846218645602e-13, -3.198230767882250e-13,  6.632839463435701e-14, -9.375846108323780e-15,  1.007108435006517e-15, -8.738680839978267e-17,
  6.369398232843236e-18, -4.006891121511689e-19,  2.219247497999352e-20, -1.098718119111572e-21,  4.920897309020747e-23, -2.010517067737625e-24,  1.821369104257863e-13,
 -7.567302950853339e-14,  1.679756594926766e-14, -2.536375840257939e-15,  2.901608992756871e-16, -2.673020237679077e-17,  2.062119932726770e-18, -1.369021036378109e-19,
  7.979845938003880e-21, -4.146980310481783e-22,  1.944850702509194e-23, -8.300459444703680e-25,  4.206940651800661e-14, -1.813496934809413e-14,  4.188195103118194e-15,
 -6.573299835895393e-16,  7.803232277661379e-17, -7.445904979617261e-18,  5.939217384709096e-19, -4.069826656383546e-20,  2.444550658494361e-21, -1.307083173343042e-22,
  6.297834355143696e-24, -2.757498959833028e-25,  1.043245235049293e-01, -4.604202018470827e-04,  2.144034021069117e-06, -1.040864529861708e-08,  5.190886478176247e-11,
 -2.634579650828676e-13,  1.345012444120670e-15, -6.910795091937665e-18,  3.525239856939283e-20, -1.815015402431835e-22,  9.111357721444715e-25, -4.748649953262202e-27,
  8.850690725088262e-02, -5.153907087695911e-04,  3.760969931720783e-06, -2.811101512783798e-08,  2.045376653212811e-10, -1.443446321710797e-12,  9.919591239176495e-15,
 -6.669547597203431e-17,  4.399686584379945e-19, -2.856343848447367e-21,  1.826602839933094e-23, -1.153848975891413e-25,  6.370449193716081e-02, -5.520527891413240e-04,
  5.900208419590619e-06, -5.834081244593487e-08,  5.393271623699654e-10, -4.745617450911281e-12,  4.016386259547954e-14, -3.290704406810167e-16,  2.622221642775807e-18,
 -2.039209016450855e-20,  1.551959660246330e-22, -1.158301241820046e-24,  3.890437650198780e-02, -5.052891817226883e-04,  7.154369752703906e-06, -8.843485648686438e-08,
  1.003834129913603e-09, -1.069994005732856e-11,  1.084370952906632e-13, -1.053589942463118e-15,  9.874965900705984e-18, -8.969422646575265e-20,  7.923973780239319e-22,
 -6.827727938425726e-24,  2.016230270565638e-02, -3.802805989351463e-04,  6.795579784794038e-06, -1.028816371203279e-07,  1.407597754184898e-09, -1.783964898963032e-11,
  2.126498523904288e-13, -2.408998791735932e-15,  2.613238858653629e-17, -2.729883816333261e-19,  2.758312545078324e-21, -2.704905743755494e-23,  8.870616719749907e-03,
 -2.340300089694000e-04,  5.164090143739498e-06, -9.453204779707337e-08,  1.537840976029267e-09, -2.287703123927584e-11,  3.169022383253212e-13, -4.138353626231776e-15,
  5.139703138400028e-17, -6.111123157971983e-19,  6.991918740984788e-21, -7.728185531312358e-23,  3.315386357729698e-03, -1.182901389019195e-04,  3.186376102155179e-06,
 -6.981638432852541e-08,  1.337011328741134e-09, -2.313248131034479e-11,  3.692147653871353e-13, -5.513071419808163e-15,  7.778873247615477e-17, -1.044953505371337e-18,
  1.344142662130418e-20, -1.663007428978370e-22,  1.053879716636494e-03, -4.943481305994281e-05,  1.613216547210889e-06, -4.196630883957653e-08,  9.391109484378841e-10,
 -1.877100414334624e-11,  3.430460170879802e-13, -5.822392907444545e-15,  9.280622704399565e-17, -1.400846283387426e-18,  2.015251054448720e-20, -2.776706440522084e-22,
  2.854714829987293e-04, -1.720161723414119e-05,  6.758521358593769e-07, -2.074017936788530e-08,  5.393388999041742e-10, -1.239192471541085e-11,  2.580986406406026e-13,
 -4.957409449280259e-15,  8.889028741953169e-17, -1.501551767227280e-18,  2.406382255247362e-20, -3.678381230945821e-22,  6.609604493041471e-05, -5.019970903387910e-06,
  2.361565413919812e-07, -8.505463523551178e-09,  2.559432502692387e-10, -6.734178829031430e-12,  1.592931095616807e-13, -3.451091847250894e-15,  6.939270044718638e-17,
 -1.307837440281457e-18,  2.327993274262184e-20, -3.936489809062947e-22,  1.314221998930524e-05, -1.238501978151896e-06,  6.940312832379926e-08, -2.921644471860749e-09,
  1.014003212947408e-10, -3.046441802403275e-12,  8.162604094256646e-14, -1.989789125122581e-15,  4.476073559677659e-17, -9.390703837385829e-19,  1.852501486957137e-20,
 -3.457495224334933e-22,  2.260015986727685e-06, -2.608003786796190e-07,  1.732479266756609e-08, -8.495166457131787e-10,  3.391564177643473e-11, -1.160886351757046e-12,
  3.516189991612547e-14, -9.626128782327861e-16,  2.418198409983606e-17, -5.637558591015173e-19,  1.230358140734721e-20, -2.530215877685783e-22,  3.396599952765005e-07,
 -4.745166139505153e-08,  3.719274757329224e-09, -2.117810452256593e-10,  9.703870370567331e-12, -3.777104914906235e-13,  1.291137749947611e-14, -3.963598807027783e-16,
  1.110309870994681e-17, -2.872218742290295e-19,  6.924938110176139e-21, -1.566871759789074e-22,  4.529914077937704e-08, -7.582831663126571e-09,  6.979836422298831e-10,
 -4.601477185864021e-11,  2.414541692770578e-12, -1.066851931531177e-13,  4.109388441753456e-15, -1.412577129139206e-16,  4.406414118565945e-18, -1.263120304239519e-19,
  3.359772319749658e-21, -8.352421144121039e-23,  5.479934281595002e-09, -1.088318797059309e-09,  1.170545193424420e-10, -8.904815184233723e-12,  5.337872661983026e-13,
 -2.671855591686081e-14,  1.157634594197868e-15, -4.448430666211703e-17,  1.542794219355086e-18, -4.892956945478525e-20,  1.433566617239215e-21, -3.909335691765466e-23,
  6.202803240909509e-10, -1.446633010347055e-10,  1.807411419812618e-11, -1.580084242154224e-12,  1.078488128481200e-13, -6.098671622682592e-15,  2.964844802964025e-16,
 -1.270663371626134e-17,  4.888665192086864e-19, -1.711612096442889e-20,  5.511687579786606e-22, -1.645098646606784e-23,  6.857982320587438e-11, -1.856795683379684e-11,
  2.674868061412940e-12, -2.672038762375980e-13,  2.066864197810810e-14, -1.314903786135635e-15,  7.145094964124352e-17, -3.403024300445694e-18,  1.447369664182327e-19,
 -5.575447950366849e-21,  1.966742183937343e-22, -6.403799417804945e-24,  7.843634188762567e-12, -2.431679012655326e-12,  3.999006936140019e-13, -4.527325097902737e-14,
  3.940272529111999e-15, -2.801835375121200e-16,  1.691510326225250e-17, -8.901666860661013e-19,  4.162494226631532e-20, -1.754803487350878e-21,  6.745773736509812e-23,
 -2.383920486440406e-24,  9.969958366908018e-13, -3.479228032147749e-13,  6.442598148234775e-14, -8.167442450329100e-15,  7.911711800825972e-16, -6.225320638283169e-17,
  4.136383635809201e-18, -2.383835167446713e-19,  1.215108141363069e-20, -5.560234633549055e-22,  2.310892449743323e-23, -8.795437490960453e-25,  1.522320363780049e-13,
 -5.853891947462335e-14,  1.197747317805922e-14, -1.671344674307898e-15,  1.773551965564615e-16, -1.521410081686229e-17,  1.097070596359354e-18, -6.832211351317814e-20,
  3.748329256799322e-21, -1.839235308153340e-22,  8.168396896663749e-24, -3.310974890906129e-25,  2.935496485888465e-14, -1.212052282204830e-14,  2.672818998812032e-15,
 -4.010322238217357e-16,  4.560262575711365e-17, -4.177210430002111e-18,  3.205337629567875e-19, -2.117288715239634e-20,  1.228287302981319e-21, -6.354619281902874e-23,
  2.967592503754780e-24, -1.261495487311885e-25,  6.210203333929457e-15, -2.671842662541225e-15,  6.157490943552484e-16, -9.644067170872953e-17,  1.142577270427925e-17,
 -1.088180341348081e-18,  8.664088836962547e-20, -5.926747063581245e-21,  3.554029017528642e-22, -1.897314166955373e-23,  9.127924746590611e-25, -3.990906210426959e-26,
  1.025163756038362e-01, -4.437538148203829e-04,  2.023945153173670e-06, -9.618566412612824e-09,  4.694746884448396e-11, -2.333780166675748e-13,  1.166368841691401e-15,
 -5.880619726403786e-18,  2.932675244937298e-20, -1.489375517308298e-22,  7.238891323863339e-25, -3.810747315627952e-27,  8.650345924951101e-02, -4.865987568367528e-04,
  3.442360923299317e-06, -2.505703623470745e-08,  1.779060119894420e-10, -1.226285092215122e-12,  8.234716032282613e-15, -5.413007389407899e-17,  3.491550371902933e-19,
 -2.217853110901684e-21,  1.387340696703933e-23, -8.582907012050204e-26,  6.158644821543165e-02, -5.075116717534064e-04,  5.248923455200195e-06, -5.042147340787893e-08,
  4.533540826467386e-10, -3.883408292665024e-12,  3.202228154040023e-14, -2.558000272225532e-16,  1.988578833159793e-18, -1.509409155679197e-20,  1.121777798200858e-22,
 -8.178581565221661e-25,  3.699133377115430e-02, -4.520414464730954e-04,  6.182889690439637e-06, -7.395352276776262e-08,  8.136433242542325e-10, -8.418526697315651e-12,
  8.291557083505934e-14, -7.836799845620545e-16,  7.150893765471339e-18, -6.327486582711647e-20,  5.448994531181206e-22, -4.579015630465787e-24,  1.874259748727422e-02,
 -3.304968346829126e-04,  5.685194778527816e-06, -8.295846433407913e-08,  1.096829555845865e-09, -1.345935464251267e-11,  1.555671160826516e-13, -1.710836213426186e-15,
  1.803414378509128e-17, -1.832162012527890e-19,  1.801709528885541e-21, -1.720653953042753e-23,  8.010485534563768e-03, -1.968688045248841e-04,  4.163477928402494e-06,
 -7.320997271297637e-08,  1.147851880890828e-09, -1.649456355033073e-11,  2.210963555967702e-13, -2.797683530436062e-15,  3.370741153084839e-17, -3.891814140083732e-19,
  4.327583653194050e-21, -4.652407379836541e-23,  2.888372474726440e-03, -9.581892429396521e-05,  2.463092576644347e-06, -5.169177918328182e-08,  9.517882681087976e-10,
 -1.587381003422333e-11,  2.447073049002964e-13, -3.534750721008520e-15,  4.831189134991933e-17, -6.293583421423845e-19,  7.858499493360071e-21, -9.446385039181106e-23,
  8.790888435795772e-04, -3.831390355557353e-05,  1.188697537542780e-06, -2.954650038682976e-08,  6.343718526779061e-10, -1.220021104846958e-11,  2.149994794334773e-13,
 -3.525015518132299e-15,  5.435688086642117e-17, -7.947623159220005e-19,  1.108734477179502e-20, -1.482900955848395e-22,  2.260871616286118e-04, -1.266049054908254e-05,
  4.715417497490204e-07, -1.379889613915553e-08,  3.436717909932163e-10, -7.585832954475472e-12,  1.521488609590930e-13, -2.819663714170184e-15,  4.886096473159104e-17,
 -7.987663578470060e-19,  1.240358070304349e-20, -1.839160422110381e-22,  4.923455851950520e-05, -3.478397214776251e-06,  1.548098247675077e-07, -5.308962001545310e-09,
  1.527961058045366e-10, -3.857615135581166e-12,  8.778104841017400e-14, -1.833291919148989e-15,  3.559756029863917e-17, -6.488540098642551e-19,  1.118503279415724e-20,
 -1.833774154419956e-22,  9.110218858301474e-06, -7.999575241202164e-07,  4.236643204651988e-08, -1.696615608454174e-09,  5.626932500603543e-11, -1.620906752678004e-12,
  4.175222745156505e-14, -9.806026618283211e-16,  2.129231157467830e-17, -4.318769165014052e-19,  8.248410858058852e-21, -1.492376968211235e-22,  1.440471587354221e-06,
 -1.552602879354875e-07,  9.747116907130393e-09, -4.545586020033899e-10,  1.733673016883770e-11, -5.688248213629476e-13,  1.656011967386828e-14, -4.367431771754195e-16,
  1.058977048042930e-17, -2.386899153209952e-19,  5.043902959886880e-21, -1.005704159971461e-22,  1.963537423870789e-07, -2.570440959009515e-08,  1.905917612181929e-09,
 -1.032733138892495e-10,  4.522417893161619e-12, -1.687966800994152e-13,  5.548048938302300e-15, -1.641399188628359e-16,  4.439968455418631e-18, -1.110994798275276e-19,
  2.594974106686827e-21, -5.696129737686557e-23,  2.338872674398989e-08, -3.683937644307190e-09,  3.214624880180680e-10, -2.019714012582492e-11,  1.014117157983286e-12,
 -4.301489297867885e-14,  1.594822331573598e-15, -5.288744366134888e-17,  1.594721292939270e-18, -4.426446532996126e-20,  1.141831858080735e-21, -2.756786676456231e-23,
  2.484398835703701e-09, -4.666853449991352e-10,  4.774166710578602e-11, -3.470284435307181e-12,  1.994948521119852e-13, -9.605254983045511e-15,  4.013318883349457e-16,
 -1.490477268092269e-17,  5.005463612253270e-19, -1.539794776644989e-20,  4.382537998591763e-22, -1.162623121778972e-23,  2.424791907104591e-10, -5.383053818070023e-11,
  6.426501097344873e-12, -5.388732811051084e-13,  3.539174235886079e-14, -1.930997993326718e-15,  9.078696040773856e-17, -3.770620476524703e-18,  1.408369047653981e-19,
 -4.794850631023456e-21,  1.503587913235148e-22, -4.376213776047424e-24,  2.270395059341105e-11, -5.895721986808108e-12,  8.164491682347949e-13, -7.863222114442067e-14,
  5.879718082200142e-15, -3.624423122585545e-16,  1.912246709962923e-17, -8.858920973617644e-19,  3.670961544972523e-20, -1.379746607552727e-21,  4.755122901769075e-23,
 -1.514561436282040e-24,  2.165949069580163e-12, -6.496154332176064e-13,  1.034534185247752e-13, -1.136561304070502e-14,  9.619038914605200e-16, -6.663720046260269e-17,
  3.925989698706839e-18, -2.019314982991694e-19,  9.241418423617104e-21, -3.817726817796410e-22,  1.439763719323698e-23, -4.996882355694515e-25,  2.278957546694625e-13,
 -7.765680955526961e-14,  1.404232858333681e-14, -1.740722603557365e-15,  1.651225922683776e-16, -1.274039553835363e-17,  8.311348949270478e-19, -4.708181751019720e-20,
  2.361410584713803e-21, -1.064250214735064e-22,  4.360180889739814e-24, -1.637262000063053e-25,  2.900376818205266e-14, -1.099007060472087e-14,  2.214973939477239e-15,
 -3.046690004554032e-16,  3.189621321104531e-17, -2.701732075148640e-18,  1.925203550859837e-19, -1.185684199317833e-20,  6.437327196478057e-22, -3.127781273215964e-23,
  1.376312346876406e-24, -5.530401276333443e-26,  4.799573294114867e-15, -1.967814083479761e-15,  4.307403787330436e-16, -6.416974712789594e-17,  7.247928471703333e-18,
 -6.597134835380283e-19,  5.032138632510930e-20, -3.305394583356506e-21,  1.907442205582335e-22, -9.819343593861100e-24,  4.564173715877307e-25, -1.931647747665699e-26,
  9.211273967817184e-16, -3.954423815780323e-16,  9.091971842219533e-17, -1.420751714342670e-17,  1.679529496343044e-18, -1.596214402635332e-19,  1.268368041866834e-20,
 -8.659897170819906e-22,  5.183592571901855e-23, -2.762484757059204e-24,  1.326839257314196e-25, -5.792125111491210e-27,  1.007730300282141e-01, -4.280115201947892e-04,
  1.912880061973869e-06, -8.903280585965422e-09,  4.254702752473161e-11, -2.072597694918197e-13,  1.014081833019465e-15, -5.022678033547993e-18,  2.444777568038383e-20,
 -1.231213005669852e-22,  5.717455072507281e-25, -3.148618379594826e-27,  8.461030360548377e-02, -4.602160134125100e-04,  3.157979545573745e-06, -2.239650110020649e-08,
  1.552401003105198e-10, -1.045647188225553e-12,  6.864215281161530e-15, -4.413446097348542e-17,  2.784542204512705e-19, -1.731608570343286e-21,  1.059554241442129e-23,
 -6.427610741291081e-26,  5.963671890494038e-02, -4.678228455988933e-04,  4.684953622996249e-06, -4.374970834383633e-08,  3.828262492418222e-10, -3.194104427448241e-12,
  2.567486451603450e-14, -2.000594195506986e-16,  1.517987804032968e-18, -1.125100753355347e-20,  8.169035365301612e-23, -5.820129601197475e-25,  3.527677016274430e-02,
 -4.059189159978692e-04,  5.368331862922872e-06, -6.218109292394000e-08,  6.635203632999205e-10, -6.667975421214043e-12,  6.386154381590863e-14, -5.874555185284351e-16,
  5.221225783640931e-18, -4.502833577097701e-20,  3.781643749509144e-22, -3.100536518352311e-24,  1.750566419870162e-02, -2.887181617109475e-04,  4.786720946329170e-06,
 -6.737501603816599e-08,  8.614112541485092e-10, -1.024100489975588e-11,  1.148426416147989e-13, -1.226722828647627e-15,  1.257188422949593e-17, -1.242737422149335e-19,
  1.189932822157472e-21, -1.107178163759485e-23,  7.284471933687740e-03, -1.667861665502569e-04,  3.385131701423847e-06, -5.721975901967632e-08,  8.652576291447696e-10,
 -1.201823004944257e-11,  1.559727513815817e-13, -1.913434476862927e-15,  2.237564671948672e-17, -2.509865677142175e-19,  2.713661694700965e-21, -2.838709241033132e-23,
  2.540913781124758e-03, -7.835871287557458e-05,  1.924634904342933e-06, -3.871463432252441e-08,  6.858463181372939e-10, -1.103276658547397e-11,  1.643615516672588e-13,
 -2.297901661749318e-15,  3.043723712035980e-17, -3.846846539272623e-19,  4.664654679465168e-21, -5.449926726612974e-23,  7.428281126450313e-04, -3.006688231001432e-05,
  8.878113866194179e-07, -2.109855794182683e-08,  4.348866146206615e-10, -8.051739703906522e-12,  1.368932187034800e-13, -2.169096946007170e-15,  3.237230586771374e-17,
 -4.586642992951578e-19,  6.207167736509794e-21, -8.061329988191281e-23,  1.820593946106000e-04, -9.467387745385954e-06,  3.345171417681867e-07, -9.339452660175832e-09,
  2.228875387208925e-10, -4.728487486916654e-12,  9.136587705022516e-14, -1.634309729582448e-15,  2.737866532756048e-17, -4.332880255220413e-19,  6.521238264388738e-21,
 -9.381986062882870e-23,  3.744623010615446e-05, -2.458386264443370e-06,  1.035528078954401e-07, -3.382362274445102e-09,  9.313710923183517e-11, -2.256981911458899e-12,
  4.941985541063005e-14, -9.952082540643143e-16,  1.866520753991959e-17, -3.291049261419497e-19,  5.494962429036368e-21, -8.736193150464259e-23,  6.478063100425703e-06,
 -5.293097124216391e-07,  2.649292926471864e-08, -1.009320635441243e-09,  3.199203850958900e-11, -8.837142665879378e-13,  2.188602986212100e-14, -4.952873983596392e-16,
  1.038152811267058e-17, -2.035925537896025e-19,  3.764798209317069e-21, -6.603391347307935e-23,  9.465097527235024e-07, -9.512905123482017e-08,  5.641366000262411e-09,
 -2.501468966130595e-10,  9.112794983273530e-12, -2.865707054270567e-13,  8.018129451098730e-15, -2.036923176349679e-16,  4.766609794564899e-18, -1.038621085683590e-19,
  2.124858455339206e-21, -4.107282715394269e-23,  1.176313294803234e-07, -1.440038803951208e-08,  1.009154117949096e-09, -5.200235537518622e-11,  2.175303394672101e-12,
 -7.782420480510562e-14,  2.458640458103771e-15, -7.007734466940529e-17,  1.829837544176073e-18, -4.427565528378559e-20,  1.001548034362805e-21, -2.132117586484929e-23,
  1.257901905856994e-08, -1.859867396376855e-09,  1.536371054985709e-10, -9.189913222814177e-12,  4.411653290320898e-13, -1.795036382410740e-14,  6.401746715973340e-16,
 -2.046806208403324e-17,  5.962326409376452e-19, -1.601606791796634e-20,  4.004530117354515e-22, -9.384774807728007e-24,  1.178698077233177e-09, -2.088547986873131e-10,
  2.028396066581475e-11, -1.406742831489816e-12,  7.745817143483932e-14, -3.583467802689065e-15,  1.442466464255443e-16, -5.172703836640939e-18,  1.680672449377382e-19,
 -5.010777515774716e-21,  1.384358570492374e-22, -3.569991373120088e-24,  9.953620372416553e-11, -2.097089130890541e-11,  2.386873046945798e-12, -1.916113355788234e-13,
  1.208974459930921e-14, -6.355267837040640e-16,  2.885917035648239e-17, -1.160141814523293e-18,  4.202141143538763e-20, -1.389676036815065e-21,  4.239422811627065e-23,
 -1.202054835006873e-24,  7.902241957593350e-12, -1.961978071789483e-12,  2.605180587235851e-13, -2.413784563353154e-14,  1.741453622005759e-15, -1.038363021128605e-16,
  5.310864785359676e-18, -2.389762878513035e-19,  9.635071715361014e-21, -3.528963902367355e-22,  1.186833618593643e-23, -3.693714676228771e-25,  6.274073803922593e-13,
 -1.814948007333129e-13,  2.791666532276039e-14, -2.969446335521178e-15,  2.438818764359932e-16, -1.642964853937268e-17,  9.430283148640427e-19, -4.733245540779519e-20,
  2.116976478468062e-21, -8.558274793380047e-23,  3.162317992879543e-24, -1.076575832675208e-25,  5.427563898957015e-14, -1.801259758033863e-14,  3.173154913024596e-15,
 -3.838165766871646e-16,  3.558423540038696e-17, -2.687558670046768e-18,  1.718613819786643e-19, -9.555278127240897e-21,  4.709188717836241e-22, -2.087658640416799e-23,
  8.421297735229618e-25, -3.116359644775354e-26,  5.692427017294821e-15, -2.121537184881762e-15,  4.204340427221410e-16, -5.691288630114005e-17,  5.869610393693843e-18,
 -4.902555242765972e-19,  3.447946671225774e-20, -2.097582219851096e-21,  1.125781739444154e-22, -5.411141134210877e-24,  2.356968974360099e-25, -9.380925823440936e-27,
  7.974616748624239e-16, -3.243545498779025e-16,  7.040762447439900e-17, -1.040523036112034e-17,  1.166408538721943e-18, -1.054163976597811e-19,  7.987529821272698e-21,
 -5.213971405194567e-22,  2.991213436991292e-23, -1.531376036042023e-24,  7.081185534136373e-26, -2.982303957176569e-27,  1.373534148921258e-16, -5.882330591104418e-17,
  1.348929885820227e-17, -2.102529134651282e-18,  2.479429761920508e-19, -2.350971115743382e-20,  1.863991498516944e-21, -1.269995662168444e-22,  7.586766029250973e-24,
 -4.035567522208807e-25,  1.934825076435784e-26, -8.431778117452838e-28,  9.909092931235232e-02, -4.131245710502961e-04,  1.809992574685835e-06, -8.254413622350991e-09,
  3.863426039533195e-11, -1.845249664121789e-13,  8.837630606797762e-16, -4.307115703865906e-18,  2.039494504073389e-20, -1.028870649923262e-22,  4.427985421416333e-25,
 -2.760704190499994e-27,  8.281832267799702e-02, -4.359865170384153e-04,  2.903462343330838e-06, -2.007141486357900e-08,  1.358794408076155e-10, -8.947831169249171e-13,
  5.744379054654771e-15, -3.614476003000004e-17,  2.231097411286471e-19, -1.359346047763467e-21,  8.132354569890699e-24, -4.849382834868437e-26,  5.783720266990469e-02,
 -4.323437204674360e-04,  4.194703808255248e-06, -3.810387543347737e-08,  3.246792517187504e-10, -2.639991486065177e-12,  2.069659103551176e-14, -1.573805858907583e-16,
  1.166085347868698e-18, -8.442797171788073e-21,  5.991741780461340e-23, -4.172807625866008e-25,  3.373450412393767e-02, -3.657860967532466e-04,  4.681711086998797e-06,
 -5.255363883709305e-08,  5.442468544427381e-10, -5.315203157218049e-12,  4.952757101261473e-14, -4.436403978243128e-16,  3.842556659719684e-18, -3.231215234981556e-20,
  2.647755048117860e-22, -2.118799775331349e-24,  1.642257000338329e-02, -2.534387392622378e-04,  4.054612216331174e-06, -5.509215236915579e-08,  6.815897085733838e-10,
 -7.855327969478188e-12,  8.551440159019825e-14, -8.876922608593542e-16,  8.849164400590513e-18, -8.515164417574174e-20,  7.942518892243339e-22, -7.203065249100619e-24,
  6.667450408319296e-03, -1.422333424798952e-04,  2.774239635243838e-06, -4.511202553764471e-08,  6.583720921033320e-10, -8.844543778903605e-12,  1.111988562892029e-13,
 -1.323252114625481e-15,  1.502645312270841e-17, -1.638253614675036e-19,  1.723022992333481e-21, -1.754560238126608e-23,  2.255573661793880e-03, -6.464886432287217e-05,
  1.519257836192323e-06, -2.931205641752285e-08,  4.999449692501525e-10, -7.761739151456028e-12,  1.118062027439324e-13, -1.513694437945553e-15,  1.944004677308869e-17,
 -2.384761158228340e-19,  2.809398298929518e-21, -3.191525641693169e-23,  6.353142813241121e-04, -2.387000632175576e-05,  6.715901474079289e-07, -1.526886532843103e-08,
  3.023326400522232e-10, -5.391761854030898e-12,  8.848428690746427e-14, -1.355624327615711e-15,  1.958946171435339e-17, -2.690639450146074e-19,  3.533646803720303e-21,
 -4.457732606124960e-23,  1.489093212115998e-04, -7.185402778953402e-06,  2.410674473992229e-07, -6.424614786806129e-09,  1.469954414793969e-10, -2.998627702345995e-12,
  5.584292075395461e-14, -9.645200722623796e-16,  1.562639852189520e-17, -2.394821919886406e-19,  3.494490730536260e-21, -4.879334547968742e-23,  2.904418750408751e-05,
 -1.770038375304189e-06,  7.060152177610919e-08, -2.197228897451428e-09,  5.790844308378866e-11, -1.347400058122523e-12,  2.839875989312998e-14, -5.515926641531916e-16,
  9.994942615776056e-18, -1.705131426980351e-19,  2.758155398953200e-21, -4.253096130952508e-23,  4.718724699901897e-06, -3.582906007419291e-07,  1.695008431035473e-08,
 -6.144202139759802e-10,  1.861573661969538e-11, -4.931849635940278e-13,  1.174542929409405e-14, -2.561525636258219e-16,  5.183595937974060e-18, -9.829710755897117e-20,
  1.760058974490669e-21, -2.992941694572121e-23,  6.402444336219215e-07, -5.990265762561810e-08,  3.354525390890000e-09, -1.414060136877992e-10,  4.920060053711413e-12,
 -1.482856218398084e-13,  3.987310235679838e-15, -9.756702633875343e-17,  2.203392841825187e-18, -4.641031651462106e-20,  9.191740687474784e-22, -1.722296709092325e-23,
  7.292612846937034e-08, -8.331935590436147e-09,  5.514037210172913e-10, -2.700786879471776e-11,  1.078781525247673e-12, -3.698202329907187e-14,  1.122666469227275e-15,
 -3.081951257014652e-17,  7.766358666932861e-19, -1.816683182062932e-20,  3.978878383928040e-22, -8.212587568169944e-24,  7.038560264448205e-09, -9.745810480963055e-10,
  7.611486978414912e-11, -4.330483006309426e-12,  1.986064228469780e-13, -7.746880547330332e-15,  2.656026849272401e-16, -8.183057517996362e-18,  2.301658031970092e-19,
 -5.980516855023304e-21,  1.448696267123757e-22, -3.293966666517577e-24,  5.847591051881485e-10, -9.746945010174163e-11,  8.971007109623339e-12, -5.927915690996439e-13,
  3.122791661879801e-14, -1.386764005606719e-15,  5.373018051892254e-17, -1.858901782344975e-18,  5.838844202642423e-20, -1.685886066928867e-21,  4.517955112277551e-23,
 -1.131791141115914e-24,  4.290129849464739e-11, -8.551830136363498e-12,  9.259158355778471e-13, -7.103271628451642e-14,  4.298948644785601e-15, -2.174299081515124e-16,
  9.524370413808957e-18, -3.701707383141319e-19,  1.298827103484973e-20, -4.168111279510420e-22,  1.235819404646006e-23, -3.410534009433937e-25,  2.894194033958142e-12,
 -6.848001502391625e-13,  8.696399320967814e-14, -7.734725018322656e-15,  5.373902245696740e-16, -3.094158043453090e-17,  1.531779929627099e-18, -6.685259260520490e-20,
  2.619041981960279e-21, -9.336126895659555e-23,  3.060412248361284e-24, -9.296495179984806e-26,  1.910218192122366e-13, -5.312521672350938e-14,  7.870900313979771e-15,
 -8.086635372166608e-16,  6.431610254651829e-17, -4.205371658038891e-18,  2.347520552446075e-19, -1.147961769178815e-20,  5.010277153998087e-22, -1.979403414722187e-23,
  7.156866477916452e-25, -2.387060624424321e-26,  1.350622190722801e-14, -4.353042363409108e-15,  7.451608158791432e-16, -8.774666942962230e-17,  7.934630170339680e-18,
 -5.855155021997628e-19,  3.663932254908738e-20, -1.996237452233510e-21,  9.653113029952605e-23, -4.203732764986849e-24,  1.667502956817664e-25, -6.074067919419549e-27,
  1.154266186093982e-15, -4.222370829575930e-16,  8.211442307885981e-17, -1.091936944258747e-17,  1.107559465856219e-18, -9.108272189980339e-20,  6.313619302719362e-21,
 -3.789239423356403e-22,  2.008065727121023e-23, -9.537765683905987e-25,  4.108283416700860e-26, -1.618081063272761e-27,  1.349137720812774e-16, -5.437678624922265e-17,
  1.169233317591442e-17, -1.712395732402651e-18,  1.903305762291373e-19, -1.706499397287804e-20,  1.283431128790146e-21, -8.319496738184873e-23,  4.741704177909335e-24,
 -2.412697081548693e-25,  1.109231574921879e-26, -4.646416357772109e-28,  2.060314597189992e-17, -8.799515883032352e-18,  2.011998379404950e-18, -3.127115173945653e-19,
  3.677681057809007e-20, -3.478166554566348e-21,  2.750976092727002e-22, -1.869996800657652e-23,  1.114662738794516e-24, -5.916821792657927e-26,  2.831184723952270e-27,
 -1.231495748799373e-28,  9.746677804886832e-02, -3.990306069768945e-04,  1.714530337816909e-06, -7.664676743224651e-09,  3.514646270717189e-11, -1.646914017520599e-13,
  7.717669429504008e-16, -3.710556502407379e-18,  1.698099270731200e-20, -8.756127857351772e-23,  3.238810154377179e-25, -2.709400236179608e-27,  8.111935702365584e-02,
 -4.136866000526212e-04,  2.675082592207840e-06, -1.803334858040131e-08,  1.192844385754503e-10, -7.682989659961226e-13,  4.825346700727220e-15, -2.972939864245048e-17,
  1.795482268469191e-19, -1.073059451122617e-21,  6.266032929794349e-24, -3.693616372923486e-26,  5.617216675288084e-02, -4.005306078536223e-04,  3.766967620538323e-06,
 -3.330584353239620e-08,  2.765103222173796e-10, -2.192201763600014e-12,  1.676974958162760e-14, -1.244999768738695e-16,  9.012035079127326e-19, -6.376220263074771e-21,
  4.425455480093486e-23, -3.012835517899762e-25,  3.234247188103671e-02, -3.307146270869044e-04,  4.100005322500071e-06, -4.463552427541071e-08,  4.488907328882432e-10,
 -4.262715962465323e-12,  3.866581399120132e-14, -3.374155453071152e-16,  2.849462901128054e-18, -2.337288889276796e-20,  1.869688266457315e-22, -1.460623243574089e-24,
  1.546974869068214e-02, -2.234721278025969e-04,  3.454093916454761e-06, -4.533996810421874e-08,  5.431474247060406e-10, -6.071876030447418e-12,  6.420297594119672e-14,
 -6.480047167706619e-16,  6.286681091417124e-18, -5.891363383506818e-20,  5.355596129284403e-22, -4.735767711211460e-24,  6.139712563954498e-03, -1.220382858453813e-04,
  2.290699144121685e-06, -3.585988095909252e-08,  5.054271146037508e-10, -6.571057058897625e-12,  8.007978400034963e-14, -9.248424411187320e-16,  1.020348433470985e-17,
 -1.081733369370033e-19,  1.107205275535503e-21, -1.097970585998530e-23,  2.019236149625714e-03, -5.377671266895916e-05,  1.210820860731417e-06, -2.242226004751403e-08,
  3.684428689486735e-10, -5.523916585593991e-12,  7.698133049941054e-14, -1.009763037185817e-15,  1.257971140171926e-17, -1.498503708713576e-19,  1.715780616037145e-21,
 -1.895958646554862e-23,  5.495254271809130e-04, -1.915546130646907e-05,  5.141704649275620e-07, -1.119057835186750e-08,  2.129904525762520e-10, -3.660855267281826e-12,
  5.802104140483482e-14, -8.598851187020393e-16,  1.203656387667896e-17, -1.603331459703398e-19,  2.044204476587341e-21, -2.505792486635282e-23,  1.235875004318161e-04,
 -5.529388548175808e-06,  1.763175716933691e-07, -4.487907938174808e-09,  9.849908376816401e-11, -1.933067549183571e-12,  3.471138759953059e-14, -5.791439211847966e-16,
  9.077530317819598e-18, -1.347665888899337e-19,  1.907165928756751e-21, -2.585258185467368e-23,  2.294647976356695e-05, -1.296773206384274e-06,  4.901173043145693e-08,
 -1.453912588649008e-09,  3.669035527250732e-11, -8.200156582242474e-13,  1.664203434160895e-14, -3.118674975816238e-16,  5.461349339651725e-18, -9.017091098041025e-20,
  1.413382457441721e-21, -2.114298278608222e-23,  3.516339870532492e-06, -2.477796193873533e-07,  1.108232919201737e-08, -3.823008955081092e-10,  1.107456593106691e-11,
 -2.814589650839499e-13,  6.447173945037348e-15, -1.355253406342297e-16,  2.648216166947940e-18, -4.856624205050820e-20,  8.421334790107154e-22, -1.388486935438710e-23,
  4.451890414106430e-07, -3.871139149643070e-08,  2.046721415578695e-09, -8.201433604378163e-11,  2.725464217788334e-12, -7.872775673505093e-14,  2.034509214237774e-15,
 -4.795259166503611e-17,  1.045099991255393e-18, -2.127907221631378e-20,  4.079785706583786e-22, -7.409990002449093e-24,  4.671880893845333e-08, -4.971631777507119e-09,
  3.105113305192906e-10, -1.445019262209849e-11,  5.509818452876939e-13, -1.809484066988111e-14,  5.277208094999565e-16, -1.395038995255827e-17,  3.391962527832565e-19,
 -7.668983483156998e-21,  1.625952860814605e-22, -3.253257102920242e-24,  4.092123585851980e-09, -5.293631358454635e-10,  3.904258159039412e-11, -2.111068522971626e-12,
  9.243727503569125e-14, -3.454651730028575e-15,  1.138089909368828e-16, -3.377273104164934e-18,  9.168301400164343e-20, -2.303362355014905e-21,  5.403382443787086e-23,
 -1.191519715611713e-24,  3.030598084236227e-10, -4.738867309164746e-11,  4.126518562506982e-12, -2.594736610816723e-13,  1.306378123331025e-14, -5.563607495723773e-16,
  2.073142624837983e-17, -6.914551781164459e-19,  2.098116544080937e-20, -5.862937747687667e-22,  1.523055866160220e-23, -3.704004780147066e-25,  1.940898854379579e-11,
 -3.649155020966317e-12,  3.750253006530100e-13, -2.744664413497521e-14,  1.590967564639831e-15, -7.732040039691775e-17,  3.263374023555684e-18, -1.224897568286154e-19,
  4.159088636485691e-21, -1.293943729069562e-22,  3.725274406288594e-24, -9.997629521843532e-26,  1.116110697990603e-12, -2.508230644720987e-13,  3.038413271837379e-14,
 -2.588560092387151e-15,  1.728701261419387e-16, -9.595371104364910e-18,  4.590856117253135e-19, -1.940618787321567e-20,  7.377736563210967e-22, -2.556520371929466e-23,
  8.158920302216023e-25, -2.416369437810146e-26,  6.123953210689802e-14, -1.631772454219514e-14,  2.322053781589533e-15, -2.298708729408226e-16,  1.766626401740266e-17,
 -1.118977439575750e-18,  6.064099011951617e-20, -2.884436757494506e-21,  1.226640468835725e-22, -4.729126458701588e-24,  1.670958982661768e-25, -5.453417168074159e-27,
  3.521782957432717e-15, -1.098872138520095e-15,  1.822825409216764e-16, -2.084541351658720e-17,  1.834494277157971e-18, -1.320011674977269e-19,  8.068434779615631e-21,
 -4.300624941924648e-22,  2.037380070493510e-23, -8.703120039004876e-25,  3.390327985658383e-26, -1.214117720750873e-27,  2.425775682779999e-16, -8.688899052358213e-17,
  1.654535838172965e-17, -2.156963902100071e-18,  2.147775262287854e-19, -1.736165026949078e-20,  1.184343551664331e-21, -7.002628712499742e-23,  3.659487071017647e-24,
 -1.715568765355343e-25,  7.299509794827919e-27, -2.842100876633122e-28,  2.329239297337516e-17, -9.290841620351930e-18,  1.976396730354788e-18, -2.865059126842437e-19,
  3.154081032192488e-20, -2.802725098046578e-21,  2.090333583979413e-22, -1.344459477584008e-23,  7.606981308036829e-25, -3.844230663521924e-26,  1.756073177298101e-27,
 -7.311875218468862e-29,  3.111106263109986e-18, -1.324648921700802e-18,  3.018832438961678e-19, -4.677012055588414e-20,  5.483776395528054e-21, -5.171402273606628e-22,
  4.079115768277728e-23, -2.765708654929414e-24,  1.644584320539066e-25, -8.709730184853110e-27,  4.158535011631774e-28, -1.805144840382958e-29,  9.589751876516109e-02,
 -3.856729528837148e-04,  1.625822746997154e-06, -7.127711836348738e-09,  3.202974848403842e-11, -1.473571679282439e-13,  6.750214195947284e-16, -3.215337162330485e-18,
  1.403255105117500e-20, -7.707468614911668e-23,  1.973797765417020e-25, -3.133622310120240e-27,  7.950608572581937e-02, -3.931202229728440e-04,  2.469646274126245e-06,
 -1.624170492958830e-08,  1.050123261700432e-10, -6.618645171590420e-13,  4.067881028249665e-15, -2.455657881477798e-17,  1.450626525955354e-19, -8.522505591679778e-22,
  4.835444722540052e-24, -2.854495235519277e-26,  5.462788651814268e-02, -3.719215322999234e-04,  3.392463368287751e-06, -2.921169211795929e-08,  2.364246450512236e-10,
 -1.828501509842173e-12,  1.365527487403768e-14, -9.901683772909283e-17,  7.005711288395546e-19, -4.844886721084093e-21,  3.291080383035697e-23, -2.189238859557800e-25,
  3.108198538361688e-02, -2.999411583720933e-04,  3.604814122059023e-06, -3.808792317684165e-08,  3.722010804772478e-10, -3.438533209775047e-12,  3.037785058427640e-14,
 -2.583689668570169e-16,  2.128499950936698e-18, -1.703578367190511e-20,  1.331226140275836e-22, -1.015180668283450e-24,  1.462787689484097e-02, -1.978766732135839e-04,
  2.958404283824750e-06, -3.754317253364245e-08,  4.357586206998998e-10, -4.727822928722735e-12,  4.858371206131250e-14, -4.770061452059259e-16,  4.505993904924755e-18,
 -4.113992858226013e-20,  3.646749941466456e-22, -3.145050595838590e-24,  5.685666975885051e-03, -1.053058415412612e-04,  1.904880381062921e-06, -2.872817617527110e-08,
  3.913040344414338e-10, -4.926308034402994e-12,  5.822579909274931e-14, -6.529536914927372e-16,  7.002363945680192e-18, -7.221933720261340e-20,  7.197097715804986e-22,
 -6.952892143577702e-24,  1.821929520156068e-03, -4.507398658242903e-05,  9.737792133979354e-07, -1.731947118872426e-08,  2.743654545238786e-10, -3.974705307236252e-12,
  5.361845013519104e-14, -6.817552997988734e-16,  8.242877529993635e-18, -9.538828666379726e-20,  1.061984151022927e-21, -1.141911731149644e-23,  4.803548505911651e-04,
 -1.552642257333235e-05,  3.981389036135647e-07, -8.300274728060765e-09,  1.519523803674346e-10, -2.518565686733399e-12,  3.857006652843623e-14, -5.532153710219297e-16,
  7.504613195635635e-18, -9.698728685842054e-20,  1.200927029906848e-21, -1.430940166685214e-23,  1.039842358664474e-04, -4.310145151635673e-06,  1.307756260871753e-07,
 -3.180925305345787e-09,  6.700733890943629e-11, -1.265769004531741e-12,  2.192609079687237e-14, -3.535345480918638e-16,  5.363110649618522e-18, -7.715918524821328e-20,
  1.059336380257707e-21, -1.394506845288078e-23,  1.844568425823519e-05, -9.656062427945136e-07,  3.460880535987724e-08, -9.790167927860677e-10,  2.366743660362344e-11,
 -5.082961648060889e-13,  9.936811918298370e-15, -1.797234677479807e-16,  3.042556230757843e-18, -4.863147026799803e-20,  7.388478305012299e-22, -1.072463785735540e-23,
  2.677234131684606e-06, -1.748381153201798e-07,  7.396195214606842e-09, -2.428707000526701e-10,  6.728731577015442e-12, -1.640969366190741e-13,  3.616265310922951e-15,
 -7.328783708030752e-17,  1.383100376629786e-18, -2.453489180489268e-20,  4.120582296060455e-22, -6.588213041324065e-24,  3.177659805510920e-07, -2.563743058278592e-08,
  1.279725956437089e-09, -4.874694070506033e-11,  1.547326454382679e-12, -4.284174986559316e-14,  1.064110748797343e-15, -2.416018896485319e-17,  5.081922760817512e-19,
 -1.000260434057241e-20,  1.856563911423729e-22, -3.268612338204021e-24,  3.088248612506148e-08, -3.054896491981680e-09,  1.799736830702163e-10, -7.955126201610133e-12,
  2.894985311517244e-13, -9.106641960014467e-15,  2.551169692933572e-16, -6.493415082737464e-18,  1.523192406263885e-19, -3.328189445708722e-21,  6.829754595284970e-23,
 -1.324465432673117e-24,  2.468529176950564e-09, -2.976361237762431e-10,  2.070902552250015e-11, -1.063449225974446e-12,  4.443411427096789e-14, -1.590379073367621e-15,
  5.032267561761236e-17, -1.437791546399359e-18,  3.765818272982322e-20, -9.144406165048038e-22,  2.076697553214398e-23, -4.439687522893402e-25,  1.638980691445096e-10,
 -2.397583749605537e-11,  1.972156534904318e-12, -1.178687738400699e-13,  5.666329302286590e-15, -2.312411064961588e-16,  8.280897625264634e-18, -2.660819933484774e-19,
  7.794702421800494e-21, -2.106712379299304e-22,  5.301975039596471e-24, -1.251055388248749e-25,  9.211692476528371e-12, -1.628383184012804e-12,  1.585139164429417e-13,
 -1.104900461037619e-14,  6.125799118840457e-16, -2.857220275076726e-17,  1.160634361073932e-18, -4.202964724752840e-20,  1.379722993604610e-21, -4.157663534998694e-23,
  1.161311009988123e-24, -3.028326458956327e-26,  4.533624596291017e-13, -9.643012500963409e-14,  1.111395300680199e-14, -9.050284330447216e-16,  5.798900314566468e-17,
 -3.097923821425518e-18,  1.430344769841991e-19, -5.848209624386653e-21,  2.154846146562246e-22, -7.249857423067741e-24,  2.250073318441950e-25, -6.490174400171533e-27,
  2.070539715100477e-14, -5.266717030248906e-15,  7.177364055344184e-16, -6.829032686399581e-17,  5.060305220112623e-18, -3.098794017163521e-19,  1.627431691086947e-20,
 -7.517305147859184e-22,  3.110143498932397e-23, -1.168474739476457e-24,  4.029236333503383e-26, -1.285120846565781e-27,  9.649722277859043e-16, -2.904929146128988e-16,
  4.655702744986993e-17, -5.157097904838645e-18,  4.406712313845816e-19, -3.085450468101237e-20,  1.838682405819987e-21, -9.571255743008177e-23,  4.435018356719759e-24,
 -1.855601984578069e-25,  7.088958645537223e-27, -2.492545932623273e-28,  5.301488725586454e-17, -1.854400595178938e-17,  3.448912152780203e-18, -4.398098180677798e-19,
  4.290527003053672e-20, -3.402917745707546e-21,  2.280649132709796e-22, -1.326443727333415e-23,  6.826088215010739e-25, -3.154400817083548e-26,  1.324201383334283e-27,
 -5.091242393766816e-29,  4.114243963206749e-18, -1.621638587217527e-18,  3.407678863640484e-19, -4.882936575738627e-20,  5.317587130036364e-21, -4.677784478290891e-22,
  3.456169895315469e-23, -2.203557611794790e-24,  1.236630865204975e-25, -6.201835970496157e-27,  2.812865099549150e-28, -1.163408532639326e-29,  4.733147499723648e-19,
 -2.008229828505770e-19,  4.559666171293043e-20, -7.038813200519661e-21,  8.224870417429671e-22, -7.731440250268696e-23,  6.079978039005202e-24, -4.110573572187835e-25,
  2.437714741451493e-26, -1.287738394281794e-27,  6.133664868647117e-29, -2.656483390592420e-30,  9.438031042262109e-02, -3.730000073967830e-04,  1.543270574864660e-06,
 -6.637962509003236e-09,  2.923756941838223e-11, -1.321887817155396e-13,  5.908706643537748e-16, -2.809451186912120e-18,  1.136445232667667e-20, -7.219847358568473e-23,
  3.877401592658570e-26, -4.183660521121347e-27,  7.797192384513757e-02, -3.741150639582501e-04,  2.284406733617112e-06, -1.466232620860964e-08,  9.269822825449307e-11,
 -5.719889096870330e-13,  3.440925004954915e-15, -2.037047988576945e-17,  1.175781393250518e-19, -6.820421426267689e-22,  3.718344264064941e-24, -2.258071436200740e-26,
  5.319234697721641e-02, -3.461223472083693e-04,  3.063468227439741e-06, -2.570455060251173e-08,  2.029197506664877e-10, -1.531663826797185e-12,  1.117214674476091e-14,
 -7.915283329174938e-17,  5.477032037714619e-19, -3.702321742921587e-21,  2.464633260089084e-23, -1.599279544254882e-25,  2.993713943825841e-02, -2.728346078968604e-04,
  3.181342829290463e-06, -3.264558659937653e-08,  3.101726194844388e-10, -2.789112098663572e-12,  2.401174074175343e-14, -1.991232095037257e-16,  1.601202704902946e-18,
 -1.250627159224435e-20,  9.556427472894152e-23, -7.108448102491489e-25,  1.388100973851370e-02, -1.758997809820601e-04,  2.546792156916557e-06, -3.126839765498606e-08,
  3.518591500708594e-10, -3.707068367032206e-12,  3.704218327830073e-14, -3.539454812384294e-16,  3.257303235360223e-18, -2.898334608964463e-20,  2.506802092197273e-22,
 -2.108618110766151e-24,  5.292879328695961e-03, -9.134634006330824e-05,  1.594686085316362e-06, -2.318538396722546e-08,  3.053925110663794e-10, -3.725178266622825e-12,
  4.272570370775008e-14, -4.654676304878243e-16,  4.854579104784523e-18, -4.872735569909327e-20,  4.730283195299695e-22, -4.453192440576918e-24,  1.655995687819400e-03,
 -3.804607756265357e-05,  7.898712954609231e-07, -1.350165030721575e-08,  2.063351278376915e-10, -2.890028522111477e-12,  3.775908642111182e-14, -4.656190194005436e-16,
  5.466237837339077e-18, -6.147777874092746e-20,  6.658077913353822e-22, -6.968963931522939e-24,  4.240422463261538e-04, -1.270191923666543e-05,  3.116104030139043e-07,
 -6.226528463517150e-09,  1.097108619163784e-10, -1.754550606567228e-12,  2.597680215206748e-14, -3.607664108013847e-16,  4.744906393425573e-18, -5.951932891396065e-20,
  7.160305698128572e-22, -8.296115108651291e-24,  8.861772435497330e-05, -3.400152170893600e-06,  9.828601263144252e-08, -2.285786265186644e-09,  4.624271512334517e-11,
 -8.412388448539690e-13,  1.406423503501806e-14, -2.192463907291544e-16,  3.220301767176038e-18, -4.491428757651358e-20,  5.984401631916297e-22, -7.652723133994118e-24,
  1.507076113422524e-05, -7.299872455717839e-07,  2.483493541775449e-08, -6.702395033253569e-10,  1.552940530803803e-11, -3.206323576406891e-13,  6.040307303639760e-15,
 -1.054799895112642e-16,  1.726845498820686e-18, -2.672864395064568e-20,  3.937131693379915e-22, -5.546746094154392e-24,  2.080052368665854e-06, -1.257180541725770e-07,
  5.032965663216402e-09, -1.573680529016880e-10,  4.171236981837904e-12, -9.764500592581916e-14,  2.070822255476062e-15, -4.047154793748765e-17,  7.378424571163032e-19,
 -1.266296307496935e-20,  2.060247096951563e-22, -3.194830559335081e-24,  2.325055324956798e-07, -1.737572863939638e-08,  8.189680093383435e-10, -2.965754908574959e-11,
  8.993343332768351e-13, -2.387097403075190e-14,  5.699526725516063e-16, -1.246714775390135e-17,  2.531176505607466e-19, -4.816536825595456e-21,  8.655116089221888e-23,
 -1.477135497511390e-24,  2.103319834750262e-08, -1.930161303736706e-09,  1.072234467767916e-10, -4.500700742863856e-12,  1.563040004612044e-13, -4.709178398400132e-15,
  1.267159594922669e-16, -3.105202389559970e-18,  7.026817792567944e-20, -1.483695061008865e-21,  2.946660235336401e-23, -5.537919736488200e-25,  1.542847151235386e-09,
 -1.729736513051576e-10,  1.134397103343467e-11, -5.529211083462915e-13,  2.203593023011401e-14, -7.550698745660904e-16,  2.294047291096294e-17, -6.308809192344311e-19,
  1.593772185867332e-20, -3.739570153617803e-22,  8.219218177811520e-24, -1.703055750441990e-25,  9.237883122593650e-11, -1.260716509118626e-11,  9.781872257476173e-13,
 -5.551103626412004e-14,  2.545960201597568e-15, -9.949073451570614e-17,  3.421826829431828e-18, -1.058627090863844e-19,  2.992285884795467e-21, -7.818007941829833e-23,
  1.905174362833204e-24, -4.359490983205121e-26,  4.582965821467677e-12, -7.592742709939727e-13,  6.986804911268791e-14, -4.631183169317055e-15,  2.452690111423106e-16,
 -1.096694777286885e-17,  4.283293650744094e-19, -1.495068139012529e-20,  4.740844688081518e-22, -1.382591653340092e-23,  3.743740685140191e-25, -9.478599318975389e-27,
  1.939890910227251e-13, -3.891251311895809e-14,  4.256038126240649e-15, -3.305842718672996e-16,  2.028710882420437e-17, -1.041478964526872e-18,  4.633882734269152e-20,
 -1.830198920655916e-21,  6.527939292495763e-23, -2.130011260645084e-24,  6.421916530871998e-26, -1.802218500763422e-27,  7.392848826061832e-15, -1.788257642269889e-15,
  2.326798350752136e-16, -2.122449555744109e-17,  1.513058046488774e-18, -8.940428856892248e-20,  4.542136890580615e-21, -2.034108880496606e-22,  8.175158645695306e-24,
 -2.988792294074579e-25,  1.004478141229349e-26, -3.127055378528734e-28,  2.785956874164015e-16, -8.061390481663684e-17,  1.244335911541319e-17, -1.331436789992048e-18,
  1.101992225744907e-19, -7.491650150531790e-21,  4.343919569583657e-22, -2.204324616808160e-23,  9.973803659119971e-25, -4.080957611304561e-26,  1.526728895894519e-27,
 -5.263526717685691e-29,  1.209207066924717e-17, -4.117859779985608e-18,  7.459564426797956e-19, -9.281934097455019e-20,  8.851584166402142e-21, -6.874338639272942e-22,
  4.518227394492500e-23, -2.580615888776940e-24,  1.305772637223488e-25, -5.939620873226120e-27,  2.456872067405590e-28, -9.316505560084733e-30,  7.456621804247995e-19,
 -2.899031166109387e-19,  6.007483234864004e-20, -8.495575240431716e-21,  9.139018929139859e-22, -7.948403063694964e-23,  5.810887402659095e-24, -3.668614575457472e-25,
  2.040054957197396e-26, -1.014410512684339e-27,  4.564340918748379e-29, -1.873820081818276e-30,  7.262248020066869e-20, -3.068973353770881e-20,  6.938592649929216e-21,
 -1.066760181720918e-21,  1.241720498612799e-22, -1.163009297275629e-23,  9.114833683237955e-25, -6.142746868283591e-26,  3.631945211615718e-27, -1.913183107572138e-28,
  9.088488987378527e-30, -3.926351284240263e-31,  9.291250920554876e-02, -3.609647084303979e-04,  1.466337011295809e-06, -6.190567145411983e-09,  2.672943310476310e-11,
 -1.189131677991438e-13,  5.169064918992029e-16, -2.487461206856825e-18,  8.744962243824383e-21, -7.476138531691593e-23, -1.780042460110099e-25, -5.685800371814648e-27,
  7.651093424568793e-02, -3.565192290335707e-04,  2.116994358735347e-06, -1.326637237453133e-08,  8.204017642663366e-11, -4.958477359977845e-13,  2.919729171257559e-15,
 -1.697399124425427e-17,  9.547476304898293e-20, -5.518413454110934e-22,  2.822184441647435e-24, -1.837914054578461e-26,  5.185499450073987e-02, -3.227954627258273e-04,
  2.773528232834761e-06, -2.268905174137312e-08,  1.747980073178034e-10, -1.288263838856071e-12,  9.182482408925393e-15, -6.358153123144996e-17,  4.305943344202629e-19,
 -2.843655396399866e-21,  1.859690822279079e-23, -1.173033118228765e-25,  2.889433518952415e-02, -2.488705314957667e-04,  2.817628033218201e-06, -2.809956787879279e-08,
  2.597298331987775e-10, -2.274336839593759e-12,  1.909087181369755e-14, -1.544076076485102e-16,  1.212869751238075e-18, -9.241830918406033e-21,  6.918250509730906e-23,
 -5.010277016194709e-25,  1.321591095171617e-02, -1.569359579570330e-04,  2.203050942174110e-06, -2.618664854095165e-08,  2.858621779318429e-10, -2.926102391104267e-12,
  2.844693792248726e-14, -2.646387320480045e-16,  2.374087957118047e-18, -2.059025841668392e-20,  1.739283745324933e-22, -1.426465499508500e-24,  4.951357092684232e-03,
 -7.962400413257388e-05,  1.343489624160350e-06, -1.884355297476731e-08,  2.401717249206554e-10, -2.840103541668813e-12,  3.162772303761546e-14, -3.348876233866284e-16,
  3.398542019328710e-18, -3.321002633261942e-20,  3.142319678292389e-22, -2.883311991130015e-24,  1.515497011695194e-03, -3.232315685581632e-05,  6.459004302527483e-07,
 -1.061755655425819e-08,  1.566348137402902e-10, -2.122367570746205e-12,  2.687135540770045e-14, -3.215154695504007e-16,  3.666744799880596e-18, -4.009555038297598e-20,
  4.226068063363124e-22, -4.307285705907216e-24,  3.777859903454437e-04, -1.048053074589684e-05,  2.463673339737569e-07, -4.721158377510976e-09,  8.011700212078856e-11,
 -1.236965841915581e-12,  1.771457230746105e-14, -2.383273002323032e-16,  3.040477352090646e-18, -3.703322319558541e-20,  4.330253431736849e-22, -4.880303276744263e-24,
  7.643218187617074e-05, -2.712172896341498e-06,  7.479483036778215e-08, -1.664056633558840e-09,  3.235049788529696e-11, -5.670631869068310e-13,  9.154436391425958e-15,
 -1.380341228206888e-16,  1.963859469855263e-18, -2.656311576231596e-20,  3.436058855586830e-22, -4.269773434496492e-24,  1.250261254448163e-05, -5.596960135196031e-07,
  1.809428502090180e-08, -4.660958687261319e-10,  1.035606249296708e-11, -2.056531681488835e-13,  3.735026456011936e-15, -6.299783862534191e-17,  9.977295315821437e-19,
 -1.495963097923707e-20,  2.137068870865368e-22, -2.922972155519894e-24,  1.647173684377948e-06, -9.200603041502007e-08,  3.488341294017310e-09, -1.038932835493359e-10,
  2.635733213050772e-12, -5.924616663083262e-14,  1.209564345056492e-15, -2.280342958376145e-17,  4.017191503232355e-19, -6.671751068088043e-21,  1.051785173129313e-22,
 -1.582187809922811e-24,  1.741550753903255e-07, -1.203491206610477e-08,  5.357774506002374e-10, -1.844839771808235e-11,  5.345562339266138e-13, -1.360493674715112e-14,
  3.123184753590824e-16, -6.582863104313059e-18,  1.290215686344903e-19, -2.373871661477059e-21,  4.130308323997258e-23, -6.833776304304571e-25,  1.473785171406141e-08,
 -1.252107263625719e-09,  6.557641013281318e-11, -2.613618458220018e-12,  8.661962512840285e-14, -2.499516787502635e-15,  6.460265426913246e-17, -1.524171328922459e-18,
  3.327246846288806e-20, -6.788802873888114e-22,  1.304819491583972e-23, -2.376429693494597e-25,  9.975956142397786e-10, -1.037477770729105e-10,  6.408699372417595e-12,
 -2.963517685551595e-13,  1.126169421013523e-14, -3.693313610024950e-16,  1.077162988359150e-17, -2.850642686851605e-19,  6.944523285601594e-21, -1.574135937718830e-22,
  3.347692950621959e-24, -6.721463676407130e-26,  5.419183578969455e-11, -6.880246640807734e-12,  5.029082941805164e-13, -2.707406690352179e-14,  1.183825061317916e-15,
 -4.427148478808801e-17,  1.461595450069716e-18, -4.351515386666223e-20,  1.186229982168944e-21, -2.994667496566126e-23,  7.063135249521381e-25, -1.566634045996629e-26,
  2.387830968792016e-12, -3.695535663581770e-13,  3.208502955887522e-14, -2.019552501385611e-15,  1.020492118706017e-16, -4.369925576181259e-18,  1.639492260648533e-19,
 -5.511231709372411e-21,  1.686776664371613e-22, -4.757173594469549e-24,  1.247840575007037e-25, -3.065332895277236e-27,  8.742079803331124e-14, -1.647657226738595e-14,
  1.705885532026374e-15, -1.261375564700345e-16,  7.401264031274845e-18, -3.645846425451021e-19,  1.561120647443776e-20, -5.948755816402515e-22,  2.051586403524982e-23,
 -6.485127679824630e-25,  1.897453307607548e-26, -5.175725551952489e-28,  2.790368767379913e-15, -6.392819927370406e-16,  7.917630768324174e-17, -6.906514798687512e-18,
  4.726375692931572e-19, -2.689517651430022e-20,  1.319485514511601e-21, -5.719689805351234e-23,  2.229710372413226e-24, -7.921388874072462e-26,  2.591291571789703e-27,
 -7.864036309126007e-29,  8.496861307382274e-17, -2.353708081280922e-17,  3.487426061619688e-18, -3.594218052135226e-19,  2.874189293987097e-20, -1.892906261791509e-21,
  1.065764182656649e-22, -5.262273287711014e-24,  2.320959783989670e-25, -9.272248721556916e-27,  3.391864745004551e-28, -1.144987968042791e-29,  2.889244060177292e-18,
 -9.546043665661323e-19,  1.679169562247205e-19, -2.033210938398433e-20,  1.890820124858409e-21, -1.434773424694641e-22,  9.229820846115886e-24, -5.167631122046152e-25,
  2.566728100879501e-26, -1.147511269243880e-27,  4.670433174134502e-29, -1.744469523757907e-30,  1.391222376349102e-19, -5.324024603341111e-20,  1.085781732127412e-20,
 -1.512619676665336e-21,  1.604710435317170e-22, -1.377804352746930e-23,  9.953461277230047e-25, -6.214888295800707e-26,  3.420685039030125e-27, -1.684743213443853e-28,
  7.513242816792944e-30, -3.058938865057237e-31,  1.125096200284707e-20, -4.732682921524502e-21,  1.064825930512910e-21, -1.629507965797122e-22,  1.888494151227681e-23,
 -1.761560946730208e-24,  1.375308311472734e-25, -9.235418507447049e-27,  5.442184143344608e-28, -2.857720713671649e-29,  1.353524654177362e-30, -5.831137870321060e-32,
  9.149165131208087e-02, -3.495240656413592e-04,  1.394539868446221e-06, -5.781271420666169e-09,  2.446973839846224e-11, -1.073141257019523e-13,  4.507579719916194e-16,
 -2.252570108894556e-18,  5.861948997553566e-21, -8.720503059926647e-23, -4.483607808605418e-25, -6.191488424835524e-27,  7.511775153495209e-02, -3.401984748401170e-04,
  1.965358393534653e-06, -1.202941347155558e-08,  7.278716874631207e-11, -4.311498757282499e-13,  2.484390020745182e-15, -1.421639216491470e-17,  7.745493055102515e-20,
 -4.541009591003417e-22,  2.090090737057616e-24, -1.487693357703712e-26,  5.060652936884565e-02, -3.016506495511940e-04,  2.517227164318911e-06, -2.008701032778539e-08,
  1.510999868750441e-10, -1.087780323604072e-12,  7.580684014911622e-15, -5.130638305911691e-17,  3.404593837861740e-19, -2.193188573219953e-21,  1.415063787070561e-23,
 -8.648108087990500e-26,  2.794189491860424e-02, -2.276109422182858e-04,  2.503943025453438e-06, -2.428428475872349e-08,  2.184961370176971e-10, -1.863940474498257e-12,
  1.526437994618686e-14, -1.204252275768976e-16,  9.250948047821837e-19, -6.868737182657754e-21,  5.052853530707751e-23, -3.557051772044166e-25,  1.262152994588830e-02,
 -1.404949736200823e-04,  1.914436330835123e-06, -2.204630850472401e-08,  2.336088206198801e-10, -2.324349571747324e-12,  2.199811721288595e-14, -1.992988859004090e-16,
  1.744302582340771e-18, -1.474162780622853e-20,  1.217925539047269e-22, -9.736220120361258e-25,  4.653011653735302e-03, -6.971931495705383e-05,  1.138674393117632e-06,
 -1.541695976860867e-08,  1.902599038245645e-10, -2.182295035593897e-12,  2.360964200239126e-14, -2.430653326259105e-16,  2.401685567883622e-18, -2.285184014613757e-20,
  2.109126089371632e-22, -1.886586003816058e-24,  1.395788020731759e-03, -2.762600408695335e-05,  5.322316116145512e-07, -8.418776385896545e-09,  1.199706519920233e-10,
 -1.573450941744933e-12,  1.931590445987022e-14, -2.243497256802238e-16,  2.486873225921922e-18, -2.644848877936139e-20,  2.714425921784623e-22, -2.694840216871273e-24,
  3.394753989293226e-04, -8.716156474253797e-06,  1.966573391299518e-07, -3.616186830580197e-09,  5.914065333105022e-11, -8.820216960320962e-13,  1.222472284144117e-14,
 -1.593991930881952e-16,  1.973451465629334e-18, -2.334869107851798e-20,  2.654717888457714e-22, -2.911349158888601e-24,  6.666511578515287e-05, -2.185680057849523e-06,
  5.759289926630246e-08, -1.226438168193993e-09,  2.292650679248242e-11, -3.874319820975898e-13,  6.042508700937610e-15, -8.816668802075648e-17,  1.215555360425597e-18,
 -1.595099528881039e-20,  2.003900300626433e-22, -2.420544567016585e-24,  1.052151488322364e-05, -4.347811701298669e-07,  1.337386698288198e-08, -3.289735717432528e-10,
  7.013256672037170e-12, -1.340163284080037e-13,  2.347558691341206e-15, -3.825986353695100e-17,  5.864035341014421e-19, -8.519910712225202e-21,  1.180766486177295e-22,
 -1.568345632901852e-24,  1.327972236147529e-06, -6.845004569295898e-08,  2.460123085126637e-09, -6.981720299940694e-11,  1.696048527659066e-12, -3.662190513623376e-14,
  7.200166485815165e-16, -1.309842006696793e-17,  2.230377837718973e-19, -3.585556874331197e-21,  5.478375890645085e-23, -7.996111556365512e-25,  1.333667839340526e-07,
 -8.507130040380764e-09,  3.579010226864568e-10, -1.172020965591162e-11,  3.245973408890460e-13, -7.923462081685369e-15,  1.749252841197390e-16, -3.553456756422008e-18,
  6.724696722795767e-20, -1.196523917712641e-21,  2.016023083474573e-23, -3.234123005572990e-25,  1.060887412757035e-08, -8.327052361784064e-10,  4.111667047160705e-11,
 -1.555988289230126e-12,  4.921472705460358e-14, -1.360291217842571e-15,  3.377265514138930e-17, -7.671826798400545e-19,  1.615664709911265e-20, -3.185613705598865e-22,
  5.925519164923410e-24, -1.045816504328239e-25,  6.663057790313326e-10, -6.412185901572195e-11,  3.728883962962508e-12, -1.635325049305973e-13,  5.924247394636009e-15,
 -1.859202135905902e-16,  5.204452280425765e-18, -1.325221202747393e-19,  3.112747392917284e-21, -6.815232492564335e-23,  1.402193515990555e-24, -2.727539930870934e-26,
  3.303903923542376e-11, -3.891227493172396e-12,  2.676507284026791e-13, -1.365855348642511e-14,  5.690426432709632e-16, -2.035497631119591e-17,  6.447741688961331e-19,
 -1.846582168667463e-20,  4.852799503676855e-22, -1.183287523931046e-23,  2.700122694240434e-25, -5.803062107351934e-27,  1.301398671364483e-12, -1.875298201940020e-13,
  1.533472598907888e-14, -9.153905566668165e-16,  4.408698931919590e-17, -1.806356975046079e-18,  6.504726138599727e-20, -2.104252897984213e-21,  6.211740821606283e-23,
 -1.693027966791763e-24,  4.299215703749307e-26, -1.024029478287458e-27,  4.147148830439628e-14, -7.316376397249086e-15,  7.152975701267820e-16, -5.025479354148246e-17,
  2.814980668288303e-18, -1.328704445595960e-19,  5.468489335565003e-21, -2.008139407026971e-22,  6.689238556939428e-24, -2.046386604118706e-25,  5.804845714010493e-27,
 -1.537610401172029e-28,  1.114132105351635e-15, -2.407419280393110e-16,  2.829378144761309e-17, -2.354244430238384e-18,  1.543262578288762e-19, -8.441216553238144e-21,
  3.992259149635284e-22, -1.672464603459549e-23,  6.314698269358805e-25, -2.177033713630687e-26,  6.922946661259703e-28, -2.045618613296476e-29,  2.744034520632535e-17,
 -7.245179809070529e-18,  1.026837928884648e-18, -1.016312248566422e-19,  7.831850640071653e-21, -4.985272205653129e-22,  2.719822443474501e-23, -1.304190401729079e-24,
  5.597298678025384e-26, -2.179723331856099e-27,  7.784759247752956e-29, -2.569412975926701e-30,  7.259791237793058e-19, -2.318186770629852e-19,  3.946195348123276e-20,
 -4.635991665838551e-21,  4.193294746639349e-22, -3.101629771919291e-23,  1.948718005205116e-24, -1.067453822186305e-25,  5.195307434660416e-27, -2.279109899697994e-28,
  9.113531155810621e-30, -3.348281455914637e-31,  2.682031543935794e-20, -1.007772734653866e-20,  2.017967297113069e-21, -2.763607878206809e-22,  2.885929385657977e-23,
 -2.442033180340850e-24,  1.740595393676861e-25, -1.073381882724657e-26,  5.840174960810213e-28, -2.845736987366008e-29,  1.256491430607018e-30, -5.068465262092840e-32,
  1.762444151036351e-21, -7.374123645460830e-22,  1.649892310287871e-22, -2.511434229074867e-23,  2.896114311431486e-24, -2.688920642484473e-25,  2.090245092751442e-26,
 -1.397965200232730e-27,  8.206741581199531e-29, -4.294179336512788e-30,  2.027148014319813e-31, -8.706083848951788e-33,  9.011543749678701e-02, -3.386387513568363e-04,
  1.327444725203647e-06, -5.406359179584969e-09,  2.242662571588208e-11, -9.723463821552112e-14,  3.898126241315527e-16, -2.119172773638127e-18,  2.340692048058020e-21,
 -1.097517086483857e-22, -6.430059321557769e-25, -1.093548977384070e-27,  7.378751624643051e-02, -3.250338563807480e-04,  1.827718577143160e-06, -1.093069359631544e-08,
  6.472956744056514e-11, -3.760357046990415e-13,  2.118681227833970e-15, -1.198446922479774e-17,  6.246559444117627e-20, -3.823225376868583e-22,  1.535459337373035e-24,
 -9.776353681548837e-27,  4.943873171301600e-02, -2.824375010766041e-04,  2.290001441693929e-06, -1.783403736280668e-08,  1.310534482669455e-10, -9.219209756285061e-13,
  6.285499422598854e-15, -4.157273063617739e-17,  2.708404892321235e-19, -1.696310510983524e-21,  1.084945941015240e-23, -6.503261656203429e-26,  2.706974895591761e-02,
 -2.086883220606140e-04,  2.232338519785944e-06, -2.106776135102815e-08,  1.846240213644575e-10, -1.534928345803531e-12,  1.227235602616014e-14, -9.441714043483970e-17,
  7.107264734688162e-19, -5.128527081968434e-21,  3.720204072177415e-23, -2.567035687922596e-25,  1.208859078484825e-02, -1.261775198053528e-04,  1.670861000827815e-06,
 -1.865356757507079e-08,  1.919800001723120e-10, -1.857510497743887e-12,  1.712566231487877e-14, -1.511099018514120e-16,  1.291877215391438e-18, -1.062896499342472e-20,
  8.602959912590830e-23, -6.723419622771949e-25,  4.391250420410542e-03, -6.130131114055448e-05,  9.705892724242340e-07, -1.269334847144180e-08,  1.517709018098502e-10,
 -1.689354792579270e-12,  1.776682590845652e-14, -1.778952645370961e-16,  1.712809589470742e-18, -1.586689574266139e-20,  1.429701553629716e-22, -1.248114830597595e-24,
  1.293202992648176e-03, -2.374185842790297e-05,  4.417611208268181e-07, -6.727794763115939e-09,  9.267162183883366e-11, -1.177068433872058e-12,  1.401878946808283e-14,
 -1.581202643425084e-16,  1.704625319043292e-18, -1.763619044542753e-20,  1.763440730911652e-22, -1.706347405819849e-24,  3.075035245574768e-04, -7.301632621403396e-06,
  1.584062452160206e-07, -2.796517178843477e-09,  4.410646775574221e-11, -6.357596296200969e-13,  8.532567582833864e-15, -1.078748231500201e-16,  1.296744064783723e-18,
 -1.490822772372258e-20,  1.648951266325761e-22, -1.760413439240712e-24,  5.875875976729070e-05, -1.778111458412386e-06,  4.484428751621068e-08, -9.144903032544072e-10,
  1.644875791800844e-11, -2.681203676743076e-13,  4.042013902574499e-15, -5.709636849603962e-17,  7.631680767483414e-19, -9.719359106201722e-21,  1.186311329764184e-22,
 -1.393429871817785e-24,  8.973817623797294e-06, -3.418588412711230e-07,  1.002001137166458e-08, -2.354722799081329e-10,  4.819435657855919e-12, -8.866366974282442e-14,
  1.498674516525257e-15, -2.361061312599756e-17,  3.503458882555188e-19, -4.934184296523687e-21,  6.636189001894800e-23, -8.562497900786275e-25,  1.088812801231788e-06,
 -5.170909191084757e-08,  1.763699356594165e-09, -4.771260810848345e-11,  1.110419257433346e-12, -2.304176393910348e-14,  4.364354921398079e-16, -7.663950301655054e-18,
  1.261796335729843e-19, -1.964051393998202e-21,  2.909180089934158e-23, -4.120950270786125e-25,  1.042843922358325e-07, -6.128914941185148e-09,  2.438463382158247e-10,
 -7.596217733238583e-12,  2.011569925714340e-13, -4.710907642798282e-15,  1.000464012232568e-16, -1.959251381166540e-18,  3.580832702691272e-20, -6.162720169518741e-22,
  1.005706704209885e-23, -1.564519253689749e-25,  7.834158022715074e-09, -5.668868432524314e-10,  2.639659578806837e-11, -9.485334516566876e-13,  2.863664881651034e-14,
 -7.582578215445542e-16,  1.808615055299186e-17, -3.956203679373787e-19,  8.038462765684931e-21, -1.531723893167961e-22,  2.757486960949565e-24, -4.716417486908116e-26,
  4.590031206748616e-10, -4.077299032728965e-11,  2.231481754845466e-12, -9.278992945156950e-14,  3.204145165703127e-15, -9.621624023552845e-17,  2.584919564994795e-18,
 -6.332551343888756e-20,  1.434014381359837e-21, -3.032399164439028e-23,  6.035200191769083e-25, -1.137229836532230e-26,  2.090216314651133e-11, -2.277089735559293e-12,
  1.472513975995436e-13, -7.118502336613198e-15,  2.824433987379866e-16, -9.659971865066520e-18,  2.934906373096574e-19, -8.082759582932609e-21,  2.047105193596836e-22,
 -4.819696565070907e-24,  1.063704189517475e-25, -2.214423642574048e-27,  7.409646734558630e-13, -9.907891432159033e-14,  7.618578735278565e-15, -4.308055094795851e-16,
  1.975771793204585e-17, -7.739567174498253e-19,  2.673159238539427e-20, -8.316458949870313e-22,  2.366413940372571e-23, -6.229340875385975e-25,  1.530492595005759e-26,
 -3.532755359077326e-28,  2.069464447578420e-14, -3.404170056079347e-15,  3.135438147362167e-16, -2.089373429108912e-17,  1.115615583695009e-18, -5.039342100241020e-20,
  1.991197886996272e-21, -7.039108168041074e-23,  2.262501527288478e-24, -6.692282325593114e-26,  1.838815359923784e-27, -4.725790720690318e-29,  4.707507011487606e-16,
 -9.551800246007379e-17,  1.062013127408565e-17, -8.408593099646769e-19,  5.268991037064694e-20, -2.765135349179742e-21,  1.258623795848238e-22, -5.087986919209050e-24,
  1.858016405988037e-25, -6.207948743543133e-27,  1.916651650132150e-28, -5.507658423891912e-30,  9.403000065511955e-18, -2.355384024242848e-18,  3.181490674618597e-19,
 -3.014806708652424e-20,  2.232941814431424e-21, -1.370552924018989e-22,  7.230183007282277e-24, -3.360462874981074e-25,  1.400896785731886e-26, -5.309035740013530e-28,
  1.848324495206110e-29, -5.956117584323428e-31,  1.925828843544568e-19, -5.917554915894774e-20,  9.712304086979268e-21, -1.103493296450458e-21,  9.680573022433134e-23,
 -6.962138393646412e-24,  4.262494223218171e-25, -2.279650972062003e-26,  1.085133043701538e-27, -4.662922940712386e-29,  1.828952923135317e-30, -6.599635601384192e-32,
  5.364789833827381e-21, -1.973492642585336e-21,  3.869538849616341e-22, -5.196931872957269e-23,  5.330438515761578e-24, -4.436759009804083e-25,  3.114710228484545e-26,
 -1.894041145499063e-27,  1.017264047371394e-28, -4.897637541143305e-30,  2.138487084793162e-31, -8.537389096337068e-33,  2.796266244088945e-22, -1.162685702260132e-22,
  2.584615984428170e-23, -3.910187368548028e-24,  4.483396629672598e-25, -4.140586986789723e-26,  3.202860660423200e-27, -2.132281500452908e-28,  1.246416399949557e-29,
 -6.495927411092458e-31,  3.055118965371074e-32, -1.307537350383338e-33,  8.878171914466983e-02, -3.282727433474999e-04,  1.264658787961765e-06, -5.062602465319827e-09,
  2.057070930658843e-11, -8.858653968186510e-14,  3.308956598378938e-16, -2.112303406245917e-18, -2.046430608889187e-21, -1.319186230624037e-22, -3.151877421056265e-25,
  1.979088043038351e-26,  7.251581770994575e-02, -3.109197287891685e-04,  1.702524755901343e-06, -9.952533656938936e-09,  5.769127093890229e-11, -3.290005732756003e-13,
  1.809111896276172e-15, -1.019462798986453e-17,  4.972695682638578e-20, -3.268542592822249e-22,  1.319008391402415e-24,  1.467035870635105e-27,  4.834431488669702e-02,
 -2.649392267634259e-04,  2.087991165985696e-06, -1.587687210227807e-08,  1.140340941597904e-10, -7.841116327670627e-13,  5.234185160418578e-15, -3.380447741721044e-17,
  2.169358411914874e-19, -1.315244524837067e-21,  8.293340275904204e-24, -5.277791615257346e-26,  2.626917987950127e-02, -1.917928821150863e-04,  1.996285726102557e-06,
 -1.834421709453807e-08,  1.566692756580943e-10, -1.269706823533269e-12,  9.921252000798239e-15, -7.436153031088536e-17,  5.503557771994920e-19, -3.845668849232926e-21,
  2.738796576273180e-23, -1.953042155017749e-25,  1.160926698281886e-02, -1.136564696253978e-04,  1.464290914028287e-06, -1.585811621586642e-08,  1.586199562541898e-10,
 -1.492927276372092e-12,  1.342024176130904e-14, -1.152818494163446e-16,  9.646441128784844e-19, -7.715093052425810e-21,  6.109299808152592e-23, -4.757339462905585e-25,
  4.160664984150723e-03, -5.410702127906900e-05,  8.317947970706674e-07, -1.051373139460294e-08,  1.218742825944035e-10, -1.317021099848327e-12,  1.347451363576834e-14,
 -1.312200788708402e-16,  1.232550837305811e-18, -1.111233439457662e-20,  9.773624774696557e-23, -8.379784747872026e-25,  1.204825792528807e-03, -2.050717435332784e-05,
  3.692025480162549e-07, -5.416500732863833e-09,  7.216567869104440e-11, -8.881233497847477e-13,  1.026856458210991e-14, -1.125036787089448e-16,  1.180471046792820e-18,
 -1.188251415069909e-20,  1.157809748495421e-22, -1.094324036453814e-24,  2.806347067373759e-04, -6.157517368499166e-06,  1.286960842134769e-07, -2.182357306722419e-09,
  3.321671489405312e-11, -4.629888030770866e-13,  6.020598861966504e-15, -7.383057382600052e-17,  8.622167843756438e-19, -9.635047049986821e-21,  1.037064467681515e-22,
 -1.078796253429823e-24,  5.230014035088194e-05, -1.459154440123044e-06,  3.528822455972730e-08, -6.894363990086599e-10,  1.193993982803538e-11, -1.878301004020387e-13,
  2.738508964626945e-15, -3.746528532241917e-17,  4.857270877185758e-19, -6.005769696139034e-21,  7.124513079576416e-23, -8.141621109996138e-25,  7.750494264108590e-06,
 -2.718136353953635e-07,  7.604258672829849e-09, -1.707971414750454e-10,  3.358207327233933e-12, -5.950928269679910e-14,  9.710945849892933e-16, -1.479490559376701e-17,
  2.126274655661294e-19, -2.903817480955935e-21,  3.791318341483471e-23, -4.753686403573210e-25,  9.069539428891724e-07, -3.961932578221034e-08,  1.284202974300683e-09,
 -3.312898667748729e-11,  7.390541132238563e-13, -1.474423471867649e-14,  2.691607921650867e-16, -4.564140616461472e-18,  7.268145418201516e-20, -1.095733662913427e-21,
  1.573862841068100e-23, -2.164263512942915e-25,  8.316173002886937e-08, -4.494444947395048e-09,  1.692703149314316e-10, -5.017550793848704e-12,  1.270977214313537e-13,
 -2.856643827908947e-15,  5.837847131032209e-17, -1.102439641856848e-18,  1.946407556582073e-20, -3.240866074756427e-22,  5.123575151408419e-24, -7.730554245426883e-26,
  5.926517067421298e-09, -3.944706206948628e-10,  1.733009770178608e-11, -5.913858403223586e-13,  1.704598286051574e-14, -4.324753119138507e-16,  9.912148234873003e-18,
 -2.088186896868677e-19,  4.094178201635335e-21, -7.540335054633204e-23,  1.313907530300114e-24, -2.178040092630968e-26,  3.256247477618675e-10, -2.663052914215322e-11,
  1.371568653040639e-12, -5.406849332372547e-14,  1.779634147335245e-15, -5.113366925435110e-17,  1.318424158739000e-18, -3.107424330801257e-20,  6.783987281591772e-22,
 -1.385473041783743e-23,  2.667221728657929e-25, -4.868329329479856e-27,  1.370064334410381e-11, -1.376473045880210e-12,  8.362590678503579e-14, -3.827720175318605e-15,
  1.445888044995667e-16, -4.726851863632035e-18,  1.377081262760454e-19, -3.646050654245916e-21,  8.897235434822705e-23, -2.022137831852846e-24,  4.315316022170132e-26,
 -8.699779966455909e-28,  4.400848573200484e-13, -5.441865781974733e-14,  3.929324115152614e-15, -2.102640307398360e-16,  9.175564501198205e-18, -3.434071911135714e-19,
  1.136945679431915e-20, -3.399817477714968e-22,  9.319958927065956e-24, -2.368333677189538e-25,  5.627015859004552e-27, -1.258069560395202e-28,  1.085195397909371e-14,
 -1.657814814255294e-15,  1.435390884619741e-16, -9.057464757157193e-18,  4.603917900174117e-19, -1.987885996842710e-20,  7.533244637466047e-22, -2.561210138854903e-23,
  7.936216240838028e-25, -2.267781466366211e-26,  6.030719634381692e-28, -1.502593116685452e-29,  2.104863301974618e-16, -3.992244988075296e-17,  4.186578133189039e-18,
 -3.146729360124154e-19,  1.881120889979267e-20, -9.455246000177530e-22,  4.135580801533848e-23, -1.610914328153155e-24,  5.682002202608491e-26, -1.837547498951208e-27,
  5.501543687242544e-29, -1.535694378400652e-30,  3.424817661336210e-18, -8.098460275962174e-19,  1.038624628590013e-19, -9.394040230943451e-21,  6.669613022879373e-22,
 -3.938183632231499e-23,  2.004632472172788e-24, -9.013565083711035e-26,  3.643345122351519e-27, -1.341459270938558e-28,  4.545545130080628e-30, -1.428021860932289e-31,
  5.414362829455120e-20, -1.593206368709065e-20,  2.511045514837263e-21, -2.749739432154668e-22,  2.332573497289089e-23, -1.626758029745616e-24,  9.681923491835865e-26,
 -5.044545240512481e-27,  2.343804079396542e-28, -9.847347697189917e-30,  3.782232401266705e-31, -1.338330642611614e-32,  1.118610579424156e-21, -4.014637233248606e-22,
  7.683850788143236e-23, -1.009224882964010e-23,  1.014246718275392e-24, -8.285762645902468e-26,  5.717903433970182e-27, -3.422588310785149e-28,  1.811651583425457e-29,
 -8.605530103038603e-31,  3.710855130227933e-32, -1.464417231968856e-33,  4.502555419284723e-23, -1.858462005476305e-23,  4.100217263036146e-24, -6.159102882228856e-25,
  7.015521076462409e-26, -6.439671922500907e-27,  4.953226269204512e-28, -3.280378254931811e-29,  1.908250820045907e-30, -9.900435581853416e-32,  4.636774338211986e-33,
 -1.976707280258307e-34,  8.748848567913352e-02, -3.183930146779755e-04,  1.205825221669123e-06, -4.747233773719421e-09,  1.887354575760891e-11, -8.136659809888807e-14,
  2.701163243829643e-16, -2.253801252637303e-18, -6.702498591455420e-21, -1.144793298569516e-22,  1.570587822957943e-24,  7.271425253771559e-26,  7.129864431119090e-02,
 -2.977620455550435e-04,  1.588422957646928e-06, -9.079848285151071e-09,  5.152320942539683e-11, -2.888379693953892e-13,  1.544245998880153e-15, -8.780990051251854e-18,
  3.897759435509983e-20, -2.668535008580867e-22,  1.857327917838493e-24,  2.578711246154194e-26,  4.731680146772890e-02, -2.489675190707993e-04,  1.907919722790919e-06,
 -1.417126732386157e-08,  9.953527381001931e-11, -6.691066252549175e-13,  4.378159569144782e-15, -2.756053868052426e-17,  1.750113324400709e-19, -1.028727070058170e-21,
  6.040795899096085e-24, -5.169111997580699e-26,  2.553261248042967e-02, -1.766623539600308e-04,  1.790397420762557e-06, -1.602839814824057e-08,  1.334973561527668e-10,
 -1.054712929917640e-12,  8.066289143984773e-15, -5.876996972136465e-17,  4.296565437864998e-19, -2.911938128509699e-21,  1.948162845075831e-23, -1.702085281802184e-25,
  1.117692259721409e-02, -1.026623480213394e-04,  1.288289535843343e-06, -1.354260314088097e-08,  1.317378060342034e-10, -1.206328762051932e-12,  1.058589424503860e-14,
 -8.842394701488360e-17,  7.262158089778208e-19, -5.650091742189359e-21,  4.301810168704238e-23, -3.572867287860019e-25,  3.956790869223040e-03, -4.792606581256521e-05,
  7.165144037925915e-07, -8.758068996104904e-09,  9.849169485092956e-11, -1.033610166260668e-12,  1.029738223764274e-14, -9.749145169395893e-17,  8.947864157962309e-19,
 -7.854775323168786e-21,  6.703113692032923e-23, -5.778211951107641e-25,  1.128318717103859e-03, -1.779518491412814e-05,  3.105869053604657e-07, -4.391558405565148e-09,
  5.663300150365894e-11, -6.755759421068260e-13,  7.588870116882711e-15, -8.076551010489471e-17,  8.256251251166370e-19, -8.088901416789366e-21,  7.666489467955628e-23,
 -7.133219893568443e-25,  2.579098030969029e-04, -5.224322910690913e-06,  1.054146656882219e-07, -1.717767831345928e-09,  2.524928518298085e-11, -3.404777444359374e-13,
  4.292683092075839e-15, -5.107323689634134e-17,  5.798458128489874e-19, -6.300731441015753e-21,  6.597085295876854e-23, -6.704631152703759e-25,  4.697997275166939e-05,
 -1.206957879023151e-06,  2.804791789406525e-08, -5.252066104627787e-10,  8.763904629365006e-12, -1.331195483938362e-13,  1.878133379381903e-15, -2.489447729113895e-17,
  3.132185809531451e-19, -3.761446186048921e-21,  4.337293144287231e-23, -4.827252778457535e-25,  6.773107146635445e-06, -2.183472704969880e-07,  5.841552603030281e-09,
 -1.254491587024767e-10,  2.371128307767075e-12, -4.049229855739396e-14,  6.382504868822779e-16, -9.407259110995913e-18,  1.310027136604968e-19, -1.735494657510310e-21,
  2.200268582533313e-23, -2.682270490985844e-25,  7.667629642511590e-07, -3.075519955232096e-08,  9.489017903266526e-10, -2.335136251599745e-11,  4.996345942372707e-13,
 -9.587635613114252e-15,  1.687651949254986e-16, -2.764434498328803e-18,  4.259521267766819e-20, -6.221597890513988e-22,  8.668152308188193e-24, -1.157523482876311e-25,
  6.755458731625855e-08, -3.350449205442189e-09,  1.195963884060593e-10, -3.374279083164447e-12,  8.179800878017838e-14, -1.765113282288364e-15,  3.472375781849979e-17,
 -6.325237098167880e-19,  1.079114528327652e-20, -1.738783787283145e-22,  2.663591391520360e-24, -3.898781003593884e-26,  4.586744717798978e-09, -2.801621283106502e-10,
  1.162146301563559e-11, -3.766712227660342e-13,  1.036884523840901e-14, -2.521294127037330e-16,  5.554072657432012e-18, -1.127123397939778e-19,  2.132808334569559e-21,
 -3.797174833954313e-23,  6.405206639881969e-25, -1.029167846930439e-26,  2.375319029007094e-10, -1.783706854372748e-11,  8.646987892809985e-13, -3.231345544489665e-14,
  1.013866566446969e-15, -2.787578599665601e-17,  6.898502524541127e-19, -1.564358982353128e-20,  3.292655763842222e-22, -6.494524736171671e-24,  1.209383042167601e-25,
 -2.138164891708173e-27,  9.289192778125056e-12, -8.580378469596478e-13,  4.895317051606780e-14, -2.120704057325459e-15,  7.624783334481540e-17, -2.382183776038781e-18,
  6.653636999596253e-20, -1.693357211210452e-21,  3.980709653399493e-23, -8.732066403052867e-25,  1.801525556668052e-26, -3.516480064790972e-28,  2.722388850748359e-13,
 -3.102055718513800e-14,  2.100808761611672e-15, -1.062922069522685e-16,  4.410651958496374e-18, -1.576298625793398e-19,  5.000088425538248e-21, -1.436468484011775e-22,
  3.792005354509994e-24, -9.297972258884706e-26,  2.135428255774159e-27, -4.622444822759007e-29,  5.972684887336277e-15, -8.438975694238392e-16,  6.854897575471480e-17,
 -4.089924143297188e-18,  1.976713322056141e-19, -8.150180325090574e-21,  2.959425288284167e-22, -9.668517642834365e-24,  2.885864071947197e-25, -7.960351252074211e-27,
  2.047304951069560e-28, -4.941718639497635e-30,  9.955896735101994e-17, -1.756775872835963e-17,  1.732564941499582e-18, -1.233450135104748e-19,  7.021357646082995e-21,
 -3.374706536305314e-22,  1.416269821179183e-23, -5.308618683843164e-25,  1.806296604637524e-26, -5.647411494342258e-28,  1.637784421739349e-29, -4.436140079342496e-31,
  1.327627385160609e-18, -2.947879870609298e-19,  3.576003568727321e-20, -3.077652286445340e-21,  2.089097093293539e-22, -1.183934109817958e-23,  5.802948593724972e-25,
 -2.519402143288015e-26,  9.856788638413883e-28, -3.520220023948764e-29,  1.159198641048858e-30, -3.545215407229166e-32,  1.619336692098112e-20, -4.538727837970864e-21,
  6.839745779068800e-22, -7.192526013643573e-23,  5.881145377352470e-24, -3.966228245314909e-25,  2.288971890051468e-26, -1.159216266058365e-27,  5.246151145043580e-29,
 -2.150928390264065e-30,  8.075444708868571e-32, -2.797447057334448e-33,  2.443808477242928e-22, -8.522205871589509e-23,  1.586426091238435e-23, -2.031301865862169e-24,
  1.994616537028925e-25, -1.595365722482531e-26,  1.079834171143635e-27, -6.349761668242399e-29,  3.306528241792248e-30, -1.547090835035936e-31,  6.578724654121722e-33,
 -2.562796645540853e-34,  7.376036313319821e-24, -3.018113680648359e-24,  6.599843126848778e-25, -9.831852022873773e-26,  1.111344721319514e-26, -1.012954142967361e-27,
  7.740951361846073e-29, -5.095997597540656e-30,  2.948062160978702e-31, -1.521697127401705e-32,  7.092867569970174e-34, -3.010431853674152e-35,  8.623385312133494e-02,
 -3.089692680185658e-04,  1.150617656023082e-06, -4.457945400941810e-09,  1.730579083143682e-11, -7.566851276298032e-14,  2.035174453994439e-16, -2.514365247638801e-18,
 -8.693557206184421e-21,  3.812402536427395e-23,  6.788639643813043e-24,  1.727412291923319e-25,  7.013234004989050e-02, -2.854769066545572e-04,  1.484226673621368e-06,
 -8.299758480098219e-09,  4.609784661515806e-11, -2.545938323661095e-13,  1.314514266806353e-15, -7.670206690032375e-18,  3.108220302789357e-20, -1.585258300441459e-22,
  3.876683768779594e-24,  6.935955347537446e-26,  4.635041801653797e-02, -2.343582897336980e-04,  1.746996093742085e-06, -1.268030229641163e-08,  8.714452341101493e-11,
 -5.726909604492793e-13,  3.679608150156647e-15, -2.251067639798122e-17,  1.417559474146295e-19, -8.352507331072698e-22,  3.541467468580248e-24, -6.424328027439895e-26,
  2.485344049722939e-02, -1.630737639185598e-04,  1.610208886603012e-06, -1.405120880647989e-08,  1.142133534573571e-10, -8.794069102214580e-13,  6.598444180814610e-15,
 -4.656249283457863e-17,  3.370446785661667e-19, -2.283422481450384e-21,  1.185355082988449e-23, -1.825479771407677e-25,  1.078590487779409e-02, -9.297199193354586e-05,
  1.137671473985134e-06, -1.161480368768102e-08,  1.099641147387781e-10, -9.795285578117111e-13,  8.406986278805960e-15, -6.813683379572612e-17,  5.501912691424571e-19,
 -4.223248478566464e-21,  2.872989512716506e-23, -3.013091100337536e-25,  3.775921077189561e-03, -4.258903638357878e-05,  6.202316892071960e-07, -7.335024799886887e-09,
  8.008542926342122e-11, -8.162385224442931e-13,  7.929393518619292e-15, -7.291160498376983e-17,  6.546413477430040e-19, -5.629271641995268e-21,  4.539361026021704e-23,
 -4.194614331130706e-25,  1.061794079293014e-03, -1.550684649134878e-05,  2.629091692079709e-07, -3.584345070962619e-09,  4.477399523016077e-11, -5.178441486046032e-13,
  5.657426830572573e-15, -5.846941284127079e-17,  5.827851115300446e-19, -5.572037874861066e-21,  5.089601458067130e-23, -4.766460414005422e-25,  2.385776521983368e-04,
 -4.457074063606687e-06,  8.701755684585043e-08, -1.363109059569059e-09,  1.936414889769743e-11, -2.527099477958040e-13,  3.091625858713672e-15, -3.569072257568760e-17,
  3.941699787303043e-19, -4.170198528138088e-21,  4.234629080548500e-23, -4.236273606463434e-25,  4.256410948846530e-05, -1.005588200363770e-06,  2.250624596943315e-08,
 -4.040522893768184e-10,  6.501167980835812e-12, -9.539039621392202e-14,  1.303219480750102e-15, -1.674078308224113e-17,  2.045149544357027e-19, -2.387157049396628e-21,
  2.673456870978887e-23, -2.905438025935079e-25,  5.984484444606719e-06, -1.770480158354525e-07,  4.539536382416446e-09, -9.323931342902235e-11,  1.695350401907592e-12,
 -2.791360281092441e-14,  4.252332797386261e-16, -6.065626914651737e-18,  8.188357086527080e-20, -1.052812965646922e-21,  1.296033386833562e-23, -1.537692959385570e-25,
  6.573241913440590e-07, -2.416221370593948e-08,  7.109696136803735e-10, -1.669495059714040e-11,  3.428319700740506e-13, -6.330625039696386e-15,  1.075015725242724e-16,
 -1.701666396196838e-18,  2.537972065124634e-20, -3.592985329821363e-22,  4.856502688339566e-24, -6.300835220424046e-26,  5.583809788330803e-08, -2.535810509617163e-09,
  8.592443517034890e-11, -2.308036345055136e-12,  5.357443480639217e-14, -1.110374291390134e-15,  2.103572014153432e-17, -3.697414952666215e-19,  6.097311792505510e-21,
 -9.510345684108228e-23,  1.411958852754048e-24, -2.005532325873464e-26,  3.626942357261613e-09, -2.027913146120147e-10,  7.951242515880030e-12, -2.448167627942721e-13,
  6.438680564749510e-15, -1.500967826355552e-16,  3.178834285486920e-18, -6.215726869805843e-20,  1.135408121558618e-21, -1.954483596624023e-23,  3.192063557305695e-25,
 -4.972159757893728e-27,  1.779030023384123e-10, -1.223194024838805e-11,  5.584236287827079e-13, -1.978212934600035e-14,  5.917801881165560e-16, -1.557170790768502e-17,
  3.699156559879160e-19, -8.071752810703907e-21,  1.638107818292811e-22, -3.120771367456439e-24,  5.621516386627793e-26, -9.627205699667564e-28,  6.504247533470894e-12,
 -5.505947649287597e-13,  2.949478522321766e-14, -1.208984269046698e-15,  4.136896939363623e-17, -1.235069467904537e-18,  3.307017279250533e-20, -8.089368295236926e-22,
  1.831744210377399e-23, -3.877716015230217e-25,  7.733367912768435e-27, -1.461337082328410e-28,  1.751153213621789e-13, -1.831956156804805e-14,  1.162590762091352e-15,
 -5.557777938289857e-17,  2.191892572392984e-18, -7.477020346227842e-20,  2.271487216007429e-21, -6.267203531750684e-23,  1.592605096058465e-24, -3.766746889255670e-26,
  8.359361779759493e-28, -1.751326250481988e-29,  3.445296627165820e-15, -4.483275787726853e-16,  3.410455306586318e-17, -1.921482131905208e-18,  8.821153054832505e-20,
 -3.469949539992157e-21,  1.206329849625133e-22, -3.784301786457173e-24,  1.087286606392267e-25, -2.893180382931808e-27,  7.191563288623840e-29, -1.680595521573004e-30,
  4.978005074675593e-17, -8.131995676779199e-18,  7.521399266212627e-19, -5.061181079790443e-20,  2.738701547572694e-21, -1.256801255546296e-22,  5.054011466881220e-24,
 -1.820669324749619e-25,  5.969140066591931e-27, -1.802258872033011e-28,  5.057427905911764e-30, -1.327909528709793e-31,  5.482292329053817e-19, -1.136653498427930e-19,
  1.299239997114232e-20, -1.060773456437595e-21,  6.866589832483185e-23, -3.726563687727876e-24,  1.755236012276770e-25, -7.344625042675515e-27,  2.776513769498907e-28,
 -9.602810635964063e-30,  3.068416298411726e-31, -9.122604996129290e-33,  5.170153372892584e-21, -1.372168609684662e-21,  1.968055491108402e-22, -1.979804942373020e-23,
  1.555281649914435e-24, -1.011327160477487e-25,  5.644793038709696e-27, -2.772109284519968e-28,  1.219341689971570e-29, -4.868925522263438e-31,  1.783545111908441e-32,
 -6.038303364004848e-34,  5.625238812465332e-23, -1.896989768503043e-23,  3.420271336287917e-24, -4.254017175838591e-25,  4.068639803707908e-26, -3.177293444146160e-27,
  2.104133211687406e-28, -1.212809964874822e-29,  6.200584175676125e-31, -2.852513127744114e-32,  1.194164228584555e-33, -4.585236572345762e-35,  1.233015787848300e-24,
 -4.992950965180849e-25,  1.080416548538613e-25, -1.593863439269250e-26,  1.785563420166455e-27, -1.614199037134930e-28,  1.224335867937728e-29, -8.004624117112928e-31,
  4.601418615164511e-32, -2.361235188509353e-33,  1.094659731843074e-34, -4.622838962308696e-36,  8.501605362371500e-02, -2.999737143874741e-04,  1.098734518884306e-06,
 -4.192918787424734e-09,  1.583541323133863e-11, -7.165680452868477e-14,  1.298978580070803e-16, -2.701019090261835e-18, -2.483031505428158e-22,  5.008612614855256e-22,
  1.735938340416093e-23,  3.104360460395010e-25,  6.901356647336880e-02, -2.739893192589229e-04,  1.388892290940702e-06, -7.601284874850574e-09,  4.130462027590496e-11,
 -2.255143235159694e-13,  1.113068133068728e-15, -6.730004037381360e-18,  2.905287759314815e-20,  7.429709709166746e-23,  8.193541437437677e-24,  1.277852667365544e-25,
  4.544000544596751e-02, -2.209681125279405e-04,  1.602835342956634e-06, -1.137302769339393e-08,  7.652529027748496e-11, -4.914583126634351e-13,  3.108456561676591e-15,
 -1.843415667097990e-17,  1.134973384544050e-19, -7.566479243544150e-22,  2.124389728051430e-25, -8.819424688678250e-26,  2.422588305530519e-02, -1.508367677277562e-04,
  1.452005165660924e-06, -1.235631817751109e-08,  9.810922512483025e-11, -7.355435780362206e-13,  5.433890972345997e-15, -3.701712876802820e-17,  2.613450536027365e-19,
 -1.980700037633009e-21,  2.979396802764693e-24, -2.235767002940068e-25,  1.043137727776693e-02, -8.439964121995825e-05,  1.008237717020030e-06, -1.000175430670421e-08,
  9.224639862163310e-11, -7.987985584436856e-13,  6.724217510803108e-15, -5.276704635554714e-17,  4.157017404644711e-19, -3.333455247551472e-21,  1.584165133401388e-23,
 -2.894561508233103e-25,  3.614960374477826e-03, -3.795865760938676e-05,  5.393925700983928e-07, -6.174569978151257e-09,  6.550983192620209e-11, -6.482397751508695e-13,
  6.152981157166595e-15, -5.488929325293532e-17,  4.805089089860631e-19, -4.152044148851142e-21,  2.912867654020886e-23, -3.281494743226148e-25,  1.003717042444673e-03,
 -1.356418498513500e-05,  2.238760171772663e-07, -2.943959885054932e-09,  3.565243868336956e-11, -3.997765365507041e-13,  4.253793701319951e-15, -4.267489585516713e-17,
  4.142312765405327e-19, -3.907425756247740e-21,  3.339689447281032e-23, -3.301948411856152e-25,  2.220450010214944e-04, -3.821455310643651e-06,  7.236460657208327e-08,
 -1.090000589810592e-09,  1.497781101683077e-11, -1.892055657042054e-13,  2.248439551340968e-15, -2.518577771227149e-17,  2.705026432370389e-19, -2.799454094405538e-21,
  2.728216774268579e-23, -2.731897708031175e-25,  3.887346693830784e-05, -8.432991178579823e-07,  1.822387224619304e-08, -3.137436833000854e-10,  4.871674657525275e-12,
 -6.907110831866660e-14,  9.145192226573354e-16, -1.138758204879310e-17,  1.350956682557756e-19, -1.535878118483358e-21,  1.664756992781106e-23, -1.776877746178688e-25,
  5.342438063835104e-06, -1.447851691192931e-07,  3.566645599372277e-09, -7.007821280693978e-11,  1.226771166720334e-12, -1.948170965298805e-14,  2.870251334292443e-16,
 -3.963604528800249e-18,  5.188492125015479e-20, -6.481238807955599e-22,  7.739321283731160e-24, -8.955262635100364e-26,  5.709020515917812e-07, -1.919135014201442e-08,
  5.397773513204193e-10, -1.209704668193203e-11,  2.385885286721814e-13, -4.241308383138571e-15,  6.951937981248908e-17, -1.063802726433037e-18,  1.536301646691901e-20,
 -2.109266888504683e-22,  2.765595349962046e-24, -3.488929120505136e-26,  4.691278838891005e-08, -1.946154075198037e-09,  6.271840850273502e-11, -1.604234968442593e-12,
  3.567876329476113e-14, -7.105149170721992e-16,  1.296859982471151e-17, -2.200263357124210e-19,  3.508332588632806e-21, -5.299164344481561e-23,  7.625962378830605e-25,
 -1.051529477010316e-26,  2.926593232964641e-09, -1.493851383084400e-10,  5.544462623760013e-12, -1.621935691801662e-13,  4.077441901674789e-15, -9.115554824546675e-17,
  1.856684102740578e-18, -3.499023614683024e-20,  6.171552782421775e-22, -1.027440108870687e-23,  1.624919872102456e-25, -2.454249468583086e-27,  1.366061446393885e-10,
 -8.574006701134144e-12,  3.689472407948769e-13, -1.239012768583107e-14,  3.534903788616614e-16, -8.903625516102543e-18,  2.030765195882693e-19, -4.264604189356273e-21,
  8.345987009971070e-23, -1.535922915240167e-24,  2.676525055026998e-26, -4.440394241309417e-28,  4.695624300495188e-12, -3.630464131874376e-13,  1.826444176326997e-14,
 -7.082242438399547e-16,  2.306421046350722e-17, -6.579914820463760e-19,  1.688993856335273e-20, -3.970901276925440e-22,  8.660948262100783e-24, -1.769348103884668e-25,
  3.410734309487981e-27, -6.238934314732092e-29,  1.169275356755445e-13, -1.118737165416208e-14,  6.649137642810396e-16, -3.001578530129633e-17,  1.124684983140135e-18,
 -3.660823886936935e-20,  1.064836883363464e-21, -2.820821442580435e-23,  6.898523486975060e-25, -1.573393237762670e-26,  3.373142712684277e-28, -6.837750790197821e-30,
  2.079645070002368e-15, -2.481349689785068e-16,  1.765070787834273e-17, -9.379998537281015e-19,  4.086742432273463e-20, -1.532587960153414e-21,  5.097760927575255e-23,
 -1.534594821070743e-24,  4.241641432968277e-26, -1.088148731421752e-27,  2.612682023214016e-29, -5.907817264783297e-31,  2.628465909798247e-17, -3.954790827428595e-18,
  3.421680895438423e-19, -2.172094122918378e-20,  1.115546507564740e-21, -4.881222838498982e-23,  1.878575010204302e-24, -6.496715702303823e-26,  2.050163783661230e-27,
 -5.971763083559705e-29,  1.619951285472647e-30, -4.119334612834718e-32,  2.412502557847463e-19, -4.642930183524282e-20,  4.981857941373750e-21, -3.847351936554526e-22,
  2.369157200085116e-23, -1.228649276587684e-24,  5.550386427323281e-26, -2.234476758662427e-27,  8.148671669944886e-29, -2.725103586531474e-30,  8.437191916854942e-32,
 -2.435149793842636e-33,  1.767675238554961e-21, -4.413698823071439e-22,  5.995936123056636e-23, -5.747378634252062e-24,  4.323115114891375e-25, -2.702456196254104e-26,
  1.454977160809168e-27, -6.912123548919017e-29,  2.948544961974217e-30, -1.144337895270142e-31,  4.082210241918152e-33, -1.348332934961611e-34,  1.372451311350385e-23,
 -4.450651802108326e-24,  7.735446821147141e-25, -9.307866505597111e-26,  8.640541554859689e-27, -6.567749787434093e-28,  4.243864813861090e-29, -2.391851545708424e-30,
  1.197947561504055e-31, -5.407701524342857e-33,  2.224670996655658e-34, -8.405511004272383e-36,  2.110979235742468e-25, -8.441359349136592e-26,  1.803855757924815e-26,
 -2.630522128629487e-27,  2.916043196861066e-28, -2.611053168385745e-29,  1.963212334301614e-30, -1.273333072005991e-31,  7.266349920400781e-33, -3.703769826363914e-34,
  1.706446508272049e-35, -7.165417629472564e-37,  8.383342579506944e-02, -2.913808990504707e-04,  1.049892878576217e-06, -3.950873341557790e-09,  1.442741248188878e-11,
 -6.942553955888844e-14,  5.799034865965221e-17, -2.257443509362143e-18,  3.391599839757760e-20,  1.504890961911655e-21,  3.357545689279971e-23,  4.080220367849017e-25,
  6.793926919588134e-02, -2.632321414107596e-04,  1.301497807742489e-06, -6.975103924795438e-09,  3.704676910225357e-11, -2.009518912372256e-13,  9.385652356796485e-16,
 -5.682307880466309e-18,  3.912481529314184e-20,  5.296673696937366e-22,  1.487657692700083e-23,  1.678897248733413e-25,  4.458094244421286e-02, -2.086712417588122e-04,
  1.473393743696801e-06, -1.022337138441248e-08,  6.740235874889342e-11, -4.226641319979547e-13,  2.639017590583926e-15, -1.524445303936442e-17,  8.541117240900893e-20,
 -8.326461807238778e-22, -4.151600831249847e-24, -1.066303937956533e-25,  2.364486524271239e-02, -1.397882176395122e-04,  1.312684403343428e-06, -1.089750799474930e-08,
  8.462313839636558e-11, -6.166884805856671e-13,  4.503823187062940e-15, -2.979196498638455e-17,  1.897019944729624e-19, -2.070125178800944e-21, -7.673614229879768e-24,
 -2.526480370499922e-25,  1.010918427370191e-02, -7.678989226529346e-05,  8.965722051575263e-07, -8.645327998875454e-09,  7.777187602828887e-11, -6.537510165775917e-13,
  5.415661623210325e-15, -4.128726032332905e-17,  3.040372845986761e-19, -2.953910353315082e-21,  3.189393105428773e-24, -2.807252723925964e-25,  3.471310677192062e-03,
 -3.392301340291470e-05,  4.711834699264532e-07, -5.222600525248123e-09,  5.390568373805579e-11, -5.174042614675135e-13,  4.810323404175884e-15, -4.170680904924242e-17,
  3.487010228021357e-19, -3.256907033171523e-21,  1.607162306816145e-23, -2.664025472903884e-25,  9.528315102729680e-04, -1.190536299413186e-05,  1.917241995329968e-07,
 -2.432319061165939e-09,  2.858825278112551e-11, -3.106478196255726e-13,  3.225008140666113e-15, -3.143888372909241e-17,  2.943912757470695e-19, -2.831603054292396e-21,
  2.108266925596681e-23, -2.351189358595028e-25,  2.078395683751114e-04, -3.291054188298802e-06,  6.060647585594372e-08, -8.779198326757173e-10,  1.168088949773066e-11,
 -1.428134376703700e-13,  1.650647177882431e-15, -1.795317103499519e-17,  1.867538333862183e-19, -1.917892708058833e-21,  1.747562534808423e-23, -1.794507586273574e-25,
  3.576974935092269e-05, -7.113404861284056e-07,  1.488462841246862e-08, -2.457559660400474e-10,  3.686233528529598e-12, -5.050721576980702e-14,  6.487122129645677e-16,
 -7.834571923124018e-18,  9.011408090602164e-20, -1.004020660641935e-21,  1.043365102258448e-23, -1.103332147045183e-25,  4.815472661534377e-06, -1.193094318292062e-07,
  2.831736004874167e-09, -5.322728154410525e-11,  8.979188963631248e-13, -1.375686121700369e-14,  1.961661391299338e-16, -2.623801170294167e-18,  3.328963856366664e-20,
 -4.050959623173546e-22,  4.677288882525401e-24, -5.295064468283279e-26,  5.019375166058320e-07, -1.539479782406511e-08,  4.149862285360946e-10, -8.876797147604595e-12,
  1.682941963718307e-13, -2.881049510119960e-15,  4.561043492030794e-17, -6.750089759018033e-19,  9.439240349045494e-21, -1.258407986814091e-22,  1.599098201531614e-24,
 -1.963993687207240e-26,  4.002214827908362e-08, -1.512685119656484e-09,  4.647337037807516e-11, -1.132033173070114e-12,  2.414069302296432e-14, -4.620838871488266e-16,
  8.130061630901476e-18, -1.331951382382483e-19,  2.053941478179850e-21, -3.006241400521287e-23,  4.192981008073641e-25, -5.615716310421670e-27,  2.406838408229784e-09,
 -1.118299957259074e-10,  3.936431937563709e-12, -1.094152024264221e-13,  2.630808337173989e-15, -5.642186000402643e-17,  1.105691052536831e-18, -2.008945216955863e-20,
  3.422178105033104e-22, -5.511959593336339e-24,  8.442334488646301e-26, -1.236755527890893e-27,  1.073914667121902e-10, -6.133000147899773e-12,  2.490830323442718e-13,
 -7.929807997958515e-15,  2.158511510922563e-16, -5.205455830739590e-18,  1.140231183073675e-19, -2.304940524986847e-21,  4.350657091464811e-23, -7.735752966679633e-25,
  1.304240596995043e-26, -2.096364634360985e-28,  3.489542527743739e-12, -2.455259489356695e-13,  1.160786337519619e-14, -4.257349682699656e-16,  1.319729074107949e-17,
 -3.597992104590865e-19,  8.854563968883117e-21, -2.000949384977812e-22,  4.203893244581922e-24, -8.287950340215802e-26,  1.544251638017568e-27, -2.734337950086768e-29,
  8.090391665490244e-14, -7.050699880760901e-15,  3.923918370534163e-16, -1.671915148230990e-17,  5.950733113479598e-19, -1.847863542899701e-20,  5.145430502305203e-22,
 -1.308480975310704e-23,  3.079037379870214e-25, -6.770757169745051e-27,  1.401965296312595e-28, -2.749208222120307e-30,  1.311317588799766e-15, -1.427977530802993e-16,
  9.487643046572142e-18, -4.751118023352895e-19,  1.963162282435136e-20, -7.014432236995856e-22,  2.231115018740821e-23, -6.441815162964886e-25,  1.712045820771116e-26,
 -4.232354237400586e-28,  9.811199601263623e-30, -2.145630544759848e-31,  1.463680291884898e-17, -2.017507489603852e-18,  1.629116204911227e-19, -9.739259666223994e-21,
  4.740829667354698e-22, -1.975586892250620e-23,  7.268742958420484e-25, -2.410804446898704e-26,  7.315797040386645e-28, -2.053965762532083e-29,  5.381485697737189e-31,
 -1.324180057959666e-32,  1.131234213612885e-19, -2.008244974463631e-20,  2.015465263182486e-21, -1.468153983611430e-22,  8.580534082637655e-24, -4.243659798004635e-25,
  1.835347055383250e-26, -7.096890507535948e-28,  2.492806351774922e-29, -8.049170843279392e-31,  2.411387532661221e-32, -6.747579384392976e-34,  6.489013772915409e-22,
 -1.513599303389373e-22,  1.937840298146797e-23, -1.762847079755142e-24,  1.265332578985708e-25, -7.581455394320223e-27,  3.926763476995902e-28, -1.800251838951556e-29,
  7.431003653148886e-31, -2.797318136740889e-32,  9.699378445766992e-34, -3.119907449613927e-35,  3.571567760097430e-24, -1.106481446342157e-24,  1.843921258245174e-25,
 -2.136854727471546e-26,  1.917883663367619e-27, -1.414138002325219e-28,  8.889148367133191e-30, -4.885602481133081e-31,  2.391294078049827e-32, -1.056899362843048e-33,
  4.264167417831180e-35, -1.582484483605413e-36,  3.718081725479795e-26, -1.464180915974177e-26,  3.082048635800612e-27, -4.433015383552653e-28,  4.853368248832824e-29,
 -4.297095083917361e-30,  3.198111894125426e-31, -2.055119530370745e-32,  1.162875310752051e-33, -5.881580562541166e-35,  2.690616054721504e-36, -1.122435995655344e-37,
  8.268440562005082e-02, -2.831675788167945e-04,  1.003821802357543e-06, -3.731085754243980e-09,  1.304858228163264e-11, -6.860944069101544e-14,  2.017069455748111e-17,
 -1.140605898418730e-20,  1.165044529920366e-19,  3.192585702406019e-21,  4.982407465800826e-23,  2.672779419195101e-25,  6.690664832021791e-02, -2.531451849686791e-04,
  1.221224245628306e-06, -6.413335314181552e-09,  3.324092149115894e-11, -1.801720253282882e-13,  8.007568073239803e-16, -3.996136264986667e-18,  7.064160852273670e-20,
  1.265813074919952e-21,  2.149904269805847e-23,  1.063352768593227e-25,  4.376907986364884e-02, -1.973571009850520e-04,  1.356915718444073e-06, -9.209258565047986e-09,
  5.954933963971598e-11, -3.641700683190567e-13,  2.245649566238660e-15, -1.303202314508881e-17,  5.133737026050594e-20, -1.089223943768455e-21, -8.462130507806912e-24,
 -7.586983433897757e-26,  2.310591841784558e-02, -1.297877058740735e-04,  1.189649391230129e-06, -9.636607137013557e-09,  7.330596168332652e-11, -5.179923722328905e-13,
  3.742884814704915e-15, -2.499442385249211e-17,  1.070547442169305e-19, -2.588274454073641e-21, -1.766111284332180e-23, -1.713226582670597e-25,  9.815741424785833e-03,
 -7.001208611318659e-05,  7.998847402663247e-07, -7.498890651960404e-09,  6.590824118569987e-11, -5.366462207921400e-13,  4.379880025224634e-15, -3.325821447693421e-17,
  1.971539172639242e-19, -3.056526601258327e-21, -7.670719689104466e-24, -1.893001800096428e-25,  3.342780353400145e-03, -3.039031570795188e-05,  4.133650080393602e-07,
 -4.436997317529059e-09,  4.462355626546598e-11, -4.148135322637894e-13,  3.781882126983203e-15, -3.232199072610170e-17,  2.403881407187847e-19, -2.827023965240543e-21,
  6.048825186923179e-24, -1.791374181270067e-25,  9.081031772845271e-04, -1.048099098263415e-05,  1.650886637307596e-07, -2.020686556378459e-09,  2.308311649395624e-11,
 -2.428354169775933e-13,  2.462332113232113e-15, -2.350544739569798e-17,  2.053518202224506e-19, -2.171973332059885e-21,  1.247185348646506e-23, -1.558266509994339e-25,
  1.955825492284200e-04, -2.845369225514825e-06,  5.110507927674055e-08, -7.118828440926230e-10,  9.183294010909495e-12, -1.086142016195855e-13,  1.222123013578087e-15,
 -1.296104739831540e-17,  1.285758927705461e-19, -1.356600894417196e-21,  1.105076212870119e-23, -1.157251474544339e-25,  3.314518480305803e-05, -6.031287126445116e-07,
  1.225865007669255e-08, -1.940805872408409e-10,  2.815563440357130e-12, -3.727542354421770e-14,  4.648050101412297e-16, -5.457340076838009e-18,  6.043839804126479e-20,
 -6.701310715935731e-22,  6.562861597888445e-24, -6.867430278057240e-26,  4.379816621092268e-06, -9.898558365268273e-08,  2.270894528240676e-09, -4.082884998285622e-11,
  6.644800618184052e-13, -9.822384409225071e-15,  1.356543237679457e-16, -1.759874585055521e-18,  2.157852310861534e-20, -2.575054801838413e-22,  2.856650693594330e-24,
 -3.164388128131638e-26,  4.463827703504775e-07, -1.245924060453384e-08,  3.228958825074637e-10, -6.591443510537870e-12,  1.202489099101733e-13, -1.982852907419754e-15,
  3.033702014947949e-17, -4.346052909965705e-19,  5.878610155610097e-21, -7.632012661801846e-23,  9.379181528570064e-25, -1.121888057497207e-26,  3.463737090107974e-08,
 -1.189308763966480e-09,  3.493267601499593e-11, -8.102600610298368e-13,  1.658267002790566e-14, -3.051841195590036e-16,  5.178617959262122e-18, -8.197638370578577e-20,
  1.222238756836634e-21, -1.735733259593647e-23,  2.345056774971585e-25, -3.051655743026256e-27,  2.015093682958954e-09, -8.495215048508306e-11,  2.842965448114156e-12,
 -7.507907231001754e-14,  1.727868529439560e-15, -3.556030757676705e-17,  6.707646092727971e-19, -1.175498039761213e-20,  1.934079144288316e-22, -3.015712249940363e-24,
  4.473177363234005e-26, -6.357423693399249e-28,  8.631568081893121e-11, -4.469299940111714e-12,  1.716392830237977e-13, -5.179786472187944e-15,  1.345956383281600e-16,
 -3.108574871516688e-18,  6.541448003402596e-20, -1.273261907454461e-21,  2.318297120153564e-23, -3.983888180254035e-25,  6.499105655768893e-27, -1.012250994072874e-28,
  2.665239567042889e-12, -1.699889938193798e-13,  7.561301956525095e-15, -2.622627942947977e-16,  7.740833516537484e-18, -2.017027822057649e-19,  4.759771709864572e-21,
 -1.034003064765630e-22,  2.092693084551981e-24, -3.981929479806039e-26,  7.171535369513719e-28, -1.229219946054799e-29,  5.790503143144245e-14, -4.576498892180910e-15,
  2.385688383998487e-16, -9.590678513243717e-18,  3.242370953963455e-19, -9.604394389146305e-21,  2.559984500977415e-22, -6.248856346322142e-24,  1.414711873064727e-25,
 -2.999056879670013e-27,  5.996917879350319e-29, -1.137433296137600e-30,  8.621589351198330e-16, -8.526582445104060e-17,  5.287805785834083e-18, -2.493187572028683e-19,
  9.765203634857929e-21, -3.322800029870715e-22,  1.010249709893737e-23, -2.796498812184861e-25,  7.143615272343971e-27, -1.701094260776908e-28,  3.805744149598385e-30,
 -8.046222224570522e-32,  8.582199164324820e-18, -1.077591889854680e-18,  8.105486016216908e-20, -4.556429276356312e-21,  2.099730792049503e-22, -8.324569277665533e-24,
  2.925412521233035e-25, -9.297216358975276e-27,  2.710824472025274e-28, -7.330059191237180e-30,  1.853499526113069e-31, -4.409916202251642e-33,  5.648920698438871e-20,
 -9.189482054167485e-21,  8.596636143292100e-22, -5.891435748845356e-23,  3.261008481865136e-24, -1.535206089390284e-25,  6.346050395613758e-27, -2.353341673011710e-28,
  7.950466022871811e-30, -2.475333148798415e-31,  7.166228874758261e-33, -1.941728950903774e-34,  2.562815675087036e-22, -5.541850364225770e-23,  6.652878494409561e-24,
 -5.720712343351082e-25,  3.905189083151541e-26, -2.236148120905440e-27,  1.111288671675221e-28, -4.904918527470457e-30,  1.954835811465926e-31, -7.123079309196306e-33,
  2.396098490937934e-34, -7.492446398169665e-36,  9.977187051859193e-25, -2.930556222324690e-25,  4.654607067129605e-26, -5.169296451521087e-27,  4.466826884206248e-28,
 -3.183193883534104e-29,  1.940174363842593e-30, -1.036859961937692e-31,  4.946604257451013e-33, -2.135503840772088e-34,  8.431532230509317e-36, -3.067307445676392e-37,
  6.774433822954255e-27, -2.617969586477960e-27,  5.411062491739929e-28, -7.655453502925157e-29,  8.258113418236259e-30, -7.214949125820490e-31,  5.305708701660029e-32,
 -3.372676754866935e-33,  1.889695047130002e-34, -9.472245620374724e-36,  4.297786893908854e-37, -1.779475501088918e-38,  8.156751776452355e-02, -2.753126513798253e-04,
  9.602562613721384e-07, -3.533250676306991e-09,  1.168388795432426e-11, -6.758752229942494e-14,  9.215953622858457e-17,  5.954998675331757e-18,  2.688232691537134e-19,
  5.265601193697702e-21,  4.867274779003088e-23, -4.467416869125506e-25,  6.591313216657847e-02, -2.436744568137059e-04,  1.147339727593944e-06, -5.909296756167173e-09,
  2.982212037147447e-11, -1.619929193060527e-13,  7.285824196088054e-16, -8.349186828651375e-19,  1.322541378502139e-19,  2.153251009261241e-21,  2.068460020684332e-23,
 -1.967683759527832e-25,  4.300068436793113e-02, -1.869281573456675e-04,  1.251890153637451e-06, -8.311929227783970e-09,  5.277613424601905e-11, -3.145063004159140e-13,
  1.897362151616451e-15, -1.208668364806400e-17,  5.513413547425691e-21, -1.460964404634610e-21, -9.009575529695022e-24,  7.869347628246764e-26,  2.260509675243182e-02,
 -1.207138854609529e-04,  1.080720776990499e-06, -8.541941943077422e-09,  6.378933581292628e-11, -4.362654151121757e-13,  3.075956401679129e-15, -2.320638711391959e-17,
  1.365907665754581e-23, -3.367147254511418e-21, -1.871062623106906e-23,  1.849240584730137e-25,  9.547945598695477e-03, -6.395580802108013e-05,  7.158887205784661e-07,
 -6.524815942543301e-09,  5.615430249516261e-11, -4.420950768752295e-13,  3.519934850544240e-15, -2.878152514161629e-17,  8.019411296217186e-20, -3.459566982579267e-21,
 -1.022779817396070e-23,  1.226892937437636e-25,  3.227512061628451e-03, -2.728483385233114e-05,  3.641462936559911e-07, -3.784752265459061e-09,  3.716572935997405e-11,
 -3.341320112930045e-13,  2.969516362127784e-15, -2.622410390141919e-17,  1.414699805402655e-19, -2.696985711564866e-21,  1.835274234141140e-24,  1.204640771293372e-26,
  8.686754620543060e-04, -9.251345328585548e-06,  1.429059525335969e-07, -1.687210784514833e-09,  1.876760008427465e-11, -1.909638341415993e-13,  1.885038890378276e-15,
 -1.810080858395696e-17,  1.347291420642887e-19, -1.783249159474291e-21,  7.700898928902907e-24, -5.409141606399458e-26,  1.849679715544306e-04, -2.468356432146586e-06,
  4.337724003618122e-08, -5.808503381076121e-10,  7.277145545968026e-12, -8.321553542798514e-14,  9.100290546594593e-16, -9.551705191783263e-18,  8.661391014608551e-20,
 -1.000394401371531e-21,  7.151627447043132e-24, -6.163843239642233e-26,  3.091506936929356e-05, -5.136625106856043e-07,  1.017720559650526e-08, -1.544378250087563e-10,
  2.170271959997611e-12, -2.775584020194846e-14,  3.357788561679195e-16, -3.864000925958353e-18,  4.039366666123516e-20, -4.590830005509199e-22,  4.194179062568037e-24,
 -4.045444422308008e-26,  4.017342435269239e-06, -8.261133224604443e-08,  1.838786021313624e-09, -3.160730991232904e-11,  4.969675955095970e-13, -7.087810251329292e-15,
  9.479415777943991e-17, -1.198091661354635e-18,  1.406906203834292e-20, -1.668421526906197e-22,  1.770023119266710e-24, -1.874456567048880e-26,  4.012536947256349e-07,
 -1.016253114427687e-08,  2.541514659095489e-10, -4.948943094088439e-12,  8.698700948260111e-14, -1.381836620760106e-15,  2.043517032805745e-17, -2.840754226008982e-19,
  3.702318524064500e-21, -4.708080926069642e-23,  5.585234626419818e-25, -6.459567128625602e-27,  3.038328595153095e-08, -9.446529346083500e-10,  2.661998866576844e-11,
 -5.877215897084873e-13,  1.155654099951558e-14, -2.045403406722479e-16,  3.348435282400852e-18, -5.128568777757667e-20,  7.382115894406486e-22, -1.019765363938644e-23,
  1.333826228736384e-25, -1.683099788264076e-27,  1.715665294321180e-09, -6.539111968589174e-11,  2.086977406699537e-12, -5.234864645218033e-14,  1.154215272662931e-15,
 -2.280146663046495e-17,  4.141286494684175e-19, -7.005809298140808e-21,  1.112852744111150e-22, -1.681729263084721e-24,  2.415629269740264e-26, -3.329386708525299e-28,
  7.083713234046610e-11, -3.312430849424597e-12,  1.205978507184627e-13, -3.449094686375863e-15,  8.561876718148278e-17, -1.894266258886438e-18,  3.830592268727852e-20,
 -7.182881120654216e-22,  1.261512915097644e-23, -2.096261516634900e-25,  3.309209994937489e-27, -4.994466717836469e-29,  2.088946151242883e-12, -1.202523367116975e-13,
  5.041854508963507e-15, -1.653385977925942e-16,  4.648743488118876e-18, -1.157935654187950e-19,  2.620675727407681e-21, -5.474267383391635e-23,  1.067329083024395e-24,
 -1.960517031169466e-26,  3.413220063577896e-28, -5.663432380736718e-30,  4.279491726392352e-14, -3.052800080162401e-15,  1.492070116626118e-16, -5.657184051006078e-18,
  1.816902187928723e-19, -5.133834655122743e-21,  1.309874262585339e-22, -3.069160713951318e-24,  6.684718255338356e-26, -1.366108148309667e-27,  2.637787476413490e-29,
 -4.838655797840981e-31,  5.899299358607619e-16, -5.270557382686972e-17,  3.050513248142629e-18, -1.353275381148726e-19,  5.022783168456305e-21, -1.627085288239636e-22,
  4.727187302158458e-24, -1.254200325962918e-25,  3.078489158197268e-27, -7.059356858970053e-29,  1.523750738535992e-30, -3.113492517731799e-32,  5.289028303291843e-18,
 -6.013011639149644e-19,  4.207129173454833e-20, -2.220876998643151e-21,  9.679680365558495e-23, -3.647934248443029e-24,  1.223492352715493e-25, -3.723207513007618e-27,
  1.042347508803298e-28, -2.712689354066295e-30,  6.615653544494652e-32, -1.520962199159992e-33,  3.000927163854151e-20, -4.441992556195797e-21,  3.861575042809914e-22,
 -2.483828828383510e-23,  1.299612461830592e-24, -5.814276309638157e-26,  2.293723806680820e-27, -8.146153062781785e-29,  2.643514563985479e-30, -7.926176081703676e-32,
  2.214863094440786e-33, -5.804505953486246e-35,  1.090452785040270e-22, -2.167927135683813e-23,  2.428066851570733e-24, -1.965823627963547e-25,  1.272107150255198e-26,
 -6.941610561624717e-28,  3.301624549842696e-29, -1.399695947064255e-30,  5.374630764097780e-32, -1.891930084158138e-33,  6.162636822656174e-35, -1.870007668313783e-36,
  3.010849659555477e-25, -8.311470510018397e-26,  1.249925231830301e-26, -1.323188902614706e-27,  1.095826307982026e-28, -7.517820876306080e-30,  4.427624578468201e-31,
 -2.293630442957108e-32,  1.063571583604859e-33, -4.473505314993404e-35,  1.724451345441269e-36, -6.136535458376354e-38,  1.285580178570229e-27, -4.853142487310983e-28,
  9.810044089064987e-29, -1.360530080926474e-29,  1.441857853031905e-30, -1.239969979737758e-31,  8.990276109495666e-33, -5.642506539315734e-34,  3.125285513288985e-35,
 -1.550297815937010e-36,  6.967497488512992e-38, -2.859954771062736e-39,  8.048136708472313e-02, -2.677971208953858e-04,  9.189348901610293e-07, -3.356925751623570e-09,
  1.037357344066841e-11, -6.221552489976570e-14,  4.101747429615058e-16,  1.790460702830468e-17,  4.851024375839837e-19,  6.410370670212091e-21, -3.448891930719138e-24,
 -2.097944019265047e-24,  6.495635380324490e-02, -2.347715136783652e-04,  1.079187253381815e-06, -5.457110001466455e-09,  2.675802261760264e-11, -1.442325018486921e-13,
  7.771013446364471e-16,  4.770512177865137e-18,  2.210619532497740e-19,  2.634834690639136e-21, -1.670980757061288e-24, -8.929311499377927e-25,  4.227238992970152e-02,
 -1.772981161581522e-04,  1.157013637151781e-06, -7.515473279084771e-09,  4.691385110947900e-11, -2.730616247225940e-13,  1.553065816133279e-15, -1.280954278857412e-17,
 -5.195283951472785e-20, -1.663089290996556e-21,  1.521866260215036e-24,  4.385799829070622e-25,  2.213890720774453e-02, -1.124614199248359e-04,  9.840657007106038e-07,
 -7.587326393911541e-09,  5.574913297182047e-11, -3.703563299613445e-13,  2.407077762733812e-15, -2.526263329000570e-17, -1.309497721160630e-19, -3.751887338577478e-21,
  5.363217631142585e-24,  9.943522472341237e-25,  9.303101413347670e-03, -5.852725895938411e-05,  6.427040883892084e-07, -5.692762601177175e-09,  4.809291021090060e-11,
 -3.671147192164176e-13,  2.730800550276990e-15, -2.826683044574482e-17, -4.891987316378104e-20, -3.590869426312738e-21,  8.612137023860579e-24,  8.029125453519088e-25,
  3.123925058004239e-03, -2.454370646240589e-05,  3.220885301168186e-07, -3.239931061267937e-09,  3.113856209814343e-11, -2.712524448643768e-13,  2.284157159534108e-15,
 -2.322991024331853e-17,  4.666834957272078e-20, -2.517688532630930e-21,  9.866400125148570e-24,  3.881982506667646e-25,  8.338351911411527e-04, -8.184254156224974e-06,
  1.243425876456921e-07, -1.415189600096151e-09,  1.536195369963190e-11, -1.513748558438396e-13,  1.429332600143751e-15, -1.475941710470985e-17,  7.587622468545748e-20,
 -1.480882953886255e-21,  8.579632827732541e-24,  1.056815626598070e-25,  1.757470738876331e-04, -2.147359152336114e-06,  3.705432787341321e-08, -4.766295223408206e-10,
  5.811062790935206e-12, -6.430243147737931e-14,  6.763379770287920e-16, -7.305386965260613e-18,  5.524739563600972e-20, -7.517179864137353e-22,  5.718657229485340e-24,
 -1.601081160218123e-27,  2.901229847582388e-05, -4.391070843012690e-07,  8.515302690421163e-09, -1.237508947267477e-10,  1.687672562665778e-12, -2.086358025651051e-14,
  2.434113698799264e-16, -2.806521928293266e-18,  2.652049156205755e-20, -3.200489945702300e-22,  2.921532650037929e-24, -1.787129554607644e-26,  3.714093105407797e-06,
 -6.929304328317832e-08,  1.502900539863679e-09, -2.467682357231079e-11,  3.754857480182880e-13, -5.169533645001210e-15,  6.673648838831471e-17, -8.317641580733688e-19,
  9.163539573430928e-21, -1.098238500329292e-22,  1.142033050360414e-24, -1.031661072635983e-26,  3.643247105399602e-07, -8.345147997484629e-09,  2.022823572133444e-10,
 -3.754079524338375e-12,  6.367349832708435e-14, -9.748789132198369e-16,  1.391270302819802e-17, -1.889063319668437e-19,  2.349675250703381e-21, -2.949889199158342e-23,
  3.407820480550901e-25, -3.670947669413103e-27,  2.698998799847984e-08, -7.570450587871511e-10,  2.055467745600833e-11, -4.316212524556785e-13,  8.165522345519265e-15,
 -1.390462009666700e-16,  2.194546086930065e-18, -3.263610793069871e-20,  4.516457703203705e-22, -6.090932521651081e-24,  7.736652450746731e-26, -9.354261920198224e-28,
  1.483915529622657e-09, -5.092554266111767e-11,  1.556132378663943e-12, -3.704952467665931e-14,  7.835521351204972e-16, -1.486384335316320e-17,  2.599005601970533e-19,
 -4.252173056986185e-21,  6.510520760340588e-23, -9.551225023816714e-25,  1.330062968299195e-26, -1.771582763461046e-28,  5.928429589509128e-11, -2.492501941850924e-12,
  8.632281787323353e-14, -2.338424610528173e-15,  5.550696120759990e-17, -1.176808412799118e-18,  2.287088540090813e-20, -4.135571785757008e-22,  7.002485438328158e-24,
 -1.126048672641612e-25,  1.720948693843339e-27, -2.514750057293478e-29,  1.677618928079404e-12, -8.674543073609518e-14,  3.437443351218505e-15, -1.065275394075863e-16,
  2.855164757879256e-18, -6.800016677277534e-20,  1.476237509087351e-21, -2.966639522207768e-23,  5.571660760354835e-25, -9.883033181739126e-27,  1.663572923284910e-28,
 -2.671718765537845e-30,  3.260180389191663e-14, -2.088092007101256e-15,  9.585751801344898e-17, -3.426133950418748e-18,  1.045695969765815e-19, -2.818729872113136e-21,
  6.884676098669410e-23, -1.548727363027098e-24,  3.244991794080197e-26, -6.393413861135400e-28,  1.192067975502957e-29, -2.114644866901794e-31,  4.192777201557523e-16,
 -3.364346848702665e-17,  1.818511483413710e-18, -7.585225766706504e-20,  2.667593427524961e-21, -8.225102192440597e-23,  2.283073225293837e-24, -5.804934127119128e-26,
  1.368803351677788e-27, -3.022051412924174e-29,  6.292049022144562e-31, -1.242224018498968e-32,  3.419156966049094e-18, -3.496644747264400e-19,  2.273970005819005e-20,
 -1.125917034815137e-21,  4.638010987614213e-23, -1.660403899750308e-24,  5.311664633977248e-26, -1.546847371255421e-27,  4.155671850155112e-29, -1.040323004954011e-30,
  2.445605828630751e-32, -5.429962462760493e-34,  1.693514132923764e-20, -2.263673379904329e-21,  1.824071264945675e-22, -1.098846658784247e-23,  5.425942062812697e-25,
 -2.303530225322034e-26,  8.661190777601980e-28, -2.942312242011529e-29,  9.160866607192599e-31, -2.642276442104405e-32,  7.119063378451945e-34, -1.802644923967198e-35,
  5.001661326184648e-23, -9.060287955382031e-24,  9.421507338469753e-25, -7.155221362561498e-26,  4.375753050438127e-27, -2.269358485175702e-28,  1.030546598510562e-29,
 -4.187161845827237e-31,  1.545914906014468e-32, -5.247012961427351e-34,  1.652026735152437e-35, -4.856370545431385e-37,  9.874000359509518e-26, -2.536063587481849e-26,
  3.585526739966030e-27, -3.597620606779297e-28,  2.841968751379666e-29, -1.869245398300175e-30,  1.059904844340473e-31, -5.304928640963815e-33,  2.383975243631304e-34,
 -9.743343683562163e-36,  3.657993389848086e-37, -1.270452052230930e-38,  2.562246697646556e-28, -9.392678963364353e-29,  1.847415525849435e-29, -2.500990820692546e-30,
  2.594663859935151e-31, -2.189702361608725e-32,  1.561210249213569e-33, -9.652523841394166e-35,  5.274678702752859e-36, -2.584797328093578e-37,  1.148911831568859e-38,
 -4.668841990317120e-40,  };
  int offset = -22;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 22;
    if (std::isnan(t)) {
      fill_n(rr+offset, 22, 0.5);
      fill_n(ww+offset, 22, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 22; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=22; ++j) {
        const int boxof = it*264+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
