/*
 *        .þÛÛþ þ    þ þÛÛþ.     þ    þ þÛÛÛþ.  þÛÛÛþ .þÛÛþ. þ    þ
 *       .þ   Û Ûþ.  Û Û   þ.    Û    Û Û    þ  Û.    Û.   Û Ûþ.  Û
 *       Û    Û Û Û  Û Û    Û    Û   þ. Û.   Û  Û     Û    Û Û Û  Û
 *     .þþÛÛÛÛþ Û  Û Û þÛÛÛÛþþ.  þþÛÛ.  þþÛÛþ.  þÛ    Û    Û Û  Û Û
 *    .Û      Û Û  .þÛ Û      Û. Û   Û  Û    Û  Û.    þ.   Û Û  .þÛ
 *    þ.      þ þ    þ þ      .þ þ   .þ þ    .þ þÛÛÛþ .þÛÛþ. þ    þ
 *
 * Berusky (C) AnakreoN
 * Martin Stransky <stransky@anakreon.cz> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Portability defines
 */

#ifndef __PORTABILITY_H__
#define __PORTABILITY_H__

/*
 * Defines for windows
 */
#ifdef _WIN32

#define WINDOWS   1
#undef  LINUX

#include <io.h>
#include "window.h"

#define VERSION           "1.7.2"
#define PATH_MAX          128

#define random()          rand()
#define snprintf          _snprintf
#define mkdirm            _mkdir
#define mktemp            _mktemp
#define stat              _stat

// Stupid VC2010
#pragma warning(disable: 4996 4800)

#endif // _WIN32

/*
 * Defines for linux
 */
#ifndef _WIN32

#undef  WINDOWS
#ifndef LINUX
#define LINUX   1
#endif // LINUX

#include <unistd.h>

#define mkdirm(d)  mkdir(d,DEFAULT_DIR_MASK)

#endif // ! _WIN32

#endif // __PORTABILITY_H__
