;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt --nominal --global-refining -all -S -o - | filecheck %s

(module
  ;; Globals with no assignments aside from their initial values. The first is
  ;; a null, so we have nothing concrete to improve with (though we could use
  ;; the type of the null perhaps, TODO). The second is a ref.func which lets
  ;; us refine.
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $func-null-init (mut anyref) (ref.null func))
  (global $func-null-init (mut anyref) (ref.null func))
  ;; CHECK:      (global $func-func-init (mut (ref $none_=>_none)) (ref.func $foo))
  (global $func-func-init (mut anyref) (ref.func $foo))
  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $foo)
)

(module
  ;; Globals with later assignments of null. The global with a function in its
  ;; init will update the null to allow it to refine.

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $func-null-init (mut anyref) (ref.null func))
  (global $func-null-init (mut anyref) (ref.null func))
  ;; CHECK:      (global $func-func-init (mut (ref null $none_=>_none)) (ref.func $foo))
  (global $func-func-init (mut anyref) (ref.func $foo))

  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (global.set $func-null-init
  ;; CHECK-NEXT:   (ref.null any)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $func-func-init
  ;; CHECK-NEXT:   (ref.null $none_=>_none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo
   (global.set $func-null-init (ref.null any))
   (global.set $func-func-init (ref.null any))
  )
)

(module
  ;; Globals with later assignments of something non-null. Both can be refined,
  ;; and the one with a non-null initial value can even become non-nullable.

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $func-null-init (mut (ref null $none_=>_none)) (ref.null $none_=>_none))
  (global $func-null-init (mut anyref) (ref.null func))
  ;; CHECK:      (global $func-func-init (mut (ref $none_=>_none)) (ref.func $foo))
  (global $func-func-init (mut anyref) (ref.func $foo))

  ;; CHECK:      (elem declare func $foo)

  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (global.set $func-null-init
  ;; CHECK-NEXT:   (ref.func $foo)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $func-func-init
  ;; CHECK-NEXT:   (ref.func $foo)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo
   (global.set $func-null-init (ref.func $foo))
   (global.set $func-func-init (ref.func $foo))
  )
)

(module
  ;; A global with multiple later assignments. The refined type is more
  ;; specific than the original, but less than each of the non-null values.

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $i32_=>_none (func_subtype (param i32) func))

  ;; CHECK:      (global $global (mut funcref) (ref.null func))
  (global $global (mut anyref) (ref.null any))

  ;; CHECK:      (elem declare func $bar $foo)

  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.func $foo)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.func $bar)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null func)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null func)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null func)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo
   (global.set $global (ref.func $foo))
   (global.set $global (ref.func $bar))
   (global.set $global (ref.null func))
   ;; These nulls will be updated.
   (global.set $global (ref.null eq))
   (global.set $global (ref.null data))
  )

  ;; CHECK:      (func $bar (type $i32_=>_none) (param $x i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $bar (param $x i32)
    ;; A function with a different signature, whose reference is also assigned
    ;; to the global.
  )
)
