;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 (memory 1 1)

 ;; CHECK-TEXT:      (type $0 (func (param v128 v128) (result v128)))

 ;; CHECK-TEXT:      (type $1 (func (param v128) (result v128)))

 ;; CHECK-TEXT:      (type $2 (func (param i32) (result v128)))

 ;; CHECK-TEXT:      (type $3 (func (param v128 i32) (result v128)))

 ;; CHECK-TEXT:      (type $4 (func (param v128) (result i32)))

 ;; CHECK-TEXT:      (type $5 (func (param i32 v128)))

 ;; CHECK-TEXT:      (type $6 (func (param i32 v128) (result v128)))

 ;; CHECK-TEXT:      (type $7 (func (result v128)))

 ;; CHECK-TEXT:      (type $8 (func (param f32) (result v128)))

 ;; CHECK-TEXT:      (type $9 (func (param f64) (result v128)))

 ;; CHECK-TEXT:      (type $10 (func (param v128) (result i64)))

 ;; CHECK-TEXT:      (type $11 (func (param v128 i64) (result v128)))

 ;; CHECK-TEXT:      (type $12 (func (param v128) (result f32)))

 ;; CHECK-TEXT:      (type $13 (func (param v128 f32) (result v128)))

 ;; CHECK-TEXT:      (type $14 (func (param v128) (result f64)))

 ;; CHECK-TEXT:      (type $15 (func (param v128 f64) (result v128)))

 ;; CHECK-TEXT:      (type $16 (func (param v128 v128 v128) (result v128)))

 ;; CHECK-TEXT:      (memory $0 1 1)

 ;; CHECK-TEXT:      (func $v128.load (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (type $0 (func (param v128 v128) (result v128)))

 ;; CHECK-BIN:      (type $1 (func (param v128) (result v128)))

 ;; CHECK-BIN:      (type $2 (func (param i32) (result v128)))

 ;; CHECK-BIN:      (type $3 (func (param v128 i32) (result v128)))

 ;; CHECK-BIN:      (type $4 (func (param v128) (result i32)))

 ;; CHECK-BIN:      (type $5 (func (param i32 v128)))

 ;; CHECK-BIN:      (type $6 (func (param i32 v128) (result v128)))

 ;; CHECK-BIN:      (type $7 (func (result v128)))

 ;; CHECK-BIN:      (type $8 (func (param f32) (result v128)))

 ;; CHECK-BIN:      (type $9 (func (param f64) (result v128)))

 ;; CHECK-BIN:      (type $10 (func (param v128) (result i64)))

 ;; CHECK-BIN:      (type $11 (func (param v128 i64) (result v128)))

 ;; CHECK-BIN:      (type $12 (func (param v128) (result f32)))

 ;; CHECK-BIN:      (type $13 (func (param v128 f32) (result v128)))

 ;; CHECK-BIN:      (type $14 (func (param v128) (result f64)))

 ;; CHECK-BIN:      (type $15 (func (param v128 f64) (result v128)))

 ;; CHECK-BIN:      (type $16 (func (param v128 v128 v128) (result v128)))

 ;; CHECK-BIN:      (memory $0 1 1)

 ;; CHECK-BIN:      (func $v128.load (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load (param $0 i32) (result v128)
  (v128.load offset=0 align=16
    (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_s (param $0 i32) (result v128)
  (v128.load8x8_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_u (param $0 i32) (result v128)
  (v128.load8x8_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_s (param $0 i32) (result v128)
  (v128.load16x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_u (param $0 i32) (result v128)
  (v128.load16x4_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_s (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_s (param $0 i32) (result v128)
  (v128.load32x2_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_u (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_u (param $0 i32) (result v128)
  (v128.load32x2_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_splat (param $0 i32) (result v128)
  (v128.load8_splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_splat (param $0 i32) (result v128)
  (v128.load16_splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_splat (param $0 i32) (result v128)
  (v128.load32_splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_splat (param $0 i32) (result v128)
  (v128.load64_splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store (param $0 i32) (param $1 v128)
  (v128.store offset=0 align=16
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.const.i8x16 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x04030201 0x08070605 0x0c0b0a09 0x100f0e0d)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.i8x16 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x04030201 0x08070605 0x0c0b0a09 0x100f0e0d)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.i8x16 (result v128)
  (v128.const i8x16 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16)
 )

 ;; CHECK-TEXT:      (func $v128.const.i16x8 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x00020001 0x00040003 0x00060005 0x00080007)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.i16x8 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x00020001 0x00040003 0x00060005 0x00080007)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.i16x8 (result v128)
  (v128.const i16x8 1 2 3 4 5 6 7 8)
 )

 ;; CHECK-TEXT:      (func $v128.const.i32x4 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x00000001 0x00000002 0x00000003 0x00000004)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.i32x4 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x00000001 0x00000002 0x00000003 0x00000004)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.i32x4 (result v128)
  (v128.const i32x4 1 2 3 4)
 )

 ;; CHECK-TEXT:      (func $v128.const.i64x2 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x00000001 0x00000000 0x00000002 0x00000000)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.i64x2 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x00000001 0x00000000 0x00000002 0x00000000)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.i64x2 (result v128)
  (v128.const i64x2 1 2)
 )

 ;; CHECK-TEXT:      (func $v128.const.f32x4 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x3f800000 0x40000000 0x40400000 0x40800000)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.f32x4 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x3f800000 0x40000000 0x40400000 0x40800000)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.f32x4 (result v128)
  (v128.const f32x4 1.0 2 3 4)
 )

 ;; CHECK-TEXT:      (func $v128.const.f64x2 (type $7) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.const i32x4 0x00000000 0x3ff00000 0x00000000 0x40000000)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.const.f64x2 (type $7) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.const i32x4 0x00000000 0x3ff00000 0x00000000 0x40000000)
 ;; CHECK-BIN-NEXT: )
 (func $v128.const.f64x2 (result v128)
  (v128.const f64x2 1.0 2)
 )

 ;; CHECK-TEXT:      (func $i8x16.shuffle (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.shuffle 0 17 2 19 4 21 6 23 8 25 10 27 12 29 14 31
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.shuffle (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.shuffle 0 17 2 19 4 21 6 23 8 25 10 27 12 29 14 31
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.shuffle (param $0 v128) (param $1 v128) (result v128)
  (i8x16.shuffle 0 17 2 19 4 21 6 23 8 25 10 27 12 29 14 31
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.swizzle (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.swizzle
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.swizzle (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.swizzle
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.swizzle (param $0 v128) (param $1 v128) (result v128)
  (i8x16.swizzle
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.splat (param $0 i32) (result v128)
  (i8x16.splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.splat (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.splat (param $0 i32) (result v128)
  (i16x8.splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.splat (type $8) (param $0 f32) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.splat (type $8) (param $0 f32) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.splat (param $0 f32) (result v128)
  (f32x4.splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.splat (type $9) (param $0 f64) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.splat
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.splat (type $9) (param $0 f64) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.splat
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.splat (param $0 f64) (result v128)
  (f64x2.splat
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.extract_lane_s (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i8x16.extract_lane_s 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.extract_lane_s (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i8x16.extract_lane_s 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.extract_lane_s (param $0 v128) (result i32)
  (i8x16.extract_lane_s 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.extract_lane_u (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i8x16.extract_lane_u 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.extract_lane_u (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i8x16.extract_lane_u 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.extract_lane_u (param $0 v128) (result i32)
  (i8x16.extract_lane_u 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.replace_lane (param $0 v128) (param $1 i32) (result v128)
  (i8x16.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extract_lane_s (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i16x8.extract_lane_s 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extract_lane_s (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i16x8.extract_lane_s 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extract_lane_s (param $0 v128) (result i32)
  (i16x8.extract_lane_s 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extract_lane_u (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i16x8.extract_lane_u 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extract_lane_u (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i16x8.extract_lane_u 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extract_lane_u (param $0 v128) (result i32)
  (i16x8.extract_lane_u 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.replace_lane (param $0 v128) (param $1 i32) (result v128)
  (i16x8.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extract_lane (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i32x4.extract_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extract_lane (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i32x4.extract_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extract_lane (param $0 v128) (result i32)
  (i32x4.extract_lane 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.replace_lane (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.replace_lane (param $0 v128) (param $1 i32) (result v128)
  (i32x4.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extract_lane (type $10) (param $0 v128) (result i64)
 ;; CHECK-TEXT-NEXT:  (i64x2.extract_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extract_lane (type $10) (param $0 v128) (result i64)
 ;; CHECK-BIN-NEXT:  (i64x2.extract_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extract_lane (param $0 v128) (result i64)
  (i64x2.extract_lane 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.replace_lane (type $11) (param $0 v128) (param $1 i64) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.replace_lane (type $11) (param $0 v128) (param $1 i64) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.replace_lane (param $0 v128) (param $1 i64) (result v128)
  (i64x2.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.extract_lane (type $12) (param $0 v128) (result f32)
 ;; CHECK-TEXT-NEXT:  (f32x4.extract_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.extract_lane (type $12) (param $0 v128) (result f32)
 ;; CHECK-BIN-NEXT:  (f32x4.extract_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.extract_lane (param $0 v128) (result f32)
  (f32x4.extract_lane 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.replace_lane (type $13) (param $0 v128) (param $1 f32) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.replace_lane (type $13) (param $0 v128) (param $1 f32) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.replace_lane (param $0 v128) (param $1 f32) (result v128)
  (f32x4.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.extract_lane (type $14) (param $0 v128) (result f64)
 ;; CHECK-TEXT-NEXT:  (f64x2.extract_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.extract_lane (type $14) (param $0 v128) (result f64)
 ;; CHECK-BIN-NEXT:  (f64x2.extract_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.extract_lane (param $0 v128) (result f64)
  (f64x2.extract_lane 0
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.replace_lane (type $15) (param $0 v128) (param $1 f64) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.replace_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.replace_lane (type $15) (param $0 v128) (param $1 f64) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.replace_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.replace_lane (param $0 v128) (param $1 f64) (result v128)
  (f64x2.replace_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.eq (param $0 v128) (param $1 v128) (result v128)
  (i8x16.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.ne (param $0 v128) (param $1 v128) (result v128)
  (i8x16.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.lt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.lt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.lt_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.lt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.lt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.lt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.lt_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.lt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.gt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.gt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.gt_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.gt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.gt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.gt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.gt_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.gt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.le_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.le_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.le_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.le_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.le_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.le_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.le_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.le_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.ge_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.ge_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.ge_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.ge_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.ge_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.ge_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.ge_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.ge_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.eq (param $0 v128) (param $1 v128) (result v128)
  (i16x8.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.ne (param $0 v128) (param $1 v128) (result v128)
  (i16x8.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.lt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.lt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.lt_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.lt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.lt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.lt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.lt_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.lt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.gt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.gt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.gt_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.gt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.gt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.gt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.gt_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.gt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.le_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.le_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.le_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.le_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.le_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.le_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.le_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.le_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.ge_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.ge_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.ge_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.ge_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.ge_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.ge_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.ge_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.ge_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.eq (param $0 v128) (param $1 v128) (result v128)
  (i32x4.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.ne (param $0 v128) (param $1 v128) (result v128)
  (i32x4.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.lt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.lt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.lt_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.lt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.lt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.lt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.lt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.lt_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.lt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.gt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.gt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.gt_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.gt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.gt_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.gt_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.gt_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.gt_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.gt_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.le_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.le_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.le_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.le_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.le_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.le_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.le_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.le_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.le_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.ge_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.ge_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.ge_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.ge_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.ge_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.ge_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.ge_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.ge_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.ge_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.eq (param $0 v128) (param $1 v128) (result v128)
  (f32x4.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.ne (param $0 v128) (param $1 v128) (result v128)
  (f32x4.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.lt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.lt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.lt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.lt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.lt (param $0 v128) (param $1 v128) (result v128)
  (f32x4.lt
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.gt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.gt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.gt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.gt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.gt (param $0 v128) (param $1 v128) (result v128)
  (f32x4.gt
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.le (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.le
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.le (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.le
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.le (param $0 v128) (param $1 v128) (result v128)
  (f32x4.le
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.ge (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.ge
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.ge (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.ge
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.ge (param $0 v128) (param $1 v128) (result v128)
  (f32x4.ge
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.eq (param $0 v128) (param $1 v128) (result v128)
  (f64x2.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.ne (param $0 v128) (param $1 v128) (result v128)
  (f64x2.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.lt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.lt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.lt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.lt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.lt (param $0 v128) (param $1 v128) (result v128)
  (f64x2.lt
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.gt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.gt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.gt (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.gt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.gt (param $0 v128) (param $1 v128) (result v128)
  (f64x2.gt
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.le (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.le
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.le (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.le
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.le (param $0 v128) (param $1 v128) (result v128)
  (f64x2.le
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.ge (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.ge
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.ge (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.ge
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.ge (param $0 v128) (param $1 v128) (result v128)
  (f64x2.ge
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.not (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.not
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.not (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.not
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.not (param $0 v128) (result v128)
  (v128.not
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.and (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.and
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.and (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.and
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.and (param $0 v128) (param $1 v128) (result v128)
  (v128.and
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.andnot (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.andnot
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.andnot (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.andnot
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.andnot (param $0 v128) (param $1 v128) (result v128)
  (v128.andnot
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.or (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.or
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.or (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.or
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.or (param $0 v128) (param $1 v128) (result v128)
  (v128.or
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.xor (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.xor
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.xor (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.xor
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.xor (param $0 v128) (param $1 v128) (result v128)
  (v128.xor
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.bitselect (type $16) (param $0 v128) (param $1 v128) (param $2 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.bitselect
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.bitselect (type $16) (param $0 v128) (param $1 v128) (param $2 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.bitselect
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.bitselect (param $0 v128) (param $1 v128) (param $2 v128) (result v128)
  (v128.bitselect
   (local.get $0)
   (local.get $1)
   (local.get $2)
  )
 )

 ;; CHECK-TEXT:      (func $v128.any_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (v128.any_true
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.any_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (v128.any_true
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.any_true (param $0 v128) (result i32)
  (v128.any_true
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load8_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load16_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load32_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_offset (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_offset (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_offset (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align_offset (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align_offset (type $6) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align_offset (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store8_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store8_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store8_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store8_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store8_lane (param $0 i32) (param $1 v128)
  (v128.store8_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store16_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store16_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store16_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store16_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store16_lane (param $0 i32) (param $1 v128)
  (v128.store16_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store32_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store32_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store32_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store32_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store32_lane (param $0 i32) (param $1 v128)
  (v128.store32_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane (param $0 i32) (param $1 v128)
  (v128.store64_lane 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align (param $0 i32) (param $1 v128)
  (v128.store64_lane align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_offset (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_offset (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_offset (param $0 i32) (param $1 v128)
  (v128.store64_lane offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align_offset (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align_offset (type $5) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align_offset (param $0 i32) (param $1 v128)
  (v128.store64_lane offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_zero (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_zero
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_zero (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_zero
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_zero (param $0 i32) (result v128)
  (v128.load32_zero
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_zero (type $2) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_zero
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_zero (type $2) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_zero
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_zero (param $0 i32) (result v128)
  (v128.load64_zero
   (local.get $0)
  )
 )

  ;; CHECK-TEXT:      (func $f32x4.demote_f64x2_zero (type $1) (param $0 v128) (result v128)
  ;; CHECK-TEXT-NEXT:  (f32x4.demote_f64x2_zero
  ;; CHECK-TEXT-NEXT:   (local.get $0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $f32x4.demote_f64x2_zero (type $1) (param $0 v128) (result v128)
  ;; CHECK-BIN-NEXT:  (f32x4.demote_f64x2_zero
  ;; CHECK-BIN-NEXT:   (local.get $0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $f32x4.demote_f64x2_zero (param $0 v128) (result v128)
  (f32x4.demote_f64x2_zero
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.promote_low_f32x4 (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.promote_low_f32x4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.promote_low_f32x4 (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.promote_low_f32x4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.promote_low_f32x4 (param $0 v128) (result v128)
  (f64x2.promote_low_f32x4
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.abs (param $0 v128) (result v128)
  (i8x16.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.neg (param $0 v128) (result v128)
  (i8x16.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.popcnt (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.popcnt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.popcnt (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.popcnt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.popcnt (param $0 v128) (result v128)
  (i8x16.popcnt
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i8x16.all_true
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i8x16.all_true
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.all_true (param $0 v128) (result i32)
  (i8x16.all_true
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i8x16.bitmask
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i8x16.bitmask
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.bitmask (param $0 v128) (result i32)
  (i8x16.bitmask
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.narrow_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.narrow_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.narrow_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.narrow_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.narrow_i16x8_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.narrow_i16x8_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.narrow_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.narrow_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.narrow_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.narrow_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.narrow_i16x8_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.narrow_i16x8_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.ceil (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.ceil
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.ceil (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.ceil
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.ceil (param $0 v128) (result v128)
  (f32x4.ceil
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.floor (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.floor
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.floor (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.floor
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.floor (param $0 v128) (result v128)
  (f32x4.floor
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.trunc (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.trunc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.trunc (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.trunc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.trunc (param $0 v128) (result v128)
  (f32x4.trunc
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.nearest (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.nearest
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.nearest (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.nearest
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.nearest (param $0 v128) (result v128)
  (f32x4.nearest
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.shl
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.shl
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.shl (param $0 v128) (param $1 i32) (result v128)
  (i8x16.shl
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.shr_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.shr_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.shr_s (param $0 v128) (param $1 i32) (result v128)
  (i8x16.shr_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.shr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.shr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.shr_u (param $0 v128) (param $1 i32) (result v128)
  (i8x16.shr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.add (param $0 v128) (param $1 v128) (result v128)
  (i8x16.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.add_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.add_sat_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.add_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.add_sat_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.add_sat_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.add_sat_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.add_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.add_sat_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.add_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.add_sat_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.add_sat_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.add_sat_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.sub (param $0 v128) (param $1 v128) (result v128)
  (i8x16.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.sub_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.sub_sat_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.sub_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.sub_sat_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.sub_sat_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.sub_sat_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.sub_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.sub_sat_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.sub_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.sub_sat_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.sub_sat_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.sub_sat_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.ceil (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.ceil
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.ceil (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.ceil
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.ceil (param $0 v128) (result v128)
  (f64x2.ceil
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.floor (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.floor
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.floor (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.floor
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.floor (param $0 v128) (result v128)
  (f64x2.floor
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.min_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.min_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.min_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.min_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.min_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.min_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.min_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.min_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.max_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.max_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.max_s (param $0 v128) (param $1 v128) (result v128)
  (i8x16.max_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.max_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.max_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.max_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.max_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.trunc (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.trunc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.trunc (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.trunc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.trunc (param $0 v128) (result v128)
  (f64x2.trunc
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i8x16.avgr_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i8x16.avgr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i8x16.avgr_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i8x16.avgr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i8x16.avgr_u (param $0 v128) (param $1 v128) (result v128)
  (i8x16.avgr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extadd_pairwise_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extadd_pairwise_i8x16_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extadd_pairwise_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extadd_pairwise_i8x16_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extadd_pairwise_i8x16_s (param $0 v128) (result v128)
  (i16x8.extadd_pairwise_i8x16_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extadd_pairwise_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extadd_pairwise_i8x16_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extadd_pairwise_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extadd_pairwise_i8x16_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extadd_pairwise_i8x16_u (param $0 v128) (result v128)
  (i16x8.extadd_pairwise_i8x16_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extadd_pairwise_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extadd_pairwise_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extadd_pairwise_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extadd_pairwise_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extadd_pairwise_i16x8_s (param $0 v128) (result v128)
  (i32x4.extadd_pairwise_i16x8_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extadd_pairwise_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extadd_pairwise_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extadd_pairwise_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extadd_pairwise_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extadd_pairwise_i16x8_u (param $0 v128) (result v128)
  (i32x4.extadd_pairwise_i16x8_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.abs (param $0 v128) (result v128)
  (i16x8.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.neg (param $0 v128) (result v128)
  (i16x8.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.q15mulr_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.q15mulr_sat_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.q15mulr_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.q15mulr_sat_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.q15mulr_sat_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.q15mulr_sat_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i16x8.all_true
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i16x8.all_true
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.all_true (param $0 v128) (result i32)
  (i16x8.all_true
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i16x8.bitmask
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i16x8.bitmask
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.bitmask (param $0 v128) (result i32)
  (i16x8.bitmask
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.narrow_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.narrow_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.narrow_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.narrow_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.narrow_i32x4_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.narrow_i32x4_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.narrow_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.narrow_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.narrow_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.narrow_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.narrow_i32x4_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.narrow_i32x4_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extend_low_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extend_low_i8x16_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extend_low_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extend_low_i8x16_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extend_low_i8x16_s (param $0 v128) (result v128)
  (i16x8.extend_low_i8x16_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extend_high_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extend_high_i8x16_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extend_high_i8x16_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extend_high_i8x16_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extend_high_i8x16_s (param $0 v128) (result v128)
  (i16x8.extend_high_i8x16_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extend_low_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extend_low_i8x16_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extend_low_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extend_low_i8x16_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extend_low_i8x16_u (param $0 v128) (result v128)
  (i16x8.extend_low_i8x16_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extend_high_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extend_high_i8x16_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extend_high_i8x16_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extend_high_i8x16_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extend_high_i8x16_u (param $0 v128) (result v128)
  (i16x8.extend_high_i8x16_u
   (local.get $0)
  )
 )

;; CHECK-TEXT:      (func $i16x8.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-TEXT-NEXT:  (i16x8.shl
;; CHECK-TEXT-NEXT:   (local.get $0)
;; CHECK-TEXT-NEXT:   (local.get $1)
;; CHECK-TEXT-NEXT:  )
;; CHECK-TEXT-NEXT: )
;; CHECK-BIN:      (func $i16x8.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NEXT:  (i16x8.shl
;; CHECK-BIN-NEXT:   (local.get $0)
;; CHECK-BIN-NEXT:   (local.get $1)
;; CHECK-BIN-NEXT:  )
;; CHECK-BIN-NEXT: )
(func $i16x8.shl (param $0 v128) (param $1 i32) (result v128)
  (i16x8.shl
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.shr_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.shr_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.shr_s (param $0 v128) (param $1 i32) (result v128)
  (i16x8.shr_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.shr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.shr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.shr_u (param $0 v128) (param $1 i32) (result v128)
  (i16x8.shr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.add (param $0 v128) (param $1 v128) (result v128)
  (i16x8.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.add_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.add_sat_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.add_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.add_sat_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.add_sat_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.add_sat_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.add_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.add_sat_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.add_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.add_sat_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.add_sat_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.add_sat_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.sub (param $0 v128) (param $1 v128) (result v128)
  (i16x8.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.sub_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.sub_sat_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.sub_sat_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.sub_sat_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.sub_sat_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.sub_sat_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.sub_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.sub_sat_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.sub_sat_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.sub_sat_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.sub_sat_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.sub_sat_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.nearest (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.nearest
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.nearest (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.nearest
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.nearest (param $0 v128) (result v128)
  (f64x2.nearest
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.mul
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.mul
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.mul (param $0 v128) (param $1 v128) (result v128)
  (i16x8.mul
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.min_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.min_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.min_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.min_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.min_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.min_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.min_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.min_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.max_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.max_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.max_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.max_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.max_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.max_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.max_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.max_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.avgr_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.avgr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.avgr_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.avgr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.avgr_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.avgr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extmul_low_i8x16_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extmul_low_i8x16_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extmul_low_i8x16_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extmul_low_i8x16_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extmul_low_i8x16_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.extmul_low_i8x16_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extmul_high_i8x16_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extmul_high_i8x16_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extmul_high_i8x16_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extmul_high_i8x16_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extmul_high_i8x16_s (param $0 v128) (param $1 v128) (result v128)
  (i16x8.extmul_high_i8x16_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extmul_low_i8x16_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extmul_low_i8x16_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extmul_low_i8x16_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extmul_low_i8x16_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extmul_low_i8x16_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.extmul_low_i8x16_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i16x8.extmul_high_i8x16_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i16x8.extmul_high_i8x16_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i16x8.extmul_high_i8x16_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i16x8.extmul_high_i8x16_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i16x8.extmul_high_i8x16_u (param $0 v128) (param $1 v128) (result v128)
  (i16x8.extmul_high_i8x16_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.abs (param $0 v128) (result v128)
  (i32x4.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.neg (param $0 v128) (result v128)
  (i32x4.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i32x4.all_true
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i32x4.all_true
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.all_true (param $0 v128) (result i32)
  (i32x4.all_true
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i32x4.bitmask
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i32x4.bitmask
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.bitmask (param $0 v128) (result i32)
  (i32x4.bitmask
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extend_low_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extend_low_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extend_low_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extend_low_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extend_low_i16x8_s (param $0 v128) (result v128)
  (i32x4.extend_low_i16x8_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extend_high_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extend_high_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extend_high_i16x8_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extend_high_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extend_high_i16x8_s (param $0 v128) (result v128)
  (i32x4.extend_high_i16x8_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extend_low_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extend_low_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extend_low_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extend_low_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extend_low_i16x8_u (param $0 v128) (result v128)
  (i32x4.extend_low_i16x8_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extend_high_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extend_high_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extend_high_i16x8_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extend_high_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extend_high_i16x8_u (param $0 v128) (result v128)
  (i32x4.extend_high_i16x8_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.shl
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.shl
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.shl (param $0 v128) (param $1 i32) (result v128)
  (i32x4.shl
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.shr_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.shr_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.shr_s (param $0 v128) (param $1 i32) (result v128)
  (i32x4.shr_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.shr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.shr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.shr_u (param $0 v128) (param $1 i32) (result v128)
  (i32x4.shr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.add (param $0 v128) (param $1 v128) (result v128)
  (i32x4.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.sub (param $0 v128) (param $1 v128) (result v128)
  (i32x4.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.mul
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.mul
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.mul (param $0 v128) (param $1 v128) (result v128)
  (i32x4.mul
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.min_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.min_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.min_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.min_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.min_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.min_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.min_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.min_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.min_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.min_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.max_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.max_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.max_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.max_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.max_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.max_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.max_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.max_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.max_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.max_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.dot_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.dot_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.dot_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.dot_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.dot_i16x8_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.dot_i16x8_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extmul_low_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extmul_low_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extmul_low_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extmul_low_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extmul_low_i16x8_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.extmul_low_i16x8_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extmul_high_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extmul_high_i16x8_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extmul_high_i16x8_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extmul_high_i16x8_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extmul_high_i16x8_s (param $0 v128) (param $1 v128) (result v128)
  (i32x4.extmul_high_i16x8_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extmul_low_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extmul_low_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extmul_low_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extmul_low_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extmul_low_i16x8_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.extmul_low_i16x8_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.extmul_high_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.extmul_high_i16x8_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.extmul_high_i16x8_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.extmul_high_i16x8_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.extmul_high_i16x8_u (param $0 v128) (param $1 v128) (result v128)
  (i32x4.extmul_high_i16x8_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.abs (param $0 v128) (result v128)
  (i64x2.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.neg (param $0 v128) (result v128)
  (i64x2.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i64x2.all_true
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.all_true (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i64x2.all_true
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.all_true (param $0 v128) (result i32)
  (i64x2.all_true
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-TEXT-NEXT:  (i64x2.bitmask
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.bitmask (type $4) (param $0 v128) (result i32)
 ;; CHECK-BIN-NEXT:  (i64x2.bitmask
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.bitmask (param $0 v128) (result i32)
  (i64x2.bitmask
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extend_low_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extend_low_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extend_low_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extend_low_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extend_low_i32x4_s (param $0 v128) (result v128)
  (i64x2.extend_low_i32x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extend_high_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extend_high_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extend_high_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extend_high_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extend_high_i32x4_s (param $0 v128) (result v128)
  (i64x2.extend_high_i32x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extend_low_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extend_low_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extend_low_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extend_low_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extend_low_i32x4_u (param $0 v128) (result v128)
  (i64x2.extend_low_i32x4_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extend_high_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extend_high_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extend_high_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extend_high_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extend_high_i32x4_u (param $0 v128) (result v128)
  (i64x2.extend_high_i32x4_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.shl
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.shl (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.shl
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.shl (param $0 v128) (param $1 i32) (result v128)
  (i64x2.shl
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.shr_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.shr_s (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.shr_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.shr_s (param $0 v128) (param $1 i32) (result v128)
  (i64x2.shr_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.shr_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.shr_u (type $3) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.shr_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.shr_u (param $0 v128) (param $1 i32) (result v128)
  (i64x2.shr_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.add (param $0 v128) (param $1 v128) (result v128)
  (i64x2.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.sub (param $0 v128) (param $1 v128) (result v128)
  (i64x2.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.mul
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.mul
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.mul (param $0 v128) (param $1 v128) (result v128)
  (i64x2.mul
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.eq
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.eq (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.eq
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.eq (param $0 v128) (param $1 v128) (result v128)
  (i64x2.eq
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.ne
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.ne (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.ne
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.ne (param $0 v128) (param $1 v128) (result v128)
  (i64x2.ne
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.lt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.lt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.lt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.lt_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.lt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.gt_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.gt_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.gt_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.gt_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.gt_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.le_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.le_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.le_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.le_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.le_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.ge_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.ge_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.ge_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.ge_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.ge_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extmul_low_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extmul_low_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extmul_low_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extmul_low_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extmul_low_i32x4_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.extmul_low_i32x4_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extmul_high_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extmul_high_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extmul_high_i32x4_s (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extmul_high_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extmul_high_i32x4_s (param $0 v128) (param $1 v128) (result v128)
  (i64x2.extmul_high_i32x4_s
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extmul_low_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extmul_low_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extmul_low_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extmul_low_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extmul_low_i32x4_u (param $0 v128) (param $1 v128) (result v128)
  (i64x2.extmul_low_i32x4_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i64x2.extmul_high_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i64x2.extmul_high_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i64x2.extmul_high_i32x4_u (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i64x2.extmul_high_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i64x2.extmul_high_i32x4_u (param $0 v128) (param $1 v128) (result v128)
  (i64x2.extmul_high_i32x4_u
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.abs (param $0 v128) (result v128)
  (f32x4.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.neg (param $0 v128) (result v128)
  (f32x4.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.sqrt (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.sqrt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.sqrt (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.sqrt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.sqrt (param $0 v128) (result v128)
  (f32x4.sqrt
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.add (param $0 v128) (param $1 v128) (result v128)
  (f32x4.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.sub (param $0 v128) (param $1 v128) (result v128)
  (f32x4.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.mul
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.mul
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.mul (param $0 v128) (param $1 v128) (result v128)
  (f32x4.mul
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.div (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.div
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.div (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.div
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.div (param $0 v128) (param $1 v128) (result v128)
  (f32x4.div
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.min (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.min
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.min (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.min
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.min (param $0 v128) (param $1 v128) (result v128)
  (f32x4.min
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.max (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.max
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.max (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.max
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.max (param $0 v128) (param $1 v128) (result v128)
  (f32x4.max
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.pmin (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.pmin
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.pmin (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.pmin
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.pmin (param $0 v128) (param $1 v128) (result v128)
  (f32x4.pmin
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.pmax (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.pmax
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.pmax (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.pmax
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.pmax (param $0 v128) (param $1 v128) (result v128)
  (f32x4.pmax
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.abs
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.abs (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.abs
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.abs (param $0 v128) (result v128)
  (f64x2.abs
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.neg
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.neg (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.neg
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.neg (param $0 v128) (result v128)
  (f64x2.neg
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.sqrt (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.sqrt
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.sqrt (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.sqrt
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.sqrt (param $0 v128) (result v128)
  (f64x2.sqrt
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.add
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.add (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.add
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.add (param $0 v128) (param $1 v128) (result v128)
  (f64x2.add
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.sub
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.sub (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.sub
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.sub (param $0 v128) (param $1 v128) (result v128)
  (f64x2.sub
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.mul
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.mul (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.mul
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.mul (param $0 v128) (param $1 v128) (result v128)
  (f64x2.mul
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.div (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.div
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.div (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.div
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.div (param $0 v128) (param $1 v128) (result v128)
  (f64x2.div
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.min (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.min
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.min (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.min
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.min (param $0 v128) (param $1 v128) (result v128)
  (f64x2.min
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.max (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.max
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.max (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.max
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.max (param $0 v128) (param $1 v128) (result v128)
  (f64x2.max
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.pmin (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.pmin
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.pmin (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.pmin
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.pmin (param $0 v128) (param $1 v128) (result v128)
  (f64x2.pmin
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.pmax (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.pmax
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.pmax (type $0) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.pmax
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.pmax (param $0 v128) (param $1 v128) (result v128)
  (f64x2.pmax
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.trunc_sat_f32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.trunc_sat_f32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.trunc_sat_f32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.trunc_sat_f32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.trunc_sat_f32x4_s (param $0 v128) (result v128)
  (i32x4.trunc_sat_f32x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.trunc_sat_f32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.trunc_sat_f32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.trunc_sat_f32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.trunc_sat_f32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.trunc_sat_f32x4_u (param $0 v128) (result v128)
  (i32x4.trunc_sat_f32x4_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.convert_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.convert_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.convert_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.convert_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.convert_i32x4_s (param $0 v128) (result v128)
  (f32x4.convert_i32x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f32x4.convert_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f32x4.convert_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f32x4.convert_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f32x4.convert_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f32x4.convert_i32x4_u (param $0 v128) (result v128)
  (f32x4.convert_i32x4_u
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.trunc_sat_f64x2_s_zero (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.trunc_sat_f64x2_s_zero
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.trunc_sat_f64x2_s_zero (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.trunc_sat_f64x2_s_zero
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.trunc_sat_f64x2_s_zero (param $0 v128) (result v128)
  (i32x4.trunc_sat_f64x2_s_zero
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $i32x4.trunc_sat_f64x2_u_zero (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (i32x4.trunc_sat_f64x2_u_zero
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $i32x4.trunc_sat_f64x2_u_zero (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (i32x4.trunc_sat_f64x2_u_zero
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $i32x4.trunc_sat_f64x2_u_zero (param $0 v128) (result v128)
  (i32x4.trunc_sat_f64x2_u_zero
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.convert_low_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.convert_low_i32x4_s
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.convert_low_i32x4_s (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.convert_low_i32x4_s
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.convert_low_i32x4_s (param $0 v128) (result v128)
  (f64x2.convert_low_i32x4_s
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $f64x2.convert_low_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (f64x2.convert_low_i32x4_u
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $f64x2.convert_low_i32x4_u (type $1) (param $0 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (f64x2.convert_low_i32x4_u
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $f64x2.convert_low_i32x4_u (param $0 v128) (result v128)
  (f64x2.convert_low_i32x4_u
   (local.get $0)
  )
 )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func (param v128 v128) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $1 (func (param v128) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $2 (func (param i32) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $3 (func (param v128 i32) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $4 (func (param v128) (result i32)))

;; CHECK-BIN-NODEBUG:      (type $5 (func (param i32 v128)))

;; CHECK-BIN-NODEBUG:      (type $6 (func (param i32 v128) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $7 (func (result v128)))

;; CHECK-BIN-NODEBUG:      (type $8 (func (param f32) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $9 (func (param f64) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $10 (func (param v128) (result i64)))

;; CHECK-BIN-NODEBUG:      (type $11 (func (param v128 i64) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $12 (func (param v128) (result f32)))

;; CHECK-BIN-NODEBUG:      (type $13 (func (param v128 f32) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $14 (func (param v128) (result f64)))

;; CHECK-BIN-NODEBUG:      (type $15 (func (param v128 f64) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $16 (func (param v128 v128 v128) (result v128)))

;; CHECK-BIN-NODEBUG:      (memory $0 1 1)

;; CHECK-BIN-NODEBUG:      (func $0 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x04030201 0x08070605 0x0c0b0a09 0x100f0e0d)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x00020001 0x00040003 0x00060005 0x00080007)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x00000001 0x00000002 0x00000003 0x00000004)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x00000001 0x00000000 0x00000002 0x00000000)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x3f800000 0x40000000 0x40400000 0x40800000)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $7) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.const i32x4 0x00000000 0x3ff00000 0x00000000 0x40000000)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.shuffle 0 17 2 19 4 21 6 23 8 25 10 27 12 29 14 31
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.swizzle
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $8) (param $0 f32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $9) (param $0 f64) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.splat
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $24 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.extract_lane_s 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $25 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.extract_lane_u 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $26 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $27 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extract_lane_s 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $28 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extract_lane_u 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $29 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $30 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extract_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $31 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $32 (type $10) (param $0 v128) (result i64)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extract_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $33 (type $11) (param $0 v128) (param $1 i64) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $34 (type $12) (param $0 v128) (result f32)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.extract_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $35 (type $13) (param $0 v128) (param $1 f32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $36 (type $14) (param $0 v128) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.extract_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $37 (type $15) (param $0 v128) (param $1 f64) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.replace_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $38 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $39 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $40 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.lt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $41 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.lt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $42 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.gt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $43 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.gt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $44 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.le_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $45 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.le_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $46 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.ge_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $47 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.ge_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $48 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $49 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $50 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.lt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $51 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.lt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $52 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.gt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $53 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.gt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $54 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.le_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $55 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.le_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $56 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.ge_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $57 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.ge_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $58 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $59 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $60 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.lt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $61 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.lt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $62 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.gt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $63 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.gt_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $64 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.le_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $65 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.le_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $66 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.ge_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $67 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.ge_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $68 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $69 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $70 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.lt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $71 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.gt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $72 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.le
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $73 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.ge
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $74 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $75 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $76 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.lt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $77 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.gt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $78 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.le
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $79 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.ge
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $80 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.not
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $81 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.and
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $82 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.andnot
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $83 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.or
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $84 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.xor
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $85 (type $16) (param $0 v128) (param $1 v128) (param $2 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.bitselect
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $86 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.any_true
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $87 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $88 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $89 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $90 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $91 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $92 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $93 (type $6) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $94 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store8_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $95 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store16_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $96 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store32_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $97 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $98 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $99 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $100 (type $5) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $101 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_zero
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $102 (type $2) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_zero
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $103 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.demote_f64x2_zero
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $104 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.promote_low_f32x4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $105 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $106 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $107 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.popcnt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $108 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.all_true
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $109 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.bitmask
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $110 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.narrow_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $111 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.narrow_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $112 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.ceil
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $113 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.floor
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $114 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.trunc
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $115 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.nearest
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $116 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.shl
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $117 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.shr_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $118 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.shr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $119 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $120 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.add_sat_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $121 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.add_sat_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $122 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $123 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.sub_sat_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $124 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.sub_sat_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $125 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.ceil
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $126 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.floor
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $127 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.min_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $128 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.min_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $129 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.max_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $130 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.max_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $131 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.trunc
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $132 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i8x16.avgr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $133 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extadd_pairwise_i8x16_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $134 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extadd_pairwise_i8x16_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $135 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extadd_pairwise_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $136 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extadd_pairwise_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $137 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $138 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $139 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.q15mulr_sat_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $140 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.all_true
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $141 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.bitmask
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $142 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.narrow_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $143 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.narrow_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $144 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extend_low_i8x16_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $145 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extend_high_i8x16_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $146 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extend_low_i8x16_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $147 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extend_high_i8x16_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $148 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.shl
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $149 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.shr_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $150 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.shr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $151 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $152 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.add_sat_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $153 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.add_sat_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $154 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $155 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.sub_sat_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $156 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.sub_sat_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $157 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.nearest
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $158 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.mul
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $159 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.min_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $160 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.min_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $161 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.max_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $162 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.max_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $163 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.avgr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $164 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extmul_low_i8x16_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $165 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extmul_high_i8x16_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $166 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extmul_low_i8x16_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $167 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i16x8.extmul_high_i8x16_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $168 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $169 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $170 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.all_true
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $171 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.bitmask
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $172 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extend_low_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $173 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extend_high_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $174 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extend_low_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $175 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extend_high_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $176 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.shl
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $177 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.shr_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $178 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.shr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $179 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $180 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $181 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.mul
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $182 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.min_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $183 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.min_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $184 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.max_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $185 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.max_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $186 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.dot_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $187 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extmul_low_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $188 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extmul_high_i16x8_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $189 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extmul_low_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $190 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.extmul_high_i16x8_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $191 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $192 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $193 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.all_true
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $194 (type $4) (param $0 v128) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.bitmask
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $195 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extend_low_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $196 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extend_high_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $197 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extend_low_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $198 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extend_high_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $199 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.shl
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $200 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.shr_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $201 (type $3) (param $0 v128) (param $1 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.shr_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $202 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $203 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $204 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.mul
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $205 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $206 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.ne
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $207 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.lt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $208 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.gt_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $209 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.le_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $210 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.ge_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $211 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extmul_low_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $212 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extmul_high_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $213 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extmul_low_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $214 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i64x2.extmul_high_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $215 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $216 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $217 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.sqrt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $218 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $219 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $220 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.mul
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $221 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.div
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $222 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.min
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $223 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.max
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $224 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.pmin
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $225 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.pmax
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $226 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.abs
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $227 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.neg
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $228 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.sqrt
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $229 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $230 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.sub
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $231 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.mul
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $232 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.div
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $233 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.min
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $234 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.max
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $235 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.pmin
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $236 (type $0) (param $0 v128) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.pmax
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $237 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.trunc_sat_f32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $238 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.trunc_sat_f32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $239 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.convert_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $240 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f32x4.convert_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $241 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.trunc_sat_f64x2_s_zero
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $242 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (i32x4.trunc_sat_f64x2_u_zero
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $243 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.convert_low_i32x4_s
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $244 (type $1) (param $0 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (f64x2.convert_low_i32x4_u
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )
