/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTUtilities;
import com.kreative.rsrc.pict.PixMap;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ColorCursorResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1668445042;
    public static final short CURSOR_TYPE_BW = Short.MIN_VALUE;
    public static final short CURSOR_TYPE_COLOR = -32767;

    public static boolean isMyType(int type) {
        return type == 1668445042;
    }

    public ColorCursorResource(short id, byte[] data) {
        super(1668445042, id, data);
    }

    public ColorCursorResource(short id, String name, byte[] data) {
        super(1668445042, id, name, data);
    }

    public ColorCursorResource(short id, byte attr, byte[] data) {
        super(1668445042, id, attr, data);
    }

    public ColorCursorResource(short id, byte attr, String name, byte[] data) {
        super(1668445042, id, attr, name, data);
    }

    public ColorCursorResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public ColorCursorResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public ColorCursorResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public ColorCursorResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public short getCursorType() {
        return KSFLUtilities.getShort(this.data, 0);
    }

    public int getPixmapRcdOffset() {
        return KSFLUtilities.getInt(this.data, 2);
    }

    public int getImageOffset() {
        return KSFLUtilities.getInt(this.data, 6);
    }

    public int getExpandedDataOffset() {
        return KSFLUtilities.getInt(this.data, 10);
    }

    public short getExpandedDataBitDepth() {
        return KSFLUtilities.getShort(this.data, 14);
    }

    public Image getBWImage() {
        int[] pixels = new int[512];
        int i = 20;
        int j = 0;
        while (i < 84 && j < 512) {
            pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
            pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
            pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
            pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
            pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
            pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
            pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
            pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
            ++i;
            j += 8;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixels, 0, 16);
        return img;
    }

    public Image getMask() {
        int[] pixels = new int[512];
        int i = 20;
        int j = 0;
        while (i < 84 && j < 512) {
            pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
            pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
            pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
            pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
            pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
            pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
            pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
            pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
            ++i;
            j += 8;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixels, 256, 16);
        return img;
    }

    public Image getBWComposite() {
        int[] pixels = new int[512];
        int i = 20;
        int j = 0;
        while (i < 84 && j < 512) {
            pixels[j + 0] = (this.data[i] & 0x80) >> 7;
            pixels[j + 1] = (this.data[i] & 0x40) >> 6;
            pixels[j + 2] = (this.data[i] & 0x20) >> 5;
            pixels[j + 3] = (this.data[i] & 0x10) >> 4;
            pixels[j + 4] = (this.data[i] & 8) >> 3;
            pixels[j + 5] = (this.data[i] & 4) >> 2;
            pixels[j + 6] = (this.data[i] & 2) >> 1;
            pixels[j + 7] = (this.data[i] & 1) >> 0;
            ++i;
            j += 8;
        }
        int[] pixelsx = new int[256];
        int i2 = 0;
        int j2 = 256;
        while (i2 < 256 && j2 < 512) {
            pixelsx[i2] = pixels[j2] != 0 ? (pixels[i2] != 0 ? -16777216 : -1) : (pixels[i2] != 0 ? -2139062144 : 0);
            ++i2;
            ++j2;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, pixelsx, 0, 16);
        return img;
    }

    public int getHotspotY() {
        return KSFLUtilities.getShort(this.data, 84);
    }

    public int getHotspotX() {
        return KSFLUtilities.getShort(this.data, 86);
    }

    public Point getHotspot() {
        return new Point(KSFLUtilities.getShort(this.data, 86), KSFLUtilities.getShort(this.data, 84));
    }

    public int getColorTableSeed() {
        return KSFLUtilities.getInt(this.data, 92);
    }

    public Image getImage() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(this.getPixmapRcdOffset());
            PixMap crsrpm = PixMap.read(in, true);
            in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(this.getImageOffset());
            byte[] crsrpd = crsrpm.readPixData(in, false);
            in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(crsrpm.pmTable);
            ColorTable crsrct = crsrpm.hasColorTable() ? ColorTable.read(in) : null;
            return PICTUtilities.pixmapToImage(crsrpm, crsrct, crsrpd, -1, -16777216, false, false);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Image getComposite() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(this.getPixmapRcdOffset());
            PixMap crsrpm = PixMap.read(in, true);
            in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(this.getImageOffset());
            byte[] crsrpd = crsrpm.readPixData(in, false);
            in = new DataInputStream(new ByteArrayInputStream(this.data));
            in.skip(crsrpm.pmTable);
            ColorTable crsrct = crsrpm.hasColorTable() ? ColorTable.read(in) : null;
            BufferedImage crs = PICTUtilities.pixmapToImage(crsrpm, crsrct, crsrpd, -1, -16777216, false, false);
            BufferedImage msk = (BufferedImage)this.getMask();
            int[] icnpixels = new int[crs.getWidth() * crs.getHeight()];
            crs.getRGB(0, 0, crs.getWidth(), crs.getHeight(), icnpixels, 0, crs.getWidth());
            int[] mskpixels = new int[msk.getWidth() * msk.getHeight()];
            msk.getRGB(0, 0, msk.getWidth(), msk.getHeight(), mskpixels, 0, msk.getWidth());
            int i = 0;
            while (i < icnpixels.length && i < mskpixels.length) {
                if ((mskpixels[i] & 0xFFFFFF) >= 0x800000) {
                    icnpixels[i] = 0;
                }
                ++i;
            }
            BufferedImage cmp = new BufferedImage(crs.getWidth(), crs.getHeight(), 2);
            cmp.setRGB(0, 0, crs.getWidth(), crs.getHeight(), icnpixels, 0, crs.getWidth());
            return cmp;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

