//  Copyright 2016 John Maddock. Distributed under the Boost
//  Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

static const boost::array<boost::array<typename table_type<T>::type, 3>, 101> gamma_0 = {{{SC_(1.43156441636360688183664865448643158739330056363229723426222506077465368434786796569824218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-30), SC_(6.98536502143685108617882284090181520784225065279944459321343460310063824042105596746205061501871754388692206421700826292338586923926227628460021980992867287987375102820871203483062060697666614954318393354992686094982543110966849877446263308176165064356911280715433887048666237697473022869255273999217684089964991492221986910024913642477585922789463545534969256995761341961043378489622694491092689099559034124245255841747358458264103951568451574298386270253381902108950381976482928860300454676297330631e+29), SC_(6.87187849460716195307241085972306257332085866067179593404732520056618176287191986920381800623266452019036583359883694184875415202170061110761480957915606961682069515921066423464205321804055901215315467103669400564886703708251292818882278221076111306170866005908677608207802396451776607673326647945821489765973119269856654977100758235960633379767322574933089743488018675093572248899118887185116534963011794036363538903828089102456817460307090409752243309227015705466471210473582150215759294410478127318e+01)},
                                                                                          {SC_(1.79146693234808763489644628257161121326585477954787539722758538118796423077583312988281250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-30), SC_(5.58201763003960861567789539135859580193439485454005702914698335930268444742331582630745213615777247085201364155083693868300803234678816291383457578463565723759685983298265642045770249117431149944641399014596592494299731209900651334858910291525879151363330828856538879949073338110312308363596227316892822743368020808448586000291704754174750156554217552056937856371791137981786534012294619836443861840926728414921766784846846305707429974243911452854519547303013841568504048941438592827646572038542434135e+29), SC_(6.84945179903097403861349744215875103992060757962123025404796608423978602225846553619170965077356955755357802672163974219562277828210284327971512344158362567867847738326049609853308815256769082679556958330239424646993080494046302980172303736275513780193302833410723002758066285468945113082751363817936859921002909109039191137803314698577973722031573009127625727285778678734025455705063199556191858178447008447936782744160858096688591534358039500459582424936993394926936663017800067374964851005923319757e+01)},
                                                                                          {SC_(6.01361845021915553684662812684153866129482788357822620195491936101461760699748992919921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-30), SC_(1.66289233059599382108622045278925250222879368299965805063800397354768670022530740489524286087023172081743657291575193949292317670513431375657893264047630789615214924106176337174346019293635258374337002078109120613262494521256415816444259140590129490551962102684902275473895987026116781659018530303429482685495372173326818893646289757008674753758860465244922365484215329043013694653249383965600156071526093224196543564395256619974579165365709216420397501003922915691506013990491427372931318956493080999e+29), SC_(6.72835261508627487441809388914618718039806766838076765738449388127304650638500226155393279449547157554874214601262165687120232963516589317117744273330309623400314525833549943284641956342219602925993192470847874648719472012633435814459477730435577468888682456785797630097073380249832077254791664762750315685378649126380990575187276250739357550980693771790622800409807477947479455730830600697505092486997466317766437101841783321172164072094610651193846740792964214770153922331926924938123871030133738925e+01)},
                                                                                          {SC_(1.15805324961653822428570241697281798757994191687720197947442102304194122552871704101562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-29), SC_(8.63518150250108277194016891306233647484350850467664211488828521671098276856027646738832798460638738889745235576927151073499175108377545838358386482265787302310436375999567002230935819513356910576887220572360144418394608202135272298033654003052182297572299115574956232437725263892943148991293370552472446011183244210703600281122859489582978101451793967074375924992378742386032880290147673310487052110730167491270221379145909984226467052326276061760313245928809376103054222364829784917100855808316020815e+28), SC_(6.66282273346089416734535625179362666621182077643990467879063832625680227791050206585733185502957596233314540660483901760430911805270185678987126994680068402992221525616904588488441229909153800950377006070324398572799927651884646302955793101599665239041508783676953386426252223745918060631306977940834262621283653711331967519129060500243592868823804992668473953470906948420875648942763002156556099370463527314476558063517916220321125974741423139110495117826462394235672451732466307699999303905633370100e+01)},
                                                                                          {SC_(1.42245694944417038241730866879301796566459337427951181709318007051479071378707885742187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-29), SC_(7.03008973586689712434453706188967052189544377452251027190548933242786882782597583872281928283881475602762471967697312305884958111647827996819565671460034196076646349776435256364489761767965592316774008837231548263375054937427862888061428112304485964913506427137973546426799224557859735091281967123454997149655374130493654203587146086260828222294410435287918229997913562020320493066804583330730837073698808542435953750233088861767005232084367280435329039878489987209426255343649661690999646366391423086e+28), SC_(6.64225820742780683535257712261924121209227913749076443473890372060519527816598227736042607832909087984911015926106929130360483186660465408894557878927354666930836674850262877191875658008191764865453073508984311388701881734517396030408218265504769496117527926393550877643119833107884441914845938545843378909648403549025956978676004449802550052939417816321088510807702282974630203123683236264607529541476291560195226774671285268000217027114645279781317099602573341146438849056594216426188392209461223262e+01)},
                                                                                          {SC_(4.97012101832753915362870547787643979509599986062878818060539742873515933752059936523437500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-29), SC_(2.01202344231147724230810353716656887566130414385907540860402251559475890073645391277780480020189554969458171902799377776861135178157011979373269790864340211440027520775401007836782123067346497601513358857239897301150526329963708751115670484000483500722297344616098324545158500747555859233886573924190763930230809498621227122379869747916191366861272145295954082819043984946331634617739137084318984472461083170724165845505521971897573240355846211686074477671195963638013441293957127903234462875211715646e+28), SC_(6.51715235072511457864378388754998157435356973715673258412791513444778374479836727125230109590192077325601920795178505423399615183618242933697838040985779154418085424257031245674733493517221878558879698506150447439006049190511649430013973295257187798595008470757450564951138158522942211934575884784926138442646487836912254893171857625559424638068958366192061382628054238930763500818744359069789679612002531155109612303921215254254747694195676813610575246106335880547522974750286496268913709809509252474e+01)},
                                                                                          {SC_(9.66007941505749759175817416441747844432341024711874410968448501080274581909179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-29), SC_(1.03518817706743243919823284998017787128647257621455912634163869070166059872671230538431901891097497439179354992612162157669426027906636292231895643723927703757223460655854516477901321769519052303126616273995428548985832279710011127934672239520409848031206199996350739655807535213912727774552045467776829721969059974045525292499046126524249705366001360881203124736372820107025125261106918354118101667092609216938740138156696613533257159162712186798710277184296626585528266265769960723307483161365376229e+28), SC_(6.45069658276162457259303572398885329683158361494024827181717336146058546986400295243949312741758251226140035714229464147482260893374857925924565517856610305565502975329832388352253205506611318819270307820107725007303695608214479732517695140757758354226761553744330994156337100540242975402121772398848516182993789845650062348186821501621405335217798478394612071716443631914367377297227176427909617300917373609884768866750477406306294818746619910517952227127526727803071073422415549147408253665298301300e+01)},
                                                                                          {SC_(1.23292931325318213137633109542739196875415141549381381480543495854362845420837402343750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-28), SC_(8.11076506374416877382537129208031545752074797419842750844528587451643362386982055323101915507674024859960406340146989444652626245160911354305121401560514918118286169465374662239310666900739378375958129364148653331105246827262534402832707407165597662287434176607244865340061287749891730809236349890319758864866554723496495254063628105477907236700688483571320960538771287714513893495299885765536699744850957588500735883090986629317497556750278199990341833620560130060637909786621313289257460639001650831e+27), SC_(6.42629897103672909988458723024910870404416821898215222127400022516539410704531383405982899412381871048426582739992646976069868034841151137810871632844074572909965313276374324555176087210170807432149288863515134794938111522097235775211996947623050218416749855639680453817148045797399149820883035794559402140834591578682886608367287283427546427869980860693429982414804171599334229599589490584031942607532254985111818673092821904070864890840147766974757375588542457697599486106018224639916097437571599819e+01)},
                                                                                          {SC_(3.29652280413527321597289728537034730709403803142198974285292933927848935127258300781250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-28), SC_(3.03349941564355360012064150184228595706904820067783154892030109296391762822472881195726613182210189442955174212546738337284886561017336690039432370715941439412719089329892531356865265081975064636232370994677816511211572902921257370348330352994628809490300819077932611462301055106584074350770615111880273573943059035962668811432859854690471774370491309454815309809006764621402491823519351139477097886747251831199460054088808790491284984413259166462592982630156453579922162794986104508307975648736654540e+27), SC_(6.32795143866050323716760133418296904749863732946975200928947118578322607994583477068450164307701602413609648444048639207929029056223035086133893270694677420843751377393407833586002432242261752314708430347057295480453578837209532569699006883030625680960140262219134646858202581750831824382271631031980228590555215920432590868320228606184600039560993755754788437087523337075244902961115198620434131953515679906038170612236824559118585723278727600502113865815188191107710031491713156376132212151995325781e+01)},
                                                                                          {SC_(5.28364435768055252017009628713605422886039151425530135952612909022718667984008789062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-28), SC_(1.89263306215217388065301450837422131624429762500909613738277870523089267798630746568964190871771157247405784615737404532079180608133788878517212154426651108760035114597438980870405792535468966738754609913368846304859794971254949645193988742238635877174034183157545953026521100953857513511469947369943288857923008731164449119832620087394383402735741445779931513137986706278546522549426676715586900797211295600476831080380451856593421444600033324608401914174483790915085395318359941917879811363209587464e+27), SC_(6.28077665249491897691049827940636540970398543994861233169099871356964217589347125478155697980887940866179062958974044155963995941441194575820156444577833257789890482265650964581797191647152323111036866463941206128044651251402305746085176458414290497006593109264627423072684766714099596688313036477988560744962758440194036696643717238708853234985639383334272562979038431089236482058749177876773587848544135873987589282606791220573117136189470910455726053001892397518963850274607542910338241721343457177e+01)},
                                                                                          {SC_(8.86586057273120049620324386849842094685003081322438589495504857040941715240478515625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-28), SC_(1.12792209148394250283821637021946106530198113703610911095488337733749683357735288766824599638075655918840636782440721083365515523554739468482924768722301671735596891690745164252007005619188503105228533256226946150583868513360183143203542320141069898108879458118152610755855595193019270900648744728405474759634285607695917755572614881162868983190243597181686385780385043194947192656483297254721171554847487312358317557282161067168244426453811265351416570323053082026986937719013776178742039427104942286e+27), SC_(6.22901745936964236807423188366699491237395082581362863038475204196764335339422677682424533021060737567932462267191280241127353523262734638192900266136858588339878538342860483208191254394637373839754873788419222515574108790388057884237928241734260216993505146375338473328907938233508277422196718935311128911439714419720575361379606654030425058941565427488999592176540230675586731103811757799195001504320404652187910673241283381657595695105566385412255027821045966205549848464433924669316746507256885131e+01)},
                                                                                          {SC_(2.49966909705205994304740110602803937055616662066270805553358513861894607543945312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-27), SC_(4.00052951480390792753792297612547756446636308354112378451456968304268692528633775519125653540337556139742594352743621941853552757231088824292247450739114201180697920406873694369842101729381223009665109087920683089903813373384379869972135737762953748899884850561862020898979033509177864717063968439364396918776475551700928193992691475593786044265808700917232151033008792097742668057139762411818451641133325103860432283894810997209741497147809418396090524305457199005071908197450896512609552069520382170e+26), SC_(6.12536391489047683456791920395172307654373024181199187144911145425432965478592302886538061658534635912284286031438597728058141651972777704999971671030797848009724431879789343164823041816910201631030249867326068929534579895965669649438343390853080251794078983618181753609923762928472591231131609267962196214873011951877052947425588001178855301901711271913497699503029013954248204210958479220752097373121722687614004482162043568710684966204871567240274381394573742635156718926230757319557118639628439420e+01)},
                                                                                          {SC_(4.13105039723262296431436267163873604088076066376267192481464007869362831115722656250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-27), SC_(2.42069184309612078735610309396289531456075006005701452319232308780898469481899786562711660638975498443576891437412380505348319376012700732093473068914701828605341797891307189106243524744582901965865091960195620144901563293848963647400347796236403212162016330881728652090676262972985324378411000114398851717735569482703793791472186452067039116212437053446977932154280424530245898016181405959157039069608327504217006545118390787849039405560427420843900632344217146363244036322483055152244720350520312732e+26), SC_(6.07512658027331975479577088722915968953877892639195256368947344929252315379014575284754474798075879668931747060129256164633934573369599205358256458706635358062235593480105093770678843815652602539307431543115040519794608689731244425228894620530188188065811225372150482460249371284136442858221115772490874167846093958384149302455707825340823690871444826129737661538243254629158931922087992517687225059329004092487025701375624298827988692231490866885497114885255366053276979415146569639295467508175390497e+01)},
                                                                                          {SC_(7.67973655713747804159297628821628769124011532065665619484207127243280410766601562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-27), SC_(1.30212799952181823165140121882528410353551267300487990139386626525325211291024568030230970848519462523321250316113910391542233495172804953518059438162757195427412584355171613764849732449793589808648756002181462999052595392577807540209762006753250735181780410531193269824922742158457533297763018004418385433117806616100977526675610500618779766320207731845672476138902627160544984413741977497354820351022582824220122963569820651479542153114314134607530615386140027703759180101932525568349064975126058165e+26), SC_(6.01312122667240529166843994063021266541288260960290414568544325404195544575095829794041035120469854123574649673981547316854462290304396763545774453073567613797603142297644704020352034632426024680109753030361110840049738676836013357598960559784241302812865391854524389664056261621870677748278809719438623073587488273527342019260350532258454443364272867066135071843918273298351325211729169344200131324037636430369715829612165506521055551942816236666920875284797438923786575101586645401435561328322074817e+01)},
                                                                                          {SC_(1.99929709006070097053663358872093457378141950764316447930468712002038955688476562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-26), SC_(5.00175789266836197992253524274830985249917406243586481928958356437141598411984138722862492208659648540426313645171261046500070366734305739654716860293908480183345282315525066342879659673808912526681216851816527758086674670902923821816912492981456459220446807092272059870287398917856957814911955087942529906020699544749520437288684229226072743323074045476154958594811061595567355441543116054826269870495160775013279838715048442052026193416237173077956430343800236803747119123474588037106300229115319493e+25), SC_(5.91744167540296642932633105438455466640616516641281944106250379983760813618537924832488310046560748278519239110324535565544143210026284763893696541922381258765648942880722642974790705056266372562023064784175361677559270801762988065916285030771581562373334272877335535222265668349615364410562602776765986836342337156864942547577113767363493593568061040388382331590689156231846893431183969526225066656037250767253219801811525307324434690649574834704255754342306560284967752740251238298561968659075731801e+01)},
                                                                                          {SC_(5.15147741524697845975412980082616359162571428864652034462778829038143157958984375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-26), SC_(1.94119069034500808603652466533066021838567012298869439701340945032173827546064073709628358298435505063869761045803662384531648487567393382773594440075435175724183604412243156694194932492028878970941961283821446471330266254909674918925098980942551328647919533502012637100674140444753442826674029392350808309173674621706803567435055313380241398358750606063235436398329157810706396769069082270097287993911924029918948917243632827735362569726563281278358132173640383259378355790298494643627193841009125610e+25), SC_(5.82279288675638227521744581984472667501463857487542260681762460523386320409989607920181437766464159215936294441689087772286732842238926045596412700160862731390874584038617859265714534550615456175097106413483539149755980595702034247039218440752863612649821537138773308438672246983171497554091758620898857991717016801958594108321529888222047270727588727745793441847528628771717744394905353164071527110746942189167167910378796313989630478491619937958186173400443704421577577652506214296565647827659664193e+01)},
                                                                                          {SC_(1.01200722207604382263949018037021122481435020379336719997809268534183502197265625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-25), SC_(9.88135240723468294587520823096149819619540476689712710623997817993083189475816383577084956312949922972156866572877356452911798009387999009526605954163888106149571728467821461881641485221579135727239840228161933168563012454259847186432292992881836215442485054048489450902048271065397568687760395141387333368815582691028472081451393202540812412060789893208592124641855931693833129410253652436457888009028232812205367434613971048802458771917161720241635834784826416484240215260071905616525517892376198493e+24), SC_(5.75526916175725540760017008791674277403750658183657019667573395043965482862223161211434510621020178646998074509782225975726388192488504530392658732934512207024506529591122416739406187792824292457201619483969139331538455509702323358241424076304580592500270106222576434714589313899240402996303681999603577990188285524562004708292069045649249373724332501528425003869718292101485821916461949819884935827385813682080426761085178755516591092075170285475651907581965934227857501471685138069598110050036387246e+01)},
                                                                                          {SC_(2.06429269589654098179854645662305491103302723665535722830099985003471374511718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-25), SC_(4.84427427364262875842177793582518195279767597643060376319794648994297827081054097195940382072797039218621065892526441246106534412586907979155363395093623504721783967370117346993663134634720015066493921311731770109109810916776708584865494093815063529130112517199074056968525199230121554514145114301260244921843558589363080736372954820248471209753932824991565235931747363147022272578757977659537120808256136053752131562400463651066011428784940346704179494919962842998228211078697496029314646389388898709e+24), SC_(5.68398396772585233454081243163015719457273127694317564671579909124104470082415630897415329078724340316758032857229084552171453692626527967609074784678664906070359314921191268418039853212010471717205985371362797477808024589535717680159846557085388955229865201914116328556336605417711822202289369410146331697923086998315821256230168984504108244541247998403612502502907727077479891826525225618196587293524636550350625327996139236466781075913080290453906357687119354962653760957324187035168960795482516167e+01)},
                                                                                          {SC_(4.06329433289633339525743443387977341628436445120087228133343160152435302734375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-25), SC_(2.46105725569527169415983887680710324054112250788475703843400058327137510398066264739078011647200558087326350808351871985106152690049359086642413238317408836089468987877838079876187296081669103803784535166355608455966760897587389088115522647388304688901396509685347705021509288980827182717349153930357355160998461433103157942190593059970182220422601313102141445390082271181048288342624754879410555438595064913555566952651043246646544339420386855070326440604309211163343582298939299136028028873165480769e+24), SC_(5.61626332682108543103894914638265205739494039591792063561869770530274312850585567765343945280850219080051628164852842207643000297697060102013357499398606383713775784855806022728186354069091978795877261624547818135305576719244903321101517119309704129792662326041351319265014075608624116830962662681594177248456643562788865593950429324530694066762617857478074607527695679287002457200156179042326635089136412749258440888089649819236202364351423255552506804629320072380909487742338753291737755545443775797e+01)},
                                                                                          {SC_(8.13819478186073092670198892427626982497279595207828606362454593181610107421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-25), SC_(1.22877373521325115162328151196138471976141512712124850581584744704992399909168261635541263516328487781554443968352277192925529436530024421006633112093621416957359244265549900396322231619231727354042398710426402533917291689560431212331314867942163998562472153269908152702292325979049258401011838074535270886141399120216251602299571716343713366066427282233107466768238863223341638688213559918551782217436488107168907078748350405159172588636795924752838173975951774548164437216663669472739716812900706291e+24), SC_(5.54680589407017581449312663260900718532236752643429778887916074462724851849598244854808478563726062042713449609513298516922138485589080042918533500047818941095475305997544950753739499731683843803755248795132093107433712169375661072287744142881205356719090133730530388524199409758849195774801927230016968519619337069603229936339950959945894614972178336489693903099001770377373594374895517334732896865347661491160409693023609464135192154062110190404782725103313309390020123729907971058891945976423107090e+01)},
                                                                                          {SC_(9.57554865497999074939999660325683650957673265224912029225379228591918945312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-25), SC_(1.04432658224751051534314719319653764492076403254903353940705501087203904226108528788809371267534452777143739782207618775861320582874754248864333937039501094101917228222578478024350733644382871829557399595988827405718915208248754996663898673158999141554101618210328270114242596449908503778350906723150268970162028603276526593042556952793500072272667839653724623032562627561836490475514812167562140191244558846393493937542533932600626398969074932846968713462462457715092757436435680895751950017915638130e+24), SC_(5.53054144906448593874035705960252565327725371930035233374475045868754601997131177506417834643641068577542592682508927413603952599228162183490902725675527826513870330578615340807530339380960658869221743008220977723760935754238139593711178583463897078717435139016330627214829940443565604990205981580028836645095112579577358064065119684256270078779601982060604318757793537509382142428577689380707350625620009954407756292439931086645123086101261977511377525026818121340639711064353707057249378932596923274e+01)},
                                                                                          {SC_(2.85516056186804819386971813584199120922280101808610197622328996658325195312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-24), SC_(3.50242999765214323664192679073178441988316976402121689738366828010343200142127297877801696998138244162201391895289627133288966388269820082791501666523174699265748272305684918310912716715770179390342333881476222257119067917382383828097056575473305941584001441668576626536239604665841289353700793779427804962841854234138298713674382597487122053790601814569968031027493158660860778248283756870286152743158063320918616278309751952166743130766591170707371648727380827196137739711391014068466505661904440217e+23), SC_(5.42129141514975251800903561369021896767530710266420752809382078867957345755941405132689457634465145272252196685234760413494992978952209599519173817340434015117011005940702842923245114745048817216891242529483752482359028631069418216006995563505772451582472582577624264823737226327430602918404820892619934026026679795159577460335018994519482732498954471793682959200041271002531143558773649050588603615579031798187421758140576055031223887773975801539821645805264411679468976240805660854787612427720085525e+01)},
                                                                                          {SC_(6.52014364093064091884456528840346284381368491267494391649961471557617187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-24), SC_(1.53370854243521973586893102813914310939965427847284394727942326816923530158483359322277635535490460600254860546777471016072796682814782921636329959096588533379368302049694060279320304899005746782369004567388608876800597722684498185816580726353948738996684213751763514979183260672977613294821391044699592421424071378526056882956988747680636997296772179269782489944802968406726338812277631440999738435783684003696158536718815313665608295411332733865266716369836200650975268023336258804965762457776544875e+23), SC_(5.33871458253436267660312480785009601729216078741234807903756510475077269603543815841324029033223878574917502908041974473136581597194818255013348773687457538072821039582681999557815447099340143448346969967803777016864105080422428146552078395204345173179644042513512657540372581522428813903397886613502554964587865832987725841749146742934838411775381167966256392170311556144245615596487835602499722904753756187542702952227808014818824336277067590912165157720497569824343819810963150406333187486453320164e+01)},
                                                                                          {SC_(1.31098837463635003832097749177504342199540587898809462785720825195312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-23), SC_(7.62783270505648920867640128917029682085014404223298750921210449188883287957637267346963792923947398577101641982313673140522903767065871959681776941420786346990663932279594126922699186822003592857543574397975415727821273939141093361267052683898474890607767272618049135227041257172444582130532397303361510817394714073504522661387391945133312715542154642780804313417668739292346961368873149467702801677937149054720393235576921825090293378239947540846276937347389762949029484045230989398597611258299015322e+22), SC_(5.26886758016750764532724250391453133579168931661122683861881724102784766335119510458343279795727755360417828961523650183250788076928558998266697318508102942356639306550934079657348019990471331356616671440992693851502497540967879695178087358316196135449214724222581033520195801247039827371115321875006799826166266808354064309683485881431194829649247848425203894402917390733452728328994293143443163498889486622254544214583416155521738672267888911298790423121376809223944061169250554139218709440516067540e+01)},
                                                                                          {SC_(2.59028852225433412082328801177410343425933092476043384522199630737304687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-23), SC_(3.86057379866586319878799465520462508773374309731222147451540412289649626604311610271505156892543734630828629717871661915627739337921111016296975526068036546011996321933999439105025263806297456366301563262085095498328808608921907606929694250705204329001618943812913711507301443230672701441796481501946959406058733878796305518832400784536950370251240917339676666211604312502114193270809313318899693038913600801258981405147278842314317813074821654637246696524927484395930153180957204116226311041051575070e+22), SC_(5.20076878708021655204184517590029484781779325945365320134692951662097251746010442303228973955429295220624205734359293984540010475530401054700767967040031802383111862364495871155708008415805050150046955904324684920911708716591437325331213161883361059635649619622139582737775763756910681490313609300987084497727073273136118042184330561290773528921435330943144151579989347270239667075286213199707738173963359766442692057049676746685889195318181733518343155600767669257087994297941841427762786592820580199e+01)},
                                                                                          {SC_(2.93777859556056893705993279786690963728545966660021804273128509521484375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-23), SC_(3.40393248664535973451643561545599015646480163251746595187335545294157661290070259654556490228897046833198768473283011025314766585326825660311638945820356275028504108010061473219261760927138383081243874282257741552861246265341571115130840175610661210996672096930564509064007280059700812172651108467231185451280522308365237196553586846212890788781209593678169565625983002898914954626594158457302304321444438490738130358193686145378731322940962556530139169746200404495578798523354146116661641285345779468e+22), SC_(5.18818034228480048495984841998696565418571058823007515216304504326186316117799223812592599800053866943330882932209733319774993987429860654967791070950192182720563465084761871021801510083705614519767136322047619989872914050805017533441004404032584098212597431832228764483076722028111823178273253323659440621758510792485130604460981055521765707306470062276856877280447173587180991702485468042648886026757392434693933943855302891392288442139215967429109453656283435937137806905507213701777697785708916602e+01)},
                                                                                          {SC_(7.86351191582705469613519475556052962250674909228109754621982574462890625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-23), SC_(1.27169642610610039353264616927599175234779914344881805733869580633167446969597085449508303449649856295673996772851928970484478455725869106340434214033522429436281717957271664490947874357052247959982209769067209733807145329602247519581626721334004570445050566096313562487889013608558003318113736293222661115116237175842533338824845777635499715409458146778160438857783694339290802398515134559787128147139201279684177329341813791723791645732119236379285735920408460318017210905600269751682346961660174051e+22), SC_(5.08972238235817915756710145375177450823509597274772735688967008797016311927179066425401316234841495457645680749356303387011726052153995399350107102311415173522242349706194436150181002293398019846980279232678924816759224648575930356637357223960768881058525455547490594553426412812113145828448959563668690340567112115668860640488282014428626692311646693602244887490659454290033238900625854342402063608843879097706509412062070869795895634470749766615375813006168918399107358410251103233338070834608171218e+01)},
                                                                                          {SC_(1.90381848086964392834489130147419128080699124438979197293519973754882812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-22), SC_(5.25260160066946451216401888059962516778732901049570780683024351572719151667787646855463099146585407964053825766930472772728698256660716949502801050859969127596546505976843647978026708358679238991719723994756553212701512367961114046483288579383813550637161150736903854808004565774707190980542096793989969411975096086259679433124457082433968122358310884166563878035988158013841190648076433223713075923687946218147161294236941276929535940783322870621803800934875095257103638684763412873109654240236089051e+21), SC_(5.00130104497222740728056396948021842053725671133632273915590421086540995885813788156178684793591659855727077330324357543560582420708812233670466083001362821798690316015631303321842998721923280159860116612739436828240078595075021023635482180195173811443143861016540316132682754359770001807411742030056445805013793074054109764814553533227232453792365752365826883614935008145498752931608573064596345947693694716816510723270897599891592664901791763900806485055510666392856983244898302151747117597853439027e+01)},
                                                                                          {SC_(3.81224138507088185839560978023822512827933906010002829134464263916015625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-22), SC_(2.62312875547728931624265607213756815229837180169602095107327334620073176917117693941741379801758213948691714295468078460965756685506546144383314549488869924636549335223264787835030053818578531165584930072928904954024349836757669531292599781334847779073929930462134987001491872682250658594585821377388524745624403856725561382616752243818539754229843502888914770520037420032497262912077979169509544962261229110346059316603824642058929794962625900432712959225107275250144027312303800204614559719130614088e+21), SC_(4.93186547396602967807569716447834137730489798578208909181956823619940195091783373690286003795378305170062448815938262002666855919185740745808868834518988746793180050929189726528174841883797281208589583375771652408457949764152811572462780673549541833300927262733221435417215931929623799861721052593168258224331928041117341615950018916874018539855668865299897540452645987293103073809492246918894060636522018825311579944256307429299926433463157773358234415239424681932122613637285458521080913054880393190e+01)},
                                                                                          {SC_(5.49313358014133027717803441948574150188733256072737276554107666015625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-22), SC_(1.82045454640895782737597987629015253196424399819770711984867168537754339866104500301965169548440597151564783591998096204750642251097138511714139431677230119316032123096723638435315702956082607856781221770795262706437219993962584257438868249993742164284339577414043879202101786168615719873186715666650725127913925044433708513784715492777075613064868451994980205253786155564432613892877191420027887520647436384687185562679132018990435662701316643628299136576381271167422303030261887730404064469821661616e+21), SC_(4.89533731735552832041589301430161251020130076163841042575523208601949953816095170371768447691586445244814754879873655432782452790720310931894083872122785341863455879689084514113729905769521595789846313097484306889731804610702066651582493944283543411813419736212048892954255421551910526337589242688284096162070571743478755325100547875689720992357527643607016139503743185301042251704701530808508066708422044540174423444837331714045278436889408090514469447622243967937763842767800209868922707391107115056e+01)},
                                                                                          {SC_(9.67215262454222827277166131629965173388541188614908605813980102539062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-22), SC_(1.03389600931501929871097748597108012503603240764947686389435163117375649258678792903056071607754243833593207370623936419856377159806444481248117223998829490194577017841692422535813595410446015676576831805051126599707021576420891181154412175525551678059867804876476222326414755412781154745397066502491812883871947516897588521853430063495325076052198574002590913096133461052863926525420514129463693265405456836877870291872408610362015129227970482483273273845790259359266596054256231926761044565464033080e+21), SC_(4.83876211526414979604635716263705953424666129250468312064929767779865870430085106549754942840632302924184467393105280221031089458453346711488164184273691108029712931250317685626244951629221689589424633173262031509079949942052033836097273287253793763926645896482582399059720693766548808207758164347982593877689742387604381713327862363173160844314328159732166305198258012076073150997611295564230600179954076979830331378330132787416576665241470078232795284322184660642563132648624641834323472973518630605e+01)},
                                                                                          {SC_(1.70216887177863917482281209177935599186071158328559249639511108398437500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-21), SC_(5.87485775694555373167830190810947978074136007912954035211349619261705336638409363420065882452461996702314667318377905295556382085566956103363904724888053444999238638638047322550676699560353465463822389438155518513284160800035024841145198763981778295086704772143892266059585666296705036968955960094559165454125738827162309721849410190497768549790407976026865987343414380830766635337193966062235485294062197370443236409650307028525323119441263966385207051043615749087468096830868638236989811223697512846e+20), SC_(4.78223837080342956793684677947106154961522152824515734094452704401576955395734057320806187417084580015495705104032785915022776196524911035311341716253866023844008453954146289524334796068740032756280072158706992888389727754165739635731112302444977854489414440643254915015070323265306535814024253673397347468234679060454970156387012906763493040337094509367197022134455190670828956855467931764615143248858050259521769945653420149568573354187997851604834498374939753381150748940039401972150105022390568142e+01)},
                                                                                          {SC_(4.81711376218383283936066573301115756322587913018651306629180908203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-21), SC_(2.07593187408273119152469340787584993890199570636061024535034187514866784687246050811341044476827375433480122929541167222047975713155197480798124497902130577079489261717652034359642106356416547649168312264735412183148465876725562907070038342803242173535250774119973305228029222184206457390221388120526840827119402382489085565296916043218667855465146608182737262945596180604152319863495913770032065685967941222160843715367489927722217409213962422170874267170019204004892033424089148243078905283228037205e+20), SC_(4.67821120086936591155861343624377850408269305810050469109688472737615468051095256528958901042725900832184701847084075487537053023539942576971128033660153998945676607285872594089641174041605333823436914379532594652603569351790857962248245167080191475771720972177837880349399147575537558363282997470664643874116717082159563251158697158617110481785942129499655204492946736783592575692219959790344322588335340149192743106478058297032949955331719952339817796143077569677432793189592681892060865012873193475e+01)},
                                                                                          {SC_(7.53835218496289623698718975960963994964458834147080779075622558593750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-21), SC_(1.32654985527838137100932148001816998202531058674126548560649347649621723628346782156486921309260567626575505247724488705138662753142944879073548888865365873854899374953797004778789748638581143372102322151991790136819332204708988722277664693837174949456397321602470382326078211353728562381264101144823679289452835745057195794802022960930042459359943364735905222631946467121359896176823730763057059644290401154571759016166486610674803826665802666272410848457505223641701711941719977501447883034136159953e+20), SC_(4.63342833378474888230149349666744582083410493325092779782325990451750115439726645419432244279477421063064027863192770563073507505859141449350699461178579618829859155282280329464471157435721507507621366940722327450189318592513979948532139573299619587090909747514578389070859627428039581931779660251967891631196240115897628890456050781081363826940234999078862646972605461455399964225335297811563651185144751675814309192435649749296000702432933328264772882595395455332123984715360567248273515423621218181e+01)},
                                                                                          {SC_(2.59630539283257292986818211277810775072794058360159397125244140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-20), SC_(3.85162701876530232468016912812562115373016774249503275226081603451011972263884092116338217726073095315378831950037360909099536077599495060933119624377088198449654129198262640605955970599568081504230936190952678753636882742353834162910291504268867570124117933635673759417794194750694611151724251936494514678735433147379446557816715174471231316403411149395136087982745338487971867500234281286818420446085777843840510364259879208876519674749555766856827657168205200716024970765971906489858958552410340209e+19), SC_(4.50976124281920705382894731131297213130572717493742609284798877986990697571350693999371678487948632519864994037977278991511171422997687213322493057461733626999725433941144937352468234189905071478290922464427713382759016633848292380102094051047990921816293731510106932513291229018355894945898305007359239076376113280775919897826671201334146282266277827196326947730939522373694958320901000146985783812074526877946883639947205073390942506470008867088564871610508691951675410364770185985961728739523981618e+01)},
                                                                                          {SC_(4.44458748032432159103292338558910401502544118557125329971313476562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-20), SC_(2.24992759041617511461621764486439635331268181524943714185422655502011940305830955842049995629795499038379372105174122525659372487742336448447414773844185770557560669635298671132635822489541669693773055967965532505432053161714602453342903646974643879994358520105467411119547515122875898507996505993250138824454260200092114888103323809959405846895518855899975499562260312288474932728168479107206688794805002289162783128162902120231213764618237747182467147917636833518130802203155531015258002908630659505e+19), SC_(4.45600148005480883843221099327436102666507286396321419246469079708178654036796335564537748997950297615591540727977401329305621673590499008495012173174392772256892507453002392058153845853189319966166580698136193800825737803950908645504563702087417217271483342543855867136519298690260888636782412764723517798316454633414606328262091535579645033263025779535288322669191010012877722363484688404092994821819255479622047806371600580845074877980334211973902257995372110831043126958395107296424305717728039778e+01)},
                                                                                          {SC_(9.71557492149857393706909557129502985617364174686372280120849609375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-20), SC_(1.02927516701786239327088559412658766939139020160726492118279488473065998991185050649522612566598502492850845923928935444094096535636546140592813025897441044117222322919932658956040882346732304391680061902209382086302404668689151737674617016917845957206762618188322104946471590369266478660595098732069281192644117382544988957154567918982755878771131501810034492564665202549534237745127922812286537989714258529959375056247550200531755397160082332872499569497564890372601849391656798155826066504423590993e+19), SC_(4.37779716000584398698990777213961810795783081592017743708184220804927904372994901189967649515009735172880623955419740420012315986576189119126543575566904578046919431809875380432523353206754900523923781714480384673715724050123132008911344423077801177226414264244221939888532288642522215169036955971731289164143691078284671577290431144790881842027973573671404137841858557411863925709522264346872510355435006440809714471312012017359301321832215804656521781996390042520886865485354409134425576656515292926e+01)},
                                                                                          {SC_(2.03659828423951236444711457296286027940368512645363807678222656250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-19), SC_(4.91014849486338795473190760759441444466067332010736115448451018358708701249483729445665603792278275962824915533363252447208992321271997558403209359068593642512124051171201458814565348168725868138337357097501234373545916690198371201406334166588453088443536369069022785451336023963788649872427573525422434996888534953599038755123121918868508030352785585630353270762249702292785344287764591129078367625041276697406774722135731348618936205273074423355634920869234376105907879152417604078132666329384170075e+18), SC_(4.30378358585949627123043266249905967962887816014864580030065149334627360311264625084269369929010885338331708629099405372167695832844306064622709950330533203706114565842728252858428991981732670460958718014399250740467134868328348527925344194855324451370921408502953554014065116467018777966799168200158046526847454556567370263163616973309536526429423014979421181142030669729325491143297954511079372608224911716501489196081860212695795268550473745083593808696175606006373300488827315794661965705208608074e+01)},
                                                                                          {SC_(4.24897141467077741851980990372972257773653836920857429504394531250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-19), SC_(2.35351077333026230535011839474240622219483000391146763132183509793076592234927888232167018165059965341889704087890201558410868910455786613836598080957397030633632176587127990393846747320588225351631383496860587423029556133907670877877103353918512797316094631873557226661613318816657601526325447094347483360340956738001270992373069448262826936645820092382649354305920636802353742283580922610354426889294090123859577447266696482951980426047140310287263459070317723770875069575962886935550805237786695897e+18), SC_(4.23024398333195918158408107850347603783326689000823856751331542763754852295008148151040641858229359628078469346471651904183328738913698501012488411862344210217630892036531716673830832847274975771154382165559196133886158282803537992484348196540541778850787109396622290227802667263982437869403228137310193502583531468534595730634902358307597504479659454456104333192503021970905139088727531342322319258852396765871179050698860655091930182032950808135395012770057668306527411218055974698533878804694897876e+01)},
                                                                                          {SC_(6.52109697062557611797143503062912373025028500705957412719726562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-19), SC_(1.53348432710711382412002595519912645825566648563457431696666953405839323663436385415540577078371909268498986232218717729843902408307671822735810898376099999002890492643837786599645083719969138547771263335859855947307816324679806209991631345545056461506588633853780283094320592719021248371654162004605737603691227969348135209903536561923025330689942523293801939078260739547166454712431551868620292198550625950525062132279655944219731109300227921932835486424569827867231613062088487239727349654985918115e+18), SC_(4.18740741580717877834749717580480872663444883214839906712612229928671353630872016793683491013573267754990828537497837278806841156933537456470785351876763297827295195430920851033552990997091396033417305252831735464754273359090537968713199905598504642031010880493394683204614779223808652364642055436096918311854372211100470681108894123216199490765448486492648497952880318710041148392364754006599729496266016887671960468648728381863442366793411335781696166403861745903446537097238299743376393803857573148e+01)},
                                                                                          {SC_(1.43612616409619005828149362891110740747535601258277893066406250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-18), SC_(6.96317653003236534270279684056230493480974635294387864151869876012762532284596734951082527306944183471677369290174280413996466386927811922535961306689638808619571896542664757715749540445967495026030505751974090250891098156207641193344218297448568461129691361732130086054347427579303927112472352548506572728853835019753327122688017454392580665395920292338033791221187069780092498336554008503930308658152705336554580268216215995514521220060257848935007955158452333523773525415852441445066559674435759662e+17), SC_(4.10845823491203750269417544215072791519132546542332718178996273127574536831489212657835589746442090649387167240256729528753922301781366890181149045548306041011402050938687552735678160032267437349278570868601663400661323803208330594908106678976157884754069206007117314370496433949931110672961261612716138604168632915180563247416747360388044256592175912181596271822746593829008506529828578871060187771282714872573721122505387176962208757179811399463372209857716091891885223526650002477848497475476979043e+01)},
                                                                                          {SC_(3.11890848786895488590521774430186496829264797270298004150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-18), SC_(3.20624989123443732306466173906761681520397454797743411967171013836766623066090680547883575948261116875373758903768745835189573992875216085613141902692685511200847100457475304187579768628665984916839183891132515815084322285924840767805505007345562218865321739461777396150138788712581196262279033992571354092841083584810694368680835024576873243622929377079471785915486205112652151458409005461347986973352151531724888021213681531813870835307532278204228758832097427330025813162846791315218221029824619746e+17), SC_(4.03090485769127361541044518516749793558620098090648641127887094855827700200790074148846586717769702602507584916035694807696947856797493490000517122913319060871005295342371073736921330336059216945323871412710866077897955936403693279226005005938096644598230886353655584378890229552843787958464746461009779666997703222136831645152267985521755750444319743715297346010531544876992967622344263445129450448900510104730168827827208165554824488326702348994212535336245330092400863992833297810181409567228297843e+01)},
                                                                                          {SC_(3.59334537282425688607678804231682079262100160121917724609375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-18), SC_(2.78292203015829599261962546957895404990081417377702462561540550534248787923941627519770252374132972956048659251893293996353753189857684586454930049807693801282519389517382281037655102888634397511227508026612893186882009903794224845367685465254686600207247735925185218914216633415917812638411226987452749991767060400949519492513420696456926364234344734374551036206649868606958533670717760397382911283500570331443689754506095339881662222313057843468236763118633209815395160066394239858074758994028666204e+17), SC_(4.01674480465780156756373233991409013436821533054168506258895292628279818069729361806787595136076424384006316279954726598012824241067989855404179824808341722733810737973220122456049123599114093743744591167641745949850999579256815048452990723593892588637365211655957582808948217026490586121983724517543864781645178437196162666472151019598645107712434762601053469666360788143574729074809760313574145036322494425208379260483457212057388135008101922347976288102119321928476946075419079715204273847836843414e+01)},
                                                                                          {SC_(9.44587319976354210931956956187605101149529218673706054687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-18), SC_(1.05866337484292391877893553128199112698939570289224932065176817862141085135514836951586667720844659406770612439774968221124632789370844307001432545672057723464869417971709395799424259898055623912235791403741122929999123344770195973794864712554455288234558866684027599817096207096080284146412184004873522071048450897003367401937804000169854687400292647731549224669081176646068486188198521486876180228698061143311696077549270110157042874108852125353259990832498202645937700555218735068731041170828303378e+17), SC_(3.92009537262054234501302376900562352494457658036527151870180025479603504754753461578489644244060365462256407622755712594087048043074770735971508367302683895802466764533029159135853094442397091072625565603081572124195271332301215264596440920186443496183795483255217338464274566920054827464817577632394600445251335490560113043160121251415961773020418811680125283359994707443679440487631092951378592813529930845985123785509843786473207457924902332048362844352195749950987077358017799628118071730249025862e+01)},
                                                                                          {SC_(2.56618226665795902841776809921725543972570449113845825195312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-17), SC_(3.89683933597725175319881448875156329550959272329681834568395064472849695620233075370398121094999407832801079152543061082854904293375770342032999568194809723919167029207972483181872792071870253942805732212213696866676682551256652819376616818109748330084069432861352227832513280730680509108965375769828468563041117914052232128632742067003958206273566240057625865861463363448156974487157530828513033287570098452135060842470250942593681513427150841818546592619926264067908663369379108875730639326268033636e+16), SC_(3.82015272857946013868972828269190565241603203009525306048316289669090329472938769874388002268858503344601957377991550737380331618410528604493034595400009144511968159360478428151102928583235292537366903749091753601878616080067370420318789469929376398084229926120334276674083850290518652741873258037928908447880487108384710647297029037281429246371294923692866791630607779476698503708578625544511474622147702976005586821125679388687458018308507924009603884965657863077894756124074217763436492364278673196e+01)},
                                                                                          {SC_(3.36376503340485928823799799403104771045036613941192626953125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-17), SC_(2.97285925166949974807457128035170450066477816399282150074283633548132630228050480206101334146278178930908294908408020515338238795065654546119508961075437640461050424638007401351047794124504871288463863754584673855954961126297232599340503171861121561195226942325267400079715661257042576124244835504300757726324585566034800400383463784278686607598194278053396410834529186953102975415973744957865023871122361396135152717126955846865152882110803343610508752652208729776608990800704842038078247817331994336e+16), SC_(3.79308856886101391007069400688611715241306412481945391925641124503755302287114347811486474630031114965526460388140834253480812330063540612899960732864833037424012896192727400080411399823034435528040797825742848919090423377514889994050050630539014368288480412226524143513889592088827662068166527198378253824506638864160188289159987241034610535720713030553745641299836235130444127236622529535246872710565897403446713078126446643276414792539312938432098757656839684732673029434047131943526266196279957187e+01)},
                                                                                          {SC_(1.07358170281591559259981583096532631316222250461578369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-16), SC_(9.31461478317936154583885573605068314152782065589549609469914565023926800351906893630628413577057329177994311163956620701142336185063877418787239256892852873445087920365235403253490262027044753883469508398410847328265673193194742911647138928314816775890233439455542433156942108387193099894695833914145431402964584546919313488937598696841459038400110037727145266204533694824059513121510339268845269654240403127274651877792927116000049616797253148390354717608718094465314742868903581139626551889300905460e+15), SC_(3.67703610436463545495026752764732073257799710462679383878926040687745483770759737595879677884882603573698864133418997486425012617679062865326383978427075714145698038560113831222027110705069239786335016603569169352428328537042962202684139397465453620032063627325258874434348407817356371726695939425687202245573310859195697100566991928320499898224427193219018938684548326483374310145227660772699544688722421474069378038779652620437195668034097533124429018646466024438627728567972649112787843740899791573e+01)},
                                                                                          {SC_(1.86668379762073861211080227917591400910168886184692382812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-16), SC_(5.35709369350391592768923477986863641641041386670021657907817556703006517389988705389283232109982968543641719672782632683446951123770688487043526051583297000240895361108843806299619059970226545428273207896350988541869699991627107327834801493033331216553070688928465855987579410298857315865277432779893119738942981339000319483447360246902762847090996239733181691824983861438010137642268593931536986215723688557791478609307628514091675490387977196067334917940938095685385256768892170730058270859880636462e+15), SC_(3.62171980015770238529644276256304909762841122755715670454530535932119577983920286373688488828352754734406931597030396464476356557398010697414611460815730595598795724461987357764438028481679345185347219185863071734495762170385287950687445842789959555195963125019478348258106691677467080954410031938373216500393153641016722276609946656713555540444591568662264332738289295169018430812414467670389834383152578763719731976746966496898676584798648716600235148412802550386858248891110592564164992629404214083e+01)},
                                                                                          {SC_(3.72754000856436763788881449954715208150446414947509765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-16), SC_(2.68273445141408911283723006239656257697803268441537091833578995823631479637870109372542433045823942500493538309772882061158620811239346747126416414725632220522897904212689367685374427993307715937071521329955922919964121115209128646024026140952716125111524982773348304152867310039303794124441877617403751368109200025144399966053076218345391645919809571229742549148501577352386134954357696287153144345459858333574657639646117466158790728579741367905998417341437163124394832747783463050305056098538914629e+15), SC_(3.55256129869549746469129190589446112611374971235422325441661743173441106581270111685559740007254639646094495493656624168305177527459509052071035691146800720852814665759057328973021867643432657506024722624096544711014523774399719873932689274731995051138325881077303537458836774065049783694018259907349665329693554519542391840301112676185833713188657051332369184515962004392542293913181461136174541586330573388317276739077974633782704129881107851360100845571979416524943258965369577672126496148058574581e+01)},
                                                                                          {SC_(6.21164623847126305677956992212784825824201107025146484375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-16), SC_(1.60987918759215724473296955164050711825489618287045866202801823414693239227582877689612642201828742154418687355121973966292505959901391806799139653809838745188340881684515162988792007848468674612998319858187092531693899932814139414825926557323551114672169822158423992839458703436196401791797911936673436838394240815852947047828174796753313307757136143684480285017719542768808602568057397749873573409112484432828327014784464583830481102656394268086123846746418699465072883104433293290933010401885509252e+15), SC_(3.50149355323288728364329861732880324176031638041336862139807052588032519007018091239566004053112678380594715791614694015553568082314922840573501903934526205826219301106252291108123590770428192799388536288175283950076110976661476116388877098281744244826032674245791119891143171701318333066266192173031544331503256176982628055047348808467609466555103556740155332807731035093879658546200419663988682878676527720256158920797662450751878684463077317141864229153842444817407043542613272320106476743924054420e+01)},
                                                                                          {SC_(1.56118675387513505814496284074266441166400909423828125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-15), SC_(6.40538358090616930572199615451805628548811466548124866767301580454193836914688527258945904249400930128393597483821093345931465125659040391786350941651021513731158934861793952123651760083410251936794620985570172329548344492841407057052025958565132036658866728905612768400532182293158835054332981413662202889397861806043910747692211323788804394256779409295771295572821408075298471507736651155422104110473872767486593110874188436686541654282655355161458124621196612875076129336425440541282095043450040255e+14), SC_(3.40933301232014391150868421636533958473440302585740860260848018138238167947147035645125756954671750855391887535317009444065956767921064677968618219945959053639513910191608207857335901642663150813785332414376802057893921745648267995098117737459621623133122851171303514865520860577135966638142992592890484973123904068963085394166183181897269113986078489578835681632904743027489067147409257807141797115092583680460450147123180586018335936955745723770866230963621347586888357455203043177396972833240851176e+01)},
                                                                                          {SC_(3.09201076472299246633568259312596637755632400512695312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-15), SC_(3.23414139242036684276083130604740555332102742732209059379463888241652420546423273086068775293720523823200670849046209509059992046513896037709874652313295779648822248664308086223556376242106158616999836997344265976872160860155284371645823226486628544951807381517275685383124474248733832833490965510634823019355780090367489336590037228205353144842183317855983909606680484114170019756574079014702848036194935144988337541633047521822526159654693197431239667075331189787015556708335276605238049315835810949e+14), SC_(3.34099547827158268511113993446903871609732924567423972328264466707266472778778891404558763137098605651259421135963813833515578889335972791280638276638644224502835075692963388704588416382084250235467716489647590712743538560386421899270208473311755340209188808173381086345830251825944994715547816456415714427114514915312552192521665876486824893423925556696142108780583640085356427710300777015891910118866224225325727148526583301327987132946111378409333344173151219474323631718818017607572968466884244881e+01)},
                                                                                          {SC_(6.19284930682226925080513524335401598364114761352539062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-15), SC_(1.61476559569818671077849756616782395312094395613347467750921722608840205796460277758977185598066368612152647586355409621867085587660898402276437610012628993258471020827684469653607635220589425130797599931290173046110225841248699388265771294084712117371892010203190259471067461983539407831393871011826817832470708029300694095843415136560615706146315580504139342457709693423001976894072748271524278429319146224988993773668626131510931741784139122901762820252013439990701483599226194926428639331692995557e+14), SC_(3.27153811060745956545208526189697911818865513720855207755872098602864684374322696355123670952633924436258610666907170222209394190047290120323927472415081513666370900738289979879690186626743145600004271927253949261836286290740269610628605968254208476768024418971702204779288095032341257084062060344264304671198009573892376055095018771428144517163652189210316706374200046878577151824403617693596267098982951994663722671034852406566911866665007273958508147641802996795125455444652177198364896323298304893e+01)},
                                                                                          {SC_(1.04787902801498772342725374073779676109552383422851562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-14), SC_(9.54308630352406516205359046743618128166013090307817797340778789274961654822225673440177258174542900560867351268330833966280245668620838918829357035489275755644143090680060808839976435761676367940523185523095340333253908768554277364428691654262043043572182784073217355994150549491589487440011307430494117507959296987864631992522761541545646638217243232172299176577840404366061062966572185707442372468239516417574982507870328724871909524033211780972857372209413324807897530256218888609923492076544192109e+13), SC_(3.21894231539638950907826379599187842092021268441575923627069258871771854433853115415782489861480221176798825589829782195888976062477106413518596068053420790907345073056114458972152822792634568125668736336221600151997074169590195016728096593357645536460894160204159094589833050074995328566868137793424194031239361538971519366809470194032401330140171321878243915169056979387038234600397250254904913143463342791005518801681322155705188385276179554739337515081187784957575036642842343229436475007253920317e+01)},
                                                                                          {SC_(1.97847313076864039782520876542548649013042449951171875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-14), SC_(5.05440273334157824610291274505331299112537682918356644294065782874967080760819218369358842344722889119059120852563533630957034017900977677765645163762768638444925755118980175905552516718603988596151136262505942788287639943511325025291684945629253287336400993651018048078421763736114277036323128197654243217402405771923455474402297884519301843406468653715197789031889941921922213353229037615872818479641755520825402977352044532728989288131318994792635273076684794348019858198888846251883682434856709647e+13), SC_(3.15538659007727107880083686193998563292533754784239638473546230158371409841656726541189075805403753304475273768163410631304837122301201804069146565821080380728613439679856624459579438773909638520997068262009983521806344833780047975686836856408178527940530668908592418922849294084163218999836168907185916907686225093493625442584462427634364163510373475305542575946640596319788825084236461508223200924347550008190319412896325544644970319132017408695512459624713558941710455539829411743008273160922182276e+01)},
                                                                                          {SC_(4.04181625234673047586397842678707093000411987304687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-14), SC_(2.47413523417687237626963417481472433633575119288276766917889956829706449387149542182869256245700252809127224187392299344118680726955621980608527311106641981758457137155249257019959311787800175161249767547732906304767784662313938188488954622233749014151216322402541870100691842879966764316542106877672313850010047940125563794655250325383293007679879162113741747550152520179452876634080967834990748405544440060405645105251924641229465383899510724315835256818990916050429842286719722149892359257192546334e+13), SC_(3.08394971435561524360142991538131117539701549235963414268474100167564253338933446140757694701064289726364423973157455283907856938737731484242330760047331965651566581163412758979346661233941073287719334494551282734269681696866274532457888490449760451692621607033690773687251984208887286450445309681513684821963475136058108812225796383611583847994569380161340863673936288863658102647041572372692358955984131110815821568036946097843162296614207222964877061568985465748411171374575442815448828159106229063e+01)},
                                                                                          {SC_(9.41030023002276116983466636156663298606872558593750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-14), SC_(1.06266535132378760631643358293084561511832251368430794866564956367470040705018915409688083875482366263429632275039193240775766717077873313852950906600022896494221965573665971241663302310175858585575545771211409213274114706303571146331076743944647262144373083858176045960978072697190078745416271470663047735107459899716848754352570868678111151112812595107266326009187517941163620835723085933282061532789859285423369697118361841235177506549712822803071392540857286208956514811198187808084053916061721078e+13), SC_(2.99943864434060791143172217492896937207257949517184549417827064206979752588254776175589324103489335524950979308405249931740158481930226889556381324738413768244210883195345624061540768169879851570810583307354423589854007192927945909045754243680609798014063800551099760224902076469760607675735491720932918729762150703739803896371534094356260646920621664361156701208773746212016161641743802207607892411338748745704600883232903687017902944301007840250864179183844517526006505109173025929076962406537777920e+01)},
                                                                                          {SC_(1.33452981738307885350991455197799950838088989257812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-13), SC_(7.49327581125803664353332686794462735456476172634230287246141345112050937168008380331979244951518303168542851471161625212402617638944763054689499203513298470645263374349226143689692949458761027910602397479322818253915367494622615901121203986244743934212301062374794036609817418728998513819624985002827010279122684636930340188704487616825826188496239163860134394337564212301369114736279077734733982238018672531979578933946521870429264290190811162244158436887004878920183732188673299621097892176296159380e+12), SC_(2.96450271758229288403252112889839343046264919348997051677770807143229064321698759490104407092173470549790770910195143510892421208124871524048537452270859140340894574198474275240976869613246364719079574395550342755224793264452868148741241005212364301594685738976292681945703335226563931912049610406775300176036592141685864992725787902308843717762037673700674556235606932116716568288702687427879873000484350347814943416258390061621054988463397497969887685774955472977153237799356556556812974507905534520e+01)},
                                                                                          {SC_(2.66296967116330662861400924157351255416870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-13), SC_(3.75520611754846112229083118399808749001360022124058715474727790108499144051750552773043606887072948591733873717619240063080087438143083644198452449978587541745540668164534368081538836999426749485182722608937514052626546048690634099712339264714521629742112776070046990915446381417847222407042913672916714141265208789710907662269976047802795103569149539665396634565491541483384838198541813267661606162894493363675144867700571511618283433250754834401268934080145757542080423149459099357971487063044420798e+12), SC_(2.89541642911290985674935632628817900504134143476583578690835555153792464486843214230770681727568219370418454410176940082705556788379939494096559518415200599813788233053457422119145514230226273454974164747119856647988194000419844395517976877127785947700998789158949025802776791456070546132318867880519233401001419907844937725860998778948766916982532697956516048925274592479471863457959002692582148207882530569385026392064968869404325018522967272680481727974672171879554684614564347484171235619314903696e+01)},
                                                                                          {SC_(5.92041389871345025142090889858081936836242675781250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-13), SC_(1.68907109723691052070486525865106261806854966699127027205669176277569218965909678349600366028971380180385906687809738819931361084816519280585711566815674289584306704539214723315643204060952677418896085153747819431781526018839209148072775102167053932355256696250635369168809087728146494200909522760193515069230982932008136433426818311186461001454876401671432451216807114751593214297322118984996051173573813270457915363615668883625006270008577595200337542985666436051094151406486548468223963306159654578e+12), SC_(2.81551998471470821921826157320225318779020697755817987877133780395168679457427671788226434299866659405041732712114375208646597948004797119550767305131975984686358907282376546079646237181336488345676458337148909817110936069601773500181081630094896836955048561619175391708439600263872860209454397931673667257880817059574772661504631368432527966353704558439825785368252610502124484964110156251032299215447175710893508980200682712137982588485989277355873023709479206867181641268659311575364569507471812106e+01)},
                                                                                          {SC_(1.55163989296047688526414276566356420516967773437500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-12), SC_(6.44479434007808281945668171737631984460126338755716050528259636607558935755206412545315633066199139062007451090068421786440803136845169038776735288556927740762250530813003376363047126561006457621447061946747652004313806111815894201357327059916054202470401783612662229031472185476081051007630444791825977198318692478573405964267879544376662236850355227144275165845837654094265233204518939903809979157878239002505955765874635670880773744972151920549504126507544870672637337239076996374024550050298288969e+11), SC_(2.71917087488208757956302942278577362295215807788263157065483843364066663844154423713634751254760580365655956711675975357428722671276630188824680533146797115053517339275254913516196328098442855098750314098697115490375504499318013291671780934170480957119848910233193628612157277168981731443947541882834369189186964256514844948997973976691949465374841958954223300229207473839330998856617233994716915993252606356782819485709994926845524965543217686418000523044509663205570777926153154778574864020540675905e+01)},
                                                                                          {SC_(3.26923297461201300961874949280172586441040039062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-12), SC_(3.05882146596417234835994602981634843704750827288294119670156575398858570365036581738681250292878619132939544196249745147762777975788702902641322452264655661985803387949475536433707633244000288147225470160054689577928543581745112442814412566861665723976043265302978007164309180647034560028702203990421924922013355345598647705169919067111687823219992429534585941737923695475857355829185398287550483537377689480938908547889512997031717082903798346740384480735275300567744061225303803147502571461670451282e+11), SC_(2.64464657228708503007839379797814889383468623408632356045883940239707796706335741648601257561033703735027993923522266991510795865405348473785708794241059879719326704776023245036986519209326809690606573999809271632372481993912245549990143970731534224585709349233224063569517537604626541649377460349869609607539997644367673174479433895486942986943532920284602864941975113981089301869678030658716662693056171364402660992019175343646111063211321804943853171822947415008191403169872733872982066844706145490e+01)},
                                                                                          {SC_(3.75378547690097263966890750452876091003417968750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-12), SC_(2.66397748659682909756214887858083229415894420716762742064573472682474490462580859011373564363428084801314649404922305948134943734902447416261381967458044712729517464413747608514517893451473086812036842641949289328614680708631437977491656865094490800485832412388703509802032685663024816128140980278111665016584380476090092190662589280675294498094956505172465951855876751666393436168631795516138382681944895276698624547918025170510095147475386547606289130297220119860631615057432119740644819489077420394e+11), SC_(2.63082563245997692641649751900943291907691027144583704549442551016776634450412688273893462505301287777070668295183514819852524997814713408510699214857155819476853930204939748762743648482032606225357989833787868484607162940507880034914693458466251230146443827109590823773695084631603391774312246852917983179238312233575917758149911819562050473544307597831316353986629032971639235492193044250270704422734560896220909594598818102479338461828126613160467017936891031331993774585288966541820231566991439324e+01)},
                                                                                          {SC_(9.57916385102564049702777992933988571166992187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-12), SC_(1.04393245125189169486027570038996582173487482590748586089822808469387431328301377618370442742826265541497232306444964659164242474807185782150761610210632289940820474500560688335407912085585699972502466458135697942977731536099335360050363930102587739596997254053324420001037812190352819577308953150566568369925711308080252617427664868786203872471901268803117970363715521670230414288279696940737544931751291247921012323221444842194521436843824624549899340782748610804764503134909942955283466392480149356e+11), SC_(2.53714308084356893528465928314436682427710311763825598345994023050258622398573852312837852231659309845437520988033941711696041489046002537658504340143627120828392418786708213179671375739089890154011798708971619878833013355845921783147827319762987629911070090390377141442166911300222465040042045659314267308680084418840737558155857306825315728369486845594480625849530184371295514707954989360252541560432094681464308036399339395096989260992294394578271133139088324006323139537103026881509515892094815868e+01)},
                                                                                          {SC_(1.85816709241670707797311479225754737854003906250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-11), SC_(5.38164734522710681215600336061308853120702404775145741709026396178823245553137666800524126297374217114724680251167541929241182261687949418995565335029486872157125343290612171119880530101193916858921432756965877000509299499604733026401192518432472807166016347864511370369708185703119315683513347311705471142373926510862090059777086621231383651397623524522666406326397488408425070093854590097402718270173248647652565267172176040569249429679757503140285383909390206192507646517253731439123746131624249013e+10), SC_(2.47088454552427137429056329064109142188843906165891475774275743679190025685194554734484595319669509903930259457820499849598199214676908400721919316015322380864769811197623330485316164544963476410844338145101962702064276881579255860088713997116411562209654938575284162991827148200313426345555058188280286970644756612598695826995893568264874467159345854674115312282747039761533926261402464939091487342073450254851176994505068182111978970672752958497500861843350592146405041615401662481907234472878121134e+01)},
                                                                                          {SC_(5.44948530745159587240777909755706787109375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-11), SC_(1.83503568419782742444110740345485123635192662508026305449822064127200895495506522518300606061885236080150004638907060784485796894919202236803140073697331043211992951972609347054589798075100998594256645375390103519596787348845827032192905773076186985280977236935203223950666348048814013595501435907216666387351197442286860869056417192384391638213785809676518670680508710566800590437787611079311407075165452999495406849472529410938337431736830657048795062807787119744804484928614047453144586034805245789e+10), SC_(2.36329148576872448249942821605627674186499356266069319715954487992643662294411738158241119885349703763796404853789880585762925019414200620292460678339262214588413946187958058256382025002391673480147145270388456894043662461018854194828668215962270960439151474188647474425625494775601112078253792726530286137717752752768842949012627953324732331371323991302860241330919243809216358651674628647197448697291367713884619010229075199219840636262767574903350571262368220355179436844196791555671752462351869046e+01)},
                                                                                          {SC_(6.08951777891775236639659851789474487304687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-11), SC_(1.64216615546621064803013134062087811673092748693572885955291086615453038443965746918527089670359832467884627804869657509889650026751673783619206954153041104516844408513248895106916772556394041551875119284869088037479657980868966602129588687470062451815693221099315162782276653334393329494895424621430603591057616248637305903296178334745144236325653690117993496869421243789046117391168563934190450243201956497156633468278725255215744464020504309074023652187498470935365081369407764705200742909320431349e+10), SC_(2.35218671267563612353348723043202312786307472491656736789362170809010927853268720372089773533365322636476747355137070858356044677376510322713056628921780389307345874508065375269999253671352912911300789233090646288480277336399214203824400746311370034317659741344301244189548926906452691866457683693618594716563727782265819613630587556878361391532959913004915741915512858017425295944874612540863724007947904388532017360454437916475157224516660170429346394565018134649549162182163834378038354896787534841e+01)},
                                                                                          {SC_(1.33774435973066374572226777672767639160156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-10), SC_(7.47526979014226168376384951063540791218306464061986362930576004822937035170826747587219778713265013490356876945166420253260555381329073438163483115746514774479474424515084780051629598601133421867960470830504667887885069909772744114866067292970878487141283092292728452415775921280918070442774133326301037901061816917727478717520084018487350667522549017129986542118147485610067262541496627719604571748937052892434485040545825983818735788800698893594461092076293536724104072562332257956291083818308956413e+09), SC_(2.27348660478985728986052090691869895050374367468815674115675413846437487991638874436688243456130558073290283141742095678859644590259358965534318423720133246933305572030632400606313806383078380531211317966778435095299543494045005476053336526881142479116347292899023673200509584071082808986065746925389076777580052558272824153282309889654575678844049352349892755868036262512082925318962285347555701091174821628709528237217604386997327214614368590642701672876321992143952181847423729490477577346381853522e+01)},
                                                                                          {SC_(2.55445886665484067634679377079010009765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.91472343871439978910477041965245474686465180195914637204067931155807421046773613195218014343443213281482963786749317221809432998053890797111065514873743303968835421350089217250012183258566393346818055392099509447667423810046789872014606508233744159464480197460174056765333167633380035505451716049617734818251233366973419386831337618966097682993067804646577065386307800044732627324473412332158334409508167829825644048453099756316314804390039245419754866540656073700840066868100898153281112806338309714e+09), SC_(2.20880105224416920895025375311224309333191291243380788898883223848745359017136539357506857766099404650529030796456169266293876522646879739438348110747941991215095622332304227939069152729572485470267183483067041403067149639760009599374303521571969473311055242104395748819301709770976566775902041342531942700926010496460878831692942101086740124837297933734304244538829304784415560885582162795113502131933398817811477963855514503427658668565459402914411004137540469053418634046916829095623083037368147796e+01)},
                                                                                          {SC_(9.28560339730211126152426004409790039062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.07693593693067459739313196967983697014168456746735348950919376991901134647895921249473783820425440748624729046805302065147100445478576472841997876556348031552956847123213018659344562570860704628256642731968975802662512832765217693879980226435177749884163278536128229784803704747100947313765909472695150172294912887298258373307813501549625979139710091181006478520754982671108876330020574992387977252845102120807513897028338524143351916484881826006078361700760820994355807138708960301667204359286421020e+09), SC_(2.07973857504644610716889395527737992585186849324495128250619250061479886870375850394426233184821495976670242716899017325165163154088869376465418506805353926143256480084118576294761652581847352892907919904429997475140686105674530141840068766707330442895114253613073589774120006201302061827279282589546526093188104157655815622515958409221402489609226382619746450223058090686879130896414033263620750912064412230268748715901437966406012423491677890763788052175548531716952413812038430090387475416035911166e+01)},
                                                                                          {SC_(1.69822733653290924848988652229309082031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.88849312166503329222804086517709611102504992551929827158983260288274819355761666131361350403874753215463840071495318131961262300000765445973666229487031598720857498492987143522791355463828265864402139432350575863919550830036469565606199591470156705446960446045999559624084043933730929837654285300895855904989248038146101301631557036491570331704774925320131536014567404874489691389486251736352515404220755516488822817333832143329345542864773188420965679770154373216348702981384689050349014346637868895e+08), SC_(2.01936808721548656388079701232333621990292234406195324994727476802362692900192163204786445631523775797240087658142441617001290954758379696663986806394767773157322284307849876524904682586819191449092688119556710946373436273820321044371035628264815659393916459198676972087410240894826301225696379803232794401251838170344674786562306664018746217590477957014229341960304890117884805982875916303367067026067301211977791816334606548169972461693412588611268696560770810948724317758861874065303224659055768486e+01)},
                                                                                          {SC_(3.39355921141759608872234821319580078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.94675865585811635298905545790724556951261971511817324192800337091966952557433897238486040563146326422690127775802629136506732120683355613677456114065442582606140614028294138747202403264952788642284199088873893000648208374234647107722407968127897446593386208233249293959770393729136064523101800224883878867516495924927666979551417108620059324211868720429514373406034762486902686884221653802832710722135064601777922572822590724018314669731551707502644268987523794807797201345037498713836837200106117859e+08), SC_(1.95013865494979315748313424975857460473634359955171433398912789707630274299619009224156325830001463741355320932191136639198272143513408963597746842884554261062767061011794862873805897207009188860568189846504131852234332017714959090717508237726771666011207787732265446873884001434343930063513478218717017119608818828926407280580928774522312004033748177516159660878382197007027146156778530958492741043073137226561947610796232234756201323918090842542134154240717765908943925443129110964257210652469765459e+01)},
                                                                                          {SC_(6.31372820691922242986038327217102050781250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.58385024439239560678029793644762724145694760750936270448787476917426742365312993416495445258066935770102073399067933673940787592468244489319355965681748597844017136875830896374444946819887498943387605128932905916683614722179628126645099686007619813917603450327015203485661027618036158569766302078449406310364340890783600576522072882996092981719203190666518838669113707153191547698768060884224247649696478290695897698814564809558453790895608263410530264953882534568878304886285345294246575653964394933e+08), SC_(1.88805394901935901312944434284350951219368630628612582497798500377213575430066187911538214347407247506592302835814578379074942968724063304830478545485499104982891564902834873083552388009367885301931886283108030732695152751848460305522542720948518365374089606446212603641365595987395773574687901369258435992285754676676444454303083046616673187875296372440378443356862117485368511965690403951383780793178907009178840322578791980487361471021699988380686049660994558986894513487250480575078814977194988926e+01)},
                                                                                          {SC_(8.38326386087828723248094320297241210937500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.19285282171266658145508408138097534262559562256796179239060845011847752757742744827549809320449524476525678489254530873060639064343374370418109877624082104111867971537796336728658937487311009651740723155108598523574089439636001946998412481579157288344084972946019075804904453746381170904188301113624111553121632985948929138222683651820769143181173655246038790436308561376021389687302205902619878055292692238813786176438899128455354260304627671521514620334784061653162359203841812596820283636012413155e+08), SC_(1.85970285112369275360019811510798597407616819997535534540861800006130065438481930599974368466408856952940619414764119222982234819668925719824207934180803628792362844837237434872443976991587061436543189016693448298778560625710296335004224090879870402508253963121606317871340026351185428422401899631577649568952634738322641017608299843257260519480390161519206689676784551329384425137071265909687534307017746909409303177372383274507940067443301831530926380849233752290042798372825621637792458149510367158e+01)},
                                                                                          {SC_(1.96263059137891104910522699356079101562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.09520229157747964001427996680084687728519220880694851417761451758485922028137797926986558108081161647424335273935443009450702693139660492793598652472042922321455560347329476289740970225980232132484721944368298424652675989140325777048780846103353145589579610596228532659731472516752040401388614999099106605361023985232754174754462689599358275454662950394291313192314924154309854807338240568480536882437606662081858664976471783856993462009295129472122922430204094632485111706729685334953903001928515306e+07), SC_(1.77463950207854514067971232064740260529105197804463559048243833216868226570768682518176721601656061733151204368405143742619830734756623431664082017620746152360142944331261018871625099695179564716131664620296596142717865215783930311250469461067216865839155669595131410277575494071155624571181890018520530487012085131270472606584209551187422858235247484254934923176063127943828270477251954203313710078679176167435792694591424828856084830989589146231865386331847539580708042557229489148910726228436273224e+01)},
                                                                                          {SC_(5.25638483850343618541955947875976562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.90244816615071042976912611629696763144346541035766078085764029503997602581877792049646577520911176605141052583156884910047229341218903573541592559499518194959491983325368765455962448031602893719065828910665027882587968020448370625205459497212847547686522514510967372971354497619542701997056077016761039101147586700231467014866991293439747219121625945505887139948909731139184864350248915445653527417884819966623498522753330295654416087777162453609622667919905235926258921853904509270133969132116091634e+07), SC_(1.67612372162164061692861843009343434771981611053111621976184895674270615702556422861104711239670932942032636331270126587785220494849967705136661812539736970981197905984513517678832773229865521494702028014410160745047515210657408196793002836449416485413273544305012535544219297954738314917704098327165656062964601614781986549238030592926364895039476594734612878189916934277091367272748422762481586851408931992506671596123378100473697510918014617091780151806715692586329303065621890707562029937748330347e+01)},
                                                                                          {SC_(1.16242290459922514855861663818359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.60272048104487229772270370408991565622146793420283748432283683850487109590703567341512208842888206543920002357186841608997218745333833023455975206855307233940669287790010316749659645433998894151744284846749708391642403854115820092354766734491127892363620549380243024276736218478701060023730673432191670156499018218581472049008969127266351163613795232939963359099049229223643932353224706265523448130695355903869011220522517153184148351405100515798526771128492374949302429712428995265054565616102236743e+06), SC_(1.59675890462055852493050785354007861019565072353741022812627104322063156529086182292122548245675963093183064733327338722657905893984234890223568744516553902070973717709098500393275533107035456906906513737015232252328472020431774422782634447132083994791646502267731048214337727523605199382839002174372325259458602525164508779404945196242777027746479829450292065967587035499960957349740151867689420397814665735654733186029950552962743110042418202174503847771730953250698037145722977227920266313544340773e+01)},
                                                                                          {SC_(1.77692015768116107210516929626464843750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.62771429605701866811138968820040581688116632816625983330513767541698354176855994730746674759831971880240445767320154220938966723002674804699555553392464572752062447887107572218019828318385760764849719115812290395527218248512835468451576239683644796014696087840260231260544768733299352553787968817182380161518794267110224517746786086312897558884287582163631755473909091469973820008996113444080900207916568204012349110621060594004089234828356435145317529589017309777517404825895108564229825972606783182e+06), SC_(1.55432139311902849557388986039946494987126573050313531526481779205905405668433477095198392052135320177727361621658987782230848885023817861314864082631463951648319984960611870632532168113895900910854247521399554895529781550582806849790523833389893084518536060834832685622097231090397585685502199395551134545521290924266861842592714224402073494637426674029193910125176587896815977374475577011900752678646424642579248726361363336678870110288587035477510896039630197401429009658705999914443878600811574386e+01)},
                                                                                          {SC_(2.46631088884896598756313323974609375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.05463829463703525078122574940316185372614216769109157708814571443486612751575690613250765783963915311892809190311521636840848682833365271859823541200911649626456985869205183744879031447905297712068866428485718280809470026817621417084457752394310317819688996380906775828413109847499866410583703740515922882544138759737755727432557079831161548511524423498124090291597806689974390433799904149419080022622021024787189417104421660109962432297064272955004064700460013960135399781819403593602459160459413744e+06), SC_(1.52153720417102064745346523708311080286908527069304380979659806362345202173276520946568894036685196482196087450838867175344344468238318814384356738850916294525418838439245756796795747454256238522398060373267581786207971837564233417365834530177830732568954115312718140425486929049831566682146227958628349055286920128285911779848078583664754564964840731594796819254368142311552040020238959735263159278838020281187709608149004880883080370901523357618622591286058941009526205756711994702121770949864546654e+01)},
                                                                                          {SC_(7.93268782217637635767459869384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.26060619619731797608818932503181830260823421781213048732665695327420696362898453758226660591820476065756957020975520019667707610555894768703507485484222106076869765708337512029685375685746413643372605490449629888194538976635668689248136807099122488332322328884163089485410632245588395068264245821725494222737390864654038651030533750522546976123471768082838483346923830312776214845895208472603705758787692650064498899060550013054720470762070785663552346599987591854146837595704246331651813008524383209e+06), SC_(1.40471032713253781161105456090844398310531699761588801858703943827256004083339187938282688922859386138059958746496554270966644869917724313173459469024731217872312313939028706531208267916779711847875755923115508248648357114981186732018707140167984280398904591328254471708347734049112217021783628832842204199345747439816740684385414946326168177179946882060522211697405823017982624446938981152321786117064296988318870088712395225819402305299983569779003430897690524415945397318576782524369949353588329616e+01)},
                                                                                          {SC_(1.37209326567244715988636016845703125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.28812853343498664144152447838008783938567673932162819960961771256950384002603126229351335533069556913916892568138616531409143041501189818980704581213281032710490015194970354870756213476299773879811898004568190420013714451336012132400839252929052511244586664386695283946540013669687700896185000308463082744375107020456438967956604931415578634631979274913179204735917911437772705149748195582640430894253267806733655964881188471383295076887111769104559648198985229120804501321038598800302786397869897490e+05), SC_(1.34991722610834251544478254617081208033887846401310469427406095478843346196811171297685073308928006301987164377413398299284980888737753603655332120887310757344649691900092227409561455158414895169100825749492101027579480515522441587439428668126217470515921622120380597586481272803721815179676865176168002630196740690339996435287953994766447951272834237454248437077301244123733043940406921792054573656410299063798548540972124521498460570764799509713656084726107747894221393929095901305152701667831232883e+01)},
                                                                                          {SC_(2.14747706195339560508728027343750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.65662138219785513456021194162659715040199784495451432714692244736381873142785567562103911931072664389018733512973345980123097086105957143181830422993307222537024789466998094044967709540947345569548881850284232773624903802613550469100983177752083220734207267969462805084427281822878812239074581148461697210298236933264855944662677760069483003826859992395504506972326467470916808301997979437414794764181083226857845955214583704416618979717374942753521670200061935257869925639843860532949699488119920342e+05), SC_(1.30512156248704163419310858052987283807885073935136057758898979845218818037254859855534477451394234492262573113912574193529039772507620648887073103288733240844530015624769737072016655692043999870453260213995786982745953810791105720212177103030589518066961157830316056921435994370920505014296960653565850275264051276660243817416894060431159237063418800675904538400890810373846318565995207426410477915174816465069935340231044180571276528013572674914197376905082237182062279095158542604714638986206139428e+01)},
                                                                                          {SC_(5.27022712049074470996856689453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.89744566051396948131191467613435700133438193946287587593391216386661306606335409546369520065981423905125657400592597211211243004697254375450734895459592300815375383152751165081305823627983584181411284526182204207394660389795419887200792166308617327974051439608467092227533174890458055752767205733534348342642249333065058210492219904013467166773249090089125094303714125962392590340230759838587590812261282901800275368686907652321958606428003570401793590415297039558116943719793472143796722363193257473e+05), SC_(1.21534340574375251331797866321470805050072336943670368507800133643376730773790413820040384632351349786576361785072435541887797662530053082201097185957785332034829965887731383605989153147309401665061094744509328906214042555919268939030387813798149437192066156894881989347180491920144816757302805182042339614005936728867964872372329336770418426254156892181076908397406972043893748829677877785432144800417604037445100468162760543750235752313608369165085076555511055641440400557644122506521106201156828000e+01)},
                                                                                          {SC_(9.23316110856831073760986328125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.08304692055151174435645853312702433563445401245428008062158172231455734708917727233248309622995416103476130730859783426082812474016241501932511000475901840984624284970956268938241100845148302704104227692202374326021995429710412190789499517501742831968214505026085727217377064048749586381949765702833484753838333062317642259075801944397863616645673756838251985742411639158567796696629295388664024665052813892150438181549706074897778508926078559131307287669070666914378154990685310194791830936012072137e+05), SC_(1.15927037566595656608676333962593457748246358442149722307760213653329691390266732585232312633218072213780520674080290918004260905060501441987250389989879522599564165926295894900973356709358185982833184287889198682185728270473692925487109895376481633969407425746209783983216649854424136095892698254944537841867507179483097032287978923877995255955010604613196178590571391372314231476100820183230223610979878398116965034513157331357185817159093437732287357107176531525209785815749703666087413492601638367e+01)},
                                                                                          {SC_(2.69396477960981428623199462890625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.71194329747660700872822240489096533346970414462319130943332437727673026086395871555354923534426796329307758684090756605125926441079955027284505526484660084516570689496028558153640491596899194314856682287855875398764204347089952167700379787578451809878965118618325856981967306344605010950402177172875745453986482790033650570205353879618538529832262937125092859324209602202715647865832427287280809938499032165592488069349477641753571240221659642079940920995507104949485325593819265961739532385927724001e+04), SC_(1.05218959113191896554438255983392789165506636604484179691160873065455025312686246355084294414971498650330801965012760611510148977404541413264372006775938011586906419749948493205342928656222439747335580984568333324076988203103506297440002347920779866410520674190113274847777131783052870610390167794377546520034787355528411508314922975386358933134353197222922919703716998581882764082601589614612452860504022521256961901296746671426803571353232525264162049239730237299766785596779287518475633276054504511e+01)},
                                                                                          {SC_(3.20805702358484268188476562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.11709385543515572081573476743918797729420381355450382111209778511181152310932055956563749014637508036076666934504020805229942252077588670358362288265495735084797052807569608353528679336352612738901337701163849825424516929631780124984065988054242480080427910793718686499912898841019187210679705723175454260477745636077694212098776697591722777186050104731968499613418884068268352388977472866805105290135328421979342194632200989741338926428484922875461512185439530419888158628103661380037688089459246622e+04), SC_(1.03472414831310176380983520126166183229500641071994253195046291587080019387137512979227110645263077621786969120878177843284129518960337795398690432074360786303100938249647682482133908324719023468000441189614849101558514019884444875606114225203976467536402967505115161687406889548187118481920055496926584251660690334337239079454029278564608943116880634267663164371010715252754735624250229428238157024613942707533924518433208364222285625505553939009603522382189325666940210790483815089523032160326727186e+01)},
                                                                                          {SC_(1.09570304630324244499206542968750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.12598326298792575871376208892941821597249145712355235734553245112275791184424920173192390958809327836147088440453600847272070731838167459383457734633274396531286746571484131371295317801711910499009978655927962435202345802991303378916715764960222274468063689080593822570418178751973369105720490378352700618930760845476121115398840126230586994459640874070111920630086235547729480577307390280974311106356863825358553687848655142111054663297488417064528607271372924608147255338609518866735822561855075808e+03), SC_(9.11888092749354750131942804760198365932951387446607940153090806005643231331865994203153064090907668937081238831422255569214073300853117391260189906213547756795578339461193047601491906417607295384073771562974969006175586199307941274383550444330451406419535665500372152406327606813356895490483840883903495107538235046324827393471368712595702254706807119781085992818405020677615041495700125639064504392716280328536528527483253025798036974151336021910553259995244874029242300562997202783539503321465074836e+00)},
                                                                                          {SC_(1.26518658362329006195068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.90339543765010940777148884430598859351624539666986011225276345158776246884141569590179807044935540608336020073420198831987509235879831098864207174778508378299183243304945942399124179383363140239127129852788889394591268763142954004803973096640508764838455634334250452217575170092021719528520780979702520546195516521766092522673675677114507991883621135632426293262864552958004567105759441872777690805227017885582718414531016665919775279511441635073252680404200996526347257159690831721716257307386634020e+03), SC_(8.97504774835078092356190417460687731975039635483901022943615671319109149737911055314981699026784930674690670230372344603892513366502197739637264654321535008940079734351022352120615821558964314283413690614455978052538154196046662526310741944191671468287266268233426532630706431678673817316378735628183210777142361433016716451904550644715844194615744623549079746505429283121123624192521206839116751685248416746623025501661583164546510521555172172770363313019918383836960358393888517833715726142629204114e+00)},
                                                                                          {SC_(2.89763789623975753784179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.45050990712494949775484002402506388638080961096441424786111616212629018401813163185537287870628332365611975002748252281954445942791824089759407952360045363041729854235263163931426111990963272192916849625697623347007557637621285946168372199998129262208030995630954149379608985182807987421083472125798154110350638801183057973882308932482367706263206585063709642030346439272821014392389727598715876907984410099739266841331289003132310293615533755248496236332102731721832627511713932767473667701783430362e+03), SC_(8.14627729827083672260241473795882251685177893472958167349605915118977814410015333417694750657030461729339257490528025119250178359084774998230863794007053582161693347623694527222996422723379100574685447013068079638620883177928422256598825247182208799316990898594977407941592694581625618281858646634334423979133024372486968759491378328948502691422577116400902205623065242117642679484587995259074059369354113787583549754706589392229130887348557036144422650603292395363687531902954386667400975083172345586e+00)},
                                                                                          {SC_(6.87856925651431083679199218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.45321416213776341402172643653824290406246448625953718991061156275374559371473926240159189562530897642663657874824554509667432592596502028111498876987731731419103181077902550647076830258178738399692656235388664685636163262176946409182939329754572681632034342895691385894677553479890654931971482605617255828759487638944296672758417176666979192400085893856817992255670426756593975946191143479418145211492672337177829308430717007395722848329062849814785306945348487702248579633088084778151184300309266488e+03), SC_(7.28153304578384526584740309475807940366672770326761440940762897710596740030873024930437245041126693802972723766820782336184883357255905701949197956259485841269939774864827721578724722429879285781856120681590534300373112907042521537083714436074932198957147919504117058586652251820950663673303273139893930539087144915014830401325006614936376974832764368207617357592682985463417492708094036271644356036769127411668259712404556319653473155967703044648299583649315831983842605529260138729644416212347308063e+00)},
                                                                                          {SC_(1.45484786480665206909179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.86781314954593160454464618092638855307877715120008177395736462810782174656198499987155564941616352195397978189958626591964468149122014404578158273793351109200213113242205214101044790656181720304965625629108123017569222776687767520209813381764274910480897470251188192687862750700740524066029998775711155906709369717589842957496547022861611550070495006016302488665795132883296840140179617961235225362018556687105202197899534545930741979641738181687774160395997039192122337171298869606024764194152572205e+02), SC_(6.53201592270476536860947401963790763923758464656367263306060046607497918271178641252338567185849747672002776634506076650648391589820323978592182449435073300185043423125573525602447945355905816656067022917255389590808978616355532501271604376496797233681175875074422547652589334792206541712331187984801333409296389423652916811105854094159227253078778899017652515577545872921594094374282044642163199705253838209075554053916667166971670921667204169860545673190811176573623732640765103804713524763978549642e+00)},
                                                                                          {SC_(2.84763518720865249633789062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.50594171696151285909745151539060148090670100756598276592118180115987704129717344737175536146838467429650509880933261757536214809892173281876006961922839017349368918016715871059899525030941759609599269441898890931160728866049789584876193014773218548509654645319159561127258379771324092719966908675957131318483541799312767747733138961436119057779331859641695772856381662725815794379091863942494612270061680368205577445870953007609987741104005991805804886967384188275707554716979388087267636532946282078e+02), SC_(5.85962934855018738649587312234013861000302129002387515656848684744945876545003674583879202077964721098762835565299861962310916008066036172236976819930438289116464091969366411037592261252848982404206750088667969180754458945474285474601066663817491557087065960821804732948417813401515198784400105833419751461696325694087766748324802786184900101367488656974546138080516802723177843393752642666700380479419135279302308967786036757719890914724222867842139605213115580195304952037597706912460432334234902066e+00)},
                                                                                          {SC_(5.64682111144065856933593750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.76519128540056304742831997519877820920857036914650901573270747956845477500889430697791487592196803258689553507495813881022776480777925700182036665576971280072328890974816214386062388950744611023401725987258039815422475168276086738701705000544747226989884474035058273612828243108186586517112777510088124111564539998697510264649032558567739799755678748844961531931104024399830344324164790517360715481533255431541118846660346844535860168147964486866047359898493337601385827325615954944742621429321977581e+02), SC_(5.17342924749847509395382677345036844101386697468349132677587382453025545597250597832024586312263039851038054560204026648849897213226041789143731646890157430242670947732858306884595312712256217331938275330011909939145523867716578226550295227412107943048043687400262298491544402458520241247144003660180386212975533604735504214749965015720884534279252951041120761999648196048357797420424505106730015081309075580772224806827744896280719587243764810430249896719753220866678503719199010381856204558124856374e+00)},
                                                                                          {SC_(1.16216316819190979003906250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.54805948781229923149687641890635273041975417474905882859150516565590298743474220866223427847397219829369000787365484657820972691183108360605393331283145369982954735683172978957406283752717555211684709068397614268169647182606579192285035162851360588278393626951222557182654523459375034429014293356095258118240324502965413852124342360304922331374659768398497859177287801543512494826720289510820485846755824343228251545178145676407581591245429045649416349044250416913523846071033825128926490142637555209e+01), SC_(4.44828938969349535148810997617139307954227933026998994112515594555692200779333843464356653807921936992867624497189566489714896857491962316363828135293928928346656864064617647335878702422430142925101126291391714324130882393175364831612313548374438381832325779808261417954388871727651255253232705020856911750794487479982819966152311932156460627180969788906322678826909888730809759061812987798687444590362138599953149339329603462078768122099122835718866740346965377935783016681741937074820082041620821229e+00)},
                                                                                          {SC_(2.57236361503601074218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.83223951967113693849122890317251581426967564682796089915964456835265948178547033943047557579841168870426481105111239555909984888566219617456297725026211199966229821867396896637673047846203677720619527001090874122989539262164276823985235279052457210386157561812538654504918195664295917949283586772716395811634553989103419541323834554767430044867416405158430381076975887538013410973782203585237740277871442626129687031933867672020721719964459784999936157127453790515452253439903564787419239743591953735e+01), SC_(3.64603445628268180815228446194149337645492864618317199432418684416543018270226503511460400594569703029802101239399103310482691389005692181097074338257638671907992807691192922059620682440896513659224462009722394389581858799601911686718694851673895425167333370010580684144797968600958815062396012803331103402562839775473490687537808011575400396372112998895944651405677171661590755009935769417687641381092691734206386019166963834756183746889477962328743513839292774321043859834004242466174346299715639715e+00)},
                                                                                          {SC_(5.60617148876190185546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.73130292072055181332528155290397626567590041507263494389423293518332512065213706248091156839903121576423171826799183870730052420390377795841699975327731506894205043429718237598549528618024309783147598930694013249097703503193128875785371460887670941110426110649033031522216424367225466117889459621951853207485923846568405880011044669040489333426682118087888525374235517821551139711223601978742628388427488194084278925710136997272334148684152483989197734051109512385005918855581117719442233374533422244e+01), SC_(2.85145935140559624069624461061073352033685732756820805957005838077186103003354080673737557189099925222021795696661665853518636804085091657285841456607737476426645592333146127781631727888953940992284927928306043552361916447918323282469427741999878319265371284600734940623454427339491501614225992065340251283593925141296480332996912477863604005197249766568111289688786686315245507596213806311552005867021049188904470043625006815633642348871266026153738589428518712450395800127807049373655934687568417331e+00)},
                                                                                          {SC_(1.06835305690765380859375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.87937594300137280222785178504237281981439562279757747352051112017636683902262772265882567787341933727313653229652916122291506572903276244906764087817565322262562231578119198439889397172690818865294208195973086367244330613132729788244977350056887782304089958939338325229445338626076593013444094664859749521861056733116710043733177675852597199662862200321171291806334222056142568553511466136167881100235172294895254202442503636358257078278759840849425123630124694068082847314610010282369584001586261853e+00), SC_(2.18373127784552189022885498465497378725174602502279874257568947818012110655570669710383812275007248898023855011570363491375778330408026208369307534619406033795714421333845585977938683598593439353594844370348254064282219915588151065915494297324923171198525509198152675095787497882326067723426000070832410772860559971251231892379783042570498001965458465779101525970184734775905368402518886395167646368847252388395330389342197997105657677203248240392695509386526846047757896615797092836470002490643633298e+00)},
                                                                                          {SC_(2.40109324455261230468750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.78368178711231748572573525384921992043324039087841552984182765916536616511007182819817947529256026069114281603423250421784805149083154700929567018507486497721146897268173695523381988008996518312445075106405346666217454765991551115606292938365849946881660425346595554991194890984373406939193890782449870111966141693907909130927359458596551510644771454460052235072482166749519660613764899466155251273563930908045243468567615852308986288038858920350451375815061357930111117157254756816152463843436327128e+00), SC_(1.33069755333858002682528355594543980693815080830370533083954040140260195653398211600745407909514068964724602269394591033304236792153229295793542951189322400050827513942267588200591266599249018149995398100320469707929205615364581942070307474177593988947465298790510611575030618715531455462387945757223905207989659084961839714183952763698696758176669305915307247150797661417783641740176782212774158911335502133645542871042818603699326206692704757081405565700275666335072274515905630940653959113015557377e+00)},
                                                                                          {SC_(4.38671588897705078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.01934827098895240866291564717148470275669350790670181518067930385460960037293047713749104474976545378311550134726627432493246281473486566445456021631400427110536255673815460084692784908956829653495993998690913162566451452325878295142067599750666467140637626487570692754761019581563191008018345327025821296654609413196999811589162106157757140856559879383490075416647663882482288743311346454343684899228300598158351924220896203043721869605613557353107864698167995101951259722097491579350956902970931209e+00), SC_(7.02774821229955033201098872522145702309892877930122696222989524936496725944203147163698086529296544937631736479740341375762633221927065058166212697662139823190263516531129117388895917944769456807118372772711996458078531822620766199003175648806790195767357047125727581511679389676806235768985317112567081989787111582319607295781808387339568984936622732251106484870203126608862728541660239102098528893658125927049289362506476736744933084082880129995438327280953236300426644368771292926944860776376107631e-01)},
                                                                                          {SC_(9.03765439987182617187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.06560979056544150631486646775654894531497351725167706096010663906438214437064541280383121734941160110013742022603852718722974043716489921274151432075110987277321452784597219287693334742039128758201596461554834254278304725176897557872665236905185284924160764990132078376209152960730546416782338895816056903193589945923357184438008243261009964597638527688093732813264760840562843021362962398437652711368023143234727399617697596268517882044297733794559710970166806228215768323696486824556471166719059683e+00), SC_(6.35472086047240242476850173653964968094401254249645125812894399696989269072611985147350175386979540001317320432048487161687158377836798760540253238342535989944288732501843277339124525960211590046211344621131449288110335040489171975921179119993706307712533585084502959793358884082738581504049157966802149956240785900918636177358262658800443458403672205227617798438927337432399221706666884340845929646445623501901592486353757974256947960849040821025145345264978638085227457220184701989027155986122840831e-02)},
                                                                                          {SC_(1.27602481842041015625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.01414888950966447256741553037802701136914837769904660661341552878720993180981144638082955030623611082112991817736220467858881713541188940021200281798722356747839343824757865378792288085582653852666354963604237824428091058309940381345419447968927454656100213071087794811710211906454576989399445912084143541816722735712338070767965545035059458937634367561872704858664652199384243134873698614575689341524672508628895265595278960478185603597994851716518887234426980755563401446357574835173394489257258389e-01), SC_(-1.03789651277172193944086098338852746711453874554494751358201389145763256548191333008529778141620308270050982442005582738919672606157209775679357946534464297204946198894138476752722800806070647736840953123760641090828638676777046197081472678594658653029924350948826762779384389037531016067478554113108266601116041196944329962447909678357418268110606803095785064013479379529072212712584934963239795181858596438347804510477316820666489360204187718259096876068752105120502150744520502695973277633725886243e-01)}}};
//#undef SC_
