
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/vmd/get_type.hpp>
#include <boost/vmd/not_equal.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS

 #define BOOST_VMD_REGISTER_UDEF_CIRCLE (UDEF_CIRCLE)
 #define BOOST_VMD_REGISTER_UDEF_SQUARE (UDEF_SQUARE)
 #define BOOST_VMD_REGISTER_UDEF_TRIANGLE (UDEF_TRIANGLE)
 #define BOOST_VMD_REGISTER_UDEF_HEXAGON (UDEF_HEXAGON)

 #define BOOST_VMD_DETECT_UDEF_CIRCLE_UDEF_CIRCLE
 #define BOOST_VMD_DETECT_UDEF_SQUARE_UDEF_SQUARE
 #define BOOST_VMD_DETECT_UDEF_TRIANGLE_UDEF_TRIANGLE
 #define BOOST_VMD_DETECT_UDEF_HEXAGON_UDEF_HEXAGON

 #define BOOST_VMD_REGISTER_BOOST_VMD_TYPE_UDEF_SHAPES (BOOST_VMD_TYPE_UDEF_SHAPES)
 
 #define BOOST_VMD_DETECT_BOOST_VMD_TYPE_UDEF_SHAPES_BOOST_VMD_TYPE_UDEF_SHAPES

 #define BOOST_VMD_SUBTYPE_REGISTER_UDEF_CIRCLE (BOOST_VMD_TYPE_UDEF_SHAPES,UDEF_CIRCLE)
 #define BOOST_VMD_SUBTYPE_REGISTER_UDEF_SQUARE (BOOST_VMD_TYPE_UDEF_SHAPES,UDEF_SQUARE)
 #define BOOST_VMD_SUBTYPE_REGISTER_UDEF_TRIANGLE (BOOST_VMD_TYPE_UDEF_SHAPES,UDEF_TRIANGLE)
 #define BOOST_VMD_SUBTYPE_REGISTER_UDEF_HEXAGON (BOOST_VMD_TYPE_UDEF_SHAPES,UDEF_HEXAGON)

 #define BOOST_VMD_SUBTYPE_REGISTER_BOOST_VMD_TYPE_UDEF_SHAPES (BOOST_VMD_TYPE_TYPE,BOOST_VMD_TYPE_UDEF_SHAPES)
 
 #define A_SEQUENCE UDEF_SQUARE
 #define A_SEQUENCE2 217
 #define A_SEQUENCE3 BOOST_VMD_TYPE_UDEF_SHAPES
 #define A_SEQUENCE4 BOOST_VMD_TYPE_NUMBER
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(A_SEQUENCE),BOOST_VMD_TYPE_UDEF_SHAPES));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(A_SEQUENCE2),BOOST_VMD_TYPE_NUMBER));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(A_SEQUENCE3),BOOST_VMD_TYPE_TYPE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(A_SEQUENCE4),BOOST_VMD_TYPE_TYPE));
 
 #define A_SEQUENCE5 (1,2) UDEF_TRIANGLE
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,A_SEQUENCE5,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_UDEF_SHAPES,UDEF_TRIANGLE)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,A_SEQUENCE5,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_TUPLE,(1,2))));
 
 #define A_SEQUENCE6 UDEF_CIRCLE
 #define A_SEQUENCE7 168
 
 BOOST_TEST(BOOST_VMD_EQUAL(A_SEQUENCE6,UDEF_CIRCLE,BOOST_VMD_TYPE_UDEF_SHAPES));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_SEQUENCE6,UDEF_CIRCLE,BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(A_SEQUENCE7,168,BOOST_VMD_TYPE_NUMBER));
 BOOST_TEST(BOOST_VMD_NOT_EQUAL(A_SEQUENCE7,168,BOOST_VMD_TYPE_SEQ));
 
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
