/* Copyright Nabil Alikhan. 2010.
 * This file is part of BLAST Ring Image Generator (BRIG).
 * BRIG is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * BRIG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *  along with BRIG.  If not, see <http://www.gnu.org/licenses/>.
 */

package brig;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import javax.swing.JOptionPane;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import org.jdom.Document;
import org.jdom.Element;
/**
 *
 * @author Nabil
 */
public class Options extends javax.swing.JFrame {

    /** Creates new form CGHeader */
    public Options() {
        initComponents();
        load();
        reverse.setVisible(false);
        reload();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jToggleButton2 = new javax.swing.JToggleButton();
        blastField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jTextField1 = new javax.swing.JTextField();
        emblField = new javax.swing.JTextField();
        spacerField = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        reverse = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel41 = new javax.swing.JLabel();
        dividerField = new javax.swing.JTextField();
        multiplierField = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        render = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        lowerField = new javax.swing.JTextField();
        upperField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        minimumField = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        selectedColourBox = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        jToggleButton1 = new javax.swing.JToggleButton();
        jButton1 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Configure BRIG options...");

        jToggleButton2.setText("Browse");
        jToggleButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton2ActionPerformed(evt);
            }
        });

        blastField.setText("bin/");

        jLabel1.setText("BLAST binary folder:");

        jLabel10.setText("EMBL file extensions:");

        jLabel9.setText("FASTA file extensions:");

        jLabel2.setText("Genbank file extensions:");

        jTextField2.setText("gbk");

        jTextField1.setText("fna,faa,fas");

        emblField.setText("embl");

        spacerField.setText("0");

        jLabel8.setText("Default spacer space:");

        reverse.setText("Use ring sequences as BLAST database");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel9)
                    .addComponent(jLabel10)
                    .addComponent(jLabel1)
                    .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(34, 34, 34)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(reverse)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(emblField, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextField1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 323, Short.MAX_VALUE)
                            .addComponent(jTextField2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 323, Short.MAX_VALUE))
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                            .addComponent(blastField, javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGap(18, 18, 18)
                            .addComponent(jToggleButton2)
                            .addGap(123, 123, 123)))
                    .addComponent(spacerField, javax.swing.GroupLayout.PREFERRED_SIZE, 118, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(29, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel9))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel10)
                    .addComponent(emblField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(blastField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jToggleButton2))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(spacerField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(reverse)
                .addContainerGap(61, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("BRIG settings", jPanel1);

        jLabel41.setText("Graph label thickness divider:");

        dividerField.setText("3");
        dividerField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dividerFieldActionPerformed(evt);
            }
        });

        multiplierField.setText("3");

        jLabel14.setText("Graph ring thickness multiplier:");

        jLabel3.setText("Image render memory (MB)");

        render.setText("1500");

        jLabel4.setText("Default upper threshold (%)");

        jLabel5.setText("Default lower threshold (%)");

        lowerField.setText("50");
        lowerField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lowerFieldActionPerformed(evt);
            }
        });

        upperField.setText("70");

        jLabel6.setText("Default min. threshold (%)");

        minimumField.setText("50");

        selectedColourBox.setBackground(new java.awt.Color(153, 102, 0));
        selectedColourBox.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout selectedColourBoxLayout = new javax.swing.GroupLayout(selectedColourBox);
        selectedColourBox.setLayout(selectedColourBoxLayout);
        selectedColourBoxLayout.setHorizontalGroup(
            selectedColourBoxLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 68, Short.MAX_VALUE)
        );
        selectedColourBoxLayout.setVerticalGroup(
            selectedColourBoxLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 28, Short.MAX_VALUE)
        );

        jButton2.setText("Choose colour");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Ring 1", "Ring 2", "Ring 3", "Ring 4", "Ring 5", "Ring 6", "Ring 7", "Ring 8", "Ring 9", "Ring 10" }));
        jComboBox1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox1ItemStateChanged(evt);
            }
        });

        jLabel7.setText("Default ring colour: ");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(selectedColourBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jButton2, javax.swing.GroupLayout.PREFERRED_SIZE, 116, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLabel7)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(55, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel7)
                .addGap(7, 7, 7)
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton2)
                    .addComponent(selectedColourBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel41)
                    .addComponent(jLabel3)
                    .addComponent(jLabel14)
                    .addComponent(jLabel4)
                    .addComponent(jLabel5)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(minimumField, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(multiplierField, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(dividerField, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(render, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(upperField, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(lowerField, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(164, 164, 164))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel41)
                            .addComponent(dividerField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(16, 16, 16)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel14)
                            .addComponent(multiplierField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(render, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel4)
                            .addComponent(upperField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel5)
                            .addComponent(lowerField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(minimumField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel6))
                        .addContainerGap())))
        );

        jTabbedPane1.addTab("Image settings", jPanel2);

        jToggleButton1.setText("Save & close");
        jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton1ActionPerformed(evt);
            }
        });

        jButton1.setText("Close");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton3.setText("Save settings as default");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 648, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButton3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jToggleButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButton1)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jToggleButton1)
                    .addComponent(jButton3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 326, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jToggleButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton1ActionPerformed
    save();
    }//GEN-LAST:event_jToggleButton1ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        dispose();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jToggleButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton2ActionPerformed
        final JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() != null) {
            try {
                blastField.setText( fc.getSelectedFile().toString() );
            }catch(Exception e){e.printStackTrace();}
        }
        
    }//GEN-LAST:event_jToggleButton2ActionPerformed

    private void lowerFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lowerFieldActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_lowerFieldActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        Element settings = BRIG.PROFILE.getRootElement().getChild("brig_settings");
        Color selected = Color.red;
        selected = JColorChooser.showDialog(this, "Choose Colour", selected);
        String col = selected.getRed() + "," + selected.getGreen() + "," + selected.getBlue();
        String ringName = jComboBox1.getSelectedItem().toString().replaceAll(" " , "");
        settings.setAttribute(ringName,  col  );
        reload();
}//GEN-LAST:event_jButton2ActionPerformed

    private void jComboBox1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox1ItemStateChanged
        reload();
    }//GEN-LAST:event_jComboBox1ItemStateChanged

    private void dividerFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dividerFieldActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_dividerFieldActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
               final JFileChooser fc = new JFileChooser();
            try {
                Document newProfile = BRIG.prepProfile(BRIG.PROFILE);
                int j = BRIG.saveXML("default-BRIG.xml", newProfile);
                if (j == 0) {
                    JOptionPane.showMessageDialog(this,
                            "Saved!",
                            "Saved!",
                            JOptionPane.INFORMATION_MESSAGE);
                }else{
                    JOptionPane.showMessageDialog(this,
                            "Could not save settings",
                            "Error!",
                            JOptionPane.ERROR);
                }
            } catch (Exception e) {
                    JOptionPane.showMessageDialog(this,
                            "Could not save settings",
                            "Error!",
                            JOptionPane.ERROR);
            }        
    }//GEN-LAST:event_jButton3ActionPerformed

    private void reload(){
        Element settings = BRIG.PROFILE.getRootElement().getChild("brig_settings");
        String ringName = jComboBox1.getSelectedItem().toString().replaceAll(" " , "");
        if(BRIG.PROFILE.getRootElement().getAttribute("reverseDb") != null ){
            reverse.setSelected(true);
        }else{
            reverse.setSelected(false);
        }
        if (settings == null ){
            settings = new Element("brig_settings");
            BRIG.PROFILE.getRootElement().addContent(settings);
        }
            String col = settings.getAttributeValue(ringName);
            if (col == null) {
                col = "225,0,0";
            }
            String[] tabArray = col.split(",");
            Color change = new Color(Integer.parseInt(tabArray[0]), Integer.parseInt(tabArray[1]), Integer.parseInt(tabArray[2]));
            selectedColourBox.setBackground(change);
BRIG.dumpXML("errorlog.xml",BRIG.PROFILE);

    }
    private  void save(){
        int error =0;
        String errorText = "";
        if(!isInt( dividerField.getText() ) ){
            error++;
            errorText = "Divider is not a valid integer\n";
        }
        if(!isInt( multiplierField.getText() ) ){
            error++;
            errorText = "Multiplier is not a valid integer\n";
        }
        if(!isInt( upperField.getText() ) ){
            error++;
            errorText = "Upper threshold is not a valid integer\n";
        }
        if(!isInt( lowerField.getText() ) ){
            error++;
            errorText = "Lower threshold is not a valid integer\n";
        }
        if(!isInt( spacerField.getText() ) ){
            error++;
            errorText = "Spacer value is not a valid integer\n";
        }
        if(!isInt( minimumField.getText() ) ){
            error++;
            errorText = "Minimum threshold is not a valid integer\n";
        }else{
            if(isInt( lowerField.getText() ) && isInt( upperField.getText() ) ){
                if(Integer.parseInt(minimumField.getText()) > Integer.parseInt(lowerField.getText()) ||
                        Integer.parseInt(minimumField.getText()) > Integer.parseInt(upperField.getText())){
                    error++;
                    errorText = "Minimum threshold is greater than other thresholds\n";
                }
            }
        }
        if ( reverse.isSelected() ){
            // Removinh reverseDb functionality.
            //Main.PROFILE.getRootElement().setAttribute("reverseDb", "true");
            BRIG.PROFILE.getRootElement().removeAttribute("reverseDb");
        }else{
            BRIG.PROFILE.getRootElement().removeAttribute("reverseDb");
        }
        File bro = new File(blastField.getText());
        if(!bro.isDirectory() && blastField.getText().compareTo("") != 0){
            error++;
            errorText = "Blast location is not a valid directory\n";
        }
        if(error > 0){
         errorText = "There are " + error + " errror(s):\n" +errorText;
            JOptionPane.showMessageDialog(this,
            errorText,
            "ERROR!",
         JOptionPane.ERROR_MESSAGE);
        }else{
            try{
               if (BRIG.PROFILE.getRootElement().getChild("brig_settings") == null) {
                   Element noo = new Element("brig_settings");
                   BRIG.PROFILE.getRootElement().addContent(noo);
               }
               Element settings = BRIG.PROFILE.getRootElement().getChild("brig_settings");
               settings.setAttribute("defaultUpper", upperField.getText());
               settings.setAttribute("defaultLower", lowerField.getText());
               settings.setAttribute("defaultMinimum", minimumField.getText());
               settings.setAttribute("genbankFiles", jTextField2.getText());
               settings.setAttribute("fastaFiles", jTextField1.getText());
               settings.setAttribute("emblFiles", emblField.getText());
               settings.setAttribute("blastLocation", blastField.getText());
               settings.setAttribute("divider",dividerField.getText());
               settings.setAttribute("multiplier",multiplierField.getText());
               settings.setAttribute("memory",render.getText());
               settings.setAttribute("defaultSpacer",spacerField.getText());
                this.dispose();
            }catch(Exception e){
                JOptionPane.showMessageDialog(this,
                    "Could not save settings:\n" + e.getMessage(),
                    "ERROR!",
                    JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    private void load() {
        if (BRIG.PROFILE.getRootElement().getChild("brig_settings") != null) {
            Element settings = BRIG.PROFILE.getRootElement().getChild("brig_settings");
            if (settings.getAttributeValue("defaultMinimum") != null) {
                minimumField.setText(settings.getAttributeValue("defaultMinimum"));
            }
            if (settings.getAttributeValue("genbankFiles") != null) {
                jTextField2.setText(settings.getAttributeValue("genbankFiles"));
            }
            if (settings.getAttributeValue("fastaFiles") != null) {
                jTextField1.setText(settings.getAttributeValue("fastaFiles"));
            }
            if (settings.getAttributeValue("emblFiles") != null) {
                emblField.setText(settings.getAttributeValue("emblFiles"));
            }
            if (settings.getAttributeValue("blastLocation") != null) {
                blastField.setText(settings.getAttributeValue("blastLocation"));
            }
            if (settings.getAttributeValue("divider") != null) {
                dividerField.setText(settings.getAttributeValue("divider"));
            }
            if (settings.getAttributeValue("multiplier") != null) {
                multiplierField.setText(settings.getAttributeValue("multiplier"));
            }
            if (settings.getAttributeValue("memory") != null) {
                render.setText(settings.getAttributeValue("memory"));
            }
            if (settings.getAttributeValue("defaultUpper") != null) {
                upperField.setText(settings.getAttributeValue("defaultUpper"));
            }
            if (settings.getAttributeValue("defaultLower") != null) {
                lowerField.setText(settings.getAttributeValue("defaultLower"));
            }
            if (settings.getAttributeValue("defaultSpacer") != null) {
                spacerField.setText(settings.getAttributeValue("defaultSpacer"));
            }
        }
    }


    private boolean isInt(String in){
    try{
        Integer.parseInt(in);
        return true;
        }catch(NumberFormatException e){
            return false;
        }
    }
    private boolean isDouble(String in){
    try{
        Double.parseDouble(in);
        return true;
        }catch(NumberFormatException e){
            return false;
        }
    }
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CGHeader().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField blastField;
    private javax.swing.JTextField dividerField;
    private javax.swing.JTextField emblField;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToggleButton jToggleButton2;
    private javax.swing.JTextField lowerField;
    private javax.swing.JTextField minimumField;
    private javax.swing.JTextField multiplierField;
    private javax.swing.JTextField render;
    private javax.swing.JCheckBox reverse;
    private javax.swing.JPanel selectedColourBox;
    private javax.swing.JTextField spacerField;
    private javax.swing.JTextField upperField;
    // End of variables declaration//GEN-END:variables

}
