/*  
 *  The Janocchio program is (C) 2007 Eli Lilly and Co.
 *  Authors: David Evans and Gary Sharman
 *  Contact : janocchio-users@lists.sourceforge.net.
 * 
 *  It is derived in part from Jmol 
 *  (C) 2002-2006 The Jmol Development Team
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *  All we ask is that proper credit is given for our work, which includes
 *  - but is not limited to - adding the above copyright notice to the beginning
 *  of your source code files, and to any copyright notice that you may distribute
 *  with programs based on this work.
 *
 *  This program is distributed in the hope that it will be useful, on an 'as is' basis,
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.openscience.jmol.app.janocchio;

import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;

public class NoeParameterSelectionPanel extends JPanel {
  NoeTable noeTable;

  public NoeParameterSelectionPanel(NoeTable noeTable) {
    this.noeTable = noeTable;
    initComponents();
    freqField.setText(String.valueOf(noeTable.getNMRfreq()));
    tauField.setText(String.valueOf(noeTable.getCorrelationTime()));
    tMixField.setText(String.valueOf(noeTable.getMixingTime()));
    cutoffField.setText(String.valueOf(noeTable.getCutoff()));
    rhoStarField.setText(String.valueOf(noeTable.getRhoStar()));

    freqField.setHorizontalAlignment(SwingConstants.RIGHT);
    tauField.setHorizontalAlignment(SwingConstants.RIGHT);
    tMixField.setHorizontalAlignment(SwingConstants.RIGHT);
    cutoffField.setHorizontalAlignment(SwingConstants.RIGHT);
    rhoStarField.setHorizontalAlignment(SwingConstants.RIGHT);

  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
  void initComponents() {
    freqLabel = new JLabel();
    freqField = new JTextField();
    tMixLabel = new JLabel();
    tMixField = new JTextField();
    tauLabel = new JLabel();
    tauField = new JTextField();
    cutoffLabel = new JLabel();
    cutoffField = new JTextField();
    rhoStarLabel = new JLabel();
    rhoStarField = new JTextField();
    setAllButton = new JButton();
    titleLabel = new JLabel();
    noesyLabel = new JLabel();
    noesyComboBox = new JComboBox<String>();
    refSingleLabel = new JLabel();
    refSingleComboBox = new JComboBox<String>();

    freqLabel.setText("Spectrometer Frequency/MHz");

    freqField.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        freqFieldActionPerformed(evt);
      }
    });

    tMixLabel.setText("Mixing Time/s");

    tMixField.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        tMixFieldActionPerformed(evt);
      }
    });

    tauLabel.setText("Correlation Time/ps");

    tauField.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        tauFieldActionPerformed(evt);
      }
    });

    cutoffLabel.setText("Spin-pair cutoff/A");

    cutoffField.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cutoffFieldActionPerformed(evt);
      }
    });

    rhoStarLabel.setText("Constant relaxation term/s-1");

    rhoStarField.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        rhoStarFieldActionPerformed(evt);
      }
    });

    setAllButton.setText("Set All");
    setAllButton.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        setAllButtonActionPerformed(evt);
      }
    });

    titleLabel.setText("Parameters for NOE Calculation");

    noesyLabel.setText("NOESY or ROESY");

    noesyComboBox.setModel(new DefaultComboBoxModel<String>(new String[] {
        "NOESY", "ROESY" }));
    noesyComboBox.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        noesyComboBoxActionPerformed(evt);
      }
    });

    refSingleLabel.setText("Normalisation");

    refSingleComboBox.setModel(new DefaultComboBoxModel<String>(new String[] {
        "Single", "Diag" }));
    refSingleComboBox.addActionListener(new java.awt.event.ActionListener() {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        refSingleComboBoxActionPerformed(evt);
      }
    });

    GroupLayout layout = new GroupLayout(this);
    this.setLayout(layout);
    layout
        .setHorizontalGroup(layout
            .createParallelGroup(Alignment.LEADING)
            .addGroup(
                Alignment.TRAILING,
                layout
                    .createSequentialGroup()
                    .addGroup(
                        layout
                            .createParallelGroup(Alignment.TRAILING)
                            .addGroup(
                                layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(setAllButton))
                            .addGroup(
                                layout
                                    .createParallelGroup(Alignment.LEADING)
                                    .addGroup(
                                        layout.createSequentialGroup()
                                            .addGap(35, 35, 35)
                                            .addComponent(titleLabel))
                                    .addGroup(
                                        layout
                                            .createSequentialGroup()
                                            .addContainerGap()
                                            .addGroup(
                                                layout
                                                    .createParallelGroup(
                                                        Alignment.LEADING)
                                                    .addGroup(
                                                        layout
                                                            .createSequentialGroup()
                                                            .addGroup(
                                                                layout
                                                                    .createParallelGroup(
                                                                        Alignment.LEADING)
                                                                    .addGroup(
                                                                        layout
                                                                            .createSequentialGroup()
                                                                            .addGroup(
                                                                                layout
                                                                                    .createParallelGroup(
                                                                                        Alignment.LEADING)
                                                                                    .addComponent(
                                                                                        cutoffLabel)
                                                                                    .addComponent(
                                                                                        freqLabel)
                                                                                    .addComponent(
                                                                                        tMixLabel)
                                                                                    .addComponent(
                                                                                        tauLabel))
                                                                            .addGap(
                                                                                18,
                                                                                18,
                                                                                18))
                                                                    .addGroup(
                                                                        layout
                                                                            .createSequentialGroup()
                                                                            .addComponent(
                                                                                noesyLabel,
                                                                                GroupLayout.DEFAULT_SIZE,
                                                                                195,
                                                                                Short.MAX_VALUE)
                                                                            .addPreferredGap(
                                                                                ComponentPlacement.RELATED)))
                                                            .addGroup(
                                                                layout
                                                                    .createParallelGroup(
                                                                        Alignment.TRAILING)
                                                                    .addGroup(
                                                                        layout
                                                                            .createParallelGroup(
                                                                                Alignment.TRAILING,
                                                                                false)
                                                                            .addComponent(
                                                                                tauField,
                                                                                Alignment.LEADING)
                                                                            .addComponent(
                                                                                tMixField,
                                                                                Alignment.LEADING)
                                                                            .addComponent(
                                                                                freqField,
                                                                                GroupLayout.DEFAULT_SIZE,
                                                                                61,
                                                                                Short.MAX_VALUE)
                                                                            .addComponent(
                                                                                cutoffField)
                                                                            .addComponent(
                                                                                rhoStarField,
                                                                                Alignment.LEADING))
                                                                    .addComponent(
                                                                        noesyComboBox,
                                                                        GroupLayout.PREFERRED_SIZE,
                                                                        GroupLayout.DEFAULT_SIZE,
                                                                        GroupLayout.PREFERRED_SIZE)))
                                                    .addGroup(
                                                        layout
                                                            .createSequentialGroup()
                                                            .addComponent(
                                                                rhoStarLabel,
                                                                GroupLayout.DEFAULT_SIZE,
                                                                276,
                                                                Short.MAX_VALUE)
                                                            .addPreferredGap(
                                                                ComponentPlacement.RELATED))))
                                    .addGroup(
                                        Alignment.TRAILING,
                                        layout
                                            .createSequentialGroup()
                                            .addContainerGap()
                                            .addComponent(refSingleLabel)
                                            .addPreferredGap(
                                                ComponentPlacement.RELATED,
                                                119, Short.MAX_VALUE)
                                            .addComponent(refSingleComboBox,
                                                GroupLayout.PREFERRED_SIZE, 69,
                                                GroupLayout.PREFERRED_SIZE))))
                    .addContainerGap()));
    layout.setVerticalGroup(layout.createParallelGroup(Alignment.LEADING)
        .addGroup(
            layout
                .createSequentialGroup()
                .addComponent(titleLabel, GroupLayout.PREFERRED_SIZE, 24,
                    GroupLayout.PREFERRED_SIZE)
                .addGap(15, 15, 15)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(freqLabel)
                        .addComponent(freqField, GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(tMixLabel)
                        .addComponent(tMixField, GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(tauLabel, GroupLayout.PREFERRED_SIZE, 23,
                            GroupLayout.PREFERRED_SIZE)
                        .addComponent(tauField, GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(cutoffField, GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE)
                        .addComponent(cutoffLabel))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(rhoStarLabel)
                        .addComponent(rhoStarField, GroupLayout.PREFERRED_SIZE,
                            19, GroupLayout.PREFERRED_SIZE))
                .addGap(8, 8, 8)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(noesyComboBox,
                            GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE)
                        .addComponent(noesyLabel))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(
                    layout
                        .createParallelGroup(Alignment.BASELINE)
                        .addComponent(refSingleComboBox,
                            GroupLayout.PREFERRED_SIZE,
                            GroupLayout.DEFAULT_SIZE,
                            GroupLayout.PREFERRED_SIZE)
                        .addComponent(refSingleLabel))
                .addPreferredGap(ComponentPlacement.RELATED, 66,
                    Short.MAX_VALUE).addComponent(setAllButton)
                .addContainerGap()));
  }

  /**
   * @param evt
   */
  void refSingleComboBoxActionPerformed(java.awt.event.ActionEvent evt) {
    String sel = (String) refSingleComboBox.getSelectedItem();
    if (sel.equals("Single")) {
      noeTable.setlrefSingle(true);
    } else {
      noeTable.setlrefSingle(false);
    }
  }

  /**
   * @param evt
   */
  void noesyComboBoxActionPerformed(java.awt.event.ActionEvent evt) {
    String sel = (String) noesyComboBox.getSelectedItem();
    if (sel.equals("NOESY")) {
      noeTable.setNoesy(true);
    } else {
      noeTable.setNoesy(false);
    }
  }

  void setAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setAllButtonActionPerformed
    rhoStarFieldActionPerformed(evt);
    cutoffFieldActionPerformed(evt);
    tauFieldActionPerformed(evt);
    tMixFieldActionPerformed(evt);
    freqFieldActionPerformed(evt);
    noesyComboBoxActionPerformed(evt);
    refSingleComboBoxActionPerformed(evt);
  }

  /**
   * @param evt
   */
  void rhoStarFieldActionPerformed(java.awt.event.ActionEvent evt) {
    String text = rhoStarField.getText();
    noeTable.setRhoStar(Double.parseDouble(text));
    rhoStarField.setText(String.valueOf(noeTable.getRhoStar()));
  }

  /**
   * @param evt
   */
  void cutoffFieldActionPerformed(java.awt.event.ActionEvent evt) {
    String text = cutoffField.getText();
    noeTable.setCutoff(Double.parseDouble(text));
    cutoffField.setText(String.valueOf(noeTable.getCutoff()));
  }

  /**
   * @param evt
   */
  void tauFieldActionPerformed(java.awt.event.ActionEvent evt) {
    String text = tauField.getText();
    noeTable.setCorrelationTime(Double.parseDouble(text));
    tauField.setText(String.valueOf(noeTable.getCorrelationTime()));
  }

  /**
   * @param evt
   */
  void tMixFieldActionPerformed(java.awt.event.ActionEvent evt) {
    String text = tMixField.getText();
    noeTable.setMixingTime(Double.parseDouble(text));
    tMixField.setText(String.valueOf(noeTable.getMixingTime()));
  }

  /**
   * @param evt
   */
  void freqFieldActionPerformed(java.awt.event.ActionEvent evt) {
    String text = freqField.getText();
    noeTable.setNMRfreq(Double.parseDouble(text));
    freqField.setText(String.valueOf(noeTable.getNMRfreq()));
  }

  public JTextField getRhoStarField() {
    return rhoStarField;
  }

  public JTextField getCutoffField() {
    return cutoffField;
  }

  public JTextField getTauField() {
    return tauField;
  }

  public JTextField gettMixField() {
    return tMixField;
  }

  public JTextField getFreqField() {
    return freqField;
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  JTextField cutoffField;
  JLabel cutoffLabel;
  JTextField freqField;
  JLabel freqLabel;
  JComboBox<String> noesyComboBox;
  JLabel noesyLabel;
  JComboBox<String> refSingleComboBox;
  JLabel refSingleLabel;
  JTextField rhoStarField;
  JLabel rhoStarLabel;
  JButton setAllButton;
  JTextField tMixField;
  JLabel tMixLabel;
  JTextField tauField;
  JLabel tauLabel;
  JLabel titleLabel;
  // End of variables declaration//GEN-END:variables

}
