/* ----- encode/857x5167, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857x5167_checksums[] = {
  "3bc06d9dfd4200ecfb99af82babaeb6f536f7bf947ccd4b9624e5adeeef68cd6",
  "6761bf59312ec4ed003d0e17a39f234aefcd57e38dba5018eaafb2051b9c7ae0",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857x5167_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857x5167_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857x5167_ITEMBYTES

static void *storage_encode_857x5167_s;
static unsigned char *test_encode_857x5167_s;
static void *storage_encode_857x5167_x;
static unsigned char *test_encode_857x5167_x;
static void *storage_encode_857x5167_s2;
static unsigned char *test_encode_857x5167_s2;
static void *storage_encode_857x5167_x2;
static unsigned char *test_encode_857x5167_x2;

#define precomputed_encode_857x5167_NUM 4

static const unsigned char precomputed_encode_857x5167_s[precomputed_encode_857x5167_NUM][crypto_encode_STRBYTES] = {
  {105,50,41,84,95,89,68,19,137,228,172,136,53,165,176,176,152,139,228,183,228,141,246,25,218,136,34,47,12,126,214,149,219,216,147,48,185,186,23,131,177,224,109,156,178,211,195,221,142,108,88,88,149,248,88,156,54,153,182,162,27,49,65,73,102,149,229,95,31,221,140,102,18,75,157,212,12,50,116,147,82,102,186,119,9,191,169,115,98,61,5,201,9,172,182,132,17,149,234,117,85,159,42,229,208,41,38,126,103,144,253,143,183,243,219,40,116,191,135,93,184,204,58,87,188,37,66,78,63,137,104,173,110,240,83,123,121,28,175,253,124,83,127,2,80,249,196,85,144,56,208,87,153,53,162,48,171,56,152,162,7,0,9,111,118,110,193,155,106,243,236,2,217,199,52,150,8,71,141,214,150,173,61,179,8,10,184,227,179,124,173,172,177,186,15,153,5,135,66,176,148,126,186,122,168,85,73,199,26,152,154,95,124,161,230,134,250,28,226,171,248,219,171,69,249,90,84,68,86,213,50,70,183,244,81,254,159,115,215,7,253,86,208,171,177,169,81,113,169,170,67,120,0,232,86,224,221,0,184,250,216,91,54,254,211,40,94,126,10,197,41,169,25,13,76,62,197,88,252,172,225,84,5,37,154,51,148,234,143,113,68,219,100,15,143,142,56,236,126,245,238,71,40,6,203,233,213,62,121,225,252,39,199,213,100,165,25,61,191,120,211,4,46,130,155,90,40,20,97,215,173,216,161,179,246,19,144,203,111,137,166,234,151,215,23,8,146,98,144,146,178,249,219,140,206,213,201,77,145,183,189,28,64,89,47,241,39,71,227,35,249,5,177,189,53,220,175,197,148,118,154,138,138,74,211,168,238,173,62,162,186,126,37,5,117,28,75,124,177,187,223,139,76,89,46,37,174,217,145,114,56,34,60,56,16,147,155,25,130,168,209,233,16,237,177,153,41,30,240,54,7,238,90,136,129,221,185,53,62,105,205,238,108,247,132,67,77,230,154,208,77,48,121,35,95,236,58,57,79,244,191,202,62,195,120,4,213,229,250,33,53,187,145,112,142,193,34,69,214,53,101,128,177,28,96,98,210,149,161,232,104,247,161,138,117,66,153,172,141,22,189,63,93,57,233,56,145,7,188,244,163,49,5,26,112,56,168,106,248,98,35,114,240,168,33,129,128,133,57,220,253,203,243,169,65,242,196,101,5,92,89,114,178,73,62,218,223,161,231,215,125,1,81,34,66,8,198,175,56,210,190,216,199,243,27,113,21,36,216,86,233,111,245,30,55,60,121,139,2,133,16,39,199,118,212,198,167,0,77,124,238,113,198,29,228,108,18,243,166,206,245,156,130,179,35,255,67,210,5,9,122,100,113,253,162,56,143,237,191,65,176,47,16,47,244,55,239,102,104,35,93,140,255,109,236,174,144,105,138,109,116,143,61,161,187,213,49,70,86,4,83,45,5,213,244,122,228,195,232,232,114,62,101,37,67,115,95,133,196,95,19,68,133,191,107,82,145,76,119,33,152,199,85,117,237,92,100,30,255,92,239,98,110,52,27,47,165,227,58,155,86,38,105,28,132,115,181,28,102,117,106,254,67,215,52,160,236,63,21,95,234,137,167,195,178,165,67,80,75,84,231,156,81,198,82,135,233,71,196,152,50,46,120,150,163,121,190,42,48,176,206,91,46,148,115,17,200,49,132,74,203,5,77,178,255,251,54,74,167,193,135,230,72,111,2,197,217,82,223,234,221,199,254,92,246,189,253,233,173,194,210,76,31,34,145,213,150,234,235,111,222,115,176,131,251,159,58,130,161,51,135,102,59,62,153,218,107,41,244,29,215,241,74,212,33,223,132,235,7,117,209,218,169,135,245,133,184,115,130,18,69,1,139,130,149,67,66,167,5,197,45,209,130,99,99,69,42,253,101,201,78,57,216,172,45,125,203,134,187,13,61,5,244,147,136,112,206,226,224,240,92,106,199,165,91,18,58,180,70,88,239,247,100,211,243,201,234,254,138,94,113,236,175,173,194,6,187,85,162,53,4,161,240,245,232,224,29,214,1,40,131,27,196,189,239,177,255,86,58,240,81,42,226,157,104,118,59,40,204,75,246,110,42,106,244,168,162,89,108,159,17,5,190,93,231,119,134,138,145,224,102,213,241,182,68,107,37,215,65,73,222,8,122,36,130,122,77,83,225,114,247,205,129,241,169,102,193,177,49,123,159,124,17,119,186,25,73,16,50,199,76,69,186,200,229,96,223,88,68,93,164,72,91,46,146,116,21,23,45,119,142,0,208,144,217,116,172,53,80,73,249,227,46,156,206,217,186,174,234,9,224,167,49,212,77,209,101,147,88,11,52,86,247,104,106,88,238,149,180,124,139,161,85,14,109,126,104,160,68,56,212,81,241,221,112,172,30,249,229,162,145,27,95,47,221,24,8,134,176,143,21,53,150,21,129,243,214,81,88,104,21,102,167,43,144,50,218,99,18,218,176,177,30,130,217,37,164,36,2,90,59,174,212,213,11,125,68,98,200,77,84,204,37,104,163,91,18,166,70,114,160,158,246,208,187,62,107,246,53,12,99,197,29,1,86,194,96,51,186,155,142,25,240,39,103,112,19,170,194,157,84,181,63,40,1,149,37,209,1,56,154,33,54,219,109,114,191,118,91,100,243,139,251,116,246,151,67,241,206,171,128,145,122,163,50,13,21,63,15,136,131,100,34,82,251,74,32,201,1,118,173,173,15,143,146,214,10,211,35,19,87,74,72,180,194,241,214,27,97,13,171,212,172,241,174,159,67,99,221,47,222,200,211,252,144,107,19,76,191,155,168,5,162,180,37,140,11,122,110,191,50,80,235,153,29,54,185,82,169,104,47,199,228,228,201,248,159,37,252,205,182,122,19,242,9,101,101,141,22,149,129,237,115,139,150,125,186,74,196,71,193,63,237,212,159,137,3,114,153,73,50,44},
  {253,16,69,88,212,112,126,109,90,36,175,177,91,153,238,201,161,136,107,64,178,237,30,101,4,254,21,63,90,163,105,219,170,33,242,83,21,23,27,237,199,235,186,174,109,236,34,187,72,40,220,89,82,222,53,123,243,96,143,235,37,80,170,249,5,210,74,36,100,41,124,96,90,154,179,142,142,179,213,21,193,94,25,235,135,86,227,243,247,196,156,167,223,251,46,79,219,69,230,108,197,143,156,25,18,46,221,2,99,80,72,38,48,160,81,115,131,248,172,155,205,140,235,249,245,46,205,82,209,152,237,125,72,7,41,255,3,238,218,3,58,188,22,241,144,13,196,146,115,166,4,182,220,188,223,189,179,7,41,27,240,3,7,171,58,92,103,14,31,112,83,14,131,175,108,36,42,30,160,41,10,174,40,60,2,243,215,181,152,180,190,200,233,70,139,222,61,156,53,8,239,157,128,26,63,190,72,172,69,137,75,223,19,167,141,150,169,193,212,188,183,226,241,12,157,173,235,135,23,128,178,170,162,112,13,186,133,117,13,203,162,111,192,53,173,138,201,169,86,34,133,50,226,66,74,79,141,209,239,84,153,108,148,176,186,167,237,190,61,238,4,251,6,91,201,148,138,227,182,23,204,228,229,9,163,154,143,241,213,34,31,208,172,182,144,157,194,103,63,40,146,21,235,73,214,247,225,236,117,236,209,246,24,110,219,148,81,217,149,98,239,219,198,58,202,180,95,181,86,206,80,210,241,79,229,143,35,150,66,114,142,138,243,192,128,246,10,137,66,100,106,174,81,223,164,108,14,124,112,83,84,79,111,207,18,125,179,16,235,175,236,66,149,26,99,119,135,114,40,50,168,242,125,56,70,204,184,179,148,135,86,49,48,149,165,22,166,213,109,99,211,45,41,2,164,182,245,202,55,208,101,90,180,109,12,168,47,155,211,191,164,74,154,242,235,253,192,251,237,34,193,26,99,233,230,60,10,104,215,3,75,186,23,113,47,134,80,14,114,36,46,211,241,74,163,58,240,175,193,59,178,3,22,101,21,104,107,81,10,154,12,222,49,82,24,124,89,219,201,242,246,160,199,48,219,44,206,79,32,249,179,167,197,165,210,7,190,186,210,103,252,14,14,26,108,244,12,31,75,81,144,112,215,74,228,121,121,26,250,60,154,141,83,193,199,184,129,4,242,148,160,101,195,210,248,98,233,129,88,141,45,102,107,174,5,108,154,133,254,109,181,109,250,233,58,165,67,54,120,167,20,222,173,135,49,91,109,226,84,213,228,29,3,54,104,50,203,211,2,114,166,166,32,109,36,50,41,222,207,131,158,122,216,234,33,0,254,176,73,208,45,211,253,235,58,78,66,74,188,166,198,55,237,86,196,211,124,27,238,187,200,174,223,30,56,242,138,115,67,187,148,172,235,36,69,148,134,7,192,158,223,128,51,155,230,243,84,23,9,142,162,215,25,46,68,23,154,149,90,250,229,114,170,222,232,190,228,39,182,159,53,112,49,195,140,244,164,235,43,17,132,218,23,12,69,216,217,124,133,8,161,202,140,15,72,20,12,223,210,200,62,56,132,209,78,30,144,228,56,129,96,120,194,14,114,249,123,32,113,197,140,78,72,173,154,152,72,115,18,172,151,219,118,20,217,44,41,180,231,174,52,12,147,222,241,80,52,122,193,168,111,188,69,192,96,85,60,201,70,118,66,49,36,234,72,211,226,103,136,79,241,137,204,143,139,194,39,222,137,114,207,14,243,223,241,129,35,132,58,240,25,103,64,246,50,78,15,73,26,253,222,38,61,95,23,126,56,103,86,200,109,163,161,61,43,148,94,207,11,124,143,217,58,88,241,85,173,19,68,252,82,46,221,21,27,233,225,23,51,137,231,184,186,11,233,65,69,55,81,139,195,151,250,50,139,132,158,230,100,108,184,41,169,117,83,202,148,66,196,61,185,206,69,164,151,151,153,107,210,254,206,1,161,228,83,37,113,3,39,117,241,206,187,83,101,114,180,79,47,49,232,58,76,217,96,234,15,173,245,18,152,97,117,136,177,128,208,110,255,24,185,58,255,84,175,159,153,61,196,160,197,242,229,223,106,9,124,241,83,100,123,136,86,28,251,12,106,69,224,49,55,46,68,67,190,42,143,238,166,215,232,96,195,80,226,95,151,168,223,243,46,88,69,202,228,236,108,99,41,198,243,116,141,192,178,67,64,197,52,53,96,208,70,218,175,112,216,102,240,223,207,145,226,121,152,198,100,66,210,202,56,227,139,244,244,207,33,180,186,160,27,124,18,27,84,150,250,239,185,27,5,148,34,187,232,246,107,173,33,178,167,238,62,48,136,165,91,198,87,50,211,171,101,215,134,23,190,229,219,25,181,21,246,210,203,118,178,143,36,192,100,5,245,244,169,191,31,209,254,254,26,99,204,67,219,6,227,6,186,214,28,22,114,26,125,130,151,210,154,28,240,136,219,14,70,5,114,21,226,60,151,73,91,132,209,162,69,97,51,70,129,251,84,81,245,251,165,102,159,8,190,249,66,195,10,170,115,96,97,214,161,197,85,74,29,63,199,212,136,253,56,64,162,61,14,91,161,174,81,1,231,86,112,156,177,127,4,122,5,12,28,66,160,28,149,239,132,90,2,67,89,150,87,155,237,83,109,0,105,24,86,218,61,184,61,247,3,130,167,224,6,137,239,82,113,17,53,19,245,60,226,125,39,5,38,54,85,218,150,35,189,106,204,23,77,78,126,30,32,146,76,52,176,66,139,49,210,65,217,195,16,148,3,11,61,182,36,156,27,28,21,255,228,205,78,54,221,177,8,207,59,153,168,96,93,26,69,44,61,185,133,228,41,60,58,111,17,241,174,201,152,102,100,74,115,38,8,167,237,43,9,190,130,53,13,161,42,37,115,38,182,103,88,145,96,109,104,40,48,227,220,121,241,23,132,76,15,134,134,76,216,48},
  {53,92,20,244,25,25,109,91,11,78,131,200,82,210,63,86,213,148,233,152,148,20,128,194,29,224,143,242,8,234,127,241,218,19,10,16,114,66,130,155,45,34,172,53,97,114,76,124,70,201,143,169,36,190,185,189,57,104,213,107,23,29,31,1,91,49,204,154,82,119,197,129,42,200,190,16,84,230,115,61,93,19,116,138,236,8,200,15,91,189,75,149,96,187,14,221,186,225,238,131,176,40,136,246,122,205,95,42,110,178,147,183,215,202,111,82,138,70,132,76,214,15,151,227,229,101,133,30,116,156,127,37,187,147,124,191,188,7,3,212,225,74,160,185,249,109,91,20,143,21,134,61,65,216,114,41,100,8,170,102,52,157,99,222,244,202,53,191,128,178,1,197,27,149,220,44,250,195,183,77,50,14,242,220,16,226,174,238,169,37,216,74,24,36,131,70,192,168,211,98,132,40,236,226,201,71,191,59,17,209,40,185,160,255,161,177,66,5,154,19,7,41,59,159,24,60,140,139,115,96,253,123,246,84,221,128,162,241,83,3,149,27,37,70,171,37,247,186,57,240,235,166,181,67,179,4,187,163,47,57,125,39,182,93,6,173,34,29,12,30,7,82,212,113,9,130,237,154,25,214,64,128,5,136,202,44,171,124,147,101,30,89,91,32,6,225,167,158,158,201,216,201,19,130,68,134,189,212,85,154,9,222,107,179,230,8,118,168,240,207,112,94,200,79,143,98,165,126,83,104,194,232,109,132,221,31,148,89,20,203,182,192,78,53,43,184,212,197,209,242,126,98,159,23,103,173,135,52,222,59,203,69,195,44,190,14,96,243,133,207,113,156,113,53,104,178,170,93,96,38,94,61,217,52,239,163,195,239,224,162,191,147,230,65,95,246,124,149,235,199,204,207,123,64,33,155,36,162,12,11,9,177,168,151,160,100,86,152,241,20,72,123,242,128,48,204,175,69,194,73,78,23,234,129,122,122,139,166,216,192,109,4,162,247,72,222,0,128,97,8,154,65,44,182,202,179,150,246,194,99,148,87,113,70,4,112,1,7,84,33,117,172,92,206,64,161,138,251,244,92,28,175,24,181,51,229,64,232,173,196,107,173,198,183,210,203,57,117,203,182,63,110,210,215,173,188,226,98,48,169,49,168,58,146,232,250,6,114,192,146,23,96,100,234,6,26,113,201,245,175,87,233,174,106,57,224,43,6,252,63,151,38,224,180,207,131,150,111,26,110,111,99,138,216,32,227,26,174,179,118,132,101,187,170,99,8,177,73,24,198,97,204,121,187,66,207,136,110,3,41,53,64,116,155,68,233,190,126,51,129,126,77,113,71,69,196,83,171,238,99,63,173,226,55,61,233,7,123,58,78,156,123,44,29,120,18,55,205,60,170,28,53,220,69,247,136,246,203,51,255,107,230,234,42,106,200,2,141,200,81,179,59,48,165,195,244,10,190,250,65,158,134,157,153,147,49,21,105,205,110,50,193,38,131,82,86,31,29,140,185,153,60,203,52,203,169,107,103,21,52,193,69,190,61,175,72,7,170,173,235,169,239,234,184,89,220,93,250,79,110,177,122,157,116,244,188,158,209,219,85,73,2,114,249,98,137,185,217,116,148,111,0,20,194,34,129,131,169,46,200,24,23,181,81,23,4,248,33,11,200,149,49,250,135,9,237,114,255,248,201,131,157,52,169,244,214,18,45,84,135,119,185,63,69,195,109,108,243,11,86,182,130,54,42,47,144,209,117,107,244,241,35,185,181,229,204,132,174,204,221,60,130,155,62,218,160,146,130,212,236,169,106,235,0,121,32,62,155,68,71,235,215,28,222,106,209,16,82,33,30,65,40,89,25,119,130,26,81,26,91,214,94,192,200,116,151,45,242,218,191,198,173,193,27,31,66,182,247,113,78,44,140,224,38,143,12,186,163,157,174,88,119,246,30,18,198,186,204,177,67,53,132,21,243,229,29,249,136,248,162,174,194,136,179,197,189,62,102,24,184,20,231,100,29,243,165,8,199,233,144,44,145,179,118,64,139,38,136,24,146,62,201,238,170,205,185,222,158,120,203,23,138,236,169,226,25,87,35,13,11,199,233,227,47,244,111,204,226,218,37,106,132,54,52,161,182,240,83,154,49,177,191,33,29,174,82,175,40,24,200,210,65,85,202,116,150,42,10,76,248,230,145,146,161,209,132,113,152,108,217,33,2,181,206,251,41,232,172,128,106,21,150,195,33,49,139,186,4,100,30,165,240,52,165,36,31,135,237,83,88,52,242,169,136,88,113,175,174,212,138,168,57,70,72,137,187,225,153,54,206,29,115,174,253,42,0,57,247,22,245,232,186,243,155,77,98,20,166,14,29,135,209,151,4,191,151,40,182,54,110,153,111,95,218,45,25,90,191,19,210,121,33,86,105,210,16,73,44,35,151,36,189,102,223,203,203,253,17,54,57,27,34,255,208,163,19,138,132,25,55,238,103,153,42,73,22,229,189,237,116,223,81,243,52,231,175,45,102,249,136,222,155,207,164,92,252,232,217,3,30,48,204,37,57,134,3,33,247,115,101,110,73,221,14,219,134,192,210,157,169,230,212,222,213,60,93,169,169,231,185,47,61,133,178,150,64,226,239,222,124,211,73,98,182,116,64,105,12,227,93,38,153,145,77,143,24,230,122,108,153,103,236,101,137,88,86,189,190,8,0,191,167,129,12,34,50,86,253,19,114,208,236,44,17,3,239,241,135,204,243,45,2,198,135,118,177,148,238,217,31,73,68,218,60,9,76,250,129,56,6,156,85,203,143,140,250,141,12,204,45,32,207,193,39,165,161,37,162,253,246,166,236,232,7,102,109,173,213,251,49,68,225,141,106,65,38,14,43,52,118,111,22,241,157,160,191,48,219,32,186,70,243,244,67,140,26,174,6,143,148,47,16,254,75,220,211,58,32,230,210,116,4,96,87,82,7,77,96,195,190,16,75},
  {65,72,247,17,144,226,202,145,138,142,210,75,239,180,143,240,63,151,57,31,206,85,168,247,141,166,158,95,18,192,233,90,65,96,231,139,91,11,78,185,236,250,91,22,134,147,190,118,88,90,185,223,50,12,92,209,249,19,45,251,14,227,176,64,242,188,185,156,34,116,81,99,48,239,168,61,94,42,150,103,103,165,249,214,67,6,73,197,232,119,185,62,234,23,32,209,82,4,114,53,75,138,101,34,181,158,154,106,110,173,139,233,96,236,18,164,63,215,144,36,142,9,79,175,243,60,195,154,64,159,61,144,170,218,134,20,82,96,154,60,133,116,174,142,17,43,232,166,167,173,132,157,237,161,188,124,227,118,118,71,227,141,46,150,132,201,211,91,167,31,134,12,22,82,16,184,237,238,225,12,97,12,138,78,30,44,172,81,74,158,197,185,131,128,183,82,30,168,141,96,179,87,30,47,216,144,44,115,26,236,174,139,54,243,136,41,228,58,179,52,44,179,120,219,152,62,186,133,63,69,228,1,107,130,145,92,178,1,209,43,84,112,144,184,125,180,25,23,149,123,88,37,61,183,160,82,238,85,54,146,227,233,61,205,250,119,204,199,60,151,121,103,155,66,107,71,139,227,135,83,105,111,49,9,195,72,127,144,159,181,72,190,145,91,66,103,204,112,50,145,5,201,114,178,220,253,177,3,98,38,38,81,251,125,182,64,133,176,136,144,22,197,205,66,213,240,58,131,31,228,223,237,48,47,254,24,94,189,184,198,197,179,45,121,233,224,158,42,22,69,202,95,235,127,137,222,152,34,218,88,24,68,244,201,246,7,246,1,165,245,190,11,10,110,122,86,114,41,192,88,89,37,19,55,184,114,123,150,235,151,143,150,193,59,73,222,216,135,165,96,33,89,243,179,88,224,18,224,78,207,25,246,61,86,161,73,103,185,121,62,55,61,19,229,198,154,139,26,13,146,94,1,215,130,138,220,242,2,125,253,152,72,69,151,134,60,75,59,143,35,214,233,235,183,175,234,194,65,8,254,206,6,249,15,51,163,213,118,215,149,195,34,18,35,30,110,6,252,92,136,113,217,184,69,36,174,193,199,141,103,108,175,102,128,45,22,190,13,54,206,56,157,37,106,84,253,42,25,162,127,114,231,18,255,224,180,64,195,157,130,148,196,178,85,82,77,211,84,149,220,74,233,37,194,174,12,248,86,126,16,78,106,185,139,2,133,12,44,186,108,180,211,205,195,183,21,203,99,173,176,81,33,91,77,39,11,151,192,80,2,54,70,174,252,190,74,46,73,58,112,126,59,8,219,27,84,49,91,23,176,72,238,26,81,204,147,234,159,135,111,120,46,199,48,250,50,0,174,193,39,7,203,69,40,145,107,49,90,46,173,70,120,169,43,234,185,146,109,22,105,119,249,255,239,236,242,7,79,24,184,126,247,245,143,44,160,154,116,9,21,251,212,55,96,194,60,83,140,253,240,243,58,127,64,56,32,208,5,250,93,29,194,133,137,68,28,226,82,2,204,175,214,111,11,163,244,11,144,24,186,140,169,20,46,199,167,22,42,92,50,156,30,67,1,125,218,81,19,68,239,211,178,105,195,160,39,222,230,56,46,25,145,88,234,98,94,242,240,225,13,131,93,24,137,137,177,223,142,46,216,123,85,123,118,35,82,221,126,78,12,238,75,174,176,86,86,86,198,147,12,33,48,221,170,183,66,44,16,190,10,115,141,9,160,249,4,76,79,207,1,85,105,67,132,66,237,149,218,96,253,7,35,45,115,48,243,158,124,85,33,113,230,16,54,218,148,47,173,213,80,255,247,9,185,206,175,136,141,6,153,152,255,163,250,248,190,164,94,133,76,95,50,154,210,214,170,6,248,215,66,58,156,129,136,15,141,255,118,231,88,190,116,169,16,31,152,116,162,114,122,250,97,234,227,71,195,95,121,210,101,17,29,72,94,226,106,17,237,118,244,182,248,174,110,11,102,156,14,208,24,196,117,217,139,27,55,218,13,209,182,139,104,81,181,139,233,179,156,96,104,3,207,18,136,1,166,241,109,97,97,4,170,196,27,227,46,83,148,251,26,23,123,207,211,214,145,139,252,223,41,74,126,28,87,249,36,199,98,50,132,193,155,30,9,73,78,207,131,192,9,159,102,86,145,243,45,66,138,164,174,97,107,210,115,67,12,201,197,27,97,34,163,78,77,152,82,98,246,130,195,228,244,245,79,187,152,201,183,165,169,78,242,22,199,11,244,250,101,74,95,99,103,103,156,161,58,233,12,185,254,13,250,126,3,205,7,173,243,150,205,194,89,21,19,72,239,72,92,83,81,183,185,234,25,199,93,80,68,151,151,223,215,45,40,176,180,250,86,206,25,34,77,85,107,223,55,225,20,161,8,231,54,104,120,124,238,80,140,252,12,4,201,179,211,32,107,157,93,202,239,92,10,29,214,173,4,214,116,161,67,160,87,82,242,54,82,126,193,61,155,107,23,62,128,208,62,20,118,54,173,184,186,124,90,15,226,100,187,165,161,179,46,65,22,69,196,26,194,191,159,69,155,191,95,248,95,107,217,30,112,216,45,14,10,121,176,242,219,238,2,96,173,232,91,10,201,183,222,83,8,7,16,62,252,35,209,161,63,217,238,123,31,98,183,204,85,164,55,66,96,84,175,217,199,218,82,29,91,252,115,63,114,38,189,244,39,37,163,189,158,82,56,251,178,201,104,226,112,74,159,64,231,129,131,39,161,82,58,126,54,194,106,113,53,51,209,40,96,46,173,54,60,55,69,208,16,111,27,200,221,85,233,233,8,13,69,192,3,127,130,39,57,192,255,138,67,255,208,47,243,3,195,188,208,183,244,219,7,58,122,154,215,236,178,122,185,241,125,209,154,91,48,113,205,180,187,71,123,217,91,100,139,53,7,244,252,26,160,111,42,40,125,146,110,9,200,108,99,97,11,147,63},
} ;

static const int16_t precomputed_encode_857x5167_x[precomputed_encode_857x5167_NUM][crypto_encode_ITEMS] = {
  {21453,-14476,-12694,-15679,16221,-1298,31433,8389,3128,19151,-24427,-18455,17786,32133,-17823,-6351,3518,26262,19392,18540,23060,5248,19817,-16557,-11492,-8206,2416,-12738,-24427,8329,12202,-15132,-9878,28079,-4386,19115,9517,21380,24865,-28358,3789,3756,25222,-231,-13206,-15736,-26399,-23026,-7132,4358,-31303,27617,-5802,12609,-20067,-7547,22376,-32542,-32605,-27987,-32533,26144,17342,23101,1988,14670,-14814,-17923,-14451,17502,-12772,29152,-7827,30139,-23365,27406,32630,666,22524,5464,30903,-2651,-13923,-32061,25768,5567,-6331,-9172,14419,5233,-1707,24224,17269,1788,-695,-25997,-26951,-6024,19214,28468,-10632,-7165,3893,-21909,-21632,-28160,25885,3991,-22696,-3983,-15399,10348,-27326,2539,6838,-1733,17557,-18527,-28474,-11937,-16285,8715,23602,23240,-15442,-27486,16321,-1121,-13726,3587,-9583,18729,3119,27713,31471,-6100,-1737,13742,20584,2489,-26432,-15020,-31806,-19421,-398,-15150,-8973,-28081,1043,-21917,23520,9824,-23059,4964,-30077,28769,29433,11838,-23425,10119,28182,25391,12295,9710,23202,-16452,26861,-12100,27006,-21212,-3421,-937,-24743,20176,-11182,14606,-31915,781,5524,-17753,-1179,30447,-9572,11135,-2412,29212,-5456,31944,-28828,24625,-11544,24475,5267,32146,-7446,4411,-30859,5312,16503,23157,10324,-13040,32462,6948,-13306,32078,21937,-9928,213,-9701,5253,-8373,32720,-24220,-15922,7608,9359,-27691,-22652,29522,-10958,-19094,-14026,-29717,-21487,19688,-12127,21261,2275,-27059,-24846,-13296,31120,473,20879,9262,12424,3305,28159,-6920,12387,-26154,-13848,2536,14235,-9446,27253,-11468,-28736,-27721,30119,25460,-32033,-14593,564,-12082,-20992,14851,-32574,31034,24184,-20496,541,2439,-22114,-31445,20058,10892,4212,-24422,-10086,-24335,-19445,3490,-28987,7033,-11315,17368,-18370,4338,-22307,-20852,5611,6486,23390,-8236,18658,21054,-25362,-20609,2085,21345,17901,-2935,-7822,-3133,20464,32136,-1160,26154,17311,-18127,8004,2476,28688,-31867,-1362,-14119,22953,-16256,28067,24391,22025,-18958,11624,-29676,-10131,-29084,4460,20845,3106,30831,15850,-30132,-10788,13249,-8835,-5739,-20893,4274,15823,25810,21359,7102,26340,-15138,8830,2270,-29986,-1905,-1021,6941,-3652,12645,-17665,5560,-2969,-13803,-23752,18296,26461,15371,-12099,-14446,27040,1154,-20200,5231,-13847,18984,14101,-11736,-14667,13237,-5315,-24066,-7033,-29008,5391,13500,-652,-4901,-27028,-30181,-14572,5887,-29340,-1547,-11408,364,5290,-29600,-9522,-24492,28035,-6912,10699,-16995,23110,-3880,5354,32384,-16585,-10558,-120,31987,26554,-32113,797,-18692,-17166,10995,21946,-18850,24434,-5548,-21276,31398,-20591,-944,-21225,-18689,-14321,3507,15280,-2576,18930,-17673,13288,-21546,-29475,8348,-31098,27878,32131,5250,29273,7296,1214,10686,-5145,18224,9387,-10287,7251,32642,-4759,-6144,-31242,9864,2473,-8340,28841,23805,-4306,-29478,19513,19836,29771,8497,31961,21020,-8808,16959,14570,1259,-30464,-24010,1618,26851,31539,-18044,1984,1586,-32668,892,-29215,-27236,-13658,-27588,-31673,-19006,9997,2316,-22003,671,4549,16771,12858,-3468,25933,-6216,-3344,17503,2713,-6343,-24072,-12138,1065,31832,14994,-13222,5261,-3716,17018,20805,-8831,29624,-30337,-9822,-32442,-12407,-21704,14651,29236,5547,-30913,-27234,-26329,-2357,-16507,-20078,-17549,2910,28392,-11192,23137,22201,2656,25144,-5537,-24884,-9888,1216,-3404,883,8299,9547,12269,-1852,-7906,-14431,32307,-4208,-7585,2830,18884,29520,25204,-21105,32735,-3082,-8203,31011,-6054,28332,23837,-13266,-30181,20292,17933,16096,-16589,-28526,-10445,26737,-3846,11844,-26973,5835,11279,-24879,-13947,24238,-29339,15226,-3906,-12119,8155,12259,6705,3864,-7344,-15429,14637,14438,-25978,-9779,14001,29903,-9116,18532,30844,5109,-514,90,12963,-4980,-11893,-31186,-2243,-27025,25141,2959,20306,15454,7323,14217,-11221,-8507,19933,-19528,17053,21115,-28889,21524,24485,-9966,17205,-23936,-2291,21619,23255,-8746,27872,29998,23537,27154,-9302,13387,25227,-5573,-1495,29721,-281,15059,-27024,-19455,23389,13877,28473,26476,24065,6578,29284,20808,-2282,13302,-5902,-18888,-20890,-31326,-16714,-10119,24491,26176,-20827,-20092,17362,-32244,16042,-29705,-19723,-1472,-11044,3256,11284,-3968,-27761,13383,-6085,-15415,-8734,30781,22979,-21040,18445,10398,-5468,-31696,29272,27525,809,-10828,30653,-25086,-24419,412,-16200,6081,9068,-6428,-3860,-24009,-7936,3571,-6975,-16355,4828,22429,5058,-8525,24109,16351,-23749,-5776,-19998,-7683,-7372,-30678,-25454,-820,-19591,2400,-30506,-12798,24921,1716,-32684,15582,20310,2172,-21692,-3967,-1109,7191,12438,474,-11417,-17150,-9111,-13153,5253,-28722,-22469,137,-16842,-20013,-19529,20220,31318,-27505,-13510,-27415,30240,-1346,-19966,8985,-24432,-5796,23362,-16544,-9621,-22573,31122,12047,-28037,893,5059,-27277,-30563,-6673,-3249,-3679,27584,-16115,-10929,-18649,21824,26956,-9461,-8048,11036,-19985,-20868,4669,16002,-21028,-18203,-14290,-10444,10605,23376,-6952,15852,22042,10150,13197,3961,-7478,28134,-13303,-24814,-1756,-4758,18564,-14443,12648,-9020,-18249,-2736,30062,3678,14943,7670,-13403,29999,-25703,-7190,13855,-5907,14895,11944,8392,-19975,26350,-3050,-31124,1899,23290,-22492,-10403,-3095,11166,3154,-1863,26192,-10203,2197,-23263,25883,21332,-994,-3356,24562,21585,18258,-26690,31988,7341,-18652,-3533,-5201,-15754,13669,21440,19786,-25022,6334,-29492,276,-14097,-872,-27443,29378,24557,12046,26972,31022,-24535,27016,-10309,-21139,-23477,-3346,5611,-9657},
  {-19414,21485,-12507,-20432,533,10689,-8401,-12495,31373,26131,-27183,-3118,-23253,25120,-27175,17995,5405,32524,14626,13655,-11229,-22543,23891,629,-30095,-18131,-15450,-29679,-7391,-24729,-8737,-31258,-31558,-10912,20769,26703,10291,-25586,19776,-26779,-13780,-32347,-21274,-3652,3798,-17815,-8002,11820,-3090,-2026,30236,30608,-25268,20266,19521,-4452,-2229,-12760,12471,-27656,10837,17024,-10669,8361,15827,-6210,-14124,4026,-19190,-2026,24052,11080,9349,28811,2373,12098,13625,20491,12773,15968,-16316,-24477,-22272,25479,29860,3037,2637,-17510,21582,27127,-1730,-5806,-13467,-10762,30288,1746,-22502,-28577,13891,-11491,5744,-31477,-13107,-26447,18468,-2366,-19959,-11588,8823,18724,-15090,-32458,-1561,-31145,9113,29976,-12254,26559,13089,-587,-18616,28635,1462,-8149,22231,11154,-30175,-5532,-23096,21911,-10134,-17859,11708,20356,17828,-13349,5528,-19499,-20681,-10979,21010,-2648,-10739,28055,-29832,28856,-15756,-24576,-14067,-16182,4996,-2864,-2253,25847,8728,-7367,-19590,-29849,-26010,765,14166,21462,-16483,-25082,21270,-1172,-7294,-1925,-1005,-17148,-21409,-5220,512,29245,-2299,9113,-27794,-2732,-4533,8971,4774,32044,-17386,-7714,26656,16398,-29877,3716,-31473,279,23965,-7937,-7526,-9935,-22717,4744,-6808,-117,-20193,17946,469,-9130,15826,-17406,-5574,14683,-21396,10804,7954,-7027,-22187,15674,-24855,-8890,11632,30659,12742,-547,-12536,12100,-26929,-16408,-12155,17060,-10157,-17882,-13641,-2980,20399,872,15364,-13822,4645,-8093,-11921,-15598,29732,-8513,-18752,-15469,-10360,-8106,1278,8238,3316,6631,-31056,4743,1521,-261,20722,27437,1002,10712,21716,24762,-31276,-5145,-29258,2151,23170,-4631,8323,7951,22902,-8116,23707,5022,3818,6509,15490,-16786,13367,7857,-7578,-23715,21121,6039,-10870,10468,17490,26102,8255,-6006,17296,-4691,2164,-11739,18759,29986,-27795,-22722,1479,21115,7813,-20683,-19597,-30415,18951,-4456,-28257,30413,9343,27044,-32320,-10470,28361,29880,29480,-4461,22335,6750,-791,-32175,65,-29738,-3512,-24169,24469,-17328,-25789,29284,176,-27878,27088,-31882,-5269,924,-20094,-14660,5889,12849,-15230,31761,-26972,-29473,-7829,24600,23057,12527,30574,-31184,-31079,4630,-15054,-5790,31470,-4108,-25537,-24643,21586,-26440,-204,-20285,29983,28123,10106,-25860,-31110,-10694,-31605,-30249,-19322,-27721,-14770,24524,2518,-14845,30959,15636,-20540,7336,-18413,-26002,12758,22099,-4018,15719,4381,11573,-12722,-14314,1299,-27130,-5939,-8153,-2076,6076,-14528,-1220,-11726,-14996,4448,-15232,17963,30198,30523,-12843,4574,28657,29635,25152,14421,-22084,4708,-24816,-5507,88,-17672,19265,-13200,-19861,-18140,28608,29590,-14662,-4458,16647,19248,13597,-31127,-16123,14713,29439,-10393,31756,-8984,-4104,12613,-14808,-16943,-27296,4433,-13858,-4398,22908,-11644,25258,-4038,-27325,-24681,20188,-5543,7922,32055,16344,-19250,4974,-5096,13334,2552,-12806,11744,-24049,20246,4179,23535,28191,23620,-4253,-21862,-13896,3440,-9590,-26923,528,-19330,15603,-24000,8102,18617,17261,-1991,32472,-29570,24790,-27385,-4194,-25040,22791,-17856,-22406,14648,-22031,-84,-31151,2270,-29856,-20316,9108,-27547,-22686,8448,9371,-624,32430,16242,-26172,18093,-27077,-20312,-17092,6774,-21704,954,-3266,24996,-31128,-13172,29633,-29033,10663,-27686,-4125,22719,22075,-15715,4660,5018,-31760,18691,17257,-25431,10438,-12028,3069,-16756,-1429,17474,-21088,-9831,26361,32288,21789,-23227,-5875,-17461,7570,9146,-28142,2741,-2728,14470,23931,7460,-14017,-21445,24865,-31847,-28421,-12137,-2414,3752,-21858,-24104,-20594,-10342,-9225,23847,14543,-22110,15230,17217,31396,17798,31381,-32515,14560,-26432,-19716,7285,-23023,-658,-5685,-24884,-7564,27636,-31703,-10243,21339,11422,3016,563,20211,-10734,-31266,-26208,15383,-2160,-31679,-28426,-12760,-13362,7270,-30960,-31217,-12830,-21772,-11316,8803,5712,-4093,-1554,14193,-32358,-15184,21134,476,21205,17689,20286,25928,30789,-22232,-32404,5240,-20289,18467,5037,-29217,-279,4769,-9724,16997,6618,24402,3565,-23741,565,28066,-29416,31892,28167,31148,10637,-30184,29613,32199,1119,-10817,-16371,-17122,31605,22002,10693,29183,-14769,3163,-22132,-17821,-9856,28878,-20837,562,-663,15717,-23408,-21914,-16022,-1696,23024,-10389,-25691,14939,-8074,29054,-993,11675,31589,-16689,32110,15417,28988,-4501,-11747,-27375,-1709,-28465,-12870,27055,4069,13281,-26614,12243,9685,-2080,11407,12070,-15336,-4749,-14144,17983,-23036,29768,-7394,17478,1723,-13617,-19048,-20682,-19095,13195,32115,-25841,-20369,-19295,10607,20735,-7871,-23031,-7883,12565,-29397,22121,-13176,5254,-8748,-28071,-14311,-26248,16442,26526,-13767,22129,-12564,-8446,20138,-30958,31410,-17424,-20090,-6897,3511,-28223,-13694,-11863,-4620,-20949,25979,1444,8992,-20868,23412,-23711,-12606,-32431,8687,26907,-12246,-4247,-14833,1776,-6518,-7291,29509,-5851,18241,-20667,-20242,20856,8631,1717,-2322,1018,-28396,-16548,4401,-17809,10100,-8324,-29706,-3259,30742,-14470,2687,-1788,-11215,26938,-4400,-3097,5921,4354,29780,-7455,9361,4080,-13571,-20214,-27416,-21858,17132,-9805,324,7956,5022,5372,-25154,-6193,22531,19177,-31410,-27968,-5818,-4087,27392,-791,-9340,11740,-21371,-24753,-13700,19503,-1262,3825,-30723,-7038,4322,-29292,18816,-27723,2268,1549,29808,13222,-9946,-25227,32433,-16620,27746,19214,25066,-6296,-7781,29870,12868,-23255,-12363,740,-19569,-10516,-24238,-17717,-26870,-13920,-8080,16935,181,-12864,16926,-2675,-2235,-20174,-23587,29123,13005,1010,-24975},
  {-16766,-14067,-29999,637,16522,6385,-28627,26640,-10267,-31734,-27664,2093,-13365,-19335,-23168,1985,-16046,11325,31961,8256,-26060,-32016,-8600,28344,12042,13229,23467,-26196,29114,-28062,-28262,-27781,-1374,9112,-11143,19343,-15799,-19849,-27876,1482,-8161,29858,23253,-16087,9579,-10694,15382,-14598,-14166,17780,24757,19350,21563,13495,13313,-25832,-9156,10979,-8438,-29323,-26743,2338,-8511,13650,-18539,-19862,-23262,26566,14629,-8269,-16950,19781,32500,19962,-26581,1069,-11450,-19550,14761,21414,16520,-23669,-31081,22787,17399,-5269,-3631,18441,2719,19796,31950,-31133,23239,19719,-6326,-12084,-7697,-13707,-27312,-25326,-3795,-30659,8521,-29887,-7800,-25602,-15903,-5838,7984,31346,-18471,-5450,18459,15700,3583,1504,-7850,-13220,15431,6819,-12472,-478,-25909,1092,28922,-16555,-6872,23427,-18725,22535,-14883,18254,26270,-19517,17330,7078,-24330,21866,30107,13672,-21292,9683,19017,5289,-1120,-22713,-27380,11825,16425,-30518,4823,-16175,-4925,22066,1113,-3961,32151,-10989,-3138,-27612,-9207,-22763,24385,32718,5951,-1877,-26729,-3054,18768,15648,-21050,-25083,-28215,670,-14175,-7931,13309,-6429,-18978,14791,-3224,-21338,-7462,30904,2044,3452,15861,5863,29976,9871,-16568,2240,10849,14409,-5399,-2858,24099,-12733,12389,-11710,5388,15704,6280,-468,18707,-28550,22105,14538,1769,-10840,28531,17067,-4487,19417,16350,-7683,23631,25037,-21070,-14872,-25607,-9822,-28664,20365,-32702,15706,20510,6466,-27759,-8690,-11469,-346,28544,-6726,-29739,200,-28489,-11435,22071,16628,9566,-23607,15037,-10136,-25834,-2101,-23872,25033,-25623,-25600,-8687,19350,-12356,-18521,-3831,-22074,30920,16333,-13766,-24213,-24777,-5142,20178,-7764,-1243,22079,219,-30023,24667,-15505,-24404,15845,29304,692,-31611,21772,-11604,-21025,25596,-317,-23568,5120,21597,-7128,-5600,-21818,-6277,-28384,-26411,-1806,-5916,8758,21696,14245,12364,18870,-17243,-19730,-1879,8043,8035,32235,-28633,17700,24663,-31757,21955,3958,9735,-10654,-15155,28372,21003,-29712,27286,-19968,17711,-19527,23588,-14012,-20202,-28906,-27224,-12496,6444,-17315,19532,26439,-16655,-5746,-18556,-17294,-29417,6618,-4031,18036,-21313,10635,15489,-29139,-541,3565,-16265,-14551,-17135,-4778,26688,-24068,-16853,3466,-2816,29746,13284,-1659,-26475,26910,-23721,21792,-7428,4622,16426,3711,-20091,4722,-4729,10441,9597,-24611,-17876,13383,-2630,23369,-7246,14017,15285,16397,28490,20208,-26797,17619,32726,8264,22399,24342,27257,-11846,-12090,18403,3492,-3372,20218,-7013,30274,16620,25872,31793,-13591,-11731,10467,-2360,16538,23742,19364,1833,-24398,15633,20689,-30867,22931,12839,13690,9713,4702,-13786,24657,31025,5261,24791,-1029,-13766,-32189,25691,-13460,682,28064,-6720,-32004,29709,32764,8810,25422,23376,2572,-10286,-23268,12882,-30768,11909,24016,13000,-17190,9517,26918,15764,-18336,1512,9063,-12025,-29040,-24241,-10371,18115,1610,-5362,-29881,26429,16064,-16038,-12180,15834,-4357,1287,394,9241,13657,26005,25882,22297,-10153,15843,29449,21924,-24260,-13264,-21007,-17871,8457,12191,-8579,-28791,-18330,6266,5688,-14736,1285,20610,-7705,-11449,-4714,30953,-13427,19922,18540,27926,15802,-23368,-21164,-21637,-16164,6545,-639,-11022,26223,5213,-25643,19960,-20384,2670,-9854,-18174,15330,-28367,-19623,-1729,-32509,-26245,-26726,1188,-15717,-26821,-2293,-10236,-1760,-21172,22453,-32561,18204,3083,-7331,28216,32599,1360,9319,185,19340,20787,-17537,2148,-2380,-8056,16583,-15744,-25000,5960,-15950,11971,15169,31243,-31338,23052,-30627,30430,-15067,-2053,-25968,23488,-11458,16180,6374,-19949,-18853,-3209,-17809,29892,29977,-25562,3216,-20737,-19826,4070,672,9311,-26611,-29788,-17310,21104,-3641,-7841,14255,23100,7759,-23478,6732,-12632,-26582,-18602,-32099,8191,170,23,-28735,9507,31176,-8969,5093,-4880,-20049,-3348,-21190,-3364,4502,-20745,25199,23885,-8623,31780,-23164,-30147,-25204,26626,-163,5185,-26649,-29669,-19390,18682,-30174,10059,-6793,-23397,-15970,-29134,-1191,9533,31278,1495,-6487,17043,-23673,-14492,-14193,-21452,2958,8884,1590,16220,4759,12757,-467,12197,1773,26474,20149,709,447,-10356,-13845,16993,27335,18317,-18697,-27303,16155,25198,19067,23480,-24116,30039,26430,23025,-26721,9005,1737,-30589,-17258,22100,-25398,-4597,3416,-2724,16317,-716,2877,9506,-31900,-17767,-28910,24903,-19139,20472,17932,11435,3314,23620,-19453,-8604,-29641,-30080,-16572,-1481,22271,-19258,-18715,27483,18723,-23558,-26068,-5905,3546,-22549,16646,-26987,-5762,-9375,-30245,-32121,23017,29867,-11762,-5101,15683,-29910,6415,5469,9492,9826,29224,8079,-17818,7330,-15211,-30570,-1630,10110,-27275,10803,-29647,18590,6240,29410,1867,8211,-16691,26856,-31969,18392,-25209,30895,-8919,-24562,23695,-17622,14638,24132,-8964,-11309,29008,8398,8094,-24042,-11297,-7444,4674,24830,-25615,7357,-11528,-426,-3044,-30312,-15709,-13124,27499,6588,-28032,28797,9738,-14962,11306,-8641,8414,23800,4320,-10278,21753,15354,-8993,16126,-3529,16220,-28746,12549,15892,-30789,21970,3501,-11113,-12301,6222,23602,-10977,-19517,-21038,-7209,21709,22483,-27345,6237,-28807,20965,32272,-16121,29992,26621,-25379,-3468,-18292,-24258,-27699,10889,-32263,20990,20311,-17765,724,26266,30774,-30058,-15628,4787,23141,-17356,11441,15144,-16659,24550,-15523,5411,11944,894,27941,20335,24358,18134,-26569,7075,438,-17015,26322,23752,-19857,-30551,28242,31249,-822,30987,26487,-32703,11632,12575,8451,14199,-18460,1300,-23679,-16990,-19313},
  {9341,17100,-1240,11953,29988,8612,15419,11249,18991,-25883,-7241,17189,20841,13482,-420,-9075,-24503,19514,-30936,5903,-6535,28427,-31136,-1912,-5614,-827,-21963,16695,-12,-31854,9693,19460,14209,-15728,-2416,-29015,2616,-28515,30852,-22874,9310,2082,8042,-29137,16768,3626,-24546,-25936,17051,11043,-8124,14571,-8048,15182,8454,-3878,-23018,16349,9886,23793,-11181,16005,-2081,-15793,-2852,-6886,1827,20378,-14873,-18683,-17523,32460,8240,-20400,-16929,-6953,5365,24887,1835,-5163,3336,4641,-4875,20620,-1746,32075,-25462,20417,15804,12516,15578,-8031,26006,-22212,-25840,9792,686,10988,28734,-5028,-15216,-2171,9801,8692,23641,28596,-23197,17609,-8038,22204,-23622,-27313,-28946,-23938,25435,24905,7351,-3256,-14316,-12396,29951,-8975,-29874,24095,-22003,17226,-16299,10818,-12338,20606,13021,-28688,23210,-12464,-5438,23756,-31095,27351,-2354,22340,22714,28277,-11559,2699,25334,25381,15064,4160,1415,-32464,-23598,-1474,4847,19122,-22385,-5709,23154,24751,31489,-17429,30512,-24563,-14172,13798,29768,13012,-8380,13553,-13003,-642,14079,-10887,-21109,-15947,-32004,-7556,-25594,-18919,-30704,17999,-21118,21409,13923,-2855,5531,-9923,-19527,31949,3279,-2107,7379,31486,-30253,26528,-13286,4675,19082,25084,23044,-26089,4742,18611,9801,19851,10798,-31034,2204,22976,-24224,-12362,-20907,27719,24261,-5969,-18367,-14919,-14175,-13955,1725,-31430,-22246,30686,-904,24656,-15751,14945,-10020,13010,-18936,-9527,5708,-200,8143,-15500,19782,-27915,27203,-4079,-12200,10279,27192,-18444,-4475,21557,30614,-5095,13787,19570,-12737,-15398,23199,-8985,20711,-25894,-20264,28680,27714,6500,14767,-15751,21383,7092,-27190,-9395,32259,-5111,13206,29434,15649,-20187,-31453,24282,23540,-20903,23661,11954,10386,-8025,-15048,-28879,-20364,-28309,-26507,12116,-6946,20347,8965,-22282,10214,2535,10846,-25210,14505,22760,30821,-8701,-21641,14603,7197,21835,11817,-16588,-12916,-28342,-30685,8679,25150,20813,10006,5572,4919,20881,16483,-29384,31735,29633,-19761,-32390,13481,-6495,-19212,16078,-2738,-30975,30378,-16875,20297,-24273,-7452,-11259,-29084,2501,-29781,-15909,6120,15386,21036,-32578,-8754,-10106,-19808,13883,-24563,-8144,21128,-24129,6759,27081,12155,3493,-24011,13515,-31798,24575,-1970,16133,-28372,-604,26164,-20598,23980,-1884,-15945,8867,6420,7182,29599,9641,9992,-13757,16439,16249,11798,-4708,-1365,31153,21589,-29757,27895,30935,-6902,-719,4708,-6447,22064,29000,20666,-22433,-24434,-17021,10769,-6862,-5729,23758,31225,-29696,-15710,-28166,-5253,-32698,5944,-9033,7786,31511,-21626,-14050,26511,-10435,20057,12139,-8030,10377,19359,-16110,21822,-32419,19335,-22672,13440,-15961,23934,-10265,18755,11392,-5876,-26442,-13289,-22756,-5426,22849,-5553,-23951,-21711,-9590,-5012,-27758,5643,15385,20047,-20094,-5782,386,-32009,-18846,14617,7795,8116,-9111,12735,-18816,-21809,-23559,30719,-10460,-19725,-26540,-28423,17367,3566,-30634,28932,-24154,-14085,-11598,6596,7697,-6882,-24503,-13397,24804,29300,-29391,-31523,-10709,21904,26146,23519,27865,-3430,2862,-16998,-12247,-24039,27361,-26001,-26453,23977,2232,-21434,-25671,27389,-11503,27048,20210,8464,27587,19376,-2910,15386,-5132,23502,-6138,19928,31635,18958,28906,3591,-6499,26713,9559,-8428,28498,-4251,17971,-19186,28190,21289,-20503,874,8077,-27099,2321,4657,5791,5823,9773,-12046,-7105,2827,-3610,-23269,-8367,-28302,-23027,-31279,-31229,824,1936,20816,-24190,22271,-26063,16575,-31882,-5329,-22803,27502,27410,-11466,-18164,-20474,-6910,3298,23893,-17367,29986,1726,5843,24646,12441,-24510,-26511,2403,-2856,-27677,18252,-9013,6468,-25615,9249,-16009,13249,2444,3022,-32666,-9096,7137,-17773,18282,12160,2307,-22843,-23258,1294,19022,-31213,-28170,3077,26767,13896,28769,31513,-10797,23481,17518,22610,-29633,23701,-19140,6133,-32217,30415,15931,18052,-23279,20663,25947,-31045,-6050,26205,-17511,1346,-29648,-25013,16717,-31668,-9021,-2238,-8948,-306,-19209,-21967,-6718,29465,-19286,3600,17608,16038,-23684,10966,21438,12775,431,-7680,13159,9691,23254,-27409,-14896,-30840,14509,-5041,-22409,23090,17668,-11096,11773,-11709,9598,9909,8906,30447,2130,7035,-8205,-30543,-30678,28279,8890,-21123,-3783,16566,-26958,-23021,-7303,31681,-103,21449,-10751,9127,-32608,-4765,3242,-13723,-32101,4343,22175,-24707,-28507,-1661,8517,-19450,-31545,-16088,-9797,8424,-6235,-23094,-30035,19669,-29903,24805,501,19041,1513,-12846,10234,15348,31380,-1528,13090,2806,-21304,-6971,-19782,3069,-28485,12954,13045,-16079,-23976,-5947,13058,-3943,-9741,-6093,-5091,-31905,-249,18927,-20386,-29563,-13669,25379,23298,2544,-29726,-6336,26113,-12944,19424,-6115,13853,28229,-7000,-21697,30469,11414,-13043,16639,26932,31417,30851,23256,-6330,-24061,-14182,-14979,-24510,-31484,-9335,-5381,-26963,-14305,26355,-18851,29604,28990,2142,-28629,-9703,-4152,11861,20808,-28453,-26572,-4751,27269,-8002,17744,-30380,29281,26929,6136,0,30375,22915,3799,-3125,11404,-16447,5628,-7513,13428,30833,22095,20728,-16573,12057,-1863,12619,15956,-6608,-1565,-23604,18732,32684,-9474,5430,27233,29681,9424,2028,-6548,-12413,7849,-11152,-8255,-28514,14793,1759,-14288,-12930,-5451,-1095,1611,-4789,-13661,-586,-15104,-29505,3783,-32571,-2606,-24194,-18186,1485,-7383,31106,-15171,-20492,-5675,-1775,-2281,7778,-14052,-23974,-4764,-11112,577,-11888,25286,7214,23661,-23363,-4706,16652,-6963,5687,23456,-15834,-22472,-32061,-18358,29155,-3628,27270},
} ;

static void test_encode_857x5167_impl(long long impl)
{
  unsigned char *s = test_encode_857x5167_s;
  unsigned char *x = test_encode_857x5167_x;
  unsigned char *s2 = test_encode_857x5167_s2;
  unsigned char *x2 = test_encode_857x5167_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857x5167_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857x5167(impl);
    printf("encode_857x5167 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x5167_implementation(impl),ntruprime_dispatch_encode_857x5167_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857x5167;
    printf("encode_857x5167 selected implementation %s compiler %s\n",ntruprime_encode_857x5167_implementation(),ntruprime_encode_857x5167_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857x5167_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857x5167_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857x5167_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857x5167_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857x5167_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857x5167_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857x5167(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x5167")) return;
  storage_encode_857x5167_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857x5167_s = aligned(storage_encode_857x5167_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857x5167_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857x5167_x = aligned(storage_encode_857x5167_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857x5167_s2 = callocplus(maxalloc);
  test_encode_857x5167_s2 = aligned(storage_encode_857x5167_s2,crypto_encode_STRBYTES);
  storage_encode_857x5167_x2 = callocplus(maxalloc);
  test_encode_857x5167_x2 = aligned(storage_encode_857x5167_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857x5167 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857x5167();++impl)
      forked(test_encode_857x5167_impl,impl);
    ++test_encode_857x5167_s;
    ++test_encode_857x5167_x;
    ++test_encode_857x5167_s2;
    ++test_encode_857x5167_x2;
  }
  free(storage_encode_857x5167_x2);
  free(storage_encode_857x5167_s2);
  free(storage_encode_857x5167_x);
  free(storage_encode_857x5167_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

