pub enum Glyph {}

#[allow(dead_code)]
#[allow(non_upper_case_globals)]
impl Glyph {
    pub const A: u16 = 0x0041;
    pub const AE: u16 = 0x00c6;
    pub const AEacute: u16 = 0x01fc;
    pub const AEmacron: u16 = 0x01e2;
    pub const AEsmall: u16 = 0xf7e6;
    pub const Aacute: u16 = 0x00c1;
    pub const Aacutesmall: u16 = 0xf7e1;
    pub const Abreve: u16 = 0x0102;
    pub const Abreveacute: u16 = 0x1eae;
    pub const Abrevecyrillic: u16 = 0x04d0;
    pub const Abrevedotbelow: u16 = 0x1eb6;
    pub const Abrevegrave: u16 = 0x1eb0;
    pub const Abrevehookabove: u16 = 0x1eb2;
    pub const Abrevetilde: u16 = 0x1eb4;
    pub const Acaron: u16 = 0x01cd;
    pub const Acircle: u16 = 0x24b6;
    pub const Acircumflex: u16 = 0x00c2;
    pub const Acircumflexacute: u16 = 0x1ea4;
    pub const Acircumflexdotbelow: u16 = 0x1eac;
    pub const Acircumflexgrave: u16 = 0x1ea6;
    pub const Acircumflexhookabove: u16 = 0x1ea8;
    pub const Acircumflexsmall: u16 = 0xf7e2;
    pub const Acircumflextilde: u16 = 0x1eaa;
    pub const Acute: u16 = 0xf6c9;
    pub const Acutesmall: u16 = 0xf7b4;
    pub const Acyrillic: u16 = 0x0410;
    pub const Adblgrave: u16 = 0x0200;
    pub const Adieresis: u16 = 0x00c4;
    pub const Adieresiscyrillic: u16 = 0x04d2;
    pub const Adieresismacron: u16 = 0x01de;
    pub const Adieresissmall: u16 = 0xf7e4;
    pub const Adotbelow: u16 = 0x1ea0;
    pub const Adotmacron: u16 = 0x01e0;
    pub const Agrave: u16 = 0x00c0;
    pub const Agravesmall: u16 = 0xf7e0;
    pub const Ahookabove: u16 = 0x1ea2;
    pub const Aiecyrillic: u16 = 0x04d4;
    pub const Ainvertedbreve: u16 = 0x0202;
    pub const Alpha: u16 = 0x0391;
    pub const Alphatonos: u16 = 0x0386;
    pub const Amacron: u16 = 0x0100;
    pub const Amonospace: u16 = 0xff21;
    pub const Aogonek: u16 = 0x0104;
    pub const Aring: u16 = 0x00c5;
    pub const Aringacute: u16 = 0x01fa;
    pub const Aringbelow: u16 = 0x1e00;
    pub const Aringsmall: u16 = 0xf7e5;
    pub const Asmall: u16 = 0xf761;
    pub const Atilde: u16 = 0x00c3;
    pub const Atildesmall: u16 = 0xf7e3;
    pub const Aybarmenian: u16 = 0x0531;
    pub const B: u16 = 0x0042;
    pub const Bcircle: u16 = 0x24b7;
    pub const Bdotaccent: u16 = 0x1e02;
    pub const Bdotbelow: u16 = 0x1e04;
    pub const Becyrillic: u16 = 0x0411;
    pub const Benarmenian: u16 = 0x0532;
    pub const Beta: u16 = 0x0392;
    pub const Bhook: u16 = 0x0181;
    pub const Blinebelow: u16 = 0x1e06;
    pub const Bmonospace: u16 = 0xff22;
    pub const Brevesmall: u16 = 0xf6f4;
    pub const Bsmall: u16 = 0xf762;
    pub const Btopbar: u16 = 0x0182;
    pub const C: u16 = 0x0043;
    pub const Caarmenian: u16 = 0x053e;
    pub const Cacute: u16 = 0x0106;
    pub const Caron: u16 = 0xf6ca;
    pub const Caronsmall: u16 = 0xf6f5;
    pub const Ccaron: u16 = 0x010c;
    pub const Ccedilla: u16 = 0x00c7;
    pub const Ccedillaacute: u16 = 0x1e08;
    pub const Ccedillasmall: u16 = 0xf7e7;
    pub const Ccircle: u16 = 0x24b8;
    pub const Ccircumflex: u16 = 0x0108;
    pub const Cdot: u16 = 0x010a;
    pub const Cdotaccent: u16 = 0x010a;
    pub const Cedillasmall: u16 = 0xf7b8;
    pub const Chaarmenian: u16 = 0x0549;
    pub const Cheabkhasiancyrillic: u16 = 0x04bc;
    pub const Checyrillic: u16 = 0x0427;
    pub const Chedescenderabkhasiancyrillic: u16 = 0x04be;
    pub const Chedescendercyrillic: u16 = 0x04b6;
    pub const Chedieresiscyrillic: u16 = 0x04f4;
    pub const Cheharmenian: u16 = 0x0543;
    pub const Chekhakassiancyrillic: u16 = 0x04cb;
    pub const Cheverticalstrokecyrillic: u16 = 0x04b8;
    pub const Chi: u16 = 0x03a7;
    pub const Chook: u16 = 0x0187;
    pub const Circumflexsmall: u16 = 0xf6f6;
    pub const Cmonospace: u16 = 0xff23;
    pub const Coarmenian: u16 = 0x0551;
    pub const Csmall: u16 = 0xf763;
    pub const D: u16 = 0x0044;
    pub const DZ: u16 = 0x01f1;
    pub const DZcaron: u16 = 0x01c4;
    pub const Daarmenian: u16 = 0x0534;
    pub const Dafrican: u16 = 0x0189;
    pub const Dbar: u16 = 0x0110;
    pub const Dcaron: u16 = 0x010e;
    pub const Dcedilla: u16 = 0x1e10;
    pub const Dcircle: u16 = 0x24b9;
    pub const Dcircumflexbelow: u16 = 0x1e12;
    pub const Dcroat: u16 = 0x0110;
    pub const Ddotaccent: u16 = 0x1e0a;
    pub const Ddotbelow: u16 = 0x1e0c;
    pub const Decyrillic: u16 = 0x0414;
    pub const Deicoptic: u16 = 0x03ee;
    pub const Delta: u16 = 0x2206;
    pub const Deltagreek: u16 = 0x0394;
    pub const Dhook: u16 = 0x018a;
    pub const Dieresis: u16 = 0xf6cb;
    pub const DieresisAcute: u16 = 0xf6cc;
    pub const DieresisGrave: u16 = 0xf6cd;
    pub const Dieresissmall: u16 = 0xf7a8;
    pub const Digammagreek: u16 = 0x03dc;
    pub const Djecyrillic: u16 = 0x0402;
    pub const Dlinebelow: u16 = 0x1e0e;
    pub const Dmonospace: u16 = 0xff24;
    pub const Dotaccentsmall: u16 = 0xf6f7;
    pub const Dslash: u16 = 0x0110;
    pub const Dsmall: u16 = 0xf764;
    pub const Dtopbar: u16 = 0x018b;
    pub const Dz: u16 = 0x01f2;
    pub const Dzcaron: u16 = 0x01c5;
    pub const Dzeabkhasiancyrillic: u16 = 0x04e0;
    pub const Dzecyrillic: u16 = 0x0405;
    pub const Dzhecyrillic: u16 = 0x040f;
    pub const E: u16 = 0x0045;
    pub const Eacute: u16 = 0x00c9;
    pub const Eacutesmall: u16 = 0xf7e9;
    pub const Ebreve: u16 = 0x0114;
    pub const Ecaron: u16 = 0x011a;
    pub const Ecedillabreve: u16 = 0x1e1c;
    pub const Echarmenian: u16 = 0x0535;
    pub const Ecircle: u16 = 0x24ba;
    pub const Ecircumflex: u16 = 0x00ca;
    pub const Ecircumflexacute: u16 = 0x1ebe;
    pub const Ecircumflexbelow: u16 = 0x1e18;
    pub const Ecircumflexdotbelow: u16 = 0x1ec6;
    pub const Ecircumflexgrave: u16 = 0x1ec0;
    pub const Ecircumflexhookabove: u16 = 0x1ec2;
    pub const Ecircumflexsmall: u16 = 0xf7ea;
    pub const Ecircumflextilde: u16 = 0x1ec4;
    pub const Ecyrillic: u16 = 0x0404;
    pub const Edblgrave: u16 = 0x0204;
    pub const Edieresis: u16 = 0x00cb;
    pub const Edieresissmall: u16 = 0xf7eb;
    pub const Edot: u16 = 0x0116;
    pub const Edotaccent: u16 = 0x0116;
    pub const Edotbelow: u16 = 0x1eb8;
    pub const Efcyrillic: u16 = 0x0424;
    pub const Egrave: u16 = 0x00c8;
    pub const Egravesmall: u16 = 0xf7e8;
    pub const Eharmenian: u16 = 0x0537;
    pub const Ehookabove: u16 = 0x1eba;
    pub const Eightroman: u16 = 0x2167;
    pub const Einvertedbreve: u16 = 0x0206;
    pub const Eiotifiedcyrillic: u16 = 0x0464;
    pub const Elcyrillic: u16 = 0x041b;
    pub const Elevenroman: u16 = 0x216a;
    pub const Emacron: u16 = 0x0112;
    pub const Emacronacute: u16 = 0x1e16;
    pub const Emacrongrave: u16 = 0x1e14;
    pub const Emcyrillic: u16 = 0x041c;
    pub const Emonospace: u16 = 0xff25;
    pub const Encyrillic: u16 = 0x041d;
    pub const Endescendercyrillic: u16 = 0x04a2;
    pub const Eng: u16 = 0x014a;
    pub const Enghecyrillic: u16 = 0x04a4;
    pub const Enhookcyrillic: u16 = 0x04c7;
    pub const Eogonek: u16 = 0x0118;
    pub const Eopen: u16 = 0x0190;
    pub const Epsilon: u16 = 0x0395;
    pub const Epsilontonos: u16 = 0x0388;
    pub const Ercyrillic: u16 = 0x0420;
    pub const Ereversed: u16 = 0x018e;
    pub const Ereversedcyrillic: u16 = 0x042d;
    pub const Escyrillic: u16 = 0x0421;
    pub const Esdescendercyrillic: u16 = 0x04aa;
    pub const Esh: u16 = 0x01a9;
    pub const Esmall: u16 = 0xf765;
    pub const Eta: u16 = 0x0397;
    pub const Etarmenian: u16 = 0x0538;
    pub const Etatonos: u16 = 0x0389;
    pub const Eth: u16 = 0x00d0;
    pub const Ethsmall: u16 = 0xf7f0;
    pub const Etilde: u16 = 0x1ebc;
    pub const Etildebelow: u16 = 0x1e1a;
    pub const Euro: u16 = 0x20ac;
    pub const Ezh: u16 = 0x01b7;
    pub const Ezhcaron: u16 = 0x01ee;
    pub const Ezhreversed: u16 = 0x01b8;
    pub const F: u16 = 0x0046;
    pub const FFIsmall: u16 = 0xd807;
    pub const FFLsmall: u16 = 0xd808;
    pub const FFsmall: u16 = 0xd804;
    pub const FIsmall: u16 = 0xd805;
    pub const FLsmall: u16 = 0xd806;
    pub const Fcircle: u16 = 0x24bb;
    pub const Fdotaccent: u16 = 0x1e1e;
    pub const Feharmenian: u16 = 0x0556;
    pub const Feicoptic: u16 = 0x03e4;
    pub const Fhook: u16 = 0x0191;
    pub const Fitacyrillic: u16 = 0x0472;
    pub const Fiveroman: u16 = 0x2164;
    pub const Fmonospace: u16 = 0xff26;
    pub const Fourroman: u16 = 0x2163;
    pub const Fsmall: u16 = 0xf766;
    pub const G: u16 = 0x0047;
    pub const GBsquare: u16 = 0x3387;
    pub const Gacute: u16 = 0x01f4;
    pub const Gamma: u16 = 0x0393;
    pub const Gammaafrican: u16 = 0x0194;
    pub const Gangiacoptic: u16 = 0x03ea;
    pub const Gbreve: u16 = 0x011e;
    pub const Gcaron: u16 = 0x01e6;
    pub const Gcedilla: u16 = 0x0122;
    pub const Gcircle: u16 = 0x24bc;
    pub const Gcircumflex: u16 = 0x011c;
    pub const Gcommaaccent: u16 = 0x0122;
    pub const Gdot: u16 = 0x0120;
    pub const Gdotaccent: u16 = 0x0120;
    pub const Gecyrillic: u16 = 0x0413;
    pub const Germandbls: u16 = 0x0053;
    pub const Germandbls2: u16 = 0x1e9e;
    pub const Germandblssmall: u16 = 0xd803;
    pub const Ghadarmenian: u16 = 0x0542;
    pub const Ghemiddlehookcyrillic: u16 = 0x0494;
    pub const Ghestrokecyrillic: u16 = 0x0492;
    pub const Gheupturncyrillic: u16 = 0x0490;
    pub const Ghook: u16 = 0x0193;
    pub const Gimarmenian: u16 = 0x0533;
    pub const Gjecyrillic: u16 = 0x0403;
    pub const Gmacron: u16 = 0x1e20;
    pub const Gmonospace: u16 = 0xff27;
    pub const Grave: u16 = 0xf6ce;
    pub const Gravesmall: u16 = 0xf760;
    pub const Gsmall: u16 = 0xf767;
    pub const Gsmallhook: u16 = 0x029b;
    pub const Gstroke: u16 = 0x01e4;
    pub const H: u16 = 0x0048;
    pub const H18533: u16 = 0x25cf;
    pub const H18543: u16 = 0x25aa;
    pub const H18551: u16 = 0x25ab;
    pub const H22073: u16 = 0x25a1;
    pub const HPsquare: u16 = 0x33cb;
    pub const Haabkhasiancyrillic: u16 = 0x04a8;
    pub const Hadescendercyrillic: u16 = 0x04b2;
    pub const Hardsigncyrillic: u16 = 0x042a;
    pub const Hbar: u16 = 0x0126;
    pub const Hbrevebelow: u16 = 0x1e2a;
    pub const Hcedilla: u16 = 0x1e28;
    pub const Hcircle: u16 = 0x24bd;
    pub const Hcircumflex: u16 = 0x0124;
    pub const Hdieresis: u16 = 0x1e26;
    pub const Hdotaccent: u16 = 0x1e22;
    pub const Hdotbelow: u16 = 0x1e24;
    pub const Hmonospace: u16 = 0xff28;
    pub const Hoarmenian: u16 = 0x0540;
    pub const Horicoptic: u16 = 0x03e8;
    pub const Hsmall: u16 = 0xf768;
    pub const Hungarumlaut: u16 = 0xf6cf;
    pub const Hungarumlautsmall: u16 = 0xf6f8;
    pub const Hzsquare: u16 = 0x3390;
    pub const I: u16 = 0x0049;
    pub const IAcyrillic: u16 = 0x042f;
    pub const IJ: u16 = 0x0132;
    pub const IUcyrillic: u16 = 0x042e;
    pub const Iacute: u16 = 0x00cd;
    pub const Iacutesmall: u16 = 0xf7ed;
    pub const Ibreve: u16 = 0x012c;
    pub const Icaron: u16 = 0x01cf;
    pub const Icircle: u16 = 0x24be;
    pub const Icircumflex: u16 = 0x00ce;
    pub const Icircumflexsmall: u16 = 0xf7ee;
    pub const Icyrillic: u16 = 0x0406;
    pub const Idblgrave: u16 = 0x0208;
    pub const Idieresis: u16 = 0x00cf;
    pub const Idieresisacute: u16 = 0x1e2e;
    pub const Idieresiscyrillic: u16 = 0x04e4;
    pub const Idieresissmall: u16 = 0xf7ef;
    pub const Idot: u16 = 0x0130;
    pub const Idotaccent: u16 = 0x0130;
    pub const Idotbelow: u16 = 0x1eca;
    pub const Iebrevecyrillic: u16 = 0x04d6;
    pub const Iecyrillic: u16 = 0x0415;
    pub const Ifractur: u16 = 0x2111;
    pub const Ifraktur: u16 = 0x2111;
    pub const Igrave: u16 = 0x00cc;
    pub const Igravesmall: u16 = 0xf7ec;
    pub const Ihookabove: u16 = 0x1ec8;
    pub const Iicyrillic: u16 = 0x0418;
    pub const Iinvertedbreve: u16 = 0x020a;
    pub const Iishortcyrillic: u16 = 0x0419;
    pub const Imacron: u16 = 0x012a;
    pub const Imacroncyrillic: u16 = 0x04e2;
    pub const Imonospace: u16 = 0xff29;
    pub const Iniarmenian: u16 = 0x053b;
    pub const Iocyrillic: u16 = 0x0401;
    pub const Iogonek: u16 = 0x012e;
    pub const Iota: u16 = 0x0399;
    pub const Iotaafrican: u16 = 0x0196;
    pub const Iotadieresis: u16 = 0x03aa;
    pub const Iotatonos: u16 = 0x038a;
    pub const Ismall: u16 = 0xf769;
    pub const Istroke: u16 = 0x0197;
    pub const Itilde: u16 = 0x0128;
    pub const Itildebelow: u16 = 0x1e2c;
    pub const Izhitsacyrillic: u16 = 0x0474;
    pub const Izhitsadblgravecyrillic: u16 = 0x0476;
    pub const J: u16 = 0x004a;
    pub const Jaarmenian: u16 = 0x0541;
    pub const Jcircle: u16 = 0x24bf;
    pub const Jcircumflex: u16 = 0x0134;
    pub const Jecyrillic: u16 = 0x0408;
    pub const Jheharmenian: u16 = 0x054b;
    pub const Jmonospace: u16 = 0xff2a;
    pub const Jsmall: u16 = 0xf76a;
    pub const K: u16 = 0x004b;
    pub const KBsquare: u16 = 0x3385;
    pub const KKsquare: u16 = 0x33cd;
    pub const Kabashkircyrillic: u16 = 0x04a0;
    pub const Kacute: u16 = 0x1e30;
    pub const Kacyrillic: u16 = 0x041a;
    pub const Kadescendercyrillic: u16 = 0x049a;
    pub const Kahookcyrillic: u16 = 0x04c3;
    pub const Kappa: u16 = 0x039a;
    pub const Kastrokecyrillic: u16 = 0x049e;
    pub const Kaverticalstrokecyrillic: u16 = 0x049c;
    pub const Kcaron: u16 = 0x01e8;
    pub const Kcedilla: u16 = 0x0136;
    pub const Kcircle: u16 = 0x24c0;
    pub const Kcommaaccent: u16 = 0x0136;
    pub const Kdotbelow: u16 = 0x1e32;
    pub const Keharmenian: u16 = 0x0554;
    pub const Kenarmenian: u16 = 0x053f;
    pub const Khacyrillic: u16 = 0x0425;
    pub const Kheicoptic: u16 = 0x03e6;
    pub const Khook: u16 = 0x0198;
    pub const Kjecyrillic: u16 = 0x040c;
    pub const Klinebelow: u16 = 0x1e34;
    pub const Kmonospace: u16 = 0xff2b;
    pub const Koppacyrillic: u16 = 0x0480;
    pub const Koppagreek: u16 = 0x03de;
    pub const Ksicyrillic: u16 = 0x046e;
    pub const Ksmall: u16 = 0xf76b;
    pub const L: u16 = 0x004c;
    pub const LJ: u16 = 0x01c7;
    pub const LL: u16 = 0xf6bf;
    pub const Lacute: u16 = 0x0139;
    pub const Lambda: u16 = 0x039b;
    pub const Lcaron: u16 = 0x013d;
    pub const Lcedilla: u16 = 0x013b;
    pub const Lcircle: u16 = 0x24c1;
    pub const Lcircumflexbelow: u16 = 0x1e3c;
    pub const Lcommaaccent: u16 = 0x013b;
    pub const Ldot: u16 = 0x013f;
    pub const Ldotaccent: u16 = 0x013f;
    pub const Ldotbelow: u16 = 0x1e36;
    pub const Ldotbelowmacron: u16 = 0x1e38;
    pub const Liwnarmenian: u16 = 0x053c;
    pub const Lj: u16 = 0x01c8;
    pub const Ljecyrillic: u16 = 0x0409;
    pub const Llinebelow: u16 = 0x1e3a;
    pub const Lmonospace: u16 = 0xff2c;
    pub const Lslash: u16 = 0x0141;
    pub const Lslashsmall: u16 = 0xf6f9;
    pub const Lsmall: u16 = 0xf76c;
    pub const M: u16 = 0x004d;
    pub const MBsquare: u16 = 0x3386;
    pub const Macron: u16 = 0xf6d0;
    pub const Macronsmall: u16 = 0xf7af;
    pub const Macute: u16 = 0x1e3e;
    pub const Mcircle: u16 = 0x24c2;
    pub const Mdotaccent: u16 = 0x1e40;
    pub const Mdotbelow: u16 = 0x1e42;
    pub const Menarmenian: u16 = 0x0544;
    pub const Mmonospace: u16 = 0xff2d;
    pub const Msmall: u16 = 0xf76d;
    pub const Mturned: u16 = 0x019c;
    pub const Mu: u16 = 0x039c;
    pub const N: u16 = 0x004e;
    pub const NJ: u16 = 0x01ca;
    pub const Nacute: u16 = 0x0143;
    pub const Ncaron: u16 = 0x0147;
    pub const Ncedilla: u16 = 0x0145;
    pub const Ncircle: u16 = 0x24c3;
    pub const Ncircumflexbelow: u16 = 0x1e4a;
    pub const Ncommaaccent: u16 = 0x0145;
    pub const Ndotaccent: u16 = 0x1e44;
    pub const Ndotbelow: u16 = 0x1e46;
    pub const Ng: u16 = 0x014a;
    pub const Nhookleft: u16 = 0x019d;
    pub const Nineroman: u16 = 0x2168;
    pub const Nj: u16 = 0x01cb;
    pub const Njecyrillic: u16 = 0x040a;
    pub const Nlinebelow: u16 = 0x1e48;
    pub const Nmonospace: u16 = 0xff2e;
    pub const Nowarmenian: u16 = 0x0546;
    pub const Nsmall: u16 = 0xf76e;
    pub const Ntilde: u16 = 0x00d1;
    pub const Ntildesmall: u16 = 0xf7f1;
    pub const Nu: u16 = 0x039d;
    pub const O: u16 = 0x004f;
    pub const OE: u16 = 0x0152;
    pub const OEsmall: u16 = 0xf6fa;
    pub const Oacute: u16 = 0x00d3;
    pub const Oacutesmall: u16 = 0xf7f3;
    pub const Obarredcyrillic: u16 = 0x04e8;
    pub const Obarreddieresiscyrillic: u16 = 0x04ea;
    pub const Obreve: u16 = 0x014e;
    pub const Ocaron: u16 = 0x01d1;
    pub const Ocenteredtilde: u16 = 0x019f;
    pub const Ocircle: u16 = 0x24c4;
    pub const Ocircumflex: u16 = 0x00d4;
    pub const Ocircumflexacute: u16 = 0x1ed0;
    pub const Ocircumflexdotbelow: u16 = 0x1ed8;
    pub const Ocircumflexgrave: u16 = 0x1ed2;
    pub const Ocircumflexhookabove: u16 = 0x1ed4;
    pub const Ocircumflexsmall: u16 = 0xf7f4;
    pub const Ocircumflextilde: u16 = 0x1ed6;
    pub const Ocyrillic: u16 = 0x041e;
    pub const Odblacute: u16 = 0x0150;
    pub const Odblgrave: u16 = 0x020c;
    pub const Odieresis: u16 = 0x00d6;
    pub const Odieresiscyrillic: u16 = 0x04e6;
    pub const Odieresissmall: u16 = 0xf7f6;
    pub const Odotbelow: u16 = 0x1ecc;
    pub const Ogoneksmall: u16 = 0xf6fb;
    pub const Ograve: u16 = 0x00d2;
    pub const Ogravesmall: u16 = 0xf7f2;
    pub const Oharmenian: u16 = 0x0555;
    pub const Ohm: u16 = 0x2126;
    pub const Ohookabove: u16 = 0x1ece;
    pub const Ohorn: u16 = 0x01a0;
    pub const Ohornacute: u16 = 0x1eda;
    pub const Ohorndotbelow: u16 = 0x1ee2;
    pub const Ohorngrave: u16 = 0x1edc;
    pub const Ohornhookabove: u16 = 0x1ede;
    pub const Ohorntilde: u16 = 0x1ee0;
    pub const Ohungarumlaut: u16 = 0x0150;
    pub const Oi: u16 = 0x01a2;
    pub const Oinvertedbreve: u16 = 0x020e;
    pub const Omacron: u16 = 0x014c;
    pub const Omacronacute: u16 = 0x1e52;
    pub const Omacrongrave: u16 = 0x1e50;
    pub const Omega: u16 = 0x2126;
    pub const Omegacyrillic: u16 = 0x0460;
    pub const Omegagreek: u16 = 0x03a9;
    pub const Omegaroundcyrillic: u16 = 0x047a;
    pub const Omegatitlocyrillic: u16 = 0x047c;
    pub const Omegatonos: u16 = 0x038f;
    pub const Omicron: u16 = 0x039f;
    pub const Omicrontonos: u16 = 0x038c;
    pub const Omonospace: u16 = 0xff2f;
    pub const Oneroman: u16 = 0x2160;
    pub const Oogonek: u16 = 0x01ea;
    pub const Oogonekmacron: u16 = 0x01ec;
    pub const Oopen: u16 = 0x0186;
    pub const Oslash: u16 = 0x00d8;
    pub const Oslashacute: u16 = 0x01fe;
    pub const Oslashsmall: u16 = 0xf7f8;
    pub const Osmall: u16 = 0xf76f;
    pub const Ostrokeacute: u16 = 0x01fe;
    pub const Otcyrillic: u16 = 0x047e;
    pub const Otilde: u16 = 0x00d5;
    pub const Otildeacute: u16 = 0x1e4c;
    pub const Otildedieresis: u16 = 0x1e4e;
    pub const Otildesmall: u16 = 0xf7f5;
    pub const P: u16 = 0x0050;
    pub const Pacute: u16 = 0x1e54;
    pub const Pcircle: u16 = 0x24c5;
    pub const Pdotaccent: u16 = 0x1e56;
    pub const Pecyrillic: u16 = 0x041f;
    pub const Peharmenian: u16 = 0x054a;
    pub const Pemiddlehookcyrillic: u16 = 0x04a6;
    pub const Phi: u16 = 0x03a6;
    pub const Phook: u16 = 0x01a4;
    pub const Pi: u16 = 0x03a0;
    pub const Piwrarmenian: u16 = 0x0553;
    pub const Pmonospace: u16 = 0xff30;
    pub const Psi: u16 = 0x03a8;
    pub const Psicyrillic: u16 = 0x0470;
    pub const Psmall: u16 = 0xf770;
    pub const Q: u16 = 0x0051;
    pub const Qcircle: u16 = 0x24c6;
    pub const Qmonospace: u16 = 0xff31;
    pub const Qsmall: u16 = 0xf771;
    pub const R: u16 = 0x0052;
    pub const Raarmenian: u16 = 0x054c;
    pub const Racute: u16 = 0x0154;
    pub const Rcaron: u16 = 0x0158;
    pub const Rcedilla: u16 = 0x0156;
    pub const Rcircle: u16 = 0x24c7;
    pub const Rcommaaccent: u16 = 0x0156;
    pub const Rdblgrave: u16 = 0x0210;
    pub const Rdotaccent: u16 = 0x1e58;
    pub const Rdotbelow: u16 = 0x1e5a;
    pub const Rdotbelowmacron: u16 = 0x1e5c;
    pub const Reharmenian: u16 = 0x0550;
    pub const Rfractur: u16 = 0x211c;
    pub const Rfraktur: u16 = 0x211c;
    pub const Rho: u16 = 0x03a1;
    pub const Ringsmall: u16 = 0xf6fc;
    pub const Rinvertedbreve: u16 = 0x0212;
    pub const Rlinebelow: u16 = 0x1e5e;
    pub const Rmonospace: u16 = 0xff32;
    pub const Rsmall: u16 = 0xf772;
    pub const Rsmallinverted: u16 = 0x0281;
    pub const Rsmallinvertedsuperior: u16 = 0x02b6;
    pub const S: u16 = 0x0053;
    pub const SF010000: u16 = 0x250c;
    pub const SF020000: u16 = 0x2514;
    pub const SF030000: u16 = 0x2510;
    pub const SF040000: u16 = 0x2518;
    pub const SF050000: u16 = 0x253c;
    pub const SF060000: u16 = 0x252c;
    pub const SF070000: u16 = 0x2534;
    pub const SF080000: u16 = 0x251c;
    pub const SF090000: u16 = 0x2524;
    pub const SF100000: u16 = 0x2500;
    pub const SF110000: u16 = 0x2502;
    pub const SF190000: u16 = 0x2561;
    pub const SF200000: u16 = 0x2562;
    pub const SF210000: u16 = 0x2556;
    pub const SF220000: u16 = 0x2555;
    pub const SF230000: u16 = 0x2563;
    pub const SF240000: u16 = 0x2551;
    pub const SF250000: u16 = 0x2557;
    pub const SF260000: u16 = 0x255d;
    pub const SF270000: u16 = 0x255c;
    pub const SF280000: u16 = 0x255b;
    pub const SF360000: u16 = 0x255e;
    pub const SF370000: u16 = 0x255f;
    pub const SF380000: u16 = 0x255a;
    pub const SF390000: u16 = 0x2554;
    pub const SF400000: u16 = 0x2569;
    pub const SF410000: u16 = 0x2566;
    pub const SF420000: u16 = 0x2560;
    pub const SF430000: u16 = 0x2550;
    pub const SF440000: u16 = 0x256c;
    pub const SF450000: u16 = 0x2567;
    pub const SF460000: u16 = 0x2568;
    pub const SF470000: u16 = 0x2564;
    pub const SF480000: u16 = 0x2565;
    pub const SF490000: u16 = 0x2559;
    pub const SF500000: u16 = 0x2558;
    pub const SF510000: u16 = 0x2552;
    pub const SF520000: u16 = 0x2553;
    pub const SF530000: u16 = 0x256b;
    pub const SF540000: u16 = 0x256a;
    pub const SS: u16 = 0x0053;
    pub const SSsmall: u16 = 0xd803;
    pub const Sacute: u16 = 0x015a;
    pub const Sacutedotaccent: u16 = 0x1e64;
    pub const Sampigreek: u16 = 0x03e0;
    pub const Scaron: u16 = 0x0160;
    pub const Scarondotaccent: u16 = 0x1e66;
    pub const Scaronsmall: u16 = 0xf6fd;
    pub const Scedilla: u16 = 0x015e;
    pub const Schwa: u16 = 0x018f;
    pub const Schwacyrillic: u16 = 0x04d8;
    pub const Schwadieresiscyrillic: u16 = 0x04da;
    pub const Scircle: u16 = 0x24c8;
    pub const Scircumflex: u16 = 0x015c;
    pub const Scommaaccent: u16 = 0x0218;
    pub const Sdotaccent: u16 = 0x1e60;
    pub const Sdotbelow: u16 = 0x1e62;
    pub const Sdotbelowdotaccent: u16 = 0x1e68;
    pub const Seharmenian: u16 = 0x054d;
    pub const Sevenroman: u16 = 0x2166;
    pub const Shaarmenian: u16 = 0x0547;
    pub const Shacyrillic: u16 = 0x0428;
    pub const Shchacyrillic: u16 = 0x0429;
    pub const Sheicoptic: u16 = 0x03e2;
    pub const Shhacyrillic: u16 = 0x04ba;
    pub const Shimacoptic: u16 = 0x03ec;
    pub const Sigma: u16 = 0x03a3;
    pub const Sixroman: u16 = 0x2165;
    pub const Smonospace: u16 = 0xff33;
    pub const Softsigncyrillic: u16 = 0x042c;
    pub const Ssmall: u16 = 0xf773;
    pub const Stigmagreek: u16 = 0x03da;
    pub const T: u16 = 0x0054;
    pub const Tau: u16 = 0x03a4;
    pub const Tbar: u16 = 0x0166;
    pub const Tcaron: u16 = 0x0164;
    pub const Tcedilla: u16 = 0x0162;
    pub const Tcircle: u16 = 0x24c9;
    pub const Tcircumflexbelow: u16 = 0x1e70;
    pub const Tcommaaccent: u16 = 0x0162;
    pub const Tdotaccent: u16 = 0x1e6a;
    pub const Tdotbelow: u16 = 0x1e6c;
    pub const Tecyrillic: u16 = 0x0422;
    pub const Tedescendercyrillic: u16 = 0x04ac;
    pub const Tenroman: u16 = 0x2169;
    pub const Tetsecyrillic: u16 = 0x04b4;
    pub const Theta: u16 = 0x0398;
    pub const Thook: u16 = 0x01ac;
    pub const Thorn: u16 = 0x00de;
    pub const Thornsmall: u16 = 0xf7fe;
    pub const Threeroman: u16 = 0x2162;
    pub const Tildesmall: u16 = 0xf6fe;
    pub const Tiwnarmenian: u16 = 0x054f;
    pub const Tlinebelow: u16 = 0x1e6e;
    pub const Tmonospace: u16 = 0xff34;
    pub const Toarmenian: u16 = 0x0539;
    pub const Tonefive: u16 = 0x01bc;
    pub const Tonesix: u16 = 0x0184;
    pub const Tonetwo: u16 = 0x01a7;
    pub const Tretroflexhook: u16 = 0x01ae;
    pub const Tsecyrillic: u16 = 0x0426;
    pub const Tshecyrillic: u16 = 0x040b;
    pub const Tsmall: u16 = 0xf774;
    pub const Twelveroman: u16 = 0x216b;
    pub const Tworoman: u16 = 0x2161;
    pub const U: u16 = 0x0055;
    pub const Uacute: u16 = 0x00da;
    pub const Uacutesmall: u16 = 0xf7fa;
    pub const Ubreve: u16 = 0x016c;
    pub const Ucaron: u16 = 0x01d3;
    pub const Ucircle: u16 = 0x24ca;
    pub const Ucircumflex: u16 = 0x00db;
    pub const Ucircumflexbelow: u16 = 0x1e76;
    pub const Ucircumflexsmall: u16 = 0xf7fb;
    pub const Ucyrillic: u16 = 0x0423;
    pub const Udblacute: u16 = 0x0170;
    pub const Udblgrave: u16 = 0x0214;
    pub const Udieresis: u16 = 0x00dc;
    pub const Udieresisacute: u16 = 0x01d7;
    pub const Udieresisbelow: u16 = 0x1e72;
    pub const Udieresiscaron: u16 = 0x01d9;
    pub const Udieresiscyrillic: u16 = 0x04f0;
    pub const Udieresisgrave: u16 = 0x01db;
    pub const Udieresismacron: u16 = 0x01d5;
    pub const Udieresissmall: u16 = 0xf7fc;
    pub const Udotbelow: u16 = 0x1ee4;
    pub const Ugrave: u16 = 0x00d9;
    pub const Ugravesmall: u16 = 0xf7f9;
    pub const Uhookabove: u16 = 0x1ee6;
    pub const Uhorn: u16 = 0x01af;
    pub const Uhornacute: u16 = 0x1ee8;
    pub const Uhorndotbelow: u16 = 0x1ef0;
    pub const Uhorngrave: u16 = 0x1eea;
    pub const Uhornhookabove: u16 = 0x1eec;
    pub const Uhorntilde: u16 = 0x1eee;
    pub const Uhungarumlaut: u16 = 0x0170;
    pub const Uhungarumlautcyrillic: u16 = 0x04f2;
    pub const Uinvertedbreve: u16 = 0x0216;
    pub const Ukcyrillic: u16 = 0x0478;
    pub const Umacron: u16 = 0x016a;
    pub const Umacroncyrillic: u16 = 0x04ee;
    pub const Umacrondieresis: u16 = 0x1e7a;
    pub const Umonospace: u16 = 0xff35;
    pub const Uogonek: u16 = 0x0172;
    pub const Upsilon: u16 = 0x03a5;
    pub const Upsilon1: u16 = 0x03d2;
    pub const Upsilonacutehooksymbolgreek: u16 = 0x03d3;
    pub const Upsilonafrican: u16 = 0x01b1;
    pub const Upsilondieresis: u16 = 0x03ab;
    pub const Upsilondieresishooksymbolgreek: u16 = 0x03d4;
    pub const Upsilonhooksymbol: u16 = 0x03d2;
    pub const Upsilontonos: u16 = 0x038e;
    pub const Uring: u16 = 0x016e;
    pub const Ushortcyrillic: u16 = 0x040e;
    pub const Usmall: u16 = 0xf775;
    pub const Ustraightcyrillic: u16 = 0x04ae;
    pub const Ustraightstrokecyrillic: u16 = 0x04b0;
    pub const Utilde: u16 = 0x0168;
    pub const Utildeacute: u16 = 0x1e78;
    pub const Utildebelow: u16 = 0x1e74;
    pub const V: u16 = 0x0056;
    pub const Vcircle: u16 = 0x24cb;
    pub const Vdotbelow: u16 = 0x1e7e;
    pub const Vecyrillic: u16 = 0x0412;
    pub const Vewarmenian: u16 = 0x054e;
    pub const Vhook: u16 = 0x01b2;
    pub const Vmonospace: u16 = 0xff36;
    pub const Voarmenian: u16 = 0x0548;
    pub const Vsmall: u16 = 0xf776;
    pub const Vtilde: u16 = 0x1e7c;
    pub const W: u16 = 0x0057;
    pub const Wacute: u16 = 0x1e82;
    pub const Wcircle: u16 = 0x24cc;
    pub const Wcircumflex: u16 = 0x0174;
    pub const Wdieresis: u16 = 0x1e84;
    pub const Wdotaccent: u16 = 0x1e86;
    pub const Wdotbelow: u16 = 0x1e88;
    pub const Wgrave: u16 = 0x1e80;
    pub const Wmonospace: u16 = 0xff37;
    pub const Wsmall: u16 = 0xf777;
    pub const X: u16 = 0x0058;
    pub const Xcircle: u16 = 0x24cd;
    pub const Xdieresis: u16 = 0x1e8c;
    pub const Xdotaccent: u16 = 0x1e8a;
    pub const Xeharmenian: u16 = 0x053d;
    pub const Xi: u16 = 0x039e;
    pub const Xmonospace: u16 = 0xff38;
    pub const Xsmall: u16 = 0xf778;
    pub const Y: u16 = 0x0059;
    pub const Yacute: u16 = 0x00dd;
    pub const Yacutesmall: u16 = 0xf7fd;
    pub const Yatcyrillic: u16 = 0x0462;
    pub const Ycircle: u16 = 0x24ce;
    pub const Ycircumflex: u16 = 0x0176;
    pub const Ydieresis: u16 = 0x0178;
    pub const Ydieresissmall: u16 = 0xf7ff;
    pub const Ydotaccent: u16 = 0x1e8e;
    pub const Ydotbelow: u16 = 0x1ef4;
    pub const Yericyrillic: u16 = 0x042b;
    pub const Yerudieresiscyrillic: u16 = 0x04f8;
    pub const Ygrave: u16 = 0x1ef2;
    pub const Yhook: u16 = 0x01b3;
    pub const Yhookabove: u16 = 0x1ef6;
    pub const Yiarmenian: u16 = 0x0545;
    pub const Yicyrillic: u16 = 0x0407;
    pub const Yiwnarmenian: u16 = 0x0552;
    pub const Ymonospace: u16 = 0xff39;
    pub const Ysmall: u16 = 0xf779;
    pub const Ytilde: u16 = 0x1ef8;
    pub const Yusbigcyrillic: u16 = 0x046a;
    pub const Yusbigiotifiedcyrillic: u16 = 0x046c;
    pub const Yuslittlecyrillic: u16 = 0x0466;
    pub const Yuslittleiotifiedcyrillic: u16 = 0x0468;
    pub const Z: u16 = 0x005a;
    pub const Zaarmenian: u16 = 0x0536;
    pub const Zacute: u16 = 0x0179;
    pub const Zcaron: u16 = 0x017d;
    pub const Zcaronsmall: u16 = 0xf6ff;
    pub const Zcircle: u16 = 0x24cf;
    pub const Zcircumflex: u16 = 0x1e90;
    pub const Zdot: u16 = 0x017b;
    pub const Zdotaccent: u16 = 0x017b;
    pub const Zdotbelow: u16 = 0x1e92;
    pub const Zecyrillic: u16 = 0x0417;
    pub const Zedescendercyrillic: u16 = 0x0498;
    pub const Zedieresiscyrillic: u16 = 0x04de;
    pub const Zeta: u16 = 0x0396;
    pub const Zhearmenian: u16 = 0x053a;
    pub const Zhebrevecyrillic: u16 = 0x04c1;
    pub const Zhecyrillic: u16 = 0x0416;
    pub const Zhedescendercyrillic: u16 = 0x0496;
    pub const Zhedieresiscyrillic: u16 = 0x04dc;
    pub const Zlinebelow: u16 = 0x1e94;
    pub const Zmonospace: u16 = 0xff3a;
    pub const Zsmall: u16 = 0xf77a;
    pub const Zstroke: u16 = 0x01b5;
    pub const a: u16 = 0x0061;
    pub const aabengali: u16 = 0x0986;
    pub const aacute: u16 = 0x00e1;
    pub const aadeva: u16 = 0x0906;
    pub const aagujarati: u16 = 0x0a86;
    pub const aagurmukhi: u16 = 0x0a06;
    pub const aamatragurmukhi: u16 = 0x0a3e;
    pub const aarusquare: u16 = 0x3303;
    pub const aavowelsignbengali: u16 = 0x09be;
    pub const aavowelsigndeva: u16 = 0x093e;
    pub const aavowelsigngujarati: u16 = 0x0abe;
    pub const abbreviationmarkarmenian: u16 = 0x055f;
    pub const abbreviationsigndeva: u16 = 0x0970;
    pub const abengali: u16 = 0x0985;
    pub const abopomofo: u16 = 0x311a;
    pub const abreve: u16 = 0x0103;
    pub const abreveacute: u16 = 0x1eaf;
    pub const abrevecyrillic: u16 = 0x04d1;
    pub const abrevedotbelow: u16 = 0x1eb7;
    pub const abrevegrave: u16 = 0x1eb1;
    pub const abrevehookabove: u16 = 0x1eb3;
    pub const abrevetilde: u16 = 0x1eb5;
    pub const acaron: u16 = 0x01ce;
    pub const acircle: u16 = 0x24d0;
    pub const acircumflex: u16 = 0x00e2;
    pub const acircumflexacute: u16 = 0x1ea5;
    pub const acircumflexdotbelow: u16 = 0x1ead;
    pub const acircumflexgrave: u16 = 0x1ea7;
    pub const acircumflexhookabove: u16 = 0x1ea9;
    pub const acircumflextilde: u16 = 0x1eab;
    pub const acute: u16 = 0x00b4;
    pub const acutebelowcmb: u16 = 0x0317;
    pub const acutecmb: u16 = 0x0301;
    pub const acutecomb: u16 = 0x0301;
    pub const acutedeva: u16 = 0x0954;
    pub const acutelowmod: u16 = 0x02cf;
    pub const acutetonecmb: u16 = 0x0341;
    pub const acyrillic: u16 = 0x0430;
    pub const adblgrave: u16 = 0x0201;
    pub const addakgurmukhi: u16 = 0x0a71;
    pub const adeva: u16 = 0x0905;
    pub const adieresis: u16 = 0x00e4;
    pub const adieresiscyrillic: u16 = 0x04d3;
    pub const adieresismacron: u16 = 0x01df;
    pub const adotbelow: u16 = 0x1ea1;
    pub const adotmacron: u16 = 0x01e1;
    pub const ae: u16 = 0x00e6;
    pub const aeacute: u16 = 0x01fd;
    pub const aekorean: u16 = 0x3150;
    pub const aemacron: u16 = 0x01e3;
    pub const afii00208: u16 = 0x2015;
    pub const afii08941: u16 = 0x20a4;
    pub const afii10017: u16 = 0x0410;
    pub const afii10018: u16 = 0x0411;
    pub const afii10019: u16 = 0x0412;
    pub const afii10020: u16 = 0x0413;
    pub const afii10021: u16 = 0x0414;
    pub const afii10022: u16 = 0x0415;
    pub const afii10023: u16 = 0x0401;
    pub const afii10024: u16 = 0x0416;
    pub const afii10025: u16 = 0x0417;
    pub const afii10026: u16 = 0x0418;
    pub const afii10027: u16 = 0x0419;
    pub const afii10028: u16 = 0x041a;
    pub const afii10029: u16 = 0x041b;
    pub const afii10030: u16 = 0x041c;
    pub const afii10031: u16 = 0x041d;
    pub const afii10032: u16 = 0x041e;
    pub const afii10033: u16 = 0x041f;
    pub const afii10034: u16 = 0x0420;
    pub const afii10035: u16 = 0x0421;
    pub const afii10036: u16 = 0x0422;
    pub const afii10037: u16 = 0x0423;
    pub const afii10038: u16 = 0x0424;
    pub const afii10039: u16 = 0x0425;
    pub const afii10040: u16 = 0x0426;
    pub const afii10041: u16 = 0x0427;
    pub const afii10042: u16 = 0x0428;
    pub const afii10043: u16 = 0x0429;
    pub const afii10044: u16 = 0x042a;
    pub const afii10045: u16 = 0x042b;
    pub const afii10046: u16 = 0x042c;
    pub const afii10047: u16 = 0x042d;
    pub const afii10048: u16 = 0x042e;
    pub const afii10049: u16 = 0x042f;
    pub const afii10050: u16 = 0x0490;
    pub const afii10051: u16 = 0x0402;
    pub const afii10052: u16 = 0x0403;
    pub const afii10053: u16 = 0x0404;
    pub const afii10054: u16 = 0x0405;
    pub const afii10055: u16 = 0x0406;
    pub const afii10056: u16 = 0x0407;
    pub const afii10057: u16 = 0x0408;
    pub const afii10058: u16 = 0x0409;
    pub const afii10059: u16 = 0x040a;
    pub const afii10060: u16 = 0x040b;
    pub const afii10061: u16 = 0x040c;
    pub const afii10062: u16 = 0x040e;
    pub const afii10063: u16 = 0xf6c4;
    pub const afii10064: u16 = 0xf6c5;
    pub const afii10065: u16 = 0x0430;
    pub const afii10066: u16 = 0x0431;
    pub const afii10067: u16 = 0x0432;
    pub const afii10068: u16 = 0x0433;
    pub const afii10069: u16 = 0x0434;
    pub const afii10070: u16 = 0x0435;
    pub const afii10071: u16 = 0x0451;
    pub const afii10072: u16 = 0x0436;
    pub const afii10073: u16 = 0x0437;
    pub const afii10074: u16 = 0x0438;
    pub const afii10075: u16 = 0x0439;
    pub const afii10076: u16 = 0x043a;
    pub const afii10077: u16 = 0x043b;
    pub const afii10078: u16 = 0x043c;
    pub const afii10079: u16 = 0x043d;
    pub const afii10080: u16 = 0x043e;
    pub const afii10081: u16 = 0x043f;
    pub const afii10082: u16 = 0x0440;
    pub const afii10083: u16 = 0x0441;
    pub const afii10084: u16 = 0x0442;
    pub const afii10085: u16 = 0x0443;
    pub const afii10086: u16 = 0x0444;
    pub const afii10087: u16 = 0x0445;
    pub const afii10088: u16 = 0x0446;
    pub const afii10089: u16 = 0x0447;
    pub const afii10090: u16 = 0x0448;
    pub const afii10091: u16 = 0x0449;
    pub const afii10092: u16 = 0x044a;
    pub const afii10093: u16 = 0x044b;
    pub const afii10094: u16 = 0x044c;
    pub const afii10095: u16 = 0x044d;
    pub const afii10096: u16 = 0x044e;
    pub const afii10097: u16 = 0x044f;
    pub const afii10098: u16 = 0x0491;
    pub const afii10099: u16 = 0x0452;
    pub const afii10100: u16 = 0x0453;
    pub const afii10101: u16 = 0x0454;
    pub const afii10102: u16 = 0x0455;
    pub const afii10103: u16 = 0x0456;
    pub const afii10104: u16 = 0x0457;
    pub const afii10105: u16 = 0x0458;
    pub const afii10106: u16 = 0x0459;
    pub const afii10107: u16 = 0x045a;
    pub const afii10108: u16 = 0x045b;
    pub const afii10109: u16 = 0x045c;
    pub const afii10110: u16 = 0x045e;
    pub const afii10145: u16 = 0x040f;
    pub const afii10146: u16 = 0x0462;
    pub const afii10147: u16 = 0x0472;
    pub const afii10148: u16 = 0x0474;
    pub const afii10192: u16 = 0xf6c6;
    pub const afii10193: u16 = 0x045f;
    pub const afii10194: u16 = 0x0463;
    pub const afii10195: u16 = 0x0473;
    pub const afii10196: u16 = 0x0475;
    pub const afii10831: u16 = 0xf6c7;
    pub const afii10832: u16 = 0xf6c8;
    pub const afii10846: u16 = 0x04d9;
    pub const afii299: u16 = 0x200e;
    pub const afii300: u16 = 0x200f;
    pub const afii301: u16 = 0x200d;
    pub const afii57381: u16 = 0x066a;
    pub const afii57388: u16 = 0x060c;
    pub const afii57392: u16 = 0x0660;
    pub const afii57393: u16 = 0x0661;
    pub const afii57394: u16 = 0x0662;
    pub const afii57395: u16 = 0x0663;
    pub const afii57396: u16 = 0x0664;
    pub const afii57397: u16 = 0x0665;
    pub const afii57398: u16 = 0x0666;
    pub const afii57399: u16 = 0x0667;
    pub const afii57400: u16 = 0x0668;
    pub const afii57401: u16 = 0x0669;
    pub const afii57403: u16 = 0x061b;
    pub const afii57407: u16 = 0x061f;
    pub const afii57409: u16 = 0x0621;
    pub const afii57410: u16 = 0x0622;
    pub const afii57411: u16 = 0x0623;
    pub const afii57412: u16 = 0x0624;
    pub const afii57413: u16 = 0x0625;
    pub const afii57414: u16 = 0x0626;
    pub const afii57415: u16 = 0x0627;
    pub const afii57416: u16 = 0x0628;
    pub const afii57417: u16 = 0x0629;
    pub const afii57418: u16 = 0x062a;
    pub const afii57419: u16 = 0x062b;
    pub const afii57420: u16 = 0x062c;
    pub const afii57421: u16 = 0x062d;
    pub const afii57422: u16 = 0x062e;
    pub const afii57423: u16 = 0x062f;
    pub const afii57424: u16 = 0x0630;
    pub const afii57425: u16 = 0x0631;
    pub const afii57426: u16 = 0x0632;
    pub const afii57427: u16 = 0x0633;
    pub const afii57428: u16 = 0x0634;
    pub const afii57429: u16 = 0x0635;
    pub const afii57430: u16 = 0x0636;
    pub const afii57431: u16 = 0x0637;
    pub const afii57432: u16 = 0x0638;
    pub const afii57433: u16 = 0x0639;
    pub const afii57434: u16 = 0x063a;
    pub const afii57440: u16 = 0x0640;
    pub const afii57441: u16 = 0x0641;
    pub const afii57442: u16 = 0x0642;
    pub const afii57443: u16 = 0x0643;
    pub const afii57444: u16 = 0x0644;
    pub const afii57445: u16 = 0x0645;
    pub const afii57446: u16 = 0x0646;
    pub const afii57448: u16 = 0x0648;
    pub const afii57449: u16 = 0x0649;
    pub const afii57450: u16 = 0x064a;
    pub const afii57451: u16 = 0x064b;
    pub const afii57452: u16 = 0x064c;
    pub const afii57453: u16 = 0x064d;
    pub const afii57454: u16 = 0x064e;
    pub const afii57455: u16 = 0x064f;
    pub const afii57456: u16 = 0x0650;
    pub const afii57457: u16 = 0x0651;
    pub const afii57458: u16 = 0x0652;
    pub const afii57470: u16 = 0x0647;
    pub const afii57505: u16 = 0x06a4;
    pub const afii57506: u16 = 0x067e;
    pub const afii57507: u16 = 0x0686;
    pub const afii57508: u16 = 0x0698;
    pub const afii57509: u16 = 0x06af;
    pub const afii57511: u16 = 0x0679;
    pub const afii57512: u16 = 0x0688;
    pub const afii57513: u16 = 0x0691;
    pub const afii57514: u16 = 0x06ba;
    pub const afii57519: u16 = 0x06d2;
    pub const afii57534: u16 = 0x06d5;
    pub const afii57636: u16 = 0x20aa;
    pub const afii57645: u16 = 0x05be;
    pub const afii57658: u16 = 0x05c3;
    pub const afii57664: u16 = 0x05d0;
    pub const afii57665: u16 = 0x05d1;
    pub const afii57666: u16 = 0x05d2;
    pub const afii57667: u16 = 0x05d3;
    pub const afii57668: u16 = 0x05d4;
    pub const afii57669: u16 = 0x05d5;
    pub const afii57670: u16 = 0x05d6;
    pub const afii57671: u16 = 0x05d7;
    pub const afii57672: u16 = 0x05d8;
    pub const afii57673: u16 = 0x05d9;
    pub const afii57674: u16 = 0x05da;
    pub const afii57675: u16 = 0x05db;
    pub const afii57676: u16 = 0x05dc;
    pub const afii57677: u16 = 0x05dd;
    pub const afii57678: u16 = 0x05de;
    pub const afii57679: u16 = 0x05df;
    pub const afii57680: u16 = 0x05e0;
    pub const afii57681: u16 = 0x05e1;
    pub const afii57682: u16 = 0x05e2;
    pub const afii57683: u16 = 0x05e3;
    pub const afii57684: u16 = 0x05e4;
    pub const afii57685: u16 = 0x05e5;
    pub const afii57686: u16 = 0x05e6;
    pub const afii57687: u16 = 0x05e7;
    pub const afii57688: u16 = 0x05e8;
    pub const afii57689: u16 = 0x05e9;
    pub const afii57690: u16 = 0x05ea;
    pub const afii57694: u16 = 0xfb2a;
    pub const afii57695: u16 = 0xfb2b;
    pub const afii57700: u16 = 0xfb4b;
    pub const afii57705: u16 = 0xfb1f;
    pub const afii57716: u16 = 0x05f0;
    pub const afii57717: u16 = 0x05f1;
    pub const afii57718: u16 = 0x05f2;
    pub const afii57723: u16 = 0xfb35;
    pub const afii57793: u16 = 0x05b4;
    pub const afii57794: u16 = 0x05b5;
    pub const afii57795: u16 = 0x05b6;
    pub const afii57796: u16 = 0x05bb;
    pub const afii57797: u16 = 0x05b8;
    pub const afii57798: u16 = 0x05b7;
    pub const afii57799: u16 = 0x05b0;
    pub const afii57800: u16 = 0x05b2;
    pub const afii57801: u16 = 0x05b1;
    pub const afii57802: u16 = 0x05b3;
    pub const afii57803: u16 = 0x05c2;
    pub const afii57804: u16 = 0x05c1;
    pub const afii57806: u16 = 0x05b9;
    pub const afii57807: u16 = 0x05bc;
    pub const afii57839: u16 = 0x05bd;
    pub const afii57841: u16 = 0x05bf;
    pub const afii57842: u16 = 0x05c0;
    pub const afii57929: u16 = 0x02bc;
    pub const afii61248: u16 = 0x2105;
    pub const afii61289: u16 = 0x2113;
    pub const afii61352: u16 = 0x2116;
    pub const afii61573: u16 = 0x202c;
    pub const afii61574: u16 = 0x202d;
    pub const afii61575: u16 = 0x202e;
    pub const afii61664: u16 = 0x200c;
    pub const afii63167: u16 = 0x066d;
    pub const afii64937: u16 = 0x02bd;
    pub const agrave: u16 = 0x00e0;
    pub const agujarati: u16 = 0x0a85;
    pub const agurmukhi: u16 = 0x0a05;
    pub const ahiragana: u16 = 0x3042;
    pub const ahookabove: u16 = 0x1ea3;
    pub const aibengali: u16 = 0x0990;
    pub const aibopomofo: u16 = 0x311e;
    pub const aideva: u16 = 0x0910;
    pub const aiecyrillic: u16 = 0x04d5;
    pub const aigujarati: u16 = 0x0a90;
    pub const aigurmukhi: u16 = 0x0a10;
    pub const aimatragurmukhi: u16 = 0x0a48;
    pub const ainarabic: u16 = 0x0639;
    pub const ainfinalarabic: u16 = 0xfeca;
    pub const aininitialarabic: u16 = 0xfecb;
    pub const ainmedialarabic: u16 = 0xfecc;
    pub const ainvertedbreve: u16 = 0x0203;
    pub const aivowelsignbengali: u16 = 0x09c8;
    pub const aivowelsigndeva: u16 = 0x0948;
    pub const aivowelsigngujarati: u16 = 0x0ac8;
    pub const akatakana: u16 = 0x30a2;
    pub const akatakanahalfwidth: u16 = 0xff71;
    pub const akorean: u16 = 0x314f;
    pub const alef: u16 = 0x05d0;
    pub const alefarabic: u16 = 0x0627;
    pub const alefdageshhebrew: u16 = 0xfb30;
    pub const aleffinalarabic: u16 = 0xfe8e;
    pub const alefhamzaabovearabic: u16 = 0x0623;
    pub const alefhamzaabovefinalarabic: u16 = 0xfe84;
    pub const alefhamzabelowarabic: u16 = 0x0625;
    pub const alefhamzabelowfinalarabic: u16 = 0xfe88;
    pub const alefhebrew: u16 = 0x05d0;
    pub const aleflamedhebrew: u16 = 0xfb4f;
    pub const alefmaddaabovearabic: u16 = 0x0622;
    pub const alefmaddaabovefinalarabic: u16 = 0xfe82;
    pub const alefmaksuraarabic: u16 = 0x0649;
    pub const alefmaksurafinalarabic: u16 = 0xfef0;
    pub const alefmaksurainitialarabic: u16 = 0xfef3;
    pub const alefmaksuramedialarabic: u16 = 0xfef4;
    pub const alefpatahhebrew: u16 = 0xfb2e;
    pub const alefqamatshebrew: u16 = 0xfb2f;
    pub const aleph: u16 = 0x2135;
    pub const allequal: u16 = 0x224c;
    pub const alpha: u16 = 0x03b1;
    pub const alphatonos: u16 = 0x03ac;
    pub const altselector: u16 = 0xd802;
    pub const amacron: u16 = 0x0101;
    pub const amonospace: u16 = 0xff41;
    pub const ampersand: u16 = 0x0026;
    pub const ampersandmonospace: u16 = 0xff06;
    pub const ampersandsmall: u16 = 0xf726;
    pub const amsquare: u16 = 0x33c2;
    pub const anbopomofo: u16 = 0x3122;
    pub const angbopomofo: u16 = 0x3124;
    pub const angbracketleft: u16 = 0x27e8;
    pub const angbracketright: u16 = 0x27e9;
    pub const angkhankhuthai: u16 = 0x0e5a;
    pub const angle: u16 = 0x2220;
    pub const anglebracketleft: u16 = 0x3008;
    pub const anglebracketleftvertical: u16 = 0xfe3f;
    pub const anglebracketright: u16 = 0x3009;
    pub const anglebracketrightvertical: u16 = 0xfe40;
    pub const angleleft: u16 = 0x2329;
    pub const angleleftBig: u16 = 0x2329;
    pub const angleleftBigg: u16 = 0x2329;
    pub const angleleftbig: u16 = 0x2329;
    pub const angleleftbigg: u16 = 0x2329;
    pub const angleright: u16 = 0x232a;
    pub const anglerightBig: u16 = 0x232a;
    pub const anglerightBigg: u16 = 0x232a;
    pub const anglerightbig: u16 = 0x232a;
    pub const anglerightbigg: u16 = 0x232a;
    pub const angstrom: u16 = 0x212b;
    pub const anoteleia: u16 = 0x0387;
    pub const anudattadeva: u16 = 0x0952;
    pub const anusvarabengali: u16 = 0x0982;
    pub const anusvaradeva: u16 = 0x0902;
    pub const anusvaragujarati: u16 = 0x0a82;
    pub const aogonek: u16 = 0x0105;
    pub const apaatosquare: u16 = 0x3300;
    pub const aparen: u16 = 0x249c;
    pub const apostrophearmenian: u16 = 0x055a;
    pub const apostrophemod: u16 = 0x02bc;
    pub const apple: u16 = 0xf8ff;
    pub const approaches: u16 = 0x2250;
    pub const approxequal: u16 = 0x2248;
    pub const approxequalorimage: u16 = 0x2252;
    pub const approximatelyequal: u16 = 0x2245;
    pub const araeaekorean: u16 = 0x318e;
    pub const araeakorean: u16 = 0x318d;
    pub const arc: u16 = 0x2312;
    pub const arighthalfring: u16 = 0x1e9a;
    pub const aring: u16 = 0x00e5;
    pub const aringacute: u16 = 0x01fb;
    pub const aringbelow: u16 = 0x1e01;
    pub const arrowboth: u16 = 0x2194;
    pub const arrowbothv: u16 = 0x2195;
    pub const arrowbt: u16 = 0x2193;
    pub const arrowdashdown: u16 = 0x21e3;
    pub const arrowdashleft: u16 = 0x21e0;
    pub const arrowdashright: u16 = 0x21e2;
    pub const arrowdashup: u16 = 0x21e1;
    pub const arrowdblboth: u16 = 0x21d4;
    pub const arrowdblbothv: u16 = 0x21d5;
    pub const arrowdbldown: u16 = 0x21d3;
    pub const arrowdblleft: u16 = 0x21d0;
    pub const arrowdblright: u16 = 0x21d2;
    pub const arrowdbltp: u16 = 0x21d1;
    pub const arrowdblup: u16 = 0x21d1;
    pub const arrowdblvertex: u16 = 0x21d5;
    pub const arrowdown: u16 = 0x2193;
    pub const arrowdownleft: u16 = 0x2199;
    pub const arrowdownright: u16 = 0x2198;
    pub const arrowdownwhite: u16 = 0x21e9;
    pub const arrowheaddownmod: u16 = 0x02c5;
    pub const arrowheadleftmod: u16 = 0x02c2;
    pub const arrowheadrightmod: u16 = 0x02c3;
    pub const arrowheadupmod: u16 = 0x02c4;
    pub const arrowhorizex: u16 = 0xf8e7;
    pub const arrowleft: u16 = 0x2190;
    pub const arrowleftbothalf: u16 = 0x21bd;
    pub const arrowleftdbl: u16 = 0x21d0;
    pub const arrowleftdblstroke: u16 = 0x21cd;
    pub const arrowleftoverright: u16 = 0x21c6;
    pub const arrowlefttophalf: u16 = 0x21bc;
    pub const arrowleftwhite: u16 = 0x21e6;
    pub const arrownortheast: u16 = 0x2197;
    pub const arrownorthwest: u16 = 0x2196;
    pub const arrowright: u16 = 0x2192;
    pub const arrowrightbothalf: u16 = 0x21c1;
    pub const arrowrightdblstroke: u16 = 0x21cf;
    pub const arrowrightheavy: u16 = 0x279e;
    pub const arrowrightoverleft: u16 = 0x21c4;
    pub const arrowrighttophalf: u16 = 0x21c0;
    pub const arrowrightwhite: u16 = 0x21e8;
    pub const arrowsoutheast: u16 = 0x2198;
    pub const arrowsouthwest: u16 = 0x2199;
    pub const arrowtableft: u16 = 0x21e4;
    pub const arrowtabright: u16 = 0x21e5;
    pub const arrowtp: u16 = 0x2191;
    pub const arrowup: u16 = 0x2191;
    pub const arrowupdn: u16 = 0x2195;
    pub const arrowupdnbse: u16 = 0x21a8;
    pub const arrowupdownbase: u16 = 0x21a8;
    pub const arrowupleft: u16 = 0x2196;
    pub const arrowupleftofdown: u16 = 0x21c5;
    pub const arrowupright: u16 = 0x2197;
    pub const arrowupwhite: u16 = 0x21e7;
    pub const arrowvertex: u16 = 0x2195;
    pub const arrowvertex2: u16 = 0xf8e6;
    pub const ascendercompwordmark: u16 = 0xd80a;
    pub const asciicircum: u16 = 0x005e;
    pub const asciicircummonospace: u16 = 0xff3e;
    pub const asciitilde: u16 = 0x007e;
    pub const asciitildemonospace: u16 = 0xff5e;
    pub const ascript: u16 = 0x0251;
    pub const ascriptturned: u16 = 0x0252;
    pub const asmallhiragana: u16 = 0x3041;
    pub const asmallkatakana: u16 = 0x30a1;
    pub const asmallkatakanahalfwidth: u16 = 0xff67;
    pub const asterisk: u16 = 0x002a;
    pub const asteriskaltonearabic: u16 = 0x066d;
    pub const asteriskarabic: u16 = 0x066d;
    pub const asteriskcentered: u16 = 0x2217;
    pub const asteriskmath: u16 = 0x2217;
    pub const asteriskmonospace: u16 = 0xff0a;
    pub const asterisksmall: u16 = 0xfe61;
    pub const asterism: u16 = 0x2042;
    pub const asuperior: u16 = 0xf6e9;
    pub const asymptoticallyequal: u16 = 0x2243;
    pub const at: u16 = 0x0040;
    pub const atilde: u16 = 0x00e3;
    pub const atmonospace: u16 = 0xff20;
    pub const atsmall: u16 = 0xfe6b;
    pub const aturned: u16 = 0x0250;
    pub const aubengali: u16 = 0x0994;
    pub const aubopomofo: u16 = 0x3120;
    pub const audeva: u16 = 0x0914;
    pub const augujarati: u16 = 0x0a94;
    pub const augurmukhi: u16 = 0x0a14;
    pub const aulengthmarkbengali: u16 = 0x09d7;
    pub const aumatragurmukhi: u16 = 0x0a4c;
    pub const auvowelsignbengali: u16 = 0x09cc;
    pub const auvowelsigndeva: u16 = 0x094c;
    pub const auvowelsigngujarati: u16 = 0x0acc;
    pub const avagrahadeva: u16 = 0x093d;
    pub const aybarmenian: u16 = 0x0561;
    pub const ayin: u16 = 0x05e2;
    pub const ayinaltonehebrew: u16 = 0xfb20;
    pub const ayinhebrew: u16 = 0x05e2;
    pub const b: u16 = 0x0062;
    pub const babengali: u16 = 0x09ac;
    pub const backslash: u16 = 0x005c;
    pub const backslashBig: u16 = 0x005c;
    pub const backslashBigg: u16 = 0x005c;
    pub const backslashbig: u16 = 0x005c;
    pub const backslashbigg: u16 = 0x005c;
    pub const backslashmonospace: u16 = 0xff3c;
    pub const badeva: u16 = 0x092c;
    pub const bagujarati: u16 = 0x0aac;
    pub const bagurmukhi: u16 = 0x0a2c;
    pub const bahiragana: u16 = 0x3070;
    pub const bahtthai: u16 = 0x0e3f;
    pub const bakatakana: u16 = 0x30d0;
    pub const bar: u16 = 0x007c;
    pub const bardbl: u16 = 0x2225;
    pub const bardblex: u16 = 0x2016;
    pub const barex: u16 = 0x007c;
    pub const barmonospace: u16 = 0xff5c;
    pub const bbopomofo: u16 = 0x3105;
    pub const bcircle: u16 = 0x24d1;
    pub const bdotaccent: u16 = 0x1e03;
    pub const bdotbelow: u16 = 0x1e05;
    pub const beamedsixteenthnotes: u16 = 0x266c;
    pub const because: u16 = 0x2235;
    pub const becyrillic: u16 = 0x0431;
    pub const beharabic: u16 = 0x0628;
    pub const behfinalarabic: u16 = 0xfe90;
    pub const behinitialarabic: u16 = 0xfe91;
    pub const behiragana: u16 = 0x3079;
    pub const behmedialarabic: u16 = 0xfe92;
    pub const behmeeminitialarabic: u16 = 0xfc9f;
    pub const behmeemisolatedarabic: u16 = 0xfc08;
    pub const behnoonfinalarabic: u16 = 0xfc6d;
    pub const bekatakana: u16 = 0x30d9;
    pub const benarmenian: u16 = 0x0562;
    pub const bet: u16 = 0x05d1;
    pub const beta: u16 = 0x03b2;
    pub const betasymbolgreek: u16 = 0x03d0;
    pub const betdagesh: u16 = 0xfb31;
    pub const betdageshhebrew: u16 = 0xfb31;
    pub const bethebrew: u16 = 0x05d1;
    pub const betrafehebrew: u16 = 0xfb4c;
    pub const bhabengali: u16 = 0x09ad;
    pub const bhadeva: u16 = 0x092d;
    pub const bhagujarati: u16 = 0x0aad;
    pub const bhagurmukhi: u16 = 0x0a2d;
    pub const bhook: u16 = 0x0253;
    pub const bihiragana: u16 = 0x3073;
    pub const bikatakana: u16 = 0x30d3;
    pub const bilabialclick: u16 = 0x0298;
    pub const bindigurmukhi: u16 = 0x0a02;
    pub const birusquare: u16 = 0x3331;
    pub const blackcircle: u16 = 0x25cf;
    pub const blackdiamond: u16 = 0x25c6;
    pub const blackdownpointingtriangle: u16 = 0x25bc;
    pub const blackleftpointingpointer: u16 = 0x25c4;
    pub const blackleftpointingtriangle: u16 = 0x25c0;
    pub const blacklenticularbracketleft: u16 = 0x3010;
    pub const blacklenticularbracketleftvertical: u16 = 0xfe3b;
    pub const blacklenticularbracketright: u16 = 0x3011;
    pub const blacklenticularbracketrightvertical: u16 = 0xfe3c;
    pub const blacklowerlefttriangle: u16 = 0x25e3;
    pub const blacklowerrighttriangle: u16 = 0x25e2;
    pub const blackrectangle: u16 = 0x25ac;
    pub const blackrightpointingpointer: u16 = 0x25ba;
    pub const blackrightpointingtriangle: u16 = 0x25b6;
    pub const blacksmallsquare: u16 = 0x25aa;
    pub const blacksmilingface: u16 = 0x263b;
    pub const blacksquare: u16 = 0x25a0;
    pub const blackstar: u16 = 0x2605;
    pub const blackupperlefttriangle: u16 = 0x25e4;
    pub const blackupperrighttriangle: u16 = 0x25e5;
    pub const blackuppointingsmalltriangle: u16 = 0x25b4;
    pub const blackuppointingtriangle: u16 = 0x25b2;
    pub const blank: u16 = 0x2423;
    pub const blinebelow: u16 = 0x1e07;
    pub const block: u16 = 0x2588;
    pub const bmonospace: u16 = 0xff42;
    pub const bobaimaithai: u16 = 0x0e1a;
    pub const bohiragana: u16 = 0x307c;
    pub const bokatakana: u16 = 0x30dc;
    pub const bparen: u16 = 0x249d;
    pub const bqsquare: u16 = 0x33c3;
    pub const braceex: u16 = 0x007c;
    pub const braceex2: u16 = 0xf8f4;
    pub const braceleft: u16 = 0x007b;
    pub const braceleftBig: u16 = 0x007b;
    pub const braceleftBigg: u16 = 0x007b;
    pub const braceleftbig: u16 = 0x007b;
    pub const braceleftbigg: u16 = 0x007b;
    pub const braceleftbt: u16 = 0xf8f3;
    pub const braceleftmid: u16 = 0x007c;
    pub const braceleftmid2: u16 = 0xf8f2;
    pub const braceleftmonospace: u16 = 0xff5b;
    pub const braceleftsmall: u16 = 0xfe5b;
    pub const bracelefttp: u16 = 0xf8f1;
    pub const braceleftvertical: u16 = 0xfe37;
    pub const braceright: u16 = 0x007d;
    pub const bracerightBig: u16 = 0x007d;
    pub const bracerightBigg: u16 = 0x007d;
    pub const bracerightbig: u16 = 0x007d;
    pub const bracerightbigg: u16 = 0x007d;
    pub const bracerightbt: u16 = 0xf8fe;
    pub const bracerightmid: u16 = 0x2016;
    pub const bracerightmid2: u16 = 0xf8fd;
    pub const bracerightmonospace: u16 = 0xff5d;
    pub const bracerightsmall: u16 = 0xfe5c;
    pub const bracerighttp: u16 = 0xf8fc;
    pub const bracerightvertical: u16 = 0xfe38;
    pub const bracketleft: u16 = 0x005b;
    pub const bracketleftBig: u16 = 0x005b;
    pub const bracketleftBigg: u16 = 0x005b;
    pub const bracketleftbig: u16 = 0x005b;
    pub const bracketleftbigg: u16 = 0x005b;
    pub const bracketleftbt: u16 = 0xf8f0;
    pub const bracketleftex: u16 = 0xf8ef;
    pub const bracketleftmonospace: u16 = 0xff3b;
    pub const bracketlefttp: u16 = 0xf8ee;
    pub const bracketright: u16 = 0x005d;
    pub const bracketrightBig: u16 = 0x005d;
    pub const bracketrightBigg: u16 = 0x005d;
    pub const bracketrightbig: u16 = 0x005d;
    pub const bracketrightbigg: u16 = 0x005d;
    pub const bracketrightbt: u16 = 0xf8fb;
    pub const bracketrightex: u16 = 0xf8fa;
    pub const bracketrightmonospace: u16 = 0xff3d;
    pub const bracketrighttp: u16 = 0xf8f9;
    pub const breve: u16 = 0x02d8;
    pub const brevebelowcmb: u16 = 0x032e;
    pub const brevecmb: u16 = 0x0306;
    pub const breveinvertedbelowcmb: u16 = 0x032f;
    pub const breveinvertedcmb: u16 = 0x0311;
    pub const breveinverteddoublecmb: u16 = 0x0361;
    pub const bridgebelowcmb: u16 = 0x032a;
    pub const bridgeinvertedbelowcmb: u16 = 0x033a;
    pub const brokenbar: u16 = 0x00a6;
    pub const bstroke: u16 = 0x0180;
    pub const bsuperior: u16 = 0xf6ea;
    pub const btopbar: u16 = 0x0183;
    pub const buhiragana: u16 = 0x3076;
    pub const bukatakana: u16 = 0x30d6;
    pub const bullet: u16 = 0x2022;
    pub const bulletinverse: u16 = 0x25d8;
    pub const bulletoperator: u16 = 0x2219;
    pub const bullseye: u16 = 0x25ce;
    pub const c: u16 = 0x0063;
    pub const caarmenian: u16 = 0x056e;
    pub const cabengali: u16 = 0x099a;
    pub const cacute: u16 = 0x0107;
    pub const cadeva: u16 = 0x091a;
    pub const cagujarati: u16 = 0x0a9a;
    pub const cagurmukhi: u16 = 0x0a1a;
    pub const calsquare: u16 = 0x3388;
    pub const candrabindubengali: u16 = 0x0981;
    pub const candrabinducmb: u16 = 0x0310;
    pub const candrabindudeva: u16 = 0x0901;
    pub const candrabindugujarati: u16 = 0x0a81;
    pub const capitalcompwordmark: u16 = 0xd809;
    pub const capslock: u16 = 0x21ea;
    pub const careof: u16 = 0x2105;
    pub const caron: u16 = 0x02c7;
    pub const caronbelowcmb: u16 = 0x032c;
    pub const caroncmb: u16 = 0x030c;
    pub const carriagereturn: u16 = 0x21b5;
    pub const cbopomofo: u16 = 0x3118;
    pub const ccaron: u16 = 0x010d;
    pub const ccedilla: u16 = 0x00e7;
    pub const ccedillaacute: u16 = 0x1e09;
    pub const ccircle: u16 = 0x24d2;
    pub const ccircumflex: u16 = 0x0109;
    pub const ccurl: u16 = 0x0255;
    pub const cdot: u16 = 0x010b;
    pub const cdotaccent: u16 = 0x010b;
    pub const cdsquare: u16 = 0x33c5;
    pub const cedilla: u16 = 0x00b8;
    pub const cedillacmb: u16 = 0x0327;
    pub const ceilingleft: u16 = 0x2308;
    pub const ceilingleftBig: u16 = 0x2308;
    pub const ceilingleftBigg: u16 = 0x2308;
    pub const ceilingleftbig: u16 = 0x2308;
    pub const ceilingleftbigg: u16 = 0x2308;
    pub const ceilingright: u16 = 0x2309;
    pub const ceilingrightBig: u16 = 0x2309;
    pub const ceilingrightBigg: u16 = 0x2309;
    pub const ceilingrightbig: u16 = 0x2309;
    pub const ceilingrightbigg: u16 = 0x2309;
    pub const cent: u16 = 0x00a2;
    pub const centigrade: u16 = 0x2103;
    pub const centinferior: u16 = 0xf6df;
    pub const centmonospace: u16 = 0xffe0;
    pub const centoldstyle: u16 = 0xf7a2;
    pub const centsuperior: u16 = 0xf6e0;
    pub const chaarmenian: u16 = 0x0579;
    pub const chabengali: u16 = 0x099b;
    pub const chadeva: u16 = 0x091b;
    pub const chagujarati: u16 = 0x0a9b;
    pub const chagurmukhi: u16 = 0x0a1b;
    pub const chbopomofo: u16 = 0x3114;
    pub const cheabkhasiancyrillic: u16 = 0x04bd;
    pub const checkmark: u16 = 0x2713;
    pub const checyrillic: u16 = 0x0447;
    pub const chedescenderabkhasiancyrillic: u16 = 0x04bf;
    pub const chedescendercyrillic: u16 = 0x04b7;
    pub const chedieresiscyrillic: u16 = 0x04f5;
    pub const cheharmenian: u16 = 0x0573;
    pub const chekhakassiancyrillic: u16 = 0x04cc;
    pub const cheverticalstrokecyrillic: u16 = 0x04b9;
    pub const chi: u16 = 0x03c7;
    pub const chieuchacirclekorean: u16 = 0x3277;
    pub const chieuchaparenkorean: u16 = 0x3217;
    pub const chieuchcirclekorean: u16 = 0x3269;
    pub const chieuchkorean: u16 = 0x314a;
    pub const chieuchparenkorean: u16 = 0x3209;
    pub const chochangthai: u16 = 0x0e0a;
    pub const chochanthai: u16 = 0x0e08;
    pub const chochingthai: u16 = 0x0e09;
    pub const chochoethai: u16 = 0x0e0c;
    pub const chook: u16 = 0x0188;
    pub const cieucacirclekorean: u16 = 0x3276;
    pub const cieucaparenkorean: u16 = 0x3216;
    pub const cieuccirclekorean: u16 = 0x3268;
    pub const cieuckorean: u16 = 0x3148;
    pub const cieucparenkorean: u16 = 0x3208;
    pub const cieucuparenkorean: u16 = 0x321c;
    pub const circle: u16 = 0x25cb;
    pub const circlecopyrt: u16 = 0x20dd;
    pub const circledivide: u16 = 0x2298;
    pub const circledot: u16 = 0x2299;
    pub const circledotdisplay: u16 = 0x2299;
    pub const circledottext: u16 = 0x2299;
    pub const circleminus: u16 = 0x2296;
    pub const circlemultiply: u16 = 0x2297;
    pub const circlemultiplydisplay: u16 = 0x2297;
    pub const circlemultiplytext: u16 = 0x2297;
    pub const circleot: u16 = 0x2299;
    pub const circleplus: u16 = 0x2295;
    pub const circleplusdisplay: u16 = 0x2295;
    pub const circleplustext: u16 = 0x2295;
    pub const circlepostalmark: u16 = 0x3036;
    pub const circlewithlefthalfblack: u16 = 0x25d0;
    pub const circlewithrighthalfblack: u16 = 0x25d1;
    pub const circumflex: u16 = 0x02c6;
    pub const circumflexbelowcmb: u16 = 0x032d;
    pub const circumflexcmb: u16 = 0x0302;
    pub const clear: u16 = 0x2327;
    pub const clickalveolar: u16 = 0x01c2;
    pub const clickdental: u16 = 0x01c0;
    pub const clicklateral: u16 = 0x01c1;
    pub const clickretroflex: u16 = 0x01c3;
    pub const club: u16 = 0x2663;
    pub const clubsuitblack: u16 = 0x2663;
    pub const clubsuitwhite: u16 = 0x2667;
    pub const cmcubedsquare: u16 = 0x33a4;
    pub const cmonospace: u16 = 0xff43;
    pub const cmsquaredsquare: u16 = 0x33a0;
    pub const coarmenian: u16 = 0x0581;
    pub const colon: u16 = 0x003a;
    pub const colonmonetary: u16 = 0x20a1;
    pub const colonmonospace: u16 = 0xff1a;
    pub const colonsign: u16 = 0x20a1;
    pub const colonsmall: u16 = 0xfe55;
    pub const colontriangularhalfmod: u16 = 0x02d1;
    pub const colontriangularmod: u16 = 0x02d0;
    pub const comma: u16 = 0x002c;
    pub const commaabovecmb: u16 = 0x0313;
    pub const commaaboverightcmb: u16 = 0x0315;
    pub const commaaccent: u16 = 0xf6c3;
    pub const commaarabic: u16 = 0x060c;
    pub const commaarmenian: u16 = 0x055d;
    pub const commainferior: u16 = 0xf6e1;
    pub const commamonospace: u16 = 0xff0c;
    pub const commareversedabovecmb: u16 = 0x0314;
    pub const commareversedmod: u16 = 0x02bd;
    pub const commasmall: u16 = 0xfe50;
    pub const commasuperior: u16 = 0xf6e2;
    pub const commaturnedabovecmb: u16 = 0x0312;
    pub const commaturnedmod: u16 = 0x02bb;
    pub const compass: u16 = 0x263c;
    pub const compwordmark: u16 = 0x200c;
    pub const congruent: u16 = 0x2245;
    pub const contintegraldisplay: u16 = 0x222e;
    pub const contintegraltext: u16 = 0x222e;
    pub const contourintegral: u16 = 0x222e;
    pub const control: u16 = 0x2303;
    pub const controlACK: u16 = 0x0006;
    pub const controlBEL: u16 = 0x0007;
    pub const controlBS: u16 = 0x0008;
    pub const controlCAN: u16 = 0x0018;
    pub const controlCR: u16 = 0x000d;
    pub const controlDC1: u16 = 0x0011;
    pub const controlDC2: u16 = 0x0012;
    pub const controlDC3: u16 = 0x0013;
    pub const controlDC4: u16 = 0x0014;
    pub const controlDEL: u16 = 0x007f;
    pub const controlDLE: u16 = 0x0010;
    pub const controlEM: u16 = 0x0019;
    pub const controlENQ: u16 = 0x0005;
    pub const controlEOT: u16 = 0x0004;
    pub const controlESC: u16 = 0x001b;
    pub const controlETB: u16 = 0x0017;
    pub const controlETX: u16 = 0x0003;
    pub const controlFF: u16 = 0x000c;
    pub const controlFS: u16 = 0x001c;
    pub const controlGS: u16 = 0x001d;
    pub const controlHT: u16 = 0x0009;
    pub const controlLF: u16 = 0x000a;
    pub const controlNAK: u16 = 0x0015;
    pub const controlRS: u16 = 0x001e;
    pub const controlSI: u16 = 0x000f;
    pub const controlSO: u16 = 0x000e;
    pub const controlSOT: u16 = 0x0002;
    pub const controlSTX: u16 = 0x0001;
    pub const controlSUB: u16 = 0x001a;
    pub const controlSYN: u16 = 0x0016;
    pub const controlUS: u16 = 0x001f;
    pub const controlVT: u16 = 0x000b;
    pub const coproduct: u16 = 0x2a3f;
    pub const coproductdisplay: u16 = 0x2210;
    pub const coproducttext: u16 = 0x2210;
    pub const copyright: u16 = 0x00a9;
    pub const copyrightsans: u16 = 0xf8e9;
    pub const copyrightserif: u16 = 0xf6d9;
    pub const cornerbracketleft: u16 = 0x300c;
    pub const cornerbracketlefthalfwidth: u16 = 0xff62;
    pub const cornerbracketleftvertical: u16 = 0xfe41;
    pub const cornerbracketright: u16 = 0x300d;
    pub const cornerbracketrighthalfwidth: u16 = 0xff63;
    pub const cornerbracketrightvertical: u16 = 0xfe42;
    pub const corporationsquare: u16 = 0x337f;
    pub const cosquare: u16 = 0x33c7;
    pub const coverkgsquare: u16 = 0x33c6;
    pub const cparen: u16 = 0x249e;
    pub const cruzeiro: u16 = 0x20a2;
    pub const cstretched: u16 = 0x0297;
    pub const curlyand: u16 = 0x22cf;
    pub const curlyor: u16 = 0x22ce;
    pub const currency: u16 = 0x00a4;
    pub const cwm: u16 = 0x200c;
    pub const cyrBreve: u16 = 0xf6d1;
    pub const cyrFlex: u16 = 0xf6d2;
    pub const cyrbreve: u16 = 0xf6d4;
    pub const cyrflex: u16 = 0xf6d5;
    pub const d: u16 = 0x0064;
    pub const daarmenian: u16 = 0x0564;
    pub const dabengali: u16 = 0x09a6;
    pub const dadarabic: u16 = 0x0636;
    pub const dadeva: u16 = 0x0926;
    pub const dadfinalarabic: u16 = 0xfebe;
    pub const dadinitialarabic: u16 = 0xfebf;
    pub const dadmedialarabic: u16 = 0xfec0;
    pub const dagesh: u16 = 0x05bc;
    pub const dageshhebrew: u16 = 0x05bc;
    pub const dagger: u16 = 0x2020;
    pub const daggerdbl: u16 = 0x2021;
    pub const dagujarati: u16 = 0x0aa6;
    pub const dagurmukhi: u16 = 0x0a26;
    pub const dahiragana: u16 = 0x3060;
    pub const dakatakana: u16 = 0x30c0;
    pub const dalarabic: u16 = 0x062f;
    pub const dalet: u16 = 0x05d3;
    pub const daletdagesh: u16 = 0xfb33;
    pub const daletdageshhebrew: u16 = 0xfb33;
    pub const dalethatafpatah: u16 = 0x05d3;
    pub const dalethatafpatahhebrew: u16 = 0x05d3;
    pub const dalethatafsegol: u16 = 0x05d3;
    pub const dalethatafsegolhebrew: u16 = 0x05d3;
    pub const dalethebrew: u16 = 0x05d3;
    pub const dalethiriq: u16 = 0x05d3;
    pub const dalethiriqhebrew: u16 = 0x05d3;
    pub const daletholam: u16 = 0x05d3;
    pub const daletholamhebrew: u16 = 0x05d3;
    pub const daletpatah: u16 = 0x05d3;
    pub const daletpatahhebrew: u16 = 0x05d3;
    pub const daletqamats: u16 = 0x05d3;
    pub const daletqamatshebrew: u16 = 0x05d3;
    pub const daletqubuts: u16 = 0x05d3;
    pub const daletqubutshebrew: u16 = 0x05d3;
    pub const daletsegol: u16 = 0x05d3;
    pub const daletsegolhebrew: u16 = 0x05d3;
    pub const daletsheva: u16 = 0x05d3;
    pub const daletshevahebrew: u16 = 0x05d3;
    pub const dalettsere: u16 = 0x05d3;
    pub const dalettserehebrew: u16 = 0x05d3;
    pub const dalfinalarabic: u16 = 0xfeaa;
    pub const dammaarabic: u16 = 0x064f;
    pub const dammalowarabic: u16 = 0x064f;
    pub const dammatanaltonearabic: u16 = 0x064c;
    pub const dammatanarabic: u16 = 0x064c;
    pub const danda: u16 = 0x0964;
    pub const dargahebrew: u16 = 0x05a7;
    pub const dargalefthebrew: u16 = 0x05a7;
    pub const dasiapneumatacyrilliccmb: u16 = 0x0485;
    pub const dbar: u16 = 0x0111;
    pub const dblGrave: u16 = 0xf6d3;
    pub const dblanglebracketleft: u16 = 0x300a;
    pub const dblanglebracketleftvertical: u16 = 0xfe3d;
    pub const dblanglebracketright: u16 = 0x300b;
    pub const dblanglebracketrightvertical: u16 = 0xfe3e;
    pub const dblarchinvertedbelowcmb: u16 = 0x032b;
    pub const dblarrowleft: u16 = 0x21d4;
    pub const dblarrowright: u16 = 0x21d2;
    pub const dblbracketleft: u16 = 0x27e6;
    pub const dblbracketright: u16 = 0x27e7;
    pub const dbldanda: u16 = 0x0965;
    pub const dblgrave: u16 = 0xf6d6;
    pub const dblgravecmb: u16 = 0x030f;
    pub const dblintegral: u16 = 0x222c;
    pub const dbllowline: u16 = 0x2017;
    pub const dbllowlinecmb: u16 = 0x0333;
    pub const dbloverlinecmb: u16 = 0x033f;
    pub const dblprimemod: u16 = 0x02ba;
    pub const dblverticalbar: u16 = 0x2016;
    pub const dblverticallineabovecmb: u16 = 0x030e;
    pub const dbopomofo: u16 = 0x3109;
    pub const dbsquare: u16 = 0x33c8;
    pub const dcaron: u16 = 0x010f;
    pub const dcedilla: u16 = 0x1e11;
    pub const dcircle: u16 = 0x24d3;
    pub const dcircumflexbelow: u16 = 0x1e13;
    pub const dcroat: u16 = 0x0111;
    pub const ddabengali: u16 = 0x09a1;
    pub const ddadeva: u16 = 0x0921;
    pub const ddagujarati: u16 = 0x0aa1;
    pub const ddagurmukhi: u16 = 0x0a21;
    pub const ddalarabic: u16 = 0x0688;
    pub const ddalfinalarabic: u16 = 0xfb89;
    pub const dddhadeva: u16 = 0x095c;
    pub const ddhabengali: u16 = 0x09a2;
    pub const ddhadeva: u16 = 0x0922;
    pub const ddhagujarati: u16 = 0x0aa2;
    pub const ddhagurmukhi: u16 = 0x0a22;
    pub const ddotaccent: u16 = 0x1e0b;
    pub const ddotbelow: u16 = 0x1e0d;
    pub const decimalseparatorarabic: u16 = 0x066b;
    pub const decimalseparatorpersian: u16 = 0x066b;
    pub const decyrillic: u16 = 0x0434;
    pub const degree: u16 = 0x00b0;
    pub const dehihebrew: u16 = 0x05ad;
    pub const dehiragana: u16 = 0x3067;
    pub const deicoptic: u16 = 0x03ef;
    pub const dekatakana: u16 = 0x30c7;
    pub const deleteleft: u16 = 0x232b;
    pub const deleteright: u16 = 0x2326;
    pub const delta: u16 = 0x03b4;
    pub const deltaturned: u16 = 0x018d;
    pub const denominatorminusonenumeratorbengali: u16 = 0x09f8;
    pub const dezh: u16 = 0x02a4;
    pub const dhabengali: u16 = 0x09a7;
    pub const dhadeva: u16 = 0x0927;
    pub const dhagujarati: u16 = 0x0aa7;
    pub const dhagurmukhi: u16 = 0x0a27;
    pub const dhook: u16 = 0x0257;
    pub const dialytikatonos: u16 = 0x0385;
    pub const dialytikatonoscmb: u16 = 0x0344;
    pub const diamond: u16 = 0x2662;
    pub const diamond2: u16 = 0x2666;
    pub const diamondmath: u16 = 0x22c4;
    pub const diamondsuitwhite: u16 = 0x2662;
    pub const dieresis: u16 = 0x00a8;
    pub const dieresisacute: u16 = 0xf6d7;
    pub const dieresisbelowcmb: u16 = 0x0324;
    pub const dieresiscmb: u16 = 0x0308;
    pub const dieresisgrave: u16 = 0xf6d8;
    pub const dieresistonos: u16 = 0x0385;
    pub const dihiragana: u16 = 0x3062;
    pub const dikatakana: u16 = 0x30c2;
    pub const dittomark: u16 = 0x3003;
    pub const divide: u16 = 0x00f7;
    pub const divides: u16 = 0x2223;
    pub const divisionslash: u16 = 0x2215;
    pub const djecyrillic: u16 = 0x0452;
    pub const dkshade: u16 = 0x2593;
    pub const dlinebelow: u16 = 0x1e0f;
    pub const dlsquare: u16 = 0x3397;
    pub const dmacron: u16 = 0x0111;
    pub const dmonospace: u16 = 0xff44;
    pub const dnblock: u16 = 0x2584;
    pub const dochadathai: u16 = 0x0e0e;
    pub const dodekthai: u16 = 0x0e14;
    pub const dohiragana: u16 = 0x3069;
    pub const dokatakana: u16 = 0x30c9;
    pub const dollar: u16 = 0x0024;
    pub const dollarinferior: u16 = 0xf6e3;
    pub const dollarmonospace: u16 = 0xff04;
    pub const dollaroldstyle: u16 = 0xf724;
    pub const dollarsmall: u16 = 0xfe69;
    pub const dollarsuperior: u16 = 0xf6e4;
    pub const dong: u16 = 0x20ab;
    pub const dorusquare: u16 = 0x3326;
    pub const dotaccent: u16 = 0x02d9;
    pub const dotaccentcmb: u16 = 0x0307;
    pub const dotbelowcmb: u16 = 0x0323;
    pub const dotbelowcomb: u16 = 0x0323;
    pub const dotkatakana: u16 = 0x30fb;
    pub const dotlessi: u16 = 0x0131;
    pub const dotlessj: u16 = 0x0237;
    pub const dotlessj2: u16 = 0xf6be;
    pub const dotlessjstrokehook: u16 = 0x0284;
    pub const dotmath: u16 = 0x22c5;
    pub const dottedcircle: u16 = 0x25cc;
    pub const doubleyodpatah: u16 = 0xfb1f;
    pub const doubleyodpatahhebrew: u16 = 0xfb1f;
    pub const downtackbelowcmb: u16 = 0x031e;
    pub const downtackmod: u16 = 0x02d5;
    pub const dparen: u16 = 0x249f;
    pub const dsuperior: u16 = 0xf6eb;
    pub const dtail: u16 = 0x0256;
    pub const dtopbar: u16 = 0x018c;
    pub const duhiragana: u16 = 0x3065;
    pub const dukatakana: u16 = 0x30c5;
    pub const dz: u16 = 0x01f3;
    pub const dzaltone: u16 = 0x02a3;
    pub const dzcaron: u16 = 0x01c6;
    pub const dzcurl: u16 = 0x02a5;
    pub const dzeabkhasiancyrillic: u16 = 0x04e1;
    pub const dzecyrillic: u16 = 0x0455;
    pub const dzhecyrillic: u16 = 0x045f;
    pub const e: u16 = 0x0065;
    pub const eacute: u16 = 0x00e9;
    pub const earth: u16 = 0x2641;
    pub const ebengali: u16 = 0x098f;
    pub const ebopomofo: u16 = 0x311c;
    pub const ebreve: u16 = 0x0115;
    pub const ecandradeva: u16 = 0x090d;
    pub const ecandragujarati: u16 = 0x0a8d;
    pub const ecandravowelsigndeva: u16 = 0x0945;
    pub const ecandravowelsigngujarati: u16 = 0x0ac5;
    pub const ecaron: u16 = 0x011b;
    pub const ecedillabreve: u16 = 0x1e1d;
    pub const echarmenian: u16 = 0x0565;
    pub const echyiwnarmenian: u16 = 0x0587;
    pub const ecircle: u16 = 0x24d4;
    pub const ecircumflex: u16 = 0x00ea;
    pub const ecircumflexacute: u16 = 0x1ebf;
    pub const ecircumflexbelow: u16 = 0x1e19;
    pub const ecircumflexdotbelow: u16 = 0x1ec7;
    pub const ecircumflexgrave: u16 = 0x1ec1;
    pub const ecircumflexhookabove: u16 = 0x1ec3;
    pub const ecircumflextilde: u16 = 0x1ec5;
    pub const ecyrillic: u16 = 0x0454;
    pub const edblgrave: u16 = 0x0205;
    pub const edeva: u16 = 0x090f;
    pub const edieresis: u16 = 0x00eb;
    pub const edot: u16 = 0x0117;
    pub const edotaccent: u16 = 0x0117;
    pub const edotbelow: u16 = 0x1eb9;
    pub const eegurmukhi: u16 = 0x0a0f;
    pub const eematragurmukhi: u16 = 0x0a47;
    pub const efcyrillic: u16 = 0x0444;
    pub const egrave: u16 = 0x00e8;
    pub const egujarati: u16 = 0x0a8f;
    pub const eharmenian: u16 = 0x0567;
    pub const ehbopomofo: u16 = 0x311d;
    pub const ehiragana: u16 = 0x3048;
    pub const ehookabove: u16 = 0x1ebb;
    pub const eibopomofo: u16 = 0x311f;
    pub const eight: u16 = 0x0038;
    pub const eightarabic: u16 = 0x0668;
    pub const eightbengali: u16 = 0x09ee;
    pub const eightcircle: u16 = 0x2467;
    pub const eightcircleinversesansserif: u16 = 0x2791;
    pub const eightdeva: u16 = 0x096e;
    pub const eighteencircle: u16 = 0x2471;
    pub const eighteenparen: u16 = 0x2485;
    pub const eighteenperiod: u16 = 0x2499;
    pub const eightgujarati: u16 = 0x0aee;
    pub const eightgurmukhi: u16 = 0x0a6e;
    pub const eighthackarabic: u16 = 0x0668;
    pub const eighthangzhou: u16 = 0x3028;
    pub const eighthnotebeamed: u16 = 0x266b;
    pub const eightideographicparen: u16 = 0x3227;
    pub const eightinferior: u16 = 0x2088;
    pub const eightmonospace: u16 = 0xff18;
    pub const eightoldstyle: u16 = 0xf738;
    pub const eightparen: u16 = 0x247b;
    pub const eightperiod: u16 = 0x248f;
    pub const eightpersian: u16 = 0x06f8;
    pub const eightroman: u16 = 0x2177;
    pub const eightsuperior: u16 = 0x2078;
    pub const eightthai: u16 = 0x0e58;
    pub const einvertedbreve: u16 = 0x0207;
    pub const eiotifiedcyrillic: u16 = 0x0465;
    pub const ekatakana: u16 = 0x30a8;
    pub const ekatakanahalfwidth: u16 = 0xff74;
    pub const ekonkargurmukhi: u16 = 0x0a74;
    pub const ekorean: u16 = 0x3154;
    pub const elcyrillic: u16 = 0x043b;
    pub const element: u16 = 0x2208;
    pub const elevencircle: u16 = 0x246a;
    pub const elevenparen: u16 = 0x247e;
    pub const elevenperiod: u16 = 0x2492;
    pub const elevenroman: u16 = 0x217a;
    pub const ellipsis: u16 = 0x2026;
    pub const ellipsisvertical: u16 = 0x22ee;
    pub const emacron: u16 = 0x0113;
    pub const emacronacute: u16 = 0x1e17;
    pub const emacrongrave: u16 = 0x1e15;
    pub const emcyrillic: u16 = 0x043c;
    pub const emdash: u16 = 0x2014;
    pub const emdashvertical: u16 = 0xfe31;
    pub const emonospace: u16 = 0xff45;
    pub const emphasismarkarmenian: u16 = 0x055b;
    pub const emptyset: u16 = 0x2205;
    pub const emptyslot: u16 = 0xd801;
    pub const enbopomofo: u16 = 0x3123;
    pub const encyrillic: u16 = 0x043d;
    pub const endash: u16 = 0x2013;
    pub const endashvertical: u16 = 0xfe32;
    pub const endescendercyrillic: u16 = 0x04a3;
    pub const eng: u16 = 0x014b;
    pub const engbopomofo: u16 = 0x3125;
    pub const enghecyrillic: u16 = 0x04a5;
    pub const enhookcyrillic: u16 = 0x04c8;
    pub const enspace: u16 = 0x2002;
    pub const eogonek: u16 = 0x0119;
    pub const eokorean: u16 = 0x3153;
    pub const eopen: u16 = 0x025b;
    pub const eopenclosed: u16 = 0x029a;
    pub const eopenreversed: u16 = 0x025c;
    pub const eopenreversedclosed: u16 = 0x025e;
    pub const eopenreversedhook: u16 = 0x025d;
    pub const eparen: u16 = 0x24a0;
    pub const epsilon: u16 = 0x03b5;
    pub const epsilon1: u16 = 0x03f5;
    pub const epsilontonos: u16 = 0x03ad;
    pub const equal: u16 = 0x003d;
    pub const equalmonospace: u16 = 0xff1d;
    pub const equalsmall: u16 = 0xfe66;
    pub const equalsuperior: u16 = 0x207c;
    pub const equivalence: u16 = 0x2261;
    pub const equivasymptotic: u16 = 0x224d;
    pub const erbopomofo: u16 = 0x3126;
    pub const ercyrillic: u16 = 0x0440;
    pub const ereversed: u16 = 0x0258;
    pub const ereversedcyrillic: u16 = 0x044d;
    pub const escyrillic: u16 = 0x0441;
    pub const esdescendercyrillic: u16 = 0x04ab;
    pub const esh: u16 = 0x0283;
    pub const eshcurl: u16 = 0x0286;
    pub const eshortdeva: u16 = 0x090e;
    pub const eshortvowelsigndeva: u16 = 0x0946;
    pub const eshreversedloop: u16 = 0x01aa;
    pub const eshsquatreversed: u16 = 0x0285;
    pub const esmallhiragana: u16 = 0x3047;
    pub const esmallkatakana: u16 = 0x30a7;
    pub const esmallkatakanahalfwidth: u16 = 0xff6a;
    pub const estimated: u16 = 0x212e;
    pub const esuperior: u16 = 0xf6ec;
    pub const eta: u16 = 0x03b7;
    pub const etarmenian: u16 = 0x0568;
    pub const etatonos: u16 = 0x03ae;
    pub const eth: u16 = 0x00f0;
    pub const etilde: u16 = 0x1ebd;
    pub const etildebelow: u16 = 0x1e1b;
    pub const etnahtafoukhhebrew: u16 = 0x0591;
    pub const etnahtafoukhlefthebrew: u16 = 0x0591;
    pub const etnahtahebrew: u16 = 0x0591;
    pub const etnahtalefthebrew: u16 = 0x0591;
    pub const eturned: u16 = 0x01dd;
    pub const eukorean: u16 = 0x3161;
    pub const euro: u16 = 0x20ac;
    pub const evowelsignbengali: u16 = 0x09c7;
    pub const evowelsigndeva: u16 = 0x0947;
    pub const evowelsigngujarati: u16 = 0x0ac7;
    pub const exclam: u16 = 0x0021;
    pub const exclamarmenian: u16 = 0x055c;
    pub const exclamdbl: u16 = 0x203c;
    pub const exclamdown: u16 = 0x00a1;
    pub const exclamdownsmall: u16 = 0xf7a1;
    pub const exclammonospace: u16 = 0xff01;
    pub const exclamsmall: u16 = 0xf721;
    pub const existential: u16 = 0x2203;
    pub const ezh: u16 = 0x0292;
    pub const ezhcaron: u16 = 0x01ef;
    pub const ezhcurl: u16 = 0x0293;
    pub const ezhreversed: u16 = 0x01b9;
    pub const ezhtail: u16 = 0x01ba;
    pub const f: u16 = 0x0066;
    pub const f_f: u16 = 0xfb00;
    pub const f_f_i: u16 = 0xfb03;
    pub const f_f_l: u16 = 0xfb04;
    pub const f_i: u16 = 0xfb01;
    pub const f_l: u16 = 0xfb02;
    pub const fadeva: u16 = 0x095e;
    pub const fagurmukhi: u16 = 0x0a5e;
    pub const fahrenheit: u16 = 0x2109;
    pub const fathaarabic: u16 = 0x064e;
    pub const fathalowarabic: u16 = 0x064e;
    pub const fathatanarabic: u16 = 0x064b;
    pub const fbopomofo: u16 = 0x3108;
    pub const fcircle: u16 = 0x24d5;
    pub const fdotaccent: u16 = 0x1e1f;
    pub const feharabic: u16 = 0x0641;
    pub const feharmenian: u16 = 0x0586;
    pub const fehfinalarabic: u16 = 0xfed2;
    pub const fehinitialarabic: u16 = 0xfed3;
    pub const fehmedialarabic: u16 = 0xfed4;
    pub const feicoptic: u16 = 0x03e5;
    pub const female: u16 = 0x2640;
    pub const ff: u16 = 0xfb00;
    pub const ffi: u16 = 0xfb03;
    pub const ffl: u16 = 0xfb04;
    pub const fi: u16 = 0xfb01;
    pub const fifteencircle: u16 = 0x246e;
    pub const fifteenparen: u16 = 0x2482;
    pub const fifteenperiod: u16 = 0x2496;
    pub const figuredash: u16 = 0x2012;
    pub const filledbox: u16 = 0x25a0;
    pub const filledrect: u16 = 0x25ac;
    pub const finalkaf: u16 = 0x05da;
    pub const finalkafdagesh: u16 = 0xfb3a;
    pub const finalkafdageshhebrew: u16 = 0xfb3a;
    pub const finalkafhebrew: u16 = 0x05da;
    pub const finalkafqamats: u16 = 0x05da;
    pub const finalkafqamatshebrew: u16 = 0x05da;
    pub const finalkafsheva: u16 = 0x05da;
    pub const finalkafshevahebrew: u16 = 0x05da;
    pub const finalmem: u16 = 0x05dd;
    pub const finalmemhebrew: u16 = 0x05dd;
    pub const finalnun: u16 = 0x05df;
    pub const finalnunhebrew: u16 = 0x05df;
    pub const finalpe: u16 = 0x05e3;
    pub const finalpehebrew: u16 = 0x05e3;
    pub const finaltsadi: u16 = 0x05e5;
    pub const finaltsadihebrew: u16 = 0x05e5;
    pub const firsttonechinese: u16 = 0x02c9;
    pub const fisheye: u16 = 0x25c9;
    pub const fitacyrillic: u16 = 0x0473;
    pub const five: u16 = 0x0035;
    pub const fivearabic: u16 = 0x0665;
    pub const fivebengali: u16 = 0x09eb;
    pub const fivecircle: u16 = 0x2464;
    pub const fivecircleinversesansserif: u16 = 0x278e;
    pub const fivedeva: u16 = 0x096b;
    pub const fiveeighths: u16 = 0x215d;
    pub const fivegujarati: u16 = 0x0aeb;
    pub const fivegurmukhi: u16 = 0x0a6b;
    pub const fivehackarabic: u16 = 0x0665;
    pub const fivehangzhou: u16 = 0x3025;
    pub const fiveideographicparen: u16 = 0x3224;
    pub const fiveinferior: u16 = 0x2085;
    pub const fivemonospace: u16 = 0xff15;
    pub const fiveoldstyle: u16 = 0xf735;
    pub const fiveparen: u16 = 0x2478;
    pub const fiveperiod: u16 = 0x248c;
    pub const fivepersian: u16 = 0x06f5;
    pub const fiveroman: u16 = 0x2174;
    pub const fivesuperior: u16 = 0x2075;
    pub const fivethai: u16 = 0x0e55;
    pub const fl: u16 = 0xfb02;
    pub const flat: u16 = 0x266d;
    pub const floorleft: u16 = 0x230a;
    pub const floorleftBig: u16 = 0x230a;
    pub const floorleftBigg: u16 = 0x230a;
    pub const floorleftbig: u16 = 0x230a;
    pub const floorleftbigg: u16 = 0x230a;
    pub const floorright: u16 = 0x230b;
    pub const floorrightBig: u16 = 0x230b;
    pub const floorrightBigg: u16 = 0x230b;
    pub const floorrightbig: u16 = 0x230b;
    pub const floorrightbigg: u16 = 0x230b;
    pub const florin: u16 = 0x0192;
    pub const fmonospace: u16 = 0xff46;
    pub const fmsquare: u16 = 0x3399;
    pub const fofanthai: u16 = 0x0e1f;
    pub const fofathai: u16 = 0x0e1d;
    pub const follows: u16 = 0x227b;
    pub const followsequal: u16 = 0x227d;
    pub const fongmanthai: u16 = 0x0e4f;
    pub const forall: u16 = 0x2200;
    pub const four: u16 = 0x0034;
    pub const fourarabic: u16 = 0x0664;
    pub const fourbengali: u16 = 0x09ea;
    pub const fourcircle: u16 = 0x2463;
    pub const fourcircleinversesansserif: u16 = 0x278d;
    pub const fourdeva: u16 = 0x096a;
    pub const fourgujarati: u16 = 0x0aea;
    pub const fourgurmukhi: u16 = 0x0a6a;
    pub const fourhackarabic: u16 = 0x0664;
    pub const fourhangzhou: u16 = 0x3024;
    pub const fourideographicparen: u16 = 0x3223;
    pub const fourinferior: u16 = 0x2084;
    pub const fourmonospace: u16 = 0xff14;
    pub const fournumeratorbengali: u16 = 0x09f7;
    pub const fouroldstyle: u16 = 0xf734;
    pub const fourparen: u16 = 0x2477;
    pub const fourperiod: u16 = 0x248b;
    pub const fourpersian: u16 = 0x06f4;
    pub const fourroman: u16 = 0x2173;
    pub const foursuperior: u16 = 0x2074;
    pub const fourteencircle: u16 = 0x246d;
    pub const fourteenparen: u16 = 0x2481;
    pub const fourteenperiod: u16 = 0x2495;
    pub const fourthai: u16 = 0x0e54;
    pub const fourthtonechinese: u16 = 0x02cb;
    pub const fparen: u16 = 0x24a1;
    pub const fraction: u16 = 0x2044;
    pub const franc: u16 = 0x20a3;
    pub const g: u16 = 0x0067;
    pub const gabengali: u16 = 0x0997;
    pub const gacute: u16 = 0x01f5;
    pub const gadeva: u16 = 0x0917;
    pub const gafarabic: u16 = 0x06af;
    pub const gaffinalarabic: u16 = 0xfb93;
    pub const gafinitialarabic: u16 = 0xfb94;
    pub const gafmedialarabic: u16 = 0xfb95;
    pub const gagujarati: u16 = 0x0a97;
    pub const gagurmukhi: u16 = 0x0a17;
    pub const gahiragana: u16 = 0x304c;
    pub const gakatakana: u16 = 0x30ac;
    pub const gamma: u16 = 0x03b3;
    pub const gammalatinsmall: u16 = 0x0263;
    pub const gammasuperior: u16 = 0x02e0;
    pub const gangiacoptic: u16 = 0x03eb;
    pub const gbopomofo: u16 = 0x310d;
    pub const gbreve: u16 = 0x011f;
    pub const gcaron: u16 = 0x01e7;
    pub const gcedilla: u16 = 0x0123;
    pub const gcircle: u16 = 0x24d6;
    pub const gcircumflex: u16 = 0x011d;
    pub const gcommaaccent: u16 = 0x0123;
    pub const gdot: u16 = 0x0121;
    pub const gdotaccent: u16 = 0x0121;
    pub const gecyrillic: u16 = 0x0433;
    pub const gehiragana: u16 = 0x3052;
    pub const gekatakana: u16 = 0x30b2;
    pub const geometricallyequal: u16 = 0x2251;
    pub const gereshaccenthebrew: u16 = 0x059c;
    pub const gereshhebrew: u16 = 0x05f3;
    pub const gereshmuqdamhebrew: u16 = 0x059d;
    pub const germandbls: u16 = 0x00df;
    pub const gershayimaccenthebrew: u16 = 0x059e;
    pub const gershayimhebrew: u16 = 0x05f4;
    pub const getamark: u16 = 0x3013;
    pub const ghabengali: u16 = 0x0998;
    pub const ghadarmenian: u16 = 0x0572;
    pub const ghadeva: u16 = 0x0918;
    pub const ghagujarati: u16 = 0x0a98;
    pub const ghagurmukhi: u16 = 0x0a18;
    pub const ghainarabic: u16 = 0x063a;
    pub const ghainfinalarabic: u16 = 0xfece;
    pub const ghaininitialarabic: u16 = 0xfecf;
    pub const ghainmedialarabic: u16 = 0xfed0;
    pub const ghemiddlehookcyrillic: u16 = 0x0495;
    pub const ghestrokecyrillic: u16 = 0x0493;
    pub const gheupturncyrillic: u16 = 0x0491;
    pub const ghhadeva: u16 = 0x095a;
    pub const ghhagurmukhi: u16 = 0x0a5a;
    pub const ghook: u16 = 0x0260;
    pub const ghzsquare: u16 = 0x3393;
    pub const gihiragana: u16 = 0x304e;
    pub const gikatakana: u16 = 0x30ae;
    pub const gimarmenian: u16 = 0x0563;
    pub const gimel: u16 = 0x05d2;
    pub const gimeldagesh: u16 = 0xfb32;
    pub const gimeldageshhebrew: u16 = 0xfb32;
    pub const gimelhebrew: u16 = 0x05d2;
    pub const gjecyrillic: u16 = 0x0453;
    pub const glottalinvertedstroke: u16 = 0x01be;
    pub const glottalstop: u16 = 0x0294;
    pub const glottalstopinverted: u16 = 0x0296;
    pub const glottalstopmod: u16 = 0x02c0;
    pub const glottalstopreversed: u16 = 0x0295;
    pub const glottalstopreversedmod: u16 = 0x02c1;
    pub const glottalstopreversedsuperior: u16 = 0x02e4;
    pub const glottalstopstroke: u16 = 0x02a1;
    pub const glottalstopstrokereversed: u16 = 0x02a2;
    pub const gmacron: u16 = 0x1e21;
    pub const gmonospace: u16 = 0xff47;
    pub const gohiragana: u16 = 0x3054;
    pub const gokatakana: u16 = 0x30b4;
    pub const gparen: u16 = 0x24a2;
    pub const gpasquare: u16 = 0x33ac;
    pub const gradient: u16 = 0x2207;
    pub const grave: u16 = 0x0060;
    pub const gravebelowcmb: u16 = 0x0316;
    pub const gravecmb: u16 = 0x0300;
    pub const gravecomb: u16 = 0x0300;
    pub const gravedeva: u16 = 0x0953;
    pub const gravelowmod: u16 = 0x02ce;
    pub const gravemonospace: u16 = 0xff40;
    pub const gravetonecmb: u16 = 0x0340;
    pub const greater: u16 = 0x003e;
    pub const greaterequal: u16 = 0x2265;
    pub const greaterequalorless: u16 = 0x22db;
    pub const greatermonospace: u16 = 0xff1e;
    pub const greatermuch: u16 = 0x226b;
    pub const greaterorequivalent: u16 = 0x2273;
    pub const greaterorless: u16 = 0x2277;
    pub const greateroverequal: u16 = 0x2267;
    pub const greatersmall: u16 = 0xfe65;
    pub const gscript: u16 = 0x0261;
    pub const gstroke: u16 = 0x01e5;
    pub const guhiragana: u16 = 0x3050;
    pub const guillemotleft: u16 = 0x00ab;
    pub const guillemotright: u16 = 0x00bb;
    pub const guilsinglleft: u16 = 0x2039;
    pub const guilsinglright: u16 = 0x203a;
    pub const gukatakana: u16 = 0x30b0;
    pub const guramusquare: u16 = 0x3318;
    pub const gysquare: u16 = 0x33c9;
    pub const h: u16 = 0x0068;
    pub const haabkhasiancyrillic: u16 = 0x04a9;
    pub const haaltonearabic: u16 = 0x06c1;
    pub const habengali: u16 = 0x09b9;
    pub const hadescendercyrillic: u16 = 0x04b3;
    pub const hadeva: u16 = 0x0939;
    pub const hagujarati: u16 = 0x0ab9;
    pub const hagurmukhi: u16 = 0x0a39;
    pub const haharabic: u16 = 0x062d;
    pub const hahfinalarabic: u16 = 0xfea2;
    pub const hahinitialarabic: u16 = 0xfea3;
    pub const hahiragana: u16 = 0x306f;
    pub const hahmedialarabic: u16 = 0xfea4;
    pub const haitusquare: u16 = 0x332a;
    pub const hakatakana: u16 = 0x30cf;
    pub const hakatakanahalfwidth: u16 = 0xff8a;
    pub const halantgurmukhi: u16 = 0x0a4d;
    pub const hamzaarabic: u16 = 0x0621;
    pub const hamzadammaarabic: u16 = 0x0621;
    pub const hamzadammatanarabic: u16 = 0x0621;
    pub const hamzafathaarabic: u16 = 0x0621;
    pub const hamzafathatanarabic: u16 = 0x0621;
    pub const hamzalowarabic: u16 = 0x0621;
    pub const hamzalowkasraarabic: u16 = 0x0621;
    pub const hamzalowkasratanarabic: u16 = 0x0621;
    pub const hamzasukunarabic: u16 = 0x0621;
    pub const hangulfiller: u16 = 0x3164;
    pub const hardsigncyrillic: u16 = 0x044a;
    pub const harpoonleftbarbup: u16 = 0x21bc;
    pub const harpoonleftdown: u16 = 0x21bd;
    pub const harpoonleftup: u16 = 0x21bc;
    pub const harpoonrightbarbup: u16 = 0x21c0;
    pub const harpoonrightdown: u16 = 0x21c1;
    pub const harpoonrightup: u16 = 0x21c0;
    pub const hasquare: u16 = 0x33ca;
    pub const hatafpatah: u16 = 0x05b2;
    pub const hatafpatah16: u16 = 0x05b2;
    pub const hatafpatah23: u16 = 0x05b2;
    pub const hatafpatah2f: u16 = 0x05b2;
    pub const hatafpatahhebrew: u16 = 0x05b2;
    pub const hatafpatahnarrowhebrew: u16 = 0x05b2;
    pub const hatafpatahquarterhebrew: u16 = 0x05b2;
    pub const hatafpatahwidehebrew: u16 = 0x05b2;
    pub const hatafqamats: u16 = 0x05b3;
    pub const hatafqamats1b: u16 = 0x05b3;
    pub const hatafqamats28: u16 = 0x05b3;
    pub const hatafqamats34: u16 = 0x05b3;
    pub const hatafqamatshebrew: u16 = 0x05b3;
    pub const hatafqamatsnarrowhebrew: u16 = 0x05b3;
    pub const hatafqamatsquarterhebrew: u16 = 0x05b3;
    pub const hatafqamatswidehebrew: u16 = 0x05b3;
    pub const hatafsegol: u16 = 0x05b1;
    pub const hatafsegol17: u16 = 0x05b1;
    pub const hatafsegol24: u16 = 0x05b1;
    pub const hatafsegol30: u16 = 0x05b1;
    pub const hatafsegolhebrew: u16 = 0x05b1;
    pub const hatafsegolnarrowhebrew: u16 = 0x05b1;
    pub const hatafsegolquarterhebrew: u16 = 0x05b1;
    pub const hatafsegolwidehebrew: u16 = 0x05b1;
    pub const hatwide: u16 = 0x0302;
    pub const hatwider: u16 = 0x0302;
    pub const hatwiderr: u16 = 0x0302;
    pub const hbar: u16 = 0x0127;
    pub const hbopomofo: u16 = 0x310f;
    pub const hbrevebelow: u16 = 0x1e2b;
    pub const hcedilla: u16 = 0x1e29;
    pub const hcircle: u16 = 0x24d7;
    pub const hcircumflex: u16 = 0x0125;
    pub const hdieresis: u16 = 0x1e27;
    pub const hdotaccent: u16 = 0x1e23;
    pub const hdotbelow: u16 = 0x1e25;
    pub const he: u16 = 0x05d4;
    pub const heart: u16 = 0x2661;
    pub const heart2: u16 = 0x2665;
    pub const heartsuitblack: u16 = 0x2665;
    pub const heartsuitwhite: u16 = 0x2661;
    pub const hedagesh: u16 = 0xfb34;
    pub const hedageshhebrew: u16 = 0xfb34;
    pub const hehaltonearabic: u16 = 0x06c1;
    pub const heharabic: u16 = 0x0647;
    pub const hehebrew: u16 = 0x05d4;
    pub const hehfinalaltonearabic: u16 = 0xfba7;
    pub const hehfinalalttwoarabic: u16 = 0xfeea;
    pub const hehfinalarabic: u16 = 0xfeea;
    pub const hehhamzaabovefinalarabic: u16 = 0xfba5;
    pub const hehhamzaaboveisolatedarabic: u16 = 0xfba4;
    pub const hehinitialaltonearabic: u16 = 0xfba8;
    pub const hehinitialarabic: u16 = 0xfeeb;
    pub const hehiragana: u16 = 0x3078;
    pub const hehmedialaltonearabic: u16 = 0xfba9;
    pub const hehmedialarabic: u16 = 0xfeec;
    pub const heiseierasquare: u16 = 0x337b;
    pub const hekatakana: u16 = 0x30d8;
    pub const hekatakanahalfwidth: u16 = 0xff8d;
    pub const hekutaarusquare: u16 = 0x3336;
    pub const henghook: u16 = 0x0267;
    pub const herutusquare: u16 = 0x3339;
    pub const het: u16 = 0x05d7;
    pub const hethebrew: u16 = 0x05d7;
    pub const hhook: u16 = 0x0266;
    pub const hhooksuperior: u16 = 0x02b1;
    pub const hieuhacirclekorean: u16 = 0x327b;
    pub const hieuhaparenkorean: u16 = 0x321b;
    pub const hieuhcirclekorean: u16 = 0x326d;
    pub const hieuhkorean: u16 = 0x314e;
    pub const hieuhparenkorean: u16 = 0x320d;
    pub const hihiragana: u16 = 0x3072;
    pub const hikatakana: u16 = 0x30d2;
    pub const hikatakanahalfwidth: u16 = 0xff8b;
    pub const hiriq: u16 = 0x05b4;
    pub const hiriq14: u16 = 0x05b4;
    pub const hiriq21: u16 = 0x05b4;
    pub const hiriq2d: u16 = 0x05b4;
    pub const hiriqhebrew: u16 = 0x05b4;
    pub const hiriqnarrowhebrew: u16 = 0x05b4;
    pub const hiriqquarterhebrew: u16 = 0x05b4;
    pub const hiriqwidehebrew: u16 = 0x05b4;
    pub const hlinebelow: u16 = 0x1e96;
    pub const hmonospace: u16 = 0xff48;
    pub const hoarmenian: u16 = 0x0570;
    pub const hohipthai: u16 = 0x0e2b;
    pub const hohiragana: u16 = 0x307b;
    pub const hokatakana: u16 = 0x30db;
    pub const hokatakanahalfwidth: u16 = 0xff8e;
    pub const holam: u16 = 0x05b9;
    pub const holam19: u16 = 0x05b9;
    pub const holam26: u16 = 0x05b9;
    pub const holam32: u16 = 0x05b9;
    pub const holamhebrew: u16 = 0x05b9;
    pub const holamnarrowhebrew: u16 = 0x05b9;
    pub const holamquarterhebrew: u16 = 0x05b9;
    pub const holamwidehebrew: u16 = 0x05b9;
    pub const honokhukthai: u16 = 0x0e2e;
    pub const hookabovecomb: u16 = 0x0309;
    pub const hookcmb: u16 = 0x0309;
    pub const hookleftchar: u16 = 0x21a9;
    pub const hookpalatalizedbelowcmb: u16 = 0x0321;
    pub const hookretroflexbelowcmb: u16 = 0x0322;
    pub const hookrightchar: u16 = 0x21aa;
    pub const hoonsquare: u16 = 0x3342;
    pub const horicoptic: u16 = 0x03e9;
    pub const horizontalbar: u16 = 0x2015;
    pub const horncmb: u16 = 0x031b;
    pub const hotsprings: u16 = 0x2668;
    pub const house: u16 = 0x2302;
    pub const hparen: u16 = 0x24a3;
    pub const hsuperior: u16 = 0x02b0;
    pub const hturned: u16 = 0x0265;
    pub const huhiragana: u16 = 0x3075;
    pub const huiitosquare: u16 = 0x3333;
    pub const hukatakana: u16 = 0x30d5;
    pub const hukatakanahalfwidth: u16 = 0xff8c;
    pub const hungarumlaut: u16 = 0x02dd;
    pub const hungarumlautcmb: u16 = 0x030b;
    pub const hv: u16 = 0x0195;
    pub const hyphen: u16 = 0x002d;
    pub const hyphen_alt: u16 = 0x2010;
    pub const hyphenchar: u16 = 0x002d;
    pub const hypheninferior: u16 = 0xf6e5;
    pub const hyphenmonospace: u16 = 0xff0d;
    pub const hyphensmall: u16 = 0xfe63;
    pub const hyphensuperior: u16 = 0xf6e6;
    pub const hyphentwo: u16 = 0x2010;
    pub const i: u16 = 0x0069;
    pub const iacute: u16 = 0x00ed;
    pub const iacyrillic: u16 = 0x044f;
    pub const ibengali: u16 = 0x0987;
    pub const ibopomofo: u16 = 0x3127;
    pub const ibreve: u16 = 0x012d;
    pub const icaron: u16 = 0x01d0;
    pub const icircle: u16 = 0x24d8;
    pub const icircumflex: u16 = 0x00ee;
    pub const icyrillic: u16 = 0x0456;
    pub const idblgrave: u16 = 0x0209;
    pub const ideographearthcircle: u16 = 0x328f;
    pub const ideographfirecircle: u16 = 0x328b;
    pub const ideographicallianceparen: u16 = 0x323f;
    pub const ideographiccallparen: u16 = 0x323a;
    pub const ideographiccentrecircle: u16 = 0x32a5;
    pub const ideographicclose: u16 = 0x3006;
    pub const ideographiccomma: u16 = 0x3001;
    pub const ideographiccommaleft: u16 = 0xff64;
    pub const ideographiccongratulationparen: u16 = 0x3237;
    pub const ideographiccorrectcircle: u16 = 0x32a3;
    pub const ideographicearthparen: u16 = 0x322f;
    pub const ideographicenterpriseparen: u16 = 0x323d;
    pub const ideographicexcellentcircle: u16 = 0x329d;
    pub const ideographicfestivalparen: u16 = 0x3240;
    pub const ideographicfinancialcircle: u16 = 0x3296;
    pub const ideographicfinancialparen: u16 = 0x3236;
    pub const ideographicfireparen: u16 = 0x322b;
    pub const ideographichaveparen: u16 = 0x3232;
    pub const ideographichighcircle: u16 = 0x32a4;
    pub const ideographiciterationmark: u16 = 0x3005;
    pub const ideographiclaborcircle: u16 = 0x3298;
    pub const ideographiclaborparen: u16 = 0x3238;
    pub const ideographicleftcircle: u16 = 0x32a7;
    pub const ideographiclowcircle: u16 = 0x32a6;
    pub const ideographicmedicinecircle: u16 = 0x32a9;
    pub const ideographicmetalparen: u16 = 0x322e;
    pub const ideographicmoonparen: u16 = 0x322a;
    pub const ideographicnameparen: u16 = 0x3234;
    pub const ideographicperiod: u16 = 0x3002;
    pub const ideographicprintcircle: u16 = 0x329e;
    pub const ideographicreachparen: u16 = 0x3243;
    pub const ideographicrepresentparen: u16 = 0x3239;
    pub const ideographicresourceparen: u16 = 0x323e;
    pub const ideographicrightcircle: u16 = 0x32a8;
    pub const ideographicsecretcircle: u16 = 0x3299;
    pub const ideographicselfparen: u16 = 0x3242;
    pub const ideographicsocietyparen: u16 = 0x3233;
    pub const ideographicspace: u16 = 0x3000;
    pub const ideographicspecialparen: u16 = 0x3235;
    pub const ideographicstockparen: u16 = 0x3231;
    pub const ideographicstudyparen: u16 = 0x323b;
    pub const ideographicsunparen: u16 = 0x3230;
    pub const ideographicsuperviseparen: u16 = 0x323c;
    pub const ideographicwaterparen: u16 = 0x322c;
    pub const ideographicwoodparen: u16 = 0x322d;
    pub const ideographiczero: u16 = 0x3007;
    pub const ideographmetalcircle: u16 = 0x328e;
    pub const ideographmooncircle: u16 = 0x328a;
    pub const ideographnamecircle: u16 = 0x3294;
    pub const ideographsuncircle: u16 = 0x3290;
    pub const ideographwatercircle: u16 = 0x328c;
    pub const ideographwoodcircle: u16 = 0x328d;
    pub const ideva: u16 = 0x0907;
    pub const idieresis: u16 = 0x00ef;
    pub const idieresisacute: u16 = 0x1e2f;
    pub const idieresiscyrillic: u16 = 0x04e5;
    pub const idotbelow: u16 = 0x1ecb;
    pub const iebrevecyrillic: u16 = 0x04d7;
    pub const iecyrillic: u16 = 0x0435;
    pub const ieungacirclekorean: u16 = 0x3275;
    pub const ieungaparenkorean: u16 = 0x3215;
    pub const ieungcirclekorean: u16 = 0x3267;
    pub const ieungkorean: u16 = 0x3147;
    pub const ieungparenkorean: u16 = 0x3207;
    pub const igrave: u16 = 0x00ec;
    pub const igujarati: u16 = 0x0a87;
    pub const igurmukhi: u16 = 0x0a07;
    pub const ihiragana: u16 = 0x3044;
    pub const ihookabove: u16 = 0x1ec9;
    pub const iibengali: u16 = 0x0988;
    pub const iicyrillic: u16 = 0x0438;
    pub const iideva: u16 = 0x0908;
    pub const iigujarati: u16 = 0x0a88;
    pub const iigurmukhi: u16 = 0x0a08;
    pub const iimatragurmukhi: u16 = 0x0a40;
    pub const iinvertedbreve: u16 = 0x020b;
    pub const iishortcyrillic: u16 = 0x0439;
    pub const iivowelsignbengali: u16 = 0x09c0;
    pub const iivowelsigndeva: u16 = 0x0940;
    pub const iivowelsigngujarati: u16 = 0x0ac0;
    pub const ij: u16 = 0x0133;
    pub const ikatakana: u16 = 0x30a4;
    pub const ikatakanahalfwidth: u16 = 0xff72;
    pub const ikorean: u16 = 0x3163;
    pub const ilde: u16 = 0x02dc;
    pub const iluyhebrew: u16 = 0x05ac;
    pub const imacron: u16 = 0x012b;
    pub const imacroncyrillic: u16 = 0x04e3;
    pub const imageorapproximatelyequal: u16 = 0x2253;
    pub const imatragurmukhi: u16 = 0x0a3f;
    pub const imonospace: u16 = 0xff49;
    pub const increment: u16 = 0x2206;
    pub const infinity: u16 = 0x221e;
    pub const iniarmenian: u16 = 0x056b;
    pub const integral: u16 = 0x222b;
    pub const integralbottom: u16 = 0x2321;
    pub const integralbt: u16 = 0x2321;
    pub const integraldisplay: u16 = 0x222b;
    pub const integralex: u16 = 0xf8f5;
    pub const integraltext: u16 = 0x222b;
    pub const integraltop: u16 = 0x2320;
    pub const integraltp: u16 = 0x2320;
    pub const interrobang: u16 = 0x203d;
    pub const interrobangdown: u16 = 0xd80b;
    pub const intersection: u16 = 0x2229;
    pub const intersectiondisplay: u16 = 0x22c2;
    pub const intersectionsq: u16 = 0x2293;
    pub const intersectiontext: u16 = 0x22c2;
    pub const intisquare: u16 = 0x3305;
    pub const invbullet: u16 = 0x25d8;
    pub const invcircle: u16 = 0x25d9;
    pub const invsmileface: u16 = 0x263b;
    pub const iocyrillic: u16 = 0x0451;
    pub const iogonek: u16 = 0x012f;
    pub const iota: u16 = 0x03b9;
    pub const iotadieresis: u16 = 0x03ca;
    pub const iotadieresistonos: u16 = 0x0390;
    pub const iotalatin: u16 = 0x0269;
    pub const iotatonos: u16 = 0x03af;
    pub const iparen: u16 = 0x24a4;
    pub const irigurmukhi: u16 = 0x0a72;
    pub const ismallhiragana: u16 = 0x3043;
    pub const ismallkatakana: u16 = 0x30a3;
    pub const ismallkatakanahalfwidth: u16 = 0xff68;
    pub const issharbengali: u16 = 0x09fa;
    pub const istroke: u16 = 0x0268;
    pub const isuperior: u16 = 0xf6ed;
    pub const iterationhiragana: u16 = 0x309d;
    pub const iterationkatakana: u16 = 0x30fd;
    pub const itilde: u16 = 0x0129;
    pub const itildebelow: u16 = 0x1e2d;
    pub const iubopomofo: u16 = 0x3129;
    pub const iucyrillic: u16 = 0x044e;
    pub const ivowelsignbengali: u16 = 0x09bf;
    pub const ivowelsigndeva: u16 = 0x093f;
    pub const ivowelsigngujarati: u16 = 0x0abf;
    pub const izhitsacyrillic: u16 = 0x0475;
    pub const izhitsadblgravecyrillic: u16 = 0x0477;
    pub const j: u16 = 0x006a;
    pub const jaarmenian: u16 = 0x0571;
    pub const jabengali: u16 = 0x099c;
    pub const jadeva: u16 = 0x091c;
    pub const jagujarati: u16 = 0x0a9c;
    pub const jagurmukhi: u16 = 0x0a1c;
    pub const jbopomofo: u16 = 0x3110;
    pub const jcaron: u16 = 0x01f0;
    pub const jcircle: u16 = 0x24d9;
    pub const jcircumflex: u16 = 0x0135;
    pub const jcrossedtail: u16 = 0x029d;
    pub const jdotlessstroke: u16 = 0x025f;
    pub const jecyrillic: u16 = 0x0458;
    pub const jeemarabic: u16 = 0x062c;
    pub const jeemfinalarabic: u16 = 0xfe9e;
    pub const jeeminitialarabic: u16 = 0xfe9f;
    pub const jeemmedialarabic: u16 = 0xfea0;
    pub const jeharabic: u16 = 0x0698;
    pub const jehfinalarabic: u16 = 0xfb8b;
    pub const jhabengali: u16 = 0x099d;
    pub const jhadeva: u16 = 0x091d;
    pub const jhagujarati: u16 = 0x0a9d;
    pub const jhagurmukhi: u16 = 0x0a1d;
    pub const jheharmenian: u16 = 0x057b;
    pub const jis: u16 = 0x3004;
    pub const jmonospace: u16 = 0xff4a;
    pub const jparen: u16 = 0x24a5;
    pub const jsuperior: u16 = 0x02b2;
    pub const k: u16 = 0x006b;
    pub const kabashkircyrillic: u16 = 0x04a1;
    pub const kabengali: u16 = 0x0995;
    pub const kacute: u16 = 0x1e31;
    pub const kacyrillic: u16 = 0x043a;
    pub const kadescendercyrillic: u16 = 0x049b;
    pub const kadeva: u16 = 0x0915;
    pub const kaf: u16 = 0x05db;
    pub const kafarabic: u16 = 0x0643;
    pub const kafdagesh: u16 = 0xfb3b;
    pub const kafdageshhebrew: u16 = 0xfb3b;
    pub const kaffinalarabic: u16 = 0xfeda;
    pub const kafhebrew: u16 = 0x05db;
    pub const kafinitialarabic: u16 = 0xfedb;
    pub const kafmedialarabic: u16 = 0xfedc;
    pub const kafrafehebrew: u16 = 0xfb4d;
    pub const kagujarati: u16 = 0x0a95;
    pub const kagurmukhi: u16 = 0x0a15;
    pub const kahiragana: u16 = 0x304b;
    pub const kahookcyrillic: u16 = 0x04c4;
    pub const kakatakana: u16 = 0x30ab;
    pub const kakatakanahalfwidth: u16 = 0xff76;
    pub const kappa: u16 = 0x03ba;
    pub const kappasymbolgreek: u16 = 0x03f0;
    pub const kapyeounmieumkorean: u16 = 0x3171;
    pub const kapyeounphieuphkorean: u16 = 0x3184;
    pub const kapyeounpieupkorean: u16 = 0x3178;
    pub const kapyeounssangpieupkorean: u16 = 0x3179;
    pub const karoriisquare: u16 = 0x330d;
    pub const kashidaautoarabic: u16 = 0x0640;
    pub const kashidaautonosidebearingarabic: u16 = 0x0640;
    pub const kasmallkatakana: u16 = 0x30f5;
    pub const kasquare: u16 = 0x3384;
    pub const kasraarabic: u16 = 0x0650;
    pub const kasratanarabic: u16 = 0x064d;
    pub const kastrokecyrillic: u16 = 0x049f;
    pub const katahiraprolongmarkhalfwidth: u16 = 0xff70;
    pub const kaverticalstrokecyrillic: u16 = 0x049d;
    pub const kbopomofo: u16 = 0x310e;
    pub const kcalsquare: u16 = 0x3389;
    pub const kcaron: u16 = 0x01e9;
    pub const kcedilla: u16 = 0x0137;
    pub const kcircle: u16 = 0x24da;
    pub const kcommaaccent: u16 = 0x0137;
    pub const kdotbelow: u16 = 0x1e33;
    pub const keharmenian: u16 = 0x0584;
    pub const kehiragana: u16 = 0x3051;
    pub const kekatakana: u16 = 0x30b1;
    pub const kekatakanahalfwidth: u16 = 0xff79;
    pub const kenarmenian: u16 = 0x056f;
    pub const kesmallkatakana: u16 = 0x30f6;
    pub const kgreenlandic: u16 = 0x0138;
    pub const khabengali: u16 = 0x0996;
    pub const khacyrillic: u16 = 0x0445;
    pub const khadeva: u16 = 0x0916;
    pub const khagujarati: u16 = 0x0a96;
    pub const khagurmukhi: u16 = 0x0a16;
    pub const khaharabic: u16 = 0x062e;
    pub const khahfinalarabic: u16 = 0xfea6;
    pub const khahinitialarabic: u16 = 0xfea7;
    pub const khahmedialarabic: u16 = 0xfea8;
    pub const kheicoptic: u16 = 0x03e7;
    pub const khhadeva: u16 = 0x0959;
    pub const khhagurmukhi: u16 = 0x0a59;
    pub const khieukhacirclekorean: u16 = 0x3278;
    pub const khieukhaparenkorean: u16 = 0x3218;
    pub const khieukhcirclekorean: u16 = 0x326a;
    pub const khieukhkorean: u16 = 0x314b;
    pub const khieukhparenkorean: u16 = 0x320a;
    pub const khokhaithai: u16 = 0x0e02;
    pub const khokhonthai: u16 = 0x0e05;
    pub const khokhuatthai: u16 = 0x0e03;
    pub const khokhwaithai: u16 = 0x0e04;
    pub const khomutthai: u16 = 0x0e5b;
    pub const khook: u16 = 0x0199;
    pub const khorakhangthai: u16 = 0x0e06;
    pub const khzsquare: u16 = 0x3391;
    pub const kihiragana: u16 = 0x304d;
    pub const kikatakana: u16 = 0x30ad;
    pub const kikatakanahalfwidth: u16 = 0xff77;
    pub const kiroguramusquare: u16 = 0x3315;
    pub const kiromeetorusquare: u16 = 0x3316;
    pub const kirosquare: u16 = 0x3314;
    pub const kiyeokacirclekorean: u16 = 0x326e;
    pub const kiyeokaparenkorean: u16 = 0x320e;
    pub const kiyeokcirclekorean: u16 = 0x3260;
    pub const kiyeokkorean: u16 = 0x3131;
    pub const kiyeokparenkorean: u16 = 0x3200;
    pub const kiyeoksioskorean: u16 = 0x3133;
    pub const kjecyrillic: u16 = 0x045c;
    pub const klinebelow: u16 = 0x1e35;
    pub const klsquare: u16 = 0x3398;
    pub const kmcubedsquare: u16 = 0x33a6;
    pub const kmonospace: u16 = 0xff4b;
    pub const kmsquaredsquare: u16 = 0x33a2;
    pub const kohiragana: u16 = 0x3053;
    pub const kohmsquare: u16 = 0x33c0;
    pub const kokaithai: u16 = 0x0e01;
    pub const kokatakana: u16 = 0x30b3;
    pub const kokatakanahalfwidth: u16 = 0xff7a;
    pub const kooposquare: u16 = 0x331e;
    pub const koppacyrillic: u16 = 0x0481;
    pub const koreanstandardsymbol: u16 = 0x327f;
    pub const koroniscmb: u16 = 0x0343;
    pub const kparen: u16 = 0x24a6;
    pub const kpasquare: u16 = 0x33aa;
    pub const ksicyrillic: u16 = 0x046f;
    pub const ktsquare: u16 = 0x33cf;
    pub const kturned: u16 = 0x029e;
    pub const kuhiragana: u16 = 0x304f;
    pub const kukatakana: u16 = 0x30af;
    pub const kukatakanahalfwidth: u16 = 0xff78;
    pub const kvsquare: u16 = 0x33b8;
    pub const kwsquare: u16 = 0x33be;
    pub const l: u16 = 0x006c;
    pub const labengali: u16 = 0x09b2;
    pub const lacute: u16 = 0x013a;
    pub const ladeva: u16 = 0x0932;
    pub const lagujarati: u16 = 0x0ab2;
    pub const lagurmukhi: u16 = 0x0a32;
    pub const lakkhangyaothai: u16 = 0x0e45;
    pub const lamaleffinalarabic: u16 = 0xfefc;
    pub const lamalefhamzaabovefinalarabic: u16 = 0xfef8;
    pub const lamalefhamzaaboveisolatedarabic: u16 = 0xfef7;
    pub const lamalefhamzabelowfinalarabic: u16 = 0xfefa;
    pub const lamalefhamzabelowisolatedarabic: u16 = 0xfef9;
    pub const lamalefisolatedarabic: u16 = 0xfefb;
    pub const lamalefmaddaabovefinalarabic: u16 = 0xfef6;
    pub const lamalefmaddaaboveisolatedarabic: u16 = 0xfef5;
    pub const lamarabic: u16 = 0x0644;
    pub const lambda: u16 = 0x03bb;
    pub const lambdastroke: u16 = 0x019b;
    pub const lamed: u16 = 0x05dc;
    pub const lameddagesh: u16 = 0xfb3c;
    pub const lameddageshhebrew: u16 = 0xfb3c;
    pub const lamedhebrew: u16 = 0x05dc;
    pub const lamedholam: u16 = 0x05dc;
    pub const lamedholamdagesh: u16 = 0x05dc;
    pub const lamedholamdageshhebrew: u16 = 0x05dc;
    pub const lamedholamhebrew: u16 = 0x05dc;
    pub const lamfinalarabic: u16 = 0xfede;
    pub const lamhahinitialarabic: u16 = 0xfcca;
    pub const laminitialarabic: u16 = 0xfedf;
    pub const lamjeeminitialarabic: u16 = 0xfcc9;
    pub const lamkhahinitialarabic: u16 = 0xfccb;
    pub const lamlamhehisolatedarabic: u16 = 0xfdf2;
    pub const lammedialarabic: u16 = 0xfee0;
    pub const lammeemhahinitialarabic: u16 = 0xfd88;
    pub const lammeeminitialarabic: u16 = 0xfccc;
    pub const lammeemjeeminitialarabic: u16 = 0xfedf;
    pub const lammeemkhahinitialarabic: u16 = 0xfedf;
    pub const largecircle: u16 = 0x25ef;
    pub const latticetop: u16 = 0x22a4;
    pub const lbar: u16 = 0x019a;
    pub const lbelt: u16 = 0x026c;
    pub const lbopomofo: u16 = 0x310c;
    pub const lcaron: u16 = 0x013e;
    pub const lcedilla: u16 = 0x013c;
    pub const lcircle: u16 = 0x24db;
    pub const lcircumflexbelow: u16 = 0x1e3d;
    pub const lcommaaccent: u16 = 0x013c;
    pub const ldot: u16 = 0x0140;
    pub const ldotaccent: u16 = 0x0140;
    pub const ldotbelow: u16 = 0x1e37;
    pub const ldotbelowmacron: u16 = 0x1e39;
    pub const leftangleabovecmb: u16 = 0x031a;
    pub const lefttackbelowcmb: u16 = 0x0318;
    pub const less: u16 = 0x003c;
    pub const lessequal: u16 = 0x2264;
    pub const lessequalorgreater: u16 = 0x22da;
    pub const lessmonospace: u16 = 0xff1c;
    pub const lessmuch: u16 = 0x226a;
    pub const lessorequivalent: u16 = 0x2272;
    pub const lessorgreater: u16 = 0x2276;
    pub const lessoverequal: u16 = 0x2266;
    pub const lesssmall: u16 = 0xfe64;
    pub const lezh: u16 = 0x026e;
    pub const lfblock: u16 = 0x258c;
    pub const lhookretroflex: u16 = 0x026d;
    pub const lira: u16 = 0x20a4;
    pub const liwnarmenian: u16 = 0x056c;
    pub const lj: u16 = 0x01c9;
    pub const ljecyrillic: u16 = 0x0459;
    pub const ll: u16 = 0xf6c0;
    pub const lladeva: u16 = 0x0933;
    pub const llagujarati: u16 = 0x0ab3;
    pub const llinebelow: u16 = 0x1e3b;
    pub const llladeva: u16 = 0x0934;
    pub const llvocalicbengali: u16 = 0x09e1;
    pub const llvocalicdeva: u16 = 0x0961;
    pub const llvocalicvowelsignbengali: u16 = 0x09e3;
    pub const llvocalicvowelsigndeva: u16 = 0x0963;
    pub const lmiddletilde: u16 = 0x026b;
    pub const lmonospace: u16 = 0xff4c;
    pub const lmsquare: u16 = 0x33d0;
    pub const lochulathai: u16 = 0x0e2c;
    pub const logicaland: u16 = 0x2227;
    pub const logicalanddisplay: u16 = 0x22c0;
    pub const logicalandtext: u16 = 0x22c0;
    pub const logicalnot: u16 = 0x00ac;
    pub const logicalnotreversed: u16 = 0x2310;
    pub const logicalor: u16 = 0x2228;
    pub const logicalordisplay: u16 = 0x22c1;
    pub const logicalortext: u16 = 0x22c1;
    pub const lolingthai: u16 = 0x0e25;
    pub const longs: u16 = 0x017f;
    pub const lowlinecenterline: u16 = 0xfe4e;
    pub const lowlinecmb: u16 = 0x0332;
    pub const lowlinedashed: u16 = 0xfe4d;
    pub const lozenge: u16 = 0x25ca;
    pub const lparen: u16 = 0x24a7;
    pub const lscript: u16 = 0x2113;
    pub const lslash: u16 = 0x0142;
    pub const lsquare: u16 = 0x2113;
    pub const lsuperior: u16 = 0xf6ee;
    pub const ltshade: u16 = 0x2591;
    pub const luthai: u16 = 0x0e26;
    pub const lvocalicbengali: u16 = 0x098c;
    pub const lvocalicdeva: u16 = 0x090c;
    pub const lvocalicvowelsignbengali: u16 = 0x09e2;
    pub const lvocalicvowelsigndeva: u16 = 0x0962;
    pub const lxsquare: u16 = 0x33d3;
    pub const m: u16 = 0x006d;
    pub const mabengali: u16 = 0x09ae;
    pub const macron: u16 = 0x00af;
    pub const macronbelowcmb: u16 = 0x0331;
    pub const macroncmb: u16 = 0x0304;
    pub const macronlowmod: u16 = 0x02cd;
    pub const macronmonospace: u16 = 0xffe3;
    pub const macute: u16 = 0x1e3f;
    pub const madeva: u16 = 0x092e;
    pub const magujarati: u16 = 0x0aae;
    pub const magurmukhi: u16 = 0x0a2e;
    pub const mahapakhhebrew: u16 = 0x05a4;
    pub const mahapakhlefthebrew: u16 = 0x05a4;
    pub const mahiragana: u16 = 0x307e;
    pub const maichattawalowleftthai: u16 = 0xf895;
    pub const maichattawalowrightthai: u16 = 0xf894;
    pub const maichattawathai: u16 = 0x0e4b;
    pub const maichattawaupperleftthai: u16 = 0xf893;
    pub const maieklowleftthai: u16 = 0xf88c;
    pub const maieklowrightthai: u16 = 0xf88b;
    pub const maiekthai: u16 = 0x0e48;
    pub const maiekupperleftthai: u16 = 0xf88a;
    pub const maihanakatleftthai: u16 = 0xf884;
    pub const maihanakatthai: u16 = 0x0e31;
    pub const maitaikhuleftthai: u16 = 0xf889;
    pub const maitaikhuthai: u16 = 0x0e47;
    pub const maitholowleftthai: u16 = 0xf88f;
    pub const maitholowrightthai: u16 = 0xf88e;
    pub const maithothai: u16 = 0x0e49;
    pub const maithoupperleftthai: u16 = 0xf88d;
    pub const maitrilowleftthai: u16 = 0xf892;
    pub const maitrilowrightthai: u16 = 0xf891;
    pub const maitrithai: u16 = 0x0e4a;
    pub const maitriupperleftthai: u16 = 0xf890;
    pub const maiyamokthai: u16 = 0x0e46;
    pub const makatakana: u16 = 0x30de;
    pub const makatakanahalfwidth: u16 = 0xff8f;
    pub const male: u16 = 0x2642;
    pub const mansyonsquare: u16 = 0x3347;
    pub const maqafhebrew: u16 = 0x05be;
    pub const mars: u16 = 0x2642;
    pub const masoracirclehebrew: u16 = 0x05af;
    pub const masquare: u16 = 0x3383;
    pub const mbopomofo: u16 = 0x3107;
    pub const mbsquare: u16 = 0x33d4;
    pub const mcircle: u16 = 0x24dc;
    pub const mcubedsquare: u16 = 0x33a5;
    pub const mdotaccent: u16 = 0x1e41;
    pub const mdotbelow: u16 = 0x1e43;
    pub const meemarabic: u16 = 0x0645;
    pub const meemfinalarabic: u16 = 0xfee2;
    pub const meeminitialarabic: u16 = 0xfee3;
    pub const meemmedialarabic: u16 = 0xfee4;
    pub const meemmeeminitialarabic: u16 = 0xfcd1;
    pub const meemmeemisolatedarabic: u16 = 0xfc48;
    pub const meetorusquare: u16 = 0x334d;
    pub const mehiragana: u16 = 0x3081;
    pub const meizierasquare: u16 = 0x337e;
    pub const mekatakana: u16 = 0x30e1;
    pub const mekatakanahalfwidth: u16 = 0xff92;
    pub const mem: u16 = 0x05de;
    pub const memdagesh: u16 = 0xfb3e;
    pub const memdageshhebrew: u16 = 0xfb3e;
    pub const memhebrew: u16 = 0x05de;
    pub const menarmenian: u16 = 0x0574;
    pub const merkhahebrew: u16 = 0x05a5;
    pub const merkhakefulahebrew: u16 = 0x05a6;
    pub const merkhakefulalefthebrew: u16 = 0x05a6;
    pub const merkhalefthebrew: u16 = 0x05a5;
    pub const mhook: u16 = 0x0271;
    pub const mhzsquare: u16 = 0x3392;
    pub const middledotkatakanahalfwidth: u16 = 0xff65;
    pub const middot: u16 = 0x00b7;
    pub const mieumacirclekorean: u16 = 0x3272;
    pub const mieumaparenkorean: u16 = 0x3212;
    pub const mieumcirclekorean: u16 = 0x3264;
    pub const mieumkorean: u16 = 0x3141;
    pub const mieumpansioskorean: u16 = 0x3170;
    pub const mieumparenkorean: u16 = 0x3204;
    pub const mieumpieupkorean: u16 = 0x316e;
    pub const mieumsioskorean: u16 = 0x316f;
    pub const mihiragana: u16 = 0x307f;
    pub const mikatakana: u16 = 0x30df;
    pub const mikatakanahalfwidth: u16 = 0xff90;
    pub const minus: u16 = 0x2212;
    pub const minusbelowcmb: u16 = 0x0320;
    pub const minuscircle: u16 = 0x2296;
    pub const minusmod: u16 = 0x02d7;
    pub const minusplus: u16 = 0x2213;
    pub const minute: u16 = 0x2032;
    pub const miribaarusquare: u16 = 0x334a;
    pub const mirisquare: u16 = 0x3349;
    pub const mlonglegturned: u16 = 0x0270;
    pub const mlsquare: u16 = 0x3396;
    pub const mmcubedsquare: u16 = 0x33a3;
    pub const mmonospace: u16 = 0xff4d;
    pub const mmsquaredsquare: u16 = 0x339f;
    pub const mohiragana: u16 = 0x3082;
    pub const mohmsquare: u16 = 0x33c1;
    pub const mokatakana: u16 = 0x30e2;
    pub const mokatakanahalfwidth: u16 = 0xff93;
    pub const molsquare: u16 = 0x33d6;
    pub const momathai: u16 = 0x0e21;
    pub const moverssquare: u16 = 0x33a7;
    pub const moverssquaredsquare: u16 = 0x33a8;
    pub const mparen: u16 = 0x24a8;
    pub const mpasquare: u16 = 0x33ab;
    pub const mssquare: u16 = 0x33b3;
    pub const msuperior: u16 = 0xf6ef;
    pub const mturned: u16 = 0x026f;
    pub const mu: u16 = 0x00b5;
    pub const mu1: u16 = 0x00b5;
    pub const muasquare: u16 = 0x3382;
    pub const muchgreater: u16 = 0x226b;
    pub const muchless: u16 = 0x226a;
    pub const mufsquare: u16 = 0x338c;
    pub const mugreek: u16 = 0x03bc;
    pub const mugsquare: u16 = 0x338d;
    pub const muhiragana: u16 = 0x3080;
    pub const mukatakana: u16 = 0x30e0;
    pub const mukatakanahalfwidth: u16 = 0xff91;
    pub const mulsquare: u16 = 0x3395;
    pub const multiply: u16 = 0x00d7;
    pub const mumsquare: u16 = 0x339b;
    pub const munahhebrew: u16 = 0x05a3;
    pub const munahlefthebrew: u16 = 0x05a3;
    pub const musicalnote: u16 = 0x266a;
    pub const musicalnotedbl: u16 = 0x266b;
    pub const musicflatsign: u16 = 0x266d;
    pub const musicsharpsign: u16 = 0x266f;
    pub const mussquare: u16 = 0x33b2;
    pub const muvsquare: u16 = 0x33b6;
    pub const muwsquare: u16 = 0x33bc;
    pub const mvmegasquare: u16 = 0x33b9;
    pub const mvsquare: u16 = 0x33b7;
    pub const mwmegasquare: u16 = 0x33bf;
    pub const mwsquare: u16 = 0x33bd;
    pub const n: u16 = 0x006e;
    pub const nabengali: u16 = 0x09a8;
    pub const nabla: u16 = 0x2207;
    pub const nacute: u16 = 0x0144;
    pub const nadeva: u16 = 0x0928;
    pub const nagujarati: u16 = 0x0aa8;
    pub const nagurmukhi: u16 = 0x0a28;
    pub const nahiragana: u16 = 0x306a;
    pub const nakatakana: u16 = 0x30ca;
    pub const nakatakanahalfwidth: u16 = 0xff85;
    pub const napostrophe: u16 = 0x0149;
    pub const nasquare: u16 = 0x3381;
    pub const natural: u16 = 0x266e;
    pub const nbopomofo: u16 = 0x310b;
    pub const nbspace: u16 = 0x00a0;
    pub const ncaron: u16 = 0x0148;
    pub const ncedilla: u16 = 0x0146;
    pub const ncircle: u16 = 0x24dd;
    pub const ncircumflexbelow: u16 = 0x1e4b;
    pub const ncommaaccent: u16 = 0x0146;
    pub const ndotaccent: u16 = 0x1e45;
    pub const ndotbelow: u16 = 0x1e47;
    pub const negationslash: u16 = 0x0338;
    pub const nehiragana: u16 = 0x306d;
    pub const nekatakana: u16 = 0x30cd;
    pub const nekatakanahalfwidth: u16 = 0xff88;
    pub const newsheqelsign: u16 = 0x20aa;
    pub const nfsquare: u16 = 0x338b;
    pub const ng: u16 = 0x014b;
    pub const ngabengali: u16 = 0x0999;
    pub const ngadeva: u16 = 0x0919;
    pub const ngagujarati: u16 = 0x0a99;
    pub const ngagurmukhi: u16 = 0x0a19;
    pub const ngonguthai: u16 = 0x0e07;
    pub const nhiragana: u16 = 0x3093;
    pub const nhookleft: u16 = 0x0272;
    pub const nhookretroflex: u16 = 0x0273;
    pub const nieunacirclekorean: u16 = 0x326f;
    pub const nieunaparenkorean: u16 = 0x320f;
    pub const nieuncieuckorean: u16 = 0x3135;
    pub const nieuncirclekorean: u16 = 0x3261;
    pub const nieunhieuhkorean: u16 = 0x3136;
    pub const nieunkorean: u16 = 0x3134;
    pub const nieunpansioskorean: u16 = 0x3168;
    pub const nieunparenkorean: u16 = 0x3201;
    pub const nieunsioskorean: u16 = 0x3167;
    pub const nieuntikeutkorean: u16 = 0x3166;
    pub const nihiragana: u16 = 0x306b;
    pub const nikatakana: u16 = 0x30cb;
    pub const nikatakanahalfwidth: u16 = 0xff86;
    pub const nikhahitleftthai: u16 = 0xf899;
    pub const nikhahitthai: u16 = 0x0e4d;
    pub const nine: u16 = 0x0039;
    pub const ninearabic: u16 = 0x0669;
    pub const ninebengali: u16 = 0x09ef;
    pub const ninecircle: u16 = 0x2468;
    pub const ninecircleinversesansserif: u16 = 0x2792;
    pub const ninedeva: u16 = 0x096f;
    pub const ninegujarati: u16 = 0x0aef;
    pub const ninegurmukhi: u16 = 0x0a6f;
    pub const ninehackarabic: u16 = 0x0669;
    pub const ninehangzhou: u16 = 0x3029;
    pub const nineideographicparen: u16 = 0x3228;
    pub const nineinferior: u16 = 0x2089;
    pub const ninemonospace: u16 = 0xff19;
    pub const nineoldstyle: u16 = 0xf739;
    pub const nineparen: u16 = 0x247c;
    pub const nineperiod: u16 = 0x2490;
    pub const ninepersian: u16 = 0x06f9;
    pub const nineroman: u16 = 0x2178;
    pub const ninesuperior: u16 = 0x2079;
    pub const nineteencircle: u16 = 0x2472;
    pub const nineteenparen: u16 = 0x2486;
    pub const nineteenperiod: u16 = 0x249a;
    pub const ninethai: u16 = 0x0e59;
    pub const nj: u16 = 0x01cc;
    pub const njecyrillic: u16 = 0x045a;
    pub const nkatakana: u16 = 0x30f3;
    pub const nkatakanahalfwidth: u16 = 0xff9d;
    pub const nlegrightlong: u16 = 0x019e;
    pub const nlinebelow: u16 = 0x1e49;
    pub const nmonospace: u16 = 0xff4e;
    pub const nmsquare: u16 = 0x339a;
    pub const nnabengali: u16 = 0x09a3;
    pub const nnadeva: u16 = 0x0923;
    pub const nnagujarati: u16 = 0x0aa3;
    pub const nnagurmukhi: u16 = 0x0a23;
    pub const nnnadeva: u16 = 0x0929;
    pub const nohiragana: u16 = 0x306e;
    pub const nokatakana: u16 = 0x30ce;
    pub const nokatakanahalfwidth: u16 = 0xff89;
    pub const nonbreakingspace: u16 = 0x00a0;
    pub const nonenthai: u16 = 0x0e13;
    pub const nonuthai: u16 = 0x0e19;
    pub const noonarabic: u16 = 0x0646;
    pub const noonfinalarabic: u16 = 0xfee6;
    pub const noonghunnaarabic: u16 = 0x06ba;
    pub const noonghunnafinalarabic: u16 = 0xfb9f;
    pub const noonhehinitialarabic: u16 = 0xfee7;
    pub const nooninitialarabic: u16 = 0xfee7;
    pub const noonjeeminitialarabic: u16 = 0xfcd2;
    pub const noonjeemisolatedarabic: u16 = 0xfc4b;
    pub const noonmedialarabic: u16 = 0xfee8;
    pub const noonmeeminitialarabic: u16 = 0xfcd5;
    pub const noonmeemisolatedarabic: u16 = 0xfc4e;
    pub const noonnoonfinalarabic: u16 = 0xfc8d;
    pub const notcontains: u16 = 0x220c;
    pub const notelement: u16 = 0x2209;
    pub const notelementof: u16 = 0x2209;
    pub const notequal: u16 = 0x2260;
    pub const notgreater: u16 = 0x226f;
    pub const notgreaternorequal: u16 = 0x2271;
    pub const notgreaternorless: u16 = 0x2279;
    pub const notidentical: u16 = 0x2262;
    pub const notless: u16 = 0x226e;
    pub const notlessnorequal: u16 = 0x2270;
    pub const notparallel: u16 = 0x2226;
    pub const notprecedes: u16 = 0x2280;
    pub const notsubset: u16 = 0x2284;
    pub const notsucceeds: u16 = 0x2281;
    pub const notsuperset: u16 = 0x2285;
    pub const nowarmenian: u16 = 0x0576;
    pub const nparen: u16 = 0x24a9;
    pub const nssquare: u16 = 0x33b1;
    pub const nsuperior: u16 = 0x207f;
    pub const ntilde: u16 = 0x00f1;
    pub const nu: u16 = 0x03bd;
    pub const nuhiragana: u16 = 0x306c;
    pub const nukatakana: u16 = 0x30cc;
    pub const nukatakanahalfwidth: u16 = 0xff87;
    pub const nuktabengali: u16 = 0x09bc;
    pub const nuktadeva: u16 = 0x093c;
    pub const nuktagujarati: u16 = 0x0abc;
    pub const nuktagurmukhi: u16 = 0x0a3c;
    pub const numbersign: u16 = 0x0023;
    pub const numbersignmonospace: u16 = 0xff03;
    pub const numbersignsmall: u16 = 0xfe5f;
    pub const numeralsigngreek: u16 = 0x0374;
    pub const numeralsignlowergreek: u16 = 0x0375;
    pub const numero: u16 = 0x2116;
    pub const nun: u16 = 0x05e0;
    pub const nundagesh: u16 = 0xfb40;
    pub const nundageshhebrew: u16 = 0xfb40;
    pub const nunhebrew: u16 = 0x05e0;
    pub const nvsquare: u16 = 0x33b5;
    pub const nwsquare: u16 = 0x33bb;
    pub const nyabengali: u16 = 0x099e;
    pub const nyadeva: u16 = 0x091e;
    pub const nyagujarati: u16 = 0x0a9e;
    pub const nyagurmukhi: u16 = 0x0a1e;
    pub const o: u16 = 0x006f;
    pub const oacute: u16 = 0x00f3;
    pub const oangthai: u16 = 0x0e2d;
    pub const obarred: u16 = 0x0275;
    pub const obarredcyrillic: u16 = 0x04e9;
    pub const obarreddieresiscyrillic: u16 = 0x04eb;
    pub const obengali: u16 = 0x0993;
    pub const obopomofo: u16 = 0x311b;
    pub const obreve: u16 = 0x014f;
    pub const ocandradeva: u16 = 0x0911;
    pub const ocandragujarati: u16 = 0x0a91;
    pub const ocandravowelsigndeva: u16 = 0x0949;
    pub const ocandravowelsigngujarati: u16 = 0x0ac9;
    pub const ocaron: u16 = 0x01d2;
    pub const ocircle: u16 = 0x24de;
    pub const ocircumflex: u16 = 0x00f4;
    pub const ocircumflexacute: u16 = 0x1ed1;
    pub const ocircumflexdotbelow: u16 = 0x1ed9;
    pub const ocircumflexgrave: u16 = 0x1ed3;
    pub const ocircumflexhookabove: u16 = 0x1ed5;
    pub const ocircumflextilde: u16 = 0x1ed7;
    pub const ocyrillic: u16 = 0x043e;
    pub const odblacute: u16 = 0x0151;
    pub const odblgrave: u16 = 0x020d;
    pub const odeva: u16 = 0x0913;
    pub const odieresis: u16 = 0x00f6;
    pub const odieresiscyrillic: u16 = 0x04e7;
    pub const odotbelow: u16 = 0x1ecd;
    pub const oe: u16 = 0x0153;
    pub const oekorean: u16 = 0x315a;
    pub const ogonek: u16 = 0x02db;
    pub const ogonekcmb: u16 = 0x0328;
    pub const ograve: u16 = 0x00f2;
    pub const ogujarati: u16 = 0x0a93;
    pub const oharmenian: u16 = 0x0585;
    pub const ohiragana: u16 = 0x304a;
    pub const ohookabove: u16 = 0x1ecf;
    pub const ohorn: u16 = 0x01a1;
    pub const ohornacute: u16 = 0x1edb;
    pub const ohorndotbelow: u16 = 0x1ee3;
    pub const ohorngrave: u16 = 0x1edd;
    pub const ohornhookabove: u16 = 0x1edf;
    pub const ohorntilde: u16 = 0x1ee1;
    pub const ohungarumlaut: u16 = 0x0151;
    pub const oi: u16 = 0x01a3;
    pub const oinvertedbreve: u16 = 0x020f;
    pub const okatakana: u16 = 0x30aa;
    pub const okatakanahalfwidth: u16 = 0xff75;
    pub const okorean: u16 = 0x3157;
    pub const olehebrew: u16 = 0x05ab;
    pub const omacron: u16 = 0x014d;
    pub const omacronacute: u16 = 0x1e53;
    pub const omacrongrave: u16 = 0x1e51;
    pub const omdeva: u16 = 0x0950;
    pub const omega: u16 = 0x03c9;
    pub const omega1: u16 = 0x03d6;
    pub const omegacyrillic: u16 = 0x0461;
    pub const omegalatinclosed: u16 = 0x0277;
    pub const omegaroundcyrillic: u16 = 0x047b;
    pub const omegatitlocyrillic: u16 = 0x047d;
    pub const omegatonos: u16 = 0x03ce;
    pub const omgujarati: u16 = 0x0ad0;
    pub const omicron: u16 = 0x03bf;
    pub const omicrontonos: u16 = 0x03cc;
    pub const omonospace: u16 = 0xff4f;
    pub const one: u16 = 0x0031;
    pub const onearabic: u16 = 0x0661;
    pub const onebengali: u16 = 0x09e7;
    pub const onecircle: u16 = 0x2460;
    pub const onecircleinversesansserif: u16 = 0x278a;
    pub const onedeva: u16 = 0x0967;
    pub const onedotenleader: u16 = 0x2024;
    pub const oneeighth: u16 = 0x215b;
    pub const onefitted: u16 = 0xf6dc;
    pub const onegujarati: u16 = 0x0ae7;
    pub const onegurmukhi: u16 = 0x0a67;
    pub const onehackarabic: u16 = 0x0661;
    pub const onehalf: u16 = 0x00bd;
    pub const onehangzhou: u16 = 0x3021;
    pub const oneideographicparen: u16 = 0x3220;
    pub const oneinferior: u16 = 0x2081;
    pub const onemonospace: u16 = 0xff11;
    pub const onenumeratorbengali: u16 = 0x09f4;
    pub const oneoldstyle: u16 = 0xf731;
    pub const oneparen: u16 = 0x2474;
    pub const oneperiod: u16 = 0x2488;
    pub const onepersian: u16 = 0x06f1;
    pub const onequarter: u16 = 0x00bc;
    pub const oneroman: u16 = 0x2170;
    pub const onesuperior: u16 = 0x00b9;
    pub const onethai: u16 = 0x0e51;
    pub const onethird: u16 = 0x2153;
    pub const oogonek: u16 = 0x01eb;
    pub const oogonekmacron: u16 = 0x01ed;
    pub const oogurmukhi: u16 = 0x0a13;
    pub const oomatragurmukhi: u16 = 0x0a4b;
    pub const oopen: u16 = 0x0254;
    pub const oparen: u16 = 0x24aa;
    pub const openbullet: u16 = 0x25e6;
    pub const option: u16 = 0x2325;
    pub const ordfeminine: u16 = 0x00aa;
    pub const ordmasculine: u16 = 0x00ba;
    pub const orthogonal: u16 = 0x221f;
    pub const oshortdeva: u16 = 0x0912;
    pub const oshortvowelsigndeva: u16 = 0x094a;
    pub const oslash: u16 = 0x00f8;
    pub const oslashacute: u16 = 0x01ff;
    pub const osmallhiragana: u16 = 0x3049;
    pub const osmallkatakana: u16 = 0x30a9;
    pub const osmallkatakanahalfwidth: u16 = 0xff6b;
    pub const ostrokeacute: u16 = 0x01ff;
    pub const osuperior: u16 = 0xf6f0;
    pub const otcyrillic: u16 = 0x047f;
    pub const otilde: u16 = 0x00f5;
    pub const otildeacute: u16 = 0x1e4d;
    pub const otildedieresis: u16 = 0x1e4f;
    pub const oubopomofo: u16 = 0x3121;
    pub const overline: u16 = 0x203e;
    pub const overlinecenterline: u16 = 0xfe4a;
    pub const overlinecmb: u16 = 0x0305;
    pub const overlinedashed: u16 = 0xfe49;
    pub const overlinedblwavy: u16 = 0xfe4c;
    pub const overlinewavy: u16 = 0xfe4b;
    pub const overscore: u16 = 0x00af;
    pub const ovowelsignbengali: u16 = 0x09cb;
    pub const ovowelsigndeva: u16 = 0x094b;
    pub const ovowelsigngujarati: u16 = 0x0acb;
    pub const owner: u16 = 0x220b;
    pub const p: u16 = 0x0070;
    pub const paampssquare: u16 = 0x3380;
    pub const paasentosquare: u16 = 0x332b;
    pub const pabengali: u16 = 0x09aa;
    pub const pacute: u16 = 0x1e55;
    pub const padeva: u16 = 0x092a;
    pub const pagedown: u16 = 0x21df;
    pub const pageup: u16 = 0x21de;
    pub const pagujarati: u16 = 0x0aaa;
    pub const pagurmukhi: u16 = 0x0a2a;
    pub const pahiragana: u16 = 0x3071;
    pub const paiyannoithai: u16 = 0x0e2f;
    pub const pakatakana: u16 = 0x30d1;
    pub const palatalizationcyrilliccmb: u16 = 0x0484;
    pub const palochkacyrillic: u16 = 0x04c0;
    pub const pansioskorean: u16 = 0x317f;
    pub const paragraph: u16 = 0x00b6;
    pub const parallel: u16 = 0x2225;
    pub const parenleft: u16 = 0x0028;
    pub const parenleftBig: u16 = 0x0028;
    pub const parenleftBigg: u16 = 0x0028;
    pub const parenleftaltonearabic: u16 = 0xfd3e;
    pub const parenleftbig: u16 = 0x0028;
    pub const parenleftbigg: u16 = 0x0028;
    pub const parenleftbt: u16 = 0xf8ed;
    pub const parenleftex: u16 = 0x007c;
    pub const parenleftex2: u16 = 0xf8ec;
    pub const parenleftinferior: u16 = 0x208d;
    pub const parenleftmonospace: u16 = 0xff08;
    pub const parenleftsmall: u16 = 0xfe59;
    pub const parenleftsuperior: u16 = 0x207d;
    pub const parenlefttp: u16 = 0xf8eb;
    pub const parenleftvertical: u16 = 0xfe35;
    pub const parenright: u16 = 0x0029;
    pub const parenrightBig: u16 = 0x0029;
    pub const parenrightBigg: u16 = 0x0029;
    pub const parenrightaltonearabic: u16 = 0xfd3f;
    pub const parenrightbig: u16 = 0x0029;
    pub const parenrightbigg: u16 = 0x0029;
    pub const parenrightbt: u16 = 0xf8f8;
    pub const parenrightex: u16 = 0x007c;
    pub const parenrightex2: u16 = 0xf8f7;
    pub const parenrightinferior: u16 = 0x208e;
    pub const parenrightmonospace: u16 = 0xff09;
    pub const parenrightsmall: u16 = 0xfe5a;
    pub const parenrightsuperior: u16 = 0x207e;
    pub const parenrighttp: u16 = 0xf8f6;
    pub const parenrightvertical: u16 = 0xfe36;
    pub const partialdiff: u16 = 0x2202;
    pub const paseqhebrew: u16 = 0x05c0;
    pub const pashtahebrew: u16 = 0x0599;
    pub const pasquare: u16 = 0x33a9;
    pub const patah: u16 = 0x05b7;
    pub const patah11: u16 = 0x05b7;
    pub const patah1d: u16 = 0x05b7;
    pub const patah2a: u16 = 0x05b7;
    pub const patahhebrew: u16 = 0x05b7;
    pub const patahnarrowhebrew: u16 = 0x05b7;
    pub const patahquarterhebrew: u16 = 0x05b7;
    pub const patahwidehebrew: u16 = 0x05b7;
    pub const pazerhebrew: u16 = 0x05a1;
    pub const pbopomofo: u16 = 0x3106;
    pub const pcircle: u16 = 0x24df;
    pub const pdotaccent: u16 = 0x1e57;
    pub const pe: u16 = 0x05e4;
    pub const pecyrillic: u16 = 0x043f;
    pub const pedagesh: u16 = 0xfb44;
    pub const pedageshhebrew: u16 = 0xfb44;
    pub const peezisquare: u16 = 0x333b;
    pub const pefinaldageshhebrew: u16 = 0xfb43;
    pub const peharabic: u16 = 0x067e;
    pub const peharmenian: u16 = 0x057a;
    pub const pehebrew: u16 = 0x05e4;
    pub const pehfinalarabic: u16 = 0xfb57;
    pub const pehinitialarabic: u16 = 0xfb58;
    pub const pehiragana: u16 = 0x307a;
    pub const pehmedialarabic: u16 = 0xfb59;
    pub const pekatakana: u16 = 0x30da;
    pub const pemiddlehookcyrillic: u16 = 0x04a7;
    pub const perafehebrew: u16 = 0xfb4e;
    pub const percent: u16 = 0x0025;
    pub const percentarabic: u16 = 0x066a;
    pub const percentmonospace: u16 = 0xff05;
    pub const percentsmall: u16 = 0xfe6a;
    pub const period: u16 = 0x002e;
    pub const periodarmenian: u16 = 0x0589;
    pub const periodcentered: u16 = 0x00b7;
    pub const periodhalfwidth: u16 = 0xff61;
    pub const periodinferior: u16 = 0xf6e7;
    pub const periodmonospace: u16 = 0xff0e;
    pub const periodsmall: u16 = 0xfe52;
    pub const periodsuperior: u16 = 0xf6e8;
    pub const perispomenigreekcmb: u16 = 0x0342;
    pub const perpendicular: u16 = 0x22a5;
    pub const pertenthousand: u16 = 0x2031;
    pub const perthousand: u16 = 0x2030;
    pub const peseta: u16 = 0x20a7;
    pub const pfsquare: u16 = 0x338a;
    pub const phabengali: u16 = 0x09ab;
    pub const phadeva: u16 = 0x092b;
    pub const phagujarati: u16 = 0x0aab;
    pub const phagurmukhi: u16 = 0x0a2b;
    pub const phi: u16 = 0x03c6;
    pub const phi2: u16 = 0x03d5;
    pub const phieuphacirclekorean: u16 = 0x327a;
    pub const phieuphaparenkorean: u16 = 0x321a;
    pub const phieuphcirclekorean: u16 = 0x326c;
    pub const phieuphkorean: u16 = 0x314d;
    pub const phieuphparenkorean: u16 = 0x320c;
    pub const philatin: u16 = 0x0278;
    pub const phinthuthai: u16 = 0x0e3a;
    pub const phisymbolgreek: u16 = 0x03d5;
    pub const phook: u16 = 0x01a5;
    pub const phophanthai: u16 = 0x0e1e;
    pub const phophungthai: u16 = 0x0e1c;
    pub const phosamphaothai: u16 = 0x0e20;
    pub const pi: u16 = 0x03c0;
    pub const pi1: u16 = 0x03d6;
    pub const pieupacirclekorean: u16 = 0x3273;
    pub const pieupaparenkorean: u16 = 0x3213;
    pub const pieupcieuckorean: u16 = 0x3176;
    pub const pieupcirclekorean: u16 = 0x3265;
    pub const pieupkiyeokkorean: u16 = 0x3172;
    pub const pieupkorean: u16 = 0x3142;
    pub const pieupparenkorean: u16 = 0x3205;
    pub const pieupsioskiyeokkorean: u16 = 0x3174;
    pub const pieupsioskorean: u16 = 0x3144;
    pub const pieupsiostikeutkorean: u16 = 0x3175;
    pub const pieupthieuthkorean: u16 = 0x3177;
    pub const pieuptikeutkorean: u16 = 0x3173;
    pub const pihiragana: u16 = 0x3074;
    pub const pikatakana: u16 = 0x30d4;
    pub const pisymbolgreek: u16 = 0x03d6;
    pub const piwrarmenian: u16 = 0x0583;
    pub const plus: u16 = 0x002b;
    pub const plusbelowcmb: u16 = 0x031f;
    pub const pluscircle: u16 = 0x2295;
    pub const plusminus: u16 = 0x00b1;
    pub const plusmod: u16 = 0x02d6;
    pub const plusmonospace: u16 = 0xff0b;
    pub const plussmall: u16 = 0xfe62;
    pub const plussuperior: u16 = 0x207a;
    pub const pmonospace: u16 = 0xff50;
    pub const pmsquare: u16 = 0x33d8;
    pub const pohiragana: u16 = 0x307d;
    pub const pointingindexdownwhite: u16 = 0x261f;
    pub const pointingindexleftwhite: u16 = 0x261c;
    pub const pointingindexrightwhite: u16 = 0x261e;
    pub const pointingindexupwhite: u16 = 0x261d;
    pub const pokatakana: u16 = 0x30dd;
    pub const poplathai: u16 = 0x0e1b;
    pub const postalmark: u16 = 0x3012;
    pub const postalmarkface: u16 = 0x3020;
    pub const pparen: u16 = 0x24ab;
    pub const precedes: u16 = 0x227a;
    pub const precedesequal: u16 = 0x227c;
    pub const prescription: u16 = 0x211e;
    pub const prime: u16 = 0x2032;
    pub const primemod: u16 = 0x02b9;
    pub const primereversed: u16 = 0x2035;
    pub const product: u16 = 0x220f;
    pub const productdisplay: u16 = 0x220f;
    pub const producttext: u16 = 0x220f;
    pub const projective: u16 = 0x2305;
    pub const prolongedkana: u16 = 0x30fc;
    pub const propellor: u16 = 0x2318;
    pub const propersubset: u16 = 0x2282;
    pub const propersuperset: u16 = 0x2283;
    pub const proportion: u16 = 0x2237;
    pub const proportional: u16 = 0x221d;
    pub const psi: u16 = 0x03c8;
    pub const psicyrillic: u16 = 0x0471;
    pub const psilipneumatacyrilliccmb: u16 = 0x0486;
    pub const pssquare: u16 = 0x33b0;
    pub const puhiragana: u16 = 0x3077;
    pub const pukatakana: u16 = 0x30d7;
    pub const punctdash: u16 = 0x2014;
    pub const pvsquare: u16 = 0x33b4;
    pub const pwsquare: u16 = 0x33ba;
    pub const q: u16 = 0x0071;
    pub const qadeva: u16 = 0x0958;
    pub const qadmahebrew: u16 = 0x05a8;
    pub const qafarabic: u16 = 0x0642;
    pub const qaffinalarabic: u16 = 0xfed6;
    pub const qafinitialarabic: u16 = 0xfed7;
    pub const qafmedialarabic: u16 = 0xfed8;
    pub const qamats: u16 = 0x05b8;
    pub const qamats10: u16 = 0x05b8;
    pub const qamats1a: u16 = 0x05b8;
    pub const qamats1c: u16 = 0x05b8;
    pub const qamats27: u16 = 0x05b8;
    pub const qamats29: u16 = 0x05b8;
    pub const qamats33: u16 = 0x05b8;
    pub const qamatsde: u16 = 0x05b8;
    pub const qamatshebrew: u16 = 0x05b8;
    pub const qamatsnarrowhebrew: u16 = 0x05b8;
    pub const qamatsqatanhebrew: u16 = 0x05b8;
    pub const qamatsqatannarrowhebrew: u16 = 0x05b8;
    pub const qamatsqatanquarterhebrew: u16 = 0x05b8;
    pub const qamatsqatanwidehebrew: u16 = 0x05b8;
    pub const qamatsquarterhebrew: u16 = 0x05b8;
    pub const qamatswidehebrew: u16 = 0x05b8;
    pub const qarneyparahebrew: u16 = 0x059f;
    pub const qbopomofo: u16 = 0x3111;
    pub const qcircle: u16 = 0x24e0;
    pub const qhook: u16 = 0x02a0;
    pub const qmonospace: u16 = 0xff51;
    pub const qof: u16 = 0x05e7;
    pub const qofdagesh: u16 = 0xfb47;
    pub const qofdageshhebrew: u16 = 0xfb47;
    pub const qofhatafpatah: u16 = 0x05e7;
    pub const qofhatafpatahhebrew: u16 = 0x05e7;
    pub const qofhatafsegol: u16 = 0x05e7;
    pub const qofhatafsegolhebrew: u16 = 0x05e7;
    pub const qofhebrew: u16 = 0x05e7;
    pub const qofhiriq: u16 = 0x05e7;
    pub const qofhiriqhebrew: u16 = 0x05e7;
    pub const qofholam: u16 = 0x05e7;
    pub const qofholamhebrew: u16 = 0x05e7;
    pub const qofpatah: u16 = 0x05e7;
    pub const qofpatahhebrew: u16 = 0x05e7;
    pub const qofqamats: u16 = 0x05e7;
    pub const qofqamatshebrew: u16 = 0x05e7;
    pub const qofqubuts: u16 = 0x05e7;
    pub const qofqubutshebrew: u16 = 0x05e7;
    pub const qofsegol: u16 = 0x05e7;
    pub const qofsegolhebrew: u16 = 0x05e7;
    pub const qofsheva: u16 = 0x05e7;
    pub const qofshevahebrew: u16 = 0x05e7;
    pub const qoftsere: u16 = 0x05e7;
    pub const qoftserehebrew: u16 = 0x05e7;
    pub const qparen: u16 = 0x24ac;
    pub const quarternote: u16 = 0x2669;
    pub const qubuts: u16 = 0x05bb;
    pub const qubuts18: u16 = 0x05bb;
    pub const qubuts25: u16 = 0x05bb;
    pub const qubuts31: u16 = 0x05bb;
    pub const qubutshebrew: u16 = 0x05bb;
    pub const qubutsnarrowhebrew: u16 = 0x05bb;
    pub const qubutsquarterhebrew: u16 = 0x05bb;
    pub const qubutswidehebrew: u16 = 0x05bb;
    pub const question: u16 = 0x003f;
    pub const questionarabic: u16 = 0x061f;
    pub const questionarmenian: u16 = 0x055e;
    pub const questiondown: u16 = 0x00bf;
    pub const questiondownsmall: u16 = 0xf7bf;
    pub const questiongreek: u16 = 0x037e;
    pub const questionmonospace: u16 = 0xff1f;
    pub const questionsmall: u16 = 0xf73f;
    pub const quotedbl: u16 = 0x0022;
    pub const quotedblbase: u16 = 0x201e;
    pub const quotedblleft: u16 = 0x201c;
    pub const quotedblmonospace: u16 = 0xff02;
    pub const quotedblprime: u16 = 0x301e;
    pub const quotedblprimereversed: u16 = 0x301d;
    pub const quotedblright: u16 = 0x201d;
    pub const quoteleft: u16 = 0x2018;
    pub const quoteleftreversed: u16 = 0x201b;
    pub const quotereversed: u16 = 0x201b;
    pub const quoteright: u16 = 0x2019;
    pub const quoterightn: u16 = 0x0149;
    pub const quotesinglbase: u16 = 0x201a;
    pub const quotesingle: u16 = 0x0027;
    pub const quotesinglemonospace: u16 = 0xff07;
    pub const r: u16 = 0x0072;
    pub const raarmenian: u16 = 0x057c;
    pub const rabengali: u16 = 0x09b0;
    pub const racute: u16 = 0x0155;
    pub const radeva: u16 = 0x0930;
    pub const radical: u16 = 0x221a;
    pub const radicalBig: u16 = 0x221a;
    pub const radicalBigg: u16 = 0x221a;
    pub const radicalbig: u16 = 0x221a;
    pub const radicalbigg: u16 = 0x221a;
    pub const radicalbt: u16 = 0x221a;
    pub const radicalex: u16 = 0xf8e5;
    pub const radoverssquare: u16 = 0x33ae;
    pub const radoverssquaredsquare: u16 = 0x33af;
    pub const radsquare: u16 = 0x33ad;
    pub const rafe: u16 = 0x05bf;
    pub const rafehebrew: u16 = 0x05bf;
    pub const ragujarati: u16 = 0x0ab0;
    pub const ragurmukhi: u16 = 0x0a30;
    pub const rahiragana: u16 = 0x3089;
    pub const rakatakana: u16 = 0x30e9;
    pub const rakatakanahalfwidth: u16 = 0xff97;
    pub const ralowerdiagonalbengali: u16 = 0x09f1;
    pub const ramiddlediagonalbengali: u16 = 0x09f0;
    pub const ramshorn: u16 = 0x0264;
    pub const rangedash: u16 = 0x2013;
    pub const ratio: u16 = 0x2236;
    pub const rbopomofo: u16 = 0x3116;
    pub const rcaron: u16 = 0x0159;
    pub const rcedilla: u16 = 0x0157;
    pub const rcircle: u16 = 0x24e1;
    pub const rcommaaccent: u16 = 0x0157;
    pub const rdblgrave: u16 = 0x0211;
    pub const rdotaccent: u16 = 0x1e59;
    pub const rdotbelow: u16 = 0x1e5b;
    pub const rdotbelowmacron: u16 = 0x1e5d;
    pub const referencemark: u16 = 0x203b;
    pub const reflexsubset: u16 = 0x2286;
    pub const reflexsuperset: u16 = 0x2287;
    pub const registered: u16 = 0x00ae;
    pub const registersans: u16 = 0xf8e8;
    pub const registerserif: u16 = 0xf6da;
    pub const reharabic: u16 = 0x0631;
    pub const reharmenian: u16 = 0x0580;
    pub const rehfinalarabic: u16 = 0xfeae;
    pub const rehiragana: u16 = 0x308c;
    pub const rehyehaleflamarabic: u16 = 0x0631;
    pub const rekatakana: u16 = 0x30ec;
    pub const rekatakanahalfwidth: u16 = 0xff9a;
    pub const resh: u16 = 0x05e8;
    pub const reshdageshhebrew: u16 = 0xfb48;
    pub const reshhatafpatah: u16 = 0x05e8;
    pub const reshhatafpatahhebrew: u16 = 0x05e8;
    pub const reshhatafsegol: u16 = 0x05e8;
    pub const reshhatafsegolhebrew: u16 = 0x05e8;
    pub const reshhebrew: u16 = 0x05e8;
    pub const reshhiriq: u16 = 0x05e8;
    pub const reshhiriqhebrew: u16 = 0x05e8;
    pub const reshholam: u16 = 0x05e8;
    pub const reshholamhebrew: u16 = 0x05e8;
    pub const reshpatah: u16 = 0x05e8;
    pub const reshpatahhebrew: u16 = 0x05e8;
    pub const reshqamats: u16 = 0x05e8;
    pub const reshqamatshebrew: u16 = 0x05e8;
    pub const reshqubuts: u16 = 0x05e8;
    pub const reshqubutshebrew: u16 = 0x05e8;
    pub const reshsegol: u16 = 0x05e8;
    pub const reshsegolhebrew: u16 = 0x05e8;
    pub const reshsheva: u16 = 0x05e8;
    pub const reshshevahebrew: u16 = 0x05e8;
    pub const reshtsere: u16 = 0x05e8;
    pub const reshtserehebrew: u16 = 0x05e8;
    pub const reversedtilde: u16 = 0x223d;
    pub const reviahebrew: u16 = 0x0597;
    pub const reviamugrashhebrew: u16 = 0x0597;
    pub const revlogicalnot: u16 = 0x2310;
    pub const rfishhook: u16 = 0x027e;
    pub const rfishhookreversed: u16 = 0x027f;
    pub const rhabengali: u16 = 0x09dd;
    pub const rhadeva: u16 = 0x095d;
    pub const rho: u16 = 0x03c1;
    pub const rho1: u16 = 0x03f1;
    pub const rhook: u16 = 0x027d;
    pub const rhookturned: u16 = 0x027b;
    pub const rhookturnedsuperior: u16 = 0x02b5;
    pub const rhosymbolgreek: u16 = 0x03f1;
    pub const rhotichookmod: u16 = 0x02de;
    pub const rieulacirclekorean: u16 = 0x3271;
    pub const rieulaparenkorean: u16 = 0x3211;
    pub const rieulcirclekorean: u16 = 0x3263;
    pub const rieulhieuhkorean: u16 = 0x3140;
    pub const rieulkiyeokkorean: u16 = 0x313a;
    pub const rieulkiyeoksioskorean: u16 = 0x3169;
    pub const rieulkorean: u16 = 0x3139;
    pub const rieulmieumkorean: u16 = 0x313b;
    pub const rieulpansioskorean: u16 = 0x316c;
    pub const rieulparenkorean: u16 = 0x3203;
    pub const rieulphieuphkorean: u16 = 0x313f;
    pub const rieulpieupkorean: u16 = 0x313c;
    pub const rieulpieupsioskorean: u16 = 0x316b;
    pub const rieulsioskorean: u16 = 0x313d;
    pub const rieulthieuthkorean: u16 = 0x313e;
    pub const rieultikeutkorean: u16 = 0x316a;
    pub const rieulyeorinhieuhkorean: u16 = 0x316d;
    pub const rightangle: u16 = 0x221f;
    pub const righttackbelowcmb: u16 = 0x0319;
    pub const righttriangle: u16 = 0x22bf;
    pub const rihiragana: u16 = 0x308a;
    pub const rikatakana: u16 = 0x30ea;
    pub const rikatakanahalfwidth: u16 = 0xff98;
    pub const ring: u16 = 0x02da;
    pub const ringbelowcmb: u16 = 0x0325;
    pub const ringcmb: u16 = 0x030a;
    pub const ringhalfleft: u16 = 0x02bf;
    pub const ringhalfleftarmenian: u16 = 0x0559;
    pub const ringhalfleftbelowcmb: u16 = 0x031c;
    pub const ringhalfleftcentered: u16 = 0x02d3;
    pub const ringhalfright: u16 = 0x02be;
    pub const ringhalfrightbelowcmb: u16 = 0x0339;
    pub const ringhalfrightcentered: u16 = 0x02d2;
    pub const rinvertedbreve: u16 = 0x0213;
    pub const rittorusquare: u16 = 0x3351;
    pub const rlinebelow: u16 = 0x1e5f;
    pub const rlongleg: u16 = 0x027c;
    pub const rlonglegturned: u16 = 0x027a;
    pub const rmonospace: u16 = 0xff52;
    pub const rohiragana: u16 = 0x308d;
    pub const rokatakana: u16 = 0x30ed;
    pub const rokatakanahalfwidth: u16 = 0xff9b;
    pub const roruathai: u16 = 0x0e23;
    pub const rparen: u16 = 0x24ad;
    pub const rrabengali: u16 = 0x09dc;
    pub const rradeva: u16 = 0x0931;
    pub const rragurmukhi: u16 = 0x0a5c;
    pub const rreharabic: u16 = 0x0691;
    pub const rrehfinalarabic: u16 = 0xfb8d;
    pub const rrvocalicbengali: u16 = 0x09e0;
    pub const rrvocalicdeva: u16 = 0x0960;
    pub const rrvocalicgujarati: u16 = 0x0ae0;
    pub const rrvocalicvowelsignbengali: u16 = 0x09c4;
    pub const rrvocalicvowelsigndeva: u16 = 0x0944;
    pub const rrvocalicvowelsigngujarati: u16 = 0x0ac4;
    pub const rsuperior: u16 = 0xf6f1;
    pub const rtblock: u16 = 0x2590;
    pub const rturned: u16 = 0x0279;
    pub const rturnedsuperior: u16 = 0x02b4;
    pub const ruhiragana: u16 = 0x308b;
    pub const rukatakana: u16 = 0x30eb;
    pub const rukatakanahalfwidth: u16 = 0xff99;
    pub const rupeemarkbengali: u16 = 0x09f2;
    pub const rupeesignbengali: u16 = 0x09f3;
    pub const rupiah: u16 = 0xf6dd;
    pub const ruthai: u16 = 0x0e24;
    pub const rvocalicbengali: u16 = 0x098b;
    pub const rvocalicdeva: u16 = 0x090b;
    pub const rvocalicgujarati: u16 = 0x0a8b;
    pub const rvocalicvowelsignbengali: u16 = 0x09c3;
    pub const rvocalicvowelsigndeva: u16 = 0x0943;
    pub const rvocalicvowelsigngujarati: u16 = 0x0ac3;
    pub const s: u16 = 0x0073;
    pub const sabengali: u16 = 0x09b8;
    pub const sacute: u16 = 0x015b;
    pub const sacutedotaccent: u16 = 0x1e65;
    pub const sadarabic: u16 = 0x0635;
    pub const sadeva: u16 = 0x0938;
    pub const sadfinalarabic: u16 = 0xfeba;
    pub const sadinitialarabic: u16 = 0xfebb;
    pub const sadmedialarabic: u16 = 0xfebc;
    pub const sagujarati: u16 = 0x0ab8;
    pub const sagurmukhi: u16 = 0x0a38;
    pub const sahiragana: u16 = 0x3055;
    pub const sakatakana: u16 = 0x30b5;
    pub const sakatakanahalfwidth: u16 = 0xff7b;
    pub const sallallahoualayhewasallamarabic: u16 = 0xfdfa;
    pub const samekh: u16 = 0x05e1;
    pub const samekhdagesh: u16 = 0xfb41;
    pub const samekhdageshhebrew: u16 = 0xfb41;
    pub const samekhhebrew: u16 = 0x05e1;
    pub const saraaathai: u16 = 0x0e32;
    pub const saraaethai: u16 = 0x0e41;
    pub const saraaimaimalaithai: u16 = 0x0e44;
    pub const saraaimaimuanthai: u16 = 0x0e43;
    pub const saraamthai: u16 = 0x0e33;
    pub const saraathai: u16 = 0x0e30;
    pub const saraethai: u16 = 0x0e40;
    pub const saraiileftthai: u16 = 0xf886;
    pub const saraiithai: u16 = 0x0e35;
    pub const saraileftthai: u16 = 0xf885;
    pub const saraithai: u16 = 0x0e34;
    pub const saraothai: u16 = 0x0e42;
    pub const saraueeleftthai: u16 = 0xf888;
    pub const saraueethai: u16 = 0x0e37;
    pub const saraueleftthai: u16 = 0xf887;
    pub const sarauethai: u16 = 0x0e36;
    pub const sarauthai: u16 = 0x0e38;
    pub const sarauuthai: u16 = 0x0e39;
    pub const sbopomofo: u16 = 0x3119;
    pub const scaron: u16 = 0x0161;
    pub const scarondotaccent: u16 = 0x1e67;
    pub const scedilla: u16 = 0x015f;
    pub const schwa: u16 = 0x0259;
    pub const schwacyrillic: u16 = 0x04d9;
    pub const schwadieresiscyrillic: u16 = 0x04db;
    pub const schwahook: u16 = 0x025a;
    pub const scircle: u16 = 0x24e2;
    pub const scircumflex: u16 = 0x015d;
    pub const scommaaccent: u16 = 0x0219;
    pub const sdotaccent: u16 = 0x1e61;
    pub const sdotbelow: u16 = 0x1e63;
    pub const sdotbelowdotaccent: u16 = 0x1e69;
    pub const seagullbelowcmb: u16 = 0x033c;
    pub const second: u16 = 0x2033;
    pub const secondtonechinese: u16 = 0x02ca;
    pub const section: u16 = 0x00a7;
    pub const seenarabic: u16 = 0x0633;
    pub const seenfinalarabic: u16 = 0xfeb2;
    pub const seeninitialarabic: u16 = 0xfeb3;
    pub const seenmedialarabic: u16 = 0xfeb4;
    pub const segol: u16 = 0x05b6;
    pub const segol13: u16 = 0x05b6;
    pub const segol1f: u16 = 0x05b6;
    pub const segol2c: u16 = 0x05b6;
    pub const segolhebrew: u16 = 0x05b6;
    pub const segolnarrowhebrew: u16 = 0x05b6;
    pub const segolquarterhebrew: u16 = 0x05b6;
    pub const segoltahebrew: u16 = 0x0592;
    pub const segolwidehebrew: u16 = 0x05b6;
    pub const seharmenian: u16 = 0x057d;
    pub const sehiragana: u16 = 0x305b;
    pub const sekatakana: u16 = 0x30bb;
    pub const sekatakanahalfwidth: u16 = 0xff7e;
    pub const semicolon: u16 = 0x003b;
    pub const semicolonarabic: u16 = 0x061b;
    pub const semicolonmonospace: u16 = 0xff1b;
    pub const semicolonsmall: u16 = 0xfe54;
    pub const semivoicedmarkkana: u16 = 0x309c;
    pub const semivoicedmarkkanahalfwidth: u16 = 0xff9f;
    pub const sentisquare: u16 = 0x3322;
    pub const sentosquare: u16 = 0x3323;
    pub const seven: u16 = 0x0037;
    pub const sevenarabic: u16 = 0x0667;
    pub const sevenbengali: u16 = 0x09ed;
    pub const sevencircle: u16 = 0x2466;
    pub const sevencircleinversesansserif: u16 = 0x2790;
    pub const sevendeva: u16 = 0x096d;
    pub const seveneighths: u16 = 0x215e;
    pub const sevengujarati: u16 = 0x0aed;
    pub const sevengurmukhi: u16 = 0x0a6d;
    pub const sevenhackarabic: u16 = 0x0667;
    pub const sevenhangzhou: u16 = 0x3027;
    pub const sevenideographicparen: u16 = 0x3226;
    pub const seveninferior: u16 = 0x2087;
    pub const sevenmonospace: u16 = 0xff17;
    pub const sevenoldstyle: u16 = 0xf737;
    pub const sevenparen: u16 = 0x247a;
    pub const sevenperiod: u16 = 0x248e;
    pub const sevenpersian: u16 = 0x06f7;
    pub const sevenroman: u16 = 0x2176;
    pub const sevensuperior: u16 = 0x2077;
    pub const seventeencircle: u16 = 0x2470;
    pub const seventeenparen: u16 = 0x2484;
    pub const seventeenperiod: u16 = 0x2498;
    pub const seventhai: u16 = 0x0e57;
    pub const sfthyphen: u16 = 0x00ad;
    pub const shaarmenian: u16 = 0x0577;
    pub const shabengali: u16 = 0x09b6;
    pub const shacyrillic: u16 = 0x0448;
    pub const shaddaarabic: u16 = 0x0651;
    pub const shaddadammaarabic: u16 = 0xfc61;
    pub const shaddadammatanarabic: u16 = 0xfc5e;
    pub const shaddafathaarabic: u16 = 0xfc60;
    pub const shaddafathatanarabic: u16 = 0x0651;
    pub const shaddakasraarabic: u16 = 0xfc62;
    pub const shaddakasratanarabic: u16 = 0xfc5f;
    pub const shade: u16 = 0x2592;
    pub const shadedark: u16 = 0x2593;
    pub const shadelight: u16 = 0x2591;
    pub const shademedium: u16 = 0x2592;
    pub const shadeva: u16 = 0x0936;
    pub const shagujarati: u16 = 0x0ab6;
    pub const shagurmukhi: u16 = 0x0a36;
    pub const shalshelethebrew: u16 = 0x0593;
    pub const sharp: u16 = 0x266f;
    pub const shbopomofo: u16 = 0x3115;
    pub const shchacyrillic: u16 = 0x0449;
    pub const sheenarabic: u16 = 0x0634;
    pub const sheenfinalarabic: u16 = 0xfeb6;
    pub const sheeninitialarabic: u16 = 0xfeb7;
    pub const sheenmedialarabic: u16 = 0xfeb8;
    pub const sheicoptic: u16 = 0x03e3;
    pub const sheqel: u16 = 0x20aa;
    pub const sheqelhebrew: u16 = 0x20aa;
    pub const sheva: u16 = 0x05b0;
    pub const sheva115: u16 = 0x05b0;
    pub const sheva15: u16 = 0x05b0;
    pub const sheva22: u16 = 0x05b0;
    pub const sheva2e: u16 = 0x05b0;
    pub const shevahebrew: u16 = 0x05b0;
    pub const shevanarrowhebrew: u16 = 0x05b0;
    pub const shevaquarterhebrew: u16 = 0x05b0;
    pub const shevawidehebrew: u16 = 0x05b0;
    pub const shhacyrillic: u16 = 0x04bb;
    pub const shimacoptic: u16 = 0x03ed;
    pub const shin: u16 = 0x05e9;
    pub const shindagesh: u16 = 0xfb49;
    pub const shindageshhebrew: u16 = 0xfb49;
    pub const shindageshshindot: u16 = 0xfb2c;
    pub const shindageshshindothebrew: u16 = 0xfb2c;
    pub const shindageshsindot: u16 = 0xfb2d;
    pub const shindageshsindothebrew: u16 = 0xfb2d;
    pub const shindothebrew: u16 = 0x05c1;
    pub const shinhebrew: u16 = 0x05e9;
    pub const shinshindot: u16 = 0xfb2a;
    pub const shinshindothebrew: u16 = 0xfb2a;
    pub const shinsindot: u16 = 0xfb2b;
    pub const shinsindothebrew: u16 = 0xfb2b;
    pub const shook: u16 = 0x0282;
    pub const sigma: u16 = 0x03c3;
    pub const sigma1: u16 = 0x03c2;
    pub const sigmafinal: u16 = 0x03c2;
    pub const sigmalunatesymbolgreek: u16 = 0x03f2;
    pub const sihiragana: u16 = 0x3057;
    pub const sikatakana: u16 = 0x30b7;
    pub const sikatakanahalfwidth: u16 = 0xff7c;
    pub const siluqhebrew: u16 = 0x05bd;
    pub const siluqlefthebrew: u16 = 0x05bd;
    pub const similar: u16 = 0x223c;
    pub const similarequal: u16 = 0x2243;
    pub const sindothebrew: u16 = 0x05c2;
    pub const siosacirclekorean: u16 = 0x3274;
    pub const siosaparenkorean: u16 = 0x3214;
    pub const sioscieuckorean: u16 = 0x317e;
    pub const sioscirclekorean: u16 = 0x3266;
    pub const sioskiyeokkorean: u16 = 0x317a;
    pub const sioskorean: u16 = 0x3145;
    pub const siosnieunkorean: u16 = 0x317b;
    pub const siosparenkorean: u16 = 0x3206;
    pub const siospieupkorean: u16 = 0x317d;
    pub const siostikeutkorean: u16 = 0x317c;
    pub const six: u16 = 0x0036;
    pub const sixarabic: u16 = 0x0666;
    pub const sixbengali: u16 = 0x09ec;
    pub const sixcircle: u16 = 0x2465;
    pub const sixcircleinversesansserif: u16 = 0x278f;
    pub const sixdeva: u16 = 0x096c;
    pub const sixgujarati: u16 = 0x0aec;
    pub const sixgurmukhi: u16 = 0x0a6c;
    pub const sixhackarabic: u16 = 0x0666;
    pub const sixhangzhou: u16 = 0x3026;
    pub const sixideographicparen: u16 = 0x3225;
    pub const sixinferior: u16 = 0x2086;
    pub const sixmonospace: u16 = 0xff16;
    pub const sixoldstyle: u16 = 0xf736;
    pub const sixparen: u16 = 0x2479;
    pub const sixperiod: u16 = 0x248d;
    pub const sixpersian: u16 = 0x06f6;
    pub const sixroman: u16 = 0x2175;
    pub const sixsuperior: u16 = 0x2076;
    pub const sixteencircle: u16 = 0x246f;
    pub const sixteencurrencydenominatorbengali: u16 = 0x09f9;
    pub const sixteenparen: u16 = 0x2483;
    pub const sixteenperiod: u16 = 0x2497;
    pub const sixthai: u16 = 0x0e56;
    pub const slash: u16 = 0x002f;
    pub const slashBig: u16 = 0x2215;
    pub const slashBigg: u16 = 0x2215;
    pub const slashbig: u16 = 0x2215;
    pub const slashbigg: u16 = 0x2215;
    pub const slashmonospace: u16 = 0xff0f;
    pub const slong: u16 = 0x017f;
    pub const slongdotaccent: u16 = 0x1e9b;
    pub const slurabove: u16 = 0x2322;
    pub const slurbelow: u16 = 0x2323;
    pub const smileface: u16 = 0x263a;
    pub const smonospace: u16 = 0xff53;
    pub const sofpasuqhebrew: u16 = 0x05c3;
    pub const softhyphen: u16 = 0x00ad;
    pub const softsigncyrillic: u16 = 0x044c;
    pub const sohiragana: u16 = 0x305d;
    pub const sokatakana: u16 = 0x30bd;
    pub const sokatakanahalfwidth: u16 = 0xff7f;
    pub const soliduslongoverlaycmb: u16 = 0x0338;
    pub const solidusshortoverlaycmb: u16 = 0x0337;
    pub const sorusithai: u16 = 0x0e29;
    pub const sosalathai: u16 = 0x0e28;
    pub const sosothai: u16 = 0x0e0b;
    pub const sosuathai: u16 = 0x0e2a;
    pub const space: u16 = 0x0020;
    pub const spacehackarabic: u16 = 0x0020;
    pub const spade: u16 = 0x2660;
    pub const spadesuitblack: u16 = 0x2660;
    pub const spadesuitwhite: u16 = 0x2664;
    pub const sparen: u16 = 0x24ae;
    pub const squarebelowcmb: u16 = 0x033b;
    pub const squarecc: u16 = 0x33c4;
    pub const squarecm: u16 = 0x339d;
    pub const squarediagonalcrosshatchfill: u16 = 0x25a9;
    pub const squarehorizontalfill: u16 = 0x25a4;
    pub const squarekg: u16 = 0x338f;
    pub const squarekm: u16 = 0x339e;
    pub const squarekmcapital: u16 = 0x33ce;
    pub const squareln: u16 = 0x33d1;
    pub const squarelog: u16 = 0x33d2;
    pub const squaremg: u16 = 0x338e;
    pub const squaremil: u16 = 0x33d5;
    pub const squaremm: u16 = 0x339c;
    pub const squaremsquared: u16 = 0x33a1;
    pub const squareorthogonalcrosshatchfill: u16 = 0x25a6;
    pub const squareupperlefttolowerrightfill: u16 = 0x25a7;
    pub const squareupperrighttolowerleftfill: u16 = 0x25a8;
    pub const squareverticalfill: u16 = 0x25a5;
    pub const squarewhitewithsmallblack: u16 = 0x25a3;
    pub const srsquare: u16 = 0x33db;
    pub const ssabengali: u16 = 0x09b7;
    pub const ssadeva: u16 = 0x0937;
    pub const ssagujarati: u16 = 0x0ab7;
    pub const ssangcieuckorean: u16 = 0x3149;
    pub const ssanghieuhkorean: u16 = 0x3185;
    pub const ssangieungkorean: u16 = 0x3180;
    pub const ssangkiyeokkorean: u16 = 0x3132;
    pub const ssangnieunkorean: u16 = 0x3165;
    pub const ssangpieupkorean: u16 = 0x3143;
    pub const ssangsioskorean: u16 = 0x3146;
    pub const ssangtikeutkorean: u16 = 0x3138;
    pub const ssuperior: u16 = 0xf6f2;
    pub const star: u16 = 0x22c6;
    pub const sterling: u16 = 0x00a3;
    pub const sterlingmonospace: u16 = 0xffe1;
    pub const strokelongoverlaycmb: u16 = 0x0336;
    pub const strokeshortoverlaycmb: u16 = 0x0335;
    pub const subset: u16 = 0x2282;
    pub const subsetnotequal: u16 = 0x228a;
    pub const subsetorequal: u16 = 0x2286;
    pub const subsetsqequal: u16 = 0x2291;
    pub const succeeds: u16 = 0x227b;
    pub const suchthat: u16 = 0x220b;
    pub const suhiragana: u16 = 0x3059;
    pub const sukatakana: u16 = 0x30b9;
    pub const sukatakanahalfwidth: u16 = 0xff7d;
    pub const sukunarabic: u16 = 0x0652;
    pub const summation: u16 = 0x2211;
    pub const summationdisplay: u16 = 0x2211;
    pub const summationtext: u16 = 0x2211;
    pub const sun: u16 = 0x263c;
    pub const superset: u16 = 0x2283;
    pub const supersetnotequal: u16 = 0x228b;
    pub const supersetorequal: u16 = 0x2287;
    pub const supersetsqequal: u16 = 0x2292;
    pub const svsquare: u16 = 0x33dc;
    pub const syouwaerasquare: u16 = 0x337c;
    pub const t: u16 = 0x0074;
    pub const tabengali: u16 = 0x09a4;
    pub const tackdown: u16 = 0x22a4;
    pub const tackleft: u16 = 0x22a3;
    pub const tadeva: u16 = 0x0924;
    pub const tagujarati: u16 = 0x0aa4;
    pub const tagurmukhi: u16 = 0x0a24;
    pub const taharabic: u16 = 0x0637;
    pub const tahfinalarabic: u16 = 0xfec2;
    pub const tahinitialarabic: u16 = 0xfec3;
    pub const tahiragana: u16 = 0x305f;
    pub const tahmedialarabic: u16 = 0xfec4;
    pub const taisyouerasquare: u16 = 0x337d;
    pub const takatakana: u16 = 0x30bf;
    pub const takatakanahalfwidth: u16 = 0xff80;
    pub const tatweelarabic: u16 = 0x0640;
    pub const tau: u16 = 0x03c4;
    pub const tav: u16 = 0x05ea;
    pub const tavdages: u16 = 0xfb4a;
    pub const tavdagesh: u16 = 0xfb4a;
    pub const tavdageshhebrew: u16 = 0xfb4a;
    pub const tavhebrew: u16 = 0x05ea;
    pub const tbar: u16 = 0x0167;
    pub const tbopomofo: u16 = 0x310a;
    pub const tcaron: u16 = 0x0165;
    pub const tccurl: u16 = 0x02a8;
    pub const tcedilla: u16 = 0x0163;
    pub const tcheharabic: u16 = 0x0686;
    pub const tchehfinalarabic: u16 = 0xfb7b;
    pub const tchehinitialarabic: u16 = 0xfb7c;
    pub const tchehmedialarabic: u16 = 0xfb7d;
    pub const tchehmeeminitialarabic: u16 = 0xfb7c;
    pub const tcircle: u16 = 0x24e3;
    pub const tcircumflexbelow: u16 = 0x1e71;
    pub const tcommaaccent: u16 = 0x0163;
    pub const tdieresis: u16 = 0x1e97;
    pub const tdotaccent: u16 = 0x1e6b;
    pub const tdotbelow: u16 = 0x1e6d;
    pub const tecyrillic: u16 = 0x0442;
    pub const tedescendercyrillic: u16 = 0x04ad;
    pub const teharabic: u16 = 0x062a;
    pub const tehfinalarabic: u16 = 0xfe96;
    pub const tehhahinitialarabic: u16 = 0xfca2;
    pub const tehhahisolatedarabic: u16 = 0xfc0c;
    pub const tehinitialarabic: u16 = 0xfe97;
    pub const tehiragana: u16 = 0x3066;
    pub const tehjeeminitialarabic: u16 = 0xfca1;
    pub const tehjeemisolatedarabic: u16 = 0xfc0b;
    pub const tehmarbutaarabic: u16 = 0x0629;
    pub const tehmarbutafinalarabic: u16 = 0xfe94;
    pub const tehmedialarabic: u16 = 0xfe98;
    pub const tehmeeminitialarabic: u16 = 0xfca4;
    pub const tehmeemisolatedarabic: u16 = 0xfc0e;
    pub const tehnoonfinalarabic: u16 = 0xfc73;
    pub const tekatakana: u16 = 0x30c6;
    pub const tekatakanahalfwidth: u16 = 0xff83;
    pub const telephone: u16 = 0x2121;
    pub const telephoneblack: u16 = 0x260e;
    pub const telishagedolahebrew: u16 = 0x05a0;
    pub const telishaqetanahebrew: u16 = 0x05a9;
    pub const tencircle: u16 = 0x2469;
    pub const tenideographicparen: u16 = 0x3229;
    pub const tenparen: u16 = 0x247d;
    pub const tenperiod: u16 = 0x2491;
    pub const tenroman: u16 = 0x2179;
    pub const tesh: u16 = 0x02a7;
    pub const tet: u16 = 0x05d8;
    pub const tetdagesh: u16 = 0xfb38;
    pub const tetdageshhebrew: u16 = 0xfb38;
    pub const tethebrew: u16 = 0x05d8;
    pub const tetsecyrillic: u16 = 0x04b5;
    pub const tevirhebrew: u16 = 0x059b;
    pub const tevirlefthebrew: u16 = 0x059b;
    pub const thabengali: u16 = 0x09a5;
    pub const thadeva: u16 = 0x0925;
    pub const thagujarati: u16 = 0x0aa5;
    pub const thagurmukhi: u16 = 0x0a25;
    pub const thalarabic: u16 = 0x0630;
    pub const thalfinalarabic: u16 = 0xfeac;
    pub const thanthakhatlowleftthai: u16 = 0xf898;
    pub const thanthakhatlowrightthai: u16 = 0xf897;
    pub const thanthakhatthai: u16 = 0x0e4c;
    pub const thanthakhatupperleftthai: u16 = 0xf896;
    pub const theharabic: u16 = 0x062b;
    pub const thehfinalarabic: u16 = 0xfe9a;
    pub const thehinitialarabic: u16 = 0xfe9b;
    pub const thehmedialarabic: u16 = 0xfe9c;
    pub const thereexists: u16 = 0x2203;
    pub const therefore: u16 = 0x2234;
    pub const theta: u16 = 0x03b8;
    pub const theta1: u16 = 0x03d1;
    pub const thetasymbolgreek: u16 = 0x03d1;
    pub const thieuthacirclekorean: u16 = 0x3279;
    pub const thieuthaparenkorean: u16 = 0x3219;
    pub const thieuthcirclekorean: u16 = 0x326b;
    pub const thieuthkorean: u16 = 0x314c;
    pub const thieuthparenkorean: u16 = 0x320b;
    pub const thirteencircle: u16 = 0x246c;
    pub const thirteenparen: u16 = 0x2480;
    pub const thirteenperiod: u16 = 0x2494;
    pub const thonangmonthothai: u16 = 0x0e11;
    pub const thook: u16 = 0x01ad;
    pub const thophuthaothai: u16 = 0x0e12;
    pub const thorn: u16 = 0x00fe;
    pub const thothahanthai: u16 = 0x0e17;
    pub const thothanthai: u16 = 0x0e10;
    pub const thothongthai: u16 = 0x0e18;
    pub const thothungthai: u16 = 0x0e16;
    pub const thousandcyrillic: u16 = 0x0482;
    pub const thousandsseparatorarabic: u16 = 0x066c;
    pub const thousandsseparatorpersian: u16 = 0x066c;
    pub const three: u16 = 0x0033;
    pub const threearabic: u16 = 0x0663;
    pub const threebengali: u16 = 0x09e9;
    pub const threecircle: u16 = 0x2462;
    pub const threecircleinversesansserif: u16 = 0x278c;
    pub const threedeva: u16 = 0x0969;
    pub const threeeighths: u16 = 0x215c;
    pub const threegujarati: u16 = 0x0ae9;
    pub const threegurmukhi: u16 = 0x0a69;
    pub const threehackarabic: u16 = 0x0663;
    pub const threehangzhou: u16 = 0x3023;
    pub const threeideographicparen: u16 = 0x3222;
    pub const threeinferior: u16 = 0x2083;
    pub const threemonospace: u16 = 0xff13;
    pub const threenumeratorbengali: u16 = 0x09f6;
    pub const threeoldstyle: u16 = 0xf733;
    pub const threeparen: u16 = 0x2476;
    pub const threeperiod: u16 = 0x248a;
    pub const threepersian: u16 = 0x06f3;
    pub const threequarters: u16 = 0x00be;
    pub const threequartersemdash: u16 = 0xf6de;
    pub const threeroman: u16 = 0x2172;
    pub const threesuperior: u16 = 0x00b3;
    pub const threethai: u16 = 0x0e53;
    pub const thzsquare: u16 = 0x3394;
    pub const tie: u16 = 0x2040;
    pub const tihiragana: u16 = 0x3061;
    pub const tikatakana: u16 = 0x30c1;
    pub const tikatakanahalfwidth: u16 = 0xff81;
    pub const tikeutacirclekorean: u16 = 0x3270;
    pub const tikeutaparenkorean: u16 = 0x3210;
    pub const tikeutcirclekorean: u16 = 0x3262;
    pub const tikeutkorean: u16 = 0x3137;
    pub const tikeutparenkorean: u16 = 0x3202;
    pub const tilde: u16 = 0x02dc;
    pub const tildebelowcmb: u16 = 0x0330;
    pub const tildecmb: u16 = 0x0303;
    pub const tildecomb: u16 = 0x0303;
    pub const tildedoublecmb: u16 = 0x0360;
    pub const tildeoperator: u16 = 0x223c;
    pub const tildeoverlaycmb: u16 = 0x0334;
    pub const tildeverticalcmb: u16 = 0x033e;
    pub const tildewide: u16 = 0x0303;
    pub const tildewider: u16 = 0x0303;
    pub const tildewiderr: u16 = 0x0303;
    pub const timescircle: u16 = 0x2297;
    pub const tipehahebrew: u16 = 0x0596;
    pub const tipehalefthebrew: u16 = 0x0596;
    pub const tippigurmukhi: u16 = 0x0a70;
    pub const titlocyrilliccmb: u16 = 0x0483;
    pub const tiwnarmenian: u16 = 0x057f;
    pub const tlinebelow: u16 = 0x1e6f;
    pub const tmonospace: u16 = 0xff54;
    pub const toarmenian: u16 = 0x0569;
    pub const tohiragana: u16 = 0x3068;
    pub const tokatakana: u16 = 0x30c8;
    pub const tokatakanahalfwidth: u16 = 0xff84;
    pub const tonebarextrahighmod: u16 = 0x02e5;
    pub const tonebarextralowmod: u16 = 0x02e9;
    pub const tonebarhighmod: u16 = 0x02e6;
    pub const tonebarlowmod: u16 = 0x02e8;
    pub const tonebarmidmod: u16 = 0x02e7;
    pub const tonefive: u16 = 0x01bd;
    pub const tonesix: u16 = 0x0185;
    pub const tonetwo: u16 = 0x01a8;
    pub const tonos: u16 = 0x0384;
    pub const tonsquare: u16 = 0x3327;
    pub const topatakthai: u16 = 0x0e0f;
    pub const tortoiseshellbracketleft: u16 = 0x3014;
    pub const tortoiseshellbracketleftsmall: u16 = 0xfe5d;
    pub const tortoiseshellbracketleftvertical: u16 = 0xfe39;
    pub const tortoiseshellbracketright: u16 = 0x3015;
    pub const tortoiseshellbracketrightsmall: u16 = 0xfe5e;
    pub const tortoiseshellbracketrightvertical: u16 = 0xfe3a;
    pub const totaothai: u16 = 0x0e15;
    pub const tpalatalhook: u16 = 0x01ab;
    pub const tparen: u16 = 0x24af;
    pub const trademark: u16 = 0x2122;
    pub const trademarksans: u16 = 0xf8ea;
    pub const trademarkserif: u16 = 0xf6db;
    pub const tretroflexhook: u16 = 0x0288;
    pub const triagdn: u16 = 0x25bc;
    pub const triaglf: u16 = 0x25c4;
    pub const triagrt: u16 = 0x25ba;
    pub const triagup: u16 = 0x25b2;
    pub const triangle: u16 = 0x25b3;
    pub const triangleinv: u16 = 0x25bd;
    pub const triangleleft: u16 = 0x25b9;
    pub const triangleright: u16 = 0x25c3;
    pub const ts: u16 = 0x02a6;
    pub const tsadi: u16 = 0x05e6;
    pub const tsadidagesh: u16 = 0xfb46;
    pub const tsadidageshhebrew: u16 = 0xfb46;
    pub const tsadihebrew: u16 = 0x05e6;
    pub const tsecyrillic: u16 = 0x0446;
    pub const tsere: u16 = 0x05b5;
    pub const tsere12: u16 = 0x05b5;
    pub const tsere1e: u16 = 0x05b5;
    pub const tsere2b: u16 = 0x05b5;
    pub const tserehebrew: u16 = 0x05b5;
    pub const tserenarrowhebrew: u16 = 0x05b5;
    pub const tserequarterhebrew: u16 = 0x05b5;
    pub const tserewidehebrew: u16 = 0x05b5;
    pub const tshecyrillic: u16 = 0x045b;
    pub const tsuperior: u16 = 0xf6f3;
    pub const ttabengali: u16 = 0x099f;
    pub const ttadeva: u16 = 0x091f;
    pub const ttagujarati: u16 = 0x0a9f;
    pub const ttagurmukhi: u16 = 0x0a1f;
    pub const tteharabic: u16 = 0x0679;
    pub const ttehfinalarabic: u16 = 0xfb67;
    pub const ttehinitialarabic: u16 = 0xfb68;
    pub const ttehmedialarabic: u16 = 0xfb69;
    pub const tthabengali: u16 = 0x09a0;
    pub const tthadeva: u16 = 0x0920;
    pub const tthagujarati: u16 = 0x0aa0;
    pub const tthagurmukhi: u16 = 0x0a20;
    pub const tturned: u16 = 0x0287;
    pub const tuhiragana: u16 = 0x3064;
    pub const tukatakana: u16 = 0x30c4;
    pub const tukatakanahalfwidth: u16 = 0xff82;
    pub const turnstileleft: u16 = 0x22a2;
    pub const turnstileright: u16 = 0x22a3;
    pub const tusmallhiragana: u16 = 0x3063;
    pub const tusmallkatakana: u16 = 0x30c3;
    pub const tusmallkatakanahalfwidth: u16 = 0xff6f;
    pub const twelvecircle: u16 = 0x246b;
    pub const twelveparen: u16 = 0x247f;
    pub const twelveperiod: u16 = 0x2493;
    pub const twelveroman: u16 = 0x217b;
    pub const twelveudash: u16 = 0xf6de;
    pub const twentycircle: u16 = 0x2473;
    pub const twentyhangzhou: u16 = 0x5344;
    pub const twentyparen: u16 = 0x2487;
    pub const twentyperiod: u16 = 0x249b;
    pub const two: u16 = 0x0032;
    pub const twoarabic: u16 = 0x0662;
    pub const twobengali: u16 = 0x09e8;
    pub const twocircle: u16 = 0x2461;
    pub const twocircleinversesansserif: u16 = 0x278b;
    pub const twodeva: u16 = 0x0968;
    pub const twodotenleader: u16 = 0x2025;
    pub const twodotleader: u16 = 0x2025;
    pub const twodotleadervertical: u16 = 0xfe30;
    pub const twogujarati: u16 = 0x0ae8;
    pub const twogurmukhi: u16 = 0x0a68;
    pub const twohackarabic: u16 = 0x0662;
    pub const twohangzhou: u16 = 0x3022;
    pub const twoideographicparen: u16 = 0x3221;
    pub const twoinferior: u16 = 0x2082;
    pub const twomonospace: u16 = 0xff12;
    pub const twonumeratorbengali: u16 = 0x09f5;
    pub const twooldstyle: u16 = 0xf732;
    pub const twoparen: u16 = 0x2475;
    pub const twoperiod: u16 = 0x2489;
    pub const twopersian: u16 = 0x06f2;
    pub const tworoman: u16 = 0x2171;
    pub const twostroke: u16 = 0x01bb;
    pub const twosuperior: u16 = 0x00b2;
    pub const twothai: u16 = 0x0e52;
    pub const twothirds: u16 = 0x2154;
    pub const u: u16 = 0x0075;
    pub const uacute: u16 = 0x00fa;
    pub const ubar: u16 = 0x0289;
    pub const ubengali: u16 = 0x0989;
    pub const ubopomofo: u16 = 0x3128;
    pub const ubreve: u16 = 0x016d;
    pub const ucaron: u16 = 0x01d4;
    pub const ucircle: u16 = 0x24e4;
    pub const ucircumflex: u16 = 0x00fb;
    pub const ucircumflexbelow: u16 = 0x1e77;
    pub const ucyrillic: u16 = 0x0443;
    pub const udattadeva: u16 = 0x0951;
    pub const udblacute: u16 = 0x0171;
    pub const udblgrave: u16 = 0x0215;
    pub const udeva: u16 = 0x0909;
    pub const udieresis: u16 = 0x00fc;
    pub const udieresisacute: u16 = 0x01d8;
    pub const udieresisbelow: u16 = 0x1e73;
    pub const udieresiscaron: u16 = 0x01da;
    pub const udieresiscyrillic: u16 = 0x04f1;
    pub const udieresisgrave: u16 = 0x01dc;
    pub const udieresismacron: u16 = 0x01d6;
    pub const udotbelow: u16 = 0x1ee5;
    pub const ugrave: u16 = 0x00f9;
    pub const ugujarati: u16 = 0x0a89;
    pub const ugurmukhi: u16 = 0x0a09;
    pub const uhiragana: u16 = 0x3046;
    pub const uhookabove: u16 = 0x1ee7;
    pub const uhorn: u16 = 0x01b0;
    pub const uhornacute: u16 = 0x1ee9;
    pub const uhorndotbelow: u16 = 0x1ef1;
    pub const uhorngrave: u16 = 0x1eeb;
    pub const uhornhookabove: u16 = 0x1eed;
    pub const uhorntilde: u16 = 0x1eef;
    pub const uhungarumlaut: u16 = 0x0171;
    pub const uhungarumlautcyrillic: u16 = 0x04f3;
    pub const uinvertedbreve: u16 = 0x0217;
    pub const ukatakana: u16 = 0x30a6;
    pub const ukatakanahalfwidth: u16 = 0xff73;
    pub const ukcyrillic: u16 = 0x0479;
    pub const ukorean: u16 = 0x315c;
    pub const umacron: u16 = 0x016b;
    pub const umacroncyrillic: u16 = 0x04ef;
    pub const umacrondieresis: u16 = 0x1e7b;
    pub const umatragurmukhi: u16 = 0x0a41;
    pub const umonospace: u16 = 0xff55;
    pub const underscore: u16 = 0x005f;
    pub const underscoredbl: u16 = 0x2017;
    pub const underscoremonospace: u16 = 0xff3f;
    pub const underscorevertical: u16 = 0xfe33;
    pub const underscorewavy: u16 = 0xfe4f;
    pub const union: u16 = 0x222a;
    pub const uniondisplay: u16 = 0x22c3;
    pub const unionmulti: u16 = 0x228e;
    pub const unionmultidisplay: u16 = 0x228e;
    pub const unionmultitext: u16 = 0x228e;
    pub const unionsq: u16 = 0x2294;
    pub const unionsqdisplay: u16 = 0x2294;
    pub const unionsqtext: u16 = 0x2294;
    pub const uniontext: u16 = 0x22c3;
    pub const universal: u16 = 0x2200;
    pub const uogonek: u16 = 0x0173;
    pub const uparen: u16 = 0x24b0;
    pub const upblock: u16 = 0x2580;
    pub const upperdothebrew: u16 = 0x05c4;
    pub const upsilon: u16 = 0x03c5;
    pub const upsilondieresis: u16 = 0x03cb;
    pub const upsilondieresistonos: u16 = 0x03b0;
    pub const upsilonlatin: u16 = 0x028a;
    pub const upsilontonos: u16 = 0x03cd;
    pub const uptackbelowcmb: u16 = 0x031d;
    pub const uptackmod: u16 = 0x02d4;
    pub const uragurmukhi: u16 = 0x0a73;
    pub const uring: u16 = 0x016f;
    pub const ushortcyrillic: u16 = 0x045e;
    pub const usmallhiragana: u16 = 0x3045;
    pub const usmallkatakana: u16 = 0x30a5;
    pub const usmallkatakanahalfwidth: u16 = 0xff69;
    pub const ustraightcyrillic: u16 = 0x04af;
    pub const ustraightstrokecyrillic: u16 = 0x04b1;
    pub const utilde: u16 = 0x0169;
    pub const utildeacute: u16 = 0x1e79;
    pub const utildebelow: u16 = 0x1e75;
    pub const uubengali: u16 = 0x098a;
    pub const uudeva: u16 = 0x090a;
    pub const uugujarati: u16 = 0x0a8a;
    pub const uugurmukhi: u16 = 0x0a0a;
    pub const uumatragurmukhi: u16 = 0x0a42;
    pub const uuvowelsignbengali: u16 = 0x09c2;
    pub const uuvowelsigndeva: u16 = 0x0942;
    pub const uuvowelsigngujarati: u16 = 0x0ac2;
    pub const uvowelsignbengali: u16 = 0x09c1;
    pub const uvowelsigndeva: u16 = 0x0941;
    pub const uvowelsigngujarati: u16 = 0x0ac1;
    pub const v: u16 = 0x0076;
    pub const vadeva: u16 = 0x0935;
    pub const vagujarati: u16 = 0x0ab5;
    pub const vagurmukhi: u16 = 0x0a35;
    pub const vakatakana: u16 = 0x30f7;
    pub const vav: u16 = 0x05d5;
    pub const vavdagesh: u16 = 0xfb35;
    pub const vavdagesh65: u16 = 0xfb35;
    pub const vavdageshhebrew: u16 = 0xfb35;
    pub const vavhebrew: u16 = 0x05d5;
    pub const vavholam: u16 = 0xfb4b;
    pub const vavholamhebrew: u16 = 0xfb4b;
    pub const vavvavhebrew: u16 = 0x05f0;
    pub const vavyodhebrew: u16 = 0x05f1;
    pub const vcircle: u16 = 0x24e5;
    pub const vdotbelow: u16 = 0x1e7f;
    pub const vector: u16 = 0x20d7;
    pub const vecyrillic: u16 = 0x0432;
    pub const veharabic: u16 = 0x06a4;
    pub const vehfinalarabic: u16 = 0xfb6b;
    pub const vehinitialarabic: u16 = 0xfb6c;
    pub const vehmedialarabic: u16 = 0xfb6d;
    pub const vekatakana: u16 = 0x30f9;
    pub const venus: u16 = 0x2640;
    pub const verticalbar: u16 = 0x007c;
    pub const verticallineabovecmb: u16 = 0x030d;
    pub const verticallinebelowcmb: u16 = 0x0329;
    pub const verticallinelowmod: u16 = 0x02cc;
    pub const verticallinemod: u16 = 0x02c8;
    pub const vewarmenian: u16 = 0x057e;
    pub const vhook: u16 = 0x028b;
    pub const vikatakana: u16 = 0x30f8;
    pub const viramabengali: u16 = 0x09cd;
    pub const viramadeva: u16 = 0x094d;
    pub const viramagujarati: u16 = 0x0acd;
    pub const visargabengali: u16 = 0x0983;
    pub const visargadeva: u16 = 0x0903;
    pub const visargagujarati: u16 = 0x0a83;
    pub const visiblespace: u16 = 0x2423;
    pub const visualspace: u16 = 0x2423;
    pub const vmonospace: u16 = 0xff56;
    pub const voarmenian: u16 = 0x0578;
    pub const voicediterationhiragana: u16 = 0x309e;
    pub const voicediterationkatakana: u16 = 0x30fe;
    pub const voicedmarkkana: u16 = 0x309b;
    pub const voicedmarkkanahalfwidth: u16 = 0xff9e;
    pub const vokatakana: u16 = 0x30fa;
    pub const vparen: u16 = 0x24b1;
    pub const vtilde: u16 = 0x1e7d;
    pub const vturned: u16 = 0x028c;
    pub const vuhiragana: u16 = 0x3094;
    pub const vukatakana: u16 = 0x30f4;
    pub const w: u16 = 0x0077;
    pub const wacute: u16 = 0x1e83;
    pub const waekorean: u16 = 0x3159;
    pub const wahiragana: u16 = 0x308f;
    pub const wakatakana: u16 = 0x30ef;
    pub const wakatakanahalfwidth: u16 = 0xff9c;
    pub const wakorean: u16 = 0x3158;
    pub const wasmallhiragana: u16 = 0x308e;
    pub const wasmallkatakana: u16 = 0x30ee;
    pub const wattosquare: u16 = 0x3357;
    pub const wavedash: u16 = 0x301c;
    pub const wavyunderscorevertical: u16 = 0xfe34;
    pub const wawarabic: u16 = 0x0648;
    pub const wawfinalarabic: u16 = 0xfeee;
    pub const wawhamzaabovearabic: u16 = 0x0624;
    pub const wawhamzaabovefinalarabic: u16 = 0xfe86;
    pub const wbsquare: u16 = 0x33dd;
    pub const wcircle: u16 = 0x24e6;
    pub const wcircumflex: u16 = 0x0175;
    pub const wdieresis: u16 = 0x1e85;
    pub const wdotaccent: u16 = 0x1e87;
    pub const wdotbelow: u16 = 0x1e89;
    pub const wehiragana: u16 = 0x3091;
    pub const weierstrass: u16 = 0x2118;
    pub const wekatakana: u16 = 0x30f1;
    pub const wekorean: u16 = 0x315e;
    pub const weokorean: u16 = 0x315d;
    pub const wgrave: u16 = 0x1e81;
    pub const whitebullet: u16 = 0x25e6;
    pub const whitecircle: u16 = 0x25cb;
    pub const whitecircleinverse: u16 = 0x25d9;
    pub const whitecornerbracketleft: u16 = 0x300e;
    pub const whitecornerbracketleftvertical: u16 = 0xfe43;
    pub const whitecornerbracketright: u16 = 0x300f;
    pub const whitecornerbracketrightvertical: u16 = 0xfe44;
    pub const whitediamond: u16 = 0x25c7;
    pub const whitediamondcontainingblacksmalldiamond: u16 = 0x25c8;
    pub const whitedownpointingsmalltriangle: u16 = 0x25bf;
    pub const whitedownpointingtriangle: u16 = 0x25bd;
    pub const whiteleftpointingsmalltriangle: u16 = 0x25c3;
    pub const whiteleftpointingtriangle: u16 = 0x25c1;
    pub const whitelenticularbracketleft: u16 = 0x3016;
    pub const whitelenticularbracketright: u16 = 0x3017;
    pub const whiterightpointingsmalltriangle: u16 = 0x25b9;
    pub const whiterightpointingtriangle: u16 = 0x25b7;
    pub const whitesmallsquare: u16 = 0x25ab;
    pub const whitesmilingface: u16 = 0x263a;
    pub const whitesquare: u16 = 0x25a1;
    pub const whitestar: u16 = 0x2606;
    pub const whitetelephone: u16 = 0x260f;
    pub const whitetortoiseshellbracketleft: u16 = 0x3018;
    pub const whitetortoiseshellbracketright: u16 = 0x3019;
    pub const whiteuppointingsmalltriangle: u16 = 0x25b5;
    pub const whiteuppointingtriangle: u16 = 0x25b3;
    pub const wihiragana: u16 = 0x3090;
    pub const wikatakana: u16 = 0x30f0;
    pub const wikorean: u16 = 0x315f;
    pub const wmonospace: u16 = 0xff57;
    pub const wohiragana: u16 = 0x3092;
    pub const wokatakana: u16 = 0x30f2;
    pub const wokatakanahalfwidth: u16 = 0xff66;
    pub const won: u16 = 0x20a9;
    pub const wonmonospace: u16 = 0xffe6;
    pub const wowaenthai: u16 = 0x0e27;
    pub const wparen: u16 = 0x24b2;
    pub const wreathproduct: u16 = 0x2240;
    pub const wring: u16 = 0x1e98;
    pub const wsuperior: u16 = 0x02b7;
    pub const wturned: u16 = 0x028d;
    pub const wynn: u16 = 0x01bf;
    pub const x: u16 = 0x0078;
    pub const xabovecmb: u16 = 0x033d;
    pub const xbopomofo: u16 = 0x3112;
    pub const xcircle: u16 = 0x24e7;
    pub const xdieresis: u16 = 0x1e8d;
    pub const xdotaccent: u16 = 0x1e8b;
    pub const xeharmenian: u16 = 0x056d;
    pub const xi: u16 = 0x03be;
    pub const xmonospace: u16 = 0xff58;
    pub const xparen: u16 = 0x24b3;
    pub const xsuperior: u16 = 0x02e3;
    pub const y: u16 = 0x0079;
    pub const yaadosquare: u16 = 0x334e;
    pub const yabengali: u16 = 0x09af;
    pub const yacute: u16 = 0x00fd;
    pub const yadeva: u16 = 0x092f;
    pub const yaekorean: u16 = 0x3152;
    pub const yagujarati: u16 = 0x0aaf;
    pub const yagurmukhi: u16 = 0x0a2f;
    pub const yahiragana: u16 = 0x3084;
    pub const yakatakana: u16 = 0x30e4;
    pub const yakatakanahalfwidth: u16 = 0xff94;
    pub const yakorean: u16 = 0x3151;
    pub const yamakkanthai: u16 = 0x0e4e;
    pub const yasmallhiragana: u16 = 0x3083;
    pub const yasmallkatakana: u16 = 0x30e3;
    pub const yasmallkatakanahalfwidth: u16 = 0xff6c;
    pub const yatcyrillic: u16 = 0x0463;
    pub const ycircle: u16 = 0x24e8;
    pub const ycircumflex: u16 = 0x0177;
    pub const ydieresis: u16 = 0x00ff;
    pub const ydotaccent: u16 = 0x1e8f;
    pub const ydotbelow: u16 = 0x1ef5;
    pub const yeharabic: u16 = 0x064a;
    pub const yehbarreearabic: u16 = 0x06d2;
    pub const yehbarreefinalarabic: u16 = 0xfbaf;
    pub const yehfinalarabic: u16 = 0xfef2;
    pub const yehhamzaabovearabic: u16 = 0x0626;
    pub const yehhamzaabovefinalarabic: u16 = 0xfe8a;
    pub const yehhamzaaboveinitialarabic: u16 = 0xfe8b;
    pub const yehhamzaabovemedialarabic: u16 = 0xfe8c;
    pub const yehinitialarabic: u16 = 0xfef3;
    pub const yehmedialarabic: u16 = 0xfef4;
    pub const yehmeeminitialarabic: u16 = 0xfcdd;
    pub const yehmeemisolatedarabic: u16 = 0xfc58;
    pub const yehnoonfinalarabic: u16 = 0xfc94;
    pub const yehthreedotsbelowarabic: u16 = 0x06d1;
    pub const yekorean: u16 = 0x3156;
    pub const yen: u16 = 0x00a5;
    pub const yenmonospace: u16 = 0xffe5;
    pub const yeokorean: u16 = 0x3155;
    pub const yeorinhieuhkorean: u16 = 0x3186;
    pub const yerahbenyomohebrew: u16 = 0x05aa;
    pub const yerahbenyomolefthebrew: u16 = 0x05aa;
    pub const yericyrillic: u16 = 0x044b;
    pub const yerudieresiscyrillic: u16 = 0x04f9;
    pub const yesieungkorean: u16 = 0x3181;
    pub const yesieungpansioskorean: u16 = 0x3183;
    pub const yesieungsioskorean: u16 = 0x3182;
    pub const yetivhebrew: u16 = 0x059a;
    pub const ygrave: u16 = 0x1ef3;
    pub const yhook: u16 = 0x01b4;
    pub const yhookabove: u16 = 0x1ef7;
    pub const yiarmenian: u16 = 0x0575;
    pub const yicyrillic: u16 = 0x0457;
    pub const yikorean: u16 = 0x3162;
    pub const yinyang: u16 = 0x262f;
    pub const yiwnarmenian: u16 = 0x0582;
    pub const ymonospace: u16 = 0xff59;
    pub const yod: u16 = 0x05d9;
    pub const yoddagesh: u16 = 0xfb39;
    pub const yoddageshhebrew: u16 = 0xfb39;
    pub const yodhebrew: u16 = 0x05d9;
    pub const yodyodhebrew: u16 = 0x05f2;
    pub const yodyodpatahhebrew: u16 = 0xfb1f;
    pub const yohiragana: u16 = 0x3088;
    pub const yoikorean: u16 = 0x3189;
    pub const yokatakana: u16 = 0x30e8;
    pub const yokatakanahalfwidth: u16 = 0xff96;
    pub const yokorean: u16 = 0x315b;
    pub const yosmallhiragana: u16 = 0x3087;
    pub const yosmallkatakana: u16 = 0x30e7;
    pub const yosmallkatakanahalfwidth: u16 = 0xff6e;
    pub const yotgreek: u16 = 0x03f3;
    pub const yoyaekorean: u16 = 0x3188;
    pub const yoyakorean: u16 = 0x3187;
    pub const yoyakthai: u16 = 0x0e22;
    pub const yoyingthai: u16 = 0x0e0d;
    pub const yparen: u16 = 0x24b4;
    pub const ypogegrammeni: u16 = 0x037a;
    pub const ypogegrammenigreekcmb: u16 = 0x0345;
    pub const yr: u16 = 0x01a6;
    pub const yring: u16 = 0x1e99;
    pub const ysuperior: u16 = 0x02b8;
    pub const ytilde: u16 = 0x1ef9;
    pub const yturned: u16 = 0x028e;
    pub const yuhiragana: u16 = 0x3086;
    pub const yuikorean: u16 = 0x318c;
    pub const yukatakana: u16 = 0x30e6;
    pub const yukatakanahalfwidth: u16 = 0xff95;
    pub const yukorean: u16 = 0x3160;
    pub const yusbigcyrillic: u16 = 0x046b;
    pub const yusbigiotifiedcyrillic: u16 = 0x046d;
    pub const yuslittlecyrillic: u16 = 0x0467;
    pub const yuslittleiotifiedcyrillic: u16 = 0x0469;
    pub const yusmallhiragana: u16 = 0x3085;
    pub const yusmallkatakana: u16 = 0x30e5;
    pub const yusmallkatakanahalfwidth: u16 = 0xff6d;
    pub const yuyekorean: u16 = 0x318b;
    pub const yuyeokorean: u16 = 0x318a;
    pub const yyabengali: u16 = 0x09df;
    pub const yyadeva: u16 = 0x095f;
    pub const z: u16 = 0x007a;
    pub const zaarmenian: u16 = 0x0566;
    pub const zacute: u16 = 0x017a;
    pub const zadeva: u16 = 0x095b;
    pub const zagurmukhi: u16 = 0x0a5b;
    pub const zaharabic: u16 = 0x0638;
    pub const zahfinalarabic: u16 = 0xfec6;
    pub const zahinitialarabic: u16 = 0xfec7;
    pub const zahiragana: u16 = 0x3056;
    pub const zahmedialarabic: u16 = 0xfec8;
    pub const zainarabic: u16 = 0x0632;
    pub const zainfinalarabic: u16 = 0xfeb0;
    pub const zakatakana: u16 = 0x30b6;
    pub const zaqefgadolhebrew: u16 = 0x0595;
    pub const zaqefqatanhebrew: u16 = 0x0594;
    pub const zarqahebrew: u16 = 0x0598;
    pub const zayin: u16 = 0x05d6;
    pub const zayindagesh: u16 = 0xfb36;
    pub const zayindageshhebrew: u16 = 0xfb36;
    pub const zayinhebrew: u16 = 0x05d6;
    pub const zbopomofo: u16 = 0x3117;
    pub const zcaron: u16 = 0x017e;
    pub const zcircle: u16 = 0x24e9;
    pub const zcircumflex: u16 = 0x1e91;
    pub const zcurl: u16 = 0x0291;
    pub const zdot: u16 = 0x017c;
    pub const zdotaccent: u16 = 0x017c;
    pub const zdotbelow: u16 = 0x1e93;
    pub const zecyrillic: u16 = 0x0437;
    pub const zedescendercyrillic: u16 = 0x0499;
    pub const zedieresiscyrillic: u16 = 0x04df;
    pub const zehiragana: u16 = 0x305c;
    pub const zekatakana: u16 = 0x30bc;
    pub const zero: u16 = 0x0030;
    pub const zeroarabic: u16 = 0x0660;
    pub const zerobengali: u16 = 0x09e6;
    pub const zerodeva: u16 = 0x0966;
    pub const zerogujarati: u16 = 0x0ae6;
    pub const zerogurmukhi: u16 = 0x0a66;
    pub const zerohackarabic: u16 = 0x0660;
    pub const zeroinferior: u16 = 0x2080;
    pub const zeromonospace: u16 = 0xff10;
    pub const zerooldstyle: u16 = 0xf730;
    pub const zeropersian: u16 = 0x06f0;
    pub const zerosuperior: u16 = 0x2070;
    pub const zerothai: u16 = 0x0e50;
    pub const zerowidthjoiner: u16 = 0xfeff;
    pub const zerowidthnonjoiner: u16 = 0x200c;
    pub const zerowidthspace: u16 = 0x200b;
    pub const zeta: u16 = 0x03b6;
    pub const zhbopomofo: u16 = 0x3113;
    pub const zhearmenian: u16 = 0x056a;
    pub const zhebrevecyrillic: u16 = 0x04c2;
    pub const zhecyrillic: u16 = 0x0436;
    pub const zhedescendercyrillic: u16 = 0x0497;
    pub const zhedieresiscyrillic: u16 = 0x04dd;
    pub const zihiragana: u16 = 0x3058;
    pub const zikatakana: u16 = 0x30b8;
    pub const zinorhebrew: u16 = 0x05ae;
    pub const zlinebelow: u16 = 0x1e95;
    pub const zmonospace: u16 = 0xff5a;
    pub const zohiragana: u16 = 0x305e;
    pub const zokatakana: u16 = 0x30be;
    pub const zparen: u16 = 0x24b5;
    pub const zretroflexhook: u16 = 0x0290;
    pub const zstroke: u16 = 0x01b6;
    pub const zuhiragana: u16 = 0x305a;
    pub const zukatakana: u16 = 0x30ba;
}
