# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class FindCellStrategy(Object):
    r"""
    FindCellStrategy - helper class to manage the
    PointSet::FindCell() METHOD
    
    Superclass: Object
    
    FindCellStrategy is a helper class to manage the use of locators
    for locating cells containing a query point x[3], the so-called
    find_cell() method. The use of DataSet::FindCell() is a common
    operation in applications such as streamline generation and probing.
    However, in some dataset types find_cell() can be implemented very
    simply (e.g., ImageData) while in other datasets it is a complex
    operation requiring supplemental objects like locators to perform
    efficiently. In particular, PointSet and its subclasses (like
    UnstructuredGrid) require complex strategies to efficiently
    implement the find_cell() operation. Subclasses of the abstract
    FindCellStrategy implement several of these strategies.
    
    The are two key methods to this class and subclasses. The
    Initialize() method negotiates with an input dataset to define the
    locator to use: either a locator associated with the inout dataset,
    or possibly an alternative locator defined by the strategy
    (subclasses do this). The second important method, find_cell() mimics
    DataSet::FindCell() and can be used in place of it.
    
    @sa
    PointSet PolyData StructuredGrid UnstructuredGrid
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFindCellStrategy, obj, update, **traits)
    
    def find_cell(self, *args):
        """
        find_cell(self, x:[float, float, float], cell:Cell,
            gencell:GenericCell, cellId:int, tol2:float, subId:int,
            pcoords:[float, float, float], weights:[float, ...]) -> int
        C++: virtual IdType find_cell(double x[3], Cell *cell,
            GenericCell *gencell, IdType cellId, double tol2,
            int &subId, double pcoords[3], double *weights)
        Virtual method for finding a cell. Subclasses must satisfy this
        API. This method is of the same signature as
        DataSet::FindCell().
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FindCell, *my_args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, ps:PointSet) -> int
        C++: virtual int initialize(PointSet *ps)
        All subclasses of this class must provide an initialize method. 
        This method performs handshaking and setup between the
        PointSet dataset and associated locator(s). A return value==0
        means the initialization process failed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FindCellStrategy, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

