#! /usr/bin/env python

import openturns as ot

ot.TESTPREAMBLE()

# Instantiate one distribution object
dim = 2
meanPoint = ot.Point(dim, 1.0)
meanPoint[0] = 0.5
meanPoint[1] = -0.5
sigma = ot.Point(dim, 1.0)
sigma[0] = 2.0
sigma[1] = 3.0
R = ot.CorrelationMatrix(dim)
for i in range(1, dim):
    R[i, i - 1] = 0.5

distribution1 = ot.Normal(meanPoint, sigma, R)

# Instantiate another distribution object
meanPoint[0] = -1.5
meanPoint[1] = 0.5
sigma[0] = 4.0
sigma[1] = 1.0
for i in range(1, dim):
    R[i, i - 1] = -0.25

distribution2 = ot.Normal(meanPoint, sigma, R)

# Test for sampling
size = 200
sample1 = distribution1.getSample(size)
sample2 = distribution2.getSample(size)

# Create an empty graph
myGraph = ot.Graph("Normal sample", "x1", "x2", True, "topright")

# Create the first cloud
myCloud1 = ot.Cloud(sample1, "blue", "fsquare", "First Cloud")

# Then, draw it
myGraph.add(myCloud1)

# Check that the correct files have been generated by computing their
# checksum

# Create the second cloud
myCloud2 = ot.Cloud(sample2, "red", "circle", "Second Cloud")

# Add it to the graph and draw everything
myGraph.add(myCloud2)
