#include <stdio.h>
#include <time.h>
#include "ap.h"
// disable some irrelevant warnings
#if (AE_COMPILER==AE_MSVC) && !defined(AE_ALL_WARNINGS)
#pragma warning(disable:4100)
#pragma warning(disable:4127)
#pragma warning(disable:4611)
#pragma warning(disable:4702)
#pragma warning(disable:4996)
#endif
#include "alglibinternal.h"
#include "alglibmisc.h"
#include "diffequations.h"
#include "linalg.h"
#include "optimization.h"
#include "solvers.h"
#include "statistics.h"
#include "dataanalysis.h"
#include "specialfunctions.h"
#include "integration.h"
#include "fasttransforms.h"
#include "interpolation.h"

using namespace alglib_impl;






/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtsort(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Nearest Neighbor Search
*************************************************************************/
ae_bool testnearestneighbor(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnearestneighbor(ae_bool silent, ae_state *_state);








ae_bool testhqrnd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhqrnd(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testodesolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testodesolver(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t matkind;
    ae_int_t triangle;
    ae_matrix bufa;
    hqrndstate rs;
    rcommstate rcs;
} sparsegenerator;





ae_bool testsparse(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsparse(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state);


/*************************************************************************
Function for testing CRS-specific functionality.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void crstest(ae_bool* errorflag, ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state);


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state);


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state);
void _sparsegenerator_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _sparsegenerator_clear(void* _p);
void _sparsegenerator_destroy(void* _p);








ae_bool testablas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testablas(ae_bool silent, ae_state *_state);








ae_bool testcreflections(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcreflections(ae_bool silent, ae_state *_state);








ae_bool testmatgen(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatgen(ae_bool silent, ae_state *_state);








ae_bool testtrfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrfac(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrlinsolve(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsafesolve(ae_bool silent, ae_state *_state);








ae_bool testrcond(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrcond(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testmatinv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatinv(ae_bool silent, ae_state *_state);








ae_bool testhblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhblas(ae_bool silent, ae_state *_state);








ae_bool testsblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testortfac(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing
*************************************************************************/
ae_bool testfbls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfbls(ae_bool silent, ae_state *_state);








ae_bool testcqmodels(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcqmodels(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdsvd(ae_bool silent, ae_state *_state);








ae_bool testblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsvd(ae_bool silent, ae_state *_state);








ae_bool testoptserv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testoptserv(ae_bool silent, ae_state *_state);








ae_bool testsnnls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsnnls(ae_bool silent, ae_state *_state);








ae_bool testsactivesets(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsactivesets(ae_bool silent, ae_state *_state);








ae_bool testlinmin(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinmin(ae_bool silent, ae_state *_state);








ae_bool testminlbfgs(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlbfgs(ae_bool silent, ae_state *_state);








ae_bool testxblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testxblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectdensesolvers(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdirectdensesolvers(ae_bool silent, ae_state *_state);








ae_bool testnormestimator(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnormestimator(ae_bool silent, ae_state *_state);








ae_bool testlinlsqr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinlsqr(ae_bool silent, ae_state *_state);








ae_bool testmincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmincg(ae_bool silent, ae_state *_state);


/*************************************************************************
Other properties
*************************************************************************/
void testother(ae_bool* err, ae_state *_state);








ae_bool testminbleic(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminbleic(ae_bool silent, ae_state *_state);








ae_bool testminqp(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminqp(ae_bool silent, ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetQuadraticTerm', 'MinQPSetBC', 
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = diag(aii), aii>0 (random)
    b = 0
    random bounds (either no bounds, one bound, two bounds a<b, two bounds a=b)
    random start point
    dimension - from 1 to 5.
    
Returns True on success, False on failure.
*************************************************************************/
ae_bool simpletest(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    without bounds
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest1(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetBC', 'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 
'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    boundary constraints
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest2(ae_state *_state);


/*************************************************************************
ConsoleTest.
*************************************************************************/
ae_bool consoletest(ae_state *_state);


/*************************************************************************
This function performs tests specific for QuickQP solver
    
Returns True on failure.
*************************************************************************/
ae_bool quickqptests(ae_state *_state);


/*************************************************************************
This function performs tests specific for BLEIC solver
    
Returns True on error, False on success.
*************************************************************************/
ae_bool bleictests(ae_state *_state);








ae_bool testminbc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminbc(ae_bool silent, ae_state *_state);








ae_bool testminnlc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminnlc(ae_bool silent, ae_state *_state);








ae_bool testminns(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminns(ae_bool silent, ae_state *_state);








ae_bool testminlm(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlm(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing symmetric EVD subroutine
*************************************************************************/
ae_bool testevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testevd(ae_bool silent, ae_state *_state);








ae_bool testbasestat(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbasestat(ae_bool silent, ae_state *_state);








ae_bool testpca(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpca(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing BDSS operations
*************************************************************************/
ae_bool testbdss(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdss(ae_bool silent, ae_state *_state);








ae_bool testmlpbase(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpbase(ae_bool silent, ae_state *_state);








ae_bool testlda(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlda(ae_bool silent, ae_state *_state);








ae_bool testssa(ae_bool silent, ae_state *_state);
ae_bool _pexec_testssa(ae_bool silent, ae_state *_state);








ae_bool testgammafunc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgammafunc(ae_bool silent, ae_state *_state);








ae_bool testlinreg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinreg(ae_bool silent, ae_state *_state);








ae_bool testfilters(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfilters(ae_bool silent, ae_state *_state);


/*************************************************************************
This function tests SMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testsma(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests EMA(alpha) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testema(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests LRMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testlrma(ae_bool issilent, ae_state *_state);








ae_bool testmcpd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmcpd(ae_bool silent, ae_state *_state);








ae_bool testmlpe(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpe(ae_bool silent, ae_state *_state);








ae_bool testmlptrain(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlptrain(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing clustering
*************************************************************************/
ae_bool testclustering(ae_bool silent, ae_state *_state);
ae_bool _pexec_testclustering(ae_bool silent, ae_state *_state);








ae_bool testdforest(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdforest(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgkq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgkq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testautogk(ae_bool silent, ae_state *_state);
ae_bool _pexec_testautogk(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfft(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfft(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfht(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfht(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testconv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testconv(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testcorr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcorr(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing IDW interpolation
*************************************************************************/
ae_bool testidwint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testidwint(ae_bool silent, ae_state *_state);








ae_bool testratint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testratint(ae_bool silent, ae_state *_state);








ae_bool testfitsphere(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfitsphere(ae_bool silent, ae_state *_state);








ae_bool testspline1d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline1d(ae_bool silent, ae_state *_state);








ae_bool testparametric(ae_bool silent, ae_state *_state);
ae_bool _pexec_testparametric(ae_bool silent, ae_state *_state);








ae_bool testspline3d(ae_bool silence, ae_state *_state);
ae_bool _pexec_testspline3d(ae_bool silence, ae_state *_state);








/*************************************************************************
Unit test
*************************************************************************/
ae_bool testpolint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolint(ae_bool silent, ae_state *_state);








ae_bool testlsfit(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlsfit(ae_bool silent, ae_state *_state);








ae_bool testspline2d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline2d(ae_bool silent, ae_state *_state);








ae_bool testrbf(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrbf(ae_bool silent, ae_state *_state);


/*************************************************************************
The test  has  to  check, that  algorithm can solve problems of matrix are
degenerate.
    * used model with linear term;
    * points locate in a subspace of dimension less than an original space.

  -- ALGLIB --
     Copyright 13.12.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool sqrdegmatrixrbftest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic functionality of RBF module on regular grids with
multi-layer algorithm in 1D.

  -- ALGLIB --
     Copyright 2.03.2012 by Bochkanov Sergey
*************************************************************************/
ae_bool basicmultilayerrbf1dtest(ae_state *_state);








ae_bool testhermite(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhermite(ae_bool silent, ae_state *_state);








ae_bool testlaguerre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlaguerre(ae_bool silent, ae_state *_state);








ae_bool testlegendre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlegendre(ae_bool silent, ae_state *_state);








ae_bool testchebyshev(ae_bool silent, ae_state *_state);
ae_bool _pexec_testchebyshev(ae_bool silent, ae_state *_state);








ae_bool testwsr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testwsr(ae_bool silent, ae_state *_state);








ae_bool teststest(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststest(ae_bool silent, ae_state *_state);








ae_bool teststudentttests(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststudentttests(ae_bool silent, ae_state *_state);








ae_bool testmannwhitneyu(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmannwhitneyu(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Schur decomposition subroutine
*************************************************************************/
ae_bool testschur(ae_bool silent, ae_state *_state);
ae_bool _pexec_testschur(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testspdgevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspdgevd(ae_bool silent, ae_state *_state);








ae_bool testinverseupdate(ae_bool silent, ae_state *_state);
ae_bool _pexec_testinverseupdate(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testpolynomialsolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolynomialsolver(ae_bool silent, ae_state *_state);








ae_bool testnleq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnleq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectsparsesolvers(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdirectsparsesolvers(ae_bool silent, ae_state *_state);








ae_bool testlincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlincg(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_bool bfield;
    double rfield;
    ae_int_t ifield;
    ae_complex cfield;
    ae_vector b1field;
    ae_vector r1field;
    ae_vector i1field;
    ae_vector c1field;
    ae_matrix b2field;
    ae_matrix r2field;
    ae_matrix i2field;
    ae_matrix c2field;
} rec1;


typedef struct
{
    ae_vector b;
    ae_vector i;
    ae_vector r;
} rec4serialization;


typedef struct
{
    ae_complex cval;
    double rval;
    ae_int_t ival;
    ae_bool bval;
    ae_vector i1val;
} poolrec1;


typedef struct
{
    ae_bool bval;
    poolrec1 recval;
    ae_shared_pool pool;
} poolrec2;


typedef struct
{
    ae_int_t val;
} poolsummand;





void rec4serializationalloc(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationunserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


ae_bool testalglibbasics(ae_bool silent, ae_state *_state);
ae_bool _pexec_testalglibbasics(ae_bool silent, ae_state *_state);
void _rec1_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _rec1_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _rec1_clear(void* _p);
void _rec1_destroy(void* _p);
void _rec4serialization_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _rec4serialization_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _rec4serialization_clear(void* _p);
void _rec4serialization_destroy(void* _p);
void _poolrec1_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolrec1_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolrec1_clear(void* _p);
void _poolrec1_destroy(void* _p);
void _poolrec2_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolrec2_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolrec2_clear(void* _p);
void _poolrec2_destroy(void* _p);
void _poolsummand_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolsummand_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolsummand_clear(void* _p);
void _poolsummand_destroy(void* _p);




static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state);
static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state);





/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t n;
    ae_int_t i;
    ae_int_t m;
    ae_int_t offs;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t maxn;
    ae_vector a;
    ae_vector a0;
    ae_vector a1;
    ae_vector a2;
    ae_vector a3;
    ae_vector i1;
    ae_vector i2;
    ae_vector i3;
    ae_vector a4;
    ae_vector pa4;
    ae_vector ar;
    ae_vector ar2;
    ae_vector ai;
    ae_vector p1;
    ae_vector p2;
    ae_vector bufr1;
    ae_vector bufr2;
    ae_vector bufi1;
    ae_bool distinctvals;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&a0, 0, sizeof(a0));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&a3, 0, sizeof(a3));
    memset(&i1, 0, sizeof(i1));
    memset(&i2, 0, sizeof(i2));
    memset(&i3, 0, sizeof(i3));
    memset(&a4, 0, sizeof(a4));
    memset(&pa4, 0, sizeof(pa4));
    memset(&ar, 0, sizeof(ar));
    memset(&ar2, 0, sizeof(ar2));
    memset(&ai, 0, sizeof(ai));
    memset(&p1, 0, sizeof(p1));
    memset(&p2, 0, sizeof(p2));
    memset(&bufr1, 0, sizeof(bufr1));
    memset(&bufr2, 0, sizeof(bufr2));
    memset(&bufi1, 0, sizeof(bufi1));
    ae_vector_init(&a, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a3, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&i1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&i2, 0, DT_INT, _state, ae_true);
    ae_vector_init(&i3, 0, DT_INT, _state, ae_true);
    ae_vector_init(&a4, 0, DT_INT, _state, ae_true);
    ae_vector_init(&pa4, 0, DT_INT, _state, ae_true);
    ae_vector_init(&ar, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ar2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ai, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p2, 0, DT_INT, _state, ae_true);
    ae_vector_init(&bufr1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bufr2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bufi1, 0, DT_INT, _state, ae_true);

    waserrors = ae_false;
    maxn = 100;
    passcount = 10;
    
    /*
     * Test tagsort
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Pprobably distinct sort:
             * * generate array of integer random numbers.
             *   Because of birthday paradox, random numbers have to be VERY large
             *   in order to avoid situation when we have distinct values.
             * * sort A0 using TagSort and test sort results
             * * now we can use A0 as reference point and test other functions
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(100000000, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            distinctvals = ae_true;
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&ae_fp_neq(a0.ptr.p_double[i],a0.ptr.p_double[i-1]);
            }
            if( distinctvals )
            {
                tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]))||ai.ptr.p_int[i]!=p1.ptr.p_int[i];
                }
                tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]))||ae_fp_neq(ar.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
                tagsortfast(&a3, &bufr1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
                }
                tagsortmiddleir(&a4, &ar2, 0, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]))||ae_fp_neq(ar2.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
            }
            
            /*
             * Non-distinct sort.
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)((n-i)/2);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 'All same' sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(0);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 0-1 sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(2, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * Special test for TagSortMiddleIR: sorting in the middle gives same results
             * as sorting in the beginning of the array
             */
            m = 3*n;
            offs = ae_randominteger(n, _state);
            ae_vector_set_length(&i1, m, _state);
            ae_vector_set_length(&i2, m, _state);
            ae_vector_set_length(&i3, m, _state);
            ae_vector_set_length(&ar, m, _state);
            ae_vector_set_length(&ar2, m, _state);
            for(i=0; i<=m-1; i++)
            {
                i1.ptr.p_int[i] = ae_randominteger(100000000, _state);
                i2.ptr.p_int[i] = i1.ptr.p_int[i];
                i3.ptr.p_int[i] = i1.ptr.p_int[i];
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
            }
            for(i=0; i<=n-1; i++)
            {
                i1.ptr.p_int[i] = i1.ptr.p_int[offs+i];
                ar.ptr.p_double[i] = ar.ptr.p_double[offs+i];
            }
            tagsortmiddleir(&i1, &ar, 0, n, _state);
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&i1.ptr.p_int[i]!=i1.ptr.p_int[i-1];
            }
            if( distinctvals )
            {
                tagsortmiddleir(&i2, &ar2, offs, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||i2.ptr.p_int[offs+i]!=i1.ptr.p_int[i])||ae_fp_neq(ar2.ptr.p_double[offs+i],ar.ptr.p_double[i]);
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING TAGSORT\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_int[0] = ae_randominteger(3, _state)-1;
}


static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_vector a2;
    double t;
    ae_vector f;

    ae_frame_make(_state, &_frame_block);
    memset(&a2, 0, sizeof(a2));
    memset(&f, 0, sizeof(f));
    ae_vector_init(&a2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&f, 0, DT_INT, _state, ae_true);

    ae_vector_set_length(&a2, n-1+1, _state);
    ae_vector_set_length(&f, n-1+1, _state);
    
    /*
     * is set ordered?
     */
    for(i=0; i<=n-2; i++)
    {
        *waserrors = *waserrors||ae_fp_greater(asorted->ptr.p_double[i],asorted->ptr.p_double[i+1]);
    }
    
    /*
     * P1 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],aoriginal->ptr.p_double[p1->ptr.p_int[i]]);
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[i] = 0;
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[p1->ptr.p_int[i]] = f.ptr.p_int[p1->ptr.p_int[i]]+1;
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||f.ptr.p_int[i]!=1;
    }
    
    /*
     * P2 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        a2.ptr.p_double[i] = aoriginal->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        if( p2->ptr.p_int[i]!=i )
        {
            t = a2.ptr.p_double[i];
            a2.ptr.p_double[i] = a2.ptr.p_double[p2->ptr.p_int[i]];
            a2.ptr.p_double[p2->ptr.p_int[i]] = t;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],a2.ptr.p_double[i]);
    }
    ae_frame_leave(_state);
}



static ae_bool testnearestneighborunit_kdtresultsdifferent(/* Real    */ ae_matrix* refxy,
     ae_int_t ntotal,
     /* Real    */ ae_matrix* qx,
     /* Real    */ ae_matrix* qxy,
     /* Integer */ ae_vector* qt,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_state *_state);
static double testnearestneighborunit_vnorm(/* Real    */ ae_vector* x,
     ae_int_t n,
     ae_int_t normtype,
     ae_state *_state);
static void testnearestneighborunit_testkdtuniform(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_int_t normtype,
     ae_bool* kdterrors,
     ae_state *_state);
static void testnearestneighborunit_testkdtreeserialization(ae_bool* err,
     ae_state *_state);
static ae_bool testnearestneighborunit_testspecialcases(ae_state *_state);





/*************************************************************************
Testing Nearest Neighbor Search
*************************************************************************/
ae_bool testnearestneighbor(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xy;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_int_t normtype;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t n;
    ae_int_t smalln;
    ae_int_t largen;
    ae_int_t passcount;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool kdterrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xy, 0, sizeof(xy));
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state, ae_true);

    kdterrors = ae_false;
    passcount = 2;
    smalln = 256;
    largen = 2048;
    ny = 3;
    
    /*
     *
     */
    testnearestneighborunit_testkdtreeserialization(&kdterrors, _state);
    for(pass=1; pass<=passcount; pass++)
    {
        for(normtype=0; normtype<=2; normtype++)
        {
            for(nx=1; nx<=3; nx++)
            {
                
                /*
                 * Test in hypercube
                 */
                ae_matrix_set_length(&xy, largen, nx+ny, _state);
                for(i=0; i<=largen-1; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[i][j] = 10*ae_randomreal(_state)-5;
                    }
                }
                for(n=1; n<=10; n++)
                {
                    testnearestneighborunit_testkdtuniform(&xy, n, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                }
                testnearestneighborunit_testkdtuniform(&xy, largen, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                
                /*
                 * Test clustered (2*N points, pairs of equal points)
                 */
                ae_matrix_set_length(&xy, 2*smalln, nx+ny, _state);
                for(i=0; i<=smalln-1; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[2*i+0][j] = 10*ae_randomreal(_state)-5;
                        xy.ptr.pp_double[2*i+1][j] = xy.ptr.pp_double[2*i+0][j];
                    }
                }
                testnearestneighborunit_testkdtuniform(&xy, 2*smalln, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                
                /*
                 * Test degenerate case: all points are same except for one
                 */
                ae_matrix_set_length(&xy, smalln, nx+ny, _state);
                v = ae_randomreal(_state);
                for(i=0; i<=smalln-2; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[i][j] = v;
                    }
                }
                for(j=0; j<=nx+ny-1; j++)
                {
                    xy.ptr.pp_double[smalln-1][j] = 10*ae_randomreal(_state)-5;
                }
                testnearestneighborunit_testkdtuniform(&xy, smalln, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
            }
        }
    }
    kdterrors = kdterrors||testnearestneighborunit_testspecialcases(_state);
    
    /*
     * report
     */
    waserrors = kdterrors;
    if( !silent )
    {
        printf("TESTING NEAREST NEIGHBOR SEARCH\n");
        printf("* KD TREES:                              ");
        if( !kdterrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Compare results from different queries:
* X     just X-values
* XY    X-values and Y-values
* XT    X-values and tag values
*************************************************************************/
static ae_bool testnearestneighborunit_kdtresultsdifferent(/* Real    */ ae_matrix* refxy,
     ae_int_t ntotal,
     /* Real    */ ae_matrix* qx,
     /* Real    */ ae_matrix* qxy,
     /* Integer */ ae_vector* qt,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_false;
    for(i=0; i<=n-1; i++)
    {
        if( qt->ptr.p_int[i]<0||qt->ptr.p_int[i]>=ntotal )
        {
            result = ae_true;
            return result;
        }
        for(j=0; j<=nx-1; j++)
        {
            result = result||ae_fp_neq(qx->ptr.pp_double[i][j],refxy->ptr.pp_double[qt->ptr.p_int[i]][j]);
            result = result||ae_fp_neq(qxy->ptr.pp_double[i][j],refxy->ptr.pp_double[qt->ptr.p_int[i]][j]);
        }
        for(j=0; j<=ny-1; j++)
        {
            result = result||ae_fp_neq(qxy->ptr.pp_double[i][nx+j],refxy->ptr.pp_double[qt->ptr.p_int[i]][nx+j]);
        }
    }
    return result;
}


/*************************************************************************
Returns norm
*************************************************************************/
static double testnearestneighborunit_vnorm(/* Real    */ ae_vector* x,
     ae_int_t n,
     ae_int_t normtype,
     ae_state *_state)
{
    ae_int_t i;
    double result;


    result = ae_randomreal(_state);
    if( normtype==0 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = ae_maxreal(result, ae_fabs(x->ptr.p_double[i], _state), _state);
        }
        return result;
    }
    if( normtype==1 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = result+ae_fabs(x->ptr.p_double[i], _state);
        }
        return result;
    }
    if( normtype==2 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = result+ae_sqr(x->ptr.p_double[i], _state);
        }
        result = ae_sqrt(result, _state);
        return result;
    }
    return result;
}


/*************************************************************************
Testing Nearest Neighbor Search on uniformly distributed hypercube

NormType: 0, 1, 2
D: space dimension
N: points count
*************************************************************************/
static void testnearestneighborunit_testkdtuniform(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_int_t normtype,
     ae_bool* kdterrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    double errtol;
    ae_vector tags;
    ae_vector ptx;
    ae_vector tmpx;
    ae_vector tmpb;
    kdtree treex;
    kdtree treexy;
    kdtree treext;
    kdtreerequestbuffer bufx;
    kdtreerequestbuffer bufxy;
    kdtreerequestbuffer bufxt;
    ae_matrix qx;
    ae_matrix qxy;
    ae_vector qtags;
    ae_vector qr;
    ae_vector boxmin;
    ae_vector boxmax;
    ae_vector qmin;
    ae_vector qmax;
    double spread;
    ae_int_t kx;
    ae_int_t kxy;
    ae_int_t kt;
    double eps;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t task;
    ae_bool isequal;
    double r;
    ae_int_t q;
    ae_int_t qcount;
    double v;
    ae_bool inthebox;

    ae_frame_make(_state, &_frame_block);
    memset(&tags, 0, sizeof(tags));
    memset(&ptx, 0, sizeof(ptx));
    memset(&tmpx, 0, sizeof(tmpx));
    memset(&tmpb, 0, sizeof(tmpb));
    memset(&treex, 0, sizeof(treex));
    memset(&treexy, 0, sizeof(treexy));
    memset(&treext, 0, sizeof(treext));
    memset(&bufx, 0, sizeof(bufx));
    memset(&bufxy, 0, sizeof(bufxy));
    memset(&bufxt, 0, sizeof(bufxt));
    memset(&qx, 0, sizeof(qx));
    memset(&qxy, 0, sizeof(qxy));
    memset(&qtags, 0, sizeof(qtags));
    memset(&qr, 0, sizeof(qr));
    memset(&boxmin, 0, sizeof(boxmin));
    memset(&boxmax, 0, sizeof(boxmax));
    memset(&qmin, 0, sizeof(qmin));
    memset(&qmax, 0, sizeof(qmax));
    ae_vector_init(&tags, 0, DT_INT, _state, ae_true);
    ae_vector_init(&ptx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmpx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmpb, 0, DT_BOOL, _state, ae_true);
    _kdtree_init(&treex, _state, ae_true);
    _kdtree_init(&treexy, _state, ae_true);
    _kdtree_init(&treext, _state, ae_true);
    _kdtreerequestbuffer_init(&bufx, _state, ae_true);
    _kdtreerequestbuffer_init(&bufxy, _state, ae_true);
    _kdtreerequestbuffer_init(&bufxt, _state, ae_true);
    ae_matrix_init(&qx, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&qxy, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&qtags, 0, DT_INT, _state, ae_true);
    ae_vector_init(&qr, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&boxmin, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&boxmax, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&qmin, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&qmax, 0, DT_REAL, _state, ae_true);

    qcount = 10;
    ae_assert(n>0, "Assertion failed", _state);
    
    /*
     * Tol - roundoff error tolerance (for '>=' comparisons)
     */
    errtol = 100000*ae_machineepsilon;
    
    /*
     * Evaluate bounding box and spread.
     */
    ae_vector_set_length(&boxmin, nx, _state);
    ae_vector_set_length(&boxmax, nx, _state);
    for(j=0; j<=nx-1; j++)
    {
        boxmin.ptr.p_double[j] = xy->ptr.pp_double[0][j];
        boxmax.ptr.p_double[j] = xy->ptr.pp_double[0][j];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=nx-1; j++)
        {
            boxmin.ptr.p_double[j] = ae_minreal(boxmin.ptr.p_double[j], xy->ptr.pp_double[i][j], _state);
            boxmax.ptr.p_double[j] = ae_maxreal(boxmax.ptr.p_double[j], xy->ptr.pp_double[i][j], _state);
        }
    }
    spread = (double)(0);
    for(j=0; j<=nx-1; j++)
    {
        spread = ae_maxreal(spread, boxmax.ptr.p_double[j]-boxmin.ptr.p_double[j], _state);
    }
    if( ae_fp_eq(spread,(double)(0)) )
    {
        spread = (double)(1);
    }
    
    /*
     * fill tags
     */
    ae_vector_set_length(&tags, n, _state);
    for(i=0; i<=n-1; i++)
    {
        tags.ptr.p_int[i] = i;
    }
    
    /*
     * build trees
     */
    kdtreebuild(xy, n, nx, 0, normtype, &treex, _state);
    kdtreebuild(xy, n, nx, ny, normtype, &treexy, _state);
    kdtreebuildtagged(xy, &tags, n, nx, 0, normtype, &treext, _state);
    
    /*
     * allocate arrays
     */
    ae_vector_set_length(&tmpx, nx, _state);
    ae_vector_set_length(&tmpb, n, _state);
    ae_matrix_set_length(&qx, n, nx, _state);
    ae_matrix_set_length(&qxy, n, nx+ny, _state);
    ae_vector_set_length(&qtags, n, _state);
    ae_vector_set_length(&qr, n, _state);
    ae_vector_set_length(&ptx, nx, _state);
    
    /*
     * test general K-NN queries (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R.
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select K: 1..N
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = 1+ae_randominteger(n, _state);
        }
        else
        {
            k = 1;
        }
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test functions which use internal buffer:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
        kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
        kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
        
        /*
         * Test functions which use external buffer:
         * * create external request buffer, perform buffered request
         * * reset status of internal buffer by performing 1-NN query, it is essential
         *   to test the fact that external buffer is used
         * * check consistency of results from different queries
         * * check that points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * check that distances are correct and are ordered
         */
        kdtreecreaterequestbuffer(&treex, &bufx, _state);
        kdtreecreaterequestbuffer(&treexy, &bufxy, _state);
        kdtreecreaterequestbuffer(&treext, &bufxt, _state);
        kx = kdtreetsqueryknn(&treex, &bufx, &ptx, k, ae_true, _state);
        kxy = kdtreetsqueryknn(&treexy, &bufxy, &ptx, k, ae_true, _state);
        kt = kdtreetsqueryknn(&treext, &bufxt, &ptx, k, ae_true, _state);
        kdtreequeryknn(&treex, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treexy, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treext, &ptx, 1, ae_true, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreetsqueryresultsx(&treex, &bufx, &qx, _state);
        kdtreetsqueryresultsxy(&treexy, &bufxy, &qxy, _state);
        kdtreetsqueryresultstags(&treext, &bufxt, &qtags, _state);
        kdtreetsqueryresultsdistances(&treext, &bufxt, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
        
        /*
         * Test reallocation properties: functions must automatically
         * resize array which is too small, but leave unchanged array which is
         * too large.
         */
        if( n>=2 )
        {
            
            /*
             * First step: array is too small, two elements are required
             */
            k = 2;
            kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
            kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
            kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
            if( (kx!=k||kxy!=k)||kt!=k )
            {
                *kdterrors = ae_true;
                ae_frame_leave(_state);
                return;
            }
            ae_matrix_set_length(&qx, 1, 1, _state);
            ae_matrix_set_length(&qxy, 1, 1, _state);
            ae_vector_set_length(&qtags, 1, _state);
            ae_vector_set_length(&qr, 1, _state);
            kdtreequeryresultsx(&treex, &qx, _state);
            kdtreequeryresultsxy(&treexy, &qxy, _state);
            kdtreequeryresultstags(&treext, &qtags, _state);
            kdtreequeryresultsdistances(&treext, &qr, _state);
            *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
            
            /*
             * Second step: array is one row larger than needed, so only first
             * row is overwritten. Test it.
             */
            k = 1;
            kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
            kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
            kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
            if( (kx!=k||kxy!=k)||kt!=k )
            {
                *kdterrors = ae_true;
                ae_frame_leave(_state);
                return;
            }
            for(i=0; i<=nx-1; i++)
            {
                qx.ptr.pp_double[1][i] = _state->v_nan;
            }
            for(i=0; i<=nx+ny-1; i++)
            {
                qxy.ptr.pp_double[1][i] = _state->v_nan;
            }
            qtags.ptr.p_int[1] = 999;
            qr.ptr.p_double[1] = _state->v_nan;
            kdtreequeryresultsx(&treex, &qx, _state);
            kdtreequeryresultsxy(&treexy, &qxy, _state);
            kdtreequeryresultstags(&treext, &qtags, _state);
            kdtreequeryresultsdistances(&treext, &qr, _state);
            *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
            for(i=0; i<=nx-1; i++)
            {
                *kdterrors = *kdterrors||!ae_isnan(qx.ptr.pp_double[1][i], _state);
            }
            for(i=0; i<=nx+ny-1; i++)
            {
                *kdterrors = *kdterrors||!ae_isnan(qxy.ptr.pp_double[1][i], _state);
            }
            *kdterrors = *kdterrors||!(qtags.ptr.p_int[1]==999);
            *kdterrors = *kdterrors||!ae_isnan(qr.ptr.p_double[1], _state);
        }
        
        /*
         * Test reallocation properties: 'interactive' functions must allocate
         * new array on each call.
         */
        if( n>=2 )
        {
            
            /*
             * On input array is either too small or too large
             */
            for(k=1; k<=2; k++)
            {
                ae_assert(k==1||k==2, "KNN: internal error (unexpected K)!", _state);
                kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
                kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
                kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
                if( (kx!=k||kxy!=k)||kt!=k )
                {
                    *kdterrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ae_matrix_set_length(&qx, 3-k, 3-k, _state);
                ae_matrix_set_length(&qxy, 3-k, 3-k, _state);
                ae_vector_set_length(&qtags, 3-k, _state);
                ae_vector_set_length(&qr, 3-k, _state);
                kdtreequeryresultsxi(&treex, &qx, _state);
                kdtreequeryresultsxyi(&treexy, &qxy, _state);
                kdtreequeryresultstagsi(&treext, &qtags, _state);
                kdtreequeryresultsdistancesi(&treext, &qr, _state);
                *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
                *kdterrors = (*kdterrors||qx.rows!=k)||qx.cols!=nx;
                *kdterrors = (*kdterrors||qxy.rows!=k)||qxy.cols!=nx+ny;
                *kdterrors = *kdterrors||qtags.cnt!=k;
                *kdterrors = *kdterrors||qr.cnt!=k;
            }
        }
    }
    
    /*
     * test general approximate K-NN queries (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R/(1+Eps).
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select K: 1..N
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = 1+ae_randominteger(n, _state);
        }
        else
        {
            k = 1;
        }
        
        /*
         * Select Eps
         */
        eps = 0.5+ae_randomreal(_state);
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test functions which use internal buffer:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryaknn(&treex, &ptx, k, ae_true, eps, _state);
        kxy = kdtreequeryaknn(&treexy, &ptx, k, ae_true, eps, _state);
        kt = kdtreequeryaknn(&treext, &ptx, k, ae_true, eps, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol)/(1+eps));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
        
        /*
         * Test functions which use external buffer:
         * * create external request buffer, perform buffered request
         * * reset status of internal buffer by performing 1-NN query, it is essential
         *   to test the fact that external buffer is used
         * * check consistency of results from different queries
         * * check that points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * check that distances are correct and are ordered
         */
        kdtreecreaterequestbuffer(&treex, &bufx, _state);
        kdtreecreaterequestbuffer(&treexy, &bufxy, _state);
        kdtreecreaterequestbuffer(&treext, &bufxt, _state);
        kx = kdtreetsqueryaknn(&treex, &bufx, &ptx, k, ae_true, eps, _state);
        kxy = kdtreetsqueryaknn(&treexy, &bufxy, &ptx, k, ae_true, eps, _state);
        kt = kdtreetsqueryaknn(&treext, &bufxt, &ptx, k, ae_true, eps, _state);
        kdtreequeryknn(&treex, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treexy, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treext, &ptx, 1, ae_true, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreetsqueryresultsx(&treex, &bufx, &qx, _state);
        kdtreetsqueryresultsxy(&treexy, &bufxy, &qxy, _state);
        kdtreetsqueryresultstags(&treext, &bufxt, &qtags, _state);
        kdtreetsqueryresultsdistances(&treext, &bufxt, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol)/(1+eps));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
    }
    
    /*
     * test general R-NN queries  (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R.
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select R
         */
        if( ae_fp_greater(ae_randomreal(_state),0.3) )
        {
            r = ae_maxreal(ae_randomreal(_state), ae_machineepsilon, _state);
        }
        else
        {
            r = ae_machineepsilon;
        }
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test functions which use internal buffer:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryrnn(&treex, &ptx, r, ae_true, _state);
        kxy = kdtreequeryrnn(&treexy, &ptx, r, ae_true, _state);
        kt = kdtreequeryrnn(&treext, &ptx, r, ae_true, _state);
        if( kxy!=kx||kt!=kx )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, kx, nx, ny, _state);
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, kx, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        for(i=0; i<=kx-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            if( tmpb.ptr.p_bool[i] )
            {
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
            else
            {
                *kdterrors = *kdterrors||ae_fp_greater(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1+errtol));
            }
        }
        for(i=0; i<=kx-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        
        /*
         * Test functions which use external buffer:
         * * create external request buffer, perform buffered request
         * * reset status of internal buffer by performing 1-NN query, it is essential
         *   to test the fact that external buffer is used
         * * check consistency of results from different queries
         * * check that points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * check that distances are correct and are ordered
         */
        kdtreecreaterequestbuffer(&treex, &bufx, _state);
        kdtreecreaterequestbuffer(&treexy, &bufxy, _state);
        kdtreecreaterequestbuffer(&treext, &bufxt, _state);
        kx = kdtreetsqueryrnn(&treex, &bufx, &ptx, r, ae_true, _state);
        kxy = kdtreetsqueryrnn(&treexy, &bufxy, &ptx, r, ae_true, _state);
        kt = kdtreetsqueryrnn(&treext, &bufxt, &ptx, r, ae_true, _state);
        kdtreequeryknn(&treex, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treexy, &ptx, 1, ae_true, _state);
        kdtreequeryknn(&treext, &ptx, 1, ae_true, _state);
        if( kxy!=kx||kt!=kx )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetrealmatrix(&qxy, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreetsqueryresultsx(&treex, &bufx, &qx, _state);
        kdtreetsqueryresultsxy(&treexy, &bufxy, &qxy, _state);
        kdtreetsqueryresultstags(&treext, &bufxt, &qtags, _state);
        kdtreetsqueryresultsdistances(&treext, &bufxt, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, kx, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        for(i=0; i<=kx-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            if( tmpb.ptr.p_bool[i] )
            {
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
            else
            {
                *kdterrors = *kdterrors||ae_fp_greater(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1+errtol));
            }
        }
        for(i=0; i<=kx-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
    }
    
    /*
     * test box queries
     */
    ae_vector_set_length(&qmin, nx, _state);
    ae_vector_set_length(&qmax, nx, _state);
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Test for box exactly equal to one of the points.
         * More than one exactly equal point may be found.
         * Only thread-safe version is tested.
         */
        kdtreecreaterequestbuffer(&treext, &bufxt, _state);
        k = ae_randominteger(n, _state);
        for(j=0; j<=nx-1; j++)
        {
            qmin.ptr.p_double[j] = xy->ptr.pp_double[k][j];
            qmax.ptr.p_double[j] = xy->ptr.pp_double[k][j];
        }
        kx = kdtreetsquerybox(&treext, &bufxt, &qmin, &qmax, _state);
        if( kx<1 )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        unsetrealmatrix(&qx, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreetsqueryresultsx(&treext, &bufxt, &qx, _state);
        kdtreetsqueryresultstags(&treext, &bufxt, &qtags, _state);
        kdtreetsqueryresultsdistances(&treext, &bufxt, &qr, _state);
        for(i=0; i<=kx-1; i++)
        {
            ae_set_error_flag(kdterrors, ae_fp_neq(qr.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testnearestneighborunit.ap:753");
        }
        for(i=0; i<=kx-1; i++)
        {
            for(j=0; j<=nx-1; j++)
            {
                ae_set_error_flag(kdterrors, ae_fp_neq(qx.ptr.pp_double[i][j],xy->ptr.pp_double[k][j]), __FILE__, __LINE__, "testnearestneighborunit.ap:758");
                ae_set_error_flag(kdterrors, ae_fp_neq(qx.ptr.pp_double[i][j],xy->ptr.pp_double[qtags.ptr.p_int[i]][j]), __FILE__, __LINE__, "testnearestneighborunit.ap:759");
            }
        }
        
        /*
         * Test for randomly generated box (thread-safe version)
         */
        for(j=0; j<=nx-1; j++)
        {
            qmin.ptr.p_double[j] = boxmin.ptr.p_double[j]+ae_randomreal(_state)*(boxmax.ptr.p_double[j]-boxmin.ptr.p_double[j]);
            qmax.ptr.p_double[j] = qmin.ptr.p_double[j];
            v = spread*ae_pow((double)(10), -2*ae_randomreal(_state), _state);
            qmin.ptr.p_double[j] = qmin.ptr.p_double[j]-v;
            qmax.ptr.p_double[j] = qmax.ptr.p_double[j]+v;
        }
        kx = kdtreetsquerybox(&treext, &bufxt, &qmin, &qmax, _state);
        unsetrealmatrix(&qx, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreetsqueryresultsx(&treext, &bufxt, &qx, _state);
        kdtreetsqueryresultstags(&treext, &bufxt, &qtags, _state);
        kdtreetsqueryresultsdistances(&treext, &bufxt, &qr, _state);
        for(i=0; i<=kx-1; i++)
        {
            ae_set_error_flag(kdterrors, ae_fp_neq(qr.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testnearestneighborunit.ap:782");
        }
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_false;
        }
        for(i=0; i<=kx-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_true;
        }
        for(i=0; i<=n-1; i++)
        {
            inthebox = ae_true;
            for(j=0; j<=nx-1; j++)
            {
                inthebox = inthebox&&ae_fp_greater_eq(xy->ptr.pp_double[i][j],qmin.ptr.p_double[j]);
                inthebox = inthebox&&ae_fp_less_eq(xy->ptr.pp_double[i][j],qmax.ptr.p_double[j]);
            }
            if( tmpb.ptr.p_bool[i] )
            {
                ae_set_error_flag(kdterrors, !inthebox, __FILE__, __LINE__, "testnearestneighborunit.ap:796");
            }
            else
            {
                ae_set_error_flag(kdterrors, inthebox, __FILE__, __LINE__, "testnearestneighborunit.ap:798");
            }
        }
        
        /*
         * Test for randomly generated box (non-thread-safe version)
         */
        for(j=0; j<=nx-1; j++)
        {
            qmin.ptr.p_double[j] = boxmin.ptr.p_double[j]+ae_randomreal(_state)*(boxmax.ptr.p_double[j]-boxmin.ptr.p_double[j]);
            qmax.ptr.p_double[j] = qmin.ptr.p_double[j];
            v = spread*ae_pow((double)(10), -2*ae_randomreal(_state), _state);
            qmin.ptr.p_double[j] = qmin.ptr.p_double[j]-v;
            qmax.ptr.p_double[j] = qmax.ptr.p_double[j]+v;
        }
        kx = kdtreequerybox(&treext, &qmin, &qmax, _state);
        unsetrealmatrix(&qx, _state);
        unsetintegerarray(&qtags, _state);
        unsetrealarray(&qr, _state);
        kdtreequeryresultsx(&treext, &qx, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        for(i=0; i<=kx-1; i++)
        {
            ae_set_error_flag(kdterrors, ae_fp_neq(qr.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testnearestneighborunit.ap:820");
        }
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_false;
        }
        for(i=0; i<=kx-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_true;
        }
        for(i=0; i<=n-1; i++)
        {
            inthebox = ae_true;
            for(j=0; j<=nx-1; j++)
            {
                inthebox = inthebox&&ae_fp_greater_eq(xy->ptr.pp_double[i][j],qmin.ptr.p_double[j]);
                inthebox = inthebox&&ae_fp_less_eq(xy->ptr.pp_double[i][j],qmax.ptr.p_double[j]);
            }
            if( tmpb.ptr.p_bool[i] )
            {
                ae_set_error_flag(kdterrors, !inthebox, __FILE__, __LINE__, "testnearestneighborunit.ap:834");
            }
            else
            {
                ae_set_error_flag(kdterrors, inthebox, __FILE__, __LINE__, "testnearestneighborunit.ap:836");
            }
        }
    }
    
    /*
     * Test self-matching:
     * * self-match - nearest neighbor of each point in XY is the point itself
     * * no self-match - nearest neighbor is NOT the point itself
     */
    if( n>1 )
    {
        
        /*
         * test for N=1 have non-general form, but it is not really needed
         */
        for(task=0; task<=1; task++)
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                kx = kdtreequeryknn(&treex, &ptx, 1, task==0, _state);
                kdtreequeryresultsxi(&treex, &qx, _state);
                if( kx!=1 )
                {
                    *kdterrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                isequal = ae_true;
                for(j=0; j<=nx-1; j++)
                {
                    isequal = isequal&&ae_fp_eq(qx.ptr.pp_double[0][j],ptx.ptr.p_double[j]);
                }
                if( task==0 )
                {
                    *kdterrors = *kdterrors||!isequal;
                }
                else
                {
                    *kdterrors = *kdterrors||isequal;
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Testing serialization of KD trees

This function sets Err to True on errors, but leaves it unchanged on success
*************************************************************************/
static void testnearestneighborunit_testkdtreeserialization(ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t normtype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t q;
    ae_matrix xy;
    ae_vector x;
    ae_vector tags;
    ae_vector qsizes;
    double threshold;
    kdtree tree0;
    kdtree tree1;
    ae_int_t k0;
    ae_int_t k1;
    ae_matrix xy0;
    ae_matrix xy1;
    ae_vector tags0;
    ae_vector tags1;

    ae_frame_make(_state, &_frame_block);
    memset(&xy, 0, sizeof(xy));
    memset(&x, 0, sizeof(x));
    memset(&tags, 0, sizeof(tags));
    memset(&qsizes, 0, sizeof(qsizes));
    memset(&tree0, 0, sizeof(tree0));
    memset(&tree1, 0, sizeof(tree1));
    memset(&xy0, 0, sizeof(xy0));
    memset(&xy1, 0, sizeof(xy1));
    memset(&tags0, 0, sizeof(tags0));
    memset(&tags1, 0, sizeof(tags1));
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tags, 0, DT_INT, _state, ae_true);
    ae_vector_init(&qsizes, 0, DT_INT, _state, ae_true);
    _kdtree_init(&tree0, _state, ae_true);
    _kdtree_init(&tree1, _state, ae_true);
    ae_matrix_init(&xy0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&xy1, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tags0, 0, DT_INT, _state, ae_true);
    ae_vector_init(&tags1, 0, DT_INT, _state, ae_true);

    threshold = 100*ae_machineepsilon;
    
    /*
     * different N, NX, NY, NormType
     */
    n = 1;
    while(n<=51)
    {
        
        /*
         * prepare array with query sizes
         */
        ae_vector_set_length(&qsizes, 4, _state);
        qsizes.ptr.p_int[0] = 1;
        qsizes.ptr.p_int[1] = ae_minint(2, n, _state);
        qsizes.ptr.p_int[2] = ae_minint(4, n, _state);
        qsizes.ptr.p_int[3] = n;
        
        /*
         * different NX/NY/NormType
         */
        for(nx=1; nx<=2; nx++)
        {
            for(ny=0; ny<=2; ny++)
            {
                for(normtype=0; normtype<=2; normtype++)
                {
                    
                    /*
                     * Prepare data
                     */
                    ae_matrix_set_length(&xy, n, nx+ny, _state);
                    ae_vector_set_length(&tags, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=nx+ny-1; j++)
                        {
                            xy.ptr.pp_double[i][j] = ae_randomreal(_state);
                        }
                        tags.ptr.p_int[i] = ae_randominteger(100, _state);
                    }
                    
                    /*
                     * Build tree, pass it through serializer
                     */
                    kdtreebuildtagged(&xy, &tags, n, nx, ny, normtype, &tree0, _state);
                    {
                        /*
                         * This code passes data structure through serializers
                         * (serializes it to string and loads back)
                         */
                        ae_serializer _local_serializer;
                        ae_int_t _local_ssize;
                        ae_frame _local_frame_block;
                        ae_dyn_block _local_dynamic_block;
                        
                        ae_frame_make(_state, &_local_frame_block);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_alloc_start(&_local_serializer);
                        kdtreealloc(&_local_serializer, &tree0, _state);
                        _local_ssize = ae_serializer_get_alloc_size(&_local_serializer);
                        memset(&_local_dynamic_block, 0, sizeof(_local_dynamic_block));
                        ae_db_init(&_local_dynamic_block, _local_ssize+1, _state, ae_true);
                        ae_serializer_sstart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        kdtreeserialize(&_local_serializer, &tree0, _state);
                        ae_serializer_stop(&_local_serializer, _state);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_ustart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        kdtreeunserialize(&_local_serializer, &tree1, _state);
                        ae_serializer_stop(&_local_serializer, _state);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_frame_leave(_state);
                    }
                    
                    /*
                     * For each point of XY we make queries with different sizes
                     */
                    ae_vector_set_length(&x, nx, _state);
                    for(k=0; k<=n-1; k++)
                    {
                        for(q=0; q<=qsizes.cnt-1; q++)
                        {
                            ae_v_move(&x.ptr.p_double[0], 1, &xy.ptr.pp_double[k][0], 1, ae_v_len(0,nx-1));
                            k0 = kdtreequeryknn(&tree0, &x, qsizes.ptr.p_int[q], ae_true, _state);
                            k1 = kdtreequeryknn(&tree1, &x, qsizes.ptr.p_int[q], ae_true, _state);
                            if( k0!=k1 )
                            {
                                *err = ae_true;
                                ae_frame_leave(_state);
                                return;
                            }
                            kdtreequeryresultsxy(&tree0, &xy0, _state);
                            kdtreequeryresultsxy(&tree1, &xy1, _state);
                            for(i=0; i<=k0-1; i++)
                            {
                                for(j=0; j<=nx+ny-1; j++)
                                {
                                    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[i][j]-xy1.ptr.pp_double[i][j], _state),threshold) )
                                    {
                                        *err = ae_true;
                                        ae_frame_leave(_state);
                                        return;
                                    }
                                }
                            }
                            kdtreequeryresultstags(&tree0, &tags0, _state);
                            kdtreequeryresultstags(&tree1, &tags1, _state);
                            for(i=0; i<=k0-1; i++)
                            {
                                if( tags0.ptr.p_int[i]!=tags1.ptr.p_int[i] )
                                {
                                    *err = ae_true;
                                    ae_frame_leave(_state);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        
        /*
         * Next N
         */
        n = n+25;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function tests different special cases:
* Kd-tree for a zero number of points
* Kd-tree for array with a lot of duplicates (early versions of ALGLIB
  raised stack overflow on such datasets)

It returns True on errors, False on success.
*************************************************************************/
static ae_bool testnearestneighborunit_testspecialcases(ae_state *_state)
{
    ae_frame _frame_block;
    kdtree kdt;
    ae_matrix xy;
    ae_vector tags;
    ae_vector x;
    ae_int_t n;
    ae_int_t nk;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t normtype;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&kdt, 0, sizeof(kdt));
    memset(&xy, 0, sizeof(xy));
    memset(&tags, 0, sizeof(tags));
    memset(&x, 0, sizeof(x));
    _kdtree_init(&kdt, _state, ae_true);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tags, 0, DT_INT, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);

    result = ae_false;
    for(nx=1; nx<=3; nx++)
    {
        for(ny=0; ny<=3; ny++)
        {
            for(normtype=0; normtype<=2; normtype++)
            {
                
                /*
                 * Build tree
                 */
                if( ae_fp_greater(ae_randomreal(_state),0.5) )
                {
                    kdtreebuildtagged(&xy, &tags, 0, nx, ny, normtype, &kdt, _state);
                }
                else
                {
                    kdtreebuild(&xy, 0, nx, ny, normtype, &kdt, _state);
                }
                
                /*
                 * Test different queries
                 */
                ae_vector_set_length(&x, nx, _state);
                for(i=0; i<=nx-1; i++)
                {
                    x.ptr.p_double[i] = ae_randomreal(_state);
                }
                result = result||kdtreequeryknn(&kdt, &x, 1, ae_true, _state)>0;
                result = result||kdtreequeryrnn(&kdt, &x, 1.0E6, ae_true, _state)>0;
                result = result||kdtreequeryaknn(&kdt, &x, 1, ae_true, 2.0, _state)>0;
            }
        }
    }
    
    /*
     * Ability to handle array with a lot of duplicates without causing
     * stack overflow.
     *
     * Two situations are handled:
     * * array where ALL N elements are duplicates
     * * array where there are NK distinct elements and N-NK duplicates
     */
    nx = 2;
    ny = 1;
    n = 100000;
    nk = 100;
    v = ae_randomreal(_state);
    ae_matrix_set_length(&xy, n, nx+ny, _state);
    ae_vector_set_length(&x, nx, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=nx+ny-1; j++)
        {
            xy.ptr.pp_double[i][j] = v;
        }
    }
    kdtreebuild(&xy, n, nx, ny, 2, &kdt, _state);
    for(j=0; j<=nx-1; j++)
    {
        x.ptr.p_double[j] = v;
    }
    result = result||kdtreequeryrnn(&kdt, &x, 0.0001, ae_true, _state)!=n;
    for(i=0; i<=nk-1; i++)
    {
        for(j=0; j<=nx+ny-1; j++)
        {
            xy.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    kdtreebuild(&xy, n, nx, ny, 2, &kdt, _state);
    result = result||kdtreequeryrnn(&kdt, &x, 0.0001, ae_true, _state)<n-nk;
    ae_frame_leave(_state);
    return result;
}



static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state);
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state);





ae_bool testhqrnd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t samplesize;
    double sigmathreshold;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t k;
    ae_int_t pass;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t i1;
    ae_int_t i2;
    double r1;
    double r2;
    ae_vector x;
    ae_vector bins;
    double mean;
    double means;
    double stddev;
    double stddevs;
    double lambdav;
    ae_bool seederrors;
    ae_bool urerrors;
    double ursigmaerr;
    ae_bool uierrors;
    double uisigmaerr;
    ae_bool normerrors;
    double normsigmaerr;
    ae_bool unit2errors;
    ae_bool experrors;
    double expsigmaerr;
    ae_bool discreteerr;
    ae_bool continuouserr;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&bins, 0, sizeof(bins));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bins, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    waserrors = ae_false;
    sigmathreshold = (double)(7);
    samplesize = 100000;
    passcount = 50;
    seederrors = ae_false;
    urerrors = ae_false;
    uierrors = ae_false;
    normerrors = ae_false;
    experrors = ae_false;
    unit2errors = ae_false;
    ae_vector_set_length(&x, samplesize-1+1, _state);
    
    /*
     * Test seed errors
     */
    for(pass=1; pass<=passcount; pass++)
    {
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i1 = hqrnduniformi(&state, 100, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i2 = hqrnduniformi(&state, 100, _state);
        seederrors = seederrors||i1!=i2;
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r1 = hqrnduniformr(&state, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r2 = hqrnduniformr(&state, _state);
        seederrors = seederrors||ae_fp_neq(r1,r2);
    }
    
    /*
     * Test HQRNDRandomize() and real uniform generator
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    ursigmaerr = (double)(0);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrnduniformr(&state, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        urerrors = (urerrors||ae_fp_less_eq(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(1));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((mean-0.5)/means, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((stddev-ae_sqrt((double)1/(double)12, _state))/stddevs, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    urerrors = urerrors||ae_fp_greater(ursigmaerr,sigmathreshold);
    
    /*
     * Test HQRNDRandomize() and integer uniform
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    for(n=2; n<=10; n++)
    {
        for(i=0; i<=samplesize-1; i++)
        {
            x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
        }
        for(i=0; i<=samplesize-1; i++)
        {
            uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
        }
        testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
        if( ae_fp_neq(means,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
        if( ae_fp_neq(stddevs,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Special 'close-to-limit' test on uniformity of integers
     * (straightforward implementation like 'RND mod N' will return
     *  non-uniform numbers for N=2/3*LIMIT)
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    n = 1431655708;
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Test normal
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    normsigmaerr = (double)(0);
    i = 0;
    while(i<samplesize)
    {
        hqrndnormal2(&state, &r1, &r2, _state);
        x.ptr.p_double[i] = r1;
        if( i+1<samplesize )
        {
            x.ptr.p_double[i+1] = r2;
        }
        i = i+2;
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/means, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-1)/stddevs, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    normerrors = normerrors||ae_fp_greater(normsigmaerr,sigmathreshold);
    
    /*
     * Test unit2
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    n = 1000000;
    ae_vector_set_length(&bins, 10, _state);
    for(i=0; i<=bins.cnt-1; i++)
    {
        bins.ptr.p_int[i] = 0;
    }
    for(pass=0; pass<=n-1; pass++)
    {
        hqrndunit2(&state, &r1, &r2, _state);
        ae_set_error_flag(&unit2errors, ae_fp_greater(ae_fabs(r1*r1+r2*r2-1, _state),100*ae_machineepsilon), __FILE__, __LINE__, "testhqrndunit.ap:241");
        k = ae_ifloor((ae_atan2(r1, r2, _state)+ae_pi)/(2*ae_pi)*bins.cnt, _state);
        if( k<0 )
        {
            k = 0;
        }
        if( k>=bins.cnt )
        {
            k = bins.cnt-1;
        }
        bins.ptr.p_int[k] = bins.ptr.p_int[k]+1;
    }
    for(i=0; i<=bins.cnt-1; i++)
    {
        ae_set_error_flag(&unit2errors, ae_fp_less((double)(bins.ptr.p_int[i]),0.9*n/bins.cnt)||ae_fp_greater((double)(bins.ptr.p_int[i]),1.1*n/bins.cnt), __FILE__, __LINE__, "testhqrndunit.ap:250");
    }
    
    /*
     * Test exponential
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    expsigmaerr = (double)(0);
    lambdav = 2+5*ae_randomreal(_state);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrndexponential(&state, lambdav, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((mean-1.0/lambdav)/means, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((stddev-1.0/lambdav)/stddevs, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    experrors = experrors||ae_fp_greater(expsigmaerr,sigmathreshold);
    
    /*
     *Discrete/Continuous tests
     */
    discreteerr = hqrnddiscretetest(ae_true, _state);
    continuouserr = hqrndcontinuoustest(ae_true, _state);
    
    /*
     * Final report
     */
    waserrors = ((((((seederrors||urerrors)||uierrors)||normerrors)||unit2errors)||experrors)||discreteerr)||continuouserr;
    if( !silent )
    {
        printf("RNG TEST\n");
        printf("SEED TEST:                               ");
        if( !seederrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM CONTINUOUS:                      ");
        if( !urerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM INTEGER:                         ");
        if( !uierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("NORMAL:                                  ");
        if( !normerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIT2:                                   ");
        if( !unit2errors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("EXPONENTIAL:                             ");
        if( !experrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("DISCRETE:                                ");
        if( !discreteerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CONTINUOUS:                              ");
        if( !continuouserr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    ae_vector bins;
    ae_vector binbounds;
    ae_int_t nb;
    ae_int_t samplesize;
    hqrndstate state;
    ae_int_t xp;
    ae_int_t i;
    ae_int_t j;
    double v;
    double sigma;
    double sigmamax;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&sample, 0, sizeof(sample));
    memset(&bins, 0, sizeof(bins));
    memset(&binbounds, 0, sizeof(binbounds));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&sample, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bins, 0, DT_INT, _state, ae_true);
    ae_vector_init(&binbounds, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    result = ae_false;
    
    /*
     * Test for sample size equal to 1
     */
    ae_vector_set_length(&sample, 1, _state);
    sample.ptr.p_double[0] = ae_randomreal(_state);
    hqrndrandomize(&state, _state);
    result = result||ae_fp_neq(hqrndcontinuous(&state, &sample, 1, _state),sample.ptr.p_double[0]);
    
    /*
     * Test for larger samples
     */
    xp = 100000;
    sigmamax = 10.0;
    for(samplesize=2; samplesize<=5; samplesize++)
    {
        
        /*
         * 1. Generate random sample with SampleSize points
         * 2. Generate NB=3*(SampleSize-1) bins, with bounds as prescribed by (BinBounds[I],BinBounds[I+1]).
         *    Bin bounds are generated in such a way that value can fall into any bin with same probability
         * 3. Generate many random values
         * 4. Calculate number of values which fall into each bin
         * 5. Bins[I] should have binomial distribution with mean XP/NB and 
         *    variance XP*(1/NB)*(1-1/NB)
         */
        nb = 3*(samplesize-1);
        sigma = ae_sqrt(xp*((double)1/(double)nb)*(1-(double)1/(double)nb), _state);
        ae_vector_set_length(&sample, samplesize, _state);
        sample.ptr.p_double[0] = 2*ae_randomreal(_state)-1;
        for(i=0; i<=samplesize-2; i++)
        {
            sample.ptr.p_double[i+1] = sample.ptr.p_double[i]+0.1+ae_randomreal(_state);
        }
        ae_vector_set_length(&bins, nb, _state);
        ae_vector_set_length(&binbounds, nb+1, _state);
        for(i=0; i<=samplesize-2; i++)
        {
            bins.ptr.p_int[3*i+0] = 0;
            bins.ptr.p_int[3*i+1] = 0;
            bins.ptr.p_int[3*i+2] = 0;
            binbounds.ptr.p_double[3*i+0] = sample.ptr.p_double[i];
            binbounds.ptr.p_double[3*i+1] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])/3;
            binbounds.ptr.p_double[3*i+2] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])*2/3;
        }
        binbounds.ptr.p_double[nb] = sample.ptr.p_double[samplesize-1];
        hqrndrandomize(&state, _state);
        for(i=0; i<=xp-1; i++)
        {
            v = hqrndcontinuous(&state, &sample, samplesize, _state);
            for(j=0; j<=nb-1; j++)
            {
                if( ae_fp_greater(v,binbounds.ptr.p_double[j])&&ae_fp_less(v,binbounds.ptr.p_double[j+1]) )
                {
                    bins.ptr.p_int[j] = bins.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=nb-1; i++)
        {
            result = result||ae_fp_greater(ae_fabs(bins.ptr.p_int[i]-(double)xp/(double)nb, _state),sigma*sigmamax);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    double sigma;
    double sigmathreshold;
    double tsample;
    double max;
    double min;
    ae_int_t i;
    ae_int_t j;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t binscount;
    ae_int_t xp;
    ae_vector nn;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&sample, 0, sizeof(sample));
    memset(&nn, 0, sizeof(nn));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&sample, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&nn, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    
    /*
     * We test that all values from discrete sample are generated with same probability.
     * To do this, we generate random values many times, then we calculate actual probabilities
     * and compare them with theoretical ones.
     */
    max = (double)(100);
    min = (double)(-100);
    xp = 100000;
    sigmathreshold = 10.0;
    for(binscount=1; binscount<=5; binscount++)
    {
        sigma = ae_sqrt(xp*((double)1/(double)binscount)*(1-(double)1/(double)binscount), _state);
        ae_vector_set_length(&nn, binscount, _state);
        for(i=0; i<=binscount-1; i++)
        {
            nn.ptr.p_int[i] = 0;
        }
        ae_vector_set_length(&sample, binscount, _state);
        sample.ptr.p_double[0] = (max-min)*ae_randomreal(_state)+min;
        for(i=1; i<=binscount-1; i++)
        {
            sample.ptr.p_double[i] = sample.ptr.p_double[i-1]+max*ae_randomreal(_state)+0.001;
        }
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        hqrndseed(s1, s2, &state, _state);
        for(i=0; i<=xp-1; i++)
        {
            tsample = hqrnddiscrete(&state, &sample, binscount, _state);
            for(j=0; j<=binscount-1; j++)
            {
                if( ae_fp_eq(tsample,sample.ptr.p_double[j]) )
                {
                    nn.ptr.p_int[j] = nn.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=binscount-1; i++)
        {
            if( ae_fp_less((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount-sigmathreshold*sigma)||ae_fp_greater((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount+sigmathreshold*sigma) )
            {
                if( !silent )
                {
                    printf("HQRNDDiscreteTest::ErrorReport::\n");
                    printf("nn[%0d]=%0d;\n   xp/BinsCount=%0.5f;\n   C*sigma=%0.5f\n",
                        (int)(i),
                        (int)(nn.ptr.p_int[i]),
                        (double)((double)xp/(double)binscount),
                        (double)(sigmathreshold*sigma));
                    printf("HQRNDDiscreteTest: test is FAILED!\n");
                }
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
        if( !silent )
        {
            printf("HQRNDDiscreteTest: test is OK.\n");
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state)
{
    ae_int_t i;
    double v1;
    double v2;
    double variance;

    *mean = 0;
    *means = 0;
    *stddev = 0;
    *stddevs = 0;

    *mean = (double)(0);
    *means = (double)(1);
    *stddev = (double)(0);
    *stddevs = (double)(1);
    variance = (double)(0);
    if( n<=1 )
    {
        return;
    }
    
    /*
     * Mean
     */
    for(i=0; i<=n-1; i++)
    {
        *mean = *mean+x->ptr.p_double[i];
    }
    *mean = *mean/n;
    
    /*
     * Variance (using corrected two-pass algorithm)
     */
    if( n!=1 )
    {
        v1 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v1 = v1+ae_sqr(x->ptr.p_double[i]-(*mean), _state);
        }
        v2 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v2 = v2+(x->ptr.p_double[i]-(*mean));
        }
        v2 = ae_sqr(v2, _state)/n;
        variance = (v1-v2)/(n-1);
        if( ae_fp_less(variance,(double)(0)) )
        {
            variance = (double)(0);
        }
        *stddev = ae_sqrt(variance, _state);
    }
    
    /*
     * Errors
     */
    *means = *stddev/ae_sqrt((double)(n), _state);
    *stddevs = *stddev*ae_sqrt((double)(2), _state)/ae_sqrt((double)(n-1), _state);
}


/*************************************************************************
Unsets HQRNDState structure
*************************************************************************/
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state)
{


    state->s1 = 0;
    state->s2 = 0;
    state->magicv = 0;
}








/*************************************************************************
Test
*************************************************************************/
ae_bool testodesolver(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t passcount;
    ae_bool curerrors;
    ae_bool rkckerrors;
    ae_bool waserrors;
    ae_vector xtbl;
    ae_matrix ytbl;
    odesolverreport rep;
    ae_vector xg;
    ae_vector y;
    double h;
    double eps;
    ae_int_t solver;
    ae_int_t pass;
    ae_int_t mynfev;
    double v;
    ae_int_t m;
    ae_int_t m2;
    ae_int_t i;
    double err;
    odesolverstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xtbl, 0, sizeof(xtbl));
    memset(&ytbl, 0, sizeof(ytbl));
    memset(&rep, 0, sizeof(rep));
    memset(&xg, 0, sizeof(xg));
    memset(&y, 0, sizeof(y));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&xtbl, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ytbl, 0, 0, DT_REAL, _state, ae_true);
    _odesolverreport_init(&rep, _state, ae_true);
    ae_vector_init(&xg, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    _odesolverstate_init(&state, _state, ae_true);

    rkckerrors = ae_false;
    waserrors = ae_false;
    passcount = 10;
    
    /*
     * simple test: just A*sin(x)+B*cos(x)
     */
    ae_assert(passcount>=2, "Assertion failed", _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        for(solver=0; solver<=0; solver++)
        {
            
            /*
             * prepare
             */
            h = 1.0E-2;
            eps = 1.0E-5;
            if( pass%2==0 )
            {
                eps = -eps;
            }
            ae_vector_set_length(&y, 2, _state);
            for(i=0; i<=1; i++)
            {
                y.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            m = 2+ae_randominteger(10, _state);
            ae_vector_set_length(&xg, m, _state);
            xg.ptr.p_double[0] = (m-1)*ae_randomreal(_state);
            for(i=1; i<=m-1; i++)
            {
                xg.ptr.p_double[i] = xg.ptr.p_double[i-1]+ae_randomreal(_state);
            }
            v = 2*ae_pi/(xg.ptr.p_double[m-1]-xg.ptr.p_double[0]);
            ae_v_muld(&xg.ptr.p_double[0], 1, ae_v_len(0,m-1), v);
            if( ae_fp_greater(ae_randomreal(_state),0.5) )
            {
                ae_v_muld(&xg.ptr.p_double[0], 1, ae_v_len(0,m-1), -1);
            }
            mynfev = 0;
            
            /*
             * choose solver
             */
            if( solver==0 )
            {
                odesolverrkck(&y, 2, &xg, m, eps, h, &state, _state);
            }
            
            /*
             * solve
             */
            while(odesolveriteration(&state, _state))
            {
                state.dy.ptr.p_double[0] = state.y.ptr.p_double[1];
                state.dy.ptr.p_double[1] = -state.y.ptr.p_double[0];
                mynfev = mynfev+1;
            }
            odesolverresults(&state, &m2, &xtbl, &ytbl, &rep, _state);
            
            /*
             * check results
             */
            curerrors = ae_false;
            if( rep.terminationtype<=0 )
            {
                curerrors = ae_true;
            }
            else
            {
                curerrors = curerrors||m2!=m;
                err = (double)(0);
                for(i=0; i<=m-1; i++)
                {
                    err = ae_maxreal(err, ae_fabs(ytbl.ptr.pp_double[i][0]-(y.ptr.p_double[0]*ae_cos(xtbl.ptr.p_double[i]-xtbl.ptr.p_double[0], _state)+y.ptr.p_double[1]*ae_sin(xtbl.ptr.p_double[i]-xtbl.ptr.p_double[0], _state)), _state), _state);
                    err = ae_maxreal(err, ae_fabs(ytbl.ptr.pp_double[i][1]-(-y.ptr.p_double[0]*ae_sin(xtbl.ptr.p_double[i]-xtbl.ptr.p_double[0], _state)+y.ptr.p_double[1]*ae_cos(xtbl.ptr.p_double[i]-xtbl.ptr.p_double[0], _state)), _state), _state);
                }
                curerrors = curerrors||ae_fp_greater(err,10*ae_fabs(eps, _state));
                curerrors = curerrors||mynfev!=rep.nfev;
            }
            if( solver==0 )
            {
                rkckerrors = rkckerrors||curerrors;
            }
        }
    }
    
    /*
     * another test:
     *
     *     y(0)   = 0
     *     dy/dx  = f(x,y)
     *     f(x,y) = 0,   x<1
     *              x-1, x>=1
     *
     * with BOTH absolute and fractional tolerances.
     * Starting from zero will be real challenge for
     * fractional tolerance.
     */
    ae_assert(passcount>=2, "Assertion failed", _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        h = 1.0E-4;
        eps = 1.0E-4;
        if( pass%2==0 )
        {
            eps = -eps;
        }
        ae_vector_set_length(&y, 1, _state);
        y.ptr.p_double[0] = (double)(0);
        m = 21;
        ae_vector_set_length(&xg, m, _state);
        for(i=0; i<=m-1; i++)
        {
            xg.ptr.p_double[i] = (double)(2*i)/(double)(m-1);
        }
        mynfev = 0;
        odesolverrkck(&y, 1, &xg, m, eps, h, &state, _state);
        while(odesolveriteration(&state, _state))
        {
            state.dy.ptr.p_double[0] = ae_maxreal(state.x-1, (double)(0), _state);
            mynfev = mynfev+1;
        }
        odesolverresults(&state, &m2, &xtbl, &ytbl, &rep, _state);
        if( rep.terminationtype<=0 )
        {
            rkckerrors = ae_true;
        }
        else
        {
            rkckerrors = rkckerrors||m2!=m;
            err = (double)(0);
            for(i=0; i<=m-1; i++)
            {
                err = ae_maxreal(err, ae_fabs(ytbl.ptr.pp_double[i][0]-ae_sqr(ae_maxreal(xg.ptr.p_double[i]-1, (double)(0), _state), _state)/2, _state), _state);
            }
            rkckerrors = rkckerrors||ae_fp_greater(err,ae_fabs(eps, _state));
            rkckerrors = rkckerrors||mynfev!=rep.nfev;
        }
    }
    
    /*
     * end
     */
    waserrors = rkckerrors;
    if( !silent )
    {
        printf("TESTING ODE SOLVER\n");
        printf("* RK CASH-KARP:                           ");
        if( rkckerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state);
static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static ae_bool testsparseunit_enumeratetest(ae_state *_state);
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state);
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state);
static ae_bool testsparseunit_testconvertsm(ae_state *_state);
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state);





ae_bool testsparse(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool basicerrors;
    ae_bool linearerrors;
    ae_bool basicrnderrors;
    ae_bool level2unsymmetricerrors;
    ae_bool level2symmetricerrors;
    ae_bool level2triangularerrors;
    ae_bool level3unsymmetricerrors;
    ae_bool level3symmetricerrors;
    ae_bool linearserrors;
    ae_bool linearmmerrors;
    ae_bool linearsmmerrors;
    ae_bool getrowerrors;
    ae_bool copyerrors;
    ae_bool basiccopyerrors;
    ae_bool enumerateerrors;
    ae_bool rewriteexistingerr;
    ae_bool skserrors;
    ae_bool crserrors;
    ae_bool result;


    getrowerrors = ae_false;
    crserrors = ae_false;
    skserrors = skstest(_state);
    crstest(&crserrors, _state);
    basicerrors = basicfunctest(_state)||testsparseunit_testgcmatrixtype(_state);
    basicrnderrors = basicfuncrandomtest(_state);
    linearerrors = linearfunctionstest(_state);
    level2unsymmetricerrors = testlevel2unsymmetric(_state);
    level2symmetricerrors = testlevel2symmetric(_state);
    level2triangularerrors = testlevel2triangular(_state);
    level3unsymmetricerrors = testlevel3unsymmetric(_state);
    level3symmetricerrors = testlevel3symmetric(_state);
    linearserrors = linearfunctionsstest(_state);
    linearmmerrors = linearfunctionsmmtest(_state);
    linearsmmerrors = linearfunctionssmmtest(_state);
    copyerrors = copyfunctest(ae_true, _state)||testsparseunit_testconvertsm(_state);
    basiccopyerrors = basiccopyfunctest(ae_true, _state);
    enumerateerrors = testsparseunit_enumeratetest(_state);
    rewriteexistingerr = testsparseunit_rewriteexistingtest(_state);
    testsparseunit_testgetrow(&getrowerrors, _state);
    
    /*
     * report
     */
    waserrors = ((((((((((((((((skserrors||crserrors)||getrowerrors)||basicerrors)||linearerrors)||basicrnderrors)||level2unsymmetricerrors)||level2symmetricerrors)||level2triangularerrors)||level3unsymmetricerrors)||level3symmetricerrors)||linearserrors)||linearmmerrors)||linearsmmerrors)||copyerrors)||basiccopyerrors)||enumerateerrors)||rewriteexistingerr;
    if( !silent )
    {
        printf("TESTING SPARSE\n");
        printf("STORAGE FORMAT SPECIFICS:\n");
        printf("* SKS:                                   ");
        if( !skserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* CRS:                                   ");
        if( !crserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("OPERATIONS:\n");
        printf("* GETROW:                                ");
        if( !getrowerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BLAS:\n");
        printf("* LEVEL 2 GENERAL:                       ");
        if( !level2unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 SYMMETRIC:                     ");
        if( !level2symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 TRIANGULAR:                    ");
        if( !level2triangularerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 GENERAL:                       ");
        if( !level3unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 SYMMETRIC:                     ");
        if( !level3symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC TEST:                              ");
        if( !basicerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COPY TEST:                               ");
        if( !copyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_COPY TEST:                         ");
        if( !basiccopyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_RND TEST:                          ");
        if( !basicrnderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST:                             ");
        if( !linearerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST FOR SYMMETRIC MATRICES:      ");
        if( !linearserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST:                         ");
        if( !linearmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST FOR SYMMETRIC MATRICES:  ");
        if( !linearsmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("ENUMERATE TEST:                          ");
        if( !enumerateerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REWRITE EXISTING TEST:                   ");
        if( !rewriteexistingerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    sparsematrix s3;
    sparsematrix s4;
    sparsematrix s5;
    sparsematrix s6;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    ae_int_t t0;
    ae_int_t t1;
    ae_matrix a;
    ae_matrix wasenumerated;
    ae_vector d;
    ae_vector u;
    hqrndstate rs;
    double v0;
    double v1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_int_t bw;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    memset(&s3, 0, sizeof(s3));
    memset(&s4, 0, sizeof(s4));
    memset(&s5, 0, sizeof(s5));
    memset(&s6, 0, sizeof(s6));
    memset(&a, 0, sizeof(a));
    memset(&wasenumerated, 0, sizeof(wasenumerated));
    memset(&d, 0, sizeof(d));
    memset(&u, 0, sizeof(u));
    memset(&rs, 0, sizeof(rs));
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&s2, _state, ae_true);
    _sparsematrix_init(&s3, _state, ae_true);
    _sparsematrix_init(&s4, _state, ae_true);
    _sparsematrix_init(&s5, _state, ae_true);
    _sparsematrix_init(&s6, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&wasenumerated, 0, 0, DT_BOOL, _state, ae_true);
    ae_vector_init(&d, 0, DT_INT, _state, ae_true);
    ae_vector_init(&u, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. We also generate D and U - subdiagonal
             * and superdiagonal profile sizes.
             *
             * Create matrix with either general SKS or banded SKS constructor function
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_vector_set_length(&d, n, _state);
            ae_vector_set_length(&u, n, _state);
            ae_matrix_set_length(&a, n, n, _state);
            if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
            {
                
                /*
                 * Test SparseCreateSKS() functionality
                 */
                for(i=0; i<=n-1; i++)
                {
                    d.ptr.p_int[i] = 0;
                    u.ptr.p_int[i] = 0;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j||ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                            if( j<i )
                            {
                                d.ptr.p_int[i] = ae_maxint(d.ptr.p_int[i], i-j, _state);
                            }
                            else
                            {
                                u.ptr.p_int[j] = ae_maxint(u.ptr.p_int[j], j-i, _state);
                            }
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
                sparsecreatesks(n, n, &d, &u, &s0, _state);
            }
            else
            {
                
                /*
                 * Test SparseCreateSKSBand() functionality
                 */
                bw = hqrnduniformi(&rs, n+1, _state);
                for(i=0; i<=n-1; i++)
                {
                    d.ptr.p_int[i] = ae_minint(bw, i, _state);
                    u.ptr.p_int[i] = ae_minint(bw, i, _state);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_iabs(i-j, _state)<=bw&&ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
                sparsecreatesksband(n, n, bw, &s0, _state);
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
                        {
                            ae_set_error_flag(&result, !sparserewriteexisting(&s0, i, j, a.ptr.pp_double[i][j], _state), __FILE__, __LINE__, "testsparseunit.ap:437");
                        }
                        else
                        {
                            sparseset(&s0, i, j, a.ptr.pp_double[i][j], _state);
                        }
                    }
                }
            }
            uppercnt = 0;
            lowercnt = 0;
            for(i=0; i<=n-1; i++)
            {
                uppercnt = uppercnt+u.ptr.p_int[i];
                lowercnt = lowercnt+d.ptr.p_int[i];
            }
            
            /*
             * Try to call SparseRewriteExisting() for out-of-band elements, make sure that it returns False.
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (i>=j&&i-j>d.ptr.p_int[i])||(i<=j&&j-i>u.ptr.p_int[j]) )
                    {
                        ae_set_error_flag(&result, sparserewriteexisting(&s0, i, j, 1.0, _state), __FILE__, __LINE__, "testsparseunit.ap:455");
                    }
                }
            }
            
            /*
             * Convert to several different formats, check their contents with SparseGet().
             */
            sparsecopy(&s0, &s1, _state);
            sparseconverttocrs(&s1, _state);
            sparsecopytocrs(&s0, &s2, _state);
            sparsecopytocrsbuf(&s0, &s3, _state);
            sparsecopytohash(&s0, &s4, _state);
            sparsecopytohashbuf(&s0, &s5, _state);
            sparsecopy(&s0, &s6, _state);
            sparseconverttohash(&s6, _state);
            ae_set_error_flag(&result, sparsegetnrows(&s0, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:468");
            ae_set_error_flag(&result, sparsegetncols(&s0, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:469");
            ae_set_error_flag(&result, sparsegetmatrixtype(&s0, _state)!=2, __FILE__, __LINE__, "testsparseunit.ap:470");
            ae_set_error_flag(&result, !sparseissks(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:471");
            ae_set_error_flag(&result, sparseiscrs(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:472");
            ae_set_error_flag(&result, sparseishash(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:473");
            ae_set_error_flag(&result, sparseissks(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:474");
            ae_set_error_flag(&result, !sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:475");
            ae_set_error_flag(&result, sparseishash(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:476");
            for(i=0; i<=n-1; i++)
            {
                v1 = a.ptr.pp_double[i][i];
                v0 = sparsegetdiagonal(&s0, i, _state);
                ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:481");
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s0, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:488");
                    v0 = sparseget(&s1, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:490");
                    v0 = sparseget(&s2, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:492");
                    v0 = sparseget(&s3, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:494");
                    v0 = sparseget(&s4, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:496");
                    v0 = sparseget(&s5, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:498");
                    v0 = sparseget(&s6, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:500");
                }
            }
            
            /*
             * Check enumeration capabilities:
             * * each element returned by SparseEnumerate() is returned only once
             * * each non-zero element of A was enumerated
             */
            ae_matrix_set_length(&wasenumerated, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    wasenumerated.ptr.pp_bool[i][j] = ae_false;
                }
            }
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&s0, &t0, &t1, &i, &j, &v0, _state))
            {
                ae_set_error_flag(&result, wasenumerated.ptr.pp_bool[i][j], __FILE__, __LINE__, "testsparseunit.ap:516");
                wasenumerated.ptr.pp_bool[i][j] = ae_true;
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        ae_set_error_flag(&result, !wasenumerated.ptr.pp_bool[i][j], __FILE__, __LINE__, "testsparseunit.ap:522");
                    }
                }
            }
            
            /*
             * Check UpperCnt()/LowerCnt()
             */
            ae_set_error_flag(&result, sparsegetuppercount(&s0, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:527");
            ae_set_error_flag(&result, sparsegetlowercount(&s0, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:528");
            
            /*
             * Check in-place transposition
             */
            sparsecopy(&s0, &s1, _state);
            sparsetransposesks(&s1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v0 = sparseget(&s0, i, j, _state);
                    v1 = sparseget(&s1, j, i, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:540");
                }
            }
            
            /*
             * One more check - matrix is initially created in some other format
             * (CRS or Hash) and converted to SKS later.
             */
            sparsecreate(n, n, 0, &s0, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(&s0, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            sparsecopy(&s0, &s1, _state);
            sparseconverttosks(&s1, _state);
            sparsecopytosks(&s0, &s2, _state);
            sparsecopytosksbuf(&s0, &s3, _state);
            ae_set_error_flag(&result, !sparseissks(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:556");
            ae_set_error_flag(&result, sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:557");
            ae_set_error_flag(&result, sparseishash(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:558");
            ae_set_error_flag(&result, !sparseissks(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:559");
            ae_set_error_flag(&result, sparseiscrs(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:560");
            ae_set_error_flag(&result, sparseishash(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:561");
            ae_set_error_flag(&result, !sparseissks(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:562");
            ae_set_error_flag(&result, sparseiscrs(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:563");
            ae_set_error_flag(&result, sparseishash(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:564");
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s1, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:570");
                    v0 = sparseget(&s2, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:572");
                    v0 = sparseget(&s3, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:574");
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = ae_minint(ae_round(nz*0.95, _state), nz-1, _state);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing CRS-specific functionality.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void crstest(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t nz;
    double pnz;
    hqrndstate rs;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    memset(&rs, 0, sizeof(rs));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    _hqrndstate_init(&rs, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&s2, _state, ae_true);

    hqrndrandomize(&rs, _state);
    for(n=1; n<=10; n++)
    {
        for(m=1; m<=10; m++)
        {
            nz = n*m;
            for(;;)
            {
                
                /*
                 * Generate N*N matrix where probability of non-diagonal element
                 * being non-zero is PNZ. We also generate D and U - subdiagonal
                 * and superdiagonal profile sizes.
                 *
                 * Create matrix with either general SKS or banded SKS constructor function
                 */
                if( n>1 )
                {
                    pnz = (double)nz/(double)(m*n);
                }
                else
                {
                    pnz = 1.0;
                }
                
                /*
                 * Generate random matrix in HASH format, copy it to CRS format, compare with original
                 */
                sparsecreate(m, n, ae_round(nz*hqrnduniformr(&rs, _state), _state), &s0, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            sparseset(&s0, i, j, hqrndnormal(&rs, _state), _state);
                        }
                    }
                }
                sparsecopytocrs(&s0, &s1, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:642");
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s0, i, j, _state),sparseget(&s1, i, j, _state)), __FILE__, __LINE__, "testsparseunit.ap:645");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Check transposition
                 */
                sparsecopytocrs(&s1, &s2, _state);
                sparsetransposecrs(&s2, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:654");
                ae_set_error_flag(errorflag, sparsegetnrows(&s1, _state)!=sparsegetncols(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:655");
                ae_set_error_flag(errorflag, sparsegetncols(&s1, _state)!=sparsegetnrows(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:656");
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s1, i, j, _state),sparseget(&s2, j, i, _state)), __FILE__, __LINE__, "testsparseunit.ap:661");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Increase problem sparcity and try one more time. 
                 * Stop after testing NZ=0.
                 */
                if( nz==0 )
                {
                    break;
                }
                nz = ae_minint(ae_round(nz*0.95, _state), nz-1, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_matrix a;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 10;
    m = 10;
    result = ae_false;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            uppercnt = 0;
            lowercnt = 0;
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1 )
                    {
                        inc(&uppercnt, _state);
                    }
                    if( j1<i1 )
                    {
                        inc(&lowercnt, _state);
                    }
                    a.ptr.pp_double[i1][j1] = i1+j1+(double)((i+j)*(m+n))/(double)2;
                    a.ptr.pp_double[i1][j1] = a.ptr.pp_double[i1][j1]+1;
                    sparseset(&s, i1, j1, i1+j1+(double)((i+j)*(m+n))/(double)2, _state);
                    sparseadd(&s, i1, j1, (double)(1), _state);
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            ae_set_error_flag(&result, sparsegetuppercount(&s, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:730");
            ae_set_error_flag(&result, sparsegetlowercount(&s, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:731");
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            ae_set_error_flag(&result, sparsegetuppercount(&s, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:750");
            ae_set_error_flag(&result, sparsegetlowercount(&s, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:751");
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:806");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:807");
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemv(&s0, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<m, __FILE__, __LINE__, "testsparseunit.ap:821");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:827");
                }
                
                /*
                 * Test SparseMTV
                 */
                ae_vector_set_length(&x0, m, _state);
                ae_vector_set_length(&x1, m, _state);
                for(j=0; j<=m-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemtv(&s0, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:841");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(j=0; j<=n-1; j++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,m-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:847");
                }
                
                /*
                 * Test SparseMV2
                 */
                if( m==n )
                {
                    ae_vector_set_length(&x0, n, _state);
                    ae_vector_set_length(&x1, n, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.p_double[j] = x0.ptr.p_double[j];
                    }
                    sparsemv2(&s0, &x0, &y0, &y1, _state);
                    ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:863");
                    ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:864");
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[j][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:870");
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:872");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_neq(sparseget(&sa, i, j, _state),a.ptr.pp_double[i][j]), __FILE__, __LINE__, "testsparseunit.ap:935");
                        ae_set_error_flag(&result, ae_fp_neq(sparseget(&s0, i, j, _state),a.ptr.pp_double[i][j]), __FILE__, __LINE__, "testsparseunit.ap:936");
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemm(&s0, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<m, __FILE__, __LINE__, "testsparseunit.ap:951");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:952");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:959");
                    }
                }
                
                /*
                 * Test SparseMTM
                 */
                ae_matrix_set_length(&x0, m, k, _state);
                ae_matrix_set_length(&x1, m, k, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemtm(&s0, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:974");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:975");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,m-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:982");
                    }
                }
                
                /*
                 * Test SparseMM2
                 */
                if( m==n )
                {
                    ae_matrix_set_length(&x0, n, k, _state);
                    ae_matrix_set_length(&x1, n, k, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                            x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                        }
                    }
                    sparsemm2(&s0, &x0, k, &y0, &y1, _state);
                    ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:999");
                    ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1000");
                    ae_set_error_flag(&result, y1.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1001");
                    ae_set_error_flag(&result, y1.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1002");
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1009");
                            v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1011");
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    double va;
    double vb;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1090");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1091");
                        ae_set_error_flag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1092");
                        ae_set_error_flag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1093");
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsesmv(&s0, isupper, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1116");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1122");
                }
                sparsesmv(&s1, isupper, &x0, &y1, _state);
                ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1125");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1131");
                }
                
                /*
                 * Test SparseVSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                vb = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        vb = vb+x1.ptr.p_double[i]*a.ptr.pp_double[i][j]*x1.ptr.p_double[j];
                    }
                }
                va = sparsevsmv(&s0, isupper, &x0, _state);
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1149");
                va = sparsevsmv(&s1, isupper, &x0, _state);
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1151");
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1232");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1233");
                        ae_set_error_flag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1234");
                        ae_set_error_flag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1235");
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMM
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsesmm(&s0, isupper, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1259");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1260");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1267");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_vector ey;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_matrix ea;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_bool isunit;
    ae_int_t optype;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&ey, 0, sizeof(ey));
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ey, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test sparseTRMV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A"
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                
                /*
                 * Test SparseTRMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1386");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1392");
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y1, _state);
                ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1395");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1401");
                }
            }
        }
    }
    
    /*
     * Test sparseTRSV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 1, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A" and EY = inv(EA)*x0
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                ae_vector_set_length(&ey, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    ey.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
                }
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &ey.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    x0.ptr.p_double[i] = v;
                    x1.ptr.p_double[i] = v;
                }
                
                /*
                 * Test SparseTRSV
                 */
                sparsetrsv(&s0, isupper, isunit, optype, &x0, _state);
                ae_set_error_flag(&result, x0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1485");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1489");
                }
                sparsetrsv(&s1, isupper, isunit, optype, &x1, _state);
                ae_set_error_flag(&result, x1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1491");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1495");
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_int_t mfigure;
    ae_int_t temp;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 20;
    m = 20;
    mfigure = 10;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 0, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Nulling all elements
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(0), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, -1*sparseget(&s, i1, j1, _state), _state);
                    }
                }
            }
            
            /*
             * Again initialization of the matrix and check new values
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 10;
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_vector_set_length(&ty, i, _state);
            ae_vector_set_length(&tyt, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                ty.ptr.p_double[i1] = (double)(0);
            }
            for(i1=0; i1<=j-1; i1++)
            {
                tyt.ptr.p_double[i1] = (double)(0);
            }
            ae_vector_set_length(&x0, j, _state);
            ae_vector_set_length(&x1, i, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            for(i1=0; i1<=i-1; i1++)
            {
                x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            
            /*
             * Consider two cases: square matrix, and non-square matrix
             */
            if( i!=j )
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                    }
                }
                
                /*
                 * Multiplication
                 */
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x1, &yt, _state);
                
                /*
                 * Check for MV-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MTV-result
                 */
                for(i1=0; i1<=j-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            else
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                    }
                }
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x0, &yt, _state);
                sparsemv2(&s, &x0, &y0, &yt0, _state);
                
                /*
                 * Check for MV2-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MV- and MTV-result by help MV2
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);

    
    /*
     *Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        
        /*
         * Prepare test problem
         */
        testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
        
        /*
         * Initialize temporaries
         */
        ae_vector_set_length(&ty, i, _state);
        ae_vector_set_length(&tyt, i, _state);
        ae_vector_set_length(&x0, i, _state);
        ae_vector_set_length(&x1, i, _state);
        for(i1=0; i1<=i-1; i1++)
        {
            ty.ptr.p_double[i1] = (double)(0);
            tyt.ptr.p_double[i1] = (double)(0);
            x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
        }
        
        /*
         * Searching true result for upper and lower triangles
         * of the matrix
         */
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=i1; j1<=i-1; j1++)
            {
                ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    ty.ptr.p_double[j1] = ty.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                }
            }
        }
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=0; j1<=i1; j1++)
            {
                tyt.ptr.p_double[i1] = tyt.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                }
            }
        }
        
        /*
         * Multiplication
         */
        sparsesmv(&s, ae_true, &x0, &y, _state);
        sparsesmv(&s, ae_false, &x1, &yt, _state);
        
        /*
         * Check for SMV-result
         */
        for(i1=0; i1<=i-1; i1++)
        {
            if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t kmax;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    ae_matrix y0;
    ae_matrix yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt0, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 32;
    m = 32;
    kmax = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            ae_matrix_set_length(&x0, j, kmax, _state);
            ae_matrix_set_length(&x1, i, kmax, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            ae_matrix_set_length(&ty, i, kmax, _state);
            ae_matrix_set_length(&tyt, j, kmax, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            if( i!=j )
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            else
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k=1; k<=kmax; k++)
            {
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Multiplication
                     */
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x1, k, &yt, _state);
                    
                    /*
                     * Check for MM-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MTM-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x0, k, &yt, _state);
                    sparsemm2(&s, &x0, k, &y0, &yt0, _state);
                    
                    /*
                     * Check for MM2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y0.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MV- and MTM-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater(ae_fabs(y0.ptr.pp_double[i1][j1]-y.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.pp_double[i1][j1]-yt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t k;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 32;
    k = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=k-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_matrix_set_length(&ty, i, j, _state);
            ae_matrix_set_length(&tyt, i, j, _state);
            ae_matrix_set_length(&x0, i, j, _state);
            ae_matrix_set_length(&x1, i, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            
            /*
             * Searching true result for upper and lower triangles
             * of the matrix
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=i1; j1<=i-1; j1++)
                    {
                        ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            ty.ptr.pp_double[j1][k1] = ty.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=i1; j1++)
                    {
                        tyt.ptr.pp_double[i1][k1] = tyt.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            
            /*
             * Multiplication
             */
            sparsesmm(&s, ae_true, &x0, j, &y, _state);
            sparsesmm(&s, ae_false, &x1, j, &yt, _state);
            
            /*
             * Check for SMM-result
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][k1]-ty.ptr.pp_double[i1][k1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][k1]-tyt.ptr.pp_double[i1][k1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    sparsematrix sss;
    ae_int_t n;
    ae_int_t m;
    ae_vector ner;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&ss, 0, sizeof(ss));
    memset(&sss, 0, sizeof(sss));
    memset(&ner, 0, sizeof(ner));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&ss, _state, ae_true);
    _sparsematrix_init(&sss, _state, ae_true);
    ae_vector_init(&ner, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 30;
    m = 30;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            ae_vector_set_length(&ner, i, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                if( i1<=j-3 )
                {
                    ner.ptr.p_int[i1] = 2;
                }
                else
                {
                    if( j-3<i1&&i1<=j-2 )
                    {
                        ner.ptr.p_int[i1] = 1;
                    }
                    else
                    {
                        ner.ptr.p_int[i1] = 0;
                    }
                }
            }
            sparsecreatecrs(i, j, &ner, &sss, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1&&j1<=i1+2 )
                    {
                        a.ptr.pp_double[i1][j1] = (double)(i1+j1+1);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                        sparseset(&sss, i1, j1, a.ptr.pp_double[i1][j1], _state);
                    }
                    else
                    {
                        a.ptr.pp_double[i1][j1] = (double)(0);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    
                    /*
                     * Check for SparseCreate
                     */
                    sparsecopy(&s, &ss, _state);
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for SparseCreateCRS
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    sparsecopy(&sss, &ss, _state);
                    a0 = sparseget(&sss, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            sparsecopy(&s, &ss, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    ae_vector cpy;
    ae_vector cpyt;
    ae_vector cpy0;
    ae_vector cpyt0;
    double eps;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&ss, 0, sizeof(ss));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    memset(&cpy, 0, sizeof(cpy));
    memset(&cpyt, 0, sizeof(cpyt));
    memset(&cpy0, 0, sizeof(cpy0));
    memset(&cpyt0, 0, sizeof(cpyt0));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&ss, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpy, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpy0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpyt0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 30;
    m = 30;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            for(mtype=0; mtype<=1; mtype++)
            {
                
                /*
                 * Prepare test problem
                 */
                testsparseunit_createrandom(i, j, -1, mtype, -1, -1, &a, &s, _state);
                sparsecopy(&s, &ss, _state);
                
                /*
                 * Initialize temporaries
                 */
                ae_vector_set_length(&ty, i, _state);
                ae_vector_set_length(&tyt, j, _state);
                for(i1=0; i1<=i-1; i1++)
                {
                    ty.ptr.p_double[i1] = (double)(0);
                }
                for(i1=0; i1<=j-1; i1++)
                {
                    tyt.ptr.p_double[i1] = (double)(0);
                }
                ae_vector_set_length(&x0, j, _state);
                ae_vector_set_length(&x1, i, _state);
                for(i1=0; i1<=j-1; i1++)
                {
                    x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                for(i1=0; i1<=i-1; i1++)
                {
                    x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x1, &yt, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x1, &cpyt, _state);
                    
                    /*
                     * Check for MV-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpy.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy.ptr.p_double[i1]-y.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV\n");
                                printf("Y[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("cpY[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MTV-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpyt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpyt.ptr.p_double[i1]-yt.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MTV\n");
                                printf("Yt[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpYt[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x0, &yt, _state);
                    sparsemv2(&s, &x0, &y0, &yt0, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x0, &cpyt, _state);
                    sparsemv2(&ss, &x0, &cpy0, &cpyt0, _state);
                    
                    /*
                     * Check for MV2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((((ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpy0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpyt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy0.ptr.p_double[i1]-y0.ptr.p_double[i1],(double)(0)))||ae_fp_neq(cpyt0.ptr.p_double[i1]-yt0.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV2\n");
                                printf("Y0[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MV- and MTV-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpy0.ptr.p_double[i1]-cpy.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpyt0.ptr.p_double[i1]-cpyt.ptr.p_double[i1], _state),eps) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV_MVT\n");
                                printf("Y0[%0d]=%0.5f; Y[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; Yt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f; cpY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f; cpYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function initializes sparse matrix generator, which is used to generate
a set of matrices with sequentially increasing sparsity.

PARAMETERS:
    M, N        -   matrix size. If M=0, then matrix is square N*N.
                    N and M must be small enough to store N*M dense matrix.
    MatKind     -   matrix properties:
                    * 0     -   general sparse (no structure)
                    * 1     -   general sparse, but diagonal is always present and non-zero
                    * 2     -   diagonally dominant, SPD
    Triangle    -   triangle being returned:
                    * +1    -   upper triangle
                    * -1    -   lower triangle
                    *  0    -   full matrix is returned
                    
OUTPUT PARAMETERS:
    G           -   generator
    A           -   matrix A in dense format
    SA          -   matrix A in sparse format (hash-table storage)
*************************************************************************/
static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state)
{

    _sparsegenerator_clear(g);

    g->n = n;
    g->m = m;
    g->matkind = matkind;
    g->triangle = triangle;
    hqrndrandomize(&g->rs, _state);
    ae_vector_set_length(&g->rcs.ia, 5+1, _state);
    ae_vector_set_length(&g->rcs.ra, 1+1, _state);
    g->rcs.stage = -1;
}


static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t nz;
    ae_int_t nzd;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_matrix_clear(da);
    _sparsematrix_clear(sa);

    
    /*
     * Reverse communication preparations
     * I know it looks ugly, but it works the same way
     * anywhere from C++ to Python.
     *
     * This code initializes locals by:
     * * random values determined during code
     *   generation - on first subroutine call
     * * values from previous call - on subsequent calls
     */
    if( g->rcs.stage>=0 )
    {
        n = g->rcs.ia.ptr.p_int[0];
        m = g->rcs.ia.ptr.p_int[1];
        nz = g->rcs.ia.ptr.p_int[2];
        nzd = g->rcs.ia.ptr.p_int[3];
        i = g->rcs.ia.ptr.p_int[4];
        j = g->rcs.ia.ptr.p_int[5];
        pnz = g->rcs.ra.ptr.p_double[0];
        v = g->rcs.ra.ptr.p_double[1];
    }
    else
    {
        n = 359;
        m = -58;
        nz = -919;
        nzd = -909;
        i = 81;
        j = 255;
        pnz = 74;
        v = -788;
    }
    if( g->rcs.stage==0 )
    {
        goto lbl_0;
    }
    if( g->rcs.stage==1 )
    {
        goto lbl_1;
    }
    
    /*
     * Routine body
     */
    n = g->n;
    if( g->m==0 )
    {
        m = n;
    }
    else
    {
        m = g->m;
    }
    ae_assert(m>0&&n>0, "GenerateNext: incorrect N/M", _state);
    
    /*
     * Generate general sparse matrix
     */
    if( g->matkind!=0 )
    {
        goto lbl_2;
    }
    nz = n*m;
lbl_4:
    if( ae_false )
    {
        goto lbl_5;
    }
    
    /*
     * Generate dense N*N matrix where probability of element
     * being non-zero is PNZ.
     */
    pnz = (double)nz/(double)(n*m);
    ae_matrix_set_length(&g->bufa, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, m, n, _state);
    sparsecreate(m, n, ae_round(pnz*m*n, _state), sa, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 0;
    goto lbl_rcomm;
lbl_0:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_5;
    }
    nz = nz/2;
    goto lbl_4;
lbl_5:
    result = ae_false;
    return result;
lbl_2:
    
    /*
     * Generate general sparse matrix with non-zero diagonal
     */
    if( g->matkind!=1 )
    {
        goto lbl_6;
    }
    ae_assert(n==m, "GenerateNext: non-square matrix for MatKind=1", _state);
    nz = n*n-n;
lbl_8:
    if( ae_false )
    {
        goto lbl_9;
    }
    
    /*
     * Generate dense N*N matrix where probability of non-diagonal element
     * being non-zero is PNZ.
     */
    if( n>1 )
    {
        pnz = (double)nz/(double)(n*n-n);
    }
    else
    {
        pnz = (double)(1);
    }
    ae_matrix_set_length(&g->bufa, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                do
                {
                    g->bufa.ptr.pp_double[i][i] = hqrnduniformr(&g->rs, _state)-0.5;
                }
                while(ae_fp_eq(g->bufa.ptr.pp_double[i][i],(double)(0)));
                g->bufa.ptr.pp_double[i][i] = g->bufa.ptr.pp_double[i][i]+1.5*ae_sign(g->bufa.ptr.pp_double[i][i], _state);
                continue;
            }
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, n, n, _state);
    sparsecreate(n, n, ae_round(pnz*(n*n-n)+n, _state), sa, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 1;
    goto lbl_rcomm;
lbl_1:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_9;
    }
    nz = nz/2;
    goto lbl_8;
lbl_9:
    result = ae_false;
    return result;
lbl_6:
    ae_assert(ae_false, "Assertion failed", _state);
    result = ae_false;
    return result;
    
    /*
     * Saving state
     */
lbl_rcomm:
    result = ae_true;
    g->rcs.ia.ptr.p_int[0] = n;
    g->rcs.ia.ptr.p_int[1] = m;
    g->rcs.ia.ptr.p_int[2] = nz;
    g->rcs.ia.ptr.p_int[3] = nzd;
    g->rcs.ia.ptr.p_int[4] = i;
    g->rcs.ia.ptr.p_int[5] = j;
    g->rcs.ra.ptr.p_double[0] = pnz;
    g->rcs.ra.ptr.p_double[1] = v;
    return result;
}


/*************************************************************************
This function creates random sparse matrix with some prescribed pattern.

INPUT PARAMETERS:
    M       -   number of rows
    N       -   number of columns
    PKind   -   sparsity pattern:
                *-1 = pattern is chosen at random as well as P0/P1
                * 0 = matrix with up to P0 non-zero elements at random locations
                      (however, actual number of non-zero elements can be
                      less than P0, and in fact can be zero)
                * 1 = band matrix with P0 non-zero elements below diagonal
                      and P1 non-zero element above diagonal
                * 2 = matrix with random number of contiguous non-zero 
                      elements in the each row
    CKind   -   creation type:
                *-1 = CKind is chosen at random
                * 0 = matrix is created in Hash-Table format and converted
                      to CRS representation
                * 1 = matrix is created in CRS format

OUTPUT PARAMETERS:
    DA      -   dense representation of A, array[M,N]
    SA      -   sparse representation of A, in CRS format

  -- ALGLIB PROJECT --
     Copyright 31.10.2011 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxpkind;
    ae_int_t maxckind;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_vector c0;
    ae_vector c1;
    ae_vector rowsizes;

    ae_frame_make(_state, &_frame_block);
    memset(&c0, 0, sizeof(c0));
    memset(&c1, 0, sizeof(c1));
    memset(&rowsizes, 0, sizeof(rowsizes));
    ae_matrix_clear(da);
    _sparsematrix_clear(sa);
    ae_vector_init(&c0, 0, DT_INT, _state, ae_true);
    ae_vector_init(&c1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&rowsizes, 0, DT_INT, _state, ae_true);

    maxpkind = 2;
    maxckind = 1;
    ae_assert(m>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(n>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(pkind>=-1&&pkind<=maxpkind, "CreateRandom: incorrect parameters", _state);
    ae_assert(ckind>=-1&&ckind<=maxckind, "CreateRandom: incorrect parameters", _state);
    if( pkind==-1 )
    {
        pkind = ae_randominteger(maxpkind+1, _state);
        if( pkind==0 )
        {
            p0 = ae_randominteger(m*n, _state);
        }
        if( pkind==1 )
        {
            p0 = ae_randominteger(ae_minint(m, n, _state), _state);
            p1 = ae_randominteger(ae_minint(m, n, _state), _state);
        }
    }
    if( ckind==-1 )
    {
        ckind = ae_randominteger(maxckind+1, _state);
    }
    if( pkind==0 )
    {
        
        /*
         * Matrix with elements at random locations
         */
        ae_matrix_set_length(da, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        if( ckind==0 )
        {
            
            /*
             * Create matrix in Hash format, convert to CRS
             */
            sparsecreate(m, n, 1, sa, _state);
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                if( ae_fp_greater(ae_randomreal(_state),0.5) )
                {
                    da->ptr.pp_double[i][j] = v;
                    sparseset(sa, i, j, v, _state);
                }
                else
                {
                    da->ptr.pp_double[i][j] = da->ptr.pp_double[i][j]+v;
                    sparseadd(sa, i, j, v, _state);
                }
            }
            sparseconverttocrs(sa, _state);
            ae_frame_leave(_state);
            return;
        }
        if( ckind==1 )
        {
            
            /*
             * Create matrix in CRS format
             */
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                da->ptr.pp_double[i][j] = v;
            }
            ae_vector_set_length(&rowsizes, m, _state);
            for(i=0; i<=m-1; i++)
            {
                rowsizes.ptr.p_int[i] = 0;
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        rowsizes.ptr.p_int[i] = rowsizes.ptr.p_int[i]+1;
                    }
                }
            }
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                    }
                }
            }
            ae_frame_leave(_state);
            return;
        }
        ae_assert(ae_false, "CreateRandom: internal error", _state);
    }
    if( pkind==1 )
    {
        
        /*
         * Band matrix
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=ae_maxint(i-p0, 0, _state); j<=ae_minint(i+p1, n-1, _state); j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
            rowsizes.ptr.p_int[i] = ae_maxint(ae_minint(i+p1, n-1, _state)-ae_maxint(i-p0, 0, _state)+1, 0, _state);
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        sparseconverttocrs(sa, _state);
        ae_frame_leave(_state);
        return;
    }
    if( pkind==2 )
    {
        
        /*
         * Matrix with one contiguous sequence of non-zero elements per row
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        ae_vector_set_length(&c0, m, _state);
        ae_vector_set_length(&c1, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            c0.ptr.p_int[i] = ae_randominteger(n, _state);
            c1.ptr.p_int[i] = c0.ptr.p_int[i]+ae_randominteger(n-c0.ptr.p_int[i]+1, _state);
            rowsizes.ptr.p_int[i] = c1.ptr.p_int[i]-c0.ptr.p_int[i];
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=c0.ptr.p_int[i]; j<=c1.ptr.p_int[i]-1; j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        sparseconverttocrs(sa, _state);
        ae_frame_leave(_state);
        return;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function does test for SparseEnumerate function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_enumeratetest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    double r;
    double v;
    ae_int_t ne;
    ae_int_t t0;
    ae_int_t t1;
    ae_int_t counter;
    ae_int_t c;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&spa, 0, sizeof(spa));
    memset(&a, 0, sizeof(a));
    memset(&ta, 0, sizeof(ta));
    _sparsematrix_init(&spa, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state, ae_true);

    r = 10.5;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ne = 0;
            
            /*
             * Create matrix with non-zero elements inside the region:
             * 0<=I<S.M and 0<=J<S.N
             */
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    ta.ptr.pp_bool[i][j] = ae_false;
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c = ae_randominteger(2, _state);
                    if( c==0 )
                    {
                        a.ptr.pp_double[i][j] = (double)(0);
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                        
                        /*
                         * Number of non-zero elements
                         */
                        ne = ne+1;
                    }
                }
            }
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                t0 = 0;
                t1 = 0;
                counter = 0;
                while(sparseenumerate(&spa, &t0, &t1, &i, &j, &v, _state))
                {
                    ta.ptr.pp_bool[i][j] = ae_true;
                    counter = counter+1;
                    if( ae_fp_neq(v,a.ptr.pp_double[i][j]) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check that all non-zero elements was enumerated
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j]&&ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
                if( ne!=counter )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function does test for SparseRewriteExisting function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    double spaval;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    ae_int_t c;
    ae_int_t ne;
    ae_int_t nr;
    double r;
    double v;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&spa, 0, sizeof(spa));
    memset(&a, 0, sizeof(a));
    memset(&ta, 0, sizeof(ta));
    _sparsematrix_init(&spa, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state, ae_true);

    r = 20.0;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                v = r*(2*ae_randomreal(_state)-1);
                
                /*
                 * Creating and filling of the matrix
                 */
                ne = 0;
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==0 )
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                        if( c==1 )
                        {
                            do
                            {
                                a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                            }
                            while(ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)));
                            sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                            ne = ne+1;
                        }
                        ta.ptr.pp_bool[i][j] = ae_false;
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                
                /*
                 * Rewrite some elements
                 */
                nr = 0;
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==1 )
                        {
                            ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                            if( ta.ptr.pp_bool[i][j] )
                            {
                                a.ptr.pp_double[i][j] = v;
                                nr = nr+1;
                            }
                        }
                    }
                }
                
                /*
                 * Now we have to be sure, that all changes had made correctly
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            spaval = sparseget(&spa, i, j, _state);
                            nr = nr-1;
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                if( nr!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Rewrite all elements
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            a.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            ne = ne-1;
                        }
                    }
                }
                if( ne!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spaval = sparseget(&spa, i, j, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                        else
                        {
                            if( ae_fp_neq(spaval,(double)(0))||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test  for  SparseGetRow/GetCompressedRow  function.   It  creates  random
dense and sparse matrices;  then  get every  row from  sparse matrix  and
compares it with every row in dense matrix.

On failure sets error flag, on success leaves it unchanged.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_int_t nz;
    ae_vector vals;
    ae_vector mrow;
    ae_vector colidx;
    ae_vector wasreturned;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&vals, 0, sizeof(vals));
    memset(&mrow, 0, sizeof(mrow));
    memset(&colidx, 0, sizeof(colidx));
    memset(&wasreturned, 0, sizeof(wasreturned));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vals, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&mrow, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&colidx, 0, DT_INT, _state, ae_true);
    ae_vector_init(&wasreturned, 0, DT_BOOL, _state, ae_true);

    msize = 15;
    nsize = 15;
    for(mtype=1; mtype<=2; mtype++)
    {
        for(m=1; m<=msize; m++)
        {
            for(n=1; n<=nsize; n++)
            {
                
                /*
                 * Skip nonrectangular SKS matrices - not supported
                 */
                if( mtype==2&&m!=n )
                {
                    continue;
                }
                
                /*
                 * Create "reference" and sparse matrices
                 */
                ae_matrix_set_length(&a, m, n, _state);
                sparsecreate(m, n, 1, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Choose matrix type to test
                 */
                if( mtype==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                else
                {
                    sparseconverttosks(&s, _state);
                }
                
                /*
                 * Test SparseGetRow()
                 */
                for(i=0; i<=m-1; i++)
                {
                    sparsegetrow(&s, i, &mrow, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(mrow.ptr.p_double[j],a.ptr.pp_double[i][j])||ae_fp_neq(mrow.ptr.p_double[j],sparseget(&s, i, j, _state)) )
                        {
                            ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3013");
                            ae_frame_leave(_state);
                            return;
                        }
                    }
                }
                
                /*
                 * Test SparseGetCompressedRow()
                 */
                ae_vector_set_length(&wasreturned, n, _state);
                for(i=0; i<=m-1; i++)
                {
                    sparsegetcompressedrow(&s, i, &colidx, &vals, &nz, _state);
                    if( nz<0||nz>n )
                    {
                        ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3027");
                        ae_frame_leave(_state);
                        return;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        wasreturned.ptr.p_bool[j] = ae_false;
                    }
                    for(j=0; j<=nz-1; j++)
                    {
                        if( colidx.ptr.p_int[j]<0||colidx.ptr.p_int[j]>n )
                        {
                            ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3036");
                            ae_frame_leave(_state);
                            return;
                        }
                        ae_set_error_flag(err, j>0&&colidx.ptr.p_int[j]<=colidx.ptr.p_int[j-1], __FILE__, __LINE__, "testsparseunit.ap:3039");
                        ae_set_error_flag(err, ae_fp_neq(vals.ptr.p_double[j],a.ptr.pp_double[i][colidx.ptr.p_int[j]])||ae_fp_neq(vals.ptr.p_double[j],sparseget(&s, i, colidx.ptr.p_int[j], _state)), __FILE__, __LINE__, "testsparseunit.ap:3040");
                        wasreturned.ptr.p_bool[colidx.ptr.p_int[j]] = ae_true;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(err, ae_fp_neq(a.ptr.pp_double[i][j],(double)(0))&&!wasreturned.ptr.p_bool[j], __FILE__, __LINE__, "testsparseunit.ap:3044");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Test for SparseConvert functions(isn't tested ConvertToCRS function). The
function  create random  dense and sparse  matrices  in CRS  format. Then
convert  sparse matrix  to some  format  by CONVERT_TO/COPY_TO  functions,
then it does  some modification in matrices and compares that marices are
identical.

NOTE:
    Result of the function assigned to variable CopyErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testconvertsm(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_vector ner;
    double tmp;
    ae_int_t i;
    ae_int_t j;
    ae_int_t vartf;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&cs, 0, sizeof(cs));
    memset(&a, 0, sizeof(a));
    memset(&ner, 0, sizeof(ner));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&cs, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ner, 0, DT_INT, _state, ae_true);

    msize = 15;
    nsize = 15;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            for(vartf=0; vartf<=2; vartf++)
            {
                ae_matrix_set_length(&a, m, n, _state);
                ae_vector_set_length(&ner, m, _state);
                for(i=0; i<=m-1; i++)
                {
                    ner.ptr.p_int[i] = 0;
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            ner.ptr.p_int[i] = ner.ptr.p_int[i]+1;
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Create sparse matrix
                 */
                sparsecreatecrs(m, n, &ner, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                    }
                }
                
                /*
                 * Set matrix type(we have to be sure that all formats
                 * converted correctly)
                 */
                i = ae_randominteger(2, _state);
                if( i==0 )
                {
                    sparseconverttohash(&s, _state);
                }
                if( i==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                
                /*
                 * Start test
                 */
                if( vartf==0 )
                {
                    sparseconverttohash(&s, _state);
                    sparsecopy(&s, &cs, _state);
                }
                if( vartf==1 )
                {
                    sparsecopytohash(&s, &cs, _state);
                }
                if( vartf==2 )
                {
                    sparsecopytocrs(&s, &cs, _state);
                }
                
                /*
                 * Change some elements in row
                 */
                if( vartf!=2 )
                {
                    for(i=0; i<=m-1; i++)
                    {
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = tmp;
                        sparseset(&cs, i, j, tmp, _state);
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = a.ptr.pp_double[i][j]+tmp;
                        sparseadd(&cs, i, j, tmp, _state);
                    }
                }
                
                /*
                 * Check that A is identical to S
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],sparseget(&cs, i, j, _state)) )
                        {
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test for  check/get  type functions.  The function  create sparse matrix,
converts it to desired type then check this type.

NOTE:
    Result of the function assigned to variable BasicErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&cs, 0, sizeof(cs));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&cs, _state, ae_true);

    msize = 5;
    nsize = 5;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            sparsecreate(m, n, 1, &s, _state);
            sparseconverttocrs(&s, _state);
            if( (sparseishash(&s, _state)||!sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparseconverttohash(&s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytocrs(&s, &cs, _state);
            if( (sparseishash(&cs, _state)||!sparseiscrs(&cs, _state))||sparsegetmatrixtype(&cs, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytohash(&cs, &s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


void _sparsegenerator_init(void* _p, ae_state *_state, ae_bool make_automatic)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_init(&p->bufa, 0, 0, DT_REAL, _state, make_automatic);
    _hqrndstate_init(&p->rs, _state, make_automatic);
    _rcommstate_init(&p->rcs, _state, make_automatic);
}


void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic)
{
    sparsegenerator *dst = (sparsegenerator*)_dst;
    sparsegenerator *src = (sparsegenerator*)_src;
    dst->n = src->n;
    dst->m = src->m;
    dst->matkind = src->matkind;
    dst->triangle = src->triangle;
    ae_matrix_init_copy(&dst->bufa, &src->bufa, _state, make_automatic);
    _hqrndstate_init_copy(&dst->rs, &src->rs, _state, make_automatic);
    _rcommstate_init_copy(&dst->rcs, &src->rcs, _state, make_automatic);
}


void _sparsegenerator_clear(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_clear(&p->bufa);
    _hqrndstate_clear(&p->rs);
    _rcommstate_clear(&p->rcs);
}


void _sparsegenerator_destroy(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_destroy(&p->bufa);
    _hqrndstate_destroy(&p->rs);
    _rcommstate_destroy(&p->rcs);
}



static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testgemv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static void testablasunit_testsymv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_testtrsv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_spectest(ae_bool* errorflag, ae_state *_state);
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static void testablasunit_testreflections(ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);
static void testablasunit_refrmatrixsymv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state);
static double testablasunit_refrmatrixsyvmv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state);





ae_bool testablas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n0;
    ae_int_t n1;
    ae_bool trsmerrors;
    ae_bool syrkerrors;
    ae_bool gemmerrors;
    ae_bool transerrors;
    ae_bool rank1errors;
    ae_bool gemverrors;
    ae_bool symverrors;
    ae_bool trsverrors;
    ae_bool reflerrors;
    ae_bool copyerrors;
    ae_bool specerrors;
    ae_bool waserrors;
    ae_matrix ra;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);

    trsmerrors = ae_false;
    syrkerrors = ae_false;
    gemmerrors = ae_false;
    transerrors = ae_false;
    rank1errors = ae_false;
    gemverrors = ae_false;
    symverrors = ae_false;
    trsverrors = ae_false;
    reflerrors = ae_false;
    copyerrors = ae_false;
    waserrors = ae_false;
    specerrors = ae_false;
    testablasunit_spectest(&specerrors, _state);
    trsmerrors = trsmerrors||testablasunit_testtrsm(1, 3*matrixtilesizea(_state)+1, _state);
    syrkerrors = syrkerrors||testablasunit_testsyrk(1, 3*matrixtilesizea(_state)+1, _state);
    gemmerrors = gemmerrors||testablasunit_testgemm(1, 3*matrixtilesizea(_state)+1, _state);
    transerrors = transerrors||testablasunit_testtrans(1, 3*matrixtilesizea(_state)+1, _state);
    rank1errors = rank1errors||testablasunit_testrank1(1, 3*matrixtilesizea(_state)+1, _state);
    gemverrors = gemverrors||testablasunit_testgemv(1, 3*matrixtilesizea(_state)+1, _state);
    copyerrors = copyerrors||testablasunit_testcopy(1, 3*matrixtilesizea(_state)+1, _state);
    testablasunit_testsymv(1, 3*matrixtilesizea(_state)+1, &symverrors, _state);
    testablasunit_testtrsv(1, 3*matrixtilesizea(_state)+1, &trsverrors, _state);
    testablasunit_testreflections(&reflerrors, _state);
    n0 = 6*matrixtilesizeb(_state);
    n1 = 6*matrixtilesizeb(_state);
    gemmerrors = gemmerrors||testablasunit_testgemm(n0, n1, _state);
    trsmerrors = trsmerrors||testablasunit_testtrsm(n0, n1, _state);
    syrkerrors = syrkerrors||testablasunit_testsyrk(n0, n1, _state);
    
    /*
     * report
     */
    waserrors = (((((((((trsmerrors||syrkerrors)||gemmerrors)||transerrors)||rank1errors)||gemverrors)||symverrors)||trsverrors)||reflerrors)||copyerrors)||specerrors;
    if( !silent )
    {
        printf("TESTING ABLAS\n");
        printf("LEVEL 3 FUNCTIONS:\n");
        printf("* TRSM                                   ");
        if( trsmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SYRK                                   ");
        if( syrkerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* GEMM                                   ");
        if( gemmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LEVEL 2 FUNCTIONS:\n");
        printf("* TRANS                                  ");
        if( transerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* RANK1                                  ");
        if( rank1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* GEMV                                   ");
        if( gemverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SYMV/SYVMV                             ");
        if( symverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* TRSV                                   ");
        if( trsverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* REFL                                   ");
        if( reflerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COPY                                   ");
        if( copyerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("SPECIAL TESTS                            ");
        if( specerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
?Matrix????TRSM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t optype;
    ae_int_t uppertype;
    ae_int_t unittype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_matrix refra;
    ae_matrix refrxl;
    ae_matrix refrxr;
    ae_matrix refca;
    ae_matrix refcxl;
    ae_matrix refcxr;
    ae_matrix ra;
    ae_matrix ca;
    ae_matrix rxr1;
    ae_matrix rxl1;
    ae_matrix cxr1;
    ae_matrix cxl1;
    ae_matrix rxr2;
    ae_matrix rxl2;
    ae_matrix cxr2;
    ae_matrix cxl2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrxl, 0, sizeof(refrxl));
    memset(&refrxr, 0, sizeof(refrxr));
    memset(&refca, 0, sizeof(refca));
    memset(&refcxl, 0, sizeof(refcxl));
    memset(&refcxr, 0, sizeof(refcxr));
    memset(&ra, 0, sizeof(ra));
    memset(&ca, 0, sizeof(ca));
    memset(&rxr1, 0, sizeof(rxr1));
    memset(&rxl1, 0, sizeof(rxl1));
    memset(&cxr1, 0, sizeof(cxr1));
    memset(&cxl1, 0, sizeof(cxl1));
    memset(&rxr2, 0, sizeof(rxr2));
    memset(&rxl2, 0, sizeof(rxl2));
    memset(&cxr2, 0, sizeof(cxr2));
    memset(&cxl2, 0, sizeof(cxl2));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrxl, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrxr, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcxl, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcxr, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rxr1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rxl1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cxr1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cxl1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rxr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rxl2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cxr2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cxl2, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = ae_sqr((double)(maxn), _state)*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random matrices whose upper
         * and lower triangle submatrices are non-degenerate
         * well-conditioned matrices.
         *
         * Matrix size is 2Mx2M (four copies of same MxM matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refra.ptr.pp_double[i][i] = (2*ae_randominteger(1, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i+m][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+m] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+m][j+m] = refra.ptr.pp_double[i][j];
            }
        }
        ae_matrix_set_length(&refca, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                refca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refca.ptr.pp_complex[i][i].x = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
            refca.ptr.pp_complex[i][i].y = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i+m][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+m] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+m][j+m] = refca.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Generate random XL/XR.
         *
         * XR is NxM matrix (matrix for 'Right' subroutines)
         * XL is MxN matrix (matrix for 'Left' subroutines)
         */
        ae_matrix_set_length(&refrxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refrxr.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refrxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refrxl.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refcxr.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxr.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refcxl.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxl.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra, 2*m, 2*m, _state);
        ae_matrix_set_length(&rxr1, n, m, _state);
        ae_matrix_set_length(&rxr2, n, m, _state);
        ae_matrix_set_length(&rxl1, m, n, _state);
        ae_matrix_set_length(&rxl2, m, n, _state);
        ae_matrix_set_length(&ca, 2*m, 2*m, _state);
        ae_matrix_set_length(&cxr1, n, m, _state);
        ae_matrix_set_length(&cxr2, n, m, _state);
        ae_matrix_set_length(&cxl1, m, n, _state);
        ae_matrix_set_length(&cxl2, m, n, _state);
        optype = ae_randominteger(3, _state);
        uppertype = ae_randominteger(2, _state);
        unittype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        aoffsi = m*aoffsitype;
        aoffsj = m*aoffsjtype;
        
        /*
         * copy A, XR, XL (fill unused parts with random garbage)
         */
        for(i=0; i<=2*m-1; i++)
        {
            for(j=0; j<=2*m-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+m)&&j>=aoffsj)&&j<aoffsj+m )
                {
                    ca.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ra.ptr.pp_double[i][j] = ae_randomreal(_state);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxr1.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    cxr2.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                    rxr2.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                }
                else
                {
                    cxr1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxr2.ptr.pp_complex[i][j] = cxr1.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxr2.ptr.pp_double[i][j] = rxr1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxl1.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    cxl2.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                    rxl2.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                }
                else
                {
                    cxl1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxl2.ptr.pp_complex[i][j] = cxl1.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxl2.ptr.pp_double[i][j] = rxl1.ptr.pp_double[i][j];
                }
            }
        }
        
        /*
         * Test CXR
         */
        cmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr2, xoffsi, xoffsj, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxr1.ptr.pp_complex[i][j],cxr2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test CXL
         */
        cmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl2, xoffsi, xoffsj, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxl1.ptr.pp_complex[i][j],cxl2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        if( optype<2 )
        {
            
            /*
             * Test RXR
             */
            rmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr2, xoffsi, xoffsj, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxr1.ptr.pp_double[i][j]-rxr2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * Test RXL
             */
            rmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl2, xoffsi, xoffsj, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxl1.ptr.pp_double[i][j]-rxl2.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SYRK tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t uppertype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t alphatype;
    ae_int_t betatype;
    ae_matrix refra;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcc;
    double alpha;
    double beta;
    ae_matrix ra1;
    ae_matrix ra2;
    ae_matrix ca1;
    ae_matrix ca2;
    ae_matrix rc;
    ae_matrix rct;
    ae_matrix cc;
    ae_matrix cct;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrc, 0, sizeof(refrc));
    memset(&refca, 0, sizeof(refca));
    memset(&refcc, 0, sizeof(refcc));
    memset(&ra1, 0, sizeof(ra1));
    memset(&ra2, 0, sizeof(ra2));
    memset(&ca1, 0, sizeof(ca1));
    memset(&ca2, 0, sizeof(ca2));
    memset(&rc, 0, sizeof(rc));
    memset(&rct, 0, sizeof(rct));
    memset(&cc, 0, sizeof(cc));
    memset(&cct, 0, sizeof(cct));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ra2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rct, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cct, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        k = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random Hermitian matrices,
         * RefRC/RefCC by random matrices
         *
         * RA/CA size is 2Nx2N (four copies of same NxN matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*n, 2*n, _state);
        ae_matrix_set_length(&refca, 2*n, 2*n, _state);
        for(i=0; i<=n-1; i++)
        {
            refra.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            refca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            for(j=i+1; j<=n-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refra.ptr.pp_double[j][i] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[j][i] = ae_c_conj(refca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refra.ptr.pp_double[i+n][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+n] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+n][j+n] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[i+n][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+n] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+n][j+n] = refca.ptr.pp_complex[i][j];
            }
        }
        ae_matrix_set_length(&refrc, n, k, _state);
        ae_matrix_set_length(&refcc, n, k, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ra2, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca2, 2*n, 2*n, _state);
        ae_matrix_set_length(&rc, n, k, _state);
        ae_matrix_set_length(&rct, k, n, _state);
        ae_matrix_set_length(&cc, n, k, _state);
        ae_matrix_set_length(&cct, k, n, _state);
        uppertype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        alphatype = ae_randominteger(2, _state);
        betatype = ae_randominteger(2, _state);
        aoffsi = n*aoffsitype;
        aoffsj = n*aoffsjtype;
        alpha = alphatype*(2*ae_randomreal(_state)-1);
        beta = betatype*(2*ae_randomreal(_state)-1);
        
        /*
         * copy A, C (fill unused parts with random garbage)
         */
        for(i=0; i<=2*n-1; i++)
        {
            for(j=0; j<=2*n-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+n)&&j>=aoffsj)&&j<aoffsj+n )
                {
                    ca1.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ca2.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                    ra2.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ca2.ptr.pp_complex[i][j] = ca1.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    ra2.ptr.pp_double[i][j] = ra1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    rc.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                    rct.ptr.pp_double[j][i] = refrc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                    cct.ptr.pp_complex[j][i] = refcc.ptr.pp_complex[i][j];
                }
                else
                {
                    rc.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rct.ptr.pp_double[j][i] = rc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cct.ptr.pp_complex[j][i] = cct.ptr.pp_complex[j][i];
                }
            }
        }
        
        /*
         * Test complex
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test old version of HERK (named SYRK)
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_fabs(ra1.ptr.pp_double[i][j]-ra2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
GEMM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t aoptype;
    ae_int_t aoptyper;
    ae_int_t boffsi;
    ae_int_t boffsj;
    ae_int_t boptype;
    ae_int_t boptyper;
    ae_int_t coffsi;
    ae_int_t coffsj;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcb;
    ae_matrix refcc;
    double alphar;
    double betar;
    ae_complex alphac;
    ae_complex betac;
    ae_matrix rc1;
    ae_matrix rc2;
    ae_matrix cc1;
    ae_matrix cc2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refrc, 0, sizeof(refrc));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    memset(&refcc, 0, sizeof(refcc));
    memset(&rc1, 0, sizeof(rc1));
    memset(&rc2, 0, sizeof(rc2));
    memset(&cc1, 0, sizeof(cc1));
    memset(&cc2, 0, sizeof(cc2));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rc1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rc2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cc1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cc2, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N/K in [1,MX] such that max(M,N,K)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        k = 1+ae_randominteger(mx, _state);
        i = ae_randominteger(3, _state);
        if( i==0 )
        {
            m = mx;
        }
        if( i==1 )
        {
            n = mx;
        }
        if( i==2 )
        {
            k = mx;
        }
        
        /*
         * Initialize A/B/C by random matrices with size (MaxN+1)*(MaxN+1)
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrc, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcc, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&rc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&rc2, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc2, maxn+1, maxn+1, _state);
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        aoptype = ae_randominteger(3, _state);
        aoptyper = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        boptype = ae_randominteger(3, _state);
        boptyper = ae_randominteger(2, _state);
        coffsi = ae_randominteger(2, _state);
        coffsj = ae_randominteger(2, _state);
        alphar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        betar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            alphac.x = 2*ae_randomreal(_state)-1;
            alphac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            alphac = ae_complex_from_i(0);
        }
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            betac.x = 2*ae_randomreal(_state)-1;
            betac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            betac = ae_complex_from_i(0);
        }
        
        /*
         * copy C
         */
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                rc1.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                rc2.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                cc1.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                cc2.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Test complex
         */
        cmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc1, coffsi, coffsj, _state);
        testablasunit_refcmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cc1.ptr.pp_complex[i][j],cc2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         */
        rmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc1, coffsi, coffsj, _state);
        testablasunit_refrmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_fabs(rc1.ptr.pp_double[i][j]-rc2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
transpose tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double v1;
    double v2;
    double threshold;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         * Generate random V1 and V2 which are used to fill
         * RefRB/RefCB with control values.
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        v1 = ae_randomreal(_state);
        v2 = ae_randomreal(_state);
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = i*v1+j*v2;
                refcb.ptr.pp_complex[i][j] = ae_complex_from_d(i*v1+j*v2);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        rmatrixtranspose(m, n, &refra, aoffsi, aoffsj, &refrb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-(v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-refra.ptr.pp_double[aoffsi+j-boffsj][aoffsj+i-boffsi], _state),threshold);
                }
            }
        }
        cmatrixtranspose(m, n, &refca, aoffsi, aoffsj, &refcb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub_d(refcb.ptr.pp_complex[i][j],v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refcb.ptr.pp_complex[i][j],refca.ptr.pp_complex[aoffsi+j-boffsj][aoffsj+i-boffsi]), _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
rank-1tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t uoffs;
    ae_int_t voffs;
    double threshold;
    double ralpha;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_vector ru;
    ae_vector rv;
    ae_vector cu;
    ae_vector cv;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    memset(&ru, 0, sizeof(ru));
    memset(&rv, 0, sizeof(rv));
    memset(&cu, 0, sizeof(cu));
    memset(&cv, 0, sizeof(cv));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&ru, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cu, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cv, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refrb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refcb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refrb.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&ru, 2*m, _state);
        ae_vector_set_length(&cu, 2*m, _state);
        for(i=0; i<=2*m-1; i++)
        {
            ru.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rv, 2*n, _state);
        ae_vector_set_length(&cv, 2*n, _state);
        for(i=0; i<=2*n-1; i++)
        {
            rv.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Generate random offsets of all operands and random coefficients.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        uoffs = ae_randominteger(m, _state);
        voffs = ae_randominteger(n, _state);
        ralpha = ae_randomreal(_state)-0.5;
        
        /*
         * Test CMatrixRank1() and deprecated RMatrixRank1()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refca.ptr.pp_complex[i][j] = refcb.ptr.pp_complex[i][j];
            }
        }
        cmatrixrank1(m, n, &refca, aoffsi, aoffsj, &cu, uoffs, &cv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],refcb.ptr.pp_complex[i][j]), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],ae_c_add(refcb.ptr.pp_complex[i][j],ae_c_mul(cu.ptr.p_complex[i-aoffsi+uoffs],cv.ptr.p_complex[j-aoffsj+voffs]))), _state),threshold);
                }
            }
        }
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = refrb.ptr.pp_double[i][j];
            }
        }
        rmatrixrank1(m, n, &refra, aoffsi, aoffsj, &ru, uoffs, &rv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-refrb.ptr.pp_double[i][j], _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-(refrb.ptr.pp_double[i][j]+ru.ptr.p_double[i-aoffsi+uoffs]*rv.ptr.p_double[j-aoffsj+voffs]), _state),threshold);
                }
            }
        }
        
        /*
         * Test modern RMatrixGER()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = refrb.ptr.pp_double[i][j];
            }
        }
        rmatrixger(m, n, &refra, aoffsi, aoffsj, ralpha, &ru, uoffs, &rv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    ae_set_error_flag(&result, ae_fp_neq(ae_fabs(refra.ptr.pp_double[i][j]-refrb.ptr.pp_double[i][j], _state),0.0), __FILE__, __LINE__, "testablasunit.ap:1132");
                }
                else
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-(refrb.ptr.pp_double[i][j]+ralpha*ru.ptr.p_double[i-aoffsi+uoffs]*rv.ptr.p_double[j-aoffsj+voffs]), _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1134");
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
MV tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testgemv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_int_t yoffs;
    ae_int_t opca;
    ae_int_t opra;
    double threshold;
    double ralpha;
    double rbeta;
    double rv1;
    double rv2;
    ae_complex cv1;
    ae_complex cv2;
    ae_matrix refra;
    ae_matrix refca;
    ae_vector rx;
    ae_vector ry;
    ae_vector cx;
    ae_vector cy;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refca, 0, sizeof(refca));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&cx, 0, sizeof(cx));
    memset(&cy, 0, sizeof(cy));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cx, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cy, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&cx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        ae_vector_set_length(&cy, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        yoffs = ae_randominteger(maxn, _state);
        opca = ae_randominteger(3, _state);
        opra = ae_randominteger(2, _state);
        ralpha = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        rbeta = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        
        /*
         * Test CMatrixMV and deprecated RMatrixMV
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            cy.ptr.p_complex[i] = ae_complex_from_i(i);
        }
        cmatrixmv(m, n, &refca, aoffsi, aoffsj, opca, &cx, xoffs, &cy, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_c_neq_d(cy.ptr.p_complex[i],(double)(i));
            }
            else
            {
                cv1 = cy.ptr.p_complex[i];
                cv2 = ae_complex_from_d(0.0);
                if( opca==0 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi+i-yoffs][aoffsj], 1, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opca==1 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                if( opca==2 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "Conj", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cv1,cv2), _state),threshold);
            }
        }
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
        }
        rmatrixmv(m, n, &refra, aoffsi, aoffsj, opra, &rx, xoffs, &ry, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_fp_neq(ry.ptr.p_double[i],(double)(i));
            }
            else
            {
                rv1 = ry.ptr.p_double[i];
                rv2 = (double)(0);
                if( opra==0 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi+i-yoffs][aoffsj], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opra==1 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi][aoffsj+i-yoffs], refra.stride, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold);
            }
        }
        
        /*
         * Test modern RMatrixGEMV()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
        }
        rmatrixgemv(m, n, ralpha, &refra, aoffsi, aoffsj, opra, &rx, xoffs, rbeta, &ry, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                ae_set_error_flag(&result, ae_fp_neq(ry.ptr.p_double[i],(double)(i)), __FILE__, __LINE__, "testablasunit.ap:1282");
            }
            else
            {
                rv1 = ry.ptr.p_double[i];
                rv2 = (double)(0);
                if( opra==0 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi+i-yoffs][aoffsj], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opra==1 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi][aoffsj+i-yoffs], refra.stride, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsi,aoffsi+n-1));
                }
                rv2 = rbeta*i+ralpha*rv2;
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1292");
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SYMV/SYVMV tests

Sets error flag on failure, ignores on success.
*************************************************************************/
static void testablasunit_testsymv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_int_t yoffs;
    ae_bool isuppera;
    double threshold;
    double ralpha;
    double rbeta;
    double rv1;
    double rv2;
    ae_matrix refra;
    ae_vector rx;
    ae_vector ry;
    ae_vector rz;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&rz, 0, sizeof(rz));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rz, 0, DT_REAL, _state, ae_true);

    threshold = 1000*ae_machineepsilon;
    for(n=minn; n<=maxn; n++)
    {
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        ae_vector_set_length(&rz, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        yoffs = ae_randominteger(maxn, _state);
        isuppera = ae_fp_greater(ae_randomreal(_state),0.5);
        ralpha = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        rbeta = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        
        /*
         * Test RMatrixSYMV()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
            rz.ptr.p_double[i] = (double)(i);
        }
        rmatrixsymv(n, ralpha, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, rbeta, &ry, yoffs, _state);
        testablasunit_refrmatrixsymv(n, ralpha, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, rbeta, &rz, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+n )
            {
                ae_set_error_flag(errorflag, ae_fp_neq(ry.ptr.p_double[i],(double)(i)), __FILE__, __LINE__, "testablasunit.ap:1380");
            }
            else
            {
                ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(ry.ptr.p_double[i]-rz.ptr.p_double[i], _state),threshold*maxreal3(ae_fabs(ry.ptr.p_double[i], _state), ae_fabs(rz.ptr.p_double[i], _state), 1.0, _state)), __FILE__, __LINE__, "testablasunit.ap:1382");
            }
        }
        
        /*
         * Test RMatrixSYVMV()
         */
        rv1 = rmatrixsyvmv(n, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, &ry, _state);
        rv2 = testablasunit_refrmatrixsyvmv(n, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, _state);
        ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold*maxreal3(ae_fabs(rv1, _state), ae_fabs(rv2, _state), 1.0, _state)), __FILE__, __LINE__, "testablasunit.ap:1396");
    }
    ae_frame_leave(_state);
}


/*************************************************************************
TRSV tests

Sets error flag on failure, ignores on success.
*************************************************************************/
static void testablasunit_testtrsv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_bool isuppera;
    ae_bool isunita;
    ae_int_t opa;
    double threshold;
    ae_matrix refra;
    ae_matrix ea;
    ae_vector rx;
    ae_vector ry;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&ea, 0, sizeof(ea));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);

    for(n=minn; n<=maxn; n++)
    {
        
        /*
         * Decreased threshold because of ill-conditioning of randomly generated matrices
         */
        threshold = 1.0E-6*(1+n);
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by sparse random vector with size (MaxN+MaxN) (sparsity is important to test some branches of algorithm)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = (2*ae_randomreal(_state)-1)*ae_randominteger(3, _state);
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         *
         * NOTE: in order to improve conditioning properties we add 10*Identity
         *       to purported diagonal of A
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        isuppera = ae_fp_greater(ae_randomreal(_state),0.5);
        isunita = ae_fp_greater(ae_randomreal(_state),0.5);
        opa = ae_randominteger(2, _state);
        for(i=0; i<=n-1; i++)
        {
            refra.ptr.pp_double[aoffsi+i][aoffsj+i] = refra.ptr.pp_double[aoffsi+i][aoffsj+i]+10;
        }
        
        /*
         * Test RMatrixTRSV():
         * * check that elements of RX beyond [XOffs,XOffs+N-1] are unchanged
         * * calculate RX:=TRSV(RX)
         * * extract effective A from RefRA to EA=array[N,N]
         * * compare product EA*RX, compare with copy of RX stored in RY
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = rx.ptr.p_double[i];
        }
        rmatrixtrsv(n, &refra, aoffsi, aoffsj, isuppera, isunita, opa, &rx, xoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<xoffs||i>xoffs+n-1 )
            {
                ae_set_error_flag(errorflag, ae_fp_neq(rx.ptr.p_double[i],ry.ptr.p_double[i]), __FILE__, __LINE__, "testablasunit.ap:1480");
            }
        }
        ae_matrix_set_length(&ea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = refra.ptr.pp_double[aoffsi+i][aoffsj+j];
                if( (j<i&&isuppera)||(j>i&&!isuppera) )
                {
                    v = (double)(0);
                }
                if( isunita&&i==j )
                {
                    v = (double)(1);
                }
                if( opa==0 )
                {
                    ea.ptr.pp_double[i][j] = v;
                }
                else
                {
                    ea.ptr.pp_double[j][i] = v;
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(0,n-1));
            ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(v-ry.ptr.p_double[xoffs+i], _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1503");
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Special test.
On failure sets error flag, on success does not change it.
*************************************************************************/
static void testablasunit_spectest(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix emptyr2;
    ae_matrix emptyc2;
    ae_matrix outputr2;
    ae_matrix outputc2;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t pass;

    ae_frame_make(_state, &_frame_block);
    memset(&emptyr2, 0, sizeof(emptyr2));
    memset(&emptyc2, 0, sizeof(emptyc2));
    memset(&outputr2, 0, sizeof(outputr2));
    memset(&outputc2, 0, sizeof(outputc2));
    ae_matrix_init(&emptyr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&emptyc2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&outputr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&outputc2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test that SYRK, GEMM and TRSM does not reference empty argument at all.
     *
     * In order to perform this test we pass empty (unallocated) matrix
     * with large offset; incorrect implementation will crash on such data.
     */
    n = 128+ae_randominteger(65, _state)-32;
    ae_matrix_set_length(&outputr2, n, n, _state);
    ae_matrix_set_length(&outputc2, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            outputr2.ptr.pp_double[i][j] = (double)(0);
            outputc2.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(pass=0; pass<=10; pass++)
    {
        rmatrixgemm(n, n, 0, 1.0, &emptyr2, 35345, 23453, ae_randominteger(2, _state), &emptyr2, 74764, 26845, ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        rmatrixgemm(n, n, n, 0.0, &emptyr2, 35345, 23453, ae_randominteger(2, _state), &emptyr2, 74764, 26845, ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        cmatrixgemm(n, n, 0, ae_complex_from_d(1.0), &emptyc2, 35345, 23453, ae_randominteger(3, _state), &emptyc2, 74764, 26845, ae_randominteger(3, _state), ae_complex_from_d(1.0+ae_randominteger(2, _state)), &outputc2, 0, 0, _state);
        cmatrixgemm(n, n, n, ae_complex_from_d(0.0), &emptyc2, 35345, 23453, ae_randominteger(3, _state), &emptyc2, 74764, 26845, ae_randominteger(3, _state), ae_complex_from_d(1.0+ae_randominteger(2, _state)), &outputc2, 0, 0, _state);
        rmatrixsyrk(n, 0, 1.0, &emptyr2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        rmatrixsyrk(n, n, 0.0, &emptyr2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        cmatrixherk(n, 0, 1.0, &emptyc2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputc2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        cmatrixherk(n, n, 0.0, &emptyc2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputc2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        rmatrixrighttrsm(0, 0, &emptyr2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        rmatrixlefttrsm(0, 0, &emptyr2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        cmatrixrighttrsm(0, 0, &emptyc2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), &outputc2, 0, 0, _state);
        cmatrixlefttrsm(0, 0, &emptyc2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), &outputc2, 0, 0, _state);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
COPY tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double threshold;
    ae_matrix ra;
    ae_matrix rb;
    ae_matrix ca;
    ae_matrix cb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&rb, 0, sizeof(rb));
    memset(&ca, 0, sizeof(ca));
    memset(&cb, 0, sizeof(cb));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&ra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&ca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&rb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&cb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                rb.ptr.pp_double[i][j] = (double)(1+2*i+3*j);
                cb.ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        boffsi = ae_randominteger(maxn, _state);
        boffsj = ae_randominteger(maxn, _state);
        cmatrixcopy(m, n, &ca, aoffsi, aoffsj, &cb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_c_neq_d(cb.ptr.pp_complex[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[aoffsi+i-boffsi][aoffsj+j-boffsj],cb.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
        }
        rmatrixcopy(m, n, &ra, aoffsi, aoffsj, &rb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_fp_neq(rb.ptr.pp_double[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(ra.ptr.pp_double[aoffsi+i-boffsi][aoffsj+j-boffsj]-rb.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


static void testablasunit_testreflections(ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    double tmp;
    double beta;
    double tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    double threshold;
    ae_int_t tasktype;
    double xscale;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&v, 0, sizeof(v));
    memset(&work, 0, sizeof(work));
    memset(&h, 0, sizeof(h));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c, 0, sizeof(c));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&v, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);

    passcount = 10;
    threshold = 100*ae_machineepsilon;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=10; n++)
        {
            for(m=1; m<=10; m++)
            {
                
                /*
                 * Task
                 */
                n = 1+ae_randominteger(10, _state);
                m = 1+ae_randominteger(10, _state);
                maxmn = ae_maxint(m, n, _state);
                
                /*
                 * Initialize
                 */
                ae_vector_set_length(&x, maxmn+1, _state);
                ae_vector_set_length(&v, maxmn+1, _state);
                ae_vector_set_length(&work, maxmn+1, _state);
                ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
                
                /*
                 * GenerateReflection, three tasks are possible:
                 * * random X
                 * * zero X
                 * * non-zero X[1], all other are zeros
                 * * random X, near underflow scale
                 * * random X, near overflow scale
                 */
                for(tasktype=0; tasktype<=4; tasktype++)
                {
                    xscale = (double)(1);
                    if( tasktype==0 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    if( tasktype==1 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==2 )
                    {
                        x.ptr.p_double[1] = 2*ae_randomreal(_state)-1;
                        for(i=2; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==3 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (ae_randominteger(21, _state)-10)*ae_minrealnumber;
                        }
                        xscale = 10*ae_minrealnumber;
                    }
                    if( tasktype==4 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (2*ae_randomreal(_state)-1)*ae_maxrealnumber;
                        }
                        xscale = ae_maxrealnumber;
                    }
                    ae_v_move(&v.ptr.p_double[1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                    generatereflection(&v, n, &tau, _state);
                    beta = v.ptr.p_double[1];
                    v.ptr.p_double[1] = (double)(1);
                    for(i=1; i<=n; i++)
                    {
                        for(j=1; j<=n; j++)
                        {
                            if( i==j )
                            {
                                h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                            else
                            {
                                h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                        }
                    }
                    err = (double)(0);
                    for(i=1; i<=n; i++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                        if( i==1 )
                        {
                            err = ae_maxreal(err, ae_fabs(tmp-beta, _state), _state);
                        }
                        else
                        {
                            err = ae_maxreal(err, ae_fabs(tmp, _state), _state);
                        }
                    }
                    meg = ae_maxreal(meg, err/xscale, _state);
                }
                
                /*
                 * ApplyReflectionFromTheLeft
                 */
                for(i=1; i<=m; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, m, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=m; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &a.ptr.pp_double[1][j], a.stride, ae_v_len(1,m));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mel = ae_maxreal(mel, err, _state);
                
                /*
                 * ApplyReflectionFromTheRight
                 */
                for(i=1; i<=n; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, n, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&a.ptr.pp_double[i][1], 1, &h.ptr.pp_double[1][j], h.stride, ae_v_len(1,n));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mer = ae_maxreal(mer, err, _state);
            }
        }
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_double[i] = ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1);
    }
    generatereflection(&v, 10, &tau, _state);
    
    /*
     * Result
     */
    ae_set_error_flag(errorflag, (ae_fp_greater(meg,threshold)||ae_fp_greater(mel,threshold))||ae_fp_greater(mer,threshold), __FILE__, __LINE__, "testablasunit.ap:1888");
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2+i][j2], 1, "N", ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&tx.ptr.p_complex[0], 1, "N", &a2.ptr.pp_complex[0][j], a2.stride, "N", ae_v_len(0,n-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2][j2+j], x->stride, "N", ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vc = ae_v_cdotproduct(&a2.ptr.pp_complex[i][0], 1, "N", &tx.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2+i][j2], 1, ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vr = ae_v_dotproduct(&tx.ptr.p_double[0], 1, &a2.ptr.pp_double[0][j], a2.stride, ae_v_len(0,n-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2][j2+j], x->stride, ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vr = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &tx.ptr.p_double[0], 1, ae_v_len(0,m-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i+1<j )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j+1<n )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state, ae_true);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_complex_from_i(0);
                }
                else
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_c_mul_d(c->ptr.pp_complex[i+ic][j+jc],beta);
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_complex_from_i(0);
            if( k>0 )
            {
                vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &ae.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,k-1));
            }
            vc = ae_c_mul_d(vc,alpha);
            if( isupper&&j>=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    double vr;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state, ae_true);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_double[i+ic][j+jc] = (double)(0);
                }
                else
                {
                    c->ptr.pp_double[i+ic][j+jc] = c->ptr.pp_double[i+ic][j+jc]*beta;
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vr = (double)(0);
            if( k>0 )
            {
                vr = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &ae.ptr.pp_double[j][0], 1, ae_v_len(0,k-1));
            }
            vr = alpha*vr;
            if( isupper&&j>=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    memset(&be, 0, sizeof(be));
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&be, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+j][ja+i];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+j][jb+i];
            }
            if( optypeb==2 )
            {
                be.ptr.pp_complex[i][j] = ae_c_conj(b->ptr.pp_complex[ib+j][jb+i], _state);
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &be.ptr.pp_complex[0][j], be.stride, "N", ae_v_len(0,k-1));
            vc = ae_c_mul(alpha,vc);
            if( ae_c_neq_d(beta,(double)(0)) )
            {
                vc = ae_c_add(vc,ae_c_mul(beta,c->ptr.pp_complex[ic+i][jc+j]));
            }
            c->ptr.pp_complex[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    double vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    memset(&be, 0, sizeof(be));
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&be, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+j][jb+i];
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &be.ptr.pp_double[0][j], be.stride, ae_v_len(0,k-1));
            vc = alpha*vc;
            if( ae_fp_neq(beta,(double)(0)) )
            {
                vc = vc+beta*c->ptr.pp_double[ic+i][jc+j];
            }
            c->ptr.pp_double[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYMV,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refrmatrixsymv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_matrix b;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Convert problem to traditional dense GEMV
     */
    ae_matrix_set_length(&b, n, n, _state);
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    
    /*
     * Calculate result
     */
    for(i=0; i<=n-1; i++)
    {
        v = beta*y->ptr.p_double[iy+i];
        for(j=0; j<=n-1; j++)
        {
            v = v+alpha*b.ptr.pp_double[i][j]*x->ptr.p_double[ix+j];
        }
        y->ptr.p_double[iy+i] = v;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYVMV,
ALGLIB subroutine
*************************************************************************/
static double testablasunit_refrmatrixsyvmv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix b;
    double result;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Convert problem to traditional dense GEMV
     */
    ae_matrix_set_length(&b, n, n, _state);
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    
    /*
     * Calculate result
     */
    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            result = result+x->ptr.p_double[ix+i]*b.ptr.pp_double[i][j]*x->ptr.p_double[ix+j];
        }
    }
    ae_frame_leave(_state);
    return result;
}








ae_bool testcreflections(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    ae_complex tmp;
    ae_complex beta;
    ae_complex tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&v, 0, sizeof(v));
    memset(&work, 0, sizeof(work));
    memset(&h, 0, sizeof(h));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c, 0, sizeof(c));
    ae_vector_init(&x, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&v, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&work, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = 1000*ae_machineepsilon;
    passcount = 1000;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Task
         */
        n = 1+ae_randominteger(10, _state);
        m = 1+ae_randominteger(10, _state);
        maxmn = ae_maxint(m, n, _state);
        
        /*
         * Initialize
         */
        ae_vector_set_length(&x, maxmn+1, _state);
        ae_vector_set_length(&v, maxmn+1, _state);
        ae_vector_set_length(&work, maxmn+1, _state);
        ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
        
        /*
         * GenerateReflection
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        err = (double)(0);
        for(i=1; i<=n; i++)
        {
            tmp = ae_v_cdotproduct(&h.ptr.pp_complex[1][i], h.stride, "Conj", &x.ptr.p_complex[1], 1, "N", ae_v_len(1,n));
            if( i==1 )
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(tmp,beta), _state), _state);
            }
            else
            {
                err = ae_maxreal(err, ae_c_abs(tmp, _state), _state);
            }
        }
        err = ae_maxreal(err, ae_fabs(beta.y, _state), _state);
        meg = ae_maxreal(meg, err, _state);
        
        /*
         * ApplyReflectionFromTheLeft
         */
        for(i=1; i<=m; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, m, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=m; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&h.ptr.pp_complex[i][1], 1, "N", &a.ptr.pp_complex[1][j], a.stride, "N", ae_v_len(1,m));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mel = ae_maxreal(mel, err, _state);
        
        /*
         * ApplyReflectionFromTheRight
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&a.ptr.pp_complex[i][1], 1, "N", &h.ptr.pp_complex[1][j], h.stride, "N", ae_v_len(1,n));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mer = ae_maxreal(mer, err, _state);
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_complex[i] = ae_complex_from_d(ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1));
    }
    complexgeneratereflection(&v, 10, &tau, _state);
    
    /*
     * report
     */
    waserrors = (ae_fp_greater(meg,threshold)||ae_fp_greater(mel,threshold))||ae_fp_greater(mer,threshold);
    if( !silent )
    {
        printf("TESTING COMPLEX REFLECTIONS\n");
        printf("Generate error:                          %5.3e\n",
            (double)(meg));
        printf("Apply(L) error:                          %5.3e\n",
            (double)(mel));
        printf("Apply(R) error:                          %5.3e\n",
            (double)(mer));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        printf("Overflow crash test:                     PASSED\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static ae_int_t testmatgenunit_maxsvditerations = 60;
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state);
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state);
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state);
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_testeult(ae_state *_state);
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state);
static double testmatgenunit_extsign(double a, double b, ae_state *_state);
static double testmatgenunit_mymax(double a, double b, ae_state *_state);
static double testmatgenunit_pythag(double a, double b, ae_state *_state);





ae_bool testmatgen(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_matrix u;
    ae_matrix v;
    ae_matrix ca;
    ae_matrix cb;
    ae_matrix r1;
    ae_matrix r2;
    ae_matrix c1;
    ae_matrix c2;
    ae_vector w;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double cond;
    double threshold;
    double vt;
    ae_complex ct;
    double minw;
    double maxw;
    ae_bool serr;
    ae_bool herr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool eulerr;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&u, 0, sizeof(u));
    memset(&v, 0, sizeof(v));
    memset(&ca, 0, sizeof(ca));
    memset(&cb, 0, sizeof(cb));
    memset(&r1, 0, sizeof(r1));
    memset(&r2, 0, sizeof(r2));
    memset(&c1, 0, sizeof(c1));
    memset(&c2, 0, sizeof(c2));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    rerr = ae_false;
    cerr = ae_false;
    serr = ae_false;
    herr = ae_false;
    spderr = ae_false;
    hpderr = ae_false;
    eulerr = ae_false;
    waserrors = ae_false;
    maxn = 20;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Testing orthogonal
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            ae_matrix_set_length(&r1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&r2, 2*n-1+1, n-1+1, _state);
            ae_matrix_set_length(&c1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&c2, 2*n-1+1, n-1+1, _state);
            
            /*
             * Random orthogonal, real
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            rmatrixrndorthogonal(n, &a, _state);
            rmatrixrndorthogonal(n, &b, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            
            /*
             * Random orthogonal, complex
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            cmatrixrndorthogonal(n, &ca, _state);
            cmatrixrndorthogonal(n, &cb, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
            
            /*
             * From the right real tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheright(&a, n, n, _state);
            rmatrixrndorthogonalfromtheright(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r2.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r2.ptr.pp_double[i+n][j] = r2.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheright(&r2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r2.ptr.pp_double[i+n][j]-r2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * From the left real tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheleft(&a, n, n, _state);
            rmatrixrndorthogonalfromtheleft(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r1.ptr.pp_double[i][j+n] = r1.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheleft(&r1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r1.ptr.pp_double[i][j]-r1.ptr.pp_double[i][j+n], _state),threshold);
                }
            }
            
            /*
             * From the right complex tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheright(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheright(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c2.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c2.ptr.pp_complex[i+n][j] = c2.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheright(&c2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c2.ptr.pp_complex[i+n][j],c2.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
            
            /*
             * From the left complex tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheleft(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheleft(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c1.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c1.ptr.pp_complex[i][j+n] = c1.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheleft(&c1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c1.ptr.pp_complex[i][j],c1.ptr.pp_complex[i][j+n]), _state),threshold);
                }
            }
        }
    }
    
    /*
     * Testing GCond
     */
    for(n=2; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * real test
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            rmatrixrndcond(n, cond, &a, _state);
            ae_matrix_set_length(&b, n+1, n+1, _state);
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    b.ptr.pp_double[i][j] = a.ptr.pp_double[i-1][j-1];
                }
            }
            if( testmatgenunit_obsoletesvddecomposition(&b, n, n, &w, &v, _state) )
            {
                maxw = w.ptr.p_double[1];
                minw = w.ptr.p_double[1];
                for(i=2; i<=n; i++)
                {
                    if( ae_fp_greater(w.ptr.p_double[i],maxw) )
                    {
                        maxw = w.ptr.p_double[i];
                    }
                    if( ae_fp_less(w.ptr.p_double[i],minw) )
                    {
                        minw = w.ptr.p_double[i];
                    }
                }
                vt = maxw/minw/cond;
                if( ae_fp_greater(ae_fabs(ae_log(vt, _state), _state),ae_log(1+threshold, _state)) )
                {
                    rerr = ae_true;
                }
            }
        }
    }
    
    /*
     * Symmetric/SPD
     * N = 2 .. 30
     */
    for(n=2; n<=maxn; n++)
    {
        
        /*
         * SPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            spdmatrixrndcond(n, cond, &a, _state);
            
            /*
             * test condition number
             */
            spderr = spderr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test SPD
             */
            spderr = spderr||!testmatgenunit_isspd(&a, n, ae_true, _state);
            
            /*
             * test that A is symmetic
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    spderr = spderr||ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2d(&b, _state);
            spdmatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spderr = spderr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * HPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hpdmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test HPD
             */
            hpderr = hpderr||!testmatgenunit_ishpd(&ca, n, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hpdmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        hpderr = hpderr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
        
        /*
         * Symmetric matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * test condition number
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            smatrixrndcond(n, cond, &a, _state);
            serr = serr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test for difference between A and B
             */
            testmatgenunit_unset2d(&b, _state);
            smatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        serr = serr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * Hermitian matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    herr = herr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        herr = herr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
    }
    
    /*
     * Test for symmetric matrices
     */
    eulerr = testmatgenunit_testeult(_state);
    
    /*
     * report
     */
    waserrors = (((((rerr||cerr)||serr)||spderr)||herr)||hpderr)||eulerr;
    if( !silent )
    {
        printf("TESTING MATRIX GENERATOR\n");
        printf("REAL TEST:                               ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TEST:                            ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SYMMETRIC TEST:                          ");
        if( !serr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HERMITIAN TEST:                          ");
        if( !herr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD TEST:                                ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD TEST:                                ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("TEST FOR SYMMETRIC MATRICES:             ");
        if( !eulerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_double[0][0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Test whether matrix is SPD
*************************************************************************/
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t i;
    ae_int_t j;
    double ajj;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;

    
    /*
     *     Test the input parameters.
     */
    ae_assert(n>=0, "Error in SMatrixCholesky: incorrect function arguments", _state);
    
    /*
     *     Quick return if possible
     */
    result = ae_true;
    if( n<=0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( isupper )
    {
        
        /*
         * Compute the Cholesky factorization A = U'*U.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute U(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of row J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[0][i], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                    a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j][j+1], 1, ae_v_len(j+1,n-1), v);
            }
        }
    }
    else
    {
        
        /*
         * Compute the Cholesky factorization A = L*L'.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute L(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[j][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of column J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
                    a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), v);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Tests whether A is HPD
*************************************************************************/
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t j;
    double ajj;
    ae_complex v;
    double r;
    ae_vector t;
    ae_vector t2;
    ae_vector t3;
    ae_int_t i;
    ae_matrix a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    memset(&t, 0, sizeof(t));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&a1, 0, sizeof(a1));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&t2, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&t3, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_vector_set_length(&t, n-1+1, _state);
    ae_vector_set_length(&t2, n-1+1, _state);
    ae_vector_set_length(&t3, n-1+1, _state);
    result = ae_true;
    
    /*
     * Compute the Cholesky factorization A = U'*U.
     */
    for(j=0; j<=n-1; j++)
    {
        
        /*
         * Compute U(J,J) and test for non-positive-definiteness.
         */
        v = ae_v_cdotproduct(&a->ptr.pp_complex[0][j], a->stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
        ajj = ae_c_sub(a->ptr.pp_complex[j][j],v).x;
        if( ae_fp_less_eq(ajj,(double)(0)) )
        {
            a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
            result = ae_false;
            ae_frame_leave(_state);
            return result;
        }
        ajj = ae_sqrt(ajj, _state);
        a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
        
        /*
         * Compute elements J+1:N-1 of row J.
         */
        if( j<n-1 )
        {
            ae_v_cmove(&t2.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "Conj", ae_v_len(0,j-1));
            ae_v_cmove(&t3.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j][j+1], 1, "N", ae_v_len(j+1,n-1));
            for(i=j+1; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[0][i], a->stride, "N", &t2.ptr.p_complex[0], 1, "N", ae_v_len(0,j-1));
                t3.ptr.p_complex[i] = ae_c_sub(t3.ptr.p_complex[i],v);
            }
            ae_v_cmove(&a->ptr.pp_complex[j][j+1], 1, &t3.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
            r = 1/ajj;
            ae_v_cmuld(&a->ptr.pp_complex[j][j+1], 1, ae_v_len(j+1,n-1), r);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
The function check, that upper triangle from symmetric matrix is equal to
lower triangle.
*************************************************************************/
static ae_bool testmatgenunit_testeult(ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    double c;
    double range;
    double eps;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);

    eps = 2*ae_machineepsilon;
    range = 100*(2*ae_randomreal(_state)-1);
    for(n=1; n<=15; n++)
    {
        c = 900*ae_randomreal(_state)+100;
        
        /*
         * Generate symmetric matrix and check it
         */
        smatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        spdmatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hpdmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with real values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = range*(2*ae_randomreal(_state)-1);
            }
        }
        for(i=0; i<=n-2; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        smatrixrndmultiply(&a, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with complex values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = range*(2*ae_randomreal(_state)-1);
                if( i!=j )
                {
                    b.ptr.pp_complex[i][j].y = range*(2*ae_randomreal(_state)-1);
                }
                else
                {
                    b.ptr.pp_complex[i][j].y = (double)(0);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = b.ptr.pp_complex[j][i].x;
                b.ptr.pp_complex[i][j].y = -b.ptr.pp_complex[j][i].y;
            }
        }
        hmatrixrndmultiply(&b, n, _state);
        for(i=0; i<=n-1; i++)
        {
            b.ptr.pp_complex[i][i].y = (double)(0);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SVD condition number
*************************************************************************/
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix v;
    ae_vector w;
    ae_int_t i;
    ae_int_t j;
    double minw;
    double maxw;
    double result;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&v, 0, sizeof(v));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&a1, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a1.ptr.pp_double[i][j] = a->ptr.pp_double[i-1][j-1];
        }
    }
    if( !testmatgenunit_obsoletesvddecomposition(&a1, n, n, &w, &v, _state) )
    {
        result = (double)(0);
        ae_frame_leave(_state);
        return result;
    }
    minw = w.ptr.p_double[1];
    maxw = w.ptr.p_double[1];
    for(i=2; i<=n; i++)
    {
        if( ae_fp_less(w.ptr.p_double[i],minw) )
        {
            minw = w.ptr.p_double[i];
        }
        if( ae_fp_greater(w.ptr.p_double[i],maxw) )
        {
            maxw = w.ptr.p_double[i];
        }
    }
    result = maxw/minw;
    ae_frame_leave(_state);
    return result;
}


static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t nm;
    ae_int_t minmn;
    ae_int_t l;
    ae_int_t k;
    ae_int_t j;
    ae_int_t jj;
    ae_int_t its;
    ae_int_t i;
    double z;
    double y;
    double x;
    double vscale;
    double s;
    double h;
    double g;
    double f;
    double c;
    double anorm;
    ae_vector rv1;
    ae_bool flag;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&rv1, 0, sizeof(rv1));
    ae_vector_clear(w);
    ae_matrix_clear(v);
    ae_vector_init(&rv1, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&rv1, n+1, _state);
    ae_vector_set_length(w, n+1, _state);
    ae_matrix_set_length(v, n+1, n+1, _state);
    result = ae_true;
    if( m<n )
    {
        minmn = m;
    }
    else
    {
        minmn = n;
    }
    g = 0.0;
    vscale = 0.0;
    anorm = 0.0;
    l = n;
    for(i=1; i<=n; i++)
    {
        l = i+1;
        rv1.ptr.p_double[i] = vscale*g;
        g = (double)(0);
        s = (double)(0);
        vscale = (double)(0);
        if( i<=m )
        {
            for(k=i; k<=m; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[k][i], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = a->ptr.pp_double[k][i]/vscale;
                    s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][i];
                }
                f = a->ptr.pp_double[i][i];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][i] = f-g;
                if( i!=n )
                {
                    for(j=l; j<=n; j++)
                    {
                        s = 0.0;
                        for(k=i; k<=m; k++)
                        {
                            s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                        }
                        f = s/h;
                        for(k=i; k<=m; k++)
                        {
                            a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                        }
                    }
                }
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = vscale*a->ptr.pp_double[k][i];
                }
            }
        }
        w->ptr.p_double[i] = vscale*g;
        g = 0.0;
        s = 0.0;
        vscale = 0.0;
        if( i<=m&&i!=n )
        {
            for(k=l; k<=n; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[i][k], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = a->ptr.pp_double[i][k]/vscale;
                    s = s+a->ptr.pp_double[i][k]*a->ptr.pp_double[i][k];
                }
                f = a->ptr.pp_double[i][l];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][l] = f-g;
                for(k=l; k<=n; k++)
                {
                    rv1.ptr.p_double[k] = a->ptr.pp_double[i][k]/h;
                }
                if( i!=m )
                {
                    for(j=l; j<=m; j++)
                    {
                        s = 0.0;
                        for(k=l; k<=n; k++)
                        {
                            s = s+a->ptr.pp_double[j][k]*a->ptr.pp_double[i][k];
                        }
                        for(k=l; k<=n; k++)
                        {
                            a->ptr.pp_double[j][k] = a->ptr.pp_double[j][k]+s*rv1.ptr.p_double[k];
                        }
                    }
                }
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = vscale*a->ptr.pp_double[i][k];
                }
            }
        }
        anorm = testmatgenunit_mymax(anorm, ae_fabs(w->ptr.p_double[i], _state)+ae_fabs(rv1.ptr.p_double[i], _state), _state);
    }
    for(i=n; i>=1; i--)
    {
        if( i<n )
        {
            if( ae_fp_neq(g,0.0) )
            {
                for(j=l; j<=n; j++)
                {
                    v->ptr.pp_double[j][i] = a->ptr.pp_double[i][j]/a->ptr.pp_double[i][l]/g;
                }
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=n; k++)
                    {
                        s = s+a->ptr.pp_double[i][k]*v->ptr.pp_double[k][j];
                    }
                    for(k=l; k<=n; k++)
                    {
                        v->ptr.pp_double[k][j] = v->ptr.pp_double[k][j]+s*v->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=l; j<=n; j++)
            {
                v->ptr.pp_double[i][j] = 0.0;
                v->ptr.pp_double[j][i] = 0.0;
            }
        }
        v->ptr.pp_double[i][i] = 1.0;
        g = rv1.ptr.p_double[i];
        l = i;
    }
    for(i=minmn; i>=1; i--)
    {
        l = i+1;
        g = w->ptr.p_double[i];
        if( i<n )
        {
            for(j=l; j<=n; j++)
            {
                a->ptr.pp_double[i][j] = 0.0;
            }
        }
        if( ae_fp_neq(g,0.0) )
        {
            g = 1.0/g;
            if( i!=n )
            {
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=m; k++)
                    {
                        s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                    }
                    f = s/a->ptr.pp_double[i][i]*g;
                    for(k=i; k<=m; k++)
                    {
                        a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]*g;
            }
        }
        else
        {
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = 0.0;
            }
        }
        a->ptr.pp_double[i][i] = a->ptr.pp_double[i][i]+1.0;
    }
    nm = 0;
    for(k=n; k>=1; k--)
    {
        for(its=1; its<=testmatgenunit_maxsvditerations; its++)
        {
            flag = ae_true;
            for(l=k; l>=1; l--)
            {
                nm = l-1;
                if( ae_fp_eq(ae_fabs(rv1.ptr.p_double[l], _state)+anorm,anorm) )
                {
                    flag = ae_false;
                    break;
                }
                if( ae_fp_eq(ae_fabs(w->ptr.p_double[nm], _state)+anorm,anorm) )
                {
                    break;
                }
            }
            if( flag )
            {
                c = 0.0;
                s = 1.0;
                for(i=l; i<=k; i++)
                {
                    f = s*rv1.ptr.p_double[i];
                    if( ae_fp_neq(ae_fabs(f, _state)+anorm,anorm) )
                    {
                        g = w->ptr.p_double[i];
                        h = testmatgenunit_pythag(f, g, _state);
                        w->ptr.p_double[i] = h;
                        h = 1.0/h;
                        c = g*h;
                        s = -f*h;
                        for(j=1; j<=m; j++)
                        {
                            y = a->ptr.pp_double[j][nm];
                            z = a->ptr.pp_double[j][i];
                            a->ptr.pp_double[j][nm] = y*c+z*s;
                            a->ptr.pp_double[j][i] = -y*s+z*c;
                        }
                    }
                }
            }
            z = w->ptr.p_double[k];
            if( l==k )
            {
                if( ae_fp_less(z,0.0) )
                {
                    w->ptr.p_double[k] = -z;
                    for(j=1; j<=n; j++)
                    {
                        v->ptr.pp_double[j][k] = -v->ptr.pp_double[j][k];
                    }
                }
                break;
            }
            if( its==testmatgenunit_maxsvditerations )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            x = w->ptr.p_double[l];
            nm = k-1;
            y = w->ptr.p_double[nm];
            g = rv1.ptr.p_double[nm];
            h = rv1.ptr.p_double[k];
            f = ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
            g = testmatgenunit_pythag(f, (double)(1), _state);
            f = ((x-z)*(x+z)+h*(y/(f+testmatgenunit_extsign(g, f, _state))-h))/x;
            c = 1.0;
            s = 1.0;
            for(j=l; j<=nm; j++)
            {
                i = j+1;
                g = rv1.ptr.p_double[i];
                y = w->ptr.p_double[i];
                h = s*g;
                g = c*g;
                z = testmatgenunit_pythag(f, h, _state);
                rv1.ptr.p_double[j] = z;
                c = f/z;
                s = h/z;
                f = x*c+g*s;
                g = -x*s+g*c;
                h = y*s;
                y = y*c;
                for(jj=1; jj<=n; jj++)
                {
                    x = v->ptr.pp_double[jj][j];
                    z = v->ptr.pp_double[jj][i];
                    v->ptr.pp_double[jj][j] = x*c+z*s;
                    v->ptr.pp_double[jj][i] = -x*s+z*c;
                }
                z = testmatgenunit_pythag(f, h, _state);
                w->ptr.p_double[j] = z;
                if( ae_fp_neq(z,0.0) )
                {
                    z = 1.0/z;
                    c = f*z;
                    s = h*z;
                }
                f = c*g+s*y;
                x = -s*g+c*y;
                for(jj=1; jj<=m; jj++)
                {
                    y = a->ptr.pp_double[jj][j];
                    z = a->ptr.pp_double[jj][i];
                    a->ptr.pp_double[jj][j] = y*c+z*s;
                    a->ptr.pp_double[jj][i] = -y*s+z*c;
                }
            }
            rv1.ptr.p_double[l] = 0.0;
            rv1.ptr.p_double[k] = f;
            w->ptr.p_double[k] = x;
        }
    }
    ae_frame_leave(_state);
    return result;
}


static double testmatgenunit_extsign(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater_eq(b,(double)(0)) )
    {
        result = ae_fabs(a, _state);
    }
    else
    {
        result = -ae_fabs(a, _state);
    }
    return result;
}


static double testmatgenunit_mymax(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater(a,b) )
    {
        result = a;
    }
    else
    {
        result = b;
    }
    return result;
}


static double testmatgenunit_pythag(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_less(ae_fabs(a, _state),ae_fabs(b, _state)) )
    {
        result = ae_fabs(b, _state)*ae_sqrt(1+ae_sqr(a/b, _state), _state);
    }
    else
    {
        result = ae_fabs(a, _state)*ae_sqrt(1+ae_sqr(b/a, _state), _state);
    }
    return result;
}



static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state);





ae_bool testtrfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_matrix ral;
    ae_matrix rau;
    ae_matrix ca;
    ae_matrix cal;
    ae_matrix cau;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t maxmn;
    ae_int_t largemn;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    double vr;
    ae_bool waserrors;
    ae_bool dspderr;
    ae_bool sspderr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool properr;
    ae_bool dspdupderr;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&ral, 0, sizeof(ral));
    memset(&rau, 0, sizeof(rau));
    memset(&ca, 0, sizeof(ca));
    memset(&cal, 0, sizeof(cal));
    memset(&cau, 0, sizeof(cau));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ral, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rau, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cal, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cau, 0, 0, DT_COMPLEX, _state, ae_true);

    rerr = ae_false;
    dspderr = ae_false;
    sspderr = ae_false;
    cerr = ae_false;
    hpderr = ae_false;
    properr = ae_false;
    dspdupderr = ae_false;
    waserrors = ae_false;
    maxmn = 4*matrixtilesizea(_state)+1;
    largemn = 256;
    threshold = 1000*ae_machineepsilon*maxmn;
    
    /*
     * Sparse Cholesky
     */
    sspderr = sparserealcholeskytest(_state);
    
    /*
     * Cholesky updates
     */
    testtrfacunit_testdensecholeskyupdates(&dspdupderr, _state);
    
    /*
     * test LU:
     * * first, test on small-scale matrices
     * * then, perform several large-scale tests
     */
    for(mx=1; mx<=maxmn; mx++)
    {
        
        /*
         * Initialize N/M, both are <=MX,
         * at least one of them is exactly equal to MX
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        
        /*
         * First, test on zero matrix
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
        
        /*
         * Second, random matrix with moderate condition number
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
        }
        cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
        cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
        rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
        rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
    }
    for(m=largemn-1; m<=largemn+1; m++)
    {
        for(n=largemn-1; n<=largemn+1; n++)
        {
            
            /*
             * Random matrix with moderate condition number
             */
            ae_matrix_set_length(&ra, m, n, _state);
            ae_matrix_set_length(&ca, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra.ptr.pp_double[i][j] = (double)(0);
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
            }
            for(i=0; i<=ae_minint(m, n, _state)-1; i++)
            {
                ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
                ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
            }
            cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
            cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
            rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
            rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
            testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
            testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
        }
    }
    
    /*
     * Test Cholesky
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * Load CA (HPD matrix with low condition number),
         *      CAL and CAU - its lower and upper triangles
         */
        hpdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ca, _state);
        ae_matrix_set_length(&cal, n, n, _state);
        ae_matrix_set_length(&cau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                cal.ptr.pp_complex[i][j] = ae_complex_from_i(i);
                cau.ptr.pp_complex[i][j] = ae_complex_from_i(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_cmove(&cal.ptr.pp_complex[i][0], 1, &ca.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,i));
            ae_v_cmove(&cau.ptr.pp_complex[i][i], 1, &ca.ptr.pp_complex[i][i], 1, "N", ae_v_len(i,n-1));
        }
        
        /*
         * Test HPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         */
        if( hpdmatrixcholesky(&cal, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cal.ptr.pp_complex[i][j],(double)(i));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cal.ptr.pp_complex[i][0], 1, "N", &cal.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,j));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        if( hpdmatrixcholesky(&cau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cau.ptr.pp_complex[i][j],(double)(j));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cau.ptr.pp_complex[0][i], cau.stride, "Conj", &cau.ptr.pp_complex[0][j], cau.stride, "N", ae_v_len(0,i));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        
        /*
         * Load RA (SPD matrix with low condition number),
         *      RAL and RAU - its lower and upper triangles
         *
         * Test SPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         *
         * After testing SPDMatrixCholesky() we compare results
         * returned by SparseCholeskyX() against ones returned
         * by SPDMatrixCholesky().
         */
        spdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ra, _state);
        ae_matrix_set_length(&ral, n, n, _state);
        ae_matrix_set_length(&rau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ral.ptr.pp_double[i][j] = (double)(i);
                rau.ptr.pp_double[i][j] = (double)(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&ral.ptr.pp_double[i][0], 1, &ra.ptr.pp_double[i][0], 1, ae_v_len(0,i));
            ae_v_move(&rau.ptr.pp_double[i][i], 1, &ra.ptr.pp_double[i][i], 1, ae_v_len(i,n-1));
        }
        if( spdmatrixcholesky(&ral, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        dspderr = dspderr||ae_fp_neq(ral.ptr.pp_double[i][j],(double)(i));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&ral.ptr.pp_double[i][0], 1, &ral.ptr.pp_double[j][0], 1, ae_v_len(0,j));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        if( spdmatrixcholesky(&rau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        dspderr = dspderr||ae_fp_neq(rau.ptr.pp_double[i][j],(double)(j));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&rau.ptr.pp_double[0][i], rau.stride, &rau.ptr.pp_double[0][j], rau.stride, ae_v_len(0,i));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        
        /*
         * Check algorithms on negative definite matrices -
         * correct error code must be returned.
         */
        ae_matrix_set_length(&ra, n, n, _state);
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 0.0;
                ca.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
            }
            ra.ptr.pp_double[i][i] = 1.0;
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        }
        ra.ptr.pp_double[n/2][n/2] = -1.0;
        ca.ptr.pp_complex[n/2][n/2] = ae_complex_from_d(-1.0);
        ae_set_error_flag(&dspderr, spdmatrixcholesky(&ra, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), __FILE__, __LINE__, "testtrfacunit.ap:499");
        ae_set_error_flag(&hpderr, hpdmatrixcholesky(&ca, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), __FILE__, __LINE__, "testtrfacunit.ap:500");
    }
    
    /*
     * report
     */
    waserrors = (((((rerr||dspderr)||sspderr)||cerr)||hpderr)||properr)||dspdupderr;
    if( !silent )
    {
        printf("TESTING TRIANGULAR FACTORIZATIONS\n");
        printf("* REAL:                                  ");
        if( rerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (dense)                            ");
        if( dspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (sparse)                           ");
        if( sspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                               ");
        if( cerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                   ");
        if( hpderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* OTHER PROPERTIES:                      ");
        if( properr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TESTING UPDATED FACTORIZATIONS\n");
        printf("* SPD (dense)                            ");
        if( dspdupderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_matrix a;
    ae_matrix a1;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_int_t t0;
    ae_int_t t1;
    ae_bool isupper;
    double offscale;
    double tol;
    sparsematrix sa;
    sparsematrix sa1;
    sparsematrix sc;
    sparsebuffers sbuf;
    ae_vector p0;
    ae_vector p1;
    ae_vector b1;
    ae_int_t cfmt;
    ae_int_t cord;
    hqrndstate rs;
    ae_int_t maxfmt;
    ae_int_t maxord;
    ae_int_t minord;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&a1, 0, sizeof(a1));
    memset(&sa, 0, sizeof(sa));
    memset(&sa1, 0, sizeof(sa1));
    memset(&sc, 0, sizeof(sc));
    memset(&sbuf, 0, sizeof(sbuf));
    memset(&p0, 0, sizeof(p0));
    memset(&p1, 0, sizeof(p1));
    memset(&b1, 0, sizeof(b1));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsematrix_init(&sa1, _state, ae_true);
    _sparsematrix_init(&sc, _state, ae_true);
    _sparsebuffers_init(&sbuf, _state, ae_true);
    ae_vector_init(&p0, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&b1, 0, DT_BOOL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    maxfmt = 2;
    maxord = 0;
    minord = -2;
    offscale = 1.0E-3;
    tol = 1.0E-8;
    
    /*
     * SparseCholeskyX test: performed for matrices
     * of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate symmetric N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. Off-diagonal elements are set to very
             * small values, so positive definiteness is guaranteed.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            
            /*
             * Problem statement
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            cfmt = ae_randominteger(maxfmt+1, _state);
            cord = ae_randominteger(maxord+1-minord, _state)+minord;
            
            /*
             * Create matrix is hash-based storage format, convert it to random storage format.
             */
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            sparseconvertto(&sa, hqrnduniformi(&rs, maxfmt+1, _state), _state);
            
            /*
             * Perform sparse Cholesky and make several tests:
             * * correctness of P0 and P1 (they are correct permutations and one is inverse of another)
             * * format of SC matches CFmt
             * * SC has correct size (exactly N*N)
             * * check that correct triangle is returned
             */
            if( !sparsecholeskyx(&sa, n, isupper, &p0, &p1, cord, ae_randominteger(3, _state), cfmt, &sbuf, &sc, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:669");
                ae_frame_leave(_state);
                return result;
            }
            ae_set_error_flag(&result, p0.cnt<n, __FILE__, __LINE__, "testtrfacunit.ap:672");
            ae_set_error_flag(&result, p1.cnt<n, __FILE__, __LINE__, "testtrfacunit.ap:673");
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            ae_vector_set_length(&b1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                b1.ptr.p_bool[i] = ae_false;
            }
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(&result, p0.ptr.p_int[i]<0, __FILE__, __LINE__, "testtrfacunit.ap:682");
                ae_set_error_flag(&result, p1.ptr.p_int[i]<0, __FILE__, __LINE__, "testtrfacunit.ap:683");
                ae_set_error_flag(&result, p0.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:684");
                ae_set_error_flag(&result, p1.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:685");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                ae_set_error_flag(&result, b1.ptr.p_bool[p0.ptr.p_int[i]], __FILE__, __LINE__, "testtrfacunit.ap:690");
                b1.ptr.p_bool[p0.ptr.p_int[i]] = ae_true;
                ae_set_error_flag(&result, p1.ptr.p_int[p0.ptr.p_int[i]]!=i, __FILE__, __LINE__, "testtrfacunit.ap:694");
            }
            ae_set_error_flag(&result, sparsegetmatrixtype(&sc, _state)!=cfmt, __FILE__, __LINE__, "testtrfacunit.ap:696");
            ae_set_error_flag(&result, sparsegetncols(&sc, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:697");
            ae_set_error_flag(&result, sparsegetnrows(&sc, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:698");
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sc, &t0, &t1, &i, &j, &v, _state))
            {
                ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:703");
                ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:704");
            }
            
            /*
             * Now, test correctness of Cholesky decomposition itself.
             * We calculate U'*U (or L*L') and check at against permutation
             * of A given by P0.
             *
             * NOTE: we expect that only one triangle of SC is filled,
             *       and another one is exactly zero.
             */
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, k, j, _state)*sparseget(&sc, k, i, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[p0.ptr.p_int[i]][p0.ptr.p_int[j]]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:723");
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, j, k, _state)*sparseget(&sc, i, k, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[p0.ptr.p_int[i]][p0.ptr.p_int[j]]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:734");
                    }
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * SparseCholeskySkyline test: performed for matrices
     * of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Choose IsUpper - main triangle to work with.
             *
             * Generate A - symmetric N*N matrix where probability of non-diagonal
             * element being non-zero is PNZ. Off-diagonal elements are set to
             * very small values, so positive definiteness is guaranteed. Full matrix
             * is generated.
             *
             * Additionally, we create A1 - same as A, but one of the triangles is
             * asymmetrically spoiled. If IsUpper is True, we spoil lower one, or vice versa.
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            ae_matrix_set_length(&a1, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        
                        /*
                         * Copy one triangle
                         */
                        a1.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        
                        /*
                         * Form another sparse pattern in different triangle.
                         */
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a1.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
            }
            
            /*
             * Create copies of A and A1 in hash-based storage format.
             * Only one triangle of A is copied, but A1 is copied fully.
             * Convert them to SKS
             */
            sparsecreate(n, n, 0, &sa, _state);
            sparsecreate(n, n, 0, &sa1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                    sparseset(&sa1, i, j, a1.ptr.pp_double[i][j], _state);
                }
            }
            sparseconverttosks(&sa, _state);
            sparseconverttosks(&sa1, _state);
            
            /*
             * Call SparseCholeskySkyline() for SA and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that correct triangle is returned (and another one is unchanged - zero)
             * * check that it is correct Cholesky decomposition.
             *   We calculate U'*U (or L*L') and check at against A. We expect
             *   that only one triangle of SA is filled, and another one is
             *   exactly zero.
             */
            if( !sparsecholeskyskyline(&sa, n, isupper, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:846");
                ae_frame_leave(_state);
                return result;
            }
            ae_set_error_flag(&result, !sparseissks(&sa, _state), __FILE__, __LINE__, "testtrfacunit.ap:849");
            ae_set_error_flag(&result, sparsegetncols(&sa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:850");
            ae_set_error_flag(&result, sparsegetnrows(&sa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:851");
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sa, &t0, &t1, &i, &j, &v, _state))
            {
                ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:856");
                ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:857");
            }
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, k, j, _state)*sparseget(&sa, k, i, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:867");
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, j, k, _state)*sparseget(&sa, i, k, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:878");
                    }
                }
            }
            
            /*
             * Call SparseCholeskySkyline() for SA1 and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that factorized triangle matches contents of SA,
             *   and another triangle was unchanged (matches contents of A1).
             */
            if( !sparsecholeskyskyline(&sa1, n, isupper, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:891");
                ae_frame_leave(_state);
                return result;
            }
            ae_set_error_flag(&result, !sparseissks(&sa1, _state), __FILE__, __LINE__, "testtrfacunit.ap:894");
            ae_set_error_flag(&result, sparsegetncols(&sa1, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:895");
            ae_set_error_flag(&result, sparsegetnrows(&sa1, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:896");
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-sparseget(&sa, i, j, _state), _state),10*ae_machineepsilon), __FILE__, __LINE__, "testtrfacunit.ap:900");
                    }
                    else
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-a1.ptr.pp_double[i][j], _state),10*ae_machineepsilon), __FILE__, __LINE__, "testtrfacunit.ap:902");
                    }
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    ae_frame_leave(_state);
    return result;
}


static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    ae_complex v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cl, 0, sizeof(cl));
    memset(&cu, 0, sizeof(cu));
    memset(&ca2, 0, sizeof(ca2));
    memset(&ct, 0, sizeof(ct));
    memset(&p, 0, sizeof(p));
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cl, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cu, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&ct, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cl.ptr.pp_complex[j][j] = ae_complex_from_d(1.0);
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[i][0], 1, &ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cu.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[0][i], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][i], ca2.stride, &ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    double v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cl, 0, sizeof(cl));
    memset(&cu, 0, sizeof(cu));
    memset(&ca2, 0, sizeof(ca2));
    memset(&ct, 0, sizeof(ct));
    memset(&p, 0, sizeof(p));
    ae_matrix_init(&ca, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cl, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cu, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ct, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        cl.ptr.pp_double[j][j] = 1.0;
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[i][0], 1, &ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, &ct.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        cu.ptr.pp_double[i][i] = 1.0;
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[0][i], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][i], ca2.stride, &ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_double[0], 1, ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing dense Cholesky updates
Sets error flag to True on errors, does not change it on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    double pfix;
    ae_matrix a0;
    ae_matrix a1;
    ae_vector u;
    ae_vector fix;
    ae_int_t i;
    ae_int_t j;
    ae_bool isupper;
    double tol;
    ae_vector bufr;
    hqrndstate rs;

    ae_frame_make(_state, &_frame_block);
    memset(&a0, 0, sizeof(a0));
    memset(&a1, 0, sizeof(a1));
    memset(&u, 0, sizeof(u));
    memset(&fix, 0, sizeof(fix));
    memset(&bufr, 0, sizeof(bufr));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&a0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&u, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&fix, 0, DT_BOOL, _state, ae_true);
    ae_vector_init(&bufr, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    tol = 1.0E-8;
    
    /*
     * Test rank-1 updates
     *
     * For each matrix size in 1..30 select sparse update vector with probability of element
     * being non-zero equal to 1/2.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector U.
         */
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&u, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&rs, _state),0.5) )
            {
                u.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
            }
            else
            {
                u.ptr.p_double[i] = (double)(0);
            }
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   we call SPDMatrixCholeskyUpdateAdd1
         * * A1 is transformed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:985");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdateadd1(&a0, n, isupper, &u, _state);
        }
        else
        {
            spdmatrixcholeskyupdateadd1buf(&a0, n, isupper, &u, &bufr, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    a1.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j]+u.ptr.p_double[i]*u.ptr.p_double[j];
                }
            }
        }
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:996");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ae_set_error_flag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1001");
            }
        }
    }
    
    /*
     * Test variable fixing functions.
     *
     * For each matrix size in 1..30 select PFix - probability of each variable being fixed,
     * and perform test.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector Fix.
         */
        pfix = (double)hqrnduniformi(&rs, n+1, _state)/(double)n;
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&fix, n, _state);
        for(i=0; i<=n-1; i++)
        {
            fix.ptr.p_bool[i] = ae_fp_less_eq(hqrnduniformr(&rs, _state),pfix);
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   variables are fixed with SPDMatrixCholeskyUpdateFix
         * * A1 is fixed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1040");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdatefixbuf(&a0, n, isupper, &fix, &bufr, _state);
        }
        else
        {
            spdmatrixcholeskyupdatefix(&a0, n, isupper, &fix, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    if( fix.ptr.p_bool[i]||fix.ptr.p_bool[j] )
                    {
                        if( i==j )
                        {
                            a1.ptr.pp_double[i][j] = (double)(1);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
            }
        }
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1057");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ae_set_error_flag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1062");
            }
        }
    }
    ae_frame_leave(_state);
}








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    ae_int_t passcount;
    double threshold;
    ae_matrix aeffective;
    ae_matrix aparam;
    ae_vector xe;
    ae_vector b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t cnts;
    ae_int_t cntu;
    ae_int_t cntt;
    ae_int_t cntm;
    ae_bool waserrors;
    ae_bool isupper;
    ae_bool istrans;
    ae_bool isunit;
    double v;
    double s;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&aeffective, 0, sizeof(aeffective));
    memset(&aparam, 0, sizeof(aparam));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&aeffective, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&aparam, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xe, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);

    waserrors = ae_false;
    maxmn = 15;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Different problems
     */
    for(n=1; n<=maxmn; n++)
    {
        ae_matrix_set_length(&aeffective, n-1+1, n-1+1, _state);
        ae_matrix_set_length(&aparam, n-1+1, n-1+1, _state);
        ae_vector_set_length(&xe, n-1+1, _state);
        ae_vector_set_length(&b, n-1+1, _state);
        for(pass=1; pass<=passcount; pass++)
        {
            for(cnts=0; cnts<=1; cnts++)
            {
                for(cntu=0; cntu<=1; cntu++)
                {
                    for(cntt=0; cntt<=1; cntt++)
                    {
                        for(cntm=0; cntm<=2; cntm++)
                        {
                            isupper = cnts==0;
                            isunit = cntu==0;
                            istrans = cntt==0;
                            
                            /*
                             * Skip meaningless combinations of parameters:
                             * (matrix is singular) AND (matrix is unit diagonal)
                             */
                            if( cntm==2&&isunit )
                            {
                                continue;
                            }
                            
                            /*
                             * Clear matrices
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=n-1; j++)
                                {
                                    aeffective.ptr.pp_double[i][j] = (double)(0);
                                    aparam.ptr.pp_double[i][j] = (double)(0);
                                }
                            }
                            
                            /*
                             * Prepare matrices
                             */
                            if( isupper )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=i; j<=n-1; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            else
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=i; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            if( isunit )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    aeffective.ptr.pp_double[i][i] = (double)(1);
                                    aparam.ptr.pp_double[i][i] = (double)(0);
                                }
                            }
                            if( istrans )
                            {
                                if( isupper )
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[j][i] = aeffective.ptr.pp_double[i][j];
                                            aeffective.ptr.pp_double[i][j] = (double)(0);
                                        }
                                    }
                                }
                                else
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[i][j] = aeffective.ptr.pp_double[j][i];
                                            aeffective.ptr.pp_double[j][i] = (double)(0);
                                        }
                                    }
                                }
                            }
                            
                            /*
                             * Prepare task, solve, compare
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                v = ae_v_dotproduct(&aeffective.ptr.pp_double[i][0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                                b.ptr.p_double[i] = v;
                            }
                            rmatrixtrsafesolve(&aparam, n, &b, &s, isupper, istrans, isunit, _state);
                            ae_v_muld(&xe.ptr.p_double[0], 1, ae_v_len(0,n-1), s);
                            ae_v_sub(&xe.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_v_dotproduct(&xe.ptr.p_double[0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_sqrt(v, _state);
                            waserrors = waserrors||ae_fp_greater(v,threshold);
                        }
                    }
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING RMatrixTRSafeSolve\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    double threshold;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool waserrors;
    ae_bool isupper;
    ae_int_t trans;
    ae_bool isunit;
    double scalea;
    double growth;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t j1;
    ae_int_t j2;
    ae_complex cv;
    ae_matrix ca;
    ae_matrix cea;
    ae_matrix ctmpa;
    ae_vector cxs;
    ae_vector cxe;
    double rv;
    ae_matrix ra;
    ae_matrix rea;
    ae_matrix rtmpa;
    ae_vector rxs;
    ae_vector rxe;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cea, 0, sizeof(cea));
    memset(&ctmpa, 0, sizeof(ctmpa));
    memset(&cxs, 0, sizeof(cxs));
    memset(&cxe, 0, sizeof(cxe));
    memset(&ra, 0, sizeof(ra));
    memset(&rea, 0, sizeof(rea));
    memset(&rtmpa, 0, sizeof(rtmpa));
    memset(&rxs, 0, sizeof(rxs));
    memset(&rxe, 0, sizeof(rxe));
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cea, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ctmpa, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cxs, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cxe, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rea, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rtmpa, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rxs, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rxe, 0, DT_REAL, _state, ae_true);

    maxmn = 30;
    threshold = 100000*ae_machineepsilon;
    rerrors = ae_false;
    cerrors = ae_false;
    waserrors = ae_false;
    
    /*
     * Different problems: general tests
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * test complex solver with well-conditioned matrix:
         * 1. generate A: fill off-diagonal elements with small values,
         *    diagonal elements are filled with larger values
         * 2. generate 'effective' A
         * 3. prepare task (exact X is stored in CXE, right part - in CXS),
         *    solve and compare CXS and CXE
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(3, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ca.ptr.pp_complex[i][j].x = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                    ca.ptr.pp_complex[i][j].y = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                    ca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_cmatrixmakeacopy(&ca, n, n, &ctmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                ctmpa.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
            if( isunit )
            {
                ctmpa.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
        }
        ae_matrix_set_length(&cea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[i][0], 1, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==2 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "Conj", ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&cxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cxe.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cxe.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&cxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cv = ae_v_cdotproduct(&cea.ptr.pp_complex[i][0], 1, "N", &cxe.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
            cxs.ptr.p_complex[i] = cv;
        }
        if( cmatrixscaledtrsafesolve(&ca, scalea, n, &cxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                cerrors = cerrors||ae_fp_greater(ae_c_abs(ae_c_sub(cxs.ptr.p_complex[i],cxe.ptr.p_complex[i]), _state),threshold);
            }
        }
        else
        {
            cerrors = ae_true;
        }
        
        /*
         * same with real
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(2, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ra, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ra.ptr.pp_double[i][j] = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_rmatrixmakeacopy(&ra, n, n, &rtmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                rtmpa.ptr.pp_double[i][j] = (double)(0);
            }
            if( isunit )
            {
                rtmpa.ptr.pp_double[i][i] = (double)(1);
            }
        }
        ae_matrix_set_length(&rea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_moved(&rea.ptr.pp_double[i][0], 1, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_moved(&rea.ptr.pp_double[0][i], rea.stride, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&rxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rxe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rv = ae_v_dotproduct(&rea.ptr.pp_double[i][0], 1, &rxe.ptr.p_double[0], 1, ae_v_len(0,n-1));
            rxs.ptr.p_double[i] = rv;
        }
        if( rmatrixscaledtrsafesolve(&ra, scalea, n, &rxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                rerrors = rerrors||ae_fp_greater(ae_fabs(rxs.ptr.p_double[i]-rxe.ptr.p_double[i], _state),threshold);
            }
        }
        else
        {
            rerrors = ae_true;
        }
    }
    
    /*
     * Special test with diagonal ill-conditioned matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 1/growth)
     * b = (1, 0.5)
     */
    n = 2;
    growth = (double)(10);
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_d(1/growth);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 1.05*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 0.95*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = 1/growth;
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 1.05*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 0.95*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    
    /*
     * Special test with diagonal degenerate matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 0)
     * b = (1, 0.5)
     */
    n = 2;
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_i(0);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = (double)(0);
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    
    /*
     * report
     */
    waserrors = rerrors||cerrors;
    if( !silent )
    {
        printf("TESTING SAFE TR SOLVER\n");
        printf("REAL:                                    ");
        if( !rerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}



static double testrcondunit_threshold50 = 0.25;
static double testrcondunit_threshold90 = 0.10;
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);





ae_bool testrcond(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    ae_int_t passcount;
    ae_bool waserrors;
    ae_bool rtrerr;
    ae_bool ctrerr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool result;


    maxn = 10;
    passcount = 100;
    
    /*
     * report
     */
    rtrerr = !testrcondunit_testrmatrixtrrcond(maxn, passcount, _state);
    ctrerr = !testrcondunit_testcmatrixtrrcond(maxn, passcount, _state);
    rerr = !testrcondunit_testrmatrixrcond(maxn, passcount, _state);
    cerr = !testrcondunit_testcmatrixrcond(maxn, passcount, _state);
    spderr = !testrcondunit_testspdmatrixrcond(maxn, passcount, _state);
    hpderr = !testrcondunit_testhpdmatrixrcond(maxn, passcount, _state);
    waserrors = ((((rtrerr||ctrerr)||rerr)||cerr)||spderr)||hpderr;
    if( !silent )
    {
        printf("TESTING RCOND\n");
        printf("REAL TRIANGULAR:                         ");
        if( !rtrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TRIANGULAR:                      ");
        if( !ctrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REAL:                                    ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD:                                     ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD:                                     ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_double[i][j] = (double)(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_rmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_double[i] = a->ptr.pp_double[i][j];
            a->ptr.pp_double[i][j] = (double)(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &work.ptr.p_double[j+1], 1, ae_v_len(j+1,n-1));
                a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_move(&work.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][jp], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][jp], a->stride, &work.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&pivots, 0, sizeof(pivots));
    ae_vector_init(&pivots, 0, DT_INT, _state, ae_true);

    rmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_rmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&inva, 0, sizeof(inva));
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * inv A
     */
    testrcondunit_rmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_rmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_cmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_complex[i] = a->ptr.pp_complex[i][j];
            a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &work.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
                a->ptr.pp_complex[i][j] = ae_c_sub(a->ptr.pp_complex[i][j],v);
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_cmove(&work.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][j], a->stride, &a->ptr.pp_complex[0][jp], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][jp], a->stride, &work.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&pivots, 0, sizeof(pivots));
    ae_vector_init(&pivots, 0, DT_INT, _state, ae_true);

    cmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_cmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&inva, 0, sizeof(inva));
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * inv A
     */
    testrcondunit_cmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_cmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
            }
            testrcondunit_rmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_double[i][j] = (double)(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_double[i][i] = (double)(1);
                }
            }
            testrcondunit_rmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/rmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/rmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j].x = ae_randomreal(_state)-0.5;
                    a.ptr.pp_complex[i][j].y = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i].x = 1+ae_randomreal(_state);
                a.ptr.pp_complex[i][i].y = 1+ae_randomreal(_state);
            }
            testrcondunit_cmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                }
            }
            testrcondunit_cmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/cmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/cmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
        rmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            rmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
            rmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/rmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/rmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/rmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/rmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            spdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_rmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
            spdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/spdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/spdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errless;
    ae_bool errspec;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    
    /*
     * process
     */
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
        cmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            cmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
            cmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/cmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/cmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/cmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/cmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            hpdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_cmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &cha, _state);
            hpdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/hpdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/hpdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}



static void testmatinvunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testmatinvunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static ae_bool testmatinvunit_rmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_spdmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_hpdmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_rmatrixcheckinversesingular(/* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_cmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_cmatrixcheckinversesingular(/* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static void testmatinvunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testmatinvunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testmatinvunit_testrtrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rtrerrors,
     ae_state *_state);
static void testmatinvunit_testctrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* ctrerrors,
     ae_state *_state);
static void testmatinvunit_testrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_state *_state);
static void testmatinvunit_testcinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_state *_state);
static void testmatinvunit_testspdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_state *_state);
static void testmatinvunit_testhpdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* hpderrors,
     ae_state *_state);
static void testmatinvunit_unset2d(/* Real    */ ae_matrix* x,
     ae_state *_state);
static void testmatinvunit_cunset2d(/* Complex */ ae_matrix* x,
     ae_state *_state);
static void testmatinvunit_unsetrep(matinvreport* r, ae_state *_state);





/*************************************************************************
Test
*************************************************************************/
ae_bool testmatinv(ae_bool silent, ae_state *_state)
{
    ae_int_t maxrn;
    ae_int_t maxcn;
    ae_int_t largen;
    ae_int_t passcount;
    double threshold;
    ae_bool rtrerrors;
    ae_bool ctrerrors;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool spderrors;
    ae_bool hpderrors;
    ae_bool waserrors;
    ae_bool result;


    maxrn = 3*matrixtilesizea(_state)+1;
    maxcn = 3*matrixtilesizea(_state)+1;
    largen = 4*matrixtilesizeb(_state)+1;
    passcount = 1;
    threshold = 10000*ae_machineepsilon;
    rtrerrors = ae_false;
    ctrerrors = ae_false;
    rerrors = ae_false;
    cerrors = ae_false;
    spderrors = ae_false;
    hpderrors = ae_false;
    testmatinvunit_testrtrinv(1, maxrn, passcount, threshold, &rtrerrors, _state);
    testmatinvunit_testctrinv(1, maxcn, passcount, threshold, &ctrerrors, _state);
    testmatinvunit_testrinv(1, maxrn, passcount, threshold, &rerrors, _state);
    testmatinvunit_testspdinv(1, maxrn, passcount, threshold, &spderrors, _state);
    testmatinvunit_testcinv(1, maxcn, passcount, threshold, &cerrors, _state);
    testmatinvunit_testhpdinv(1, maxcn, passcount, threshold, &hpderrors, _state);
    testmatinvunit_testrtrinv(largen, largen, passcount, threshold, &rtrerrors, _state);
    testmatinvunit_testctrinv(largen, largen, passcount, threshold, &ctrerrors, _state);
    testmatinvunit_testrinv(largen, largen, passcount, threshold, &rerrors, _state);
    testmatinvunit_testspdinv(largen, largen, passcount, threshold, &spderrors, _state);
    testmatinvunit_testcinv(largen, largen, passcount, threshold, &cerrors, _state);
    testmatinvunit_testhpdinv(largen, largen, passcount, threshold, &hpderrors, _state);
    waserrors = ((((rtrerrors||ctrerrors)||rerrors)||cerrors)||spderrors)||hpderrors;
    if( !silent )
    {
        printf("TESTING MATINV\n");
        printf("* REAL TRIANGULAR:                        ");
        if( rtrerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX TRIANGULAR:                     ");
        if( ctrerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* REAL:                                   ");
        if( rerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                                ");
        if( cerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD:                                    ");
        if( spderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                    ");
        if( hpderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testmatinvunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testmatinvunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_rmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &inva->ptr.pp_double[0][j], inva->stride, ae_v_len(0,n-1));
                if( i==j )
                {
                    v = v-1;
                }
                result = result&&ae_fp_less_eq(ae_fabs(v, _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_spdmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_matrix _inva;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    memset(&_inva, 0, sizeof(_inva));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;
    ae_matrix_init_copy(&_inva, inva, _state, ae_true);
    inva = &_inva;

    for(i=0; i<=n-2; i++)
    {
        if( isupper )
        {
            ae_v_move(&a->ptr.pp_double[i+1][i], a->stride, &a->ptr.pp_double[i][i+1], 1, ae_v_len(i+1,n-1));
            ae_v_move(&inva->ptr.pp_double[i+1][i], inva->stride, &inva->ptr.pp_double[i][i+1], 1, ae_v_len(i+1,n-1));
        }
        else
        {
            ae_v_move(&a->ptr.pp_double[i][i+1], 1, &a->ptr.pp_double[i+1][i], a->stride, ae_v_len(i+1,n-1));
            ae_v_move(&inva->ptr.pp_double[i][i+1], 1, &inva->ptr.pp_double[i+1][i], inva->stride, ae_v_len(i+1,n-1));
        }
    }
    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &inva->ptr.pp_double[0][j], inva->stride, ae_v_len(0,n-1));
                if( i==j )
                {
                    v = v-1;
                }
                result = result&&ae_fp_less_eq(ae_fabs(v, _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_hpdmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_matrix _inva;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    memset(&_inva, 0, sizeof(_inva));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;
    ae_matrix_init_copy(&_inva, inva, _state, ae_true);
    inva = &_inva;

    for(i=0; i<=n-2; i++)
    {
        if( isupper )
        {
            ae_v_cmove(&a->ptr.pp_complex[i+1][i], a->stride, &a->ptr.pp_complex[i][i+1], 1, "Conj", ae_v_len(i+1,n-1));
            ae_v_cmove(&inva->ptr.pp_complex[i+1][i], inva->stride, &inva->ptr.pp_complex[i][i+1], 1, "Conj", ae_v_len(i+1,n-1));
        }
        else
        {
            ae_v_cmove(&a->ptr.pp_complex[i][i+1], 1, &a->ptr.pp_complex[i+1][i], a->stride, "Conj", ae_v_len(i+1,n-1));
            ae_v_cmove(&inva->ptr.pp_complex[i][i+1], 1, &inva->ptr.pp_complex[i+1][i], inva->stride, "Conj", ae_v_len(i+1,n-1));
        }
    }
    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][0], 1, "N", &inva->ptr.pp_complex[0][j], inva->stride, "N", ae_v_len(0,n-1));
                if( i==j )
                {
                    v = ae_c_sub_d(v,1);
                }
                result = result&&ae_fp_less_eq(ae_c_abs(v, _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether inversion result indicate singular matrix
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_rmatrixcheckinversesingular(/* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result&&ae_fp_eq(inva->ptr.pp_double[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_cmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][0], 1, "N", &inva->ptr.pp_complex[0][j], inva->stride, "N", ae_v_len(0,n-1));
                if( i==j )
                {
                    v = ae_c_sub_d(v,1);
                }
                result = result&&ae_fp_less_eq(ae_c_abs(v, _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inversion result indicate singular matrix
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_cmatrixcheckinversesingular(/* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result&&ae_c_eq_d(inva->ptr.pp_complex[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testmatinvunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testmatinvunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Real TR inverse
*************************************************************************/
static void testmatinvunit_testrtrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rtrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t task;
    ae_bool isupper;
    ae_bool isunit;
    double v;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * Test
     */
    for(n=minn; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, n, _state);
        for(task=0; task<=3; task++)
        {
            for(pass=1; pass<=passcount; pass++)
            {
                
                /*
                 * Determine task
                 */
                isupper = task%2==0;
                isunit = task/2%2==0;
                
                /*
                 * Generate matrix
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                        }
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                
                /*
                 * Inverse
                 */
                rmatrixtrinverse(&b, n, isupper, isunit, &info, &rep, _state);
                if( info<=0 )
                {
                    *rtrerrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Structural test
                 */
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][i],b.ptr.pp_double[i][i]);
                    }
                }
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i-1; j++)
                        {
                            *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=i+1; j<=n-1; j++)
                        {
                            *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                        }
                    }
                }
                
                /*
                 * Inverse test
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                            b.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a.ptr.pp_double[i][i] = (double)(1);
                        b.ptr.pp_double[i][i] = (double)(1);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &b.ptr.pp_double[0][j], b.stride, ae_v_len(0,n-1));
                        if( j!=i )
                        {
                            *rtrerrors = *rtrerrors||ae_fp_greater(ae_fabs(v, _state),threshold);
                        }
                        else
                        {
                            *rtrerrors = *rtrerrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Complex TR inverse
*************************************************************************/
static void testmatinvunit_testctrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* ctrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t task;
    ae_bool isupper;
    ae_bool isunit;
    ae_complex v;
    ae_int_t info;
    matinvreport rep;
    double emax;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * Test
     */
    for(n=minn; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, n, _state);
        for(task=0; task<=3; task++)
        {
            for(pass=1; pass<=passcount; pass++)
            {
                
                /*
                 * Determine task
                 */
                isupper = task%2==0;
                isunit = task/2%2==0;
                
                /*
                 * Generate matrix
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            a.ptr.pp_complex[i][i].x = 1+ae_randomreal(_state);
                            a.ptr.pp_complex[i][i].y = 1+ae_randomreal(_state);
                        }
                        else
                        {
                            a.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                            a.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
                        }
                        b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
                    }
                }
                
                /*
                 * Inverse
                 */
                cmatrixtrinverse(&b, n, isupper, isunit, &info, &rep, _state);
                if( info<=0 )
                {
                    *ctrerrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Structural test
                 */
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][i],b.ptr.pp_complex[i][i]);
                    }
                }
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i-1; j++)
                        {
                            *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][j],b.ptr.pp_complex[i][j]);
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=i+1; j<=n-1; j++)
                        {
                            *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][j],b.ptr.pp_complex[i][j]);
                        }
                    }
                }
                
                /*
                 * Inverse test
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                            b.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                        }
                    }
                }
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                        b.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                    }
                }
                emax = (double)(0);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_cdotproduct(&a.ptr.pp_complex[i][0], 1, "N", &b.ptr.pp_complex[0][j], b.stride, "N", ae_v_len(0,n-1));
                        if( j==i )
                        {
                            v = ae_c_sub_d(v,1);
                        }
                        emax = ae_maxreal(emax, ae_c_abs(v, _state), _state);
                    }
                }
                *ctrerrors = *ctrerrors||ae_fp_greater(emax,threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Real test
*************************************************************************/
static void testmatinvunit_testrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix inva;
    ae_matrix invlua;
    ae_vector p;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&inva, 0, sizeof(inva));
    memset(&invlua, 0, sizeof(invlua));
    memset(&p, 0, sizeof(p));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&invlua, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            rmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
            rmatrixlu(&lua, n, n, &p, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_rmatrixmakeacopy(&lua, n, n, &invlua, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            rmatrixinverse(&inva, n, &info, &rep, _state);
            *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinverse(&a, &inva, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            rmatrixluinverse(&invlua, &p, n, &info, &rep, _state);
            *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinverse(&a, &invlua, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             *    * with equal rows/columns
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=4; taskkind++)
            {
                testmatinvunit_unset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                }
                if( taskkind==3 )
                {
                    
                    /*
                     * equal columns
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_move(&a.ptr.pp_double[0][0], a.stride, &a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1));
                }
                if( taskkind==4 )
                {
                    
                    /*
                     * equal rows
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_move(&a.ptr.pp_double[0][0], 1, &a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1));
                }
                testmatinvunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                rmatrixlu(&lua, n, n, &p, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                rmatrixinverse(&a, n, &info, &rep, _state);
                *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinversesingular(&a, n, threshold, info, &rep, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                rmatrixluinverse(&lua, &p, n, &info, &rep, _state);
                *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinversesingular(&lua, n, threshold, info, &rep, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Complex test
*************************************************************************/
static void testmatinvunit_testcinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix inva;
    ae_matrix invlua;
    ae_vector p;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&inva, 0, sizeof(inva));
    memset(&invlua, 0, sizeof(invlua));
    memset(&p, 0, sizeof(p));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&invlua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            cmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
            cmatrixlu(&lua, n, n, &p, _state);
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_cmatrixmakeacopy(&lua, n, n, &invlua, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            cmatrixinverse(&inva, n, &info, &rep, _state);
            *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinverse(&a, &inva, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            cmatrixluinverse(&invlua, &p, n, &info, &rep, _state);
            *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinverse(&a, &invlua, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             *    * with equal rows/columns
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=4; taskkind++)
            {
                testmatinvunit_cunset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[k][0], 1, ae_v_len(0,n-1), 0);
                }
                if( taskkind==3 )
                {
                    
                    /*
                     * equal columns
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_cmove(&a.ptr.pp_complex[0][0], a.stride, &a.ptr.pp_complex[0][k], a.stride, "N", ae_v_len(0,n-1));
                }
                if( taskkind==4 )
                {
                    
                    /*
                     * equal rows
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_cmove(&a.ptr.pp_complex[0][0], 1, &a.ptr.pp_complex[k][0], 1, "N", ae_v_len(0,n-1));
                }
                testmatinvunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
                cmatrixlu(&lua, n, n, &p, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                cmatrixinverse(&a, n, &info, &rep, _state);
                *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinversesingular(&a, n, threshold, info, &rep, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                cmatrixluinverse(&lua, &p, n, &info, &rep, _state);
                *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinversesingular(&lua, n, threshold, info, &rep, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
SPD test
*************************************************************************/
static void testmatinvunit_testspdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_matrix inva;
    ae_matrix invcha;
    ae_bool isupper;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&inva, 0, sizeof(inva));
    memset(&invcha, 0, sizeof(invcha));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&invcha, 0, 0, DT_REAL, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            spdmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_rmatrixdrophalf(&a, n, isupper, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
            if( !spdmatrixcholesky(&cha, n, isupper, _state) )
            {
                continue;
            }
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_rmatrixmakeacopy(&cha, n, n, &invcha, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            spdmatrixinverse(&inva, n, isupper, &info, &rep, _state);
            *spderrors = *spderrors||!testmatinvunit_spdmatrixcheckinverse(&a, &inva, isupper, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            spdmatrixcholeskyinverse(&invcha, n, isupper, &info, &rep, _state);
            *spderrors = *spderrors||!testmatinvunit_spdmatrixcheckinverse(&a, &invcha, isupper, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=2; taskkind++)
            {
                testmatinvunit_unset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                }
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                spdmatrixcholeskyinverse(&a, n, isupper, &info, &rep, _state);
                if( info!=-3&&info!=1 )
                {
                    *spderrors = ae_true;
                }
                else
                {
                    *spderrors = (*spderrors||ae_fp_less(rep.r1,(double)(0)))||ae_fp_greater(rep.r1,1000*ae_machineepsilon);
                    *spderrors = (*spderrors||ae_fp_less(rep.rinf,(double)(0)))||ae_fp_greater(rep.rinf,1000*ae_machineepsilon);
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
HPD test
*************************************************************************/
static void testmatinvunit_testhpdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* hpderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_matrix inva;
    ae_matrix invcha;
    ae_bool isupper;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&inva, 0, sizeof(inva));
    memset(&invcha, 0, sizeof(invcha));
    memset(&rep, 0, sizeof(rep));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&invcha, 0, 0, DT_COMPLEX, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            hpdmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_cmatrixdrophalf(&a, n, isupper, _state);
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &cha, _state);
            if( !hpdmatrixcholesky(&cha, n, isupper, _state) )
            {
                continue;
            }
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_cmatrixmakeacopy(&cha, n, n, &invcha, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            hpdmatrixinverse(&inva, n, isupper, &info, &rep, _state);
            *hpderrors = *hpderrors||!testmatinvunit_hpdmatrixcheckinverse(&a, &inva, isupper, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            hpdmatrixcholeskyinverse(&invcha, n, isupper, &info, &rep, _state);
            *hpderrors = *hpderrors||!testmatinvunit_hpdmatrixcheckinverse(&a, &invcha, isupper, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=2; taskkind++)
            {
                testmatinvunit_cunset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[0][k], a.stride, ae_v_len(0,n-1), 0);
                    ae_v_cmuld(&a.ptr.pp_complex[k][0], 1, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[k][0], 1, ae_v_len(0,n-1), 0);
                    ae_v_cmuld(&a.ptr.pp_complex[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                hpdmatrixcholeskyinverse(&a, n, isupper, &info, &rep, _state);
                if( info!=-3&&info!=1 )
                {
                    *hpderrors = ae_true;
                }
                else
                {
                    *hpderrors = (*hpderrors||ae_fp_less(rep.r1,(double)(0)))||ae_fp_greater(rep.r1,1000*ae_machineepsilon);
                    *hpderrors = (*hpderrors||ae_fp_less(rep.rinf,(double)(0)))||ae_fp_greater(rep.rinf,1000*ae_machineepsilon);
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Unsets real matrix
*************************************************************************/
static void testmatinvunit_unset2d(/* Real    */ ae_matrix* x,
     ae_state *_state)
{


    ae_matrix_set_length(x, 1, 1, _state);
    x->ptr.pp_double[0][0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets real matrix
*************************************************************************/
static void testmatinvunit_cunset2d(/* Complex */ ae_matrix* x,
     ae_state *_state)
{


    ae_matrix_set_length(x, 1, 1, _state);
    x->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets report
*************************************************************************/
static void testmatinvunit_unsetrep(matinvreport* r, ae_state *_state)
{


    r->r1 = (double)(-1);
    r->rinf = (double)(-1);
}








ae_bool testhblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    ae_complex alpha;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&x, 0, sizeof(x));
    memset(&y1, 0, sizeof(y1));
    memset(&y2, 0, sizeof(y2));
    memset(&y3, 0, sizeof(y3));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&x, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y1, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y2, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y3, 0, DT_COMPLEX, _state, ae_true);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_complex[i][i].x = 2*ae_randomreal(_state)-1;
            a.ptr.pp_complex[i][i].y = (double)(0);
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[j][i] = ae_c_conj(a.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                alpha.x = 2*ae_randomreal(_state)-1;
                alpha.y = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_cdotproduct(&a.ptr.pp_complex[i][i1], 1, "N", &x.ptr.p_complex[1], 1, "N", ae_v_len(i1,i2));
                    y1.ptr.p_complex[i-i1+1] = ae_c_mul(alpha,v);
                }
                hermitianmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                hermitianmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_csub(&y2.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y2.ptr.p_complex[1], 1, "N", &y2.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
                ae_v_csub(&y3.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y3.ptr.p_complex[1], 1, "N", &y3.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING HERMITIAN BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}








ae_bool testsblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    double alpha;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&x, 0, sizeof(x));
    memset(&y1, 0, sizeof(y1));
    memset(&y2, 0, sizeof(y2));
    memset(&y3, 0, sizeof(y3));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y3, 0, DT_REAL, _state, ae_true);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                alpha = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][i1], 1, &x.ptr.p_double[1], 1, ae_v_len(i1,i2));
                    y1.ptr.p_double[i-i1+1] = alpha*v;
                }
                symmetricmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                symmetricmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_sub(&y2.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y2.ptr.p_double[1], 1, &y2.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
                ae_v_sub(&y3.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y3.ptr.p_double[1], 1, &y3.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING SYMMETRIC BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state);
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state);
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state);
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state);
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    double threshold;
    ae_int_t mx;
    ae_matrix ra;
    ae_matrix ca;
    ae_int_t m;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_bool rqrerrors;
    ae_bool rlqerrors;
    ae_bool cqrerrors;
    ae_bool clqerrors;
    ae_bool rbderrors;
    ae_bool rhesserrors;
    ae_bool rtderrors;
    ae_bool ctderrors;
    ae_bool waserrors;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&ca, 0, sizeof(ca));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    waserrors = ae_false;
    rqrerrors = ae_false;
    rlqerrors = ae_false;
    cqrerrors = ae_false;
    clqerrors = ae_false;
    rbderrors = ae_false;
    rhesserrors = ae_false;
    rtderrors = ae_false;
    ctderrors = ae_false;
    threshold = 5*1000*ae_machineepsilon;
    
    /*
     * Medium-scale problems with various sparseness profiles
     */
    for(mx=1; mx<=3*matrixtilesizea(_state)+1; mx++)
    {
        
        /*
         * Rectangular factorizations: QR, LQ, bidiagonal
         * Matrix types: zero, dense, sparse
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, m, n, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, m, n, 0.95, _state);
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        
        /*
         * Square factorizations: Hessenberg, tridiagonal
         * Matrix types: zero, dense, sparse
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        
        /*
         * Symetric factorizations: tridiagonal
         * Matrix types: zero, dense, sparse
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
    }
    
    /*
     * Large-scale tests
     */
    for(mx=4*matrixtilesizeb(_state); mx<=4*matrixtilesizeb(_state); mx++)
    {
        
        /*
         * Rectangular factorizations: QR, LQ, bidiagonal
         * Matrix types: dense
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        
        /*
         * Square factorizations: Hessenberg, tridiagonal
         * Matrix types: dense
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        
        /*
         * Symetric factorizations: tridiagonal
         * Matrix types: dense
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
    }
    
    /*
     * report
     */
    waserrors = ((((((rqrerrors||rlqerrors)||cqrerrors)||clqerrors)||rbderrors)||rhesserrors)||rtderrors)||ctderrors;
    if( !silent )
    {
        printf("TESTING ORTFAC UNIT\n");
        printf("RQR ERRORS:                              ");
        if( !rqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RLQ ERRORS:                              ");
        if( !rlqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CQR ERRORS:                              ");
        if( !cqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CLQ ERRORS:                              ");
        if( !clqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RBD ERRORS:                              ");
        if( !rbderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RHESS ERRORS:                            ");
        if( !rhesserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RTD ERRORS:                              ");
        if( !rtderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CTD ERRORS:                              ");
        if( !ctderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Diff
*************************************************************************/
static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double result;


    result = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            result = ae_maxreal(result, ae_fabs(b->ptr.pp_double[i][j]-a->ptr.pp_double[i][j], _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a->ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
    }
}


/*************************************************************************
Matrix multiplication
*************************************************************************/
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t crows;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector work;
    double beta;
    double alpha;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);

    
    /*
     * Pre-setup
     */
    k = ae_maxint(ai2-ai1+1, aj2-aj1+1, _state);
    k = ae_maxint(k, bi2-bi1+1, _state);
    k = ae_maxint(k, bj2-bj1+1, _state);
    ae_vector_set_length(&work, k+1, _state);
    beta = (double)(0);
    alpha = (double)(1);
    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "MatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    crows = arows;
    
    /*
     * Test WORK
     */
    i = ae_maxint(arows, acols, _state);
    i = ae_maxint(brows, i, _state);
    i = ae_maxint(i, bcols, _state);
    work.ptr.p_double[1] = (double)(0);
    work.ptr.p_double[i] = (double)(0);
    
    /*
     * Prepare C
     */
    if( ae_fp_eq(beta,(double)(0)) )
    {
        for(i=ci1; i<=ci2; i++)
        {
            for(j=cj1; j<=cj2; j++)
            {
                c->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
    else
    {
        for(i=ci1; i<=ci2; i++)
        {
            ae_v_muld(&c->ptr.pp_double[i][cj1], 1, ae_v_len(cj1,cj2), beta);
        }
    }
    
    /*
     * A*B
     */
    if( !transa&&!transb )
    {
        for(l=ai1; l<=ai2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[l][aj1+r-bi1];
                k = ci1+l-ai1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A*B'
     */
    if( !transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(l=ai1; l<=ai2; l++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=ai1; l<=ai2; l++)
            {
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * A'*B
     */
    if( transa&&!transb )
    {
        for(l=aj1; l<=aj2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[ai1+r-bi1][l];
                k = ci1+l-aj1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A'*B'
     */
    if( transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(i=1; i<=crows; i++)
                {
                    work.ptr.p_double[i] = 0.0;
                }
                for(l=ai1; l<=ai2; l++)
                {
                    v = alpha*b->ptr.pp_double[r][bj1+l-ai1];
                    k = cj1+r-bi1;
                    ae_v_addd(&work.ptr.p_double[1], 1, &a->ptr.pp_double[l][aj1], 1, ae_v_len(1,crows), v);
                }
                ae_v_add(&c->ptr.pp_double[ci1][k], c->stride, &work.ptr.p_double[1], 1, ae_v_len(ci1,ci2));
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=aj1; l<=aj2; l++)
            {
                k = ai2-ai1+1;
                ae_v_move(&work.ptr.p_double[1], 1, &a->ptr.pp_double[ai1][l], a->stride, ae_v_len(1,k));
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&work.ptr.p_double[1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(1,k));
                    c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taub, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixqr(&b, m, n, &taub, _state);
    rmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    rmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &r.ptr.pp_double[0][j], r.stride, ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_neq(r.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,m-1));
            if( i==j )
            {
                v = v-1;
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixqr(&b, m, n, &taub, _state);
    cmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    cmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &r.ptr.pp_complex[0][j], r.stride, "N", ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_c_neq_d(r.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,m-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    cmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&l, 0, sizeof(l));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taub, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&l, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixlq(&b, m, n, &taub, _state);
    rmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    rmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&l.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_neq(l.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    rmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&l, 0, sizeof(l));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&l, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixlq(&b, m, n, &taub, _state);
    cmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    cmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&l.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_c_neq_d(l.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    cmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix t;
    ae_matrix pt;
    ae_matrix q;
    ae_matrix r;
    ae_matrix bd;
    ae_matrix x;
    ae_matrix r1;
    ae_matrix r2;
    ae_vector taup;
    ae_vector tauq;
    ae_vector d;
    ae_vector e;
    ae_bool up;
    double v;
    ae_int_t mtsize;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    memset(&pt, 0, sizeof(pt));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&bd, 0, sizeof(bd));
    memset(&x, 0, sizeof(x));
    memset(&r1, 0, sizeof(r1));
    memset(&r2, 0, sizeof(r2));
    memset(&taup, 0, sizeof(taup));
    memset(&tauq, 0, sizeof(tauq));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&t, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&pt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&bd, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taup, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tauq, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    
    /*
     * Bidiagonal decomposition error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &t, _state);
    rmatrixbd(&t, m, n, &tauq, &taup, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, m, &q, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, n, &pt, _state);
    rmatrixbdunpackdiagonals(&t, m, n, &up, &d, &e, _state);
    ae_matrix_set_length(&bd, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            bd.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=ae_minint(m, n, _state)-1; i++)
    {
        bd.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    if( up )
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        }
    }
    else
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
        }
    }
    ae_matrix_set_length(&r, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &bd.ptr.pp_double[0][j], bd.stride, ae_v_len(0,m-1));
            r.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&r.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[0][j], pt.stride, ae_v_len(0,n-1));
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * Orthogonality test for Q/PT
     */
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,m-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&pt.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    
    /*
     * Partial unpacking test
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, k, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(r.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    k = 1+ae_randominteger(n, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, k, &r, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(r.ptr.pp_double[i][j]-pt.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    
    /*
     * Multiplication test
     */
    ae_matrix_set_length(&x, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r1, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r2, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    for(i=0; i<=ae_maxint(m, n, _state)-1; i++)
    {
        for(j=0; j<=ae_maxint(m, n, _state)-1; j++)
        {
            x.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    mtsize = 1+ae_randominteger(ae_maxint(m, n, _state), _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_false, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_true, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_false, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_true, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_true, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_false, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_true, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_false, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix b;
    ae_matrix h;
    ae_matrix q;
    ae_matrix t1;
    ae_matrix t2;
    ae_vector tau;
    ae_int_t i;
    ae_int_t j;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&h, 0, sizeof(h));
    memset(&q, 0, sizeof(q));
    memset(&t1, 0, sizeof(t1));
    memset(&t2, 0, sizeof(t2));
    memset(&tau, 0, sizeof(tau));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tau, 0, DT_REAL, _state, ae_true);

    testortfacunit_rmatrixmakeacopy(a, n, n, &b, _state);
    
    /*
     * Decomposition
     */
    rmatrixhessenberg(&b, n, &tau, _state);
    rmatrixhessenbergunpackq(&b, n, &tau, &q, _state);
    rmatrixhessenbergunpackh(&b, n, &h, _state);
    
    /*
     * Matrix properties
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *hesserrors = *hesserrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i-2; j++)
        {
            *hesserrors = *hesserrors||ae_fp_neq(h.ptr.pp_double[i][j],(double)(0));
        }
    }
    
    /*
     * Decomposition error
     */
    ae_matrix_set_length(&t1, n, n, _state);
    ae_matrix_set_length(&t2, n, n, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, n-1, 0, n-1, ae_false, &h, 0, n-1, 0, n-1, ae_false, &t1, 0, n-1, 0, n-1, _state);
    testortfacunit_internalmatrixmatrixmultiply(&t1, 0, n-1, 0, n-1, ae_false, &q, 0, n-1, 0, n-1, ae_true, &t2, 0, n-1, 0, n-1, _state);
    *hesserrors = *hesserrors||ae_fp_greater(testortfacunit_rmatrixdiff(&t2, a, n, n, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Tridiagonal tester
*************************************************************************/
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&t, 0, sizeof(t));
    memset(&q, 0, sizeof(q));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&tau, 0, sizeof(tau));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t3, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tau, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    smatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    smatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    smatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    smatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Hermitian problem tester
*************************************************************************/
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&t, 0, sizeof(t));
    memset(&q, 0, sizeof(q));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&tau, 0, sizeof(tau));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t3, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tau, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    hmatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    hmatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    hmatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    hmatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}








/*************************************************************************
Testing
*************************************************************************/
ae_bool testfbls(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_bool waserrors;
    ae_bool cgerrors;
    ae_bool lserrors;
    ae_bool cholerrors;
    double eps;
    double v;
    double v1;
    double v2;
    ae_vector tmp0;
    ae_vector tmp1;
    ae_vector tmp2;
    double scalea;
    ae_bool uppera;
    ae_matrix a;
    ae_matrix ea;
    ae_vector b;
    ae_vector x;
    ae_vector xe;
    ae_vector buf;
    double alpha;
    double e1;
    double e2;
    fblslincgstate cgstate;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&tmp0, 0, sizeof(tmp0));
    memset(&tmp1, 0, sizeof(tmp1));
    memset(&tmp2, 0, sizeof(tmp2));
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&b, 0, sizeof(b));
    memset(&x, 0, sizeof(x));
    memset(&xe, 0, sizeof(xe));
    memset(&buf, 0, sizeof(buf));
    memset(&cgstate, 0, sizeof(cgstate));
    ae_vector_init(&tmp0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmp1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmp2, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xe, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&buf, 0, DT_REAL, _state, ae_true);
    _fblslincgstate_init(&cgstate, _state, ae_true);

    mx = 10;
    waserrors = ae_false;
    cgerrors = ae_false;
    lserrors = ae_false;
    cholerrors = ae_false;
    
    /*
     * Test CG solver:
     * * generate problem (A, B, Alpha, XE - exact solution) and initial approximation X
     * * E1 = ||A'A*x-b||
     * * solve
     * * E2 = ||A'A*x-b||
     * * test that E2<0.001*E1
     */
    for(n=1; n<=mx; n++)
    {
        for(m=1; m<=mx; m++)
        {
            ae_matrix_set_length(&a, m, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&xe, n, _state);
            ae_vector_set_length(&tmp1, m, _state);
            ae_vector_set_length(&tmp2, n, _state);
            
            /*
             * init A, alpha, B, X (initial approximation), XE (exact solution)
             * X is initialized in such way that is has no chances to be equal to XE.
             */
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                }
            }
            alpha = ae_randomreal(_state)+0.1;
            for(i=0; i<=n-1; i++)
            {
                b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                x.ptr.p_double[i] = (2*ae_randominteger(2, _state)-1)*(2+ae_randomreal(_state));
            }
            
            /*
             * Test dense CG (which solves A'A*x=b and accepts dense A)
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = (2*ae_randominteger(2, _state)-1)*(2+ae_randomreal(_state));
            }
            rmatrixmv(m, n, &a, 0, 0, 0, &x, 0, &tmp1, 0, _state);
            rmatrixmv(n, m, &a, 0, 0, 1, &tmp1, 0, &tmp2, 0, _state);
            ae_v_addd(&tmp2.ptr.p_double[0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1), alpha);
            ae_v_sub(&tmp2.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
            v = ae_v_dotproduct(&tmp2.ptr.p_double[0], 1, &tmp2.ptr.p_double[0], 1, ae_v_len(0,n-1));
            e1 = ae_sqrt(v, _state);
            fblssolvecgx(&a, m, n, alpha, &b, &x, &buf, _state);
            rmatrixmv(m, n, &a, 0, 0, 0, &x, 0, &tmp1, 0, _state);
            rmatrixmv(n, m, &a, 0, 0, 1, &tmp1, 0, &tmp2, 0, _state);
            ae_v_addd(&tmp2.ptr.p_double[0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1), alpha);
            ae_v_sub(&tmp2.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
            v = ae_v_dotproduct(&tmp2.ptr.p_double[0], 1, &tmp2.ptr.p_double[0], 1, ae_v_len(0,n-1));
            e2 = ae_sqrt(v, _state);
            cgerrors = cgerrors||ae_fp_greater(e2,0.001*e1);
            
            /*
             * Test sparse CG (which relies on reverse communication)
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = (2*ae_randominteger(2, _state)-1)*(2+ae_randomreal(_state));
            }
            rmatrixmv(m, n, &a, 0, 0, 0, &x, 0, &tmp1, 0, _state);
            rmatrixmv(n, m, &a, 0, 0, 1, &tmp1, 0, &tmp2, 0, _state);
            ae_v_addd(&tmp2.ptr.p_double[0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1), alpha);
            ae_v_sub(&tmp2.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
            v = ae_v_dotproduct(&tmp2.ptr.p_double[0], 1, &tmp2.ptr.p_double[0], 1, ae_v_len(0,n-1));
            e1 = ae_sqrt(v, _state);
            fblscgcreate(&x, &b, n, &cgstate, _state);
            while(fblscgiteration(&cgstate, _state))
            {
                rmatrixmv(m, n, &a, 0, 0, 0, &cgstate.x, 0, &tmp1, 0, _state);
                rmatrixmv(n, m, &a, 0, 0, 1, &tmp1, 0, &cgstate.ax, 0, _state);
                ae_v_addd(&cgstate.ax.ptr.p_double[0], 1, &cgstate.x.ptr.p_double[0], 1, ae_v_len(0,n-1), alpha);
                v1 = ae_v_dotproduct(&tmp1.ptr.p_double[0], 1, &tmp1.ptr.p_double[0], 1, ae_v_len(0,m-1));
                v2 = ae_v_dotproduct(&cgstate.x.ptr.p_double[0], 1, &cgstate.x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                cgstate.xax = v1+alpha*v2;
            }
            rmatrixmv(m, n, &a, 0, 0, 0, &cgstate.xk, 0, &tmp1, 0, _state);
            rmatrixmv(n, m, &a, 0, 0, 1, &tmp1, 0, &tmp2, 0, _state);
            ae_v_addd(&tmp2.ptr.p_double[0], 1, &cgstate.xk.ptr.p_double[0], 1, ae_v_len(0,n-1), alpha);
            ae_v_sub(&tmp2.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
            v = ae_v_dotproduct(&tmp2.ptr.p_double[0], 1, &tmp2.ptr.p_double[0], 1, ae_v_len(0,n-1));
            e2 = ae_sqrt(v, _state);
            cgerrors = cgerrors||ae_fp_greater(ae_fabs(e1-cgstate.e1, _state),100*ae_machineepsilon*e1);
            cgerrors = cgerrors||ae_fp_greater(ae_fabs(e2-cgstate.e2, _state),100*ae_machineepsilon*e1);
            cgerrors = cgerrors||ae_fp_greater(e2,0.001*e1);
        }
    }
    
    /*
     * Test linear least squares:
     * * try N=1..5, M=N..2*N
     *                           [ B ]
     * * generate MxN matrix A = [   ], where (M-N)xN submatrix B contains
     *                           [ C ]
     *   random values from [-1,+1], and NxN submatrix C is diagonally dominant
     *   (diagonal of C is equal to 1.0, and magnitude of off-diagonal elements
     *   is smaller than 0.01). Such matrix is guaranteed to be non-degenerate.
     * * generate random known solution xe, set right part b=A*xe
     * * check that results of FBLSSolveLS agree with xe
     */
    eps = 1.0E-6;
    for(n=1; n<=5; n++)
    {
        for(m=n; m<=2*n; m++)
        {
            ae_matrix_set_length(&a, m, n, _state);
            for(i=0; i<=m-n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                }
            }
            for(i=m-n; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.01*(2*ae_randomreal(_state)-1);
                }
                a.ptr.pp_double[i][i-(m-n)] = 1.0;
            }
            ae_vector_set_length(&xe, n, _state);
            for(i=0; i<=n-1; i++)
            {
                xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            ae_vector_set_length(&b, m, _state);
            for(i=0; i<=m-1; i++)
            {
                v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                b.ptr.p_double[i] = v;
            }
            fblssolvels(&a, &b, m, n, &tmp0, &tmp1, &tmp2, _state);
            for(i=0; i<=n-1; i++)
            {
                lserrors = lserrors||ae_fp_greater(ae_fabs(b.ptr.p_double[i]-xe.ptr.p_double[i], _state),eps);
            }
        }
    }
    
    /*
     * Test Cholesky solver:
     * * generate trial A, ScaleA, XS and corresponding right part B
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate test problem
         */
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&ea, n, n, _state);
        ae_vector_set_length(&xe, n, _state);
        ae_vector_set_length(&b, n, _state);
        ae_vector_set_length(&buf, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = 0.01*(ae_randomreal(_state)-0.5);
            }
            a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
            xe.ptr.p_double[i] = ae_randomreal(_state)-0.5;
        }
        scalea = ae_pow((double)(10), ae_randomreal(_state)*4-2, _state);
        uppera = ae_fp_greater(ae_randomreal(_state),0.5);
        for(i=0; i<=n-1; i++)
        {
            if( uppera )
            {
                for(j=0; j<=i-1; j++)
                {
                    ea.ptr.pp_double[i][j] = (double)(0);
                }
                for(j=i; j<=n-1; j++)
                {
                    ea.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                }
            }
            else
            {
                for(j=0; j<=i; j++)
                {
                    ea.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                }
                for(j=i+1; j<=n-1; j++)
                {
                    ea.ptr.pp_double[i][j] = (double)(0);
                }
            }
        }
        if( uppera )
        {
            rmatrixgemv(n, n, 1.0, &ea, 0, 0, 0, &xe, 0, 0.0, &buf, 0, _state);
            rmatrixgemv(n, n, 1.0, &ea, 0, 0, 1, &buf, 0, 0.0, &b, 0, _state);
        }
        else
        {
            rmatrixgemv(n, n, 1.0, &ea, 0, 0, 1, &xe, 0, 0.0, &buf, 0, _state);
            rmatrixgemv(n, n, 1.0, &ea, 0, 0, 0, &buf, 0, 0.0, &b, 0, _state);
        }
        ae_v_muld(&b.ptr.p_double[0], 1, ae_v_len(0,n-1), scalea);
        
        /*
         * Test
         */
        fblscholeskysolve(&a, ae_sqrt(scalea, _state), n, uppera, &b, &buf, _state);
        for(i=0; i<=n-1; i++)
        {
            ae_set_error_flag(&cholerrors, ae_fp_greater(ae_fabs(b.ptr.p_double[i]-xe.ptr.p_double[i], _state),1.0E3*ae_machineepsilon), __FILE__, __LINE__, "testfblsunit.ap:284");
        }
    }
    
    /*
     * report
     */
    waserrors = (cgerrors||lserrors)||cholerrors;
    if( !silent )
    {
        printf("TESTING FBLS\n");
        printf("CG ERRORS:                               ");
        if( cgerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LS ERRORS:                               ");
        if( lserrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CHOL ERRORS:                             ");
        if( cholerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}








ae_bool testcqmodels(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool eval0errors;
    ae_bool eval1errors;
    ae_bool eval2errors;
    ae_bool newton0errors;
    ae_bool newton1errors;
    ae_bool newton2errors;
    ae_bool waserrors;
    convexquadraticmodel s;
    ae_int_t nkind;
    ae_int_t kmax;
    ae_int_t n;
    ae_int_t k;
    ae_int_t i;
    ae_int_t pass;
    ae_int_t j;
    double alpha;
    double theta;
    double tau;
    double v;
    double v2;
    double h;
    double f0;
    double mkind;
    double xtadx2;
    double noise;
    ae_matrix a;
    ae_matrix q;
    ae_vector b;
    ae_vector r;
    ae_vector x;
    ae_vector x0;
    ae_vector xc;
    ae_vector d;
    ae_vector ge;
    ae_vector gt;
    ae_vector tmp0;
    ae_vector adx;
    ae_vector adxe;
    ae_vector activeset;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&q, 0, sizeof(q));
    memset(&b, 0, sizeof(b));
    memset(&r, 0, sizeof(r));
    memset(&x, 0, sizeof(x));
    memset(&x0, 0, sizeof(x0));
    memset(&xc, 0, sizeof(xc));
    memset(&d, 0, sizeof(d));
    memset(&ge, 0, sizeof(ge));
    memset(&gt, 0, sizeof(gt));
    memset(&tmp0, 0, sizeof(tmp0));
    memset(&adx, 0, sizeof(adx));
    memset(&adxe, 0, sizeof(adxe));
    memset(&activeset, 0, sizeof(activeset));
    _convexquadraticmodel_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&r, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xc, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ge, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&gt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmp0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&adx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&adxe, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&activeset, 0, DT_BOOL, _state, ae_true);

    waserrors = ae_false;
    
    /*
     * Eval0 test: unconstrained model evaluation
     */
    eval0errors = ae_false;
    for(n=1; n<=5; n++)
    {
        for(k=0; k<=2*n; k++)
        {
            
            /*
             * Allocate place
             */
            ae_matrix_set_length(&a, n, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&d, n, _state);
            ae_vector_set_length(&ge, n, _state);
            ae_vector_set_length(&gt, n, _state);
            ae_vector_set_length(&tmp0, n, _state);
            if( k>0 )
            {
                ae_matrix_set_length(&q, k, n, _state);
                ae_vector_set_length(&r, k, _state);
            }
            
            /*
             * Generate problem
             */
            alpha = ae_randomreal(_state)+1.0;
            theta = ae_randomreal(_state)+1.0;
            tau = ae_randomreal(_state)*ae_randominteger(2, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 10*(1+ae_randomreal(_state));
                b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                d.ptr.p_double[i] = ae_randomreal(_state)+1;
                for(j=i+1; j<=n-1; j++)
                {
                    v = 0.1*ae_randomreal(_state)-0.05;
                    a.ptr.pp_double[i][j] = v;
                    a.ptr.pp_double[j][i] = v;
                }
                for(j=0; j<=k-1; j++)
                {
                    q.ptr.pp_double[j][i] = 2*ae_randomreal(_state)-1;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                r.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            
            /*
             * Build model
             */
            cqminit(n, &s, _state);
            cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
            cqmsetb(&s, &b, _state);
            cqmsetq(&s, &q, &r, k, theta, _state);
            cqmsetd(&s, &d, tau, _state);
            
            /*
             * Evaluate and compare:
             * * X          -   random point
             * * GE         -   "exact" gradient
             * * XTADX2     -   x'*(alpha*A+tau*D)*x/2
             * * ADXE       -   (alpha*A+tau*D)*x
             * * V          -   model value at X
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                ge.ptr.p_double[i] = 0.0;
            }
            v = 0.0;
            xtadx2 = 0.0;
            ae_vector_set_length(&adxe, n, _state);
            for(i=0; i<=n-1; i++)
            {
                adxe.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-1; i++)
            {
                v = v+x.ptr.p_double[i]*b.ptr.p_double[i];
                ge.ptr.p_double[i] = ge.ptr.p_double[i]+b.ptr.p_double[i];
                v = v+0.5*ae_sqr(x.ptr.p_double[i], _state)*tau*d.ptr.p_double[i];
                ge.ptr.p_double[i] = ge.ptr.p_double[i]+x.ptr.p_double[i]*tau*d.ptr.p_double[i];
                adxe.ptr.p_double[i] = adxe.ptr.p_double[i]+x.ptr.p_double[i]*tau*d.ptr.p_double[i];
                xtadx2 = xtadx2+0.5*ae_sqr(x.ptr.p_double[i], _state)*tau*d.ptr.p_double[i];
                for(j=0; j<=n-1; j++)
                {
                    v = v+0.5*alpha*x.ptr.p_double[i]*a.ptr.pp_double[i][j]*x.ptr.p_double[j];
                    ge.ptr.p_double[i] = ge.ptr.p_double[i]+alpha*a.ptr.pp_double[i][j]*x.ptr.p_double[j];
                    adxe.ptr.p_double[i] = adxe.ptr.p_double[i]+alpha*a.ptr.pp_double[i][j]*x.ptr.p_double[j];
                    xtadx2 = xtadx2+0.5*alpha*x.ptr.p_double[i]*a.ptr.pp_double[i][j]*x.ptr.p_double[j];
                }
            }
            for(i=0; i<=k-1; i++)
            {
                v2 = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                v = v+0.5*theta*ae_sqr(v2-r.ptr.p_double[i], _state);
                for(j=0; j<=n-1; j++)
                {
                    ge.ptr.p_double[j] = ge.ptr.p_double[j]+theta*(v2-r.ptr.p_double[i])*q.ptr.pp_double[i][j];
                }
            }
            v2 = cqmeval(&s, &x, _state);
            eval0errors = eval0errors||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
            cqmevalx(&s, &x, &v2, &noise, _state);
            eval0errors = eval0errors||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
            eval0errors = (eval0errors||ae_fp_less(noise,(double)(0)))||ae_fp_greater(noise,10000*ae_machineepsilon);
            v2 = cqmxtadx2(&s, &x, &tmp0, _state);
            eval0errors = eval0errors||ae_fp_greater(ae_fabs(xtadx2-v2, _state),10000*ae_machineepsilon);
            cqmgradunconstrained(&s, &x, &gt, _state);
            for(i=0; i<=n-1; i++)
            {
                eval0errors = eval0errors||ae_fp_greater(ae_fabs(ge.ptr.p_double[i]-gt.ptr.p_double[i], _state),10000*ae_machineepsilon);
            }
            cqmadx(&s, &x, &adx, _state);
            for(i=0; i<=n-1; i++)
            {
                eval0errors = eval0errors||ae_fp_greater(ae_fabs(adx.ptr.p_double[i]-adxe.ptr.p_double[i], _state),10000*ae_machineepsilon);
            }
        }
    }
    waserrors = waserrors||eval0errors;
    
    /*
     * Eval1 test: constrained model evaluation
     */
    eval1errors = ae_false;
    for(n=1; n<=5; n++)
    {
        for(k=0; k<=2*n; k++)
        {
            
            /*
             * Allocate place
             */
            ae_matrix_set_length(&a, n, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&xc, n, _state);
            ae_vector_set_length(&activeset, n, _state);
            if( k>0 )
            {
                ae_matrix_set_length(&q, k, n, _state);
                ae_vector_set_length(&r, k, _state);
            }
            
            /*
             * Generate problem
             */
            alpha = ae_randomreal(_state)+1.0;
            theta = ae_randomreal(_state)+1.0;
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 10*(1+ae_randomreal(_state));
                b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                xc.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                activeset.ptr.p_bool[i] = ae_fp_greater(ae_randomreal(_state),0.5);
                for(j=i+1; j<=n-1; j++)
                {
                    v = 0.1*ae_randomreal(_state)-0.05;
                    a.ptr.pp_double[i][j] = v;
                    a.ptr.pp_double[j][i] = v;
                }
                for(j=0; j<=k-1; j++)
                {
                    q.ptr.pp_double[j][i] = 2*ae_randomreal(_state)-1;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                r.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            
            /*
             * Build model, evaluate at random point X, compare
             */
            cqminit(n, &s, _state);
            cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
            cqmsetb(&s, &b, _state);
            cqmsetq(&s, &q, &r, k, theta, _state);
            cqmsetactiveset(&s, &xc, &activeset, _state);
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                if( !activeset.ptr.p_bool[i] )
                {
                    xc.ptr.p_double[i] = x.ptr.p_double[i];
                }
            }
            v = 0.0;
            for(i=0; i<=n-1; i++)
            {
                v = v+xc.ptr.p_double[i]*b.ptr.p_double[i];
                for(j=0; j<=n-1; j++)
                {
                    v = v+0.5*alpha*xc.ptr.p_double[i]*a.ptr.pp_double[i][j]*xc.ptr.p_double[j];
                }
            }
            for(i=0; i<=k-1; i++)
            {
                v2 = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &xc.ptr.p_double[0], 1, ae_v_len(0,n-1));
                v = v+0.5*theta*ae_sqr(v2-r.ptr.p_double[i], _state);
            }
            eval1errors = eval1errors||ae_fp_greater(ae_fabs(v-cqmeval(&s, &xc, _state), _state),10000*ae_machineepsilon);
            eval1errors = eval1errors||ae_fp_greater(ae_fabs(v-cqmdebugconstrainedevalt(&s, &x, _state), _state),10000*ae_machineepsilon);
            eval1errors = eval1errors||ae_fp_greater(ae_fabs(v-cqmdebugconstrainedevale(&s, &x, _state), _state),10000*ae_machineepsilon);
        }
    }
    waserrors = waserrors||eval1errors;
    
    /*
     * Eval2 test: we generate empty problem and apply sequence of random transformations,
     * re-evaluating and re-checking model after each modification.
     *
     * The purpose of such test is to ensure that our caching strategy works correctly.
     */
    eval2errors = ae_false;
    for(n=1; n<=5; n++)
    {
        kmax = 2*n;
        ae_matrix_set_length(&a, n, n, _state);
        ae_vector_set_length(&b, n, _state);
        ae_vector_set_length(&d, n, _state);
        ae_vector_set_length(&x, n, _state);
        ae_vector_set_length(&xc, n, _state);
        ae_matrix_set_length(&q, kmax, n, _state);
        ae_vector_set_length(&r, kmax, _state);
        ae_vector_set_length(&activeset, n, _state);
        ae_vector_set_length(&tmp0, n, _state);
        alpha = 0.0;
        theta = 0.0;
        k = 0;
        tau = 1.0+ae_randomreal(_state);
        for(i=0; i<=n-1; i++)
        {
            d.ptr.p_double[i] = 1.0;
            b.ptr.p_double[i] = 0.0;
            xc.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            for(j=0; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = (double)(0);
            }
        }
        cqminit(n, &s, _state);
        cqmsetd(&s, &d, tau, _state);
        for(pass=1; pass<=100; pass++)
        {
            
            /*
             * Select random modification type, apply modification.
             *
             * MKind is a random integer in [0,7] - number of specific 
             * modification to apply.
             */
            mkind = (double)(ae_randominteger(8, _state));
            if( ae_fp_eq(mkind,(double)(0)) )
            {
                
                /*
                 * Set non-zero D
                 */
                tau = 1.0+ae_randomreal(_state);
                for(i=0; i<=n-1; i++)
                {
                    d.ptr.p_double[i] = 2*ae_randomreal(_state)+1;
                }
                cqmsetd(&s, &d, tau, _state);
            }
            else
            {
                if( ae_fp_eq(mkind,(double)(1)) )
                {
                    
                    /*
                     * Set zero D.
                     * In case Alpha=0, set non-zero A.
                     */
                    if( ae_fp_eq(alpha,(double)(0)) )
                    {
                        alpha = 1.0+ae_randomreal(_state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=i+1; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                            }
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            a.ptr.pp_double[i][i] = 4+2*ae_randomreal(_state);
                        }
                        cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
                    }
                    tau = 0.0;
                    for(i=0; i<=n-1; i++)
                    {
                        d.ptr.p_double[i] = (double)(0);
                    }
                    cqmsetd(&s, &d, 0.0, _state);
                }
                else
                {
                    if( ae_fp_eq(mkind,(double)(2)) )
                    {
                        
                        /*
                         * Set non-zero A
                         */
                        alpha = 1.0+ae_randomreal(_state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=i+1; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                            }
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            a.ptr.pp_double[i][i] = 4+2*ae_randomreal(_state);
                        }
                        cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
                    }
                    else
                    {
                        if( ae_fp_eq(mkind,(double)(3)) )
                        {
                            
                            /*
                             * Set zero A.
                             * In case Tau=0, set non-zero D.
                             */
                            if( ae_fp_eq(tau,(double)(0)) )
                            {
                                tau = 1.0+ae_randomreal(_state);
                                for(i=0; i<=n-1; i++)
                                {
                                    d.ptr.p_double[i] = 2*ae_randomreal(_state)+1;
                                }
                                cqmsetd(&s, &d, tau, _state);
                            }
                            alpha = 0.0;
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=n-1; j++)
                                {
                                    a.ptr.pp_double[i][j] = (double)(0);
                                }
                            }
                            cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
                        }
                        else
                        {
                            if( ae_fp_eq(mkind,(double)(4)) )
                            {
                                
                                /*
                                 * Set B.
                                 */
                                for(i=0; i<=n-1; i++)
                                {
                                    b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                                }
                                cqmsetb(&s, &b, _state);
                            }
                            else
                            {
                                if( ae_fp_eq(mkind,(double)(5)) )
                                {
                                    
                                    /*
                                     * Set Q.
                                     */
                                    k = ae_randominteger(kmax+1, _state);
                                    theta = 1.0+ae_randomreal(_state);
                                    for(i=0; i<=k-1; i++)
                                    {
                                        r.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                                        for(j=0; j<=n-1; j++)
                                        {
                                            q.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                                        }
                                    }
                                    cqmsetq(&s, &q, &r, k, theta, _state);
                                }
                                else
                                {
                                    if( ae_fp_eq(mkind,(double)(6)) )
                                    {
                                        
                                        /*
                                         * Set active set
                                         */
                                        for(i=0; i<=n-1; i++)
                                        {
                                            activeset.ptr.p_bool[i] = ae_fp_greater(ae_randomreal(_state),0.5);
                                            xc.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                                        }
                                        cqmsetactiveset(&s, &xc, &activeset, _state);
                                    }
                                    else
                                    {
                                        if( ae_fp_eq(mkind,(double)(7)) )
                                        {
                                            
                                            /*
                                             * Rewrite main diagonal
                                             */
                                            if( ae_fp_eq(alpha,(double)(0)) )
                                            {
                                                alpha = 1.0;
                                            }
                                            for(i=0; i<=n-1; i++)
                                            {
                                                tmp0.ptr.p_double[i] = 1+ae_randomreal(_state);
                                                a.ptr.pp_double[i][i] = tmp0.ptr.p_double[i]/alpha;
                                            }
                                            cqmrewritedensediagonal(&s, &tmp0, _state);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            /*
             * generate random point with respect to constraints,
             * test model at this point
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                if( activeset.ptr.p_bool[i] )
                {
                    x.ptr.p_double[i] = xc.ptr.p_double[i];
                }
            }
            v = 0.0;
            for(i=0; i<=n-1; i++)
            {
                v = v+x.ptr.p_double[i]*b.ptr.p_double[i];
            }
            if( ae_fp_greater(tau,(double)(0)) )
            {
                for(i=0; i<=n-1; i++)
                {
                    v = v+0.5*tau*d.ptr.p_double[i]*ae_sqr(x.ptr.p_double[i], _state);
                }
            }
            if( ae_fp_greater(alpha,(double)(0)) )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+0.5*alpha*x.ptr.p_double[i]*a.ptr.pp_double[i][j]*x.ptr.p_double[j];
                    }
                }
            }
            if( ae_fp_greater(theta,(double)(0)) )
            {
                for(i=0; i<=k-1; i++)
                {
                    v2 = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    v = v+0.5*theta*ae_sqr(v2-r.ptr.p_double[i], _state);
                }
            }
            v2 = cqmeval(&s, &x, _state);
            eval2errors = eval2errors||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
            v2 = cqmdebugconstrainedevalt(&s, &x, _state);
            eval2errors = eval2errors||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
            v2 = cqmdebugconstrainedevale(&s, &x, _state);
            eval2errors = eval2errors||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
        }
    }
    waserrors = waserrors||eval2errors;
    
    /*
     * Newton0 test: unconstrained optimization
     */
    newton0errors = ae_false;
    for(n=1; n<=5; n++)
    {
        for(k=0; k<=2*n; k++)
        {
            
            /*
             * Allocate place
             */
            ae_matrix_set_length(&a, n, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&x0, n, _state);
            if( k>0 )
            {
                ae_matrix_set_length(&q, k, n, _state);
                ae_vector_set_length(&r, k, _state);
            }
            
            /*
             * Generate problem with known solution x0:
             *   min f(x),
             *   f(x) = 0.5*(x-x0)'*A*(x-x0)
             *        = 0.5*x'*A*x + (-x0'*A)*x + 0.5*x0'*A*x0'
             */
            alpha = ae_randomreal(_state)+1.0;
            for(i=0; i<=n-1; i++)
            {
                x0.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                a.ptr.pp_double[i][i] = 10*(1+ae_randomreal(_state));
                for(j=i+1; j<=n-1; j++)
                {
                    v = 0.1*ae_randomreal(_state)-0.05;
                    a.ptr.pp_double[i][j] = v;
                    a.ptr.pp_double[j][i] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x0.ptr.p_double[0], 1, ae_v_len(0,n-1));
                b.ptr.p_double[i] = -alpha*v;
            }
            theta = ae_randomreal(_state)+1.0;
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    q.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                }
                v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &x0.ptr.p_double[0], 1, ae_v_len(0,n-1));
                r.ptr.p_double[i] = v;
            }
            
            /*
             * Build model, evaluate at random point X, compare
             */
            cqminit(n, &s, _state);
            cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
            cqmsetb(&s, &b, _state);
            cqmsetq(&s, &q, &r, k, theta, _state);
            cqmconstrainedoptimum(&s, &x, _state);
            for(i=0; i<=n-1; i++)
            {
                newton0errors = newton0errors||ae_fp_greater(ae_fabs(x.ptr.p_double[i]-x0.ptr.p_double[i], _state),1.0E6*ae_machineepsilon);
            }
        }
    }
    waserrors = waserrors||newton0errors;
    
    /*
     * Newton1 test: constrained optimization
     */
    newton1errors = ae_false;
    h = 1.0E-3;
    for(n=1; n<=5; n++)
    {
        for(k=0; k<=2*n; k++)
        {
            
            /*
             * Allocate place
             */
            ae_matrix_set_length(&a, n, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&xc, n, _state);
            ae_vector_set_length(&activeset, n, _state);
            if( k>0 )
            {
                ae_matrix_set_length(&q, k, n, _state);
                ae_vector_set_length(&r, k, _state);
            }
            
            /*
             * Generate test problem with unknown solution.
             */
            alpha = ae_randomreal(_state)+1.0;
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 10*(1+ae_randomreal(_state));
                b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                xc.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                activeset.ptr.p_bool[i] = ae_fp_greater(ae_randomreal(_state),0.5);
                for(j=i+1; j<=n-1; j++)
                {
                    v = 0.1*ae_randomreal(_state)-0.05;
                    a.ptr.pp_double[i][j] = v;
                    a.ptr.pp_double[j][i] = v;
                }
            }
            theta = ae_randomreal(_state)+1.0;
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    q.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                }
                r.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            
            /*
             * Build model, find solution
             */
            cqminit(n, &s, _state);
            cqmseta(&s, &a, ae_fp_greater(ae_randomreal(_state),0.5), alpha, _state);
            cqmsetb(&s, &b, _state);
            cqmsetq(&s, &q, &r, k, theta, _state);
            cqmsetactiveset(&s, &xc, &activeset, _state);
            if( cqmconstrainedoptimum(&s, &x, _state) )
            {
                
                /*
                 * Check that constraints are satisfied,
                 * and that solution is true optimum
                 */
                f0 = cqmeval(&s, &x, _state);
                for(i=0; i<=n-1; i++)
                {
                    newton1errors = newton1errors||(activeset.ptr.p_bool[i]&&ae_fp_neq(x.ptr.p_double[i],xc.ptr.p_double[i]));
                    if( !activeset.ptr.p_bool[i] )
                    {
                        v = x.ptr.p_double[i];
                        x.ptr.p_double[i] = v+h;
                        v2 = cqmeval(&s, &x, _state);
                        newton1errors = newton1errors||ae_fp_less(v2,f0);
                        x.ptr.p_double[i] = v-h;
                        v2 = cqmeval(&s, &x, _state);
                        newton1errors = newton1errors||ae_fp_less(v2,f0);
                        x.ptr.p_double[i] = v;
                    }
                }
            }
            else
            {
                newton1errors = ae_true;
            }
        }
    }
    waserrors = waserrors||newton1errors;
    
    /*
     * Newton2 test: we test ability to work with diagonal matrices, including
     * very large ones (up to 100.000 elements). This test checks that:
     * a) we can work with Alpha=0, i.e. when we have strictly diagonal A
     * b) diagonal problems are handled efficiently, i.e. algorithm will
     *    successfully solve problem with N=100.000
     *
     * Test problem:
     * * diagonal term D and rank-K term Q
     * * known solution X0,
     * * about 50% of constraints are active and equal to components of X0
     */
    newton2errors = ae_false;
    for(nkind=0; nkind<=5; nkind++)
    {
        for(k=0; k<=5; k++)
        {
            n = ae_round(ae_pow((double)(n), (double)(nkind), _state), _state);
            
            /*
             * generate problem
             */
            ae_vector_set_length(&d, n, _state);
            ae_vector_set_length(&b, n, _state);
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&x0, n, _state);
            ae_vector_set_length(&activeset, n, _state);
            if( k>0 )
            {
                ae_matrix_set_length(&q, k, n, _state);
                ae_vector_set_length(&r, k, _state);
            }
            tau = 1+ae_randomreal(_state);
            theta = 1+ae_randomreal(_state);
            for(i=0; i<=n-1; i++)
            {
                x0.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                d.ptr.p_double[i] = 1+ae_randomreal(_state);
                b.ptr.p_double[i] = -x0.ptr.p_double[i]*tau*d.ptr.p_double[i];
                activeset.ptr.p_bool[i] = ae_fp_greater(ae_randomreal(_state),0.5);
            }
            for(i=0; i<=k-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    q.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    v = v+q.ptr.pp_double[i][j]*x0.ptr.p_double[j];
                }
                r.ptr.p_double[i] = v;
            }
            
            /*
             * Solve, test
             */
            cqminit(n, &s, _state);
            cqmsetb(&s, &b, _state);
            cqmsetd(&s, &d, tau, _state);
            cqmsetq(&s, &q, &r, k, theta, _state);
            cqmsetactiveset(&s, &x0, &activeset, _state);
            if( cqmconstrainedoptimum(&s, &x, _state) )
            {
                
                /*
                 * Check that constraints are satisfied,
                 * and that solution is true optimum
                 */
                f0 = cqmeval(&s, &x, _state);
                for(i=0; i<=n-1; i++)
                {
                    newton2errors = newton2errors||(activeset.ptr.p_bool[i]&&ae_fp_neq(x.ptr.p_double[i],x0.ptr.p_double[i]));
                    newton2errors = newton2errors||(!activeset.ptr.p_bool[i]&&ae_fp_greater(ae_fabs(x.ptr.p_double[i]-x0.ptr.p_double[i], _state),1000*ae_machineepsilon));
                }
                
                /*
                 * Check that constrained evaluation at some point gives correct results
                 */
                for(i=0; i<=n-1; i++)
                {
                    if( activeset.ptr.p_bool[i] )
                    {
                        x.ptr.p_double[i] = x0.ptr.p_double[i];
                    }
                    else
                    {
                        x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    }
                }
                v = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+0.5*tau*d.ptr.p_double[i]*ae_sqr(x.ptr.p_double[i], _state)+x.ptr.p_double[i]*b.ptr.p_double[i];
                }
                for(i=0; i<=k-1; i++)
                {
                    v2 = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    v = v+0.5*theta*ae_sqr(v2-r.ptr.p_double[i], _state);
                }
                v2 = cqmeval(&s, &x, _state);
                newton2errors = (newton2errors||!ae_isfinite(v2, _state))||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
                v2 = cqmdebugconstrainedevalt(&s, &x, _state);
                newton2errors = (newton2errors||!ae_isfinite(v2, _state))||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
                v2 = cqmdebugconstrainedevale(&s, &x, _state);
                newton2errors = (newton2errors||!ae_isfinite(v2, _state))||ae_fp_greater(ae_fabs(v-v2, _state),10000*ae_machineepsilon);
            }
            else
            {
                newton2errors = ae_true;
            }
        }
    }
    waserrors = waserrors||newton2errors;
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING CONVEX QUADRATIC MODELS\n");
        printf("Eval0 test:                               ");
        if( eval0errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("Eval1 test:                               ");
        if( eval1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("Eval2 test:                               ");
        if( eval2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("Newton0 test:                             ");
        if( newton0errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("Newton1 test:                             ");
        if( newton1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("Newton2 test:                             ");
        if( newton2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state);
static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector d;
    ae_vector e;
    ae_matrix mempty;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    memset(&mempty, 0, sizeof(mempty));
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&mempty, 0, 0, DT_REAL, _state, ae_true);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxn = 15;
    threshold = 5*100*ae_machineepsilon;
    ae_vector_set_length(&d, maxn-1+1, _state);
    ae_vector_set_length(&e, maxn-2+1, _state);
    
    /*
     * special case: zero divide matrix
     * unfixed LAPACK routine should fail on this problem
     */
    n = 7;
    d.ptr.p_double[0] = -6.96462904751731892700e-01;
    d.ptr.p_double[1] = 0.00000000000000000000e+00;
    d.ptr.p_double[2] = -5.73827770385971991400e-01;
    d.ptr.p_double[3] = -6.62562624399371191700e-01;
    d.ptr.p_double[4] = 5.82737148001782223600e-01;
    d.ptr.p_double[5] = 3.84825263580925003300e-01;
    d.ptr.p_double[6] = 9.84087420830525472200e-01;
    e.ptr.p_double[0] = -7.30307931760612871800e-02;
    e.ptr.p_double[1] = -2.30079042939542843800e-01;
    e.ptr.p_double[2] = -6.87824621739351216300e-01;
    e.ptr.p_double[3] = -1.77306437707837570600e-02;
    e.ptr.p_double[4] = 1.78285126526551632000e-15;
    e.ptr.p_double[5] = -4.89434737751289969400e-02;
    rmatrixbdsvd(&d, &e, n, ae_true, ae_false, &mempty, 0, &mempty, 0, &mempty, 0, _state);
    
    /*
     * zero matrix, several cases
     */
    for(i=0; i<=maxn-1; i++)
    {
        d.ptr.p_double[i] = (double)(0);
    }
    for(i=0; i<=maxn-2; i++)
    {
        e.ptr.p_double[i] = (double)(0);
    }
    for(n=1; n<=maxn; n++)
    {
        testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
    }
    
    /*
     * Dense matrix
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            for(i=0; i<=maxn-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=maxn-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * Sparse matrices, very sparse matrices, incredible sparse matrices
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            testbdsvdunit_fillsparsede(&d, &e, n, 0.5, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.8, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.9, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.95, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = ((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING BIDIAGONAL SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                a->ptr.pp_double[i][j] = (double)(1);
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;


    ae_vector_set_length(d, n-1+1, _state);
    ae_vector_set_length(e, ae_maxint(0, n-2, _state)+1, _state);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            d->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            d->ptr.p_double[i] = (double)(0);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            e->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            e->ptr.p_double[i] = (double)(0);
        }
    }
}


static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double locerr;
    double sm;


    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            if( isupper )
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i==j-1 )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[i]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
            else
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i-1==j )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[j]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * check for C = U'
     * we consider it as decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            locerr = ae_maxreal(locerr, ae_fabs(u->ptr.pp_double[i][j]-c->ptr.pp_double[j][i], _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=n-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_vector wt;
    ae_matrix u2;
    ae_matrix c2;
    ae_matrix vt2;
    ae_matrix u1;
    ae_matrix c1;
    ae_matrix vt1;
    ae_int_t nru;
    ae_int_t ncc;
    ae_int_t ncvt;
    ae_int_t pass;
    hqrndstate rs;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&wt, 0, sizeof(wt));
    memset(&u2, 0, sizeof(u2));
    memset(&c2, 0, sizeof(c2));
    memset(&vt2, 0, sizeof(vt2));
    memset(&u1, 0, sizeof(u1));
    memset(&c1, 0, sizeof(c1));
    memset(&vt1, 0, sizeof(vt1));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&wt, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt1, 0, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    ae_vector_set_length(&wt, n, _state);
    
    /*
     * Perform nonsquare SVD
     */
    for(pass=1; pass<=20; pass++)
    {
        
        /*
         * Problem size
         */
        nru = hqrnduniformi(&rs, 2*n, _state);
        ncc = hqrnduniformi(&rs, 2*n, _state);
        ncvt = hqrnduniformi(&rs, 2*n, _state);
        
        /*
         * Reference matrices (copy 1) and working matrices (copy 2)
         */
        for(i=0; i<=n-1; i++)
        {
            wt.ptr.p_double[i] = d->ptr.p_double[i];
        }
        if( nru>0 )
        {
            
            /*
             * init U1/U2
             */
            ae_matrix_set_length(&u1, nru, n, _state);
            ae_matrix_set_length(&u2, nru, n, _state);
            for(i=0; i<=u1.rows-1; i++)
            {
                for(j=0; j<=u1.cols-1; j++)
                {
                    u1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    u2.ptr.pp_double[i][j] = u1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set U1/U2 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&u1, 1, 1, _state);
            ae_matrix_set_length(&u2, 1, 1, _state);
        }
        if( ncc>0 )
        {
            ae_matrix_set_length(&c1, n, ncc, _state);
            ae_matrix_set_length(&c2, n, ncc, _state);
            for(i=0; i<=c1.rows-1; i++)
            {
                for(j=0; j<=c1.cols-1; j++)
                {
                    c1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set C1/C1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&c1, 1, 1, _state);
            ae_matrix_set_length(&c2, 1, 1, _state);
        }
        if( ncvt>0 )
        {
            ae_matrix_set_length(&vt1, n, ncvt, _state);
            ae_matrix_set_length(&vt2, n, ncvt, _state);
            for(i=0; i<=vt1.rows-1; i++)
            {
                for(j=0; j<=vt1.cols-1; j++)
                {
                    vt1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    vt2.ptr.pp_double[i][j] = vt1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set VT1/VT1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&vt1, 1, 1, _state);
            ae_matrix_set_length(&vt2, 1, 1, _state);
        }
        
        /*
         * SVD with non-square U/C/VT
         */
        if( !rmatrixbdsvd(&wt, e, n, isupper, ae_fp_greater(hqrnduniformr(&rs, _state),(double)(0)), &u2, nru, &c2, ncc, &vt2, ncvt, _state) )
        {
            *err = 1.0;
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=nru-1; i++)
        {
            for(j=0; j<=u2.cols-1; j++)
            {
                v = ae_v_dotproduct(&u1.ptr.pp_double[i][0], 1, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-u2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=c2.rows-1; i++)
        {
            for(j=0; j<=ncc-1; j++)
            {
                v = ae_v_dotproduct(&c->ptr.pp_double[i][0], 1, &c1.ptr.pp_double[0][j], c1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-c2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=vt2.rows-1; i++)
        {
            for(j=0; j<=ncvt-1; j++)
            {
                v = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt1.ptr.pp_double[0][j], vt1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-vt2.ptr.pp_double[i][j], _state), _state);
            }
        }
    }
    ae_frame_leave(_state);
}


static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix c;
    ae_vector w;
    ae_int_t i;
    double mx;

    ae_frame_make(_state, &_frame_block);
    memset(&u, 0, sizeof(u));
    memset(&vt, 0, sizeof(vt));
    memset(&c, 0, sizeof(c));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater(ae_fabs(d->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(d->ptr.p_double[i], _state);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater(ae_fabs(e->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(e->ptr.p_double[i], _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    
    /*
     * Upper BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    
    /*
     * Lower BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}



static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state);





ae_bool testblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t i2;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t l;
    ae_int_t k;
    ae_int_t r;
    ae_int_t i3;
    ae_int_t j3;
    ae_int_t col1;
    ae_int_t col2;
    ae_int_t row1;
    ae_int_t row2;
    ae_vector x1;
    ae_vector x2;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c1;
    ae_matrix c2;
    double err;
    double e1;
    double e2;
    double e3;
    double v;
    double scl1;
    double scl2;
    double scl3;
    ae_bool was1;
    ae_bool was2;
    ae_bool trans1;
    ae_bool trans2;
    double threshold;
    ae_bool n2errors;
    ae_bool hsnerrors;
    ae_bool amaxerrors;
    ae_bool mverrors;
    ae_bool iterrors;
    ae_bool cterrors;
    ae_bool mmerrors;
    ae_bool waserrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x1, 0, sizeof(x1));
    memset(&x2, 0, sizeof(x2));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c1, 0, sizeof(c1));
    memset(&c2, 0, sizeof(c2));
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x2, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state, ae_true);

    n2errors = ae_false;
    amaxerrors = ae_false;
    hsnerrors = ae_false;
    mverrors = ae_false;
    iterrors = ae_false;
    cterrors = ae_false;
    mmerrors = ae_false;
    waserrors = ae_false;
    threshold = 10000*ae_machineepsilon;
    
    /*
     * Test Norm2
     */
    passcount = 1000;
    e1 = (double)(0);
    e2 = (double)(0);
    e3 = (double)(0);
    scl2 = 0.5*ae_maxrealnumber;
    scl3 = 2*ae_minrealnumber;
    for(pass=1; pass<=passcount; pass++)
    {
        n = 1+ae_randominteger(1000, _state);
        i1 = ae_randominteger(10, _state);
        i2 = n+i1-1;
        ae_vector_set_length(&x1, i2+1, _state);
        ae_vector_set_length(&x2, i2+1, _state);
        for(i=i1; i<=i2; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        v = (double)(0);
        for(i=i1; i<=i2; i++)
        {
            v = v+ae_sqr(x1.ptr.p_double[i], _state);
        }
        v = ae_sqrt(v, _state);
        e1 = ae_maxreal(e1, ae_fabs(v-vectornorm2(&x1, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl2*x1.ptr.p_double[i];
        }
        e2 = ae_maxreal(e2, ae_fabs(v*scl2-vectornorm2(&x2, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl3*x1.ptr.p_double[i];
        }
        e3 = ae_maxreal(e3, ae_fabs(v*scl3-vectornorm2(&x2, i1, i2, _state), _state), _state);
    }
    e2 = e2/scl2;
    e3 = e3/scl3;
    n2errors = (ae_fp_greater_eq(e1,threshold)||ae_fp_greater_eq(e2,threshold))||ae_fp_greater_eq(e3,threshold);
    
    /*
     * Testing VectorAbsMax, Column/Row AbsMax
     */
    ae_vector_set_length(&x1, 5+1, _state);
    x1.ptr.p_double[1] = 2.0;
    x1.ptr.p_double[2] = 0.2;
    x1.ptr.p_double[3] = -1.3;
    x1.ptr.p_double[4] = 0.7;
    x1.ptr.p_double[5] = -3.0;
    amaxerrors = (vectoridxabsmax(&x1, 1, 5, _state)!=5||vectoridxabsmax(&x1, 1, 4, _state)!=1)||vectoridxabsmax(&x1, 2, 4, _state)!=3;
    n = 30;
    ae_vector_set_length(&x1, n+1, _state);
    ae_matrix_set_length(&a, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    was1 = ae_false;
    was2 = ae_false;
    for(pass=1; pass<=1000; pass++)
    {
        j = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n+1-i1, _state);
        ae_v_move(&x1.ptr.p_double[i1], 1, &a.ptr.pp_double[i1][j], a.stride, ae_v_len(i1,i2));
        if( vectoridxabsmax(&x1, i1, i2, _state)!=columnidxabsmax(&a, i1, i2, j, _state) )
        {
            was1 = ae_true;
        }
        i = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n+1-j1, _state);
        ae_v_move(&x1.ptr.p_double[j1], 1, &a.ptr.pp_double[i][j1], 1, ae_v_len(j1,j2));
        if( vectoridxabsmax(&x1, j1, j2, _state)!=rowidxabsmax(&a, j1, j2, i, _state) )
        {
            was2 = ae_true;
        }
    }
    amaxerrors = (amaxerrors||was1)||was2;
    
    /*
     * Testing upper Hessenberg 1-norm
     */
    ae_matrix_set_length(&a, 3+1, 3+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    a.ptr.pp_double[1][1] = (double)(2);
    a.ptr.pp_double[1][2] = (double)(3);
    a.ptr.pp_double[1][3] = (double)(1);
    a.ptr.pp_double[2][1] = (double)(4);
    a.ptr.pp_double[2][2] = (double)(-5);
    a.ptr.pp_double[2][3] = (double)(8);
    a.ptr.pp_double[3][1] = (double)(99);
    a.ptr.pp_double[3][2] = (double)(3);
    a.ptr.pp_double[3][3] = (double)(1);
    hsnerrors = ae_fp_greater(ae_fabs(upperhessenberg1norm(&a, 1, 3, 1, 3, &x1, _state)-11, _state),threshold);
    
    /*
     * Testing MatrixVectorMultiply
     */
    ae_matrix_set_length(&a, 3+1, 5+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    ae_vector_set_length(&x2, 2+1, _state);
    a.ptr.pp_double[2][3] = (double)(2);
    a.ptr.pp_double[2][4] = (double)(-1);
    a.ptr.pp_double[2][5] = (double)(-1);
    a.ptr.pp_double[3][3] = (double)(1);
    a.ptr.pp_double[3][4] = (double)(-2);
    a.ptr.pp_double[3][5] = (double)(2);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 1.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 1.0, _state);
    e1 = ae_fabs(x1.ptr.p_double[1]+5, _state)+ae_fabs(x1.ptr.p_double[2]-8, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+2, _state)+ae_fabs(x2.ptr.p_double[2]+2, _state);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 0.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 0.0, _state);
    e2 = ae_fabs(x1.ptr.p_double[1]+3, _state)+ae_fabs(x1.ptr.p_double[2]-3, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+1, _state)+ae_fabs(x2.ptr.p_double[2]+1, _state);
    mverrors = ae_fp_greater_eq(e1+e2,threshold);
    
    /*
     * testing inplace transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    ae_vector_set_length(&x1, n-1+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n-(i2-i1), _state);
        j2 = j1+(i2-i1);
        copymatrix(&a, i1, i2, j1, j2, &b, i1, i2, j1, j2, _state);
        inplacetranspose(&b, i1, i2, j1, j2, &x1, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i1+(j-j1)][j1+(i-i1)]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    iterrors = was1;
    
    /*
     * testing copy and transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n-j1+1, _state);
        copyandtranspose(&a, i1, i2, j1, j2, &b, j1, j2, i1, i2, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[j][i]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    cterrors = was1;
    
    /*
     * Testing MatrixMatrixMultiply
     */
    n = 10;
    ae_matrix_set_length(&a, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&b, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c1, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c2, 2*n+1, 2*n+1, _state);
    ae_vector_set_length(&x1, n+1, _state);
    ae_vector_set_length(&x2, n+1, _state);
    for(i=1; i<=2*n; i++)
    {
        for(j=1; j<=2*n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
            b.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 1000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        for(i=1; i<=2*n; i++)
        {
            for(j=1; j<=2*n; j++)
            {
                c1.ptr.pp_double[i][j] = 2.1*i+3.1*j;
                c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
            }
        }
        l = 1+ae_randominteger(n, _state);
        k = 1+ae_randominteger(n, _state);
        r = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        i2 = 1+ae_randominteger(n, _state);
        j2 = 1+ae_randominteger(n, _state);
        i3 = 1+ae_randominteger(n, _state);
        j3 = 1+ae_randominteger(n, _state);
        trans1 = ae_fp_greater(ae_randomreal(_state),0.5);
        trans2 = ae_fp_greater(ae_randomreal(_state),0.5);
        if( trans1 )
        {
            col1 = l;
            row1 = k;
        }
        else
        {
            col1 = k;
            row1 = l;
        }
        if( trans2 )
        {
            col2 = k;
            row2 = r;
        }
        else
        {
            col2 = r;
            row2 = k;
        }
        scl1 = ae_randomreal(_state);
        scl2 = ae_randomreal(_state);
        matrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c1, i3, i3+l-1, j3, j3+r-1, scl2, &x1, _state);
        testblasunit_naivematrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c2, i3, i3+l-1, j3, j3+r-1, scl2, _state);
        err = (double)(0);
        for(i=1; i<=l; i++)
        {
            for(j=1; j<=r; j++)
            {
                err = ae_maxreal(err, ae_fabs(c1.ptr.pp_double[i3+i-1][j3+j-1]-c2.ptr.pp_double[i3+i-1][j3+j-1], _state), _state);
            }
        }
        if( ae_fp_greater(err,threshold) )
        {
            was1 = ae_true;
            break;
        }
    }
    mmerrors = was1;
    
    /*
     * report
     */
    waserrors = (((((n2errors||amaxerrors)||hsnerrors)||mverrors)||iterrors)||cterrors)||mmerrors;
    if( !silent )
    {
        printf("TESTING BLAS\n");
        printf("VectorNorm2:                             ");
        if( n2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("AbsMax (vector/row/column):              ");
        if( amaxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("UpperHessenberg1Norm:                    ");
        if( hsnerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixVectorMultiply:                    ");
        if( mverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("InplaceTranspose:                        ");
        if( iterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CopyAndTranspose:                        ");
        if( cterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixMatrixMultiply:                    ");
        if( mmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector x1;
    ae_vector x2;

    ae_frame_make(_state, &_frame_block);
    memset(&x1, 0, sizeof(x1));
    memset(&x2, 0, sizeof(x2));
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x2, 0, DT_REAL, _state, ae_true);

    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "NaiveMatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    l = arows;
    r = bcols;
    k = acols;
    ae_vector_set_length(&x1, k+1, _state);
    ae_vector_set_length(&x2, k+1, _state);
    for(i=1; i<=l; i++)
    {
        for(j=1; j<=r; j++)
        {
            if( !transa )
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bj1,bj2));
                }
            }
            else
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bj1,bj2));
                }
            }
            if( ae_fp_eq(beta,(double)(0)) )
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = alpha*v;
            }
            else
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = beta*c->ptr.pp_double[ci1+i-1][cj1+j-1]+alpha*v;
            }
        }
    }
    ae_frame_leave(_state);
}



static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t maxmn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t gpass;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double othererr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    othererr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxmn = 30;
    threshold = 5*100*ae_machineepsilon;
    ae_matrix_set_length(&a, maxmn-1+1, maxmn-1+1, _state);
    
    /*
     * TODO: div by zero fail, convergence fail
     */
    for(gpass=1; gpass<=1; gpass++)
    {
        
        /*
         * zero matrix, several cases
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Long dense matrix
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=ae_minint(5, maxmn, _state)-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=maxmn; i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        for(i=0; i<=ae_minint(5, maxmn, _state)-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=maxmn; j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Dense matrices
         */
        for(m=1; m<=ae_minint(10, maxmn, _state); m++)
        {
            for(n=1; n<=ae_minint(10, maxmn, _state); n++)
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Sparse matrices, very sparse matrices, incredible sparse matrices
         */
        for(m=1; m<=10; m++)
        {
            for(n=1; n<=10; n++)
            {
                for(pass=1; pass<=2; pass++)
                {
                    testsvdunit_fillsparsea(&a, m, n, 0.8, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.9, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.95, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                }
            }
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = (((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||ae_fp_greater(othererr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("SVD with different parameters error:     %5.3e\n",
            (double)(othererr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t minmn;
    double locerr;
    double sm;


    minmn = ae_minint(m, n, _state);
    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=minmn-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            locerr = ae_maxreal(locerr, ae_fabs(a->ptr.pp_double[i][j]-sm, _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=i; j<=minmn-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,m-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=minmn-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix u2;
    ae_matrix vt2;
    ae_vector w;
    ae_vector w2;
    ae_int_t i;
    ae_int_t j;
    ae_int_t ujob;
    ae_int_t vtjob;
    ae_int_t memjob;
    ae_int_t ucheck;
    ae_int_t vtcheck;

    ae_frame_make(_state, &_frame_block);
    memset(&u, 0, sizeof(u));
    memset(&vt, 0, sizeof(vt));
    memset(&u2, 0, sizeof(u2));
    memset(&vt2, 0, sizeof(vt2));
    memset(&w, 0, sizeof(w));
    memset(&w2, 0, sizeof(w2));
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w2, 0, DT_REAL, _state, ae_true);

    
    /*
     * Main SVD test
     */
    if( !rmatrixsvd(a, m, n, 2, 2, 2, &w, &u, &vt, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testsvdunit_getsvderror(a, m, n, &u, &w, &vt, materr, orterr, wsorted, _state);
    
    /*
     * Additional SVD tests
     */
    for(ujob=0; ujob<=2; ujob++)
    {
        for(vtjob=0; vtjob<=2; vtjob++)
        {
            for(memjob=0; memjob<=2; memjob++)
            {
                if( !rmatrixsvd(a, m, n, ujob, vtjob, memjob, &w2, &u2, &vt2, _state) )
                {
                    *failcount = *failcount+1;
                    *wfailed = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ucheck = 0;
                if( ujob==1 )
                {
                    ucheck = ae_minint(m, n, _state);
                }
                if( ujob==2 )
                {
                    ucheck = m;
                }
                vtcheck = 0;
                if( vtjob==1 )
                {
                    vtcheck = ae_minint(m, n, _state);
                }
                if( vtjob==2 )
                {
                    vtcheck = n;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=ucheck-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(u.ptr.pp_double[i][j]-u2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=vtcheck-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(vt.ptr.pp_double[i][j]-vt2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=ae_minint(m, n, _state)-1; i++)
                {
                    *othererr = ae_maxreal(*othererr, ae_fabs(w.ptr.p_double[i]-w2.ptr.p_double[i], _state), _state);
                }
            }
        }
    }
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}



static void testoptservunit_testprec(ae_bool* wereerrors,
     ae_state *_state);





ae_bool testoptserv(ae_bool silent, ae_state *_state)
{
    ae_bool precerrors;
    ae_bool wereerrors;
    ae_bool result;


    precerrors = ae_false;
    testoptservunit_testprec(&precerrors, _state);
    
    /*
     * report
     */
    wereerrors = precerrors;
    if( !silent )
    {
        printf("TESTING OPTSERV\n");
        printf("TESTS:                                    \n");
        printf("* PRECONDITIONERS                         ");
        if( precerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( wereerrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !wereerrors;
    return result;
}


/*************************************************************************
This function checks preconditioning functions

On failure sets error flag.
*************************************************************************/
static void testoptservunit_testprec(ae_bool* wereerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i0;
    ae_int_t j0;
    ae_int_t j1;
    double v;
    double rho;
    double theta;
    double tolg;
    ae_matrix va;
    ae_vector vc;
    ae_vector vd;
    ae_vector vb;
    ae_vector s0;
    ae_vector s1;
    ae_vector s2;
    ae_vector g;
    precbuflbfgs buf;
    precbuflowrank lowrankbuf;
    ae_vector norms;
    ae_matrix sk;
    ae_matrix yk;
    ae_matrix bk;
    ae_vector bksk;
    ae_vector tmp;
    matinvreport rep;
    hqrndstate rs;

    ae_frame_make(_state, &_frame_block);
    memset(&va, 0, sizeof(va));
    memset(&vc, 0, sizeof(vc));
    memset(&vd, 0, sizeof(vd));
    memset(&vb, 0, sizeof(vb));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    memset(&g, 0, sizeof(g));
    memset(&buf, 0, sizeof(buf));
    memset(&lowrankbuf, 0, sizeof(lowrankbuf));
    memset(&norms, 0, sizeof(norms));
    memset(&sk, 0, sizeof(sk));
    memset(&yk, 0, sizeof(yk));
    memset(&bk, 0, sizeof(bk));
    memset(&bksk, 0, sizeof(bksk));
    memset(&tmp, 0, sizeof(tmp));
    memset(&rep, 0, sizeof(rep));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&va, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vc, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vd, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vb, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&g, 0, DT_REAL, _state, ae_true);
    _precbuflbfgs_init(&buf, _state, ae_true);
    _precbuflowrank_init(&lowrankbuf, _state, ae_true);
    ae_vector_init(&norms, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&sk, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yk, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&bk, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bksk, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tmp, 0, DT_REAL, _state, ae_true);
    _matinvreport_init(&rep, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * Test for inexact L-BFGS preconditioner.
     *
     * We generate QP problem 0.5*x'*H*x, with random H=D+V'*C*V.
     * Different K's, from 0 to N, are tried. We test preconditioner
     * code which uses compact L-BFGS update against reference implementation
     * which uses non-compact BFGS scheme.
     *
     * For each K we perform two tests: first for KxN non-zero matrix V,
     * second one for NxN matrix V with last N-K rows set to zero. Last test
     * checks algorithm's ability to handle zero updates.
     */
    tolg = 1.0E-9;
    for(n=1; n<=10; n++)
    {
        for(k=0; k<=n; k++)
        {
            
            /*
             * Prepare problem:
             * * VD, VC, VA, with VC/VA reordered by ascending of VC[i]*norm(VA[i,...])^2
             * * trial vector S (copies are stored to S0,S1,S2)
             */
            ae_vector_set_length(&vd, n, _state);
            ae_vector_set_length(&s0, n, _state);
            ae_vector_set_length(&s1, n, _state);
            ae_vector_set_length(&s2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                vd.ptr.p_double[i] = ae_exp(hqrndnormal(&rs, _state), _state);
                s0.ptr.p_double[i] = hqrndnormal(&rs, _state);
                s1.ptr.p_double[i] = s0.ptr.p_double[i];
                s2.ptr.p_double[i] = s0.ptr.p_double[i];
            }
            rmatrixrndcond(n, 1.0E2, &va, _state);
            rvectorsetlengthatleast(&vc, n, _state);
            for(i=0; i<=k-1; i++)
            {
                vc.ptr.p_double[i] = ae_exp(hqrndnormal(&rs, _state), _state);
            }
            for(i=k; i<=n-1; i++)
            {
                vc.ptr.p_double[i] = (double)(0);
                for(j=0; j<=n-1; j++)
                {
                    va.ptr.pp_double[i][j] = 0.0;
                }
            }
            ae_vector_set_length(&norms, k, _state);
            for(i=0; i<=k-1; i++)
            {
                v = ae_v_dotproduct(&va.ptr.pp_double[i][0], 1, &va.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                norms.ptr.p_double[i] = v*vc.ptr.p_double[i];
            }
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=k-2; j++)
                {
                    if( ae_fp_greater(norms.ptr.p_double[j],norms.ptr.p_double[j+1]) )
                    {
                        
                        /*
                         * Swap elements J and J+1
                         */
                        v = norms.ptr.p_double[j];
                        norms.ptr.p_double[j] = norms.ptr.p_double[j+1];
                        norms.ptr.p_double[j+1] = v;
                        v = vc.ptr.p_double[j];
                        vc.ptr.p_double[j] = vc.ptr.p_double[j+1];
                        vc.ptr.p_double[j+1] = v;
                        for(j0=0; j0<=n-1; j0++)
                        {
                            v = va.ptr.pp_double[j][j0];
                            va.ptr.pp_double[j][j0] = va.ptr.pp_double[j+1][j0];
                            va.ptr.pp_double[j+1][j0] = v;
                        }
                    }
                }
            }
            
            /*
             * Generate reference model and apply it to S2:
             * * generate approximate Hessian Bk
             * * calculate inv(Bk)
             * * calculate inv(Bk)*S2, store to S2
             */
            rmatrixsetlengthatleast(&sk, k, n, _state);
            rmatrixsetlengthatleast(&yk, k, n, _state);
            ae_matrix_set_length(&bk, n, n, _state);
            ae_vector_set_length(&bksk, n, _state);
            ae_vector_set_length(&tmp, n, _state);
            for(i=0; i<=k-1; i++)
            {
                ae_v_move(&sk.ptr.pp_double[i][0], 1, &va.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                v = ae_v_dotproduct(&va.ptr.pp_double[i][0], 1, &sk.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                v = v*vc.ptr.p_double[i];
                for(j=0; j<=n-1; j++)
                {
                    yk.ptr.pp_double[i][j] = vd.ptr.p_double[j]*sk.ptr.pp_double[i][j]+va.ptr.pp_double[i][j]*v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i==j )
                    {
                        bk.ptr.pp_double[i][i] = vd.ptr.p_double[i];
                    }
                    else
                    {
                        bk.ptr.pp_double[i][j] = 0.0;
                    }
                }
            }
            for(i=0; i<=k-1; i++)
            {
                theta = 0.0;
                for(j0=0; j0<=n-1; j0++)
                {
                    bksk.ptr.p_double[j0] = (double)(0);
                    for(j1=0; j1<=n-1; j1++)
                    {
                        theta = theta+sk.ptr.pp_double[i][j0]*bk.ptr.pp_double[j0][j1]*sk.ptr.pp_double[i][j1];
                        bksk.ptr.p_double[j0] = bksk.ptr.p_double[j0]+bk.ptr.pp_double[j0][j1]*sk.ptr.pp_double[i][j1];
                    }
                }
                theta = 1/theta;
                rho = ae_v_dotproduct(&sk.ptr.pp_double[i][0], 1, &yk.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                rho = 1/rho;
                for(j0=0; j0<=n-1; j0++)
                {
                    for(j1=0; j1<=n-1; j1++)
                    {
                        bk.ptr.pp_double[j0][j1] = bk.ptr.pp_double[j0][j1]+rho*yk.ptr.pp_double[i][j0]*yk.ptr.pp_double[i][j1];
                    }
                }
                for(j0=0; j0<=n-1; j0++)
                {
                    for(j1=0; j1<=n-1; j1++)
                    {
                        bk.ptr.pp_double[j0][j1] = bk.ptr.pp_double[j0][j1]-theta*bksk.ptr.p_double[j0]*bksk.ptr.p_double[j1];
                    }
                }
            }
            rmatrixinverse(&bk, n, &j0, &rep, _state);
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_dotproduct(&bk.ptr.pp_double[i][0], 1, &s2.ptr.p_double[0], 1, ae_v_len(0,n-1));
                tmp.ptr.p_double[i] = v;
            }
            for(i=0; i<=n-1; i++)
            {
                s2.ptr.p_double[i] = tmp.ptr.p_double[i];
            }
            
            /*
             * First test for non-zero V:
             * * apply preconditioner to X0
             * * compare reference model against implementation being tested
             */
            inexactlbfgspreconditioner(&s0, n, &vd, &vc, &va, k, &buf, _state);
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(wereerrors, ae_fp_greater(ae_fabs(s2.ptr.p_double[i]-s0.ptr.p_double[i], _state),tolg), __FILE__, __LINE__, "testoptservunit.ap:236");
            }
            
            /*
             * Second test - N-K zero rows appended to V and rows are
             * randomly reordered. Doing so should not change result,
             * algorithm must be able to order rows according to second derivative
             * and skip zero updates.
             */
            for(i=0; i<=n-1; i++)
            {
                i0 = i+hqrnduniformi(&rs, n-i, _state);
                v = vc.ptr.p_double[i];
                vc.ptr.p_double[i] = vc.ptr.p_double[i0];
                vc.ptr.p_double[i0] = v;
                for(j=0; j<=n-1; j++)
                {
                    v = va.ptr.pp_double[i][j];
                    va.ptr.pp_double[i][j] = va.ptr.pp_double[i0][j];
                    va.ptr.pp_double[i0][j] = v;
                }
            }
            inexactlbfgspreconditioner(&s1, n, &vd, &vc, &va, n, &buf, _state);
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(wereerrors, ae_fp_greater(ae_fabs(s2.ptr.p_double[i]-s1.ptr.p_double[i], _state),tolg), __FILE__, __LINE__, "testoptservunit.ap:259");
            }
        }
    }
    
    /*
     * Test for exact low-rank preconditioner.
     *
     * We generate QP problem 0.5*x'*H*x, with random H=D+V'*C*V.
     * Different K's, from 0 to N, are tried. We test preconditioner
     * code which uses Woodbury update against reference implementation
     * which performs straightforward matrix inversion.
     *
     * For each K we perform two tests: first for KxN non-zero matrix V,
     * second one for NxN matrix V with randomly appended N-K zero rows.
     * Last test checks algorithm's ability to handle zero updates.
     */
    tolg = 1.0E-9;
    for(n=1; n<=10; n++)
    {
        for(k=0; k<=n; k++)
        {
            
            /*
             * Prepare problem:
             * * VD, VC, VA
             * * trial vector S (copies are stored to S0,S1,S2)
             */
            ae_vector_set_length(&vd, n, _state);
            ae_vector_set_length(&s0, n, _state);
            ae_vector_set_length(&s1, n, _state);
            ae_vector_set_length(&s2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                vd.ptr.p_double[i] = ae_exp(hqrndnormal(&rs, _state), _state);
                s0.ptr.p_double[i] = hqrndnormal(&rs, _state);
                s1.ptr.p_double[i] = s0.ptr.p_double[i];
                s2.ptr.p_double[i] = s0.ptr.p_double[i];
            }
            rmatrixrndcond(n, 1.0E2, &va, _state);
            rvectorsetlengthatleast(&vc, n, _state);
            for(i=0; i<=k-1; i++)
            {
                vc.ptr.p_double[i] = ae_exp(hqrndnormal(&rs, _state), _state);
            }
            for(i=k; i<=n-1; i++)
            {
                vc.ptr.p_double[i] = (double)(0);
                for(j=0; j<=n-1; j++)
                {
                    va.ptr.pp_double[i][j] = 0.0;
                }
            }
            
            /*
             * Generate reference model and apply it to S2
             */
            ae_matrix_set_length(&bk, n, n, _state);
            ae_vector_set_length(&tmp, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i==j )
                    {
                        v = vd.ptr.p_double[i];
                    }
                    else
                    {
                        v = 0.0;
                    }
                    for(j1=0; j1<=k-1; j1++)
                    {
                        v = v+va.ptr.pp_double[j1][i]*vc.ptr.p_double[j1]*va.ptr.pp_double[j1][j];
                    }
                    bk.ptr.pp_double[i][j] = v;
                }
            }
            rmatrixinverse(&bk, n, &j, &rep, _state);
            ae_assert(j>0, "Assertion failed", _state);
            for(i=0; i<=n-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+bk.ptr.pp_double[i][j]*s2.ptr.p_double[j];
                }
                tmp.ptr.p_double[i] = v;
            }
            for(i=0; i<=n-1; i++)
            {
                s2.ptr.p_double[i] = tmp.ptr.p_double[i];
            }
            
            /*
             * First test for non-zero V:
             * * apply preconditioner to X0
             * * compare reference model against implementation being tested
             */
            preparelowrankpreconditioner(&vd, &vc, &va, n, k, &lowrankbuf, _state);
            applylowrankpreconditioner(&s0, &lowrankbuf, _state);
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(wereerrors, ae_fp_greater(ae_fabs(s2.ptr.p_double[i]-s0.ptr.p_double[i], _state),tolg), __FILE__, __LINE__, "testoptservunit.ap:341");
            }
            
            /*
             * Second test - N-K zero rows appended to V and rows are
             * randomly reordered. Doing so should not change result,
             * algorithm must be able to order rows according to second derivative
             * and skip zero updates.
             */
            for(i=0; i<=n-1; i++)
            {
                i0 = i+hqrnduniformi(&rs, n-i, _state);
                v = vc.ptr.p_double[i];
                vc.ptr.p_double[i] = vc.ptr.p_double[i0];
                vc.ptr.p_double[i0] = v;
                for(j=0; j<=n-1; j++)
                {
                    v = va.ptr.pp_double[i][j];
                    va.ptr.pp_double[i][j] = va.ptr.pp_double[i0][j];
                    va.ptr.pp_double[i0][j] = v;
                }
            }
            preparelowrankpreconditioner(&vd, &vc, &va, n, n, &lowrankbuf, _state);
            applylowrankpreconditioner(&s1, &lowrankbuf, _state);
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(wereerrors, ae_fp_greater(ae_fabs(s2.ptr.p_double[i]-s1.ptr.p_double[i], _state),tolg), __FILE__, __LINE__, "testoptservunit.ap:365");
            }
        }
    }
    ae_frame_leave(_state);
}








ae_bool testsnnls(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool test0errors;
    ae_bool test1errors;
    ae_bool test2errors;
    ae_bool testnewtonerrors;
    ae_bool waserrors;
    double eps;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_int_t ns;
    ae_int_t nd;
    ae_int_t nr;
    ae_matrix densea;
    ae_matrix effectivea;
    ae_vector isconstrained;
    ae_vector g;
    ae_vector b;
    ae_vector x;
    ae_vector xs;
    snnlssolver s;
    hqrndstate rs;
    double rho;
    double xtol;
    ae_int_t nmax;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&densea, 0, sizeof(densea));
    memset(&effectivea, 0, sizeof(effectivea));
    memset(&isconstrained, 0, sizeof(isconstrained));
    memset(&g, 0, sizeof(g));
    memset(&b, 0, sizeof(b));
    memset(&x, 0, sizeof(x));
    memset(&xs, 0, sizeof(xs));
    memset(&s, 0, sizeof(s));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&densea, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&effectivea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&isconstrained, 0, DT_BOOL, _state, ae_true);
    ae_vector_init(&g, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xs, 0, DT_REAL, _state, ae_true);
    _snnlssolver_init(&s, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    test0errors = ae_false;
    test1errors = ae_false;
    test2errors = ae_false;
    testnewtonerrors = ae_false;
    waserrors = ae_false;
    hqrndrandomize(&rs, _state);
    nmax = 10;
    
    /*
     * Test 2 (comes first because it is very basic):
     * * NS=0
     * * ND in [1,NMAX]
     * * NR=ND
     * * DenseA is diagonal with positive entries
     * * B is random
     * * random constraints
     * Exact solution is known and can be tested
     */
    eps = 1.0E-12;
    for(nd=1; nd<=nmax; nd++)
    {
        
        /*
         * Generate problem
         */
        ns = 0;
        nr = nd;
        ae_matrix_set_length(&densea, nd, nd, _state);
        ae_vector_set_length(&b, nd, _state);
        ae_vector_set_length(&isconstrained, nd, _state);
        for(i=0; i<=nd-1; i++)
        {
            for(j=0; j<=nd-1; j++)
            {
                densea.ptr.pp_double[i][j] = (double)(0);
            }
            densea.ptr.pp_double[i][i] = (double)(1+hqrnduniformi(&rs, 2, _state));
            b.ptr.p_double[i] = (double)((1+hqrnduniformi(&rs, 2, _state))*(2*hqrnduniformi(&rs, 2, _state)-1));
            isconstrained.ptr.p_bool[i] = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
        }
        
        /*
         * Solve with SNNLS solver
         */
        snnlsinit(0, 0, 0, &s, _state);
        snnlssetproblem(&s, &densea, &b, 0, nd, nd, _state);
        for(i=0; i<=nd-1; i++)
        {
            if( !isconstrained.ptr.p_bool[i] )
            {
                snnlsdropnnc(&s, i, _state);
            }
        }
        snnlssolve(&s, &x, _state);
        
        /*
         * Check
         */
        for(i=0; i<=nd-1; i++)
        {
            if( isconstrained.ptr.p_bool[i] )
            {
                ae_set_error_flag(&test2errors, ae_fp_greater(ae_fabs(x.ptr.p_double[i]-ae_maxreal(b.ptr.p_double[i]/densea.ptr.pp_double[i][i], 0.0, _state), _state),eps), __FILE__, __LINE__, "testsnnlsunit.ap:86");
                ae_set_error_flag(&test2errors, ae_fp_less(x.ptr.p_double[i],0.0), __FILE__, __LINE__, "testsnnlsunit.ap:87");
            }
            else
            {
                ae_set_error_flag(&test2errors, ae_fp_greater(ae_fabs(x.ptr.p_double[i]-b.ptr.p_double[i]/densea.ptr.pp_double[i][i], _state),eps), __FILE__, __LINE__, "testsnnlsunit.ap:90");
            }
        }
    }
    
    /*
     * Test 0:
     * * NS in [0,NMAX]
     * * ND in [0,NMAX]
     * * NR in [NS,NS+ND+NMAX]
     * * NS+ND>0, NR>0
     * * about 50% of variables are constrained
     * * we check that constrained gradient is small at the solution
     */
    eps = 1.0E-5;
    for(ns=0; ns<=nmax; ns++)
    {
        for(nd=0; nd<=nmax; nd++)
        {
            for(nr=ns; nr<=ns+nd+nmax; nr++)
            {
                
                /*
                 * Skip NS+ND=0, NR=0
                 */
                if( ns+nd==0 )
                {
                    continue;
                }
                if( nr==0 )
                {
                    continue;
                }
                
                /*
                 * Generate problem:
                 * * DenseA, array[NR,ND]
                 * * EffectiveA, array[NR,NS+ND]
                 * * B, array[NR]
                 * * IsConstrained, array[NS+ND]
                 */
                if( nd>0 )
                {
                    ae_matrix_set_length(&densea, nr, nd, _state);
                    for(i=0; i<=nr-1; i++)
                    {
                        for(j=0; j<=nd-1; j++)
                        {
                            densea.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                }
                ae_matrix_set_length(&effectivea, nr, ns+nd, _state);
                for(i=0; i<=nr-1; i++)
                {
                    for(j=0; j<=ns+nd-1; j++)
                    {
                        effectivea.ptr.pp_double[i][j] = 0.0;
                    }
                }
                for(i=0; i<=ns-1; i++)
                {
                    effectivea.ptr.pp_double[i][i] = 1.0;
                }
                for(i=0; i<=nr-1; i++)
                {
                    for(j=0; j<=nd-1; j++)
                    {
                        effectivea.ptr.pp_double[i][ns+j] = densea.ptr.pp_double[i][j];
                    }
                }
                ae_vector_set_length(&b, nr, _state);
                for(i=0; i<=nr-1; i++)
                {
                    b.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                ae_vector_set_length(&isconstrained, ns+nd, _state);
                for(i=0; i<=ns+nd-1; i++)
                {
                    isconstrained.ptr.p_bool[i] = ae_fp_greater(ae_randomreal(_state),0.5);
                }
                
                /*
                 * Solve with SNNLS solver
                 */
                snnlsinit(0, 0, 0, &s, _state);
                snnlssetproblem(&s, &densea, &b, ns, nd, nr, _state);
                for(i=0; i<=ns+nd-1; i++)
                {
                    if( !isconstrained.ptr.p_bool[i] )
                    {
                        snnlsdropnnc(&s, i, _state);
                    }
                }
                snnlssolve(&s, &x, _state);
                
                /*
                 * Check non-negativity
                 */
                for(i=0; i<=ns+nd-1; i++)
                {
                    ae_set_error_flag(&test0errors, isconstrained.ptr.p_bool[i]&&ae_fp_less(x.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testsnnlsunit.ap:160");
                }
                
                /*
                 * Calculate gradient A'*A*x-b'*A.
                 * Check projected gradient (each component must be less than Eps).
                 */
                ae_vector_set_length(&g, ns+nd, _state);
                for(i=0; i<=ns+nd-1; i++)
                {
                    v = ae_v_dotproduct(&b.ptr.p_double[0], 1, &effectivea.ptr.pp_double[0][i], effectivea.stride, ae_v_len(0,nr-1));
                    g.ptr.p_double[i] = -v;
                }
                for(i=0; i<=nr-1; i++)
                {
                    v = ae_v_dotproduct(&effectivea.ptr.pp_double[i][0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,ns+nd-1));
                    ae_v_addd(&g.ptr.p_double[0], 1, &effectivea.ptr.pp_double[i][0], 1, ae_v_len(0,ns+nd-1), v);
                }
                for(i=0; i<=ns+nd-1; i++)
                {
                    if( !isconstrained.ptr.p_bool[i]||ae_fp_greater(x.ptr.p_double[i],(double)(0)) )
                    {
                        ae_set_error_flag(&test0errors, ae_fp_greater(ae_fabs(g.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsnnlsunit.ap:179");
                    }
                    else
                    {
                        ae_set_error_flag(&test0errors, ae_fp_less(g.ptr.p_double[i],-eps), __FILE__, __LINE__, "testsnnlsunit.ap:181");
                    }
                }
            }
        }
    }
    
    /*
     * Test 1: ability of the solver to take very short steps.
     *
     * We solve problem similar to one solver in test 0, but with
     * progressively decreased magnitude of variables. We generate
     * problem with already-known solution and compare results against it.
     */
    xtol = 1.0E-7;
    for(ns=0; ns<=nmax; ns++)
    {
        for(nd=0; nd<=nmax; nd++)
        {
            for(nr=ns; nr<=ns+nd+nmax; nr++)
            {
                for(k=0; k<=20; k++)
                {
                    
                    /*
                     * Skip NS+ND=0, NR=0
                     *
                     * Skip degenerate problems (NR<NS+ND) - important for this particular test.
                     */
                    if( ns+nd==0 )
                    {
                        continue;
                    }
                    if( nr==0 )
                    {
                        continue;
                    }
                    if( nr<ns+nd )
                    {
                        continue;
                    }
                    
                    /*
                     * Generate problem:
                     * * DenseA, array[NR,ND]
                     * * EffectiveA, array[NR,NS+ND]
                     * * B, array[NR]
                     * * IsConstrained, array[NS+ND]
                     */
                    rho = ae_pow((double)(10), (double)(-k), _state);
                    if( nd>0 )
                    {
                        ae_matrix_set_length(&densea, nr, nd, _state);
                        for(i=0; i<=nr-1; i++)
                        {
                            for(j=0; j<=nd-1; j++)
                            {
                                densea.ptr.pp_double[i][j] = 2*hqrnduniformr(&rs, _state)-1;
                            }
                        }
                    }
                    ae_matrix_set_length(&effectivea, nr, ns+nd, _state);
                    for(i=0; i<=nr-1; i++)
                    {
                        for(j=0; j<=ns+nd-1; j++)
                        {
                            effectivea.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                    for(i=0; i<=ns-1; i++)
                    {
                        effectivea.ptr.pp_double[i][i] = 1.0;
                    }
                    for(i=0; i<=nr-1; i++)
                    {
                        for(j=0; j<=nd-1; j++)
                        {
                            effectivea.ptr.pp_double[i][ns+j] = densea.ptr.pp_double[i][j];
                        }
                    }
                    ae_vector_set_length(&xs, ns+nd, _state);
                    ae_vector_set_length(&isconstrained, ns+nd, _state);
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        xs.ptr.p_double[i] = rho*(hqrnduniformr(&rs, _state)-0.5);
                        isconstrained.ptr.p_bool[i] = ae_fp_greater(xs.ptr.p_double[i],0.0);
                    }
                    ae_vector_set_length(&b, nr, _state);
                    for(i=0; i<=nr-1; i++)
                    {
                        v = 0.0;
                        for(j=0; j<=ns+nd-1; j++)
                        {
                            v = v+effectivea.ptr.pp_double[i][j]*xs.ptr.p_double[j];
                        }
                        b.ptr.p_double[i] = v;
                    }
                    
                    /*
                     * Solve with SNNLS solver
                     */
                    snnlsinit(0, 0, 0, &s, _state);
                    snnlssetproblem(&s, &densea, &b, ns, nd, nr, _state);
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        if( !isconstrained.ptr.p_bool[i] )
                        {
                            snnlsdropnnc(&s, i, _state);
                        }
                    }
                    snnlssolve(&s, &x, _state);
                    
                    /*
                     * Check non-negativity
                     */
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        ae_set_error_flag(&test1errors, isconstrained.ptr.p_bool[i]&&ae_fp_less(x.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testsnnlsunit.ap:263");
                    }
                    
                    /*
                     * Compare with true solution
                     */
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        ae_set_error_flag(&test1errors, ae_fp_greater(ae_fabs(xs.ptr.p_double[i]-x.ptr.p_double[i], _state),rho*xtol), __FILE__, __LINE__, "testsnnlsunit.ap:269");
                    }
                }
            }
        }
    }
    
    /*
     * Test for Newton phase:
     * * NS in [0,NMAX]
     * * ND in [0,NMAX]
     * * NR in [NS,NS+ND+NMAX]
     * * NS+ND>0, NR>0
     * * all variables are unconstrained
     * * S.DebugMaxNewton is set to 1, S.RefinementIts is set to 1,
     *   i.e. algorithm is terminated after one Newton iteration, and no
     *   iterative refinement is used.
     * * we test that gradient is small at solution, i.e. one Newton iteration
     *   on unconstrained problem is enough to find solution. In case of buggy
     *   Newton solver one iteration won't move us to the solution - it may
     *   decrease function value, but won't find exact solution.
     *
     * This test is intended to catch subtle bugs in the Newton solver which
     * do NOT prevent algorithm from converging to the solution, but slow it
     * down (convergence becomes linear or even slower).
     */
    eps = 1.0E-4;
    for(ns=0; ns<=nmax; ns++)
    {
        for(nd=0; nd<=nmax; nd++)
        {
            for(nr=ns; nr<=ns+nd+nmax; nr++)
            {
                
                /*
                 * Skip NS+ND=0, NR=0
                 */
                if( ns+nd==0 )
                {
                    continue;
                }
                if( nr==0 )
                {
                    continue;
                }
                
                /*
                 * Generate problem:
                 * * DenseA, array[NR,ND]
                 * * EffectiveA, array[NR,NS+ND]
                 * * B, array[NR]
                 * * IsConstrained, array[NS+ND]
                 */
                if( nd>0 )
                {
                    ae_matrix_set_length(&densea, nr, nd, _state);
                    for(i=0; i<=nr-1; i++)
                    {
                        for(j=0; j<=nd-1; j++)
                        {
                            densea.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
                        }
                    }
                }
                ae_matrix_set_length(&effectivea, nr, ns+nd, _state);
                for(i=0; i<=nr-1; i++)
                {
                    for(j=0; j<=ns+nd-1; j++)
                    {
                        effectivea.ptr.pp_double[i][j] = 0.0;
                    }
                }
                for(i=0; i<=ns-1; i++)
                {
                    effectivea.ptr.pp_double[i][i] = 1.0;
                }
                for(i=0; i<=nr-1; i++)
                {
                    for(j=0; j<=nd-1; j++)
                    {
                        effectivea.ptr.pp_double[i][ns+j] = densea.ptr.pp_double[i][j];
                    }
                }
                ae_vector_set_length(&b, nr, _state);
                for(i=0; i<=nr-1; i++)
                {
                    b.ptr.p_double[i] = hqrndnormal(&rs, _state);
                }
                
                /*
                 * Solve with SNNLS solver
                 */
                snnlsinit(0, 0, 0, &s, _state);
                snnlssetproblem(&s, &densea, &b, ns, nd, nr, _state);
                for(i=0; i<=ns+nd-1; i++)
                {
                    snnlsdropnnc(&s, i, _state);
                }
                s.debugmaxinnerits = 1;
                snnlssolve(&s, &x, _state);
                
                /*
                 * Calculate gradient A'*A*x-b'*A.
                 * Check projected gradient (each component must be less than Eps).
                 */
                ae_vector_set_length(&g, ns+nd, _state);
                for(i=0; i<=ns+nd-1; i++)
                {
                    v = ae_v_dotproduct(&b.ptr.p_double[0], 1, &effectivea.ptr.pp_double[0][i], effectivea.stride, ae_v_len(0,nr-1));
                    g.ptr.p_double[i] = -v;
                }
                for(i=0; i<=nr-1; i++)
                {
                    v = ae_v_dotproduct(&effectivea.ptr.pp_double[i][0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,ns+nd-1));
                    ae_v_addd(&g.ptr.p_double[0], 1, &effectivea.ptr.pp_double[i][0], 1, ae_v_len(0,ns+nd-1), v);
                }
                for(i=0; i<=ns+nd-1; i++)
                {
                    ae_set_error_flag(&testnewtonerrors, ae_fp_greater(ae_fabs(g.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsnnlsunit.ap:358");
                }
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ((test0errors||test1errors)||test2errors)||testnewtonerrors;
    if( !silent )
    {
        printf("TESTING SPECIAL NNLS SOLVER\n");
        printf("TEST 0:                                   ");
        if( test0errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TEST 1:                                   ");
        if( test1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TEST 2:                                   ");
        if( test2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("NEWTON PHASE:                             ");
        if( testnewtonerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static void testsactivesetsunit_testspecproperties(ae_bool* err,
     ae_state *_state);





ae_bool testsactivesets(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool specerr;
    ae_bool result;


    specerr = ae_false;
    testsactivesetsunit_testspecproperties(&specerr, _state);
    
    /*
     * report
     */
    waserrors = specerr;
    if( !silent )
    {
        printf("TESTING ACTIVE SETS\n");
        printf("* SPECIAL PROPERTIES                      ");
        if( specerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
This function tests special properties.

On failure sets Err to True (leaves it unchanged otherwise)
*************************************************************************/
static void testsactivesetsunit_testspecproperties(ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t nec;
    ae_int_t nic;
    double v;
    double vv;
    sactiveset state;
    hqrndstate rs;
    ae_vector bl;
    ae_vector bu;
    ae_vector x;
    ae_vector s;
    ae_matrix c;
    ae_vector ct;
    ae_int_t scaletype;
    ae_int_t pass;
    ae_int_t distortidx;
    double distortmag;

    ae_frame_make(_state, &_frame_block);
    memset(&state, 0, sizeof(state));
    memset(&rs, 0, sizeof(rs));
    memset(&bl, 0, sizeof(bl));
    memset(&bu, 0, sizeof(bu));
    memset(&x, 0, sizeof(x));
    memset(&s, 0, sizeof(s));
    memset(&c, 0, sizeof(c));
    memset(&ct, 0, sizeof(ct));
    _sactiveset_init(&state, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);
    ae_vector_init(&bl, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bu, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ct, 0, DT_INT, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * N-dimensional problem with Ne equality and Ni inequality constraints.
     *
     * Check that SActiveSet object uses efficient algorithm
     * to determine initial point: it avoids expensive (N+Ni)-dimensional
     * QP subproblem when initial point is feasible w.r.t. constraints.
     *
     * In order to do so we try to find initial point for a problem with
     * 2 equality constraints and 1000000 inequality constraints (+box
     * constraints). Inefficient algorithm will simply fail to allocate
     * enough memory, so we do not have to perform any checks here.
     */
    n = 5;
    nec = 2;
    nic = 1000000;
    ae_vector_set_length(&x, n, _state);
    ae_vector_set_length(&bl, n, _state);
    ae_vector_set_length(&bu, n, _state);
    for(scaletype=0; scaletype<=1; scaletype++)
    {
        
        /*
         * Generate problem
         */
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = hqrnduniformr(&rs, _state);
            bl.ptr.p_double[i] = x.ptr.p_double[i]-hqrnduniformr(&rs, _state)*hqrnduniformi(&rs, 2, _state);
            bu.ptr.p_double[i] = x.ptr.p_double[i]+hqrnduniformr(&rs, _state)*hqrnduniformi(&rs, 2, _state);
        }
        ae_matrix_set_length(&c, nec+nic, n+1, _state);
        ae_vector_set_length(&ct, nec+nic, _state);
        for(i=0; i<=nec+nic-1; i++)
        {
            v = (double)(0);
            for(j=0; j<=n-1; j++)
            {
                c.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
                v = v+c.ptr.pp_double[i][j]*x.ptr.p_double[j];
            }
            c.ptr.pp_double[i][n] = v;
            if( i<nec )
            {
                ct.ptr.p_int[i] = 0;
            }
            else
            {
                c.ptr.pp_double[i][n] = c.ptr.pp_double[i][n]+0.1;
                ct.ptr.p_int[i] = -1;
            }
        }
        
        /*
         * Apply scaling (if needed), then randomly multiply C by
         * some large/small value in order to distort magnitude of
         * linear constraints.
         *
         * Correct SActiveSet implementation must be able to renormalize
         * constraints prior to checking feasibility of initial point.
         */
        ae_vector_set_length(&s, n, _state);
        for(i=0; i<=n-1; i++)
        {
            s.ptr.p_double[i] = (double)(1);
            if( scaletype!=0 )
            {
                s.ptr.p_double[i] = ae_pow((double)(10), 40*hqrnduniformr(&rs, _state)-20, _state);
            }
            x.ptr.p_double[i] = x.ptr.p_double[i]*s.ptr.p_double[i];
            bl.ptr.p_double[i] = bl.ptr.p_double[i]*s.ptr.p_double[i];
            bu.ptr.p_double[i] = bu.ptr.p_double[i]*s.ptr.p_double[i];
            for(j=0; j<=nec+nic-1; j++)
            {
                c.ptr.pp_double[j][i] = c.ptr.pp_double[j][i]/s.ptr.p_double[i];
            }
        }
        for(i=0; i<=nec+nic-1; i++)
        {
            v = ae_pow((double)(10), 40*hqrnduniformr(&rs, _state)-20, _state);
            ae_v_muld(&c.ptr.pp_double[i][0], 1, ae_v_len(0,n), v);
        }
        
        /*
         * Solve.
         * Simply being able to survive SASStartOptimization() call is enough for this test
         */
        sasinit(n, &state, _state);
        sassetscale(&state, &s, _state);
        sassetbc(&state, &bl, &bu, _state);
        sassetlc(&state, &c, &ct, nec+nic, _state);
        sasstartoptimization(&state, &x, _state);
    }
    
    /*
     * Test that algorithm can correctly distinguish between feasible
     * and non-feasible initial points. In order to do so we try to
     * call SASStartOptimization() for moderately sized problem and
     * examine State.FeasInitPt flag after call is done.
     *
     * This test is performed for equality-only constraints
     */
    for(pass=1; pass<=10; pass++)
    {
        n = 50+hqrnduniformi(&rs, 10, _state);
        nec = 10+hqrnduniformi(&rs, 10, _state);
        nic = 0;
        ae_vector_set_length(&x, n, _state);
        for(scaletype=0; scaletype<=1; scaletype++)
        {
            
            /*
             * Generate problem, prepare distortion which introduces infeasibility
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = hqrnduniformr(&rs, _state);
            }
            ae_matrix_set_length(&c, nec+nic, n+1, _state);
            ae_vector_set_length(&ct, nec+nic, _state);
            for(i=0; i<=nec+nic-1; i++)
            {
                v = (double)(0);
                vv = (double)(0);
                for(j=0; j<=n-1; j++)
                {
                    c.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
                    vv = vv+ae_sqr(c.ptr.pp_double[i][j], _state);
                    v = v+c.ptr.pp_double[i][j]*x.ptr.p_double[j];
                }
                c.ptr.pp_double[i][n] = v;
                vv = coalesce(vv, (double)(1), _state);
                vv = 1/ae_sqrt(vv, _state);
                ae_v_muld(&c.ptr.pp_double[i][0], 1, ae_v_len(0,n), vv);
                ct.ptr.p_int[i] = 0;
            }
            distortidx = hqrnduniformi(&rs, n, _state);
            distortmag = (double)(0);
            for(i=0; i<=nec+nic-1; i++)
            {
                distortmag = ae_maxreal(distortmag, ae_fabs(c.ptr.pp_double[i][distortidx], _state), _state);
            }
            ae_assert(ae_fp_greater(distortmag,(double)(0)), "Assertion failed", _state);
            distortmag = 1.0E7*ae_machineepsilon/distortmag;
            
            /*
             * Apply scaling (if needed), then randomly multiply C by
             * some large/small value in order to distort magnitude of
             * linear constraints.
             *
             * Correct SActiveSet implementation must be able to renormalize
             * constraints prior to checking feasibility of initial point.
             */
            ae_vector_set_length(&s, n, _state);
            for(i=0; i<=n-1; i++)
            {
                s.ptr.p_double[i] = (double)(1);
                if( scaletype!=0 )
                {
                    s.ptr.p_double[i] = ae_pow((double)(10), 40*hqrnduniformr(&rs, _state)-20, _state);
                }
                x.ptr.p_double[i] = x.ptr.p_double[i]*s.ptr.p_double[i];
                for(j=0; j<=nec+nic-1; j++)
                {
                    c.ptr.pp_double[j][i] = c.ptr.pp_double[j][i]/s.ptr.p_double[i];
                }
            }
            for(i=0; i<=nec+nic-1; i++)
            {
                v = ae_pow((double)(10), 40*hqrnduniformr(&rs, _state)-20, _state);
                ae_v_muld(&c.ptr.pp_double[i][0], 1, ae_v_len(0,n), v);
            }
            
            /*
             * Solve for feasible initial X and check State.FeasInitPt flag
             */
            sasinit(n, &state, _state);
            sassetscale(&state, &s, _state);
            sassetlc(&state, &c, &ct, nec+nic, _state);
            sasstartoptimization(&state, &x, _state);
            ae_set_error_flag(err, !state.feasinitpt, __FILE__, __LINE__, "testsactivesetsunit.ap:225");
            
            /*
             * Solve for infeasible initial X and check State.FeasInitPt flag
             */
            x.ptr.p_double[distortidx] = x.ptr.p_double[distortidx]+s.ptr.p_double[distortidx]*distortmag;
            sasinit(n, &state, _state);
            sassetscale(&state, &s, _state);
            sassetlc(&state, &c, &ct, nec+nic, _state);
            sasstartoptimization(&state, &x, _state);
            ae_set_error_flag(err, state.feasinitpt, __FILE__, __LINE__, "testsactivesetsunit.ap:235");
        }
    }
    ae_frame_leave(_state);
}








ae_bool testlinmin(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool result;


    waserrors = ae_false;
    if( !silent )
    {
        printf("TESTING LINMIN\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}



static void testminlbfgsunit_testfunc2(minlbfgsstate* state,
     ae_state *_state);
static void testminlbfgsunit_testfunc3(minlbfgsstate* state,
     ae_state *_state);
static void testminlbfgsunit_calciip2(minlbfgsstate* state,
     ae_int_t n,
     ae_state *_state);
static void testminlbfgsunit_testpreconditioning(ae_bool* err,
     ae_state *_state);
static void testminlbfgsunit_testother(ae_bool* err, ae_state *_state);
static ae_bool testminlbfgsunit_gradientchecktest(ae_state *_state);
static void testminlbfgsunit_funcderiv(double a,
     double b,
     double c,
     double d,
     double x0,
     double x1,
     double x2,
     /* Real    */ ae_vector* x,
     ae_int_t functype,
     double* f,
     /* Real    */ ae_vector* g,
     ae_state *_state);





ae_bool testminlbfgs(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_bool referror;
    ae_bool nonconverror;
    ae_bool eqerror;
    ae_bool converror;
    ae_bool crashtest;
    ae_bool othererrors;
    ae_bool restartserror;
    ae_bool precerror;
    ae_bool graderrors;
    ae_int_t n;
    ae_int_t m;
    ae_vector x;
    ae_vector xe;
    ae_vector b;
    ae_vector xlast;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_matrix a;
    ae_vector diagh;
    ae_int_t maxits;
    minlbfgsstate state;
    minlbfgsreport rep;
    double diffstep;
    ae_int_t dkind;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    memset(&xlast, 0, sizeof(xlast));
    memset(&a, 0, sizeof(a));
    memset(&diagh, 0, sizeof(diagh));
    memset(&state, 0, sizeof(state));
    memset(&rep, 0, sizeof(rep));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xe, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xlast, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&diagh, 0, DT_REAL, _state, ae_true);
    _minlbfgsstate_init(&state, _state, ae_true);
    _minlbfgsreport_init(&rep, _state, ae_true);

    waserrors = ae_false;
    referror = ae_false;
    precerror = ae_false;
    nonconverror = ae_false;
    restartserror = ae_false;
    eqerror = ae_false;
    converror = ae_false;
    crashtest = ae_false;
    othererrors = ae_false;
    testminlbfgsunit_testpreconditioning(&precerror, _state);
    testminlbfgsunit_testother(&othererrors, _state);
    
    /*
     * Reference problem
     */
    diffstep = 1.0E-6;
    for(dkind=0; dkind<=1; dkind++)
    {
        ae_vector_set_length(&x, 3, _state);
        n = 3;
        m = 2;
        x.ptr.p_double[0] = 100*ae_randomreal(_state)-50;
        x.ptr.p_double[1] = 100*ae_randomreal(_state)-50;
        x.ptr.p_double[2] = 100*ae_randomreal(_state)-50;
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), 0, _state);
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needf||state.needfg )
            {
                state.f = ae_sqr(state.x.ptr.p_double[0]-2, _state)+ae_sqr(state.x.ptr.p_double[1], _state)+ae_sqr(state.x.ptr.p_double[2]-state.x.ptr.p_double[0], _state);
            }
            if( state.needfg )
            {
                state.g.ptr.p_double[0] = 2*(state.x.ptr.p_double[0]-2)+2*(state.x.ptr.p_double[0]-state.x.ptr.p_double[2]);
                state.g.ptr.p_double[1] = 2*state.x.ptr.p_double[1];
                state.g.ptr.p_double[2] = 2*(state.x.ptr.p_double[2]-state.x.ptr.p_double[0]);
            }
        }
        minlbfgsresults(&state, &x, &rep, _state);
        referror = (((referror||rep.terminationtype<=0)||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-2, _state),0.001))||ae_fp_greater(ae_fabs(x.ptr.p_double[1], _state),0.001))||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-2, _state),0.001);
    }
    
    /*
     * nonconvex problems with complex surface: we start from point with very small
     * gradient, but we need ever smaller gradient in the next step due to
     * Wolfe conditions.
     */
    diffstep = 1.0E-6;
    for(dkind=0; dkind<=1; dkind++)
    {
        ae_vector_set_length(&x, 1, _state);
        n = 1;
        m = 1;
        v = (double)(-100);
        while(ae_fp_less(v,0.1))
        {
            x.ptr.p_double[0] = v;
            if( dkind==0 )
            {
                minlbfgscreate(n, m, &x, &state, _state);
            }
            if( dkind==1 )
            {
                minlbfgscreatef(n, m, &x, diffstep, &state, _state);
            }
            minlbfgssetcond(&state, 1.0E-9, (double)(0), (double)(0), 0, _state);
            while(minlbfgsiteration(&state, _state))
            {
                if( state.needf||state.needfg )
                {
                    state.f = ae_sqr(state.x.ptr.p_double[0], _state)/(1+ae_sqr(state.x.ptr.p_double[0], _state));
                }
                if( state.needfg )
                {
                    state.g.ptr.p_double[0] = (2*state.x.ptr.p_double[0]*(1+ae_sqr(state.x.ptr.p_double[0], _state))-ae_sqr(state.x.ptr.p_double[0], _state)*2*state.x.ptr.p_double[0])/ae_sqr(1+ae_sqr(state.x.ptr.p_double[0], _state), _state);
                }
            }
            minlbfgsresults(&state, &x, &rep, _state);
            nonconverror = (nonconverror||rep.terminationtype<=0)||ae_fp_greater(ae_fabs(x.ptr.p_double[0], _state),0.001);
            v = v+0.1;
        }
    }
    
    /*
     * F2 problem with restarts:
     * * make several iterations and restart BEFORE termination
     * * iterate and restart AFTER termination
     *
     * NOTE: step is bounded from above to avoid premature convergence
     */
    diffstep = 1.0E-6;
    for(dkind=0; dkind<=1; dkind++)
    {
        ae_vector_set_length(&x, 3, _state);
        n = 3;
        m = 2;
        x.ptr.p_double[0] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[1] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[2] = 10+10*ae_randomreal(_state);
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetstpmax(&state, 0.1, _state);
        minlbfgssetcond(&state, 0.0000001, 0.0, 0.0, 0, _state);
        for(i=0; i<=10; i++)
        {
            if( !minlbfgsiteration(&state, _state) )
            {
                break;
            }
            testminlbfgsunit_testfunc2(&state, _state);
        }
        x.ptr.p_double[0] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[1] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[2] = 10+10*ae_randomreal(_state);
        minlbfgsrestartfrom(&state, &x, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc2(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        restartserror = (((restartserror||rep.terminationtype<=0)||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-ae_log((double)(2), _state), _state),0.01))||ae_fp_greater(ae_fabs(x.ptr.p_double[1], _state),0.01))||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-ae_log((double)(2), _state), _state),0.01);
        x.ptr.p_double[0] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[1] = 10+10*ae_randomreal(_state);
        x.ptr.p_double[2] = 10+10*ae_randomreal(_state);
        minlbfgsrestartfrom(&state, &x, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc2(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        restartserror = (((restartserror||rep.terminationtype<=0)||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-ae_log((double)(2), _state), _state),0.01))||ae_fp_greater(ae_fabs(x.ptr.p_double[1], _state),0.01))||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-ae_log((double)(2), _state), _state),0.01);
    }
    
    /*
     * Linear equations
     */
    diffstep = 1.0E-6;
    for(n=1; n<=10; n++)
    {
        
        /*
         * Prepare task
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        ae_vector_set_length(&x, n-1+1, _state);
        ae_vector_set_length(&xe, n-1+1, _state);
        ae_vector_set_length(&b, n-1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            a.ptr.pp_double[i][i] = a.ptr.pp_double[i][i]+3*ae_sign(a.ptr.pp_double[i][i], _state);
        }
        for(i=0; i<=n-1; i++)
        {
            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
            b.ptr.p_double[i] = v;
        }
        
        /*
         * Test different M/DKind
         */
        for(m=1; m<=n; m++)
        {
            for(dkind=0; dkind<=1; dkind++)
            {
                
                /*
                 * Solve task
                 */
                for(i=0; i<=n-1; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                if( dkind==0 )
                {
                    minlbfgscreate(n, m, &x, &state, _state);
                }
                if( dkind==1 )
                {
                    minlbfgscreatef(n, m, &x, diffstep, &state, _state);
                }
                minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), 0, _state);
                while(minlbfgsiteration(&state, _state))
                {
                    if( state.needf||state.needfg )
                    {
                        state.f = (double)(0);
                    }
                    if( state.needfg )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            state.g.ptr.p_double[i] = (double)(0);
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &state.x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        if( state.needf||state.needfg )
                        {
                            state.f = state.f+ae_sqr(v-b.ptr.p_double[i], _state);
                        }
                        if( state.needfg )
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                state.g.ptr.p_double[j] = state.g.ptr.p_double[j]+2*(v-b.ptr.p_double[i])*a.ptr.pp_double[i][j];
                            }
                        }
                    }
                }
                minlbfgsresults(&state, &x, &rep, _state);
                eqerror = eqerror||rep.terminationtype<=0;
                for(i=0; i<=n-1; i++)
                {
                    eqerror = eqerror||ae_fp_greater(ae_fabs(x.ptr.p_double[i]-xe.ptr.p_double[i], _state),0.001);
                }
            }
        }
    }
    
    /*
     * Testing convergence properties
     */
    diffstep = 1.0E-6;
    for(dkind=0; dkind<=1; dkind++)
    {
        ae_vector_set_length(&x, 3, _state);
        n = 3;
        m = 2;
        for(i=0; i<=2; i++)
        {
            x.ptr.p_double[i] = 6*ae_randomreal(_state)-3;
        }
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, 0.001, (double)(0), (double)(0), 0, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc3(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        converror = converror||rep.terminationtype!=4;
        for(i=0; i<=2; i++)
        {
            x.ptr.p_double[i] = 6*ae_randomreal(_state)-3;
        }
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, (double)(0), 0.001, (double)(0), 0, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc3(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        converror = converror||rep.terminationtype!=1;
        for(i=0; i<=2; i++)
        {
            x.ptr.p_double[i] = 6*ae_randomreal(_state)-3;
        }
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, (double)(0), (double)(0), 0.001, 0, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc3(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        converror = converror||rep.terminationtype!=2;
        for(i=0; i<=2; i++)
        {
            x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), 10, _state);
        while(minlbfgsiteration(&state, _state))
        {
            testminlbfgsunit_testfunc3(&state, _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        converror = (converror||rep.terminationtype!=5)||rep.iterationscount!=10;
    }
    
    /*
     * Crash test: too many iterations on a simple tasks
     * May fail when encounter zero step, underflow or something like that
     */
    ae_vector_set_length(&x, 2+1, _state);
    n = 3;
    m = 2;
    maxits = 10000;
    for(i=0; i<=2; i++)
    {
        x.ptr.p_double[i] = 6*ae_randomreal(_state)-3;
    }
    minlbfgscreate(n, m, &x, &state, _state);
    minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), maxits, _state);
    while(minlbfgsiteration(&state, _state))
    {
        state.f = ae_sqr(ae_exp(state.x.ptr.p_double[0], _state)-2, _state)+ae_sqr(state.x.ptr.p_double[1], _state)+ae_sqr(state.x.ptr.p_double[2]-state.x.ptr.p_double[0], _state);
        state.g.ptr.p_double[0] = 2*(ae_exp(state.x.ptr.p_double[0], _state)-2)*ae_exp(state.x.ptr.p_double[0], _state)+2*(state.x.ptr.p_double[0]-state.x.ptr.p_double[2]);
        state.g.ptr.p_double[1] = 2*state.x.ptr.p_double[1];
        state.g.ptr.p_double[2] = 2*(state.x.ptr.p_double[2]-state.x.ptr.p_double[0]);
    }
    minlbfgsresults(&state, &x, &rep, _state);
    crashtest = crashtest||rep.terminationtype<=0;
    
    /*
     *  Test for MinLBFGSGradientCheck
     */
    graderrors = testminlbfgsunit_gradientchecktest(_state);
    
    /*
     * end
     */
    waserrors = (((((((referror||nonconverror)||eqerror)||converror)||crashtest)||othererrors)||restartserror)||precerror)||graderrors;
    if( !silent )
    {
        printf("TESTING L-BFGS OPTIMIZATION\n");
        printf("REFERENCE PROBLEM:                        ");
        if( referror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("NON-CONVEX PROBLEM:                       ");
        if( nonconverror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LINEAR EQUATIONS:                         ");
        if( eqerror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("RESTARTS:                                 ");
        if( restartserror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("PRECONDITIONER:                           ");
        if( precerror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CONVERGENCE PROPERTIES:                   ");
        if( converror )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CRASH TEST:                               ");
        if( crashtest )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("OTHER PROPERTIES:                         ");
        if( othererrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TEST FOR VERIFICATION OF THE GRADIENT:    ");
        if( graderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Calculate test function #2

Simple variation of #1, much more nonlinear, which makes unlikely premature
convergence of algorithm .
*************************************************************************/
static void testminlbfgsunit_testfunc2(minlbfgsstate* state,
     ae_state *_state)
{


    if( ae_fp_less(state->x.ptr.p_double[0],(double)(100)) )
    {
        if( state->needf||state->needfg )
        {
            state->f = ae_sqr(ae_exp(state->x.ptr.p_double[0], _state)-2, _state)+ae_sqr(ae_sqr(state->x.ptr.p_double[1], _state), _state)+ae_sqr(state->x.ptr.p_double[2]-state->x.ptr.p_double[0], _state);
        }
        if( state->needfg )
        {
            state->g.ptr.p_double[0] = 2*(ae_exp(state->x.ptr.p_double[0], _state)-2)*ae_exp(state->x.ptr.p_double[0], _state)+2*(state->x.ptr.p_double[0]-state->x.ptr.p_double[2]);
            state->g.ptr.p_double[1] = 4*state->x.ptr.p_double[1]*ae_sqr(state->x.ptr.p_double[1], _state);
            state->g.ptr.p_double[2] = 2*(state->x.ptr.p_double[2]-state->x.ptr.p_double[0]);
        }
    }
    else
    {
        if( state->needf||state->needfg )
        {
            state->f = ae_sqrt(ae_maxrealnumber, _state);
        }
        if( state->needfg )
        {
            state->g.ptr.p_double[0] = ae_sqrt(ae_maxrealnumber, _state);
            state->g.ptr.p_double[1] = (double)(0);
            state->g.ptr.p_double[2] = (double)(0);
        }
    }
}


/*************************************************************************
Calculate test function #3

Simple variation of #1, much more nonlinear, with non-zero value at minimum.
It achieve two goals:
* makes unlikely premature convergence of algorithm .
* solves some issues with EpsF stopping condition which arise when
  F(minimum) is zero

*************************************************************************/
static void testminlbfgsunit_testfunc3(minlbfgsstate* state,
     ae_state *_state)
{
    double s;


    s = 0.001;
    if( ae_fp_less(state->x.ptr.p_double[0],(double)(100)) )
    {
        if( state->needf||state->needfg )
        {
            state->f = ae_sqr(ae_exp(state->x.ptr.p_double[0], _state)-2, _state)+ae_sqr(ae_sqr(state->x.ptr.p_double[1], _state)+s, _state)+ae_sqr(state->x.ptr.p_double[2]-state->x.ptr.p_double[0], _state);
        }
        if( state->needfg )
        {
            state->g.ptr.p_double[0] = 2*(ae_exp(state->x.ptr.p_double[0], _state)-2)*ae_exp(state->x.ptr.p_double[0], _state)+2*(state->x.ptr.p_double[0]-state->x.ptr.p_double[2]);
            state->g.ptr.p_double[1] = 2*(ae_sqr(state->x.ptr.p_double[1], _state)+s)*2*state->x.ptr.p_double[1];
            state->g.ptr.p_double[2] = 2*(state->x.ptr.p_double[2]-state->x.ptr.p_double[0]);
        }
    }
    else
    {
        if( state->needf||state->needfg )
        {
            state->f = ae_sqrt(ae_maxrealnumber, _state);
        }
        if( state->needfg )
        {
            state->g.ptr.p_double[0] = ae_sqrt(ae_maxrealnumber, _state);
            state->g.ptr.p_double[1] = (double)(0);
            state->g.ptr.p_double[2] = (double)(0);
        }
    }
}


/*************************************************************************
Calculate test function IIP2

f(x) = sum( ((i*i+1)*x[i])^2, i=0..N-1)

It has high condition number which makes fast convergence unlikely without
good preconditioner.

*************************************************************************/
static void testminlbfgsunit_calciip2(minlbfgsstate* state,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;


    if( state->needf||state->needfg )
    {
        state->f = (double)(0);
    }
    for(i=0; i<=n-1; i++)
    {
        if( state->needf||state->needfg )
        {
            state->f = state->f+ae_sqr((double)(i*i+1), _state)*ae_sqr(state->x.ptr.p_double[i], _state);
        }
        if( state->needfg )
        {
            state->g.ptr.p_double[i] = ae_sqr((double)(i*i+1), _state)*2*state->x.ptr.p_double[i];
        }
    }
}


/*************************************************************************
This function tests preconditioning

On failure sets Err to True (leaves it unchanged otherwise)
*************************************************************************/
static void testminlbfgsunit_testpreconditioning(ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t cntb1;
    ae_int_t cntb2;
    ae_int_t cntg1;
    ae_int_t cntg2;
    ae_int_t pkind;
    minlbfgsstate state;
    minlbfgsreport rep;
    ae_vector x;
    ae_vector s;
    ae_matrix a;
    ae_vector diagh;

    ae_frame_make(_state, &_frame_block);
    memset(&state, 0, sizeof(state));
    memset(&rep, 0, sizeof(rep));
    memset(&x, 0, sizeof(x));
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&diagh, 0, sizeof(diagh));
    _minlbfgsstate_init(&state, _state, ae_true);
    _minlbfgsreport_init(&rep, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&diagh, 0, DT_REAL, _state, ae_true);

    m = 1;
    k = 50;
    
    /*
     * Preconditioner test1.
     *
     * If
     * * B1 is default preconditioner
     * * B2 is Cholesky preconditioner with unit diagonal
     * * G1 is Cholesky preconditioner based on exact Hessian with perturbations
     * * G2 is diagonal precomditioner based on approximate diagonal of Hessian matrix
     * then "bad" preconditioners (B1/B2/..) are worse than "good" ones (G1/G2/..).
     * "Worse" means more iterations to converge.
     *
     * We test it using f(x) = sum( ((i*i+1)*x[i])^2, i=0..N-1) and L-BFGS
     * optimizer with deliberately small M=1.
     *
     * N        - problem size
     * PKind    - zero for upper triangular preconditioner, one for lower triangular.
     * K        - number of repeated passes (should be large enough to average out random factors)
     */
    for(n=10; n<=15; n++)
    {
        pkind = ae_randominteger(2, _state);
        ae_vector_set_length(&x, n, _state);
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = (double)(0);
        }
        minlbfgscreate(n, m, &x, &state, _state);
        
        /*
         * Test it with default preconditioner
         */
        minlbfgssetprecdefault(&state, _state);
        cntb1 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntb1 = cntb1+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        
        /*
         * Test it with unit preconditioner
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    a.ptr.pp_double[i][i] = (double)(1);
                }
                else
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                }
            }
        }
        minlbfgssetpreccholesky(&state, &a, pkind==0, _state);
        cntb2 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntb2 = cntb2+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        
        /*
         * Test it with perturbed Hessian preconditioner
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    a.ptr.pp_double[i][i] = (i*i+1)*(0.8+0.4*ae_randomreal(_state));
                }
                else
                {
                    if( (pkind==0&&j>i)||(pkind==1&&j<i) )
                    {
                        a.ptr.pp_double[i][j] = 0.1*ae_randomreal(_state)-0.05;
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = _state->v_nan;
                    }
                }
            }
        }
        minlbfgssetpreccholesky(&state, &a, pkind==0, _state);
        cntg1 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntg1 = cntg1+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        
        /*
         * Test it with perturbed diagonal preconditioner
         */
        ae_vector_set_length(&diagh, n, _state);
        for(i=0; i<=n-1; i++)
        {
            diagh.ptr.p_double[i] = 2*ae_sqr((double)(i*i+1), _state)*(0.8+0.4*ae_randomreal(_state));
        }
        minlbfgssetprecdiag(&state, &diagh, _state);
        cntg2 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntg2 = cntg2+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        
        /*
         * Compare
         */
        *err = *err||cntb1<cntg1;
        *err = *err||cntb2<cntg1;
        *err = *err||cntb1<cntg2;
        *err = *err||cntb2<cntg2;
    }
    
    /*
     * Preconditioner test 2.
     *
     * If
     * * B2 is default preconditioner with non-unit scale S[i]=1/sqrt(h[i])
     * * G2 is scale-based preconditioner with non-unit scale S[i]=1/sqrt(h[i])
     * then B2 is worse than G2.
     * "Worse" means more iterations to converge.
     */
    for(n=10; n<=15; n++)
    {
        ae_vector_set_length(&x, n, _state);
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = (double)(0);
        }
        minlbfgscreate(n, m, &x, &state, _state);
        ae_vector_set_length(&s, n, _state);
        for(i=0; i<=n-1; i++)
        {
            s.ptr.p_double[i] = 1/ae_sqrt(2*ae_pow((double)(i*i+1), (double)(2), _state)*(0.8+0.4*ae_randomreal(_state)), _state);
        }
        minlbfgssetprecdefault(&state, _state);
        minlbfgssetscale(&state, &s, _state);
        cntb2 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntb2 = cntb2+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        minlbfgssetprecscale(&state, _state);
        minlbfgssetscale(&state, &s, _state);
        cntg2 = 0;
        for(pass=0; pass<=k-1; pass++)
        {
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                testminlbfgsunit_calciip2(&state, n, _state);
            }
            minlbfgsresults(&state, &x, &rep, _state);
            cntg2 = cntg2+rep.iterationscount;
            *err = *err||rep.terminationtype<=0;
        }
        *err = *err||cntb2<cntg2;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function tests other properties

On failure sets Err to True (leaves it unchanged otherwise)
*************************************************************************/
static void testminlbfgsunit_testother(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_vector x;
    ae_vector a;
    ae_vector b;
    ae_vector s;
    ae_vector h;
    ae_vector x0;
    ae_vector x1;
    ae_vector xlast;
    ae_matrix fulla;
    ae_bool hasxlast;
    double lastscaledstep;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    minlbfgsstate state;
    minlbfgsreport rep;
    double fprev;
    double xprev;
    double v;
    double stpmax;
    double tmpeps;
    double epsg;
    ae_int_t pkind;
    ae_int_t ckind;
    ae_int_t mkind;
    double vc;
    double vm;
    double diffstep;
    ae_int_t dkind;
    ae_bool wasf;
    ae_bool wasfg;
    double r;
    hqrndstate rs;
    ae_int_t spoiliteration;
    ae_int_t stopiteration;
    ae_int_t spoilvar;
    double spoilval;
    double ss;
    ae_bool terminationrequested;
    ae_int_t pass;
    ae_int_t stopcallidx;
    ae_int_t callidx;
    ae_int_t maxits;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&s, 0, sizeof(s));
    memset(&h, 0, sizeof(h));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&xlast, 0, sizeof(xlast));
    memset(&fulla, 0, sizeof(fulla));
    memset(&state, 0, sizeof(state));
    memset(&rep, 0, sizeof(rep));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&s, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&h, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xlast, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&fulla, 0, 0, DT_REAL, _state, ae_true);
    _minlbfgsstate_init(&state, _state, ae_true);
    _minlbfgsreport_init(&rep, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * Test reports (F should form monotone sequence)
     */
    n = 50;
    m = 2;
    ae_vector_set_length(&x, n, _state);
    ae_vector_set_length(&xlast, n, _state);
    for(i=0; i<=n-1; i++)
    {
        x.ptr.p_double[i] = (double)(1);
    }
    minlbfgscreate(n, m, &x, &state, _state);
    minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), 100, _state);
    minlbfgssetxrep(&state, ae_true, _state);
    fprev = ae_maxrealnumber;
    while(minlbfgsiteration(&state, _state))
    {
        if( state.needfg )
        {
            state.f = (double)(0);
            for(i=0; i<=n-1; i++)
            {
                state.f = state.f+ae_sqr((1+i)*state.x.ptr.p_double[i], _state);
                state.g.ptr.p_double[i] = 2*(1+i)*state.x.ptr.p_double[i];
            }
        }
        if( state.xupdated )
        {
            *err = *err||ae_fp_greater(state.f,fprev);
            if( ae_fp_eq(fprev,ae_maxrealnumber) )
            {
                for(i=0; i<=n-1; i++)
                {
                    *err = *err||ae_fp_neq(state.x.ptr.p_double[i],x.ptr.p_double[i]);
                }
            }
            fprev = state.f;
            ae_v_move(&xlast.ptr.p_double[0], 1, &state.x.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    minlbfgsresults(&state, &x, &rep, _state);
    for(i=0; i<=n-1; i++)
    {
        *err = *err||ae_fp_neq(x.ptr.p_double[i],xlast.ptr.p_double[i]);
    }
    
    /*
     * Test differentiation vs. analytic gradient
     * (first one issues NeedF requests, second one issues NeedFG requests)
     */
    n = 50;
    m = 5;
    diffstep = 1.0E-6;
    for(dkind=0; dkind<=1; dkind++)
    {
        ae_vector_set_length(&x, n, _state);
        ae_vector_set_length(&xlast, n, _state);
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = (double)(1);
        }
        if( dkind==0 )
        {
            minlbfgscreate(n, m, &x, &state, _state);
        }
        if( dkind==1 )
        {
            minlbfgscreatef(n, m, &x, diffstep, &state, _state);
        }
        minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), n/2, _state);
        wasf = ae_false;
        wasfg = ae_false;
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needf||state.needfg )
            {
                state.f = (double)(0);
            }
            for(i=0; i<=n-1; i++)
            {
                if( state.needf||state.needfg )
                {
                    state.f = state.f+ae_sqr((1+i)*state.x.ptr.p_double[i], _state);
                }
                if( state.needfg )
                {
                    state.g.ptr.p_double[i] = 2*(1+i)*state.x.ptr.p_double[i];
                }
            }
            wasf = wasf||state.needf;
            wasfg = wasfg||state.needfg;
        }
        minlbfgsresults(&state, &x, &rep, _state);
        if( dkind==0 )
        {
            *err = (*err||wasf)||!wasfg;
        }
        if( dkind==1 )
        {
            *err = (*err||!wasf)||wasfg;
        }
    }
    
    /*
     * Test that numerical differentiation uses scaling.
     *
     * In order to test that we solve simple optimization
     * problem: min(x^2) with initial x equal to 0.0.
     *
     * We choose random DiffStep and S, then we check that
     * optimizer evaluates function at +-DiffStep*S only.
     */
    ae_vector_set_length(&x, 1, _state);
    ae_vector_set_length(&s, 1, _state);
    diffstep = ae_randomreal(_state)*1.0E-6;
    s.ptr.p_double[0] = ae_exp(ae_randomreal(_state)*4-2, _state);
    x.ptr.p_double[0] = (double)(0);
    minlbfgscreatef(1, 1, &x, diffstep, &state, _state);
    minlbfgssetcond(&state, 1.0E-6, (double)(0), (double)(0), 0, _state);
    minlbfgssetscale(&state, &s, _state);
    v = (double)(0);
    while(minlbfgsiteration(&state, _state))
    {
        state.f = ae_sqr(state.x.ptr.p_double[0], _state);
        v = ae_maxreal(v, ae_fabs(state.x.ptr.p_double[0], _state), _state);
    }
    minlbfgsresults(&state, &x, &rep, _state);
    r = v/(s.ptr.p_double[0]*diffstep);
    *err = *err||ae_fp_greater(ae_fabs(ae_log(r, _state), _state),ae_log(1+1000*ae_machineepsilon, _state));
    
    /*
     * test maximum step
     */
    n = 1;
    m = 1;
    ae_vector_set_length(&x, n, _state);
    x.ptr.p_double[0] = (double)(100);
    stpmax = 0.05+0.05*ae_randomreal(_state);
    minlbfgscreate(n, m, &x, &state, _state);
    minlbfgssetcond(&state, 1.0E-9, (double)(0), (double)(0), 0, _state);
    minlbfgssetstpmax(&state, stpmax, _state);
    minlbfgssetxrep(&state, ae_true, _state);
    xprev = x.ptr.p_double[0];
    while(minlbfgsiteration(&state, _state))
    {
        if( state.needfg )
        {
            state.f = ae_exp(state.x.ptr.p_double[0], _state)+ae_exp(-state.x.ptr.p_double[0], _state);
            state.g.ptr.p_double[0] = ae_exp(state.x.ptr.p_double[0], _state)-ae_exp(-state.x.ptr.p_double[0], _state);
            *err = *err||ae_fp_greater(ae_fabs(state.x.ptr.p_double[0]-xprev, _state),(1+ae_sqrt(ae_machineepsilon, _state))*stpmax);
        }
        if( state.xupdated )
        {
            *err = *err||ae_fp_greater(ae_fabs(state.x.ptr.p_double[0]-xprev, _state),(1+ae_sqrt(ae_machineepsilon, _state))*stpmax);
            xprev = state.x.ptr.p_double[0];
        }
    }
    
    /*
     * Test correctness of the scaling:
     * * initial point is random point from [+1,+2]^N
     * * f(x) = SUM(A[i]*x[i]^4), C[i] is random from [0.01,100]
     * * we use random scaling matrix
     * * we test different variants of the preconditioning:
     *   0) unit preconditioner
     *   1) random diagonal from [0.01,100]
     *   2) scale preconditioner
     * * we set stringent stopping conditions (we try EpsG and EpsX)
     * * and we test that in the extremum stopping conditions are
     *   satisfied subject to the current scaling coefficients.
     */
    tmpeps = 1.0E-10;
    m = 1;
    for(n=1; n<=10; n++)
    {
        for(pkind=0; pkind<=2; pkind++)
        {
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&xlast, n, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&s, n, _state);
            ae_vector_set_length(&h, n, _state);
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = ae_randomreal(_state)+1;
                a.ptr.p_double[i] = ae_exp(ae_log((double)(100), _state)*(2*ae_randomreal(_state)-1), _state);
                s.ptr.p_double[i] = ae_exp(ae_log((double)(100), _state)*(2*ae_randomreal(_state)-1), _state);
                h.ptr.p_double[i] = ae_exp(ae_log((double)(100), _state)*(2*ae_randomreal(_state)-1), _state);
            }
            minlbfgscreate(n, m, &x, &state, _state);
            minlbfgssetscale(&state, &s, _state);
            minlbfgssetxrep(&state, ae_true, _state);
            if( pkind==1 )
            {
                minlbfgssetprecdiag(&state, &h, _state);
            }
            if( pkind==2 )
            {
                minlbfgssetprecscale(&state, _state);
            }
            
            /*
             * Test gradient-based stopping condition
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = ae_randomreal(_state)+1;
            }
            minlbfgssetcond(&state, tmpeps, (double)(0), (double)(0), 0, _state);
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                if( state.needfg )
                {
                    state.f = (double)(0);
                    for(i=0; i<=n-1; i++)
                    {
                        state.f = state.f+a.ptr.p_double[i]*ae_pow(state.x.ptr.p_double[i], (double)(4), _state);
                        state.g.ptr.p_double[i] = 4*a.ptr.p_double[i]*ae_pow(state.x.ptr.p_double[i], (double)(3), _state);
                    }
                }
            }
            minlbfgsresults(&state, &x, &rep, _state);
            if( rep.terminationtype<=0 )
            {
                *err = ae_true;
                ae_frame_leave(_state);
                return;
            }
            v = (double)(0);
            for(i=0; i<=n-1; i++)
            {
                v = v+ae_sqr(s.ptr.p_double[i]*4*a.ptr.p_double[i]*ae_pow(x.ptr.p_double[i], (double)(3), _state), _state);
            }
            v = ae_sqrt(v, _state);
            *err = *err||ae_fp_greater(v,tmpeps);
            
            /*
             * Test step-based stopping condition
             */
            for(i=0; i<=n-1; i++)
            {
                x.ptr.p_double[i] = ae_randomreal(_state)+1;
            }
            hasxlast = ae_false;
            lastscaledstep = ae_maxrealnumber;
            minlbfgssetcond(&state, (double)(0), (double)(0), tmpeps, 0, _state);
            minlbfgsrestartfrom(&state, &x, _state);
            while(minlbfgsiteration(&state, _state))
            {
                if( state.needfg )
                {
                    state.f = (double)(0);
                    for(i=0; i<=n-1; i++)
                    {
                        state.f = state.f+a.ptr.p_double[i]*ae_pow(state.x.ptr.p_double[i], (double)(4), _state);
                        state.g.ptr.p_double[i] = 4*a.ptr.p_double[i]*ae_pow(state.x.ptr.p_double[i], (double)(3), _state);
                    }
                }
                if( state.xupdated )
                {
                    if( hasxlast )
                    {
                        lastscaledstep = (double)(0);
                        for(i=0; i<=n-1; i++)
                        {
                            lastscaledstep = lastscaledstep+ae_sqr(state.x.ptr.p_double[i]-xlast.ptr.p_double[i], _state)/ae_sqr(s.ptr.p_double[i], _state);
                        }
                        lastscaledstep = ae_sqrt(lastscaledstep, _state);
                    }
                    else
                    {
                        lastscaledstep = (double)(0);
                    }
                    ae_v_move(&xlast.ptr.p_double[0], 1, &state.x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    hasxlast = ae_true;
                }
            }
            minlbfgsresults(&state, &x, &rep, _state);
            if( rep.terminationtype<=0 )
            {
                *err = ae_true;
                ae_frame_leave(_state);
                return;
            }
            *err = *err||ae_fp_greater(lastscaledstep,tmpeps);
        }
    }
    
    /*
     * Check correctness of the "trimming".
     *
     * Trimming is a technique which is used to help algorithm
     * cope with unbounded functions. In order to check this
     * technique we will try to solve following optimization
     * problem:
     *
     *     min f(x) subject to no constraints on X
     *            { 1/(1-x) + 1/(1+x) + c*x, if -0.999999<x<0.999999
     *     f(x) = {
     *            { M, if x<=-0.999999 or x>=0.999999
     *
     * where c is either 1.0 or 1.0E+6, M is either 1.0E8, 1.0E20 or +INF
     * (we try different combinations)
     */
    for(ckind=0; ckind<=1; ckind++)
    {
        for(mkind=0; mkind<=2; mkind++)
        {
            
            /*
             * Choose c and M
             */
            vc = (double)(1);
            vm = (double)(1);
            if( ckind==0 )
            {
                vc = 1.0;
            }
            if( ckind==1 )
            {
                vc = 1.0E+6;
            }
            if( mkind==0 )
            {
                vm = 1.0E+8;
            }
            if( mkind==1 )
            {
                vm = 1.0E+20;
            }
            if( mkind==2 )
            {
                vm = _state->v_posinf;
            }
            
            /*
             * Create optimizer, solve optimization problem
             */
            epsg = 1.0E-6*vc;
            ae_vector_set_length(&x, 1, _state);
            x.ptr.p_double[0] = 0.0;
            minlbfgscreate(1, 1, &x, &state, _state);
            minlbfgssetcond(&state, epsg, (double)(0), (double)(0), 0, _state);
            while(minlbfgsiteration(&state, _state))
            {
                if( state.needfg )
                {
                    if( ae_fp_less(-0.999999,state.x.ptr.p_double[0])&&ae_fp_less(state.x.ptr.p_double[0],0.999999) )
                    {
                        state.f = 1/(1-state.x.ptr.p_double[0])+1/(1+state.x.ptr.p_double[0])+vc*state.x.ptr.p_double[0];
                        state.g.ptr.p_double[0] = 1/ae_sqr(1-state.x.ptr.p_double[0], _state)-1/ae_sqr(1+state.x.ptr.p_double[0], _state)+vc;
                    }
                    else
                    {
                        state.f = vm;
                    }
                }
            }
            minlbfgsresults(&state, &x, &rep, _state);
            if( rep.terminationtype<=0 )
            {
                *err = ae_true;
                ae_frame_leave(_state);
                return;
            }
            *err = *err||ae_fp_greater(ae_fabs(1/ae_sqr(1-x.ptr.p_double[0], _state)-1/ae_sqr(1+x.ptr.p_double[0], _state)+vc, _state),epsg);
        }
    }
    
    /*
     * Test integrity checks for NAN/INF:
     * * algorithm solves optimization problem, which is normal for some time (quadratic)
     * * after 5-th step we choose random component of gradient and consistently spoil
     *   it by NAN or INF.
     * * we check that correct termination code is returned (-8)
     */
    n = 100;
    for(pass=1; pass<=10; pass++)
    {
        spoiliteration = 5;
        stopiteration = 8;
        if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
        {
            
            /*
             * Gradient can be spoiled by +INF, -INF, NAN
             */
            spoilvar = hqrnduniformi(&rs, n, _state);
            i = hqrnduniformi(&rs, 3, _state);
            spoilval = _state->v_nan;
            if( i==0 )
            {
                spoilval = _state->v_neginf;
            }
            if( i==1 )
            {
                spoilval = _state->v_posinf;
            }
        }
        else
        {
            
            /*
             * Function value can be spoiled only by NAN
             * (+INF can be recognized as legitimate value during optimization)
             */
            spoilvar = -1;
            spoilval = _state->v_nan;
        }
        spdmatrixrndcond(n, 1.0E5, &fulla, _state);
        ae_vector_set_length(&b, n, _state);
        ae_vector_set_length(&x0, n, _state);
        for(i=0; i<=n-1; i++)
        {
            b.ptr.p_double[i] = hqrndnormal(&rs, _state);
            x0.ptr.p_double[i] = hqrndnormal(&rs, _state);
        }
        minlbfgscreate(n, 1, &x0, &state, _state);
        minlbfgssetcond(&state, 0.0, 0.0, 0.0, stopiteration, _state);
        minlbfgssetxrep(&state, ae_true, _state);
        k = -1;
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needfg )
            {
                state.f = (double)(0);
                for(i=0; i<=n-1; i++)
                {
                    state.f = state.f+b.ptr.p_double[i]*state.x.ptr.p_double[i];
                    state.g.ptr.p_double[i] = b.ptr.p_double[i];
                    for(j=0; j<=n-1; j++)
                    {
                        state.f = state.f+0.5*state.x.ptr.p_double[i]*fulla.ptr.pp_double[i][j]*state.x.ptr.p_double[j];
                        state.g.ptr.p_double[i] = state.g.ptr.p_double[i]+fulla.ptr.pp_double[i][j]*state.x.ptr.p_double[j];
                    }
                }
                if( k>=spoiliteration )
                {
                    if( spoilvar<0 )
                    {
                        state.f = spoilval;
                    }
                    else
                    {
                        state.g.ptr.p_double[spoilvar] = spoilval;
                    }
                }
                continue;
            }
            if( state.xupdated )
            {
                inc(&k, _state);
                continue;
            }
            ae_assert(ae_false, "Assertion failed", _state);
        }
        minlbfgsresults(&state, &x1, &rep, _state);
        ae_set_error_flag(err, rep.terminationtype!=-8, __FILE__, __LINE__, "testminlbfgsunit.ap:1119");
    }
    
    /*
     * Check algorithm ability to handle request for termination:
     * * to terminate with correct return code = 8
     * * to return point which was "current" at the moment of termination
     */
    for(pass=1; pass<=50; pass++)
    {
        n = 3;
        ss = (double)(100);
        ae_vector_set_length(&x, n, _state);
        ae_vector_set_length(&xlast, n, _state);
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = 6+ae_randomreal(_state);
        }
        stopcallidx = ae_randominteger(20, _state);
        maxits = 25;
        minlbfgscreate(n, 1, &x, &state, _state);
        minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), maxits, _state);
        minlbfgssetxrep(&state, ae_true, _state);
        callidx = 0;
        terminationrequested = ae_false;
        ae_v_move(&xlast.ptr.p_double[0], 1, &x.ptr.p_double[0], 1, ae_v_len(0,n-1));
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needfg )
            {
                state.f = ss*ae_sqr(ae_exp(state.x.ptr.p_double[0], _state)-2, _state)+ae_sqr(state.x.ptr.p_double[1], _state)+ae_sqr(state.x.ptr.p_double[2]-state.x.ptr.p_double[0], _state);
                state.g.ptr.p_double[0] = 2*ss*(ae_exp(state.x.ptr.p_double[0], _state)-2)*ae_exp(state.x.ptr.p_double[0], _state)+2*(state.x.ptr.p_double[2]-state.x.ptr.p_double[0])*(-1);
                state.g.ptr.p_double[1] = 2*state.x.ptr.p_double[1];
                state.g.ptr.p_double[2] = 2*(state.x.ptr.p_double[2]-state.x.ptr.p_double[0]);
                if( callidx==stopcallidx )
                {
                    minlbfgsrequesttermination(&state, _state);
                    terminationrequested = ae_true;
                }
                inc(&callidx, _state);
                continue;
            }
            if( state.xupdated )
            {
                if( !terminationrequested )
                {
                    ae_v_move(&xlast.ptr.p_double[0], 1, &state.x.ptr.p_double[0], 1, ae_v_len(0,n-1));
                }
                continue;
            }
            ae_assert(ae_false, "Assertion failed", _state);
        }
        minlbfgsresults(&state, &x, &rep, _state);
        ae_set_error_flag(err, rep.terminationtype!=8, __FILE__, __LINE__, "testminlbfgsunit.ap:1169");
        for(i=0; i<=n-1; i++)
        {
            ae_set_error_flag(err, ae_fp_neq(x.ptr.p_double[i],xlast.ptr.p_double[i]), __FILE__, __LINE__, "testminlbfgsunit.ap:1171");
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function tests, that gradient verified correctly.
*************************************************************************/
static ae_bool testminlbfgsunit_gradientchecktest(ae_state *_state)
{
    ae_frame _frame_block;
    minlbfgsstate state;
    minlbfgsreport rep;
    ae_int_t m;
    ae_int_t n;
    double a;
    double b;
    double c;
    double d;
    double x0;
    double x1;
    double x2;
    ae_vector x;
    double teststep;
    double noise;
    ae_int_t nbrcomp;
    ae_int_t func;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t i;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&state, 0, sizeof(state));
    memset(&rep, 0, sizeof(rep));
    memset(&x, 0, sizeof(x));
    _minlbfgsstate_init(&state, _state, ae_true);
    _minlbfgsreport_init(&rep, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);

    passcount = 35;
    teststep = 0.01;
    n = 3;
    m = 2;
    ae_vector_set_length(&x, n, _state);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Prepare test's parameters
         */
        func = ae_randominteger(3, _state)+1;
        nbrcomp = ae_randominteger(n, _state);
        noise = (double)(10*(2*ae_randominteger(2, _state)-1));
        
        /*
         * Prepare function's parameters
         */
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = 5*randomnormal(_state);
        }
        a = 5*ae_randomreal(_state)+1;
        b = 5*ae_randomreal(_state)+1;
        c = 5*ae_randomreal(_state)+1;
        d = 5*ae_randomreal(_state)+1;
        x0 = 5*(2*ae_randomreal(_state)-1);
        x1 = 5*(2*ae_randomreal(_state)-1);
        x2 = 5*(2*ae_randomreal(_state)-1);
        minlbfgscreate(n, m, &x, &state, _state);
        minlbfgssetcond(&state, (double)(0), (double)(0), (double)(0), 0, _state);
        minlbfgssetgradientcheck(&state, teststep, _state);
        
        /*
         * Check that the criterion passes a derivative if it is correct
         */
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needfg )
            {
                testminlbfgsunit_funcderiv(a, b, c, d, x0, x1, x2, &state.x, func, &state.f, &state.g, _state);
            }
        }
        minlbfgsresults(&state, &x, &rep, _state);
        
        /*
         * Check that error code does not equal to -7 and parameter .VarIdx
         * equal to -1.
         */
        if( rep.terminationtype==-7||rep.varidx!=-1 )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        for(i=0; i<=n-1; i++)
        {
            x.ptr.p_double[i] = 5*randomnormal(_state);
        }
        minlbfgsrestartfrom(&state, &x, _state);
        
        /*
         * Check that the criterion does not miss a derivative if
         * it is incorrect
         */
        while(minlbfgsiteration(&state, _state))
        {
            if( state.needfg )
            {
                testminlbfgsunit_funcderiv(a, b, c, d, x0, x1, x2, &state.x, func, &state.f, &state.g, _state);
                state.g.ptr.p_double[nbrcomp] = state.g.ptr.p_double[nbrcomp]+noise;
            }
        }
        minlbfgsresults(&state, &x, &rep, _state);
        
        /*
         * Check that error code equal to -7 and parameter .VarIdx
         * equal to number of incorrect component.
         */
        if( rep.terminationtype!=-7||rep.varidx!=nbrcomp )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function return function value and it derivatives. Function dimension
is 3.
    Function's list:
        * funcType=1:
            F(X)=A*(X-X0)^2+B*(Y-Y0)^2+C*(Z-Z0)^2+D;
        * funcType=2:
            F(X)=A*sin(X-X0)^2+B*sin(Y-Y0)^2+C*sin(Z-Z0)^2+D;
        * funcType=3:
            F(X)=A*(X-X0)^2+B*(Y-Y0)^2+C*((Z-Z0)-(X-X0))^2+D.
*************************************************************************/
static void testminlbfgsunit_funcderiv(double a,
     double b,
     double c,
     double d,
     double x0,
     double x1,
     double x2,
     /* Real    */ ae_vector* x,
     ae_int_t functype,
     double* f,
     /* Real    */ ae_vector* g,
     ae_state *_state)
{


    ae_assert(((ae_isfinite(a, _state)&&ae_isfinite(b, _state))&&ae_isfinite(c, _state))&&ae_isfinite(d, _state), "FuncDeriv: A, B, C or D contains NaN or Infinite.", _state);
    ae_assert((ae_isfinite(x0, _state)&&ae_isfinite(x1, _state))&&ae_isfinite(x2, _state), "FuncDeriv: X0, X1 or X2 contains NaN or Infinite.", _state);
    ae_assert(functype>=1&&functype<=3, "FuncDeriv: incorrect funcType(funcType<1 or funcType>3).", _state);
    if( functype==1 )
    {
        *f = a*ae_sqr(x->ptr.p_double[0]-x0, _state)+b*ae_sqr(x->ptr.p_double[1]-x1, _state)+c*ae_sqr(x->ptr.p_double[2]-x2, _state)+d;
        g->ptr.p_double[0] = 2*a*(x->ptr.p_double[0]-x0);
        g->ptr.p_double[1] = 2*b*(x->ptr.p_double[1]-x1);
        g->ptr.p_double[2] = 2*c*(x->ptr.p_double[2]-x2);
        return;
    }
    if( functype==2 )
    {
        *f = a*ae_sqr(ae_sin(x->ptr.p_double[0]-x0, _state), _state)+b*ae_sqr(ae_sin(x->ptr.p_double[1]-x1, _state), _state)+c*ae_sqr(ae_sin(x->ptr.p_double[2]-x2, _state), _state)+d;
        g->ptr.p_double[0] = 2*a*ae_sin(x->ptr.p_double[0]-x0, _state)*ae_cos(x->ptr.p_double[0]-x0, _state);
        g->ptr.p_double[1] = 2*b*ae_sin(x->ptr.p_double[1]-x1, _state)*ae_cos(x->ptr.p_double[1]-x1, _state);
        g->ptr.p_double[2] = 2*c*ae_sin(x->ptr.p_double[2]-x2, _state)*ae_cos(x->ptr.p_double[2]-x2, _state);
        return;
    }
    if( functype==3 )
    {
        *f = a*ae_sqr(x->ptr.p_double[0]-x0, _state)+b*ae_sqr(x->ptr.p_double[1]-x1, _state)+c*ae_sqr(x->ptr.p_double[2]-x2-(x->ptr.p_double[0]-x0), _state)+d;
        g->ptr.p_double[0] = 2*a*(x->ptr.p_double[0]-x0)+2*c*(x->ptr.p_double[0]-x->ptr.p_double[2]-x0+x2);
        g->ptr.p_double[1] = 2*b*(x->ptr.p_double[1]-x1);
        g->ptr.p_double[2] = 2*c*(x->ptr.p_double[2]-x->ptr.p_double[0]-x2+x0);
        return;
    }
}








ae_bool testxblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool approxerrors;
    ae_bool exactnesserrors;
    ae_bool waserrors;
    double approxthreshold;
    ae_int_t maxn;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t pass;
    double rv1;
    double rv2;
    double rv2err;
    ae_complex cv1;
    ae_complex cv2;
    double cv2err;
    ae_vector rx;
    ae_vector ry;
    ae_vector cx;
    ae_vector cy;
    ae_vector temp;
    double s;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&cx, 0, sizeof(cx));
    memset(&cy, 0, sizeof(cy));
    memset(&temp, 0, sizeof(temp));
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cx, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cy, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&temp, 0, DT_REAL, _state, ae_true);

    approxerrors = ae_false;
    exactnesserrors = ae_false;
    waserrors = ae_false;
    approxthreshold = 1000*ae_machineepsilon;
    maxn = 1000;
    passcount = 10;
    
    /*
     * tests:
     * 1. ability to calculate dot product
     * 2. higher precision
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             *  ability to approximately calculate real dot product
             */
            ae_vector_set_length(&rx, n, _state);
            ae_vector_set_length(&ry, n, _state);
            ae_vector_set_length(&temp, n, _state);
            for(i=0; i<=n-1; i++)
            {
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    rx.ptr.p_double[i] = (double)(0);
                }
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    ry.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    ry.ptr.p_double[i] = (double)(0);
                }
            }
            rv1 = ae_v_dotproduct(&rx.ptr.p_double[0], 1, &ry.ptr.p_double[0], 1, ae_v_len(0,n-1));
            xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
            approxerrors = approxerrors||ae_fp_greater(ae_fabs(rv1-rv2, _state),approxthreshold);
            
            /*
             *  ability to approximately calculate complex dot product
             */
            ae_vector_set_length(&cx, n, _state);
            ae_vector_set_length(&cy, n, _state);
            ae_vector_set_length(&temp, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    cx.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    cx.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    cx.ptr.p_complex[i] = ae_complex_from_i(0);
                }
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    cy.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    cy.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    cy.ptr.p_complex[i] = ae_complex_from_i(0);
                }
            }
            cv1 = ae_v_cdotproduct(&cx.ptr.p_complex[0], 1, "N", &cy.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
            xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
            approxerrors = approxerrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv1,cv2), _state),approxthreshold);
        }
    }
    
    /*
     * test of precision: real
     */
    n = 50000;
    ae_vector_set_length(&rx, n, _state);
    ae_vector_set_length(&ry, n, _state);
    ae_vector_set_length(&temp, n, _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        ae_assert(n%2==0, "Assertion failed", _state);
        
        /*
         * First test: X + X + ... + X - X - X - ... - X = 1*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        ry.ptr.p_double[0] = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            ry.ptr.p_double[i] = ry.ptr.p_double[0];
        }
        for(i=0; i<=n/2-1; i++)
        {
            rx.ptr.p_double[i] = (double)(1);
        }
        for(i=n/2; i<=n-2; i++)
        {
            rx.ptr.p_double[i] = (double)(-1);
        }
        rx.ptr.p_double[n-1] = (double)(0);
        xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(rv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(rv2err,4*ae_machineepsilon*ae_fabs(ry.ptr.p_double[0], _state));
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_fabs(rv2-ry.ptr.p_double[0], _state),rv2err);
        
        /*
         * First test: X + X + ... + X = N*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        ry.ptr.p_double[0] = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            ry.ptr.p_double[i] = ry.ptr.p_double[0];
        }
        for(i=0; i<=n-1; i++)
        {
            rx.ptr.p_double[i] = (double)(1);
        }
        xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(rv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(rv2err,4*ae_machineepsilon*ae_fabs(ry.ptr.p_double[0], _state)*n);
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_fabs(rv2-n*ry.ptr.p_double[0], _state),rv2err);
    }
    
    /*
     * test of precision: complex
     */
    n = 50000;
    ae_vector_set_length(&cx, n, _state);
    ae_vector_set_length(&cy, n, _state);
    ae_vector_set_length(&temp, 2*n, _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        ae_assert(n%2==0, "Assertion failed", _state);
        
        /*
         * First test: X + X + ... + X - X - X - ... - X = 1*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        cy.ptr.p_complex[0].x = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        cy.ptr.p_complex[0].y = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            cy.ptr.p_complex[i] = cy.ptr.p_complex[0];
        }
        for(i=0; i<=n/2-1; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(1);
        }
        for(i=n/2; i<=n-2; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(-1);
        }
        cx.ptr.p_complex[n-1] = ae_complex_from_i(0);
        xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(cv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(cv2err,4*ae_machineepsilon*ae_c_abs(cy.ptr.p_complex[0], _state));
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv2,cy.ptr.p_complex[0]), _state),cv2err);
        
        /*
         * First test: X + X + ... + X = N*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        cy.ptr.p_complex[0] = ae_complex_from_d((2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state));
        for(i=1; i<=n-1; i++)
        {
            cy.ptr.p_complex[i] = cy.ptr.p_complex[0];
        }
        for(i=0; i<=n-1; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(1);
        }
        xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(cv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(cv2err,4*ae_machineepsilon*ae_c_abs(cy.ptr.p_complex[0], _state)*n);
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv2,ae_c_mul_d(cy.ptr.p_complex[0],1.0*n)), _state),cv2err);
    }
    
    /*
     * report
     */
    waserrors = approxerrors||exactnesserrors;
    if( !silent )
    {
        printf("TESTING XBLAS\n");
        printf("APPROX.TESTS:                            ");
        if( approxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("EXACT TESTS:                             ");
        if( exactnesserrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    
    /*
     * end
     */
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static ae_bool testdirectdensesolversunit_rmatrixchecksolutionm(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionmfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolution(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionm(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionmfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolution(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static void testdirectdensesolversunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testdirectdensesolversunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testdirectdensesolversunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testdirectdensesolversunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testdirectdensesolversunit_testrsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testspdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testcsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testhpdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* hpderrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_unset2d(/* Real    */ ae_matrix* x,
     ae_state *_state);
static void testdirectdensesolversunit_unset1d(/* Real    */ ae_vector* x,
     ae_state *_state);
static void testdirectdensesolversunit_cunset2d(/* Complex */ ae_matrix* x,
     ae_state *_state);
static void testdirectdensesolversunit_cunset1d(/* Complex */ ae_vector* x,
     ae_state *_state);
static void testdirectdensesolversunit_unsetrep(densesolverreport* r,
     ae_state *_state);
static void testdirectdensesolversunit_unsetlsrep(densesolverlsreport* r,
     ae_state *_state);





/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectdensesolvers(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    ae_int_t maxm;
    ae_int_t passcount;
    double threshold;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool spderrors;
    ae_bool hpderrors;
    ae_bool rfserrors;
    ae_bool waserrors;
    ae_bool result;


    maxn = 10;
    maxm = 5;
    passcount = 5;
    threshold = 10000*ae_machineepsilon;
    rfserrors = ae_false;
    rerrors = ae_false;
    cerrors = ae_false;
    spderrors = ae_false;
    hpderrors = ae_false;
    testdirectdensesolversunit_testrsolver(maxn, maxm, passcount, threshold, &rerrors, &rfserrors, _state);
    testdirectdensesolversunit_testspdsolver(maxn, maxm, passcount, threshold, &spderrors, &rfserrors, _state);
    testdirectdensesolversunit_testcsolver(maxn, maxm, passcount, threshold, &cerrors, &rfserrors, _state);
    testdirectdensesolversunit_testhpdsolver(maxn, maxm, passcount, threshold, &hpderrors, &rfserrors, _state);
    waserrors = (((rerrors||cerrors)||spderrors)||hpderrors)||rfserrors;
    if( !silent )
    {
        printf("TESTING DENSE SOLVER\n");
        printf("* REAL:                                   ");
        if( rerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                                ");
        if( cerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD:                                    ");
        if( spderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                    ");
        if( hpderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* ITERATIVE IMPROVEMENT:                  ");
        if( rfserrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionm(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][j]-xs->ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionmfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][j]-xs->ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolution(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_move(&xsm.ptr.pp_double[0][0], xsm.stride, &xs->ptr.p_double[0], 1, ae_v_len(0,n-1));
    result = testdirectdensesolversunit_rmatrixchecksolutionm(xe, n, 1, threshold, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][0]-xs->ptr.p_double[i], _state),threshold);
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    result = result&&ae_fp_eq(xs->ptr.pp_double[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_eq(xs->ptr.pp_double[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_move(&xsm.ptr.pp_double[0][0], xsm.stride, &xs->ptr.p_double[0], 1, ae_v_len(0,n-1));
    result = testdirectdensesolversunit_rmatrixchecksingularm(n, 1, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            result = result&&ae_fp_eq(xs->ptr.p_double[i],(double)(0));
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionm(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_c_abs(ae_c_sub(xe->ptr.pp_complex[i][j],xs->ptr.pp_complex[i][j]), _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionmfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
        return result;
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            result = result&&ae_fp_less_eq(ae_c_abs(ae_c_sub(xe->ptr.pp_complex[i][j],xs->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolution(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksolutionm(xe, n, 1, threshold, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksolutionmfast(xe, n, 1, threshold, info, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
        return result;
    }
    result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
    result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
    if( info==-3 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_c_eq_d(xs->ptr.pp_complex[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
        return result;
    }
    if( info==-3 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_c_eq_d(xs->ptr.pp_complex[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksingularm(n, 1, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksingularmfast(n, 1, info, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testdirectdensesolversunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testdirectdensesolversunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testdirectdensesolversunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testdirectdensesolversunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Real test
*************************************************************************/
static void testdirectdensesolversunit_testrsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_bool* rfserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix atmp;
    ae_vector p;
    ae_matrix xe;
    ae_matrix b;
    ae_vector bv;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t m;
    ae_int_t pass;
    ae_int_t taskkind;
    double v;
    double verr;
    ae_int_t info;
    densesolverreport rep;
    densesolverlsreport repls;
    ae_matrix x;
    ae_vector xv;
    ae_vector y;
    ae_vector tx;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&atmp, 0, sizeof(atmp));
    memset(&p, 0, sizeof(p));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    memset(&bv, 0, sizeof(bv));
    memset(&rep, 0, sizeof(rep));
    memset(&repls, 0, sizeof(repls));
    memset(&x, 0, sizeof(x));
    memset(&xv, 0, sizeof(xv));
    memset(&y, 0, sizeof(y));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&atmp, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&xe, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bv, 0, DT_REAL, _state, ae_true);
    _densesolverreport_init(&rep, _state, ae_true);
    _densesolverlsreport_init(&repls, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=maxn; n++)
        {
            for(m=1; m<=maxm; m++)
            {
                
                /*
                 * ********************************************************
                 * WELL CONDITIONED TASKS
                 * ability to find correct solution is tested
                 * ********************************************************
                 *
                 * 1. generate random well conditioned matrix A.
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods on original A
                 */
                rmatrixrndcond(n, (double)(1000), &a, _state);
                testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                rmatrixlu(&lua, n, n, &p, _state);
                ae_matrix_set_length(&xe, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                ae_matrix_set_length(&b, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                        b.ptr.pp_double[i][j] = v;
                    }
                }
                
                /*
                 * Test solvers
                 */
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixsolvem(&a, n, &b, m, ae_fp_greater(ae_randomreal(_state),0.5), &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                rmatrixsolvemfast(&a, n, &x, m, &info, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolvefast(&a, n, &bv, &info, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &bv, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixlusolvem(&lua, &p, n, &b, m, &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                rmatrixlusolvemfast(&lua, &p, n, &x, m, &info, _state);
                ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:552");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixlusolve(&lua, &p, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&xv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixlusolvefast(&lua, &p, n, &xv, &info, _state);
                ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &xv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:566");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixmixedsolvem(&a, &lua, &p, n, &b, m, &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixmixedsolve(&a, &lua, &p, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                
                /*
                 * Test DenseSolverRLS():
                 * * test on original system A*x = b
                 * * test on overdetermined system with the same solution: (A' A')'*x = (b' b')'
                 * * test on underdetermined system with the same solution: (A 0 0 0 ) * z = b
                 */
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolvels(&a, n, n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = (*rerrors||ae_fp_less(repls.r2,100*ae_machineepsilon))||ae_fp_greater(repls.r2,1+1000*ae_machineepsilon);
                    *rerrors = (*rerrors||repls.n!=n)||repls.k!=0;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                }
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, 2*n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                ae_v_move(&bv.ptr.p_double[n], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(n,2*n-1));
                ae_matrix_set_length(&atmp, 2*n, n, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, 0, n-1, 0, n-1, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, n, 2*n-1, 0, n-1, _state);
                rmatrixsolvels(&atmp, 2*n, n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = (*rerrors||ae_fp_less(repls.r2,100*ae_machineepsilon))||ae_fp_greater(repls.r2,1+1000*ae_machineepsilon);
                    *rerrors = (*rerrors||repls.n!=n)||repls.k!=0;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                }
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                ae_matrix_set_length(&atmp, n, 2*n, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, 0, n-1, 0, n-1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=n; j<=2*n-1; j++)
                    {
                        atmp.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                rmatrixsolvels(&atmp, n, 2*n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = *rerrors||ae_fp_neq(repls.r2,(double)(0));
                    *rerrors = (*rerrors||repls.n!=2*n)||repls.k!=n;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                    for(i=n; i<=2*n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xv.ptr.p_double[i], _state),threshold);
                    }
                }
                
                /*
                 * ********************************************************
                 * EXACTLY SINGULAR MATRICES
                 * ability to detect singularity is tested
                 * ********************************************************
                 *
                 * 1. generate different types of singular matrices:
                 *    * zero (TaskKind=0)
                 *    * with zero columns (TaskKind=1)
                 *    * with zero rows (TaskKind=2)
                 *    * with equal rows/columns (TaskKind=2 or 3)
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods
                 */
                for(taskkind=0; taskkind<=4; taskkind++)
                {
                    testdirectdensesolversunit_unset2d(&a, _state);
                    if( taskkind==0 )
                    {
                        
                        /*
                         * all zeros
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = (double)(0);
                            }
                        }
                    }
                    if( taskkind==1 )
                    {
                        
                        /*
                         * there is zero column
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==2 )
                    {
                        
                        /*
                         * there is zero row
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==3 )
                    {
                        
                        /*
                         * equal columns
                         */
                        if( n<2 )
                        {
                            continue;
                        }
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = 1+ae_randominteger(n-1, _state);
                        ae_v_move(&a.ptr.pp_double[0][0], a.stride, &a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1));
                    }
                    if( taskkind==4 )
                    {
                        
                        /*
                         * equal rows
                         */
                        if( n<2 )
                        {
                            continue;
                        }
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = 1+ae_randominteger(n-1, _state);
                        ae_v_move(&a.ptr.pp_double[0][0], 1, &a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1));
                    }
                    ae_matrix_set_length(&xe, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    ae_matrix_set_length(&b, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                            b.ptr.pp_double[i][j] = v;
                        }
                    }
                    testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                    rmatrixlu(&lua, n, n, &p, _state);
                    
                    /*
                     * Test RMatrixSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixsolvem(&a, n, &b, m, ae_fp_greater(ae_randomreal(_state),0.5), &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixSolveMFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_matrix_set_length(&x, n, m, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                            }
                        }
                        rmatrixsolvemfast(&a, n, &x, m, &info, _state);
                        *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularmfast(n, m, info, &x, _state);
                    }
                    
                    /*
                     * Test RMatrixSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                    
                    /*
                     * Test RMatrixSolveFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_vector_set_length(&bv, n, _state);
                        ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                        rmatrixsolvefast(&a, n, &bv, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularfast(n, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:784");
                    }
                    
                    /*
                     * Test RMatrixLUSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixlusolvem(&lua, &p, n, &b, m, &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixLUSolveMFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_matrix_set_length(&x, n, m, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                            }
                        }
                        rmatrixlusolvemfast(&lua, &p, n, &x, m, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularmfast(n, m, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:808");
                    }
                    
                    /*
                     * Test RMatrixLUSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixlusolve(&lua, &p, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                    
                    /*
                     * Test RMatrixLUSolveFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_vector_set_length(&bv, n, _state);
                        ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                        rmatrixlusolvefast(&lua, &p, n, &bv, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularfast(n, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:832");
                    }
                    
                    /*
                     * Test RMatrixMixedSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixmixedsolvem(&a, &lua, &p, n, &b, m, &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixMixedSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixmixedsolve(&a, &lua, &p, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                }
            }
        }
    }
    
    /*
     * test iterative improvement
     */
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Test iterative improvement matrices
         *
         * A matrix/right part are constructed such that both matrix
         * and solution components are within (-1,+1). Such matrix/right part
         * have nice properties - system can be solved using iterative
         * improvement with |A*x-b| about several ulps of max(1,|b|).
         */
        n = 100;
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, 1, _state);
        ae_vector_set_length(&bv, n, _state);
        ae_vector_set_length(&tx, n, _state);
        ae_vector_set_length(&xv, n, _state);
        ae_vector_set_length(&y, n, _state);
        for(i=0; i<=n-1; i++)
        {
            xv.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
            xdot(&y, &xv, n, &tx, &v, &verr, _state);
            bv.ptr.p_double[i] = v;
        }
        ae_v_move(&b.ptr.pp_double[0][0], b.stride, &bv.ptr.p_double[0], 1, ae_v_len(0,n-1));
        
        /*
         * Test RMatrixSolveM()
         */
        testdirectdensesolversunit_unset2d(&x, _state);
        rmatrixsolvem(&a, n, &b, 1, ae_true, &info, &rep, &x, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            ae_vector_set_length(&xv, n, _state);
            ae_v_move(&xv.ptr.p_double[0], 1, &x.ptr.pp_double[0][0], x.stride, ae_v_len(0,n-1));
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-b.ptr.pp_double[i][0], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(b.ptr.pp_double[i][0], _state), _state));
            }
        }
        
        /*
         * Test RMatrixSolve()
         */
        testdirectdensesolversunit_unset1d(&xv, _state);
        rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-bv.ptr.p_double[i], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(bv.ptr.p_double[i], _state), _state));
            }
        }
        
        /*
         * Test LS-solver on the same matrix
         */
        rmatrixsolvels(&a, n, n, &bv, 0.0, &info, &repls, &xv, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-bv.ptr.p_double[i], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(bv.ptr.p_double[i], _state), _state));
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
SPD test
*************************************************************************/
static void testdirectdensesolversunit_testspdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_bool* rfserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_matrix atmp;
    ae_vector p;
    ae_matrix xe;
    ae_matrix b;
    ae_vector bv;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t m;
    ae_int_t pass;
    ae_int_t taskkind;
    double v;
    ae_bool isupper;
    ae_int_t info;
    densesolverreport rep;
    densesolverlsreport repls;
    ae_matrix x;
    ae_vector xv;
    ae_vector y;
    ae_vector tx;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&atmp, 0, sizeof(atmp));
    memset(&p, 0, sizeof(p));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    memset(&bv, 0, sizeof(bv));
    memset(&rep, 0, sizeof(rep));
    memset(&repls, 0, sizeof(repls));
    memset(&x, 0, sizeof(x));
    memset(&xv, 0, sizeof(xv));
    memset(&y, 0, sizeof(y));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&atmp, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&xe, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bv, 0, DT_REAL, _state, ae_true);
    _densesolverreport_init(&rep, _state, ae_true);
    _densesolverlsreport_init(&repls, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=maxn; n++)
        {
            for(m=1; m<=maxm; m++)
            {
                
                /*
                 * ********************************************************
                 * WELL CONDITIONED TASKS
                 * ability to find correct solution is tested
                 * ********************************************************
                 *
                 * 1. generate random well conditioned matrix A.
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods on original A
                 */
                isupper = ae_fp_greater(ae_randomreal(_state),0.5);
                spdmatrixrndcond(n, (double)(1000), &a, _state);
                testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
                if( !spdmatrixcholesky(&cha, n, isupper, _state) )
                {
                    *spderrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ae_matrix_set_length(&xe, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                ae_matrix_set_length(&b, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                        b.ptr.pp_double[i][j] = v;
                    }
                }
                testdirectdensesolversunit_rmatrixdrophalf(&a, n, isupper, _state);
                testdirectdensesolversunit_rmatrixdrophalf(&cha, n, isupper, _state);
                
                /*
                 * Test solvers
                 */
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                spdmatrixsolvem(&a, n, isupper, &b, m, &info, &rep, &x, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                spdmatrixsolvemfast(&a, n, isupper, &x, m, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1023");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixsolve(&a, n, isupper, &bv, &info, &rep, &xv, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixsolvefast(&a, n, isupper, &bv, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1037");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                spdmatrixcholeskysolvem(&cha, n, isupper, &b, m, &info, &rep, &x, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                spdmatrixcholeskysolvemfast(&cha, n, isupper, &x, m, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1051");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state