/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * (C) Copyright 2019 Rockchip Electronics Co., Ltd.
 */

#ifndef _ASM_ARCH_GRF_RV1126_H
#define _ASM_ARCH_GRF_RV1126_H

struct rv1126_grf {
	unsigned int soc_con0;
	unsigned int soc_con1;
	unsigned int soc_con2;
	unsigned int reserved0[1];
	unsigned int soc_status0;
	unsigned int soc_status1;
	unsigned int reserved1[2];
	unsigned int cpu_con0;
	unsigned int cpu_con1;
	unsigned int reserved2[2];
	unsigned int cpu_status0;
	unsigned int reserved3[3];
	unsigned int noc_con0;
	unsigned int noc_con1;
	unsigned int noc_con2;
	unsigned int noc_con3;
	unsigned int usbhost_con0;
	unsigned int usbhost_con1;
	unsigned int usbhost_status0;
	unsigned int usbotg_con0;
	unsigned int usbotg_con1;
	unsigned int usbotg_status0;
	unsigned int usbotg_status1;
	unsigned int usbotg_status2;
	unsigned int mac_con0;
	unsigned int mac_con1;
	unsigned int mac_con2;
	unsigned int reserved4[2];
	unsigned int mac_status0;
	unsigned int mac_status1;
	unsigned int mac_status2;
	unsigned int mem_con0;
	unsigned int mem_con1;
	unsigned int mem_con2;
	unsigned int mem_con3;
	unsigned int reserved5[(0x100 - 0x09c) / 4 - 1];
	unsigned int tsadc_con0;
	unsigned int reserved6[3];
	unsigned int chip_id;
	unsigned int reserved7[(0x10000 - 0x110) / 4 - 1];
	unsigned int gpio0c_iomux_h;
	unsigned int gpio0d_iomux_l;
	unsigned int gpio0d_iomux_h;
	unsigned int reserved8[1];
	unsigned int gpio1a_iomux_l;
	unsigned int gpio1a_iomux_h;
	unsigned int gpio1b_iomux_l;
	unsigned int gpio1b_iomux_h;
	unsigned int gpio1c_iomux_l;
	unsigned int gpio1c_iomux_h;
	unsigned int gpio1d_iomux_l;
	unsigned int gpio1d_iomux_h;
	unsigned int gpio2a_iomux_l;
	unsigned int gpio2a_iomux_h;
	unsigned int gpio2b_iomux_l;
	unsigned int gpio2b_iomux_h;
	unsigned int gpio2c_iomux_l;
	unsigned int gpio2c_iomux_h;
	unsigned int gpio2d_iomux_l;
	unsigned int gpio2d_iomux_h;
	unsigned int gpio3a_iomux_l;
	unsigned int gpio3a_iomux_h;
	unsigned int gpio3b_iomux_l;
	unsigned int gpio3b_iomux_h;
	unsigned int gpio3c_iomux_l;
	unsigned int gpio3c_iomux_h;
	unsigned int gpio3d_iomux_l;
	unsigned int gpio3d_iomux_h;
	unsigned int gpio4a_iomux_l;
	unsigned int reserved9[3];
	unsigned int gpio0c_ds_h;
	unsigned int gpio0d_ds_l;
	unsigned int gpio0d_ds_h;
	unsigned int reserved10[1];
	unsigned int gpio1a_ds_l;
	unsigned int gpio1a_ds_h;
	unsigned int gpio1b_ds_l;
	unsigned int gpio1b_ds_h;
	unsigned int gpio1c_ds_l;
	unsigned int gpio1c_ds_h;
	unsigned int gpio1d_ds_l;
	unsigned int gpio1d_ds_h;
	unsigned int gpio2a_ds_l;
	unsigned int gpio2a_ds_h;
	unsigned int gpio2b_ds_l;
	unsigned int gpio2b_ds_h;
	unsigned int gpio2c_ds_l;
	unsigned int gpio2c_ds_h;
	unsigned int gpio2d_ds_l;
	unsigned int gpio2d_ds_h;
	unsigned int gpio3a_ds_l;
	unsigned int gpio3a_ds_h;
	unsigned int gpio3b_ds_l;
	unsigned int gpio3b_ds_h;
	unsigned int gpio3c_ds_l;
	unsigned int gpio3c_ds_h;
	unsigned int gpio3d_ds_l;
	unsigned int gpio3d_ds_h;
	unsigned int gpio4a_ds_l;
	unsigned int reserved12[3];
	unsigned int gpio0c_p_h;
	unsigned int gpio0d_p;
	unsigned int gpio1a_p;
	unsigned int gpio1b_p;
	unsigned int gpio1c_p;
	unsigned int gpio1d_p;
	unsigned int gpio2a_p;
	unsigned int gpio2b_p;
	unsigned int gpio2c_p;
	unsigned int gpio2d_p;
	unsigned int gpio3a_p;
	unsigned int gpio3b_p;
	unsigned int gpio3c_p;
	unsigned int gpio3d_p;
	unsigned int gpio4a_p;
	unsigned int reserved13[1];
	unsigned int gpio0c_ie_h;
	unsigned int gpio0d_ie;
	unsigned int gpio1a_ie;
	unsigned int gpio1b_ie;
	unsigned int gpio1c_ie;
	unsigned int gpio1d_ie;
	unsigned int gpio2a_ie;
	unsigned int gpio2b_ie;
	unsigned int gpio2c_ie;
	unsigned int gpio2d_ie;
	unsigned int gpio3a_ie;
	unsigned int gpio3b_ie;
	unsigned int gpio3c_ie;
	unsigned int gpio3d_ie;
	unsigned int gpio4a_ie;
	unsigned int reserved14[1];
	unsigned int gpio0c_smt_h;
	unsigned int gpio0d_smt;
	unsigned int gpio1a_smt;
	unsigned int gpio1b_smt;
	unsigned int gpio1c_smt;
	unsigned int gpio1d_smt;
	unsigned int gpio2a_smt;
	unsigned int gpio2b_smt;
	unsigned int gpio2c_smt;
	unsigned int gpio2d_smt;
	unsigned int gpio3a_smt;
	unsigned int gpio3b_smt;
	unsigned int gpio3c_smt;
	unsigned int gpio3d_smt;
	unsigned int gpio4a_smt;
	unsigned int reserved15[(0x10200 - 0x101b8) / 4 - 1];
	unsigned int csiphy0_con;
	unsigned int reserved16[1];
	unsigned int csiphy0_status;
	unsigned int reserved17[1];
	unsigned int csiphy1_con;
	unsigned int reserved18[1];
	unsigned int csiphy1_status;
	unsigned int reserved19[1];
	unsigned int dsiphy_con;
	unsigned int reserved20[3];
	unsigned int usbphy_con0;
	unsigned int usbphy_con1;
	unsigned int usbphy_con2;
	unsigned int reserved21[3];
	unsigned int usbphy_status;
	unsigned int reserved22[1];
	unsigned int cifio_con;
	unsigned int sddetflt_con;
	unsigned int uart2rx_low_con;
	unsigned int reserved23[1];
	unsigned int iofunc_con0;
	unsigned int iofunc_con1;
	unsigned int iofunc_con2;
	unsigned int iofunc_con3;
	unsigned int usbphy0_cfg_con;
	unsigned int usbphy0_cfg_addrin;
	unsigned int usbphy0_cfg_addrout;
	unsigned int usbphy0_cfg_dly_con;
	unsigned int usbphy1_cfg_con;
	unsigned int usbphy1_cfg_addrin;
	unsigned int usbphy1_cfg_addrout;
	unsigned int usbphy1_cfg_dly_con;
	unsigned int reserved24[(0x10300 - 0x1028c) / 4 - 1];
	unsigned int usb_sig_detect_con;
	unsigned int usb_sig_detect_status;
	unsigned int usb_sig_detect_clr;
	unsigned int reserved25[1];
	unsigned int usb_linestate_con;
	unsigned int usb_disconnect_con;
	unsigned int usb_bvalid_con;
	unsigned int usb_id_con;
};

check_member(rv1126_grf, usb_id_con, 0x1031c);

struct rv1126_pmugrf {
	unsigned int gpio0a_iomux_l;
	unsigned int gpio0a_iomux_h;
	unsigned int gpio0b_iomux_l;
	unsigned int gpio0b_iomux_h;
	unsigned int gpio0c_iomux_l;
	unsigned int reserved0[3];
	unsigned int gpio0a_ds_l;
	unsigned int gpio0a_ds_h;
	unsigned int gpio0b_ds_l;
	unsigned int gpio0b_ds_h;
	unsigned int gpio0c_ds_l;
	unsigned int osc_ds;
	unsigned int reserved1[2];
	unsigned int gpio0a_p;
	unsigned int gpio0b_p;
	unsigned int gpio0c_p_l;
	unsigned int reserved2[1];
	unsigned int gpio0a_ie;
	unsigned int gpio0b_ie;
	unsigned int gpio0c_ie_l;
	unsigned int reserved3[1];
	unsigned int gpio0a_smt;
	unsigned int gpio0b_smt;
	unsigned int gpio0c_smt_l;
	unsigned int reserved4[(0x100 - 0x68) / 4 - 1];
	unsigned int soc_con[7];
	unsigned int reserved5[(0x140 - 0x118) / 4 - 1];
	unsigned int io_vsel;
	unsigned int io_vret;
	unsigned int reserved6[(0x180 - 0x144) / 4 - 1];
	unsigned int pmupvtm_clkdiv;
	unsigned int reserved7[(0x200 - 0x180) / 4 - 1];
	unsigned int os_reg[12];
	unsigned int rstfunc_status;
	unsigned int rstfunc_clr;
	unsigned int reserved8[(0x380 - 0x234) / 4 - 1];
	unsigned int sd_detect_con;
	unsigned int reserved9[3];
	unsigned int sd_detect_status;
	unsigned int reserved10[3];
	unsigned int sd_detect_clr;
	unsigned int reserved11[3];
	unsigned int sd_det_count;
};

check_member(rv1126_pmugrf, sd_det_count, 0x3b0);

#endif
