libvgio is a library for (de)serializing `vg` files for use with the
[vg toolkit](https://github.com/vgteam/vg) (see _Sequence variation aware genome
references and read mapping with the variation graph toolkit_).

This tool is in the development stage, so it may contain bugs and the
instructions on how to use it are subject to change.

## Compiling

libvgio is implemented in C++11 and is built using CMake.

libvgio's only dependencies are protobuf
([Google Protocol Buffers](https://developers.google.com/protocol-buffers/)),
[htslib](https://www.htslib.org/), and pthreads, all of which can be easily
installed on any Unix style system.

**libvgio requires htslib 1.10 or greater** to avoid [a bug in htslib that truncates multi-member GZIP files after the first member](https://github.com/samtools/htslib/issues/742). If you build against an older htslib, you will not be able to read all VG and GAM files properly, especially GraphAligner GAMs.

Once protobufs and pthreads are installed, you can build and install libvgio
by running the installation script: `./install.sh [INSTALL_LOCATION]`.
This will install the dynamic library and headers in your home directory unless
you provide the script with the optional `INSTALL_LOCATION`.

## Usage

libvgio exposes two header files `vg/vg.pb.h` and
`vg/io/basic_stream.hpp`.
`vg/vg.pb.h` is the header generated by the vg protobuf (see the
[vg toolkit Wiki](https://github.com/vgteam/vg/wiki/File-Formats) for details)
and `vg/io/basic_stream.hpp` exposes an input stream and an output stream.

The following C++ example reads a vg graph with the input stream and writes it
to the standard output with the output stream.

```cpp
#include <iostream>
#include "vg/vg.pb.h"
#include "vg/io/basic_stream.hpp"

using std::cout;
using std::endl;
using vg::Graph;
using vg::io::inputStream;
using vg::io::outputStream;

int main(int argc, char* argv[])
{
  if (argc != 2) {
    cout << "Usage: " << argv[0] << " VG_FILE" << endl;
    return -1;
  }
  Graph g = inputStream(argv[1]);
  outputStream(g);
  return 0;
}
```

This can be compiled by linking against libvgio at compile time
```
g++ -lvgio <myprogram>.cpp
```
or with CMake
```
find_package(VGio REQUIRED)
target_link_libraries(myprogram VGio::VGio)
```
