// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SADDW2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SADDW2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_saddw2_8H[] = {
  0x0001, 0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000,
  0x0028, 0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001,
  0x004a, 0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002,
  0x0076, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0008,
  0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033,
  0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055,
  0x007d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d,
  0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e,
  0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f,
  0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0xff80,
  0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0xff81,
  0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0xff82,
  0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0xff83,
  0x00fb, 0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xffaa,
  0x00fc, 0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0xffcc,
  0x00fd, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0xfff8,
  0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0xfffd,
  0xffff, 0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0xfffe,
  0x0000, 0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0xffff,
  0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0xffff, 0x0001,
  0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002,
  0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003,
  0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0009,
  0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034,
  0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056,
  0x007e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e,
  0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f,
  0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080,
  0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0xff81,
  0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0xff80, 0xff82,
  0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0xff81, 0xff83,
  0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0xff82, 0xff84,
  0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xffab,
  0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xffaa, 0xffcd,
  0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0xffcc, 0xfff9,
  0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0xfff8, 0xfffe,
  0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0xfffd, 0xffff,
  0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0xfffe, 0x0000,
  0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0xfffe, 0x0000, 0x0002,
  0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003,
  0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004,
  0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x000a,
  0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035,
  0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057,
  0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f,
  0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080,
  0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081,
  0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0xff82,
  0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0xff81, 0xff83,
  0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0xff80, 0xff82, 0xff84,
  0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0xff81, 0xff83, 0xff85,
  0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xffac,
  0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xffab, 0xffce,
  0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xffaa, 0xffcd, 0xfffa,
  0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0xffcc, 0xfff9, 0xffff,
  0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0xfff8, 0xfffe, 0x0000,
  0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0xfffd, 0xffff, 0x0001,
  0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0xfffd, 0xffff, 0x0001, 0x0010,
  0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011,
  0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012,
  0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0018,
  0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043,
  0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065,
  0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d,
  0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e,
  0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f,
  0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0xff90,
  0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0xff82, 0xff91,
  0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0xff81, 0xff83, 0xff92,
  0x55aa, 0x807a, 0x807c, 0x807e, 0xff80, 0xff82, 0xff84, 0xff93,
  0x55d2, 0x807b, 0x807d, 0x7f7f, 0xff81, 0xff83, 0xff85, 0xffba,
  0x55d3, 0x807c, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xffac, 0xffdc,
  0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xffab, 0xffce, 0x0008,
  0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xffaa, 0xffcd, 0xfffa, 0x000d,
  0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0xffcc, 0xfff9, 0xffff, 0x000e,
  0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0xfff8, 0xfffe, 0x0000, 0x000f,
  0x7f80, 0x7fa8, 0x7fcb, 0xfff8, 0xfffe, 0x0000, 0x000f, 0x007d,
  0x7fa7, 0x7fca, 0x7ff7, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e,
  0x7fc9, 0x7ff6, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f,
  0x7ff5, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x0085,
  0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0,
  0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2,
  0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa,
  0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb,
  0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc,
  0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0xfffd,
  0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0xff90, 0xfffe,
  0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0xff82, 0xff91, 0xffff,
  0x8052, 0x807b, 0x807d, 0x007f, 0xff81, 0xff83, 0xff92, 0x0000,
  0x807a, 0x807c, 0x807e, 0xff80, 0xff82, 0xff84, 0xff93, 0x0027,
  0x807b, 0x807d, 0x7f7f, 0xff81, 0xff83, 0xff85, 0xffba, 0x0049,
  0x807c, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xffac, 0xffdc, 0x0075,
  0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xffab, 0xffce, 0x0008, 0x007a,
  0x7f7e, 0x7f80, 0x7f82, 0xffaa, 0xffcd, 0xfffa, 0x000d, 0x007b,
  0x7f7f, 0x7f81, 0x7fa9, 0xffcc, 0xfff9, 0xffff, 0x000e, 0x007c,
  0x7f81, 0x7fa9, 0xffcc, 0xfff9, 0xffff, 0x000e, 0x007c, 0x007e,
  0x7fa8, 0x7fcb, 0xfff8, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f,
  0x7fca, 0x7ff7, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080,
  0x7ff6, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x0086,
  0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1,
  0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3,
  0x7ffd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb,
  0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc,
  0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd,
  0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0xfffe,
  0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0xfffd, 0xffff,
  0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0xff90, 0xfffe, 0x0000,
  0x8053, 0x807c, 0x007e, 0x0080, 0xff82, 0xff91, 0xffff, 0x0001,
  0x807b, 0x807d, 0x007f, 0xff81, 0xff83, 0xff92, 0x0000, 0x0028,
  0x807c, 0x807e, 0xff80, 0xff82, 0xff84, 0xff93, 0x0027, 0x004a,
  0x807d, 0x7f7f, 0xff81, 0xff83, 0xff85, 0xffba, 0x0049, 0x0076,
  0x7f7e, 0x7f80, 0xff82, 0xff84, 0xffac, 0xffdc, 0x0075, 0x007b,
  0x7f7f, 0x7f81, 0xff83, 0xffab, 0xffce, 0x0008, 0x007a, 0x007c,
  0x7f80, 0x7f82, 0xffaa, 0xffcd, 0xfffa, 0x000d, 0x007b, 0x007d,
  0x7f82, 0xffaa, 0xffcd, 0xfffa, 0x000d, 0x007b, 0x007d, 0x007f,
  0x7fa9, 0xffcc, 0xfff9, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080,
  0x7fcb, 0xfff8, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081,
  0x7ff7, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x0087,
  0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2,
  0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4,
  0x7ffe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc,
  0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd,
  0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe,
  0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0xffff,
  0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0xfffe, 0x0000,
  0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0xfffd, 0xffff, 0x0001,
  0x8054, 0x007d, 0x007f, 0x0081, 0xff90, 0xfffe, 0x0000, 0x0002,
  0x807c, 0x007e, 0x0080, 0xff82, 0xff91, 0xffff, 0x0001, 0x0029,
  0x807d, 0x007f, 0xff81, 0xff83, 0xff92, 0x0000, 0x0028, 0x004b,
  0x807e, 0xff80, 0xff82, 0xff84, 0xff93, 0x0027, 0x004a, 0x0077,
  0x7f7f, 0xff81, 0xff83, 0xff85, 0xffba, 0x0049, 0x0076, 0x007c,
  0x7f80, 0xff82, 0xff84, 0xffac, 0xffdc, 0x0075, 0x007b, 0x007d,
  0x7f81, 0xff83, 0xffab, 0xffce, 0x0008, 0x007a, 0x007c, 0x007e,
  0xff83, 0xffab, 0xffce, 0x0008, 0x007a, 0x007c, 0x007e, 0x3333,
  0xffaa, 0xffcd, 0xfffa, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334,
  0xffcc, 0xfff9, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335,
  0xfff8, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x333b,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366,
  0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388,
  0xffff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0,
  0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1,
  0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2,
  0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x32b3,
  0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0xffff, 0x32b4,
  0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0xfffe, 0x0000, 0x32b5,
  0x0055, 0x007e, 0x0080, 0x008f, 0xfffd, 0xffff, 0x0001, 0x32b6,
  0x007d, 0x007f, 0x0081, 0xff90, 0xfffe, 0x0000, 0x0002, 0x32dd,
  0x007e, 0x0080, 0xff82, 0xff91, 0xffff, 0x0001, 0x0029, 0x32ff,
  0x007f, 0xff81, 0xff83, 0xff92, 0x0000, 0x0028, 0x004b, 0x332b,
  0xff80, 0xff82, 0xff84, 0xff93, 0x0027, 0x004a, 0x0077, 0x3330,
  0xff81, 0xff83, 0xff85, 0xffba, 0x0049, 0x0076, 0x007c, 0x3331,
  0xff82, 0xff84, 0xffac, 0xffdc, 0x0075, 0x007b, 0x007d, 0x3332,
  0xff84, 0xffac, 0xffdc, 0x0075, 0x007b, 0x007d, 0x3332, 0x5555,
  0xffab, 0xffce, 0x0008, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556,
  0xffcd, 0xfffa, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557,
  0xfff9, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x555d,
  0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588,
  0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa,
  0x0000, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2,
  0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3,
  0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4,
  0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x54d5,
  0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x32b3, 0x54d6,
  0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0xffff, 0x32b4, 0x54d7,
  0x0056, 0x007f, 0x008e, 0x00fc, 0xfffe, 0x0000, 0x32b5, 0x54d8,
  0x007e, 0x0080, 0x008f, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x54ff,
  0x007f, 0x0081, 0xff90, 0xfffe, 0x0000, 0x0002, 0x32dd, 0x5521,
  0x0080, 0xff82, 0xff91, 0xffff, 0x0001, 0x0029, 0x32ff, 0x554d,
  0xff81, 0xff83, 0xff92, 0x0000, 0x0028, 0x004b, 0x332b, 0x5552,
  0xff82, 0xff84, 0xff93, 0x0027, 0x004a, 0x0077, 0x3330, 0x5553,
  0xff83, 0xff85, 0xffba, 0x0049, 0x0076, 0x007c, 0x3331, 0x5554,
  0xff85, 0xffba, 0x0049, 0x0076, 0x007c, 0x3331, 0x5554, 0x7ffd,
  0xffac, 0xffdc, 0x0075, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe,
  0xffce, 0x0008, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff,
  0xfffa, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x8005,
  0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030,
  0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052,
  0x0001, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a,
  0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b,
  0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c,
  0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x7f7d,
  0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x54d5, 0x7f7e,
  0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x32b3, 0x54d6, 0x7f7f,
  0x0057, 0x008d, 0x00fb, 0x00fd, 0xffff, 0x32b4, 0x54d7, 0x7f80,
  0x007f, 0x008e, 0x00fc, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fa7,
  0x0080, 0x008f, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x54ff, 0x7fc9,
  0x0081, 0xff90, 0xfffe, 0x0000, 0x0002, 0x32dd, 0x5521, 0x7ff5,
  0xff82, 0xff91, 0xffff, 0x0001, 0x0029, 0x32ff, 0x554d, 0x7ffa,
  0xff83, 0xff92, 0x0000, 0x0028, 0x004b, 0x332b, 0x5552, 0x7ffb,
  0xff84, 0xff93, 0x0027, 0x004a, 0x0077, 0x3330, 0x5553, 0x7ffc,
  0xff93, 0x0027, 0x004a, 0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe,
  0xffba, 0x0049, 0x0076, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff,
  0xffdc, 0x0075, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000,
  0x0008, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x8006,
  0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031,
  0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053,
  0x000f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b,
  0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c,
  0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d,
  0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e,
  0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f,
  0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80,
  0x0065, 0x00fa, 0x00fc, 0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81,
  0x008d, 0x00fb, 0x00fd, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8,
  0x008e, 0x00fc, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca,
  0x008f, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6,
  0xff90, 0xfffe, 0x0000, 0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb,
  0xff91, 0xffff, 0x0001, 0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc,
  0xff92, 0x0000, 0x0028, 0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd,
  0x0000, 0x0028, 0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff,
  0x0027, 0x004a, 0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000,
  0x0049, 0x0076, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001,
  0x0075, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007,
  0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032,
  0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054,
  0x007c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c,
  0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d,
  0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e,
  0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f,
  0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80,
  0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81,
  0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82,
  0x00fa, 0x00fc, 0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9,
  0x00fb, 0x00fd, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb,
  0x00fc, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7,
  0xfffd, 0xffff, 0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc,
  0xfffe, 0x0000, 0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd,
  0xffff, 0x0001, 0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe,
  0x0001, 0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000,
  0x0028, 0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001,
  0x004a, 0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002,
  0x0076, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8008,
  0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033,
  0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055,
  0x007d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d,
  0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e,
  0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f,
  0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x7f80,
  0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0x7f81,
  0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0x7f82,
  0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83,
  0x00fb, 0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7faa,
  0x00fc, 0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0x7fcc,
  0x00fd, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0x7ff8,
  0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0x7ffd,
  0xffff, 0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0x7ffe,
  0x0000, 0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0x7fff,
  0x0002, 0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0x7fff, 0x8001,
  0x0029, 0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002,
  0x004b, 0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003,
  0x0077, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8009,
  0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034,
  0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056,
  0x007e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e,
  0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f,
  0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080,
  0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x7f81,
  0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x7f80, 0x7f82,
  0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0x7f81, 0x7f83,
  0x00d4, 0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0x7f82, 0x7f84,
  0x00fc, 0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7fab,
  0x00fd, 0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7faa, 0x7fcd,
  0x00fe, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0x7fcc, 0x7ff9,
  0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0x7ff8, 0x7ffe,
  0x0000, 0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0x7ffd, 0x7fff,
  0x0001, 0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0x7ffe, 0x8000,
  0x32b6, 0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa,
  0x32dd, 0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab,
  0x32ff, 0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac,
  0x332b, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaab2,
  0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd,
  0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff,
  0x3332, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27,
  0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28,
  0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29,
  0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xaa2a,
  0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x7f81, 0xaa2b,
  0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x7f80, 0x7f82, 0xaa2c,
  0x3388, 0x55d2, 0x807b, 0x807d, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d,
  0x33b0, 0x55d3, 0x807c, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa54,
  0x33b1, 0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7fab, 0xaa76,
  0x33b2, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7faa, 0x7fcd, 0xaaa2,
  0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0x7fcc, 0x7ff9, 0xaaa7,
  0x32b4, 0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0x7ff8, 0x7ffe, 0xaaa8,
  0x32b5, 0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0x7ffd, 0x7fff, 0xaaa9,
  0x54d8, 0x7fa7, 0x7fca, 0x7ff7, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc,
  0x54ff, 0x7fc9, 0x7ff6, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd,
  0x5521, 0x7ff5, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce,
  0x554d, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccd4,
  0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff,
  0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21,
  0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49,
  0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a,
  0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b,
  0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcc4c,
  0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xaa2a, 0xcc4d,
  0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x7f81, 0xaa2b, 0xcc4e,
  0x55aa, 0x807a, 0x807c, 0x807e, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f,
  0x55d2, 0x807b, 0x807d, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xcc76,
  0x55d3, 0x807c, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa54, 0xcc98,
  0x55d4, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7fab, 0xaa76, 0xccc4,
  0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7faa, 0x7fcd, 0xaaa2, 0xccc9,
  0x54d6, 0x7f7f, 0x7f81, 0x7fa9, 0x7fcc, 0x7ff9, 0xaaa7, 0xccca,
  0x54d7, 0x7f80, 0x7fa8, 0x7fcb, 0x7ff8, 0x7ffe, 0xaaa8, 0xcccb,
  0x7f80, 0x7fa8, 0x7fcb, 0x7ff8, 0x7ffe, 0xaaa8, 0xcccb, 0xff80,
  0x7fa7, 0x7fca, 0x7ff7, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81,
  0x7fc9, 0x7ff6, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82,
  0x7ff5, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff88,
  0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3,
  0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5,
  0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd,
  0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe,
  0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff,
  0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0xff00,
  0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcc4c, 0xff01,
  0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xaa2a, 0xcc4d, 0xff02,
  0x8052, 0x807b, 0x807d, 0x807f, 0x7f81, 0xaa2b, 0xcc4e, 0xff03,
  0x807a, 0x807c, 0x807e, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff2a,
  0x807b, 0x807d, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xcc76, 0xff4c,
  0x807c, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa54, 0xcc98, 0xff78,
  0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7fab, 0xaa76, 0xccc4, 0xff7d,
  0x7f7e, 0x7f80, 0x7f82, 0x7faa, 0x7fcd, 0xaaa2, 0xccc9, 0xff7e,
  0x7f7f, 0x7f81, 0x7fa9, 0x7fcc, 0x7ff9, 0xaaa7, 0xccca, 0xff7f,
  0x7f81, 0x7fa9, 0x7fcc, 0x7ff9, 0xaaa7, 0xccca, 0xff7f, 0xff81,
  0x7fa8, 0x7fcb, 0x7ff8, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82,
  0x7fca, 0x7ff7, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83,
  0x7ff6, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff89,
  0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4,
  0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6,
  0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe,
  0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff,
  0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000,
  0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0xff01,
  0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0xff00, 0xff02,
  0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcc4c, 0xff01, 0xff03,
  0x8053, 0x807c, 0x807e, 0x8080, 0xaa2a, 0xcc4d, 0xff02, 0xff04,
  0x807b, 0x807d, 0x807f, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff2b,
  0x807c, 0x807e, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff2a, 0xff4d,
  0x807d, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xcc76, 0xff4c, 0xff79,
  0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa54, 0xcc98, 0xff78, 0xff7e,
  0x7f7f, 0x7f81, 0x7f83, 0x7fab, 0xaa76, 0xccc4, 0xff7d, 0xff7f,
  0x7f80, 0x7f82, 0x7faa, 0x7fcd, 0xaaa2, 0xccc9, 0xff7e, 0xff80,
  0x7f82, 0x7faa, 0x7fcd, 0xaaa2, 0xccc9, 0xff7e, 0xff80, 0xff82,
  0x7fa9, 0x7fcc, 0x7ff9, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83,
  0x7fcb, 0x7ff8, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84,
  0x7ff7, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff8a,
  0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5,
  0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7,
  0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff,
  0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000,
  0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001,
  0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0xff02,
  0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0xff01, 0xff03,
  0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0xff00, 0xff02, 0xff04,
  0x8054, 0x807d, 0x807f, 0xab29, 0xcc4c, 0xff01, 0xff03, 0xff05,
  0x807c, 0x807e, 0x8080, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff2c,
  0x807d, 0x807f, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff2b, 0xff4e,
  0x807e, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff2a, 0xff4d, 0xff7a,
  0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xcc76, 0xff4c, 0xff79, 0xff7f,
  0x7f80, 0x7f82, 0x7f84, 0xaa54, 0xcc98, 0xff78, 0xff7e, 0xff80,
  0x7f81, 0x7f83, 0x7fab, 0xaa76, 0xccc4, 0xff7d, 0xff7f, 0xff81,
  0x7f83, 0x7fab, 0xaa76, 0xccc4, 0xff7d, 0xff7f, 0xff81, 0xff83,
  0x7faa, 0x7fcd, 0xaaa2, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84,
  0x7fcc, 0x7ff9, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85,
  0x7ff8, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff8b,
  0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6,
  0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8,
  0x7fff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000,
  0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001,
  0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002,
  0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0xff03,
  0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0xff02, 0xff04,
  0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0xff01, 0xff03, 0xff05,
  0x8055, 0x807e, 0xab28, 0xcd4b, 0xff00, 0xff02, 0xff04, 0xff06,
  0x807d, 0x807f, 0xab29, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff2d,
  0x807e, 0x8080, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff2c, 0xff4f,
  0x807f, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff2b, 0xff4e, 0xff7b,
  0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff2a, 0xff4d, 0xff7a, 0xff80,
  0x7f81, 0x7f83, 0xaa2d, 0xcc76, 0xff4c, 0xff79, 0xff7f, 0xff81,
  0x7f82, 0x7f84, 0xaa54, 0xcc98, 0xff78, 0xff7e, 0xff80, 0xff82,
  0x7f84, 0xaa54, 0xcc98, 0xff78, 0xff7e, 0xff80, 0xff82, 0xfff0,
  0x7fab, 0xaa76, 0xccc4, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1,
  0x7fcd, 0xaaa2, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2,
  0x7ff9, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0xfff8,
  0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023,
  0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045,
  0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d,
  0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e,
  0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f,
  0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff70,
  0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff71,
  0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff72,
  0x8056, 0xab27, 0xcd4a, 0xffff, 0xff01, 0xff03, 0xff05, 0xff73,
  0x807e, 0xab28, 0xcd4b, 0xff00, 0xff02, 0xff04, 0xff06, 0xff9a,
  0x807f, 0xab29, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff2d, 0xffbc,
  0x8080, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffe8,
  0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffed,
  0x7f82, 0xaa2c, 0xcc4f, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffee,
  0x7f83, 0xaa2d, 0xcc76, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffef,
  0xaa2d, 0xcc76, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffef, 0xfffd,
  0xaa54, 0xcc98, 0xff78, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe,
  0xaa76, 0xccc4, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff,
  0xaaa2, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x0005,
  0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030,
  0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052,
  0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a,
  0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b,
  0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c,
  0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0xff7d,
  0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff70, 0xff7e,
  0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff71, 0xff7f,
  0xaaff, 0xcd49, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff72, 0xff80,
  0xab27, 0xcd4a, 0xffff, 0xff01, 0xff03, 0xff05, 0xff73, 0xffa7,
  0xab28, 0xcd4b, 0xff00, 0xff02, 0xff04, 0xff06, 0xff9a, 0xffc9,
  0xab29, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff2d, 0xffbc, 0xfff5,
  0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffe8, 0xfffa,
  0xaa2b, 0xcc4e, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffed, 0xfffb,
  0xaa2c, 0xcc4f, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffee, 0xfffc,
  0xcc4f, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffee, 0xfffc, 0xfffe,
  0xcc76, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffef, 0xfffd, 0xffff,
  0xcc98, 0xff78, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe, 0x0000,
  0xccc4, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff, 0x0006,
  0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x0005, 0x0031,
  0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030, 0x0053,
  0xcccb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052, 0x007b,
  0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a, 0x007c,
  0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b, 0x007d,
  0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c, 0xff7e,
  0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0xff7d, 0xff7f,
  0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff70, 0xff7e, 0xff80,
  0xcd21, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff71, 0xff7f, 0xff81,
  0xcd49, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff72, 0xff80, 0xffa8,
  0xcd4a, 0xffff, 0xff01, 0xff03, 0xff05, 0xff73, 0xffa7, 0xffca,
  0xcd4b, 0xff00, 0xff02, 0xff04, 0xff06, 0xff9a, 0xffc9, 0xfff6,
  0xcc4c, 0xff01, 0xff03, 0xff05, 0xff2d, 0xffbc, 0xfff5, 0xfffb,
  0xcc4d, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffe8, 0xfffa, 0xfffc,
  0xcc4e, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffed, 0xfffb, 0xfffd,
  0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffed, 0xfffb, 0xfffd, 0xffff,
  0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffee, 0xfffc, 0xfffe, 0x0000,
  0xff4c, 0xff79, 0xff7f, 0xff81, 0xffef, 0xfffd, 0xffff, 0x0001,
  0xff78, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe, 0x0000, 0x0007,
  0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff, 0x0006, 0x0032,
  0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x0005, 0x0031, 0x0054,
  0xff7f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030, 0x0053, 0x007c,
  0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052, 0x007b, 0x007d,
  0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a, 0x007c, 0x007e,
  0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b, 0x007d, 0xff7f,
  0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c, 0xff7e, 0xff80,
  0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0xff7d, 0xff7f, 0xff81,
  0xffd5, 0xfffe, 0x0000, 0x0002, 0xff70, 0xff7e, 0xff80, 0xff82,
  0xfffd, 0xffff, 0x0001, 0xff03, 0xff71, 0xff7f, 0xff81, 0xffa9,
  0xfffe, 0x0000, 0xff02, 0xff04, 0xff72, 0xff80, 0xffa8, 0xffcb,
  0xffff, 0xff01, 0xff03, 0xff05, 0xff73, 0xffa7, 0xffca, 0xfff7,
  0xff00, 0xff02, 0xff04, 0xff06, 0xff9a, 0xffc9, 0xfff6, 0xfffc,
  0xff01, 0xff03, 0xff05, 0xff2d, 0xffbc, 0xfff5, 0xfffb, 0xfffd,
  0xff02, 0xff04, 0xff2c, 0xff4f, 0xffe8, 0xfffa, 0xfffc, 0xfffe,
};
const unsigned kExpectedCount_NEON_saddw2_8H = 456;

#endif  // VIXL_SIM_SADDW2_8H_TRACE_AARCH64_H_
