// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLAL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UMLAL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_umlal2_4S[] = {
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x00000020,
  0x3ffd8006, 0x3ffe8003, 0x00000002, 0x00000020,
  0x3ffe0003, 0x00000001, 0x00008001, 0x00000020,
  0x00000000, 0x00007fff, 0x00010000, 0x00000020,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0x00000020,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0x00000020,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0x00000020,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0x00000020,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0x00000020,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0x00000020,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0x00000020,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0x00000020,
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x00000020,
  0x3ffd8006, 0x3ffe8003, 0x3fff8002, 0x00000020,
  0x3ffe0003, 0x3fff0001, 0x40000001, 0x00000020,
  0x3ffe8000, 0x3fff7fff, 0x55545558, 0x00000020,
  0x3ffefffd, 0x5553aaad, 0x66653336, 0x00000020,
  0x55530002, 0x66646669, 0x7fbf0082, 0x00000020,
  0x6663999c, 0x7fbe0101, 0x7fbf8081, 0x00000020,
  0x7fbd0180, 0x7fbe80ff, 0x7fc00080, 0x00000020,
  0x7fbd817d, 0x7fbf00fd, 0x7fc0807f, 0x00000020,
  0x7fbe017a, 0x7fbf80fb, 0x7ff70012, 0x00000020,
  0x7fbe8177, 0x7ff60021, 0x7ffd8005, 0x00000020,
  0x7ff50030, 0x7ffc8007, 0x7ffe0004, 0x00000020,
  0x7ffc8006, 0x7ffe0003, 0x00000002, 0x00000020,
  0x7ffd0004, 0x7ffe8002, 0x00000002, 0x00000021,
  0x7ffd8002, 0x00000001, 0x00000002, 0x00000022,
  0x00000000, 0x00008000, 0x00000002, 0x00000030,
  0x00007ffe, 0x0000ffff, 0x00000002, 0x0000009d,
  0x0000fffc, 0x0007fff1, 0x00000002, 0x0000009e,
  0x0007ffe0, 0x003e7f84, 0x00000002, 0x0000009f,
  0x003e7f06, 0x003eff83, 0x00000002, 0x00003353,
  0x003eff04, 0x003f7f82, 0x00000002, 0x00005575,
  0x003f7f02, 0x19994cce, 0x00000002, 0x0000801d,
  0x1999199a, 0x2aaa2aac, 0x00000002, 0x0000801e,
  0x2aa9d556, 0x3ffe0004, 0x00000002, 0x0000801f,
  0x3ffd8006, 0x3ffe8003, 0x00000002, 0x00008020,
  0x3ffe0004, 0x3fff0002, 0x00000002, 0x00008021,
  0x3ffe8002, 0x3fff8001, 0x00000002, 0x0000aaca,
  0x3fff0000, 0x40000000, 0x00000002, 0x0000ccec,
  0x3fff7ffe, 0x55545557, 0x00000002, 0x0000ffa0,
  0x5553aaac, 0x66653335, 0x00000002, 0x0000ffa1,
  0x66646668, 0x7fbf0081, 0x00000002, 0x0000ffa2,
  0x7fbe0100, 0x7fbf8080, 0x00000002, 0x0000ffa3,
  0x7fbe80fe, 0x7fc0007f, 0x00000002, 0x00010010,
  0x7fbf00fc, 0x7fc0807e, 0x00000002, 0x0001001d,
  0x7fbf80fa, 0x7ff70011, 0x00000002, 0x0001001e,
  0x7ff60020, 0x7ffd8004, 0x00000002, 0x0001001f,
  0x7ffd8003, 0x00000001, 0x00010001, 0x00000020,
  0x7ffe0002, 0x00000001, 0x00000002, 0x00000022,
  0x7ffe8001, 0x00000001, 0x00000003, 0x00000024,
  0x00000000, 0x00000001, 0x00000004, 0x00000040,
  0x00007fff, 0x00000001, 0x00000012, 0x0000011a,
  0x0000fffe, 0x00000001, 0x0000007f, 0x0000011c,
  0x0007fff0, 0x00000001, 0x00000080, 0x0000011e,
  0x003e7f83, 0x00000001, 0x00000081, 0x00006686,
  0x003eff82, 0x00000001, 0x00003335, 0x0000aaca,
  0x003f7f81, 0x00000001, 0x00005557, 0x0001001a,
  0x19994ccd, 0x00000001, 0x00007fff, 0x0001001c,
  0x2aaa2aab, 0x00000001, 0x00008000, 0x0001001e,
  0x3ffe0003, 0x00000001, 0x00008001, 0x00010020,
  0x3ffe8002, 0x00000001, 0x00008002, 0x00010022,
  0x3fff0001, 0x00000001, 0x00008003, 0x00015574,
  0x3fff8000, 0x00000001, 0x0000aaac, 0x000199b8,
  0x3fffffff, 0x00000001, 0x0000ccce, 0x0001ff20,
  0x55545556, 0x00000001, 0x0000ff82, 0x0001ff22,
  0x66653334, 0x00000001, 0x0000ff83, 0x0001ff24,
  0x7fbf0080, 0x00000001, 0x0000ff84, 0x0001ff26,
  0x7fbf807f, 0x00000001, 0x0000ff85, 0x00020000,
  0x7fc0007e, 0x00000001, 0x0000fff2, 0x0002001a,
  0x7fc0807d, 0x00000001, 0x0000ffff, 0x0002001c,
  0x7ff70010, 0x00000001, 0x00010000, 0x0002001e,
  0x00000000, 0x0000ffff, 0x00020000, 0x00000020,
  0x00000000, 0x00010000, 0x00000002, 0x00000030,
  0x00000000, 0x00000001, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000006, 0x00000120,
  0x00000000, 0x00000003, 0x00000022, 0x000007f0,
  0x00000000, 0x00000011, 0x000000fc, 0x00000800,
  0x00000000, 0x0000007e, 0x000000fe, 0x00000810,
  0x00000000, 0x0000007f, 0x00000100, 0x00033350,
  0x00000000, 0x00000080, 0x00006668, 0x00055570,
  0x00000000, 0x00003334, 0x0000aaac, 0x0007fff0,
  0x00000000, 0x00005556, 0x0000fffc, 0x00080000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080010,
  0x00000000, 0x00007fff, 0x00010000, 0x00080020,
  0x00000000, 0x00008000, 0x00010002, 0x00080030,
  0x00000000, 0x00008001, 0x00010004, 0x000aaac0,
  0x00000000, 0x00008002, 0x00015556, 0x000ccce0,
  0x00000000, 0x0000aaab, 0x0001999a, 0x000ff820,
  0x00000000, 0x0000cccd, 0x0001ff02, 0x000ff830,
  0x00000000, 0x0000ff81, 0x0001ff04, 0x000ff840,
  0x00000000, 0x0000ff82, 0x0001ff06, 0x000ff850,
  0x00000000, 0x0000ff83, 0x0001ff08, 0x000fff20,
  0x00000000, 0x0000ff84, 0x0001ffe2, 0x000ffff0,
  0x00000000, 0x0000fff1, 0x0001fffc, 0x00100000,
  0x00000000, 0x0000fffe, 0x0001fffe, 0x00100010,
  0x0000fffd, 0x0001fffd, 0x000ffff2, 0x00000020,
  0x0000fffe, 0x0001ffff, 0x00000002, 0x0000009d,
  0x0000ffff, 0x00000001, 0x00000012, 0x0000011a,
  0x00000000, 0x00000003, 0x00000022, 0x000007f0,
  0x00000001, 0x00000005, 0x00000102, 0x00003d29,
  0x00000002, 0x00000021, 0x000007d2, 0x00003da6,
  0x00000010, 0x000000fb, 0x000007e2, 0x00003e23,
  0x0000007d, 0x000000fd, 0x000007f2, 0x00190007,
  0x0000007e, 0x000000ff, 0x00033332, 0x0029aaa1,
  0x0000007f, 0x00006667, 0x00055552, 0x003e7ea9,
  0x00003333, 0x0000aaab, 0x0007ffd2, 0x003e7f26,
  0x00005555, 0x0000fffb, 0x0007ffe2, 0x003e7fa3,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0x003e8020,
  0x00007ffe, 0x0000ffff, 0x00080002, 0x003e809d,
  0x00007fff, 0x00010001, 0x00080012, 0x00535522,
  0x00008000, 0x00010003, 0x000aaaa2, 0x0063ffbc,
  0x00008001, 0x00015555, 0x000cccc2, 0x007cc1a0,
  0x0000aaaa, 0x00019999, 0x000ff802, 0x007cc21d,
  0x0000cccc, 0x0001ff01, 0x000ff812, 0x007cc29a,
  0x0000ff80, 0x0001ff03, 0x000ff822, 0x007cc317,
  0x0000ff81, 0x0001ff05, 0x000ff832, 0x007cf850,
  0x0000ff82, 0x0001ff07, 0x000fff02, 0x007cfea9,
  0x0000ff83, 0x0001ffe1, 0x000fffd2, 0x007cff26,
  0x0000fff0, 0x0001fffb, 0x000fffe2, 0x007cffa3,
  0x0001fffa, 0x000fffe1, 0x007cff85, 0x00000020,
  0x0001fffc, 0x000ffff1, 0x00000002, 0x0000009e,
  0x0001fffe, 0x00000001, 0x0000007f, 0x0000011c,
  0x00000000, 0x00000011, 0x000000fc, 0x00000800,
  0x00000002, 0x00000021, 0x000007d2, 0x00003da6,
  0x00000004, 0x00000101, 0x00003d0b, 0x00003e24,
  0x00000020, 0x000007d1, 0x00003d88, 0x00003ea2,
  0x000000fa, 0x000007e1, 0x00003e05, 0x0019333a,
  0x000000fc, 0x000007f1, 0x0018ffe9, 0x0029fff6,
  0x000000fe, 0x00033331, 0x0029aa83, 0x003efea6,
  0x00006666, 0x00055551, 0x003e7e8b, 0x003eff24,
  0x0000aaaa, 0x0007ffd1, 0x003e7f08, 0x003effa2,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0x003f0020,
  0x0000fffc, 0x0007fff1, 0x003e8002, 0x003f009e,
  0x0000fffe, 0x00080001, 0x003e807f, 0x0053ffcc,
  0x00010000, 0x00080011, 0x00535504, 0x0064cc88,
  0x00010002, 0x000aaaa1, 0x0063ff9e, 0x007dc120,
  0x00015554, 0x000cccc1, 0x007cc182, 0x007dc19e,
  0x00019998, 0x000ff801, 0x007cc1ff, 0x007dc21c,
  0x0001ff00, 0x000ff811, 0x007cc27c, 0x007dc29a,
  0x0001ff02, 0x000ff821, 0x007cc2f9, 0x007df840,
  0x0001ff04, 0x000ff831, 0x007cf832, 0x007dfea6,
  0x0001ff06, 0x000fff01, 0x007cfe8b, 0x007dff24,
  0x0001ffe0, 0x000fffd1, 0x007cff08, 0x007dffa2,
  0x000fffd0, 0x007cff07, 0x007dff84, 0x00000020,
  0x000fffe0, 0x007cff84, 0x00000002, 0x0000009f,
  0x000ffff0, 0x00000001, 0x00000080, 0x0000011e,
  0x00000000, 0x0000007e, 0x000000fe, 0x00000810,
  0x00000010, 0x000000fb, 0x000007e2, 0x00003e23,
  0x00000020, 0x000007d1, 0x00003d88, 0x00003ea2,
  0x00000100, 0x00003d0a, 0x00003e06, 0x00003f21,
  0x000007d0, 0x00003d87, 0x00003e84, 0x0019666d,
  0x000007e0, 0x00003e04, 0x0019331c, 0x002a554b,
  0x000007f0, 0x0018ffe8, 0x0029ffd8, 0x003f7ea3,
  0x00033330, 0x0029aa82, 0x003efe88, 0x003f7f22,
  0x00055550, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0x003f8020,
  0x0007ffe0, 0x003e7f84, 0x003f0002, 0x003f809f,
  0x0007fff0, 0x003e8001, 0x003f0080, 0x0054aa76,
  0x00080000, 0x003e807e, 0x0053ffae, 0x00659954,
  0x00080010, 0x00535503, 0x0064cc6a, 0x007ec0a0,
  0x000aaaa0, 0x0063ff9d, 0x007dc102, 0x007ec11f,
  0x000cccc0, 0x007cc181, 0x007dc180, 0x007ec19e,
  0x000ff800, 0x007cc1fe, 0x007dc1fe, 0x007ec21d,
  0x000ff810, 0x007cc27b, 0x007dc27c, 0x007ef830,
  0x000ff820, 0x007cc2f8, 0x007df822, 0x007efea3,
  0x000ff830, 0x007cf831, 0x007dfe88, 0x007eff22,
  0x000fff00, 0x007cfe8a, 0x007dff06, 0x007effa1,
  0x007cfe89, 0x007dff05, 0x007eff83, 0x00000020,
  0x007cff06, 0x007dff83, 0x00000002, 0x00003353,
  0x007cff83, 0x00000001, 0x00000081, 0x00006686,
  0x00000000, 0x0000007f, 0x00000100, 0x00033350,
  0x0000007d, 0x000000fd, 0x000007f2, 0x00190007,
  0x000000fa, 0x000007e1, 0x00003e05, 0x0019333a,
  0x000007d0, 0x00003d87, 0x00003e84, 0x0019666d,
  0x00003d09, 0x00003e05, 0x00003f03, 0x0a3d5c49,
  0x00003d86, 0x00003e83, 0x0019664f, 0x1110ef0f,
  0x00003e03, 0x0019331b, 0x002a552d, 0x1998e687,
  0x0018ffe7, 0x0029ffd7, 0x003f7e85, 0x199919ba,
  0x0029aa81, 0x003efe87, 0x003f7f04, 0x19994ced,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0x19998020,
  0x003e7f06, 0x003eff83, 0x003f8002, 0x1999b353,
  0x003e7f83, 0x003f0001, 0x003f8081, 0x2221ddfe,
  0x003e8000, 0x003f007f, 0x0054aa58, 0x28f570c4,
  0x003e807d, 0x0053ffad, 0x00659936, 0x331966a0,
  0x00535502, 0x0064cc69, 0x007ec082, 0x331999d3,
  0x0063ff9c, 0x007dc101, 0x007ec101, 0x3319cd06,
  0x007cc180, 0x007dc17f, 0x007ec180, 0x331a0039,
  0x007cc1fd, 0x007dc1fd, 0x007ec1ff, 0x332fccf0,
  0x007cc27a, 0x007dc27b, 0x007ef812, 0x33326687,
  0x007cc2f7, 0x007df821, 0x007efe85, 0x333299ba,
  0x007cf830, 0x007dfe87, 0x007eff04, 0x3332cced,
  0x007dfe86, 0x007eff03, 0x3332cccf, 0x00000020,
  0x007dff04, 0x007eff82, 0x00000002, 0x00005575,
  0x007dff82, 0x00000001, 0x00003335, 0x0000aaca,
  0x00000000, 0x00000080, 0x00006668, 0x00055570,
  0x0000007e, 0x000000ff, 0x00033332, 0x0029aaa1,
  0x000000fc, 0x000007f1, 0x0018ffe9, 0x0029fff6,
  0x000007e0, 0x00003e04, 0x0019331c, 0x002a554b,
  0x00003d86, 0x00003e83, 0x0019664f, 0x1110ef0f,
  0x00003e04, 0x00003f02, 0x0a3d5c2b, 0x1c718e59,
  0x00003e82, 0x0019664e, 0x1110eef1, 0x2aa98021,
  0x0019331a, 0x002a552c, 0x1998e669, 0x2aa9d576,
  0x0029ffd6, 0x003f7e84, 0x1999199c, 0x2aaa2acb,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0x2aaa8020,
  0x003eff04, 0x003f7f82, 0x19998002, 0x2aaad575,
  0x003eff82, 0x003f8001, 0x1999b335, 0x38e31c92,
  0x003f0000, 0x003f8080, 0x2221dde0, 0x4443bbdc,
  0x003f007e, 0x0054aa57, 0x28f570a6, 0x552a55a0,
  0x0053ffac, 0x00659935, 0x33196682, 0x552aaaf5,
  0x0064cc68, 0x007ec081, 0x331999b5, 0x552b004a,
  0x007dc100, 0x007ec100, 0x3319cce8, 0x552b559f,
  0x007dc17e, 0x007ec17f, 0x331a001b, 0x554faad0,
  0x007dc1fc, 0x007ec1fe, 0x332fccd2, 0x55540021,
  0x007dc27a, 0x007ef811, 0x33326669, 0x55545576,
  0x007df820, 0x007efe84, 0x3332999c, 0x5554aacb,
  0x007efe83, 0x3332999b, 0x5554aaad, 0x00000020,
  0x007eff02, 0x3332ccce, 0x00000002, 0x0000801d,
  0x007eff81, 0x00000001, 0x00005557, 0x0001001a,
  0x00000000, 0x00003334, 0x0000aaac, 0x0007fff0,
  0x0000007f, 0x00006667, 0x00055552, 0x003e7ea9,
  0x000000fe, 0x00033331, 0x0029aa83, 0x003efea6,
  0x000007f0, 0x0018ffe8, 0x0029ffd8, 0x003f7ea3,
  0x00003e03, 0x0019331b, 0x002a552d, 0x1998e687,
  0x00003e82, 0x0019664e, 0x1110eef1, 0x2aa98021,
  0x00003f01, 0x0a3d5c2a, 0x1c718e3b, 0x3ffd0029,
  0x0019664d, 0x1110eef0, 0x2aa98003, 0x3ffd8026,
  0x002a552b, 0x1998e668, 0x2aa9d558, 0x3ffe0023,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0x3ffe8020,
  0x003f7f02, 0x19994cce, 0x2aaa8002, 0x3fff001d,
  0x003f7f81, 0x19998001, 0x2aaad557, 0x55530022,
  0x003f8000, 0x1999b334, 0x38e31c74, 0x666399bc,
  0x003f807f, 0x2221dddf, 0x4443bbbe, 0x7fbd01a0,
  0x0054aa56, 0x28f570a5, 0x552a5582, 0x7fbd819d,
  0x00659934, 0x33196681, 0x552aaad7, 0x7fbe019a,
  0x007ec080, 0x331999b4, 0x552b002c, 0x7fbe8197,
  0x007ec0ff, 0x3319cce7, 0x552b5581, 0x7ff50050,
  0x007ec17e, 0x331a001a, 0x554faab2, 0x7ffb8029,
  0x007ec1fd, 0x332fccd1, 0x55540003, 0x7ffc0026,
  0x007ef810, 0x33326668, 0x55545558, 0x7ffc8023,
  0x33326667, 0x55545557, 0x7ffc8005, 0x00000020,
  0x3332999a, 0x5554aaac, 0x00000002, 0x0000801e,
  0x3332cccd, 0x00000001, 0x00007fff, 0x0001001c,
  0x00000000, 0x00005556, 0x0000fffc, 0x00080000,
  0x00003333, 0x0000aaab, 0x0007ffd2, 0x003e7f26,
  0x00006666, 0x00055551, 0x003e7e8b, 0x003eff24,
  0x00033330, 0x0029aa82, 0x003efe88, 0x003f7f22,
  0x0018ffe7, 0x0029ffd7, 0x003f7e85, 0x199919ba,
  0x0019331a, 0x002a552c, 0x1998e669, 0x2aa9d576,
  0x0019664d, 0x1110eef0, 0x2aa98003, 0x3ffd8026,
  0x0a3d5c29, 0x1c718e3a, 0x3ffd000b, 0x3ffe0024,
  0x1110eeef, 0x2aa98002, 0x3ffd8008, 0x3ffe8022,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0x3fff0020,
  0x1999199a, 0x2aaa2aac, 0x3ffe8002, 0x3fff801e,
  0x19994ccd, 0x2aaa8001, 0x3ffeffff, 0x5553aacc,
  0x19998000, 0x2aaad556, 0x55530004, 0x66646688,
  0x1999b333, 0x38e31c73, 0x6663999e, 0x7fbe0120,
  0x2221ddde, 0x4443bbbd, 0x7fbd0182, 0x7fbe811e,
  0x28f570a4, 0x552a5581, 0x7fbd817f, 0x7fbf011c,
  0x33196680, 0x552aaad6, 0x7fbe017c, 0x7fbf811a,
  0x331999b3, 0x552b002b, 0x7fbe8179, 0x7ff60040,
  0x3319cce6, 0x552b5580, 0x7ff50032, 0x7ffc8026,
  0x331a0019, 0x554faab1, 0x7ffb800b, 0x7ffd0024,
  0x332fccd0, 0x55540002, 0x7ffc0008, 0x7ffd8022,
  0x55540001, 0x7ffc0007, 0x7ffd8004, 0x00000020,
  0x55545556, 0x7ffc8004, 0x00000002, 0x0000801f,
  0x5554aaab, 0x00000001, 0x00008000, 0x0001001e,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080010,
  0x00005555, 0x0000fffb, 0x0007ffe2, 0x003e7fa3,
  0x0000aaaa, 0x0007ffd1, 0x003e7f08, 0x003effa2,
  0x00055550, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x0029aa81, 0x003efe87, 0x003f7f04, 0x19994ced,
  0x0029ffd6, 0x003f7e84, 0x1999199c, 0x2aaa2acb,
  0x002a552b, 0x1998e668, 0x2aa9d558, 0x3ffe0023,
  0x1110eeef, 0x2aa98002, 0x3ffd8008, 0x3ffe8022,
  0x1c718e39, 0x3ffd000a, 0x3ffe0006, 0x3fff0021,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0x3fff8020,
  0x2aa9d556, 0x3ffe0004, 0x3fff0002, 0x4000001f,
  0x2aaa2aab, 0x3ffe8001, 0x3fff8000, 0x55545576,
  0x2aaa8000, 0x3ffefffe, 0x5553aaae, 0x66653354,
  0x2aaad555, 0x55530003, 0x6664666a, 0x7fbf00a0,
  0x38e31c72, 0x6663999d, 0x7fbe0102, 0x7fbf809f,
  0x4443bbbc, 0x7fbd0181, 0x7fbe8100, 0x7fc0009e,
  0x552a5580, 0x7fbd817e, 0x7fbf00fe, 0x7fc0809d,
  0x552aaad5, 0x7fbe017b, 0x7fbf80fc, 0x7ff70030,
  0x552b002a, 0x7fbe8178, 0x7ff60022, 0x7ffd8023,
  0x552b557f, 0x7ff50031, 0x7ffc8008, 0x7ffe0022,
  0x554faab0, 0x7ffb800a, 0x7ffd0006, 0x7ffe8021,
  0x7ffb8009, 0x7ffd0005, 0x7ffe8003, 0x00000020,
  0x7ffc0006, 0x7ffd8003, 0x00000002, 0x00008020,
  0x7ffc8003, 0x00000001, 0x00008001, 0x00010020,
  0x00000000, 0x00007fff, 0x00010000, 0x00080020,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0x003e8020,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0x003f0020,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0x003f8020,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0x19998020,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0x2aaa8020,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0x3ffe8020,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0x3fff0020,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0x3fff8020,
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x40000020,
  0x3ffd8006, 0x3ffe8003, 0x3fff8002, 0x40008020,
  0x3ffe0003, 0x3fff0001, 0x40000001, 0x55550020,
  0x3ffe8000, 0x3fff7fff, 0x55545558, 0x66660020,
  0x3ffefffd, 0x5553aaad, 0x66653336, 0x7fc00020,
  0x55530002, 0x66646669, 0x7fbf0082, 0x7fc08020,
  0x6663999c, 0x7fbe0101, 0x7fbf8081, 0x7fc10020,
  0x7fbd0180, 0x7fbe80ff, 0x7fc00080, 0x7fc18020,
  0x7fbd817d, 0x7fbf00fd, 0x7fc0807f, 0x7ff80020,
  0x7fbe017a, 0x7fbf80fb, 0x7ff70012, 0x7ffe8020,
  0x7fbe8177, 0x7ff60021, 0x7ffd8005, 0x7fff0020,
  0x7ff50030, 0x7ffc8007, 0x7ffe0004, 0x7fff8020,
  0x7ffc8006, 0x7ffe0003, 0x7fff8002, 0x00000020,
  0x7ffd0004, 0x7ffe8002, 0x00000002, 0x00008021,
  0x7ffd8002, 0x00000001, 0x00008002, 0x00010022,
  0x00000000, 0x00008000, 0x00010002, 0x00080030,
  0x00007ffe, 0x0000ffff, 0x00080002, 0x003e809d,
  0x0000fffc, 0x0007fff1, 0x003e8002, 0x003f009e,
  0x0007ffe0, 0x003e7f84, 0x003f0002, 0x003f809f,
  0x003e7f06, 0x003eff83, 0x003f8002, 0x1999b353,
  0x003eff04, 0x003f7f82, 0x19998002, 0x2aaad575,
  0x003f7f02, 0x19994cce, 0x2aaa8002, 0x3fff001d,
  0x1999199a, 0x2aaa2aac, 0x3ffe8002, 0x3fff801e,
  0x2aa9d556, 0x3ffe0004, 0x3fff0002, 0x4000001f,
  0x3ffd8006, 0x3ffe8003, 0x3fff8002, 0x40008020,
  0x3ffe0004, 0x3fff0002, 0x40000002, 0x40010021,
  0x3ffe8002, 0x3fff8001, 0x40008002, 0x5555aaca,
  0x3fff0000, 0x40000000, 0x55550002, 0x6666ccec,
  0x3fff7ffe, 0x55545557, 0x66660002, 0x7fc0ffa0,
  0x5553aaac, 0x66653335, 0x7fc00002, 0x7fc17fa1,
  0x66646668, 0x7fbf0081, 0x7fc08002, 0x7fc1ffa2,
  0x7fbe0100, 0x7fbf8080, 0x7fc10002, 0x7fc27fa3,
  0x7fbe80fe, 0x7fc0007f, 0x7fc18002, 0x7ff90010,
  0x7fbf00fc, 0x7fc0807e, 0x7ff80002, 0x7fff801d,
  0x7fbf80fa, 0x7ff70011, 0x7ffe8002, 0x8000001e,
  0x7ff60020, 0x7ffd8004, 0x7fff0002, 0x8000801f,
  0x7ffd8003, 0x7fff0001, 0x80008001, 0x00000020,
  0x7ffe0002, 0x7fff8001, 0x00000002, 0x0000aaca,
  0x7ffe8001, 0x00000001, 0x00008003, 0x00015574,
  0x00000000, 0x00008001, 0x00010004, 0x000aaac0,
  0x00007fff, 0x00010001, 0x00080012, 0x00535522,
  0x0000fffe, 0x00080001, 0x003e807f, 0x0053ffcc,
  0x0007fff0, 0x003e8001, 0x003f0080, 0x0054aa76,
  0x003e7f83, 0x003f0001, 0x003f8081, 0x2221ddfe,
  0x003eff82, 0x003f8001, 0x1999b335, 0x38e31c92,
  0x003f7f81, 0x19998001, 0x2aaad557, 0x55530022,
  0x19994ccd, 0x2aaa8001, 0x3ffeffff, 0x5553aacc,
  0x2aaa2aab, 0x3ffe8001, 0x3fff8000, 0x55545576,
  0x3ffe0003, 0x3fff0001, 0x40000001, 0x55550020,
  0x3ffe8002, 0x3fff8001, 0x40008002, 0x5555aaca,
  0x3fff0001, 0x40000001, 0x40010003, 0x71c63904,
  0x3fff8000, 0x40008001, 0x5555aaac, 0x88877798,
  0x3fffffff, 0x55550001, 0x6666ccce, 0xaa54ab20,
  0x55545556, 0x66660001, 0x7fc0ff82, 0xaa5555ca,
  0x66653334, 0x7fc00001, 0x7fc17f83, 0xaa560074,
  0x7fbf0080, 0x7fc08001, 0x7fc1ff84, 0xaa56ab1e,
  0x7fbf807f, 0x7fc10001, 0x7fc27f85, 0xaa9f5580,
  0x7fc0007e, 0x7fc18001, 0x7ff8fff2, 0xaaa80022,
  0x7fc0807d, 0x7ff80001, 0x7fff7fff, 0xaaa8aacc,
  0x7ff70010, 0x7ffe8001, 0x80000000, 0xaaa95576,
  0x7ffe8000, 0x7fffffff, 0xaaa95558, 0x00000020,
  0x7fff0000, 0x80008000, 0x00000002, 0x0000ccec,
  0x7fff8000, 0x00000001, 0x0000aaac, 0x000199b8,
  0x00000000, 0x00008002, 0x00015556, 0x000ccce0,
  0x00008000, 0x00010003, 0x000aaaa2, 0x0063ffbc,
  0x00010000, 0x00080011, 0x00535504, 0x0064cc88,
  0x00080000, 0x003e807e, 0x0053ffae, 0x00659954,
  0x003e8000, 0x003f007f, 0x0054aa58, 0x28f570c4,
  0x003f0000, 0x003f8080, 0x2221dde0, 0x4443bbdc,
  0x003f8000, 0x1999b334, 0x38e31c74, 0x666399bc,
  0x19998000, 0x2aaad556, 0x55530004, 0x66646688,
  0x2aaa8000, 0x3ffefffe, 0x5553aaae, 0x66653354,
  0x3ffe8000, 0x3fff7fff, 0x55545558, 0x66660020,
  0x3fff0000, 0x40000000, 0x55550002, 0x6666ccec,
  0x3fff8000, 0x40008001, 0x5555aaac, 0x88877798,
  0x40000000, 0x40010002, 0x71c638e6, 0xa3d5c2b0,
  0x40008000, 0x5555aaab, 0x8887777a, 0xcc659a20,
  0x55550000, 0x6666cccd, 0xaa54ab02, 0xcc6666ec,
  0x66660000, 0x7fc0ff81, 0xaa5555ac, 0xcc6733b8,
  0x7fc00000, 0x7fc17f82, 0xaa560056, 0xcc680084,
  0x7fc08000, 0x7fc1ff83, 0xaa56ab00, 0xccbf3360,
  0x7fc10000, 0x7fc27f84, 0xaa9f5562, 0xccc999bc,
  0x7fc18000, 0x7ff8fff1, 0xaaa80004, 0xccca6688,
  0x7ff80000, 0x7fff7ffe, 0xaaa8aaae, 0xcccb3354,
  0x7fff7ffd, 0xaaa8aaad, 0xcccb3336, 0x00000020,
  0x7ffffffe, 0xaaa95557, 0x00000002, 0x0000ffa0,
  0x80007fff, 0x00000001, 0x0000ccce, 0x0001ff20,
  0x00000000, 0x0000aaab, 0x0001999a, 0x000ff820,
  0x00008001, 0x00015555, 0x000cccc2, 0x007cc1a0,
  0x00010002, 0x000aaaa1, 0x0063ff9e, 0x007dc120,
  0x00080010, 0x00535503, 0x0064cc6a, 0x007ec0a0,
  0x003e807d, 0x0053ffad, 0x00659936, 0x331966a0,
  0x003f007e, 0x0054aa57, 0x28f570a6, 0x552a55a0,
  0x003f807f, 0x2221dddf, 0x4443bbbe, 0x7fbd01a0,
  0x1999b333, 0x38e31c73, 0x6663999e, 0x7fbe0120,
  0x2aaad555, 0x55530003, 0x6664666a, 0x7fbf00a0,
  0x3ffefffd, 0x5553aaad, 0x66653336, 0x7fc00020,
  0x3fff7ffe, 0x55545557, 0x66660002, 0x7fc0ffa0,
  0x3fffffff, 0x55550001, 0x6666ccce, 0xaa54ab20,
  0x40008000, 0x5555aaab, 0x8887777a, 0xcc659a20,
  0x40010001, 0x71c638e5, 0xa3d5c292, 0xff004020,
  0x5555aaaa, 0x88877779, 0xcc659a02, 0xff013fa0,
  0x6666cccc, 0xaa54ab01, 0xcc6666ce, 0xff023f20,
  0x7fc0ff80, 0xaa5555ab, 0xcc67339a, 0xff033ea0,
  0x7fc17f81, 0xaa560055, 0xcc680066, 0xff700820,
  0x7fc1ff82, 0xaa56aaff, 0xccbf3342, 0xff7d01a0,
  0x7fc27f83, 0xaa9f5561, 0xccc9999e, 0xff7e0120,
  0x7ff8fff0, 0xaaa80003, 0xccca666a, 0xff7f00a0,
  0xaaa80002, 0xccca6669, 0xff7f0082, 0x00000020,
  0xaaa8aaac, 0xcccb3335, 0x00000002, 0x0000ffa1,
  0xaaa95556, 0x00000001, 0x0000ff82, 0x0001ff22,
  0x00000000, 0x0000cccd, 0x0001ff02, 0x000ff830,
  0x0000aaaa, 0x00019999, 0x000ff802, 0x007cc21d,
  0x00015554, 0x000cccc1, 0x007cc182, 0x007dc19e,
  0x000aaaa0, 0x0063ff9d, 0x007dc102, 0x007ec11f,
  0x00535502, 0x0064cc69, 0x007ec082, 0x331999d3,
  0x0053ffac, 0x00659935, 0x33196682, 0x552aaaf5,
  0x0054aa56, 0x28f570a5, 0x552a5582, 0x7fbd819d,
  0x2221ddde, 0x4443bbbd, 0x7fbd0182, 0x7fbe811e,
  0x38e31c72, 0x6663999d, 0x7fbe0102, 0x7fbf809f,
  0x55530002, 0x66646669, 0x7fbf0082, 0x7fc08020,
  0x5553aaac, 0x66653335, 0x7fc00002, 0x7fc17fa1,
  0x55545556, 0x66660001, 0x7fc0ff82, 0xaa5555ca,
  0x55550000, 0x6666cccd, 0xaa54ab02, 0xcc6666ec,
  0x5555aaaa, 0x88877779, 0xcc659a02, 0xff013fa0,
  0x71c638e4, 0xa3d5c291, 0xff004002, 0xff023f21,
  0x88877778, 0xcc659a01, 0xff013f82, 0xff033ea2,
  0xaa54ab00, 0xcc6666cd, 0xff023f02, 0xff043e23,
  0xaa5555aa, 0xcc673399, 0xff033e82, 0xff710810,
  0xaa560054, 0xcc680065, 0xff700802, 0xff7e019d,
  0xaa56aafe, 0xccbf3341, 0xff7d0182, 0xff7f011e,
  0xaa9f5560, 0xccc9999d, 0xff7e0102, 0xff80009f,
  0xccc9999c, 0xff7e0101, 0xff800081, 0x00000020,
  0xccca6668, 0xff7f0081, 0x00000002, 0x0000ffa2,
  0xcccb3334, 0x00000001, 0x0000ff83, 0x0001ff24,
  0x00000000, 0x0000ff81, 0x0001ff04, 0x000ff840,
  0x0000cccc, 0x0001ff01, 0x000ff812, 0x007cc29a,
  0x00019998, 0x000ff801, 0x007cc1ff, 0x007dc21c,
  0x000cccc0, 0x007cc181, 0x007dc180, 0x007ec19e,
  0x0063ff9c, 0x007dc101, 0x007ec101, 0x3319cd06,
  0x0064cc68, 0x007ec081, 0x331999b5, 0x552b004a,
  0x00659934, 0x33196681, 0x552aaad7, 0x7fbe019a,
  0x28f570a4, 0x552a5581, 0x7fbd817f, 0x7fbf011c,
  0x4443bbbc, 0x7fbd0181, 0x7fbe8100, 0x7fc0009e,
  0x6663999c, 0x7fbe0101, 0x7fbf8081, 0x7fc10020,
  0x66646668, 0x7fbf0081, 0x7fc08002, 0x7fc1ffa2,
  0x66653334, 0x7fc00001, 0x7fc17f83, 0xaa560074,
  0x66660000, 0x7fc0ff81, 0xaa5555ac, 0xcc6733b8,
  0x6666cccc, 0xaa54ab01, 0xcc6666ce, 0xff023f20,
  0x88877778, 0xcc659a01, 0xff013f82, 0xff033ea2,
  0xa3d5c290, 0xff004001, 0xff023f03, 0xff043e24,
  0xcc659a00, 0xff013f81, 0xff033e84, 0xff053da6,
  0xcc6666cc, 0xff023f01, 0xff043e05, 0xff720800,
  0xcc673398, 0xff033e81, 0xff7107f2, 0xff7f019a,
  0xcc680064, 0xff700801, 0xff7e017f, 0xff80011c,
  0xccbf3340, 0xff7d0181, 0xff7f0100, 0xff81009e,
  0xff7d0180, 0xff7f00ff, 0xff810080, 0x00000020,
  0xff7e0100, 0xff800080, 0x00000002, 0x0000ffa3,
  0xff7f0080, 0x00000001, 0x0000ff84, 0x0001ff26,
  0x00000000, 0x0000ff82, 0x0001ff06, 0x000ff850,
  0x0000ff80, 0x0001ff03, 0x000ff822, 0x007cc317,
  0x0001ff00, 0x000ff811, 0x007cc27c, 0x007dc29a,
  0x000ff800, 0x007cc1fe, 0x007dc1fe, 0x007ec21d,
  0x007cc180, 0x007dc17f, 0x007ec180, 0x331a0039,
  0x007dc100, 0x007ec100, 0x3319cce8, 0x552b559f,
  0x007ec080, 0x331999b4, 0x552b002c, 0x7fbe8197,
  0x33196680, 0x552aaad6, 0x7fbe017c, 0x7fbf811a,
  0x552a5580, 0x7fbd817e, 0x7fbf00fe, 0x7fc0809d,
  0x7fbd0180, 0x7fbe80ff, 0x7fc00080, 0x7fc18020,
  0x7fbe0100, 0x7fbf8080, 0x7fc10002, 0x7fc27fa3,
  0x7fbf0080, 0x7fc08001, 0x7fc1ff84, 0xaa56ab1e,
  0x7fc00000, 0x7fc17f82, 0xaa560056, 0xcc680084,
  0x7fc0ff80, 0xaa5555ab, 0xcc67339a, 0xff033ea0,
  0xaa54ab00, 0xcc6666cd, 0xff023f02, 0xff043e23,
  0xcc659a00, 0xff013f81, 0xff033e84, 0xff053da6,
  0xff004000, 0xff023f02, 0xff043e06, 0xff063d29,
  0xff013f80, 0xff033e83, 0xff053d88, 0xff7307f0,
  0xff023f00, 0xff043e04, 0xff7207e2, 0xff800197,
  0xff033e80, 0xff7107f1, 0xff7f017c, 0xff81011a,
  0xff700800, 0xff7e017e, 0xff8000fe, 0xff82009d,
  0xff7e017d, 0xff8000fd, 0xff82007f, 0x00000020,
  0xff7f00fe, 0xff81007f, 0x00000002, 0x00010010,
  0xff80007f, 0x00000001, 0x0000ff85, 0x00020000,
  0x00000000, 0x0000ff83, 0x0001ff08, 0x000fff20,
  0x0000ff81, 0x0001ff05, 0x000ff832, 0x007cf850,
  0x0001ff02, 0x000ff821, 0x007cc2f9, 0x007df840,
  0x000ff810, 0x007cc27b, 0x007dc27c, 0x007ef830,
  0x007cc1fd, 0x007dc1fd, 0x007ec1ff, 0x332fccf0,
  0x007dc17e, 0x007ec17f, 0x331a001b, 0x554faad0,
  0x007ec0ff, 0x3319cce7, 0x552b5581, 0x7ff50050,
  0x331999b3, 0x552b002b, 0x7fbe8179, 0x7ff60040,
  0x552aaad5, 0x7fbe017b, 0x7fbf80fc, 0x7ff70030,
  0x7fbd817d, 0x7fbf00fd, 0x7fc0807f, 0x7ff80020,
  0x7fbe80fe, 0x7fc0007f, 0x7fc18002, 0x7ff90010,
  0x7fbf807f, 0x7fc10001, 0x7fc27f85, 0xaa9f5580,
  0x7fc08000, 0x7fc1ff83, 0xaa56ab00, 0xccbf3360,
  0x7fc17f81, 0xaa560055, 0xcc680066, 0xff700820,
  0xaa5555aa, 0xcc673399, 0xff033e82, 0xff710810,
  0xcc6666cc, 0xff023f01, 0xff043e05, 0xff720800,
  0xff013f80, 0xff033e83, 0xff053d88, 0xff7307f0,
  0xff023f01, 0xff043e05, 0xff063d0b, 0xffe00120,
  0xff033e82, 0xff053d87, 0xff7307d2, 0xffed0050,
  0xff043e03, 0xff7207e1, 0xff800179, 0xffee0040,
  0xff7107f0, 0xff7f017b, 0xff8100fc, 0xffef0030,
  0xff7f017a, 0xff8100fb, 0xffef0012, 0x00000020,
  0xff8000fc, 0xff82007e, 0x00000002, 0x0001001d,
  0xff81007e, 0x00000001, 0x0000fff2, 0x0002001a,
  0x00000000, 0x0000ff84, 0x0001ffe2, 0x000ffff0,
  0x0000ff82, 0x0001ff07, 0x000fff02, 0x007cfea9,
  0x0001ff04, 0x000ff831, 0x007cf832, 0x007dfea6,
  0x000ff820, 0x007cc2f8, 0x007df822, 0x007efea3,
  0x007cc27a, 0x007dc27b, 0x007ef812, 0x33326687,
  0x007dc1fc, 0x007ec1fe, 0x332fccd2, 0x55540021,
  0x007ec17e, 0x331a001a, 0x554faab2, 0x7ffb8029,
  0x3319cce6, 0x552b5580, 0x7ff50032, 0x7ffc8026,
  0x552b002a, 0x7fbe8178, 0x7ff60022, 0x7ffd8023,
  0x7fbe017a, 0x7fbf80fb, 0x7ff70012, 0x7ffe8020,
  0x7fbf00fc, 0x7fc0807e, 0x7ff80002, 0x7fff801d,
  0x7fc0007e, 0x7fc18001, 0x7ff8fff2, 0xaaa80022,
  0x7fc10000, 0x7fc27f84, 0xaa9f5562, 0xccc999bc,
  0x7fc1ff82, 0xaa56aaff, 0xccbf3342, 0xff7d01a0,
  0xaa560054, 0xcc680065, 0xff700802, 0xff7e019d,
  0xcc673398, 0xff033e81, 0xff7107f2, 0xff7f019a,
  0xff023f00, 0xff043e04, 0xff7207e2, 0xff800197,
  0xff033e82, 0xff053d87, 0xff7307d2, 0xffed0050,
  0xff043e04, 0xff063d0a, 0xffe00102, 0xfffa0029,
  0xff053d86, 0xff7307d1, 0xffed0032, 0xfffb0026,
  0xff7207e0, 0xff800178, 0xffee0022, 0xfffc0023,
  0xff800177, 0xffee0021, 0xfffc0005, 0x00000020,
  0xff8100fa, 0xffef0011, 0x00000002, 0x0001001e,
  0xff82007d, 0x00000001, 0x0000ffff, 0x0002001c,
  0x00000000, 0x0000fff1, 0x0001fffc, 0x00100000,
  0x0000ff83, 0x0001ffe1, 0x000fffd2, 0x007cff26,
  0x0001ff06, 0x000fff01, 0x007cfe8b, 0x007dff24,
  0x000ff830, 0x007cf831, 0x007dfe88, 0x007eff22,
  0x007cc2f7, 0x007df821, 0x007efe85, 0x333299ba,
  0x007dc27a, 0x007ef811, 0x33326669, 0x55545576,
  0x007ec1fd, 0x332fccd1, 0x55540003, 0x7ffc0026,
  0x331a0019, 0x554faab1, 0x7ffb800b, 0x7ffd0024,
  0x552b557f, 0x7ff50031, 0x7ffc8008, 0x7ffe0022,
  0x7fbe8177, 0x7ff60021, 0x7ffd8005, 0x7fff0020,
  0x7fbf80fa, 0x7ff70011, 0x7ffe8002, 0x8000001e,
  0x7fc0807d, 0x7ff80001, 0x7fff7fff, 0xaaa8aacc,
  0x7fc18000, 0x7ff8fff1, 0xaaa80004, 0xccca6688,
  0x7fc27f83, 0xaa9f5561, 0xccc9999e, 0xff7e0120,
  0xaa56aafe, 0xccbf3341, 0xff7d0182, 0xff7f011e,
  0xcc680064, 0xff700801, 0xff7e017f, 0xff80011c,
  0xff033e80, 0xff7107f1, 0xff7f017c, 0xff81011a,
  0xff043e03, 0xff7207e1, 0xff800179, 0xffee0040,
  0xff053d86, 0xff7307d1, 0xffed0032, 0xfffb0026,
  0xff063d09, 0xffe00101, 0xfffa000b, 0xfffc0024,
  0xff7307d0, 0xffed0031, 0xfffb0008, 0xfffd0022,
  0xffed0030, 0xfffb0007, 0xfffd0004, 0x00000020,
  0xffee0020, 0xfffc0004, 0x00000002, 0x0001001f,
  0xffef0010, 0x00000001, 0x00010000, 0x0002001e,
  0x00000000, 0x0000fffe, 0x0001fffe, 0x00100010,
  0x0000fff0, 0x0001fffb, 0x000fffe2, 0x007cffa3,
  0x0001ffe0, 0x000fffd1, 0x007cff08, 0x007dffa2,
  0x000fff00, 0x007cfe8a, 0x007dff06, 0x007effa1,
  0x007cf830, 0x007dfe87, 0x007eff04, 0x3332cced,
  0x007df820, 0x007efe84, 0x3332999c, 0x5554aacb,
  0x007ef810, 0x33326668, 0x55545558, 0x7ffc8023,
  0x332fccd0, 0x55540002, 0x7ffc0008, 0x7ffd8022,
  0x554faab0, 0x7ffb800a, 0x7ffd0006, 0x7ffe8021,
  0x7ff50030, 0x7ffc8007, 0x7ffe0004, 0x7fff8020,
  0x7ff60020, 0x7ffd8004, 0x7fff0002, 0x8000801f,
  0x7ff70010, 0x7ffe8001, 0x80000000, 0xaaa95576,
  0x7ff80000, 0x7fff7ffe, 0xaaa8aaae, 0xcccb3354,
  0x7ff8fff0, 0xaaa80003, 0xccca666a, 0xff7f00a0,
  0xaa9f5560, 0xccc9999d, 0xff7e0102, 0xff80009f,
  0xccbf3340, 0xff7d0181, 0xff7f0100, 0xff81009e,
  0xff700800, 0xff7e017e, 0xff8000fe, 0xff82009d,
  0xff7107f0, 0xff7f017b, 0xff8100fc, 0xffef0030,
  0xff7207e0, 0xff800178, 0xffee0022, 0xfffc0023,
  0xff7307d0, 0xffed0031, 0xfffb0008, 0xfffd0022,
  0xffe00100, 0xfffa000a, 0xfffc0006, 0xfffe0021,
};
const unsigned kExpectedCount_NEON_umlal2_4S = 576;

#endif  // VIXL_SIM_UMLAL2_4S_TRACE_AARCH64_H_
