/*
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "voms_apic.h"
#include <stdio.h>

int main(int argc, char *argv[]) 
{
  struct vomsdata *vd = VOMS_Init(NULL, NULL);
  int error = 0;
  int i = 0;

  if (vd) {
    if (argc !=2) {
      fprintf(stderr, "File argument missing.\n");
      exit(1);
    }

    FILE *f = fopen(argv[1], "rb");
    if (f) {
      if (!VOMS_RetrieveFromFile(f,RECURSE_CHAIN, vd, &error)) {
        fclose(f);
        fprintf(stderr, "Error is: %s\n", VOMS_ErrorMessage(vd, error, NULL, 0));
        exit(1);
      }
      fclose(f);
      exit(0);
    }
  }
  exit(1);
}

