/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.nodes.VRMLBindableNodeListener;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.xj3d.core.eventmodel.BindableNodeListener;

public class BindableNodeManager
implements VRMLBindableNodeListener {
    private SimpleStack nodeStack = new SimpleStack();
    private BindableNodeListener listener;
    private VRMLClock clock;
    private HashSet nodeSet = new HashSet();
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private VRMLBindableNodeType firstNode;

    public void nodeIsBound(VRMLNodeType vRMLNodeType, boolean bl) {
        if (bl) {
            if (this.nodeStack.contains(vRMLNodeType)) {
                this.nodeStack.remove(vRMLNodeType);
            }
            VRMLNodeType vRMLNodeType2 = null;
            if (this.nodeStack.size() != 0) {
                vRMLNodeType2 = (VRMLNodeType)this.nodeStack.peek();
            }
            this.nodeStack.push(vRMLNodeType);
            if (vRMLNodeType instanceof VRMLBindableNodeType) {
                VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType;
                vRMLBindableNodeType.setOnStack(true);
                if (vRMLNodeType2 != null && vRMLNodeType2 != vRMLNodeType) {
                    VRMLBindableNodeType vRMLBindableNodeType2 = (VRMLBindableNodeType)vRMLNodeType2;
                    vRMLBindableNodeType2.setBind(false, false, 0.0);
                }
            }
            if (this.listener != null) {
                try {
                    this.listener.newNodeBound((VRMLBindableNodeType)vRMLNodeType);
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport("Error sending bind update ", exception);
                }
            }
        } else {
            VRMLNodeType vRMLNodeType3 = (VRMLNodeType)this.nodeStack.peek();
            if (vRMLNodeType3 != vRMLNodeType) {
                this.nodeStack.remove(vRMLNodeType);
                if (vRMLNodeType instanceof VRMLBindableNodeType) {
                    VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType3;
                    vRMLBindableNodeType.setOnStack(false);
                }
            } else {
                this.nodeStack.pop();
                vRMLNodeType3 = (VRMLNodeType)this.nodeStack.peek();
                if (vRMLNodeType3 instanceof VRMLBindableNodeType) {
                    VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType3;
                    vRMLBindableNodeType.setOnStack(false);
                }
                if (this.listener != null) {
                    try {
                        this.listener.newNodeBound((VRMLBindableNodeType)vRMLNodeType3);
                    }
                    catch (Exception exception) {
                        this.errorReporter.errorReport("Error sending bind update ", exception);
                    }
                }
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
    }

    public VRMLBindableNodeType getBoundNode() {
        if (this.nodeStack.isEmpty()) {
            return null;
        }
        return (VRMLBindableNodeType)this.nodeStack.peek();
    }

    public VRMLBindableNodeType getFirstNode() {
        return this.firstNode;
    }

    public boolean contains(VRMLBindableNodeType vRMLBindableNodeType) {
        return this.nodeSet.contains(vRMLBindableNodeType);
    }

    public void addNode(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        vRMLBindableNodeType.addBindableNodeListener(this);
        this.nodeSet.add(vRMLBindableNodeType);
        if (vRMLBindableNodeType instanceof VRMLTimeDependentNodeType) {
            ((VRMLTimeDependentNodeType)((Object)vRMLBindableNodeType)).setVRMLClock(this.clock);
        }
        if (this.firstNode == null) {
            this.firstNode = vRMLBindableNodeType;
        }
        if (this.listener != null) {
            try {
                this.listener.bindableAdded(vRMLBindableNodeType, bl);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error sending bindableAdded update ", exception);
            }
        }
    }

    public void removeNode(VRMLBindableNodeType vRMLBindableNodeType) {
        vRMLBindableNodeType.removeBindableNodeListener(this);
        this.nodeSet.remove(vRMLBindableNodeType);
        if (vRMLBindableNodeType instanceof VRMLTimeDependentNodeType) {
            ((VRMLTimeDependentNodeType)((Object)vRMLBindableNodeType)).setVRMLClock(null);
        }
        if (this.listener != null) {
            try {
                this.listener.bindableRemoved(vRMLBindableNodeType);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error sending bindableRemoved update ", exception);
            }
        }
    }

    public void clearAll() {
        Object[] objectArray = this.nodeSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)objectArray[i];
            vRMLBindableNodeType.removeBindableNodeListener(this);
        }
        this.nodeSet.clear();
        this.nodeStack.clear();
        this.firstNode = null;
    }

    public void setNodeChangeListener(BindableNodeListener bindableNodeListener) {
        this.listener = bindableNodeListener;
    }
}

