/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class CylinderGenerator
extends GeometryGenerator {
    private static final float DEFAULT_HEIGHT = 2.0f;
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private float cylinderHeight;
    private float radius;
    private boolean useTop;
    private boolean useSide;
    private boolean useBottom;
    private int facetCount;
    private float[] baseCoordinates;
    private int numBaseValues;
    private float[] texCoordinates2D;
    private int numTexCoords2D;
    private float[] texCoordinates3D;
    private int numTexCoords3D;
    private boolean baseChanged;
    private boolean facetsChanged;
    private Vector3f normal;

    public CylinderGenerator() {
        this(2.0f, 1.0f, 16, true, true, true);
    }

    public CylinderGenerator(boolean bl) {
        this(2.0f, 1.0f, 16, bl, bl, true);
    }

    public CylinderGenerator(int n) {
        this(2.0f, 1.0f, n, true, true, true);
    }

    public CylinderGenerator(int n, boolean bl) {
        this(2.0f, 1.0f, n, bl, bl, true);
    }

    public CylinderGenerator(float f, float f2) {
        this(f, f2, 16, true, true, true);
    }

    public CylinderGenerator(float f, float f2, int n) {
        this(f, f2, n, true, true, true);
    }

    public CylinderGenerator(float f, float f2, boolean bl, boolean bl2) {
        this(f, f2, 16, bl, bl, bl2);
    }

    public CylinderGenerator(float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        this(f, f2, 16, bl, bl2, bl3);
    }

    public CylinderGenerator(float f, float f2, int n, boolean bl, boolean bl2) {
        this(f, f2, n, true, true, bl2);
    }

    public CylinderGenerator(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.facetCount = n;
        this.cylinderHeight = f;
        this.radius = f2;
        this.useTop = bl;
        this.useBottom = bl2;
        this.useSide = bl3;
        this.baseChanged = true;
        this.facetsChanged = true;
        this.normal = new Vector3f();
    }

    public boolean hasEnds() {
        return this.useTop && this.useBottom;
    }

    public float[] getDimensions() {
        return new float[]{this.cylinderHeight, this.radius};
    }

    public void setDimensions(float f, float f2, boolean bl, boolean bl2) {
        if (this.cylinderHeight != f || this.radius != f2) {
            this.baseChanged = true;
            this.cylinderHeight = f;
            this.radius = f2;
        }
        if (bl != this.useTop != this.useBottom) {
            this.facetsChanged = true;
        }
        if (bl2 != this.useSide) {
            this.facetsChanged = true;
        }
        this.useTop = bl;
        this.useBottom = bl;
        this.useSide = bl2;
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.facetCount = n;
        this.baseChanged = true;
        this.facetsChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                if (this.useSide) {
                    n = this.facetCount * 6;
                }
                if (this.useTop) {
                    n += this.facetCount * 3;
                }
                if (!this.useBottom) break;
                n += this.facetCount * 3;
                break;
            }
            case 2: {
                if (this.useSide) {
                    n = this.facetCount * 4;
                }
                if (this.useTop) {
                    n += this.facetCount * 4;
                }
                if (!this.useBottom) break;
                n += this.facetCount * 4;
                break;
            }
            case 3: {
                if (this.useSide) {
                    n = (this.facetCount + 1) * 2;
                }
                if (this.useTop) {
                    n += (this.facetCount + 1) * 2;
                }
                if (!this.useBottom) break;
                n += (this.facetCount + 1) * 2;
                break;
            }
            case 4: {
                if (this.useSide) {
                    n = this.facetCount * 4;
                }
                if (this.useTop) {
                    n += this.facetCount + 2;
                }
                if (this.useBottom) {
                    n += this.facetCount + 2;
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.useSide) {
                    n = this.facetCount * 2;
                }
                if (this.useTop) {
                    n += 1 + this.facetCount;
                }
                if (!this.useBottom) break;
                n += 1 + this.facetCount;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 4: {
                this.triangleFans(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = geometryData.vertexCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n3);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n3;
        int n4 = 0;
        int n5 = 0;
        if (this.useSide) {
            n2 = this.facetCount;
            while (--n2 > 0) {
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5 + 3;
                nArray[n4++] = n5 + 2;
                n5 += 2;
            }
            nArray[n4++] = n5++;
            nArray[n4++] = n5++;
            nArray[n4++] = 0;
            nArray[n4++] = 1;
        }
        if (this.useTop) {
            n2 = n5++;
            n = this.facetCount;
            while (--n > 0) {
                nArray[n4++] = n2;
                nArray[n4++] = n5++;
                nArray[n4++] = n5;
                nArray[n4++] = n2;
            }
            nArray[n4++] = n2;
            nArray[n4++] = n5++;
            nArray[n4++] = n2 + 1;
            nArray[n4++] = n2;
        }
        if (this.useBottom) {
            n2 = n5++;
            n = this.facetCount;
            while (--n > 0) {
                nArray[n4++] = n2;
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5++;
                nArray[n4++] = n2;
            }
            nArray[n4++] = n2;
            nArray[n4++] = n2 + 1;
            nArray[n4++] = n5;
            nArray[n4++] = n2;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = geometryData.vertexCount * 3;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n3);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n3;
        int n4 = 0;
        int n5 = 0;
        if (this.useSide) {
            n2 = this.facetCount;
            while (--n2 > 0) {
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5 + 3;
                nArray[n4++] = n5 + 3;
                nArray[n4++] = n5 + 2;
                nArray[n4++] = n5;
                n5 += 2;
            }
            nArray[n4++] = n5;
            nArray[n4++] = n5 + 1;
            nArray[n4++] = 1;
            nArray[n4++] = 1;
            nArray[n4++] = 0;
            nArray[n4++] = n5;
            n5 += 2;
        }
        if (this.useTop) {
            n2 = n5++;
            n = this.facetCount;
            while (--n > 0) {
                nArray[n4++] = n2;
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5++;
            }
            nArray[n4++] = n2;
            nArray[n4++] = n2 + 1;
            nArray[n4++] = n5;
        }
        if (this.useBottom) {
            n2 = n5++;
            n = this.facetCount;
            while (--n > 0) {
                nArray[n4++] = n2;
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5++;
            }
            nArray[n4++] = n2;
            nArray[n4++] = n2 + 1;
            nArray[n4++] = n5;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = 0;
        if (this.useSide) {
            ++n;
        }
        if (this.useTop) {
            ++n;
        }
        if (this.useBottom) {
            ++n;
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = 0;
        int n3 = (1 + this.facetCount) * 2;
        geometryData.numStrips = n;
        if (this.useSide) {
            geometryData.stripCounts[n2++] = n3;
        }
        if (this.useTop) {
            geometryData.stripCounts[n2++] = n3;
        }
        if (this.useBottom) {
            geometryData.stripCounts[n2++] = n3;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriFanCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriFanNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount + 2;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = 4;
        }
        geometryData.stripCounts[n - 2] = this.facetCount + 2;
        geometryData.stripCounts[n - 1] = this.facetCount + 2;
        geometryData.numStrips = n;
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            n3 = (this.facetCount + 1) * 2;
            n4 = 1;
        }
        if (this.useTop) {
            n3 += (this.facetCount + 1) * 2;
            ++n4;
        }
        if (this.useBottom) {
            n3 += (this.facetCount + 1) * 2;
            ++n4;
        }
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n3);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n4];
        } else if (geometryData.stripCounts.length < n4) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n4);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n3;
        geometryData.numStrips = n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.useSide) {
            nArray2[n7++] = (this.facetCount + 1) * 2;
            n2 = this.facetCount;
            while (--n2 >= 0) {
                nArray[n5++] = n6++;
                nArray[n5++] = n6++;
            }
            nArray[n5++] = 0;
            nArray[n5++] = this.facetCount;
        }
        if (this.useTop) {
            nArray2[n7++] = (this.facetCount + 1) * 2;
            n2 = n6++;
            n = this.facetCount;
            while (--n >= 0) {
                nArray[n5++] = n2;
                nArray[n5++] = n6++;
            }
            nArray[n5++] = n2 + 1;
            nArray[n5++] = n2;
        }
        if (this.useBottom) {
            nArray2[n7] = (this.facetCount + 1) * 2;
            n2 = n6++;
            n = this.facetCount;
            while (--n >= 0) {
                nArray[n5++] = n6++;
                nArray[n5++] = n2;
            }
            nArray[n5++] = n2 + 1;
            nArray[n5++] = n2;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            n3 = this.facetCount * 4;
            n4 = this.facetCount;
        }
        if (this.useTop) {
            n3 += 2 * (this.facetCount + 2);
            ++n4;
        }
        if (this.useBottom) {
            n3 += 2 * (this.facetCount + 2);
            ++n4;
        }
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n3);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n4];
        } else if (geometryData.stripCounts.length < n4) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n4);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n3;
        geometryData.numStrips = n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.useSide) {
            n2 = this.facetCount;
            while (--n2 > 0) {
                nArray[n5++] = n6;
                nArray[n5++] = n6 + 1;
                nArray[n5++] = n6 + 3;
                nArray[n5++] = n6 + 2;
                nArray2[n2] = 4;
                n6 += 2;
            }
            nArray[n5++] = n6;
            nArray[n5++] = n6 + 1;
            nArray[n5++] = 1;
            nArray[n5++] = 0;
            n6 += 2;
            nArray2[n7++] = 4;
        }
        if (this.useTop) {
            n2 = n6++;
            nArray[n5++] = n2;
            nArray2[n7++] = this.facetCount + 2;
            n = this.facetCount;
            while (--n >= 0) {
                nArray[n5++] = n6++;
            }
            nArray[n5++] = n2 + 1;
        }
        if (this.useBottom) {
            n2 = n6++;
            nArray[n5++] = n2;
            nArray2[n7++] = this.facetCount + 2;
            n6 = geometryData.vertexCount - 1;
            n = this.facetCount;
            while (--n >= 0) {
                nArray[n5++] = n6--;
            }
            nArray[n5++] = geometryData.vertexCount - 1;
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = 0;
        if (this.useSide) {
            n = this.facetCount * 6;
        }
        if (this.useTop) {
            n += this.facetCount * 3;
        }
        if (this.useBottom) {
            n += this.facetCount * 3;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        if (this.useSide) {
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
        }
        if (this.useTop) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
        }
        if (this.useBottom) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = 0;
        if (this.useSide) {
            n2 = (this.facetCount + 1) * 2;
        }
        if (this.useTop) {
            n2 += (this.facetCount + 1) * 2;
        }
        if (this.useBottom) {
            n2 += (this.facetCount + 1) * 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        float f = this.cylinderHeight / 2.0f;
        this.regenerateBase();
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = this.baseCoordinates[n4];
                fArray[n3++] = f;
                fArray[n3++] = this.baseCoordinates[n4 + 1];
                fArray[n3++] = this.baseCoordinates[n4];
                fArray[n3++] = -f;
                fArray[n3++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n3++] = this.baseCoordinates[0];
            fArray[n3++] = f;
            fArray[n3++] = this.baseCoordinates[1];
            fArray[n3++] = this.baseCoordinates[0];
            fArray[n3++] = -f;
            fArray[n3++] = this.baseCoordinates[1];
        }
        if (this.useTop) {
            n4 = 0;
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = this.baseCoordinates[n4++];
                fArray[n3++] = f;
                fArray[n3++] = this.baseCoordinates[n4++];
            }
            fArray[n3++] = 0.0f;
            fArray[n3++] = f;
            fArray[n3++] = 0.0f;
            fArray[n3++] = this.baseCoordinates[0];
            fArray[n3++] = f;
            fArray[n3++] = this.baseCoordinates[1];
        }
        if (this.useBottom) {
            n4 = 0;
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = this.baseCoordinates[n4++];
                fArray[n3++] = -f;
                fArray[n3++] = this.baseCoordinates[n4++];
                fArray[n3++] = 0.0f;
                fArray[n3++] = -f;
                fArray[n3++] = 0.0f;
            }
            fArray[n3++] = this.baseCoordinates[0];
            fArray[n3++] = -f;
            fArray[n3++] = this.baseCoordinates[1];
            fArray[n3++] = 0.0f;
            fArray[n3++] = -f;
            fArray[n3++] = 0.0f;
        }
    }

    private void generateUnindexedTriFanCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = 0;
        if (this.useSide) {
            n = this.facetCount * 4;
        }
        if (this.useTop) {
            n += this.facetCount + 2;
        }
        if (this.useBottom) {
            n += this.facetCount + 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        if (this.useSide) {
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
        }
        if (this.useTop) {
            n4 = 0;
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
        }
        if (this.useBottom) {
            n4 = this.numBaseValues - 1;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4 - 1];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4];
                n4 -= 2;
            }
            fArray[n2++] = this.baseCoordinates[this.numBaseValues - 2];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[this.numBaseValues - 1];
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = 0;
        if (this.useSide) {
            n = this.facetCount * 4;
        }
        if (this.useTop) {
            n += this.facetCount * 4;
        }
        if (this.useBottom) {
            n += this.facetCount * 4;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        if (this.useSide) {
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
        }
        if (this.useTop) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
        }
        if (this.useBottom) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = 0;
        if (this.useSide) {
            n = this.facetCount * 2;
        }
        if (this.useTop) {
            n += 1 + this.facetCount;
        }
        if (this.useBottom) {
            n += 1 + this.facetCount;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        if (this.useSide) {
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
        }
        if (this.useTop) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
        }
        if (this.useBottom) {
            n4 = 0;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
        }
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            this.createRadialFlatNormal(n4++);
            n = this.facetCount;
            while (--n > 0) {
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3 + 9] = this.normal.x;
                fArray[n3 + 10] = this.normal.y;
                fArray[n3 + 11] = this.normal.z;
                fArray[n3 + 12] = this.normal.x;
                fArray[n3 + 13] = this.normal.y;
                fArray[n3 + 14] = this.normal.z;
                this.createRadialFlatNormal(n4++);
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                n3 += 6;
            }
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3 + 9] = this.normal.x;
            fArray[n3 + 10] = this.normal.y;
            fArray[n3 + 11] = this.normal.z;
            fArray[n3 + 12] = this.normal.x;
            fArray[n3 + 13] = this.normal.y;
            fArray[n3 + 14] = this.normal.z;
            this.createRadialFlatNormal(0);
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            n3 += 6;
        }
        if (this.useTop) {
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
            }
        }
        if (this.useBottom) {
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
            }
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            n = this.facetCount;
            while (--n >= 0) {
                this.createRadialFlatNormal(n4++);
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
            }
            fArray[n3++] = fArray[0];
            fArray[n3++] = fArray[1];
            fArray[n3++] = fArray[2];
            fArray[n3++] = fArray[3];
            fArray[n3++] = fArray[4];
            fArray[n3++] = fArray[5];
        }
        if (this.useTop) {
            n = this.facetCount + 1;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
            }
        }
        if (this.useBottom) {
            n = this.facetCount + 1;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
            }
        }
    }

    private void generateUnindexedTriFanNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            this.createRadialFlatNormal(n4++);
            n = this.facetCount;
            while (--n > 0) {
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                this.createRadialFlatNormal(n4++);
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
            }
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3++] = fArray[0];
            fArray[n3++] = fArray[1];
            fArray[n3++] = fArray[2];
            fArray[n3++] = fArray[3];
            fArray[n3++] = fArray[4];
            fArray[n3++] = fArray[5];
        }
        if (this.useTop) {
            n = this.facetCount + 2;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
            }
        }
        if (this.useBottom) {
            n = this.facetCount + 2;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
            }
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            this.createRadialFlatNormal(n4++);
            n = this.facetCount;
            while (--n > 0) {
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3 + 6] = this.normal.x;
                fArray[n3 + 7] = this.normal.y;
                fArray[n3 + 8] = this.normal.z;
                this.createRadialFlatNormal(n4++);
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                n3 += 3;
            }
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3 + 6] = this.normal.x;
            fArray[n3 + 7] = this.normal.y;
            fArray[n3 + 8] = this.normal.z;
            this.createRadialFlatNormal(0);
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            fArray[n3++] = this.normal.x;
            fArray[n3++] = this.normal.y;
            fArray[n3++] = this.normal.z;
            n3 += 3;
        }
        if (this.useTop) {
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
            }
        }
        if (this.useBottom) {
            n = this.facetCount;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
            }
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        if (this.useSide) {
            n = this.facetCount;
            while (--n >= 0) {
                this.createRadialFlatNormal(n4++);
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
                fArray[n3++] = this.normal.x;
                fArray[n3++] = this.normal.y;
                fArray[n3++] = this.normal.z;
            }
        }
        if (this.useTop) {
            n = this.facetCount + 1;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = 1.0f;
                fArray[n3++] = 0.0f;
            }
        }
        if (this.useBottom) {
            n = this.facetCount + 1;
            while (--n >= 0) {
                fArray[n3++] = 0.0f;
                fArray[n3++] = -1.0f;
                fArray[n3++] = 0.0f;
            }
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.recalc2DTexture();
        System.arraycopy(this.texCoordinates2D, 0, geometryData.textureCoordinates, 0, n);
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateBase() {
        if (!this.baseChanged) {
            return;
        }
        this.baseChanged = false;
        if (this.baseCoordinates == null || this.facetCount * 2 > this.baseCoordinates.length) {
            this.baseCoordinates = new float[this.facetCount * 2];
        }
        this.numBaseValues = this.facetCount * 2;
        double d = Math.PI * 2 / (double)this.facetCount;
        int n = 0;
        double d2 = 1.5707963267948966 - Math.PI / (double)(this.facetCount / 2);
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            double d3 = d * (double)n2;
            float f = (float)((double)this.radius * Math.cos(d3 - d2));
            float f2 = (float)((double)this.radius * Math.sin(d3 - d2));
            this.baseCoordinates[n++] = f;
            this.baseCoordinates[n++] = f2;
        }
    }

    private void recalc2DTexture() {
        int n;
        if (!this.facetsChanged) {
            return;
        }
        this.facetsChanged = false;
        int n2 = 0;
        if (this.useSide) {
            n2 = (this.facetCount + 1) * 2;
        }
        if (this.useTop) {
            n2 += (this.facetCount + 1) * 2;
        }
        if (this.useBottom) {
            n2 += (this.facetCount + 1) * 2;
        }
        if (this.texCoordinates2D == null || n2 * 2 > this.texCoordinates2D.length) {
            this.texCoordinates2D = new float[n2 * 2];
        }
        float f = 1.0f / (float)this.facetCount;
        float f2 = (float)(Math.PI * 2 / (double)this.facetCount);
        int n3 = 0;
        float[] fArray = new float[this.facetCount + 1];
        float[] fArray2 = new float[this.facetCount + 1];
        if (this.useSide) {
            for (n = 0; n < this.facetCount; ++n) {
                float f3 = (float)n * f;
                this.texCoordinates2D[n3++] = f3;
                this.texCoordinates2D[n3++] = 1.0f;
                this.texCoordinates2D[n3++] = f3;
                this.texCoordinates2D[n3++] = 0.0f;
                float f4 = (float)n * f2;
                fArray[n] = (float)(0.5 - (double)this.radius * Math.cos(f4) / 2.0);
                fArray2[n] = (float)(0.5 - (double)this.radius * Math.sin(f4) / 2.0);
            }
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = 0.0f;
        }
        if (this.useTop) {
            fArray[this.facetCount] = fArray[0];
            fArray2[this.facetCount] = fArray2[0];
            n = this.facetCount;
            while (--n >= 0) {
                this.texCoordinates2D[n3++] = 0.5f;
                this.texCoordinates2D[n3++] = 0.5f;
                this.texCoordinates2D[n3++] = fArray[n];
                this.texCoordinates2D[n3++] = fArray2[n];
            }
            this.texCoordinates2D[n3++] = 0.5f;
            this.texCoordinates2D[n3++] = 0.5f;
            this.texCoordinates2D[n3++] = fArray[0];
            this.texCoordinates2D[n3++] = fArray2[1];
        }
        if (this.useBottom) {
            n = this.facetCount;
            while (--n >= 0) {
                this.texCoordinates2D[n3++] = fArray[n];
                this.texCoordinates2D[n3++] = fArray2[n];
                this.texCoordinates2D[n3++] = 0.5f;
                this.texCoordinates2D[n3++] = 0.5f;
            }
            this.texCoordinates2D[n3++] = fArray[0];
            this.texCoordinates2D[n3++] = fArray2[1];
            this.texCoordinates2D[n3++] = 0.5f;
            this.texCoordinates2D[n3++] = 0.5f;
        }
        this.numTexCoords2D = n3;
    }

    private void createRadialFlatNormal(int n) {
        float f = this.baseCoordinates[n * 2];
        float f2 = this.baseCoordinates[n * 2 + 1];
        float f3 = f * f + f2 * f2;
        if ((double)f3 != 0.0) {
            f3 = 1.0f / (float)Math.sqrt(f3);
            this.normal.x = f * f3;
            this.normal.y = 0.0f;
            this.normal.z = f2 * f3;
        } else {
            this.normal.x = 0.0f;
            this.normal.y = 0.0f;
            this.normal.z = 0.0f;
        }
    }
}

