/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.Particle;
import org.j3d.util.ObjectArray;

public class ParticleList {
    private static ObjectArray entryCache = new ObjectArray();
    private Entry start;
    private Entry end;
    private Entry current;
    private int count;

    ParticleList() {
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void reset() {
        this.current = null;
    }

    public Particle next() {
        if (this.count == 0 || this.current == this.end) {
            return null;
        }
        this.current = this.current == null ? this.start : this.current.next;
        return this.current.value;
    }

    public Particle current() {
        if (this.count == 0) {
            return null;
        }
        if (this.current == null) {
            this.current = this.start;
        }
        return this.current.value;
    }

    public void add(Particle particle) {
        if (particle == null) {
            throw new NullPointerException("Attempting to add null object");
        }
        Entry entry = ParticleList.newEntry();
        entry.value = particle;
        if (this.start == null) {
            entry.prev = null;
            entry.next = null;
            this.start = entry;
        } else {
            entry.prev = this.end;
            entry.next = null;
            this.end.next = entry;
        }
        this.end = entry;
        ++this.count;
    }

    public Particle remove() {
        if (this.count == 0) {
            return null;
        }
        Particle particle = this.current.value;
        Entry entry = this.current.prev;
        if (this.current.next != null) {
            this.current.next.prev = this.current.prev;
        }
        if (this.current.prev != null) {
            this.current.prev.next = this.current.next;
        }
        if (this.current == this.end) {
            this.end = this.current.prev;
        }
        if (this.current == this.start) {
            this.start = this.current.next;
        }
        this.current.prev = null;
        this.current.next = null;
        ParticleList.freeEntry(this.current);
        this.current = entry;
        --this.count;
        return particle;
    }

    public void clear() {
        if (this.count == 0) {
            return;
        }
        Entry entry = this.current;
        do {
            this.current = entry;
            entry = this.current.next;
            this.current.prev = null;
            this.current.next = null;
            this.current.value = null;
            ParticleList.freeEntry(this.current);
        } while (entry != null && entry != this.current);
        this.current = null;
        this.start = null;
        this.end = null;
        this.count = 0;
    }

    public void clearCachedObjects() {
        entryCache.clear();
    }

    private static synchronized Entry newEntry() {
        return entryCache.size() == 0 ? new Entry() : (Entry)entryCache.remove(0);
    }

    private static void freeEntry(Entry entry) {
        entryCache.add(entry);
    }

    private static class Entry {
        Particle value;
        Entry next;
        Entry prev;

        private Entry() {
        }
    }
}

