/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.spline.PatchGenerator;

public class BSplinePatchGenerator
extends PatchGenerator {
    private static final int DEFAULT_FACETS = 16;
    private static final int DEFAULT_DEGREE = 3;
    private float[] widthKnots;
    private int numWidthKnots;
    private int widthDegree;
    private float[] depthKnots;
    private int numDepthKnots;
    private int depthDegree;

    public BSplinePatchGenerator() {
        this(16, 16, 3, 3);
    }

    public BSplinePatchGenerator(int n, int n2) {
        this(n, n2, 3, 3);
    }

    public BSplinePatchGenerator(int n, int n2, int n3) {
        this(n, n2, n3, n3);
    }

    public BSplinePatchGenerator(int n, int n2, int n3, int n4) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of width facets is < 3");
        }
        if (n2 < 3) {
            throw new IllegalArgumentException("Number of depth facets is < 3");
        }
        if (n3 < 2) {
            throw new IllegalArgumentException("Width degree is < 2");
        }
        if (n4 < 2) {
            throw new IllegalArgumentException("Depth degree is < 2");
        }
        this.patchChanged = true;
        this.widthFacetCount = n;
        this.depthFacetCount = n2;
        this.widthDegree = n3;
        this.depthDegree = n4;
        this.numWidthKnots = this.widthDegree;
        this.numDepthKnots = this.depthDegree;
        this.widthKnots = new float[this.numWidthKnots];
        this.depthKnots = new float[this.numDepthKnots];
    }

    public void setPatchKnots(int n, float[] fArray, int n2, float[] fArray2) {
        if (n < 2) {
            throw new IllegalArgumentException("Width degree is < 2");
        }
        if (fArray.length < this.numWidthControlPoints + n + 1) {
            throw new IllegalArgumentException("Width Knots < 3");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Depth degree is < 2");
        }
        if (fArray2.length < this.numDepthControlPoints + n2 + 1) {
            throw new IllegalArgumentException("Depth Knots < 3");
        }
        this.widthDegree = n;
        this.depthDegree = n2;
        if (fArray.length > this.widthKnots.length) {
            this.widthKnots = new float[fArray.length];
        }
        if (fArray2.length > this.depthKnots.length) {
            this.depthKnots = new float[fArray2.length];
        }
        System.arraycopy(fArray, 0, this.widthKnots, 0, fArray.length);
        System.arraycopy(fArray2, 0, this.depthKnots, 0, fArray2.length);
        this.numWidthKnots = fArray.length;
        this.numDepthKnots = fArray2.length;
        this.patchChanged = true;
    }

    public void setPatchKnots(int n, double[] dArray, int n2, double[] dArray2) {
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("Width degree is < 2");
        }
        if (dArray.length < this.numWidthControlPoints + n + 1) {
            throw new IllegalArgumentException("wknts.length < n + k + 1");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Depth degree is < 2");
        }
        if (dArray2.length < this.numDepthControlPoints + n2 + 1) {
            throw new IllegalArgumentException("dknts.length < n + k + 1");
        }
        this.widthDegree = n;
        this.depthDegree = n2;
        if (dArray.length > this.widthKnots.length) {
            this.widthKnots = new float[dArray.length];
        }
        if (dArray2.length > this.depthKnots.length) {
            this.depthKnots = new float[dArray2.length];
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            this.widthKnots[n3] = (float)dArray[n3];
        }
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            this.depthKnots[n3] = (float)dArray2[n3];
        }
        this.numWidthKnots = dArray.length;
        this.numDepthKnots = dArray2.length;
        this.patchChanged = true;
    }

    public int getWidthDegree() {
        return this.widthDegree;
    }

    public int getDepthDegree() {
        return this.depthDegree;
    }

    public void generateSmoothKnots(int n, int n2) {
        if (n < 2) {
            throw new IllegalArgumentException("Width degree is < 2");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Depth degree is < 2");
        }
        if (n != this.widthDegree) {
            this.widthDegree = n;
            this.patchChanged = true;
        }
        if (n2 != this.depthDegree) {
            this.depthDegree = n2;
            this.patchChanged = true;
        }
        this.generateSmoothKnots();
    }

    public void generateSmoothKnots() {
        int n;
        this.numWidthKnots = this.numWidthControlPoints + this.widthDegree + 1;
        if (this.widthKnots.length < this.numWidthKnots) {
            this.widthKnots = new float[this.numWidthKnots];
        }
        for (n = 0; n < this.numWidthKnots; ++n) {
            if (n <= this.widthDegree) {
                this.widthKnots[n] = 0.0f;
                continue;
            }
            if (n < this.numWidthControlPoints) {
                this.widthKnots[n] = n - this.widthDegree + 1;
                continue;
            }
            if (n < this.numWidthControlPoints) continue;
            this.widthKnots[n] = this.numWidthControlPoints - this.widthDegree + 1;
        }
        this.numDepthKnots = this.numDepthControlPoints + this.depthDegree + 1;
        if (this.depthKnots.length < this.numDepthKnots) {
            this.depthKnots = new float[this.numDepthKnots];
        }
        for (n = 0; n < this.numDepthKnots; ++n) {
            if (n <= this.depthDegree) {
                this.depthKnots[n] = 0.0f;
                continue;
            }
            if (n < this.numDepthControlPoints) {
                this.depthKnots[n] = n - this.depthDegree + 1;
                continue;
            }
            if (n < this.numDepthControlPoints) continue;
            this.depthKnots[n] = this.numDepthControlPoints - this.depthDegree + 1;
        }
    }

    protected final void regeneratePatch() {
        if (!this.patchChanged) {
            return;
        }
        this.patchChanged = false;
        this.numPatchValues = (this.widthFacetCount + 1) * 3;
        if (this.patchCoordinates == null || this.numPatchValues > this.patchCoordinates.length || this.numPatchValues > this.patchCoordinates[0].length) {
            this.patchCoordinates = new float[this.depthFacetCount + 1][this.numPatchValues];
        }
        if (this.useControlPointWeights) {
            this.regenerateRationalPatch();
        } else {
            this.regenerateStandardPatch();
        }
    }

    private void regenerateStandardPatch() {
        int n = this.widthDegree + 1;
        int n2 = this.depthDegree + 1;
        double d = (double)this.widthKnots[this.numWidthKnots - 1] / (double)(this.widthFacetCount + 1);
        double d2 = (double)this.depthKnots[this.numDepthKnots - 1] / (double)(this.depthFacetCount + 1);
        double d3 = 0.0;
        for (int i = 0; i <= this.widthFacetCount; ++i) {
            double d4 = 0.0;
            int n3 = 0;
            for (int j = 0; j <= this.depthFacetCount; ++j) {
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < this.numWidthControlPoints; ++k) {
                    n4 = 0;
                    for (n5 = 0; n5 < this.numDepthControlPoints; ++n5) {
                        double d8 = this.splineBlend(k, n, false, d3);
                        double d9 = this.splineBlend(n5, n2, true, d4);
                        d5 += (double)this.controlPointCoordinates[k][n4++] * d8 * d9;
                        d6 += (double)this.controlPointCoordinates[k][n4++] * d8 * d9;
                        d7 += (double)this.controlPointCoordinates[k][n4++] * d8 * d9;
                    }
                }
                this.patchCoordinates[i][n3++] = (float)d5;
                this.patchCoordinates[i][n3++] = (float)d6;
                this.patchCoordinates[i][n3++] = (float)d7;
                d4 += d2;
            }
            d3 += d;
        }
    }

    private void regenerateRationalPatch() {
        int n = this.widthDegree + 1;
        int n2 = this.depthDegree + 1;
        double d = (double)this.widthKnots[this.numWidthKnots - 1] / (double)(this.widthFacetCount + 1);
        double d2 = (double)this.depthKnots[this.numDepthKnots - 1] / (double)(this.depthFacetCount + 1);
        double d3 = 0.0;
        for (int i = 0; i <= this.widthFacetCount; ++i) {
            double d4 = 0.0;
            int n3 = 0;
            for (int j = 0; j <= this.depthFacetCount; ++j) {
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < this.numWidthControlPoints; ++k) {
                    n4 = 0;
                    for (n5 = 0; n5 < this.numDepthControlPoints; ++n5) {
                        double d9 = this.splineBlend(k, n, false, d3);
                        double d10 = this.splineBlend(n5, n2, true, d4);
                        float f = this.controlPointWeights[k][n5];
                        d5 += (double)this.controlPointCoordinates[k][n4++] * d9 * d10 * (double)f;
                        d6 += (double)this.controlPointCoordinates[k][n4++] * d9 * d10 * (double)f;
                        d7 += (double)this.controlPointCoordinates[k][n4++] * d9 * d10 * (double)f;
                        d8 += d9 * d10 * (double)f;
                    }
                }
                if (d8 != 0.0) {
                    this.patchCoordinates[i][n3++] = (float)(d5 / d8);
                    this.patchCoordinates[i][n3++] = (float)(d6 / d8);
                    this.patchCoordinates[i][n3++] = (float)(d7 / d8);
                } else {
                    this.patchCoordinates[i][n3++] = (float)d5;
                    this.patchCoordinates[i][n3++] = (float)d6;
                    this.patchCoordinates[i][n3++] = (float)d7;
                }
                d4 += d2;
            }
            d3 += d;
        }
    }

    private double splineBlend(int n, int n2, boolean bl, double d) {
        double d2;
        float[] fArray;
        float[] fArray2 = fArray = bl ? this.depthKnots : this.widthKnots;
        if (n2 == 1) {
            d2 = (double)fArray[n] <= d && d < (double)fArray[n + 1] ? 1.0 : 0.0;
        } else {
            double d3 = this.splineBlend(n, n2 - 1, bl, d);
            double d4 = this.splineBlend(n + 1, n2 - 1, bl, d);
            double d5 = fArray[n + n2 - 1] - fArray[n];
            double d6 = fArray[n + n2] - fArray[n + 1];
            double d7 = d3 != 0.0 ? (d - (double)fArray[n]) / d5 * d3 : 0.0;
            double d8 = d4 != 0.0 ? ((double)fArray[n + n2] - d) / d6 * d4 : 0.0;
            d2 = d7 + d8;
        }
        return d2;
    }
}

