/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Debug;
import SharpTools.Function;
import SharpTools.FunctionAbs;
import SharpTools.FunctionAcos;
import SharpTools.FunctionAsin;
import SharpTools.FunctionAtan;
import SharpTools.FunctionAverage;
import SharpTools.FunctionCos;
import SharpTools.FunctionCount;
import SharpTools.FunctionE;
import SharpTools.FunctionInt;
import SharpTools.FunctionLog;
import SharpTools.FunctionMax;
import SharpTools.FunctionMeandev;
import SharpTools.FunctionMedian;
import SharpTools.FunctionMin;
import SharpTools.FunctionPI;
import SharpTools.FunctionRange;
import SharpTools.FunctionRound;
import SharpTools.FunctionSin;
import SharpTools.FunctionSqrt;
import SharpTools.FunctionStddev;
import SharpTools.FunctionSum;
import SharpTools.FunctionTan;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeSet;

public class Formula {
    private static HashMap funcTable;
    private TreeSet dependency;
    private LinkedList postfix;
    private int row;
    private int col;
    private String formulaString;
    private ParserException error;
    private boolean needsRecalc;

    Formula(String input, int row, int col, ParserException e) {
        this.formulaString = input.toUpperCase();
        this.col = col;
        this.row = row;
        this.error = e;
    }

    Formula(String input, int row, int col) throws ParserException {
        this.col = col;
        this.row = row;
        this.formulaString = input.toUpperCase();
        try {
            LinkedList tokens = this.tokenize(this.formulaString);
            this.dependency = this.createDependency(tokens);
            this.postfix = this.toPostfix(this.convertParams(tokens));
            Debug.println("Postfix: " + this.postfix);
        }
        catch (ParserException e) {
            Debug.println("Formula constructor: " + e);
            this.throwError(e);
        }
    }

    Formula(Formula formula, int row, int col) throws ParserException {
        this.col = col;
        this.row = row;
        try {
            this.formulaString = Formula.fixRelAddr(formula.formulaString, row - formula.row, col - formula.col);
            if (this.formulaString == null) {
                this.formulaString = "$REFS$0";
                this.error = new ParserException("REFS");
                return;
            }
            LinkedList tokens = this.tokenize(this.formulaString);
            this.dependency = this.createDependency(tokens);
            this.postfix = this.toPostfix(this.convertParams(tokens));
        }
        catch (ParserException e) {
            System.err.println("Shouldn't happen!");
            this.throwError(e);
        }
    }

    public static boolean isSafe(Formula formula, int rowOff, int colOff) {
        String newString = Formula.fixRelAddr(formula.formulaString, rowOff, colOff);
        return newString != null;
    }

    public boolean isBad() {
        return this.postfix == null;
    }

    public boolean needsRecalc() {
        return this.needsRecalc;
    }

    public void setNeedsRecalc(boolean needs) {
        this.needsRecalc = needs;
    }

    public static String fixRelAddr(String oldFormula, int rowOffset, int colOffset) {
        if (colOffset == 0 && rowOffset == 0) {
            return oldFormula;
        }
        StringBuffer newFormulaBuf = new StringBuffer();
        int lastPos = 0;
        for (int i = 0; i < oldFormula.length(); ++i) {
            char c = oldFormula.charAt(i);
            int letterStart = i;
            if (!Character.isUpperCase(c)) continue;
            boolean isAbsAddr = i > 0 && oldFormula.charAt(i - 1) == '$';
            StringBuffer colNameBuf = new StringBuffer();
            while (i < oldFormula.length() && Character.isUpperCase(oldFormula.charAt(i))) {
                colNameBuf.append(oldFormula.charAt(i++));
            }
            String colName = colNameBuf.toString();
            if (i == oldFormula.length()) break;
            if (isAbsAddr || !Character.isDigit(oldFormula.charAt(i))) continue;
            StringBuffer rowNameBuf = new StringBuffer();
            while (i < oldFormula.length() && Character.isDigit(oldFormula.charAt(i))) {
                rowNameBuf.append(oldFormula.charAt(i++));
            }
            String rowName = rowNameBuf.toString();
            newFormulaBuf.append(oldFormula.substring(lastPos, letterStart));
            if (colOffset == 0) {
                newFormulaBuf.append(colName);
            } else {
                String col = Formula.translateColumn(Formula.translateColumn(colName) + colOffset);
                if (col == null) {
                    return null;
                }
                newFormulaBuf.append(col);
            }
            if (rowOffset == 0) {
                newFormulaBuf.append(rowName);
            } else {
                String row = Formula.translateRow(Formula.translateRow(rowName) + rowOffset);
                if (row == null) {
                    return null;
                }
                newFormulaBuf.append(row);
            }
            lastPos = i;
        }
        newFormulaBuf.append(oldFormula.substring(lastPos));
        return newFormulaBuf.toString();
    }

    private LinkedList tokenize(String input) throws ParserException {
        LinkedList<Node> tokens = new LinkedList<Node>();
        Stack stack = new Stack();
        Node zero = new Node();
        zero.setType(6);
        zero.setNumber(0.0f);
        int cur = 0;
        int lastType = 0;
        Node lastToken = null;
        int nParen = 0;
        while (cur < input.length()) {
            Node node = new Node();
            try {
                char c = input.charAt(cur++);
                node.setData(String.valueOf(c));
                if (Character.isLetter(c)) {
                    node.setType(3);
                    node.setParams(new LinkedList());
                    while (cur < input.length() && Character.isLetter(input.charAt(cur))) {
                        node.appendData(input.charAt(cur++));
                    }
                    if (Character.isDigit(input.charAt(cur))) {
                        node.setType(1);
                        node.setCol(Formula.translateColumn(node.getData()) - this.col);
                        node.setData("");
                        while (cur < input.length() && Character.isDigit(input.charAt(cur))) {
                            node.appendData(input.charAt(cur++));
                        }
                        node.setRow(Formula.translateRow(node.getData()) - this.row);
                        node.setData(null);
                    }
                } else if (Character.isDigit(c) || c == '.') {
                    while (cur < input.length() && (Character.isDigit(input.charAt(cur)) || input.charAt(cur) == '.')) {
                        node.appendData(input.charAt(cur++));
                    }
                    try {
                        try {
                            node.setNumber(Integer.parseInt(node.getData()));
                        }
                        catch (NumberFormatException e) {
                            node.setNumber(Float.parseFloat(node.getData()));
                        }
                        node.setType(6);
                    }
                    catch (NumberFormatException e) {
                        this.throwError("#NUM?");
                    }
                } else if (c == '(') {
                    ++nParen;
                    node.setType(4);
                } else if (c == ')') {
                    --nParen;
                    node.setType(5);
                } else if (c == ',') {
                    node.setType(8);
                } else if (c == ':') {
                    node.setPending(true);
                    node.setType(9);
                    Node prev = null;
                    try {
                        prev = (Node)tokens.removeLast();
                    }
                    catch (Exception e) {
                        this.throwError("#ADDR?");
                    }
                    if (prev.isType(1) || prev.isType(2)) {
                        node.setNextRange(prev);
                    } else {
                        this.throwError("#ADDR?");
                    }
                } else if (c == '+' || c == '-' || c == '*' || c == '/' || c == '^' || c == '%') {
                    node.setType(7);
                } else if (c == '$') {
                    node.setType(2);
                    node.setData("");
                    if (!Character.isLetter(input.charAt(cur))) {
                        this.throwError("#ADDR?");
                    }
                    while (Character.isLetter(input.charAt(cur))) {
                        node.appendData(input.charAt(cur++));
                    }
                    if (input.charAt(cur++) != '$' || !Character.isDigit(input.charAt(cur))) {
                        this.throwError("#ADDR?");
                    }
                    node.setCol(Formula.translateColumn(node.getData()));
                    node.setData("");
                    while (cur < input.length() && Character.isDigit(input.charAt(cur))) {
                        node.appendData(input.charAt(cur++));
                    }
                    node.setRow(Formula.translateRow(node.getData()));
                    node.setData(null);
                } else {
                    if (c == ' ') continue;
                    this.throwError("#NAME?");
                }
                if (cur < input.length() && (node.isType(1) || node.isType(2) || node.isType(6)) && Character.isLetterOrDigit(input.charAt(cur))) {
                    this.throwError("#NAME?");
                }
                if (lastToken != null && lastToken.isType(9) && lastToken.isPending()) {
                    if (node.isType(1) || node.isType(2)) {
                        Node range = (Node)tokens.removeLast();
                        try {
                            range.getNextRange().setNextRange(node);
                            range.setPending(false);
                        }
                        catch (NullPointerException e) {
                            this.throwError("#ADDR?");
                        }
                        node = range;
                    } else {
                        this.throwError("#ADDR?");
                    }
                }
                if (node.isType(7) && (node.getData().equals("+") || node.getData().equals("-")) && (lastToken == null || lastToken.isType(4) || lastToken.isType(8))) {
                    tokens.add(zero);
                }
                tokens.add(node);
                lastType = node.getType();
                lastToken = node;
            }
            catch (IndexOutOfBoundsException e) {
                this.throwError("#NAME?");
            }
            catch (ParserException e) {
                this.throwError(e);
            }
            catch (Exception e) {
                Debug.println(e.toString());
            }
        }
        if (nParen != 0) {
            this.throwError("#PAREN?");
        }
        return tokens;
    }

    private LinkedList convertParams(LinkedList tokens) throws ParserException {
        if (tokens == null) {
            throw this.error;
        }
        LinkedList<Node> stack = new LinkedList<Node>();
        Iterator it = tokens.iterator();
        try {
            while (it.hasNext()) {
                Node param;
                LinkedList<Node> list;
                Node exp;
                Node node = (Node)it.next();
                if (node.isType(3)) {
                    node.setPending(true);
                    stack.add(node);
                    node = (Node)it.next();
                    if (node.isType(4)) continue;
                    this.throwError("#NO(?");
                    continue;
                }
                if (node.isType(4)) {
                    node.setPending(true);
                    stack.add(node);
                    continue;
                }
                if (node.isType(8)) {
                    exp = new Node();
                    list = new LinkedList<Node>();
                    param = (Node)stack.removeLast();
                    while (!param.isType(3) || !param.isPending()) {
                        list.addFirst(param);
                        param = (Node)stack.removeLast();
                    }
                    exp.setType(10);
                    exp.setExp(list);
                    param.addParam(exp);
                    stack.add(param);
                    continue;
                }
                if (node.isType(5)) {
                    exp = new Node();
                    list = new LinkedList();
                    param = (Node)stack.removeLast();
                    while (!param.isPending() || !param.isType(3) && !param.isType(4)) {
                        list.addFirst(param);
                        param = (Node)stack.removeLast();
                    }
                    if (param.isType(4)) {
                        param.setPending(false);
                        stack.add(param);
                        stack.addAll(list);
                        stack.add(node);
                        continue;
                    }
                    exp.setType(10);
                    exp.setExp(list);
                    param.addParam(exp);
                    param.setPending(false);
                    stack.add(param);
                    continue;
                }
                stack.add(node);
            }
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.println(e);
            this.throwError("#PARAM?");
        }
        return stack;
    }

    private LinkedList toPostfix(LinkedList tokens) throws ParserException {
        if (tokens == null) {
            throw this.error;
        }
        Stack<Node> stack = new Stack<Node>();
        LinkedList<Node> postfix = new LinkedList<Node>();
        block9: for (Node node : tokens) {
            switch (node.getType()) {
                case 1: 
                case 2: 
                case 6: 
                case 9: {
                    postfix.add(node);
                    break;
                }
                case 4: {
                    stack.push(node);
                    break;
                }
                case 7: {
                    int priority = Formula.getPriority(node);
                    while (!stack.empty() && !((Node)stack.peek()).isType(4) && Formula.getPriority((Node)stack.peek()) >= priority) {
                        postfix.add((Node)stack.pop());
                    }
                    stack.push(node);
                    break;
                }
                case 5: {
                    try {
                        Node op = (Node)stack.pop();
                        while (!op.isType(4)) {
                            postfix.add(op);
                            op = (Node)stack.pop();
                        }
                        continue block9;
                    }
                    catch (EmptyStackException e) {
                        this.throwError("#PAREN?");
                        break;
                    }
                }
                case 3: {
                    LinkedList params = node.getParams();
                    for (Node exp : params) {
                        exp.setExp(this.toPostfix(exp.getExp()));
                    }
                    postfix.add(node);
                    break;
                }
                default: {
                    this.throwError("#ERROR?");
                }
            }
        }
        while (!stack.empty()) {
            postfix.add((Node)stack.pop());
        }
        return postfix;
    }

    private TreeSet createDependency(LinkedList tokens) {
        TreeSet<CellPoint> dependency = new TreeSet<CellPoint>();
        for (Node node : tokens) {
            if (node.isType(1) || node.isType(2)) {
                CellPoint newCell = node.toCellPoint(this.row, this.col);
                dependency.add(newCell);
                continue;
            }
            if (!node.isType(9)) continue;
            CellPoint[] addr = node.getAddressRange(this.row, this.col);
            for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                    dependency.add(new CellPoint(i, j));
                }
            }
        }
        return dependency;
    }

    public TreeSet getDependency() {
        if (this.isBad()) {
            return new TreeSet();
        }
        return this.dependency;
    }

    private static int getPriority(char op) {
        switch (op) {
            case '+': 
            case '-': {
                return 1;
            }
            case '%': 
            case '*': 
            case '/': {
                return 2;
            }
            case '^': {
                return 3;
            }
        }
        return 0;
    }

    private static int getPriority(Node node) {
        return Formula.getPriority(node.getData().charAt(0));
    }

    public String toString() {
        return this.formulaString;
    }

    private static Number calc(char op, Number op1, Number op2) {
        float result;
        float n1 = op1.floatValue();
        float n2 = op2.floatValue();
        switch (op) {
            case '+': {
                result = n1 + n2;
                break;
            }
            case '-': {
                result = n1 - n2;
                break;
            }
            case '*': {
                result = n1 * n2;
                break;
            }
            case '/': {
                result = n1 / n2;
                break;
            }
            case '^': {
                result = (float)Math.pow(n1, n2);
                break;
            }
            case '%': {
                result = (int)n1 % (int)n2;
                break;
            }
            default: {
                result = 0.0f;
            }
        }
        return new Float(result);
    }

    private static Number evalFunction(SharpTableModel table, Node node, int row, int col) throws ParserException {
        String funcName = node.getData();
        Function func = Formula.getFuncHandler(funcName);
        if (func == null) {
            throw new ParserException("#FUNC?");
        }
        return func.evaluate(table, node, row, col);
    }

    public static Number evaluate(SharpTableModel table, int row, int col) throws ParserException {
        if (Debug.isDebug()) {
            Debug.println("recalculating " + new CellPoint(row, col));
        }
        Formula formula = table.getCellAt(row, col).getFormula();
        formula.setNeedsRecalc(false);
        if (formula == null) {
            return new Integer(0);
        }
        return formula.evaluate(table);
    }

    private Number evaluate(SharpTableModel table) throws ParserException {
        if (this.isBad()) {
            throw this.error;
        }
        return Formula.evaluate(table, this.postfix, this.row, this.col);
    }

    public static Number evaluate(SharpTableModel table, LinkedList postfix, int row, int col) throws ParserException {
        try {
            Stack<Number> stack = new Stack<Number>();
            for (Node node : postfix) {
                Number result;
                switch (node.getType()) {
                    case 7: {
                        Number n2 = (Number)stack.pop();
                        Number n1 = (Number)stack.pop();
                        result = Formula.calc(node.getData().charAt(0), n1, n2);
                        break;
                    }
                    case 3: {
                        result = Formula.evalFunction(table, node, row, col);
                        break;
                    }
                    case 6: {
                        result = new Float(node.getNumber());
                        break;
                    }
                    case 2: {
                        result = table.getNumericValueAt(node.getRow(), node.getCol());
                        break;
                    }
                    case 1: {
                        result = table.getNumericValueAt(node.getRow() + row, node.getCol() + col);
                        break;
                    }
                    default: {
                        throw new ParserException("#EVAL?");
                    }
                }
                stack.push(result);
            }
            Number result = (Number)stack.pop();
            return result;
        }
        catch (EmptyStackException e) {
            throw new ParserException("#OP?");
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.println(e);
            return new Integer(0);
        }
    }

    private static final int translateRow(String row) {
        return Node.translateRow(row);
    }

    private static final String translateRow(int row) {
        return Node.translateRow(row);
    }

    private static final int translateColumn(String column) {
        return Node.translateColumn(column);
    }

    private static final String translateColumn(int column) {
        return Node.translateColumn(column);
    }

    private void throwError(Object s) throws ParserException {
        this.postfix = null;
        if (this.error instanceof ParserException) {
            throw (ParserException)s;
        }
        this.error = new ParserException(s);
        throw this.error;
    }

    private String getCellString() {
        return Formula.getCellString(this.row, this.col);
    }

    private static final String getCellString(int row, int col) {
        return "" + Formula.translateColumn(col) + Formula.translateRow(row);
    }

    public static final CellPoint parseAddress(String s) {
        try {
            int col;
            char c;
            int len;
            s = s.toUpperCase();
            int total = s.length();
            StringBuffer buf = new StringBuffer();
            for (len = 0; len < total; ++len) {
                c = s.charAt(len);
                if (Character.isUpperCase(c)) {
                    buf.append(c);
                    continue;
                }
                if (Character.isDigit(c)) break;
                return null;
            }
            if ((col = Formula.translateColumn(buf.toString())) == 0) {
                return null;
            }
            buf = new StringBuffer();
            while (len < total) {
                c = s.charAt(len);
                if (Character.isDigit(c)) {
                    buf.append(c);
                    ++len;
                    continue;
                }
                return null;
            }
            int row = Formula.translateRow(buf.toString());
            if (row == 0) {
                return null;
            }
            return new CellPoint(row, col);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void register(String funcName, Function func) {
        funcTable.put(funcName, func);
    }

    public static void registerFunctions() {
        funcTable = new HashMap();
        Formula.register("SUM", new FunctionSum());
        Formula.register("MEAN", new FunctionAverage());
        Formula.register("AVERAGE", new FunctionAverage());
        Formula.register("MEDIAN", new FunctionMedian());
        Formula.register("ABS", new FunctionAbs());
        Formula.register("INT", new FunctionInt());
        Formula.register("ROUND", new FunctionRound());
        Formula.register("SIN", new FunctionSin());
        Formula.register("COS", new FunctionCos());
        Formula.register("TAN", new FunctionTan());
        Formula.register("ASIN", new FunctionAsin());
        Formula.register("ACOS", new FunctionAcos());
        Formula.register("ATAN", new FunctionAtan());
        Formula.register("SQRT", new FunctionSqrt());
        Formula.register("LOG", new FunctionLog());
        Formula.register("MIN", new FunctionMin());
        Formula.register("MAX", new FunctionMax());
        Formula.register("RANGE", new FunctionRange());
        Formula.register("STDDEV", new FunctionStddev());
        Formula.register("MEANDEV", new FunctionMeandev());
        Formula.register("COUNT", new FunctionCount());
        Formula.register("PI", new FunctionPI());
        Formula.register("E", new FunctionE());
    }

    public static Function getFuncHandler(String fname) {
        Formula.registerFunctions();
        return (Function)funcTable.get(fname);
    }
}

