/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.Molecule;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetCache;
import WIMSchem.ds.TitleListener;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel {
    DataSheet ds = null;
    DataSheetCache cache = null;
    TitleListener tlist = null;

    public DataTableModel(DataSheet DS, DataSheetCache Cache2, TitleListener TList) {
        this.ds = DS;
        this.cache = Cache2;
        this.tlist = TList;
    }

    public DataSheet getDataSheet() {
        return this.ds;
    }

    public void setDataSheet(DataSheet DS, DataSheetCache Cache2) {
        this.ds = DS;
        this.cache = Cache2;
    }

    public int getColumnCount() {
        return this.ds.numCols();
    }

    public int getRowCount() {
        return this.ds.numRows();
    }

    public String getColumnName(int col) {
        return this.ds.colName(col);
    }

    public Object getValueAt(int row, int col) {
        int t = this.ds.colType(col);
        if (this.ds.isNull(row, col)) {
            if (t == 1) {
                return null;
            }
            if (t == 5) {
                return new Boolean(false);
            }
            return "";
        }
        if (t == 1) {
            return this.ds.getMolecule(row, col);
        }
        if (t == 2) {
            return this.ds.getString(row, col);
        }
        if (t == 3) {
            return new Integer(this.ds.getInteger(row, col));
        }
        if (t == 4) {
            return new Double(this.ds.getReal(row, col));
        }
        if (t == 5) {
            return new Boolean(this.ds.getBoolean(row, col));
        }
        return "";
    }

    public Class getColumnClass(int col) {
        int t = this.ds.colType(col);
        if (t == 1) {
            return new Molecule().getClass();
        }
        if (t == 2) {
            return new String("").getClass();
        }
        if (t == 3) {
            return new String("").getClass();
        }
        if (t == 4) {
            return new String("").getClass();
        }
        if (t == 5) {
            return new Boolean(false).getClass();
        }
        return new String("").getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
        int t = this.ds.colType(col);
        try {
            boolean b;
            if (t == 1) {
                if (!this.ds.isEqualMolecule(row, col, (Molecule)val)) {
                    this.cache.cacheUndo(this.ds);
                    this.ds.setMolecule(row, col, (Molecule)val);
                    this.ds.setDirty();
                    this.tlist.replaceTitle();
                }
            } else if (t == 2) {
                if (!this.ds.isEqualString(row, col, (String)val)) {
                    this.cache.cacheUndo(this.ds);
                    this.ds.setString(row, col, (String)val);
                    this.ds.setDirty();
                    this.tlist.replaceTitle();
                }
            } else if (t == 3) {
                String str = (String)val;
                if (str.length() == 0) {
                    if (!this.ds.isNull(row, col)) {
                        this.cache.cacheUndo(this.ds);
                        this.ds.setToNull(row, col);
                        this.ds.setDirty();
                        this.tlist.replaceTitle();
                    }
                } else {
                    int i = Integer.parseInt(str);
                    if (!this.ds.isEqualInteger(row, col, i)) {
                        this.cache.cacheUndo(this.ds);
                        this.ds.setInteger(row, col, i);
                        this.ds.setDirty();
                        this.tlist.replaceTitle();
                    }
                }
            } else if (t == 4) {
                String str = (String)val;
                if (str.length() == 0) {
                    if (!this.ds.isNull(row, col)) {
                        this.cache.cacheUndo(this.ds);
                        this.ds.setToNull(row, col);
                        this.ds.setDirty();
                        this.tlist.replaceTitle();
                    }
                } else {
                    double d = Double.parseDouble(str);
                    if (!this.ds.isEqualReal(row, col, d)) {
                        this.cache.cacheUndo(this.ds);
                        this.ds.setReal(row, col, d);
                        this.ds.setDirty();
                        this.tlist.replaceTitle();
                    }
                }
            } else if (t == 5 && !this.ds.isEqualBoolean(row, col, b = ((Boolean)val).booleanValue())) {
                this.cache.cacheUndo(this.ds);
                this.ds.setBoolean(row, col, b);
                this.ds.setDirty();
                this.tlist.replaceTitle();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

