/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.NotExpression;

class AndExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public AndExpression(BasicExpression basicExpression, BasicExpression basicExpression2) {
        this.E1 = basicExpression;
        this.E2 = basicExpression2;
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        BasicExpression basicExpression = NotExpression.scan(expressionText);
        if (expressionText.next() == '&') {
            expressionText.advance();
            if (expressionText.next(true) == '&') {
                expressionText.advance();
            }
            return AndExpression.scan(expressionText, basicExpression);
        }
        return basicExpression;
    }

    public static BasicExpression scan(ExpressionText expressionText, BasicExpression basicExpression) throws ConstructionException {
        BasicExpression basicExpression2 = NotExpression.scan(expressionText);
        if (expressionText.next() == '&') {
            expressionText.advance();
            return AndExpression.scan(expressionText, new AndExpression(basicExpression, basicExpression2));
        }
        return new AndExpression(basicExpression, basicExpression2);
    }

    public double getValue() throws ConstructionException {
        if (this.E1.getValue() != 0.0 && this.E2.getValue() != 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "&&" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }

    public boolean isLogical() {
        return true;
    }
}

