/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;

class ConstructionExpression
extends BasicExpression {
    int Type;
    Construction C;
    static final int CENTERX = 0;
    static final int CENTERY = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    static final int PIXEL = 4;

    public ConstructionExpression(Construction construction, int n) {
        this.Type = n;
        this.C = construction;
    }

    public double getValue() throws ConstructionException {
        if (this.C == null) {
            return 0.0;
        }
        switch (this.Type) {
            case 2: {
                return this.C.getW();
            }
            case 0: {
                return this.C.getX();
            }
            case 1: {
                return this.C.getY();
            }
            case 3: {
                return this.C.getH();
            }
            case 4: {
                return this.C.getPixel();
            }
        }
        return 0.0;
    }

    public void translate() {
        this.C = this.C.getTranslation();
    }

    public String toString() {
        switch (this.Type) {
            case 2: {
                return "windoww";
            }
            case 0: {
                return "windowcx";
            }
            case 1: {
                return "windowcy";
            }
            case 3: {
                return "windowh";
            }
            case 4: {
                return "pixel";
            }
        }
        return "";
    }
}

