/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.MyFontMetrics;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;

public class MyGraphicsFig
extends MyGraphics {
    PrintWriter Out;
    static final int STROKE_NORMAL = 1;
    static final int STROKE_THIN = 1;
    static final int STROKE_THICK = 2;
    static final int STYLE_NORMAL = 0;
    static final int STYLE_THIN = 1;
    static final int STYLE_THICK = 0;
    int Stroke = 1;
    int Red;
    int Green;
    int Blue;
    MyFontMetrics MFM;
    int yoffset = 6000;
    String[] FigColorsArray;
    int FigLastcolor = 31;
    int FigColor = 0;
    int FigFillcolor = 0;
    int FigLinestyle = 0;
    int FigLayer = 10000;
    boolean PushLayer = true;
    int xfactor = 15;
    int yfactor = 15;
    StringBuffer FigFirstpart;
    StringBuffer FigLastpart;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsFig(PrintWriter printWriter, int n, int n2) {
        this.FigFirstpart = new StringBuffer();
        this.FigLastpart = new StringBuffer();
        this.FigFirstpart.append("#FIG 3.2\n");
        this.FigFirstpart.append("Landscape\n");
        this.FigFirstpart.append("Center\n");
        this.FigFirstpart.append("Metric\n");
        this.FigFirstpart.append("A4\n");
        this.FigFirstpart.append("100.00\n");
        this.FigFirstpart.append("Single\n");
        this.FigFirstpart.append("-2\n");
        this.FigFirstpart.append("1200 2\n");
        this.MFM = new MyFontMetrics();
        this.Out = printWriter;
        this.FigColorsArray = new String[543];
    }

    public void close() {
        this.append("#End\n");
        this.Out.print(this.FigFirstpart);
        this.Out.print(this.FigLastpart);
    }

    String ColorString(Color color) {
        String string;
        String string2;
        String string3 = "#";
        String string4 = Integer.toHexString(color.getRed());
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        string3 = string3 + string4;
        string3 = string3 + string2;
        string3 = string3 + string;
        return string3;
    }

    public void setColor(Color color) {
        String string = this.ColorString(color);
        boolean bl = true;
        for (int i = 32; i <= this.FigLastcolor; ++i) {
            if (!string.equals(this.FigColorsArray[i])) continue;
            this.FigColor = i;
            bl = false;
            break;
        }
        if (bl) {
            ++this.FigLastcolor;
            this.FigColor = this.FigLastcolor;
            this.FigColorsArray[this.FigLastcolor] = string;
            this.FigFirstpart.append("0 ");
            this.FigFirstpart.append(this.FigLastcolor);
            this.FigFirstpart.append(" ");
            this.FigFirstpart.append(string);
            this.FigFirstpart.append("\n");
        }
    }

    public void setFillcolor(Color color) {
        String string = this.ColorString(color);
        boolean bl = true;
        for (int i = 32; i <= this.FigLastcolor; ++i) {
            if (!string.equals(this.FigColorsArray[i])) continue;
            this.FigFillcolor = i;
            bl = false;
            break;
        }
        if (bl) {
            ++this.FigLastcolor;
            this.FigFillcolor = this.FigLastcolor;
            this.FigColorsArray[this.FigLastcolor] = string;
            this.FigFirstpart.append("0 ");
            this.FigFirstpart.append(this.FigLastcolor);
            this.FigFirstpart.append(" ");
            this.FigFirstpart.append(string);
            this.FigFirstpart.append("\n");
        }
    }

    public void setColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else {
            if (constructionObject.getColorType() == 2) {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[n]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[n]);
                }
            } else {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[n]);
                } else {
                    this.setColor(ZirkelFrame.Colors[n]);
                }
            }
            if (constructionObject.getColorType() == 2) {
                this.Stroke = 1;
                this.FigLinestyle = 1;
            } else if (constructionObject.getColorType() == 1) {
                this.Stroke = 2;
                this.FigLinestyle = 0;
            } else {
                this.Stroke = 1;
                this.FigLinestyle = 0;
            }
        }
    }

    public void setFillColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setFillcolor(ZirkelFrame.TargetColor);
        } else if (constructionObject.getColorType() != 1) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setFillcolor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setFillcolor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            this.setColor(constructionObject);
            constructionObject.setColorType(n);
        } else {
            this.setColor(constructionObject);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.append("# drawRect");
        this.append("\n");
        this.append("2 2 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 5");
        this.append("\n");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * (d2 + d4) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * (d2 + d4) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * (d3 + d5) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * (d3 + d5) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append("\n");
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.append("# drawLine");
        this.append("\n");
        this.append("2 1 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * d4);
        this.append(" ");
        this.append((double)this.yfactor * d5);
        this.append("\n");
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        this.append("# drawThickLine");
        this.append("\n");
        this.append("2 1 ");
        this.append(0);
        this.append(" ");
        this.append(2);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * d4);
        this.append(" ");
        this.append((double)this.yfactor * d5);
        this.append("\n");
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.append("# drawLine ConstructionObject");
        this.append("\n");
        this.append("2 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 0 -1 0 0 2");
        this.append("\n");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * d4);
        this.append(" ");
        this.append((double)this.yfactor * d5);
        this.append("\n");
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.append("# drawArc");
        this.append("\n");
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        double d10 = d2 + d8;
        double d11 = d3 + d9;
        double d12 = d6 * Math.PI / 180.0;
        double d13 = d7 * Math.PI / 180.0;
        int n = (int)(d10 + d8 * Math.cos(d12));
        int n2 = (int)(d11 + d9 * Math.sin(d12));
        int n3 = (int)(d10 + d8 * Math.cos(d12 + d13 / 2.0));
        int n4 = (int)(d11 + d9 * Math.sin(d12 + d13 / 2.0));
        int n5 = (int)(d10 + d8 * Math.cos(d12 + d13));
        int n6 = (int)(d11 + d9 * Math.sin(d12 + d13));
        this.append("5 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 1 0 0 ");
        this.append((double)this.xfactor * d10);
        this.append(" ");
        this.append((double)this.yfactor * d11);
        this.append(" ");
        this.append(this.xfactor * n);
        this.append(" ");
        this.append(this.yfactor * n2);
        this.append(" ");
        this.append(this.xfactor * n3);
        this.append(" ");
        this.append(this.yfactor * n4);
        this.append(" ");
        this.append(this.xfactor * n5);
        this.append(" ");
        this.append(this.yfactor * n6);
        this.append("\n");
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        this.append("# drawArc ConstructionObject");
        this.append("\n");
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        double d10 = d2 + d8;
        double d11 = d3 + d9;
        double d12 = d6 * Math.PI / 180.0;
        double d13 = d7 * Math.PI / 180.0;
        int n = (int)(d10 + d8 * Math.cos(d12));
        int n2 = (int)(d11 - d9 * Math.sin(d12));
        int n3 = (int)(d10 + d8 * Math.cos(d12 + d13 / 2.0));
        int n4 = (int)(d11 - d9 * Math.sin(d12 + d13 / 2.0));
        int n5 = (int)(d10 + d8 * Math.cos(d12 + d13));
        int n6 = (int)(d11 - d9 * Math.sin(d12 + d13));
        this.append("5 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 0 1 0 0 ");
        this.append((double)this.xfactor * d10);
        this.append(" ");
        this.append((double)this.yfactor * d11);
        this.append(" ");
        this.append(this.xfactor * n);
        this.append(" ");
        this.append(this.yfactor * n2);
        this.append(" ");
        this.append(this.xfactor * n3);
        this.append(" ");
        this.append(this.yfactor * n4);
        this.append(" ");
        this.append(this.xfactor * n5);
        this.append(" ");
        this.append(this.yfactor * n6);
        this.append("\n");
    }

    public FontMetrics getFontMetrics() {
        return this.MFM;
    }

    public void drawString(String string, double d2, double d3) {
        this.append("#drawString");
        this.append("\n");
        this.append("4 0 ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 4 12 0.000 2 0 0 ");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * (d3 + 10.0));
        this.append(" ");
        this.append(string);
        this.append("\\001");
        this.append("\n");
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        double d6 = d4 / 2.0;
        double d7 = d5 / 2.0;
        double d8 = d2 + d6;
        double d9 = d3 + d7;
        this.append("#drawOval");
        this.append("\n");
        this.append("1 1 ");
        this.append(0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 1 0.000 ");
        this.append((int)((double)this.xfactor * d8));
        this.append(" ");
        this.append((int)((double)this.yfactor * d9));
        this.append(" ");
        this.append((int)((double)this.xfactor * d6));
        this.append(" ");
        this.append((int)((double)this.yfactor * d7));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        double d6 = d4 / 2.0;
        double d7 = d5 / 2.0;
        double d8 = d2 + d6;
        double d9 = d3 + d7;
        this.append("#drawOval ConstructionObject");
        this.append("\n");
        this.append("1 1 ");
        this.append(this.FigLinestyle);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        this.append(" 0 -1 0.000 1 0.000 ");
        this.append((int)((double)this.xfactor * d8));
        this.append(" ");
        this.append((int)((double)this.yfactor * d9));
        this.append(" ");
        this.append((int)((double)this.xfactor * d6));
        this.append(" ");
        this.append((int)((double)this.yfactor * d7));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        this.setFillColor(constructionObject);
        this.append("# fillRect");
        this.append("\n");
        this.append("2 2 ");
        this.append(bl ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (bl2) {
            this.append(" 0 20 0.000 0 0 -1 0 0 5");
        } else {
            this.append(" 0 30 0.000 0 0 -1 0 0 5");
        }
        this.append("\n");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * (d2 + d4) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append(" ");
        this.append((double)this.xfactor * (d2 + d4) - 1.0);
        this.append(" ");
        this.append((double)this.yfactor * (d3 + d5) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * (d3 + d5) - 1.0);
        this.append(" ");
        this.append((double)this.xfactor * d2);
        this.append(" ");
        this.append((double)this.yfactor * d3);
        this.append("\n");
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        this.setFillColor(constructionObject);
        this.append("#fillArc2");
        this.append("\n");
        double d8 = (d4 - 1.0) / 2.0;
        double d9 = (d5 - 1.0) / 2.0;
        double d10 = d2 + d8;
        double d11 = d3 + d9;
        double d12 = d6 * Math.PI / 180.0;
        double d13 = d7 * Math.PI / 180.0;
        int n = (int)(d10 + d8 * Math.cos(d12));
        int n2 = (int)(d11 - d9 * Math.sin(d12));
        int n3 = (int)(d10 + d8 * Math.cos(d12 + d13 / 2.0));
        int n4 = (int)(d11 - d9 * Math.sin(d12 + d13 / 2.0));
        int n5 = (int)(d10 + d8 * Math.cos(d12 + d13));
        int n6 = (int)(d11 - d9 * Math.sin(d12 + d13));
        this.append("5 2 ");
        this.append(bl ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (bl2) {
            this.append(" 0 20 0.000 0 1 0 0 ");
        } else {
            this.append(" 0 30 0.000 0 1 0 0 ");
        }
        this.append((double)this.xfactor * d10);
        this.append(" ");
        this.append((double)this.yfactor * d11);
        this.append(" ");
        this.append(this.xfactor * n);
        this.append(" ");
        this.append(this.yfactor * n2);
        this.append(" ");
        this.append(this.xfactor * n3);
        this.append(" ");
        this.append(this.yfactor * n4);
        this.append(" ");
        this.append(this.xfactor * n5);
        this.append(" ");
        this.append(this.yfactor * n6);
        this.append("\n");
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        this.setFillColor(constructionObject);
        this.append("#fillOval");
        this.append("\n");
        double d6 = (d4 - 1.0) / 2.0;
        double d7 = (d5 - 1.0) / 2.0;
        double d8 = d2 + d6;
        double d9 = d3 + d7;
        this.append("1 1 ");
        this.append(bl ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (bl2) {
            this.append(" 0 20 0.000 1 0.000 ");
        } else {
            this.append(" 0 30 0.000 1 0.000 ");
        }
        this.append((int)((double)this.xfactor * d8));
        this.append(" ");
        this.append((int)((double)this.yfactor * d9));
        this.append(" ");
        this.append((int)((double)this.xfactor * d6));
        this.append(" ");
        this.append((int)((double)this.yfactor * d7));
        this.append(" ");
        this.append("0 0 0 0");
        this.append("\n");
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        this.setFillColor(constructionObject);
        this.append("#fillPolygon");
        this.append("\n");
        this.append("2 1 ");
        this.append(bl ? this.FigLinestyle : 0);
        this.append(" ");
        this.append(this.Stroke);
        this.append(" ");
        this.append(this.FigColor);
        this.append(" ");
        this.append(this.FigFillcolor);
        this.append(" ");
        this.append(this.pushLayer());
        if (bl2) {
            this.append(" 0 20 0.000 0 0 -1 0 0 ");
        } else {
            this.append(" 0 30 0.000 0 0 -1 0 0 ");
        }
        this.append(n + 1);
        this.append("\n");
        for (int i = 0; i < n; ++i) {
            this.append((double)this.xfactor * dArray[i]);
            this.append(" ");
            this.append((double)this.yfactor * dArray2[i]);
            this.append(" ");
        }
        this.append((double)this.xfactor * dArray[0]);
        this.append(" ");
        this.append((double)this.yfactor * dArray2[0]);
        this.append(" ");
        this.append("\n");
    }

    public void setLayer(int n) {
        this.FigLayer = n;
    }

    void append(String string) {
        this.FigLastpart.append(string);
    }

    void append(int n) {
        this.FigLastpart.append("" + n);
    }

    void append(double d2) {
        this.FigLastpart.append("" + (int)d2);
    }

    public int pushLayer() {
        if (this.PushLayer) {
            --this.FigLayer;
        }
        return this.FigLayer;
    }

    public void pushLayer(boolean bl) {
        this.PushLayer = bl;
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
    }

    public void setFont(int n, boolean bl) {
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String string) {
        return this.getFontMetrics().stringWidth(string);
    }

    public int stringHeight(String string) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String string, double d2, double d3) {
        this.drawString(string, d2, d3 + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String string) {
        return this.getFontMetrics().getAscent();
    }
}

