/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.MepCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.quantum.QuantumCalculation;

public class MepCalculation
extends QuantumCalculation
implements MepCalculationInterface {
    public MepCalculation() {
        this.rangeBohr = 15.0f;
    }

    public void calculate(VolumeDataInterface volumeDataInterface, BitSet bitSet, Point3f[] point3fArray, float[] fArray) {
        this.voxelData = volumeDataInterface.getVoxelData();
        int[] nArray = volumeDataInterface.getVoxelCounts();
        this.initialize(nArray[0], nArray[1], nArray[2]);
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bitSet, point3fArray);
        this.processMep(fArray);
    }

    private void processMep(float[] fArray) {
        int n = this.qmAtoms.length;
        while (--n >= 0) {
            this.thisAtom = this.qmAtoms[n];
            if (this.thisAtom == null) continue;
            float f = fArray[n];
            this.thisAtom.setXYZ(true);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f2 = this.X2[n2];
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f3 = f2 + this.Y2[n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float f4 = f3 + this.Z2[n4];
                        float[] fArray2 = this.voxelData[n2][n3];
                        int n5 = n4;
                        fArray2[n5] = fArray2[n5] + (f4 == 0.0f ? f * Float.POSITIVE_INFINITY : f / (float)Math.sqrt(f4));
                    }
                }
            }
        }
    }
}

