/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.javia.arity.Compiler;
import org.javia.arity.Constant;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.Symbol;
import org.javia.arity.SyntaxException;
import org.javia.arity.VM;

public class Symbols {
    private static final Symbol[] builtin;
    private static Symbol shell;
    private static ThreadLocal compilers;
    private Hashtable symbols = new Hashtable();
    private Vector delta = null;
    private Stack frames = new Stack();
    private static final String[] defines;

    public Symbols() {
        int n;
        for (n = 0; n < builtin.length; ++n) {
            Symbol symbol = builtin[n];
            this.symbols.put(symbol, symbol);
        }
        try {
            for (n = 0; n < defines.length; ++n) {
                this.define(this.compile(defines[n]));
            }
        }
        catch (SyntaxException syntaxException) {
            throw new Error("" + syntaxException);
        }
    }

    public static boolean isDefinition(String string) {
        return string.indexOf(61) != -1;
    }

    public synchronized double eval(String string) throws SyntaxException {
        return Symbols.getCompiler().eval(this, string);
    }

    public synchronized FunctionAndName compile(String string) throws SyntaxException {
        return Symbols.getCompiler().compile(this, string);
    }

    public synchronized void define(String string, Function function) {
        if (function instanceof Constant) {
            this.addConstant(string, ((Constant)function).eval());
        } else {
            this.add(new Symbol(string, function));
        }
    }

    public synchronized void define(FunctionAndName functionAndName) {
        if (functionAndName.name != null) {
            this.define(functionAndName.name, functionAndName.function);
        }
    }

    public synchronized void addConstant(String string, double d) {
        this.add(new Symbol(string, d));
    }

    public synchronized void pushFrame() {
        this.frames.push(this.delta);
        this.delta = null;
    }

    public synchronized void popFrame() {
        if (this.delta != null) {
            for (int i = this.delta.size() - 1; i >= 0; --i) {
                Symbol symbol = (Symbol)this.delta.elementAt(i);
                if (symbol.isEmpty()) {
                    this.symbols.remove(symbol);
                    continue;
                }
                this.symbols.put(symbol, symbol);
            }
        }
        this.delta = (Vector)this.frames.pop();
    }

    private static Compiler getCompiler() {
        Compiler compiler = (Compiler)compilers.get();
        if (compiler == null) {
            compiler = new Compiler();
            compilers.set(compiler);
        }
        return compiler;
    }

    void addArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(new Symbol(stringArray[i], -3, (byte)(37 + i)));
        }
    }

    void add(Symbol symbol) {
        Symbol symbol2 = this.symbols.put(symbol, symbol);
        if (this.delta == null) {
            this.delta = new Vector();
        }
        this.delta.addElement(symbol2 != null ? symbol2 : Symbol.newEmpty(symbol));
    }

    synchronized Symbol lookup(String string, int n) {
        return (Symbol)this.symbols.get(shell.setKey(string, n));
    }

    static {
        int n;
        shell = new Symbol(null, 0.0);
        compilers = new ThreadLocal();
        Vector<Symbol> vector = new Vector<Symbol>();
        for (byte by = 0; by < 42; by = (byte)((byte)(by + 1))) {
            byte by2 = VM.builtinArity[by];
            if (by2 < 0) continue;
            vector.addElement(new Symbol(VM.opcodeName[by], by2, by));
        }
        String[] stringArray = new String[]{"x", "y", "z"};
        for (n = 0; n < stringArray.length; n = (int)((byte)(n + 1))) {
            vector.addElement(new Symbol(stringArray[n], -3, (byte)(37 + n)));
        }
        vector.addElement(new Symbol("pi", Math.PI));
        vector.addElement(new Symbol("\u03c0", Math.PI));
        vector.addElement(new Symbol("e", Math.E));
        vector.addElement(new Symbol("Inf", Double.POSITIVE_INFINITY));
        vector.addElement(new Symbol("Infinity", Double.POSITIVE_INFINITY));
        vector.addElement(new Symbol("NaN", Double.NaN));
        n = vector.size();
        builtin = new Symbol[n];
        vector.copyInto(builtin);
        defines = new String[]{"ln(x)    = log(x)", "log2(x)  = log(x) * 1.4426950408889634074", "log10(x) = log(x) * 0.43429448190325182765", "lg(x)    = log10(x)", "lb(x)    = log2(x)", "log(x, base) = log(x) / log(base)"};
    }
}

