/* back.c */

/*
Copyright (c) 1999 Alban Hertroys
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/extensions/shape.h>
#include <time.h>

#include <dockapp.h>
#include "config.h"
#include "geometry.h"

#define ATTRIBUTE_CLOSENESS 40000
#define DESCRIPTION "\nA utility to show today's date.\n"
#define VERSION "WMDate 0.7"

char *displayName = "";
int  testDate = 1;
int  weekday, day, month;
Bool doTest = False;
Bool drawn  = False;
Bool shaped = False;

GC gc;



static DAProgramOption options[] = {
   {"-d", "--display", "display to use.", DOString, False, {&displayName}},
   {"-s", "--not-shaped", "no shaped window.", DONone, False, {NULL}},
   {"-t", "--test", "run in test mode.", DONone, False, {NULL}},
};

/* Local functions */
void drawBack (Pixmap back, Pixmap disp);
void drawDate (Pixmap back, Pixmap disp);
void calcDate ();
Pixmap loadTilePixmap(char *path);

static void
buttonPressCallback (int button, int state, int x, int y)
{
   if (button == 1){
	  testDate++;
	  if (testDate > 31)
		 testDate = 1;
	  
	  drawn = False;
   }
}


/*************************************************************************/

int
main (int argc, char *argv[])
{
   DACallbacks callbacks = {NULL,buttonPressCallback,NULL,NULL,NULL,NULL,NULL};
   Pixmap back, mask;	/* Source pixmap to copy stuff from */
   Pixmap disp;			/* Pixmap that is actually displayed */
   unsigned long fore_pix, back_pix;
   int old_day;
   unsigned int w=183, h=84;

   DAParseArguments(argc, argv, options, 4, DESCRIPTION, VERSION);
   shaped = !options[1].used;
   doTest = options[2].used;
 
   if (!doTest)
	  callbacks.buttonPress = NULL;
   
   DAInitialize(displayName, "WMDate", 64, 64, argc, argv);
   
   gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

   DAMakePixmapFromData (back_xpm, &back, &mask, &w, &h);
   disp = DAMakePixmap();
 
   fore_pix = DAGetColor ("black");
   back_pix = DAGetColor ("white");

   if (shaped)
	  DASetShape(mask);
   
   calcDate ();
   drawDate (back, disp);
   
   DASetPixmap(disp);
   drawn = True;
   
   old_day = day;

   DASetCallbacks(&callbacks);
   DAShow();

/*
 * ---------------------------------------
 *|    M A I N   L O O P - Starts here    |
 * ---------------------------------------------------------------------------
 */

   while (1) {
	  XEvent event;
	  
	  calcDate ();
	  if (! ((day == old_day) && drawn) )
	  {
		 drawDate (back, disp);
#ifndef XSERVER_BUG
		 DASetPixmap(disp);		
/* XXX	 	Doesn't update with shaped windows on some
 * 			XServers, XCopyArea does...
 * 			This is an XServer  bug !!!
 *
 * Alternative:
 *		 XCopyArea(DADisplay, disp, DAWindow, gc, 0, 0, 64, 64, 0, 0);
 *
 * Side effects: 
 *		 unknown
 */
#else
		 XCopyArea(DADisplay, disp, DAWindow, gc, 0, 0, 64, 64, 0, 0);
#endif
		 

		 if (drawn)
			old_day = day;
		 drawn = True;
	  }

	  while (XPending (DADisplay))
	  {
		 XNextEvent (DADisplay, &event);
		 DAProcessEvent(&event);
	  }

	  if (doTest)
#ifdef SYSV
		 poll((struct poll*) 0, (size_t) 0, 25);
#else
		 usleep(25000);
#endif
	  else
		 sleep(1);
   }

   return 0;
}
        
		 
void
drawBack (Pixmap back, Pixmap disp)
{
   if (shaped)
	  XCopyArea(DADisplay, back, disp, gc, TXOFFS, TYOFFS, 
			TWIDTH, THEIGHT, TLEFT, TTOP);
   else
	  XCopyArea(DADisplay, back, disp, gc, TILELEFT, TILETOP, 
			TILEWIDTH, TILEHEIGHT, 0, 0);
}


void
drawDate (Pixmap back, Pixmap disp)
{
  int day10, day1;
  int offset10, offset1;
  int dummy;
  int width, width10, width1;

  if (!doTest)
     dummy = day;
  else
     dummy = testDate;

  day10 = dummy / 10;
  day1  = dummy % 10;

  width10 = D_WID;
  width1  = D_WID;  

  if (day10 == 0) width10 = 0;
  if (day10 == 1) width10 = D_ONE;
  if (day1 == 1)  width1  = D_ONE;
  width = (width1 + width10) / 2;
  offset10 = 32 - width;
  offset1  = offset10 + width10;

  /* Clear the area */
  drawBack(back, disp);

  /* Write day of week */
  XCopyArea (DADisplay, back, disp, gc, 
		TW_LFT, W_HEI * weekday, 
		W_WID, W_HEI, 
		PW_LFT, PW_TOP);

  /* Write day of month */
  if ((day > 9) || (testDate > 9))
  {
    XCopyArea (DADisplay, back, disp, gc, 
		  D_WID * day10 + (D_WID - width10), 
		  TD_TOP, 
          width10, D_HEI, 
          offset10, PD_TOP);
    XCopyArea (DADisplay, back, disp, gc, 
		  D_WID * day1 + (D_WID - width1), 
		  TD_TOP, 
          width1, D_HEI, 
          offset1, PD_TOP);
  }
  else
    XCopyArea (DADisplay, back, disp, gc, 
		  D_WID *day1 + (D_WID - width1), 
		  TD_TOP, 
	      width1, D_HEI, 32-width, PD_TOP);

  /* Write month */
  XCopyArea (DADisplay, back, disp, gc, 
		TM_LFT, M_HEI*month, M_WID, M_HEI, 
		PM_LFT, PM_TOP);
}


void
calcDate ()
{
  static struct tm *clk;
  time_t  actualtime;

  actualtime = time(0);
  clk = localtime (&actualtime);

  weekday = clk->tm_wday;
  day     = clk->tm_mday;
  month   = clk->tm_mon;
}

