
// Floor, Camera, etc.



// Default values, if not provided:
#ifndef (cameraUp)
  #declare cameraUp = 6.0;
#end
#ifndef (cameraRight)
  #declare cameraRight = 4.0;
#end
#ifndef (floorColor)
  #declare floorColor = color rgb <0.3,0.3,0.3>;
#end



// draw floor
plane {
  y, 0
  pigment {floorColor}
  finish {ambient 0.0 diffuse 1.0}
}

// background (sky) color
background {color SkyBlue}


// light source
light_source {
  <-100,500,-250>
  color rgb <1.2,1.2,1.2>
}

// camera
#declare Entf = 500.0;
camera
{
  orthographic
  location  <0, 0, -Entf>
  direction z
  up        cameraUp*y
  right     cameraRight*x
  rotate x*48.60
}
