#include "udposix.h"
#include <stdio.h>
#include "xgks.h"


    static void
box(id,xp,yp)
    int		id;
    double	xp, yp;
{
    char	c[80];
    float	size	= 20.0;
    Gpoint	pt[4];
    Gpoint	position;
    Gsegattr	segattr;

    if (gcreateseg(id) != 0)
	(void) fputs("Couldn't create segment\n", stderr);

    pt[0].x	= xp;
    pt[1].x	= xp + size;
    pt[2].x	= xp + size;
    pt[3].x	= xp;

    pt[0].y	= yp;
    pt[1].y	= yp;
    pt[2].y	= yp + size;
    pt[3].y	= yp + size;

    if (gfillarea(4, pt) != 0)
	(void) fputs("Couldn't fill area\n", stderr);

    position.x	= xp + size/2.;
    position.y	= yp + size/2.;
    (void) sprintf(c, "%d", id);

    if (gtext(&position, c) != 0)
	(void) fputs("Couldn't write box-text\n", stderr);

    if (gcloseseg() != 0)
	(void) fputs("Couldn't close segment\n", stderr);

    segattr.seg = id;
    if (ginqsegattr(&segattr) != 0)
	(void) fputs("Couldn't inquire about segment attributes\n", stderr);

    segattr.vis = GVISIBLE;
    segattr.det = GDETECTABLE;
    if (gsetsegattr(id, &segattr) != 0)
	(void) fputs("Couldn't set segment attributes\n", stderr);
}


main()
{
    int		ws_id	= 0;
    Glimit	window;
    Gcobundl	rep;
    Gpoint	position;
    Gtxalign	txalign;
    Gpick	response;
    Glong	memory	= 0;
    Gflinter	FillStyle	= GSOLID;
    Gimode	PickMode	= GREQUEST;

    if (gopengks(stderr, memory) != 0) {
	(void)fputs("Couldn't open GKS\n", stderr);
	return 1;
    }
    if (gopenws(ws_id, (char*)NULL, (char*)NULL) != 0) {
	(void)fputs("Couldn't open workstation\n", stderr);
	return 2;
    }
    if (gactivatews(ws_id) != 0) {
	(void)fputs("Couldn't activate workstation\n", stderr);
	return 3;
    }

    window.xmin = 0.0;
    window.xmax = 100.0;
    window.ymin = 0.0;
    window.ymax = 100.0;
    (void) gsetwindow(1, &window);

    (void) gsetclip(GNOCLIP);
    (void) gselntran(1);

    rep.red	= 1.0;
    rep.green	= 0.0;
    rep.blue	= 0.0;
    if (gsetcolourrep(ws_id, 3, &rep) != 0)
	(void) fputs("Couldn't set colour representation\n", stderr);
    rep.red	= 0.0;
    rep.green	= 1.0;
    rep.blue	= 1.0;
    if (gsetcolourrep(ws_id, 4, &rep) != 0)
	(void) fputs("Couldn't set colour representation\n", stderr);

    if (gsetfillcolorind(3) != 0)
	(void) fputs("Couldn't set fill-colour index\n", stderr);
    if (gsettextcolorind(4) != 0)
	(void) fputs("Couldn't set text-colour index\n", stderr);
    if (gsetfillintstyle(FillStyle) != 0)
	(void) fputs("Couldn't set fill-style\n", stderr);
    if (gsetcharheight(5.0) != 0)
	(void) fputs("Couldn't set character height\n", stderr);

    position.x = 10.0;
    position.y = 10.0;
    if (gtext(&position, "Pick box 1 to Quit") != 0)
	(void) fputs("Couldn't write quit instructions\n", stderr);

    if (gsetcharheight(10.0) != 0)
	(void) fputs("Couldn't set character height\n", stderr);

    txalign.hor = GTH_CENTRE;
    txalign.ver = GTV_HALF;
    if (gsettextalign(&txalign) != 0)
	(void) fputs("Couldn't set text alignment\n", stderr);

    box(1,10.0,40.0);
    box(2,40.0,40.0);
    box(3,70.0,40.0);

    if (gsetpickmode(ws_id, 1, PickMode, GECHO) != 0)
	(void) fputs("Couldn't set pick mode\n", stderr);
    do {
	if (greqpick(ws_id, 1, &response) != 0) {
	    (void) fputs("Couldn't pick\n", stderr);
	    return 4;
	}
	(void) fprintf(stderr, "Pick status, seg, pickid = %d %d %d\n",
		       (int) response.status,
		       (int) response.seg,
		       (int) response.pickid);
    } while (response.seg != 1);

    if (gdeactivatews(ws_id) != 0) {
	(void) fputs("Couldn't deactivate workstation\n", stderr);
	return 5;
    }
    if (gclosews(ws_id) != 0) {
	(void) fputs("Couldn't close workstation\n", stderr);
	return 6;
    }
    if (gclosegks() != 0) {
	(void) fputs("Couldn't close GKS\n", stderr);
	return 7;
    }

    return 0;
}
