/*
 * $Id: output.c,v 1.1 2000/08/07 22:23:57 emmerson Exp $
 */

/*LINTLIBRARY*/

#include "gks.h"
#include "xgks.h"

#undef	MIN
#define	MIN(a,b)	((a) < (b) ? (a) : (b))
#undef	MAX
#define	MAX(a,b)	((a) > (b) ? (a) : (b))

extern int	gks_errno;


    void
gpolyline_iso(
    const Gpoint_list   *point_list   /* list of points   */)
{
    gks_errno	= gpolyline(point_list->num_points, point_list->points);
}


    void
gpolymarker_iso(
    const Gpoint_list   *point_list   /* list of points   */)
{
    gks_errno	= gpolymarker(point_list->num_points, point_list->points);
}


#if 0		/* Function already in '88 API */
    void
gtext(
    const Gpoint   *text_pos,     /* text position      */
    const char     *char_string   /* character string   */)
{
}
#endif


    void
gfill_area(
    const Gpoint_list   *point_list   /* list of points   */)
{
    gks_errno	= gfillarea(point_list->num_points, point_list->points);
}


    void
gfill_area_set(
    const Gpoint_list_list   *point_list_list   /* list of point lists   */)
{
    int			n		= point_list_list->num_point_lists;
    const Gpoint_list   *point_list	= point_list_list->point_lists;

    while (n-- > 0) {
	gfill_area(point_list);
	if (gks_errno != GE_NO_ERR)
	    return;
    }
}


    void
gcell_array(
    const Grect      *rect,        /* cell rectangle   */
    const Gpat_rep   *colr_array   /* colour array     */)
{
    xgks_Grect	corners;
    Gipoint	size;

    corners.ll.x	= MIN(rect->p.x, rect->q.x);
    corners.ll.y	= MIN(rect->p.y, rect->q.y);
    corners.ur.x	= MAX(rect->p.x, rect->q.x);
    corners.ur.y	= MAX(rect->p.y, rect->q.y);

    size.x	= colr_array->dims.size_x;
    size.y	= colr_array->dims.size_y;

    gks_errno	= gcellarray(&corners, &size, size.x, colr_array->colr_array);
}


    void
ggdp(
    const Gpoint_list   *point_list,   /* list of points    */
    Gint                gdp_id,        /* gdp identifier    */
    const Ggdp_data     *gdp_data      /* gdp data record   */)
{
    gks_errno	= g_gdp(point_list->num_points, point_list->points, 
		        gdp_id, (Ggdprec*)gdp_data);
}
