/* xkeycaps, Copyright (c) 1998 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of the Sun-Swiss type 5 keyboard.
 * By Peter Kaiser, June 1998
 *
 */

static const struct key_strings sun5swde_caps [] = {

  /* Row 0 */

  {"Hilfe", 0},
  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"Druck", "S-Abf", 0},
  {"Rollen", "DownArrow", 0},
  {"Pause", "Untbr", 0},
  {"Degauss", "D\344mpfen", 0},
  {"Kontr -", "Laut -", 0},
  {"Kontr +", "Laut +", 0},
  {"Power", 0},

  /* Row 1 */

  {"Stop", 0},
  {"Wieder-", "holen", 0},
  {"\260", "\247", 0},
  {"+", "1", "|"},
  {"\"", "2", "@"},
  {"*", "3", "#"},
  {"\347", "4", "^"},
  {"%", "5", "~"},
  {"&", "6", 0},
  {"/", "7", 0},
  {"(", "8", 0},
  {")", "9", 0},
  {"=", "0", "`"},
  {"?", "'", "(')"},
  {"(`)", "(^)", "(~)"},

  {"LeftArrow", "Back Space", 0},
  {"Einfg", 0},
  {"Pos 1", 0},
  {"Bild", "UpArrow", 0},
  {"Num", "DownArrow", 0},
  {"/", 0},
  {"*", 0},
  {"-", 0},

  /* Row 2 */

  {"Eigen-", "schafter", 0},
  {"Zur\374ck-", "nahmen", 0},
  {"Tab", "RightArrow", "leftArrow"},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Z", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"\350", "\374", "["},
  {"(Uml)", "!", "]"},

  {"Return", 0},
  {"Entf", 0},
  {"Ende", 0},
  {"Bild", "DownArrow", 0},
  {"7", "Pos 1", 0},
  {"8", "UpArrow", 0},
  {"9", "Bild", "UpArrow"},
  {"+", 0},

  /* Row 3 */
  {"Vorder-", "grund", "0"},
  {"Kopie-", "ren", 0},
  {"Caps Lock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {"\351", "\365", 0},
  {"\340", "\344", "{"},
  {"\243", "$", "}"},

  {"4", "LeftArrow", 0},
  {"5", 0},
  {"6", "RightArrow", 0},

  /* Row 4 */

  {"\325ffnen", 0},
  {"Ein-", "setzen", 0},
  {"UpArrow", "Shift", 0},
  {"<", ">", "\\"},
  {"Y", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {";", ",", 0},
  {":", ".", 0},
  {"_", "-", 0},
  {"UpArrow", "Shift", 0},
  {"UpArrow", 0},
  {"1", "Ende", 0},
  {"2", "DownArrow", 0},
  {"3", "Bild", "DownArrow"},
  {"Enter", 0},

  /* Row 5 */

  {"Suchen", 0},
  {"Aus-", "schneiden", 0},
  {"Control", 0},
  {"Alt", 0},
  {"<>", 0},
  {" ", 0},
  {"<>", 0},
  {"Com-", "pose", 0},
  {"Alt", "Graph", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", "Enifg", 0},
  {".", "Entf", 0}
};
