/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-menu.h,v 1.5 2000/01/02 02:05:23 rich Exp $
 */

#ifndef __xracer_menu_h__
#define __xracer_menu_h__

/* A menu is a very specialized type of mode. */
struct xrMenu
{
  const char *name;

  const char *title;		/* The title which is displayed at the top. */
  const char *footer;		/* Anything you want printed at the bottom. */

  /* The list of menu items. */
  int nr_items;
  const char **items;

  /* The list of actions performed when a menu item is picked. */
  void (**actions) (void);

  /* Functions called on entering and leaving the menu mode. */
  void (*start_menu) (const void *args);
  void (*end_menu) (void);

  /* General callback functions. */
  void (*display_background) (void);
};

extern void xrMenuInit (void);
extern void xrEnterMenu (const struct xrMenu *menu, const void *args);

/* Global mode structures defined. */
extern struct xrMenu xrStartMenu;
extern struct xrMenu xrQuitMenu;
extern struct xrMenu xrConfigurationMenu;

#endif /* __xracer_menu_h__ */
