package ONVIF::Analytics::Types::IPv6NetworkInterfaceSetConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Enabled_of :ATTR(:get<Enabled>);
my %AcceptRouterAdvert_of :ATTR(:get<AcceptRouterAdvert>);
my %Manual_of :ATTR(:get<Manual>);
my %DHCP_of :ATTR(:get<DHCP>);

__PACKAGE__->_factory(
    [ qw(        Enabled
        AcceptRouterAdvert
        Manual
        DHCP

    ) ],
    {
        'Enabled' => \%Enabled_of,
        'AcceptRouterAdvert' => \%AcceptRouterAdvert_of,
        'Manual' => \%Manual_of,
        'DHCP' => \%DHCP_of,
    },
    {
        'Enabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'AcceptRouterAdvert' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Manual' => 'ONVIF::Analytics::Types::PrefixedIPv6Address',
        'DHCP' => 'ONVIF::Analytics::Types::IPv6DHCPConfiguration',
    },
    {

        'Enabled' => 'Enabled',
        'AcceptRouterAdvert' => 'AcceptRouterAdvert',
        'Manual' => 'Manual',
        'DHCP' => 'DHCP',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::IPv6NetworkInterfaceSetConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
IPv6NetworkInterfaceSetConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Enabled


=item * AcceptRouterAdvert


=item * Manual


=item * DHCP




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::IPv6NetworkInterfaceSetConfiguration
   Enabled =>  $some_value, # boolean
   AcceptRouterAdvert =>  $some_value, # boolean
   Manual =>  { # ONVIF::Analytics::Types::PrefixedIPv6Address
     Address => $some_value, # IPv6Address
     PrefixLength =>  $some_value, # int
   },
   DHCP => $some_value, # IPv6DHCPConfiguration
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

