package ONVIF::PTZ::Types::CertificateWithPrivateKey;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %CertificateID_of :ATTR(:get<CertificateID>);
my %Certificate_of :ATTR(:get<Certificate>);
my %PrivateKey_of :ATTR(:get<PrivateKey>);

__PACKAGE__->_factory(
    [ qw(        CertificateID
        Certificate
        PrivateKey

    ) ],
    {
        'CertificateID' => \%CertificateID_of,
        'Certificate' => \%Certificate_of,
        'PrivateKey' => \%PrivateKey_of,
    },
    {
        'CertificateID' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'Certificate' => 'ONVIF::PTZ::Types::BinaryData',
        'PrivateKey' => 'ONVIF::PTZ::Types::BinaryData',
    },
    {

        'CertificateID' => 'CertificateID',
        'Certificate' => 'Certificate',
        'PrivateKey' => 'PrivateKey',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::CertificateWithPrivateKey

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CertificateWithPrivateKey from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CertificateID


=item * Certificate


=item * PrivateKey




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::CertificateWithPrivateKey
   CertificateID =>  $some_value, # token
   Certificate =>  { # ONVIF::PTZ::Types::BinaryData
     Data =>  $some_value, # base64Binary
   },
   PrivateKey =>  { # ONVIF::PTZ::Types::BinaryData
     Data =>  $some_value, # base64Binary
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

