package ONVIF::PTZ::Types::RelayOutput;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::PTZ::Types::DeviceEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Properties_of :ATTR(:get<Properties>);

__PACKAGE__->_factory(
    [ qw(        Properties

    ) ],
    {
        'Properties' => \%Properties_of,
    },
    {
        'Properties' => 'ONVIF::PTZ::Types::RelayOutputSettings',
    },
    {

        'Properties' => 'Properties',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::RelayOutput

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RelayOutput from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Properties




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::RelayOutput
   Properties =>  { # ONVIF::PTZ::Types::RelayOutputSettings
     Mode => $some_value, # RelayMode
     DelayTime =>  $some_value, # duration
     IdleState => $some_value, # RelayIdleState
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

