/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.hierarchy.ComponentHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FinderDelegate {
    FinderDelegate() {
    }

    @RunsInEDT
    Collection<Component> find(ComponentHierarchy h, ComponentMatcher m) {
        LinkedHashSet<Component> found = new LinkedHashSet<Component>();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, component, found);
        }
        return found;
    }

    @RunsInEDT
    private void find(ComponentHierarchy h, ComponentMatcher m, Component root, Set<Component> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, c, found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(root);
        }
    }

    @RunsInEDT
    private static Collection<Component> childrenOfComponent(final Component c, final ComponentHierarchy h) {
        return GuiActionRunner.execute(new GuiQuery<Collection<Component>>(){

            @Override
            protected Collection<Component> executeInEDT() {
                return h.childrenOf(c);
            }
        });
    }

    @RunsInEDT
    private static boolean isMatching(final Component c, final ComponentMatcher m) {
        return GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
    }

    @RunsInEDT
    <T extends Component> Collection<T> find(ComponentHierarchy h, GenericTypeMatcher<T> m) {
        LinkedHashSet found = new LinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, component, found);
        }
        return found;
    }

    @RunsInEDT
    private static Collection<? extends Component> rootsOf(final ComponentHierarchy h) {
        return GuiActionRunner.execute(new GuiQuery<Collection<? extends Component>>(){

            @Override
            protected Collection<? extends Component> executeInEDT() {
                return h.roots();
            }
        });
    }

    @RunsInEDT
    private <T extends Component> void find(ComponentHierarchy h, GenericTypeMatcher<T> m, Component root, Set<T> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, c, found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(m.supportedType().cast(root));
        }
    }

    @RunsInEDT
    private static <T extends Component> boolean isMatching(final Component c, final GenericTypeMatcher<T> m) {
        return GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
    }
}

