/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.Actions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.JComponentToolTipQuery;
import org.fest.swing.driver.KeyStrokes;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class JComponentDriver
extends ContainerDriver {
    private static final String TOOL_TIP_TEXT_PROPERTY = "toolTipText";

    public JComponentDriver(Robot robot) {
        super(robot);
    }

    @RunsInCurrentThread
    protected final void scrollToVisible(JComponent c, Rectangle r) {
        c.scrollRectToVisible(r);
    }

    @RunsInCurrentThread
    protected static boolean isVisible(JComponent c, Rectangle r) {
        return c.getVisibleRect().contains(r);
    }

    @RunsInCurrentThread
    protected final boolean isVisible(JComponent c, Point p) {
        return c.getVisibleRect().contains(p);
    }

    @RunsInEDT
    protected final void invokeAction(JComponent c, String name) {
        this.robot.focusAndWaitForFocusGain(c);
        for (KeyStroke keyStroke : JComponentDriver.keyStrokesForAction(c, name)) {
            try {
                this.type(keyStroke);
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to type any key for the action with key ", Strings.quote((String)name)}));
    }

    @RunsInCurrentThread
    private static KeyStroke[] keyStrokesForAction(JComponent component, String actionName) {
        Object key = Actions.findActionKey(actionName, component.getActionMap());
        return KeyStrokes.findKeyStrokesForAction(actionName, key, component.getInputMap());
    }

    private void type(KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    @RunsInEDT
    public void requireToolTip(JComponent c, String expected) {
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireToolTip(JComponent c, Pattern pattern) {
        TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)).matches(pattern);
    }

    @RunsInEDT
    public Object clientProperty(JComponent c, Object key) {
        if (key == null) {
            throw new NullPointerException("The key of the client property to return should not be null");
        }
        return JComponentDriver.clientPropertyIn(c, key);
    }

    private static Object clientPropertyIn(final JComponent c, final Object key) {
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            protected Object executeInEDT() {
                return c.getClientProperty(key);
            }
        });
    }
}

