/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PointAndParentForScrollingJTextFieldQuery {
    @RunsInCurrentThread
    static Pair<Point, Container> pointAndParentForScrolling(JTextField textField) {
        Container parent;
        Point origin = new Point(textField.getX(), textField.getY());
        for (parent = textField.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            origin = PointAndParentForScrollingJTextFieldQuery.addRectangleToPoint(parent.getBounds(), origin);
        }
        return new Pair<Point, Container>(origin, parent);
    }

    private static Point addRectangleToPoint(Rectangle r, Point p) {
        Point newPoint = new Point(p);
        newPoint.x += r.x;
        newPoint.y += r.y;
        return newPoint;
    }

    private PointAndParentForScrollingJTextFieldQuery() {
    }
}

