/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JScrollBarDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScrollBarFixture
extends ComponentFixture<JScrollBar>
implements CommonComponentFixture,
JComponentFixture,
JPopupMenuInvokerFixture {
    private JScrollBarDriver driver;

    public JScrollBarFixture(Robot robot, JScrollBar target) {
        super(robot, target);
        this.createDriver();
    }

    public JScrollBarFixture(Robot robot, String scrollBarName) {
        super(robot, scrollBarName, JScrollBar.class);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new JScrollBarDriver(this.robot));
    }

    protected final void driver(JScrollBarDriver newDriver) {
        JScrollBarFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    @Override
    public JScrollBarFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JScrollBarFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JScrollBarFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JScrollBarFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JScrollBarFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JScrollBarFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    public JScrollBarFixture scrollBlockDown() {
        this.driver.scrollBlockDown((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollBlockDown(int times) {
        this.driver.scrollBlockDown((JScrollBar)this.target, times);
        return this;
    }

    public JScrollBarFixture scrollBlockUp() {
        this.driver.scrollBlockUp((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollBlockUp(int times) {
        this.driver.scrollBlockUp((JScrollBar)this.target, times);
        return this;
    }

    public JScrollBarFixture scrollTo(int position) {
        this.driver.scrollTo((JScrollBar)this.target, position);
        return this;
    }

    public JScrollBarFixture scrollToMaximum() {
        this.driver.scrollToMaximum((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollToMinimum() {
        this.driver.scrollToMinimum((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollUnitDown() {
        this.driver.scrollUnitDown((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollUnitDown(int times) {
        this.driver.scrollUnitDown((JScrollBar)this.target, times);
        return this;
    }

    public JScrollBarFixture scrollUnitUp() {
        this.driver.scrollUnitUp((JScrollBar)this.target);
        return this;
    }

    public JScrollBarFixture scrollUnitUp(int times) {
        this.driver.scrollUnitUp((JScrollBar)this.target, times);
        return this;
    }

    public JScrollBarFixture requireValue(int value) {
        this.driver.requireValue((JScrollBar)this.target, value);
        return this;
    }

    @Override
    public JScrollBarFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JScrollBarFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JScrollBarFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JScrollBarFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JScrollBarFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }
}

