/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JDesktopPaneChildrenFinder
implements ChildrenFinderStrategy {
    JDesktopPaneChildrenFinder() {
    }

    @Override
    @RunsInCurrentThread
    public Collection<Component> nonExplicitChildrenOf(Container c) {
        if (!(c instanceof JDesktopPane)) {
            return Collections.emptyList();
        }
        return this.internalFramesFromIcons(c);
    }

    @RunsInCurrentThread
    private Collection<Component> internalFramesFromIcons(Container c) {
        ArrayList<Component> frames = new ArrayList<Component>();
        for (Component child : c.getComponents()) {
            if (child instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame frame = ((JInternalFrame.JDesktopIcon)child).getInternalFrame();
                if (frame == null) continue;
                frames.add(frame);
                continue;
            }
            if (!(child instanceof Container)) continue;
            frames.addAll(this.internalFramesFromIcons((Container)child));
        }
        return frames;
    }
}

