/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.EmptyStackException;
import javax.swing.SwingUtilities;
import org.fest.swing.input.NativeDnDIdentifier;

class DragAwareEventQueue
extends EventQueue {
    private final Toolkit toolkit;
    private final long mask;
    private final AWTEventListener eventListener;
    private final NativeDnDIdentifier nativeDnd;

    DragAwareEventQueue(Toolkit toolkit, long mask, AWTEventListener eventListener) {
        this(toolkit, mask, eventListener, new NativeDnDIdentifier());
    }

    DragAwareEventQueue(Toolkit toolkit, long mask, AWTEventListener eventListener, NativeDnDIdentifier nativeDnd) {
        this.toolkit = toolkit;
        this.mask = mask;
        this.eventListener = eventListener;
        this.nativeDnd = nativeDnd;
    }

    public void pop() throws EmptyStackException {
        EventQueue systemEventQueue = this.toolkit.getSystemEventQueue();
        if (systemEventQueue == this) {
            super.pop();
        }
    }

    protected void dispatchEvent(AWTEvent e) {
        if (this.nativeDnd.isNativeDragAndDrop(e)) {
            MouseEvent mouseEvent = (MouseEvent)e;
            Component target = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            if (target != mouseEvent.getSource()) {
                mouseEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, target);
            }
            this.relayDnDEvent(mouseEvent);
        }
        super.dispatchEvent(e);
    }

    private void relayDnDEvent(MouseEvent event) {
        int eventId = event.getID();
        if (eventId == 503 || eventId == 506) {
            if ((this.mask & 0x20L) != 0L) {
                this.eventListener.eventDispatched(event);
            }
            return;
        }
        if (eventId >= 500 && eventId <= 507 && (this.mask & 0x10L) != 0L) {
            this.eventListener.eventDispatched(event);
        }
    }
}

