/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.annotation.RunsInCurrentThread;

final class WindowMetrics {
    private final Window window;
    final Insets insets;

    @RunsInCurrentThread
    WindowMetrics(Window w) {
        this.window = w;
        this.insets = w.getInsets();
    }

    @RunsInCurrentThread
    Point center() {
        int x = this.window.getX() + this.insets.left + this.horizontalCenter();
        int y = this.window.getY() + this.insets.top + this.verticalCenter();
        return new Point(x, y);
    }

    @RunsInCurrentThread
    private int horizontalCenter() {
        return (this.window.getWidth() - this.leftAndRightInsets()) / 2;
    }

    @RunsInCurrentThread
    int leftAndRightInsets() {
        return this.insets.left + this.insets.right;
    }

    @RunsInCurrentThread
    private int verticalCenter() {
        return (this.window.getHeight() - this.topAndBottomInsets()) / 2;
    }

    @RunsInCurrentThread
    int topAndBottomInsets() {
        return this.insets.top + this.insets.bottom;
    }
}

